;  Copyright (C) 2020 Gabriel Ash

; This program and the accompanying materials are made available under
; the terms of the Eclipse Public License 2.0 which is available at
; http://www.eclipse.org/legal/epl-2.0 .

; This code is provided as is, without any guarantee whatsoever.

(ns gabrielash.libmisc.core
  
  )



(defn get-some
  [pred coll] 
  (some #(and (pred %) %) coll))

(defn atom?
  [ a ] 
  (instance? clojure.lang.Atom a))

(def != #'not=)

(def ! #'not)

(defmacro !! [f & args] 
  `(apply (complement ~f) [~@args]))


(defn assoc-if
  "assoc conditional on first argument, 
   or assoc a non nill value"
  ([col k v]
   (if-not (nil? v) (assoc col k v) col))
  
  ([col test k v]
   (if test (assoc col k v) col)))
 
(defn is=? [v] #(= v %))

(defn no-nil? 
  "collection includes no nil values"
  [col]
  (cond (map? col)    (!! seq  (for [[k v] col :when (nil? v)] k))
        ((some-fn seq? vector?)
           col)       (every? #(!! nil? %) col)
        :else         (throw (ex-info 
                                (str "no-nil? works on maps or seqs only. " col " is neither") {}))))






