;  Copyright (C) 2020 Gabriel Ash

; This program and the accompanying materials are made available under
; the terms of the Eclipse Public License 2.0 which is available at
; http://www.eclipse.org/legal/epl-2.0 .

; This code is provided as is, without any guarantee whatsoever.

(ns gabrielash.libmisc.args )


(defmacro <* 
  " macro <* pulls last argument to first position"
  ([f] `(~f))
  ([f a] `(~f ~a))
  ([f a b] `(~f ~b ~a))
  ([f a b c] `(~f ~c ~a ~b))
  ([f a b c d] `(~f ~d ~a ~b ~c))
  ([f a b c d & more] 
   (let [lst# (last more)
         more (butlast more)]
     `(apply ~f [ ~lst# ~a ~b ~c ~d ~@more]))))



(defmacro >*
  " macro >* pushes first argument to last position"
  ([f] `(~f))
  ([f a] `(~f ~a))
  ([f a b] `(~f ~b ~a))
  ([f a b c] `(~f ~b ~c ~a))
  ([f a b c d] `(~f ~b ~c ~d ~a))
  ([f a b c d & more] `(apply ~f [~b ~c ~d ~@more ~a])))



(defn f<*
  " fn  f<* pulls last argument to first position"
  ([f] (f))
  ([f a] (f a))
  ([f a b] (f b a))
  ([f a b c] (f c a b))
  ([f a b c d] (f d a b c))
  ([f a b c d & more] 
   (apply f (cons (last more) (concat [a b c d] (butlast more))))))



(defn  f>*
  " fn f>* pushes first argument to last position"
  ([f] (f))
  ([f a] (f a))
  ([f a b] (f b a))
  ([f a b c] (f b c a))
  ([f a b c d] (f b c d a))
  ([f a b c d & more]
   (apply f  (apply f (concat [b c d] more [a])))))



(defn f<<* 
  "f<<* returns fn that pulls last argument to first position"
  [f]
  (fn
    ([] (f))
    ([a] (f a))
    ([a b] (f b a))
    ([a b c] (f c a b))
    ([a b c d] (f d a b c))

    ([a b c d & more]
     (apply f (cons (last more) (concat [a b c d] (butlast more)))))))


(defn f>>*
  "f>>* returns fn that pushes first argument to last position"
  [f]
  (fn
    ([] (f))
    ([a]  (f a))
    ([a b] (f b a))
    ([a b c] (f b c a))
    ([a b c d] (f b c d a))
    ([a b c d & more]
     (apply f (concat [b c d] more [a])))))



(defn partial<
  "pt< is partial< -> reverse partial (also defined pt> ) "
 [f & argv]
  (fn [& args]
    (apply f (concat args argv))))

(def pt> #'partial)

(def pt< #'partial<)

