;  Copyright (C) 2020 Gabriel Ash

; This program and the accompanying materials are made available under
; the terms of the Eclipse Public License 2.0 which is available at
; http://www.eclipse.org/legal/epl-2.0 .

; This code is provided as is, without any guarantee whatsoever.

(ns gabrielash.libmisc.core
  )

(defn atom?
  [ a ] 
  "is atom?"
  (instance? clojure.lang.Atom a))

(def != #'not=)

(def ! #'not)

(defmacro !! [f & args] 
  `(apply (complement ~f) [~@args]))


(defn assoc-if
 ([col k v]
  (assoc-if col v k v))
 ([col t k v]
  (if t (assoc col k v) col)))
 
(defn is=? [v] #(= v %))

