;  Copyright (C) 2020 Gabriel Ash

; This program and the accompanying materials are made available under
; the terms of the Eclipse Public License 2.0 which is available at
; http://www.eclipse.org/legal/epl-2.0 .

; This code is provided as is, without any guarantee whatsoever.

  (ns gabrielash.libmisc.debug
    (:require
     [clojure.string :as str]
     [gabrielash.defnw.core :refer :all]
     [gabrielash.misc.shorts :refer :all]))



(defn log
  [& strs]
  (let [o (apply str strs)]
    #?(:cljs
       (.log js/console o)
       :clj 
       (println o))))


(defn !>p [& args] (first args))
(defn !p> [& args] (last args))

(defn >p [v & msgs]
  (log (apply str msgs) v)
  v)


(defn p> [& args]
  (let [v (last args)
        msgs (butlast args)]
    (log (apply str msgs) v)
    v))

