(defproject {{name}} "0.1.0-SNAPSHOT"
  :description "FIXME: write description"
  :url "FIXME: add Fury's project url"
  :license {:name "EPL-2.0 OR GPL-2.0-or-later WITH Classpath-exception-2.0"
            :url  "https://www.eclipse.org/legal/epl-2.0/"}
  :dependencies [[org.clojure/clojure "1.10.1"]
                 [org.clojure/data.json "0.2.6"]
                 [com.newrelic.agent.java/newrelic-api "5.5.0"]

                 ;web-server
                 [aleph "0.4.6"]

                 ;routing
                 [ring/ring-json "0.5.0" :exclusions [cheshire]]
                 [ring-middleware-format "0.7.4"]
                 [bidi "2.1.3"]

                 ; ioc and di
                 [com.stuartsierra/component "0.4.0"]

                 ; logging
                 [ch.qos.logback/logback-classic "1.1.8" :exclusions [org.slf4j/slf4j-api]]
                 [org.slf4j/jul-to-slf4j "1.7.22"]
                 [org.slf4j/jcl-over-slf4j "1.7.22"]
                 [org.slf4j/log4j-over-slf4j "1.7.22"]]
  :profiles {:uberjar {:aot :all}
             :dev     {:aliases               {"run-dev" ["trampoline" "run" "-m" "si-seller-fiscal-information.application/run-dev"]}
                       :plugins               [[com.jakemccrary/lein-test-refresh "0.24.1"]
                                               [lein-cljfmt "0.6.4"]
                                               [lein-cloverage "1.1.1"]
                                               [test2junit "1.2.7"]
                                               [jonase/eastwood "0.3.5"]
                                               [lein-kibit "0.1.7"]]
                       :eastwood              {:exclude-linters [:no-ns-form-found]}
                       :test2junit-output-dir "test-results"
                       :dependencies          [[org.clojure/clojure "1.10.1"]
                                               [com.github.tomakehurst/wiremock "2.24.1" :exclusions [org.slf4j/slf4j-api]]
                                               [clj-http-fake "1.0.3"]
                                               [clj-fakes "0.12.0"]
                                               [javax.servlet/javax.servlet-api "4.0.1"]
                                               [reloaded.repl "0.2.4"]
                                               [ring/ring-mock "0.4.0" :exclusions [ring/ring-codec commons-codec]]]}})
