(ns leiningen.new.fury-app
  (:require [leiningen.new.templates :refer [multi-segment sanitize-ns renderer name-to-path ->files]]
            [leiningen.core.main :as main]))

(def render (renderer "fury-app"))

(defn fury-app
  "Generates fury-app template"
  [name]
  (let [data {:name      name
              :namespace (sanitize-ns name)
              :sanitized (name-to-path name)}]
    (main/info "Generating fresh 'lein new' fury-app project.")

    (->files data
             ["README.md" (render "README.md" data)]
             [".gitignore" (render "gitignore" data)]
             ["test/{{sanitized}}/application_test.clj" (render "test.clj" data)]
             ["project.clj" (render "project.clj" data)]
             ["src/{{sanitized}}/application.clj" (render "application.clj" data)]
             ["src/{{sanitized}}/entrypoint/http/router.clj" (render "router.clj" data)]
             ["src/{{sanitized}}/entrypoint/http/handler/health.clj" (render "health.clj" data)]
             ["src/{{sanitized}}/config/http_server.clj" (render "httpserver.clj" data)]
             ["src/{{sanitized}}/config/system.clj" (render "system.clj" data)]
             ["src/{{sanitized}}/core/domain/.gitkeep" (render "gitkeep" data)]
             ["src/{{sanitized}}/core/gateway/.gitkeep" (render "gitkeep" data)]
             ["src/{{sanitized}}/core/use_case/.gitkeep" (render "gitkeep" data)]
             ["src/{{sanitized}}/gateway/http/.gitkeep" (render "gitkeep" data)])))
