;; This Source Code Form is subject to the terms of the Mozilla Public
;; License, v. 2.0. If a copy of the MPL was not distributed with this
;; file, You can obtain one at http://mozilla.org/MPL/2.0/.
;;
;; Copyright (c) Andrey Antukh <niwi@niwi.nz>

(ns rumext.hooks
  (:require
   [rumext.alpha :as mf]))

(defn use-var
  "A custom hook for define mutable variables that persists
  on renders (based on useRef hook)."
  [initial]
  (let [ref (mf/useRef initial)]
    (mf/use-memo
     #js []
     #(reify
        cljs.core/IReset
        (-reset! [_ new-value]
          (mf/set-ref-val! ref new-value))

        cljs.core/ISwap
        (-swap! [self f]
          (mf/set-ref-val! ref (f (ref-val ref))))
        (-swap! [self f x]
          (mf/set-ref-val! ref (f (ref-val ref) x)))
        (-swap! [self f x y]
          (mf/set-ref-val! ref (f (ref-val ref) x y)))
        (-swap! [self f x y more]
          (mf/set-ref-val! ref (apply f (ref-val ref) x y more)))

        cljs.core/IDeref
        (-deref [self] (ref-val ref))))))

