/*
 * Decompiled with CFR 0.152.
 */
package funcatron.service.spring_boot;

import funcatron.intf.Constants;
import funcatron.intf.OperationProvider;
import funcatron.intf.impl.ContextImpl;
import io.swagger.models.Swagger;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.setup.DefaultMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;
import springfox.documentation.service.Documentation;
import springfox.documentation.spring.web.DocumentationCache;
import springfox.documentation.spring.web.json.JsonSerializer;
import springfox.documentation.swagger2.mappers.ServiceModelToSwagger2Mapper;

public abstract class SpringBootWrapper
implements OperationProvider {
    private static WebApplicationContext applicationContext = null;
    private static volatile String basePath = "/";
    private static final Object syncObj = new Object();
    private static Map<Object, Object> swaggerObject = null;

    public abstract Class<?>[] classList();

    public WebApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public void autowire(Object o) {
        applicationContext.getAutowireCapableBeanFactory().autowireBean(o);
    }

    protected MockMvc getMockMvc() {
        DefaultMockMvcBuilder builder = MockMvcBuilders.webAppContextSetup((WebApplicationContext)applicationContext);
        return builder.build();
    }

    private Map<Object, Object> serviceRequest(InputStream is, Map<Object, Object> req) {
        Logger logger = (Logger)req.get("$logger");
        try {
            MockHttpServletRequestBuilder mockR;
            String method = (String)req.get("request-method");
            String uri = (String)req.get("uri");
            if (!"/".equals(basePath) && uri.startsWith(basePath)) {
                uri = uri.substring(basePath.length());
            }
            switch (method) {
                case "get": {
                    mockR = MockMvcRequestBuilders.get((String)uri, (Object[])new Object[0]);
                    break;
                }
                case "put": {
                    mockR = MockMvcRequestBuilders.put((String)uri, (Object[])new Object[0]);
                    break;
                }
                case "post": {
                    mockR = MockMvcRequestBuilders.post((String)uri, (Object[])new Object[0]);
                    break;
                }
                case "delete": {
                    mockR = MockMvcRequestBuilders.delete((String)uri, (Object[])new Object[0]);
                    break;
                }
                case "patch": {
                    mockR = MockMvcRequestBuilders.patch((String)uri, (Object[])new Object[0]);
                    break;
                }
                case "head": {
                    mockR = MockMvcRequestBuilders.patch((String)uri, (Object[])new Object[0]);
                    break;
                }
                default: {
                    throw new RuntimeException("Unable to process HTTP request method '" + method + "'");
                }
            }
            Map headers = (Map)req.get("headers");
            for (String k : headers.keySet()) {
                Object v = headers.get(k);
                if (null == v) continue;
                if (v instanceof String) {
                    mockR.header(k, new Object[]{v});
                    continue;
                }
                if (!(v instanceof List)) continue;
                List sl = (List)v;
                int sz = sl.size();
                Object[] sa = new String[sz];
                for (int x = 0; x < sz; ++x) {
                    sa[x] = (String)sl.get(x);
                }
                mockR.header(k, sa);
            }
            if (null != is) {
                int cnt;
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                byte[] ba = new byte[4096];
                do {
                    if ((cnt = is.read(ba)) <= 0) continue;
                    bos.write(ba, 0, cnt);
                } while (cnt >= 0);
                mockR.content(bos.toByteArray());
            }
            MockMvc router = this.getMockMvc();
            MockHttpServletResponse ra = router.perform((RequestBuilder)mockR).andReturn().getResponse();
            HashMap<Object, Object> ret = new HashMap<Object, Object>();
            HashMap<String, List> respHeaders = new HashMap<String, List>();
            for (String k : ra.getHeaderNames()) {
                List hv = ra.getHeaderValues(k);
                if (null == hv) continue;
                respHeaders.put(k, hv);
            }
            ret.put("status", ra.getStatus());
            ret.put("headers", respHeaders);
            ret.put("body", ra.getContentAsByteArray());
            return ret;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to service request", e);
        }
    }

    private BiFunction<InputStream, Map<Object, Object>, Map<Object, Object>> metaService(Map<Object, Object> params, Logger logger) {
        return this::serviceRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installOperation(BiFunction<String, BiFunction<Map<Object, Object>, Logger, Object>, Void> addOperation, Function<String, BiFunction<Map<Object, Object>, Logger, Object>> findOperation, Function<Function<Logger, Void>, Void> function1, ClassLoader classLoader, Logger logger) {
        Object object = syncObj;
        synchronized (object) {
            if (applicationContext != null) {
                return;
            }
            BiFunction originalEndLife = (BiFunction)Constants.ConvertEndLifeFunc.apply(findOperation.apply("endLife"));
            WebApplicationContext ac = (WebApplicationContext)ContextImpl.runOperation((String)"spring_app", new HashMap(), (Logger)logger, WebApplicationContext.class);
            if (null == ac) {
                SpringApplication sa = new SpringApplication((Object[])this.classList());
                ac = (WebApplicationContext)sa.run(new String[0]);
            }
            applicationContext = ac;
            addOperation.apply("getSwagger", (x, logger2) -> {
                Object object = syncObj;
                synchronized (object) {
                    if (null != swaggerObject) {
                        return swaggerObject;
                    }
                    HashMap<Object, Object> ret = new HashMap<Object, Object>();
                    ret.put("type", "json");
                    SwaggerFinder gc = new SwaggerFinder();
                    this.autowire(gc);
                    ret.put("swagger", gc.dumpSwagger());
                    swaggerObject = ret;
                    return ret;
                }
            });
            addOperation.apply("dispatcherFor", (info, logger2) -> this.metaService((Map<Object, Object>)info, (Logger)logger2));
            addOperation.apply("endLife", (x, logger2) -> {
                ((ConfigurableApplicationContext)applicationContext).close();
                originalEndLife.apply(null, logger2);
                return null;
            });
        }
    }

    private static class SwaggerFinder {
        @Autowired
        private DocumentationCache documentationCache;
        @Autowired
        private ServiceModelToSwagger2Mapper mapper;
        @Autowired
        private JsonSerializer jsonSerializer;

        private SwaggerFinder() {
        }

        public String dumpSwagger() {
            try {
                String groupName = "default";
                Documentation documentation = this.documentationCache.documentationByGroup(groupName);
                if (documentation == null) {
                    if (this.documentationCache.all().isEmpty()) {
                        return "{}";
                    }
                    documentation = (Documentation)this.documentationCache.all().values().stream().findFirst().get();
                }
                Swagger swagger = this.mapper.mapDocumentation(documentation);
                basePath = swagger.getBasePath();
                return this.jsonSerializer.toJson((Object)swagger).value();
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to dump the Swagger", e);
            }
        }
    }
}

