/*
 * Decompiled with CFR 0.152.
 */
package funcatron.intf.impl;

import funcatron.intf.Accumulator;
import funcatron.intf.ClassloaderProvider;
import funcatron.intf.Context;
import funcatron.intf.Func;
import funcatron.intf.MetaResponse;
import funcatron.intf.MiddlewareProvider;
import funcatron.intf.OperationProvider;
import funcatron.intf.OrderedProvider;
import funcatron.intf.ServiceVendor;
import funcatron.intf.ServiceVendorProvider;
import funcatron.intf.impl.Dispatcher;
import funcatron.intf.impl.JDBCServiceVendorBuilder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ContextImpl
implements Context,
Accumulator {
    private final Map<Object, Object> data;
    private final Logger logger;
    private final CopyOnWriteArrayList<ReleasePair<?>> toTerminate = new CopyOnWriteArrayList();
    private static final ConcurrentHashMap<String, ServiceVendor<?>> services = new ConcurrentHashMap();
    private static Map<String, Object> props = new HashMap<String, Object>();
    private static volatile ClassLoader contextClassloader;
    private static List<MiddlewareProvider> middleWare;
    private static final ConcurrentHashMap<String, BiFunction<Map<Object, Object>, Logger, Object>> operations;
    private static final CopyOnWriteArrayList<Function<Logger, Void>> endOfLifeFunctions;
    private static DocumentBuilderFactory dbf;

    public ContextImpl(Map<Object, Object> data, Logger logger) {
        this.data = data;
        this.logger = logger;
    }

    public static ClassLoader getClassloader() {
        ClassLoader ret = contextClassloader;
        if (null == ret) {
            return ContextImpl.class.getClassLoader();
        }
        return ret;
    }

    public static byte[] toByteArray(InputStream is) {
        if (null == is) {
            return new byte[0];
        }
        byte[] buf = new byte[4096];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            int cnt = is.read(buf);
            while (cnt >= 0) {
                if (cnt > 0) {
                    bos.write(buf, 0, cnt);
                }
                cnt = is.read(buf);
            }
        }
        catch (IOException io) {
            throw new RuntimeException("Failed to read", io);
        }
        return bos.toByteArray();
    }

    private static Map<String, Object> reifyToMap(InputStream is, String type) {
        try {
            String s = new String(ContextImpl.toByteArray(is), "UTF-8");
            HashMap<String, Object> ret = new HashMap<String, Object>();
            ret.put("swagger", s);
            ret.put("type", type);
            return ret;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to reify Swagger", e);
        }
    }

    public static Map<String, Object> getSwagger(Logger l) {
        InputStream is = contextClassloader.getResourceAsStream("funcatron.yaml");
        if (null != is) {
            return ContextImpl.reifyToMap(is, "yaml");
        }
        is = contextClassloader.getResourceAsStream("funcatron.json");
        if (null != is) {
            return ContextImpl.reifyToMap(is, "json");
        }
        return null;
    }

    public static Object dispatcherFor(Map<Object, Object> info, Logger l) {
        Dispatcher disp = new Dispatcher();
        return ContextImpl.wrapWithMiddleware(disp.apply((String)info.get("$operationId"), info));
    }

    public static BiFunction<InputStream, Map<Object, Object>, Map<Object, Object>> wrapWithMiddleware(BiFunction<InputStream, Map<Object, Object>, Map<Object, Object>> function) {
        for (MiddlewareProvider mw : middleWare) {
            function = mw.wrap(function);
        }
        return function;
    }

    public static Set<String> operationNames() {
        return operations.keySet();
    }

    public static void addOperation(String name, BiFunction<Map<Object, Object>, Logger, Object> func) {
        operations.put(name, func);
    }

    public static void addFunctionToEndOfLife(Function<Logger, Void> func) {
        endOfLifeFunctions.add(func);
    }

    private static <T> List<T> toList(Iterable<T> it) {
        return StreamSupport.stream(it.spliterator(), false).collect(Collectors.toList());
    }

    private static <T extends OrderedProvider> List<T> toSortedList(Iterable<T> it) {
        List<T> list = ContextImpl.toList(it);
        list.sort((a, b) -> b.order() - a.order());
        return list;
    }

    public static Function<String, BiFunction<Map<Object, Object>, Logger, Object>> initContext(Map<String, Object> props, ClassLoader loader, Logger logger) throws Exception {
        logger.log(Level.INFO, () -> "Setting up context with props " + props);
        contextClassloader = loader;
        ContextImpl.props = Collections.unmodifiableMap(new HashMap<String, Object>(props));
        List<ClassloaderProvider> classloaderMagic = ContextImpl.toSortedList(ServiceLoader.load(ClassloaderProvider.class, loader));
        ClassLoader curClassloader = loader;
        for (ClassloaderProvider clb : classloaderMagic) {
            curClassloader = clb.buildFrom(curClassloader, eol -> {
                ContextImpl.addFunctionToEndOfLife(eol);
                return null;
            }, logger);
        }
        contextClassloader = curClassloader;
        ContextImpl.toSortedList(ServiceLoader.load(OperationProvider.class, curClassloader)).forEach(i -> {
            try {
                i.installOperation((name, func) -> {
                    ContextImpl.addOperation(name, func);
                    return null;
                }, s -> operations.get(s), eol -> {
                    ContextImpl.addFunctionToEndOfLife(eol);
                    return null;
                }, contextClassloader, logger);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e, () -> "Failed to install operation");
            }
        });
        ServiceLoader<ServiceVendorProvider> builders = ServiceLoader.load(ServiceVendorProvider.class, curClassloader);
        HashMap<String, JDBCServiceVendorBuilder> builderMap = new HashMap<String, JDBCServiceVendorBuilder>();
        builders.forEach(a -> builderMap.put(a.forType(), (JDBCServiceVendorBuilder)a));
        JDBCServiceVendorBuilder db = new JDBCServiceVendorBuilder();
        builderMap.put(db.forType(), db);
        props.forEach((k, v) -> {
            Map m;
            Object o;
            if (null != k && k instanceof String && null != v && v instanceof Map && null != (o = (m = (Map)v).get("type")) && o instanceof String) {
                logger.log(Level.FINER, () -> "Looking for builder for type: " + o);
                ServiceVendorProvider b = (ServiceVendorProvider)builderMap.get(o);
                if (null != b) {
                    logger.log(Level.FINER, () -> "Building with props " + m);
                    Optional<ServiceVendor<?>> opt = b.buildVendor((String)k, m, logger);
                    opt.map(vendor -> services.put((String)k, (ServiceVendor<?>)vendor));
                }
            }
        });
        middleWare = ContextImpl.toSortedList(ServiceLoader.load(MiddlewareProvider.class, curClassloader));
        return name -> operations.get(name);
    }

    public static void endLife() {
        ContextImpl.endLife(Logger.getLogger(ContextImpl.class.getName()));
    }

    public static <T> T runOperation(String name, Map<Object, Object> params, Logger logger, Class<T> clz) {
        BiFunction<Map<Object, Object>, Logger, Object> theOp = operations.get(name);
        if (null == theOp) {
            return null;
        }
        Object ret = theOp.apply(params, logger);
        if (clz.isInstance(ret)) {
            return (T)ret;
        }
        return null;
    }

    public static void endLife(Logger logger) {
        if (null == logger) {
            logger = Logger.getLogger(ContextImpl.class.getName());
        }
        Logger fl = logger;
        services.entrySet().forEach(a -> {
            try {
                ((ServiceVendor)a.getValue()).endLife();
            }
            catch (Exception e) {
                fl.log(Level.WARNING, e, () -> "Failed to end resource life");
            }
        });
        endOfLifeFunctions.forEach((Consumer<Function<Logger, Void>>)((Consumer<Function>)a -> {
            try {
                a.apply(fl);
            }
            catch (Exception e) {
                fl.log(Level.WARNING, e, () -> "Failed to end resource life");
            }
        }));
    }

    public static Callable<Object> buildParameterResolver(InputStream inputStream, Func<Object> func, Function<InputStream, Object> basicDeserializer, BiFunction<InputStream, Class<?>, Object> deserializer, Class<?> paramType, String contentType, Logger logger) {
        Callable<Object> resolveParam = () -> {
            BiFunction contextDeserializer = ContextImpl.runOperation("getDeserializer", new HashMap<Object, Object>(), logger, BiFunction.class);
            Object param = null;
            if (null != inputStream) {
                Function instDeserializer = null;
                try {
                    if (null != func) {
                        instDeserializer = func.jsonDecoder();
                    }
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                param = null != instDeserializer ? instDeserializer.apply(inputStream) : (null != contextDeserializer ? contextDeserializer.apply(inputStream, Arrays.asList(contentType, paramType)) : (null != basicDeserializer ? basicDeserializer.apply(inputStream) : deserializer.apply(inputStream, paramType)));
            }
            return param;
        };
        return resolveParam;
    }

    public static BiFunction<InputStream, Map<Object, Object>, Map<Object, Object>> makeResponseBiFunc(Function<Object, byte[]> serializer, BiFunction<InputStream, Class<?>, Object> deserializer, Function<InputStream, Object> basicDeserializer, String className, Class<?> paramType, Class<Func<Object>> c) {
        return (inputStream, om) -> {
            Logger theLogger = (Logger)om.get("$logger");
            if (null == theLogger) {
                theLogger = Logger.getLogger(className);
            }
            ContextImpl theContext = new ContextImpl((Map<Object, Object>)om, theLogger);
            try {
                Func func = (Func)c.newInstance();
                Callable<Object> resolveParam = ContextImpl.buildParameterResolver(inputStream, func, basicDeserializer, deserializer, paramType, theContext.contentType(), theLogger);
                Object retVal = null;
                retVal = "get".equals(theContext.getMethod()) ? func.get(theContext) : ("post".equals(theContext.getMethod()) ? func.post(resolveParam.call(), theContext) : ("put".equals(theContext.getMethod()) ? func.put(resolveParam.call(), theContext) : ("patch".equals(theContext.getMethod()) ? func.patch(resolveParam.call(), theContext) : ("delete".equals(theContext.getMethod()) ? func.delete(theContext) : func.apply(resolveParam.call(), theContext)))));
                return ContextImpl.responseObjectToResponseMap(func, retVal, theContext, serializer, new HashMap<Object, Object>(), theLogger);
            }
            catch (RuntimeException re) {
                theContext.finished(false);
                throw re;
            }
            catch (Exception e) {
                theContext.finished(false);
                throw new RuntimeException("Failed to apply function", e);
            }
        };
    }

    public static Map<Object, Object> responseObjectToResponseMap(Func<Object> func, Object retVal, Context theContext, Function<Object, byte[]> serializer, Map<Object, Object> altResponseInfo, Logger logger) throws Exception {
        Object o42;
        Object o32;
        Object o22;
        boolean allSet = false;
        HashMap<Object, Object> ret = new HashMap<Object, Object>();
        Function<Object, byte[]> instSerializer = null;
        try {
            if (null != func) {
                instSerializer = func.jsonEncoder();
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        String contentType = "application/json";
        if (null == retVal) {
            retVal = new byte[0];
        } else if (retVal instanceof MetaResponse) {
            allSet = true;
            MetaResponse mr = (MetaResponse)retVal;
            ret.put("body", mr.getBody());
            ret.put("status", mr.getResponseCode());
            ret.put("headers", mr.getHeaders());
        } else if (retVal instanceof Node && null == instSerializer) {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource((Node)retVal);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(bos);
            transformer.transform(source, result);
            retVal = bos.toByteArray();
            contentType = "text/xml";
        } else if (retVal instanceof byte[] || retVal instanceof OutputStream) {
            ret.put("body", retVal);
        } else {
            Function contextSerializer = ContextImpl.runOperation("getSerializer", altResponseInfo, logger, Function.class);
            retVal = null != instSerializer ? (Object)instSerializer.apply(retVal) : (null != contextSerializer ? contextSerializer.apply(retVal) : (Object)serializer.apply(retVal));
        }
        String fct = null;
        if (null != altResponseInfo && null != (o22 = altResponseInfo.get("content-type")) && o22 instanceof String) {
            fct = (String)o22;
        }
        try {
            if (null != func) {
                fct = func.contentType();
            }
        }
        catch (UnsupportedOperationException o22) {
            // empty catch block
        }
        String ct2 = fct == null ? contentType : fct;
        Map<Object, Object> someHeaders = new HashMap();
        if (null != altResponseInfo && null != (o32 = altResponseInfo.get("headers")) && o32 instanceof Map) {
            someHeaders = (Map)o32;
        }
        try {
            if (null != func) {
                someHeaders = func.headers();
            }
        }
        catch (UnsupportedOperationException o32) {
            // empty catch block
        }
        int status = 200;
        if (null != altResponseInfo && null != (o42 = altResponseInfo.get("status")) && o42 instanceof Number) {
            status = ((Number)o42).intValue();
        }
        try {
            if (null != func) {
                status = func.statusCode();
            }
        }
        catch (UnsupportedOperationException o42) {
            // empty catch block
        }
        if (!allSet) {
            ret.put("status", status);
            HashMap<String, String> headers = new HashMap<String, String>(someHeaders);
            if (!headers.containsKey("content-type")) {
                headers.put("content-type", ct2);
            }
            ret.put("headers", headers);
            ret.put("body", retVal);
        }
        if (theContext instanceof Accumulator) {
            ((Accumulator)((Object)theContext)).finished(true);
        }
        return ret;
    }

    public static Document documentFromInputStream(InputStream is) {
        if (null == is) {
            return null;
        }
        try {
            return dbf.newDocumentBuilder().parse(is);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse the XML", e);
        }
    }

    @Override
    public Map<Object, Object> getRequestInfo() {
        return this.data;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public String getURI() {
        return (String)this.data.get("uri");
    }

    @Override
    public Map<String, Map<String, Object>> getRequestParams() {
        return (Map)this.data.get("parameters");
    }

    @Override
    public Map<String, Object> getHeaders() {
        return (Map)this.data.get("headers");
    }

    @Override
    public Map<String, Object> getPathParams() {
        HashMap ret;
        HashMap parameters = (HashMap)this.data.get("parameters");
        if (null == parameters) {
            parameters = new HashMap();
        }
        if (null == (ret = (HashMap)parameters.get("path"))) {
            ret = new HashMap();
        }
        return ret;
    }

    @Override
    public Map<String, Object> getBodyParams() {
        HashMap ret;
        HashMap parameters = (HashMap)this.data.get("parameters");
        if (null == parameters) {
            parameters = new HashMap();
        }
        if (null == (ret = (HashMap)parameters.get("body"))) {
            ret = new HashMap();
        }
        return ret;
    }

    @Override
    public Map<String, Object> getMergedParams() {
        Map<String, Object> path = this.getPathParams();
        Map<String, Object> query = this.getQueryParams();
        HashMap<String, Object> ret = new HashMap<String, Object>();
        path.forEach((k, v) -> ret.put((String)k, v));
        query.forEach((k, v) -> ret.put((String)k, v));
        return ret;
    }

    @Override
    public Map<String, Object> getQueryParams() {
        HashMap ret;
        HashMap parameters = (HashMap)this.data.get("parameters");
        if (null == parameters) {
            parameters = new HashMap();
        }
        if (null == (ret = (HashMap)parameters.get("query"))) {
            ret = new HashMap();
        }
        return ret;
    }

    @Override
    public String getScheme() {
        return (String)this.data.get("scheme");
    }

    @Override
    public String getHost() {
        return (String)this.data.get("host");
    }

    @Override
    public String contentType() {
        List tl;
        Map<String, Object> headers = this.getHeaders();
        if (null == headers) {
            return null;
        }
        Object tRet = null;
        if (headers.containsKey("Content-Type")) {
            tRet = headers.get("Content-Type");
        } else if (headers.containsKey("content-type")) {
            tRet = headers.get("Content-Type");
        }
        if (null != tRet && tRet instanceof List && (tl = (List)tRet).size() > 0) {
            tRet = tl.get(0);
        }
        if (tRet instanceof String) {
            return (String)tRet;
        }
        return null;
    }

    @Override
    public String getMethod() {
        return (String)this.data.get("request-method");
    }

    public static String getVersion(Logger logger) {
        InputStream is = contextClassloader.getResourceAsStream("META-INF/maven/funcatron/intf/pom.properties");
        try {
            if (null != is) {
                Properties p = new Properties();
                p.load(is);
                return p.getProperty("version");
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e, () -> "Failed to get version");
        }
        return "?";
    }

    @Override
    public <T> void accumulate(T item, ServiceVendor<T> vendor) {
        this.getLogger().log(Level.FINER, () -> "Accumulating " + item);
        this.toTerminate.add(new ReleasePair<T>(item, vendor));
    }

    @Override
    public void finished(boolean success) {
        this.getLogger().log(Level.FINER, () -> "Finished " + success + " Notifying " + this.toTerminate.size());
        this.toTerminate.forEach((Consumer<ReleasePair<?>>)((Consumer<ReleasePair>)a -> {
            ReleasePair b = a;
            try {
                this.getLogger().log(Level.FINER, () -> "Releasing " + b.item);
                b.vendor.release(b.item, success);
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, "Exception releasing " + a.item, e);
            }
        }));
    }

    @Override
    public Set<String> services() {
        return services.keySet();
    }

    @Override
    public Optional<ServiceVendor<?>> serviceForName(String name) {
        if (!services.containsKey(name)) {
            return Optional.empty();
        }
        return Optional.of(services.get(name));
    }

    @Override
    public <T> Optional<T> vendForName(String name, Class<T> clz) throws Exception {
        Optional<ServiceVendor<T>> ov = this.serviceForName(name, clz);
        if (ov.isPresent()) {
            return Optional.of(ov.get().vend(this));
        }
        return Optional.empty();
    }

    @Override
    public Map<String, Object> properties() {
        return props;
    }

    static {
        middleWare = new ArrayList<MiddlewareProvider>();
        operations = new ConcurrentHashMap();
        operations.put("operations", (x, l) -> operations.keySet());
        operations.put("endLife", (x, l) -> {
            ContextImpl.endLife(l);
            return null;
        });
        operations.put("getClassloader", (x, l) -> ContextImpl.getClassloader());
        operations.put("getSwagger", (x, l) -> ContextImpl.getSwagger(l));
        operations.put("getVersion", (x, l) -> ContextImpl.getVersion(l));
        operations.put("dispatcherFor", (x, l) -> ContextImpl.dispatcherFor(x, l));
        operations.put("getSerializer", (x, l) -> null);
        operations.put("getDeserializer", (x, l) -> null);
        operations.put("wrapWithMiddleware", (x, l) -> ContextImpl.wrapWithMiddleware((BiFunction)x.get("function")));
        endOfLifeFunctions = new CopyOnWriteArrayList();
        dbf = DocumentBuilderFactory.newInstance();
        String FEATURE = null;
        try {
            FEATURE = "http://apache.org/xml/features/disallow-doctype-decl";
            dbf.setFeature(FEATURE, true);
            FEATURE = "http://xml.org/sax/features/external-general-entities";
            dbf.setFeature(FEATURE, false);
            FEATURE = "http://xml.org/sax/features/external-parameter-entities";
            dbf.setFeature(FEATURE, false);
            FEATURE = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
            dbf.setFeature(FEATURE, false);
            dbf.setXIncludeAware(false);
            dbf.setExpandEntityReferences(false);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize the XML parser", e);
        }
    }

    private static class ReleasePair<T> {
        final T item;
        final ServiceVendor<T> vendor;

        ReleasePair(T item, ServiceVendor<T> vendor) {
            this.item = item;
            this.vendor = vendor;
        }
    }
}

