/*
 * Decompiled with CFR 0.152.
 */
package funcatron.intf;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public interface MetaResponse
extends Iterable<Map.Entry<String, Object>> {
    default public int getResponseCode() {
        return 200;
    }

    default public Map<String, String> getHeaders() {
        return new HashMap<String, String>();
    }

    default public String getContentType() {
        return "application/octet-stream";
    }

    default public boolean isLargeBody() {
        return false;
    }

    default public byte[] getBody() {
        return null;
    }

    default public InputStream getBodyStream() {
        return null;
    }

    @Override
    default public Iterator<Map.Entry<String, Object>> iterator() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        boolean large = this.isLargeBody();
        byte[] arrayBody = large ? null : this.getBody();
        InputStream streamBody = large ? this.getBodyStream() : null;
        Object body = large ? streamBody : (Object)arrayBody;
        ret.put("version", "1");
        ret.put("responseCode", this.getResponseCode());
        ret.put("headers", this.getHeaders());
        ret.put("contentType", this.getContentType());
        ret.put("largeBody", large);
        ret.put("bodyArray", arrayBody);
        ret.put("bodyStream", streamBody);
        ret.put("body", body);
        return ret.entrySet().iterator();
    }
}

