/*
 * Decompiled with CFR 0.152.
 */
package funcatron.intf.impl;

import funcatron.intf.Func;
import funcatron.intf.MetaResponse;
import funcatron.intf.impl.ContextImpl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Dispatcher
implements BiFunction<String, Map<Object, Object>, BiFunction<InputStream, Map<Object, Object>, Map<Object, Object>>> {
    private static DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();

    private static byte[] toByteArray(InputStream is) {
        if (null == is) {
            return new byte[0];
        }
        byte[] buf = new byte[4096];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            int cnt = is.read(buf);
            while (cnt >= 0) {
                if (cnt > 0) {
                    bos.write(buf, 0, cnt);
                }
                cnt = is.read(buf);
            }
        }
        catch (IOException io) {
            throw new RuntimeException("Failed to read", io);
        }
        return bos.toByteArray();
    }

    private static Document documentFromInputStream(InputStream is) {
        if (null == is) {
            return null;
        }
        try {
            return dbf.newDocumentBuilder().parse(is);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse the XML", e);
        }
    }

    @Override
    public BiFunction<InputStream, Map<Object, Object>, Map<Object, Object>> apply(String className, Map<Object, Object> objectMap) {
        try {
            BiFunction deserializer = (BiFunction)objectMap.get("$deserializer");
            Function serializer = (Function)objectMap.get("$serializer");
            HashMap<Object, Object> cleanMap = new HashMap<Object, Object>(objectMap);
            objectMap.keySet().forEach(k -> {
                if (k instanceof String && ((String)k).startsWith("$")) {
                    cleanMap.remove(k);
                }
            });
            Class<?> c = this.getClass().getClassLoader().loadClass(className);
            Class<Object> paramType = Arrays.stream(c.getAnnotatedInterfaces()).map(a -> a.getType()).filter(a -> a instanceof ParameterizedType).map(a -> (ParameterizedType)a).filter(a -> a.getTypeName().startsWith("funcatron.intf.Func<")).flatMap(a -> Arrays.stream(a.getActualTypeArguments())).filter(a -> a instanceof Class).map(a -> (Class)a).findFirst().orElse(Object.class);
            Function<InputStream, Object> basicDeserializer = paramType.isAssignableFrom(byte[].class) ? is -> Dispatcher.toByteArray(is) : (paramType.isAssignableFrom(InputStream.class) ? is -> is : (paramType.isAssignableFrom(Document.class) ? is -> Dispatcher.documentFromInputStream(is) : null));
            return (inputStream, om) -> {
                Logger theLogger = (Logger)om.get("$logger");
                if (null == theLogger) {
                    theLogger = Logger.getLogger(className);
                }
                ContextImpl theContext = new ContextImpl((Map<Object, Object>)om, theLogger);
                try {
                    Func func = (Func)c.newInstance();
                    HashMap<String, Object> ret = new HashMap<String, Object>();
                    Object param = null;
                    if (null != inputStream) {
                        Function instDeserializer = null;
                        try {
                            instDeserializer = func.jsonDecoder();
                        }
                        catch (UnsupportedOperationException unsupportedOperationException) {
                            // empty catch block
                        }
                        param = null != instDeserializer ? (Object)instDeserializer.apply((InputStream)inputStream) : (null != basicDeserializer ? (Object)basicDeserializer.apply((InputStream)inputStream) : (Object)deserializer.apply(inputStream, paramType));
                    }
                    Object retVal = func.apply(param, theContext);
                    boolean allSet = false;
                    Function<Object, byte[]> instSerializer = null;
                    try {
                        instSerializer = func.jsonEncoder();
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        // empty catch block
                    }
                    String contentType = "application/json";
                    if (null == retVal) {
                        retVal = new byte[0];
                    } else if (retVal instanceof MetaResponse) {
                        allSet = true;
                        MetaResponse mr = (MetaResponse)retVal;
                        ret.put("body", mr.getBody());
                        ret.put("status", mr.getResponseCode());
                        ret.put("headers", mr.getHeaders());
                    } else if (retVal instanceof Node && null == instSerializer) {
                        TransformerFactory transformerFactory = TransformerFactory.newInstance();
                        Transformer transformer = transformerFactory.newTransformer();
                        DOMSource source = new DOMSource((Node)retVal);
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        StreamResult result = new StreamResult(bos);
                        transformer.transform(source, result);
                        retVal = bos.toByteArray();
                        contentType = "text/xml";
                    } else if (retVal instanceof byte[] || retVal instanceof OutputStream) {
                        ret.put("body", retVal);
                    } else {
                        retVal = null != instSerializer ? (Object)instSerializer.apply(retVal) : serializer.apply(retVal);
                    }
                    String fct = null;
                    try {
                        fct = func.contentType();
                    }
                    catch (UnsupportedOperationException transformer) {
                        // empty catch block
                    }
                    String ct2 = fct == null ? contentType : fct;
                    Map<Object, Object> someHeaders = new HashMap();
                    try {
                        someHeaders = func.headers();
                    }
                    catch (UnsupportedOperationException bos) {
                        // empty catch block
                    }
                    int status = 200;
                    try {
                        status = func.statusCode();
                    }
                    catch (UnsupportedOperationException result) {
                        // empty catch block
                    }
                    if (!allSet) {
                        ret.put("status", status);
                        HashMap<String, String> headers = new HashMap<String, String>(someHeaders);
                        if (!headers.containsKey("content-type")) {
                            headers.put("content-type", ct2);
                        }
                        ret.put("headers", headers);
                        ret.put("body", retVal);
                    }
                    theContext.finished(true);
                    return ret;
                }
                catch (RuntimeException re) {
                    theContext.finished(false);
                    throw re;
                }
                catch (Exception e) {
                    theContext.finished(false);
                    throw new RuntimeException("Failed to apply function", e);
                }
            };
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to build dispatch function", e);
        }
    }

    static {
        String FEATURE = null;
        try {
            FEATURE = "http://apache.org/xml/features/disallow-doctype-decl";
            dbf.setFeature(FEATURE, true);
            FEATURE = "http://xml.org/sax/features/external-general-entities";
            dbf.setFeature(FEATURE, false);
            FEATURE = "http://xml.org/sax/features/external-parameter-entities";
            dbf.setFeature(FEATURE, false);
            FEATURE = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
            dbf.setFeature(FEATURE, false);
            dbf.setXIncludeAware(false);
            dbf.setExpandEntityReferences(false);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize the XML parser", e);
        }
    }
}

