(ns syrup.human.alpha
  (:require
   [clojure.spec.alpha :as s]
            [syrup.core.alpha :as core]))

(defonce ^:private registry-ref (atom {}))

(defn resolve [root-id]
  (loop [id root-id]
    (when-let [x (get @registry-ref id)]
      (cond (string? x) (recur x)
            (qualified-keyword? x) x
            :else (throw (java.lang.AssertionError. (str "invalid spec in registry " x)))))))

(defn register!
  [id spec]
  (assert (string? id) "id must be a string")
  (cond (qualified-keyword? spec) (do (assert (s/get-spec spec) (str "spec " spec " does not exist"))
                                      (swap! registry-ref assoc id spec))
        (string? spec) (if-let [resolved-spec (resolve spec)]
                         (swap! registry-ref assoc id resolved-spec)
                         (throw (java.lang.AssertionError. (str "unable to resolve field " spec))))
        :else (throw (java.lang.AssertionError. (str "invalid spec identifier " spec)))))
