(ns fulcro.inspect.ui.data-history
  (:require [fulcro.client.primitives :as fp]
            [fulcro-css.css :as css]
            [fulcro.client.dom :as dom]
            [fulcro.inspect.ui.data-watcher :as watcher]))

(fp/defsc DataHistory
  [this {::keys [history watcher]} computed children]
  {:initial-state {::history-id (random-uuid)
                   ::history    []}
   :ident         [::history-id ::history-id]
   :query         [::history-id ::history
                   {::watcher (fp/get-query watcher/DataWatcher)}]
   :css           []
   :css-include   []}
  (let [css (css/get-classnames DataHistory)]
    (dom/div nil)))

(def data-history (fp/factory DataHistory))
