// Compiled by ClojureScript 1.9.946 {}
goog.provide('fulcro_spec.reporter');
goog.require('cljs.core');
goog.require('cljs_uuid_utils.core');
goog.require('cljs.stacktrace');
goog.require('clojure.set');
goog.require('cljs.test');
goog.require('com.stuartsierra.component');
goog.require('fulcro_spec.diff');
goog.require('goog.date.Date');
fulcro_spec.reporter.new_uuid = (function fulcro_spec$reporter$new_uuid(){
return cljs_uuid_utils.core.uuid_string.call(null,cljs_uuid_utils.core.make_random_uuid.call(null));
});
fulcro_spec.reporter.fix_str = (function fulcro_spec$reporter$fix_str(s){
var G__57860 = s;
if(cljs.core._EQ_.call(null,"",G__57860)){
return "\"\"";
} else {
if(cljs.core._EQ_.call(null,null,G__57860)){
return "nil";
} else {
return s;

}
}
});
fulcro_spec.reporter.now_time = (function fulcro_spec$reporter$now_time(){
return Date.now();
});
fulcro_spec.reporter.make_testreport = (function fulcro_spec$reporter$make_testreport(var_args){
var G__57862 = arguments.length;
switch (G__57862) {
case 0:
return fulcro_spec.reporter.make_testreport.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return fulcro_spec.reporter.make_testreport.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fulcro_spec.reporter.make_testreport.cljs$core$IFn$_invoke$arity$0 = (function (){
return fulcro_spec.reporter.make_testreport.call(null,cljs.core.PersistentVector.EMPTY);
});

fulcro_spec.reporter.make_testreport.cljs$core$IFn$_invoke$arity$1 = (function (initial_items){
return new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"id","id",-1388402092),fulcro_spec.reporter.new_uuid.call(null),new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"start-time","start-time",814801386),fulcro_spec.reporter.now_time.call(null),new cljs.core.Keyword(null,"test","test",577538877),(0),new cljs.core.Keyword(null,"pass","pass",1574159993),(0),new cljs.core.Keyword(null,"fail","fail",1706214930),(0),new cljs.core.Keyword(null,"error","error",-978969032),(0)], null);
});

fulcro_spec.reporter.make_testreport.cljs$lang$maxFixedArity = 1;

fulcro_spec.reporter.make_testitem = (function fulcro_spec$reporter$make_testitem(p__57864){
var map__57865 = p__57864;
var map__57865__$1 = ((((!((map__57865 == null)))?((((map__57865.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57865.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57865):map__57865);
var string = cljs.core.get.call(null,map__57865__$1,new cljs.core.Keyword(null,"string","string",-1989541586));
var form_meta = cljs.core.get.call(null,map__57865__$1,new cljs.core.Keyword(null,"form-meta","form-meta",-352800224));
var G__57867 = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"id","id",-1388402092),fulcro_spec.reporter.new_uuid.call(null),new cljs.core.Keyword(null,"name","name",1843675177),string,new cljs.core.Keyword(null,"status","status",-1997798413),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"test-items","test-items",1900391985),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"test-results","test-results",575566942),cljs.core.PersistentVector.EMPTY], null);
if(cljs.core.truth_(form_meta)){
return cljs.core.assoc.call(null,G__57867,new cljs.core.Keyword(null,"form-meta","form-meta",-352800224),form_meta);
} else {
return G__57867;
}
});
fulcro_spec.reporter.make_manual = (function fulcro_spec$reporter$make_manual(test_name){
return fulcro_spec.reporter.make_testitem.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"string","string",-1989541586),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(test_name)," (MANUAL TEST)"].join('')], null));
});
fulcro_spec.reporter.stack__GT_trace = (function fulcro_spec$reporter$stack__GT_trace(st){
return cljs.stacktrace.parse_stacktrace.call(null,cljs.core.PersistentArrayMap.EMPTY,st,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY);
});
fulcro_spec.reporter.merge_in_diff_results = (function fulcro_spec$reporter$merge_in_diff_results(p__57868){
var map__57869 = p__57868;
var map__57869__$1 = ((((!((map__57869 == null)))?((((map__57869.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57869.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57869):map__57869);
var test_result = map__57869__$1;
var actual = cljs.core.get.call(null,map__57869__$1,new cljs.core.Keyword(null,"actual","actual",107306363));
var expected = cljs.core.get.call(null,map__57869__$1,new cljs.core.Keyword(null,"expected","expected",1583670997));
var assert_type = cljs.core.get.call(null,map__57869__$1,new cljs.core.Keyword(null,"assert-type","assert-type",-1787842052));
var G__57871 = test_result;
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"eq","eq",1021992460,null),null], null), null).call(null,assert_type))){
return cljs.core.assoc.call(null,G__57871,new cljs.core.Keyword(null,"diff","diff",2135942783),fulcro_spec.diff.diff.call(null,expected,actual));
} else {
return G__57871;
}
});
fulcro_spec.reporter.make_test_result = (function fulcro_spec$reporter$make_test_result(status,t){
return cljs.core.update.call(null,cljs.core.update.call(null,(function (p1__57873_SHARP_){
if(cljs.core.truth_((function (){var G__57874 = p1__57873_SHARP_;
var G__57874__$1 = (((G__57874 == null))?null:new cljs.core.Keyword(null,"actual","actual",107306363).cljs$core$IFn$_invoke$arity$1(G__57874));
if((G__57874__$1 == null)){
return null;
} else {
return G__57874__$1.stack;
}
})())){
return cljs.core.assoc.call(null,p1__57873_SHARP_,new cljs.core.Keyword(null,"stack","stack",-793405930),fulcro_spec.reporter.stack__GT_trace.call(null,new cljs.core.Keyword(null,"actual","actual",107306363).cljs$core$IFn$_invoke$arity$1(p1__57873_SHARP_).stack));
} else {
return p1__57873_SHARP_;
}
}).call(null,fulcro_spec.reporter.merge_in_diff_results.call(null,cljs.core.merge.call(null,t,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"id","id",-1388402092),fulcro_spec.reporter.new_uuid.call(null),new cljs.core.Keyword(null,"status","status",-1997798413),status,new cljs.core.Keyword(null,"where","where",-2044795965),cljs.test.testing_vars_str.call(null,t)], null)))),new cljs.core.Keyword(null,"actual","actual",107306363),fulcro_spec.reporter.fix_str),new cljs.core.Keyword(null,"expected","expected",1583670997),fulcro_spec.reporter.fix_str);
});
fulcro_spec.reporter.make_tests_by_namespace = (function fulcro_spec$reporter$make_tests_by_namespace(test_name){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"id","id",-1388402092),fulcro_spec.reporter.new_uuid.call(null),new cljs.core.Keyword(null,"name","name",1843675177),test_name,new cljs.core.Keyword(null,"test-items","test-items",1900391985),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"status","status",-1997798413),cljs.core.PersistentArrayMap.EMPTY], null);
});
fulcro_spec.reporter.set_test_result = (function fulcro_spec$reporter$set_test_result(p__57875,status){
var map__57876 = p__57875;
var map__57876__$1 = ((((!((map__57876 == null)))?((((map__57876.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57876.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57876):map__57876);
var state = cljs.core.get.call(null,map__57876__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var path = cljs.core.get.call(null,map__57876__$1,new cljs.core.Keyword(null,"path","path",-188191168));
var all_paths = cljs.core.sequence.call(null,cljs.core.comp.call(null,cljs.core.take_while.call(null,cljs.core.seq),cljs.core.map.call(null,cljs.core.vec)),cljs.core.iterate.call(null,cljs.core.partial.call(null,cljs.core.drop_last,(2)),cljs.core.deref.call(null,path)));
return cljs.core.swap_BANG_.call(null,state,((function (all_paths,map__57876,map__57876__$1,state,path){
return (function (state__$1){
return cljs.core.reduce.call(null,((function (all_paths,map__57876,map__57876__$1,state,path){
return (function (state__$2,path__$1){
return cljs.core.update_in.call(null,state__$2,cljs.core.conj.call(null,path__$1,new cljs.core.Keyword(null,"status","status",-1997798413),status),cljs.core.fnil.call(null,cljs.core.inc,(0)));
});})(all_paths,map__57876,map__57876__$1,state,path))
,state__$1,all_paths);
});})(all_paths,map__57876,map__57876__$1,state,path))
);
});
fulcro_spec.reporter.begin_STAR_ = (function fulcro_spec$reporter$begin_STAR_(p__57878,t){
var map__57879 = p__57878;
var map__57879__$1 = ((((!((map__57879 == null)))?((((map__57879.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57879.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57879):map__57879);
var state = cljs.core.get.call(null,map__57879__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var path = cljs.core.get.call(null,map__57879__$1,new cljs.core.Keyword(null,"path","path",-188191168));
var path__$1 = cljs.core.deref.call(null,path);
var test_item = fulcro_spec.reporter.make_testitem.call(null,t);
var test_items_count = cljs.core.count.call(null,cljs.core.get_in.call(null,cljs.core.deref.call(null,state),cljs.core.conj.call(null,path__$1,new cljs.core.Keyword(null,"test-items","test-items",1900391985))));
cljs.core.swap_BANG_.call(null,state,cljs.core.assoc_in,cljs.core.conj.call(null,path__$1,new cljs.core.Keyword(null,"test-items","test-items",1900391985),test_items_count),test_item);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [test_item,test_items_count], null);
});
fulcro_spec.reporter.get_namespace_location = (function fulcro_spec$reporter$get_namespace_location(namespaces,nsname){
var namespace_index = cljs.core.first.call(null,cljs.core.keep_indexed.call(null,(function (idx,val){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(val),nsname)){
return idx;
} else {
return null;
}
}),namespaces));
var or__28141__auto__ = namespace_index;
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
return cljs.core.count.call(null,namespaces);
}
});
fulcro_spec.reporter.inc_report_counter = (function fulcro_spec$reporter$inc_report_counter(type){
return cljs.test.inc_report_counter_BANG_.call(null,type);
});
fulcro_spec.reporter.failure_STAR_ = (function fulcro_spec$reporter$failure_STAR_(p__57881,t,failure_type){
var map__57882 = p__57881;
var map__57882__$1 = ((((!((map__57882 == null)))?((((map__57882.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57882.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57882):map__57882);
var this$ = map__57882__$1;
var state = cljs.core.get.call(null,map__57882__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var path = cljs.core.get.call(null,map__57882__$1,new cljs.core.Keyword(null,"path","path",-188191168));
fulcro_spec.reporter.inc_report_counter.call(null,failure_type);

var path__$1 = cljs.core.deref.call(null,path);
var map__57884 = cljs.core.get_in.call(null,cljs.core.deref.call(null,state),path__$1);
var map__57884__$1 = ((((!((map__57884 == null)))?((((map__57884.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57884.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57884):map__57884);
var test_results = cljs.core.get.call(null,map__57884__$1,new cljs.core.Keyword(null,"test-results","test-results",575566942));
var new_result = fulcro_spec.reporter.make_test_result.call(null,failure_type,t);
fulcro_spec.reporter.set_test_result.call(null,this$,failure_type);

cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,cljs.core.conj.call(null,path__$1,new cljs.core.Keyword(null,"test-results","test-results",575566942)),cljs.core.conj,new_result);

return new_result;
});
fulcro_spec.reporter.error = (function fulcro_spec$reporter$error(this$,t){
return fulcro_spec.reporter.failure_STAR_.call(null,this$,t,new cljs.core.Keyword(null,"error","error",-978969032));
});
fulcro_spec.reporter.fail = (function fulcro_spec$reporter$fail(this$,t){
return fulcro_spec.reporter.failure_STAR_.call(null,this$,t,new cljs.core.Keyword(null,"fail","fail",1706214930));
});
fulcro_spec.reporter.pass = (function fulcro_spec$reporter$pass(this$,t){
fulcro_spec.reporter.inc_report_counter.call(null,new cljs.core.Keyword(null,"pass","pass",1574159993));

return fulcro_spec.reporter.set_test_result.call(null,this$,new cljs.core.Keyword(null,"pass","pass",1574159993));
});
fulcro_spec.reporter.push_test_item_path = (function fulcro_spec$reporter$push_test_item_path(p__57886,test_item,index){
var map__57887 = p__57886;
var map__57887__$1 = ((((!((map__57887 == null)))?((((map__57887.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57887.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57887):map__57887);
var path = cljs.core.get.call(null,map__57887__$1,new cljs.core.Keyword(null,"path","path",-188191168));
return cljs.core.swap_BANG_.call(null,path,cljs.core.conj,new cljs.core.Keyword(null,"test-items","test-items",1900391985),index);
});
fulcro_spec.reporter.pop_test_item_path = (function fulcro_spec$reporter$pop_test_item_path(p__57889){
var map__57890 = p__57889;
var map__57890__$1 = ((((!((map__57890 == null)))?((((map__57890.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57890.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57890):map__57890);
var path = cljs.core.get.call(null,map__57890__$1,new cljs.core.Keyword(null,"path","path",-188191168));
return cljs.core.swap_BANG_.call(null,path,cljs.core.comp.call(null,cljs.core.pop,cljs.core.pop));
});
fulcro_spec.reporter.begin_namespace = (function fulcro_spec$reporter$begin_namespace(p__57892,t){
var map__57893 = p__57892;
var map__57893__$1 = ((((!((map__57893 == null)))?((((map__57893.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57893.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57893):map__57893);
var state = cljs.core.get.call(null,map__57893__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var path = cljs.core.get.call(null,map__57893__$1,new cljs.core.Keyword(null,"path","path",-188191168));
var test_name = cljs.core.ns_name.call(null,new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(t));
var namespaces = cljs.core.get_in.call(null,cljs.core.deref.call(null,state),cljs.core.conj.call(null,cljs.core.deref.call(null,path),new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469)));
var name_space_location = fulcro_spec.reporter.get_namespace_location.call(null,namespaces,test_name);
cljs.core.swap_BANG_.call(null,path,cljs.core.conj,new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),name_space_location);

return cljs.core.swap_BANG_.call(null,state,cljs.core.assoc_in,cljs.core.deref.call(null,path),fulcro_spec.reporter.make_tests_by_namespace.call(null,test_name));
});
fulcro_spec.reporter.end_namespace = (function fulcro_spec$reporter$end_namespace(this$,t){
return fulcro_spec.reporter.pop_test_item_path.call(null,this$);
});
fulcro_spec.reporter.begin_specification = (function fulcro_spec$reporter$begin_specification(this$,t){
return cljs.core.apply.call(null,fulcro_spec.reporter.push_test_item_path,this$,fulcro_spec.reporter.begin_STAR_.call(null,this$,t));
});
fulcro_spec.reporter.end_specification = (function fulcro_spec$reporter$end_specification(this$,t){
return fulcro_spec.reporter.pop_test_item_path.call(null,this$);
});
fulcro_spec.reporter.begin_behavior = (function fulcro_spec$reporter$begin_behavior(this$,t){
return cljs.core.apply.call(null,fulcro_spec.reporter.push_test_item_path,this$,fulcro_spec.reporter.begin_STAR_.call(null,this$,t));
});
fulcro_spec.reporter.end_behavior = (function fulcro_spec$reporter$end_behavior(this$,t){
return fulcro_spec.reporter.pop_test_item_path.call(null,this$);
});
fulcro_spec.reporter.begin_manual = (function fulcro_spec$reporter$begin_manual(this$,t){
return cljs.core.apply.call(null,fulcro_spec.reporter.push_test_item_path,this$,fulcro_spec.reporter.begin_STAR_.call(null,this$,t));
});
fulcro_spec.reporter.end_manual = (function fulcro_spec$reporter$end_manual(this$,t){
fulcro_spec.reporter.set_test_result.call(null,this$,new cljs.core.Keyword(null,"manual","manual",-237370608));

return fulcro_spec.reporter.pop_test_item_path.call(null,this$);
});
fulcro_spec.reporter.begin_provided = (function fulcro_spec$reporter$begin_provided(this$,t){
return cljs.core.apply.call(null,fulcro_spec.reporter.push_test_item_path,this$,fulcro_spec.reporter.begin_STAR_.call(null,this$,t));
});
fulcro_spec.reporter.end_provided = (function fulcro_spec$reporter$end_provided(this$,t){
return fulcro_spec.reporter.pop_test_item_path.call(null,this$);
});
fulcro_spec.reporter.summary = (function fulcro_spec$reporter$summary(p__57895,t){
var map__57896 = p__57895;
var map__57896__$1 = ((((!((map__57896 == null)))?((((map__57896.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57896.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57896):map__57896);
var state = cljs.core.get.call(null,map__57896__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var end_time_57901 = fulcro_spec.reporter.now_time.call(null);
var end_date_57902 = (new goog.date.Date()).getTime();
cljs.core.swap_BANG_.call(null,state,((function (end_time_57901,end_date_57902,map__57896,map__57896__$1,state){
return (function (p__57898){
var map__57899 = p__57898;
var map__57899__$1 = ((((!((map__57899 == null)))?((((map__57899.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57899.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57899):map__57899);
var st = map__57899__$1;
var start_time = cljs.core.get.call(null,map__57899__$1,new cljs.core.Keyword(null,"start-time","start-time",814801386));
return cljs.core.assoc.call(null,cljs.core.assoc.call(null,st,new cljs.core.Keyword(null,"end-time","end-time",-1849817460),end_date_57902),new cljs.core.Keyword(null,"run-time","run-time",-1231674133),(end_time_57901 - start_time));
});})(end_time_57901,end_date_57902,map__57896,map__57896__$1,state))
);

return cljs.core.swap_BANG_.call(null,state,cljs.core.merge,t);
});
fulcro_spec.reporter.reset_test_report_BANG_ = (function fulcro_spec$reporter$reset_test_report_BANG_(p__57903){
var map__57904 = p__57903;
var map__57904__$1 = ((((!((map__57904 == null)))?((((map__57904.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57904.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57904):map__57904);
var state = cljs.core.get.call(null,map__57904__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var path = cljs.core.get.call(null,map__57904__$1,new cljs.core.Keyword(null,"path","path",-188191168));
cljs.core.reset_BANG_.call(null,state,fulcro_spec.reporter.make_testreport.call(null));

return cljs.core.reset_BANG_.call(null,path,cljs.core.PersistentVector.EMPTY);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {com.stuartsierra.component.Lifecycle}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fulcro_spec.reporter.TestReporter = (function (state,path,__meta,__extmap,__hash){
this.state = state;
this.path = path;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});

fulcro_spec.reporter.TestReporter.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__28781__auto__,k__28782__auto__){
var self__ = this;
var this__28781__auto____$1 = this;
return this__28781__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__28782__auto__,null);
});


fulcro_spec.reporter.TestReporter.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__28783__auto__,k57907,else__28784__auto__){
var self__ = this;
var this__28783__auto____$1 = this;
var G__57911 = k57907;
var G__57911__$1 = (((G__57911 instanceof cljs.core.Keyword))?G__57911.fqn:null);
switch (G__57911__$1) {
case "state":
return self__.state;

break;
case "path":
return self__.path;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k57907,else__28784__auto__);

}
});


fulcro_spec.reporter.TestReporter.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__28795__auto__,writer__28796__auto__,opts__28797__auto__){
var self__ = this;
var this__28795__auto____$1 = this;
var pr_pair__28798__auto__ = ((function (this__28795__auto____$1){
return (function (keyval__28799__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__28796__auto__,cljs.core.pr_writer,""," ","",opts__28797__auto__,keyval__28799__auto__);
});})(this__28795__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__28796__auto__,pr_pair__28798__auto__,"#fulcro-spec.reporter.TestReporter{",", ","}",opts__28797__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"path","path",-188191168),self__.path],null))], null),self__.__extmap));
});


fulcro_spec.reporter.TestReporter.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__57906){
var self__ = this;
var G__57906__$1 = this;
return (new cljs.core.RecordIter((0),G__57906__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"path","path",-188191168)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});


fulcro_spec.reporter.TestReporter.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__28779__auto__){
var self__ = this;
var this__28779__auto____$1 = this;
return self__.__meta;
});


fulcro_spec.reporter.TestReporter.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__28776__auto__){
var self__ = this;
var this__28776__auto____$1 = this;
return (new fulcro_spec.reporter.TestReporter(self__.state,self__.path,self__.__meta,self__.__extmap,self__.__hash));
});


fulcro_spec.reporter.TestReporter.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__28785__auto__){
var self__ = this;
var this__28785__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});


fulcro_spec.reporter.TestReporter.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__28777__auto__){
var self__ = this;
var this__28777__auto____$1 = this;
var h__28595__auto__ = self__.__hash;
if(!((h__28595__auto__ == null))){
return h__28595__auto__;
} else {
var h__28595__auto____$1 = ((function (h__28595__auto__,this__28777__auto____$1){
return (function (coll__28778__auto__){
return (-1689211372 ^ cljs.core.hash_unordered_coll.call(null,coll__28778__auto__));
});})(h__28595__auto__,this__28777__auto____$1))
.call(null,this__28777__auto____$1);
self__.__hash = h__28595__auto____$1;

return h__28595__auto____$1;
}
});


fulcro_spec.reporter.TestReporter.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this57908,other57909){
var self__ = this;
var this57908__$1 = this;
return (!((other57909 == null))) && ((this57908__$1.constructor === other57909.constructor)) && (cljs.core._EQ_.call(null,this57908__$1.state,other57909.state)) && (cljs.core._EQ_.call(null,this57908__$1.path,other57909.path)) && (cljs.core._EQ_.call(null,this57908__$1.__extmap,other57909.__extmap));
});


fulcro_spec.reporter.TestReporter.prototype.com$stuartsierra$component$Lifecycle$ = cljs.core.PROTOCOL_SENTINEL;


fulcro_spec.reporter.TestReporter.prototype.com$stuartsierra$component$Lifecycle$start$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});


fulcro_spec.reporter.TestReporter.prototype.com$stuartsierra$component$Lifecycle$stop$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
fulcro_spec.reporter.reset_test_report_BANG_.call(null,this$__$1);

return this$__$1;
});


fulcro_spec.reporter.TestReporter.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__28790__auto__,k__28791__auto__){
var self__ = this;
var this__28790__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),null,new cljs.core.Keyword(null,"state","state",-1988618099),null], null), null),k__28791__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__28790__auto____$1),self__.__meta),k__28791__auto__);
} else {
return (new fulcro_spec.reporter.TestReporter(self__.state,self__.path,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__28791__auto__)),null));
}
});


fulcro_spec.reporter.TestReporter.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__28788__auto__,k__28789__auto__,G__57906){
var self__ = this;
var this__28788__auto____$1 = this;
var pred__57912 = cljs.core.keyword_identical_QMARK_;
var expr__57913 = k__28789__auto__;
if(cljs.core.truth_(pred__57912.call(null,new cljs.core.Keyword(null,"state","state",-1988618099),expr__57913))){
return (new fulcro_spec.reporter.TestReporter(G__57906,self__.path,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__57912.call(null,new cljs.core.Keyword(null,"path","path",-188191168),expr__57913))){
return (new fulcro_spec.reporter.TestReporter(self__.state,G__57906,self__.__meta,self__.__extmap,null));
} else {
return (new fulcro_spec.reporter.TestReporter(self__.state,self__.path,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__28789__auto__,G__57906),null));
}
}
});


fulcro_spec.reporter.TestReporter.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__28793__auto__){
var self__ = this;
var this__28793__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"path","path",-188191168),self__.path],null))], null),self__.__extmap));
});


fulcro_spec.reporter.TestReporter.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__28780__auto__,G__57906){
var self__ = this;
var this__28780__auto____$1 = this;
return (new fulcro_spec.reporter.TestReporter(self__.state,self__.path,G__57906,self__.__extmap,self__.__hash));
});


fulcro_spec.reporter.TestReporter.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__28786__auto__,entry__28787__auto__){
var self__ = this;
var this__28786__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__28787__auto__)){
return this__28786__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__28787__auto__,(0)),cljs.core._nth.call(null,entry__28787__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__28786__auto____$1,entry__28787__auto__);
}
});

fulcro_spec.reporter.TestReporter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null);
});

fulcro_spec.reporter.TestReporter.cljs$lang$type = true;

fulcro_spec.reporter.TestReporter.cljs$lang$ctorPrSeq = (function (this__28817__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"fulcro-spec.reporter/TestReporter");
});

fulcro_spec.reporter.TestReporter.cljs$lang$ctorPrWriter = (function (this__28817__auto__,writer__28818__auto__){
return cljs.core._write.call(null,writer__28818__auto__,"fulcro-spec.reporter/TestReporter");
});

fulcro_spec.reporter.__GT_TestReporter = (function fulcro_spec$reporter$__GT_TestReporter(state,path){
return (new fulcro_spec.reporter.TestReporter(state,path,null,null,null));
});

fulcro_spec.reporter.map__GT_TestReporter = (function fulcro_spec$reporter$map__GT_TestReporter(G__57910){
return (new fulcro_spec.reporter.TestReporter(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__57910),new cljs.core.Keyword(null,"path","path",-188191168).cljs$core$IFn$_invoke$arity$1(G__57910),null,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,G__57910,new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"path","path",-188191168))),null));
});

/**
 * Just a shell to contain minimum state necessary for reporting
 */
fulcro_spec.reporter.make_test_reporter = (function fulcro_spec$reporter$make_test_reporter(){
return fulcro_spec.reporter.map__GT_TestReporter.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"state","state",-1988618099),cljs.core.atom.call(null,fulcro_spec.reporter.make_testreport.call(null)),new cljs.core.Keyword(null,"path","path",-188191168),cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY)], null));
});
fulcro_spec.reporter.get_test_report = (function fulcro_spec$reporter$get_test_report(reporter){
return cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(reporter));
});
fulcro_spec.reporter.fulcro_report = (function fulcro_spec$reporter$fulcro_report(p__57916,on_complete){
var map__57917 = p__57916;
var map__57917__$1 = ((((!((map__57917 == null)))?((((map__57917.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57917.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57917):map__57917);
var system = map__57917__$1;
var reporter = cljs.core.get.call(null,map__57917__$1,new cljs.core.Keyword("test","reporter","test/reporter",-867863647));
return ((function (map__57917,map__57917__$1,system,reporter){
return (function (t){
var G__57919 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(t);
var G__57919__$1 = (((G__57919 instanceof cljs.core.Keyword))?G__57919.fqn:null);
switch (G__57919__$1) {
case "pass":
return fulcro_spec.reporter.pass.call(null,reporter,t);

break;
case "error":
return fulcro_spec.reporter.error.call(null,reporter,t);

break;
case "fail":
return fulcro_spec.reporter.fail.call(null,reporter,t);

break;
case "begin-test-ns":
return fulcro_spec.reporter.begin_namespace.call(null,reporter,t);

break;
case "end-test-ns":
return fulcro_spec.reporter.end_namespace.call(null,reporter,t);

break;
case "begin-specification":
return fulcro_spec.reporter.begin_specification.call(null,reporter,t);

break;
case "end-specification":
return fulcro_spec.reporter.end_specification.call(null,reporter,t);

break;
case "begin-behavior":
return fulcro_spec.reporter.begin_behavior.call(null,reporter,t);

break;
case "end-behavior":
return fulcro_spec.reporter.end_behavior.call(null,reporter,t);

break;
case "begin-manual":
return fulcro_spec.reporter.begin_manual.call(null,reporter,t);

break;
case "end-manual":
return fulcro_spec.reporter.end_manual.call(null,reporter,t);

break;
case "begin-provided":
return fulcro_spec.reporter.begin_provided.call(null,reporter,t);

break;
case "end-provided":
return fulcro_spec.reporter.end_provided.call(null,reporter,t);

break;
case "summary":
return fulcro_spec.reporter.summary.call(null,reporter,t);

break;
case "end-run-tests":
return on_complete.call(null,system);

break;
default:
return null;

}
});
;})(map__57917,map__57917__$1,system,reporter))
});

//# sourceMappingURL=reporter.js.map?rel=1511404503081
