// Compiled by ClojureScript 1.9.946 {}
goog.provide('fulcro_spec.renderer');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cognitect.transit');
goog.require('goog.string');
goog.require('com.stuartsierra.component');
goog.require('goog.dom');
goog.require('om.dom');
goog.require('om.next');
goog.require('pushy.core');
goog.require('fulcro.client.core');
goog.require('fulcro.client.data_fetch');
goog.require('fulcro.client.network');
goog.require('fulcro.client.mutations');
goog.require('fulcro_spec.dom.edn_renderer');
goog.require('fulcro_spec.diff');
goog.require('fulcro_spec.selectors');
goog.require('fulcro.websockets.networking');
goog.require('goog.date.DateTime');
goog.require('goog.i18n.DateTimeFormat');
cljs.core.enable_console_print_BANG_.call(null);
fulcro_spec.renderer.test_item_class = (function fulcro_spec$renderer$test_item_class(p__56219){
var map__56220 = p__56219;
var map__56220__$1 = ((((!((map__56220 == null)))?((((map__56220.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56220.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56220):map__56220);
var fail = cljs.core.get.call(null,map__56220__$1,new cljs.core.Keyword(null,"fail","fail",1706214930));
var error = cljs.core.get.call(null,map__56220__$1,new cljs.core.Keyword(null,"error","error",-978969032));
var pass = cljs.core.get.call(null,map__56220__$1,new cljs.core.Keyword(null,"pass","pass",1574159993));
var manual = cljs.core.get.call(null,map__56220__$1,new cljs.core.Keyword(null,"manual","manual",-237370608));
return ["test-",cljs.core.str.cljs$core$IFn$_invoke$arity$1((((fail > (0)))?"fail":(((error > (0)))?"error":(((pass > (0)))?"pass":(((manual > (0)))?"manual":"pending"
)))))].join('');
});
fulcro_spec.renderer.color_favicon_data_url = (function fulcro_spec$renderer$color_favicon_data_url(color){
var cvs = document.createElement("canvas");
cvs.width = (16);

cvs.height = (16);

var ctx_56222 = cvs.getContext("2d");
ctx_56222.fillStyle = color;

ctx_56222.fillRect((0),(0),(16),(16));

return cvs.toDataURL();
});
fulcro_spec.renderer.change_favicon_to_color = (function fulcro_spec$renderer$change_favicon_to_color(color){
var favicon = document.getElementById("favicon");
return favicon.href = fulcro_spec.renderer.color_favicon_data_url.call(null,color);
});
fulcro_spec.renderer.has_status_QMARK_ = (function fulcro_spec$renderer$has_status_QMARK_(p){
return (function fulcro_spec$renderer$has_status_QMARK__$_has_status_QMARK__STAR_(x){
var or__28141__auto__ = p.call(null,new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(x));
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
return (cljs.core.seq.call(null,new cljs.core.Keyword(null,"test-items","test-items",1900391985).cljs$core$IFn$_invoke$arity$1(x))) && (cljs.core.seq.call(null,cljs.core.filter.call(null,fulcro_spec$renderer$has_status_QMARK__$_has_status_QMARK__STAR_,new cljs.core.Keyword(null,"test-items","test-items",1900391985).cljs$core$IFn$_invoke$arity$1(x))));
}
});
});
fulcro_spec.renderer.filters = (function (){var report_as = (function (status){
return (function (p1__56223_SHARP_){
return cljs.core.update.call(null,p1__56223_SHARP_,new cljs.core.Keyword(null,"status","status",-1997798413),cljs.core.select_keys,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [status], null));
});
});
var no_test_results = ((function (report_as){
return (function (p1__56224_SHARP_){
return cljs.core.dissoc.call(null,p1__56224_SHARP_,new cljs.core.Keyword(null,"test-results","test-results",575566942));
});})(report_as))
;
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"all","all",892129742),cljs.core.map.call(null,cljs.core.identity),null,cljs.core.map.call(null,cljs.core.identity),new cljs.core.Keyword(null,"failing","failing",-324520682),cljs.core.filter.call(null,cljs.core.comp.call(null,((function (report_as,no_test_results){
return (function (p1__56225_SHARP_){
return cljs.core.some.call(null,cljs.core.pos_QMARK_,p1__56225_SHARP_);
});})(report_as,no_test_results))
,cljs.core.juxt.call(null,new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"error","error",-978969032)),new cljs.core.Keyword(null,"status","status",-1997798413))),new cljs.core.Keyword(null,"manual","manual",-237370608),cljs.core.comp.call(null,cljs.core.filter.call(null,fulcro_spec.renderer.has_status_QMARK_.call(null,((function (report_as,no_test_results){
return (function (p1__56226_SHARP_){
return (new cljs.core.Keyword(null,"manual","manual",-237370608).cljs$core$IFn$_invoke$arity$1(p1__56226_SHARP_) > (0));
});})(report_as,no_test_results))
)),cljs.core.map.call(null,no_test_results),cljs.core.map.call(null,report_as.call(null,new cljs.core.Keyword(null,"manual","manual",-237370608)))),new cljs.core.Keyword(null,"passing","passing",154799600),cljs.core.comp.call(null,cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.pos_QMARK_,new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"status","status",-1997798413))),cljs.core.map.call(null,report_as.call(null,new cljs.core.Keyword(null,"pass","pass",1574159993)))),new cljs.core.Keyword(null,"pending","pending",-220036727),cljs.core.comp.call(null,cljs.core.filter.call(null,fulcro_spec.renderer.has_status_QMARK_.call(null,((function (report_as,no_test_results){
return (function (p1__56227_SHARP_){
return (cljs.core.apply.call(null,cljs.core._PLUS_,cljs.core.vals.call(null,p1__56227_SHARP_)) === (0));
});})(report_as,no_test_results))
)),cljs.core.map.call(null,no_test_results),cljs.core.map.call(null,report_as.call(null,new cljs.core.Keyword(null,"pending","pending",-220036727))))], null);
})();
if(typeof fulcro_spec.renderer.Foldable !== 'undefined'){
} else {
/**
 * @constructor
 */
fulcro_spec.renderer.Foldable = (function fulcro_spec$renderer$Foldable(){
var this__38954__auto__ = this;
React.Component.apply(this__38954__auto__,arguments);

if(!((this__38954__auto__.initLocalState == null))){
this__38954__auto__.state = this__38954__auto__.initLocalState();
} else {
this__38954__auto__.state = {};
}

return this__38954__auto__;
});

fulcro_spec.renderer.Foldable.prototype = goog.object.clone(React.Component.prototype);
}

var x56230_56248 = fulcro_spec.renderer.Foldable.prototype;
x56230_56248.componentWillUpdate = ((function (x56230_56248){
return (function (next_props__38842__auto__,next_state__38843__auto__){
var this__38841__auto__ = this;
if(((!((this__38841__auto__ == null)))?(((false) || ((cljs.core.PROTOCOL_SENTINEL === this__38841__auto__.om$next$Ident$)))?true:false):false)){
var ident__38845__auto___56249 = om.next.ident.call(null,this__38841__auto__,om.next.props.call(null,this__38841__auto__));
var next_ident__38846__auto___56250 = om.next.ident.call(null,this__38841__auto__,om.next._next_props.call(null,next_props__38842__auto__,this__38841__auto__));
if(cljs.core.not_EQ_.call(null,ident__38845__auto___56249,next_ident__38846__auto___56250)){
var idxr__38847__auto___56251 = cljs.core.get_in.call(null,om.next.get_reconciler.call(null,this__38841__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
if((idxr__38847__auto___56251 == null)){
} else {
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"indexes","indexes",1496475545).cljs$core$IFn$_invoke$arity$1(idxr__38847__auto___56251),((function (idxr__38847__auto___56251,ident__38845__auto___56249,next_ident__38846__auto___56250,this__38841__auto__,x56230_56248){
return (function (indexes__38848__auto__){
return cljs.core.update_in.call(null,cljs.core.update_in.call(null,indexes__38848__auto__,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ref->components","ref->components",-303587249),ident__38845__auto___56249], null),cljs.core.disj,this__38841__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ref->components","ref->components",-303587249),next_ident__38846__auto___56250], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentHashSet.EMPTY),this__38841__auto__);
});})(idxr__38847__auto___56251,ident__38845__auto___56249,next_ident__38846__auto___56250,this__38841__auto__,x56230_56248))
);
}
} else {
}
} else {
}

om.next.merge_pending_props_BANG_.call(null,this__38841__auto__);

return om.next.merge_pending_state_BANG_.call(null,this__38841__auto__);
});})(x56230_56248))
;

x56230_56248.shouldComponentUpdate = ((function (x56230_56248){
return (function (next_props__38842__auto__,next_state__38843__auto__){
var this__38841__auto__ = this;
var next_children__38844__auto__ = next_props__38842__auto__.children;
var next_props__38842__auto____$1 = goog.object.get(next_props__38842__auto__,"omcljs$value");
var next_props__38842__auto____$2 = (function (){var G__56232 = next_props__38842__auto____$1;
if((next_props__38842__auto____$1 instanceof om.next.OmProps)){
return om.next.unwrap.call(null,G__56232);
} else {
return G__56232;
}
})();
var or__28141__auto__ = cljs.core.not_EQ_.call(null,om.next.props.call(null,this__38841__auto__),next_props__38842__auto____$2);
if(or__28141__auto__){
return or__28141__auto__;
} else {
var or__28141__auto____$1 = (function (){var and__28129__auto__ = this__38841__auto__.state;
if(cljs.core.truth_(and__28129__auto__)){
return cljs.core.not_EQ_.call(null,goog.object.get(this__38841__auto__.state,"omcljs$state"),goog.object.get(next_state__38843__auto__,"omcljs$state"));
} else {
return and__28129__auto__;
}
})();
if(cljs.core.truth_(or__28141__auto____$1)){
return or__28141__auto____$1;
} else {
return cljs.core.not_EQ_.call(null,this__38841__auto__.props.children,next_children__38844__auto__);
}
}
});})(x56230_56248))
;

x56230_56248.componentWillUnmount = ((function (x56230_56248){
return (function (){
var this__38841__auto__ = this;
var r__38852__auto__ = om.next.get_reconciler.call(null,this__38841__auto__);
var cfg__38853__auto__ = new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(r__38852__auto__);
var st__38854__auto__ = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(cfg__38853__auto__);
var indexer__38851__auto__ = new cljs.core.Keyword(null,"indexer","indexer",-1774914315).cljs$core$IFn$_invoke$arity$1(cfg__38853__auto__);
if(cljs.core.truth_((function (){var and__28129__auto__ = !((st__38854__auto__ == null));
if(and__28129__auto__){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,st__38854__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("om.next","queries","om.next/queries",-22717146),this__38841__auto__], null));
} else {
return and__28129__auto__;
}
})())){
cljs.core.swap_BANG_.call(null,st__38854__auto__,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("om.next","queries","om.next/queries",-22717146)], null),cljs.core.dissoc,this__38841__auto__);
} else {
}

if((indexer__38851__auto__ == null)){
return null;
} else {
return om.next.protocols.drop_component_BANG_.call(null,indexer__38851__auto__,this__38841__auto__);
}
});})(x56230_56248))
;

x56230_56248.componentDidUpdate = ((function (x56230_56248){
return (function (prev_props__38849__auto__,prev_state__38850__auto__){
var this__38841__auto__ = this;
return om.next.clear_prev_props_BANG_.call(null,this__38841__auto__);
});})(x56230_56248))
;

x56230_56248.isMounted = ((function (x56230_56248){
return (function (){
var this__38841__auto__ = this;
return cljs.core.boolean$.call(null,goog.object.getValueByKeys(this__38841__auto__,"_reactInternalInstance","_renderedComponent"));
});})(x56230_56248))
;

x56230_56248.componentWillMount = ((function (x56230_56248){
return (function (){
var this__38841__auto__ = this;
var indexer__38851__auto__ = cljs.core.get_in.call(null,om.next.get_reconciler.call(null,this__38841__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
if((indexer__38851__auto__ == null)){
return null;
} else {
return om.next.protocols.index_component_BANG_.call(null,indexer__38851__auto__,this__38841__auto__);
}
});})(x56230_56248))
;

x56230_56248.initLocalState = ((function (x56230_56248){
return (function (){
var this$ = this;
var ret__38819__auto__ = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"folded?","folded?",1971930715),true], null);
var obj56234 = {"omcljs$state":ret__38819__auto__};
return obj56234;
});})(x56230_56248))
;

x56230_56248.render = ((function (x56230_56248){
return (function (){
var this__38840__auto__ = this;
var this$ = this__38840__auto__;
var _STAR_reconciler_STAR_56235 = om.next._STAR_reconciler_STAR_;
var _STAR_depth_STAR_56236 = om.next._STAR_depth_STAR_;
var _STAR_shared_STAR_56237 = om.next._STAR_shared_STAR_;
var _STAR_instrument_STAR_56238 = om.next._STAR_instrument_STAR_;
var _STAR_parent_STAR_56239 = om.next._STAR_parent_STAR_;
om.next._STAR_reconciler_STAR_ = om.next.get_reconciler.call(null,this__38840__auto__);

om.next._STAR_depth_STAR_ = (om.next.depth.call(null,this__38840__auto__) + (1));

om.next._STAR_shared_STAR_ = om.next.shared.call(null,this__38840__auto__);

om.next._STAR_instrument_STAR_ = om.next.instrument.call(null,this__38840__auto__);

om.next._STAR_parent_STAR_ = this__38840__auto__;

try{var map__56240 = om.next.get_state.call(null,this$);
var map__56240__$1 = ((((!((map__56240 == null)))?((((map__56240.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56240.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56240):map__56240);
var folded_QMARK_ = cljs.core.get.call(null,map__56240__$1,new cljs.core.Keyword(null,"folded?","folded?",1971930715));
var map__56241 = om.next.props.call(null,this$);
var map__56241__$1 = ((((!((map__56241 == null)))?((((map__56241.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56241.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56241):map__56241);
var render = cljs.core.get.call(null,map__56241__$1,new cljs.core.Keyword(null,"render","render",-1408033454));
var map__56242 = render.call(null,folded_QMARK_);
var map__56242__$1 = ((((!((map__56242 == null)))?((((map__56242.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56242.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56242):map__56242);
var title = cljs.core.get.call(null,map__56242__$1,new cljs.core.Keyword(null,"title","title",636505583));
var value = cljs.core.get.call(null,map__56242__$1,new cljs.core.Keyword(null,"value","value",305978217));
var classes = cljs.core.get.call(null,map__56242__$1,new cljs.core.Keyword(null,"classes","classes",2037804510));
return om.dom.div.call(null,({"className": "foldable"}),om.dom.a.call(null,({"className": classes, "onClick": ((function (map__56240,map__56240__$1,folded_QMARK_,map__56241,map__56241__$1,render,map__56242,map__56242__$1,title,value,classes,_STAR_reconciler_STAR_56235,_STAR_depth_STAR_56236,_STAR_shared_STAR_56237,_STAR_instrument_STAR_56238,_STAR_parent_STAR_56239,this$,this__38840__auto__,x56230_56248){
return (function (){
return om.next.update_state_BANG_.call(null,this$,cljs.core.update,new cljs.core.Keyword(null,"folded?","folded?",1971930715),cljs.core.not);
});})(map__56240,map__56240__$1,folded_QMARK_,map__56241,map__56241__$1,render,map__56242,map__56242__$1,title,value,classes,_STAR_reconciler_STAR_56235,_STAR_depth_STAR_56236,_STAR_shared_STAR_56237,_STAR_instrument_STAR_56238,_STAR_parent_STAR_56239,this$,this__38840__auto__,x56230_56248))
}),(cljs.core.truth_(folded_QMARK_)?"\u25BA":"\u25BC"),(cljs.core.truth_(folded_QMARK_)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.apply.call(null,cljs.core.str,cljs.core.take.call(null,(40),title))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(((((40) < cljs.core.count.call(null,title)))?"...":null))].join(''):[cljs.core.str.cljs$core$IFn$_invoke$arity$1(title)].join(''))),om.dom.div.call(null,({"className": (cljs.core.truth_(folded_QMARK_)?"hidden":null)}),value));
}finally {om.next._STAR_parent_STAR_ = _STAR_parent_STAR_56239;

om.next._STAR_instrument_STAR_ = _STAR_instrument_STAR_56238;

om.next._STAR_shared_STAR_ = _STAR_shared_STAR_56237;

om.next._STAR_depth_STAR_ = _STAR_depth_STAR_56236;

om.next._STAR_reconciler_STAR_ = _STAR_reconciler_STAR_56235;
}});})(x56230_56248))
;


fulcro_spec.renderer.Foldable.prototype.constructor = fulcro_spec.renderer.Foldable;

fulcro_spec.renderer.Foldable.prototype.constructor.displayName = "fulcro-spec.renderer/Foldable";

fulcro_spec.renderer.Foldable.prototype.om$isComponent = true;

var x56246_56252 = fulcro_spec.renderer.Foldable;


var x56247_56253 = fulcro_spec.renderer.Foldable.prototype;


fulcro_spec.renderer.Foldable.cljs$lang$type = true;

fulcro_spec.renderer.Foldable.cljs$lang$ctorStr = "fulcro-spec.renderer/Foldable";

fulcro_spec.renderer.Foldable.cljs$lang$ctorPrWriter = (function (this__38957__auto__,writer__38958__auto__,opt__38959__auto__){
return cljs.core._write.call(null,writer__38958__auto__,"fulcro-spec.renderer/Foldable");
});
fulcro_spec.renderer.ui_foldable = om.next.factory.call(null,fulcro_spec.renderer.Foldable,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"keyfn","keyfn",780060332),(function (){
return cljs.core.gensym.call(null,"foldable");
})], null));
if(typeof fulcro_spec.renderer.ResultLine !== 'undefined'){
} else {
/**
 * @constructor
 */
fulcro_spec.renderer.ResultLine = (function fulcro_spec$renderer$ResultLine(){
var this__38954__auto__ = this;
React.Component.apply(this__38954__auto__,arguments);

if(!((this__38954__auto__.initLocalState == null))){
this__38954__auto__.state = this__38954__auto__.initLocalState();
} else {
this__38954__auto__.state = {};
}

return this__38954__auto__;
});

fulcro_spec.renderer.ResultLine.prototype = goog.object.clone(React.Component.prototype);
}

var x56256_56268 = fulcro_spec.renderer.ResultLine.prototype;
x56256_56268.componentWillUpdate = ((function (x56256_56268){
return (function (next_props__38842__auto__,next_state__38843__auto__){
var this__38841__auto__ = this;
if(((!((this__38841__auto__ == null)))?(((false) || ((cljs.core.PROTOCOL_SENTINEL === this__38841__auto__.om$next$Ident$)))?true:false):false)){
var ident__38845__auto___56269 = om.next.ident.call(null,this__38841__auto__,om.next.props.call(null,this__38841__auto__));
var next_ident__38846__auto___56270 = om.next.ident.call(null,this__38841__auto__,om.next._next_props.call(null,next_props__38842__auto__,this__38841__auto__));
if(cljs.core.not_EQ_.call(null,ident__38845__auto___56269,next_ident__38846__auto___56270)){
var idxr__38847__auto___56271 = cljs.core.get_in.call(null,om.next.get_reconciler.call(null,this__38841__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
if((idxr__38847__auto___56271 == null)){
} else {
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"indexes","indexes",1496475545).cljs$core$IFn$_invoke$arity$1(idxr__38847__auto___56271),((function (idxr__38847__auto___56271,ident__38845__auto___56269,next_ident__38846__auto___56270,this__38841__auto__,x56256_56268){
return (function (indexes__38848__auto__){
return cljs.core.update_in.call(null,cljs.core.update_in.call(null,indexes__38848__auto__,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ref->components","ref->components",-303587249),ident__38845__auto___56269], null),cljs.core.disj,this__38841__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ref->components","ref->components",-303587249),next_ident__38846__auto___56270], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentHashSet.EMPTY),this__38841__auto__);
});})(idxr__38847__auto___56271,ident__38845__auto___56269,next_ident__38846__auto___56270,this__38841__auto__,x56256_56268))
);
}
} else {
}
} else {
}

om.next.merge_pending_props_BANG_.call(null,this__38841__auto__);

return om.next.merge_pending_state_BANG_.call(null,this__38841__auto__);
});})(x56256_56268))
;

x56256_56268.shouldComponentUpdate = ((function (x56256_56268){
return (function (next_props__38842__auto__,next_state__38843__auto__){
var this__38841__auto__ = this;
var next_children__38844__auto__ = next_props__38842__auto__.children;
var next_props__38842__auto____$1 = goog.object.get(next_props__38842__auto__,"omcljs$value");
var next_props__38842__auto____$2 = (function (){var G__56258 = next_props__38842__auto____$1;
if((next_props__38842__auto____$1 instanceof om.next.OmProps)){
return om.next.unwrap.call(null,G__56258);
} else {
return G__56258;
}
})();
var or__28141__auto__ = cljs.core.not_EQ_.call(null,om.next.props.call(null,this__38841__auto__),next_props__38842__auto____$2);
if(or__28141__auto__){
return or__28141__auto__;
} else {
var or__28141__auto____$1 = (function (){var and__28129__auto__ = this__38841__auto__.state;
if(cljs.core.truth_(and__28129__auto__)){
return cljs.core.not_EQ_.call(null,goog.object.get(this__38841__auto__.state,"omcljs$state"),goog.object.get(next_state__38843__auto__,"omcljs$state"));
} else {
return and__28129__auto__;
}
})();
if(cljs.core.truth_(or__28141__auto____$1)){
return or__28141__auto____$1;
} else {
return cljs.core.not_EQ_.call(null,this__38841__auto__.props.children,next_children__38844__auto__);
}
}
});})(x56256_56268))
;

x56256_56268.componentWillUnmount = ((function (x56256_56268){
return (function (){
var this__38841__auto__ = this;
var r__38852__auto__ = om.next.get_reconciler.call(null,this__38841__auto__);
var cfg__38853__auto__ = new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(r__38852__auto__);
var st__38854__auto__ = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(cfg__38853__auto__);
var indexer__38851__auto__ = new cljs.core.Keyword(null,"indexer","indexer",-1774914315).cljs$core$IFn$_invoke$arity$1(cfg__38853__auto__);
if(cljs.core.truth_((function (){var and__28129__auto__ = !((st__38854__auto__ == null));
if(and__28129__auto__){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,st__38854__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("om.next","queries","om.next/queries",-22717146),this__38841__auto__], null));
} else {
return and__28129__auto__;
}
})())){
cljs.core.swap_BANG_.call(null,st__38854__auto__,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("om.next","queries","om.next/queries",-22717146)], null),cljs.core.dissoc,this__38841__auto__);
} else {
}

if((indexer__38851__auto__ == null)){
return null;
} else {
return om.next.protocols.drop_component_BANG_.call(null,indexer__38851__auto__,this__38841__auto__);
}
});})(x56256_56268))
;

x56256_56268.componentDidUpdate = ((function (x56256_56268){
return (function (prev_props__38849__auto__,prev_state__38850__auto__){
var this__38841__auto__ = this;
return om.next.clear_prev_props_BANG_.call(null,this__38841__auto__);
});})(x56256_56268))
;

x56256_56268.isMounted = ((function (x56256_56268){
return (function (){
var this__38841__auto__ = this;
return cljs.core.boolean$.call(null,goog.object.getValueByKeys(this__38841__auto__,"_reactInternalInstance","_renderedComponent"));
});})(x56256_56268))
;

x56256_56268.componentWillMount = ((function (x56256_56268){
return (function (){
var this__38841__auto__ = this;
var indexer__38851__auto__ = cljs.core.get_in.call(null,om.next.get_reconciler.call(null,this__38841__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
if((indexer__38851__auto__ == null)){
return null;
} else {
return om.next.protocols.index_component_BANG_.call(null,indexer__38851__auto__,this__38841__auto__);
}
});})(x56256_56268))
;

x56256_56268.render = ((function (x56256_56268){
return (function (){
var this__38840__auto__ = this;
var this$ = this__38840__auto__;
var _STAR_reconciler_STAR_56259 = om.next._STAR_reconciler_STAR_;
var _STAR_depth_STAR_56260 = om.next._STAR_depth_STAR_;
var _STAR_shared_STAR_56261 = om.next._STAR_shared_STAR_;
var _STAR_instrument_STAR_56262 = om.next._STAR_instrument_STAR_;
var _STAR_parent_STAR_56263 = om.next._STAR_parent_STAR_;
om.next._STAR_reconciler_STAR_ = om.next.get_reconciler.call(null,this__38840__auto__);

om.next._STAR_depth_STAR_ = (om.next.depth.call(null,this__38840__auto__) + (1));

om.next._STAR_shared_STAR_ = om.next.shared.call(null,this__38840__auto__);

om.next._STAR_instrument_STAR_ = om.next.instrument.call(null,this__38840__auto__);

om.next._STAR_parent_STAR_ = this__38840__auto__;

try{var map__56264 = om.next.props.call(null,this$);
var map__56264__$1 = ((((!((map__56264 == null)))?((((map__56264.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56264.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56264):map__56264);
var title = cljs.core.get.call(null,map__56264__$1,new cljs.core.Keyword(null,"title","title",636505583));
var value = cljs.core.get.call(null,map__56264__$1,new cljs.core.Keyword(null,"value","value",305978217));
var stack = cljs.core.get.call(null,map__56264__$1,new cljs.core.Keyword(null,"stack","stack",-793405930));
var type = cljs.core.get.call(null,map__56264__$1,new cljs.core.Keyword(null,"type","type",1174270348));
return om.dom.tr.call(null,null,om.dom.td.call(null,({"className": ["test-result-title ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,type))].join('')}),title),om.dom.td.call(null,({"className": "test-result"}),om.dom.code.call(null,null,fulcro_spec.renderer.ui_foldable.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"render","render",-1408033454),((function (map__56264,map__56264__$1,title,value,stack,type,_STAR_reconciler_STAR_56259,_STAR_depth_STAR_56260,_STAR_shared_STAR_56261,_STAR_instrument_STAR_56262,_STAR_parent_STAR_56263,this$,this__38840__auto__,x56256_56268){
return (function (folded_QMARK_){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"title","title",636505583),(cljs.core.truth_(stack)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(value)].join(''):(cljs.core.truth_(folded_QMARK_)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(value)].join(''):title)),new cljs.core.Keyword(null,"value","value",305978217),(cljs.core.truth_(stack)?stack:((cljs.core.not.call(null,folded_QMARK_))?fulcro_spec.dom.edn_renderer.html_edn.call(null,value):null)),new cljs.core.Keyword(null,"classes","classes",2037804510),(cljs.core.truth_(stack)?"stack":null)], null);
});})(map__56264,map__56264__$1,title,value,stack,type,_STAR_reconciler_STAR_56259,_STAR_depth_STAR_56260,_STAR_shared_STAR_56261,_STAR_instrument_STAR_56262,_STAR_parent_STAR_56263,this$,this__38840__auto__,x56256_56268))
], null)))));
}finally {om.next._STAR_parent_STAR_ = _STAR_parent_STAR_56263;

om.next._STAR_instrument_STAR_ = _STAR_instrument_STAR_56262;

om.next._STAR_shared_STAR_ = _STAR_shared_STAR_56261;

om.next._STAR_depth_STAR_ = _STAR_depth_STAR_56260;

om.next._STAR_reconciler_STAR_ = _STAR_reconciler_STAR_56259;
}});})(x56256_56268))
;


fulcro_spec.renderer.ResultLine.prototype.constructor = fulcro_spec.renderer.ResultLine;

fulcro_spec.renderer.ResultLine.prototype.constructor.displayName = "fulcro-spec.renderer/ResultLine";

fulcro_spec.renderer.ResultLine.prototype.om$isComponent = true;

var x56266_56272 = fulcro_spec.renderer.ResultLine;


var x56267_56273 = fulcro_spec.renderer.ResultLine.prototype;


fulcro_spec.renderer.ResultLine.cljs$lang$type = true;

fulcro_spec.renderer.ResultLine.cljs$lang$ctorStr = "fulcro-spec.renderer/ResultLine";

fulcro_spec.renderer.ResultLine.cljs$lang$ctorPrWriter = (function (this__38957__auto__,writer__38958__auto__,opt__38959__auto__){
return cljs.core._write.call(null,writer__38958__auto__,"fulcro-spec.renderer/ResultLine");
});
fulcro_spec.renderer.ui_result_line = om.next.factory.call(null,fulcro_spec.renderer.ResultLine,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"keyfn","keyfn",780060332),(function (){
return cljs.core.gensym.call(null,"result-line");
})], null));
if(typeof fulcro_spec.renderer.HumanDiffLines !== 'undefined'){
} else {
/**
 * @constructor
 */
fulcro_spec.renderer.HumanDiffLines = (function fulcro_spec$renderer$HumanDiffLines(){
var this__38954__auto__ = this;
React.Component.apply(this__38954__auto__,arguments);

if(!((this__38954__auto__.initLocalState == null))){
this__38954__auto__.state = this__38954__auto__.initLocalState();
} else {
this__38954__auto__.state = {};
}

return this__38954__auto__;
});

fulcro_spec.renderer.HumanDiffLines.prototype = goog.object.clone(React.Component.prototype);
}

var x56276_56288 = fulcro_spec.renderer.HumanDiffLines.prototype;
x56276_56288.componentWillUpdate = ((function (x56276_56288){
return (function (next_props__38842__auto__,next_state__38843__auto__){
var this__38841__auto__ = this;
if(((!((this__38841__auto__ == null)))?(((false) || ((cljs.core.PROTOCOL_SENTINEL === this__38841__auto__.om$next$Ident$)))?true:false):false)){
var ident__38845__auto___56289 = om.next.ident.call(null,this__38841__auto__,om.next.props.call(null,this__38841__auto__));
var next_ident__38846__auto___56290 = om.next.ident.call(null,this__38841__auto__,om.next._next_props.call(null,next_props__38842__auto__,this__38841__auto__));
if(cljs.core.not_EQ_.call(null,ident__38845__auto___56289,next_ident__38846__auto___56290)){
var idxr__38847__auto___56291 = cljs.core.get_in.call(null,om.next.get_reconciler.call(null,this__38841__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
if((idxr__38847__auto___56291 == null)){
} else {
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"indexes","indexes",1496475545).cljs$core$IFn$_invoke$arity$1(idxr__38847__auto___56291),((function (idxr__38847__auto___56291,ident__38845__auto___56289,next_ident__38846__auto___56290,this__38841__auto__,x56276_56288){
return (function (indexes__38848__auto__){
return cljs.core.update_in.call(null,cljs.core.update_in.call(null,indexes__38848__auto__,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ref->components","ref->components",-303587249),ident__38845__auto___56289], null),cljs.core.disj,this__38841__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ref->components","ref->components",-303587249),next_ident__38846__auto___56290], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentHashSet.EMPTY),this__38841__auto__);
});})(idxr__38847__auto___56291,ident__38845__auto___56289,next_ident__38846__auto___56290,this__38841__auto__,x56276_56288))
);
}
} else {
}
} else {
}

om.next.merge_pending_props_BANG_.call(null,this__38841__auto__);

return om.next.merge_pending_state_BANG_.call(null,this__38841__auto__);
});})(x56276_56288))
;

x56276_56288.shouldComponentUpdate = ((function (x56276_56288){
return (function (next_props__38842__auto__,next_state__38843__auto__){
var this__38841__auto__ = this;
var next_children__38844__auto__ = next_props__38842__auto__.children;
var next_props__38842__auto____$1 = goog.object.get(next_props__38842__auto__,"omcljs$value");
var next_props__38842__auto____$2 = (function (){var G__56278 = next_props__38842__auto____$1;
if((next_props__38842__auto____$1 instanceof om.next.OmProps)){
return om.next.unwrap.call(null,G__56278);
} else {
return G__56278;
}
})();
var or__28141__auto__ = cljs.core.not_EQ_.call(null,om.next.props.call(null,this__38841__auto__),next_props__38842__auto____$2);
if(or__28141__auto__){
return or__28141__auto__;
} else {
var or__28141__auto____$1 = (function (){var and__28129__auto__ = this__38841__auto__.state;
if(cljs.core.truth_(and__28129__auto__)){
return cljs.core.not_EQ_.call(null,goog.object.get(this__38841__auto__.state,"omcljs$state"),goog.object.get(next_state__38843__auto__,"omcljs$state"));
} else {
return and__28129__auto__;
}
})();
if(cljs.core.truth_(or__28141__auto____$1)){
return or__28141__auto____$1;
} else {
return cljs.core.not_EQ_.call(null,this__38841__auto__.props.children,next_children__38844__auto__);
}
}
});})(x56276_56288))
;

x56276_56288.componentWillUnmount = ((function (x56276_56288){
return (function (){
var this__38841__auto__ = this;
var r__38852__auto__ = om.next.get_reconciler.call(null,this__38841__auto__);
var cfg__38853__auto__ = new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(r__38852__auto__);
var st__38854__auto__ = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(cfg__38853__auto__);
var indexer__38851__auto__ = new cljs.core.Keyword(null,"indexer","indexer",-1774914315).cljs$core$IFn$_invoke$arity$1(cfg__38853__auto__);
if(cljs.core.truth_((function (){var and__28129__auto__ = !((st__38854__auto__ == null));
if(and__28129__auto__){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,st__38854__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("om.next","queries","om.next/queries",-22717146),this__38841__auto__], null));
} else {
return and__28129__auto__;
}
})())){
cljs.core.swap_BANG_.call(null,st__38854__auto__,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("om.next","queries","om.next/queries",-22717146)], null),cljs.core.dissoc,this__38841__auto__);
} else {
}

if((indexer__38851__auto__ == null)){
return null;
} else {
return om.next.protocols.drop_component_BANG_.call(null,indexer__38851__auto__,this__38841__auto__);
}
});})(x56276_56288))
;

x56276_56288.componentDidUpdate = ((function (x56276_56288){
return (function (prev_props__38849__auto__,prev_state__38850__auto__){
var this__38841__auto__ = this;
return om.next.clear_prev_props_BANG_.call(null,this__38841__auto__);
});})(x56276_56288))
;

x56276_56288.isMounted = ((function (x56276_56288){
return (function (){
var this__38841__auto__ = this;
return cljs.core.boolean$.call(null,goog.object.getValueByKeys(this__38841__auto__,"_reactInternalInstance","_renderedComponent"));
});})(x56276_56288))
;

x56276_56288.componentWillMount = ((function (x56276_56288){
return (function (){
var this__38841__auto__ = this;
var indexer__38851__auto__ = cljs.core.get_in.call(null,om.next.get_reconciler.call(null,this__38841__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
if((indexer__38851__auto__ == null)){
return null;
} else {
return om.next.protocols.index_component_BANG_.call(null,indexer__38851__auto__,this__38841__auto__);
}
});})(x56276_56288))
;

x56276_56288.render = ((function (x56276_56288){
return (function (){
var this__38840__auto__ = this;
var this$ = this__38840__auto__;
var _STAR_reconciler_STAR_56279 = om.next._STAR_reconciler_STAR_;
var _STAR_depth_STAR_56280 = om.next._STAR_depth_STAR_;
var _STAR_shared_STAR_56281 = om.next._STAR_shared_STAR_;
var _STAR_instrument_STAR_56282 = om.next._STAR_instrument_STAR_;
var _STAR_parent_STAR_56283 = om.next._STAR_parent_STAR_;
om.next._STAR_reconciler_STAR_ = om.next.get_reconciler.call(null,this__38840__auto__);

om.next._STAR_depth_STAR_ = (om.next.depth.call(null,this__38840__auto__) + (1));

om.next._STAR_shared_STAR_ = om.next.shared.call(null,this__38840__auto__);

om.next._STAR_instrument_STAR_ = om.next.instrument.call(null,this__38840__auto__);

om.next._STAR_parent_STAR_ = this__38840__auto__;

try{var d = om.next.props.call(null,this$);
var map__56284 = fulcro_spec.diff.extract.call(null,d);
var map__56284__$1 = ((((!((map__56284 == null)))?((((map__56284.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56284.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56284):map__56284);
var exp = cljs.core.get.call(null,map__56284__$1,new cljs.core.Keyword(null,"exp","exp",-261706262));
var got = cljs.core.get.call(null,map__56284__$1,new cljs.core.Keyword(null,"got","got",-1674745710));
var path = cljs.core.get.call(null,map__56284__$1,new cljs.core.Keyword(null,"path","path",-188191168));
return om.dom.table.call(null,({"className": "human-diff-lines"}),om.dom.tbody.call(null,null,((cljs.core.seq.call(null,path))?om.dom.tr.call(null,({"className": "path"}),om.dom.td.call(null,null,"at: "),om.dom.td.call(null,null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(path)].join(''))):null),om.dom.tr.call(null,({"className": "expected"}),om.dom.td.call(null,null,"exp: "),om.dom.td.call(null,null,fulcro_spec.dom.edn_renderer.html_edn.call(null,exp))),om.dom.tr.call(null,({"className": "actual"}),om.dom.td.call(null,null,"got: "),om.dom.td.call(null,null,fulcro_spec.dom.edn_renderer.html_edn.call(null,got)))));
}finally {om.next._STAR_parent_STAR_ = _STAR_parent_STAR_56283;

om.next._STAR_instrument_STAR_ = _STAR_instrument_STAR_56282;

om.next._STAR_shared_STAR_ = _STAR_shared_STAR_56281;

om.next._STAR_depth_STAR_ = _STAR_depth_STAR_56280;

om.next._STAR_reconciler_STAR_ = _STAR_reconciler_STAR_56279;
}});})(x56276_56288))
;


fulcro_spec.renderer.HumanDiffLines.prototype.constructor = fulcro_spec.renderer.HumanDiffLines;

fulcro_spec.renderer.HumanDiffLines.prototype.constructor.displayName = "fulcro-spec.renderer/HumanDiffLines";

fulcro_spec.renderer.HumanDiffLines.prototype.om$isComponent = true;

var x56286_56292 = fulcro_spec.renderer.HumanDiffLines;


var x56287_56293 = fulcro_spec.renderer.HumanDiffLines.prototype;


fulcro_spec.renderer.HumanDiffLines.cljs$lang$type = true;

fulcro_spec.renderer.HumanDiffLines.cljs$lang$ctorStr = "fulcro-spec.renderer/HumanDiffLines";

fulcro_spec.renderer.HumanDiffLines.cljs$lang$ctorPrWriter = (function (this__38957__auto__,writer__38958__auto__,opt__38959__auto__){
return cljs.core._write.call(null,writer__38958__auto__,"fulcro-spec.renderer/HumanDiffLines");
});
fulcro_spec.renderer.ui_human_diff_lines = om.next.factory.call(null,fulcro_spec.renderer.HumanDiffLines,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"keyfn","keyfn",780060332),(function (){
return cljs.core.gensym.call(null,"human-diff-lines");
})], null));
if(typeof fulcro_spec.renderer.HumanDiff !== 'undefined'){
} else {
/**
 * @constructor
 */
fulcro_spec.renderer.HumanDiff = (function fulcro_spec$renderer$HumanDiff(){
var this__38954__auto__ = this;
React.Component.apply(this__38954__auto__,arguments);

if(!((this__38954__auto__.initLocalState == null))){
this__38954__auto__.state = this__38954__auto__.initLocalState();
} else {
this__38954__auto__.state = {};
}

return this__38954__auto__;
});

fulcro_spec.renderer.HumanDiff.prototype = goog.object.clone(React.Component.prototype);
}

var x56296_56311 = fulcro_spec.renderer.HumanDiff.prototype;
x56296_56311.componentWillUpdate = ((function (x56296_56311){
return (function (next_props__38842__auto__,next_state__38843__auto__){
var this__38841__auto__ = this;
if(((!((this__38841__auto__ == null)))?(((false) || ((cljs.core.PROTOCOL_SENTINEL === this__38841__auto__.om$next$Ident$)))?true:false):false)){
var ident__38845__auto___56312 = om.next.ident.call(null,this__38841__auto__,om.next.props.call(null,this__38841__auto__));
var next_ident__38846__auto___56313 = om.next.ident.call(null,this__38841__auto__,om.next._next_props.call(null,next_props__38842__auto__,this__38841__auto__));
if(cljs.core.not_EQ_.call(null,ident__38845__auto___56312,next_ident__38846__auto___56313)){
var idxr__38847__auto___56314 = cljs.core.get_in.call(null,om.next.get_reconciler.call(null,this__38841__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
if((idxr__38847__auto___56314 == null)){
} else {
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"indexes","indexes",1496475545).cljs$core$IFn$_invoke$arity$1(idxr__38847__auto___56314),((function (idxr__38847__auto___56314,ident__38845__auto___56312,next_ident__38846__auto___56313,this__38841__auto__,x56296_56311){
return (function (indexes__38848__auto__){
return cljs.core.update_in.call(null,cljs.core.update_in.call(null,indexes__38848__auto__,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ref->components","ref->components",-303587249),ident__38845__auto___56312], null),cljs.core.disj,this__38841__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ref->components","ref->components",-303587249),next_ident__38846__auto___56313], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentHashSet.EMPTY),this__38841__auto__);
});})(idxr__38847__auto___56314,ident__38845__auto___56312,next_ident__38846__auto___56313,this__38841__auto__,x56296_56311))
);
}
} else {
}
} else {
}

om.next.merge_pending_props_BANG_.call(null,this__38841__auto__);

return om.next.merge_pending_state_BANG_.call(null,this__38841__auto__);
});})(x56296_56311))
;

x56296_56311.shouldComponentUpdate = ((function (x56296_56311){
return (function (next_props__38842__auto__,next_state__38843__auto__){
var this__38841__auto__ = this;
var next_children__38844__auto__ = next_props__38842__auto__.children;
var next_props__38842__auto____$1 = goog.object.get(next_props__38842__auto__,"omcljs$value");
var next_props__38842__auto____$2 = (function (){var G__56298 = next_props__38842__auto____$1;
if((next_props__38842__auto____$1 instanceof om.next.OmProps)){
return om.next.unwrap.call(null,G__56298);
} else {
return G__56298;
}
})();
var or__28141__auto__ = cljs.core.not_EQ_.call(null,om.next.props.call(null,this__38841__auto__),next_props__38842__auto____$2);
if(or__28141__auto__){
return or__28141__auto__;
} else {
var or__28141__auto____$1 = (function (){var and__28129__auto__ = this__38841__auto__.state;
if(cljs.core.truth_(and__28129__auto__)){
return cljs.core.not_EQ_.call(null,goog.object.get(this__38841__auto__.state,"omcljs$state"),goog.object.get(next_state__38843__auto__,"omcljs$state"));
} else {
return and__28129__auto__;
}
})();
if(cljs.core.truth_(or__28141__auto____$1)){
return or__28141__auto____$1;
} else {
return cljs.core.not_EQ_.call(null,this__38841__auto__.props.children,next_children__38844__auto__);
}
}
});})(x56296_56311))
;

x56296_56311.componentWillUnmount = ((function (x56296_56311){
return (function (){
var this__38841__auto__ = this;
var r__38852__auto__ = om.next.get_reconciler.call(null,this__38841__auto__);
var cfg__38853__auto__ = new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(r__38852__auto__);
var st__38854__auto__ = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(cfg__38853__auto__);
var indexer__38851__auto__ = new cljs.core.Keyword(null,"indexer","indexer",-1774914315).cljs$core$IFn$_invoke$arity$1(cfg__38853__auto__);
if(cljs.core.truth_((function (){var and__28129__auto__ = !((st__38854__auto__ == null));
if(and__28129__auto__){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,st__38854__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("om.next","queries","om.next/queries",-22717146),this__38841__auto__], null));
} else {
return and__28129__auto__;
}
})())){
cljs.core.swap_BANG_.call(null,st__38854__auto__,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("om.next","queries","om.next/queries",-22717146)], null),cljs.core.dissoc,this__38841__auto__);
} else {
}

if((indexer__38851__auto__ == null)){
return null;
} else {
return om.next.protocols.drop_component_BANG_.call(null,indexer__38851__auto__,this__38841__auto__);
}
});})(x56296_56311))
;

x56296_56311.componentDidUpdate = ((function (x56296_56311){
return (function (prev_props__38849__auto__,prev_state__38850__auto__){
var this__38841__auto__ = this;
return om.next.clear_prev_props_BANG_.call(null,this__38841__auto__);
});})(x56296_56311))
;

x56296_56311.isMounted = ((function (x56296_56311){
return (function (){
var this__38841__auto__ = this;
return cljs.core.boolean$.call(null,goog.object.getValueByKeys(this__38841__auto__,"_reactInternalInstance","_renderedComponent"));
});})(x56296_56311))
;

x56296_56311.componentWillMount = ((function (x56296_56311){
return (function (){
var this__38841__auto__ = this;
var indexer__38851__auto__ = cljs.core.get_in.call(null,om.next.get_reconciler.call(null,this__38841__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
if((indexer__38851__auto__ == null)){
return null;
} else {
return om.next.protocols.index_component_BANG_.call(null,indexer__38851__auto__,this__38841__auto__);
}
});})(x56296_56311))
;

x56296_56311.render = ((function (x56296_56311){
return (function (){
var this__38840__auto__ = this;
var this$ = this__38840__auto__;
var _STAR_reconciler_STAR_56299 = om.next._STAR_reconciler_STAR_;
var _STAR_depth_STAR_56300 = om.next._STAR_depth_STAR_;
var _STAR_shared_STAR_56301 = om.next._STAR_shared_STAR_;
var _STAR_instrument_STAR_56302 = om.next._STAR_instrument_STAR_;
var _STAR_parent_STAR_56303 = om.next._STAR_parent_STAR_;
om.next._STAR_reconciler_STAR_ = om.next.get_reconciler.call(null,this__38840__auto__);

om.next._STAR_depth_STAR_ = (om.next.depth.call(null,this__38840__auto__) + (1));

om.next._STAR_shared_STAR_ = om.next.shared.call(null,this__38840__auto__);

om.next._STAR_instrument_STAR_ = om.next.instrument.call(null,this__38840__auto__);

om.next._STAR_parent_STAR_ = this__38840__auto__;

try{var map__56304 = om.next.props.call(null,this$);
var map__56304__$1 = ((((!((map__56304 == null)))?((((map__56304.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56304.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56304):map__56304);
var diff = cljs.core.get.call(null,map__56304__$1,new cljs.core.Keyword(null,"diff","diff",2135942783));
var actual = cljs.core.get.call(null,map__56304__$1,new cljs.core.Keyword(null,"actual","actual",107306363));
var vec__56305 = cljs.core.split_at.call(null,(2),diff);
var fst = cljs.core.nth.call(null,vec__56305,(0),null);
var rst = cljs.core.nth.call(null,vec__56305,(1),null);
return om.dom.tr.call(null,null,om.dom.td.call(null,null,"DIFFS:"),om.dom.td.call(null,null,om.dom.div.call(null,null,cljs.core.mapv.call(null,fulcro_spec.renderer.ui_human_diff_lines,fst),((cljs.core.seq.call(null,rst))?fulcro_spec.renderer.ui_foldable.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"render","render",-1408033454),((function (map__56304,map__56304__$1,diff,actual,vec__56305,fst,rst,_STAR_reconciler_STAR_56299,_STAR_depth_STAR_56300,_STAR_shared_STAR_56301,_STAR_instrument_STAR_56302,_STAR_parent_STAR_56303,this$,this__38840__auto__,x56296_56311){
return (function (folded_QMARK_){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"title","title",636505583),"& more",new cljs.core.Keyword(null,"value","value",305978217),cljs.core.mapv.call(null,fulcro_spec.renderer.ui_human_diff_lines,rst),new cljs.core.Keyword(null,"classes","classes",2037804510),""], null);
});})(map__56304,map__56304__$1,diff,actual,vec__56305,fst,rst,_STAR_reconciler_STAR_56299,_STAR_depth_STAR_56300,_STAR_shared_STAR_56301,_STAR_instrument_STAR_56302,_STAR_parent_STAR_56303,this$,this__38840__auto__,x56296_56311))
], null)):null))));
}finally {om.next._STAR_parent_STAR_ = _STAR_parent_STAR_56303;

om.next._STAR_instrument_STAR_ = _STAR_instrument_STAR_56302;

om.next._STAR_shared_STAR_ = _STAR_shared_STAR_56301;

om.next._STAR_depth_STAR_ = _STAR_depth_STAR_56300;

om.next._STAR_reconciler_STAR_ = _STAR_reconciler_STAR_56299;
}});})(x56296_56311))
;


fulcro_spec.renderer.HumanDiff.prototype.constructor = fulcro_spec.renderer.HumanDiff;

fulcro_spec.renderer.HumanDiff.prototype.constructor.displayName = "fulcro-spec.renderer/HumanDiff";

fulcro_spec.renderer.HumanDiff.prototype.om$isComponent = true;

var x56309_56315 = fulcro_spec.renderer.HumanDiff;


var x56310_56316 = fulcro_spec.renderer.HumanDiff.prototype;


fulcro_spec.renderer.HumanDiff.cljs$lang$type = true;

fulcro_spec.renderer.HumanDiff.cljs$lang$ctorStr = "fulcro-spec.renderer/HumanDiff";

fulcro_spec.renderer.HumanDiff.cljs$lang$ctorPrWriter = (function (this__38957__auto__,writer__38958__auto__,opt__38959__auto__){
return cljs.core._write.call(null,writer__38958__auto__,"fulcro-spec.renderer/HumanDiff");
});
fulcro_spec.renderer.ui_human_diff = om.next.factory.call(null,fulcro_spec.renderer.HumanDiff,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"keyfn","keyfn",780060332),(function (){
return cljs.core.gensym.call(null,"human-diff");
})], null));
if(typeof fulcro_spec.renderer.TestResult !== 'undefined'){
} else {
/**
 * @constructor
 */
fulcro_spec.renderer.TestResult = (function fulcro_spec$renderer$TestResult(){
var this__38954__auto__ = this;
React.Component.apply(this__38954__auto__,arguments);

if(!((this__38954__auto__.initLocalState == null))){
this__38954__auto__.state = this__38954__auto__.initLocalState();
} else {
this__38954__auto__.state = {};
}

return this__38954__auto__;
});

fulcro_spec.renderer.TestResult.prototype = goog.object.clone(React.Component.prototype);
}

var x56319_56331 = fulcro_spec.renderer.TestResult.prototype;
x56319_56331.componentWillUpdate = ((function (x56319_56331){
return (function (next_props__38842__auto__,next_state__38843__auto__){
var this__38841__auto__ = this;
if(((!((this__38841__auto__ == null)))?(((false) || ((cljs.core.PROTOCOL_SENTINEL === this__38841__auto__.om$next$Ident$)))?true:false):false)){
var ident__38845__auto___56332 = om.next.ident.call(null,this__38841__auto__,om.next.props.call(null,this__38841__auto__));
var next_ident__38846__auto___56333 = om.next.ident.call(null,this__38841__auto__,om.next._next_props.call(null,next_props__38842__auto__,this__38841__auto__));
if(cljs.core.not_EQ_.call(null,ident__38845__auto___56332,next_ident__38846__auto___56333)){
var idxr__38847__auto___56334 = cljs.core.get_in.call(null,om.next.get_reconciler.call(null,this__38841__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
if((idxr__38847__auto___56334 == null)){
} else {
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"indexes","indexes",1496475545).cljs$core$IFn$_invoke$arity$1(idxr__38847__auto___56334),((function (idxr__38847__auto___56334,ident__38845__auto___56332,next_ident__38846__auto___56333,this__38841__auto__,x56319_56331){
return (function (indexes__38848__auto__){
return cljs.core.update_in.call(null,cljs.core.update_in.call(null,indexes__38848__auto__,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ref->components","ref->components",-303587249),ident__38845__auto___56332], null),cljs.core.disj,this__38841__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ref->components","ref->components",-303587249),next_ident__38846__auto___56333], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentHashSet.EMPTY),this__38841__auto__);
});})(idxr__38847__auto___56334,ident__38845__auto___56332,next_ident__38846__auto___56333,this__38841__auto__,x56319_56331))
);
}
} else {
}
} else {
}

om.next.merge_pending_props_BANG_.call(null,this__38841__auto__);

return om.next.merge_pending_state_BANG_.call(null,this__38841__auto__);
});})(x56319_56331))
;

x56319_56331.shouldComponentUpdate = ((function (x56319_56331){
return (function (next_props__38842__auto__,next_state__38843__auto__){
var this__38841__auto__ = this;
var next_children__38844__auto__ = next_props__38842__auto__.children;
var next_props__38842__auto____$1 = goog.object.get(next_props__38842__auto__,"omcljs$value");
var next_props__38842__auto____$2 = (function (){var G__56321 = next_props__38842__auto____$1;
if((next_props__38842__auto____$1 instanceof om.next.OmProps)){
return om.next.unwrap.call(null,G__56321);
} else {
return G__56321;
}
})();
var or__28141__auto__ = cljs.core.not_EQ_.call(null,om.next.props.call(null,this__38841__auto__),next_props__38842__auto____$2);
if(or__28141__auto__){
return or__28141__auto__;
} else {
var or__28141__auto____$1 = (function (){var and__28129__auto__ = this__38841__auto__.state;
if(cljs.core.truth_(and__28129__auto__)){
return cljs.core.not_EQ_.call(null,goog.object.get(this__38841__auto__.state,"omcljs$state"),goog.object.get(next_state__38843__auto__,"omcljs$state"));
} else {
return and__28129__auto__;
}
})();
if(cljs.core.truth_(or__28141__auto____$1)){
return or__28141__auto____$1;
} else {
return cljs.core.not_EQ_.call(null,this__38841__auto__.props.children,next_children__38844__auto__);
}
}
});})(x56319_56331))
;

x56319_56331.componentWillUnmount = ((function (x56319_56331){
return (function (){
var this__38841__auto__ = this;
var r__38852__auto__ = om.next.get_reconciler.call(null,this__38841__auto__);
var cfg__38853__auto__ = new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(r__38852__auto__);
var st__38854__auto__ = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(cfg__38853__auto__);
var indexer__38851__auto__ = new cljs.core.Keyword(null,"indexer","indexer",-1774914315).cljs$core$IFn$_invoke$arity$1(cfg__38853__auto__);
if(cljs.core.truth_((function (){var and__28129__auto__ = !((st__38854__auto__ == null));
if(and__28129__auto__){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,st__38854__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("om.next","queries","om.next/queries",-22717146),this__38841__auto__], null));
} else {
return and__28129__auto__;
}
})())){
cljs.core.swap_BANG_.call(null,st__38854__auto__,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("om.next","queries","om.next/queries",-22717146)], null),cljs.core.dissoc,this__38841__auto__);
} else {
}

if((indexer__38851__auto__ == null)){
return null;
} else {
return om.next.protocols.drop_component_BANG_.call(null,indexer__38851__auto__,this__38841__auto__);
}
});})(x56319_56331))
;

x56319_56331.componentDidUpdate = ((function (x56319_56331){
return (function (prev_props__38849__auto__,prev_state__38850__auto__){
var this__38841__auto__ = this;
return om.next.clear_prev_props_BANG_.call(null,this__38841__auto__);
});})(x56319_56331))
;

x56319_56331.isMounted = ((function (x56319_56331){
return (function (){
var this__38841__auto__ = this;
return cljs.core.boolean$.call(null,goog.object.getValueByKeys(this__38841__auto__,"_reactInternalInstance","_renderedComponent"));
});})(x56319_56331))
;

x56319_56331.componentWillMount = ((function (x56319_56331){
return (function (){
var this__38841__auto__ = this;
var indexer__38851__auto__ = cljs.core.get_in.call(null,om.next.get_reconciler.call(null,this__38841__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
if((indexer__38851__auto__ == null)){
return null;
} else {
return om.next.protocols.index_component_BANG_.call(null,indexer__38851__auto__,this__38841__auto__);
}
});})(x56319_56331))
;

x56319_56331.render = ((function (x56319_56331){
return (function (){
var this__38840__auto__ = this;
var this$ = this__38840__auto__;
var _STAR_reconciler_STAR_56322 = om.next._STAR_reconciler_STAR_;
var _STAR_depth_STAR_56323 = om.next._STAR_depth_STAR_;
var _STAR_shared_STAR_56324 = om.next._STAR_shared_STAR_;
var _STAR_instrument_STAR_56325 = om.next._STAR_instrument_STAR_;
var _STAR_parent_STAR_56326 = om.next._STAR_parent_STAR_;
om.next._STAR_reconciler_STAR_ = om.next.get_reconciler.call(null,this__38840__auto__);

om.next._STAR_depth_STAR_ = (om.next.depth.call(null,this__38840__auto__) + (1));

om.next._STAR_shared_STAR_ = om.next.shared.call(null,this__38840__auto__);

om.next._STAR_instrument_STAR_ = om.next.instrument.call(null,this__38840__auto__);

om.next._STAR_parent_STAR_ = this__38840__auto__;

try{var map__56327 = om.next.props.call(null,this$);
var map__56327__$1 = ((((!((map__56327 == null)))?((((map__56327.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56327.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56327):map__56327);
var where = cljs.core.get.call(null,map__56327__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
var message = cljs.core.get.call(null,map__56327__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var extra = cljs.core.get.call(null,map__56327__$1,new cljs.core.Keyword(null,"extra","extra",1612569067));
var actual = cljs.core.get.call(null,map__56327__$1,new cljs.core.Keyword(null,"actual","actual",107306363));
var expected = cljs.core.get.call(null,map__56327__$1,new cljs.core.Keyword(null,"expected","expected",1583670997));
var stack = cljs.core.get.call(null,map__56327__$1,new cljs.core.Keyword(null,"stack","stack",-793405930));
var diff = cljs.core.get.call(null,map__56327__$1,new cljs.core.Keyword(null,"diff","diff",2135942783));
return om.dom.li.call(null,null,om.dom.table.call(null,null,om.dom.tbody.call(null,null,om.dom.tr.call(null,null,om.dom.td.call(null,({"className": "test-result-title"}),"Where: "),om.dom.td.call(null,({"className": "test-result"}),clojure.string.replace.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(where)].join(''),/G__\d+/,""))),(cljs.core.truth_(message)?fulcro_spec.renderer.ui_result_line.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"normal","normal",-1519123858),new cljs.core.Keyword(null,"title","title",636505583),"ASSERTION: ",new cljs.core.Keyword(null,"value","value",305978217),message], null)):null),fulcro_spec.renderer.ui_result_line.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"normal","normal",-1519123858),new cljs.core.Keyword(null,"title","title",636505583),"Actual: ",new cljs.core.Keyword(null,"value","value",305978217),actual,new cljs.core.Keyword(null,"stack","stack",-793405930),stack], null)),fulcro_spec.renderer.ui_result_line.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"normal","normal",-1519123858),new cljs.core.Keyword(null,"title","title",636505583),"Expected: ",new cljs.core.Keyword(null,"value","value",305978217),expected], null)),(cljs.core.truth_(extra)?fulcro_spec.renderer.ui_result_line.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"normal","normal",-1519123858),new cljs.core.Keyword(null,"title","title",636505583),"Message: ",new cljs.core.Keyword(null,"value","value",305978217),extra], null)):null),(cljs.core.truth_(diff)?fulcro_spec.renderer.ui_human_diff.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"actual","actual",107306363),actual,new cljs.core.Keyword(null,"diff","diff",2135942783),diff], null)):null))));
}finally {om.next._STAR_parent_STAR_ = _STAR_parent_STAR_56326;

om.next._STAR_instrument_STAR_ = _STAR_instrument_STAR_56325;

om.next._STAR_shared_STAR_ = _STAR_shared_STAR_56324;

om.next._STAR_depth_STAR_ = _STAR_depth_STAR_56323;

om.next._STAR_reconciler_STAR_ = _STAR_reconciler_STAR_56322;
}});})(x56319_56331))
;


fulcro_spec.renderer.TestResult.prototype.constructor = fulcro_spec.renderer.TestResult;

fulcro_spec.renderer.TestResult.prototype.constructor.displayName = "fulcro-spec.renderer/TestResult";

fulcro_spec.renderer.TestResult.prototype.om$isComponent = true;

var x56329_56335 = fulcro_spec.renderer.TestResult;


var x56330_56336 = fulcro_spec.renderer.TestResult.prototype;


fulcro_spec.renderer.TestResult.cljs$lang$type = true;

fulcro_spec.renderer.TestResult.cljs$lang$ctorStr = "fulcro-spec.renderer/TestResult";

fulcro_spec.renderer.TestResult.cljs$lang$ctorPrWriter = (function (this__38957__auto__,writer__38958__auto__,opt__38959__auto__){
return cljs.core._write.call(null,writer__38958__auto__,"fulcro-spec.renderer/TestResult");
});
fulcro_spec.renderer.ui_test_result = om.next.factory.call(null,fulcro_spec.renderer.TestResult,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"keyfn","keyfn",780060332),new cljs.core.Keyword(null,"id","id",-1388402092)], null));
if(typeof fulcro_spec.renderer.TestItem !== 'undefined'){
} else {
/**
 * @constructor
 */
fulcro_spec.renderer.TestItem = (function fulcro_spec$renderer$TestItem(){
var this__38954__auto__ = this;
React.Component.apply(this__38954__auto__,arguments);

if(!((this__38954__auto__.initLocalState == null))){
this__38954__auto__.state = this__38954__auto__.initLocalState();
} else {
this__38954__auto__.state = {};
}

return this__38954__auto__;
});

fulcro_spec.renderer.TestItem.prototype = goog.object.clone(React.Component.prototype);
}

var x56340_56352 = fulcro_spec.renderer.TestItem.prototype;
x56340_56352.componentWillUpdate = ((function (x56340_56352){
return (function (next_props__38842__auto__,next_state__38843__auto__){
var this__38841__auto__ = this;
if(((!((this__38841__auto__ == null)))?(((false) || ((cljs.core.PROTOCOL_SENTINEL === this__38841__auto__.om$next$Ident$)))?true:false):false)){
var ident__38845__auto___56353 = om.next.ident.call(null,this__38841__auto__,om.next.props.call(null,this__38841__auto__));
var next_ident__38846__auto___56354 = om.next.ident.call(null,this__38841__auto__,om.next._next_props.call(null,next_props__38842__auto__,this__38841__auto__));
if(cljs.core.not_EQ_.call(null,ident__38845__auto___56353,next_ident__38846__auto___56354)){
var idxr__38847__auto___56355 = cljs.core.get_in.call(null,om.next.get_reconciler.call(null,this__38841__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
if((idxr__38847__auto___56355 == null)){
} else {
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"indexes","indexes",1496475545).cljs$core$IFn$_invoke$arity$1(idxr__38847__auto___56355),((function (idxr__38847__auto___56355,ident__38845__auto___56353,next_ident__38846__auto___56354,this__38841__auto__,x56340_56352){
return (function (indexes__38848__auto__){
return cljs.core.update_in.call(null,cljs.core.update_in.call(null,indexes__38848__auto__,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ref->components","ref->components",-303587249),ident__38845__auto___56353], null),cljs.core.disj,this__38841__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ref->components","ref->components",-303587249),next_ident__38846__auto___56354], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentHashSet.EMPTY),this__38841__auto__);
});})(idxr__38847__auto___56355,ident__38845__auto___56353,next_ident__38846__auto___56354,this__38841__auto__,x56340_56352))
);
}
} else {
}
} else {
}

om.next.merge_pending_props_BANG_.call(null,this__38841__auto__);

return om.next.merge_pending_state_BANG_.call(null,this__38841__auto__);
});})(x56340_56352))
;

x56340_56352.shouldComponentUpdate = ((function (x56340_56352){
return (function (next_props__38842__auto__,next_state__38843__auto__){
var this__38841__auto__ = this;
var next_children__38844__auto__ = next_props__38842__auto__.children;
var next_props__38842__auto____$1 = goog.object.get(next_props__38842__auto__,"omcljs$value");
var next_props__38842__auto____$2 = (function (){var G__56342 = next_props__38842__auto____$1;
if((next_props__38842__auto____$1 instanceof om.next.OmProps)){
return om.next.unwrap.call(null,G__56342);
} else {
return G__56342;
}
})();
var or__28141__auto__ = cljs.core.not_EQ_.call(null,om.next.props.call(null,this__38841__auto__),next_props__38842__auto____$2);
if(or__28141__auto__){
return or__28141__auto__;
} else {
var or__28141__auto____$1 = (function (){var and__28129__auto__ = this__38841__auto__.state;
if(cljs.core.truth_(and__28129__auto__)){
return cljs.core.not_EQ_.call(null,goog.object.get(this__38841__auto__.state,"omcljs$state"),goog.object.get(next_state__38843__auto__,"omcljs$state"));
} else {
return and__28129__auto__;
}
})();
if(cljs.core.truth_(or__28141__auto____$1)){
return or__28141__auto____$1;
} else {
return cljs.core.not_EQ_.call(null,this__38841__auto__.props.children,next_children__38844__auto__);
}
}
});})(x56340_56352))
;

x56340_56352.componentWillUnmount = ((function (x56340_56352){
return (function (){
var this__38841__auto__ = this;
var r__38852__auto__ = om.next.get_reconciler.call(null,this__38841__auto__);
var cfg__38853__auto__ = new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(r__38852__auto__);
var st__38854__auto__ = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(cfg__38853__auto__);
var indexer__38851__auto__ = new cljs.core.Keyword(null,"indexer","indexer",-1774914315).cljs$core$IFn$_invoke$arity$1(cfg__38853__auto__);
if(cljs.core.truth_((function (){var and__28129__auto__ = !((st__38854__auto__ == null));
if(and__28129__auto__){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,st__38854__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("om.next","queries","om.next/queries",-22717146),this__38841__auto__], null));
} else {
return and__28129__auto__;
}
})())){
cljs.core.swap_BANG_.call(null,st__38854__auto__,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("om.next","queries","om.next/queries",-22717146)], null),cljs.core.dissoc,this__38841__auto__);
} else {
}

if((indexer__38851__auto__ == null)){
return null;
} else {
return om.next.protocols.drop_component_BANG_.call(null,indexer__38851__auto__,this__38841__auto__);
}
});})(x56340_56352))
;

x56340_56352.componentDidUpdate = ((function (x56340_56352){
return (function (prev_props__38849__auto__,prev_state__38850__auto__){
var this__38841__auto__ = this;
return om.next.clear_prev_props_BANG_.call(null,this__38841__auto__);
});})(x56340_56352))
;

x56340_56352.isMounted = ((function (x56340_56352){
return (function (){
var this__38841__auto__ = this;
return cljs.core.boolean$.call(null,goog.object.getValueByKeys(this__38841__auto__,"_reactInternalInstance","_renderedComponent"));
});})(x56340_56352))
;

x56340_56352.componentWillMount = ((function (x56340_56352){
return (function (){
var this__38841__auto__ = this;
var indexer__38851__auto__ = cljs.core.get_in.call(null,om.next.get_reconciler.call(null,this__38841__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
if((indexer__38851__auto__ == null)){
return null;
} else {
return om.next.protocols.index_component_BANG_.call(null,indexer__38851__auto__,this__38841__auto__);
}
});})(x56340_56352))
;

x56340_56352.render = ((function (x56340_56352){
return (function (){
var this__38840__auto__ = this;
var this$ = this__38840__auto__;
var _STAR_reconciler_STAR_56343 = om.next._STAR_reconciler_STAR_;
var _STAR_depth_STAR_56344 = om.next._STAR_depth_STAR_;
var _STAR_shared_STAR_56345 = om.next._STAR_shared_STAR_;
var _STAR_instrument_STAR_56346 = om.next._STAR_instrument_STAR_;
var _STAR_parent_STAR_56347 = om.next._STAR_parent_STAR_;
om.next._STAR_reconciler_STAR_ = om.next.get_reconciler.call(null,this__38840__auto__);

om.next._STAR_depth_STAR_ = (om.next.depth.call(null,this__38840__auto__) + (1));

om.next._STAR_shared_STAR_ = om.next.shared.call(null,this__38840__auto__);

om.next._STAR_instrument_STAR_ = om.next.instrument.call(null,this__38840__auto__);

om.next._STAR_parent_STAR_ = this__38840__auto__;

try{var map__56348 = om.next.props.call(null,this$);
var map__56348__$1 = ((((!((map__56348 == null)))?((((map__56348.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56348.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56348):map__56348);
var test_item_data = map__56348__$1;
var id = cljs.core.get.call(null,map__56348__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var current_filter = cljs.core.get.call(null,map__56348__$1,new cljs.core.Keyword(null,"current-filter","current-filter",1519815247));
return om.dom.li.call(null,({"className": "test-item"}),om.dom.div.call(null,null,om.dom.span.call(null,({"className": fulcro_spec.renderer.test_item_class.call(null,new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(test_item_data))}),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(test_item_data)),om.dom.ul.call(null,({"className": "test-list"}),cljs.core.mapv.call(null,fulcro_spec.renderer.ui_test_result,new cljs.core.Keyword(null,"test-results","test-results",575566942).cljs$core$IFn$_invoke$arity$1(test_item_data))),om.dom.ul.call(null,({"className": "test-list"}),cljs.core.sequence.call(null,cljs.core.comp.call(null,fulcro_spec.renderer.filters.call(null,current_filter),cljs.core.map.call(null,((function (map__56348,map__56348__$1,test_item_data,id,current_filter,_STAR_reconciler_STAR_56343,_STAR_depth_STAR_56344,_STAR_shared_STAR_56345,_STAR_instrument_STAR_56346,_STAR_parent_STAR_56347,this$,this__38840__auto__,x56340_56352){
return (function (p1__56337_SHARP_){
return cljs.core.assoc.call(null,p1__56337_SHARP_,new cljs.core.Keyword(null,"current-filter","current-filter",1519815247),current_filter);
});})(map__56348,map__56348__$1,test_item_data,id,current_filter,_STAR_reconciler_STAR_56343,_STAR_depth_STAR_56344,_STAR_shared_STAR_56345,_STAR_instrument_STAR_56346,_STAR_parent_STAR_56347,this$,this__38840__auto__,x56340_56352))
),cljs.core.map.call(null,fulcro_spec.renderer.ui_test_item)),new cljs.core.Keyword(null,"test-items","test-items",1900391985).cljs$core$IFn$_invoke$arity$1(test_item_data)))));
}finally {om.next._STAR_parent_STAR_ = _STAR_parent_STAR_56347;

om.next._STAR_instrument_STAR_ = _STAR_instrument_STAR_56346;

om.next._STAR_shared_STAR_ = _STAR_shared_STAR_56345;

om.next._STAR_depth_STAR_ = _STAR_depth_STAR_56344;

om.next._STAR_reconciler_STAR_ = _STAR_reconciler_STAR_56343;
}});})(x56340_56352))
;


fulcro_spec.renderer.TestItem.prototype.constructor = fulcro_spec.renderer.TestItem;

fulcro_spec.renderer.TestItem.prototype.constructor.displayName = "fulcro-spec.renderer/TestItem";

fulcro_spec.renderer.TestItem.prototype.om$isComponent = true;

var x56350_56356 = fulcro_spec.renderer.TestItem;


var x56351_56357 = fulcro_spec.renderer.TestItem.prototype;


fulcro_spec.renderer.TestItem.cljs$lang$type = true;

fulcro_spec.renderer.TestItem.cljs$lang$ctorStr = "fulcro-spec.renderer/TestItem";

fulcro_spec.renderer.TestItem.cljs$lang$ctorPrWriter = (function (this__38957__auto__,writer__38958__auto__,opt__38959__auto__){
return cljs.core._write.call(null,writer__38958__auto__,"fulcro-spec.renderer/TestItem");
});
fulcro_spec.renderer.ui_test_item = om.next.factory.call(null,fulcro_spec.renderer.TestItem,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"keyfn","keyfn",780060332),new cljs.core.Keyword(null,"id","id",-1388402092)], null));
if(typeof fulcro_spec.renderer.TestNamespace !== 'undefined'){
} else {
/**
 * @constructor
 */
fulcro_spec.renderer.TestNamespace = (function fulcro_spec$renderer$TestNamespace(){
var this__38954__auto__ = this;
React.Component.apply(this__38954__auto__,arguments);

if(!((this__38954__auto__.initLocalState == null))){
this__38954__auto__.state = this__38954__auto__.initLocalState();
} else {
this__38954__auto__.state = {};
}

return this__38954__auto__;
});

fulcro_spec.renderer.TestNamespace.prototype = goog.object.clone(React.Component.prototype);
}

var x56361_56373 = fulcro_spec.renderer.TestNamespace.prototype;
x56361_56373.componentWillUpdate = ((function (x56361_56373){
return (function (next_props__38842__auto__,next_state__38843__auto__){
var this__38841__auto__ = this;
if(((!((this__38841__auto__ == null)))?(((false) || ((cljs.core.PROTOCOL_SENTINEL === this__38841__auto__.om$next$Ident$)))?true:false):false)){
var ident__38845__auto___56374 = om.next.ident.call(null,this__38841__auto__,om.next.props.call(null,this__38841__auto__));
var next_ident__38846__auto___56375 = om.next.ident.call(null,this__38841__auto__,om.next._next_props.call(null,next_props__38842__auto__,this__38841__auto__));
if(cljs.core.not_EQ_.call(null,ident__38845__auto___56374,next_ident__38846__auto___56375)){
var idxr__38847__auto___56376 = cljs.core.get_in.call(null,om.next.get_reconciler.call(null,this__38841__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
if((idxr__38847__auto___56376 == null)){
} else {
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"indexes","indexes",1496475545).cljs$core$IFn$_invoke$arity$1(idxr__38847__auto___56376),((function (idxr__38847__auto___56376,ident__38845__auto___56374,next_ident__38846__auto___56375,this__38841__auto__,x56361_56373){
return (function (indexes__38848__auto__){
return cljs.core.update_in.call(null,cljs.core.update_in.call(null,indexes__38848__auto__,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ref->components","ref->components",-303587249),ident__38845__auto___56374], null),cljs.core.disj,this__38841__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ref->components","ref->components",-303587249),next_ident__38846__auto___56375], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentHashSet.EMPTY),this__38841__auto__);
});})(idxr__38847__auto___56376,ident__38845__auto___56374,next_ident__38846__auto___56375,this__38841__auto__,x56361_56373))
);
}
} else {
}
} else {
}

om.next.merge_pending_props_BANG_.call(null,this__38841__auto__);

return om.next.merge_pending_state_BANG_.call(null,this__38841__auto__);
});})(x56361_56373))
;

x56361_56373.shouldComponentUpdate = ((function (x56361_56373){
return (function (next_props__38842__auto__,next_state__38843__auto__){
var this__38841__auto__ = this;
var next_children__38844__auto__ = next_props__38842__auto__.children;
var next_props__38842__auto____$1 = goog.object.get(next_props__38842__auto__,"omcljs$value");
var next_props__38842__auto____$2 = (function (){var G__56363 = next_props__38842__auto____$1;
if((next_props__38842__auto____$1 instanceof om.next.OmProps)){
return om.next.unwrap.call(null,G__56363);
} else {
return G__56363;
}
})();
var or__28141__auto__ = cljs.core.not_EQ_.call(null,om.next.props.call(null,this__38841__auto__),next_props__38842__auto____$2);
if(or__28141__auto__){
return or__28141__auto__;
} else {
var or__28141__auto____$1 = (function (){var and__28129__auto__ = this__38841__auto__.state;
if(cljs.core.truth_(and__28129__auto__)){
return cljs.core.not_EQ_.call(null,goog.object.get(this__38841__auto__.state,"omcljs$state"),goog.object.get(next_state__38843__auto__,"omcljs$state"));
} else {
return and__28129__auto__;
}
})();
if(cljs.core.truth_(or__28141__auto____$1)){
return or__28141__auto____$1;
} else {
return cljs.core.not_EQ_.call(null,this__38841__auto__.props.children,next_children__38844__auto__);
}
}
});})(x56361_56373))
;

x56361_56373.componentWillUnmount = ((function (x56361_56373){
return (function (){
var this__38841__auto__ = this;
var r__38852__auto__ = om.next.get_reconciler.call(null,this__38841__auto__);
var cfg__38853__auto__ = new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(r__38852__auto__);
var st__38854__auto__ = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(cfg__38853__auto__);
var indexer__38851__auto__ = new cljs.core.Keyword(null,"indexer","indexer",-1774914315).cljs$core$IFn$_invoke$arity$1(cfg__38853__auto__);
if(cljs.core.truth_((function (){var and__28129__auto__ = !((st__38854__auto__ == null));
if(and__28129__auto__){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,st__38854__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("om.next","queries","om.next/queries",-22717146),this__38841__auto__], null));
} else {
return and__28129__auto__;
}
})())){
cljs.core.swap_BANG_.call(null,st__38854__auto__,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("om.next","queries","om.next/queries",-22717146)], null),cljs.core.dissoc,this__38841__auto__);
} else {
}

if((indexer__38851__auto__ == null)){
return null;
} else {
return om.next.protocols.drop_component_BANG_.call(null,indexer__38851__auto__,this__38841__auto__);
}
});})(x56361_56373))
;

x56361_56373.componentDidUpdate = ((function (x56361_56373){
return (function (prev_props__38849__auto__,prev_state__38850__auto__){
var this__38841__auto__ = this;
return om.next.clear_prev_props_BANG_.call(null,this__38841__auto__);
});})(x56361_56373))
;

x56361_56373.isMounted = ((function (x56361_56373){
return (function (){
var this__38841__auto__ = this;
return cljs.core.boolean$.call(null,goog.object.getValueByKeys(this__38841__auto__,"_reactInternalInstance","_renderedComponent"));
});})(x56361_56373))
;

x56361_56373.componentWillMount = ((function (x56361_56373){
return (function (){
var this__38841__auto__ = this;
var indexer__38851__auto__ = cljs.core.get_in.call(null,om.next.get_reconciler.call(null,this__38841__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
if((indexer__38851__auto__ == null)){
return null;
} else {
return om.next.protocols.index_component_BANG_.call(null,indexer__38851__auto__,this__38841__auto__);
}
});})(x56361_56373))
;

x56361_56373.render = ((function (x56361_56373){
return (function (){
var this__38840__auto__ = this;
var this$ = this__38840__auto__;
var _STAR_reconciler_STAR_56364 = om.next._STAR_reconciler_STAR_;
var _STAR_depth_STAR_56365 = om.next._STAR_depth_STAR_;
var _STAR_shared_STAR_56366 = om.next._STAR_shared_STAR_;
var _STAR_instrument_STAR_56367 = om.next._STAR_instrument_STAR_;
var _STAR_parent_STAR_56368 = om.next._STAR_parent_STAR_;
om.next._STAR_reconciler_STAR_ = om.next.get_reconciler.call(null,this__38840__auto__);

om.next._STAR_depth_STAR_ = (om.next.depth.call(null,this__38840__auto__) + (1));

om.next._STAR_shared_STAR_ = om.next.shared.call(null,this__38840__auto__);

om.next._STAR_instrument_STAR_ = om.next.instrument.call(null,this__38840__auto__);

om.next._STAR_parent_STAR_ = this__38840__auto__;

try{var map__56369 = om.next.props.call(null,this$);
var map__56369__$1 = ((((!((map__56369 == null)))?((((map__56369.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56369.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56369):map__56369);
var tests_by_namespace = map__56369__$1;
var current_filter = cljs.core.get.call(null,map__56369__$1,new cljs.core.Keyword(null,"current-filter","current-filter",1519815247));
if(cljs.core.seq.call(null,new cljs.core.Keyword(null,"test-items","test-items",1900391985).cljs$core$IFn$_invoke$arity$1(tests_by_namespace))){
return om.dom.li.call(null,({"className": "test-item"}),om.dom.div.call(null,({"className": "test-namespace"}),om.dom.h2.call(null,({"className": fulcro_spec.renderer.test_item_class.call(null,new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(tests_by_namespace))}),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(tests_by_namespace))].join('')),om.dom.ul.call(null,({"className": "test-list"}),cljs.core.sequence.call(null,cljs.core.comp.call(null,fulcro_spec.renderer.filters.call(null,current_filter),cljs.core.map.call(null,((function (map__56369,map__56369__$1,tests_by_namespace,current_filter,_STAR_reconciler_STAR_56364,_STAR_depth_STAR_56365,_STAR_shared_STAR_56366,_STAR_instrument_STAR_56367,_STAR_parent_STAR_56368,this$,this__38840__auto__,x56361_56373){
return (function (p1__56358_SHARP_){
return cljs.core.assoc.call(null,p1__56358_SHARP_,new cljs.core.Keyword(null,"current-filter","current-filter",1519815247),current_filter);
});})(map__56369,map__56369__$1,tests_by_namespace,current_filter,_STAR_reconciler_STAR_56364,_STAR_depth_STAR_56365,_STAR_shared_STAR_56366,_STAR_instrument_STAR_56367,_STAR_parent_STAR_56368,this$,this__38840__auto__,x56361_56373))
),cljs.core.map.call(null,fulcro_spec.renderer.ui_test_item)),cljs.core.sort_by.call(null,cljs.core.comp.call(null,new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"form-meta","form-meta",-352800224)),new cljs.core.Keyword(null,"test-items","test-items",1900391985).cljs$core$IFn$_invoke$arity$1(tests_by_namespace))))));
} else {
return null;
}
}finally {om.next._STAR_parent_STAR_ = _STAR_parent_STAR_56368;

om.next._STAR_instrument_STAR_ = _STAR_instrument_STAR_56367;

om.next._STAR_shared_STAR_ = _STAR_shared_STAR_56366;

om.next._STAR_depth_STAR_ = _STAR_depth_STAR_56365;

om.next._STAR_reconciler_STAR_ = _STAR_reconciler_STAR_56364;
}});})(x56361_56373))
;


fulcro_spec.renderer.TestNamespace.prototype.constructor = fulcro_spec.renderer.TestNamespace;

fulcro_spec.renderer.TestNamespace.prototype.constructor.displayName = "fulcro-spec.renderer/TestNamespace";

fulcro_spec.renderer.TestNamespace.prototype.om$isComponent = true;

var x56371_56377 = fulcro_spec.renderer.TestNamespace;


var x56372_56378 = fulcro_spec.renderer.TestNamespace.prototype;


fulcro_spec.renderer.TestNamespace.cljs$lang$type = true;

fulcro_spec.renderer.TestNamespace.cljs$lang$ctorStr = "fulcro-spec.renderer/TestNamespace";

fulcro_spec.renderer.TestNamespace.cljs$lang$ctorPrWriter = (function (this__38957__auto__,writer__38958__auto__,opt__38959__auto__){
return cljs.core._write.call(null,writer__38958__auto__,"fulcro-spec.renderer/TestNamespace");
});
fulcro_spec.renderer.ui_test_namespace = om.next.factory.call(null,fulcro_spec.renderer.TestNamespace,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"keyfn","keyfn",780060332),new cljs.core.Keyword(null,"name","name",1843675177)], null));
fulcro_spec.renderer.material_icon_paths = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"check","check",1226308904),new cljs.core.Keyword(null,"update","update",1045576396),new cljs.core.Keyword(null,"pan_tool","pan_tool",-306611187),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"access_time","access_time",-1820282641),new cljs.core.Keyword(null,"warning","warning",-1685650671),new cljs.core.Keyword(null,"assignment","assignment",1330426519),new cljs.core.Keyword(null,"help","help",-439233446),new cljs.core.Keyword(null,"hourglass_empty","hourglass_empty",141670077),new cljs.core.Keyword(null,"menu","menu",352255198)],["M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41z","M21 10.12h-6.78l2.74-2.82c-2.73-2.7-7.15-2.8-9.88-.1-2.73 2.71-2.73 7.08 0 9.79 2.73 2.71 7.15 2.71 9.88 0C18.32 15.65 19 14.08 19 12.1h2c0 1.98-.88 4.55-2.64 6.29-3.51 3.48-9.21 3.48-12.72 0-3.5-3.47-3.53-9.11-.02-12.58 3.51-3.47 9.14-3.47 12.65 0L21 3v7.12zM12.5 8v4.25l3.5 2.08-.72 1.21L11 13V8h1.5z","M23 5.5V20c0 2.2-1.8 4-4 4h-7.3c-1.08 0-2.1-.43-2.85-1.19L1 14.83s1.26-1.23 1.3-1.25c.22-.19.49-.29.79-.29.22 0 .42.06.6.16.04.01 4.31 2.46 4.31 2.46V4c0-.83.67-1.5 1.5-1.5S11 3.17 11 4v7h1V1.5c0-.83.67-1.5 1.5-1.5S15 .67 15 1.5V11h1V2.5c0-.83.67-1.5 1.5-1.5s1.5.67 1.5 1.5V11h1V5.5c0-.83.67-1.5 1.5-1.5s1.5.67 1.5 1.5z","M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12z","M11.99 2C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2zM12 20c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8zm.5-13H11v6l5.25 3.15.75-1.23-4.5-2.67z","M1 21h22L12 2 1 21zm12-3h-2v-2h2v2zm0-4h-2v-4h2v4z","M19 3h-4.18C14.4 1.84 13.3 1 12 1c-1.3 0-2.4.84-2.82 2H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-7 0c.55 0 1 .45 1 1s-.45 1-1 1-1-.45-1-1 .45-1 1-1zm2 14H7v-2h7v2zm3-4H7v-2h10v2zm0-4H7V7h10v2z","M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 17h-2v-2h2v2zm2.07-7.75l-.9.92C13.45 12.9 13 13.5 13 15h-2v-.5c0-1.1.45-2.1 1.17-2.83l1.24-1.26c.37-.36.59-.86.59-1.41 0-1.1-.9-2-2-2s-2 .9-2 2H8c0-2.21 1.79-4 4-4s4 1.79 4 4c0 .88-.36 1.68-.93 2.25z","M6 2v6h.01L6 8.01 10 12l-4 4 .01.01H6V22h12v-5.99h-.01L18 16l-4-4 4-3.99-.01-.01H18V2H6zm10 14.5V20H8v-3.5l4-4 4 4zm-4-5l-4-4V4h8v3.5l-4 4z","M3 18h18v-2H3v2zm0-5h18v-2H3v2zm0-7v2h18V6H3z"]);
fulcro_spec.renderer.state_mods = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"is","is",369128998),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 16, [new cljs.core.Keyword(null,"open","open",-1763596448),null,new cljs.core.Keyword(null,"informative","informative",1852560673),null,new cljs.core.Keyword(null,"collapsed","collapsed",-628494523),null,new cljs.core.Keyword(null,"disabled","disabled",-1529784218),null,new cljs.core.Keyword(null,"neutral","neutral",-1941956087),null,new cljs.core.Keyword(null,"positive","positive",1112941866),null,new cljs.core.Keyword(null,"negative","negative",-1562068438),null,new cljs.core.Keyword(null,"featured","featured",1584623723),null,new cljs.core.Keyword(null,"invalid","invalid",412869516),null,new cljs.core.Keyword(null,"passive","passive",252884080),null,new cljs.core.Keyword(null,"indeterminate","indeterminate",-513040976),null,new cljs.core.Keyword(null,"alterable","alterable",1971374420),null,new cljs.core.Keyword(null,"active","active",1895962068),null,new cljs.core.Keyword(null,"optional","optional",2053951509),null,new cljs.core.Keyword(null,"error","error",-978969032),null,new cljs.core.Keyword(null,"live","live",-1610148039),null], null), null),new cljs.core.Keyword(null,"has","has",1466247447),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"descendents","descendents",-2087093947),null,new cljs.core.Keyword(null,"actions","actions",-812656882),null,new cljs.core.Keyword(null,"focus","focus",234677911),null], null), null)], null);
/**
 * `fragments` is a collection of fragmentsto concatinate.
 */
fulcro_spec.renderer.concat_class_string = (function fulcro_spec$renderer$concat_class_string(var_args){
var G__56380 = arguments.length;
switch (G__56380) {
case 1:
return fulcro_spec.renderer.concat_class_string.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fulcro_spec.renderer.concat_class_string.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fulcro_spec.renderer.concat_class_string.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fulcro_spec.renderer.concat_class_string.cljs$core$IFn$_invoke$arity$1 = (function (fragments){
return fulcro_spec.renderer.concat_class_string.call(null,"","",fragments);
});

fulcro_spec.renderer.concat_class_string.cljs$core$IFn$_invoke$arity$2 = (function (type,fragments){
return fulcro_spec.renderer.concat_class_string.call(null,"",type,fragments);
});

fulcro_spec.renderer.concat_class_string.cljs$core$IFn$_invoke$arity$3 = (function (base_str,type,fragments){
return cljs.core.reduce.call(null,(function (acc,n){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(acc)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(base_str),cljs.core.str.cljs$core$IFn$_invoke$arity$1(type),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,n))].join(''))].join('');
}),base_str,fragments);
});

fulcro_spec.renderer.concat_class_string.cljs$lang$maxFixedArity = 3;

fulcro_spec.renderer.concat_state_string = (function fulcro_spec$renderer$concat_state_string(states){
return cljs.core.reduce.call(null,(function (acc,n){
var middle = (cljs.core.truth_(cljs.core.not_empty.call(null,acc))?" ":null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"is","is",369128998).cljs$core$IFn$_invoke$arity$1(fulcro_spec.renderer.state_mods).call(null,n))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(acc),cljs.core.str.cljs$core$IFn$_invoke$arity$1(middle),cljs.core.str.cljs$core$IFn$_invoke$arity$1(["is-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,n))].join(''))].join('');
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"has","has",1466247447).cljs$core$IFn$_invoke$arity$1(fulcro_spec.renderer.state_mods).call(null,n))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(acc),cljs.core.str.cljs$core$IFn$_invoke$arity$1(middle),cljs.core.str.cljs$core$IFn$_invoke$arity$1(["has-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,n))].join(''))].join('');
} else {
return acc;

}
}
}),"",states);
});
/**
 * Capitalize every word in a string
 */
fulcro_spec.renderer.title_case = (function fulcro_spec$renderer$title_case(s){
return clojure.string.join.call(null,cljs.core.map.call(null,clojure.string.capitalize,clojure.string.split.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(s)].join(''),/\b/)));
});
fulcro_spec.renderer.icon = (function fulcro_spec$renderer$icon(var_args){
var args__29319__auto__ = [];
var len__29312__auto___56388 = arguments.length;
var i__29313__auto___56389 = (0);
while(true){
if((i__29313__auto___56389 < len__29312__auto___56388)){
args__29319__auto__.push((arguments[i__29313__auto___56389]));

var G__56390 = (i__29313__auto___56389 + (1));
i__29313__auto___56389 = G__56390;
continue;
} else {
}
break;
}

var argseq__29320__auto__ = ((((1) < args__29319__auto__.length))?(new cljs.core.IndexedSeq(args__29319__auto__.slice((1)),(0),null)):null);
return fulcro_spec.renderer.icon.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29320__auto__);
});

fulcro_spec.renderer.icon.cljs$core$IFn$_invoke$arity$variadic = (function (icon_path,p__56384){
var map__56385 = p__56384;
var map__56385__$1 = ((((!((map__56385 == null)))?((((map__56385.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56385.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56385):map__56385);
var width = cljs.core.get.call(null,map__56385__$1,new cljs.core.Keyword(null,"width","width",-384071477));
var height = cljs.core.get.call(null,map__56385__$1,new cljs.core.Keyword(null,"height","height",1025178622));
var modifiers = cljs.core.get.call(null,map__56385__$1,new cljs.core.Keyword(null,"modifiers","modifiers",50378834));
var states = cljs.core.get.call(null,map__56385__$1,new cljs.core.Keyword(null,"states","states",1389013542));
var className = cljs.core.get.call(null,map__56385__$1,new cljs.core.Keyword(null,"className","className",-1983287057));
var onClick = cljs.core.get.call(null,map__56385__$1,new cljs.core.Keyword(null,"onClick","onClick",-1991238530));
if((icon_path instanceof cljs.core.Keyword)){
} else {
throw (new Error(["Assert failed: ","Must pass a :key","\n","(keyword? icon-path)"].join('')));
}

var add_class = ((function (map__56385,map__56385__$1,width,height,modifiers,states,className,onClick){
return (function (attrs){
return null;
});})(map__56385,map__56385__$1,width,height,modifiers,states,className,onClick))
;
var path_check = icon_path.call(null,fulcro_spec.renderer.material_icon_paths);
var icon_name = clojure.string.replace.call(null,cljs.core.name.call(null,icon_path),/_/,"-");
if(clojure.string.blank_QMARK_.call(null,path_check)){
return null;
} else {
return om.dom.svg.call(null,cljs.core.clj__GT_js.call(null,(function (){var G__56387 = new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"className","className",-1983287057),clojure.string.join.call(null," ",new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [fulcro_spec.renderer.concat_class_string.call(null,"c-icon","--",modifiers),["c-icon--",cljs.core.str.cljs$core$IFn$_invoke$arity$1(icon_name)].join(''),fulcro_spec.renderer.concat_state_string.call(null,states),fulcro_spec.renderer.concat_class_string.call(null,className)], null)),new cljs.core.Keyword(null,"version","version",425292698),"1.1",new cljs.core.Keyword(null,"xmlns","xmlns",-1862095571),"http://www.w3.org/2000/svg",new cljs.core.Keyword(null,"width","width",-384071477),"24",new cljs.core.Keyword(null,"height","height",1025178622),"24",new cljs.core.Keyword(null,"aria-labelledby","aria-labelledby",1817118667),"title",new cljs.core.Keyword(null,"role","role",-736691072),"img",new cljs.core.Keyword(null,"viewBox","viewBox",-469489477),"0 0 24 24"], null);
if(cljs.core.truth_(onClick)){
return cljs.core.assoc.call(null,G__56387,new cljs.core.Keyword(null,"onClick","onClick",-1991238530),((function (G__56387,add_class,path_check,icon_name,map__56385,map__56385__$1,width,height,modifiers,states,className,onClick){
return (function (){
return onClick.call(null);
});})(G__56387,add_class,path_check,icon_name,map__56385,map__56385__$1,width,height,modifiers,states,className,onClick))
);
} else {
return G__56387;
}
})()),om.dom.title.call(null,null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(fulcro_spec.renderer.title_case.call(null,clojure.string.replace.call(null,cljs.core.name.call(null,icon_path),/_/," ")))].join('')),om.dom.path.call(null,({"d": path_check})));
}
});

fulcro_spec.renderer.icon.cljs$lang$maxFixedArity = (1);

fulcro_spec.renderer.icon.cljs$lang$applyTo = (function (seq56382){
var G__56383 = cljs.core.first.call(null,seq56382);
var seq56382__$1 = cljs.core.next.call(null,seq56382);
return fulcro_spec.renderer.icon.cljs$core$IFn$_invoke$arity$variadic(G__56383,seq56382__$1);
});

fulcro_spec.renderer.filter_button = (function fulcro_spec$renderer$filter_button(var_args){
var G__56392 = arguments.length;
switch (G__56392) {
case 2:
return fulcro_spec.renderer.filter_button.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 5:
return fulcro_spec.renderer.filter_button.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fulcro_spec.renderer.filter_button.cljs$core$IFn$_invoke$arity$2 = (function (icon_type,data){
return fulcro_spec.renderer.filter_button.call(null,icon_type,data,cljs.core.gensym.call(null),cljs.core.gensym.call(null),cljs.core.constantly.call(null,null));
});

fulcro_spec.renderer.filter_button.cljs$core$IFn$_invoke$arity$5 = (function (icon_type,data,this_filter,current_filter,toggle_filter_cb){
var is_active_QMARK_ = cljs.core._EQ_.call(null,this_filter,current_filter);
return om.dom.button.call(null,({"className": "c-button c-button--icon", "onClick": toggle_filter_cb.call(null,this_filter)}),fulcro_spec.renderer.icon.call(null,icon_type,new cljs.core.Keyword(null,"states","states",1389013542),(function (){var G__56393 = cljs.core.PersistentVector.EMPTY;
if(is_active_QMARK_){
return cljs.core.conj.call(null,G__56393,new cljs.core.Keyword(null,"active","active",1895962068));
} else {
return G__56393;
}
})()),om.dom.span.call(null,({"className": (function (){var G__56394 = "c-message";
if(is_active_QMARK_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__56394)," c-message--primary"].join('');
} else {
return G__56394;
}
})()}),data));
});

fulcro_spec.renderer.filter_button.cljs$lang$maxFixedArity = 5;

fulcro_spec.renderer.find_tests = (function fulcro_spec$renderer$find_tests(test_filter,namespaces){
return cljs.core.remove.call(null,cljs.core.some_fn.call(null,cljs.core.nil_QMARK_,cljs.core.comp.call(null,cljs.core.seq,new cljs.core.Keyword(null,"test-items","test-items",1900391985))),cljs.core.apply.call(null,cljs.core.tree_seq,cljs.core.comp.call(null,cljs.core.seq,new cljs.core.Keyword(null,"test-items","test-items",1900391985)),cljs.core.comp.call(null,cljs.core.partial.call(null,cljs.core.sequence,fulcro_spec.renderer.filters.call(null,test_filter)),new cljs.core.Keyword(null,"test-items","test-items",1900391985)),cljs.core.sequence.call(null,fulcro_spec.renderer.filters.call(null,test_filter),namespaces)));
});
fulcro_spec.renderer.test_info = (function fulcro_spec$renderer$test_info(p__56396,current_filter,toggle_filter_cb){
var map__56397 = p__56396;
var map__56397__$1 = ((((!((map__56397 == null)))?((((map__56397.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56397.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56397):map__56397);
var pass = cljs.core.get.call(null,map__56397__$1,new cljs.core.Keyword(null,"pass","pass",1574159993));
var fail = cljs.core.get.call(null,map__56397__$1,new cljs.core.Keyword(null,"fail","fail",1706214930));
var error = cljs.core.get.call(null,map__56397__$1,new cljs.core.Keyword(null,"error","error",-978969032));
var namespaces = cljs.core.get.call(null,map__56397__$1,new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469));
var end_time = cljs.core.get.call(null,map__56397__$1,new cljs.core.Keyword(null,"end-time","end-time",-1849817460));
var run_time = cljs.core.get.call(null,map__56397__$1,new cljs.core.Keyword(null,"run-time","run-time",-1231674133));
var total = ((pass + fail) + error);
var end_time__$1 = (new goog.i18n.DateTimeFormat("HH:mm:ss")).format((function (){var or__28141__auto__ = (function (){var and__28129__auto__ = end_time;
if(cljs.core.truth_(and__28129__auto__)){
return (new goog.date.DateTime()).setTime(end_time);
} else {
return and__28129__auto__;
}
})();
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
return (new goog.date.DateTime());
}
})());
var run_time__$1 = clojure.string.replace_first.call(null,goog.string.format("%.3fs",(run_time / (1000))),/^0/,"");
if(((fail + error) > (0))){
fulcro_spec.renderer.change_favicon_to_color.call(null,"#d00");
} else {
fulcro_spec.renderer.change_favicon_to_color.call(null,"#0d0");
}

return om.dom.span.call(null,null,fulcro_spec.renderer.filter_button.call(null,new cljs.core.Keyword(null,"assignment","assignment",1330426519),cljs.core.count.call(null,namespaces)),fulcro_spec.renderer.filter_button.call(null,new cljs.core.Keyword(null,"help","help",-439233446),total),fulcro_spec.renderer.filter_button.call(null,new cljs.core.Keyword(null,"check","check",1226308904),pass,new cljs.core.Keyword(null,"passing","passing",154799600),current_filter,toggle_filter_cb),fulcro_spec.renderer.filter_button.call(null,new cljs.core.Keyword(null,"update","update",1045576396),cljs.core.count.call(null,fulcro_spec.renderer.find_tests.call(null,new cljs.core.Keyword(null,"pending","pending",-220036727),namespaces)),new cljs.core.Keyword(null,"pending","pending",-220036727),current_filter,toggle_filter_cb),fulcro_spec.renderer.filter_button.call(null,new cljs.core.Keyword(null,"pan_tool","pan_tool",-306611187),cljs.core.count.call(null,fulcro_spec.renderer.find_tests.call(null,new cljs.core.Keyword(null,"manual","manual",-237370608),namespaces)),new cljs.core.Keyword(null,"manual","manual",-237370608),current_filter,toggle_filter_cb),fulcro_spec.renderer.filter_button.call(null,new cljs.core.Keyword(null,"close","close",1835149582),fail,new cljs.core.Keyword(null,"failing","failing",-324520682),current_filter,toggle_filter_cb),fulcro_spec.renderer.filter_button.call(null,new cljs.core.Keyword(null,"warning","warning",-1685650671),error,new cljs.core.Keyword(null,"failing","failing",-324520682),current_filter,toggle_filter_cb),fulcro_spec.renderer.filter_button.call(null,new cljs.core.Keyword(null,"access_time","access_time",-1820282641),end_time__$1),fulcro_spec.renderer.filter_button.call(null,new cljs.core.Keyword(null,"hourglass_empty","hourglass_empty",141670077),run_time__$1));
});
var render_input_56405 = (function (p__56399){
var map__56400 = p__56399;
var map__56400__$1 = ((((!((map__56400 == null)))?((((map__56400.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56400.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56400):map__56400);
var props = map__56400__$1;
var type = cljs.core.get.call(null,map__56400__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var id = cljs.core.get.call(null,map__56400__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
return om.dom.span.call(null,null,om.dom.input.call(null,cljs.core.clj__GT_js.call(null,props)),om.dom.label.call(null,({"htmlFor": id}),"\u00A0"));
});
/**
 * Render a checkbox (not the label). Props is a normal clj(s) map with React/HTML attributes plus:
 * 
 *   `:className` - additional class stylings to apply to the top level of the checkbox
 *   `:id` string - Unique DOM ID. Required for correct rendering.
 *   `:checked` - true, false, or :partial
 */
fulcro_spec.renderer.ui_checkbox = ((function (render_input_56405){
return (function fulcro_spec$renderer$ui_checkbox(p__56402){
var map__56403 = p__56402;
var map__56403__$1 = ((((!((map__56403 == null)))?((((map__56403.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56403.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56403):map__56403);
var props = map__56403__$1;
var id = cljs.core.get.call(null,map__56403__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var state = cljs.core.get.call(null,map__56403__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var checked = cljs.core.get.call(null,map__56403__$1,new cljs.core.Keyword(null,"checked","checked",-50955819));
var className = cljs.core.get.call(null,map__56403__$1,new cljs.core.Keyword(null,"className","className",-1983287057));
if(cljs.core.truth_(id)){
} else {
throw (new Error(["Assert failed: ","DOM ID is required on checkbox","\n","id"].join('')));
}

var classes = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(className)," c-checkbox",cljs.core.str.cljs$core$IFn$_invoke$arity$1(((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"partial","partial",241141745),checked))?" is-indeterminate":null))].join('');
var checked__$1 = cljs.core.boolean$.call(null,checked);
var attrs = cljs.core.assoc.call(null,props,new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"checked","checked",-50955819),checked__$1,new cljs.core.Keyword(null,"className","className",-1983287057),classes);
return render_input_56405.call(null,attrs);
});})(render_input_56405))
;
if(typeof fulcro_spec.renderer.SelectorControl !== 'undefined'){
} else {
/**
 * @constructor
 */
fulcro_spec.renderer.SelectorControl = (function fulcro_spec$renderer$SelectorControl(){
var this__38954__auto__ = this;
React.Component.apply(this__38954__auto__,arguments);

if(!((this__38954__auto__.initLocalState == null))){
this__38954__auto__.state = this__38954__auto__.initLocalState();
} else {
this__38954__auto__.state = {};
}

return this__38954__auto__;
});

fulcro_spec.renderer.SelectorControl.prototype = goog.object.clone(React.Component.prototype);
}

var x56408_56420 = fulcro_spec.renderer.SelectorControl.prototype;
x56408_56420.componentWillUpdate = ((function (x56408_56420){
return (function (next_props__38842__auto__,next_state__38843__auto__){
var this__38841__auto__ = this;
if(((!((this__38841__auto__ == null)))?(((false) || ((cljs.core.PROTOCOL_SENTINEL === this__38841__auto__.om$next$Ident$)))?true:false):false)){
var ident__38845__auto___56421 = om.next.ident.call(null,this__38841__auto__,om.next.props.call(null,this__38841__auto__));
var next_ident__38846__auto___56422 = om.next.ident.call(null,this__38841__auto__,om.next._next_props.call(null,next_props__38842__auto__,this__38841__auto__));
if(cljs.core.not_EQ_.call(null,ident__38845__auto___56421,next_ident__38846__auto___56422)){
var idxr__38847__auto___56423 = cljs.core.get_in.call(null,om.next.get_reconciler.call(null,this__38841__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
if((idxr__38847__auto___56423 == null)){
} else {
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"indexes","indexes",1496475545).cljs$core$IFn$_invoke$arity$1(idxr__38847__auto___56423),((function (idxr__38847__auto___56423,ident__38845__auto___56421,next_ident__38846__auto___56422,this__38841__auto__,x56408_56420){
return (function (indexes__38848__auto__){
return cljs.core.update_in.call(null,cljs.core.update_in.call(null,indexes__38848__auto__,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ref->components","ref->components",-303587249),ident__38845__auto___56421], null),cljs.core.disj,this__38841__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ref->components","ref->components",-303587249),next_ident__38846__auto___56422], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentHashSet.EMPTY),this__38841__auto__);
});})(idxr__38847__auto___56423,ident__38845__auto___56421,next_ident__38846__auto___56422,this__38841__auto__,x56408_56420))
);
}
} else {
}
} else {
}

om.next.merge_pending_props_BANG_.call(null,this__38841__auto__);

return om.next.merge_pending_state_BANG_.call(null,this__38841__auto__);
});})(x56408_56420))
;

x56408_56420.shouldComponentUpdate = ((function (x56408_56420){
return (function (next_props__38842__auto__,next_state__38843__auto__){
var this__38841__auto__ = this;
var next_children__38844__auto__ = next_props__38842__auto__.children;
var next_props__38842__auto____$1 = goog.object.get(next_props__38842__auto__,"omcljs$value");
var next_props__38842__auto____$2 = (function (){var G__56410 = next_props__38842__auto____$1;
if((next_props__38842__auto____$1 instanceof om.next.OmProps)){
return om.next.unwrap.call(null,G__56410);
} else {
return G__56410;
}
})();
var or__28141__auto__ = cljs.core.not_EQ_.call(null,om.next.props.call(null,this__38841__auto__),next_props__38842__auto____$2);
if(or__28141__auto__){
return or__28141__auto__;
} else {
var or__28141__auto____$1 = (function (){var and__28129__auto__ = this__38841__auto__.state;
if(cljs.core.truth_(and__28129__auto__)){
return cljs.core.not_EQ_.call(null,goog.object.get(this__38841__auto__.state,"omcljs$state"),goog.object.get(next_state__38843__auto__,"omcljs$state"));
} else {
return and__28129__auto__;
}
})();
if(cljs.core.truth_(or__28141__auto____$1)){
return or__28141__auto____$1;
} else {
return cljs.core.not_EQ_.call(null,this__38841__auto__.props.children,next_children__38844__auto__);
}
}
});})(x56408_56420))
;

x56408_56420.componentWillUnmount = ((function (x56408_56420){
return (function (){
var this__38841__auto__ = this;
var r__38852__auto__ = om.next.get_reconciler.call(null,this__38841__auto__);
var cfg__38853__auto__ = new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(r__38852__auto__);
var st__38854__auto__ = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(cfg__38853__auto__);
var indexer__38851__auto__ = new cljs.core.Keyword(null,"indexer","indexer",-1774914315).cljs$core$IFn$_invoke$arity$1(cfg__38853__auto__);
if(cljs.core.truth_((function (){var and__28129__auto__ = !((st__38854__auto__ == null));
if(and__28129__auto__){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,st__38854__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("om.next","queries","om.next/queries",-22717146),this__38841__auto__], null));
} else {
return and__28129__auto__;
}
})())){
cljs.core.swap_BANG_.call(null,st__38854__auto__,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("om.next","queries","om.next/queries",-22717146)], null),cljs.core.dissoc,this__38841__auto__);
} else {
}

if((indexer__38851__auto__ == null)){
return null;
} else {
return om.next.protocols.drop_component_BANG_.call(null,indexer__38851__auto__,this__38841__auto__);
}
});})(x56408_56420))
;

x56408_56420.componentDidUpdate = ((function (x56408_56420){
return (function (prev_props__38849__auto__,prev_state__38850__auto__){
var this__38841__auto__ = this;
return om.next.clear_prev_props_BANG_.call(null,this__38841__auto__);
});})(x56408_56420))
;

x56408_56420.isMounted = ((function (x56408_56420){
return (function (){
var this__38841__auto__ = this;
return cljs.core.boolean$.call(null,goog.object.getValueByKeys(this__38841__auto__,"_reactInternalInstance","_renderedComponent"));
});})(x56408_56420))
;

x56408_56420.componentWillMount = ((function (x56408_56420){
return (function (){
var this__38841__auto__ = this;
var indexer__38851__auto__ = cljs.core.get_in.call(null,om.next.get_reconciler.call(null,this__38841__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
if((indexer__38851__auto__ == null)){
return null;
} else {
return om.next.protocols.index_component_BANG_.call(null,indexer__38851__auto__,this__38841__auto__);
}
});})(x56408_56420))
;

x56408_56420.render = ((function (x56408_56420){
return (function (){
var this__38840__auto__ = this;
var this$ = this__38840__auto__;
var _STAR_reconciler_STAR_56411 = om.next._STAR_reconciler_STAR_;
var _STAR_depth_STAR_56412 = om.next._STAR_depth_STAR_;
var _STAR_shared_STAR_56413 = om.next._STAR_shared_STAR_;
var _STAR_instrument_STAR_56414 = om.next._STAR_instrument_STAR_;
var _STAR_parent_STAR_56415 = om.next._STAR_parent_STAR_;
om.next._STAR_reconciler_STAR_ = om.next.get_reconciler.call(null,this__38840__auto__);

om.next._STAR_depth_STAR_ = (om.next.depth.call(null,this__38840__auto__) + (1));

om.next._STAR_shared_STAR_ = om.next.shared.call(null,this__38840__auto__);

om.next._STAR_instrument_STAR_ = om.next.instrument.call(null,this__38840__auto__);

om.next._STAR_parent_STAR_ = this__38840__auto__;

try{var map__56416 = om.next.props.call(null,this$);
var map__56416__$1 = ((((!((map__56416 == null)))?((((map__56416.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56416.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56416):map__56416);
var id = cljs.core.get.call(null,map__56416__$1,new cljs.core.Keyword("selector","id","selector/id",1917888117));
var active_QMARK_ = cljs.core.get.call(null,map__56416__$1,new cljs.core.Keyword("selector","active?","selector/active?",604593375));
return om.dom.div.call(null,({"className": "c-drawer__action", "key": [cljs.core.str.cljs$core$IFn$_invoke$arity$1(id)].join('')}),fulcro_spec.renderer.ui_checkbox.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"id","id",-1388402092),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(id)].join(''),new cljs.core.Keyword(null,"checked","checked",-50955819),active_QMARK_,new cljs.core.Keyword(null,"onChange","onChange",-312891301),((function (map__56416,map__56416__$1,id,active_QMARK_,_STAR_reconciler_STAR_56411,_STAR_depth_STAR_56412,_STAR_shared_STAR_56413,_STAR_instrument_STAR_56414,_STAR_parent_STAR_56415,this$,this__38840__auto__,x56408_56420){
return (function (e){
return om.next.transact_BANG_.call(null,this$,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__29003__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("fulcro-spec.selectors","set-selector","fulcro-spec.selectors/set-selector",483272861,null)),(function (){var x__29003__auto__ = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("selector","id","selector/id",1917888117),id,new cljs.core.Keyword("selector","active?","selector/active?",604593375),e.target.checked], null);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__29003__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__29003__auto__);
})())))));
});})(map__56416,map__56416__$1,id,active_QMARK_,_STAR_reconciler_STAR_56411,_STAR_depth_STAR_56412,_STAR_shared_STAR_56413,_STAR_instrument_STAR_56414,_STAR_parent_STAR_56415,this$,this__38840__auto__,x56408_56420))
], null)),om.dom.span.call(null,({}),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(id)].join('')));
}finally {om.next._STAR_parent_STAR_ = _STAR_parent_STAR_56415;

om.next._STAR_instrument_STAR_ = _STAR_instrument_STAR_56414;

om.next._STAR_shared_STAR_ = _STAR_shared_STAR_56413;

om.next._STAR_depth_STAR_ = _STAR_depth_STAR_56412;

om.next._STAR_reconciler_STAR_ = _STAR_reconciler_STAR_56411;
}});})(x56408_56420))
;


fulcro_spec.renderer.SelectorControl.prototype.constructor = fulcro_spec.renderer.SelectorControl;

fulcro_spec.renderer.SelectorControl.prototype.constructor.displayName = "fulcro-spec.renderer/SelectorControl";

fulcro_spec.renderer.SelectorControl.prototype.om$isComponent = true;

var x56418_56424 = fulcro_spec.renderer.SelectorControl;
/** @nocollapse */
x56418_56424.om$next$IQuery$ = cljs.core.PROTOCOL_SENTINEL;

/** @nocollapse */
x56418_56424.om$next$IQuery$query$arity$1 = ((function (x56418_56424){
return (function (this$){
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("selector","id","selector/id",1917888117),new cljs.core.Keyword("selector","active?","selector/active?",604593375)], null);
});})(x56418_56424))
;


var x56419_56425 = fulcro_spec.renderer.SelectorControl.prototype;

x56419_56425.om$next$IQuery$ = cljs.core.PROTOCOL_SENTINEL;


x56419_56425.om$next$IQuery$query$arity$1 = ((function (x56419_56425){
return (function (this$){
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("selector","id","selector/id",1917888117),new cljs.core.Keyword("selector","active?","selector/active?",604593375)], null);
});})(x56419_56425))
;


fulcro_spec.renderer.SelectorControl.cljs$lang$type = true;

fulcro_spec.renderer.SelectorControl.cljs$lang$ctorStr = "fulcro-spec.renderer/SelectorControl";

fulcro_spec.renderer.SelectorControl.cljs$lang$ctorPrWriter = (function (this__38957__auto__,writer__38958__auto__,opt__38959__auto__){
return cljs.core._write.call(null,writer__38958__auto__,"fulcro-spec.renderer/SelectorControl");
});
fulcro_spec.renderer.ui_selector_control = om.next.factory.call(null,fulcro_spec.renderer.SelectorControl,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"keyfn","keyfn",780060332),new cljs.core.Keyword("selector","id","selector/id",1917888117)], null));
fulcro_spec.renderer.test_selectors = (function fulcro_spec$renderer$test_selectors(selectors){
return om.dom.div.call(null,null,om.dom.h1.call(null,null,"Test Selectors:"),cljs.core.map.call(null,fulcro_spec.renderer.ui_selector_control,cljs.core.sort_by.call(null,new cljs.core.Keyword("selector","id","selector/id",1917888117),selectors)));
});
fulcro_spec.renderer.toolbar_button = (function fulcro_spec$renderer$toolbar_button(toggle_drawer){
return om.dom.div.call(null,({"className": "c-toolbar__button"}),om.dom.button.call(null,({"className": "c-button c-button--icon", "onClick": toggle_drawer}),fulcro_spec.renderer.icon.call(null,new cljs.core.Keyword(null,"menu","menu",352255198))));
});
fulcro_spec.renderer.test_header = (function fulcro_spec$renderer$test_header(test_report,current_filter,toggle_drawer,toggle_filter_cb){
return om.dom.header.call(null,({"className": "u-layout__header c-toolbar c-toolbar--raised"}),om.dom.div.call(null,({"className": "c-toolbar__row"}),om.dom.h1.call(null,null,"Fulcro Spec"),om.dom.div.call(null,({"className": "c-toolbar__spacer"})),fulcro_spec.renderer.test_info.call(null,test_report,current_filter,toggle_filter_cb)),fulcro_spec.renderer.toolbar_button.call(null,toggle_drawer));
});
/**
 * Generate a layout row. This is a div container for a row in a 12-wide grid responsive layout.
 *   Rows should contain layout columns generated with the `col` function of this namespace.
 * 
 *   The properties are normal DOM attributes as a cljs map and can include standard React DOM properties.
 * 
 *   `:distribute-extra-columns` can be :between or :around, and indicates where to put unused columns.
 *    - :between Unused column space is even distributed between columns
 *        2COL _____ 2COL _____ 2COL
 *    - :around Unused column space is even distributed around columns
 *        __ 2COL __ 2COL __ 2COL __
 * 
 *   `:halign` can be :start, :center, or :end for positioning a single child column in that position
 *   `:valign` can be :top, :middle, or :bottom and will affect the vertical positioning of nested cells that do not
 *   share a common height.
 */
fulcro_spec.renderer.row = (function fulcro_spec$renderer$row(var_args){
var args__29319__auto__ = [];
var len__29312__auto___56432 = arguments.length;
var i__29313__auto___56433 = (0);
while(true){
if((i__29313__auto___56433 < len__29312__auto___56432)){
args__29319__auto__.push((arguments[i__29313__auto___56433]));

var G__56434 = (i__29313__auto___56433 + (1));
i__29313__auto___56433 = G__56434;
continue;
} else {
}
break;
}

var argseq__29320__auto__ = ((((1) < args__29319__auto__.length))?(new cljs.core.IndexedSeq(args__29319__auto__.slice((1)),(0),null)):null);
return fulcro_spec.renderer.row.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29320__auto__);
});

fulcro_spec.renderer.row.cljs$core$IFn$_invoke$arity$variadic = (function (p__56428,children){
var map__56429 = p__56428;
var map__56429__$1 = ((((!((map__56429 == null)))?((((map__56429.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56429.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56429):map__56429);
var props = map__56429__$1;
var distribute_extra_columns = cljs.core.get.call(null,map__56429__$1,new cljs.core.Keyword(null,"distribute-extra-columns","distribute-extra-columns",-2101013909));
var halign = cljs.core.get.call(null,map__56429__$1,new cljs.core.Keyword(null,"halign","halign",-1113968481));
var valign = cljs.core.get.call(null,map__56429__$1,new cljs.core.Keyword(null,"valign","valign",1485197511));
var density = cljs.core.get.call(null,map__56429__$1,new cljs.core.Keyword(null,"density","density",-1664155941));
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [null,null,new cljs.core.Keyword(null,"between","between",1131099276),null,new cljs.core.Keyword(null,"around","around",-265975553),null], null), null),distribute_extra_columns)){
} else {
throw (new Error("Assert failed: (contains? #{nil :between :around} distribute-extra-columns)"));
}

if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [null,null,new cljs.core.Keyword(null,"start","start",-355208981),null,new cljs.core.Keyword(null,"center","center",-748944368),null,new cljs.core.Keyword(null,"end","end",-268185958),null], null), null),halign)){
} else {
throw (new Error("Assert failed: (contains? #{nil :start :center :end} halign)"));
}

if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [null,null,new cljs.core.Keyword(null,"bottom","bottom",-1550509018),null,new cljs.core.Keyword(null,"top","top",-1856271961),null,new cljs.core.Keyword(null,"middle","middle",-701029031),null], null), null),valign)){
} else {
throw (new Error("Assert failed: (contains? #{nil :bottom :top :middle} valign)"));
}

if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [null,null,new cljs.core.Keyword(null,"break","break",126570225),null,new cljs.core.Keyword(null,"collapse","collapse",-1218136136),null,new cljs.core.Keyword(null,"wide","wide",-151772487),null], null), null),density)){
} else {
throw (new Error("Assert failed: (contains? #{nil :break :collapse :wide} density)"));
}

var className = (function (){var or__28141__auto__ = new cljs.core.Keyword(null,"className","className",-1983287057).cljs$core$IFn$_invoke$arity$1(props);
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
return "";
}
})();
var classes = (function (){var G__56431 = className;
var G__56431__$1 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__56431)," u-row"].join('')
;
var G__56431__$2 = (cljs.core.truth_(distribute_extra_columns)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__56431__$1)," u-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,distribute_extra_columns))].join(''):G__56431__$1);
var G__56431__$3 = (cljs.core.truth_(halign)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__56431__$2)," u-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,halign))].join(''):G__56431__$2);
var G__56431__$4 = (cljs.core.truth_(valign)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__56431__$3)," u-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,valign))].join(''):G__56431__$3);
if(cljs.core.truth_(density)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__56431__$4)," u-row--",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,density))].join('');
} else {
return G__56431__$4;
}
})();
var attrs = cljs.core.clj__GT_js.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,props,new cljs.core.Keyword(null,"distribute-extra-columns","distribute-extra-columns",-2101013909),new cljs.core.Keyword(null,"halign","halign",-1113968481),new cljs.core.Keyword(null,"valign","valign",1485197511),new cljs.core.Keyword(null,"density","density",-1664155941)),new cljs.core.Keyword(null,"className","className",-1983287057),classes));
return cljs.core.apply.call(null,om.dom.div,attrs,children);
});

fulcro_spec.renderer.row.cljs$lang$maxFixedArity = (1);

fulcro_spec.renderer.row.cljs$lang$applyTo = (function (seq56426){
var G__56427 = cljs.core.first.call(null,seq56426);
var seq56426__$1 = cljs.core.next.call(null,seq56426);
return fulcro_spec.renderer.row.cljs$core$IFn$_invoke$arity$variadic(G__56427,seq56426__$1);
});

/**
 * Output a div that represents a column in the 12-column responsive grid.
 * 
 *   NOTE: halign works on anything, valign on on rows
 */
fulcro_spec.renderer.col = (function fulcro_spec$renderer$col(var_args){
var args__29319__auto__ = [];
var len__29312__auto___56441 = arguments.length;
var i__29313__auto___56442 = (0);
while(true){
if((i__29313__auto___56442 < len__29312__auto___56441)){
args__29319__auto__.push((arguments[i__29313__auto___56442]));

var G__56443 = (i__29313__auto___56442 + (1));
i__29313__auto___56442 = G__56443;
continue;
} else {
}
break;
}

var argseq__29320__auto__ = ((((1) < args__29319__auto__.length))?(new cljs.core.IndexedSeq(args__29319__auto__.slice((1)),(0),null)):null);
return fulcro_spec.renderer.col.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29320__auto__);
});

fulcro_spec.renderer.col.cljs$core$IFn$_invoke$arity$variadic = (function (p__56437,children){
var map__56438 = p__56437;
var map__56438__$1 = ((((!((map__56438 == null)))?((((map__56438.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56438.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56438):map__56438);
var props = map__56438__$1;
var md_push = cljs.core.get.call(null,map__56438__$1,new cljs.core.Keyword(null,"md-push","md-push",288470810));
var sm_push = cljs.core.get.call(null,map__56438__$1,new cljs.core.Keyword(null,"sm-push","sm-push",1835708573));
var halign = cljs.core.get.call(null,map__56438__$1,new cljs.core.Keyword(null,"halign","halign",-1113968481));
var xl_push = cljs.core.get.call(null,map__56438__$1,new cljs.core.Keyword(null,"xl-push","xl-push",-1108453728));
var sm_width = cljs.core.get.call(null,map__56438__$1,new cljs.core.Keyword(null,"sm-width","sm-width",280805410));
var push = cljs.core.get.call(null,map__56438__$1,new cljs.core.Keyword(null,"push","push",799791267));
var lg_width = cljs.core.get.call(null,map__56438__$1,new cljs.core.Keyword(null,"lg-width","lg-width",420811558));
var valign = cljs.core.get.call(null,map__56438__$1,new cljs.core.Keyword(null,"valign","valign",1485197511));
var lg_push = cljs.core.get.call(null,map__56438__$1,new cljs.core.Keyword(null,"lg-push","lg-push",606284103));
var width = cljs.core.get.call(null,map__56438__$1,new cljs.core.Keyword(null,"width","width",-384071477));
var md_width = cljs.core.get.call(null,map__56438__$1,new cljs.core.Keyword(null,"md-width","md-width",-1317567860));
var xl_width = cljs.core.get.call(null,map__56438__$1,new cljs.core.Keyword(null,"xl-width","xl-width",401581997));
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [null,null,new cljs.core.Keyword(null,"start","start",-355208981),null,new cljs.core.Keyword(null,"center","center",-748944368),null,new cljs.core.Keyword(null,"end","end",-268185958),null], null), null),halign)){
} else {
throw (new Error("Assert failed: (contains? #{nil :start :center :end} halign)"));
}

if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [null,null,new cljs.core.Keyword(null,"bottom","bottom",-1550509018),null,new cljs.core.Keyword(null,"top","top",-1856271961),null,new cljs.core.Keyword(null,"middle","middle",-701029031),null], null), null),valign)){
} else {
throw (new Error("Assert failed: (contains? #{nil :bottom :top :middle} valign)"));
}

var classes = (function (){var G__56440 = new cljs.core.Keyword(null,"className","className",-1983287057).cljs$core$IFn$_invoke$arity$1(props);
var G__56440__$1 = (cljs.core.truth_(width)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__56440)," u-column--",cljs.core.str.cljs$core$IFn$_invoke$arity$1(width)].join(''):G__56440);
var G__56440__$2 = (cljs.core.truth_(halign)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__56440__$1)," u-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,halign))].join(''):G__56440__$1);
var G__56440__$3 = (cljs.core.truth_(valign)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__56440__$2)," u-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,valign))].join(''):G__56440__$2);
var G__56440__$4 = (cljs.core.truth_(sm_width)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__56440__$3)," u-column--",cljs.core.str.cljs$core$IFn$_invoke$arity$1(sm_width),"@sm"].join(''):G__56440__$3);
var G__56440__$5 = (cljs.core.truth_(md_width)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__56440__$4)," u-column--",cljs.core.str.cljs$core$IFn$_invoke$arity$1(md_width),"@md"].join(''):G__56440__$4);
var G__56440__$6 = (cljs.core.truth_(lg_width)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__56440__$5)," u-column--",cljs.core.str.cljs$core$IFn$_invoke$arity$1(lg_width),"@lg"].join(''):G__56440__$5);
var G__56440__$7 = (cljs.core.truth_(xl_width)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__56440__$6)," u-column--",cljs.core.str.cljs$core$IFn$_invoke$arity$1(xl_width),"@xl"].join(''):G__56440__$6);
var G__56440__$8 = (cljs.core.truth_(push)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__56440__$7)," u-push--",cljs.core.str.cljs$core$IFn$_invoke$arity$1(push)].join(''):G__56440__$7);
var G__56440__$9 = (cljs.core.truth_(sm_push)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__56440__$8)," u-push--",cljs.core.str.cljs$core$IFn$_invoke$arity$1(sm_push),"@sm"].join(''):G__56440__$8);
var G__56440__$10 = (cljs.core.truth_(md_push)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__56440__$9)," u-push--",cljs.core.str.cljs$core$IFn$_invoke$arity$1(md_push),"@md"].join(''):G__56440__$9);
var G__56440__$11 = (cljs.core.truth_(lg_push)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__56440__$10)," u-push--",cljs.core.str.cljs$core$IFn$_invoke$arity$1(lg_push),"@lg"].join(''):G__56440__$10);
if(cljs.core.truth_(xl_push)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__56440__$11)," u-push--",cljs.core.str.cljs$core$IFn$_invoke$arity$1(xl_push),"@xl"].join('');
} else {
return G__56440__$11;
}
})();
var attrs = cljs.core.clj__GT_js.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,props,new cljs.core.Keyword(null,"width","width",-384071477),new cljs.core.Keyword(null,"halign","halign",-1113968481),new cljs.core.Keyword(null,"valign","valign",1485197511),new cljs.core.Keyword(null,"sm-width","sm-width",280805410),new cljs.core.Keyword(null,"md-width","md-width",-1317567860),new cljs.core.Keyword(null,"lg-width","lg-width",420811558),new cljs.core.Keyword(null,"xl-width","xl-width",401581997),new cljs.core.Keyword(null,"push","push",799791267),new cljs.core.Keyword(null,"sm-push","sm-push",1835708573),new cljs.core.Keyword(null,"md-push","md-push",288470810),new cljs.core.Keyword(null,"lg-push","lg-push",606284103),new cljs.core.Keyword(null,"xl-push","xl-push",-1108453728)),new cljs.core.Keyword(null,"className","className",-1983287057),classes));
return cljs.core.apply.call(null,om.dom.div,attrs,children);
});

fulcro_spec.renderer.col.cljs$lang$maxFixedArity = (1);

fulcro_spec.renderer.col.cljs$lang$applyTo = (function (seq56435){
var G__56436 = cljs.core.first.call(null,seq56435);
var seq56435__$1 = cljs.core.next.call(null,seq56435);
return fulcro_spec.renderer.col.cljs$core$IFn$_invoke$arity$variadic(G__56436,seq56435__$1);
});

fulcro_spec.renderer.test_main = (function fulcro_spec$renderer$test_main(p__56445,current_filter){
var map__56446 = p__56445;
var map__56446__$1 = ((((!((map__56446 == null)))?((((map__56446.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56446.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56446):map__56446);
var namespaces = cljs.core.get.call(null,map__56446__$1,new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469));
return om.dom.main.call(null,({"className": "u-layout__content"}),om.dom.article.call(null,({"className": "o-article"}),fulcro_spec.renderer.row.call(null,cljs.core.PersistentArrayMap.EMPTY,fulcro_spec.renderer.col.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"width","width",-384071477),(12)], null),om.dom.div.call(null,({"className": "test-report"}),om.dom.ul.call(null,null,cljs.core.sequence.call(null,cljs.core.comp.call(null,fulcro_spec.renderer.filters.call(null,current_filter),cljs.core.map.call(null,((function (map__56446,map__56446__$1,namespaces){
return (function (p1__56444_SHARP_){
return cljs.core.assoc.call(null,p1__56444_SHARP_,new cljs.core.Keyword(null,"current-filter","current-filter",1519815247),current_filter);
});})(map__56446,map__56446__$1,namespaces))
),cljs.core.map.call(null,fulcro_spec.renderer.ui_test_namespace)),cljs.core.sort_by.call(null,new cljs.core.Keyword(null,"name","name",1843675177),namespaces))))))));
});
if(typeof fulcro_spec.renderer.TestReport !== 'undefined'){
} else {
/**
 * @constructor
 */
fulcro_spec.renderer.TestReport = (function fulcro_spec$renderer$TestReport(){
var this__38954__auto__ = this;
React.Component.apply(this__38954__auto__,arguments);

if(!((this__38954__auto__.initLocalState == null))){
this__38954__auto__.state = this__38954__auto__.initLocalState();
} else {
this__38954__auto__.state = {};
}

return this__38954__auto__;
});

fulcro_spec.renderer.TestReport.prototype = goog.object.clone(React.Component.prototype);
}

var x56450_56466 = fulcro_spec.renderer.TestReport.prototype;
x56450_56466.componentWillUpdate = ((function (x56450_56466){
return (function (next_props__38842__auto__,next_state__38843__auto__){
var this__38841__auto__ = this;
if(((!((this__38841__auto__ == null)))?(((false) || ((cljs.core.PROTOCOL_SENTINEL === this__38841__auto__.om$next$Ident$)))?true:false):false)){
var ident__38845__auto___56467 = om.next.ident.call(null,this__38841__auto__,om.next.props.call(null,this__38841__auto__));
var next_ident__38846__auto___56468 = om.next.ident.call(null,this__38841__auto__,om.next._next_props.call(null,next_props__38842__auto__,this__38841__auto__));
if(cljs.core.not_EQ_.call(null,ident__38845__auto___56467,next_ident__38846__auto___56468)){
var idxr__38847__auto___56469 = cljs.core.get_in.call(null,om.next.get_reconciler.call(null,this__38841__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
if((idxr__38847__auto___56469 == null)){
} else {
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"indexes","indexes",1496475545).cljs$core$IFn$_invoke$arity$1(idxr__38847__auto___56469),((function (idxr__38847__auto___56469,ident__38845__auto___56467,next_ident__38846__auto___56468,this__38841__auto__,x56450_56466){
return (function (indexes__38848__auto__){
return cljs.core.update_in.call(null,cljs.core.update_in.call(null,indexes__38848__auto__,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ref->components","ref->components",-303587249),ident__38845__auto___56467], null),cljs.core.disj,this__38841__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ref->components","ref->components",-303587249),next_ident__38846__auto___56468], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentHashSet.EMPTY),this__38841__auto__);
});})(idxr__38847__auto___56469,ident__38845__auto___56467,next_ident__38846__auto___56468,this__38841__auto__,x56450_56466))
);
}
} else {
}
} else {
}

om.next.merge_pending_props_BANG_.call(null,this__38841__auto__);

return om.next.merge_pending_state_BANG_.call(null,this__38841__auto__);
});})(x56450_56466))
;

x56450_56466.shouldComponentUpdate = ((function (x56450_56466){
return (function (next_props__38842__auto__,next_state__38843__auto__){
var this__38841__auto__ = this;
var next_children__38844__auto__ = next_props__38842__auto__.children;
var next_props__38842__auto____$1 = goog.object.get(next_props__38842__auto__,"omcljs$value");
var next_props__38842__auto____$2 = (function (){var G__56452 = next_props__38842__auto____$1;
if((next_props__38842__auto____$1 instanceof om.next.OmProps)){
return om.next.unwrap.call(null,G__56452);
} else {
return G__56452;
}
})();
var or__28141__auto__ = cljs.core.not_EQ_.call(null,om.next.props.call(null,this__38841__auto__),next_props__38842__auto____$2);
if(or__28141__auto__){
return or__28141__auto__;
} else {
var or__28141__auto____$1 = (function (){var and__28129__auto__ = this__38841__auto__.state;
if(cljs.core.truth_(and__28129__auto__)){
return cljs.core.not_EQ_.call(null,goog.object.get(this__38841__auto__.state,"omcljs$state"),goog.object.get(next_state__38843__auto__,"omcljs$state"));
} else {
return and__28129__auto__;
}
})();
if(cljs.core.truth_(or__28141__auto____$1)){
return or__28141__auto____$1;
} else {
return cljs.core.not_EQ_.call(null,this__38841__auto__.props.children,next_children__38844__auto__);
}
}
});})(x56450_56466))
;

x56450_56466.componentWillUnmount = ((function (x56450_56466){
return (function (){
var this__38841__auto__ = this;
var r__38852__auto__ = om.next.get_reconciler.call(null,this__38841__auto__);
var cfg__38853__auto__ = new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(r__38852__auto__);
var st__38854__auto__ = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(cfg__38853__auto__);
var indexer__38851__auto__ = new cljs.core.Keyword(null,"indexer","indexer",-1774914315).cljs$core$IFn$_invoke$arity$1(cfg__38853__auto__);
if(cljs.core.truth_((function (){var and__28129__auto__ = !((st__38854__auto__ == null));
if(and__28129__auto__){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,st__38854__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("om.next","queries","om.next/queries",-22717146),this__38841__auto__], null));
} else {
return and__28129__auto__;
}
})())){
cljs.core.swap_BANG_.call(null,st__38854__auto__,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("om.next","queries","om.next/queries",-22717146)], null),cljs.core.dissoc,this__38841__auto__);
} else {
}

if((indexer__38851__auto__ == null)){
return null;
} else {
return om.next.protocols.drop_component_BANG_.call(null,indexer__38851__auto__,this__38841__auto__);
}
});})(x56450_56466))
;

x56450_56466.componentDidUpdate = ((function (x56450_56466){
return (function (prev_props__38849__auto__,prev_state__38850__auto__){
var this__38841__auto__ = this;
return om.next.clear_prev_props_BANG_.call(null,this__38841__auto__);
});})(x56450_56466))
;

x56450_56466.isMounted = ((function (x56450_56466){
return (function (){
var this__38841__auto__ = this;
return cljs.core.boolean$.call(null,goog.object.getValueByKeys(this__38841__auto__,"_reactInternalInstance","_renderedComponent"));
});})(x56450_56466))
;

x56450_56466.componentWillMount = ((function (x56450_56466){
return (function (){
var this__38841__auto__ = this;
var indexer__38851__auto__ = cljs.core.get_in.call(null,om.next.get_reconciler.call(null,this__38841__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
if((indexer__38851__auto__ == null)){
return null;
} else {
return om.next.protocols.index_component_BANG_.call(null,indexer__38851__auto__,this__38841__auto__);
}
});})(x56450_56466))
;

x56450_56466.render = ((function (x56450_56466){
return (function (){
var this__38840__auto__ = this;
var this$ = this__38840__auto__;
var _STAR_reconciler_STAR_56453 = om.next._STAR_reconciler_STAR_;
var _STAR_depth_STAR_56454 = om.next._STAR_depth_STAR_;
var _STAR_shared_STAR_56455 = om.next._STAR_shared_STAR_;
var _STAR_instrument_STAR_56456 = om.next._STAR_instrument_STAR_;
var _STAR_parent_STAR_56457 = om.next._STAR_parent_STAR_;
om.next._STAR_reconciler_STAR_ = om.next.get_reconciler.call(null,this__38840__auto__);

om.next._STAR_depth_STAR_ = (om.next.depth.call(null,this__38840__auto__) + (1));

om.next._STAR_shared_STAR_ = om.next.shared.call(null,this__38840__auto__);

om.next._STAR_instrument_STAR_ = om.next.instrument.call(null,this__38840__auto__);

om.next._STAR_parent_STAR_ = this__38840__auto__;

try{var map__56458 = om.next.props.call(null,this$);
var map__56458__$1 = ((((!((map__56458 == null)))?((((map__56458.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56458.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56458):map__56458);
var props = map__56458__$1;
var react_key = cljs.core.get.call(null,map__56458__$1,new cljs.core.Keyword("ui","react-key","ui/react-key",1337877664));
var compile_error = cljs.core.get.call(null,map__56458__$1,new cljs.core.Keyword(null,"compile-error","compile-error",-1313154526));
var test_report = cljs.core.get.call(null,map__56458__$1,new cljs.core.Keyword(null,"test-report","test-report",-769743150));
var selectors = cljs.core.get.call(null,map__56458__$1,new cljs.core.Keyword(null,"selectors","selectors",-680741768));
var current_filter = cljs.core.get.call(null,map__56458__$1,new cljs.core.Keyword("ui","current-filter","ui/current-filter",1519811523));
var map__56459 = om.next.get_state.call(null,this$);
var map__56459__$1 = ((((!((map__56459 == null)))?((((map__56459.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56459.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56459):map__56459);
var open_drawer_QMARK_ = cljs.core.get.call(null,map__56459__$1,new cljs.core.Keyword(null,"open-drawer?","open-drawer?",1426251925));
var toggle_drawer = ((function (map__56458,map__56458__$1,props,react_key,compile_error,test_report,selectors,current_filter,map__56459,map__56459__$1,open_drawer_QMARK_,_STAR_reconciler_STAR_56453,_STAR_depth_STAR_56454,_STAR_shared_STAR_56455,_STAR_instrument_STAR_56456,_STAR_parent_STAR_56457,this$,this__38840__auto__,x56450_56466){
return (function (){
return om.next.update_state_BANG_.call(null,this$,cljs.core.update,new cljs.core.Keyword(null,"open-drawer?","open-drawer?",1426251925),cljs.core.not);
});})(map__56458,map__56458__$1,props,react_key,compile_error,test_report,selectors,current_filter,map__56459,map__56459__$1,open_drawer_QMARK_,_STAR_reconciler_STAR_56453,_STAR_depth_STAR_56454,_STAR_shared_STAR_56455,_STAR_instrument_STAR_56456,_STAR_parent_STAR_56457,this$,this__38840__auto__,x56450_56466))
;
var toggle_filter_cb = ((function (map__56458,map__56458__$1,props,react_key,compile_error,test_report,selectors,current_filter,map__56459,map__56459__$1,open_drawer_QMARK_,toggle_drawer,_STAR_reconciler_STAR_56453,_STAR_depth_STAR_56454,_STAR_shared_STAR_56455,_STAR_instrument_STAR_56456,_STAR_parent_STAR_56457,this$,this__38840__auto__,x56450_56466){
return (function (f){
return ((function (map__56458,map__56458__$1,props,react_key,compile_error,test_report,selectors,current_filter,map__56459,map__56459__$1,open_drawer_QMARK_,toggle_drawer,_STAR_reconciler_STAR_56453,_STAR_depth_STAR_56454,_STAR_shared_STAR_56455,_STAR_instrument_STAR_56456,_STAR_parent_STAR_56457,this$,this__38840__auto__,x56450_56466){
return (function (){
return om.next.transact_BANG_.call(null,this$,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__29003__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("fulcro-spec.renderer","toggle-filter","fulcro-spec.renderer/toggle-filter",1341829866,null)),(function (){var x__29003__auto__ = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"filter","filter",-948537934),f], null);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__29003__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__29003__auto__);
})())))));
});
;})(map__56458,map__56458__$1,props,react_key,compile_error,test_report,selectors,current_filter,map__56459,map__56459__$1,open_drawer_QMARK_,toggle_drawer,_STAR_reconciler_STAR_56453,_STAR_depth_STAR_56454,_STAR_shared_STAR_56455,_STAR_instrument_STAR_56456,_STAR_parent_STAR_56457,this$,this__38840__auto__,x56450_56466))
});})(map__56458,map__56458__$1,props,react_key,compile_error,test_report,selectors,current_filter,map__56459,map__56459__$1,open_drawer_QMARK_,toggle_drawer,_STAR_reconciler_STAR_56453,_STAR_depth_STAR_56454,_STAR_shared_STAR_56455,_STAR_instrument_STAR_56456,_STAR_parent_STAR_56457,this$,this__38840__auto__,x56450_56466))
;
return om.dom.div.call(null,({"key": react_key, "className": "u-layout"}),om.dom.div.call(null,({"className": "u-layout__page u-layout__page--fixed"}),fulcro_spec.renderer.test_header.call(null,test_report,current_filter,toggle_drawer,toggle_filter_cb),om.dom.div.call(null,({"className": (function (){var G__56462 = "c-drawer";
if(cljs.core.truth_(open_drawer_QMARK_)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__56462)," is-open"].join('');
} else {
return G__56462;
}
})()}),om.dom.div.call(null,({"className": "c-drawer__header"}),om.dom.img.call(null,({"src": "img/logo.png", "height": (35), "width": (35), "onClick": toggle_drawer})),om.dom.h1.call(null,null,"Fulcro Spec")),fulcro_spec.renderer.test_selectors.call(null,selectors)),om.dom.div.call(null,({"className": (function (){var G__56463 = "c-backdrop";
if(cljs.core.truth_(open_drawer_QMARK_)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__56463)," is-active"].join('');
} else {
return G__56463;
}
})(), "onClick": toggle_drawer})),(cljs.core.truth_(compile_error)?om.dom.h1.call(null,null,compile_error):fulcro_spec.renderer.test_main.call(null,test_report,current_filter))));
}finally {om.next._STAR_parent_STAR_ = _STAR_parent_STAR_56457;

om.next._STAR_instrument_STAR_ = _STAR_instrument_STAR_56456;

om.next._STAR_shared_STAR_ = _STAR_shared_STAR_56455;

om.next._STAR_depth_STAR_ = _STAR_depth_STAR_56454;

om.next._STAR_reconciler_STAR_ = _STAR_reconciler_STAR_56453;
}});})(x56450_56466))
;


fulcro_spec.renderer.TestReport.prototype.constructor = fulcro_spec.renderer.TestReport;

fulcro_spec.renderer.TestReport.prototype.constructor.displayName = "fulcro-spec.renderer/TestReport";

fulcro_spec.renderer.TestReport.prototype.om$isComponent = true;

var x56464_56470 = fulcro_spec.renderer.TestReport;
/** @nocollapse */
x56464_56470.fulcro$client$core$InitialAppState$ = cljs.core.PROTOCOL_SENTINEL;

/** @nocollapse */
x56464_56470.fulcro$client$core$InitialAppState$initial_state$arity$2 = ((function (x56464_56470){
return (function (this$,_){
var this$__$1 = this;
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword("ui","react-key","ui/react-key",1337877664),cljs.core.gensym.call(null,"UI_REACT_KEY"),new cljs.core.Keyword(null,"compile-error","compile-error",-1313154526),null,new cljs.core.Keyword("ui","current-filter","ui/current-filter",1519811523),new cljs.core.Keyword(null,"all","all",892129742)], null);
});})(x56464_56470))
;

/** @nocollapse */
x56464_56470.om$next$IQuery$ = cljs.core.PROTOCOL_SENTINEL;

/** @nocollapse */
x56464_56470.om$next$IQuery$query$arity$1 = ((function (x56464_56470){
return (function (this$){
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("ui","react-key","ui/react-key",1337877664),new cljs.core.Keyword(null,"test-report","test-report",-769743150),new cljs.core.Keyword(null,"compile-error","compile-error",-1313154526),new cljs.core.Keyword("ui","current-filter","ui/current-filter",1519811523),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"selectors","selectors",-680741768),om.next.get_query.call(null,fulcro_spec.renderer.SelectorControl)], null)], null);
});})(x56464_56470))
;


var x56465_56471 = fulcro_spec.renderer.TestReport.prototype;

x56465_56471.fulcro$client$core$InitialAppState$ = cljs.core.PROTOCOL_SENTINEL;


x56465_56471.fulcro$client$core$InitialAppState$initial_state$arity$2 = ((function (x56465_56471){
return (function (this$,_){
var this$__$1 = this;
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword("ui","react-key","ui/react-key",1337877664),cljs.core.gensym.call(null,"UI_REACT_KEY"),new cljs.core.Keyword(null,"compile-error","compile-error",-1313154526),null,new cljs.core.Keyword("ui","current-filter","ui/current-filter",1519811523),new cljs.core.Keyword(null,"all","all",892129742)], null);
});})(x56465_56471))
;


x56465_56471.om$next$IQuery$ = cljs.core.PROTOCOL_SENTINEL;


x56465_56471.om$next$IQuery$query$arity$1 = ((function (x56465_56471){
return (function (this$){
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("ui","react-key","ui/react-key",1337877664),new cljs.core.Keyword(null,"test-report","test-report",-769743150),new cljs.core.Keyword(null,"compile-error","compile-error",-1313154526),new cljs.core.Keyword("ui","current-filter","ui/current-filter",1519811523),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"selectors","selectors",-680741768),om.next.get_query.call(null,fulcro_spec.renderer.SelectorControl)], null)], null);
});})(x56465_56471))
;


fulcro_spec.renderer.TestReport.cljs$lang$type = true;

fulcro_spec.renderer.TestReport.cljs$lang$ctorStr = "fulcro-spec.renderer/TestReport";

fulcro_spec.renderer.TestReport.cljs$lang$ctorPrWriter = (function (this__38957__auto__,writer__38958__auto__,opt__38959__auto__){
return cljs.core._write.call(null,writer__38958__auto__,"fulcro-spec.renderer/TestReport");
});
cljs.core._add_method.call(null,fulcro.client.mutations.mutate,new cljs.core.Symbol("fulcro-spec.renderer","render-tests","fulcro-spec.renderer/render-tests",658035607,null),(function (env56472,_,new_report){
return cljs.core.merge.call(null,(function (){var map__56473 = env56472;
var map__56473__$1 = ((((!((map__56473 == null)))?((((map__56473.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56473.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56473):map__56473);
var state = cljs.core.get.call(null,map__56473__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"action","action",-811238024),((function (map__56473,map__56473__$1,state){
return (function (){
return cljs.core.swap_BANG_.call(null,state,cljs.core.assoc,new cljs.core.Keyword(null,"test-report","test-report",-769743150),new_report);
});})(map__56473,map__56473__$1,state))
], null);
})(),(function (){var env = env56472;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"remote","remote",-1593576576),false], null);
})());
}));
cljs.core._add_method.call(null,fulcro.client.mutations.mutate,new cljs.core.Symbol("fulcro-spec.renderer","show-compile-error","fulcro-spec.renderer/show-compile-error",-1959581225,null),(function (env56475,_,p__56476){
var map__56477 = p__56476;
var map__56477__$1 = ((((!((map__56477 == null)))?((((map__56477.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56477.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56477):map__56477);
var error = cljs.core.get.call(null,map__56477__$1,new cljs.core.Keyword(null,"error","error",-978969032));
return cljs.core.merge.call(null,(function (){var map__56479 = env56475;
var map__56479__$1 = ((((!((map__56479 == null)))?((((map__56479.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56479.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56479):map__56479);
var state = cljs.core.get.call(null,map__56479__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"action","action",-811238024),((function (map__56479,map__56479__$1,state,map__56477,map__56477__$1,error){
return (function (){
return cljs.core.swap_BANG_.call(null,state,cljs.core.assoc,new cljs.core.Keyword(null,"compile-error","compile-error",-1313154526),error);
});})(map__56479,map__56479__$1,state,map__56477,map__56477__$1,error))
], null);
})(),(function (){var env = env56475;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"remote","remote",-1593576576),false], null);
})());
}));
cljs.core._add_method.call(null,fulcro.client.mutations.mutate,new cljs.core.Symbol("fulcro-spec.renderer","clear-compile-error","fulcro-spec.renderer/clear-compile-error",-616390103,null),(function (env56481,_,ignored){
return cljs.core.merge.call(null,(function (){var map__56482 = env56481;
var map__56482__$1 = ((((!((map__56482 == null)))?((((map__56482.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56482.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56482):map__56482);
var state = cljs.core.get.call(null,map__56482__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"action","action",-811238024),((function (map__56482,map__56482__$1,state){
return (function (){
return cljs.core.swap_BANG_.call(null,state,cljs.core.assoc,new cljs.core.Keyword(null,"compile-error","compile-error",-1313154526),false);
});})(map__56482,map__56482__$1,state))
], null);
})(),(function (){var env = env56481;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"remote","remote",-1593576576),false], null);
})());
}));
cljs.core._add_method.call(null,fulcro.websockets.networking.push_received,new cljs.core.Symbol("fulcro-spec.renderer","render-tests","fulcro-spec.renderer/render-tests",658035607,null),(function (p__56484,p__56485){
var map__56486 = p__56484;
var map__56486__$1 = ((((!((map__56486 == null)))?((((map__56486.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56486.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56486):map__56486);
var reconciler = cljs.core.get.call(null,map__56486__$1,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966));
var map__56487 = p__56485;
var map__56487__$1 = ((((!((map__56487 == null)))?((((map__56487.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56487.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56487):map__56487);
var test_report = cljs.core.get.call(null,map__56487__$1,new cljs.core.Keyword(null,"msg","msg",-1386103444));
return om.next.transact_BANG_.call(null,om.next.app_root.call(null,reconciler),cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__29003__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("fulcro-spec.renderer","clear-compile-error","fulcro-spec.renderer/clear-compile-error",-616390103,null)),(function (){var x__29003__auto__ = cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__29003__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__29003__auto__);
})(),(function (){var x__29003__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("fulcro-spec.renderer","render-tests","fulcro-spec.renderer/render-tests",658035607,null)),(function (){var x__29003__auto__ = test_report;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__29003__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__29003__auto__);
})())))));
}));
cljs.core._add_method.call(null,fulcro.websockets.networking.push_received,new cljs.core.Symbol("fulcro-spec.renderer","show-compile-error","fulcro-spec.renderer/show-compile-error",-1959581225,null),(function (p__56490,p__56491){
var map__56492 = p__56490;
var map__56492__$1 = ((((!((map__56492 == null)))?((((map__56492.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56492.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56492):map__56492);
var reconciler = cljs.core.get.call(null,map__56492__$1,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966));
var map__56493 = p__56491;
var map__56493__$1 = ((((!((map__56493 == null)))?((((map__56493.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56493.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56493):map__56493);
var message = cljs.core.get.call(null,map__56493__$1,new cljs.core.Keyword(null,"msg","msg",-1386103444));
return om.next.transact_BANG_.call(null,om.next.app_root.call(null,reconciler),cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__29003__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("fulcro-spec.renderer","show-compile-error","fulcro-spec.renderer/show-compile-error",-1959581225,null)),(function (){var x__29003__auto__ = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"error","error",-978969032),message], null);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__29003__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__29003__auto__);
})())))));
}));
if(typeof fulcro_spec.renderer.networking !== 'undefined'){
} else {
fulcro_spec.renderer.networking = cljs.core.atom.call(null,null);
}

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {com.stuartsierra.component.Lifecycle}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fulcro_spec.renderer.TestRenderer = (function (root,target,with_websockets_QMARK_,runner_atom,__meta,__extmap,__hash){
this.root = root;
this.target = target;
this.with_websockets_QMARK_ = with_websockets_QMARK_;
this.runner_atom = runner_atom;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});

fulcro_spec.renderer.TestRenderer.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__28781__auto__,k__28782__auto__){
var self__ = this;
var this__28781__auto____$1 = this;
return this__28781__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__28782__auto__,null);
});


fulcro_spec.renderer.TestRenderer.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__28783__auto__,k56497,else__28784__auto__){
var self__ = this;
var this__28783__auto____$1 = this;
var G__56501 = k56497;
var G__56501__$1 = (((G__56501 instanceof cljs.core.Keyword))?G__56501.fqn:null);
switch (G__56501__$1) {
case "root":
return self__.root;

break;
case "target":
return self__.target;

break;
case "with-websockets?":
return self__.with_websockets_QMARK_;

break;
case "runner-atom":
return self__.runner_atom;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k56497,else__28784__auto__);

}
});


fulcro_spec.renderer.TestRenderer.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__28795__auto__,writer__28796__auto__,opts__28797__auto__){
var self__ = this;
var this__28795__auto____$1 = this;
var pr_pair__28798__auto__ = ((function (this__28795__auto____$1){
return (function (keyval__28799__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__28796__auto__,cljs.core.pr_writer,""," ","",opts__28797__auto__,keyval__28799__auto__);
});})(this__28795__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__28796__auto__,pr_pair__28798__auto__,"#fulcro-spec.renderer.TestRenderer{",", ","}",opts__28797__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"root","root",-448657453),self__.root],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"target","target",253001721),self__.target],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"with-websockets?","with-websockets?",-1841272103),self__.with_websockets_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"runner-atom","runner-atom",617192507),self__.runner_atom],null))], null),self__.__extmap));
});


fulcro_spec.renderer.TestRenderer.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__56496){
var self__ = this;
var G__56496__$1 = this;
return (new cljs.core.RecordIter((0),G__56496__$1,4,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"root","root",-448657453),new cljs.core.Keyword(null,"target","target",253001721),new cljs.core.Keyword(null,"with-websockets?","with-websockets?",-1841272103),new cljs.core.Keyword(null,"runner-atom","runner-atom",617192507)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});


fulcro_spec.renderer.TestRenderer.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__28779__auto__){
var self__ = this;
var this__28779__auto____$1 = this;
return self__.__meta;
});


fulcro_spec.renderer.TestRenderer.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__28776__auto__){
var self__ = this;
var this__28776__auto____$1 = this;
return (new fulcro_spec.renderer.TestRenderer(self__.root,self__.target,self__.with_websockets_QMARK_,self__.runner_atom,self__.__meta,self__.__extmap,self__.__hash));
});


fulcro_spec.renderer.TestRenderer.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__28785__auto__){
var self__ = this;
var this__28785__auto____$1 = this;
return (4 + cljs.core.count.call(null,self__.__extmap));
});


fulcro_spec.renderer.TestRenderer.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__28777__auto__){
var self__ = this;
var this__28777__auto____$1 = this;
var h__28595__auto__ = self__.__hash;
if(!((h__28595__auto__ == null))){
return h__28595__auto__;
} else {
var h__28595__auto____$1 = ((function (h__28595__auto__,this__28777__auto____$1){
return (function (coll__28778__auto__){
return (1773823653 ^ cljs.core.hash_unordered_coll.call(null,coll__28778__auto__));
});})(h__28595__auto__,this__28777__auto____$1))
.call(null,this__28777__auto____$1);
self__.__hash = h__28595__auto____$1;

return h__28595__auto____$1;
}
});


fulcro_spec.renderer.TestRenderer.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this56498,other56499){
var self__ = this;
var this56498__$1 = this;
return (!((other56499 == null))) && ((this56498__$1.constructor === other56499.constructor)) && (cljs.core._EQ_.call(null,this56498__$1.root,other56499.root)) && (cljs.core._EQ_.call(null,this56498__$1.target,other56499.target)) && (cljs.core._EQ_.call(null,this56498__$1.with_websockets_QMARK_,other56499.with_websockets_QMARK_)) && (cljs.core._EQ_.call(null,this56498__$1.runner_atom,other56499.runner_atom)) && (cljs.core._EQ_.call(null,this56498__$1.__extmap,other56499.__extmap));
});


fulcro_spec.renderer.TestRenderer.prototype.com$stuartsierra$component$Lifecycle$ = cljs.core.PROTOCOL_SENTINEL;


fulcro_spec.renderer.TestRenderer.prototype.com$stuartsierra$component$Lifecycle$start$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
try{var app = fulcro.client.core.new_fulcro_client.call(null,new cljs.core.Keyword(null,"networking","networking",586110628),(cljs.core.truth_(self__.with_websockets_QMARK_)?(function (){
cljs.core.reset_BANG_.call(null,fulcro_spec.renderer.networking,fulcro.websockets.networking.make_channel_client.call(null,"/_fulcro_spec_chsk"));

return cljs.core.deref.call(null,fulcro_spec.renderer.networking);
})()
:(function (){
if(typeof fulcro_spec.renderer.t_fulcro_spec$renderer56503 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {fulcro.client.network.FulcroNetwork}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
fulcro_spec.renderer.t_fulcro_spec$renderer56503 = (function (root,target,with_websockets_QMARK_,runner_atom,__meta,__extmap,__hash,this$,meta56504){
this.root = root;
this.target = target;
this.with_websockets_QMARK_ = with_websockets_QMARK_;
this.runner_atom = runner_atom;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.this$ = this$;
this.meta56504 = meta56504;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

fulcro_spec.renderer.t_fulcro_spec$renderer56503.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (this$__$1){
return (function (_56505,meta56504__$1){
var self__ = this;
var _56505__$1 = this;
return (new fulcro_spec.renderer.t_fulcro_spec$renderer56503(self__.root,self__.target,self__.with_websockets_QMARK_,self__.runner_atom,self__.__meta,self__.__extmap,self__.__hash,self__.this$,meta56504__$1));
});})(this$__$1))
;


fulcro_spec.renderer.t_fulcro_spec$renderer56503.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (this$__$1){
return (function (_56505){
var self__ = this;
var _56505__$1 = this;
return self__.meta56504;
});})(this$__$1))
;


fulcro_spec.renderer.t_fulcro_spec$renderer56503.prototype.fulcro$client$network$FulcroNetwork$ = cljs.core.PROTOCOL_SENTINEL;


fulcro_spec.renderer.t_fulcro_spec$renderer56503.prototype.fulcro$client$network$FulcroNetwork$start$arity$1 = ((function (this$__$1){
return (function (this$__$1){
var self__ = this;
var this$__$2 = this;
return this$__$2;
});})(this$__$1))
;


fulcro_spec.renderer.t_fulcro_spec$renderer56503.prototype.fulcro$client$network$FulcroNetwork$send$arity$4 = ((function (this$__$1){
return (function (this$__$1,edn,ok,err){
var self__ = this;
var this$__$2 = this;
return ok.call(null,om.next.parser.call(null,cljs.core.deref.call(null,self__.runner_atom)).call(null,cljs.core.deref.call(null,self__.runner_atom),edn));
});})(this$__$1))
;

fulcro_spec.renderer.t_fulcro_spec$renderer56503.getBasis = ((function (this$__$1){
return (function (){
return new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"root","root",1191874074,null),new cljs.core.Symbol(null,"target","target",1893533248,null),new cljs.core.Symbol(null,"with-websockets?","with-websockets?",-200740576,null),new cljs.core.Symbol(null,"runner-atom","runner-atom",-2037243262,null),new cljs.core.Symbol(null,"__meta","__meta",-946752628,null),new cljs.core.Symbol(null,"__extmap","__extmap",-1435580931,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"this","this",1028897902,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("fulcro-spec.renderer","TestRenderer","fulcro-spec.renderer/TestRenderer",-580758391,null)], null)),new cljs.core.Symbol(null,"meta56504","meta56504",-1300285079,null)], null);
});})(this$__$1))
;

fulcro_spec.renderer.t_fulcro_spec$renderer56503.cljs$lang$type = true;

fulcro_spec.renderer.t_fulcro_spec$renderer56503.cljs$lang$ctorStr = "fulcro-spec.renderer/t_fulcro_spec$renderer56503";

fulcro_spec.renderer.t_fulcro_spec$renderer56503.cljs$lang$ctorPrWriter = ((function (this$__$1){
return (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"fulcro-spec.renderer/t_fulcro_spec$renderer56503");
});})(this$__$1))
;

fulcro_spec.renderer.__GT_t_fulcro_spec$renderer56503 = ((function (this$__$1){
return (function fulcro_spec$renderer$__GT_t_fulcro_spec$renderer56503(root__$1,target__$1,with_websockets_QMARK___$1,runner_atom__$1,__meta__$1,__extmap__$1,__hash__$1,this$__$2,meta56504){
return (new fulcro_spec.renderer.t_fulcro_spec$renderer56503(root__$1,target__$1,with_websockets_QMARK___$1,runner_atom__$1,__meta__$1,__extmap__$1,__hash__$1,this$__$2,meta56504));
});})(this$__$1))
;

}

return (new fulcro_spec.renderer.t_fulcro_spec$renderer56503(self__.root,self__.target,self__.with_websockets_QMARK_,self__.runner_atom,self__.__meta,self__.__extmap,self__.__hash,this$__$1,cljs.core.PersistentArrayMap.EMPTY));
})()
),new cljs.core.Keyword(null,"started-callback","started-callback",-1798586951),((function (this$__$1){
return (function (app){
if(cljs.core.truth_((function (){var and__28129__auto__ = self__.with_websockets_QMARK_;
if(cljs.core.truth_(and__28129__auto__)){
return cljs.core.deref.call(null,fulcro_spec.renderer.networking);
} else {
return and__28129__auto__;
}
})())){
fulcro.websockets.networking.install_push_handlers.call(null,cljs.core.deref.call(null,fulcro_spec.renderer.networking),app);
} else {
}

return fulcro.client.data_fetch.load.call(null,app,new cljs.core.Keyword(null,"selectors","selectors",-680741768),fulcro_spec.renderer.SelectorControl,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"post-mutation","post-mutation",-1076606705),new cljs.core.Symbol("fulcro-spec.selectors","set-selectors","fulcro-spec.selectors/set-selectors",-193971597,null)], null));
});})(this$__$1))
);
return cljs.core.assoc.call(null,this$__$1,new cljs.core.Keyword(null,"app","app",-560961707),fulcro.client.core.mount.call(null,app,self__.root,self__.target));
}catch (e56502){if((e56502 instanceof Object)){
var e = e56502;
return console.log("Startup Failed: ",e);
} else {
throw e56502;

}
}});


fulcro_spec.renderer.TestRenderer.prototype.com$stuartsierra$component$Lifecycle$stop$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.assoc.call(null,this$__$1,new cljs.core.Keyword(null,"app","app",-560961707),null);
});


fulcro_spec.renderer.TestRenderer.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__28790__auto__,k__28791__auto__){
var self__ = this;
var this__28790__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"root","root",-448657453),null,new cljs.core.Keyword(null,"with-websockets?","with-websockets?",-1841272103),null,new cljs.core.Keyword(null,"target","target",253001721),null,new cljs.core.Keyword(null,"runner-atom","runner-atom",617192507),null], null), null),k__28791__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__28790__auto____$1),self__.__meta),k__28791__auto__);
} else {
return (new fulcro_spec.renderer.TestRenderer(self__.root,self__.target,self__.with_websockets_QMARK_,self__.runner_atom,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__28791__auto__)),null));
}
});


fulcro_spec.renderer.TestRenderer.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__28788__auto__,k__28789__auto__,G__56496){
var self__ = this;
var this__28788__auto____$1 = this;
var pred__56506 = cljs.core.keyword_identical_QMARK_;
var expr__56507 = k__28789__auto__;
if(cljs.core.truth_(pred__56506.call(null,new cljs.core.Keyword(null,"root","root",-448657453),expr__56507))){
return (new fulcro_spec.renderer.TestRenderer(G__56496,self__.target,self__.with_websockets_QMARK_,self__.runner_atom,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__56506.call(null,new cljs.core.Keyword(null,"target","target",253001721),expr__56507))){
return (new fulcro_spec.renderer.TestRenderer(self__.root,G__56496,self__.with_websockets_QMARK_,self__.runner_atom,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__56506.call(null,new cljs.core.Keyword(null,"with-websockets?","with-websockets?",-1841272103),expr__56507))){
return (new fulcro_spec.renderer.TestRenderer(self__.root,self__.target,G__56496,self__.runner_atom,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__56506.call(null,new cljs.core.Keyword(null,"runner-atom","runner-atom",617192507),expr__56507))){
return (new fulcro_spec.renderer.TestRenderer(self__.root,self__.target,self__.with_websockets_QMARK_,G__56496,self__.__meta,self__.__extmap,null));
} else {
return (new fulcro_spec.renderer.TestRenderer(self__.root,self__.target,self__.with_websockets_QMARK_,self__.runner_atom,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__28789__auto__,G__56496),null));
}
}
}
}
});


fulcro_spec.renderer.TestRenderer.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__28793__auto__){
var self__ = this;
var this__28793__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"root","root",-448657453),self__.root],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"target","target",253001721),self__.target],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"with-websockets?","with-websockets?",-1841272103),self__.with_websockets_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"runner-atom","runner-atom",617192507),self__.runner_atom],null))], null),self__.__extmap));
});


fulcro_spec.renderer.TestRenderer.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__28780__auto__,G__56496){
var self__ = this;
var this__28780__auto____$1 = this;
return (new fulcro_spec.renderer.TestRenderer(self__.root,self__.target,self__.with_websockets_QMARK_,self__.runner_atom,G__56496,self__.__extmap,self__.__hash));
});


fulcro_spec.renderer.TestRenderer.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__28786__auto__,entry__28787__auto__){
var self__ = this;
var this__28786__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__28787__auto__)){
return this__28786__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__28787__auto__,(0)),cljs.core._nth.call(null,entry__28787__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__28786__auto____$1,entry__28787__auto__);
}
});

fulcro_spec.renderer.TestRenderer.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"root","root",1191874074,null),new cljs.core.Symbol(null,"target","target",1893533248,null),new cljs.core.Symbol(null,"with-websockets?","with-websockets?",-200740576,null),new cljs.core.Symbol(null,"runner-atom","runner-atom",-2037243262,null)], null);
});

fulcro_spec.renderer.TestRenderer.cljs$lang$type = true;

fulcro_spec.renderer.TestRenderer.cljs$lang$ctorPrSeq = (function (this__28817__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"fulcro-spec.renderer/TestRenderer");
});

fulcro_spec.renderer.TestRenderer.cljs$lang$ctorPrWriter = (function (this__28817__auto__,writer__28818__auto__){
return cljs.core._write.call(null,writer__28818__auto__,"fulcro-spec.renderer/TestRenderer");
});

fulcro_spec.renderer.__GT_TestRenderer = (function fulcro_spec$renderer$__GT_TestRenderer(root,target,with_websockets_QMARK_,runner_atom){
return (new fulcro_spec.renderer.TestRenderer(root,target,with_websockets_QMARK_,runner_atom,null,null,null));
});

fulcro_spec.renderer.map__GT_TestRenderer = (function fulcro_spec$renderer$map__GT_TestRenderer(G__56500){
return (new fulcro_spec.renderer.TestRenderer(new cljs.core.Keyword(null,"root","root",-448657453).cljs$core$IFn$_invoke$arity$1(G__56500),new cljs.core.Keyword(null,"target","target",253001721).cljs$core$IFn$_invoke$arity$1(G__56500),new cljs.core.Keyword(null,"with-websockets?","with-websockets?",-1841272103).cljs$core$IFn$_invoke$arity$1(G__56500),new cljs.core.Keyword(null,"runner-atom","runner-atom",617192507).cljs$core$IFn$_invoke$arity$1(G__56500),null,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,G__56500,new cljs.core.Keyword(null,"root","root",-448657453),new cljs.core.Keyword(null,"target","target",253001721),new cljs.core.Keyword(null,"with-websockets?","with-websockets?",-1841272103),new cljs.core.Keyword(null,"runner-atom","runner-atom",617192507))),null));
});

fulcro_spec.renderer.make_test_renderer = (function fulcro_spec$renderer$make_test_renderer(p__56510){
var map__56511 = p__56510;
var map__56511__$1 = ((((!((map__56511 == null)))?((((map__56511.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56511.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56511):map__56511);
var with_websockets_QMARK_ = cljs.core.get.call(null,map__56511__$1,new cljs.core.Keyword(null,"with-websockets?","with-websockets?",-1841272103),true);
return fulcro_spec.renderer.map__GT_TestRenderer.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"with-websockets?","with-websockets?",-1841272103),with_websockets_QMARK_,new cljs.core.Keyword(null,"runner-atom","runner-atom",617192507),cljs.core.atom.call(null,null),new cljs.core.Keyword(null,"root","root",-448657453),fulcro_spec.renderer.TestReport,new cljs.core.Keyword(null,"target","target",253001721),"fulcro-spec-report"], null));
});

//# sourceMappingURL=renderer.js.map?rel=1511404501704
