// Compiled by ClojureScript 1.9.946 {}
goog.provide('fulcro.websockets.networking');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('cognitect.transit');
goog.require('taoensso.sente');
goog.require('taoensso.sente.packers.transit');
goog.require('om.next');
goog.require('om.transit');
goog.require('fulcro.client.network');
goog.require('fulcro.client.logging');
goog.require('fulcro.websockets.transit_packer');

/**
 * @interface
 */
fulcro.websockets.networking.ChannelSocket = function(){};

/**
 * Install the push handlers. Must be called in started callback, passed the websocket network object, and the completed app
 */
fulcro.websockets.networking.install_push_handlers = (function fulcro$websockets$networking$install_push_handlers(this$,app){
if((!((this$ == null))) && (!((this$.fulcro$websockets$networking$ChannelSocket$install_push_handlers$arity$2 == null)))){
return this$.fulcro$websockets$networking$ChannelSocket$install_push_handlers$arity$2(this$,app);
} else {
var x__28824__auto__ = (((this$ == null))?null:this$);
var m__28825__auto__ = (fulcro.websockets.networking.install_push_handlers[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,this$,app);
} else {
var m__28825__auto____$1 = (fulcro.websockets.networking.install_push_handlers["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,this$,app);
} else {
throw cljs.core.missing_protocol.call(null,"ChannelSocket.install-push-handlers",this$);
}
}
}
});

/**
 * Reconnect the socket
 */
fulcro.websockets.networking.reconnect = (function fulcro$websockets$networking$reconnect(this$){
if((!((this$ == null))) && (!((this$.fulcro$websockets$networking$ChannelSocket$reconnect$arity$1 == null)))){
return this$.fulcro$websockets$networking$ChannelSocket$reconnect$arity$1(this$);
} else {
var x__28824__auto__ = (((this$ == null))?null:this$);
var m__28825__auto__ = (fulcro.websockets.networking.reconnect[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,this$);
} else {
var m__28825__auto____$1 = (fulcro.websockets.networking.reconnect["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"ChannelSocket.reconnect",this$);
}
}
}
});

if(typeof fulcro.websockets.networking.router_ !== 'undefined'){
} else {
fulcro.websockets.networking.router_ = cljs.core.atom.call(null,null);
}
fulcro.websockets.networking.stop_router_BANG_ = (function fulcro$websockets$networking$stop_router_BANG_(){
var temp__4657__auto__ = cljs.core.deref.call(null,fulcro.websockets.networking.router_);
if(cljs.core.truth_(temp__4657__auto__)){
var stop_f = temp__4657__auto__;
return stop_f.call(null);
} else {
return null;
}
});
fulcro.websockets.networking.start_router_BANG_ = (function fulcro$websockets$networking$start_router_BANG_(ch_recv,msg_handler){
fulcro.client.logging.info.call(null,"Starting websocket router.");

fulcro.websockets.networking.stop_router_BANG_.call(null);

return cljs.core.reset_BANG_.call(null,fulcro.websockets.networking.router_,taoensso.sente.start_chsk_router_BANG_.call(null,ch_recv,msg_handler));
});
if(typeof fulcro.websockets.networking.message_received !== 'undefined'){
} else {
/**
 * Multimethod to handle Sente `event-msg`s
 */
fulcro.websockets.networking.message_received = (function (){var method_table__29098__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__29099__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__29100__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__29101__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__29102__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"fulcro.websockets.networking","message-received"),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__29102__auto__,method_table__29098__auto__,prefer_table__29099__auto__,method_cache__29100__auto__,cached_hierarchy__29101__auto__));
})();
}
if(typeof fulcro.websockets.networking.push_received !== 'undefined'){
} else {
/**
 * Multimethod to handle push events
 */
fulcro.websockets.networking.push_received = (function (){var method_table__29098__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__29099__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__29100__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__29101__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__29102__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"fulcro.websockets.networking","push-received"),((function (method_table__29098__auto__,prefer_table__29099__auto__,method_cache__29100__auto__,cached_hierarchy__29101__auto__,hierarchy__29102__auto__){
return (function (app,msg){
return new cljs.core.Keyword(null,"topic","topic",-1960480691).cljs$core$IFn$_invoke$arity$1(msg);
});})(method_table__29098__auto__,prefer_table__29099__auto__,method_cache__29100__auto__,cached_hierarchy__29101__auto__,hierarchy__29102__auto__))
,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__29102__auto__,method_table__29098__auto__,prefer_table__29099__auto__,method_cache__29100__auto__,cached_hierarchy__29101__auto__));
})();
}
cljs.core._add_method.call(null,fulcro.websockets.networking.push_received,new cljs.core.Keyword(null,"default","default",-1987822328),(function (app,msg){
return fulcro.client.logging.error.call(null,["Received and unhandled message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg)].join(''));
}));

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {fulcro.client.network.FulcroNetwork}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {fulcro.websockets.networking.ChannelSocket}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fulcro.websockets.networking.ChannelClient = (function (ch_recv,url,init_chan,channel_socket,send_fn,global_error_callback,req_params,parse_queue,completed_app,__meta,__extmap,__hash){
this.ch_recv = ch_recv;
this.url = url;
this.init_chan = init_chan;
this.channel_socket = channel_socket;
this.send_fn = send_fn;
this.global_error_callback = global_error_callback;
this.req_params = req_params;
this.parse_queue = parse_queue;
this.completed_app = completed_app;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});

fulcro.websockets.networking.ChannelClient.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__28781__auto__,k__28782__auto__){
var self__ = this;
var this__28781__auto____$1 = this;
return this__28781__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__28782__auto__,null);
});


fulcro.websockets.networking.ChannelClient.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__28783__auto__,k55809,else__28784__auto__){
var self__ = this;
var this__28783__auto____$1 = this;
var G__55813 = k55809;
var G__55813__$1 = (((G__55813 instanceof cljs.core.Keyword))?G__55813.fqn:null);
switch (G__55813__$1) {
case "ch-recv":
return self__.ch_recv;

break;
case "url":
return self__.url;

break;
case "init-chan":
return self__.init_chan;

break;
case "channel-socket":
return self__.channel_socket;

break;
case "send-fn":
return self__.send_fn;

break;
case "global-error-callback":
return self__.global_error_callback;

break;
case "req-params":
return self__.req_params;

break;
case "parse-queue":
return self__.parse_queue;

break;
case "completed-app":
return self__.completed_app;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k55809,else__28784__auto__);

}
});


fulcro.websockets.networking.ChannelClient.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__28795__auto__,writer__28796__auto__,opts__28797__auto__){
var self__ = this;
var this__28795__auto____$1 = this;
var pr_pair__28798__auto__ = ((function (this__28795__auto____$1){
return (function (keyval__28799__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__28796__auto__,cljs.core.pr_writer,""," ","",opts__28797__auto__,keyval__28799__auto__);
});})(this__28795__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__28796__auto__,pr_pair__28798__auto__,"#fulcro.websockets.networking.ChannelClient{",", ","}",opts__28797__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861),self__.ch_recv],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"url","url",276297046),self__.url],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"init-chan","init-chan",2144713800),self__.init_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"channel-socket","channel-socket",416262463),self__.channel_socket],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"send-fn","send-fn",351002041),self__.send_fn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"global-error-callback","global-error-callback",901427631),self__.global_error_callback],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"req-params","req-params",2117077454),self__.req_params],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"parse-queue","parse-queue",1928611689),self__.parse_queue],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"completed-app","completed-app",-635152970),self__.completed_app],null))], null),self__.__extmap));
});


fulcro.websockets.networking.ChannelClient.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__55808){
var self__ = this;
var G__55808__$1 = this;
return (new cljs.core.RecordIter((0),G__55808__$1,9,new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861),new cljs.core.Keyword(null,"url","url",276297046),new cljs.core.Keyword(null,"init-chan","init-chan",2144713800),new cljs.core.Keyword(null,"channel-socket","channel-socket",416262463),new cljs.core.Keyword(null,"send-fn","send-fn",351002041),new cljs.core.Keyword(null,"global-error-callback","global-error-callback",901427631),new cljs.core.Keyword(null,"req-params","req-params",2117077454),new cljs.core.Keyword(null,"parse-queue","parse-queue",1928611689),new cljs.core.Keyword(null,"completed-app","completed-app",-635152970)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});


fulcro.websockets.networking.ChannelClient.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__28779__auto__){
var self__ = this;
var this__28779__auto____$1 = this;
return self__.__meta;
});


fulcro.websockets.networking.ChannelClient.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__28776__auto__){
var self__ = this;
var this__28776__auto____$1 = this;
return (new fulcro.websockets.networking.ChannelClient(self__.ch_recv,self__.url,self__.init_chan,self__.channel_socket,self__.send_fn,self__.global_error_callback,self__.req_params,self__.parse_queue,self__.completed_app,self__.__meta,self__.__extmap,self__.__hash));
});


fulcro.websockets.networking.ChannelClient.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__28785__auto__){
var self__ = this;
var this__28785__auto____$1 = this;
return (9 + cljs.core.count.call(null,self__.__extmap));
});


fulcro.websockets.networking.ChannelClient.prototype.fulcro$websockets$networking$ChannelSocket$ = cljs.core.PROTOCOL_SENTINEL;


fulcro.websockets.networking.ChannelClient.prototype.fulcro$websockets$networking$ChannelSocket$install_push_handlers$arity$2 = (function (this$,app){
var self__ = this;
var this$__$1 = this;
fulcro.websockets.networking.message_received.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"default","default",-1987822328),((function (this$__$1){
return (function (p__55814){
var map__55815 = p__55814;
var map__55815__$1 = ((((!((map__55815 == null)))?((((map__55815.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55815.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__55815):map__55815);
var ch_recv__$1 = cljs.core.get.call(null,map__55815__$1,new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861));
var send_fn__$1 = cljs.core.get.call(null,map__55815__$1,new cljs.core.Keyword(null,"send-fn","send-fn",351002041));
var state = cljs.core.get.call(null,map__55815__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var event = cljs.core.get.call(null,map__55815__$1,new cljs.core.Keyword(null,"event","event",301435442));
var id = cljs.core.get.call(null,map__55815__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var _QMARK_data = cljs.core.get.call(null,map__55815__$1,new cljs.core.Keyword(null,"?data","?data",-9471433));
var command = new cljs.core.Keyword(null,"command","command",-894540724).cljs$core$IFn$_invoke$arity$1(_QMARK_data);
return fulcro.client.logging.debug.call(null,"Message Routed to default handler ",command);
});})(this$__$1))
);

fulcro.websockets.networking.message_received.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword("api","parse","api/parse",-1162064757),((function (this$__$1){
return (function (p__55817){
var map__55818 = p__55817;
var map__55818__$1 = ((((!((map__55818 == null)))?((((map__55818.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55818.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__55818):map__55818);
var _QMARK_data = cljs.core.get.call(null,map__55818__$1,new cljs.core.Keyword(null,"?data","?data",-9471433));
return cljs.core.async.put_BANG_.call(null,self__.parse_queue,_QMARK_data);
});})(this$__$1))
);

fulcro.websockets.networking.message_received.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword("api","server-push","api/server-push",-1185983895),((function (this$__$1){
return (function (p__55820){
var map__55821 = p__55820;
var map__55821__$1 = ((((!((map__55821 == null)))?((((map__55821.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55821.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__55821):map__55821);
var msg = map__55821__$1;
var _QMARK_data = cljs.core.get.call(null,map__55821__$1,new cljs.core.Keyword(null,"?data","?data",-9471433));
return fulcro.websockets.networking.push_received.call(null,app,_QMARK_data);
});})(this$__$1))
);

fulcro.websockets.networking.message_received.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword("chsk","handshake","chsk/handshake",64910686),((function (this$__$1){
return (function (p__55823){
var map__55824 = p__55823;
var map__55824__$1 = ((((!((map__55824 == null)))?((((map__55824.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55824.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__55824):map__55824);
var message = map__55824__$1;
var ch_recv__$1 = cljs.core.get.call(null,map__55824__$1,new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861));
var send_fn__$1 = cljs.core.get.call(null,map__55824__$1,new cljs.core.Keyword(null,"send-fn","send-fn",351002041));
var state = cljs.core.get.call(null,map__55824__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var event = cljs.core.get.call(null,map__55824__$1,new cljs.core.Keyword(null,"event","event",301435442));
var id = cljs.core.get.call(null,map__55824__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var _QMARK_data = cljs.core.get.call(null,map__55824__$1,new cljs.core.Keyword(null,"?data","?data",-9471433));
return fulcro.client.logging.debug.call(null,"Message Routed to handshake handler ",state);
});})(this$__$1))
);

return fulcro.websockets.networking.message_received.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword("chsk","state","chsk/state",-1991397620),((function (this$__$1){
return (function (p__55826){
var map__55827 = p__55826;
var map__55827__$1 = ((((!((map__55827 == null)))?((((map__55827.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55827.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__55827):map__55827);
var message = map__55827__$1;
var ch_recv__$1 = cljs.core.get.call(null,map__55827__$1,new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861));
var send_fn__$1 = cljs.core.get.call(null,map__55827__$1,new cljs.core.Keyword(null,"send-fn","send-fn",351002041));
var state = cljs.core.get.call(null,map__55827__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var event = cljs.core.get.call(null,map__55827__$1,new cljs.core.Keyword(null,"event","event",301435442));
var id = cljs.core.get.call(null,map__55827__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var _QMARK_data = cljs.core.get.call(null,map__55827__$1,new cljs.core.Keyword(null,"?data","?data",-9471433));
fulcro.client.logging.debug.call(null,"Message Routed to state handler",cljs.core.keys.call(null,message));

fulcro.client.logging.debug.call(null,"Event",event);

fulcro.client.logging.debug.call(null,"State",state);

if(cljs.core.truth_(new cljs.core.Keyword(null,"ever-opened?","ever-opened?",1128459732).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,state)))){
return cljs.core.async.put_BANG_.call(null,self__.init_chan,true);
} else {
return null;
}
});})(this$__$1))
);
});


fulcro.websockets.networking.ChannelClient.prototype.fulcro$websockets$networking$ChannelSocket$reconnect$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return taoensso.sente.chsk_reconnect_BANG_.call(null,self__.channel_socket);
});


fulcro.websockets.networking.ChannelClient.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__28777__auto__){
var self__ = this;
var this__28777__auto____$1 = this;
var h__28595__auto__ = self__.__hash;
if(!((h__28595__auto__ == null))){
return h__28595__auto__;
} else {
var h__28595__auto____$1 = ((function (h__28595__auto__,this__28777__auto____$1){
return (function (coll__28778__auto__){
return (954161770 ^ cljs.core.hash_unordered_coll.call(null,coll__28778__auto__));
});})(h__28595__auto__,this__28777__auto____$1))
.call(null,this__28777__auto____$1);
self__.__hash = h__28595__auto____$1;

return h__28595__auto____$1;
}
});


fulcro.websockets.networking.ChannelClient.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this55810,other55811){
var self__ = this;
var this55810__$1 = this;
return (!((other55811 == null))) && ((this55810__$1.constructor === other55811.constructor)) && (cljs.core._EQ_.call(null,this55810__$1.ch_recv,other55811.ch_recv)) && (cljs.core._EQ_.call(null,this55810__$1.url,other55811.url)) && (cljs.core._EQ_.call(null,this55810__$1.init_chan,other55811.init_chan)) && (cljs.core._EQ_.call(null,this55810__$1.channel_socket,other55811.channel_socket)) && (cljs.core._EQ_.call(null,this55810__$1.send_fn,other55811.send_fn)) && (cljs.core._EQ_.call(null,this55810__$1.global_error_callback,other55811.global_error_callback)) && (cljs.core._EQ_.call(null,this55810__$1.req_params,other55811.req_params)) && (cljs.core._EQ_.call(null,this55810__$1.parse_queue,other55811.parse_queue)) && (cljs.core._EQ_.call(null,this55810__$1.completed_app,other55811.completed_app)) && (cljs.core._EQ_.call(null,this55810__$1.__extmap,other55811.__extmap));
});


fulcro.websockets.networking.ChannelClient.prototype.fulcro$client$network$FulcroNetwork$ = cljs.core.PROTOCOL_SENTINEL;


fulcro.websockets.networking.ChannelClient.prototype.fulcro$client$network$FulcroNetwork$send$arity$4 = (function (this$,edn,ok,err){
var self__ = this;
var this$__$1 = this;
var c__47173__auto___55929 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto___55929,this$__$1){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto___55929,this$__$1){
return (function (state_55871){
var state_val_55872 = (state_55871[(1)]);
if((state_val_55872 === (7))){
var state_55871__$1 = state_55871;
var statearr_55873_55930 = state_55871__$1;
(statearr_55873_55930[(2)] = false);

(statearr_55873_55930[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55872 === (1))){
var state_55871__$1 = state_55871;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55871__$1,(2),self__.parse_queue);
} else {
if((state_val_55872 === (4))){
var state_55871__$1 = state_55871;
var statearr_55874_55931 = state_55871__$1;
(statearr_55874_55931[(2)] = false);

(statearr_55874_55931[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55872 === (15))){
var inst_55854 = (state_55871[(7)]);
var inst_55853 = (state_55871[(8)]);
var inst_55863 = self__.global_error_callback.call(null,inst_55853,inst_55854);
var state_55871__$1 = state_55871;
var statearr_55875_55932 = state_55871__$1;
(statearr_55875_55932[(2)] = inst_55863);

(statearr_55875_55932[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55872 === (13))){
var inst_55853 = (state_55871[(8)]);
var inst_55860 = ["SERVER ERROR CODE: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_55853)].join('');
var inst_55861 = fulcro.client.logging.debug.call(null,inst_55860);
var state_55871__$1 = (function (){var statearr_55876 = state_55871;
(statearr_55876[(9)] = inst_55861);

return statearr_55876;
})();
if(cljs.core.truth_(self__.global_error_callback)){
var statearr_55877_55933 = state_55871__$1;
(statearr_55877_55933[(1)] = (15));

} else {
var statearr_55878_55934 = state_55871__$1;
(statearr_55878_55934[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55872 === (6))){
var state_55871__$1 = state_55871;
var statearr_55879_55935 = state_55871__$1;
(statearr_55879_55935[(2)] = true);

(statearr_55879_55935[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55872 === (17))){
var inst_55854 = (state_55871[(7)]);
var inst_55866 = (state_55871[(2)]);
var inst_55867 = err.call(null,inst_55854);
var state_55871__$1 = (function (){var statearr_55880 = state_55871;
(statearr_55880[(10)] = inst_55866);

return statearr_55880;
})();
var statearr_55881_55936 = state_55871__$1;
(statearr_55881_55936[(2)] = inst_55867);

(statearr_55881_55936[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55872 === (3))){
var inst_55831 = (state_55871[(11)]);
var inst_55836 = inst_55831.cljs$lang$protocol_mask$partition0$;
var inst_55837 = (inst_55836 & (64));
var inst_55838 = inst_55831.cljs$core$ISeq$;
var inst_55839 = (cljs.core.PROTOCOL_SENTINEL === inst_55838);
var inst_55840 = (inst_55837) || (inst_55839);
var state_55871__$1 = state_55871;
if(cljs.core.truth_(inst_55840)){
var statearr_55882_55937 = state_55871__$1;
(statearr_55882_55937[(1)] = (6));

} else {
var statearr_55883_55938 = state_55871__$1;
(statearr_55883_55938[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55872 === (12))){
var inst_55854 = (state_55871[(7)]);
var inst_55858 = ok.call(null,inst_55854);
var state_55871__$1 = state_55871;
var statearr_55884_55939 = state_55871__$1;
(statearr_55884_55939[(2)] = inst_55858);

(statearr_55884_55939[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55872 === (2))){
var inst_55831 = (state_55871[(11)]);
var inst_55831__$1 = (state_55871[(2)]);
var inst_55833 = (inst_55831__$1 == null);
var inst_55834 = cljs.core.not.call(null,inst_55833);
var state_55871__$1 = (function (){var statearr_55885 = state_55871;
(statearr_55885[(11)] = inst_55831__$1);

return statearr_55885;
})();
if(inst_55834){
var statearr_55886_55940 = state_55871__$1;
(statearr_55886_55940[(1)] = (3));

} else {
var statearr_55887_55941 = state_55871__$1;
(statearr_55887_55941[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55872 === (11))){
var inst_55854 = (state_55871[(7)]);
var inst_55853 = (state_55871[(8)]);
var inst_55852 = (state_55871[(2)]);
var inst_55853__$1 = cljs.core.get.call(null,inst_55852,new cljs.core.Keyword(null,"status","status",-1997798413));
var inst_55854__$1 = cljs.core.get.call(null,inst_55852,new cljs.core.Keyword(null,"body","body",-2049205669));
var inst_55855 = fulcro.client.logging.debug.call(null,"Receiving ",inst_55854__$1);
var inst_55856 = cljs.core._EQ_.call(null,inst_55853__$1,(200));
var state_55871__$1 = (function (){var statearr_55888 = state_55871;
(statearr_55888[(12)] = inst_55855);

(statearr_55888[(7)] = inst_55854__$1);

(statearr_55888[(8)] = inst_55853__$1);

return statearr_55888;
})();
if(inst_55856){
var statearr_55889_55942 = state_55871__$1;
(statearr_55889_55942[(1)] = (12));

} else {
var statearr_55890_55943 = state_55871__$1;
(statearr_55890_55943[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55872 === (9))){
var inst_55831 = (state_55871[(11)]);
var inst_55849 = cljs.core.apply.call(null,cljs.core.hash_map,inst_55831);
var state_55871__$1 = state_55871;
var statearr_55891_55944 = state_55871__$1;
(statearr_55891_55944[(2)] = inst_55849);

(statearr_55891_55944[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55872 === (5))){
var inst_55847 = (state_55871[(2)]);
var state_55871__$1 = state_55871;
if(cljs.core.truth_(inst_55847)){
var statearr_55892_55945 = state_55871__$1;
(statearr_55892_55945[(1)] = (9));

} else {
var statearr_55893_55946 = state_55871__$1;
(statearr_55893_55946[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55872 === (14))){
var inst_55869 = (state_55871[(2)]);
var state_55871__$1 = (function (){var statearr_55894 = state_55871;
(statearr_55894[(13)] = inst_55869);

return statearr_55894;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55871__$1,self__.parse_queue);
} else {
if((state_val_55872 === (16))){
var state_55871__$1 = state_55871;
var statearr_55895_55947 = state_55871__$1;
(statearr_55895_55947[(2)] = null);

(statearr_55895_55947[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55872 === (10))){
var inst_55831 = (state_55871[(11)]);
var state_55871__$1 = state_55871;
var statearr_55896_55948 = state_55871__$1;
(statearr_55896_55948[(2)] = inst_55831);

(statearr_55896_55948[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55872 === (8))){
var inst_55844 = (state_55871[(2)]);
var state_55871__$1 = state_55871;
var statearr_55897_55949 = state_55871__$1;
(statearr_55897_55949[(2)] = inst_55844);

(statearr_55897_55949[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__47173__auto___55929,this$__$1))
;
return ((function (switch__47085__auto__,c__47173__auto___55929,this$__$1){
return (function() {
var fulcro$websockets$networking$state_machine__47086__auto__ = null;
var fulcro$websockets$networking$state_machine__47086__auto____0 = (function (){
var statearr_55898 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_55898[(0)] = fulcro$websockets$networking$state_machine__47086__auto__);

(statearr_55898[(1)] = (1));

return statearr_55898;
});
var fulcro$websockets$networking$state_machine__47086__auto____1 = (function (state_55871){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_55871);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e55899){if((e55899 instanceof Object)){
var ex__47089__auto__ = e55899;
var statearr_55900_55950 = state_55871;
(statearr_55900_55950[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55871);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e55899;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55951 = state_55871;
state_55871 = G__55951;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
fulcro$websockets$networking$state_machine__47086__auto__ = function(state_55871){
switch(arguments.length){
case 0:
return fulcro$websockets$networking$state_machine__47086__auto____0.call(this);
case 1:
return fulcro$websockets$networking$state_machine__47086__auto____1.call(this,state_55871);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
fulcro$websockets$networking$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = fulcro$websockets$networking$state_machine__47086__auto____0;
fulcro$websockets$networking$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = fulcro$websockets$networking$state_machine__47086__auto____1;
return fulcro$websockets$networking$state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto___55929,this$__$1))
})();
var state__47175__auto__ = (function (){var statearr_55901 = f__47174__auto__.call(null);
(statearr_55901[(6)] = c__47173__auto___55929);

return statearr_55901;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto___55929,this$__$1))
);


var c__47173__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto__,this$__$1){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto__,this$__$1){
return (function (state_55918){
var state_val_55919 = (state_55918[(1)]);
if((state_val_55919 === (1))){
var state_55918__$1 = state_55918;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55918__$1,(2),self__.init_chan);
} else {
if((state_val_55919 === (2))){
var inst_55903 = (state_55918[(2)]);
var inst_55904 = fulcro.client.logging.debug.call(null,"Sending ",edn);
var inst_55905 = cljs.core.List.EMPTY;
var inst_55906 = cljs.core._conj.call(null,inst_55905,new cljs.core.Keyword("api","parse","api/parse",-1162064757));
var inst_55907 = [new cljs.core.Keyword(null,"action","action",-811238024),new cljs.core.Keyword(null,"command","command",-894540724),new cljs.core.Keyword(null,"content","content",15833224)];
var inst_55908 = [new cljs.core.Keyword(null,"send-message","send-message",185030731),new cljs.core.Keyword(null,"send-om-request","send-om-request",-1867228457),edn];
var inst_55909 = cljs.core.PersistentHashMap.fromArrays(inst_55907,inst_55908);
var inst_55910 = cljs.core.List.EMPTY;
var inst_55911 = cljs.core._conj.call(null,inst_55910,inst_55909);
var inst_55912 = cljs.core.concat.call(null,inst_55906,inst_55911);
var inst_55913 = cljs.core.seq.call(null,inst_55912);
var inst_55914 = cljs.core.sequence.call(null,inst_55913);
var inst_55915 = cljs.core.vec.call(null,inst_55914);
var inst_55916 = self__.send_fn.call(null,inst_55915);
var state_55918__$1 = (function (){var statearr_55920 = state_55918;
(statearr_55920[(7)] = inst_55904);

(statearr_55920[(8)] = inst_55903);

return statearr_55920;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55918__$1,inst_55916);
} else {
return null;
}
}
});})(c__47173__auto__,this$__$1))
;
return ((function (switch__47085__auto__,c__47173__auto__,this$__$1){
return (function() {
var fulcro$websockets$networking$state_machine__47086__auto__ = null;
var fulcro$websockets$networking$state_machine__47086__auto____0 = (function (){
var statearr_55921 = [null,null,null,null,null,null,null,null,null];
(statearr_55921[(0)] = fulcro$websockets$networking$state_machine__47086__auto__);

(statearr_55921[(1)] = (1));

return statearr_55921;
});
var fulcro$websockets$networking$state_machine__47086__auto____1 = (function (state_55918){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_55918);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e55922){if((e55922 instanceof Object)){
var ex__47089__auto__ = e55922;
var statearr_55923_55952 = state_55918;
(statearr_55923_55952[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55918);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e55922;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55953 = state_55918;
state_55918 = G__55953;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
fulcro$websockets$networking$state_machine__47086__auto__ = function(state_55918){
switch(arguments.length){
case 0:
return fulcro$websockets$networking$state_machine__47086__auto____0.call(this);
case 1:
return fulcro$websockets$networking$state_machine__47086__auto____1.call(this,state_55918);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
fulcro$websockets$networking$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = fulcro$websockets$networking$state_machine__47086__auto____0;
fulcro$websockets$networking$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = fulcro$websockets$networking$state_machine__47086__auto____1;
return fulcro$websockets$networking$state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto__,this$__$1))
})();
var state__47175__auto__ = (function (){var statearr_55924 = f__47174__auto__.call(null);
(statearr_55924[(6)] = c__47173__auto__);

return statearr_55924;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto__,this$__$1))
);

return c__47173__auto__;
});


fulcro.websockets.networking.ChannelClient.prototype.fulcro$client$network$FulcroNetwork$start$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
fulcro.client.logging.debug.call(null,"Remember to install the push handlers.");

fulcro.websockets.networking.start_router_BANG_.call(null,self__.ch_recv,fulcro.websockets.networking.message_received);

return this$__$1;
});


fulcro.websockets.networking.ChannelClient.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__28790__auto__,k__28791__auto__){
var self__ = this;
var this__28790__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, [new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861),null,new cljs.core.Keyword(null,"init-chan","init-chan",2144713800),null,new cljs.core.Keyword(null,"parse-queue","parse-queue",1928611689),null,new cljs.core.Keyword(null,"req-params","req-params",2117077454),null,new cljs.core.Keyword(null,"global-error-callback","global-error-callback",901427631),null,new cljs.core.Keyword(null,"url","url",276297046),null,new cljs.core.Keyword(null,"completed-app","completed-app",-635152970),null,new cljs.core.Keyword(null,"send-fn","send-fn",351002041),null,new cljs.core.Keyword(null,"channel-socket","channel-socket",416262463),null], null), null),k__28791__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__28790__auto____$1),self__.__meta),k__28791__auto__);
} else {
return (new fulcro.websockets.networking.ChannelClient(self__.ch_recv,self__.url,self__.init_chan,self__.channel_socket,self__.send_fn,self__.global_error_callback,self__.req_params,self__.parse_queue,self__.completed_app,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__28791__auto__)),null));
}
});


fulcro.websockets.networking.ChannelClient.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__28788__auto__,k__28789__auto__,G__55808){
var self__ = this;
var this__28788__auto____$1 = this;
var pred__55925 = cljs.core.keyword_identical_QMARK_;
var expr__55926 = k__28789__auto__;
if(cljs.core.truth_(pred__55925.call(null,new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861),expr__55926))){
return (new fulcro.websockets.networking.ChannelClient(G__55808,self__.url,self__.init_chan,self__.channel_socket,self__.send_fn,self__.global_error_callback,self__.req_params,self__.parse_queue,self__.completed_app,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__55925.call(null,new cljs.core.Keyword(null,"url","url",276297046),expr__55926))){
return (new fulcro.websockets.networking.ChannelClient(self__.ch_recv,G__55808,self__.init_chan,self__.channel_socket,self__.send_fn,self__.global_error_callback,self__.req_params,self__.parse_queue,self__.completed_app,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__55925.call(null,new cljs.core.Keyword(null,"init-chan","init-chan",2144713800),expr__55926))){
return (new fulcro.websockets.networking.ChannelClient(self__.ch_recv,self__.url,G__55808,self__.channel_socket,self__.send_fn,self__.global_error_callback,self__.req_params,self__.parse_queue,self__.completed_app,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__55925.call(null,new cljs.core.Keyword(null,"channel-socket","channel-socket",416262463),expr__55926))){
return (new fulcro.websockets.networking.ChannelClient(self__.ch_recv,self__.url,self__.init_chan,G__55808,self__.send_fn,self__.global_error_callback,self__.req_params,self__.parse_queue,self__.completed_app,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__55925.call(null,new cljs.core.Keyword(null,"send-fn","send-fn",351002041),expr__55926))){
return (new fulcro.websockets.networking.ChannelClient(self__.ch_recv,self__.url,self__.init_chan,self__.channel_socket,G__55808,self__.global_error_callback,self__.req_params,self__.parse_queue,self__.completed_app,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__55925.call(null,new cljs.core.Keyword(null,"global-error-callback","global-error-callback",901427631),expr__55926))){
return (new fulcro.websockets.networking.ChannelClient(self__.ch_recv,self__.url,self__.init_chan,self__.channel_socket,self__.send_fn,G__55808,self__.req_params,self__.parse_queue,self__.completed_app,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__55925.call(null,new cljs.core.Keyword(null,"req-params","req-params",2117077454),expr__55926))){
return (new fulcro.websockets.networking.ChannelClient(self__.ch_recv,self__.url,self__.init_chan,self__.channel_socket,self__.send_fn,self__.global_error_callback,G__55808,self__.parse_queue,self__.completed_app,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__55925.call(null,new cljs.core.Keyword(null,"parse-queue","parse-queue",1928611689),expr__55926))){
return (new fulcro.websockets.networking.ChannelClient(self__.ch_recv,self__.url,self__.init_chan,self__.channel_socket,self__.send_fn,self__.global_error_callback,self__.req_params,G__55808,self__.completed_app,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__55925.call(null,new cljs.core.Keyword(null,"completed-app","completed-app",-635152970),expr__55926))){
return (new fulcro.websockets.networking.ChannelClient(self__.ch_recv,self__.url,self__.init_chan,self__.channel_socket,self__.send_fn,self__.global_error_callback,self__.req_params,self__.parse_queue,G__55808,self__.__meta,self__.__extmap,null));
} else {
return (new fulcro.websockets.networking.ChannelClient(self__.ch_recv,self__.url,self__.init_chan,self__.channel_socket,self__.send_fn,self__.global_error_callback,self__.req_params,self__.parse_queue,self__.completed_app,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__28789__auto__,G__55808),null));
}
}
}
}
}
}
}
}
}
});


fulcro.websockets.networking.ChannelClient.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__28793__auto__){
var self__ = this;
var this__28793__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861),self__.ch_recv],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"url","url",276297046),self__.url],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"init-chan","init-chan",2144713800),self__.init_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"channel-socket","channel-socket",416262463),self__.channel_socket],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"send-fn","send-fn",351002041),self__.send_fn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"global-error-callback","global-error-callback",901427631),self__.global_error_callback],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"req-params","req-params",2117077454),self__.req_params],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"parse-queue","parse-queue",1928611689),self__.parse_queue],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"completed-app","completed-app",-635152970),self__.completed_app],null))], null),self__.__extmap));
});


fulcro.websockets.networking.ChannelClient.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__28780__auto__,G__55808){
var self__ = this;
var this__28780__auto____$1 = this;
return (new fulcro.websockets.networking.ChannelClient(self__.ch_recv,self__.url,self__.init_chan,self__.channel_socket,self__.send_fn,self__.global_error_callback,self__.req_params,self__.parse_queue,self__.completed_app,G__55808,self__.__extmap,self__.__hash));
});


fulcro.websockets.networking.ChannelClient.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__28786__auto__,entry__28787__auto__){
var self__ = this;
var this__28786__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__28787__auto__)){
return this__28786__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__28787__auto__,(0)),cljs.core._nth.call(null,entry__28787__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__28786__auto____$1,entry__28787__auto__);
}
});

fulcro.websockets.networking.ChannelClient.getBasis = (function (){
return new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch-recv","ch-recv",649614666,null),new cljs.core.Symbol(null,"url","url",1916828573,null),new cljs.core.Symbol(null,"init-chan","init-chan",-509721969,null),new cljs.core.Symbol(null,"channel-socket","channel-socket",2056793990,null),new cljs.core.Symbol(null,"send-fn","send-fn",1991533568,null),new cljs.core.Symbol(null,"global-error-callback","global-error-callback",-1753008138,null),new cljs.core.Symbol(null,"req-params","req-params",-537358315,null),new cljs.core.Symbol(null,"parse-queue","parse-queue",-725824080,null),new cljs.core.Symbol(null,"completed-app","completed-app",1005378557,null)], null);
});

fulcro.websockets.networking.ChannelClient.cljs$lang$type = true;

fulcro.websockets.networking.ChannelClient.cljs$lang$ctorPrSeq = (function (this__28817__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"fulcro.websockets.networking/ChannelClient");
});

fulcro.websockets.networking.ChannelClient.cljs$lang$ctorPrWriter = (function (this__28817__auto__,writer__28818__auto__){
return cljs.core._write.call(null,writer__28818__auto__,"fulcro.websockets.networking/ChannelClient");
});

fulcro.websockets.networking.__GT_ChannelClient = (function fulcro$websockets$networking$__GT_ChannelClient(ch_recv,url,init_chan,channel_socket,send_fn,global_error_callback,req_params,parse_queue,completed_app){
return (new fulcro.websockets.networking.ChannelClient(ch_recv,url,init_chan,channel_socket,send_fn,global_error_callback,req_params,parse_queue,completed_app,null,null,null));
});

fulcro.websockets.networking.map__GT_ChannelClient = (function fulcro$websockets$networking$map__GT_ChannelClient(G__55812){
return (new fulcro.websockets.networking.ChannelClient(new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861).cljs$core$IFn$_invoke$arity$1(G__55812),new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(G__55812),new cljs.core.Keyword(null,"init-chan","init-chan",2144713800).cljs$core$IFn$_invoke$arity$1(G__55812),new cljs.core.Keyword(null,"channel-socket","channel-socket",416262463).cljs$core$IFn$_invoke$arity$1(G__55812),new cljs.core.Keyword(null,"send-fn","send-fn",351002041).cljs$core$IFn$_invoke$arity$1(G__55812),new cljs.core.Keyword(null,"global-error-callback","global-error-callback",901427631).cljs$core$IFn$_invoke$arity$1(G__55812),new cljs.core.Keyword(null,"req-params","req-params",2117077454).cljs$core$IFn$_invoke$arity$1(G__55812),new cljs.core.Keyword(null,"parse-queue","parse-queue",1928611689).cljs$core$IFn$_invoke$arity$1(G__55812),new cljs.core.Keyword(null,"completed-app","completed-app",-635152970).cljs$core$IFn$_invoke$arity$1(G__55812),null,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,G__55812,new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861),new cljs.core.Keyword(null,"url","url",276297046),new cljs.core.Keyword(null,"init-chan","init-chan",2144713800),new cljs.core.Keyword(null,"channel-socket","channel-socket",416262463),new cljs.core.Keyword(null,"send-fn","send-fn",351002041),new cljs.core.Keyword(null,"global-error-callback","global-error-callback",901427631),new cljs.core.Keyword(null,"req-params","req-params",2117077454),new cljs.core.Keyword(null,"parse-queue","parse-queue",1928611689),new cljs.core.Keyword(null,"completed-app","completed-app",-635152970))),null));
});

/**
 * Creates a client side networking component for use in place of the default fulcro networking component.
 * 
 *   Params:
 *   - `url` - The url to handle websocket traffic on. (ex. "\chsk")
 *   - `host` (Optional) - server that is hosting the websocket server
 *   - `global-error-callback` (Optional) - Analagous to the global error callback in fulcro client.
 *   - `req-params` (Optional) - Params to be attached to the initial request.
 *   - `state-callback` (Optional) - Callback that runs when the websocket state of the websocket changes.
 *    The function takes an old state parameter and a new state parameter (arity 2 function).
 *    `state-callback` can be either a function, or an atom containing a function.
 *   - `transit-handlers` (Optional) - Expects a map with `:read` and/or `:write` key containing a map of transit handlers,
 *   
 */
fulcro.websockets.networking.make_channel_client = (function fulcro$websockets$networking$make_channel_client(var_args){
var args__29319__auto__ = [];
var len__29312__auto___55961 = arguments.length;
var i__29313__auto___55962 = (0);
while(true){
if((i__29313__auto___55962 < len__29312__auto___55961)){
args__29319__auto__.push((arguments[i__29313__auto___55962]));

var G__55963 = (i__29313__auto___55962 + (1));
i__29313__auto___55962 = G__55963;
continue;
} else {
}
break;
}

var argseq__29320__auto__ = ((((1) < args__29319__auto__.length))?(new cljs.core.IndexedSeq(args__29319__auto__.slice((1)),(0),null)):null);
return fulcro.websockets.networking.make_channel_client.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29320__auto__);
});

fulcro.websockets.networking.make_channel_client.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__55956){
var map__55957 = p__55956;
var map__55957__$1 = ((((!((map__55957 == null)))?((((map__55957.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55957.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__55957):map__55957);
var global_error_callback = cljs.core.get.call(null,map__55957__$1,new cljs.core.Keyword(null,"global-error-callback","global-error-callback",901427631));
var host = cljs.core.get.call(null,map__55957__$1,new cljs.core.Keyword(null,"host","host",-1558485167));
var req_params = cljs.core.get.call(null,map__55957__$1,new cljs.core.Keyword(null,"req-params","req-params",2117077454));
var state_callback = cljs.core.get.call(null,map__55957__$1,new cljs.core.Keyword(null,"state-callback","state-callback",-1311788585));
var transit_handlers = cljs.core.get.call(null,map__55957__$1,new cljs.core.Keyword(null,"transit-handlers","transit-handlers",-1206080791));
var parse_queue = cljs.core.async.chan.call(null);
var map__55959 = taoensso.sente.make_channel_socket_BANG_.call(null,url,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"packer","packer",66077544),fulcro.websockets.transit_packer.make_packer.call(null,transit_handlers),new cljs.core.Keyword(null,"host","host",-1558485167),host,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"params","params",710516235),req_params,new cljs.core.Keyword(null,"wrap-recv-evs?","wrap-recv-evs?",-1996694153),false], null));
var map__55959__$1 = ((((!((map__55959 == null)))?((((map__55959.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55959.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__55959):map__55959);
var chsk = cljs.core.get.call(null,map__55959__$1,new cljs.core.Keyword(null,"chsk","chsk",-863703081));
var ch_recv = cljs.core.get.call(null,map__55959__$1,new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861));
var send_fn = cljs.core.get.call(null,map__55959__$1,new cljs.core.Keyword(null,"send-fn","send-fn",351002041));
var state = cljs.core.get.call(null,map__55959__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var channel_client = fulcro.websockets.networking.map__GT_ChannelClient.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861),ch_recv,new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"init-chan","init-chan",2144713800),cljs.core.async.promise_chan.call(null),new cljs.core.Keyword(null,"channel-socket","channel-socket",416262463),chsk,new cljs.core.Keyword(null,"send-fn","send-fn",351002041),send_fn,new cljs.core.Keyword(null,"global-error-callback","global-error-callback",901427631),global_error_callback,new cljs.core.Keyword(null,"req-params","req-params",2117077454),req_params,new cljs.core.Keyword(null,"parse-queue","parse-queue",1928611689),parse_queue], null));
if(cljs.core.fn_QMARK_.call(null,state_callback)){
cljs.core.add_watch.call(null,state,new cljs.core.Keyword("fulcro.websockets.networking","state-callback","fulcro.websockets.networking/state-callback",-1576821266),((function (parse_queue,map__55959,map__55959__$1,chsk,ch_recv,send_fn,state,channel_client,map__55957,map__55957__$1,global_error_callback,host,req_params,state_callback,transit_handlers){
return (function (a,k,o,n){
return state_callback.call(null,o,n);
});})(parse_queue,map__55959,map__55959__$1,chsk,ch_recv,send_fn,state,channel_client,map__55957,map__55957__$1,global_error_callback,host,req_params,state_callback,transit_handlers))
);
} else {
if((state_callback instanceof cljs.core.Atom)){
cljs.core.add_watch.call(null,state,new cljs.core.Keyword("fulcro.websockets.networking","state-callback","fulcro.websockets.networking/state-callback",-1576821266),((function (parse_queue,map__55959,map__55959__$1,chsk,ch_recv,send_fn,state,channel_client,map__55957,map__55957__$1,global_error_callback,host,req_params,state_callback,transit_handlers){
return (function (a,k,o,n){
return cljs.core.deref.call(null,state_callback).call(null,o,n);
});})(parse_queue,map__55959,map__55959__$1,chsk,ch_recv,send_fn,state,channel_client,map__55957,map__55957__$1,global_error_callback,host,req_params,state_callback,transit_handlers))
);
} else {
}
}

return channel_client;
});

fulcro.websockets.networking.make_channel_client.cljs$lang$maxFixedArity = (1);

fulcro.websockets.networking.make_channel_client.cljs$lang$applyTo = (function (seq55954){
var G__55955 = cljs.core.first.call(null,seq55954);
var seq55954__$1 = cljs.core.next.call(null,seq55954);
return fulcro.websockets.networking.make_channel_client.cljs$core$IFn$_invoke$arity$variadic(G__55955,seq55954__$1);
});


//# sourceMappingURL=networking.js.map?rel=1511404500303
