// Compiled by ClojureScript 1.9.946 {}
goog.provide('fulcro.client.mutations');
goog.require('cljs.core');
goog.require('cljs.spec.alpha');
goog.require('om.next');
goog.require('fulcro.client.util');
goog.require('fulcro.client.logging');
goog.require('fulcro.i18n');
goog.require('cljs.loader');
if(typeof fulcro.client.mutations.mutate !== 'undefined'){
} else {
fulcro.client.mutations.mutate = (function (){var method_table__29098__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__29099__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__29100__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__29101__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__29102__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"fulcro.client.mutations","mutate"),om.next.dispatch,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__29102__auto__,method_table__29098__auto__,prefer_table__29099__auto__,method_cache__29100__auto__,cached_hierarchy__29101__auto__));
})();
}
if(typeof fulcro.client.mutations.post_mutate !== 'undefined'){
} else {
fulcro.client.mutations.post_mutate = (function (){var method_table__29098__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__29099__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__29100__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__29101__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__29102__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"fulcro.client.mutations","post-mutate"),om.next.dispatch,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__29102__auto__,method_table__29098__auto__,prefer_table__29099__auto__,method_cache__29100__auto__,cached_hierarchy__29101__auto__));
})();
}
cljs.core._add_method.call(null,fulcro.client.mutations.post_mutate,new cljs.core.Keyword(null,"default","default",-1987822328),(function (env,k,p){
return null;
}));
fulcro.client.mutations.default_locale_QMARK_ = (function fulcro$client$mutations$default_locale_QMARK_(locale_string){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["en",null,"en-US",null], null), null).call(null,locale_string);
});
fulcro.client.mutations.locale_present_QMARK_ = (function fulcro$client$mutations$locale_present_QMARK_(locale_string){
var or__28141__auto__ = fulcro.client.mutations.default_locale_QMARK_.call(null,locale_string);
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
return cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,fulcro.i18n._STAR_loaded_translations_STAR_),locale_string);
}
});
/**
 * Returns true if the given locale is in a loadable module. Always returns false on the server-side.
 */
fulcro.client.mutations.locale_loadable_QMARK_ = (function fulcro$client$mutations$locale_loadable_QMARK_(locale_key){
return cljs.core.contains_QMARK_.call(null,cljs.loader.module_infos,locale_key);
});
/**
 * Given a state map and locale, returns a new state map with the locale properly changed. Also potentially triggers a module load.
 *   There is also the mutation `change-locale` that can be used from transact.
 */
fulcro.client.mutations.change_locale_impl = (function fulcro$client$mutations$change_locale_impl(state_map,lang){
var lang__$1 = cljs.core.name.call(null,lang);
var locale_key = cljs.core.keyword.call(null,lang__$1);
var present_QMARK_ = fulcro.client.mutations.locale_present_QMARK_.call(null,lang__$1);
var valid_locale_QMARK_ = (function (){var or__28141__auto__ = present_QMARK_;
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
return fulcro.client.mutations.locale_loadable_QMARK_.call(null,locale_key);
}
})();
if(cljs.core.truth_(valid_locale_QMARK_)){
if(cljs.core.truth_((function (){var and__28129__auto__ = cljs.core.not.call(null,present_QMARK_);
if(and__28129__auto__){
return fulcro.client.mutations.locale_loadable_QMARK_.call(null,locale_key);
} else {
return and__28129__auto__;
}
})())){
cljs.loader.load.call(null,locale_key,((function (lang__$1,locale_key,present_QMARK_,valid_locale_QMARK_){
return (function (){
return fulcro.client.logging.debug.call(null,"Finished loading locale ",lang__$1);
});})(lang__$1,locale_key,present_QMARK_,valid_locale_QMARK_))
);
} else {
}

cljs.core.reset_BANG_.call(null,fulcro.i18n._STAR_current_locale_STAR_,lang__$1);

return cljs.core.assoc.call(null,cljs.core.assoc.call(null,state_map,new cljs.core.Keyword("ui","locale","ui/locale",-2115717461),lang__$1),new cljs.core.Keyword("ui","react-key","ui/react-key",1337877664),lang__$1);
} else {
fulcro.client.logging.error.call(null,["Attempt to change locale to ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(lang__$1)," but there was no such locale required or available as a loadable module."].join(''));

return state_map;
}
});
cljs.core._add_method.call(null,fulcro.client.mutations.mutate,new cljs.core.Symbol("fulcro.client.mutations","change-locale","fulcro.client.mutations/change-locale",386431844,null),(function (env71336,_,p__71337){
var map__71338 = p__71337;
var map__71338__$1 = ((((!((map__71338 == null)))?((((map__71338.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__71338.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__71338):map__71338);
var lang = cljs.core.get.call(null,map__71338__$1,new cljs.core.Keyword(null,"lang","lang",-1819677104));
return cljs.core.merge.call(null,(function (){var map__71340 = env71336;
var map__71340__$1 = ((((!((map__71340 == null)))?((((map__71340.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__71340.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__71340):map__71340);
var state = cljs.core.get.call(null,map__71340__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"action","action",-811238024),((function (map__71340,map__71340__$1,state,map__71338,map__71338__$1,lang){
return (function (){
return cljs.core.swap_BANG_.call(null,state,fulcro.client.mutations.change_locale_impl,lang);
});})(map__71340,map__71340__$1,state,map__71338,map__71338__$1,lang))
], null);
})(),(function (){var env = env71336;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"remote","remote",-1593576576),false], null);
})());
}));
cljs.core._add_method.call(null,fulcro.client.mutations.mutate,new cljs.core.Symbol("fulcro.client.mutations","set-props","fulcro.client.mutations/set-props",-1739323709,null),(function (env71342,_,params){
return cljs.core.merge.call(null,(function (){var map__71343 = env71342;
var map__71343__$1 = ((((!((map__71343 == null)))?((((map__71343.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__71343.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__71343):map__71343);
var state = cljs.core.get.call(null,map__71343__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var ref = cljs.core.get.call(null,map__71343__$1,new cljs.core.Keyword(null,"ref","ref",1289896967));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"action","action",-811238024),((function (map__71343,map__71343__$1,state,ref){
return (function (){
if((ref == null)){
fulcro.client.logging.error.call(null,"ui/set-props requires component to have an ident.");
} else {
}

return cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,ref,((function (map__71343,map__71343__$1,state,ref){
return (function (st){
return cljs.core.merge.call(null,st,params);
});})(map__71343,map__71343__$1,state,ref))
);
});})(map__71343,map__71343__$1,state,ref))
], null);
})(),(function (){var env = env71342;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"remote","remote",-1593576576),false], null);
})());
}));
cljs.core._add_method.call(null,fulcro.client.mutations.mutate,new cljs.core.Symbol("fulcro.client.mutations","toggle","fulcro.client.mutations/toggle",-1176623641,null),(function (env71345,_,p__71346){
var map__71347 = p__71346;
var map__71347__$1 = ((((!((map__71347 == null)))?((((map__71347.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__71347.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__71347):map__71347);
var field = cljs.core.get.call(null,map__71347__$1,new cljs.core.Keyword(null,"field","field",-1302436500));
return cljs.core.merge.call(null,(function (){var map__71349 = env71345;
var map__71349__$1 = ((((!((map__71349 == null)))?((((map__71349.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__71349.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__71349):map__71349);
var state = cljs.core.get.call(null,map__71349__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var ref = cljs.core.get.call(null,map__71349__$1,new cljs.core.Keyword(null,"ref","ref",1289896967));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"action","action",-811238024),((function (map__71349,map__71349__$1,state,ref,map__71347,map__71347__$1,field){
return (function (){
if((ref == null)){
fulcro.client.logging.error.call(null,"ui/toggle requires component to have an ident.");
} else {
}

return cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,cljs.core.conj.call(null,ref,field),cljs.core.not);
});})(map__71349,map__71349__$1,state,ref,map__71347,map__71347__$1,field))
], null);
})(),(function (){var env = env71345;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"remote","remote",-1593576576),false], null);
})());
}));
cljs.core._add_method.call(null,fulcro.client.mutations.mutate,new cljs.core.Keyword(null,"default","default",-1987822328),(function (p__71351,k,_){
var map__71352 = p__71351;
var map__71352__$1 = ((((!((map__71352 == null)))?((((map__71352.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__71352.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__71352):map__71352);
var target = cljs.core.get.call(null,map__71352__$1,new cljs.core.Keyword(null,"target","target",253001721));
if((target == null)){
return fulcro.client.logging.error.call(null,fulcro.client.logging.value_message.call(null,"Unknown app state mutation. Have you required the file with your mutations?",k));
} else {
return null;
}
}));
/**
 * Toggle the given boolean `field` on the specified component. It is recommended you use this function only on
 *   UI-related data (e.g. form checkbox checked status) and write clear top-level transactions for anything more complicated.
 */
fulcro.client.mutations.toggle_BANG_ = (function fulcro$client$mutations$toggle_BANG_(comp,field){
return om.next.transact_BANG_.call(null,comp,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__29003__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("fulcro.client.mutations","toggle","fulcro.client.mutations/toggle",-1176623641,null)),(function (){var x__29003__auto__ = cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"field","field",-1302436500)),(function (){var x__29003__auto__ = field;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__29003__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__29003__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__29003__auto__);
})())))));
});
/**
 * Set a raw value on the given `field` of a `component`. It is recommended you use this function only on
 *   UI-related data (e.g. form inputs that are used by the UI, and not persisted data).
 */
fulcro.client.mutations.set_value_BANG_ = (function fulcro$client$mutations$set_value_BANG_(component,field,value){
return om.next.transact_BANG_.call(null,component,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__29003__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("fulcro.client.mutations","set-props","fulcro.client.mutations/set-props",-1739323709,null)),(function (){var x__29003__auto__ = cljs.core.PersistentArrayMap.createAsIfByAssoc([field,value]);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__29003__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__29003__auto__);
})())))));
});
/**
 * Helper for set-integer!, use that instead. It is recommended you use this function only on UI-related
 *   data (e.g. data that is used for display purposes) and write clear top-level transactions for anything else.
 */
fulcro.client.mutations.ensure_integer = (function fulcro$client$mutations$ensure_integer(v){
var rv = parseInt(v);
if(cljs.core.truth_(isNaN(v))){
return (0);
} else {
return rv;
}
});
fulcro.client.mutations.target_value = (function fulcro$client$mutations$target_value(evt){
return evt.target.value;
});
/**
 * Set the given integer on the given `field` of a `component`. Allows same parameters as `set-string!`.
 * 
 * It is recommended you use this function only on UI-related data (e.g. data that is used for display purposes)
 * and write clear top-level transactions for anything else.
 */
fulcro.client.mutations.set_integer_BANG_ = (function fulcro$client$mutations$set_integer_BANG_(var_args){
var args__29319__auto__ = [];
var len__29312__auto___71360 = arguments.length;
var i__29313__auto___71361 = (0);
while(true){
if((i__29313__auto___71361 < len__29312__auto___71360)){
args__29319__auto__.push((arguments[i__29313__auto___71361]));

var G__71362 = (i__29313__auto___71361 + (1));
i__29313__auto___71361 = G__71362;
continue;
} else {
}
break;
}

var argseq__29320__auto__ = ((((2) < args__29319__auto__.length))?(new cljs.core.IndexedSeq(args__29319__auto__.slice((2)),(0),null)):null);
return fulcro.client.mutations.set_integer_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__29320__auto__);
});

fulcro.client.mutations.set_integer_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (component,field,p__71357){
var map__71358 = p__71357;
var map__71358__$1 = ((((!((map__71358 == null)))?((((map__71358.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__71358.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__71358):map__71358);
var event = cljs.core.get.call(null,map__71358__$1,new cljs.core.Keyword(null,"event","event",301435442));
var value = cljs.core.get.call(null,map__71358__$1,new cljs.core.Keyword(null,"value","value",305978217));
if(cljs.core.truth_((function (){var and__28129__auto__ = (function (){var or__28141__auto__ = event;
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
return value;
}
})();
if(cljs.core.truth_(and__28129__auto__)){
return cljs.core.not.call(null,(function (){var and__28129__auto____$1 = event;
if(cljs.core.truth_(and__28129__auto____$1)){
return value;
} else {
return and__28129__auto____$1;
}
})());
} else {
return and__28129__auto__;
}
})())){
} else {
throw (new Error(["Assert failed: ","Supply either :event or :value","\n","(and (or event value) (not (and event value)))"].join('')));
}

var value__$1 = fulcro.client.mutations.ensure_integer.call(null,(cljs.core.truth_(event)?fulcro.client.mutations.target_value.call(null,event):value));
return fulcro.client.mutations.set_value_BANG_.call(null,component,field,value__$1);
});

fulcro.client.mutations.set_integer_BANG_.cljs$lang$maxFixedArity = (2);

fulcro.client.mutations.set_integer_BANG_.cljs$lang$applyTo = (function (seq71354){
var G__71355 = cljs.core.first.call(null,seq71354);
var seq71354__$1 = cljs.core.next.call(null,seq71354);
var G__71356 = cljs.core.first.call(null,seq71354__$1);
var seq71354__$2 = cljs.core.next.call(null,seq71354__$1);
return fulcro.client.mutations.set_integer_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__71355,G__71356,seq71354__$2);
});

/**
 * Set a string on the given `field` of a `component`. The string can be literal via named parameter `:value` or
 *   can be auto-extracted from a UI event using the named parameter `:event`
 * 
 *   Examples
 * 
 *   ```
 *   (set-string! this :ui/name :value "Hello") ; set from literal (or var)
 *   (set-string! this :ui/name :event evt) ; extract from UI event target value
 *   ```
 * 
 *   It is recommended you use this function only on UI-related
 *   data (e.g. data that is used for display purposes) and write clear top-level transactions for anything else.
 */
fulcro.client.mutations.set_string_BANG_ = (function fulcro$client$mutations$set_string_BANG_(var_args){
var args__29319__auto__ = [];
var len__29312__auto___71369 = arguments.length;
var i__29313__auto___71370 = (0);
while(true){
if((i__29313__auto___71370 < len__29312__auto___71369)){
args__29319__auto__.push((arguments[i__29313__auto___71370]));

var G__71371 = (i__29313__auto___71370 + (1));
i__29313__auto___71370 = G__71371;
continue;
} else {
}
break;
}

var argseq__29320__auto__ = ((((2) < args__29319__auto__.length))?(new cljs.core.IndexedSeq(args__29319__auto__.slice((2)),(0),null)):null);
return fulcro.client.mutations.set_string_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__29320__auto__);
});

fulcro.client.mutations.set_string_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (component,field,p__71366){
var map__71367 = p__71366;
var map__71367__$1 = ((((!((map__71367 == null)))?((((map__71367.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__71367.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__71367):map__71367);
var event = cljs.core.get.call(null,map__71367__$1,new cljs.core.Keyword(null,"event","event",301435442));
var value = cljs.core.get.call(null,map__71367__$1,new cljs.core.Keyword(null,"value","value",305978217));
if(cljs.core.truth_((function (){var and__28129__auto__ = (function (){var or__28141__auto__ = event;
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
return value;
}
})();
if(cljs.core.truth_(and__28129__auto__)){
return cljs.core.not.call(null,(function (){var and__28129__auto____$1 = event;
if(cljs.core.truth_(and__28129__auto____$1)){
return value;
} else {
return and__28129__auto____$1;
}
})());
} else {
return and__28129__auto__;
}
})())){
} else {
throw (new Error(["Assert failed: ","Supply either :event or :value","\n","(and (or event value) (not (and event value)))"].join('')));
}

var value__$1 = (cljs.core.truth_(event)?fulcro.client.mutations.target_value.call(null,event):value);
return fulcro.client.mutations.set_value_BANG_.call(null,component,field,value__$1);
});

fulcro.client.mutations.set_string_BANG_.cljs$lang$maxFixedArity = (2);

fulcro.client.mutations.set_string_BANG_.cljs$lang$applyTo = (function (seq71363){
var G__71364 = cljs.core.first.call(null,seq71363);
var seq71363__$1 = cljs.core.next.call(null,seq71363);
var G__71365 = cljs.core.first.call(null,seq71363__$1);
var seq71363__$2 = cljs.core.next.call(null,seq71363__$1);
return fulcro.client.mutations.set_string_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__71364,G__71365,seq71363__$2);
});


//# sourceMappingURL=mutations.js.map?rel=1511404539238
