// Compiled by ClojureScript 1.9.946 {}
goog.provide('fulcro.client.impl.om_plumbing');
goog.require('cljs.core');
goog.require('om.next');
goog.require('om.util');
goog.require('fulcro.client.mutations');
goog.require('fulcro.client.logging');
goog.require('cljs.core.async');
goog.require('clojure.walk');
/**
 * Read function for the Om parser.
 * 
 *   *** NOTE: This function only runs when it is called without a target -- it is not triggered for remote reads. To
 *   trigger a remote read, use the `fulcro/data-fetch` namespace. ***
 * 
 *   If a user-read is supplied, *it will be allowed* to trigger remote reads. This is not recommended, as you
 *   will probably have to augment the networking layer to get it to do what you mean. Use `load` instead. You have
 *   been warned. Triggering remote reads is allowed, but discouraged and unsupported.
 * 
 *   Returns the current locale when reading the :ui/locale keyword. Otherwise pulls data out of the app-state.
 *   
 */
fulcro.client.impl.om_plumbing.read_local = (function fulcro$client$impl$om_plumbing$read_local(user_read,p__73394,dkey,params){
var map__73395 = p__73394;
var map__73395__$1 = ((((!((map__73395 == null)))?((((map__73395.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__73395.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__73395):map__73395);
var env = map__73395__$1;
var query = cljs.core.get.call(null,map__73395__$1,new cljs.core.Keyword(null,"query","query",-1288509510));
var target = cljs.core.get.call(null,map__73395__$1,new cljs.core.Keyword(null,"target","target",253001721));
var state = cljs.core.get.call(null,map__73395__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var ast = cljs.core.get.call(null,map__73395__$1,new cljs.core.Keyword(null,"ast","ast",-860334068));
var temp__4655__auto__ = user_read.call(null,env,dkey,params);
if(cljs.core.truth_(temp__4655__auto__)){
var custom_result = temp__4655__auto__;
return custom_result;
} else {
if(cljs.core.not.call(null,target)){
var G__73397 = dkey;
switch (G__73397) {
default:
var top_level_prop = (query == null);
var key = (function (){var or__28141__auto__ = new cljs.core.Keyword(null,"key","key",-1516042587).cljs$core$IFn$_invoke$arity$1(ast);
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
return dkey;
}
})();
var by_ident_QMARK_ = om.util.ident_QMARK_.call(null,key);
var union_QMARK_ = cljs.core.map_QMARK_.call(null,query);
var data = ((by_ident_QMARK_)?cljs.core.get_in.call(null,cljs.core.deref.call(null,state),key):cljs.core.get.call(null,cljs.core.deref.call(null,state),key));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),((union_QMARK_)?cljs.core.get.call(null,om.next.db__GT_tree.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentArrayMap.createAsIfByAssoc([key,query])], null),cljs.core.deref.call(null,state),cljs.core.deref.call(null,state)),key):((top_level_prop)?data:om.next.db__GT_tree.call(null,query,data,cljs.core.deref.call(null,state))
))], null);

}
} else {
return null;
}
}
});
/**
 * This is the Om entry point for writes. In general this is simply a call to the multi-method
 *   defined by Fulcro (mutate); however, Fulcro supports the concept of a global `post-mutate`
 *   function that will be called anytime the general mutate has an action that is desired. This
 *   can be useful, for example, in cases where you have some post-processing that needs
 *   to happen for a given (sub)set of mutations (that perhaps you did not define).
 */
fulcro.client.impl.om_plumbing.write_entry_point = (function fulcro$client$impl$om_plumbing$write_entry_point(env,k,params){
var rv = (function (){try{return fulcro.client.mutations.mutate.call(null,env,k,params);
}catch (e73399){var e = e73399;
fulcro.client.logging.error.call(null,["Mutation ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)," failed with exception"].join(''),e);

return null;
}})();
var action = new cljs.core.Keyword(null,"action","action",-811238024).cljs$core$IFn$_invoke$arity$1(rv);
if(cljs.core.truth_(action)){
return cljs.core.assoc.call(null,rv,new cljs.core.Keyword(null,"action","action",-811238024),((function (rv,action){
return (function (){
try{var action_result = action.call(null,env,k,params);
try{fulcro.client.mutations.post_mutate.call(null,env,k,params);
}catch (e73401){var e_73402 = e73401;
fulcro.client.logging.error.call(null,["Post mutate failed on dispatch to ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)].join(''));
}
return action_result;
}catch (e73400){var e = e73400;
fulcro.client.logging.error.call(null,["Mutation ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)," failed with exception"].join(''),e);

throw e;
}});})(rv,action))
);
} else {
return rv;
}
});
/**
 * Replaces all om-tempids in app-state with the ids returned by the server.
 */
fulcro.client.impl.om_plumbing.resolve_tempids = (function fulcro$client$impl$om_plumbing$resolve_tempids(state,tid__GT_rid){
if(cljs.core.empty_QMARK_.call(null,tid__GT_rid)){
return state;
} else {
return clojure.walk.prewalk.call(null,(function (p1__73403_SHARP_){
if(om.next.tempid_QMARK_.call(null,p1__73403_SHARP_)){
return cljs.core.get.call(null,tid__GT_rid,p1__73403_SHARP_,p1__73403_SHARP_);
} else {
return p1__73403_SHARP_;
}
}),state);
}
});
/**
 * Rewrite any pending requests in the request queue to account for the fact that a response might have
 *   changed ids that are expressed in the mutations of that queue. tempid-map MUST be a map from om
 *   tempid to real ids, not idents.
 */
fulcro.client.impl.om_plumbing.rewrite_tempids_in_request_queue = (function fulcro$client$impl$om_plumbing$rewrite_tempids_in_request_queue(queue,tempid_map){
var entry = cljs.core.async.poll_BANG_.call(null,queue);
var entries = cljs.core.PersistentVector.EMPTY;
while(true){
if(cljs.core.truth_(entry)){
var G__73408 = cljs.core.async.poll_BANG_.call(null,queue);
var G__73409 = cljs.core.conj.call(null,entries,fulcro.client.impl.om_plumbing.resolve_tempids.call(null,entry,tempid_map));
entry = G__73408;
entries = G__73409;
continue;
} else {
if(cljs.core.seq.call(null,entries)){
var seq__73404 = cljs.core.seq.call(null,entries);
var chunk__73405 = null;
var count__73406 = (0);
var i__73407 = (0);
while(true){
if((i__73407 < count__73406)){
var e = cljs.core._nth.call(null,chunk__73405,i__73407);
if(cljs.core.truth_(cljs.core.async.offer_BANG_.call(null,queue,e))){
} else {
fulcro.client.logging.error.call(null,"Offer failed to enqueue a value.");
}

var G__73410 = seq__73404;
var G__73411 = chunk__73405;
var G__73412 = count__73406;
var G__73413 = (i__73407 + (1));
seq__73404 = G__73410;
chunk__73405 = G__73411;
count__73406 = G__73412;
i__73407 = G__73413;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__73404);
if(temp__4657__auto__){
var seq__73404__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__73404__$1)){
var c__28980__auto__ = cljs.core.chunk_first.call(null,seq__73404__$1);
var G__73414 = cljs.core.chunk_rest.call(null,seq__73404__$1);
var G__73415 = c__28980__auto__;
var G__73416 = cljs.core.count.call(null,c__28980__auto__);
var G__73417 = (0);
seq__73404 = G__73414;
chunk__73405 = G__73415;
count__73406 = G__73416;
i__73407 = G__73417;
continue;
} else {
var e = cljs.core.first.call(null,seq__73404__$1);
if(cljs.core.truth_(cljs.core.async.offer_BANG_.call(null,queue,e))){
} else {
fulcro.client.logging.error.call(null,"Offer failed to enqueue a value.");
}

var G__73418 = cljs.core.next.call(null,seq__73404__$1);
var G__73419 = null;
var G__73420 = (0);
var G__73421 = (0);
seq__73404 = G__73418;
chunk__73405 = G__73419;
count__73406 = G__73420;
i__73407 = G__73421;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
}
break;
}
});
/**
 * Removes all fulcro/load and tx/fallback mutations from the query
 */
fulcro.client.impl.om_plumbing.remove_loads_and_fallbacks = (function fulcro$client$impl$om_plumbing$remove_loads_and_fallbacks(query){
var symbols_to_filter = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Symbol("fulcro","load","fulcro/load",-1361504416,null),null,new cljs.core.Symbol("fulcro.client.data-fetch","load","fulcro.client.data-fetch/load",-1506599212,null),null,new cljs.core.Symbol("tx","fallback","tx/fallback",-1892802308,null),null,new cljs.core.Symbol("fulcro.client.data-fetch","fallback","fulcro.client.data-fetch/fallback",1556791555,null),null], null), null);
var ast = om.next.query__GT_ast.call(null,query);
var children = new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(ast);
var new_children = cljs.core.filter.call(null,((function (symbols_to_filter,ast,children){
return (function (child){
return !(cljs.core.contains_QMARK_.call(null,symbols_to_filter,new cljs.core.Keyword(null,"dispatch-key","dispatch-key",733619510).cljs$core$IFn$_invoke$arity$1(child)));
});})(symbols_to_filter,ast,children))
,children);
var new_ast = cljs.core.assoc.call(null,ast,new cljs.core.Keyword(null,"children","children",-940561982),new_children);
return om.next.ast__GT_query.call(null,new_ast);
});
fulcro.client.impl.om_plumbing.fallback_query = (function fulcro$client$impl$om_plumbing$fallback_query(query,resp){

var symbols_to_find = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol("tx","fallback","tx/fallback",-1892802308,null),null,new cljs.core.Symbol("fulcro.client.data-fetch","fallback","fulcro.client.data-fetch/fallback",1556791555,null),null], null), null);
var ast = om.next.query__GT_ast.call(null,query);
var children = new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(ast);
var new_children = cljs.core.map.call(null,((function (symbols_to_find,ast,children){
return (function (ast__$1){
return cljs.core.update.call(null,ast__$1,new cljs.core.Keyword(null,"params","params",710516235),cljs.core.assoc,new cljs.core.Keyword(null,"execute","execute",-129499188),true,new cljs.core.Keyword(null,"error","error",-978969032),resp);
});})(symbols_to_find,ast,children))
,cljs.core.filter.call(null,((function (symbols_to_find,ast,children){
return (function (child){
return cljs.core.contains_QMARK_.call(null,symbols_to_find,new cljs.core.Keyword(null,"dispatch-key","dispatch-key",733619510).cljs$core$IFn$_invoke$arity$1(child));
});})(symbols_to_find,ast,children))
,children));
var new_ast = cljs.core.assoc.call(null,ast,new cljs.core.Keyword(null,"children","children",-940561982),new_children);
var fallback_query = om.next.ast__GT_query.call(null,new_ast);
if(cljs.core.truth_(cljs.core.not_empty.call(null,fallback_query))){
return fallback_query;
} else {
return null;
}
});
/**
 * Check the given keyword to see if it is in the :ui namespace.
 */
fulcro.client.impl.om_plumbing.is_ui_query_fragment_QMARK_ = (function fulcro$client$impl$om_plumbing$is_ui_query_fragment_QMARK_(kw){
var kw__$1 = ((cljs.core.map_QMARK_.call(null,kw))?cljs.core.first.call(null,cljs.core.keys.call(null,kw)):kw);
if((kw__$1 instanceof cljs.core.Keyword)){
var G__73422 = kw__$1;
var G__73422__$1 = (((G__73422 == null))?null:cljs.core.namespace.call(null,G__73422));
if((G__73422__$1 == null)){
return null;
} else {
return cljs.core.re_find.call(null,/^ui(?:\.|$)/,G__73422__$1);
}
} else {
return null;
}
});
/**
 * Returns a new query with fragments that are in the `ui` namespace removed.
 */
fulcro.client.impl.om_plumbing.strip_ui = (function fulcro$client$impl$om_plumbing$strip_ui(query){
var ast = om.next.query__GT_ast.call(null,query);
var drop_ui_children = ((function (ast){
return (function fulcro$client$impl$om_plumbing$strip_ui_$_drop_ui_children(ast_node){
var children = cljs.core.reduce.call(null,((function (ast){
return (function (acc,n){
if(cljs.core.truth_(fulcro.client.impl.om_plumbing.is_ui_query_fragment_QMARK_.call(null,new cljs.core.Keyword(null,"dispatch-key","dispatch-key",733619510).cljs$core$IFn$_invoke$arity$1(n)))){
return acc;
} else {
return cljs.core.conj.call(null,acc,fulcro$client$impl$om_plumbing$strip_ui_$_drop_ui_children.call(null,n));
}
});})(ast))
,cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(ast_node));
if(cljs.core.seq.call(null,children)){
return cljs.core.assoc.call(null,ast_node,new cljs.core.Keyword(null,"children","children",-940561982),children);
} else {
return cljs.core.dissoc.call(null,ast_node,new cljs.core.Keyword(null,"children","children",-940561982));
}
});})(ast))
;
return om.next.ast__GT_query.call(null,drop_ui_children.call(null,ast));
});
fulcro.client.impl.om_plumbing.nf = new cljs.core.Keyword("fulcro.client.impl.om-plumbing","not-found","fulcro.client.impl.om-plumbing/not-found",-315197951);
fulcro.client.impl.om_plumbing.walk = (function fulcro$client$impl$om_plumbing$walk(inner,outer,form){
if(cljs.core.map_QMARK_.call(null,form)){
return outer.call(null,cljs.core.into.call(null,cljs.core.empty.call(null,form),cljs.core.map.call(null,(function (p1__73423_SHARP_){
return inner.call(null,cljs.core.with_meta.call(null,p1__73423_SHARP_,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"map-entry?","map-entry?",-499916250),true], null)));
}),form)));
} else {
if(cljs.core.list_QMARK_.call(null,form)){
return outer.call(null,cljs.core.apply.call(null,cljs.core.list,cljs.core.map.call(null,inner,form)));
} else {
if(cljs.core.seq_QMARK_.call(null,form)){
return outer.call(null,cljs.core.doall.call(null,cljs.core.map.call(null,inner,form)));
} else {
if(cljs.core.record_QMARK_.call(null,form)){
return outer.call(null,cljs.core.reduce.call(null,(function (r,x){
return cljs.core.conj.call(null,r,inner.call(null,x));
}),form,form));
} else {
if(cljs.core.coll_QMARK_.call(null,form)){
return outer.call(null,cljs.core.into.call(null,cljs.core.empty.call(null,form),cljs.core.map.call(null,inner,form)));
} else {
return outer.call(null,form);

}
}
}
}
}
});
fulcro.client.impl.om_plumbing.prewalk = (function fulcro$client$impl$om_plumbing$prewalk(f,form){
return fulcro.client.impl.om_plumbing.walk.call(null,cljs.core.partial.call(null,fulcro.client.impl.om_plumbing.prewalk,f),cljs.core.identity,f.call(null,form));
});
fulcro.client.impl.om_plumbing.postwalk = (function fulcro$client$impl$om_plumbing$postwalk(f,form){
return fulcro.client.impl.om_plumbing.walk.call(null,cljs.core.partial.call(null,fulcro.client.impl.om_plumbing.postwalk,f),f,form);
});
fulcro.client.impl.om_plumbing.recursive_QMARK_ = (function fulcro$client$impl$om_plumbing$recursive_QMARK_(qf){
return cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"...","...",-1926939749,null),qf);
});
fulcro.client.impl.om_plumbing.add_meta_to_recursive_queries = (function fulcro$client$impl$om_plumbing$add_meta_to_recursive_queries(q){
var a = cljs.core.atom.call(null,q);
return fulcro.client.impl.om_plumbing.postwalk.call(null,((function (a){
return (function (p1__73425_SHARP_){
if(cljs.core.truth_((function (){var and__28129__auto__ = cljs.core.vector_QMARK_.call(null,p1__73425_SHARP_);
if(and__28129__auto__){
var and__28129__auto____$1 = cljs.core.not.call(null,(function (){var G__73430 = p1__73425_SHARP_;
var G__73430__$1 = (((G__73430 == null))?null:cljs.core.meta.call(null,G__73430));
if((G__73430__$1 == null)){
return null;
} else {
return new cljs.core.Keyword(null,"map-entry?","map-entry?",-499916250).cljs$core$IFn$_invoke$arity$1(G__73430__$1);
}
})());
if(and__28129__auto____$1){
var and__28129__auto____$2 = cljs.core._EQ_.call(null,cljs.core.count.call(null,p1__73425_SHARP_),(2));
if(and__28129__auto____$2){
var G__73432 = p1__73425_SHARP_;
var G__73432__$1 = (((G__73432 == null))?null:cljs.core.second.call(null,G__73432));
var G__73432__$2 = (((G__73432__$1 == null))?null:cljs.core.meta.call(null,G__73432__$1));
var G__73432__$3 = (((G__73432__$2 == null))?null:new cljs.core.Keyword(null,"depth","depth",1768663640).cljs$core$IFn$_invoke$arity$1(G__73432__$2));
if((G__73432__$3 == null)){
return null;
} else {
return typeof G__73432__$3 === 'number';
}
} else {
return and__28129__auto____$2;
}
} else {
return and__28129__auto____$1;
}
} else {
return and__28129__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,p1__73425_SHARP_),new cljs.core.Keyword(null,"depth","depth",1768663640).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,cljs.core.second.call(null,p1__73425_SHARP_)))], null);
} else {
return p1__73425_SHARP_;

}
});})(a))
,fulcro.client.impl.om_plumbing.prewalk.call(null,((function (a){
return (function (p1__73424_SHARP_){
if((cljs.core.vector_QMARK_.call(null,p1__73424_SHARP_)) && (new cljs.core.Keyword(null,"map-entry?","map-entry?",-499916250).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,p1__73424_SHARP_)) === false)){
cljs.core.reset_BANG_.call(null,a,p1__73424_SHARP_);

return p1__73424_SHARP_;
} else {
if(typeof p1__73424_SHARP_ === 'number'){
return cljs.core.with_meta.call(null,new cljs.core.Symbol(null,"...","...",-1926939749,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"...","...",727496020),cljs.core.deref.call(null,a),new cljs.core.Keyword(null,"depth","depth",1768663640),p1__73424_SHARP_], null));
} else {
if(cljs.core.truth_(fulcro.client.impl.om_plumbing.recursive_QMARK_.call(null,p1__73424_SHARP_))){
return cljs.core.with_meta.call(null,p1__73424_SHARP_,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"...","...",727496020),cljs.core.deref.call(null,a)], null));
} else {
return p1__73424_SHARP_;

}
}
}
});})(a))
,q));
});
/**
 * Returns data with meta-data marking it as a leaf in the result.
 */
fulcro.client.impl.om_plumbing.as_leaf = (function fulcro$client$impl$om_plumbing$as_leaf(data){
if(cljs.core.coll_QMARK_.call(null,data)){
return cljs.core.with_meta.call(null,data,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("fulcro","leaf","fulcro/leaf",-2094500471),true], null));
} else {
return data;
}
});
/**
 * Returns true iff the given data is marked as a leaf in the result (according to the query). Requires pre-marking.
 */
fulcro.client.impl.om_plumbing.leaf_QMARK_ = (function fulcro$client$impl$om_plumbing$leaf_QMARK_(data){
return (!(cljs.core.coll_QMARK_.call(null,data))) || (cljs.core.empty_QMARK_.call(null,data)) || ((cljs.core.coll_QMARK_.call(null,data)) && (cljs.core.boolean$.call(null,new cljs.core.Keyword("fulcro","leaf","fulcro/leaf",-2094500471).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,data)))));
});
/**
 * Recursively walk the query and response marking anything that was *asked for* in the query but is *not* in the response as missing.
 *   The merge process (which happens later in the plumbing) looks for these markers as indicators to remove any existing
 *   data in the database (which has provably disappeared).
 * 
 *   The naive approach to data merging (even recursive) would fail to remove such data.
 * 
 *   Returns the result with missing markers in place (which are then used/removed in a later stage).
 */
fulcro.client.impl.om_plumbing.mark_missing = (function fulcro$client$impl$om_plumbing$mark_missing(result,query){
var paramterized_QMARK_ = (function fulcro$client$impl$om_plumbing$mark_missing_$_paramterized_QMARK_(q){
return (cljs.core.list_QMARK_.call(null,q)) && (((cljs.core.first.call(null,q) instanceof cljs.core.Symbol)) || (cljs.core._EQ_.call(null,(2),cljs.core.count.call(null,q))));
});
var ok_STAR_not_found = (function fulcro$client$impl$om_plumbing$mark_missing_$_ok_STAR_not_found(res,k){
if(cljs.core.contains_QMARK_.call(null,res,k)){
return res;
} else {
if(cljs.core.truth_(fulcro.client.impl.om_plumbing.recursive_QMARK_.call(null,k))){
return res;
} else {
if(om.util.ident_QMARK_.call(null,k)){
return cljs.core.assoc.call(null,((cljs.core.map_QMARK_.call(null,res))?res:cljs.core.PersistentArrayMap.EMPTY),k,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("ui","fetch-state","ui/fetch-state",1030289927),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("fulcro.client.impl.data-fetch","type","fulcro.client.impl.data-fetch/type",296514265),new cljs.core.Keyword(null,"not-found","not-found",-629079980)], null)], null));
} else {
return cljs.core.assoc.call(null,((cljs.core.map_QMARK_.call(null,res))?res:cljs.core.PersistentArrayMap.EMPTY),k,fulcro.client.impl.om_plumbing.nf);

}
}
}
});
var union__GT_query = (function fulcro$client$impl$om_plumbing$mark_missing_$_union__GT_query(u){
return cljs.core.set.call(null,cljs.core.flatten.call(null,cljs.core.vals.call(null,u)));
});
var union_QMARK_ = (function fulcro$client$impl$om_plumbing$mark_missing_$_union_QMARK_(q){
var expr = (function (){var G__73440 = q;
if(cljs.core.seq_QMARK_.call(null,q)){
return cljs.core.first.call(null,G__73440);
} else {
return G__73440;
}
})();
return (cljs.core.map_QMARK_.call(null,expr)) && (((1) < cljs.core.count.call(null,cljs.core.seq.call(null,expr))));
});
var step = (function fulcro$client$impl$om_plumbing$mark_missing_$_step(res,q){
var q__$1 = (cljs.core.truth_(paramterized_QMARK_.call(null,q))?cljs.core.first.call(null,q):q);
var vec__73441 = (cljs.core.truth_(om.util.join_QMARK_.call(null,q__$1))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [om.util.join_key.call(null,q__$1),om.util.join_value.call(null,q__$1)], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [q__$1,null], null)
);
var query_key = cljs.core.nth.call(null,vec__73441,(0),null);
var _QMARK_sub_query = cljs.core.nth.call(null,vec__73441,(1),null);
var result_or_not_found = ok_STAR_not_found.call(null,res,query_key);
var result_or_not_found__$1 = ((((q__$1 instanceof cljs.core.Keyword)) && (cljs.core.map_QMARK_.call(null,result_or_not_found)))?cljs.core.update.call(null,result_or_not_found,q__$1,fulcro.client.impl.om_plumbing.as_leaf):result_or_not_found);
var sub_result = cljs.core.get.call(null,result_or_not_found__$1,query_key);
if(cljs.core.truth_((function (){var and__28129__auto__ = union_QMARK_.call(null,_QMARK_sub_query);
if(cljs.core.truth_(and__28129__auto__)){
return cljs.core.map_QMARK_.call(null,sub_result);
} else {
return and__28129__auto__;
}
})())){
return cljs.core.assoc.call(null,result_or_not_found__$1,query_key,fulcro.client.impl.om_plumbing.mark_missing.call(null,sub_result,union__GT_query.call(null,cljs.core.get.call(null,q__$1,query_key))));
} else {
if(cljs.core.truth_((function (){var and__28129__auto__ = union_QMARK_.call(null,_QMARK_sub_query);
if(cljs.core.truth_(and__28129__auto__)){
return cljs.core.coll_QMARK_.call(null,sub_result);
} else {
return and__28129__auto__;
}
})())){
var _LT__GT_ = sub_result;
var _LT__GT___$1 = cljs.core.mapv.call(null,((function (_LT__GT_,q__$1,vec__73441,query_key,_QMARK_sub_query,result_or_not_found,result_or_not_found__$1,sub_result){
return (function (p1__73433_SHARP_){
return fulcro.client.impl.om_plumbing.mark_missing.call(null,p1__73433_SHARP_,union__GT_query.call(null,cljs.core.get.call(null,q__$1,query_key)));
});})(_LT__GT_,q__$1,vec__73441,query_key,_QMARK_sub_query,result_or_not_found,result_or_not_found__$1,sub_result))
,_LT__GT_);
return cljs.core.assoc.call(null,result_or_not_found__$1,query_key,_LT__GT___$1);
} else {
if(cljs.core.truth_(fulcro.client.impl.om_plumbing.is_ui_query_fragment_QMARK_.call(null,q__$1))){
return fulcro.client.impl.om_plumbing.as_leaf.call(null,res);
} else {
if(cljs.core.truth_((function (){var and__28129__auto__ = _QMARK_sub_query;
if(cljs.core.truth_(and__28129__auto__)){
return (cljs.core.not_EQ_.call(null,fulcro.client.impl.om_plumbing.nf,sub_result)) && (cljs.core.not.call(null,fulcro.client.impl.om_plumbing.recursive_QMARK_.call(null,_QMARK_sub_query)));
} else {
return and__28129__auto__;
}
})())){
var _LT__GT_ = sub_result;
var _LT__GT___$1 = ((cljs.core.vector_QMARK_.call(null,_LT__GT_))?cljs.core.mapv.call(null,((function (_LT__GT_,q__$1,vec__73441,query_key,_QMARK_sub_query,result_or_not_found,result_or_not_found__$1,sub_result){
return (function (p1__73434_SHARP_){
return fulcro.client.impl.om_plumbing.mark_missing.call(null,p1__73434_SHARP_,_QMARK_sub_query);
});})(_LT__GT_,q__$1,vec__73441,query_key,_QMARK_sub_query,result_or_not_found,result_or_not_found__$1,sub_result))
,_LT__GT_):fulcro.client.impl.om_plumbing.mark_missing.call(null,_LT__GT_,_QMARK_sub_query));
return cljs.core.assoc.call(null,result_or_not_found__$1,query_key,_LT__GT___$1);
} else {
if(cljs.core.truth_(fulcro.client.impl.om_plumbing.recursive_QMARK_.call(null,_QMARK_sub_query))){
var temp__4655__auto__ = cljs.core.get.call(null,res,query_key);
if(cljs.core.truth_(temp__4655__auto__)){
var res_ = temp__4655__auto__;
var _LT__GT_ = res_;
var _LT__GT___$1 = ((cljs.core.vector_QMARK_.call(null,_LT__GT_))?cljs.core.mapv.call(null,((function (_LT__GT_,res_,temp__4655__auto__,q__$1,vec__73441,query_key,_QMARK_sub_query,result_or_not_found,result_or_not_found__$1,sub_result){
return (function (p1__73435_SHARP_){
return fulcro.client.impl.om_plumbing.mark_missing.call(null,p1__73435_SHARP_,_QMARK_sub_query);
});})(_LT__GT_,res_,temp__4655__auto__,q__$1,vec__73441,query_key,_QMARK_sub_query,result_or_not_found,result_or_not_found__$1,sub_result))
,_LT__GT_):fulcro.client.impl.om_plumbing.mark_missing.call(null,_LT__GT_,_QMARK_sub_query));
return cljs.core.assoc.call(null,res,query_key,_LT__GT___$1);
} else {
return result_or_not_found__$1;
}
} else {
return result_or_not_found__$1;

}
}
}
}
}
});
return cljs.core.reduce.call(null,step,result,(cljs.core.truth_(fulcro.client.impl.om_plumbing.recursive_QMARK_.call(null,query))?fulcro.client.impl.om_plumbing.add_meta_to_recursive_queries.call(null,new cljs.core.Keyword(null,"...","...",727496020).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,query))):fulcro.client.impl.om_plumbing.add_meta_to_recursive_queries.call(null,query)));
});

//# sourceMappingURL=om_plumbing.js.map?rel=1511404541473
