// Compiled by ClojureScript 1.9.946 {}
goog.provide('figwheel.client');
goog.require('cljs.core');
goog.require('goog.Uri');
goog.require('goog.userAgent.product');
goog.require('goog.object');
goog.require('cljs.reader');
goog.require('cljs.core.async');
goog.require('figwheel.client.socket');
goog.require('figwheel.client.utils');
goog.require('figwheel.client.heads_up');
goog.require('figwheel.client.file_reloading');
goog.require('clojure.string');
goog.require('cljs.repl');
figwheel.client._figwheel_version_ = "0.5.13";
figwheel.client.js_stringify = (((typeof JSON !== 'undefined') && (!((JSON.stringify == null))))?(function (x){
return ["#js ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(JSON.stringify(x,null," "))].join('');
}):(function (x){
try{return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join('');
}catch (e62879){if((e62879 instanceof Error)){
var e = e62879;
return "Error: Unable to stringify";
} else {
throw e62879;

}
}}));
figwheel.client.figwheel_repl_print = (function figwheel$client$figwheel_repl_print(var_args){
var G__62882 = arguments.length;
switch (G__62882) {
case 2:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2 = (function (stream,args){
figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),"figwheel-repl-print",new cljs.core.Keyword(null,"content","content",15833224),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"stream","stream",1534941648),stream,new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.mapv.call(null,(function (p1__62880_SHARP_){
if(typeof p1__62880_SHARP_ === 'string'){
return p1__62880_SHARP_;
} else {
return figwheel.client.js_stringify.call(null,p1__62880_SHARP_);
}
}),args)], null)], null));

return null;
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1 = (function (args){
return figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);
});

figwheel.client.figwheel_repl_print.cljs$lang$maxFixedArity = 2;

figwheel.client.console_out_print = (function figwheel$client$console_out_print(args){
return console.log.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.console_err_print = (function figwheel$client$console_err_print(args){
return console.error.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.repl_out_print_fn = (function figwheel$client$repl_out_print_fn(var_args){
var args__29319__auto__ = [];
var len__29312__auto___62885 = arguments.length;
var i__29313__auto___62886 = (0);
while(true){
if((i__29313__auto___62886 < len__29312__auto___62885)){
args__29319__auto__.push((arguments[i__29313__auto___62886]));

var G__62887 = (i__29313__auto___62886 + (1));
i__29313__auto___62886 = G__62887;
continue;
} else {
}
break;
}

var argseq__29320__auto__ = ((((0) < args__29319__auto__.length))?(new cljs.core.IndexedSeq(args__29319__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__29320__auto__);
});

figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_out_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);

return null;
});

figwheel.client.repl_out_print_fn.cljs$lang$maxFixedArity = (0);

figwheel.client.repl_out_print_fn.cljs$lang$applyTo = (function (seq62884){
return figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq62884));
});

figwheel.client.repl_err_print_fn = (function figwheel$client$repl_err_print_fn(var_args){
var args__29319__auto__ = [];
var len__29312__auto___62889 = arguments.length;
var i__29313__auto___62890 = (0);
while(true){
if((i__29313__auto___62890 < len__29312__auto___62889)){
args__29319__auto__.push((arguments[i__29313__auto___62890]));

var G__62891 = (i__29313__auto___62890 + (1));
i__29313__auto___62890 = G__62891;
continue;
} else {
}
break;
}

var argseq__29320__auto__ = ((((0) < args__29319__auto__.length))?(new cljs.core.IndexedSeq(args__29319__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__29320__auto__);
});

figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_err_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"err","err",-2089457205),args);

return null;
});

figwheel.client.repl_err_print_fn.cljs$lang$maxFixedArity = (0);

figwheel.client.repl_err_print_fn.cljs$lang$applyTo = (function (seq62888){
return figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq62888));
});

figwheel.client.enable_repl_print_BANG_ = (function figwheel$client$enable_repl_print_BANG_(){
cljs.core._STAR_print_newline_STAR_ = false;

cljs.core.set_print_fn_BANG_.call(null,figwheel.client.repl_out_print_fn);

cljs.core.set_print_err_fn_BANG_.call(null,figwheel.client.repl_err_print_fn);

return null;
});
figwheel.client.autoload_QMARK_ = (function figwheel$client$autoload_QMARK_(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),true);
});
figwheel.client.toggle_autoload = (function figwheel$client$toggle_autoload(){
var res = figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),cljs.core.not.call(null,figwheel.client.autoload_QMARK_.call(null)));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),["Toggle autoload deprecated! Use (figwheel.client/set-autoload! false)"].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),["Figwheel autoloading ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(figwheel.client.autoload_QMARK_.call(null))?"ON":"OFF"))].join(''));

return res;
});
goog.exportSymbol('figwheel.client.toggle_autoload', figwheel.client.toggle_autoload);
/**
 * Figwheel by default loads code changes as you work. Sometimes you
 *   just want to work on your code without the ramifications of
 *   autoloading and simply load your code piecemeal in the REPL. You can
 *   turn autoloading on and of with this method.
 * 
 *   (figwheel.client/set-autoload false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_autoload = (function figwheel$client$set_autoload(b){
if((b === true) || (b === false)){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),b);
});
goog.exportSymbol('figwheel.client.set_autoload', figwheel.client.set_autoload);
figwheel.client.repl_pprint = (function figwheel$client$repl_pprint(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),true);
});
goog.exportSymbol('figwheel.client.repl_pprint', figwheel.client.repl_pprint);
/**
 * This method gives you the ability to turn the pretty printing of
 *   the REPL's return value on and off.
 * 
 *   (figwheel.client/set-repl-pprint false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_repl_pprint = (function figwheel$client$set_repl_pprint(b){
if((b === true) || (b === false)){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),b);
});
goog.exportSymbol('figwheel.client.set_repl_pprint', figwheel.client.set_repl_pprint);
figwheel.client.repl_result_pr_str = (function figwheel$client$repl_result_pr_str(v){
if(cljs.core.truth_(figwheel.client.repl_pprint.call(null))){
return figwheel.client.utils.pprint_to_string.call(null,v);
} else {
return cljs.core.pr_str.call(null,v);
}
});
goog.exportSymbol('figwheel.client.repl_result_pr_str', figwheel.client.repl_result_pr_str);
figwheel.client.get_essential_messages = (function figwheel$client$get_essential_messages(ed){
if(cljs.core.truth_(ed)){
return cljs.core.cons.call(null,cljs.core.select_keys.call(null,ed,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"class","class",-2030961996)], null)),figwheel.client.get_essential_messages.call(null,new cljs.core.Keyword(null,"cause","cause",231901252).cljs$core$IFn$_invoke$arity$1(ed)));
} else {
return null;
}
});
figwheel.client.error_msg_format = (function figwheel$client$error_msg_format(p__62892){
var map__62893 = p__62892;
var map__62893__$1 = ((((!((map__62893 == null)))?((((map__62893.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__62893.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__62893):map__62893);
var message = cljs.core.get.call(null,map__62893__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var class$ = cljs.core.get.call(null,map__62893__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(class$)," : ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join('');
});
figwheel.client.format_messages = cljs.core.comp.call(null,cljs.core.partial.call(null,cljs.core.map,figwheel.client.error_msg_format),figwheel.client.get_essential_messages);
figwheel.client.focus_msgs = (function figwheel$client$focus_msgs(name_set,msg_hist){
return cljs.core.cons.call(null,cljs.core.first.call(null,msg_hist),cljs.core.filter.call(null,cljs.core.comp.call(null,name_set,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863)),cljs.core.rest.call(null,msg_hist)));
});
figwheel.client.reload_file_QMARK__STAR_ = (function figwheel$client$reload_file_QMARK__STAR_(msg_name,opts){
var or__28141__auto__ = new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
return cljs.core.not_EQ_.call(null,msg_name,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356));
}
});
figwheel.client.reload_file_state_QMARK_ = (function figwheel$client$reload_file_state_QMARK_(msg_names,opts){
var and__28129__auto__ = cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563));
if(and__28129__auto__){
return figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts);
} else {
return and__28129__auto__;
}
});
figwheel.client.block_reload_file_state_QMARK_ = (function figwheel$client$block_reload_file_state_QMARK_(msg_names,opts){
return (cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))) && (cljs.core.not.call(null,figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts)));
});
figwheel.client.warning_append_state_QMARK_ = (function figwheel$client$warning_append_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.warning_state_QMARK_ = (function figwheel$client$warning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),cljs.core.first.call(null,msg_names));
});
figwheel.client.rewarning_state_QMARK_ = (function figwheel$client$rewarning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(3),msg_names));
});
figwheel.client.compile_fail_state_QMARK_ = (function figwheel$client$compile_fail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),cljs.core.first.call(null,msg_names));
});
figwheel.client.compile_refail_state_QMARK_ = (function figwheel$client$compile_refail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.css_loaded_state_QMARK_ = (function figwheel$client$css_loaded_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874),cljs.core.first.call(null,msg_names));
});
figwheel.client.file_reloader_plugin = (function figwheel$client$file_reloader_plugin(opts){
var ch = cljs.core.async.chan.call(null);
var c__47173__auto___62972 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto___62972,ch){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto___62972,ch){
return (function (state_62944){
var state_val_62945 = (state_62944[(1)]);
if((state_val_62945 === (7))){
var inst_62940 = (state_62944[(2)]);
var state_62944__$1 = state_62944;
var statearr_62946_62973 = state_62944__$1;
(statearr_62946_62973[(2)] = inst_62940);

(statearr_62946_62973[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62945 === (1))){
var state_62944__$1 = state_62944;
var statearr_62947_62974 = state_62944__$1;
(statearr_62947_62974[(2)] = null);

(statearr_62947_62974[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62945 === (4))){
var inst_62897 = (state_62944[(7)]);
var inst_62897__$1 = (state_62944[(2)]);
var state_62944__$1 = (function (){var statearr_62948 = state_62944;
(statearr_62948[(7)] = inst_62897__$1);

return statearr_62948;
})();
if(cljs.core.truth_(inst_62897__$1)){
var statearr_62949_62975 = state_62944__$1;
(statearr_62949_62975[(1)] = (5));

} else {
var statearr_62950_62976 = state_62944__$1;
(statearr_62950_62976[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62945 === (15))){
var inst_62904 = (state_62944[(8)]);
var inst_62919 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_62904);
var inst_62920 = cljs.core.first.call(null,inst_62919);
var inst_62921 = new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(inst_62920);
var inst_62922 = ["Figwheel: Not loading code with warnings - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_62921)].join('');
var inst_62923 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),inst_62922);
var state_62944__$1 = state_62944;
var statearr_62951_62977 = state_62944__$1;
(statearr_62951_62977[(2)] = inst_62923);

(statearr_62951_62977[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62945 === (13))){
var inst_62928 = (state_62944[(2)]);
var state_62944__$1 = state_62944;
var statearr_62952_62978 = state_62944__$1;
(statearr_62952_62978[(2)] = inst_62928);

(statearr_62952_62978[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62945 === (6))){
var state_62944__$1 = state_62944;
var statearr_62953_62979 = state_62944__$1;
(statearr_62953_62979[(2)] = null);

(statearr_62953_62979[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62945 === (17))){
var inst_62926 = (state_62944[(2)]);
var state_62944__$1 = state_62944;
var statearr_62954_62980 = state_62944__$1;
(statearr_62954_62980[(2)] = inst_62926);

(statearr_62954_62980[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62945 === (3))){
var inst_62942 = (state_62944[(2)]);
var state_62944__$1 = state_62944;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62944__$1,inst_62942);
} else {
if((state_val_62945 === (12))){
var inst_62903 = (state_62944[(9)]);
var inst_62917 = figwheel.client.block_reload_file_state_QMARK_.call(null,inst_62903,opts);
var state_62944__$1 = state_62944;
if(cljs.core.truth_(inst_62917)){
var statearr_62955_62981 = state_62944__$1;
(statearr_62955_62981[(1)] = (15));

} else {
var statearr_62956_62982 = state_62944__$1;
(statearr_62956_62982[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62945 === (2))){
var state_62944__$1 = state_62944;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62944__$1,(4),ch);
} else {
if((state_val_62945 === (11))){
var inst_62904 = (state_62944[(8)]);
var inst_62909 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62910 = figwheel.client.file_reloading.reload_js_files.call(null,opts,inst_62904);
var inst_62911 = cljs.core.async.timeout.call(null,(1000));
var inst_62912 = [inst_62910,inst_62911];
var inst_62913 = (new cljs.core.PersistentVector(null,2,(5),inst_62909,inst_62912,null));
var state_62944__$1 = state_62944;
return cljs.core.async.ioc_alts_BANG_.call(null,state_62944__$1,(14),inst_62913);
} else {
if((state_val_62945 === (9))){
var inst_62904 = (state_62944[(8)]);
var inst_62930 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),"Figwheel: code autoloading is OFF");
var inst_62931 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_62904);
var inst_62932 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_62931);
var inst_62933 = ["Not loading: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_62932)].join('');
var inst_62934 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),inst_62933);
var state_62944__$1 = (function (){var statearr_62957 = state_62944;
(statearr_62957[(10)] = inst_62930);

return statearr_62957;
})();
var statearr_62958_62983 = state_62944__$1;
(statearr_62958_62983[(2)] = inst_62934);

(statearr_62958_62983[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62945 === (5))){
var inst_62897 = (state_62944[(7)]);
var inst_62899 = [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null];
var inst_62900 = (new cljs.core.PersistentArrayMap(null,2,inst_62899,null));
var inst_62901 = (new cljs.core.PersistentHashSet(null,inst_62900,null));
var inst_62902 = figwheel.client.focus_msgs.call(null,inst_62901,inst_62897);
var inst_62903 = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),inst_62902);
var inst_62904 = cljs.core.first.call(null,inst_62902);
var inst_62905 = figwheel.client.autoload_QMARK_.call(null);
var state_62944__$1 = (function (){var statearr_62959 = state_62944;
(statearr_62959[(8)] = inst_62904);

(statearr_62959[(9)] = inst_62903);

return statearr_62959;
})();
if(cljs.core.truth_(inst_62905)){
var statearr_62960_62984 = state_62944__$1;
(statearr_62960_62984[(1)] = (8));

} else {
var statearr_62961_62985 = state_62944__$1;
(statearr_62961_62985[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62945 === (14))){
var inst_62915 = (state_62944[(2)]);
var state_62944__$1 = state_62944;
var statearr_62962_62986 = state_62944__$1;
(statearr_62962_62986[(2)] = inst_62915);

(statearr_62962_62986[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62945 === (16))){
var state_62944__$1 = state_62944;
var statearr_62963_62987 = state_62944__$1;
(statearr_62963_62987[(2)] = null);

(statearr_62963_62987[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62945 === (10))){
var inst_62936 = (state_62944[(2)]);
var state_62944__$1 = (function (){var statearr_62964 = state_62944;
(statearr_62964[(11)] = inst_62936);

return statearr_62964;
})();
var statearr_62965_62988 = state_62944__$1;
(statearr_62965_62988[(2)] = null);

(statearr_62965_62988[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62945 === (8))){
var inst_62903 = (state_62944[(9)]);
var inst_62907 = figwheel.client.reload_file_state_QMARK_.call(null,inst_62903,opts);
var state_62944__$1 = state_62944;
if(cljs.core.truth_(inst_62907)){
var statearr_62966_62989 = state_62944__$1;
(statearr_62966_62989[(1)] = (11));

} else {
var statearr_62967_62990 = state_62944__$1;
(statearr_62967_62990[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__47173__auto___62972,ch))
;
return ((function (switch__47085__auto__,c__47173__auto___62972,ch){
return (function() {
var figwheel$client$file_reloader_plugin_$_state_machine__47086__auto__ = null;
var figwheel$client$file_reloader_plugin_$_state_machine__47086__auto____0 = (function (){
var statearr_62968 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62968[(0)] = figwheel$client$file_reloader_plugin_$_state_machine__47086__auto__);

(statearr_62968[(1)] = (1));

return statearr_62968;
});
var figwheel$client$file_reloader_plugin_$_state_machine__47086__auto____1 = (function (state_62944){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_62944);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e62969){if((e62969 instanceof Object)){
var ex__47089__auto__ = e62969;
var statearr_62970_62991 = state_62944;
(statearr_62970_62991[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62944);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e62969;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62992 = state_62944;
state_62944 = G__62992;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
figwheel$client$file_reloader_plugin_$_state_machine__47086__auto__ = function(state_62944){
switch(arguments.length){
case 0:
return figwheel$client$file_reloader_plugin_$_state_machine__47086__auto____0.call(this);
case 1:
return figwheel$client$file_reloader_plugin_$_state_machine__47086__auto____1.call(this,state_62944);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloader_plugin_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloader_plugin_$_state_machine__47086__auto____0;
figwheel$client$file_reloader_plugin_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloader_plugin_$_state_machine__47086__auto____1;
return figwheel$client$file_reloader_plugin_$_state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto___62972,ch))
})();
var state__47175__auto__ = (function (){var statearr_62971 = f__47174__auto__.call(null);
(statearr_62971[(6)] = c__47173__auto___62972);

return statearr_62971;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto___62972,ch))
);


return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.truncate_stack_trace = (function figwheel$client$truncate_stack_trace(stack_str){
return cljs.core.take_while.call(null,(function (p1__62993_SHARP_){
return cljs.core.not.call(null,cljs.core.re_matches.call(null,/.*eval_javascript_STAR__STAR_.*/,p1__62993_SHARP_));
}),clojure.string.split_lines.call(null,stack_str));
});
figwheel.client.get_ua_product = (function figwheel$client$get_ua_product(){
if(cljs.core.truth_(figwheel.client.utils.node_env_QMARK_.call(null))){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.SAFARI)){
return new cljs.core.Keyword(null,"safari","safari",497115653);
} else {
if(cljs.core.truth_(goog.userAgent.product.CHROME)){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.FIREFOX)){
return new cljs.core.Keyword(null,"firefox","firefox",1283768880);
} else {
if(cljs.core.truth_(goog.userAgent.product.IE)){
return new cljs.core.Keyword(null,"ie","ie",2038473780);
} else {
return null;
}
}
}
}
}
});
var base_path_62995 = figwheel.client.utils.base_url_path.call(null);
figwheel.client.eval_javascript_STAR__STAR_ = ((function (base_path_62995){
return (function figwheel$client$eval_javascript_STAR__STAR_(code,opts,result_handler){
try{figwheel.client.enable_repl_print_BANG_.call(null);

var result_value = figwheel.client.utils.eval_helper.call(null,code,opts);
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"success","success",1890645906),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),result_value], null));
}catch (e62994){if((e62994 instanceof Error)){
var e = e62994;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),clojure.string.join.call(null,"\n",figwheel.client.truncate_stack_trace.call(null,e.stack)),new cljs.core.Keyword(null,"base-path","base-path",495760020),base_path_62995], null));
} else {
var e = e62994;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),"No stacktrace available."], null));

}
}finally {figwheel.client.enable_repl_print_BANG_.call(null);
}});})(base_path_62995))
;
/**
 * The REPL can disconnect and reconnect lets ensure cljs.user exists at least.
 */
figwheel.client.ensure_cljs_user = (function figwheel$client$ensure_cljs_user(){
if(cljs.core.truth_(cljs.user)){
return null;
} else {
return cljs.user = ({});
}
});
figwheel.client.repl_plugin = (function figwheel$client$repl_plugin(p__62996){
var map__62997 = p__62996;
var map__62997__$1 = ((((!((map__62997 == null)))?((((map__62997.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__62997.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__62997):map__62997);
var opts = map__62997__$1;
var build_id = cljs.core.get.call(null,map__62997__$1,new cljs.core.Keyword(null,"build-id","build-id",1642831089));
return ((function (map__62997,map__62997__$1,opts,build_id){
return (function (p__62999){
var vec__63000 = p__62999;
var seq__63001 = cljs.core.seq.call(null,vec__63000);
var first__63002 = cljs.core.first.call(null,seq__63001);
var seq__63001__$1 = cljs.core.next.call(null,seq__63001);
var map__63003 = first__63002;
var map__63003__$1 = ((((!((map__63003 == null)))?((((map__63003.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__63003.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__63003):map__63003);
var msg = map__63003__$1;
var msg_name = cljs.core.get.call(null,map__63003__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__63001__$1;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"repl-eval","repl-eval",-1784727398),msg_name)){
figwheel.client.ensure_cljs_user.call(null);

return figwheel.client.eval_javascript_STAR__STAR_.call(null,new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(msg),opts,((function (vec__63000,seq__63001,first__63002,seq__63001__$1,map__63003,map__63003__$1,msg,msg_name,_,map__62997,map__62997__$1,opts,build_id){
return (function (res){
return figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),new cljs.core.Keyword(null,"callback-name","callback-name",336964714).cljs$core$IFn$_invoke$arity$1(msg),new cljs.core.Keyword(null,"content","content",15833224),res], null));
});})(vec__63000,seq__63001,first__63002,seq__63001__$1,map__63003,map__63003__$1,msg,msg_name,_,map__62997,map__62997__$1,opts,build_id))
);
} else {
return null;
}
});
;})(map__62997,map__62997__$1,opts,build_id))
});
figwheel.client.css_reloader_plugin = (function figwheel$client$css_reloader_plugin(opts){
return (function (p__63005){
var vec__63006 = p__63005;
var seq__63007 = cljs.core.seq.call(null,vec__63006);
var first__63008 = cljs.core.first.call(null,seq__63007);
var seq__63007__$1 = cljs.core.next.call(null,seq__63007);
var map__63009 = first__63008;
var map__63009__$1 = ((((!((map__63009 == null)))?((((map__63009.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__63009.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__63009):map__63009);
var msg = map__63009__$1;
var msg_name = cljs.core.get.call(null,map__63009__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__63007__$1;
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874))){
return figwheel.client.file_reloading.reload_css_files.call(null,opts,msg);
} else {
return null;
}
});
});
figwheel.client.compile_fail_warning_plugin = (function figwheel$client$compile_fail_warning_plugin(p__63011){
var map__63012 = p__63011;
var map__63012__$1 = ((((!((map__63012 == null)))?((((map__63012.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__63012.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__63012):map__63012);
var on_compile_warning = cljs.core.get.call(null,map__63012__$1,new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947));
var on_compile_fail = cljs.core.get.call(null,map__63012__$1,new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036));
return ((function (map__63012,map__63012__$1,on_compile_warning,on_compile_fail){
return (function (p__63014){
var vec__63015 = p__63014;
var seq__63016 = cljs.core.seq.call(null,vec__63015);
var first__63017 = cljs.core.first.call(null,seq__63016);
var seq__63016__$1 = cljs.core.next.call(null,seq__63016);
var map__63018 = first__63017;
var map__63018__$1 = ((((!((map__63018 == null)))?((((map__63018.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__63018.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__63018):map__63018);
var msg = map__63018__$1;
var msg_name = cljs.core.get.call(null,map__63018__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__63016__$1;
var pred__63020 = cljs.core._EQ_;
var expr__63021 = msg_name;
if(cljs.core.truth_(pred__63020.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),expr__63021))){
return on_compile_warning.call(null,msg);
} else {
if(cljs.core.truth_(pred__63020.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),expr__63021))){
return on_compile_fail.call(null,msg);
} else {
return null;
}
}
});
;})(map__63012,map__63012__$1,on_compile_warning,on_compile_fail))
});
figwheel.client.auto_jump_to_error = (function figwheel$client$auto_jump_to_error(opts,error){
if(cljs.core.truth_(new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920).cljs$core$IFn$_invoke$arity$1(opts))){
return figwheel.client.heads_up.auto_notify_source_file_line.call(null,error);
} else {
return null;
}
});
figwheel.client.heads_up_plugin_msg_handler = (function figwheel$client$heads_up_plugin_msg_handler(opts,msg_hist_SINGLEQUOTE_){
var msg_hist = figwheel.client.focus_msgs.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null], null), null),msg_hist_SINGLEQUOTE_);
var msg_names = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),msg_hist);
var msg = cljs.core.first.call(null,msg_hist);
var c__47173__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto__,msg_hist,msg_names,msg){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto__,msg_hist,msg_names,msg){
return (function (state_63110){
var state_val_63111 = (state_63110[(1)]);
if((state_val_63111 === (7))){
var inst_63030 = (state_63110[(2)]);
var state_63110__$1 = state_63110;
if(cljs.core.truth_(inst_63030)){
var statearr_63112_63159 = state_63110__$1;
(statearr_63112_63159[(1)] = (8));

} else {
var statearr_63113_63160 = state_63110__$1;
(statearr_63113_63160[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63111 === (20))){
var inst_63104 = (state_63110[(2)]);
var state_63110__$1 = state_63110;
var statearr_63114_63161 = state_63110__$1;
(statearr_63114_63161[(2)] = inst_63104);

(statearr_63114_63161[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63111 === (27))){
var inst_63100 = (state_63110[(2)]);
var state_63110__$1 = state_63110;
var statearr_63115_63162 = state_63110__$1;
(statearr_63115_63162[(2)] = inst_63100);

(statearr_63115_63162[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63111 === (1))){
var inst_63023 = figwheel.client.reload_file_state_QMARK_.call(null,msg_names,opts);
var state_63110__$1 = state_63110;
if(cljs.core.truth_(inst_63023)){
var statearr_63116_63163 = state_63110__$1;
(statearr_63116_63163[(1)] = (2));

} else {
var statearr_63117_63164 = state_63110__$1;
(statearr_63117_63164[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63111 === (24))){
var inst_63102 = (state_63110[(2)]);
var state_63110__$1 = state_63110;
var statearr_63118_63165 = state_63110__$1;
(statearr_63118_63165[(2)] = inst_63102);

(statearr_63118_63165[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63111 === (4))){
var inst_63108 = (state_63110[(2)]);
var state_63110__$1 = state_63110;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63110__$1,inst_63108);
} else {
if((state_val_63111 === (15))){
var inst_63106 = (state_63110[(2)]);
var state_63110__$1 = state_63110;
var statearr_63119_63166 = state_63110__$1;
(statearr_63119_63166[(2)] = inst_63106);

(statearr_63119_63166[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63111 === (21))){
var inst_63059 = (state_63110[(2)]);
var inst_63060 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_63061 = figwheel.client.auto_jump_to_error.call(null,opts,inst_63060);
var state_63110__$1 = (function (){var statearr_63120 = state_63110;
(statearr_63120[(7)] = inst_63059);

return statearr_63120;
})();
var statearr_63121_63167 = state_63110__$1;
(statearr_63121_63167[(2)] = inst_63061);

(statearr_63121_63167[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63111 === (31))){
var inst_63089 = figwheel.client.css_loaded_state_QMARK_.call(null,msg_names);
var state_63110__$1 = state_63110;
if(cljs.core.truth_(inst_63089)){
var statearr_63122_63168 = state_63110__$1;
(statearr_63122_63168[(1)] = (34));

} else {
var statearr_63123_63169 = state_63110__$1;
(statearr_63123_63169[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63111 === (32))){
var inst_63098 = (state_63110[(2)]);
var state_63110__$1 = state_63110;
var statearr_63124_63170 = state_63110__$1;
(statearr_63124_63170[(2)] = inst_63098);

(statearr_63124_63170[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63111 === (33))){
var inst_63085 = (state_63110[(2)]);
var inst_63086 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_63087 = figwheel.client.auto_jump_to_error.call(null,opts,inst_63086);
var state_63110__$1 = (function (){var statearr_63125 = state_63110;
(statearr_63125[(8)] = inst_63085);

return statearr_63125;
})();
var statearr_63126_63171 = state_63110__$1;
(statearr_63126_63171[(2)] = inst_63087);

(statearr_63126_63171[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63111 === (13))){
var inst_63044 = figwheel.client.heads_up.clear.call(null);
var state_63110__$1 = state_63110;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63110__$1,(16),inst_63044);
} else {
if((state_val_63111 === (22))){
var inst_63065 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_63066 = figwheel.client.heads_up.append_warning_message.call(null,inst_63065);
var state_63110__$1 = state_63110;
var statearr_63127_63172 = state_63110__$1;
(statearr_63127_63172[(2)] = inst_63066);

(statearr_63127_63172[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63111 === (36))){
var inst_63096 = (state_63110[(2)]);
var state_63110__$1 = state_63110;
var statearr_63128_63173 = state_63110__$1;
(statearr_63128_63173[(2)] = inst_63096);

(statearr_63128_63173[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63111 === (29))){
var inst_63076 = (state_63110[(2)]);
var inst_63077 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_63078 = figwheel.client.auto_jump_to_error.call(null,opts,inst_63077);
var state_63110__$1 = (function (){var statearr_63129 = state_63110;
(statearr_63129[(9)] = inst_63076);

return statearr_63129;
})();
var statearr_63130_63174 = state_63110__$1;
(statearr_63130_63174[(2)] = inst_63078);

(statearr_63130_63174[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63111 === (6))){
var inst_63025 = (state_63110[(10)]);
var state_63110__$1 = state_63110;
var statearr_63131_63175 = state_63110__$1;
(statearr_63131_63175[(2)] = inst_63025);

(statearr_63131_63175[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63111 === (28))){
var inst_63072 = (state_63110[(2)]);
var inst_63073 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_63074 = figwheel.client.heads_up.display_warning.call(null,inst_63073);
var state_63110__$1 = (function (){var statearr_63132 = state_63110;
(statearr_63132[(11)] = inst_63072);

return statearr_63132;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63110__$1,(29),inst_63074);
} else {
if((state_val_63111 === (25))){
var inst_63070 = figwheel.client.heads_up.clear.call(null);
var state_63110__$1 = state_63110;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63110__$1,(28),inst_63070);
} else {
if((state_val_63111 === (34))){
var inst_63091 = figwheel.client.heads_up.flash_loaded.call(null);
var state_63110__$1 = state_63110;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63110__$1,(37),inst_63091);
} else {
if((state_val_63111 === (17))){
var inst_63050 = (state_63110[(2)]);
var inst_63051 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_63052 = figwheel.client.auto_jump_to_error.call(null,opts,inst_63051);
var state_63110__$1 = (function (){var statearr_63133 = state_63110;
(statearr_63133[(12)] = inst_63050);

return statearr_63133;
})();
var statearr_63134_63176 = state_63110__$1;
(statearr_63134_63176[(2)] = inst_63052);

(statearr_63134_63176[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63111 === (3))){
var inst_63042 = figwheel.client.compile_refail_state_QMARK_.call(null,msg_names);
var state_63110__$1 = state_63110;
if(cljs.core.truth_(inst_63042)){
var statearr_63135_63177 = state_63110__$1;
(statearr_63135_63177[(1)] = (13));

} else {
var statearr_63136_63178 = state_63110__$1;
(statearr_63136_63178[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63111 === (12))){
var inst_63038 = (state_63110[(2)]);
var state_63110__$1 = state_63110;
var statearr_63137_63179 = state_63110__$1;
(statearr_63137_63179[(2)] = inst_63038);

(statearr_63137_63179[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63111 === (2))){
var inst_63025 = (state_63110[(10)]);
var inst_63025__$1 = figwheel.client.autoload_QMARK_.call(null);
var state_63110__$1 = (function (){var statearr_63138 = state_63110;
(statearr_63138[(10)] = inst_63025__$1);

return statearr_63138;
})();
if(cljs.core.truth_(inst_63025__$1)){
var statearr_63139_63180 = state_63110__$1;
(statearr_63139_63180[(1)] = (5));

} else {
var statearr_63140_63181 = state_63110__$1;
(statearr_63140_63181[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63111 === (23))){
var inst_63068 = figwheel.client.rewarning_state_QMARK_.call(null,msg_names);
var state_63110__$1 = state_63110;
if(cljs.core.truth_(inst_63068)){
var statearr_63141_63182 = state_63110__$1;
(statearr_63141_63182[(1)] = (25));

} else {
var statearr_63142_63183 = state_63110__$1;
(statearr_63142_63183[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63111 === (35))){
var state_63110__$1 = state_63110;
var statearr_63143_63184 = state_63110__$1;
(statearr_63143_63184[(2)] = null);

(statearr_63143_63184[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63111 === (19))){
var inst_63063 = figwheel.client.warning_append_state_QMARK_.call(null,msg_names);
var state_63110__$1 = state_63110;
if(cljs.core.truth_(inst_63063)){
var statearr_63144_63185 = state_63110__$1;
(statearr_63144_63185[(1)] = (22));

} else {
var statearr_63145_63186 = state_63110__$1;
(statearr_63145_63186[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63111 === (11))){
var inst_63034 = (state_63110[(2)]);
var state_63110__$1 = state_63110;
var statearr_63146_63187 = state_63110__$1;
(statearr_63146_63187[(2)] = inst_63034);

(statearr_63146_63187[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63111 === (9))){
var inst_63036 = figwheel.client.heads_up.clear.call(null);
var state_63110__$1 = state_63110;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63110__$1,(12),inst_63036);
} else {
if((state_val_63111 === (5))){
var inst_63027 = new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(opts);
var state_63110__$1 = state_63110;
var statearr_63147_63188 = state_63110__$1;
(statearr_63147_63188[(2)] = inst_63027);

(statearr_63147_63188[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63111 === (14))){
var inst_63054 = figwheel.client.compile_fail_state_QMARK_.call(null,msg_names);
var state_63110__$1 = state_63110;
if(cljs.core.truth_(inst_63054)){
var statearr_63148_63189 = state_63110__$1;
(statearr_63148_63189[(1)] = (18));

} else {
var statearr_63149_63190 = state_63110__$1;
(statearr_63149_63190[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63111 === (26))){
var inst_63080 = figwheel.client.warning_state_QMARK_.call(null,msg_names);
var state_63110__$1 = state_63110;
if(cljs.core.truth_(inst_63080)){
var statearr_63150_63191 = state_63110__$1;
(statearr_63150_63191[(1)] = (30));

} else {
var statearr_63151_63192 = state_63110__$1;
(statearr_63151_63192[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63111 === (16))){
var inst_63046 = (state_63110[(2)]);
var inst_63047 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_63048 = figwheel.client.heads_up.display_exception.call(null,inst_63047);
var state_63110__$1 = (function (){var statearr_63152 = state_63110;
(statearr_63152[(13)] = inst_63046);

return statearr_63152;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63110__$1,(17),inst_63048);
} else {
if((state_val_63111 === (30))){
var inst_63082 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_63083 = figwheel.client.heads_up.display_warning.call(null,inst_63082);
var state_63110__$1 = state_63110;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63110__$1,(33),inst_63083);
} else {
if((state_val_63111 === (10))){
var inst_63040 = (state_63110[(2)]);
var state_63110__$1 = state_63110;
var statearr_63153_63193 = state_63110__$1;
(statearr_63153_63193[(2)] = inst_63040);

(statearr_63153_63193[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63111 === (18))){
var inst_63056 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_63057 = figwheel.client.heads_up.display_exception.call(null,inst_63056);
var state_63110__$1 = state_63110;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63110__$1,(21),inst_63057);
} else {
if((state_val_63111 === (37))){
var inst_63093 = (state_63110[(2)]);
var state_63110__$1 = state_63110;
var statearr_63154_63194 = state_63110__$1;
(statearr_63154_63194[(2)] = inst_63093);

(statearr_63154_63194[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63111 === (8))){
var inst_63032 = figwheel.client.heads_up.flash_loaded.call(null);
var state_63110__$1 = state_63110;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63110__$1,(11),inst_63032);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__47173__auto__,msg_hist,msg_names,msg))
;
return ((function (switch__47085__auto__,c__47173__auto__,msg_hist,msg_names,msg){
return (function() {
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__47086__auto__ = null;
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__47086__auto____0 = (function (){
var statearr_63155 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63155[(0)] = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__47086__auto__);

(statearr_63155[(1)] = (1));

return statearr_63155;
});
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__47086__auto____1 = (function (state_63110){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_63110);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e63156){if((e63156 instanceof Object)){
var ex__47089__auto__ = e63156;
var statearr_63157_63195 = state_63110;
(statearr_63157_63195[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_63110);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e63156;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63196 = state_63110;
state_63110 = G__63196;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__47086__auto__ = function(state_63110){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__47086__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__47086__auto____1.call(this,state_63110);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__47086__auto____0;
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__47086__auto____1;
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto__,msg_hist,msg_names,msg))
})();
var state__47175__auto__ = (function (){var statearr_63158 = f__47174__auto__.call(null);
(statearr_63158[(6)] = c__47173__auto__);

return statearr_63158;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto__,msg_hist,msg_names,msg))
);

return c__47173__auto__;
});
figwheel.client.heads_up_plugin = (function figwheel$client$heads_up_plugin(opts){
var ch = cljs.core.async.chan.call(null);
figwheel.client.heads_up_config_options_STAR__STAR_ = opts;

var c__47173__auto___63225 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto___63225,ch){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto___63225,ch){
return (function (state_63211){
var state_val_63212 = (state_63211[(1)]);
if((state_val_63212 === (1))){
var state_63211__$1 = state_63211;
var statearr_63213_63226 = state_63211__$1;
(statearr_63213_63226[(2)] = null);

(statearr_63213_63226[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63212 === (2))){
var state_63211__$1 = state_63211;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63211__$1,(4),ch);
} else {
if((state_val_63212 === (3))){
var inst_63209 = (state_63211[(2)]);
var state_63211__$1 = state_63211;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63211__$1,inst_63209);
} else {
if((state_val_63212 === (4))){
var inst_63199 = (state_63211[(7)]);
var inst_63199__$1 = (state_63211[(2)]);
var state_63211__$1 = (function (){var statearr_63214 = state_63211;
(statearr_63214[(7)] = inst_63199__$1);

return statearr_63214;
})();
if(cljs.core.truth_(inst_63199__$1)){
var statearr_63215_63227 = state_63211__$1;
(statearr_63215_63227[(1)] = (5));

} else {
var statearr_63216_63228 = state_63211__$1;
(statearr_63216_63228[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63212 === (5))){
var inst_63199 = (state_63211[(7)]);
var inst_63201 = figwheel.client.heads_up_plugin_msg_handler.call(null,opts,inst_63199);
var state_63211__$1 = state_63211;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63211__$1,(8),inst_63201);
} else {
if((state_val_63212 === (6))){
var state_63211__$1 = state_63211;
var statearr_63217_63229 = state_63211__$1;
(statearr_63217_63229[(2)] = null);

(statearr_63217_63229[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63212 === (7))){
var inst_63207 = (state_63211[(2)]);
var state_63211__$1 = state_63211;
var statearr_63218_63230 = state_63211__$1;
(statearr_63218_63230[(2)] = inst_63207);

(statearr_63218_63230[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63212 === (8))){
var inst_63203 = (state_63211[(2)]);
var state_63211__$1 = (function (){var statearr_63219 = state_63211;
(statearr_63219[(8)] = inst_63203);

return statearr_63219;
})();
var statearr_63220_63231 = state_63211__$1;
(statearr_63220_63231[(2)] = null);

(statearr_63220_63231[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__47173__auto___63225,ch))
;
return ((function (switch__47085__auto__,c__47173__auto___63225,ch){
return (function() {
var figwheel$client$heads_up_plugin_$_state_machine__47086__auto__ = null;
var figwheel$client$heads_up_plugin_$_state_machine__47086__auto____0 = (function (){
var statearr_63221 = [null,null,null,null,null,null,null,null,null];
(statearr_63221[(0)] = figwheel$client$heads_up_plugin_$_state_machine__47086__auto__);

(statearr_63221[(1)] = (1));

return statearr_63221;
});
var figwheel$client$heads_up_plugin_$_state_machine__47086__auto____1 = (function (state_63211){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_63211);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e63222){if((e63222 instanceof Object)){
var ex__47089__auto__ = e63222;
var statearr_63223_63232 = state_63211;
(statearr_63223_63232[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_63211);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e63222;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63233 = state_63211;
state_63211 = G__63233;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_$_state_machine__47086__auto__ = function(state_63211){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_$_state_machine__47086__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_$_state_machine__47086__auto____1.call(this,state_63211);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$heads_up_plugin_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_$_state_machine__47086__auto____0;
figwheel$client$heads_up_plugin_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_$_state_machine__47086__auto____1;
return figwheel$client$heads_up_plugin_$_state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto___63225,ch))
})();
var state__47175__auto__ = (function (){var statearr_63224 = f__47174__auto__.call(null);
(statearr_63224[(6)] = c__47173__auto___63225);

return statearr_63224;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto___63225,ch))
);


figwheel.client.heads_up.ensure_container.call(null);

return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.enforce_project_plugin = (function figwheel$client$enforce_project_plugin(opts){
return (function (msg_hist){
if(((1) < cljs.core.count.call(null,cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"project-id","project-id",206449307),cljs.core.take.call(null,(5),msg_hist)))))){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different project. Shutting socket down.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__47173__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto__){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto__){
return (function (state_63239){
var state_val_63240 = (state_63239[(1)]);
if((state_val_63240 === (1))){
var inst_63234 = cljs.core.async.timeout.call(null,(3000));
var state_63239__$1 = state_63239;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63239__$1,(2),inst_63234);
} else {
if((state_val_63240 === (2))){
var inst_63236 = (state_63239[(2)]);
var inst_63237 = figwheel.client.heads_up.display_system_warning.call(null,"Connection from different project","Shutting connection down!!!!!");
var state_63239__$1 = (function (){var statearr_63241 = state_63239;
(statearr_63241[(7)] = inst_63236);

return statearr_63241;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63239__$1,inst_63237);
} else {
return null;
}
}
});})(c__47173__auto__))
;
return ((function (switch__47085__auto__,c__47173__auto__){
return (function() {
var figwheel$client$enforce_project_plugin_$_state_machine__47086__auto__ = null;
var figwheel$client$enforce_project_plugin_$_state_machine__47086__auto____0 = (function (){
var statearr_63242 = [null,null,null,null,null,null,null,null];
(statearr_63242[(0)] = figwheel$client$enforce_project_plugin_$_state_machine__47086__auto__);

(statearr_63242[(1)] = (1));

return statearr_63242;
});
var figwheel$client$enforce_project_plugin_$_state_machine__47086__auto____1 = (function (state_63239){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_63239);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e63243){if((e63243 instanceof Object)){
var ex__47089__auto__ = e63243;
var statearr_63244_63246 = state_63239;
(statearr_63244_63246[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_63239);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e63243;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63247 = state_63239;
state_63239 = G__63247;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
figwheel$client$enforce_project_plugin_$_state_machine__47086__auto__ = function(state_63239){
switch(arguments.length){
case 0:
return figwheel$client$enforce_project_plugin_$_state_machine__47086__auto____0.call(this);
case 1:
return figwheel$client$enforce_project_plugin_$_state_machine__47086__auto____1.call(this,state_63239);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$enforce_project_plugin_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_project_plugin_$_state_machine__47086__auto____0;
figwheel$client$enforce_project_plugin_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_project_plugin_$_state_machine__47086__auto____1;
return figwheel$client$enforce_project_plugin_$_state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto__))
})();
var state__47175__auto__ = (function (){var statearr_63245 = f__47174__auto__.call(null);
(statearr_63245[(6)] = c__47173__auto__);

return statearr_63245;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto__))
);

return c__47173__auto__;
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.enforce_figwheel_version_plugin = (function figwheel$client$enforce_figwheel_version_plugin(opts){
return (function (msg_hist){
var temp__4657__auto__ = new cljs.core.Keyword(null,"figwheel-version","figwheel-version",1409553832).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,msg_hist));
if(cljs.core.truth_(temp__4657__auto__)){
var figwheel_version = temp__4657__auto__;
if(cljs.core.not_EQ_.call(null,figwheel_version,figwheel.client._figwheel_version_)){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different version of Figwheel.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__47173__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto__,figwheel_version,temp__4657__auto__){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto__,figwheel_version,temp__4657__auto__){
return (function (state_63254){
var state_val_63255 = (state_63254[(1)]);
if((state_val_63255 === (1))){
var inst_63248 = cljs.core.async.timeout.call(null,(2000));
var state_63254__$1 = state_63254;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63254__$1,(2),inst_63248);
} else {
if((state_val_63255 === (2))){
var inst_63250 = (state_63254[(2)]);
var inst_63251 = ["Figwheel Client Version <strong>",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client._figwheel_version_),"</strong> is not equal to ","Figwheel Sidecar Version <strong>",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel_version),"</strong>",".  Shutting down Websocket Connection!","<h4>To fix try:</h4>","<ol><li>Reload this page and make sure you are not getting a cached version of the client.</li>","<li>You may have to clean (delete compiled assets) and rebuild to make sure that the new client code is being used.</li>","<li>Also, make sure you have consistent Figwheel dependencies.</li></ol>"].join('');
var inst_63252 = figwheel.client.heads_up.display_system_warning.call(null,"Figwheel Client and Server have different versions!!",inst_63251);
var state_63254__$1 = (function (){var statearr_63256 = state_63254;
(statearr_63256[(7)] = inst_63250);

return statearr_63256;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63254__$1,inst_63252);
} else {
return null;
}
}
});})(c__47173__auto__,figwheel_version,temp__4657__auto__))
;
return ((function (switch__47085__auto__,c__47173__auto__,figwheel_version,temp__4657__auto__){
return (function() {
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__47086__auto__ = null;
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__47086__auto____0 = (function (){
var statearr_63257 = [null,null,null,null,null,null,null,null];
(statearr_63257[(0)] = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__47086__auto__);

(statearr_63257[(1)] = (1));

return statearr_63257;
});
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__47086__auto____1 = (function (state_63254){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_63254);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e63258){if((e63258 instanceof Object)){
var ex__47089__auto__ = e63258;
var statearr_63259_63261 = state_63254;
(statearr_63259_63261[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_63254);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e63258;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63262 = state_63254;
state_63254 = G__63262;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__47086__auto__ = function(state_63254){
switch(arguments.length){
case 0:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__47086__auto____0.call(this);
case 1:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__47086__auto____1.call(this,state_63254);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__47086__auto____0;
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__47086__auto____1;
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto__,figwheel_version,temp__4657__auto__))
})();
var state__47175__auto__ = (function (){var statearr_63260 = f__47174__auto__.call(null);
(statearr_63260[(6)] = c__47173__auto__);

return statearr_63260;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto__,figwheel_version,temp__4657__auto__))
);

return c__47173__auto__;
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.default_on_jsload = cljs.core.identity;
figwheel.client.file_line_column = (function figwheel$client$file_line_column(p__63263){
var map__63264 = p__63263;
var map__63264__$1 = ((((!((map__63264 == null)))?((((map__63264.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__63264.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__63264):map__63264);
var file = cljs.core.get.call(null,map__63264__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var line = cljs.core.get.call(null,map__63264__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column = cljs.core.get.call(null,map__63264__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var G__63266 = "";
var G__63266__$1 = (cljs.core.truth_(file)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__63266),"file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''):G__63266);
var G__63266__$2 = (cljs.core.truth_(line)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__63266__$1)," at line ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line)].join(''):G__63266__$1);
if(cljs.core.truth_((function (){var and__28129__auto__ = line;
if(cljs.core.truth_(and__28129__auto__)){
return column;
} else {
return and__28129__auto__;
}
})())){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__63266__$2),", column ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column)].join('');
} else {
return G__63266__$2;
}
});
figwheel.client.default_on_compile_fail = (function figwheel$client$default_on_compile_fail(p__63267){
var map__63268 = p__63267;
var map__63268__$1 = ((((!((map__63268 == null)))?((((map__63268.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__63268.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__63268):map__63268);
var ed = map__63268__$1;
var formatted_exception = cljs.core.get.call(null,map__63268__$1,new cljs.core.Keyword(null,"formatted-exception","formatted-exception",-116489026));
var exception_data = cljs.core.get.call(null,map__63268__$1,new cljs.core.Keyword(null,"exception-data","exception-data",-512474886));
var cause = cljs.core.get.call(null,map__63268__$1,new cljs.core.Keyword(null,"cause","cause",231901252));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: Compile Exception");

var seq__63270_63274 = cljs.core.seq.call(null,figwheel.client.format_messages.call(null,exception_data));
var chunk__63271_63275 = null;
var count__63272_63276 = (0);
var i__63273_63277 = (0);
while(true){
if((i__63273_63277 < count__63272_63276)){
var msg_63278 = cljs.core._nth.call(null,chunk__63271_63275,i__63273_63277);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_63278);

var G__63279 = seq__63270_63274;
var G__63280 = chunk__63271_63275;
var G__63281 = count__63272_63276;
var G__63282 = (i__63273_63277 + (1));
seq__63270_63274 = G__63279;
chunk__63271_63275 = G__63280;
count__63272_63276 = G__63281;
i__63273_63277 = G__63282;
continue;
} else {
var temp__4657__auto___63283 = cljs.core.seq.call(null,seq__63270_63274);
if(temp__4657__auto___63283){
var seq__63270_63284__$1 = temp__4657__auto___63283;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__63270_63284__$1)){
var c__28980__auto___63285 = cljs.core.chunk_first.call(null,seq__63270_63284__$1);
var G__63286 = cljs.core.chunk_rest.call(null,seq__63270_63284__$1);
var G__63287 = c__28980__auto___63285;
var G__63288 = cljs.core.count.call(null,c__28980__auto___63285);
var G__63289 = (0);
seq__63270_63274 = G__63286;
chunk__63271_63275 = G__63287;
count__63272_63276 = G__63288;
i__63273_63277 = G__63289;
continue;
} else {
var msg_63290 = cljs.core.first.call(null,seq__63270_63284__$1);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_63290);

var G__63291 = cljs.core.next.call(null,seq__63270_63284__$1);
var G__63292 = null;
var G__63293 = (0);
var G__63294 = (0);
seq__63270_63274 = G__63291;
chunk__63271_63275 = G__63292;
count__63272_63276 = G__63293;
i__63273_63277 = G__63294;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(cause)){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),["Error on ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_line_column.call(null,ed))].join(''));
} else {
}

return ed;
});
figwheel.client.default_on_compile_warning = (function figwheel$client$default_on_compile_warning(p__63295){
var map__63296 = p__63295;
var map__63296__$1 = ((((!((map__63296 == null)))?((((map__63296.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__63296.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__63296):map__63296);
var w = map__63296__$1;
var message = cljs.core.get.call(null,map__63296__$1,new cljs.core.Keyword(null,"message","message",-406056002));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),["Figwheel: Compile Warning - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(message))," in ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_line_column.call(null,message))].join(''));

return w;
});
figwheel.client.default_before_load = (function figwheel$client$default_before_load(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: notified of file changes");

return files;
});
figwheel.client.default_on_cssload = (function figwheel$client$default_on_cssload(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded CSS files");

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),cljs.core.pr_str.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files)));

return files;
});
if(typeof figwheel.client.config_defaults !== 'undefined'){
} else {
figwheel.client.config_defaults = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947),new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430),new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036),new cljs.core.Keyword(null,"debug","debug",-1608172596),new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202),new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938),new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920),new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128),new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223),new cljs.core.Keyword(null,"eval-fn","eval-fn",-1111644294),new cljs.core.Keyword(null,"retry-count","retry-count",1936122875),new cljs.core.Keyword(null,"autoload","autoload",-354122500),new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318)],[new cljs.core.Var(function(){return figwheel.client.default_on_compile_warning;},new cljs.core.Symbol("figwheel.client","default-on-compile-warning","figwheel.client/default-on-compile-warning",584144208,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-warning","default-on-compile-warning",-18911586,null),"resources/public/js/compiled/test/out/figwheel/client.cljs",33,1,363,363,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"message","message",1234475525,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"w","w",1994700528,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_warning)?figwheel.client.default_on_compile_warning.cljs$lang$test:null)])),figwheel.client.default_on_jsload,true,new cljs.core.Var(function(){return figwheel.client.default_on_compile_fail;},new cljs.core.Symbol("figwheel.client","default-on-compile-fail","figwheel.client/default-on-compile-fail",1384826337,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-fail","default-on-compile-fail",-158814813,null),"resources/public/js/compiled/test/out/figwheel/client.cljs",30,1,355,355,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"formatted-exception","formatted-exception",1524042501,null),new cljs.core.Symbol(null,"exception-data","exception-data",1128056641,null),new cljs.core.Symbol(null,"cause","cause",1872432779,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"ed","ed",2076825751,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_fail)?figwheel.client.default_on_compile_fail.cljs$lang$test:null)])),false,true,["ws://",cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))?location.host:"localhost:3449")),"/figwheel-ws"].join(''),false,figwheel.client.default_before_load,false,false,(100),true,figwheel.client.default_on_cssload]);
}
figwheel.client.handle_deprecated_jsload_callback = (function figwheel$client$handle_deprecated_jsload_callback(config){
if(cljs.core.truth_(new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config))){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,config,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config)),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369));
} else {
return config;
}
});
figwheel.client.fill_url_template = (function figwheel$client$fill_url_template(config){
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
return cljs.core.update_in.call(null,config,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938)], null),(function (x){
return clojure.string.replace.call(null,clojure.string.replace.call(null,x,"[[client-hostname]]",location.hostname),"[[client-port]]",location.port);
}));
} else {
return config;
}
});
figwheel.client.base_plugins = (function figwheel$client$base_plugins(system_options){
var base = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"enforce-project-plugin","enforce-project-plugin",959402899),figwheel.client.enforce_project_plugin,new cljs.core.Keyword(null,"enforce-figwheel-version-plugin","enforce-figwheel-version-plugin",-1916185220),figwheel.client.enforce_figwheel_version_plugin,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),figwheel.client.file_reloader_plugin,new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),figwheel.client.compile_fail_warning_plugin,new cljs.core.Keyword(null,"css-reloader-plugin","css-reloader-plugin",2002032904),figwheel.client.css_reloader_plugin,new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371),figwheel.client.repl_plugin], null);
var base__$1 = ((cljs.core.not.call(null,figwheel.client.utils.html_env_QMARK_.call(null)))?cljs.core.select_keys.call(null,base,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371)], null)):base);
var base__$2 = ((new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(system_options) === false)?cljs.core.dissoc.call(null,base__$1,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733)):base__$1);
if(cljs.core.truth_((function (){var and__28129__auto__ = new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(system_options);
if(cljs.core.truth_(and__28129__auto__)){
return figwheel.client.utils.html_env_QMARK_.call(null);
} else {
return and__28129__auto__;
}
})())){
return cljs.core.assoc.call(null,base__$2,new cljs.core.Keyword(null,"heads-up-display-plugin","heads-up-display-plugin",1745207501),figwheel.client.heads_up_plugin);
} else {
return base__$2;
}
});
figwheel.client.add_message_watch = (function figwheel$client$add_message_watch(key,callback){
return cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,key,(function (_,___$1,___$2,msg_hist){
return callback.call(null,cljs.core.first.call(null,msg_hist));
}));
});
figwheel.client.add_plugins = (function figwheel$client$add_plugins(plugins,system_options){
var seq__63298 = cljs.core.seq.call(null,plugins);
var chunk__63299 = null;
var count__63300 = (0);
var i__63301 = (0);
while(true){
if((i__63301 < count__63300)){
var vec__63302 = cljs.core._nth.call(null,chunk__63299,i__63301);
var k = cljs.core.nth.call(null,vec__63302,(0),null);
var plugin = cljs.core.nth.call(null,vec__63302,(1),null);
if(cljs.core.truth_(plugin)){
var pl_63308 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__63298,chunk__63299,count__63300,i__63301,pl_63308,vec__63302,k,plugin){
return (function (_,___$1,___$2,msg_hist){
return pl_63308.call(null,msg_hist);
});})(seq__63298,chunk__63299,count__63300,i__63301,pl_63308,vec__63302,k,plugin))
);
} else {
}

var G__63309 = seq__63298;
var G__63310 = chunk__63299;
var G__63311 = count__63300;
var G__63312 = (i__63301 + (1));
seq__63298 = G__63309;
chunk__63299 = G__63310;
count__63300 = G__63311;
i__63301 = G__63312;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__63298);
if(temp__4657__auto__){
var seq__63298__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__63298__$1)){
var c__28980__auto__ = cljs.core.chunk_first.call(null,seq__63298__$1);
var G__63313 = cljs.core.chunk_rest.call(null,seq__63298__$1);
var G__63314 = c__28980__auto__;
var G__63315 = cljs.core.count.call(null,c__28980__auto__);
var G__63316 = (0);
seq__63298 = G__63313;
chunk__63299 = G__63314;
count__63300 = G__63315;
i__63301 = G__63316;
continue;
} else {
var vec__63305 = cljs.core.first.call(null,seq__63298__$1);
var k = cljs.core.nth.call(null,vec__63305,(0),null);
var plugin = cljs.core.nth.call(null,vec__63305,(1),null);
if(cljs.core.truth_(plugin)){
var pl_63317 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__63298,chunk__63299,count__63300,i__63301,pl_63317,vec__63305,k,plugin,seq__63298__$1,temp__4657__auto__){
return (function (_,___$1,___$2,msg_hist){
return pl_63317.call(null,msg_hist);
});})(seq__63298,chunk__63299,count__63300,i__63301,pl_63317,vec__63305,k,plugin,seq__63298__$1,temp__4657__auto__))
);
} else {
}

var G__63318 = cljs.core.next.call(null,seq__63298__$1);
var G__63319 = null;
var G__63320 = (0);
var G__63321 = (0);
seq__63298 = G__63318;
chunk__63299 = G__63319;
count__63300 = G__63320;
i__63301 = G__63321;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.start = (function figwheel$client$start(var_args){
var G__63323 = arguments.length;
switch (G__63323) {
case 1:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 0:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$0();

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$1 = (function (opts){
if((goog.dependencies_ == null)){
return null;
} else {
if(typeof figwheel.client.__figwheel_start_once__ !== 'undefined'){
return null;
} else {
return (
figwheel.client.__figwheel_start_once__ = setTimeout((function (){
var plugins_SINGLEQUOTE_ = new cljs.core.Keyword(null,"plugins","plugins",1900073717).cljs$core$IFn$_invoke$arity$1(opts);
var merge_plugins = new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370).cljs$core$IFn$_invoke$arity$1(opts);
var system_options = figwheel.client.fill_url_template.call(null,figwheel.client.handle_deprecated_jsload_callback.call(null,cljs.core.merge.call(null,figwheel.client.config_defaults,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"plugins","plugins",1900073717),new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370)))));
var plugins = (cljs.core.truth_(plugins_SINGLEQUOTE_)?plugins_SINGLEQUOTE_:cljs.core.merge.call(null,figwheel.client.base_plugins.call(null,system_options),merge_plugins));
figwheel.client.utils._STAR_print_debug_STAR_ = new cljs.core.Keyword(null,"debug","debug",-1608172596).cljs$core$IFn$_invoke$arity$1(opts);

figwheel.client.enable_repl_print_BANG_.call(null);

figwheel.client.add_plugins.call(null,plugins,system_options);

figwheel.client.file_reloading.patch_goog_base.call(null);

var seq__63324_63329 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"initial-messages","initial-messages",2057377771).cljs$core$IFn$_invoke$arity$1(system_options));
var chunk__63325_63330 = null;
var count__63326_63331 = (0);
var i__63327_63332 = (0);
while(true){
if((i__63327_63332 < count__63326_63331)){
var msg_63333 = cljs.core._nth.call(null,chunk__63325_63330,i__63327_63332);
figwheel.client.socket.handle_incoming_message.call(null,msg_63333);

var G__63334 = seq__63324_63329;
var G__63335 = chunk__63325_63330;
var G__63336 = count__63326_63331;
var G__63337 = (i__63327_63332 + (1));
seq__63324_63329 = G__63334;
chunk__63325_63330 = G__63335;
count__63326_63331 = G__63336;
i__63327_63332 = G__63337;
continue;
} else {
var temp__4657__auto___63338 = cljs.core.seq.call(null,seq__63324_63329);
if(temp__4657__auto___63338){
var seq__63324_63339__$1 = temp__4657__auto___63338;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__63324_63339__$1)){
var c__28980__auto___63340 = cljs.core.chunk_first.call(null,seq__63324_63339__$1);
var G__63341 = cljs.core.chunk_rest.call(null,seq__63324_63339__$1);
var G__63342 = c__28980__auto___63340;
var G__63343 = cljs.core.count.call(null,c__28980__auto___63340);
var G__63344 = (0);
seq__63324_63329 = G__63341;
chunk__63325_63330 = G__63342;
count__63326_63331 = G__63343;
i__63327_63332 = G__63344;
continue;
} else {
var msg_63345 = cljs.core.first.call(null,seq__63324_63339__$1);
figwheel.client.socket.handle_incoming_message.call(null,msg_63345);

var G__63346 = cljs.core.next.call(null,seq__63324_63339__$1);
var G__63347 = null;
var G__63348 = (0);
var G__63349 = (0);
seq__63324_63329 = G__63346;
chunk__63325_63330 = G__63347;
count__63326_63331 = G__63348;
i__63327_63332 = G__63349;
continue;
}
} else {
}
}
break;
}

return figwheel.client.socket.open.call(null,system_options);
})))
;
}
}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$0 = (function (){
return figwheel.client.start.call(null,cljs.core.PersistentArrayMap.EMPTY);
});

figwheel.client.start.cljs$lang$maxFixedArity = 1;

figwheel.client.watch_and_reload_with_opts = figwheel.client.start;
figwheel.client.watch_and_reload = (function figwheel$client$watch_and_reload(var_args){
var args__29319__auto__ = [];
var len__29312__auto___63354 = arguments.length;
var i__29313__auto___63355 = (0);
while(true){
if((i__29313__auto___63355 < len__29312__auto___63354)){
args__29319__auto__.push((arguments[i__29313__auto___63355]));

var G__63356 = (i__29313__auto___63355 + (1));
i__29313__auto___63355 = G__63356;
continue;
} else {
}
break;
}

var argseq__29320__auto__ = ((((0) < args__29319__auto__.length))?(new cljs.core.IndexedSeq(args__29319__auto__.slice((0)),(0),null)):null);
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(argseq__29320__auto__);
});

figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic = (function (p__63351){
var map__63352 = p__63351;
var map__63352__$1 = ((((!((map__63352 == null)))?((((map__63352.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__63352.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__63352):map__63352);
var opts = map__63352__$1;
return figwheel.client.start.call(null,opts);
});

figwheel.client.watch_and_reload.cljs$lang$maxFixedArity = (0);

figwheel.client.watch_and_reload.cljs$lang$applyTo = (function (seq63350){
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq63350));
});

figwheel.client.fetch_data_from_env = (function figwheel$client$fetch_data_from_env(){
try{return cljs.reader.read_string.call(null,goog.object.get(window,"FIGWHEEL_CLIENT_CONFIGURATION"));
}catch (e63357){if((e63357 instanceof Error)){
var e = e63357;
cljs.core._STAR_print_err_fn_STAR_.call(null,"Unable to load FIGWHEEL_CLIENT_CONFIGURATION from the environment");

return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"autoload","autoload",-354122500),false], null);
} else {
throw e63357;

}
}});
figwheel.client.console_intro_message = "Figwheel has compiled a temporary helper application to your :output-file.\n\nThe code currently in your configured output file does not\nrepresent the code that you are trying to compile.\n\nThis temporary application is intended to help you continue to get\nfeedback from Figwheel until the build you are working on compiles\ncorrectly.\n\nWhen your ClojureScript source code compiles correctly this helper\napplication will auto-reload and pick up your freshly compiled\nClojureScript program.";
figwheel.client.bad_compile_helper_app = (function figwheel$client$bad_compile_helper_app(){
cljs.core.enable_console_print_BANG_.call(null);

var config = figwheel.client.fetch_data_from_env.call(null);
cljs.core.println.call(null,figwheel.client.console_intro_message);

figwheel.client.heads_up.bad_compile_screen.call(null);

if(cljs.core.truth_(goog.dependencies_)){
} else {
goog.dependencies_ = true;
}

figwheel.client.start.call(null,config);

return figwheel.client.add_message_watch.call(null,new cljs.core.Keyword(null,"listen-for-successful-compile","listen-for-successful-compile",-995277603),((function (config){
return (function (p__63358){
var map__63359 = p__63358;
var map__63359__$1 = ((((!((map__63359 == null)))?((((map__63359.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__63359.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__63359):map__63359);
var msg_name = cljs.core.get.call(null,map__63359__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))){
return location.href = location.href;
} else {
return null;
}
});})(config))
);
});

//# sourceMappingURL=client.js.map?rel=1511404508638
