// Compiled by ClojureScript 1.9.946 {}
goog.provide('devtools.formatters.budgeting');
goog.require('cljs.core');
goog.require('devtools.formatters.templating');
goog.require('devtools.formatters.state');
goog.require('devtools.formatters.helpers');
goog.require('devtools.formatters.markup');
devtools.formatters.budgeting.header_expander_depth_cost = (2);
devtools.formatters.budgeting.over_budget_values = ((typeof WeakSet !== 'undefined')?(new WeakSet()):cljs.core.volatile_BANG_.call(null,cljs.core.PersistentHashSet.EMPTY));
devtools.formatters.budgeting.add_over_budget_value_BANG_ = (function devtools$formatters$budgeting$add_over_budget_value_BANG_(value){
if(cljs.core.volatile_QMARK_.call(null,devtools.formatters.budgeting.over_budget_values)){
return cljs.core.vreset_BANG_.call(null,devtools.formatters.budgeting.over_budget_values,cljs.core.conj.call(null,cljs.core.deref.call(null,devtools.formatters.budgeting.over_budget_values),value));
} else {
var o__63766__auto__ = devtools.formatters.budgeting.over_budget_values;
return (o__63766__auto__["add"]).call(o__63766__auto__,value);
}
});
devtools.formatters.budgeting.delete_over_budget_value_BANG_ = (function devtools$formatters$budgeting$delete_over_budget_value_BANG_(value){
if(cljs.core.volatile_QMARK_.call(null,devtools.formatters.budgeting.over_budget_values)){
return cljs.core.vreset_BANG_.call(null,devtools.formatters.budgeting.over_budget_values,cljs.core.disj.call(null,cljs.core.deref.call(null,devtools.formatters.budgeting.over_budget_values),value));
} else {
var o__63766__auto__ = devtools.formatters.budgeting.over_budget_values;
return (o__63766__auto__["delete"]).call(o__63766__auto__,value);
}
});
devtools.formatters.budgeting.has_over_budget_value_QMARK_ = (function devtools$formatters$budgeting$has_over_budget_value_QMARK_(value){
if(cljs.core.volatile_QMARK_.call(null,devtools.formatters.budgeting.over_budget_values)){
return cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,devtools.formatters.budgeting.over_budget_values),value);
} else {
var o__63766__auto__ = devtools.formatters.budgeting.over_budget_values;
return (o__63766__auto__["has"]).call(o__63766__auto__,value);
}
});
devtools.formatters.budgeting.object_reference_QMARK_ = (function devtools$formatters$budgeting$object_reference_QMARK_(json_ml){
return cljs.core._EQ_.call(null,cljs.core.first.call(null,json_ml),"object");
});
devtools.formatters.budgeting.determine_depth = (function devtools$formatters$budgeting$determine_depth(json_ml){
if(cljs.core.array_QMARK_.call(null,json_ml)){
return (cljs.core.apply.call(null,cljs.core.max,cljs.core.map.call(null,devtools.formatters.budgeting.determine_depth,json_ml)) + (1));
} else {
return (0);
}
});
devtools.formatters.budgeting.has_any_object_reference_QMARK_ = (function devtools$formatters$budgeting$has_any_object_reference_QMARK_(json_ml){
if(cljs.core.array_QMARK_.call(null,json_ml)){
if(cljs.core.truth_(devtools.formatters.budgeting.object_reference_QMARK_.call(null,json_ml))){
return true;
} else {
return cljs.core.some.call(null,devtools.formatters.budgeting.has_any_object_reference_QMARK_,json_ml);
}
} else {
return null;
}
});
devtools.formatters.budgeting.transfer_remaining_depth_budget_BANG_ = (function devtools$formatters$budgeting$transfer_remaining_depth_budget_BANG_(object_reference,depth_budget){
if(!((depth_budget < (0)))){
} else {
throw (new Error("Assert failed: (not (neg? depth-budget))"));
}

var data = cljs.core.second.call(null,object_reference);
var _ = ((cljs.core.object_QMARK_.call(null,data))?null:(function(){throw (new Error("Assert failed: (object? data)"))})());
var config = (data["config"]);
var G__66320 = data;
var target__63771__auto__ = G__66320;
if(cljs.core.truth_(target__63771__auto__)){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["unable to locate object path ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(null)," in ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__66320)].join('')),"\n","target__63771__auto__"].join('')));
}

(target__63771__auto__["config"] = devtools.formatters.state.set_depth_budget.call(null,config,depth_budget));

return G__66320;
});
devtools.formatters.budgeting.distribute_budget_BANG_ = (function devtools$formatters$budgeting$distribute_budget_BANG_(json_ml,depth_budget){
if(!((depth_budget < (0)))){
} else {
throw (new Error("Assert failed: (not (neg? depth-budget))"));
}

if(cljs.core.array_QMARK_.call(null,json_ml)){
var new_depth_budget_66325 = (depth_budget - (1));
if(cljs.core.truth_(devtools.formatters.budgeting.object_reference_QMARK_.call(null,json_ml))){
devtools.formatters.budgeting.transfer_remaining_depth_budget_BANG_.call(null,json_ml,new_depth_budget_66325);
} else {
var seq__66321_66326 = cljs.core.seq.call(null,json_ml);
var chunk__66322_66327 = null;
var count__66323_66328 = (0);
var i__66324_66329 = (0);
while(true){
if((i__66324_66329 < count__66323_66328)){
var item_66330 = cljs.core._nth.call(null,chunk__66322_66327,i__66324_66329);
devtools.formatters.budgeting.distribute_budget_BANG_.call(null,item_66330,new_depth_budget_66325);

var G__66331 = seq__66321_66326;
var G__66332 = chunk__66322_66327;
var G__66333 = count__66323_66328;
var G__66334 = (i__66324_66329 + (1));
seq__66321_66326 = G__66331;
chunk__66322_66327 = G__66332;
count__66323_66328 = G__66333;
i__66324_66329 = G__66334;
continue;
} else {
var temp__4657__auto___66335 = cljs.core.seq.call(null,seq__66321_66326);
if(temp__4657__auto___66335){
var seq__66321_66336__$1 = temp__4657__auto___66335;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__66321_66336__$1)){
var c__28980__auto___66337 = cljs.core.chunk_first.call(null,seq__66321_66336__$1);
var G__66338 = cljs.core.chunk_rest.call(null,seq__66321_66336__$1);
var G__66339 = c__28980__auto___66337;
var G__66340 = cljs.core.count.call(null,c__28980__auto___66337);
var G__66341 = (0);
seq__66321_66326 = G__66338;
chunk__66322_66327 = G__66339;
count__66323_66328 = G__66340;
i__66324_66329 = G__66341;
continue;
} else {
var item_66342 = cljs.core.first.call(null,seq__66321_66336__$1);
devtools.formatters.budgeting.distribute_budget_BANG_.call(null,item_66342,new_depth_budget_66325);

var G__66343 = cljs.core.next.call(null,seq__66321_66336__$1);
var G__66344 = null;
var G__66345 = (0);
var G__66346 = (0);
seq__66321_66326 = G__66343;
chunk__66322_66327 = G__66344;
count__66323_66328 = G__66345;
i__66324_66329 = G__66346;
continue;
}
} else {
}
}
break;
}
}
} else {
}

return json_ml;
});
devtools.formatters.budgeting.was_over_budget_QMARK__BANG_ = (function devtools$formatters$budgeting$was_over_budget_QMARK__BANG_(value){
if(cljs.core.truth_(devtools.formatters.budgeting.has_over_budget_value_QMARK_.call(null,value))){
devtools.formatters.budgeting.delete_over_budget_value_BANG_.call(null,value);

return true;
} else {
return null;
}
});
devtools.formatters.budgeting.alter_json_ml_to_fit_in_remaining_budget_BANG_ = (function devtools$formatters$budgeting$alter_json_ml_to_fit_in_remaining_budget_BANG_(value,json_ml){
var temp__4655__auto__ = devtools.formatters.helpers.pref.call(null,new cljs.core.Keyword(null,"initial-hierarchy-depth-budget","initial-hierarchy-depth-budget",-482715807));
if(cljs.core.truth_(temp__4655__auto__)){
var initial_hierarchy_depth_budget = temp__4655__auto__;
var remaining_depth_budget = (function (){var or__28141__auto__ = devtools.formatters.state.get_depth_budget.call(null);
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
return (initial_hierarchy_depth_budget - (1));
}
})();
var depth = devtools.formatters.budgeting.determine_depth.call(null,json_ml);
var final_QMARK_ = cljs.core.not.call(null,devtools.formatters.budgeting.has_any_object_reference_QMARK_.call(null,json_ml));
var needed_depth = ((final_QMARK_)?depth:(depth + devtools.formatters.budgeting.header_expander_depth_cost));
if((remaining_depth_budget >= needed_depth)){
return devtools.formatters.budgeting.distribute_budget_BANG_.call(null,json_ml,remaining_depth_budget);
} else {
var expander_ml = devtools.formatters.templating.render_markup.call(null,devtools.formatters.markup._LT_header_expander_GT_.call(null,value));
devtools.formatters.budgeting.add_over_budget_value_BANG_.call(null,value);

return expander_ml;
}
} else {
return json_ml;
}
});

//# sourceMappingURL=budgeting.js.map?rel=1511404513436
