// Compiled by ClojureScript 1.9.946 {:cache-key "75D5EA8647ACA951C3B9849310FE6F77B4D35C8F"}
goog.provide('cljs.loader');
goog.require('cljs.core');
goog.require('goog.object');
goog.require('goog.module.ModuleLoader');
goog.require('goog.module.ModuleManager');
cljs.loader.module_infos = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"cljs-base","cljs-base",-1271626984),cljs.core.PersistentVector.EMPTY], null);
cljs.loader.module_uris = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"cljs-base","cljs-base",-1271626984),cljs.core.PersistentVector.fromArray(["js/compiled/test/out/goog/base.js","js/compiled/test/out/goog/string/string.js","js/compiled/test/out/goog/debug/error.js","js/compiled/test/out/goog/dom/nodetype.js","js/compiled/test/out/goog/asserts/asserts.js","js/compiled/test/out/goog/array/array.js","js/compiled/test/out/goog/object/object.js","js/compiled/test/out/goog/structs/structs.js","js/compiled/test/out/goog/functions/functions.js","js/compiled/test/out/goog/math/math.js","js/compiled/test/out/goog/iter/iter.js","js/compiled/test/out/goog/structs/map.js","js/compiled/test/out/goog/uri/utils.js","js/compiled/test/out/goog/uri/uri.js","js/compiled/test/out/goog/math/integer.js","js/compiled/test/out/goog/string/stringbuffer.js","js/compiled/test/out/goog/reflect/reflect.js","js/compiled/test/out/goog/math/long.js","js/compiled/test/out/cljs/core.js","js/compiled/test/out/process/env.js","js/compiled/test/out/goog/module/module.js","js/compiled/test/out/goog/promise/thenable.js","js/compiled/test/out/goog/async/freelist.js","js/compiled/test/out/goog/async/workqueue.js","js/compiled/test/out/goog/debug/entrypointregistry.js","js/compiled/test/out/goog/dom/htmlelement.js","js/compiled/test/out/goog/dom/tagname.js","js/compiled/test/out/goog/labs/useragent/util.js","js/compiled/test/out/goog/labs/useragent/browser.js","js/compiled/test/out/goog/labs/useragent/engine.js","js/compiled/test/out/goog/async/nexttick.js","js/compiled/test/out/goog/async/run.js","js/compiled/test/out/goog/promise/resolver.js","js/compiled/test/out/goog/promise/promise.js","js/compiled/test/out/goog/disposable/idisposable.js","js/compiled/test/out/goog/disposable/disposable.js","js/compiled/test/out/goog/labs/useragent/platform.js","js/compiled/test/out/goog/useragent/useragent.js","js/compiled/test/out/goog/events/browserfeature.js","js/compiled/test/out/goog/events/eventid.js","js/compiled/test/out/goog/events/event.js","js/compiled/test/out/goog/events/eventtype.js","js/compiled/test/out/goog/events/browserevent.js","js/compiled/test/out/goog/events/listenable.js","js/compiled/test/out/goog/events/listener.js","js/compiled/test/out/goog/events/listenermap.js","js/compiled/test/out/goog/events/events.js","js/compiled/test/out/goog/events/eventtarget.js","js/compiled/test/out/goog/timer/timer.js","js/compiled/test/out/goog/events/eventhandler.js","js/compiled/test/out/goog/dom/tags.js","js/compiled/test/out/goog/string/typedstring.js","js/compiled/test/out/goog/string/const.js","js/compiled/test/out/goog/html/safescript.js","js/compiled/test/out/goog/fs/url.js","js/compiled/test/out/goog/i18n/bidi.js","js/compiled/test/out/goog/html/trustedresourceurl.js","js/compiled/test/out/goog/html/safeurl.js","js/compiled/test/out/goog/html/safestyle.js","js/compiled/test/out/goog/html/safestylesheet.js","js/compiled/test/out/goog/html/safehtml.js","js/compiled/test/out/goog/html/legacyconversions.js","js/compiled/test/out/goog/debug/errorcontext.js","js/compiled/test/out/goog/debug/debug.js","js/compiled/test/out/goog/debug/logrecord.js","js/compiled/test/out/goog/debug/logbuffer.js","js/compiled/test/out/goog/debug/logger.js","js/compiled/test/out/goog/log/log.js","js/compiled/test/out/goog/module/basemodule.js","js/compiled/test/out/goog/module/moduleloadcallback.js","js/compiled/test/out/goog/module/moduleinfo.js","js/compiled/test/out/goog/module/abstractmoduleloader.js","js/compiled/test/out/goog/net/bulkloaderhelper.js","js/compiled/test/out/goog/net/eventtype.js","js/compiled/test/out/goog/json/json.js","js/compiled/test/out/goog/json/hybrid.js","js/compiled/test/out/goog/net/errorcode.js","js/compiled/test/out/goog/net/httpstatus.js","js/compiled/test/out/goog/net/xhrlike.js","js/compiled/test/out/goog/net/xmlhttpfactory.js","js/compiled/test/out/goog/net/wrapperxmlhttpfactory.js","js/compiled/test/out/goog/net/xmlhttp.js","js/compiled/test/out/goog/net/xhrio.js","js/compiled/test/out/goog/net/bulkloader.js","js/compiled/test/out/goog/mochikit/async/deferred.js","js/compiled/test/out/goog/dom/browserfeature.js","js/compiled/test/out/goog/dom/asserts.js","js/compiled/test/out/goog/dom/safe.js","js/compiled/test/out/goog/html/uncheckedconversions.js","js/compiled/test/out/goog/math/coordinate.js","js/compiled/test/out/goog/math/size.js","js/compiled/test/out/goog/dom/dom.js","js/compiled/test/out/goog/net/jsloader.js","js/compiled/test/out/goog/useragent/product.js","js/compiled/test/out/goog/module/moduleloader.js","js/compiled/test/out/devtools/version.js","js/compiled/test/out/clojure/string.js","js/compiled/test/out/cljs/pprint.js","js/compiled/test/out/devtools/context.js","js/compiled/test/out/clojure/set.js","js/compiled/test/out/clojure/data.js","js/compiled/test/out/devtools/defaults.js","js/compiled/test/out/devtools/prefs.js","js/compiled/test/out/devtools/util.js","js/compiled/test/out/goog/debug/relativetimeprovider.js","js/compiled/test/out/clojure/zip.js","js/compiled/test/out/goog/debug/formatter.js","js/compiled/test/out/goog/debug/console.js","js/compiled/test/out/om/next/cache.js","js/compiled/test/out/cljs/core/async/impl/protocols.js","js/compiled/test/out/cljs/core/async/impl/ioc_helpers.js","js/compiled/test/out/clojure/walk.js","js/compiled/test/out/com/rpl/specter/protocols.js","js/compiled/test/out/com/rpl/specter/impl.js","js/compiled/test/out/com/rpl/specter/navs.js","js/compiled/test/out/goog/structs/simplepool.js","js/compiled/test/out/goog/debug/tracer.js","js/compiled/test/out/goog/module/modulemanager.js","js/compiled/test/out/cljs/loader.js","js/compiled/test/out/om/util.js","js/compiled/test/out/om/next/impl/parser.js","js/compiled/test/out/cljsjs/react/development/react.inc.js","js/compiled/test/out/cljsjs/react-dom/development/react-dom.inc.js","js/compiled/test/out/om/dom.js","js/compiled/test/out/com/cognitect/transit/util.js","js/compiled/test/out/com/cognitect/transit/eq.js","js/compiled/test/out/com/cognitect/transit/types.js","js/compiled/test/out/com/cognitect/transit/delimiters.js","js/compiled/test/out/com/cognitect/transit/caching.js","js/compiled/test/out/com/cognitect/transit/impl/decoder.js","js/compiled/test/out/com/cognitect/transit/impl/reader.js","js/compiled/test/out/com/cognitect/transit/handlers.js","js/compiled/test/out/com/cognitect/transit/impl/writer.js","js/compiled/test/out/com/cognitect/transit.js","js/compiled/test/out/cognitect/transit.js","js/compiled/test/out/om/next/protocols.js","js/compiled/test/out/cljs/env.js","js/compiled/test/out/cljs/tools/reader/impl/utils.js","js/compiled/test/out/cljs/tools/reader/reader_types.js","js/compiled/test/out/cljs/tools/reader/impl/inspect.js","js/compiled/test/out/cljs/tools/reader/impl/errors.js","js/compiled/test/out/cljs/tools/reader/impl/commons.js","js/compiled/test/out/cljs/tools/reader.js","js/compiled/test/out/cljs/tools/reader/edn.js","js/compiled/test/out/cljs/reader.js","js/compiled/test/out/cljs/tagged_literals.js","js/compiled/test/out/cljs/analyzer.js","js/compiled/test/out/cljs/analyzer/api.js","js/compiled/test/out/om/tempid.js","js/compiled/test/out/om/transit.js","js/compiled/test/out/om/next.js","js/compiled/test/out/cljs/spec/gen/alpha.js","js/compiled/test/out/cljs/spec/alpha.js","js/compiled/test/out/fulcro/client/util.js","js/compiled/test/out/fulcro/client/logging.js","js/compiled/test/out/yahoo/intl-messageformat-with-locales.js","js/compiled/test/out/fulcro/i18n.js","js/compiled/test/out/fulcro/client/mutations.js","js/compiled/test/out/cljs/core/async/impl/buffers.js","js/compiled/test/out/cljs/core/async/impl/dispatch.js","js/compiled/test/out/cljs/core/async/impl/channels.js","js/compiled/test/out/garden/compression.js","js/compiled/test/out/devtools/protocols.js","js/compiled/test/out/garden/types.js","js/compiled/test/out/cljs/core/async/impl/timers.js","js/compiled/test/out/cljs/core/async.js","js/compiled/test/out/fulcro/client/impl/om_plumbing.js","js/compiled/test/out/fulcro/client/impl/data_fetch.js","js/compiled/test/out/fulcro/client/network.js","js/compiled/test/out/fulcro/client/impl/application.js","js/compiled/test/out/fulcro/client/core.js","js/compiled/test/out/fulcro/inspect/helpers.js","js/compiled/test/out/com/rpl/specter.js","js/compiled/test/out/garden/selectors.js","js/compiled/test/out/goog/string/stringformat.js","js/compiled/test/out/garden/util.js","js/compiled/test/out/garden/units.js","js/compiled/test/out/garden/color.js","js/compiled/test/out/garden/compiler.js","js/compiled/test/out/garden/core.js","js/compiled/test/out/fulcro_css/core.js","js/compiled/test/out/fulcro_css/css.js","js/compiled/test/out/fulcro/inspect/ui/core.js","js/compiled/test/out/fulcro/inspect/ui/data_viewer.js","js/compiled/test/out/fulcro/inspect/ui/transactions.js","js/compiled/test/out/devtools/format.js","js/compiled/test/out/devtools/munging.js","js/compiled/test/out/devtools/formatters/helpers.js","js/compiled/test/out/devtools/formatters/state.js","js/compiled/test/out/devtools/formatters/templating.js","js/compiled/test/out/fulcro/inspect/ui/events.js","js/compiled/test/out/devtools/formatters/printing.js","js/compiled/test/out/devtools/formatters/markup.js","js/compiled/test/out/cljs/stacktrace.js","js/compiled/test/out/fulcro/inspect/ui/network.js","js/compiled/test/out/fulcro/inspect/prefs.js","js/compiled/test/out/devtools/toolbox.js","js/compiled/test/out/devtools/async.js","js/compiled/test/out/devtools/reporter.js","js/compiled/test/out/devtools/formatters/budgeting.js","js/compiled/test/out/devtools/formatters/core.js","js/compiled/test/out/devtools/formatters.js","js/compiled/test/out/devtools/hints.js","js/compiled/test/out/devtools/core.js","js/compiled/test/out/fulcro/inspect/ui/data_watcher.js","js/compiled/test/out/fulcro/inspect/ui/inspector.js","js/compiled/test/out/fulcro/inspect/core.js","js/compiled/test/out/fulcro/inspect/preload.js","js/compiled/test/out/devtools/preload.js","js/compiled/test/out/figwheel/client/utils.js","js/compiled/test/out/figwheel/client/file_reloading.js","js/compiled/test/out/cljs/repl.js","js/compiled/test/out/goog/dom/dataset.js","js/compiled/test/out/figwheel/client/socket.js","js/compiled/test/out/figwheel/client/heads_up.js","js/compiled/test/out/figwheel/client.js","js/compiled/test/out/fulcro_spec/diff.js","js/compiled/test/out/goog/date/datelike.js","js/compiled/test/out/goog/i18n/datetimesymbols.js","js/compiled/test/out/goog/date/date.js","js/compiled/test/out/goog/i18n/timezone.js","js/compiled/test/out/goog/i18n/datetimeformat.js","js/compiled/test/out/goog/structs/queue.js","js/compiled/test/out/goog/structs/collection.js","js/compiled/test/out/goog/structs/set.js","js/compiled/test/out/goog/structs/pool.js","js/compiled/test/out/goog/structs/node.js","js/compiled/test/out/goog/structs/heap.js","js/compiled/test/out/goog/structs/priorityqueue.js","js/compiled/test/out/goog/structs/prioritypool.js","js/compiled/test/out/goog/net/xhriopool.js","js/compiled/test/out/taoensso/truss/impl.js","js/compiled/test/out/taoensso/truss.js","js/compiled/test/out/cljs/test.js","js/compiled/test/out/taoensso/encore.js","js/compiled/test/out/taoensso/sente/interfaces.js","js/compiled/test/out/taoensso/sente/packers/transit.js","js/compiled/test/out/fulcro/websockets/transit_packer.js","js/compiled/test/out/taoensso/timbre/appenders/core.js","js/compiled/test/out/taoensso/timbre.js","js/compiled/test/out/taoensso/sente.js","js/compiled/test/out/fulcro/websockets/networking.js","js/compiled/test/out/fulcro/client/data_fetch.js","js/compiled/test/out/com/stuartsierra/component/platform.js","js/compiled/test/out/com/stuartsierra/dependency.js","js/compiled/test/out/com/stuartsierra/component.js","js/compiled/test/out/fulcro_spec/dom/edn_renderer.js","js/compiled/test/out/fulcro_spec/spec.js","js/compiled/test/out/fulcro_spec/impl/selectors.js","js/compiled/test/out/fulcro_spec/selectors.js","js/compiled/test/out/goog/history/eventtype.js","js/compiled/test/out/goog/history/event.js","js/compiled/test/out/goog/history/html5history.js","js/compiled/test/out/goog/dom/inputtype.js","js/compiled/test/out/goog/labs/useragent/device.js","js/compiled/test/out/goog/memoize/memoize.js","js/compiled/test/out/goog/history/history.js","js/compiled/test/out/pushy/core.js","js/compiled/test/out/fulcro_spec/renderer.js","js/compiled/test/out/fulcro_spec/router.js","js/compiled/test/out/fulcro_spec/assertions.js","js/compiled/test/out/cljs_uuid_utils/core.js","js/compiled/test/out/fulcro_spec/reporter.js","js/compiled/test/out/fulcro_spec/runner.js","js/compiled/test/out/fulcro_spec/suite.js","js/compiled/test/out/fulcro_spec/async.js","js/compiled/test/out/fulcro_spec/stub.js","js/compiled/test/out/fulcro_spec/core.js","js/compiled/test/out/fulcro/inspect/ui/transactions_spec.js","js/compiled/test/out/fulcro/inspect/helpers_spec.js","js/compiled/test/out/cljs/user.js","js/compiled/test/out/figwheel/connect/build_test.js"], true)], null);
cljs.loader.deps_for = (function cljs$loader$deps_for(x,graph){
var depends_on = cljs.core.get.call(null,graph,x);
return cljs.core.vec.call(null,cljs.core.distinct.call(null,cljs.core.concat.call(null,cljs.core.mapcat.call(null,((function (depends_on){
return (function (p1__75547_SHARP_){
return cljs.loader.deps_for.call(null,p1__75547_SHARP_,graph);
});})(depends_on))
,depends_on),depends_on)));
});
cljs.loader.munge_kw = (function cljs$loader$munge_kw(x){
var G__75548 = x;
if((x instanceof cljs.core.Keyword)){
return cljs.core.munge.call(null,cljs.core.name.call(null,G__75548));
} else {
return G__75548;
}
});
cljs.loader.to_js = (function cljs$loader$to_js(m){
return cljs.core.reduce_kv.call(null,(function (ret,k,xs){
var arr = cljs.core.into_array.call(null,cljs.core.map.call(null,cljs.loader.munge_kw,xs));
var G__75549 = ret;
goog.object.set(G__75549,cljs.core.munge.call(null,cljs.core.name.call(null,k)),arr);

return G__75549;
}),({}),m);
});
cljs.loader.create_module_manager = (function cljs$loader$create_module_manager(){
var mm = (new goog.module.ModuleManager());
var ml = (new goog.module.ModuleLoader());
mm.setLoader(ml);

return mm;
});
if(typeof cljs.loader._STAR_module_manager_STAR_ !== 'undefined'){
} else {
cljs.loader._STAR_module_manager_STAR_ = cljs.loader.create_module_manager.call(null);
}
cljs.loader._STAR_module_manager_STAR_.setAllModuleInfo(cljs.loader.to_js.call(null,cljs.loader.module_infos));
cljs.loader._STAR_module_manager_STAR_.setModuleUris(cljs.loader.to_js.call(null,cljs.loader.module_uris));
/**
 * Return true if modules is loaded. module-name should be a keyword matching
 * a :modules module definition.
 */
cljs.loader.loaded_QMARK_ = (function cljs$loader$loaded_QMARK_(module_name){
if(cljs.core.contains_QMARK_.call(null,cljs.loader.module_infos,module_name)){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["Module ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(module_name)," does not exist"].join('')),"\n","(contains? module-infos module-name)"].join('')));
}

var mname = cljs.core.munge.call(null,cljs.core.name.call(null,module_name));
var module = cljs.loader._STAR_module_manager_STAR_.getModuleInfo(mname);
if(!((module == null))){
return module.isLoaded();
} else {
return null;
}
});
/**
 * Load a module. module-name should be a keyword matching a :modules module
 * definition.
 */
cljs.loader.load = (function cljs$loader$load(var_args){
var G__75551 = arguments.length;
switch (G__75551) {
case 1:
return cljs.loader.load.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.loader.load.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.loader.load.cljs$core$IFn$_invoke$arity$1 = (function (module_name){
return cljs.loader.load.call(null,module_name,null);
});

cljs.loader.load.cljs$core$IFn$_invoke$arity$2 = (function (module_name,cb){
if(cljs.core.contains_QMARK_.call(null,cljs.loader.module_infos,module_name)){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["Module ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(module_name)," does not exist"].join('')),"\n","(contains? module-infos module-name)"].join('')));
}

var mname = cljs.core.munge.call(null,cljs.core.name.call(null,module_name));
if(!((cb == null))){
return cljs.loader._STAR_module_manager_STAR_.execOnLoad(mname,cb);
} else {
return cljs.loader._STAR_module_manager_STAR_.load(mname);
}
});

cljs.loader.load.cljs$lang$maxFixedArity = 2;

/**
 * Set a module as being loaded. module-name should be a keyword matching a
 *   :modules module definition. Will mark all parent modules as also being
 *   loaded. Note that calls to this function will be automatically generated
 *   as the final expression for known :modules entry points that require the
 *   cljs.loader namespace.
 */
cljs.loader.set_loaded_BANG_ = (function cljs$loader$set_loaded_BANG_(module_name){
if(cljs.core.contains_QMARK_.call(null,cljs.loader.module_infos,module_name)){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["Module ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(module_name)," does not exist"].join('')),"\n","(contains? module-infos module-name)"].join('')));
}

var xs = cljs.loader.deps_for.call(null,module_name,cljs.loader.module_infos);
var seq__75553_75557 = cljs.core.seq.call(null,xs);
var chunk__75554_75558 = null;
var count__75555_75559 = (0);
var i__75556_75560 = (0);
while(true){
if((i__75556_75560 < count__75555_75559)){
var x_75561 = cljs.core._nth.call(null,chunk__75554_75558,i__75556_75560);
cljs.loader._STAR_module_manager_STAR_.setLoaded(cljs.loader.munge_kw.call(null,x_75561));

var G__75562 = seq__75553_75557;
var G__75563 = chunk__75554_75558;
var G__75564 = count__75555_75559;
var G__75565 = (i__75556_75560 + (1));
seq__75553_75557 = G__75562;
chunk__75554_75558 = G__75563;
count__75555_75559 = G__75564;
i__75556_75560 = G__75565;
continue;
} else {
var temp__4657__auto___75566 = cljs.core.seq.call(null,seq__75553_75557);
if(temp__4657__auto___75566){
var seq__75553_75567__$1 = temp__4657__auto___75566;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__75553_75567__$1)){
var c__28980__auto___75568 = cljs.core.chunk_first.call(null,seq__75553_75567__$1);
var G__75569 = cljs.core.chunk_rest.call(null,seq__75553_75567__$1);
var G__75570 = c__28980__auto___75568;
var G__75571 = cljs.core.count.call(null,c__28980__auto___75568);
var G__75572 = (0);
seq__75553_75557 = G__75569;
chunk__75554_75558 = G__75570;
count__75555_75559 = G__75571;
i__75556_75560 = G__75572;
continue;
} else {
var x_75573 = cljs.core.first.call(null,seq__75553_75567__$1);
cljs.loader._STAR_module_manager_STAR_.setLoaded(cljs.loader.munge_kw.call(null,x_75573));

var G__75574 = cljs.core.next.call(null,seq__75553_75567__$1);
var G__75575 = null;
var G__75576 = (0);
var G__75577 = (0);
seq__75553_75557 = G__75574;
chunk__75554_75558 = G__75575;
count__75555_75559 = G__75576;
i__75556_75560 = G__75577;
continue;
}
} else {
}
}
break;
}

return cljs.loader._STAR_module_manager_STAR_.setLoaded(cljs.loader.munge_kw.call(null,module_name));
});
/**
 * Prefetch a module. module-name should be a keyword matching a :modules
 *   module definition. Will download the module but not evaluate it. To
 *   complete module load, one must also call cljs.loader/load after prefetching
 *   the module. Does nothing if the module is loading or has been loaded.
 */
cljs.loader.prefetch = (function cljs$loader$prefetch(module_name){
if(cljs.core.contains_QMARK_.call(null,cljs.loader.module_infos,module_name)){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["Module ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(module_name)," does not exist"].join('')),"\n","(contains? module-infos module-name)"].join('')));
}

if(cljs.core.truth_(cljs.loader.loaded_QMARK_.call(null,module_name))){
return null;
} else {
var mname = cljs.core.munge.call(null,cljs.core.name.call(null,module_name));
if(cljs.core.truth_(cljs.loader._STAR_module_manager_STAR_.isModuleLoading(mname))){
return null;
} else {
return cljs.loader._STAR_module_manager_STAR_.prefetchModule(mname);
}
}
});

//# sourceMappingURL=loader.js.map?rel=1511404548250
