// Compiled by ClojureScript 1.9.946 {}
goog.provide('fulcro.client.logging');
goog.require('cljs.core');
goog.require('cljs.pprint');
goog.require('om.next');
goog.require('goog.log');
goog.require('goog.debug.Logger.Level');
fulcro.client.logging.set_level = (function fulcro$client$logging$set_level(log_level){

return om.next._STAR_logger_STAR_.setLevel(goog.debug.Logger.Level.getPredefinedLevel((function (){var G__99394 = log_level;
var G__99394__$1 = (((G__99394 instanceof cljs.core.Keyword))?G__99394.fqn:null);
switch (G__99394__$1) {
case "all":
return "ALL";

break;
case "debug":
return "FINE";

break;
case "info":
return "INFO";

break;
case "warn":
return "WARNING";

break;
case "error":
return "SEVERE";

break;
case "none":
return "OFF";

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__99394__$1)].join('')));

}
})()));
});
/**
 * Include a pretty-printed cljs value as a string with the given text message.
 */
fulcro.client.logging.value_message = (function fulcro$client$logging$value_message(msg,val){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg),":\n",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var sb__29170__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR_99398_99401 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR_99399_99402 = cljs.core._STAR_print_fn_STAR_;
cljs.core._STAR_print_newline_STAR_ = true;

cljs.core._STAR_print_fn_STAR_ = ((function (_STAR_print_newline_STAR_99398_99401,_STAR_print_fn_STAR_99399_99402,sb__29170__auto__){
return (function (x__29171__auto__){
return sb__29170__auto__.append(x__29171__auto__);
});})(_STAR_print_newline_STAR_99398_99401,_STAR_print_fn_STAR_99399_99402,sb__29170__auto__))
;

try{cljs.pprint.pprint.call(null,val);
}finally {cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR_99399_99402;

cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR_99398_99401;
}
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__29170__auto__)].join('');
})())].join('');
});
/**
 * Print a debug message to the Om logger which includes a value.
 *        Returns the value (like identity) so it can be harmlessly nested in expressions.
 */
fulcro.client.logging.debug = (function fulcro$client$logging$debug(var_args){
var G__99404 = arguments.length;
switch (G__99404) {
case 1:
return fulcro.client.logging.debug.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fulcro.client.logging.debug.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fulcro.client.logging.debug.cljs$core$IFn$_invoke$arity$1 = (function (value){
goog.log.fine(om.next._STAR_logger_STAR_,fulcro.client.logging.value_message.call(null,"DEBUG",value));

return value;
});

fulcro.client.logging.debug.cljs$core$IFn$_invoke$arity$2 = (function (msg,value){
goog.log.fine(om.next._STAR_logger_STAR_,fulcro.client.logging.value_message.call(null,msg,value));

return value;
});

fulcro.client.logging.debug.cljs$lang$maxFixedArity = 2;

/**
 * output an INFO level message to the Om logger
 */
fulcro.client.logging.info = (function fulcro$client$logging$info(var_args){
var args__29319__auto__ = [];
var len__29312__auto___99411 = arguments.length;
var i__29313__auto___99412 = (0);
while(true){
if((i__29313__auto___99412 < len__29312__auto___99411)){
args__29319__auto__.push((arguments[i__29313__auto___99412]));

var G__99413 = (i__29313__auto___99412 + (1));
i__29313__auto___99412 = G__99413;
continue;
} else {
}
break;
}

var argseq__29320__auto__ = ((((0) < args__29319__auto__.length))?(new cljs.core.IndexedSeq(args__29319__auto__.slice((0)),(0),null)):null);
return fulcro.client.logging.info.cljs$core$IFn$_invoke$arity$variadic(argseq__29320__auto__);
});

fulcro.client.logging.info.cljs$core$IFn$_invoke$arity$variadic = (function (data){
return goog.log.info(om.next._STAR_logger_STAR_,cljs.core.apply.call(null,cljs.core.str,cljs.core.interpose.call(null," ",data)));
});

fulcro.client.logging.info.cljs$lang$maxFixedArity = (0);

fulcro.client.logging.info.cljs$lang$applyTo = (function (seq99409){
return fulcro.client.logging.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq99409));
});

/**
 * output a WARNING level message to the Om logger
 */
fulcro.client.logging.warn = (function fulcro$client$logging$warn(var_args){
var args__29319__auto__ = [];
var len__29312__auto___99419 = arguments.length;
var i__29313__auto___99420 = (0);
while(true){
if((i__29313__auto___99420 < len__29312__auto___99419)){
args__29319__auto__.push((arguments[i__29313__auto___99420]));

var G__99421 = (i__29313__auto___99420 + (1));
i__29313__auto___99420 = G__99421;
continue;
} else {
}
break;
}

var argseq__29320__auto__ = ((((0) < args__29319__auto__.length))?(new cljs.core.IndexedSeq(args__29319__auto__.slice((0)),(0),null)):null);
return fulcro.client.logging.warn.cljs$core$IFn$_invoke$arity$variadic(argseq__29320__auto__);
});

fulcro.client.logging.warn.cljs$core$IFn$_invoke$arity$variadic = (function (data){
return goog.log.warning(om.next._STAR_logger_STAR_,cljs.core.apply.call(null,cljs.core.str,cljs.core.interpose.call(null," ",data)));
});

fulcro.client.logging.warn.cljs$lang$maxFixedArity = (0);

fulcro.client.logging.warn.cljs$lang$applyTo = (function (seq99415){
return fulcro.client.logging.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq99415));
});

/**
 * output an ERROR level message to the Om logger
 */
fulcro.client.logging.error = (function fulcro$client$logging$error(var_args){
var args__29319__auto__ = [];
var len__29312__auto___99426 = arguments.length;
var i__29313__auto___99427 = (0);
while(true){
if((i__29313__auto___99427 < len__29312__auto___99426)){
args__29319__auto__.push((arguments[i__29313__auto___99427]));

var G__99428 = (i__29313__auto___99427 + (1));
i__29313__auto___99427 = G__99428;
continue;
} else {
}
break;
}

var argseq__29320__auto__ = ((((0) < args__29319__auto__.length))?(new cljs.core.IndexedSeq(args__29319__auto__.slice((0)),(0),null)):null);
return fulcro.client.logging.error.cljs$core$IFn$_invoke$arity$variadic(argseq__29320__auto__);
});

fulcro.client.logging.error.cljs$core$IFn$_invoke$arity$variadic = (function (data){
return goog.log.error(om.next._STAR_logger_STAR_,cljs.core.apply.call(null,cljs.core.str,cljs.core.interpose.call(null," ",data)));
});

fulcro.client.logging.error.cljs$lang$maxFixedArity = (0);

fulcro.client.logging.error.cljs$lang$applyTo = (function (seq99424){
return fulcro.client.logging.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq99424));
});


//# sourceMappingURL=logging.js.map?rel=1511404598589
