// Compiled by ClojureScript 1.9.946 {}
goog.provide('fulcro.client.impl.application');
goog.require('cljs.core');
goog.require('fulcro.client.logging');
goog.require('om.next');
goog.require('om.util');
goog.require('fulcro.i18n');
goog.require('fulcro.client.impl.data_fetch');
goog.require('fulcro.client.util');
goog.require('cljs.core.async');
goog.require('fulcro.client.network');
goog.require('fulcro.client.impl.om_plumbing');
/**
 * This internal function is responsible for generating and returning a function that can accomplish calling the fallbacks that
 *   appear in an incoming Om transaction, which is in turn used by the error-handling logic of the plumbing.
 */
fulcro.client.impl.application.fallback_handler = (function fulcro$client$impl$application$fallback_handler(p__99953,query){
var map__99954 = p__99953;
var map__99954__$1 = ((((!((map__99954 == null)))?((((map__99954.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__99954.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__99954):map__99954);
var reconciler = cljs.core.get.call(null,map__99954__$1,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966));
return ((function (map__99954,map__99954__$1,reconciler){
return (function (error){
cljs.core.swap_BANG_.call(null,om.next.app_state.call(null,reconciler),cljs.core.assoc,new cljs.core.Keyword("fulcro","server-error","fulcro/server-error",-1254037316),error);

var temp__4655__auto__ = fulcro.client.impl.om_plumbing.fallback_query.call(null,query,error);
if(cljs.core.truth_(temp__4655__auto__)){
var q = temp__4655__auto__;
fulcro.client.logging.warn.call(null,fulcro.client.logging.value_message.call(null,"Transaction failed. Running fallback.",q));

return om.next.transact_BANG_.call(null,reconciler,q);
} else {
return fulcro.client.logging.warn.call(null,"Fallback triggered, but no fallbacks were defined.");
}
});
;})(map__99954,map__99954__$1,reconciler))
});
/**
 * Enqueue a send to the network queue. This is a standalone function because we cannot mock core async functions.
 */
fulcro.client.impl.application.enqueue = (function fulcro$client$impl$application$enqueue(q,v){
var c__47173__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto__){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto__){
return (function (state_99965){
var state_val_99966 = (state_99965[(1)]);
if((state_val_99966 === (1))){
var state_99965__$1 = state_99965;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_99965__$1,(2),q,v);
} else {
if((state_val_99966 === (2))){
var inst_99963 = (state_99965[(2)]);
var state_99965__$1 = state_99965;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_99965__$1,inst_99963);
} else {
return null;
}
}
});})(c__47173__auto__))
;
return ((function (switch__47085__auto__,c__47173__auto__){
return (function() {
var fulcro$client$impl$application$enqueue_$_state_machine__47086__auto__ = null;
var fulcro$client$impl$application$enqueue_$_state_machine__47086__auto____0 = (function (){
var statearr_99968 = [null,null,null,null,null,null,null];
(statearr_99968[(0)] = fulcro$client$impl$application$enqueue_$_state_machine__47086__auto__);

(statearr_99968[(1)] = (1));

return statearr_99968;
});
var fulcro$client$impl$application$enqueue_$_state_machine__47086__auto____1 = (function (state_99965){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_99965);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e99969){if((e99969 instanceof Object)){
var ex__47089__auto__ = e99969;
var statearr_99970_99972 = state_99965;
(statearr_99970_99972[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_99965);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e99969;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__99973 = state_99965;
state_99965 = G__99973;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
fulcro$client$impl$application$enqueue_$_state_machine__47086__auto__ = function(state_99965){
switch(arguments.length){
case 0:
return fulcro$client$impl$application$enqueue_$_state_machine__47086__auto____0.call(this);
case 1:
return fulcro$client$impl$application$enqueue_$_state_machine__47086__auto____1.call(this,state_99965);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
fulcro$client$impl$application$enqueue_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = fulcro$client$impl$application$enqueue_$_state_machine__47086__auto____0;
fulcro$client$impl$application$enqueue_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = fulcro$client$impl$application$enqueue_$_state_machine__47086__auto____1;
return fulcro$client$impl$application$enqueue_$_state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto__))
})();
var state__47175__auto__ = (function (){var statearr_99971 = f__47174__auto__.call(null);
(statearr_99971[(6)] = c__47173__auto__);

return statearr_99971;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto__))
);

return c__47173__auto__;
});
/**
 * Do a properly-plumbed network send. This function recursively strips ui attributes from the tx and pushes the tx over
 *   the network. It installs the given on-load and on-error handlers to deal with the network response.
 */
fulcro.client.impl.application.real_send = (function fulcro$client$impl$application$real_send(net,tx,on_done,on_error,on_load){
if(((!((net == null)))?(((false) || ((cljs.core.PROTOCOL_SENTINEL === net.fulcro$client$network$ProgressiveTransfer$)))?true:false):false)){
return fulcro.client.network.updating_send.call(null,net,fulcro.client.impl.om_plumbing.strip_ui.call(null,tx),on_done,on_error,on_load);
} else {
return fulcro.client.network.send.call(null,net,fulcro.client.impl.om_plumbing.strip_ui.call(null,tx),on_done,on_error);
}
});
/**
 * Split a tx that contains mutations. Returns a vector that contains at least one tx (the original).
 * 
 * Examples:
 * [(f) (g)] => [[(f) (g)]]
 * [(f) (g) (f) (k)] => [[(f) (g)] [(f) (k)]]
 * [(f) (g) (f) (k) (g)] => [[(f) (g)] [(f) (k) (g)]]
 * 
 */
fulcro.client.impl.application.split_mutations = (function fulcro$client$impl$application$split_mutations(tx){
if(!((cljs.core.vector_QMARK_.call(null,tx)) && (cljs.core.every_QMARK_.call(null,(function (t){
return (cljs.core.list_QMARK_.call(null,t)) && ((cljs.core.first.call(null,t) instanceof cljs.core.Symbol));
}),tx)))){
fulcro.client.logging.error.call(null,"INTERNAL ERROR: split-mutations was asked to split a tx that contained things other than mutations.",tx);

return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [tx], null);
} else {
if(cljs.core.empty_QMARK_.call(null,tx)){
return cljs.core.PersistentVector.EMPTY;
} else {
var mutation_name = (function (m){
return cljs.core.first.call(null,m);
});
var map__99980 = cljs.core.reduce.call(null,((function (mutation_name){
return (function (p__99981,mutation){
var map__99982 = p__99981;
var map__99982__$1 = ((((!((map__99982 == null)))?((((map__99982.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__99982.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__99982):map__99982);
var seen = cljs.core.get.call(null,map__99982__$1,new cljs.core.Keyword(null,"seen","seen",-518999789));
var accumulator = cljs.core.get.call(null,map__99982__$1,new cljs.core.Keyword(null,"accumulator","accumulator",1546185501));
var current_tx = cljs.core.get.call(null,map__99982__$1,new cljs.core.Keyword(null,"current-tx","current-tx",1600727374));
if(cljs.core.contains_QMARK_.call(null,seen,mutation_name.call(null,mutation))){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"seen","seen",-518999789),cljs.core.PersistentHashSet.EMPTY,new cljs.core.Keyword(null,"accumulator","accumulator",1546185501),cljs.core.conj.call(null,accumulator,current_tx),new cljs.core.Keyword(null,"current-tx","current-tx",1600727374),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [mutation], null)], null);
} else {
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"seen","seen",-518999789),cljs.core.conj.call(null,seen,mutation_name.call(null,mutation)),new cljs.core.Keyword(null,"accumulator","accumulator",1546185501),accumulator,new cljs.core.Keyword(null,"current-tx","current-tx",1600727374),cljs.core.conj.call(null,current_tx,mutation)], null);
}
});})(mutation_name))
,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"seen","seen",-518999789),cljs.core.PersistentHashSet.EMPTY,new cljs.core.Keyword(null,"accumulator","accumulator",1546185501),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"current-tx","current-tx",1600727374),cljs.core.PersistentVector.EMPTY], null),tx);
var map__99980__$1 = ((((!((map__99980 == null)))?((((map__99980.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__99980.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__99980):map__99980);
var accumulator = cljs.core.get.call(null,map__99980__$1,new cljs.core.Keyword(null,"accumulator","accumulator",1546185501));
var current_tx = cljs.core.get.call(null,map__99980__$1,new cljs.core.Keyword(null,"current-tx","current-tx",1600727374));
return cljs.core.conj.call(null,accumulator,current_tx);
}
}
});
/**
 * Splits out the (remote) mutations and fallbacks in a transaction, creates an error handler that can
 * trigger fallbacks, and enqueues the remote mutations on the network queue. If duplicate mutation names
 * appear, then they will be separated into separate network requests.
 * 
 * NOTE: If the mutation in the tx has duplicates, then the same fallback will be used for the
 * resulting split tx. See `split-mutations` (which is used by this function to split dupes out of txes).
 */
fulcro.client.impl.application.enqueue_mutations = (function fulcro$client$impl$application$enqueue_mutations(p__99995,remote_tx_map,cb){
var map__99996 = p__99995;
var map__99996__$1 = ((((!((map__99996 == null)))?((((map__99996.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__99996.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__99996):map__99996);
var app = map__99996__$1;
var send_queues = cljs.core.get.call(null,map__99996__$1,new cljs.core.Keyword(null,"send-queues","send-queues",-212336330));
var seq__99998 = cljs.core.seq.call(null,cljs.core.keys.call(null,remote_tx_map));
var chunk__99999 = null;
var count__100000 = (0);
var i__100001 = (0);
while(true){
if((i__100001 < count__100000)){
var remote = cljs.core._nth.call(null,chunk__99999,i__100001);
var queue_100010 = cljs.core.get.call(null,send_queues,remote);
var full_remote_transaction_100011 = cljs.core.get.call(null,remote_tx_map,remote);
var fallback_100012 = fulcro.client.impl.application.fallback_handler.call(null,app,full_remote_transaction_100011);
var desired_remote_mutations_100013 = fulcro.client.impl.om_plumbing.remove_loads_and_fallbacks.call(null,full_remote_transaction_100011);
var tx_list_100014 = fulcro.client.impl.application.split_mutations.call(null,desired_remote_mutations_100013);
var has_mutations_QMARK__100015 = ((function (seq__99998,chunk__99999,count__100000,i__100001,queue_100010,full_remote_transaction_100011,fallback_100012,desired_remote_mutations_100013,tx_list_100014,remote,map__99996,map__99996__$1,app,send_queues){
return (function (tx){
return (cljs.core.count.call(null,tx) > (0));
});})(seq__99998,chunk__99999,count__100000,i__100001,queue_100010,full_remote_transaction_100011,fallback_100012,desired_remote_mutations_100013,tx_list_100014,remote,map__99996,map__99996__$1,app,send_queues))
;
var payload_100016 = ((function (seq__99998,chunk__99999,count__100000,i__100001,queue_100010,full_remote_transaction_100011,fallback_100012,desired_remote_mutations_100013,tx_list_100014,has_mutations_QMARK__100015,remote,map__99996,map__99996__$1,app,send_queues){
return (function (tx){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"query","query",-1288509510),tx,new cljs.core.Keyword(null,"on-load","on-load",1415151594),cb,new cljs.core.Keyword(null,"on-error","on-error",1728533530),((function (seq__99998,chunk__99999,count__100000,i__100001,queue_100010,full_remote_transaction_100011,fallback_100012,desired_remote_mutations_100013,tx_list_100014,has_mutations_QMARK__100015,remote,map__99996,map__99996__$1,app,send_queues){
return (function (p1__99994_SHARP_){
return fallback_100012.call(null,p1__99994_SHARP_);
});})(seq__99998,chunk__99999,count__100000,i__100001,queue_100010,full_remote_transaction_100011,fallback_100012,desired_remote_mutations_100013,tx_list_100014,has_mutations_QMARK__100015,remote,map__99996,map__99996__$1,app,send_queues))
], null);
});})(seq__99998,chunk__99999,count__100000,i__100001,queue_100010,full_remote_transaction_100011,fallback_100012,desired_remote_mutations_100013,tx_list_100014,has_mutations_QMARK__100015,remote,map__99996,map__99996__$1,app,send_queues))
;
var seq__100002_100017 = cljs.core.seq.call(null,tx_list_100014);
var chunk__100003_100018 = null;
var count__100004_100019 = (0);
var i__100005_100020 = (0);
while(true){
if((i__100005_100020 < count__100004_100019)){
var tx_100021 = cljs.core._nth.call(null,chunk__100003_100018,i__100005_100020);
if(cljs.core.truth_(has_mutations_QMARK__100015.call(null,tx_100021))){
fulcro.client.impl.application.enqueue.call(null,queue_100010,payload_100016.call(null,tx_100021));
} else {
}

var G__100022 = seq__100002_100017;
var G__100023 = chunk__100003_100018;
var G__100024 = count__100004_100019;
var G__100025 = (i__100005_100020 + (1));
seq__100002_100017 = G__100022;
chunk__100003_100018 = G__100023;
count__100004_100019 = G__100024;
i__100005_100020 = G__100025;
continue;
} else {
var temp__4657__auto___100026 = cljs.core.seq.call(null,seq__100002_100017);
if(temp__4657__auto___100026){
var seq__100002_100027__$1 = temp__4657__auto___100026;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__100002_100027__$1)){
var c__28980__auto___100028 = cljs.core.chunk_first.call(null,seq__100002_100027__$1);
var G__100029 = cljs.core.chunk_rest.call(null,seq__100002_100027__$1);
var G__100030 = c__28980__auto___100028;
var G__100031 = cljs.core.count.call(null,c__28980__auto___100028);
var G__100032 = (0);
seq__100002_100017 = G__100029;
chunk__100003_100018 = G__100030;
count__100004_100019 = G__100031;
i__100005_100020 = G__100032;
continue;
} else {
var tx_100033 = cljs.core.first.call(null,seq__100002_100027__$1);
if(cljs.core.truth_(has_mutations_QMARK__100015.call(null,tx_100033))){
fulcro.client.impl.application.enqueue.call(null,queue_100010,payload_100016.call(null,tx_100033));
} else {
}

var G__100034 = cljs.core.next.call(null,seq__100002_100027__$1);
var G__100035 = null;
var G__100036 = (0);
var G__100037 = (0);
seq__100002_100017 = G__100034;
chunk__100003_100018 = G__100035;
count__100004_100019 = G__100036;
i__100005_100020 = G__100037;
continue;
}
} else {
}
}
break;
}

var G__100038 = seq__99998;
var G__100039 = chunk__99999;
var G__100040 = count__100000;
var G__100041 = (i__100001 + (1));
seq__99998 = G__100038;
chunk__99999 = G__100039;
count__100000 = G__100040;
i__100001 = G__100041;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__99998);
if(temp__4657__auto__){
var seq__99998__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__99998__$1)){
var c__28980__auto__ = cljs.core.chunk_first.call(null,seq__99998__$1);
var G__100042 = cljs.core.chunk_rest.call(null,seq__99998__$1);
var G__100043 = c__28980__auto__;
var G__100044 = cljs.core.count.call(null,c__28980__auto__);
var G__100045 = (0);
seq__99998 = G__100042;
chunk__99999 = G__100043;
count__100000 = G__100044;
i__100001 = G__100045;
continue;
} else {
var remote = cljs.core.first.call(null,seq__99998__$1);
var queue_100046 = cljs.core.get.call(null,send_queues,remote);
var full_remote_transaction_100047 = cljs.core.get.call(null,remote_tx_map,remote);
var fallback_100048 = fulcro.client.impl.application.fallback_handler.call(null,app,full_remote_transaction_100047);
var desired_remote_mutations_100049 = fulcro.client.impl.om_plumbing.remove_loads_and_fallbacks.call(null,full_remote_transaction_100047);
var tx_list_100050 = fulcro.client.impl.application.split_mutations.call(null,desired_remote_mutations_100049);
var has_mutations_QMARK__100051 = ((function (seq__99998,chunk__99999,count__100000,i__100001,queue_100046,full_remote_transaction_100047,fallback_100048,desired_remote_mutations_100049,tx_list_100050,remote,seq__99998__$1,temp__4657__auto__,map__99996,map__99996__$1,app,send_queues){
return (function (tx){
return (cljs.core.count.call(null,tx) > (0));
});})(seq__99998,chunk__99999,count__100000,i__100001,queue_100046,full_remote_transaction_100047,fallback_100048,desired_remote_mutations_100049,tx_list_100050,remote,seq__99998__$1,temp__4657__auto__,map__99996,map__99996__$1,app,send_queues))
;
var payload_100052 = ((function (seq__99998,chunk__99999,count__100000,i__100001,queue_100046,full_remote_transaction_100047,fallback_100048,desired_remote_mutations_100049,tx_list_100050,has_mutations_QMARK__100051,remote,seq__99998__$1,temp__4657__auto__,map__99996,map__99996__$1,app,send_queues){
return (function (tx){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"query","query",-1288509510),tx,new cljs.core.Keyword(null,"on-load","on-load",1415151594),cb,new cljs.core.Keyword(null,"on-error","on-error",1728533530),((function (seq__99998,chunk__99999,count__100000,i__100001,queue_100046,full_remote_transaction_100047,fallback_100048,desired_remote_mutations_100049,tx_list_100050,has_mutations_QMARK__100051,remote,seq__99998__$1,temp__4657__auto__,map__99996,map__99996__$1,app,send_queues){
return (function (p1__99994_SHARP_){
return fallback_100048.call(null,p1__99994_SHARP_);
});})(seq__99998,chunk__99999,count__100000,i__100001,queue_100046,full_remote_transaction_100047,fallback_100048,desired_remote_mutations_100049,tx_list_100050,has_mutations_QMARK__100051,remote,seq__99998__$1,temp__4657__auto__,map__99996,map__99996__$1,app,send_queues))
], null);
});})(seq__99998,chunk__99999,count__100000,i__100001,queue_100046,full_remote_transaction_100047,fallback_100048,desired_remote_mutations_100049,tx_list_100050,has_mutations_QMARK__100051,remote,seq__99998__$1,temp__4657__auto__,map__99996,map__99996__$1,app,send_queues))
;
var seq__100006_100053 = cljs.core.seq.call(null,tx_list_100050);
var chunk__100007_100054 = null;
var count__100008_100055 = (0);
var i__100009_100056 = (0);
while(true){
if((i__100009_100056 < count__100008_100055)){
var tx_100057 = cljs.core._nth.call(null,chunk__100007_100054,i__100009_100056);
if(cljs.core.truth_(has_mutations_QMARK__100051.call(null,tx_100057))){
fulcro.client.impl.application.enqueue.call(null,queue_100046,payload_100052.call(null,tx_100057));
} else {
}

var G__100058 = seq__100006_100053;
var G__100059 = chunk__100007_100054;
var G__100060 = count__100008_100055;
var G__100061 = (i__100009_100056 + (1));
seq__100006_100053 = G__100058;
chunk__100007_100054 = G__100059;
count__100008_100055 = G__100060;
i__100009_100056 = G__100061;
continue;
} else {
var temp__4657__auto___100062__$1 = cljs.core.seq.call(null,seq__100006_100053);
if(temp__4657__auto___100062__$1){
var seq__100006_100063__$1 = temp__4657__auto___100062__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__100006_100063__$1)){
var c__28980__auto___100064 = cljs.core.chunk_first.call(null,seq__100006_100063__$1);
var G__100065 = cljs.core.chunk_rest.call(null,seq__100006_100063__$1);
var G__100066 = c__28980__auto___100064;
var G__100067 = cljs.core.count.call(null,c__28980__auto___100064);
var G__100068 = (0);
seq__100006_100053 = G__100065;
chunk__100007_100054 = G__100066;
count__100008_100055 = G__100067;
i__100009_100056 = G__100068;
continue;
} else {
var tx_100069 = cljs.core.first.call(null,seq__100006_100063__$1);
if(cljs.core.truth_(has_mutations_QMARK__100051.call(null,tx_100069))){
fulcro.client.impl.application.enqueue.call(null,queue_100046,payload_100052.call(null,tx_100069));
} else {
}

var G__100070 = cljs.core.next.call(null,seq__100006_100063__$1);
var G__100071 = null;
var G__100072 = (0);
var G__100073 = (0);
seq__100006_100053 = G__100070;
chunk__100007_100054 = G__100071;
count__100008_100055 = G__100072;
i__100009_100056 = G__100073;
continue;
}
} else {
}
}
break;
}

var G__100074 = cljs.core.next.call(null,seq__99998__$1);
var G__100075 = null;
var G__100076 = (0);
var G__100077 = (0);
seq__99998 = G__100074;
chunk__99999 = G__100075;
count__100000 = G__100076;
i__100001 = G__100077;
continue;
}
} else {
return null;
}
}
break;
}
});
/**
 * Finds any loads marked `parallel` and triggers real network requests immediately. Remaining loads
 *   are pulled into a single fetch payload (combined into one query) and enqueued behind any prior mutations/reads that
 *   were already requested in a prior UI/event cycle. Thus non-parallel reads are processed in clusters grouped due to UI
 *   events (a single event might trigger many reads which will all go to the server as a single combined request).
 *   Further UI events that trigger remote interaction will end up waiting until prior network request(s) are complete.
 * 
 *   This ensures that default reasoning is simple and sequential in the face of optimistic UI updates (real network
 *   traffic characteristics could cause out of order processing, and you would not want
 *   a 'create list' to be processed on the server *after* an 'add an item to the list'). 
 */
fulcro.client.impl.application.enqueue_reads = (function fulcro$client$impl$application$enqueue_reads(p__100080){
var map__100081 = p__100080;
var map__100081__$1 = ((((!((map__100081 == null)))?((((map__100081.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__100081.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__100081):map__100081);
var send_queues = cljs.core.get.call(null,map__100081__$1,new cljs.core.Keyword(null,"send-queues","send-queues",-212336330));
var reconciler = cljs.core.get.call(null,map__100081__$1,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966));
var networking = cljs.core.get.call(null,map__100081__$1,new cljs.core.Keyword(null,"networking","networking",586110628));
var seq__100083 = cljs.core.seq.call(null,cljs.core.keys.call(null,send_queues));
var chunk__100084 = null;
var count__100085 = (0);
var i__100086 = (0);
while(true){
if((i__100086 < count__100085)){
var remote = cljs.core._nth.call(null,chunk__100084,i__100086);
var queue_100105 = cljs.core.get.call(null,send_queues,remote);
var network_100106 = cljs.core.get.call(null,networking,remote);
var parallel_payload_100107 = fulcro.client.impl.data_fetch.mark_parallel_loading.call(null,remote,reconciler);
var seq__100087_100108 = cljs.core.seq.call(null,parallel_payload_100107);
var chunk__100088_100109 = null;
var count__100089_100110 = (0);
var i__100090_100111 = (0);
while(true){
if((i__100090_100111 < count__100089_100110)){
var map__100091_100112 = cljs.core._nth.call(null,chunk__100088_100109,i__100090_100111);
var map__100091_100113__$1 = ((((!((map__100091_100112 == null)))?((((map__100091_100112.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__100091_100112.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__100091_100112):map__100091_100112);
var query_100114 = cljs.core.get.call(null,map__100091_100113__$1,new cljs.core.Keyword(null,"query","query",-1288509510));
var on_load_100115 = cljs.core.get.call(null,map__100091_100113__$1,new cljs.core.Keyword(null,"on-load","on-load",1415151594));
var on_error_100116 = cljs.core.get.call(null,map__100091_100113__$1,new cljs.core.Keyword(null,"on-error","on-error",1728533530));
var load_descriptors_100117 = cljs.core.get.call(null,map__100091_100113__$1,new cljs.core.Keyword(null,"load-descriptors","load-descriptors",391720681));
var on_load_SINGLEQUOTE__100119 = ((function (seq__100087_100108,chunk__100088_100109,count__100089_100110,i__100090_100111,seq__100083,chunk__100084,count__100085,i__100086,map__100091_100112,map__100091_100113__$1,query_100114,on_load_100115,on_error_100116,load_descriptors_100117,queue_100105,network_100106,parallel_payload_100107,remote,map__100081,map__100081__$1,send_queues,reconciler,networking){
return (function (p1__100078_SHARP_){
return on_load_100115.call(null,p1__100078_SHARP_,load_descriptors_100117);
});})(seq__100087_100108,chunk__100088_100109,count__100089_100110,i__100090_100111,seq__100083,chunk__100084,count__100085,i__100086,map__100091_100112,map__100091_100113__$1,query_100114,on_load_100115,on_error_100116,load_descriptors_100117,queue_100105,network_100106,parallel_payload_100107,remote,map__100081,map__100081__$1,send_queues,reconciler,networking))
;
var on_error_SINGLEQUOTE__100120 = ((function (seq__100087_100108,chunk__100088_100109,count__100089_100110,i__100090_100111,seq__100083,chunk__100084,count__100085,i__100086,on_load_SINGLEQUOTE__100119,map__100091_100112,map__100091_100113__$1,query_100114,on_load_100115,on_error_100116,load_descriptors_100117,queue_100105,network_100106,parallel_payload_100107,remote,map__100081,map__100081__$1,send_queues,reconciler,networking){
return (function (p1__100079_SHARP_){
return on_error_100116.call(null,p1__100079_SHARP_,load_descriptors_100117);
});})(seq__100087_100108,chunk__100088_100109,count__100089_100110,i__100090_100111,seq__100083,chunk__100084,count__100085,i__100086,on_load_SINGLEQUOTE__100119,map__100091_100112,map__100091_100113__$1,query_100114,on_load_100115,on_error_100116,load_descriptors_100117,queue_100105,network_100106,parallel_payload_100107,remote,map__100081,map__100081__$1,send_queues,reconciler,networking))
;
fulcro.client.impl.application.real_send.call(null,network_100106,query_100114,on_load_SINGLEQUOTE__100119,on_error_SINGLEQUOTE__100120,null);

var G__100127 = seq__100087_100108;
var G__100128 = chunk__100088_100109;
var G__100129 = count__100089_100110;
var G__100130 = (i__100090_100111 + (1));
seq__100087_100108 = G__100127;
chunk__100088_100109 = G__100128;
count__100089_100110 = G__100129;
i__100090_100111 = G__100130;
continue;
} else {
var temp__4657__auto___100131 = cljs.core.seq.call(null,seq__100087_100108);
if(temp__4657__auto___100131){
var seq__100087_100132__$1 = temp__4657__auto___100131;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__100087_100132__$1)){
var c__28980__auto___100133 = cljs.core.chunk_first.call(null,seq__100087_100132__$1);
var G__100134 = cljs.core.chunk_rest.call(null,seq__100087_100132__$1);
var G__100135 = c__28980__auto___100133;
var G__100136 = cljs.core.count.call(null,c__28980__auto___100133);
var G__100137 = (0);
seq__100087_100108 = G__100134;
chunk__100088_100109 = G__100135;
count__100089_100110 = G__100136;
i__100090_100111 = G__100137;
continue;
} else {
var map__100093_100138 = cljs.core.first.call(null,seq__100087_100132__$1);
var map__100093_100139__$1 = ((((!((map__100093_100138 == null)))?((((map__100093_100138.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__100093_100138.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__100093_100138):map__100093_100138);
var query_100140 = cljs.core.get.call(null,map__100093_100139__$1,new cljs.core.Keyword(null,"query","query",-1288509510));
var on_load_100141 = cljs.core.get.call(null,map__100093_100139__$1,new cljs.core.Keyword(null,"on-load","on-load",1415151594));
var on_error_100142 = cljs.core.get.call(null,map__100093_100139__$1,new cljs.core.Keyword(null,"on-error","on-error",1728533530));
var load_descriptors_100143 = cljs.core.get.call(null,map__100093_100139__$1,new cljs.core.Keyword(null,"load-descriptors","load-descriptors",391720681));
var on_load_SINGLEQUOTE__100145 = ((function (seq__100087_100108,chunk__100088_100109,count__100089_100110,i__100090_100111,seq__100083,chunk__100084,count__100085,i__100086,map__100093_100138,map__100093_100139__$1,query_100140,on_load_100141,on_error_100142,load_descriptors_100143,seq__100087_100132__$1,temp__4657__auto___100131,queue_100105,network_100106,parallel_payload_100107,remote,map__100081,map__100081__$1,send_queues,reconciler,networking){
return (function (p1__100078_SHARP_){
return on_load_100141.call(null,p1__100078_SHARP_,load_descriptors_100143);
});})(seq__100087_100108,chunk__100088_100109,count__100089_100110,i__100090_100111,seq__100083,chunk__100084,count__100085,i__100086,map__100093_100138,map__100093_100139__$1,query_100140,on_load_100141,on_error_100142,load_descriptors_100143,seq__100087_100132__$1,temp__4657__auto___100131,queue_100105,network_100106,parallel_payload_100107,remote,map__100081,map__100081__$1,send_queues,reconciler,networking))
;
var on_error_SINGLEQUOTE__100146 = ((function (seq__100087_100108,chunk__100088_100109,count__100089_100110,i__100090_100111,seq__100083,chunk__100084,count__100085,i__100086,on_load_SINGLEQUOTE__100145,map__100093_100138,map__100093_100139__$1,query_100140,on_load_100141,on_error_100142,load_descriptors_100143,seq__100087_100132__$1,temp__4657__auto___100131,queue_100105,network_100106,parallel_payload_100107,remote,map__100081,map__100081__$1,send_queues,reconciler,networking){
return (function (p1__100079_SHARP_){
return on_error_100142.call(null,p1__100079_SHARP_,load_descriptors_100143);
});})(seq__100087_100108,chunk__100088_100109,count__100089_100110,i__100090_100111,seq__100083,chunk__100084,count__100085,i__100086,on_load_SINGLEQUOTE__100145,map__100093_100138,map__100093_100139__$1,query_100140,on_load_100141,on_error_100142,load_descriptors_100143,seq__100087_100132__$1,temp__4657__auto___100131,queue_100105,network_100106,parallel_payload_100107,remote,map__100081,map__100081__$1,send_queues,reconciler,networking))
;
fulcro.client.impl.application.real_send.call(null,network_100106,query_100140,on_load_SINGLEQUOTE__100145,on_error_SINGLEQUOTE__100146,null);

var G__100148 = cljs.core.next.call(null,seq__100087_100132__$1);
var G__100149 = null;
var G__100150 = (0);
var G__100151 = (0);
seq__100087_100108 = G__100148;
chunk__100088_100109 = G__100149;
count__100089_100110 = G__100150;
i__100090_100111 = G__100151;
continue;
}
} else {
}
}
break;
}

var fetch_payload_100152 = fulcro.client.impl.data_fetch.mark_loading.call(null,remote,reconciler);
while(true){
if(cljs.core.truth_(fetch_payload_100152)){
fulcro.client.impl.application.enqueue.call(null,queue_100105,cljs.core.assoc.call(null,fetch_payload_100152,new cljs.core.Keyword(null,"networking","networking",586110628),network_100106));

var G__100153 = fulcro.client.impl.data_fetch.mark_loading.call(null,remote,reconciler);
fetch_payload_100152 = G__100153;
continue;
} else {
}
break;
}

var G__100154 = seq__100083;
var G__100155 = chunk__100084;
var G__100156 = count__100085;
var G__100157 = (i__100086 + (1));
seq__100083 = G__100154;
chunk__100084 = G__100155;
count__100085 = G__100156;
i__100086 = G__100157;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__100083);
if(temp__4657__auto__){
var seq__100083__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__100083__$1)){
var c__28980__auto__ = cljs.core.chunk_first.call(null,seq__100083__$1);
var G__100158 = cljs.core.chunk_rest.call(null,seq__100083__$1);
var G__100159 = c__28980__auto__;
var G__100160 = cljs.core.count.call(null,c__28980__auto__);
var G__100161 = (0);
seq__100083 = G__100158;
chunk__100084 = G__100159;
count__100085 = G__100160;
i__100086 = G__100161;
continue;
} else {
var remote = cljs.core.first.call(null,seq__100083__$1);
var queue_100162 = cljs.core.get.call(null,send_queues,remote);
var network_100163 = cljs.core.get.call(null,networking,remote);
var parallel_payload_100164 = fulcro.client.impl.data_fetch.mark_parallel_loading.call(null,remote,reconciler);
var seq__100095_100165 = cljs.core.seq.call(null,parallel_payload_100164);
var chunk__100096_100166 = null;
var count__100097_100167 = (0);
var i__100098_100168 = (0);
while(true){
if((i__100098_100168 < count__100097_100167)){
var map__100099_100169 = cljs.core._nth.call(null,chunk__100096_100166,i__100098_100168);
var map__100099_100170__$1 = ((((!((map__100099_100169 == null)))?((((map__100099_100169.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__100099_100169.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__100099_100169):map__100099_100169);
var query_100171 = cljs.core.get.call(null,map__100099_100170__$1,new cljs.core.Keyword(null,"query","query",-1288509510));
var on_load_100172 = cljs.core.get.call(null,map__100099_100170__$1,new cljs.core.Keyword(null,"on-load","on-load",1415151594));
var on_error_100173 = cljs.core.get.call(null,map__100099_100170__$1,new cljs.core.Keyword(null,"on-error","on-error",1728533530));
var load_descriptors_100174 = cljs.core.get.call(null,map__100099_100170__$1,new cljs.core.Keyword(null,"load-descriptors","load-descriptors",391720681));
var on_load_SINGLEQUOTE__100179 = ((function (seq__100095_100165,chunk__100096_100166,count__100097_100167,i__100098_100168,seq__100083,chunk__100084,count__100085,i__100086,map__100099_100169,map__100099_100170__$1,query_100171,on_load_100172,on_error_100173,load_descriptors_100174,queue_100162,network_100163,parallel_payload_100164,remote,seq__100083__$1,temp__4657__auto__,map__100081,map__100081__$1,send_queues,reconciler,networking){
return (function (p1__100078_SHARP_){
return on_load_100172.call(null,p1__100078_SHARP_,load_descriptors_100174);
});})(seq__100095_100165,chunk__100096_100166,count__100097_100167,i__100098_100168,seq__100083,chunk__100084,count__100085,i__100086,map__100099_100169,map__100099_100170__$1,query_100171,on_load_100172,on_error_100173,load_descriptors_100174,queue_100162,network_100163,parallel_payload_100164,remote,seq__100083__$1,temp__4657__auto__,map__100081,map__100081__$1,send_queues,reconciler,networking))
;
var on_error_SINGLEQUOTE__100180 = ((function (seq__100095_100165,chunk__100096_100166,count__100097_100167,i__100098_100168,seq__100083,chunk__100084,count__100085,i__100086,on_load_SINGLEQUOTE__100179,map__100099_100169,map__100099_100170__$1,query_100171,on_load_100172,on_error_100173,load_descriptors_100174,queue_100162,network_100163,parallel_payload_100164,remote,seq__100083__$1,temp__4657__auto__,map__100081,map__100081__$1,send_queues,reconciler,networking){
return (function (p1__100079_SHARP_){
return on_error_100173.call(null,p1__100079_SHARP_,load_descriptors_100174);
});})(seq__100095_100165,chunk__100096_100166,count__100097_100167,i__100098_100168,seq__100083,chunk__100084,count__100085,i__100086,on_load_SINGLEQUOTE__100179,map__100099_100169,map__100099_100170__$1,query_100171,on_load_100172,on_error_100173,load_descriptors_100174,queue_100162,network_100163,parallel_payload_100164,remote,seq__100083__$1,temp__4657__auto__,map__100081,map__100081__$1,send_queues,reconciler,networking))
;
fulcro.client.impl.application.real_send.call(null,network_100163,query_100171,on_load_SINGLEQUOTE__100179,on_error_SINGLEQUOTE__100180,null);

var G__100182 = seq__100095_100165;
var G__100183 = chunk__100096_100166;
var G__100184 = count__100097_100167;
var G__100185 = (i__100098_100168 + (1));
seq__100095_100165 = G__100182;
chunk__100096_100166 = G__100183;
count__100097_100167 = G__100184;
i__100098_100168 = G__100185;
continue;
} else {
var temp__4657__auto___100186__$1 = cljs.core.seq.call(null,seq__100095_100165);
if(temp__4657__auto___100186__$1){
var seq__100095_100187__$1 = temp__4657__auto___100186__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__100095_100187__$1)){
var c__28980__auto___100189 = cljs.core.chunk_first.call(null,seq__100095_100187__$1);
var G__100193 = cljs.core.chunk_rest.call(null,seq__100095_100187__$1);
var G__100194 = c__28980__auto___100189;
var G__100195 = cljs.core.count.call(null,c__28980__auto___100189);
var G__100196 = (0);
seq__100095_100165 = G__100193;
chunk__100096_100166 = G__100194;
count__100097_100167 = G__100195;
i__100098_100168 = G__100196;
continue;
} else {
var map__100101_100201 = cljs.core.first.call(null,seq__100095_100187__$1);
var map__100101_100202__$1 = ((((!((map__100101_100201 == null)))?((((map__100101_100201.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__100101_100201.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__100101_100201):map__100101_100201);
var query_100203 = cljs.core.get.call(null,map__100101_100202__$1,new cljs.core.Keyword(null,"query","query",-1288509510));
var on_load_100204 = cljs.core.get.call(null,map__100101_100202__$1,new cljs.core.Keyword(null,"on-load","on-load",1415151594));
var on_error_100205 = cljs.core.get.call(null,map__100101_100202__$1,new cljs.core.Keyword(null,"on-error","on-error",1728533530));
var load_descriptors_100206 = cljs.core.get.call(null,map__100101_100202__$1,new cljs.core.Keyword(null,"load-descriptors","load-descriptors",391720681));
var on_load_SINGLEQUOTE__100207 = ((function (seq__100095_100165,chunk__100096_100166,count__100097_100167,i__100098_100168,seq__100083,chunk__100084,count__100085,i__100086,map__100101_100201,map__100101_100202__$1,query_100203,on_load_100204,on_error_100205,load_descriptors_100206,seq__100095_100187__$1,temp__4657__auto___100186__$1,queue_100162,network_100163,parallel_payload_100164,remote,seq__100083__$1,temp__4657__auto__,map__100081,map__100081__$1,send_queues,reconciler,networking){
return (function (p1__100078_SHARP_){
return on_load_100204.call(null,p1__100078_SHARP_,load_descriptors_100206);
});})(seq__100095_100165,chunk__100096_100166,count__100097_100167,i__100098_100168,seq__100083,chunk__100084,count__100085,i__100086,map__100101_100201,map__100101_100202__$1,query_100203,on_load_100204,on_error_100205,load_descriptors_100206,seq__100095_100187__$1,temp__4657__auto___100186__$1,queue_100162,network_100163,parallel_payload_100164,remote,seq__100083__$1,temp__4657__auto__,map__100081,map__100081__$1,send_queues,reconciler,networking))
;
var on_error_SINGLEQUOTE__100208 = ((function (seq__100095_100165,chunk__100096_100166,count__100097_100167,i__100098_100168,seq__100083,chunk__100084,count__100085,i__100086,on_load_SINGLEQUOTE__100207,map__100101_100201,map__100101_100202__$1,query_100203,on_load_100204,on_error_100205,load_descriptors_100206,seq__100095_100187__$1,temp__4657__auto___100186__$1,queue_100162,network_100163,parallel_payload_100164,remote,seq__100083__$1,temp__4657__auto__,map__100081,map__100081__$1,send_queues,reconciler,networking){
return (function (p1__100079_SHARP_){
return on_error_100205.call(null,p1__100079_SHARP_,load_descriptors_100206);
});})(seq__100095_100165,chunk__100096_100166,count__100097_100167,i__100098_100168,seq__100083,chunk__100084,count__100085,i__100086,on_load_SINGLEQUOTE__100207,map__100101_100201,map__100101_100202__$1,query_100203,on_load_100204,on_error_100205,load_descriptors_100206,seq__100095_100187__$1,temp__4657__auto___100186__$1,queue_100162,network_100163,parallel_payload_100164,remote,seq__100083__$1,temp__4657__auto__,map__100081,map__100081__$1,send_queues,reconciler,networking))
;
fulcro.client.impl.application.real_send.call(null,network_100163,query_100203,on_load_SINGLEQUOTE__100207,on_error_SINGLEQUOTE__100208,null);

var G__100209 = cljs.core.next.call(null,seq__100095_100187__$1);
var G__100210 = null;
var G__100211 = (0);
var G__100212 = (0);
seq__100095_100165 = G__100209;
chunk__100096_100166 = G__100210;
count__100097_100167 = G__100211;
i__100098_100168 = G__100212;
continue;
}
} else {
}
}
break;
}

var fetch_payload_100214 = fulcro.client.impl.data_fetch.mark_loading.call(null,remote,reconciler);
while(true){
if(cljs.core.truth_(fetch_payload_100214)){
fulcro.client.impl.application.enqueue.call(null,queue_100162,cljs.core.assoc.call(null,fetch_payload_100214,new cljs.core.Keyword(null,"networking","networking",586110628),network_100163));

var G__100215 = fulcro.client.impl.data_fetch.mark_loading.call(null,remote,reconciler);
fetch_payload_100214 = G__100215;
continue;
} else {
}
break;
}

var G__100216 = cljs.core.next.call(null,seq__100083__$1);
var G__100217 = null;
var G__100218 = (0);
var G__100219 = (0);
seq__100083 = G__100216;
chunk__100084 = G__100217;
count__100085 = G__100218;
i__100086 = G__100219;
continue;
}
} else {
return null;
}
}
break;
}
});
fulcro.client.impl.application.detect_errant_remotes = (function fulcro$client$impl$application$detect_errant_remotes(p__100220){
var map__100221 = p__100220;
var map__100221__$1 = ((((!((map__100221 == null)))?((((map__100221.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__100221.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__100221):map__100221);
var app = map__100221__$1;
var reconciler = cljs.core.get.call(null,map__100221__$1,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966));
var send_queues = cljs.core.get.call(null,map__100221__$1,new cljs.core.Keyword(null,"send-queues","send-queues",-212336330));
var state = om.next.app_state.call(null,reconciler);
var all_items = cljs.core.get.call(null,cljs.core.deref.call(null,state),new cljs.core.Keyword("fulcro","ready-to-load","fulcro/ready-to-load",127104696));
var item_remotes = cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.map.call(null,fulcro.client.impl.data_fetch.data_remote,all_items));
var all_remotes = cljs.core.set.call(null,cljs.core.keys.call(null,send_queues));
var invalid_remotes = clojure.set.difference.call(null,item_remotes,all_remotes);
if(cljs.core.truth_(cljs.core.not_empty.call(null,invalid_remotes))){
return fulcro.client.logging.error.call(null,["Use of invalid remote(s) detected! ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(invalid_remotes)].join(''));
} else {
return null;
}
});
/**
 * Puts queries/mutations (and their corresponding callbacks) onto the send queue. The networking code will pull these
 *   off one at a time and send them through the real networking layer. Reads are guaranteed to *follow* writes.
 */
fulcro.client.impl.application.server_send = (function fulcro$client$impl$application$server_send(app,remote_tx_map,cb){
fulcro.client.impl.application.detect_errant_remotes.call(null,app);

fulcro.client.impl.application.enqueue_mutations.call(null,app,remote_tx_map,cb);

return fulcro.client.impl.application.enqueue_reads.call(null,app);
});
/**
 * Sends a network payload. There are two kinds of payloads in Fulcro. The first is
 *   for reads, which are tracked by load descriptors in the app state. These load descriptors
 *   tell the plumbing how to handle the response, and expect to only be merged in once. Mutations
 *   do not have a payload, and can technically received progress updates from the network. The built-in
 *   networking does not (currently) give progress events, but plugin networking can. It is currently not
 *   supported to give an update on a load, so this function is careful to detect that a payload is a send
 *   and turns all but the last update into a no-op. The send-complete function comes from the
 *   network sequential processing loop, and when called unblocks the network processing to allow the
 *   next request to go. Be very careful with this code, as bugs will cause applications to stop responding
 *   to remote requests.
 */
fulcro.client.impl.application.send_payload = (function fulcro$client$impl$application$send_payload(network,payload,send_complete){
var map__100228 = payload;
var map__100228__$1 = ((((!((map__100228 == null)))?((((map__100228.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__100228.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__100228):map__100228);
var query = cljs.core.get.call(null,map__100228__$1,new cljs.core.Keyword(null,"query","query",-1288509510));
var on_load = cljs.core.get.call(null,map__100228__$1,new cljs.core.Keyword(null,"on-load","on-load",1415151594));
var on_error = cljs.core.get.call(null,map__100228__$1,new cljs.core.Keyword(null,"on-error","on-error",1728533530));
var load_descriptors = cljs.core.get.call(null,map__100228__$1,new cljs.core.Keyword(null,"load-descriptors","load-descriptors",391720681));
var merge_data = (cljs.core.truth_(load_descriptors)?((function (map__100228,map__100228__$1,query,on_load,on_error,load_descriptors){
return (function (p1__100226_SHARP_){
return on_load.call(null,p1__100226_SHARP_,load_descriptors);
});})(map__100228,map__100228__$1,query,on_load,on_error,load_descriptors))
:on_load);
var on_update = (cljs.core.truth_(load_descriptors)?cljs.core.identity:merge_data);
var on_error__$1 = (cljs.core.truth_(load_descriptors)?((function (map__100228,map__100228__$1,query,on_load,on_error,load_descriptors,merge_data,on_update){
return (function (p1__100227_SHARP_){
return on_error.call(null,p1__100227_SHARP_,load_descriptors);
});})(map__100228,map__100228__$1,query,on_load,on_error,load_descriptors,merge_data,on_update))
:on_error);
var on_error__$2 = cljs.core.comp.call(null,send_complete,on_error__$1);
var on_done = cljs.core.comp.call(null,send_complete,merge_data);
return fulcro.client.impl.application.real_send.call(null,network,query,on_done,on_error__$2,on_update);
});
fulcro.client.impl.application.is_sequential_QMARK_ = (function fulcro$client$impl$application$is_sequential_QMARK_(network){
if(((!((network == null)))?(((false) || ((cljs.core.PROTOCOL_SENTINEL === network.fulcro$client$network$NetworkBehavior$)))?true:false):false)){
return fulcro.client.network.serialize_requests_QMARK_.call(null,network);
} else {
return true;
}
});
/**
 * Starts a async go loop that sends network requests on a networking object's request queue. Must be called once and only
 *   once for each active networking object on the UI. Each iteration of the loop pulls off a
 *   single request, sends it, waits for the response, and then repeats. Gives the appearance of a separate networking
 *   'thread' using core async.
 */
fulcro.client.impl.application.start_network_sequential_processing = (function fulcro$client$impl$application$start_network_sequential_processing(p__100242){
var map__100243 = p__100242;
var map__100243__$1 = ((((!((map__100243 == null)))?((((map__100243.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__100243.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__100243):map__100243);
var networking = cljs.core.get.call(null,map__100243__$1,new cljs.core.Keyword(null,"networking","networking",586110628));
var send_queues = cljs.core.get.call(null,map__100243__$1,new cljs.core.Keyword(null,"send-queues","send-queues",-212336330));
var response_channels = cljs.core.get.call(null,map__100243__$1,new cljs.core.Keyword(null,"response-channels","response-channels",-1871059128));
var seq__100245 = cljs.core.seq.call(null,cljs.core.keys.call(null,send_queues));
var chunk__100246 = null;
var count__100247 = (0);
var i__100248 = (0);
while(true){
if((i__100248 < count__100247)){
var remote = cljs.core._nth.call(null,chunk__100246,i__100248);
var queue_100353 = cljs.core.get.call(null,send_queues,remote);
var network_100354 = cljs.core.get.call(null,networking,remote);
var sequential_QMARK__100355 = fulcro.client.impl.application.is_sequential_QMARK_.call(null,network_100354);
var response_channel_100356 = cljs.core.get.call(null,response_channels,remote);
var send_complete_100357 = (cljs.core.truth_(sequential_QMARK__100355)?((function (seq__100245,chunk__100246,count__100247,i__100248,queue_100353,network_100354,sequential_QMARK__100355,response_channel_100356,remote,map__100243,map__100243__$1,networking,send_queues,response_channels){
return (function (){
var c__47173__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (seq__100245,chunk__100246,count__100247,i__100248,c__47173__auto__,queue_100353,network_100354,sequential_QMARK__100355,response_channel_100356,remote,map__100243,map__100243__$1,networking,send_queues,response_channels){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (seq__100245,chunk__100246,count__100247,i__100248,c__47173__auto__,queue_100353,network_100354,sequential_QMARK__100355,response_channel_100356,remote,map__100243,map__100243__$1,networking,send_queues,response_channels){
return (function (state_100254){
var state_val_100255 = (state_100254[(1)]);
if((state_val_100255 === (1))){
var state_100254__$1 = state_100254;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_100254__$1,(2),response_channel_100356,new cljs.core.Keyword(null,"complete","complete",-500388775));
} else {
if((state_val_100255 === (2))){
var inst_100251 = (state_100254[(2)]);
var state_100254__$1 = state_100254;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_100254__$1,inst_100251);
} else {
return null;
}
}
});})(seq__100245,chunk__100246,count__100247,i__100248,c__47173__auto__,queue_100353,network_100354,sequential_QMARK__100355,response_channel_100356,remote,map__100243,map__100243__$1,networking,send_queues,response_channels))
;
return ((function (seq__100245,chunk__100246,count__100247,i__100248,switch__47085__auto__,c__47173__auto__,queue_100353,network_100354,sequential_QMARK__100355,response_channel_100356,remote,map__100243,map__100243__$1,networking,send_queues,response_channels){
return (function() {
var fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto__ = null;
var fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto____0 = (function (){
var statearr_100256 = [null,null,null,null,null,null,null];
(statearr_100256[(0)] = fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto__);

(statearr_100256[(1)] = (1));

return statearr_100256;
});
var fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto____1 = (function (state_100254){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_100254);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e100257){if((e100257 instanceof Object)){
var ex__47089__auto__ = e100257;
var statearr_100258_100363 = state_100254;
(statearr_100258_100363[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_100254);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e100257;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__100364 = state_100254;
state_100254 = G__100364;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto__ = function(state_100254){
switch(arguments.length){
case 0:
return fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto____0.call(this);
case 1:
return fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto____1.call(this,state_100254);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto____0;
fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto____1;
return fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto__;
})()
;})(seq__100245,chunk__100246,count__100247,i__100248,switch__47085__auto__,c__47173__auto__,queue_100353,network_100354,sequential_QMARK__100355,response_channel_100356,remote,map__100243,map__100243__$1,networking,send_queues,response_channels))
})();
var state__47175__auto__ = (function (){var statearr_100259 = f__47174__auto__.call(null);
(statearr_100259[(6)] = c__47173__auto__);

return statearr_100259;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(seq__100245,chunk__100246,count__100247,i__100248,c__47173__auto__,queue_100353,network_100354,sequential_QMARK__100355,response_channel_100356,remote,map__100243,map__100243__$1,networking,send_queues,response_channels))
);

return c__47173__auto__;
});})(seq__100245,chunk__100246,count__100247,i__100248,queue_100353,network_100354,sequential_QMARK__100355,response_channel_100356,remote,map__100243,map__100243__$1,networking,send_queues,response_channels))
:cljs.core.identity);
var c__47173__auto___100365 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (seq__100245,chunk__100246,count__100247,i__100248,c__47173__auto___100365,queue_100353,network_100354,sequential_QMARK__100355,response_channel_100356,send_complete_100357,remote,map__100243,map__100243__$1,networking,send_queues,response_channels){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (seq__100245,chunk__100246,count__100247,i__100248,c__47173__auto___100365,queue_100353,network_100354,sequential_QMARK__100355,response_channel_100356,send_complete_100357,remote,map__100243,map__100243__$1,networking,send_queues,response_channels){
return (function (state_100279){
var state_val_100280 = (state_100279[(1)]);
if((state_val_100280 === (1))){
var state_100279__$1 = state_100279;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_100279__$1,(2),queue_100353);
} else {
if((state_val_100280 === (2))){
var inst_100261 = (state_100279[(2)]);
var inst_100262 = inst_100261;
var state_100279__$1 = (function (){var statearr_100281 = state_100279;
(statearr_100281[(7)] = inst_100262);

return statearr_100281;
})();
var statearr_100282_100366 = state_100279__$1;
(statearr_100282_100366[(2)] = null);

(statearr_100282_100366[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100280 === (3))){
var inst_100262 = (state_100279[(7)]);
var inst_100264 = fulcro.client.impl.application.send_payload.call(null,network_100354,inst_100262,send_complete_100357);
var state_100279__$1 = (function (){var statearr_100283 = state_100279;
(statearr_100283[(8)] = inst_100264);

return statearr_100283;
})();
if(cljs.core.truth_(sequential_QMARK__100355)){
var statearr_100284_100367 = state_100279__$1;
(statearr_100284_100367[(1)] = (5));

} else {
var statearr_100285_100368 = state_100279__$1;
(statearr_100285_100368[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100280 === (4))){
var inst_100277 = (state_100279[(2)]);
var state_100279__$1 = state_100279;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_100279__$1,inst_100277);
} else {
if((state_val_100280 === (5))){
var state_100279__$1 = state_100279;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_100279__$1,(8),response_channel_100356);
} else {
if((state_val_100280 === (6))){
var state_100279__$1 = state_100279;
var statearr_100286_100369 = state_100279__$1;
(statearr_100286_100369[(2)] = null);

(statearr_100286_100369[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100280 === (7))){
var inst_100271 = (state_100279[(2)]);
var state_100279__$1 = (function (){var statearr_100287 = state_100279;
(statearr_100287[(9)] = inst_100271);

return statearr_100287;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_100279__$1,(9),queue_100353);
} else {
if((state_val_100280 === (8))){
var inst_100268 = (state_100279[(2)]);
var state_100279__$1 = state_100279;
var statearr_100288_100370 = state_100279__$1;
(statearr_100288_100370[(2)] = inst_100268);

(statearr_100288_100370[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100280 === (9))){
var inst_100274 = (state_100279[(2)]);
var inst_100262 = inst_100274;
var state_100279__$1 = (function (){var statearr_100294 = state_100279;
(statearr_100294[(7)] = inst_100262);

return statearr_100294;
})();
var statearr_100295_100371 = state_100279__$1;
(statearr_100295_100371[(2)] = null);

(statearr_100295_100371[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(seq__100245,chunk__100246,count__100247,i__100248,c__47173__auto___100365,queue_100353,network_100354,sequential_QMARK__100355,response_channel_100356,send_complete_100357,remote,map__100243,map__100243__$1,networking,send_queues,response_channels))
;
return ((function (seq__100245,chunk__100246,count__100247,i__100248,switch__47085__auto__,c__47173__auto___100365,queue_100353,network_100354,sequential_QMARK__100355,response_channel_100356,send_complete_100357,remote,map__100243,map__100243__$1,networking,send_queues,response_channels){
return (function() {
var fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto__ = null;
var fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto____0 = (function (){
var statearr_100296 = [null,null,null,null,null,null,null,null,null,null];
(statearr_100296[(0)] = fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto__);

(statearr_100296[(1)] = (1));

return statearr_100296;
});
var fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto____1 = (function (state_100279){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_100279);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e100297){if((e100297 instanceof Object)){
var ex__47089__auto__ = e100297;
var statearr_100298_100372 = state_100279;
(statearr_100298_100372[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_100279);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e100297;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__100373 = state_100279;
state_100279 = G__100373;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto__ = function(state_100279){
switch(arguments.length){
case 0:
return fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto____0.call(this);
case 1:
return fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto____1.call(this,state_100279);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto____0;
fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto____1;
return fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto__;
})()
;})(seq__100245,chunk__100246,count__100247,i__100248,switch__47085__auto__,c__47173__auto___100365,queue_100353,network_100354,sequential_QMARK__100355,response_channel_100356,send_complete_100357,remote,map__100243,map__100243__$1,networking,send_queues,response_channels))
})();
var state__47175__auto__ = (function (){var statearr_100299 = f__47174__auto__.call(null);
(statearr_100299[(6)] = c__47173__auto___100365);

return statearr_100299;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(seq__100245,chunk__100246,count__100247,i__100248,c__47173__auto___100365,queue_100353,network_100354,sequential_QMARK__100355,response_channel_100356,send_complete_100357,remote,map__100243,map__100243__$1,networking,send_queues,response_channels))
);


var G__100374 = seq__100245;
var G__100375 = chunk__100246;
var G__100376 = count__100247;
var G__100377 = (i__100248 + (1));
seq__100245 = G__100374;
chunk__100246 = G__100375;
count__100247 = G__100376;
i__100248 = G__100377;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__100245);
if(temp__4657__auto__){
var seq__100245__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__100245__$1)){
var c__28980__auto__ = cljs.core.chunk_first.call(null,seq__100245__$1);
var G__100378 = cljs.core.chunk_rest.call(null,seq__100245__$1);
var G__100379 = c__28980__auto__;
var G__100380 = cljs.core.count.call(null,c__28980__auto__);
var G__100381 = (0);
seq__100245 = G__100378;
chunk__100246 = G__100379;
count__100247 = G__100380;
i__100248 = G__100381;
continue;
} else {
var remote = cljs.core.first.call(null,seq__100245__$1);
var queue_100382 = cljs.core.get.call(null,send_queues,remote);
var network_100383 = cljs.core.get.call(null,networking,remote);
var sequential_QMARK__100384 = fulcro.client.impl.application.is_sequential_QMARK_.call(null,network_100383);
var response_channel_100385 = cljs.core.get.call(null,response_channels,remote);
var send_complete_100386 = (cljs.core.truth_(sequential_QMARK__100384)?((function (seq__100245,chunk__100246,count__100247,i__100248,queue_100382,network_100383,sequential_QMARK__100384,response_channel_100385,remote,seq__100245__$1,temp__4657__auto__,map__100243,map__100243__$1,networking,send_queues,response_channels){
return (function (){
var c__47173__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (seq__100245,chunk__100246,count__100247,i__100248,c__47173__auto__,queue_100382,network_100383,sequential_QMARK__100384,response_channel_100385,remote,seq__100245__$1,temp__4657__auto__,map__100243,map__100243__$1,networking,send_queues,response_channels){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (seq__100245,chunk__100246,count__100247,i__100248,c__47173__auto__,queue_100382,network_100383,sequential_QMARK__100384,response_channel_100385,remote,seq__100245__$1,temp__4657__auto__,map__100243,map__100243__$1,networking,send_queues,response_channels){
return (function (state_100303){
var state_val_100304 = (state_100303[(1)]);
if((state_val_100304 === (1))){
var state_100303__$1 = state_100303;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_100303__$1,(2),response_channel_100385,new cljs.core.Keyword(null,"complete","complete",-500388775));
} else {
if((state_val_100304 === (2))){
var inst_100301 = (state_100303[(2)]);
var state_100303__$1 = state_100303;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_100303__$1,inst_100301);
} else {
return null;
}
}
});})(seq__100245,chunk__100246,count__100247,i__100248,c__47173__auto__,queue_100382,network_100383,sequential_QMARK__100384,response_channel_100385,remote,seq__100245__$1,temp__4657__auto__,map__100243,map__100243__$1,networking,send_queues,response_channels))
;
return ((function (seq__100245,chunk__100246,count__100247,i__100248,switch__47085__auto__,c__47173__auto__,queue_100382,network_100383,sequential_QMARK__100384,response_channel_100385,remote,seq__100245__$1,temp__4657__auto__,map__100243,map__100243__$1,networking,send_queues,response_channels){
return (function() {
var fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto__ = null;
var fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto____0 = (function (){
var statearr_100305 = [null,null,null,null,null,null,null];
(statearr_100305[(0)] = fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto__);

(statearr_100305[(1)] = (1));

return statearr_100305;
});
var fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto____1 = (function (state_100303){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_100303);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e100306){if((e100306 instanceof Object)){
var ex__47089__auto__ = e100306;
var statearr_100307_100387 = state_100303;
(statearr_100307_100387[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_100303);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e100306;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__100388 = state_100303;
state_100303 = G__100388;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto__ = function(state_100303){
switch(arguments.length){
case 0:
return fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto____0.call(this);
case 1:
return fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto____1.call(this,state_100303);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto____0;
fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto____1;
return fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto__;
})()
;})(seq__100245,chunk__100246,count__100247,i__100248,switch__47085__auto__,c__47173__auto__,queue_100382,network_100383,sequential_QMARK__100384,response_channel_100385,remote,seq__100245__$1,temp__4657__auto__,map__100243,map__100243__$1,networking,send_queues,response_channels))
})();
var state__47175__auto__ = (function (){var statearr_100308 = f__47174__auto__.call(null);
(statearr_100308[(6)] = c__47173__auto__);

return statearr_100308;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(seq__100245,chunk__100246,count__100247,i__100248,c__47173__auto__,queue_100382,network_100383,sequential_QMARK__100384,response_channel_100385,remote,seq__100245__$1,temp__4657__auto__,map__100243,map__100243__$1,networking,send_queues,response_channels))
);

return c__47173__auto__;
});})(seq__100245,chunk__100246,count__100247,i__100248,queue_100382,network_100383,sequential_QMARK__100384,response_channel_100385,remote,seq__100245__$1,temp__4657__auto__,map__100243,map__100243__$1,networking,send_queues,response_channels))
:cljs.core.identity);
var c__47173__auto___100389 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (seq__100245,chunk__100246,count__100247,i__100248,c__47173__auto___100389,queue_100382,network_100383,sequential_QMARK__100384,response_channel_100385,send_complete_100386,remote,seq__100245__$1,temp__4657__auto__,map__100243,map__100243__$1,networking,send_queues,response_channels){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (seq__100245,chunk__100246,count__100247,i__100248,c__47173__auto___100389,queue_100382,network_100383,sequential_QMARK__100384,response_channel_100385,send_complete_100386,remote,seq__100245__$1,temp__4657__auto__,map__100243,map__100243__$1,networking,send_queues,response_channels){
return (function (state_100326){
var state_val_100327 = (state_100326[(1)]);
if((state_val_100327 === (1))){
var state_100326__$1 = state_100326;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_100326__$1,(2),queue_100382);
} else {
if((state_val_100327 === (2))){
var inst_100310 = (state_100326[(2)]);
var inst_100311 = inst_100310;
var state_100326__$1 = (function (){var statearr_100331 = state_100326;
(statearr_100331[(7)] = inst_100311);

return statearr_100331;
})();
var statearr_100332_100390 = state_100326__$1;
(statearr_100332_100390[(2)] = null);

(statearr_100332_100390[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100327 === (3))){
var inst_100311 = (state_100326[(7)]);
var inst_100313 = fulcro.client.impl.application.send_payload.call(null,network_100383,inst_100311,send_complete_100386);
var state_100326__$1 = (function (){var statearr_100335 = state_100326;
(statearr_100335[(8)] = inst_100313);

return statearr_100335;
})();
if(cljs.core.truth_(sequential_QMARK__100384)){
var statearr_100336_100391 = state_100326__$1;
(statearr_100336_100391[(1)] = (5));

} else {
var statearr_100337_100392 = state_100326__$1;
(statearr_100337_100392[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100327 === (4))){
var inst_100324 = (state_100326[(2)]);
var state_100326__$1 = state_100326;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_100326__$1,inst_100324);
} else {
if((state_val_100327 === (5))){
var state_100326__$1 = state_100326;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_100326__$1,(8),response_channel_100385);
} else {
if((state_val_100327 === (6))){
var state_100326__$1 = state_100326;
var statearr_100338_100393 = state_100326__$1;
(statearr_100338_100393[(2)] = null);

(statearr_100338_100393[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100327 === (7))){
var inst_100319 = (state_100326[(2)]);
var state_100326__$1 = (function (){var statearr_100339 = state_100326;
(statearr_100339[(9)] = inst_100319);

return statearr_100339;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_100326__$1,(9),queue_100382);
} else {
if((state_val_100327 === (8))){
var inst_100316 = (state_100326[(2)]);
var state_100326__$1 = state_100326;
var statearr_100340_100395 = state_100326__$1;
(statearr_100340_100395[(2)] = inst_100316);

(statearr_100340_100395[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_100327 === (9))){
var inst_100321 = (state_100326[(2)]);
var inst_100311 = inst_100321;
var state_100326__$1 = (function (){var statearr_100341 = state_100326;
(statearr_100341[(7)] = inst_100311);

return statearr_100341;
})();
var statearr_100342_100396 = state_100326__$1;
(statearr_100342_100396[(2)] = null);

(statearr_100342_100396[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(seq__100245,chunk__100246,count__100247,i__100248,c__47173__auto___100389,queue_100382,network_100383,sequential_QMARK__100384,response_channel_100385,send_complete_100386,remote,seq__100245__$1,temp__4657__auto__,map__100243,map__100243__$1,networking,send_queues,response_channels))
;
return ((function (seq__100245,chunk__100246,count__100247,i__100248,switch__47085__auto__,c__47173__auto___100389,queue_100382,network_100383,sequential_QMARK__100384,response_channel_100385,send_complete_100386,remote,seq__100245__$1,temp__4657__auto__,map__100243,map__100243__$1,networking,send_queues,response_channels){
return (function() {
var fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto__ = null;
var fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto____0 = (function (){
var statearr_100343 = [null,null,null,null,null,null,null,null,null,null];
(statearr_100343[(0)] = fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto__);

(statearr_100343[(1)] = (1));

return statearr_100343;
});
var fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto____1 = (function (state_100326){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_100326);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e100344){if((e100344 instanceof Object)){
var ex__47089__auto__ = e100344;
var statearr_100345_100403 = state_100326;
(statearr_100345_100403[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_100326);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e100344;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__100404 = state_100326;
state_100326 = G__100404;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto__ = function(state_100326){
switch(arguments.length){
case 0:
return fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto____0.call(this);
case 1:
return fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto____1.call(this,state_100326);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto____0;
fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto____1;
return fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__47086__auto__;
})()
;})(seq__100245,chunk__100246,count__100247,i__100248,switch__47085__auto__,c__47173__auto___100389,queue_100382,network_100383,sequential_QMARK__100384,response_channel_100385,send_complete_100386,remote,seq__100245__$1,temp__4657__auto__,map__100243,map__100243__$1,networking,send_queues,response_channels))
})();
var state__47175__auto__ = (function (){var statearr_100346 = f__47174__auto__.call(null);
(statearr_100346[(6)] = c__47173__auto___100389);

return statearr_100346;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(seq__100245,chunk__100246,count__100247,i__100248,c__47173__auto___100389,queue_100382,network_100383,sequential_QMARK__100384,response_channel_100385,send_complete_100386,remote,seq__100245__$1,temp__4657__auto__,map__100243,map__100243__$1,networking,send_queues,response_channels))
);


var G__100405 = cljs.core.next.call(null,seq__100245__$1);
var G__100406 = null;
var G__100407 = (0);
var G__100408 = (0);
seq__100245 = G__100405;
chunk__100246 = G__100406;
count__100247 = G__100407;
i__100248 = G__100408;
continue;
}
} else {
return null;
}
}
break;
}
});
/**
 * Configure a re-render when the locale changes and also when the translations arrive from a module load.
 * During startup this function will be called once for each reconciler that is running on a page.
 */
fulcro.client.impl.application.initialize_internationalization = (function fulcro$client$impl$application$initialize_internationalization(reconciler){
var re_render = (function fulcro$client$impl$application$initialize_internationalization_$_re_render(k,r,o,n){
if(om.next.mounted_QMARK_.call(null,om.next.app_root.call(null,reconciler))){
fulcro.client.logging.debug.call(null,"Forcing a UI refresh on locale change.");

return fulcro.client.util.force_render.call(null,reconciler);
} else {
return null;
}
});
cljs.core.remove_watch.call(null,fulcro.i18n._STAR_current_locale_STAR_,new cljs.core.Keyword(null,"locale","locale",-2115712697));

cljs.core.add_watch.call(null,fulcro.i18n._STAR_loaded_translations_STAR_,new cljs.core.Keyword(null,"locale","locale",-2115712697),re_render);

return cljs.core.add_watch.call(null,fulcro.i18n._STAR_current_locale_STAR_,new cljs.core.Keyword(null,"locale","locale",-2115712697),re_render);
});
/**
 * Remove not-found keys from m (non-recursive)
 */
fulcro.client.impl.application.sweep_one = (function fulcro$client$impl$application$sweep_one(m){
if(cljs.core.map_QMARK_.call(null,m)){
return cljs.core.reduce.call(null,(function (acc,p__100414){
var vec__100415 = p__100414;
var k = cljs.core.nth.call(null,vec__100415,(0),null);
var v = cljs.core.nth.call(null,vec__100415,(1),null);
if((cljs.core._EQ_.call(null,new cljs.core.Keyword("fulcro.client.impl.om-plumbing","not-found","fulcro.client.impl.om-plumbing/not-found",-315197951),k)) || (cljs.core._EQ_.call(null,new cljs.core.Keyword("fulcro.client.impl.om-plumbing","not-found","fulcro.client.impl.om-plumbing/not-found",-315197951),v))){
return acc;
} else {
return cljs.core.assoc.call(null,acc,k,v);
}
}),cljs.core.with_meta.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.meta.call(null,m)),m);
} else {
if(cljs.core.vector_QMARK_.call(null,m)){
return cljs.core.with_meta.call(null,cljs.core.mapv.call(null,fulcro.client.impl.application.sweep_one,m),cljs.core.meta.call(null,m));
} else {
return m;

}
}
});
/**
 * Remove all of the not-found keys (recursively) from v, stopping at marked leaves (if present)
 */
fulcro.client.impl.application.sweep = (function fulcro$client$impl$application$sweep(m){
if(cljs.core.truth_(fulcro.client.impl.om_plumbing.leaf_QMARK_.call(null,m))){
return fulcro.client.impl.application.sweep_one.call(null,m);
} else {
if(cljs.core.map_QMARK_.call(null,m)){
return cljs.core.reduce.call(null,(function (acc,p__100424){
var vec__100425 = p__100424;
var k = cljs.core.nth.call(null,vec__100425,(0),null);
var v = cljs.core.nth.call(null,vec__100425,(1),null);
if((cljs.core._EQ_.call(null,new cljs.core.Keyword("fulcro.client.impl.om-plumbing","not-found","fulcro.client.impl.om-plumbing/not-found",-315197951),k)) || (cljs.core._EQ_.call(null,new cljs.core.Keyword("fulcro.client.impl.om-plumbing","not-found","fulcro.client.impl.om-plumbing/not-found",-315197951),v))){
return acc;
} else {
if((om.util.ident_QMARK_.call(null,v)) && (cljs.core._EQ_.call(null,new cljs.core.Keyword("fulcro.client.impl.om-plumbing","not-found","fulcro.client.impl.om-plumbing/not-found",-315197951),cljs.core.second.call(null,v)))){
return acc;
} else {
return cljs.core.assoc.call(null,acc,k,fulcro.client.impl.application.sweep.call(null,v));

}
}
}),cljs.core.with_meta.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.meta.call(null,m)),m);
} else {
if(cljs.core.vector_QMARK_.call(null,m)){
return cljs.core.with_meta.call(null,cljs.core.mapv.call(null,fulcro.client.impl.application.sweep,m),cljs.core.meta.call(null,m));
} else {
return m;

}
}
}
});
/**
 * Do a recursive merge of source into target, but remove any target data that is marked as missing in the response. The
 *   missing marker is generated in the source when something has been asked for in the query, but had no value in the
 *   response. This allows us to correctly remove 'empty' data from the database without accidentally removing something
 *   that may still exist on the server (in truth we don't know its status, since it wasn't asked for, but we leave
 *   it as our 'best guess')
 */
fulcro.client.impl.application.sweep_merge = (function fulcro$client$impl$application$sweep_merge(target,source){
return cljs.core.reduce.call(null,(function (acc,p__100428){
var vec__100429 = p__100428;
var key = cljs.core.nth.call(null,vec__100429,(0),null);
var new_value = cljs.core.nth.call(null,vec__100429,(1),null);
var existing_value = cljs.core.get.call(null,acc,key);
if(cljs.core._EQ_.call(null,key,new cljs.core.Keyword("fulcro.client.impl.om-plumbing","not-found","fulcro.client.impl.om-plumbing/not-found",-315197951))){
return acc;
} else {
if(cljs.core._EQ_.call(null,new_value,new cljs.core.Keyword("fulcro.client.impl.om-plumbing","not-found","fulcro.client.impl.om-plumbing/not-found",-315197951))){
return cljs.core.dissoc.call(null,acc,key);
} else {
if((om.util.ident_QMARK_.call(null,new_value)) && (cljs.core._EQ_.call(null,new cljs.core.Keyword("fulcro.client.impl.om-plumbing","not-found","fulcro.client.impl.om-plumbing/not-found",-315197951),cljs.core.second.call(null,new_value)))){
return acc;
} else {
if(cljs.core.truth_(fulcro.client.impl.om_plumbing.leaf_QMARK_.call(null,new_value))){
return cljs.core.assoc.call(null,acc,key,fulcro.client.impl.application.sweep_one.call(null,new_value));
} else {
if((cljs.core.map_QMARK_.call(null,existing_value)) && (cljs.core.map_QMARK_.call(null,new_value))){
return cljs.core.update.call(null,acc,key,fulcro.client.impl.application.sweep_merge,new_value);
} else {
return cljs.core.assoc.call(null,acc,key,fulcro.client.impl.application.sweep.call(null,new_value));

}
}
}
}
}
}),target,source);
});
fulcro.client.impl.application.merge_handler = (function fulcro$client$impl$application$merge_handler(mutation_merge,target,source){
var source_to_merge = cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.filter.call(null,(function (p__100432){
var vec__100433 = p__100432;
var k = cljs.core.nth.call(null,vec__100433,(0),null);
var _ = cljs.core.nth.call(null,vec__100433,(1),null);
return !((k instanceof cljs.core.Symbol));
}),source));
var merged_state = fulcro.client.impl.application.sweep_merge.call(null,target,source_to_merge);
return cljs.core.reduce.call(null,((function (source_to_merge,merged_state){
return (function (acc,p__100436){
var vec__100437 = p__100436;
var k = cljs.core.nth.call(null,vec__100437,(0),null);
var v = cljs.core.nth.call(null,vec__100437,(1),null);
if(cljs.core.truth_((function (){var and__28129__auto__ = mutation_merge;
if(cljs.core.truth_(and__28129__auto__)){
return (k instanceof cljs.core.Symbol);
} else {
return and__28129__auto__;
}
})())){
var temp__4655__auto__ = mutation_merge.call(null,acc,k,cljs.core.dissoc.call(null,v,new cljs.core.Keyword(null,"tempids","tempids",1767509089)));
if(cljs.core.truth_(temp__4655__auto__)){
var updated_state = temp__4655__auto__;
return updated_state;
} else {
fulcro.client.logging.info.call(null,"Return value handler for",k,"returned nil. Ignored.");

return acc;
}
} else {
return acc;
}
});})(source_to_merge,merged_state))
,merged_state,source);
});
/**
 * The reconciler's send method calls FulcroApplication/server-send, which itself requires a reconciler with a
 *   send method already defined. This creates a catch-22 / circular dependency on the reconciler and :send field within
 *   the reconciler.
 * 
 *   To resolve the issue, we def an atom pointing to the reconciler that the send method will deref each time it is
 *   called. This allows us to define the reconciler with a send method that, at the time of initialization, has an app
 *   that points to a nil reconciler. By the end of this function, the app's reconciler reference has been properly set.
 */
fulcro.client.impl.application.generate_reconciler = (function fulcro$client$impl$application$generate_reconciler(p__100440,initial_state,parser,p__100441){
var map__100442 = p__100440;
var map__100442__$1 = ((((!((map__100442 == null)))?((((map__100442.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__100442.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__100442):map__100442);
var app = map__100442__$1;
var send_queues = cljs.core.get.call(null,map__100442__$1,new cljs.core.Keyword(null,"send-queues","send-queues",-212336330));
var mutation_merge = cljs.core.get.call(null,map__100442__$1,new cljs.core.Keyword(null,"mutation-merge","mutation-merge",-2131743322));
var map__100443 = p__100441;
var map__100443__$1 = ((((!((map__100443 == null)))?((((map__100443.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__100443.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__100443):map__100443);
var reconciler_options = map__100443__$1;
var migrate = cljs.core.get.call(null,map__100443__$1,new cljs.core.Keyword(null,"migrate","migrate",-207110743));
var rec_atom = cljs.core.atom.call(null,null);
var remotes = cljs.core.keys.call(null,send_queues);
var tempid_migrate = ((function (rec_atom,remotes,map__100442,map__100442__$1,app,send_queues,mutation_merge,map__100443,map__100443__$1,reconciler_options,migrate){
return (function (pure,_,tempids,___$1){
var seq__100446_100450 = cljs.core.seq.call(null,cljs.core.vals.call(null,send_queues));
var chunk__100447_100451 = null;
var count__100448_100452 = (0);
var i__100449_100453 = (0);
while(true){
if((i__100449_100453 < count__100448_100452)){
var queue_100454 = cljs.core._nth.call(null,chunk__100447_100451,i__100449_100453);
fulcro.client.impl.om_plumbing.rewrite_tempids_in_request_queue.call(null,queue_100454,tempids);

var G__100455 = seq__100446_100450;
var G__100456 = chunk__100447_100451;
var G__100457 = count__100448_100452;
var G__100458 = (i__100449_100453 + (1));
seq__100446_100450 = G__100455;
chunk__100447_100451 = G__100456;
count__100448_100452 = G__100457;
i__100449_100453 = G__100458;
continue;
} else {
var temp__4657__auto___100459 = cljs.core.seq.call(null,seq__100446_100450);
if(temp__4657__auto___100459){
var seq__100446_100460__$1 = temp__4657__auto___100459;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__100446_100460__$1)){
var c__28980__auto___100461 = cljs.core.chunk_first.call(null,seq__100446_100460__$1);
var G__100462 = cljs.core.chunk_rest.call(null,seq__100446_100460__$1);
var G__100463 = c__28980__auto___100461;
var G__100464 = cljs.core.count.call(null,c__28980__auto___100461);
var G__100465 = (0);
seq__100446_100450 = G__100462;
chunk__100447_100451 = G__100463;
count__100448_100452 = G__100464;
i__100449_100453 = G__100465;
continue;
} else {
var queue_100466 = cljs.core.first.call(null,seq__100446_100460__$1);
fulcro.client.impl.om_plumbing.rewrite_tempids_in_request_queue.call(null,queue_100466,tempids);

var G__100467 = cljs.core.next.call(null,seq__100446_100460__$1);
var G__100468 = null;
var G__100469 = (0);
var G__100470 = (0);
seq__100446_100450 = G__100467;
chunk__100447_100451 = G__100468;
count__100448_100452 = G__100469;
i__100449_100453 = G__100470;
continue;
}
} else {
}
}
break;
}

var state_migrate = (function (){var or__28141__auto__ = migrate;
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
return fulcro.client.impl.om_plumbing.resolve_tempids;
}
})();
return state_migrate.call(null,pure,tempids);
});})(rec_atom,remotes,map__100442,map__100442__$1,app,send_queues,mutation_merge,map__100443,map__100443__$1,reconciler_options,migrate))
;
var initial_state_with_locale = (function (){var set_default_locale = ((function (rec_atom,remotes,tempid_migrate,map__100442,map__100442__$1,app,send_queues,mutation_merge,map__100443,map__100443__$1,reconciler_options,migrate){
return (function (s){
return cljs.core.update.call(null,s,new cljs.core.Keyword("ui","locale","ui/locale",-2115717461),cljs.core.fnil.call(null,cljs.core.identity,new cljs.core.Keyword(null,"en","en",88457073)));
});})(rec_atom,remotes,tempid_migrate,map__100442,map__100442__$1,app,send_queues,mutation_merge,map__100443,map__100443__$1,reconciler_options,migrate))
;
var is_atom_QMARK_ = fulcro.client.util.atom_QMARK_.call(null,initial_state);
var incoming_locale = cljs.core.get.call(null,(cljs.core.truth_(is_atom_QMARK_)?cljs.core.deref.call(null,initial_state):initial_state),new cljs.core.Keyword("ui","locale","ui/locale",-2115717461));
if(cljs.core.truth_(incoming_locale)){
cljs.core.reset_BANG_.call(null,fulcro.i18n._STAR_current_locale_STAR_,incoming_locale);
} else {
}

if(cljs.core.truth_(is_atom_QMARK_)){
cljs.core.swap_BANG_.call(null,initial_state,set_default_locale);

return initial_state;
} else {
return set_default_locale.call(null,initial_state);
}
})();
var config = cljs.core.merge.call(null,cljs.core.PersistentArrayMap.EMPTY,reconciler_options,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"migrate","migrate",-207110743),tempid_migrate,new cljs.core.Keyword(null,"state","state",-1988618099),initial_state_with_locale,new cljs.core.Keyword(null,"send","send",-652151114),((function (rec_atom,remotes,tempid_migrate,initial_state_with_locale,map__100442,map__100442__$1,app,send_queues,mutation_merge,map__100443,map__100443__$1,reconciler_options,migrate){
return (function (tx,cb){
return fulcro.client.impl.application.server_send.call(null,cljs.core.assoc.call(null,app,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966),cljs.core.deref.call(null,rec_atom)),tx,cb);
});})(rec_atom,remotes,tempid_migrate,initial_state_with_locale,map__100442,map__100442__$1,app,send_queues,mutation_merge,map__100443,map__100443__$1,reconciler_options,migrate))
,new cljs.core.Keyword(null,"normalize","normalize",-1904390051),true,new cljs.core.Keyword(null,"remotes","remotes",1132366312),remotes,new cljs.core.Keyword(null,"merge-ident","merge-ident",1040841862),((function (rec_atom,remotes,tempid_migrate,initial_state_with_locale,map__100442,map__100442__$1,app,send_queues,mutation_merge,map__100443,map__100443__$1,reconciler_options,migrate){
return (function (reconciler,app_state,ident,props){
return cljs.core.update_in.call(null,app_state,ident,cljs.core.comp.call(null,fulcro.client.impl.application.sweep_one,cljs.core.merge),props);
});})(rec_atom,remotes,tempid_migrate,initial_state_with_locale,map__100442,map__100442__$1,app,send_queues,mutation_merge,map__100443,map__100443__$1,reconciler_options,migrate))
,new cljs.core.Keyword(null,"merge-tree","merge-tree",-127861161),((function (rec_atom,remotes,tempid_migrate,initial_state_with_locale,map__100442,map__100442__$1,app,send_queues,mutation_merge,map__100443,map__100443__$1,reconciler_options,migrate){
return (function (target,source){
return fulcro.client.impl.application.merge_handler.call(null,mutation_merge,target,source);
});})(rec_atom,remotes,tempid_migrate,initial_state_with_locale,map__100442,map__100442__$1,app,send_queues,mutation_merge,map__100443,map__100443__$1,reconciler_options,migrate))
,new cljs.core.Keyword(null,"parser","parser",-1543495310),parser], null));
var rec = om.next.reconciler.call(null,config);
cljs.core.reset_BANG_.call(null,rec_atom,rec);

return rec;
});
fulcro.client.impl.application.initialize_global_error_callbacks = (function fulcro$client$impl$application$initialize_global_error_callbacks(app){
var seq__100472 = cljs.core.seq.call(null,cljs.core.keys.call(null,new cljs.core.Keyword(null,"networking","networking",586110628).cljs$core$IFn$_invoke$arity$1(app)));
var chunk__100473 = null;
var count__100474 = (0);
var i__100475 = (0);
while(true){
if((i__100475 < count__100474)){
var remote = cljs.core._nth.call(null,chunk__100473,i__100475);
var cb_atom_100476 = cljs.core.get_in.call(null,app,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"networking","networking",586110628),remote,new cljs.core.Keyword(null,"global-error-callback","global-error-callback",901427631)], null));
if(cljs.core.truth_(fulcro.client.util.atom_QMARK_.call(null,cb_atom_100476))){
cljs.core.swap_BANG_.call(null,cb_atom_100476,((function (seq__100472,chunk__100473,count__100474,i__100475,cb_atom_100476,remote){
return (function (p1__100471_SHARP_){
if(cljs.core.fn_QMARK_.call(null,p1__100471_SHARP_)){
return cljs.core.partial.call(null,p1__100471_SHARP_,om.next.app_state.call(null,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966).cljs$core$IFn$_invoke$arity$1(app)));
} else {
throw cljs.core.ex_info.call(null,"Networking error callback must be a function.",cljs.core.PersistentArrayMap.EMPTY);
}
});})(seq__100472,chunk__100473,count__100474,i__100475,cb_atom_100476,remote))
);
} else {
}

var G__100477 = seq__100472;
var G__100478 = chunk__100473;
var G__100479 = count__100474;
var G__100480 = (i__100475 + (1));
seq__100472 = G__100477;
chunk__100473 = G__100478;
count__100474 = G__100479;
i__100475 = G__100480;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__100472);
if(temp__4657__auto__){
var seq__100472__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__100472__$1)){
var c__28980__auto__ = cljs.core.chunk_first.call(null,seq__100472__$1);
var G__100481 = cljs.core.chunk_rest.call(null,seq__100472__$1);
var G__100482 = c__28980__auto__;
var G__100483 = cljs.core.count.call(null,c__28980__auto__);
var G__100484 = (0);
seq__100472 = G__100481;
chunk__100473 = G__100482;
count__100474 = G__100483;
i__100475 = G__100484;
continue;
} else {
var remote = cljs.core.first.call(null,seq__100472__$1);
var cb_atom_100485 = cljs.core.get_in.call(null,app,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"networking","networking",586110628),remote,new cljs.core.Keyword(null,"global-error-callback","global-error-callback",901427631)], null));
if(cljs.core.truth_(fulcro.client.util.atom_QMARK_.call(null,cb_atom_100485))){
cljs.core.swap_BANG_.call(null,cb_atom_100485,((function (seq__100472,chunk__100473,count__100474,i__100475,cb_atom_100485,remote,seq__100472__$1,temp__4657__auto__){
return (function (p1__100471_SHARP_){
if(cljs.core.fn_QMARK_.call(null,p1__100471_SHARP_)){
return cljs.core.partial.call(null,p1__100471_SHARP_,om.next.app_state.call(null,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966).cljs$core$IFn$_invoke$arity$1(app)));
} else {
throw cljs.core.ex_info.call(null,"Networking error callback must be a function.",cljs.core.PersistentArrayMap.EMPTY);
}
});})(seq__100472,chunk__100473,count__100474,i__100475,cb_atom_100485,remote,seq__100472__$1,temp__4657__auto__))
);
} else {
}

var G__100486 = cljs.core.next.call(null,seq__100472__$1);
var G__100487 = null;
var G__100488 = (0);
var G__100489 = (0);
seq__100472 = G__100486;
chunk__100473 = G__100487;
count__100474 = G__100488;
i__100475 = G__100489;
continue;
}
} else {
return null;
}
}
break;
}
});

//# sourceMappingURL=application.js.map?rel=1511404599613
