// Compiled by ClojureScript 1.9.946 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('figwheel.client.utils');
goog.require('goog.Uri');
goog.require('goog.string');
goog.require('goog.object');
goog.require('goog.net.jsloader');
goog.require('goog.html.legacyconversions');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.core.async');
goog.require('goog.async.Deferred');
if(typeof figwheel.client.file_reloading.figwheel_meta_pragmas !== 'undefined'){
} else {
figwheel.client.file_reloading.figwheel_meta_pragmas = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.on_cssload_custom_event = (function figwheel$client$file_reloading$on_cssload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.css-reload",files);
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__28141__auto__ = (cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && (((new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) == null)) || (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string')) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372)));
if(or__28141__auto__){
return or__28141__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.name__GT_path = (function figwheel$client$file_reloading$name__GT_path(ns){

return goog.object.get(goog.dependencies_.nameToPath,ns);
});
figwheel.client.file_reloading.provided_QMARK_ = (function figwheel$client$file_reloading$provided_QMARK_(ns){
return goog.object.get(goog.dependencies_.written,figwheel.client.file_reloading.name__GT_path.call(null,ns));
});
figwheel.client.file_reloading.immutable_ns_QMARK_ = (function figwheel$client$file_reloading$immutable_ns_QMARK_(name){
var or__28141__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, ["cljs.nodejs",null,"goog",null,"cljs.core",null], null), null).call(null,name);
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
var or__28141__auto____$1 = goog.string.startsWith("clojure.",name);
if(cljs.core.truth_(or__28141__auto____$1)){
return or__28141__auto____$1;
} else {
return goog.string.startsWith("goog.",name);
}
}
});
figwheel.client.file_reloading.get_requires = (function figwheel$client$file_reloading$get_requires(ns){
return cljs.core.set.call(null,cljs.core.filter.call(null,(function (p1__88040_SHARP_){
return cljs.core.not.call(null,figwheel.client.file_reloading.immutable_ns_QMARK_.call(null,p1__88040_SHARP_));
}),goog.object.getKeys(goog.object.get(goog.dependencies_.requires,figwheel.client.file_reloading.name__GT_path.call(null,ns)))));
});
if(typeof figwheel.client.file_reloading.dependency_data !== 'undefined'){
} else {
figwheel.client.file_reloading.dependency_data = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"dependents","dependents",136812837),cljs.core.PersistentArrayMap.EMPTY], null));
}
figwheel.client.file_reloading.path_to_name_BANG_ = (function figwheel$client$file_reloading$path_to_name_BANG_(path,name){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([name]));
});
/**
 * Setup a path to name dependencies map.
 * That goes from path -> #{ ns-names }
 */
figwheel.client.file_reloading.setup_path__GT_name_BANG_ = (function figwheel$client$file_reloading$setup_path__GT_name_BANG_(){
var nameToPath = goog.object.filter(goog.dependencies_.nameToPath,(function (v,k,o){
return goog.string.startsWith(v,"../");
}));
return goog.object.forEach(nameToPath,((function (nameToPath){
return (function (v,k,o){
return figwheel.client.file_reloading.path_to_name_BANG_.call(null,v,k);
});})(nameToPath))
);
});
/**
 * returns a set of namespaces defined by a path
 */
figwheel.client.file_reloading.path__GT_name = (function figwheel$client$file_reloading$path__GT_name(path){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null));
});
figwheel.client.file_reloading.name_to_parent_BANG_ = (function figwheel$client$file_reloading$name_to_parent_BANG_(ns,parent_ns){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([parent_ns]));
});
/**
 * This reverses the goog.dependencies_.requires for looking up ns-dependents.
 */
figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_ = (function figwheel$client$file_reloading$setup_ns__GT_dependents_BANG_(){
var requires = goog.object.filter(goog.dependencies_.requires,(function (v,k,o){
return goog.string.startsWith(k,"../");
}));
return goog.object.forEach(requires,((function (requires){
return (function (v,k,_){
return goog.object.forEach(v,((function (requires){
return (function (v_SINGLEQUOTE_,k_SINGLEQUOTE_,___$1){
var seq__88069 = cljs.core.seq.call(null,figwheel.client.file_reloading.path__GT_name.call(null,k));
var chunk__88070 = null;
var count__88071 = (0);
var i__88072 = (0);
while(true){
if((i__88072 < count__88071)){
var n = cljs.core._nth.call(null,chunk__88070,i__88072);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__88088 = seq__88069;
var G__88089 = chunk__88070;
var G__88090 = count__88071;
var G__88091 = (i__88072 + (1));
seq__88069 = G__88088;
chunk__88070 = G__88089;
count__88071 = G__88090;
i__88072 = G__88091;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__88069);
if(temp__4657__auto__){
var seq__88069__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__88069__$1)){
var c__28980__auto__ = cljs.core.chunk_first.call(null,seq__88069__$1);
var G__88093 = cljs.core.chunk_rest.call(null,seq__88069__$1);
var G__88094 = c__28980__auto__;
var G__88095 = cljs.core.count.call(null,c__28980__auto__);
var G__88096 = (0);
seq__88069 = G__88093;
chunk__88070 = G__88094;
count__88071 = G__88095;
i__88072 = G__88096;
continue;
} else {
var n = cljs.core.first.call(null,seq__88069__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__88097 = cljs.core.next.call(null,seq__88069__$1);
var G__88098 = null;
var G__88099 = (0);
var G__88100 = (0);
seq__88069 = G__88097;
chunk__88070 = G__88098;
count__88071 = G__88099;
i__88072 = G__88100;
continue;
}
} else {
return null;
}
}
break;
}
});})(requires))
);
});})(requires))
);
});
figwheel.client.file_reloading.ns__GT_dependents = (function figwheel$client$file_reloading$ns__GT_dependents(ns){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null));
});
figwheel.client.file_reloading.build_topo_sort = (function figwheel$client$file_reloading$build_topo_sort(get_deps){
var get_deps__$1 = cljs.core.memoize.call(null,get_deps);
var topo_sort_helper_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_topo_sort_helper_STAR_(x,depth,state){
var deps = get_deps__$1.call(null,x);
if(cljs.core.empty_QMARK_.call(null,deps)){
return null;
} else {
return topo_sort_STAR_.call(null,deps,depth,state);
}
});})(get_deps__$1))
;
var topo_sort_STAR_ = ((function (get_deps__$1){
return (function() {
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = null;
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1 = (function (deps){
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.call(null,deps,(0),cljs.core.atom.call(null,cljs.core.sorted_map.call(null)));
});
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3 = (function (deps,depth,state){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [depth], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),deps);

var seq__88123_88132 = cljs.core.seq.call(null,deps);
var chunk__88124_88133 = null;
var count__88125_88134 = (0);
var i__88126_88135 = (0);
while(true){
if((i__88126_88135 < count__88125_88134)){
var dep_88136 = cljs.core._nth.call(null,chunk__88124_88133,i__88126_88135);
topo_sort_helper_STAR_.call(null,dep_88136,(depth + (1)),state);

var G__88137 = seq__88123_88132;
var G__88138 = chunk__88124_88133;
var G__88139 = count__88125_88134;
var G__88140 = (i__88126_88135 + (1));
seq__88123_88132 = G__88137;
chunk__88124_88133 = G__88138;
count__88125_88134 = G__88139;
i__88126_88135 = G__88140;
continue;
} else {
var temp__4657__auto___88141 = cljs.core.seq.call(null,seq__88123_88132);
if(temp__4657__auto___88141){
var seq__88123_88145__$1 = temp__4657__auto___88141;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__88123_88145__$1)){
var c__28980__auto___88146 = cljs.core.chunk_first.call(null,seq__88123_88145__$1);
var G__88147 = cljs.core.chunk_rest.call(null,seq__88123_88145__$1);
var G__88148 = c__28980__auto___88146;
var G__88149 = cljs.core.count.call(null,c__28980__auto___88146);
var G__88150 = (0);
seq__88123_88132 = G__88147;
chunk__88124_88133 = G__88148;
count__88125_88134 = G__88149;
i__88126_88135 = G__88150;
continue;
} else {
var dep_88151 = cljs.core.first.call(null,seq__88123_88145__$1);
topo_sort_helper_STAR_.call(null,dep_88151,(depth + (1)),state);

var G__88152 = cljs.core.next.call(null,seq__88123_88145__$1);
var G__88153 = null;
var G__88154 = (0);
var G__88155 = (0);
seq__88123_88132 = G__88152;
chunk__88124_88133 = G__88153;
count__88125_88134 = G__88154;
i__88126_88135 = G__88155;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,depth,(0))){
return elim_dups_STAR_.call(null,cljs.core.reverse.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,state))));
} else {
return null;
}
});
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = function(deps,depth,state){
switch(arguments.length){
case 1:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1.call(this,deps);
case 3:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3.call(this,deps,depth,state);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1;
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$3 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3;
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_;
})()
;})(get_deps__$1))
;
var elim_dups_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_(p__88128){
var vec__88129 = p__88128;
var seq__88130 = cljs.core.seq.call(null,vec__88129);
var first__88131 = cljs.core.first.call(null,seq__88130);
var seq__88130__$1 = cljs.core.next.call(null,seq__88130);
var x = first__88131;
var xs = seq__88130__$1;
if((x == null)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.cons.call(null,x,figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_.call(null,cljs.core.map.call(null,((function (vec__88129,seq__88130,first__88131,seq__88130__$1,x,xs,get_deps__$1){
return (function (p1__88101_SHARP_){
return clojure.set.difference.call(null,p1__88101_SHARP_,x);
});})(vec__88129,seq__88130,first__88131,seq__88130__$1,x,xs,get_deps__$1))
,xs)));
}
});})(get_deps__$1))
;
return topo_sort_STAR_;
});
figwheel.client.file_reloading.get_all_dependencies = (function figwheel$client$file_reloading$get_all_dependencies(ns){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.get_requires);
return cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns], null))));
});
figwheel.client.file_reloading.get_all_dependents = (function figwheel$client$file_reloading$get_all_dependents(nss){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.ns__GT_dependents);
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,figwheel.client.file_reloading.immutable_ns_QMARK_),cljs.core.reverse.call(null,cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,nss)))));
});
figwheel.client.file_reloading.unprovide_BANG_ = (function figwheel$client$file_reloading$unprovide_BANG_(ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.dependencies_.visited,path);

goog.object.remove(goog.dependencies_.written,path);

return goog.object.remove(goog.dependencies_.written,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(path)].join(''));
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_reloading.name__GT_path.call(null,ns))].join('');
});
figwheel.client.file_reloading.addDependency = (function figwheel$client$file_reloading$addDependency(path,provides,requires){
var seq__88160 = cljs.core.seq.call(null,provides);
var chunk__88161 = null;
var count__88162 = (0);
var i__88163 = (0);
while(true){
if((i__88163 < count__88162)){
var prov = cljs.core._nth.call(null,chunk__88161,i__88163);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__88164_88172 = cljs.core.seq.call(null,requires);
var chunk__88165_88173 = null;
var count__88166_88174 = (0);
var i__88167_88175 = (0);
while(true){
if((i__88167_88175 < count__88166_88174)){
var req_88176 = cljs.core._nth.call(null,chunk__88165_88173,i__88167_88175);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_88176,prov);

var G__88177 = seq__88164_88172;
var G__88178 = chunk__88165_88173;
var G__88179 = count__88166_88174;
var G__88180 = (i__88167_88175 + (1));
seq__88164_88172 = G__88177;
chunk__88165_88173 = G__88178;
count__88166_88174 = G__88179;
i__88167_88175 = G__88180;
continue;
} else {
var temp__4657__auto___88184 = cljs.core.seq.call(null,seq__88164_88172);
if(temp__4657__auto___88184){
var seq__88164_88185__$1 = temp__4657__auto___88184;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__88164_88185__$1)){
var c__28980__auto___88186 = cljs.core.chunk_first.call(null,seq__88164_88185__$1);
var G__88187 = cljs.core.chunk_rest.call(null,seq__88164_88185__$1);
var G__88188 = c__28980__auto___88186;
var G__88189 = cljs.core.count.call(null,c__28980__auto___88186);
var G__88190 = (0);
seq__88164_88172 = G__88187;
chunk__88165_88173 = G__88188;
count__88166_88174 = G__88189;
i__88167_88175 = G__88190;
continue;
} else {
var req_88191 = cljs.core.first.call(null,seq__88164_88185__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_88191,prov);

var G__88192 = cljs.core.next.call(null,seq__88164_88185__$1);
var G__88193 = null;
var G__88194 = (0);
var G__88195 = (0);
seq__88164_88172 = G__88192;
chunk__88165_88173 = G__88193;
count__88166_88174 = G__88194;
i__88167_88175 = G__88195;
continue;
}
} else {
}
}
break;
}

var G__88196 = seq__88160;
var G__88197 = chunk__88161;
var G__88198 = count__88162;
var G__88199 = (i__88163 + (1));
seq__88160 = G__88196;
chunk__88161 = G__88197;
count__88162 = G__88198;
i__88163 = G__88199;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__88160);
if(temp__4657__auto__){
var seq__88160__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__88160__$1)){
var c__28980__auto__ = cljs.core.chunk_first.call(null,seq__88160__$1);
var G__88200 = cljs.core.chunk_rest.call(null,seq__88160__$1);
var G__88201 = c__28980__auto__;
var G__88202 = cljs.core.count.call(null,c__28980__auto__);
var G__88203 = (0);
seq__88160 = G__88200;
chunk__88161 = G__88201;
count__88162 = G__88202;
i__88163 = G__88203;
continue;
} else {
var prov = cljs.core.first.call(null,seq__88160__$1);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__88168_88204 = cljs.core.seq.call(null,requires);
var chunk__88169_88205 = null;
var count__88170_88206 = (0);
var i__88171_88207 = (0);
while(true){
if((i__88171_88207 < count__88170_88206)){
var req_88208 = cljs.core._nth.call(null,chunk__88169_88205,i__88171_88207);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_88208,prov);

var G__88209 = seq__88168_88204;
var G__88210 = chunk__88169_88205;
var G__88211 = count__88170_88206;
var G__88212 = (i__88171_88207 + (1));
seq__88168_88204 = G__88209;
chunk__88169_88205 = G__88210;
count__88170_88206 = G__88211;
i__88171_88207 = G__88212;
continue;
} else {
var temp__4657__auto___88213__$1 = cljs.core.seq.call(null,seq__88168_88204);
if(temp__4657__auto___88213__$1){
var seq__88168_88214__$1 = temp__4657__auto___88213__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__88168_88214__$1)){
var c__28980__auto___88215 = cljs.core.chunk_first.call(null,seq__88168_88214__$1);
var G__88216 = cljs.core.chunk_rest.call(null,seq__88168_88214__$1);
var G__88217 = c__28980__auto___88215;
var G__88218 = cljs.core.count.call(null,c__28980__auto___88215);
var G__88219 = (0);
seq__88168_88204 = G__88216;
chunk__88169_88205 = G__88217;
count__88170_88206 = G__88218;
i__88171_88207 = G__88219;
continue;
} else {
var req_88224 = cljs.core.first.call(null,seq__88168_88214__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_88224,prov);

var G__88225 = cljs.core.next.call(null,seq__88168_88214__$1);
var G__88226 = null;
var G__88227 = (0);
var G__88228 = (0);
seq__88168_88204 = G__88225;
chunk__88169_88205 = G__88226;
count__88170_88206 = G__88227;
i__88171_88207 = G__88228;
continue;
}
} else {
}
}
break;
}

var G__88230 = cljs.core.next.call(null,seq__88160__$1);
var G__88231 = null;
var G__88232 = (0);
var G__88233 = (0);
seq__88160 = G__88230;
chunk__88161 = G__88231;
count__88162 = G__88232;
i__88163 = G__88233;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.file_reloading.figwheel_require = (function figwheel$client$file_reloading$figwheel_require(src,reload){
goog.require = figwheel.client.file_reloading.figwheel_require;

if(cljs.core._EQ_.call(null,reload,"reload-all")){
var seq__88234_88239 = cljs.core.seq.call(null,figwheel.client.file_reloading.get_all_dependencies.call(null,src));
var chunk__88235_88240 = null;
var count__88236_88241 = (0);
var i__88237_88242 = (0);
while(true){
if((i__88237_88242 < count__88236_88241)){
var ns_88243 = cljs.core._nth.call(null,chunk__88235_88240,i__88237_88242);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_88243);

var G__88244 = seq__88234_88239;
var G__88245 = chunk__88235_88240;
var G__88246 = count__88236_88241;
var G__88247 = (i__88237_88242 + (1));
seq__88234_88239 = G__88244;
chunk__88235_88240 = G__88245;
count__88236_88241 = G__88246;
i__88237_88242 = G__88247;
continue;
} else {
var temp__4657__auto___88248 = cljs.core.seq.call(null,seq__88234_88239);
if(temp__4657__auto___88248){
var seq__88234_88249__$1 = temp__4657__auto___88248;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__88234_88249__$1)){
var c__28980__auto___88250 = cljs.core.chunk_first.call(null,seq__88234_88249__$1);
var G__88251 = cljs.core.chunk_rest.call(null,seq__88234_88249__$1);
var G__88252 = c__28980__auto___88250;
var G__88253 = cljs.core.count.call(null,c__28980__auto___88250);
var G__88254 = (0);
seq__88234_88239 = G__88251;
chunk__88235_88240 = G__88252;
count__88236_88241 = G__88253;
i__88237_88242 = G__88254;
continue;
} else {
var ns_88255 = cljs.core.first.call(null,seq__88234_88249__$1);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_88255);

var G__88256 = cljs.core.next.call(null,seq__88234_88249__$1);
var G__88257 = null;
var G__88258 = (0);
var G__88259 = (0);
seq__88234_88239 = G__88256;
chunk__88235_88240 = G__88257;
count__88236_88241 = G__88258;
i__88237_88242 = G__88259;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(reload)){
figwheel.client.file_reloading.unprovide_BANG_.call(null,src);
} else {
}

return goog.require_figwheel_backup_(src);
});
/**
 * Reusable browser REPL bootstrapping. Patches the essential functions
 *   in goog.base to support re-loading of namespaces after page load.
 */
figwheel.client.file_reloading.bootstrap_goog_base = (function figwheel$client$file_reloading$bootstrap_goog_base(){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
goog.require_figwheel_backup_ = (function (){var or__28141__auto__ = goog.require__;
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
return goog.require;
}
})();

goog.isProvided_ = (function (name){
return false;
});

figwheel.client.file_reloading.setup_path__GT_name_BANG_.call(null);

figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_.call(null);

goog.addDependency_figwheel_backup_ = goog.addDependency;

goog.addDependency = (function() { 
var G__88263__delegate = function (args){
cljs.core.apply.call(null,figwheel.client.file_reloading.addDependency,args);

return cljs.core.apply.call(null,goog.addDependency_figwheel_backup_,args);
};
var G__88263 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__88264__i = 0, G__88264__a = new Array(arguments.length -  0);
while (G__88264__i < G__88264__a.length) {G__88264__a[G__88264__i] = arguments[G__88264__i + 0]; ++G__88264__i;}
  args = new cljs.core.IndexedSeq(G__88264__a,0,null);
} 
return G__88263__delegate.call(this,args);};
G__88263.cljs$lang$maxFixedArity = 0;
G__88263.cljs$lang$applyTo = (function (arglist__88265){
var args = cljs.core.seq(arglist__88265);
return G__88263__delegate(args);
});
G__88263.cljs$core$IFn$_invoke$arity$variadic = G__88263__delegate;
return G__88263;
})()
;

goog.constructNamespace_("cljs.user");

goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.queued_file_reload;

return goog.require = figwheel.client.file_reloading.figwheel_require;
}
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
if(typeof figwheel.client.file_reloading.bootstrapped_cljs !== 'undefined'){
return null;
} else {
return (
figwheel.client.file_reloading.bootstrapped_cljs = (function (){
figwheel.client.file_reloading.bootstrap_goog_base.call(null);

return true;
})()
)
;
}
});
figwheel.client.file_reloading.gloader = ((typeof goog.net.jsloader.safeLoad !== 'undefined')?(function (p1__88266_SHARP_,p2__88267_SHARP_){
return goog.net.jsloader.safeLoad(goog.html.legacyconversions.trustedResourceUrlFromString([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__88266_SHARP_)].join('')),p2__88267_SHARP_);
}):((typeof goog.net.jsloader.load !== 'undefined')?(function (p1__88268_SHARP_,p2__88269_SHARP_){
return goog.net.jsloader.load([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__88268_SHARP_)].join(''),p2__88269_SHARP_);
}):(function(){throw cljs.core.ex_info.call(null,"No remote script loading function found.",cljs.core.PersistentArrayMap.EMPTY)})()
));
figwheel.client.file_reloading.reload_file_in_html_env = (function figwheel$client$file_reloading$reload_file_in_html_env(request_url,callback){

var G__88270 = figwheel.client.file_reloading.gloader.call(null,figwheel.client.file_reloading.add_cache_buster.call(null,request_url),({"cleanupWhenDone": true}));
G__88270.addCallback(((function (G__88270){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(G__88270))
);

G__88270.addErrback(((function (G__88270){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(G__88270))
);

return G__88270;
});
figwheel.client.file_reloading.reload_file_STAR_ = (function (){var pred__88272 = cljs.core._EQ_;
var expr__88273 = figwheel.client.utils.host_env_QMARK_.call(null);
if(cljs.core.truth_(pred__88272.call(null,new cljs.core.Keyword(null,"node","node",581201198),expr__88273))){
var node_path_lib = require("path");
var util_pattern = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_path_lib.sep),cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_path_lib.join("goog","bootstrap","nodejs.js"))].join('');
var util_path = goog.object.findKey(require.cache,((function (node_path_lib,util_pattern,pred__88272,expr__88273){
return (function (v,k,o){
return goog.string.endsWith(k,util_pattern);
});})(node_path_lib,util_pattern,pred__88272,expr__88273))
);
var parts = cljs.core.pop.call(null,cljs.core.pop.call(null,clojure.string.split.call(null,util_path,/[\/\\]/)));
var root_path = clojure.string.join.call(null,node_path_lib.sep,parts);
return ((function (node_path_lib,util_pattern,util_path,parts,root_path,pred__88272,expr__88273){
return (function (request_url,callback){

var cache_path = node_path_lib.resolve(root_path,request_url);
goog.object.remove(require.cache,cache_path);

return callback.call(null,(function (){try{return require(cache_path);
}catch (e88277){if((e88277 instanceof Error)){
var e = e88277;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cache_path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e88277;

}
}})());
});
;})(node_path_lib,util_pattern,util_path,parts,root_path,pred__88272,expr__88273))
} else {
if(cljs.core.truth_(pred__88272.call(null,new cljs.core.Keyword(null,"html","html",-998796897),expr__88273))){
return figwheel.client.file_reloading.reload_file_in_html_env;
} else {
if(cljs.core.truth_(pred__88272.call(null,new cljs.core.Keyword(null,"react-native","react-native",-1543085138),expr__88273))){
return figwheel.client.file_reloading.reload_file_in_html_env;
} else {
if(cljs.core.truth_(pred__88272.call(null,new cljs.core.Keyword(null,"worker","worker",938239996),expr__88273))){
return ((function (pred__88272,expr__88273){
return (function (request_url,callback){

return callback.call(null,(function (){try{self.importScripts(figwheel.client.file_reloading.add_cache_buster.call(null,request_url));

return true;
}catch (e88281){if((e88281 instanceof Error)){
var e = e88281;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e88281;

}
}})());
});
;})(pred__88272,expr__88273))
} else {
return ((function (pred__88272,expr__88273){
return (function (a,b){
throw "Reload not defined for this platform";
});
;})(pred__88272,expr__88273))
}
}
}
}
})();
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__88297,callback){
var map__88298 = p__88297;
var map__88298__$1 = ((((!((map__88298 == null)))?((((map__88298.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__88298.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__88298):map__88298);
var file_msg = map__88298__$1;
var request_url = cljs.core.get.call(null,map__88298__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,["FigWheel: Attempting to load ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return figwheel.client.file_reloading.reload_file_STAR_.call(null,request_url,((function (map__88298,map__88298__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,["FigWheel: Successfully loaded ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__88298,map__88298__$1,file_msg,request_url))
);
});
if(typeof figwheel.client.file_reloading.reload_chan !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_chan = cljs.core.async.chan.call(null);
}
if(typeof figwheel.client.file_reloading.on_load_callbacks !== 'undefined'){
} else {
figwheel.client.file_reloading.on_load_callbacks = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if(typeof figwheel.client.file_reloading.dependencies_loaded !== 'undefined'){
} else {
figwheel.client.file_reloading.dependencies_loaded = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
figwheel.client.file_reloading.blocking_load = (function figwheel$client$file_reloading$blocking_load(url){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.reload_file.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-url","request-url",2100346596),url], null),((function (out){
return (function (file_msg){
cljs.core.async.put_BANG_.call(null,out,file_msg);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
if(typeof figwheel.client.file_reloading.reloader_loop !== 'undefined'){
} else {
figwheel.client.file_reloading.reloader_loop = (function (){var c__47173__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto__){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto__){
return (function (state_88366){
var state_val_88367 = (state_88366[(1)]);
if((state_val_88367 === (7))){
var inst_88362 = (state_88366[(2)]);
var state_88366__$1 = state_88366;
var statearr_88369_88390 = state_88366__$1;
(statearr_88369_88390[(2)] = inst_88362);

(statearr_88369_88390[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88367 === (1))){
var state_88366__$1 = state_88366;
var statearr_88370_88394 = state_88366__$1;
(statearr_88370_88394[(2)] = null);

(statearr_88370_88394[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88367 === (4))){
var inst_88346 = (state_88366[(7)]);
var inst_88346__$1 = (state_88366[(2)]);
var state_88366__$1 = (function (){var statearr_88371 = state_88366;
(statearr_88371[(7)] = inst_88346__$1);

return statearr_88371;
})();
if(cljs.core.truth_(inst_88346__$1)){
var statearr_88372_88399 = state_88366__$1;
(statearr_88372_88399[(1)] = (5));

} else {
var statearr_88373_88400 = state_88366__$1;
(statearr_88373_88400[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88367 === (6))){
var state_88366__$1 = state_88366;
var statearr_88374_88401 = state_88366__$1;
(statearr_88374_88401[(2)] = null);

(statearr_88374_88401[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88367 === (3))){
var inst_88364 = (state_88366[(2)]);
var state_88366__$1 = state_88366;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_88366__$1,inst_88364);
} else {
if((state_val_88367 === (2))){
var state_88366__$1 = state_88366;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_88366__$1,(4),figwheel.client.file_reloading.reload_chan);
} else {
if((state_val_88367 === (11))){
var inst_88358 = (state_88366[(2)]);
var state_88366__$1 = (function (){var statearr_88375 = state_88366;
(statearr_88375[(8)] = inst_88358);

return statearr_88375;
})();
var statearr_88376_88403 = state_88366__$1;
(statearr_88376_88403[(2)] = null);

(statearr_88376_88403[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88367 === (9))){
var inst_88350 = (state_88366[(9)]);
var inst_88352 = (state_88366[(10)]);
var inst_88354 = inst_88352.call(null,inst_88350);
var state_88366__$1 = state_88366;
var statearr_88377_88407 = state_88366__$1;
(statearr_88377_88407[(2)] = inst_88354);

(statearr_88377_88407[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88367 === (5))){
var inst_88346 = (state_88366[(7)]);
var inst_88348 = figwheel.client.file_reloading.blocking_load.call(null,inst_88346);
var state_88366__$1 = state_88366;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_88366__$1,(8),inst_88348);
} else {
if((state_val_88367 === (10))){
var inst_88350 = (state_88366[(9)]);
var inst_88356 = cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,cljs.core.conj,inst_88350);
var state_88366__$1 = state_88366;
var statearr_88378_88408 = state_88366__$1;
(statearr_88378_88408[(2)] = inst_88356);

(statearr_88378_88408[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88367 === (8))){
var inst_88346 = (state_88366[(7)]);
var inst_88352 = (state_88366[(10)]);
var inst_88350 = (state_88366[(2)]);
var inst_88351 = cljs.core.deref.call(null,figwheel.client.file_reloading.on_load_callbacks);
var inst_88352__$1 = cljs.core.get.call(null,inst_88351,inst_88346);
var state_88366__$1 = (function (){var statearr_88379 = state_88366;
(statearr_88379[(9)] = inst_88350);

(statearr_88379[(10)] = inst_88352__$1);

return statearr_88379;
})();
if(cljs.core.truth_(inst_88352__$1)){
var statearr_88380_88412 = state_88366__$1;
(statearr_88380_88412[(1)] = (9));

} else {
var statearr_88381_88413 = state_88366__$1;
(statearr_88381_88413[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__47173__auto__))
;
return ((function (switch__47085__auto__,c__47173__auto__){
return (function() {
var figwheel$client$file_reloading$state_machine__47086__auto__ = null;
var figwheel$client$file_reloading$state_machine__47086__auto____0 = (function (){
var statearr_88382 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_88382[(0)] = figwheel$client$file_reloading$state_machine__47086__auto__);

(statearr_88382[(1)] = (1));

return statearr_88382;
});
var figwheel$client$file_reloading$state_machine__47086__auto____1 = (function (state_88366){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_88366);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e88386){if((e88386 instanceof Object)){
var ex__47089__auto__ = e88386;
var statearr_88387_88414 = state_88366;
(statearr_88387_88414[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_88366);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e88386;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__88415 = state_88366;
state_88366 = G__88415;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
figwheel$client$file_reloading$state_machine__47086__auto__ = function(state_88366){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$state_machine__47086__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$state_machine__47086__auto____1.call(this,state_88366);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$state_machine__47086__auto____0;
figwheel$client$file_reloading$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$state_machine__47086__auto____1;
return figwheel$client$file_reloading$state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto__))
})();
var state__47175__auto__ = (function (){var statearr_88388 = f__47174__auto__.call(null);
(statearr_88388[(6)] = c__47173__auto__);

return statearr_88388;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto__))
);

return c__47173__auto__;
})();
}
figwheel.client.file_reloading.queued_file_reload = (function figwheel$client$file_reloading$queued_file_reload(url){
return cljs.core.async.put_BANG_.call(null,figwheel.client.file_reloading.reload_chan,url);
});
figwheel.client.file_reloading.require_with_callback = (function figwheel$client$file_reloading$require_with_callback(p__88416,callback){
var map__88417 = p__88416;
var map__88417__$1 = ((((!((map__88417 == null)))?((((map__88417.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__88417.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__88417):map__88417);
var file_msg = map__88417__$1;
var namespace = cljs.core.get.call(null,map__88417__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var request_url = figwheel.client.file_reloading.resolve_ns.call(null,namespace);
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.assoc,request_url,((function (request_url,map__88417,map__88417__$1,file_msg,namespace){
return (function (file_msg_SINGLEQUOTE_){
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.dissoc,request_url);

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,file_msg,cljs.core.select_keys.call(null,file_msg_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375)], null)))], null));
});})(request_url,map__88417,map__88417__$1,file_msg,namespace))
);

return figwheel.client.file_reloading.figwheel_require.call(null,cljs.core.name.call(null,namespace),true);
});
figwheel.client.file_reloading.figwheel_no_load_QMARK_ = (function figwheel$client$file_reloading$figwheel_no_load_QMARK_(p__88441){
var map__88442 = p__88441;
var map__88442__$1 = ((((!((map__88442 == null)))?((((map__88442.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__88442.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__88442):map__88442);
var file_msg = map__88442__$1;
var namespace = cljs.core.get.call(null,map__88442__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__88449){
var map__88450 = p__88449;
var map__88450__$1 = ((((!((map__88450 == null)))?((((map__88450.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__88450.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__88450):map__88450);
var file_msg = map__88450__$1;
var namespace = cljs.core.get.call(null,map__88450__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
var and__28129__auto__ = cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,file_msg));
if(and__28129__auto__){
var or__28141__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
var or__28141__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__28141__auto____$1)){
return or__28141__auto____$1;
} else {
return figwheel.client.file_reloading.provided_QMARK_.call(null,cljs.core.name.call(null,namespace));
}
}
} else {
return and__28129__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__88456,callback){
var map__88457 = p__88456;
var map__88457__$1 = ((((!((map__88457 == null)))?((((map__88457.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__88457.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__88457):map__88457);
var file_msg = map__88457__$1;
var request_url = cljs.core.get.call(null,map__88457__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__88457__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.require_with_callback.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,["Figwheel: Not trying to load file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__47173__auto___88520 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto___88520,out){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto___88520,out){
return (function (state_88498){
var state_val_88499 = (state_88498[(1)]);
if((state_val_88499 === (1))){
var inst_88472 = cljs.core.seq.call(null,files);
var inst_88473 = cljs.core.first.call(null,inst_88472);
var inst_88474 = cljs.core.next.call(null,inst_88472);
var inst_88475 = files;
var state_88498__$1 = (function (){var statearr_88500 = state_88498;
(statearr_88500[(7)] = inst_88474);

(statearr_88500[(8)] = inst_88473);

(statearr_88500[(9)] = inst_88475);

return statearr_88500;
})();
var statearr_88501_88522 = state_88498__$1;
(statearr_88501_88522[(2)] = null);

(statearr_88501_88522[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88499 === (2))){
var inst_88481 = (state_88498[(10)]);
var inst_88475 = (state_88498[(9)]);
var inst_88480 = cljs.core.seq.call(null,inst_88475);
var inst_88481__$1 = cljs.core.first.call(null,inst_88480);
var inst_88482 = cljs.core.next.call(null,inst_88480);
var inst_88483 = (inst_88481__$1 == null);
var inst_88484 = cljs.core.not.call(null,inst_88483);
var state_88498__$1 = (function (){var statearr_88502 = state_88498;
(statearr_88502[(10)] = inst_88481__$1);

(statearr_88502[(11)] = inst_88482);

return statearr_88502;
})();
if(inst_88484){
var statearr_88503_88523 = state_88498__$1;
(statearr_88503_88523[(1)] = (4));

} else {
var statearr_88504_88524 = state_88498__$1;
(statearr_88504_88524[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88499 === (3))){
var inst_88496 = (state_88498[(2)]);
var state_88498__$1 = state_88498;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_88498__$1,inst_88496);
} else {
if((state_val_88499 === (4))){
var inst_88481 = (state_88498[(10)]);
var inst_88486 = figwheel.client.file_reloading.reload_js_file.call(null,inst_88481);
var state_88498__$1 = state_88498;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_88498__$1,(7),inst_88486);
} else {
if((state_val_88499 === (5))){
var inst_88492 = cljs.core.async.close_BANG_.call(null,out);
var state_88498__$1 = state_88498;
var statearr_88505_88530 = state_88498__$1;
(statearr_88505_88530[(2)] = inst_88492);

(statearr_88505_88530[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88499 === (6))){
var inst_88494 = (state_88498[(2)]);
var state_88498__$1 = state_88498;
var statearr_88506_88534 = state_88498__$1;
(statearr_88506_88534[(2)] = inst_88494);

(statearr_88506_88534[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88499 === (7))){
var inst_88482 = (state_88498[(11)]);
var inst_88488 = (state_88498[(2)]);
var inst_88489 = cljs.core.async.put_BANG_.call(null,out,inst_88488);
var inst_88475 = inst_88482;
var state_88498__$1 = (function (){var statearr_88507 = state_88498;
(statearr_88507[(12)] = inst_88489);

(statearr_88507[(9)] = inst_88475);

return statearr_88507;
})();
var statearr_88508_88535 = state_88498__$1;
(statearr_88508_88535[(2)] = null);

(statearr_88508_88535[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__47173__auto___88520,out))
;
return ((function (switch__47085__auto__,c__47173__auto___88520,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__47086__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__47086__auto____0 = (function (){
var statearr_88509 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_88509[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__47086__auto__);

(statearr_88509[(1)] = (1));

return statearr_88509;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__47086__auto____1 = (function (state_88498){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_88498);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e88510){if((e88510 instanceof Object)){
var ex__47089__auto__ = e88510;
var statearr_88512_88538 = state_88498;
(statearr_88512_88538[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_88498);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e88510;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__88539 = state_88498;
state_88498 = G__88539;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__47086__auto__ = function(state_88498){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__47086__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__47086__auto____1.call(this,state_88498);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__47086__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__47086__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto___88520,out))
})();
var state__47175__auto__ = (function (){var statearr_88519 = f__47174__auto__.call(null);
(statearr_88519[(6)] = c__47173__auto___88520);

return statearr_88519;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto___88520,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__88540,opts){
var map__88541 = p__88540;
var map__88541__$1 = ((((!((map__88541 == null)))?((((map__88541.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__88541.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__88541):map__88541);
var eval_body = cljs.core.get.call(null,map__88541__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__88541__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__28129__auto__ = eval_body;
if(cljs.core.truth_(and__28129__auto__)){
return typeof eval_body === 'string';
} else {
return and__28129__auto__;
}
})())){
var code = eval_body;
try{figwheel.client.utils.debug_prn.call(null,["Evaling file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e88543){var e = e88543;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Unable to evaluate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.expand_files = (function figwheel$client$file_reloading$expand_files(files){
var deps = figwheel.client.file_reloading.get_all_dependents.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,cljs.core.partial.call(null,cljs.core.re_matches,/figwheel\.connect.*/),new cljs.core.Keyword(null,"namespace","namespace",-377510372)),cljs.core.map.call(null,((function (deps){
return (function (n){
var temp__4655__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,((function (deps){
return (function (p1__88546_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__88546_SHARP_),n);
});})(deps))
,files));
if(cljs.core.truth_(temp__4655__auto__)){
var file_msg = temp__4655__auto__;
return file_msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372),new cljs.core.Keyword(null,"namespace","namespace",-377510372),n], null);
}
});})(deps))
,deps));
});
figwheel.client.file_reloading.sort_files = (function figwheel$client$file_reloading$sort_files(files){
if((cljs.core.count.call(null,files) <= (1))){
return files;
} else {
var keep_files = cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,keep_files,new cljs.core.Keyword(null,"namespace","namespace",-377510372)),figwheel.client.file_reloading.expand_files.call(null,files));
}
});
figwheel.client.file_reloading.get_figwheel_always = (function figwheel$client$file_reloading$get_figwheel_always(){
return cljs.core.map.call(null,(function (p__88552){
var vec__88553 = p__88552;
var k = cljs.core.nth.call(null,vec__88553,(0),null);
var v = cljs.core.nth.call(null,vec__88553,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),k,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372)], null);
}),cljs.core.filter.call(null,(function (p__88557){
var vec__88558 = p__88557;
var k = cljs.core.nth.call(null,vec__88558,(0),null);
var v = cljs.core.nth.call(null,vec__88558,(1),null);
return new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(v);
}),cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas)));
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__88569,p__88570){
var map__88571 = p__88569;
var map__88571__$1 = ((((!((map__88571 == null)))?((((map__88571.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__88571.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__88571):map__88571);
var opts = map__88571__$1;
var before_jsload = cljs.core.get.call(null,map__88571__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__88571__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var reload_dependents = cljs.core.get.call(null,map__88571__$1,new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430));
var map__88572 = p__88570;
var map__88572__$1 = ((((!((map__88572 == null)))?((((map__88572.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__88572.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__88572):map__88572);
var msg = map__88572__$1;
var files = cljs.core.get.call(null,map__88572__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var figwheel_meta = cljs.core.get.call(null,map__88572__$1,new cljs.core.Keyword(null,"figwheel-meta","figwheel-meta",-225970237));
var recompile_dependents = cljs.core.get.call(null,map__88572__$1,new cljs.core.Keyword(null,"recompile-dependents","recompile-dependents",523804171));
if(cljs.core.empty_QMARK_.call(null,figwheel_meta)){
} else {
cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas,figwheel_meta);
}

var c__47173__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto__,map__88571,map__88571__$1,opts,before_jsload,on_jsload,reload_dependents,map__88572,map__88572__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto__,map__88571,map__88571__$1,opts,before_jsload,on_jsload,reload_dependents,map__88572,map__88572__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (state_88736){
var state_val_88737 = (state_88736[(1)]);
if((state_val_88737 === (7))){
var inst_88592 = (state_88736[(7)]);
var inst_88593 = (state_88736[(8)]);
var inst_88590 = (state_88736[(9)]);
var inst_88591 = (state_88736[(10)]);
var inst_88600 = cljs.core._nth.call(null,inst_88591,inst_88593);
var inst_88601 = figwheel.client.file_reloading.eval_body.call(null,inst_88600,opts);
var inst_88602 = (inst_88593 + (1));
var tmp88738 = inst_88592;
var tmp88739 = inst_88590;
var tmp88740 = inst_88591;
var inst_88590__$1 = tmp88739;
var inst_88591__$1 = tmp88740;
var inst_88592__$1 = tmp88738;
var inst_88593__$1 = inst_88602;
var state_88736__$1 = (function (){var statearr_88741 = state_88736;
(statearr_88741[(11)] = inst_88601);

(statearr_88741[(7)] = inst_88592__$1);

(statearr_88741[(8)] = inst_88593__$1);

(statearr_88741[(9)] = inst_88590__$1);

(statearr_88741[(10)] = inst_88591__$1);

return statearr_88741;
})();
var statearr_88746_88904 = state_88736__$1;
(statearr_88746_88904[(2)] = null);

(statearr_88746_88904[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88737 === (20))){
var inst_88635 = (state_88736[(12)]);
var inst_88643 = figwheel.client.file_reloading.sort_files.call(null,inst_88635);
var state_88736__$1 = state_88736;
var statearr_88747_88905 = state_88736__$1;
(statearr_88747_88905[(2)] = inst_88643);

(statearr_88747_88905[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88737 === (27))){
var state_88736__$1 = state_88736;
var statearr_88748_88906 = state_88736__$1;
(statearr_88748_88906[(2)] = null);

(statearr_88748_88906[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88737 === (1))){
var inst_88582 = (state_88736[(13)]);
var inst_88579 = before_jsload.call(null,files);
var inst_88580 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_88581 = (function (){return ((function (inst_88582,inst_88579,inst_88580,state_val_88737,c__47173__auto__,map__88571,map__88571__$1,opts,before_jsload,on_jsload,reload_dependents,map__88572,map__88572__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__88566_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__88566_SHARP_);
});
;})(inst_88582,inst_88579,inst_88580,state_val_88737,c__47173__auto__,map__88571,map__88571__$1,opts,before_jsload,on_jsload,reload_dependents,map__88572,map__88572__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_88582__$1 = cljs.core.filter.call(null,inst_88581,files);
var inst_88583 = cljs.core.not_empty.call(null,inst_88582__$1);
var state_88736__$1 = (function (){var statearr_88749 = state_88736;
(statearr_88749[(14)] = inst_88580);

(statearr_88749[(15)] = inst_88579);

(statearr_88749[(13)] = inst_88582__$1);

return statearr_88749;
})();
if(cljs.core.truth_(inst_88583)){
var statearr_88750_88907 = state_88736__$1;
(statearr_88750_88907[(1)] = (2));

} else {
var statearr_88752_88908 = state_88736__$1;
(statearr_88752_88908[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88737 === (24))){
var state_88736__$1 = state_88736;
var statearr_88754_88911 = state_88736__$1;
(statearr_88754_88911[(2)] = null);

(statearr_88754_88911[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88737 === (39))){
var inst_88687 = (state_88736[(16)]);
var state_88736__$1 = state_88736;
var statearr_88755_88912 = state_88736__$1;
(statearr_88755_88912[(2)] = inst_88687);

(statearr_88755_88912[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88737 === (46))){
var inst_88729 = (state_88736[(2)]);
var state_88736__$1 = state_88736;
var statearr_88756_88914 = state_88736__$1;
(statearr_88756_88914[(2)] = inst_88729);

(statearr_88756_88914[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88737 === (4))){
var inst_88629 = (state_88736[(2)]);
var inst_88630 = cljs.core.List.EMPTY;
var inst_88631 = cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,inst_88630);
var inst_88632 = (function (){return ((function (inst_88629,inst_88630,inst_88631,state_val_88737,c__47173__auto__,map__88571,map__88571__$1,opts,before_jsload,on_jsload,reload_dependents,map__88572,map__88572__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__88567_SHARP_){
var and__28129__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__88567_SHARP_);
if(cljs.core.truth_(and__28129__auto__)){
return (cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__88567_SHARP_))) && (cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,p1__88567_SHARP_)));
} else {
return and__28129__auto__;
}
});
;})(inst_88629,inst_88630,inst_88631,state_val_88737,c__47173__auto__,map__88571,map__88571__$1,opts,before_jsload,on_jsload,reload_dependents,map__88572,map__88572__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_88633 = cljs.core.filter.call(null,inst_88632,files);
var inst_88634 = figwheel.client.file_reloading.get_figwheel_always.call(null);
var inst_88635 = cljs.core.concat.call(null,inst_88633,inst_88634);
var state_88736__$1 = (function (){var statearr_88761 = state_88736;
(statearr_88761[(17)] = inst_88629);

(statearr_88761[(18)] = inst_88631);

(statearr_88761[(12)] = inst_88635);

return statearr_88761;
})();
if(cljs.core.truth_(reload_dependents)){
var statearr_88763_88916 = state_88736__$1;
(statearr_88763_88916[(1)] = (16));

} else {
var statearr_88764_88917 = state_88736__$1;
(statearr_88764_88917[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88737 === (15))){
var inst_88619 = (state_88736[(2)]);
var state_88736__$1 = state_88736;
var statearr_88766_88918 = state_88736__$1;
(statearr_88766_88918[(2)] = inst_88619);

(statearr_88766_88918[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88737 === (21))){
var inst_88645 = (state_88736[(19)]);
var inst_88645__$1 = (state_88736[(2)]);
var inst_88646 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_88645__$1);
var state_88736__$1 = (function (){var statearr_88767 = state_88736;
(statearr_88767[(19)] = inst_88645__$1);

return statearr_88767;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_88736__$1,(22),inst_88646);
} else {
if((state_val_88737 === (31))){
var inst_88733 = (state_88736[(2)]);
var state_88736__$1 = state_88736;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_88736__$1,inst_88733);
} else {
if((state_val_88737 === (32))){
var inst_88687 = (state_88736[(16)]);
var inst_88692 = inst_88687.cljs$lang$protocol_mask$partition0$;
var inst_88693 = (inst_88692 & (64));
var inst_88694 = inst_88687.cljs$core$ISeq$;
var inst_88695 = (cljs.core.PROTOCOL_SENTINEL === inst_88694);
var inst_88696 = (inst_88693) || (inst_88695);
var state_88736__$1 = state_88736;
if(cljs.core.truth_(inst_88696)){
var statearr_88768_88923 = state_88736__$1;
(statearr_88768_88923[(1)] = (35));

} else {
var statearr_88769_88924 = state_88736__$1;
(statearr_88769_88924[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88737 === (40))){
var inst_88709 = (state_88736[(20)]);
var inst_88708 = (state_88736[(2)]);
var inst_88709__$1 = cljs.core.get.call(null,inst_88708,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_88710 = cljs.core.get.call(null,inst_88708,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_88711 = cljs.core.not_empty.call(null,inst_88709__$1);
var state_88736__$1 = (function (){var statearr_88770 = state_88736;
(statearr_88770[(21)] = inst_88710);

(statearr_88770[(20)] = inst_88709__$1);

return statearr_88770;
})();
if(cljs.core.truth_(inst_88711)){
var statearr_88771_88925 = state_88736__$1;
(statearr_88771_88925[(1)] = (41));

} else {
var statearr_88772_88926 = state_88736__$1;
(statearr_88772_88926[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88737 === (33))){
var state_88736__$1 = state_88736;
var statearr_88773_88927 = state_88736__$1;
(statearr_88773_88927[(2)] = false);

(statearr_88773_88927[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88737 === (13))){
var inst_88605 = (state_88736[(22)]);
var inst_88609 = cljs.core.chunk_first.call(null,inst_88605);
var inst_88610 = cljs.core.chunk_rest.call(null,inst_88605);
var inst_88611 = cljs.core.count.call(null,inst_88609);
var inst_88590 = inst_88610;
var inst_88591 = inst_88609;
var inst_88592 = inst_88611;
var inst_88593 = (0);
var state_88736__$1 = (function (){var statearr_88777 = state_88736;
(statearr_88777[(7)] = inst_88592);

(statearr_88777[(8)] = inst_88593);

(statearr_88777[(9)] = inst_88590);

(statearr_88777[(10)] = inst_88591);

return statearr_88777;
})();
var statearr_88778_88928 = state_88736__$1;
(statearr_88778_88928[(2)] = null);

(statearr_88778_88928[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88737 === (22))){
var inst_88649 = (state_88736[(23)]);
var inst_88648 = (state_88736[(24)]);
var inst_88645 = (state_88736[(19)]);
var inst_88653 = (state_88736[(25)]);
var inst_88648__$1 = (state_88736[(2)]);
var inst_88649__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_88648__$1);
var inst_88650 = (function (){var all_files = inst_88645;
var res_SINGLEQUOTE_ = inst_88648__$1;
var res = inst_88649__$1;
return ((function (all_files,res_SINGLEQUOTE_,res,inst_88649,inst_88648,inst_88645,inst_88653,inst_88648__$1,inst_88649__$1,state_val_88737,c__47173__auto__,map__88571,map__88571__$1,opts,before_jsload,on_jsload,reload_dependents,map__88572,map__88572__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__88568_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__88568_SHARP_));
});
;})(all_files,res_SINGLEQUOTE_,res,inst_88649,inst_88648,inst_88645,inst_88653,inst_88648__$1,inst_88649__$1,state_val_88737,c__47173__auto__,map__88571,map__88571__$1,opts,before_jsload,on_jsload,reload_dependents,map__88572,map__88572__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_88651 = cljs.core.filter.call(null,inst_88650,inst_88648__$1);
var inst_88652 = cljs.core.deref.call(null,figwheel.client.file_reloading.dependencies_loaded);
var inst_88653__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_88652);
var inst_88654 = cljs.core.not_empty.call(null,inst_88653__$1);
var state_88736__$1 = (function (){var statearr_88781 = state_88736;
(statearr_88781[(23)] = inst_88649__$1);

(statearr_88781[(24)] = inst_88648__$1);

(statearr_88781[(25)] = inst_88653__$1);

(statearr_88781[(26)] = inst_88651);

return statearr_88781;
})();
if(cljs.core.truth_(inst_88654)){
var statearr_88782_88937 = state_88736__$1;
(statearr_88782_88937[(1)] = (23));

} else {
var statearr_88783_88938 = state_88736__$1;
(statearr_88783_88938[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88737 === (36))){
var state_88736__$1 = state_88736;
var statearr_88784_88939 = state_88736__$1;
(statearr_88784_88939[(2)] = false);

(statearr_88784_88939[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88737 === (41))){
var inst_88709 = (state_88736[(20)]);
var inst_88713 = cljs.core.comp.call(null,figwheel.client.file_reloading.name__GT_path,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var inst_88714 = cljs.core.map.call(null,inst_88713,inst_88709);
var inst_88715 = cljs.core.pr_str.call(null,inst_88714);
var inst_88716 = ["figwheel-no-load meta-data: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_88715)].join('');
var inst_88717 = figwheel.client.utils.log.call(null,inst_88716);
var state_88736__$1 = state_88736;
var statearr_88785_88940 = state_88736__$1;
(statearr_88785_88940[(2)] = inst_88717);

(statearr_88785_88940[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88737 === (43))){
var inst_88710 = (state_88736[(21)]);
var inst_88720 = (state_88736[(2)]);
var inst_88721 = cljs.core.not_empty.call(null,inst_88710);
var state_88736__$1 = (function (){var statearr_88786 = state_88736;
(statearr_88786[(27)] = inst_88720);

return statearr_88786;
})();
if(cljs.core.truth_(inst_88721)){
var statearr_88787_88941 = state_88736__$1;
(statearr_88787_88941[(1)] = (44));

} else {
var statearr_88788_88942 = state_88736__$1;
(statearr_88788_88942[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88737 === (29))){
var inst_88649 = (state_88736[(23)]);
var inst_88648 = (state_88736[(24)]);
var inst_88645 = (state_88736[(19)]);
var inst_88653 = (state_88736[(25)]);
var inst_88651 = (state_88736[(26)]);
var inst_88687 = (state_88736[(16)]);
var inst_88683 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_88686 = (function (){var all_files = inst_88645;
var res_SINGLEQUOTE_ = inst_88648;
var res = inst_88649;
var files_not_loaded = inst_88651;
var dependencies_that_loaded = inst_88653;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_88649,inst_88648,inst_88645,inst_88653,inst_88651,inst_88687,inst_88683,state_val_88737,c__47173__auto__,map__88571,map__88571__$1,opts,before_jsload,on_jsload,reload_dependents,map__88572,map__88572__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__88685){
var map__88789 = p__88685;
var map__88789__$1 = ((((!((map__88789 == null)))?((((map__88789.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__88789.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__88789):map__88789);
var namespace = cljs.core.get.call(null,map__88789__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.truth_(meta_data.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179)))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_88649,inst_88648,inst_88645,inst_88653,inst_88651,inst_88687,inst_88683,state_val_88737,c__47173__auto__,map__88571,map__88571__$1,opts,before_jsload,on_jsload,reload_dependents,map__88572,map__88572__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_88687__$1 = cljs.core.group_by.call(null,inst_88686,inst_88651);
var inst_88689 = (inst_88687__$1 == null);
var inst_88690 = cljs.core.not.call(null,inst_88689);
var state_88736__$1 = (function (){var statearr_88791 = state_88736;
(statearr_88791[(28)] = inst_88683);

(statearr_88791[(16)] = inst_88687__$1);

return statearr_88791;
})();
if(inst_88690){
var statearr_88792_88948 = state_88736__$1;
(statearr_88792_88948[(1)] = (32));

} else {
var statearr_88793_88949 = state_88736__$1;
(statearr_88793_88949[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88737 === (44))){
var inst_88710 = (state_88736[(21)]);
var inst_88723 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_88710);
var inst_88724 = cljs.core.pr_str.call(null,inst_88723);
var inst_88725 = ["not required: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_88724)].join('');
var inst_88726 = figwheel.client.utils.log.call(null,inst_88725);
var state_88736__$1 = state_88736;
var statearr_88794_88950 = state_88736__$1;
(statearr_88794_88950[(2)] = inst_88726);

(statearr_88794_88950[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88737 === (6))){
var inst_88626 = (state_88736[(2)]);
var state_88736__$1 = state_88736;
var statearr_88803_88951 = state_88736__$1;
(statearr_88803_88951[(2)] = inst_88626);

(statearr_88803_88951[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88737 === (28))){
var inst_88651 = (state_88736[(26)]);
var inst_88680 = (state_88736[(2)]);
var inst_88681 = cljs.core.not_empty.call(null,inst_88651);
var state_88736__$1 = (function (){var statearr_88815 = state_88736;
(statearr_88815[(29)] = inst_88680);

return statearr_88815;
})();
if(cljs.core.truth_(inst_88681)){
var statearr_88816_88955 = state_88736__$1;
(statearr_88816_88955[(1)] = (29));

} else {
var statearr_88817_88956 = state_88736__$1;
(statearr_88817_88956[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88737 === (25))){
var inst_88649 = (state_88736[(23)]);
var inst_88667 = (state_88736[(2)]);
var inst_88668 = cljs.core.not_empty.call(null,inst_88649);
var state_88736__$1 = (function (){var statearr_88819 = state_88736;
(statearr_88819[(30)] = inst_88667);

return statearr_88819;
})();
if(cljs.core.truth_(inst_88668)){
var statearr_88820_88960 = state_88736__$1;
(statearr_88820_88960[(1)] = (26));

} else {
var statearr_88821_88961 = state_88736__$1;
(statearr_88821_88961[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88737 === (34))){
var inst_88703 = (state_88736[(2)]);
var state_88736__$1 = state_88736;
if(cljs.core.truth_(inst_88703)){
var statearr_88823_88962 = state_88736__$1;
(statearr_88823_88962[(1)] = (38));

} else {
var statearr_88824_88963 = state_88736__$1;
(statearr_88824_88963[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88737 === (17))){
var state_88736__$1 = state_88736;
var statearr_88825_88964 = state_88736__$1;
(statearr_88825_88964[(2)] = recompile_dependents);

(statearr_88825_88964[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88737 === (3))){
var state_88736__$1 = state_88736;
var statearr_88828_88965 = state_88736__$1;
(statearr_88828_88965[(2)] = null);

(statearr_88828_88965[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88737 === (12))){
var inst_88622 = (state_88736[(2)]);
var state_88736__$1 = state_88736;
var statearr_88831_88966 = state_88736__$1;
(statearr_88831_88966[(2)] = inst_88622);

(statearr_88831_88966[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88737 === (2))){
var inst_88582 = (state_88736[(13)]);
var inst_88589 = cljs.core.seq.call(null,inst_88582);
var inst_88590 = inst_88589;
var inst_88591 = null;
var inst_88592 = (0);
var inst_88593 = (0);
var state_88736__$1 = (function (){var statearr_88832 = state_88736;
(statearr_88832[(7)] = inst_88592);

(statearr_88832[(8)] = inst_88593);

(statearr_88832[(9)] = inst_88590);

(statearr_88832[(10)] = inst_88591);

return statearr_88832;
})();
var statearr_88834_88967 = state_88736__$1;
(statearr_88834_88967[(2)] = null);

(statearr_88834_88967[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88737 === (23))){
var inst_88649 = (state_88736[(23)]);
var inst_88648 = (state_88736[(24)]);
var inst_88645 = (state_88736[(19)]);
var inst_88653 = (state_88736[(25)]);
var inst_88651 = (state_88736[(26)]);
var inst_88656 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these dependencies");
var inst_88658 = (function (){var all_files = inst_88645;
var res_SINGLEQUOTE_ = inst_88648;
var res = inst_88649;
var files_not_loaded = inst_88651;
var dependencies_that_loaded = inst_88653;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_88649,inst_88648,inst_88645,inst_88653,inst_88651,inst_88656,state_val_88737,c__47173__auto__,map__88571,map__88571__$1,opts,before_jsload,on_jsload,reload_dependents,map__88572,map__88572__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__88657){
var map__88835 = p__88657;
var map__88835__$1 = ((((!((map__88835 == null)))?((((map__88835.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__88835.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__88835):map__88835);
var request_url = cljs.core.get.call(null,map__88835__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
return clojure.string.replace.call(null,request_url,goog.basePath,"");
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_88649,inst_88648,inst_88645,inst_88653,inst_88651,inst_88656,state_val_88737,c__47173__auto__,map__88571,map__88571__$1,opts,before_jsload,on_jsload,reload_dependents,map__88572,map__88572__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_88660 = cljs.core.reverse.call(null,inst_88653);
var inst_88661 = cljs.core.map.call(null,inst_88658,inst_88660);
var inst_88662 = cljs.core.pr_str.call(null,inst_88661);
var inst_88663 = figwheel.client.utils.log.call(null,inst_88662);
var state_88736__$1 = (function (){var statearr_88838 = state_88736;
(statearr_88838[(31)] = inst_88656);

return statearr_88838;
})();
var statearr_88839_88968 = state_88736__$1;
(statearr_88839_88968[(2)] = inst_88663);

(statearr_88839_88968[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88737 === (35))){
var state_88736__$1 = state_88736;
var statearr_88840_88969 = state_88736__$1;
(statearr_88840_88969[(2)] = true);

(statearr_88840_88969[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88737 === (19))){
var inst_88635 = (state_88736[(12)]);
var inst_88641 = figwheel.client.file_reloading.expand_files.call(null,inst_88635);
var state_88736__$1 = state_88736;
var statearr_88841_88970 = state_88736__$1;
(statearr_88841_88970[(2)] = inst_88641);

(statearr_88841_88970[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88737 === (11))){
var state_88736__$1 = state_88736;
var statearr_88842_88971 = state_88736__$1;
(statearr_88842_88971[(2)] = null);

(statearr_88842_88971[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88737 === (9))){
var inst_88624 = (state_88736[(2)]);
var state_88736__$1 = state_88736;
var statearr_88843_88972 = state_88736__$1;
(statearr_88843_88972[(2)] = inst_88624);

(statearr_88843_88972[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88737 === (5))){
var inst_88592 = (state_88736[(7)]);
var inst_88593 = (state_88736[(8)]);
var inst_88595 = (inst_88593 < inst_88592);
var inst_88596 = inst_88595;
var state_88736__$1 = state_88736;
if(cljs.core.truth_(inst_88596)){
var statearr_88844_88973 = state_88736__$1;
(statearr_88844_88973[(1)] = (7));

} else {
var statearr_88845_88974 = state_88736__$1;
(statearr_88845_88974[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88737 === (14))){
var inst_88605 = (state_88736[(22)]);
var inst_88614 = cljs.core.first.call(null,inst_88605);
var inst_88615 = figwheel.client.file_reloading.eval_body.call(null,inst_88614,opts);
var inst_88616 = cljs.core.next.call(null,inst_88605);
var inst_88590 = inst_88616;
var inst_88591 = null;
var inst_88592 = (0);
var inst_88593 = (0);
var state_88736__$1 = (function (){var statearr_88846 = state_88736;
(statearr_88846[(7)] = inst_88592);

(statearr_88846[(8)] = inst_88593);

(statearr_88846[(9)] = inst_88590);

(statearr_88846[(10)] = inst_88591);

(statearr_88846[(32)] = inst_88615);

return statearr_88846;
})();
var statearr_88847_88977 = state_88736__$1;
(statearr_88847_88977[(2)] = null);

(statearr_88847_88977[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88737 === (45))){
var state_88736__$1 = state_88736;
var statearr_88848_88978 = state_88736__$1;
(statearr_88848_88978[(2)] = null);

(statearr_88848_88978[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88737 === (26))){
var inst_88649 = (state_88736[(23)]);
var inst_88648 = (state_88736[(24)]);
var inst_88645 = (state_88736[(19)]);
var inst_88653 = (state_88736[(25)]);
var inst_88651 = (state_88736[(26)]);
var inst_88670 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_88672 = (function (){var all_files = inst_88645;
var res_SINGLEQUOTE_ = inst_88648;
var res = inst_88649;
var files_not_loaded = inst_88651;
var dependencies_that_loaded = inst_88653;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_88649,inst_88648,inst_88645,inst_88653,inst_88651,inst_88670,state_val_88737,c__47173__auto__,map__88571,map__88571__$1,opts,before_jsload,on_jsload,reload_dependents,map__88572,map__88572__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__88671){
var map__88850 = p__88671;
var map__88850__$1 = ((((!((map__88850 == null)))?((((map__88850.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__88850.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__88850):map__88850);
var namespace = cljs.core.get.call(null,map__88850__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__88850__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.name__GT_path.call(null,cljs.core.name.call(null,namespace));
} else {
return file;
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_88649,inst_88648,inst_88645,inst_88653,inst_88651,inst_88670,state_val_88737,c__47173__auto__,map__88571,map__88571__$1,opts,before_jsload,on_jsload,reload_dependents,map__88572,map__88572__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_88673 = cljs.core.map.call(null,inst_88672,inst_88649);
var inst_88674 = cljs.core.pr_str.call(null,inst_88673);
var inst_88675 = figwheel.client.utils.log.call(null,inst_88674);
var inst_88676 = (function (){var all_files = inst_88645;
var res_SINGLEQUOTE_ = inst_88648;
var res = inst_88649;
var files_not_loaded = inst_88651;
var dependencies_that_loaded = inst_88653;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_88649,inst_88648,inst_88645,inst_88653,inst_88651,inst_88670,inst_88672,inst_88673,inst_88674,inst_88675,state_val_88737,c__47173__auto__,map__88571,map__88571__$1,opts,before_jsload,on_jsload,reload_dependents,map__88572,map__88572__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_88649,inst_88648,inst_88645,inst_88653,inst_88651,inst_88670,inst_88672,inst_88673,inst_88674,inst_88675,state_val_88737,c__47173__auto__,map__88571,map__88571__$1,opts,before_jsload,on_jsload,reload_dependents,map__88572,map__88572__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_88677 = setTimeout(inst_88676,(10));
var state_88736__$1 = (function (){var statearr_88856 = state_88736;
(statearr_88856[(33)] = inst_88670);

(statearr_88856[(34)] = inst_88675);

return statearr_88856;
})();
var statearr_88858_89071 = state_88736__$1;
(statearr_88858_89071[(2)] = inst_88677);

(statearr_88858_89071[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88737 === (16))){
var state_88736__$1 = state_88736;
var statearr_88859_89074 = state_88736__$1;
(statearr_88859_89074[(2)] = reload_dependents);

(statearr_88859_89074[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88737 === (38))){
var inst_88687 = (state_88736[(16)]);
var inst_88705 = cljs.core.apply.call(null,cljs.core.hash_map,inst_88687);
var state_88736__$1 = state_88736;
var statearr_88861_89077 = state_88736__$1;
(statearr_88861_89077[(2)] = inst_88705);

(statearr_88861_89077[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88737 === (30))){
var state_88736__$1 = state_88736;
var statearr_88862_89079 = state_88736__$1;
(statearr_88862_89079[(2)] = null);

(statearr_88862_89079[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88737 === (10))){
var inst_88605 = (state_88736[(22)]);
var inst_88607 = cljs.core.chunked_seq_QMARK_.call(null,inst_88605);
var state_88736__$1 = state_88736;
if(inst_88607){
var statearr_88863_89082 = state_88736__$1;
(statearr_88863_89082[(1)] = (13));

} else {
var statearr_88864_89084 = state_88736__$1;
(statearr_88864_89084[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88737 === (18))){
var inst_88639 = (state_88736[(2)]);
var state_88736__$1 = state_88736;
if(cljs.core.truth_(inst_88639)){
var statearr_88865_89088 = state_88736__$1;
(statearr_88865_89088[(1)] = (19));

} else {
var statearr_88866_89089 = state_88736__$1;
(statearr_88866_89089[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88737 === (42))){
var state_88736__$1 = state_88736;
var statearr_88873_89091 = state_88736__$1;
(statearr_88873_89091[(2)] = null);

(statearr_88873_89091[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88737 === (37))){
var inst_88700 = (state_88736[(2)]);
var state_88736__$1 = state_88736;
var statearr_88880_89094 = state_88736__$1;
(statearr_88880_89094[(2)] = inst_88700);

(statearr_88880_89094[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88737 === (8))){
var inst_88590 = (state_88736[(9)]);
var inst_88605 = (state_88736[(22)]);
var inst_88605__$1 = cljs.core.seq.call(null,inst_88590);
var state_88736__$1 = (function (){var statearr_88881 = state_88736;
(statearr_88881[(22)] = inst_88605__$1);

return statearr_88881;
})();
if(inst_88605__$1){
var statearr_88882_89101 = state_88736__$1;
(statearr_88882_89101[(1)] = (10));

} else {
var statearr_88883_89104 = state_88736__$1;
(statearr_88883_89104[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__47173__auto__,map__88571,map__88571__$1,opts,before_jsload,on_jsload,reload_dependents,map__88572,map__88572__$1,msg,files,figwheel_meta,recompile_dependents))
;
return ((function (switch__47085__auto__,c__47173__auto__,map__88571,map__88571__$1,opts,before_jsload,on_jsload,reload_dependents,map__88572,map__88572__$1,msg,files,figwheel_meta,recompile_dependents){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__47086__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__47086__auto____0 = (function (){
var statearr_88889 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_88889[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__47086__auto__);

(statearr_88889[(1)] = (1));

return statearr_88889;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__47086__auto____1 = (function (state_88736){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_88736);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e88891){if((e88891 instanceof Object)){
var ex__47089__auto__ = e88891;
var statearr_88893_89117 = state_88736;
(statearr_88893_89117[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_88736);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e88891;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__89118 = state_88736;
state_88736 = G__89118;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__47086__auto__ = function(state_88736){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__47086__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__47086__auto____1.call(this,state_88736);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__47086__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__47086__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto__,map__88571,map__88571__$1,opts,before_jsload,on_jsload,reload_dependents,map__88572,map__88572__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var state__47175__auto__ = (function (){var statearr_88896 = f__47174__auto__.call(null);
(statearr_88896[(6)] = c__47173__auto__);

return statearr_88896;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto__,map__88571,map__88571__$1,opts,before_jsload,on_jsload,reload_dependents,map__88572,map__88572__$1,msg,files,figwheel_meta,recompile_dependents))
);

return c__47173__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(location.protocol),"//"].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__89134,link){
var map__89135 = p__89134;
var map__89135__$1 = ((((!((map__89135 == null)))?((((map__89135.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__89135.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__89135):map__89135);
var file = cljs.core.get.call(null,map__89135__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__4657__auto__ = link.href;
if(cljs.core.truth_(temp__4657__auto__)){
var link_href = temp__4657__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__4657__auto__,map__89135,map__89135__$1,file){
return (function (p1__89132_SHARP_,p2__89133_SHARP_){
if(cljs.core._EQ_.call(null,p1__89132_SHARP_,p2__89133_SHARP_)){
return p1__89132_SHARP_;
} else {
return false;
}
});})(link_href,temp__4657__auto__,map__89135,map__89135__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__4657__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__89160){
var map__89161 = p__89160;
var map__89161__$1 = ((((!((map__89161 == null)))?((((map__89161.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__89161.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__89161):map__89161);
var match_length = cljs.core.get.call(null,map__89161__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__89161__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__89158_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__89158_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__4657__auto__)){
var res = temp__4657__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.distinctify = (function figwheel$client$file_reloading$distinctify(key,seqq){
return cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (p1__89176_SHARP_,p2__89177_SHARP_){
return cljs.core.assoc.call(null,p1__89176_SHARP_,cljs.core.get.call(null,p2__89177_SHARP_,key),p2__89177_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,seqq));
});
figwheel.client.file_reloading.add_link_to_document = (function figwheel$client$file_reloading$add_link_to_document(orig_link,klone,finished_fn){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
parent.removeChild(orig_link);

return finished_fn.call(null);
});})(parent))
,(300));
});
if(typeof figwheel.client.file_reloading.reload_css_deferred_chain !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_css_deferred_chain = cljs.core.atom.call(null,goog.async.Deferred.succeed());
}
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(f_data,fin){
var temp__4655__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__4655__auto__)){
var link = temp__4655__auto__;
return figwheel.client.file_reloading.add_link_to_document.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href),((function (link,temp__4655__auto__){
return (function (){
return fin.call(null,cljs.core.assoc.call(null,f_data,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),true));
});})(link,temp__4655__auto__))
);
} else {
return fin.call(null,f_data);
}
});
figwheel.client.file_reloading.reload_css_files_STAR_ = (function figwheel$client$file_reloading$reload_css_files_STAR_(deferred,f_datas,on_cssload){
return figwheel.client.utils.liftContD.call(null,figwheel.client.utils.mapConcatD.call(null,deferred,figwheel.client.file_reloading.reload_css_file,f_datas),(function (f_datas_SINGLEQUOTE_,fin){
var loaded_f_datas_89197 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),f_datas_SINGLEQUOTE_);
figwheel.client.file_reloading.on_cssload_custom_event.call(null,loaded_f_datas_89197);

if(cljs.core.fn_QMARK_.call(null,on_cssload)){
on_cssload.call(null,loaded_f_datas_89197);
} else {
}

return fin.call(null);
}));
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__89200,p__89201){
var map__89202 = p__89200;
var map__89202__$1 = ((((!((map__89202 == null)))?((((map__89202.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__89202.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__89202):map__89202);
var on_cssload = cljs.core.get.call(null,map__89202__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
var map__89203 = p__89201;
var map__89203__$1 = ((((!((map__89203 == null)))?((((map__89203.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__89203.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__89203):map__89203);
var files_msg = map__89203__$1;
var files = cljs.core.get.call(null,map__89203__$1,new cljs.core.Keyword(null,"files","files",-472457450));
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
var temp__4657__auto__ = cljs.core.not_empty.call(null,figwheel.client.file_reloading.distinctify.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files));
if(cljs.core.truth_(temp__4657__auto__)){
var f_datas = temp__4657__auto__;
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.reload_css_deferred_chain,figwheel.client.file_reloading.reload_css_files_STAR_,f_datas,on_cssload);
} else {
return null;
}
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map?rel=1511404573703
