// Compiled by ClojureScript 1.9.946 {}
goog.provide('figwheel.client');
goog.require('cljs.core');
goog.require('goog.Uri');
goog.require('goog.userAgent.product');
goog.require('goog.object');
goog.require('cljs.reader');
goog.require('cljs.core.async');
goog.require('figwheel.client.socket');
goog.require('figwheel.client.utils');
goog.require('figwheel.client.heads_up');
goog.require('figwheel.client.file_reloading');
goog.require('clojure.string');
goog.require('cljs.repl');
figwheel.client._figwheel_version_ = "0.5.13";
figwheel.client.js_stringify = (((typeof JSON !== 'undefined') && (!((JSON.stringify == null))))?(function (x){
return ["#js ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(JSON.stringify(x,null," "))].join('');
}):(function (x){
try{return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join('');
}catch (e89309){if((e89309 instanceof Error)){
var e = e89309;
return "Error: Unable to stringify";
} else {
throw e89309;

}
}}));
figwheel.client.figwheel_repl_print = (function figwheel$client$figwheel_repl_print(var_args){
var G__89312 = arguments.length;
switch (G__89312) {
case 2:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2 = (function (stream,args){
figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),"figwheel-repl-print",new cljs.core.Keyword(null,"content","content",15833224),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"stream","stream",1534941648),stream,new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.mapv.call(null,(function (p1__89310_SHARP_){
if(typeof p1__89310_SHARP_ === 'string'){
return p1__89310_SHARP_;
} else {
return figwheel.client.js_stringify.call(null,p1__89310_SHARP_);
}
}),args)], null)], null));

return null;
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1 = (function (args){
return figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);
});

figwheel.client.figwheel_repl_print.cljs$lang$maxFixedArity = 2;

figwheel.client.console_out_print = (function figwheel$client$console_out_print(args){
return console.log.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.console_err_print = (function figwheel$client$console_err_print(args){
return console.error.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.repl_out_print_fn = (function figwheel$client$repl_out_print_fn(var_args){
var args__29319__auto__ = [];
var len__29312__auto___89316 = arguments.length;
var i__29313__auto___89317 = (0);
while(true){
if((i__29313__auto___89317 < len__29312__auto___89316)){
args__29319__auto__.push((arguments[i__29313__auto___89317]));

var G__89318 = (i__29313__auto___89317 + (1));
i__29313__auto___89317 = G__89318;
continue;
} else {
}
break;
}

var argseq__29320__auto__ = ((((0) < args__29319__auto__.length))?(new cljs.core.IndexedSeq(args__29319__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__29320__auto__);
});

figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_out_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);

return null;
});

figwheel.client.repl_out_print_fn.cljs$lang$maxFixedArity = (0);

figwheel.client.repl_out_print_fn.cljs$lang$applyTo = (function (seq89315){
return figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq89315));
});

figwheel.client.repl_err_print_fn = (function figwheel$client$repl_err_print_fn(var_args){
var args__29319__auto__ = [];
var len__29312__auto___89320 = arguments.length;
var i__29313__auto___89321 = (0);
while(true){
if((i__29313__auto___89321 < len__29312__auto___89320)){
args__29319__auto__.push((arguments[i__29313__auto___89321]));

var G__89322 = (i__29313__auto___89321 + (1));
i__29313__auto___89321 = G__89322;
continue;
} else {
}
break;
}

var argseq__29320__auto__ = ((((0) < args__29319__auto__.length))?(new cljs.core.IndexedSeq(args__29319__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__29320__auto__);
});

figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_err_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"err","err",-2089457205),args);

return null;
});

figwheel.client.repl_err_print_fn.cljs$lang$maxFixedArity = (0);

figwheel.client.repl_err_print_fn.cljs$lang$applyTo = (function (seq89319){
return figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq89319));
});

figwheel.client.enable_repl_print_BANG_ = (function figwheel$client$enable_repl_print_BANG_(){
cljs.core._STAR_print_newline_STAR_ = false;

cljs.core.set_print_fn_BANG_.call(null,figwheel.client.repl_out_print_fn);

cljs.core.set_print_err_fn_BANG_.call(null,figwheel.client.repl_err_print_fn);

return null;
});
figwheel.client.autoload_QMARK_ = (function figwheel$client$autoload_QMARK_(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),true);
});
figwheel.client.toggle_autoload = (function figwheel$client$toggle_autoload(){
var res = figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),cljs.core.not.call(null,figwheel.client.autoload_QMARK_.call(null)));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),["Toggle autoload deprecated! Use (figwheel.client/set-autoload! false)"].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),["Figwheel autoloading ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(figwheel.client.autoload_QMARK_.call(null))?"ON":"OFF"))].join(''));

return res;
});
goog.exportSymbol('figwheel.client.toggle_autoload', figwheel.client.toggle_autoload);
/**
 * Figwheel by default loads code changes as you work. Sometimes you
 *   just want to work on your code without the ramifications of
 *   autoloading and simply load your code piecemeal in the REPL. You can
 *   turn autoloading on and of with this method.
 * 
 *   (figwheel.client/set-autoload false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_autoload = (function figwheel$client$set_autoload(b){
if((b === true) || (b === false)){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),b);
});
goog.exportSymbol('figwheel.client.set_autoload', figwheel.client.set_autoload);
figwheel.client.repl_pprint = (function figwheel$client$repl_pprint(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),true);
});
goog.exportSymbol('figwheel.client.repl_pprint', figwheel.client.repl_pprint);
/**
 * This method gives you the ability to turn the pretty printing of
 *   the REPL's return value on and off.
 * 
 *   (figwheel.client/set-repl-pprint false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_repl_pprint = (function figwheel$client$set_repl_pprint(b){
if((b === true) || (b === false)){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),b);
});
goog.exportSymbol('figwheel.client.set_repl_pprint', figwheel.client.set_repl_pprint);
figwheel.client.repl_result_pr_str = (function figwheel$client$repl_result_pr_str(v){
if(cljs.core.truth_(figwheel.client.repl_pprint.call(null))){
return figwheel.client.utils.pprint_to_string.call(null,v);
} else {
return cljs.core.pr_str.call(null,v);
}
});
goog.exportSymbol('figwheel.client.repl_result_pr_str', figwheel.client.repl_result_pr_str);
figwheel.client.get_essential_messages = (function figwheel$client$get_essential_messages(ed){
if(cljs.core.truth_(ed)){
return cljs.core.cons.call(null,cljs.core.select_keys.call(null,ed,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"class","class",-2030961996)], null)),figwheel.client.get_essential_messages.call(null,new cljs.core.Keyword(null,"cause","cause",231901252).cljs$core$IFn$_invoke$arity$1(ed)));
} else {
return null;
}
});
figwheel.client.error_msg_format = (function figwheel$client$error_msg_format(p__89323){
var map__89324 = p__89323;
var map__89324__$1 = ((((!((map__89324 == null)))?((((map__89324.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__89324.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__89324):map__89324);
var message = cljs.core.get.call(null,map__89324__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var class$ = cljs.core.get.call(null,map__89324__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(class$)," : ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join('');
});
figwheel.client.format_messages = cljs.core.comp.call(null,cljs.core.partial.call(null,cljs.core.map,figwheel.client.error_msg_format),figwheel.client.get_essential_messages);
figwheel.client.focus_msgs = (function figwheel$client$focus_msgs(name_set,msg_hist){
return cljs.core.cons.call(null,cljs.core.first.call(null,msg_hist),cljs.core.filter.call(null,cljs.core.comp.call(null,name_set,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863)),cljs.core.rest.call(null,msg_hist)));
});
figwheel.client.reload_file_QMARK__STAR_ = (function figwheel$client$reload_file_QMARK__STAR_(msg_name,opts){
var or__28141__auto__ = new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
return cljs.core.not_EQ_.call(null,msg_name,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356));
}
});
figwheel.client.reload_file_state_QMARK_ = (function figwheel$client$reload_file_state_QMARK_(msg_names,opts){
var and__28129__auto__ = cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563));
if(and__28129__auto__){
return figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts);
} else {
return and__28129__auto__;
}
});
figwheel.client.block_reload_file_state_QMARK_ = (function figwheel$client$block_reload_file_state_QMARK_(msg_names,opts){
return (cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))) && (cljs.core.not.call(null,figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts)));
});
figwheel.client.warning_append_state_QMARK_ = (function figwheel$client$warning_append_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.warning_state_QMARK_ = (function figwheel$client$warning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),cljs.core.first.call(null,msg_names));
});
figwheel.client.rewarning_state_QMARK_ = (function figwheel$client$rewarning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(3),msg_names));
});
figwheel.client.compile_fail_state_QMARK_ = (function figwheel$client$compile_fail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),cljs.core.first.call(null,msg_names));
});
figwheel.client.compile_refail_state_QMARK_ = (function figwheel$client$compile_refail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.css_loaded_state_QMARK_ = (function figwheel$client$css_loaded_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874),cljs.core.first.call(null,msg_names));
});
figwheel.client.file_reloader_plugin = (function figwheel$client$file_reloader_plugin(opts){
var ch = cljs.core.async.chan.call(null);
var c__47173__auto___89416 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto___89416,ch){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto___89416,ch){
return (function (state_89377){
var state_val_89378 = (state_89377[(1)]);
if((state_val_89378 === (7))){
var inst_89373 = (state_89377[(2)]);
var state_89377__$1 = state_89377;
var statearr_89380_89417 = state_89377__$1;
(statearr_89380_89417[(2)] = inst_89373);

(statearr_89380_89417[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89378 === (1))){
var state_89377__$1 = state_89377;
var statearr_89381_89418 = state_89377__$1;
(statearr_89381_89418[(2)] = null);

(statearr_89381_89418[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89378 === (4))){
var inst_89330 = (state_89377[(7)]);
var inst_89330__$1 = (state_89377[(2)]);
var state_89377__$1 = (function (){var statearr_89383 = state_89377;
(statearr_89383[(7)] = inst_89330__$1);

return statearr_89383;
})();
if(cljs.core.truth_(inst_89330__$1)){
var statearr_89384_89419 = state_89377__$1;
(statearr_89384_89419[(1)] = (5));

} else {
var statearr_89385_89420 = state_89377__$1;
(statearr_89385_89420[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89378 === (15))){
var inst_89337 = (state_89377[(8)]);
var inst_89352 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_89337);
var inst_89353 = cljs.core.first.call(null,inst_89352);
var inst_89354 = new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(inst_89353);
var inst_89355 = ["Figwheel: Not loading code with warnings - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_89354)].join('');
var inst_89356 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),inst_89355);
var state_89377__$1 = state_89377;
var statearr_89387_89421 = state_89377__$1;
(statearr_89387_89421[(2)] = inst_89356);

(statearr_89387_89421[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89378 === (13))){
var inst_89361 = (state_89377[(2)]);
var state_89377__$1 = state_89377;
var statearr_89390_89422 = state_89377__$1;
(statearr_89390_89422[(2)] = inst_89361);

(statearr_89390_89422[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89378 === (6))){
var state_89377__$1 = state_89377;
var statearr_89391_89424 = state_89377__$1;
(statearr_89391_89424[(2)] = null);

(statearr_89391_89424[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89378 === (17))){
var inst_89359 = (state_89377[(2)]);
var state_89377__$1 = state_89377;
var statearr_89392_89425 = state_89377__$1;
(statearr_89392_89425[(2)] = inst_89359);

(statearr_89392_89425[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89378 === (3))){
var inst_89375 = (state_89377[(2)]);
var state_89377__$1 = state_89377;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_89377__$1,inst_89375);
} else {
if((state_val_89378 === (12))){
var inst_89336 = (state_89377[(9)]);
var inst_89350 = figwheel.client.block_reload_file_state_QMARK_.call(null,inst_89336,opts);
var state_89377__$1 = state_89377;
if(cljs.core.truth_(inst_89350)){
var statearr_89393_89430 = state_89377__$1;
(statearr_89393_89430[(1)] = (15));

} else {
var statearr_89394_89431 = state_89377__$1;
(statearr_89394_89431[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89378 === (2))){
var state_89377__$1 = state_89377;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_89377__$1,(4),ch);
} else {
if((state_val_89378 === (11))){
var inst_89337 = (state_89377[(8)]);
var inst_89342 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_89343 = figwheel.client.file_reloading.reload_js_files.call(null,opts,inst_89337);
var inst_89344 = cljs.core.async.timeout.call(null,(1000));
var inst_89345 = [inst_89343,inst_89344];
var inst_89346 = (new cljs.core.PersistentVector(null,2,(5),inst_89342,inst_89345,null));
var state_89377__$1 = state_89377;
return cljs.core.async.ioc_alts_BANG_.call(null,state_89377__$1,(14),inst_89346);
} else {
if((state_val_89378 === (9))){
var inst_89337 = (state_89377[(8)]);
var inst_89363 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),"Figwheel: code autoloading is OFF");
var inst_89364 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_89337);
var inst_89365 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_89364);
var inst_89366 = ["Not loading: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_89365)].join('');
var inst_89367 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),inst_89366);
var state_89377__$1 = (function (){var statearr_89395 = state_89377;
(statearr_89395[(10)] = inst_89363);

return statearr_89395;
})();
var statearr_89396_89433 = state_89377__$1;
(statearr_89396_89433[(2)] = inst_89367);

(statearr_89396_89433[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89378 === (5))){
var inst_89330 = (state_89377[(7)]);
var inst_89332 = [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null];
var inst_89333 = (new cljs.core.PersistentArrayMap(null,2,inst_89332,null));
var inst_89334 = (new cljs.core.PersistentHashSet(null,inst_89333,null));
var inst_89335 = figwheel.client.focus_msgs.call(null,inst_89334,inst_89330);
var inst_89336 = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),inst_89335);
var inst_89337 = cljs.core.first.call(null,inst_89335);
var inst_89338 = figwheel.client.autoload_QMARK_.call(null);
var state_89377__$1 = (function (){var statearr_89397 = state_89377;
(statearr_89397[(8)] = inst_89337);

(statearr_89397[(9)] = inst_89336);

return statearr_89397;
})();
if(cljs.core.truth_(inst_89338)){
var statearr_89398_89434 = state_89377__$1;
(statearr_89398_89434[(1)] = (8));

} else {
var statearr_89399_89435 = state_89377__$1;
(statearr_89399_89435[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89378 === (14))){
var inst_89348 = (state_89377[(2)]);
var state_89377__$1 = state_89377;
var statearr_89400_89441 = state_89377__$1;
(statearr_89400_89441[(2)] = inst_89348);

(statearr_89400_89441[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89378 === (16))){
var state_89377__$1 = state_89377;
var statearr_89401_89442 = state_89377__$1;
(statearr_89401_89442[(2)] = null);

(statearr_89401_89442[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89378 === (10))){
var inst_89369 = (state_89377[(2)]);
var state_89377__$1 = (function (){var statearr_89402 = state_89377;
(statearr_89402[(11)] = inst_89369);

return statearr_89402;
})();
var statearr_89403_89445 = state_89377__$1;
(statearr_89403_89445[(2)] = null);

(statearr_89403_89445[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89378 === (8))){
var inst_89336 = (state_89377[(9)]);
var inst_89340 = figwheel.client.reload_file_state_QMARK_.call(null,inst_89336,opts);
var state_89377__$1 = state_89377;
if(cljs.core.truth_(inst_89340)){
var statearr_89404_89446 = state_89377__$1;
(statearr_89404_89446[(1)] = (11));

} else {
var statearr_89405_89447 = state_89377__$1;
(statearr_89405_89447[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__47173__auto___89416,ch))
;
return ((function (switch__47085__auto__,c__47173__auto___89416,ch){
return (function() {
var figwheel$client$file_reloader_plugin_$_state_machine__47086__auto__ = null;
var figwheel$client$file_reloader_plugin_$_state_machine__47086__auto____0 = (function (){
var statearr_89406 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_89406[(0)] = figwheel$client$file_reloader_plugin_$_state_machine__47086__auto__);

(statearr_89406[(1)] = (1));

return statearr_89406;
});
var figwheel$client$file_reloader_plugin_$_state_machine__47086__auto____1 = (function (state_89377){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_89377);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e89410){if((e89410 instanceof Object)){
var ex__47089__auto__ = e89410;
var statearr_89412_89448 = state_89377;
(statearr_89412_89448[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_89377);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e89410;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__89449 = state_89377;
state_89377 = G__89449;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
figwheel$client$file_reloader_plugin_$_state_machine__47086__auto__ = function(state_89377){
switch(arguments.length){
case 0:
return figwheel$client$file_reloader_plugin_$_state_machine__47086__auto____0.call(this);
case 1:
return figwheel$client$file_reloader_plugin_$_state_machine__47086__auto____1.call(this,state_89377);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloader_plugin_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloader_plugin_$_state_machine__47086__auto____0;
figwheel$client$file_reloader_plugin_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloader_plugin_$_state_machine__47086__auto____1;
return figwheel$client$file_reloader_plugin_$_state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto___89416,ch))
})();
var state__47175__auto__ = (function (){var statearr_89413 = f__47174__auto__.call(null);
(statearr_89413[(6)] = c__47173__auto___89416);

return statearr_89413;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto___89416,ch))
);


return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.truncate_stack_trace = (function figwheel$client$truncate_stack_trace(stack_str){
return cljs.core.take_while.call(null,(function (p1__89454_SHARP_){
return cljs.core.not.call(null,cljs.core.re_matches.call(null,/.*eval_javascript_STAR__STAR_.*/,p1__89454_SHARP_));
}),clojure.string.split_lines.call(null,stack_str));
});
figwheel.client.get_ua_product = (function figwheel$client$get_ua_product(){
if(cljs.core.truth_(figwheel.client.utils.node_env_QMARK_.call(null))){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.SAFARI)){
return new cljs.core.Keyword(null,"safari","safari",497115653);
} else {
if(cljs.core.truth_(goog.userAgent.product.CHROME)){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.FIREFOX)){
return new cljs.core.Keyword(null,"firefox","firefox",1283768880);
} else {
if(cljs.core.truth_(goog.userAgent.product.IE)){
return new cljs.core.Keyword(null,"ie","ie",2038473780);
} else {
return null;
}
}
}
}
}
});
var base_path_89458 = figwheel.client.utils.base_url_path.call(null);
figwheel.client.eval_javascript_STAR__STAR_ = ((function (base_path_89458){
return (function figwheel$client$eval_javascript_STAR__STAR_(code,opts,result_handler){
try{figwheel.client.enable_repl_print_BANG_.call(null);

var result_value = figwheel.client.utils.eval_helper.call(null,code,opts);
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"success","success",1890645906),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),result_value], null));
}catch (e89456){if((e89456 instanceof Error)){
var e = e89456;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),clojure.string.join.call(null,"\n",figwheel.client.truncate_stack_trace.call(null,e.stack)),new cljs.core.Keyword(null,"base-path","base-path",495760020),base_path_89458], null));
} else {
var e = e89456;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),"No stacktrace available."], null));

}
}finally {figwheel.client.enable_repl_print_BANG_.call(null);
}});})(base_path_89458))
;
/**
 * The REPL can disconnect and reconnect lets ensure cljs.user exists at least.
 */
figwheel.client.ensure_cljs_user = (function figwheel$client$ensure_cljs_user(){
if(cljs.core.truth_(cljs.user)){
return null;
} else {
return cljs.user = ({});
}
});
figwheel.client.repl_plugin = (function figwheel$client$repl_plugin(p__89460){
var map__89461 = p__89460;
var map__89461__$1 = ((((!((map__89461 == null)))?((((map__89461.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__89461.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__89461):map__89461);
var opts = map__89461__$1;
var build_id = cljs.core.get.call(null,map__89461__$1,new cljs.core.Keyword(null,"build-id","build-id",1642831089));
return ((function (map__89461,map__89461__$1,opts,build_id){
return (function (p__89465){
var vec__89467 = p__89465;
var seq__89468 = cljs.core.seq.call(null,vec__89467);
var first__89469 = cljs.core.first.call(null,seq__89468);
var seq__89468__$1 = cljs.core.next.call(null,seq__89468);
var map__89470 = first__89469;
var map__89470__$1 = ((((!((map__89470 == null)))?((((map__89470.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__89470.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__89470):map__89470);
var msg = map__89470__$1;
var msg_name = cljs.core.get.call(null,map__89470__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__89468__$1;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"repl-eval","repl-eval",-1784727398),msg_name)){
figwheel.client.ensure_cljs_user.call(null);

return figwheel.client.eval_javascript_STAR__STAR_.call(null,new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(msg),opts,((function (vec__89467,seq__89468,first__89469,seq__89468__$1,map__89470,map__89470__$1,msg,msg_name,_,map__89461,map__89461__$1,opts,build_id){
return (function (res){
return figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),new cljs.core.Keyword(null,"callback-name","callback-name",336964714).cljs$core$IFn$_invoke$arity$1(msg),new cljs.core.Keyword(null,"content","content",15833224),res], null));
});})(vec__89467,seq__89468,first__89469,seq__89468__$1,map__89470,map__89470__$1,msg,msg_name,_,map__89461,map__89461__$1,opts,build_id))
);
} else {
return null;
}
});
;})(map__89461,map__89461__$1,opts,build_id))
});
figwheel.client.css_reloader_plugin = (function figwheel$client$css_reloader_plugin(opts){
return (function (p__89472){
var vec__89473 = p__89472;
var seq__89474 = cljs.core.seq.call(null,vec__89473);
var first__89475 = cljs.core.first.call(null,seq__89474);
var seq__89474__$1 = cljs.core.next.call(null,seq__89474);
var map__89476 = first__89475;
var map__89476__$1 = ((((!((map__89476 == null)))?((((map__89476.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__89476.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__89476):map__89476);
var msg = map__89476__$1;
var msg_name = cljs.core.get.call(null,map__89476__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__89474__$1;
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874))){
return figwheel.client.file_reloading.reload_css_files.call(null,opts,msg);
} else {
return null;
}
});
});
figwheel.client.compile_fail_warning_plugin = (function figwheel$client$compile_fail_warning_plugin(p__89478){
var map__89479 = p__89478;
var map__89479__$1 = ((((!((map__89479 == null)))?((((map__89479.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__89479.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__89479):map__89479);
var on_compile_warning = cljs.core.get.call(null,map__89479__$1,new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947));
var on_compile_fail = cljs.core.get.call(null,map__89479__$1,new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036));
return ((function (map__89479,map__89479__$1,on_compile_warning,on_compile_fail){
return (function (p__89481){
var vec__89482 = p__89481;
var seq__89483 = cljs.core.seq.call(null,vec__89482);
var first__89484 = cljs.core.first.call(null,seq__89483);
var seq__89483__$1 = cljs.core.next.call(null,seq__89483);
var map__89485 = first__89484;
var map__89485__$1 = ((((!((map__89485 == null)))?((((map__89485.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__89485.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__89485):map__89485);
var msg = map__89485__$1;
var msg_name = cljs.core.get.call(null,map__89485__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__89483__$1;
var pred__89487 = cljs.core._EQ_;
var expr__89488 = msg_name;
if(cljs.core.truth_(pred__89487.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),expr__89488))){
return on_compile_warning.call(null,msg);
} else {
if(cljs.core.truth_(pred__89487.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),expr__89488))){
return on_compile_fail.call(null,msg);
} else {
return null;
}
}
});
;})(map__89479,map__89479__$1,on_compile_warning,on_compile_fail))
});
figwheel.client.auto_jump_to_error = (function figwheel$client$auto_jump_to_error(opts,error){
if(cljs.core.truth_(new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920).cljs$core$IFn$_invoke$arity$1(opts))){
return figwheel.client.heads_up.auto_notify_source_file_line.call(null,error);
} else {
return null;
}
});
figwheel.client.heads_up_plugin_msg_handler = (function figwheel$client$heads_up_plugin_msg_handler(opts,msg_hist_SINGLEQUOTE_){
var msg_hist = figwheel.client.focus_msgs.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null], null), null),msg_hist_SINGLEQUOTE_);
var msg_names = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),msg_hist);
var msg = cljs.core.first.call(null,msg_hist);
var c__47173__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto__,msg_hist,msg_names,msg){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto__,msg_hist,msg_names,msg){
return (function (state_89578){
var state_val_89579 = (state_89578[(1)]);
if((state_val_89579 === (7))){
var inst_89498 = (state_89578[(2)]);
var state_89578__$1 = state_89578;
if(cljs.core.truth_(inst_89498)){
var statearr_89580_89661 = state_89578__$1;
(statearr_89580_89661[(1)] = (8));

} else {
var statearr_89581_89664 = state_89578__$1;
(statearr_89581_89664[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89579 === (20))){
var inst_89572 = (state_89578[(2)]);
var state_89578__$1 = state_89578;
var statearr_89582_89670 = state_89578__$1;
(statearr_89582_89670[(2)] = inst_89572);

(statearr_89582_89670[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89579 === (27))){
var inst_89568 = (state_89578[(2)]);
var state_89578__$1 = state_89578;
var statearr_89584_89671 = state_89578__$1;
(statearr_89584_89671[(2)] = inst_89568);

(statearr_89584_89671[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89579 === (1))){
var inst_89490 = figwheel.client.reload_file_state_QMARK_.call(null,msg_names,opts);
var state_89578__$1 = state_89578;
if(cljs.core.truth_(inst_89490)){
var statearr_89585_89674 = state_89578__$1;
(statearr_89585_89674[(1)] = (2));

} else {
var statearr_89586_89675 = state_89578__$1;
(statearr_89586_89675[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89579 === (24))){
var inst_89570 = (state_89578[(2)]);
var state_89578__$1 = state_89578;
var statearr_89587_89677 = state_89578__$1;
(statearr_89587_89677[(2)] = inst_89570);

(statearr_89587_89677[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89579 === (4))){
var inst_89576 = (state_89578[(2)]);
var state_89578__$1 = state_89578;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_89578__$1,inst_89576);
} else {
if((state_val_89579 === (15))){
var inst_89574 = (state_89578[(2)]);
var state_89578__$1 = state_89578;
var statearr_89588_89680 = state_89578__$1;
(statearr_89588_89680[(2)] = inst_89574);

(statearr_89588_89680[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89579 === (21))){
var inst_89527 = (state_89578[(2)]);
var inst_89528 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_89529 = figwheel.client.auto_jump_to_error.call(null,opts,inst_89528);
var state_89578__$1 = (function (){var statearr_89589 = state_89578;
(statearr_89589[(7)] = inst_89527);

return statearr_89589;
})();
var statearr_89590_89683 = state_89578__$1;
(statearr_89590_89683[(2)] = inst_89529);

(statearr_89590_89683[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89579 === (31))){
var inst_89557 = figwheel.client.css_loaded_state_QMARK_.call(null,msg_names);
var state_89578__$1 = state_89578;
if(cljs.core.truth_(inst_89557)){
var statearr_89591_89685 = state_89578__$1;
(statearr_89591_89685[(1)] = (34));

} else {
var statearr_89592_89686 = state_89578__$1;
(statearr_89592_89686[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89579 === (32))){
var inst_89566 = (state_89578[(2)]);
var state_89578__$1 = state_89578;
var statearr_89593_89687 = state_89578__$1;
(statearr_89593_89687[(2)] = inst_89566);

(statearr_89593_89687[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89579 === (33))){
var inst_89553 = (state_89578[(2)]);
var inst_89554 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_89555 = figwheel.client.auto_jump_to_error.call(null,opts,inst_89554);
var state_89578__$1 = (function (){var statearr_89594 = state_89578;
(statearr_89594[(8)] = inst_89553);

return statearr_89594;
})();
var statearr_89595_89694 = state_89578__$1;
(statearr_89595_89694[(2)] = inst_89555);

(statearr_89595_89694[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89579 === (13))){
var inst_89512 = figwheel.client.heads_up.clear.call(null);
var state_89578__$1 = state_89578;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_89578__$1,(16),inst_89512);
} else {
if((state_val_89579 === (22))){
var inst_89533 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_89534 = figwheel.client.heads_up.append_warning_message.call(null,inst_89533);
var state_89578__$1 = state_89578;
var statearr_89598_89701 = state_89578__$1;
(statearr_89598_89701[(2)] = inst_89534);

(statearr_89598_89701[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89579 === (36))){
var inst_89564 = (state_89578[(2)]);
var state_89578__$1 = state_89578;
var statearr_89601_89704 = state_89578__$1;
(statearr_89601_89704[(2)] = inst_89564);

(statearr_89601_89704[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89579 === (29))){
var inst_89544 = (state_89578[(2)]);
var inst_89545 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_89546 = figwheel.client.auto_jump_to_error.call(null,opts,inst_89545);
var state_89578__$1 = (function (){var statearr_89603 = state_89578;
(statearr_89603[(9)] = inst_89544);

return statearr_89603;
})();
var statearr_89604_89709 = state_89578__$1;
(statearr_89604_89709[(2)] = inst_89546);

(statearr_89604_89709[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89579 === (6))){
var inst_89493 = (state_89578[(10)]);
var state_89578__$1 = state_89578;
var statearr_89606_89711 = state_89578__$1;
(statearr_89606_89711[(2)] = inst_89493);

(statearr_89606_89711[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89579 === (28))){
var inst_89540 = (state_89578[(2)]);
var inst_89541 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_89542 = figwheel.client.heads_up.display_warning.call(null,inst_89541);
var state_89578__$1 = (function (){var statearr_89607 = state_89578;
(statearr_89607[(11)] = inst_89540);

return statearr_89607;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_89578__$1,(29),inst_89542);
} else {
if((state_val_89579 === (25))){
var inst_89538 = figwheel.client.heads_up.clear.call(null);
var state_89578__$1 = state_89578;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_89578__$1,(28),inst_89538);
} else {
if((state_val_89579 === (34))){
var inst_89559 = figwheel.client.heads_up.flash_loaded.call(null);
var state_89578__$1 = state_89578;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_89578__$1,(37),inst_89559);
} else {
if((state_val_89579 === (17))){
var inst_89518 = (state_89578[(2)]);
var inst_89519 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_89520 = figwheel.client.auto_jump_to_error.call(null,opts,inst_89519);
var state_89578__$1 = (function (){var statearr_89609 = state_89578;
(statearr_89609[(12)] = inst_89518);

return statearr_89609;
})();
var statearr_89610_89720 = state_89578__$1;
(statearr_89610_89720[(2)] = inst_89520);

(statearr_89610_89720[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89579 === (3))){
var inst_89510 = figwheel.client.compile_refail_state_QMARK_.call(null,msg_names);
var state_89578__$1 = state_89578;
if(cljs.core.truth_(inst_89510)){
var statearr_89611_89723 = state_89578__$1;
(statearr_89611_89723[(1)] = (13));

} else {
var statearr_89612_89725 = state_89578__$1;
(statearr_89612_89725[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89579 === (12))){
var inst_89506 = (state_89578[(2)]);
var state_89578__$1 = state_89578;
var statearr_89615_89726 = state_89578__$1;
(statearr_89615_89726[(2)] = inst_89506);

(statearr_89615_89726[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89579 === (2))){
var inst_89493 = (state_89578[(10)]);
var inst_89493__$1 = figwheel.client.autoload_QMARK_.call(null);
var state_89578__$1 = (function (){var statearr_89616 = state_89578;
(statearr_89616[(10)] = inst_89493__$1);

return statearr_89616;
})();
if(cljs.core.truth_(inst_89493__$1)){
var statearr_89617_89731 = state_89578__$1;
(statearr_89617_89731[(1)] = (5));

} else {
var statearr_89620_89732 = state_89578__$1;
(statearr_89620_89732[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89579 === (23))){
var inst_89536 = figwheel.client.rewarning_state_QMARK_.call(null,msg_names);
var state_89578__$1 = state_89578;
if(cljs.core.truth_(inst_89536)){
var statearr_89622_89734 = state_89578__$1;
(statearr_89622_89734[(1)] = (25));

} else {
var statearr_89624_89735 = state_89578__$1;
(statearr_89624_89735[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89579 === (35))){
var state_89578__$1 = state_89578;
var statearr_89625_89738 = state_89578__$1;
(statearr_89625_89738[(2)] = null);

(statearr_89625_89738[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89579 === (19))){
var inst_89531 = figwheel.client.warning_append_state_QMARK_.call(null,msg_names);
var state_89578__$1 = state_89578;
if(cljs.core.truth_(inst_89531)){
var statearr_89626_89741 = state_89578__$1;
(statearr_89626_89741[(1)] = (22));

} else {
var statearr_89627_89744 = state_89578__$1;
(statearr_89627_89744[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89579 === (11))){
var inst_89502 = (state_89578[(2)]);
var state_89578__$1 = state_89578;
var statearr_89628_89745 = state_89578__$1;
(statearr_89628_89745[(2)] = inst_89502);

(statearr_89628_89745[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89579 === (9))){
var inst_89504 = figwheel.client.heads_up.clear.call(null);
var state_89578__$1 = state_89578;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_89578__$1,(12),inst_89504);
} else {
if((state_val_89579 === (5))){
var inst_89495 = new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(opts);
var state_89578__$1 = state_89578;
var statearr_89633_89750 = state_89578__$1;
(statearr_89633_89750[(2)] = inst_89495);

(statearr_89633_89750[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89579 === (14))){
var inst_89522 = figwheel.client.compile_fail_state_QMARK_.call(null,msg_names);
var state_89578__$1 = state_89578;
if(cljs.core.truth_(inst_89522)){
var statearr_89634_89752 = state_89578__$1;
(statearr_89634_89752[(1)] = (18));

} else {
var statearr_89635_89753 = state_89578__$1;
(statearr_89635_89753[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89579 === (26))){
var inst_89548 = figwheel.client.warning_state_QMARK_.call(null,msg_names);
var state_89578__$1 = state_89578;
if(cljs.core.truth_(inst_89548)){
var statearr_89638_89756 = state_89578__$1;
(statearr_89638_89756[(1)] = (30));

} else {
var statearr_89639_89759 = state_89578__$1;
(statearr_89639_89759[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89579 === (16))){
var inst_89514 = (state_89578[(2)]);
var inst_89515 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_89516 = figwheel.client.heads_up.display_exception.call(null,inst_89515);
var state_89578__$1 = (function (){var statearr_89640 = state_89578;
(statearr_89640[(13)] = inst_89514);

return statearr_89640;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_89578__$1,(17),inst_89516);
} else {
if((state_val_89579 === (30))){
var inst_89550 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_89551 = figwheel.client.heads_up.display_warning.call(null,inst_89550);
var state_89578__$1 = state_89578;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_89578__$1,(33),inst_89551);
} else {
if((state_val_89579 === (10))){
var inst_89508 = (state_89578[(2)]);
var state_89578__$1 = state_89578;
var statearr_89641_89766 = state_89578__$1;
(statearr_89641_89766[(2)] = inst_89508);

(statearr_89641_89766[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89579 === (18))){
var inst_89524 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_89525 = figwheel.client.heads_up.display_exception.call(null,inst_89524);
var state_89578__$1 = state_89578;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_89578__$1,(21),inst_89525);
} else {
if((state_val_89579 === (37))){
var inst_89561 = (state_89578[(2)]);
var state_89578__$1 = state_89578;
var statearr_89642_89774 = state_89578__$1;
(statearr_89642_89774[(2)] = inst_89561);

(statearr_89642_89774[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89579 === (8))){
var inst_89500 = figwheel.client.heads_up.flash_loaded.call(null);
var state_89578__$1 = state_89578;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_89578__$1,(11),inst_89500);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__47173__auto__,msg_hist,msg_names,msg))
;
return ((function (switch__47085__auto__,c__47173__auto__,msg_hist,msg_names,msg){
return (function() {
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__47086__auto__ = null;
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__47086__auto____0 = (function (){
var statearr_89649 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_89649[(0)] = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__47086__auto__);

(statearr_89649[(1)] = (1));

return statearr_89649;
});
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__47086__auto____1 = (function (state_89578){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_89578);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e89650){if((e89650 instanceof Object)){
var ex__47089__auto__ = e89650;
var statearr_89651_89787 = state_89578;
(statearr_89651_89787[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_89578);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e89650;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__89789 = state_89578;
state_89578 = G__89789;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__47086__auto__ = function(state_89578){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__47086__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__47086__auto____1.call(this,state_89578);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__47086__auto____0;
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__47086__auto____1;
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto__,msg_hist,msg_names,msg))
})();
var state__47175__auto__ = (function (){var statearr_89653 = f__47174__auto__.call(null);
(statearr_89653[(6)] = c__47173__auto__);

return statearr_89653;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto__,msg_hist,msg_names,msg))
);

return c__47173__auto__;
});
figwheel.client.heads_up_plugin = (function figwheel$client$heads_up_plugin(opts){
var ch = cljs.core.async.chan.call(null);
figwheel.client.heads_up_config_options_STAR__STAR_ = opts;

var c__47173__auto___89845 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto___89845,ch){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto___89845,ch){
return (function (state_89810){
var state_val_89811 = (state_89810[(1)]);
if((state_val_89811 === (1))){
var state_89810__$1 = state_89810;
var statearr_89814_89848 = state_89810__$1;
(statearr_89814_89848[(2)] = null);

(statearr_89814_89848[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89811 === (2))){
var state_89810__$1 = state_89810;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_89810__$1,(4),ch);
} else {
if((state_val_89811 === (3))){
var inst_89808 = (state_89810[(2)]);
var state_89810__$1 = state_89810;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_89810__$1,inst_89808);
} else {
if((state_val_89811 === (4))){
var inst_89798 = (state_89810[(7)]);
var inst_89798__$1 = (state_89810[(2)]);
var state_89810__$1 = (function (){var statearr_89817 = state_89810;
(statearr_89817[(7)] = inst_89798__$1);

return statearr_89817;
})();
if(cljs.core.truth_(inst_89798__$1)){
var statearr_89818_89854 = state_89810__$1;
(statearr_89818_89854[(1)] = (5));

} else {
var statearr_89822_89855 = state_89810__$1;
(statearr_89822_89855[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89811 === (5))){
var inst_89798 = (state_89810[(7)]);
var inst_89800 = figwheel.client.heads_up_plugin_msg_handler.call(null,opts,inst_89798);
var state_89810__$1 = state_89810;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_89810__$1,(8),inst_89800);
} else {
if((state_val_89811 === (6))){
var state_89810__$1 = state_89810;
var statearr_89824_89861 = state_89810__$1;
(statearr_89824_89861[(2)] = null);

(statearr_89824_89861[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89811 === (7))){
var inst_89806 = (state_89810[(2)]);
var state_89810__$1 = state_89810;
var statearr_89825_89862 = state_89810__$1;
(statearr_89825_89862[(2)] = inst_89806);

(statearr_89825_89862[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89811 === (8))){
var inst_89802 = (state_89810[(2)]);
var state_89810__$1 = (function (){var statearr_89826 = state_89810;
(statearr_89826[(8)] = inst_89802);

return statearr_89826;
})();
var statearr_89827_89865 = state_89810__$1;
(statearr_89827_89865[(2)] = null);

(statearr_89827_89865[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__47173__auto___89845,ch))
;
return ((function (switch__47085__auto__,c__47173__auto___89845,ch){
return (function() {
var figwheel$client$heads_up_plugin_$_state_machine__47086__auto__ = null;
var figwheel$client$heads_up_plugin_$_state_machine__47086__auto____0 = (function (){
var statearr_89830 = [null,null,null,null,null,null,null,null,null];
(statearr_89830[(0)] = figwheel$client$heads_up_plugin_$_state_machine__47086__auto__);

(statearr_89830[(1)] = (1));

return statearr_89830;
});
var figwheel$client$heads_up_plugin_$_state_machine__47086__auto____1 = (function (state_89810){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_89810);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e89836){if((e89836 instanceof Object)){
var ex__47089__auto__ = e89836;
var statearr_89839_89871 = state_89810;
(statearr_89839_89871[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_89810);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e89836;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__89876 = state_89810;
state_89810 = G__89876;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_$_state_machine__47086__auto__ = function(state_89810){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_$_state_machine__47086__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_$_state_machine__47086__auto____1.call(this,state_89810);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$heads_up_plugin_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_$_state_machine__47086__auto____0;
figwheel$client$heads_up_plugin_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_$_state_machine__47086__auto____1;
return figwheel$client$heads_up_plugin_$_state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto___89845,ch))
})();
var state__47175__auto__ = (function (){var statearr_89842 = f__47174__auto__.call(null);
(statearr_89842[(6)] = c__47173__auto___89845);

return statearr_89842;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto___89845,ch))
);


figwheel.client.heads_up.ensure_container.call(null);

return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.enforce_project_plugin = (function figwheel$client$enforce_project_plugin(opts){
return (function (msg_hist){
if(((1) < cljs.core.count.call(null,cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"project-id","project-id",206449307),cljs.core.take.call(null,(5),msg_hist)))))){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different project. Shutting socket down.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__47173__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto__){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto__){
return (function (state_89885){
var state_val_89886 = (state_89885[(1)]);
if((state_val_89886 === (1))){
var inst_89879 = cljs.core.async.timeout.call(null,(3000));
var state_89885__$1 = state_89885;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_89885__$1,(2),inst_89879);
} else {
if((state_val_89886 === (2))){
var inst_89881 = (state_89885[(2)]);
var inst_89883 = figwheel.client.heads_up.display_system_warning.call(null,"Connection from different project","Shutting connection down!!!!!");
var state_89885__$1 = (function (){var statearr_89890 = state_89885;
(statearr_89890[(7)] = inst_89881);

return statearr_89890;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_89885__$1,inst_89883);
} else {
return null;
}
}
});})(c__47173__auto__))
;
return ((function (switch__47085__auto__,c__47173__auto__){
return (function() {
var figwheel$client$enforce_project_plugin_$_state_machine__47086__auto__ = null;
var figwheel$client$enforce_project_plugin_$_state_machine__47086__auto____0 = (function (){
var statearr_89891 = [null,null,null,null,null,null,null,null];
(statearr_89891[(0)] = figwheel$client$enforce_project_plugin_$_state_machine__47086__auto__);

(statearr_89891[(1)] = (1));

return statearr_89891;
});
var figwheel$client$enforce_project_plugin_$_state_machine__47086__auto____1 = (function (state_89885){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_89885);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e89892){if((e89892 instanceof Object)){
var ex__47089__auto__ = e89892;
var statearr_89894_89905 = state_89885;
(statearr_89894_89905[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_89885);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e89892;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__89906 = state_89885;
state_89885 = G__89906;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
figwheel$client$enforce_project_plugin_$_state_machine__47086__auto__ = function(state_89885){
switch(arguments.length){
case 0:
return figwheel$client$enforce_project_plugin_$_state_machine__47086__auto____0.call(this);
case 1:
return figwheel$client$enforce_project_plugin_$_state_machine__47086__auto____1.call(this,state_89885);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$enforce_project_plugin_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_project_plugin_$_state_machine__47086__auto____0;
figwheel$client$enforce_project_plugin_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_project_plugin_$_state_machine__47086__auto____1;
return figwheel$client$enforce_project_plugin_$_state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto__))
})();
var state__47175__auto__ = (function (){var statearr_89898 = f__47174__auto__.call(null);
(statearr_89898[(6)] = c__47173__auto__);

return statearr_89898;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto__))
);

return c__47173__auto__;
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.enforce_figwheel_version_plugin = (function figwheel$client$enforce_figwheel_version_plugin(opts){
return (function (msg_hist){
var temp__4657__auto__ = new cljs.core.Keyword(null,"figwheel-version","figwheel-version",1409553832).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,msg_hist));
if(cljs.core.truth_(temp__4657__auto__)){
var figwheel_version = temp__4657__auto__;
if(cljs.core.not_EQ_.call(null,figwheel_version,figwheel.client._figwheel_version_)){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different version of Figwheel.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__47173__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto__,figwheel_version,temp__4657__auto__){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto__,figwheel_version,temp__4657__auto__){
return (function (state_89917){
var state_val_89918 = (state_89917[(1)]);
if((state_val_89918 === (1))){
var inst_89911 = cljs.core.async.timeout.call(null,(2000));
var state_89917__$1 = state_89917;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_89917__$1,(2),inst_89911);
} else {
if((state_val_89918 === (2))){
var inst_89913 = (state_89917[(2)]);
var inst_89914 = ["Figwheel Client Version <strong>",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client._figwheel_version_),"</strong> is not equal to ","Figwheel Sidecar Version <strong>",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel_version),"</strong>",".  Shutting down Websocket Connection!","<h4>To fix try:</h4>","<ol><li>Reload this page and make sure you are not getting a cached version of the client.</li>","<li>You may have to clean (delete compiled assets) and rebuild to make sure that the new client code is being used.</li>","<li>Also, make sure you have consistent Figwheel dependencies.</li></ol>"].join('');
var inst_89915 = figwheel.client.heads_up.display_system_warning.call(null,"Figwheel Client and Server have different versions!!",inst_89914);
var state_89917__$1 = (function (){var statearr_89920 = state_89917;
(statearr_89920[(7)] = inst_89913);

return statearr_89920;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_89917__$1,inst_89915);
} else {
return null;
}
}
});})(c__47173__auto__,figwheel_version,temp__4657__auto__))
;
return ((function (switch__47085__auto__,c__47173__auto__,figwheel_version,temp__4657__auto__){
return (function() {
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__47086__auto__ = null;
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__47086__auto____0 = (function (){
var statearr_89923 = [null,null,null,null,null,null,null,null];
(statearr_89923[(0)] = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__47086__auto__);

(statearr_89923[(1)] = (1));

return statearr_89923;
});
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__47086__auto____1 = (function (state_89917){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_89917);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e89924){if((e89924 instanceof Object)){
var ex__47089__auto__ = e89924;
var statearr_89925_89939 = state_89917;
(statearr_89925_89939[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_89917);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e89924;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__89941 = state_89917;
state_89917 = G__89941;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__47086__auto__ = function(state_89917){
switch(arguments.length){
case 0:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__47086__auto____0.call(this);
case 1:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__47086__auto____1.call(this,state_89917);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__47086__auto____0;
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__47086__auto____1;
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto__,figwheel_version,temp__4657__auto__))
})();
var state__47175__auto__ = (function (){var statearr_89928 = f__47174__auto__.call(null);
(statearr_89928[(6)] = c__47173__auto__);

return statearr_89928;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto__,figwheel_version,temp__4657__auto__))
);

return c__47173__auto__;
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.default_on_jsload = cljs.core.identity;
figwheel.client.file_line_column = (function figwheel$client$file_line_column(p__89947){
var map__89948 = p__89947;
var map__89948__$1 = ((((!((map__89948 == null)))?((((map__89948.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__89948.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__89948):map__89948);
var file = cljs.core.get.call(null,map__89948__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var line = cljs.core.get.call(null,map__89948__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column = cljs.core.get.call(null,map__89948__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var G__89951 = "";
var G__89951__$1 = (cljs.core.truth_(file)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__89951),"file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''):G__89951);
var G__89951__$2 = (cljs.core.truth_(line)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__89951__$1)," at line ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line)].join(''):G__89951__$1);
if(cljs.core.truth_((function (){var and__28129__auto__ = line;
if(cljs.core.truth_(and__28129__auto__)){
return column;
} else {
return and__28129__auto__;
}
})())){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__89951__$2),", column ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column)].join('');
} else {
return G__89951__$2;
}
});
figwheel.client.default_on_compile_fail = (function figwheel$client$default_on_compile_fail(p__89962){
var map__89963 = p__89962;
var map__89963__$1 = ((((!((map__89963 == null)))?((((map__89963.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__89963.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__89963):map__89963);
var ed = map__89963__$1;
var formatted_exception = cljs.core.get.call(null,map__89963__$1,new cljs.core.Keyword(null,"formatted-exception","formatted-exception",-116489026));
var exception_data = cljs.core.get.call(null,map__89963__$1,new cljs.core.Keyword(null,"exception-data","exception-data",-512474886));
var cause = cljs.core.get.call(null,map__89963__$1,new cljs.core.Keyword(null,"cause","cause",231901252));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: Compile Exception");

var seq__89967_89985 = cljs.core.seq.call(null,figwheel.client.format_messages.call(null,exception_data));
var chunk__89968_89986 = null;
var count__89969_89987 = (0);
var i__89970_89988 = (0);
while(true){
if((i__89970_89988 < count__89969_89987)){
var msg_89989 = cljs.core._nth.call(null,chunk__89968_89986,i__89970_89988);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_89989);

var G__89990 = seq__89967_89985;
var G__89991 = chunk__89968_89986;
var G__89992 = count__89969_89987;
var G__89993 = (i__89970_89988 + (1));
seq__89967_89985 = G__89990;
chunk__89968_89986 = G__89991;
count__89969_89987 = G__89992;
i__89970_89988 = G__89993;
continue;
} else {
var temp__4657__auto___89995 = cljs.core.seq.call(null,seq__89967_89985);
if(temp__4657__auto___89995){
var seq__89967_89996__$1 = temp__4657__auto___89995;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__89967_89996__$1)){
var c__28980__auto___89997 = cljs.core.chunk_first.call(null,seq__89967_89996__$1);
var G__89998 = cljs.core.chunk_rest.call(null,seq__89967_89996__$1);
var G__89999 = c__28980__auto___89997;
var G__90000 = cljs.core.count.call(null,c__28980__auto___89997);
var G__90001 = (0);
seq__89967_89985 = G__89998;
chunk__89968_89986 = G__89999;
count__89969_89987 = G__90000;
i__89970_89988 = G__90001;
continue;
} else {
var msg_90005 = cljs.core.first.call(null,seq__89967_89996__$1);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_90005);

var G__90006 = cljs.core.next.call(null,seq__89967_89996__$1);
var G__90007 = null;
var G__90008 = (0);
var G__90009 = (0);
seq__89967_89985 = G__90006;
chunk__89968_89986 = G__90007;
count__89969_89987 = G__90008;
i__89970_89988 = G__90009;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(cause)){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),["Error on ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_line_column.call(null,ed))].join(''));
} else {
}

return ed;
});
figwheel.client.default_on_compile_warning = (function figwheel$client$default_on_compile_warning(p__90015){
var map__90016 = p__90015;
var map__90016__$1 = ((((!((map__90016 == null)))?((((map__90016.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__90016.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__90016):map__90016);
var w = map__90016__$1;
var message = cljs.core.get.call(null,map__90016__$1,new cljs.core.Keyword(null,"message","message",-406056002));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),["Figwheel: Compile Warning - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(message))," in ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_line_column.call(null,message))].join(''));

return w;
});
figwheel.client.default_before_load = (function figwheel$client$default_before_load(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: notified of file changes");

return files;
});
figwheel.client.default_on_cssload = (function figwheel$client$default_on_cssload(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded CSS files");

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),cljs.core.pr_str.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files)));

return files;
});
if(typeof figwheel.client.config_defaults !== 'undefined'){
} else {
figwheel.client.config_defaults = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947),new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430),new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036),new cljs.core.Keyword(null,"debug","debug",-1608172596),new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202),new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938),new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920),new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128),new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223),new cljs.core.Keyword(null,"eval-fn","eval-fn",-1111644294),new cljs.core.Keyword(null,"retry-count","retry-count",1936122875),new cljs.core.Keyword(null,"autoload","autoload",-354122500),new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318)],[new cljs.core.Var(function(){return figwheel.client.default_on_compile_warning;},new cljs.core.Symbol("figwheel.client","default-on-compile-warning","figwheel.client/default-on-compile-warning",584144208,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-warning","default-on-compile-warning",-18911586,null),"resources/public/js/compiled/devcards_out/figwheel/client.cljs",33,1,363,363,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"message","message",1234475525,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"w","w",1994700528,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_warning)?figwheel.client.default_on_compile_warning.cljs$lang$test:null)])),figwheel.client.default_on_jsload,true,new cljs.core.Var(function(){return figwheel.client.default_on_compile_fail;},new cljs.core.Symbol("figwheel.client","default-on-compile-fail","figwheel.client/default-on-compile-fail",1384826337,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-fail","default-on-compile-fail",-158814813,null),"resources/public/js/compiled/devcards_out/figwheel/client.cljs",30,1,355,355,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"formatted-exception","formatted-exception",1524042501,null),new cljs.core.Symbol(null,"exception-data","exception-data",1128056641,null),new cljs.core.Symbol(null,"cause","cause",1872432779,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"ed","ed",2076825751,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_fail)?figwheel.client.default_on_compile_fail.cljs$lang$test:null)])),false,true,["ws://",cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))?location.host:"localhost:3449")),"/figwheel-ws"].join(''),false,figwheel.client.default_before_load,false,false,(100),true,figwheel.client.default_on_cssload]);
}
figwheel.client.handle_deprecated_jsload_callback = (function figwheel$client$handle_deprecated_jsload_callback(config){
if(cljs.core.truth_(new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config))){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,config,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config)),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369));
} else {
return config;
}
});
figwheel.client.fill_url_template = (function figwheel$client$fill_url_template(config){
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
return cljs.core.update_in.call(null,config,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938)], null),(function (x){
return clojure.string.replace.call(null,clojure.string.replace.call(null,x,"[[client-hostname]]",location.hostname),"[[client-port]]",location.port);
}));
} else {
return config;
}
});
figwheel.client.base_plugins = (function figwheel$client$base_plugins(system_options){
var base = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"enforce-project-plugin","enforce-project-plugin",959402899),figwheel.client.enforce_project_plugin,new cljs.core.Keyword(null,"enforce-figwheel-version-plugin","enforce-figwheel-version-plugin",-1916185220),figwheel.client.enforce_figwheel_version_plugin,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),figwheel.client.file_reloader_plugin,new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),figwheel.client.compile_fail_warning_plugin,new cljs.core.Keyword(null,"css-reloader-plugin","css-reloader-plugin",2002032904),figwheel.client.css_reloader_plugin,new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371),figwheel.client.repl_plugin], null);
var base__$1 = ((cljs.core.not.call(null,figwheel.client.utils.html_env_QMARK_.call(null)))?cljs.core.select_keys.call(null,base,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371)], null)):base);
var base__$2 = ((new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(system_options) === false)?cljs.core.dissoc.call(null,base__$1,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733)):base__$1);
if(cljs.core.truth_((function (){var and__28129__auto__ = new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(system_options);
if(cljs.core.truth_(and__28129__auto__)){
return figwheel.client.utils.html_env_QMARK_.call(null);
} else {
return and__28129__auto__;
}
})())){
return cljs.core.assoc.call(null,base__$2,new cljs.core.Keyword(null,"heads-up-display-plugin","heads-up-display-plugin",1745207501),figwheel.client.heads_up_plugin);
} else {
return base__$2;
}
});
figwheel.client.add_message_watch = (function figwheel$client$add_message_watch(key,callback){
return cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,key,(function (_,___$1,___$2,msg_hist){
return callback.call(null,cljs.core.first.call(null,msg_hist));
}));
});
figwheel.client.add_plugins = (function figwheel$client$add_plugins(plugins,system_options){
var seq__90101 = cljs.core.seq.call(null,plugins);
var chunk__90102 = null;
var count__90103 = (0);
var i__90104 = (0);
while(true){
if((i__90104 < count__90103)){
var vec__90107 = cljs.core._nth.call(null,chunk__90102,i__90104);
var k = cljs.core.nth.call(null,vec__90107,(0),null);
var plugin = cljs.core.nth.call(null,vec__90107,(1),null);
if(cljs.core.truth_(plugin)){
var pl_90122 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__90101,chunk__90102,count__90103,i__90104,pl_90122,vec__90107,k,plugin){
return (function (_,___$1,___$2,msg_hist){
return pl_90122.call(null,msg_hist);
});})(seq__90101,chunk__90102,count__90103,i__90104,pl_90122,vec__90107,k,plugin))
);
} else {
}

var G__90127 = seq__90101;
var G__90128 = chunk__90102;
var G__90129 = count__90103;
var G__90130 = (i__90104 + (1));
seq__90101 = G__90127;
chunk__90102 = G__90128;
count__90103 = G__90129;
i__90104 = G__90130;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__90101);
if(temp__4657__auto__){
var seq__90101__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__90101__$1)){
var c__28980__auto__ = cljs.core.chunk_first.call(null,seq__90101__$1);
var G__90135 = cljs.core.chunk_rest.call(null,seq__90101__$1);
var G__90136 = c__28980__auto__;
var G__90137 = cljs.core.count.call(null,c__28980__auto__);
var G__90138 = (0);
seq__90101 = G__90135;
chunk__90102 = G__90136;
count__90103 = G__90137;
i__90104 = G__90138;
continue;
} else {
var vec__90114 = cljs.core.first.call(null,seq__90101__$1);
var k = cljs.core.nth.call(null,vec__90114,(0),null);
var plugin = cljs.core.nth.call(null,vec__90114,(1),null);
if(cljs.core.truth_(plugin)){
var pl_90143 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__90101,chunk__90102,count__90103,i__90104,pl_90143,vec__90114,k,plugin,seq__90101__$1,temp__4657__auto__){
return (function (_,___$1,___$2,msg_hist){
return pl_90143.call(null,msg_hist);
});})(seq__90101,chunk__90102,count__90103,i__90104,pl_90143,vec__90114,k,plugin,seq__90101__$1,temp__4657__auto__))
);
} else {
}

var G__90144 = cljs.core.next.call(null,seq__90101__$1);
var G__90145 = null;
var G__90146 = (0);
var G__90147 = (0);
seq__90101 = G__90144;
chunk__90102 = G__90145;
count__90103 = G__90146;
i__90104 = G__90147;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.start = (function figwheel$client$start(var_args){
var G__90149 = arguments.length;
switch (G__90149) {
case 1:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 0:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$0();

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$1 = (function (opts){
if((goog.dependencies_ == null)){
return null;
} else {
if(typeof figwheel.client.__figwheel_start_once__ !== 'undefined'){
return null;
} else {
return (
figwheel.client.__figwheel_start_once__ = setTimeout((function (){
var plugins_SINGLEQUOTE_ = new cljs.core.Keyword(null,"plugins","plugins",1900073717).cljs$core$IFn$_invoke$arity$1(opts);
var merge_plugins = new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370).cljs$core$IFn$_invoke$arity$1(opts);
var system_options = figwheel.client.fill_url_template.call(null,figwheel.client.handle_deprecated_jsload_callback.call(null,cljs.core.merge.call(null,figwheel.client.config_defaults,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"plugins","plugins",1900073717),new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370)))));
var plugins = (cljs.core.truth_(plugins_SINGLEQUOTE_)?plugins_SINGLEQUOTE_:cljs.core.merge.call(null,figwheel.client.base_plugins.call(null,system_options),merge_plugins));
figwheel.client.utils._STAR_print_debug_STAR_ = new cljs.core.Keyword(null,"debug","debug",-1608172596).cljs$core$IFn$_invoke$arity$1(opts);

figwheel.client.enable_repl_print_BANG_.call(null);

figwheel.client.add_plugins.call(null,plugins,system_options);

figwheel.client.file_reloading.patch_goog_base.call(null);

var seq__90150_90157 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"initial-messages","initial-messages",2057377771).cljs$core$IFn$_invoke$arity$1(system_options));
var chunk__90151_90158 = null;
var count__90152_90159 = (0);
var i__90153_90160 = (0);
while(true){
if((i__90153_90160 < count__90152_90159)){
var msg_90161 = cljs.core._nth.call(null,chunk__90151_90158,i__90153_90160);
figwheel.client.socket.handle_incoming_message.call(null,msg_90161);

var G__90162 = seq__90150_90157;
var G__90163 = chunk__90151_90158;
var G__90164 = count__90152_90159;
var G__90165 = (i__90153_90160 + (1));
seq__90150_90157 = G__90162;
chunk__90151_90158 = G__90163;
count__90152_90159 = G__90164;
i__90153_90160 = G__90165;
continue;
} else {
var temp__4657__auto___90167 = cljs.core.seq.call(null,seq__90150_90157);
if(temp__4657__auto___90167){
var seq__90150_90168__$1 = temp__4657__auto___90167;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__90150_90168__$1)){
var c__28980__auto___90169 = cljs.core.chunk_first.call(null,seq__90150_90168__$1);
var G__90170 = cljs.core.chunk_rest.call(null,seq__90150_90168__$1);
var G__90171 = c__28980__auto___90169;
var G__90172 = cljs.core.count.call(null,c__28980__auto___90169);
var G__90173 = (0);
seq__90150_90157 = G__90170;
chunk__90151_90158 = G__90171;
count__90152_90159 = G__90172;
i__90153_90160 = G__90173;
continue;
} else {
var msg_90175 = cljs.core.first.call(null,seq__90150_90168__$1);
figwheel.client.socket.handle_incoming_message.call(null,msg_90175);

var G__90176 = cljs.core.next.call(null,seq__90150_90168__$1);
var G__90177 = null;
var G__90178 = (0);
var G__90179 = (0);
seq__90150_90157 = G__90176;
chunk__90151_90158 = G__90177;
count__90152_90159 = G__90178;
i__90153_90160 = G__90179;
continue;
}
} else {
}
}
break;
}

return figwheel.client.socket.open.call(null,system_options);
})))
;
}
}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$0 = (function (){
return figwheel.client.start.call(null,cljs.core.PersistentArrayMap.EMPTY);
});

figwheel.client.start.cljs$lang$maxFixedArity = 1;

figwheel.client.watch_and_reload_with_opts = figwheel.client.start;
figwheel.client.watch_and_reload = (function figwheel$client$watch_and_reload(var_args){
var args__29319__auto__ = [];
var len__29312__auto___90185 = arguments.length;
var i__29313__auto___90186 = (0);
while(true){
if((i__29313__auto___90186 < len__29312__auto___90185)){
args__29319__auto__.push((arguments[i__29313__auto___90186]));

var G__90187 = (i__29313__auto___90186 + (1));
i__29313__auto___90186 = G__90187;
continue;
} else {
}
break;
}

var argseq__29320__auto__ = ((((0) < args__29319__auto__.length))?(new cljs.core.IndexedSeq(args__29319__auto__.slice((0)),(0),null)):null);
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(argseq__29320__auto__);
});

figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic = (function (p__90182){
var map__90183 = p__90182;
var map__90183__$1 = ((((!((map__90183 == null)))?((((map__90183.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__90183.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__90183):map__90183);
var opts = map__90183__$1;
return figwheel.client.start.call(null,opts);
});

figwheel.client.watch_and_reload.cljs$lang$maxFixedArity = (0);

figwheel.client.watch_and_reload.cljs$lang$applyTo = (function (seq90181){
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq90181));
});

figwheel.client.fetch_data_from_env = (function figwheel$client$fetch_data_from_env(){
try{return cljs.reader.read_string.call(null,goog.object.get(window,"FIGWHEEL_CLIENT_CONFIGURATION"));
}catch (e90190){if((e90190 instanceof Error)){
var e = e90190;
cljs.core._STAR_print_err_fn_STAR_.call(null,"Unable to load FIGWHEEL_CLIENT_CONFIGURATION from the environment");

return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"autoload","autoload",-354122500),false], null);
} else {
throw e90190;

}
}});
figwheel.client.console_intro_message = "Figwheel has compiled a temporary helper application to your :output-file.\n\nThe code currently in your configured output file does not\nrepresent the code that you are trying to compile.\n\nThis temporary application is intended to help you continue to get\nfeedback from Figwheel until the build you are working on compiles\ncorrectly.\n\nWhen your ClojureScript source code compiles correctly this helper\napplication will auto-reload and pick up your freshly compiled\nClojureScript program.";
figwheel.client.bad_compile_helper_app = (function figwheel$client$bad_compile_helper_app(){
cljs.core.enable_console_print_BANG_.call(null);

var config = figwheel.client.fetch_data_from_env.call(null);
cljs.core.println.call(null,figwheel.client.console_intro_message);

figwheel.client.heads_up.bad_compile_screen.call(null);

if(cljs.core.truth_(goog.dependencies_)){
} else {
goog.dependencies_ = true;
}

figwheel.client.start.call(null,config);

return figwheel.client.add_message_watch.call(null,new cljs.core.Keyword(null,"listen-for-successful-compile","listen-for-successful-compile",-995277603),((function (config){
return (function (p__90193){
var map__90194 = p__90193;
var map__90194__$1 = ((((!((map__90194 == null)))?((((map__90194.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__90194.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__90194):map__90194);
var msg_name = cljs.core.get.call(null,map__90194__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))){
return location.href = location.href;
} else {
return null;
}
});})(config))
);
});

//# sourceMappingURL=client.js.map?rel=1511404574146
