// Compiled by ClojureScript 1.9.946 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__96471 = arguments.length;
switch (G__96471) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async96472 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async96472 = (function (f,blockable,meta96473){
this.f = f;
this.blockable = blockable;
this.meta96473 = meta96473;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

cljs.core.async.t_cljs$core$async96472.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_96474,meta96473__$1){
var self__ = this;
var _96474__$1 = this;
return (new cljs.core.async.t_cljs$core$async96472(self__.f,self__.blockable,meta96473__$1));
});


cljs.core.async.t_cljs$core$async96472.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_96474){
var self__ = this;
var _96474__$1 = this;
return self__.meta96473;
});


cljs.core.async.t_cljs$core$async96472.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async96472.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});


cljs.core.async.t_cljs$core$async96472.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});


cljs.core.async.t_cljs$core$async96472.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async96472.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta96473","meta96473",-723376054,null)], null);
});

cljs.core.async.t_cljs$core$async96472.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async96472.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async96472";

cljs.core.async.t_cljs$core$async96472.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"cljs.core.async/t_cljs$core$async96472");
});

cljs.core.async.__GT_t_cljs$core$async96472 = (function cljs$core$async$__GT_t_cljs$core$async96472(f__$1,blockable__$1,meta96473){
return (new cljs.core.async.t_cljs$core$async96472(f__$1,blockable__$1,meta96473));
});

}

return (new cljs.core.async.t_cljs$core$async96472(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__96481 = arguments.length;
switch (G__96481) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__96484 = arguments.length;
switch (G__96484) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__96494 = arguments.length;
switch (G__96494) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_96497 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_96497);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_96497,ret){
return (function (){
return fn1.call(null,val_96497);
});})(val_96497,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__96499 = arguments.length;
switch (G__96499) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4655__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__29088__auto___96501 = n;
var x_96502 = (0);
while(true){
if((x_96502 < n__29088__auto___96501)){
(a[x_96502] = (0));

var G__96503 = (x_96502 + (1));
x_96502 = G__96503;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__96504 = (i + (1));
i = G__96504;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async96505 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async96505 = (function (flag,meta96506){
this.flag = flag;
this.meta96506 = meta96506;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

cljs.core.async.t_cljs$core$async96505.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_96507,meta96506__$1){
var self__ = this;
var _96507__$1 = this;
return (new cljs.core.async.t_cljs$core$async96505(self__.flag,meta96506__$1));
});})(flag))
;


cljs.core.async.t_cljs$core$async96505.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_96507){
var self__ = this;
var _96507__$1 = this;
return self__.meta96506;
});})(flag))
;


cljs.core.async.t_cljs$core$async96505.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async96505.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;


cljs.core.async.t_cljs$core$async96505.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;


cljs.core.async.t_cljs$core$async96505.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async96505.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta96506","meta96506",2096788671,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async96505.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async96505.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async96505";

cljs.core.async.t_cljs$core$async96505.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"cljs.core.async/t_cljs$core$async96505");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async96505 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async96505(flag__$1,meta96506){
return (new cljs.core.async.t_cljs$core$async96505(flag__$1,meta96506));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async96505(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async96511 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async96511 = (function (flag,cb,meta96512){
this.flag = flag;
this.cb = cb;
this.meta96512 = meta96512;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

cljs.core.async.t_cljs$core$async96511.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_96513,meta96512__$1){
var self__ = this;
var _96513__$1 = this;
return (new cljs.core.async.t_cljs$core$async96511(self__.flag,self__.cb,meta96512__$1));
});


cljs.core.async.t_cljs$core$async96511.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_96513){
var self__ = this;
var _96513__$1 = this;
return self__.meta96512;
});


cljs.core.async.t_cljs$core$async96511.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async96511.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});


cljs.core.async.t_cljs$core$async96511.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});


cljs.core.async.t_cljs$core$async96511.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async96511.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta96512","meta96512",2147097623,null)], null);
});

cljs.core.async.t_cljs$core$async96511.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async96511.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async96511";

cljs.core.async.t_cljs$core$async96511.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"cljs.core.async/t_cljs$core$async96511");
});

cljs.core.async.__GT_t_cljs$core$async96511 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async96511(flag__$1,cb__$1,meta96512){
return (new cljs.core.async.t_cljs$core$async96511(flag__$1,cb__$1,meta96512));
});

}

return (new cljs.core.async.t_cljs$core$async96511(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__96517_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__96517_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__96518_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__96518_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__28141__auto__ = wport;
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
return port;
}
})()], null));
} else {
var G__96526 = (i + (1));
i = G__96526;
continue;
}
} else {
return null;
}
break;
}
})();
var or__28141__auto__ = ret;
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4657__auto__ = (function (){var and__28129__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__28129__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__28129__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__29319__auto__ = [];
var len__29312__auto___96532 = arguments.length;
var i__29313__auto___96533 = (0);
while(true){
if((i__29313__auto___96533 < len__29312__auto___96532)){
args__29319__auto__.push((arguments[i__29313__auto___96533]));

var G__96534 = (i__29313__auto___96533 + (1));
i__29313__auto___96533 = G__96534;
continue;
} else {
}
break;
}

var argseq__29320__auto__ = ((((1) < args__29319__auto__.length))?(new cljs.core.IndexedSeq(args__29319__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29320__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__96529){
var map__96530 = p__96529;
var map__96530__$1 = ((((!((map__96530 == null)))?((((map__96530.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__96530.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__96530):map__96530);
var opts = map__96530__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq96527){
var G__96528 = cljs.core.first.call(null,seq96527);
var seq96527__$1 = cljs.core.next.call(null,seq96527);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__96528,seq96527__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__96542 = arguments.length;
switch (G__96542) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__47173__auto___96592 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto___96592){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto___96592){
return (function (state_96566){
var state_val_96567 = (state_96566[(1)]);
if((state_val_96567 === (7))){
var inst_96562 = (state_96566[(2)]);
var state_96566__$1 = state_96566;
var statearr_96568_96593 = state_96566__$1;
(statearr_96568_96593[(2)] = inst_96562);

(statearr_96568_96593[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_96567 === (1))){
var state_96566__$1 = state_96566;
var statearr_96569_96594 = state_96566__$1;
(statearr_96569_96594[(2)] = null);

(statearr_96569_96594[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_96567 === (4))){
var inst_96545 = (state_96566[(7)]);
var inst_96545__$1 = (state_96566[(2)]);
var inst_96546 = (inst_96545__$1 == null);
var state_96566__$1 = (function (){var statearr_96570 = state_96566;
(statearr_96570[(7)] = inst_96545__$1);

return statearr_96570;
})();
if(cljs.core.truth_(inst_96546)){
var statearr_96571_96595 = state_96566__$1;
(statearr_96571_96595[(1)] = (5));

} else {
var statearr_96572_96596 = state_96566__$1;
(statearr_96572_96596[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_96567 === (13))){
var state_96566__$1 = state_96566;
var statearr_96573_96597 = state_96566__$1;
(statearr_96573_96597[(2)] = null);

(statearr_96573_96597[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_96567 === (6))){
var inst_96545 = (state_96566[(7)]);
var state_96566__$1 = state_96566;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_96566__$1,(11),to,inst_96545);
} else {
if((state_val_96567 === (3))){
var inst_96564 = (state_96566[(2)]);
var state_96566__$1 = state_96566;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_96566__$1,inst_96564);
} else {
if((state_val_96567 === (12))){
var state_96566__$1 = state_96566;
var statearr_96577_96598 = state_96566__$1;
(statearr_96577_96598[(2)] = null);

(statearr_96577_96598[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_96567 === (2))){
var state_96566__$1 = state_96566;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_96566__$1,(4),from);
} else {
if((state_val_96567 === (11))){
var inst_96555 = (state_96566[(2)]);
var state_96566__$1 = state_96566;
if(cljs.core.truth_(inst_96555)){
var statearr_96578_96599 = state_96566__$1;
(statearr_96578_96599[(1)] = (12));

} else {
var statearr_96579_96600 = state_96566__$1;
(statearr_96579_96600[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_96567 === (9))){
var state_96566__$1 = state_96566;
var statearr_96580_96601 = state_96566__$1;
(statearr_96580_96601[(2)] = null);

(statearr_96580_96601[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_96567 === (5))){
var state_96566__$1 = state_96566;
if(cljs.core.truth_(close_QMARK_)){
var statearr_96581_96602 = state_96566__$1;
(statearr_96581_96602[(1)] = (8));

} else {
var statearr_96582_96603 = state_96566__$1;
(statearr_96582_96603[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_96567 === (14))){
var inst_96560 = (state_96566[(2)]);
var state_96566__$1 = state_96566;
var statearr_96583_96604 = state_96566__$1;
(statearr_96583_96604[(2)] = inst_96560);

(statearr_96583_96604[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_96567 === (10))){
var inst_96552 = (state_96566[(2)]);
var state_96566__$1 = state_96566;
var statearr_96584_96605 = state_96566__$1;
(statearr_96584_96605[(2)] = inst_96552);

(statearr_96584_96605[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_96567 === (8))){
var inst_96549 = cljs.core.async.close_BANG_.call(null,to);
var state_96566__$1 = state_96566;
var statearr_96585_96606 = state_96566__$1;
(statearr_96585_96606[(2)] = inst_96549);

(statearr_96585_96606[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__47173__auto___96592))
;
return ((function (switch__47085__auto__,c__47173__auto___96592){
return (function() {
var cljs$core$async$state_machine__47086__auto__ = null;
var cljs$core$async$state_machine__47086__auto____0 = (function (){
var statearr_96586 = [null,null,null,null,null,null,null,null];
(statearr_96586[(0)] = cljs$core$async$state_machine__47086__auto__);

(statearr_96586[(1)] = (1));

return statearr_96586;
});
var cljs$core$async$state_machine__47086__auto____1 = (function (state_96566){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_96566);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e96587){if((e96587 instanceof Object)){
var ex__47089__auto__ = e96587;
var statearr_96588_96607 = state_96566;
(statearr_96588_96607[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_96566);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e96587;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__96608 = state_96566;
state_96566 = G__96608;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
cljs$core$async$state_machine__47086__auto__ = function(state_96566){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__47086__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__47086__auto____1.call(this,state_96566);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__47086__auto____0;
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__47086__auto____1;
return cljs$core$async$state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto___96592))
})();
var state__47175__auto__ = (function (){var statearr_96589 = f__47174__auto__.call(null);
(statearr_96589[(6)] = c__47173__auto___96592);

return statearr_96589;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto___96592))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__96609){
var vec__96610 = p__96609;
var v = cljs.core.nth.call(null,vec__96610,(0),null);
var p = cljs.core.nth.call(null,vec__96610,(1),null);
var job = vec__96610;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__47173__auto___96781 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto___96781,res,vec__96610,v,p,job,jobs,results){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto___96781,res,vec__96610,v,p,job,jobs,results){
return (function (state_96617){
var state_val_96618 = (state_96617[(1)]);
if((state_val_96618 === (1))){
var state_96617__$1 = state_96617;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_96617__$1,(2),res,v);
} else {
if((state_val_96618 === (2))){
var inst_96614 = (state_96617[(2)]);
var inst_96615 = cljs.core.async.close_BANG_.call(null,res);
var state_96617__$1 = (function (){var statearr_96619 = state_96617;
(statearr_96619[(7)] = inst_96614);

return statearr_96619;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_96617__$1,inst_96615);
} else {
return null;
}
}
});})(c__47173__auto___96781,res,vec__96610,v,p,job,jobs,results))
;
return ((function (switch__47085__auto__,c__47173__auto___96781,res,vec__96610,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____0 = (function (){
var statearr_96620 = [null,null,null,null,null,null,null,null];
(statearr_96620[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__);

(statearr_96620[(1)] = (1));

return statearr_96620;
});
var cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____1 = (function (state_96617){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_96617);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e96621){if((e96621 instanceof Object)){
var ex__47089__auto__ = e96621;
var statearr_96622_96782 = state_96617;
(statearr_96622_96782[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_96617);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e96621;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__96783 = state_96617;
state_96617 = G__96783;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__ = function(state_96617){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____1.call(this,state_96617);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto___96781,res,vec__96610,v,p,job,jobs,results))
})();
var state__47175__auto__ = (function (){var statearr_96623 = f__47174__auto__.call(null);
(statearr_96623[(6)] = c__47173__auto___96781);

return statearr_96623;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto___96781,res,vec__96610,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__96624){
var vec__96625 = p__96624;
var v = cljs.core.nth.call(null,vec__96625,(0),null);
var p = cljs.core.nth.call(null,vec__96625,(1),null);
var job = vec__96625;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__29088__auto___96784 = n;
var __96785 = (0);
while(true){
if((__96785 < n__29088__auto___96784)){
var G__96628_96786 = type;
var G__96628_96787__$1 = (((G__96628_96786 instanceof cljs.core.Keyword))?G__96628_96786.fqn:null);
switch (G__96628_96787__$1) {
case "compute":
var c__47173__auto___96789 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__96785,c__47173__auto___96789,G__96628_96786,G__96628_96787__$1,n__29088__auto___96784,jobs,results,process,async){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (__96785,c__47173__auto___96789,G__96628_96786,G__96628_96787__$1,n__29088__auto___96784,jobs,results,process,async){
return (function (state_96641){
var state_val_96642 = (state_96641[(1)]);
if((state_val_96642 === (1))){
var state_96641__$1 = state_96641;
var statearr_96643_96790 = state_96641__$1;
(statearr_96643_96790[(2)] = null);

(statearr_96643_96790[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_96642 === (2))){
var state_96641__$1 = state_96641;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_96641__$1,(4),jobs);
} else {
if((state_val_96642 === (3))){
var inst_96639 = (state_96641[(2)]);
var state_96641__$1 = state_96641;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_96641__$1,inst_96639);
} else {
if((state_val_96642 === (4))){
var inst_96631 = (state_96641[(2)]);
var inst_96632 = process.call(null,inst_96631);
var state_96641__$1 = state_96641;
if(cljs.core.truth_(inst_96632)){
var statearr_96644_96791 = state_96641__$1;
(statearr_96644_96791[(1)] = (5));

} else {
var statearr_96645_96792 = state_96641__$1;
(statearr_96645_96792[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_96642 === (5))){
var state_96641__$1 = state_96641;
var statearr_96646_96793 = state_96641__$1;
(statearr_96646_96793[(2)] = null);

(statearr_96646_96793[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_96642 === (6))){
var state_96641__$1 = state_96641;
var statearr_96647_96794 = state_96641__$1;
(statearr_96647_96794[(2)] = null);

(statearr_96647_96794[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_96642 === (7))){
var inst_96637 = (state_96641[(2)]);
var state_96641__$1 = state_96641;
var statearr_96648_96795 = state_96641__$1;
(statearr_96648_96795[(2)] = inst_96637);

(statearr_96648_96795[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__96785,c__47173__auto___96789,G__96628_96786,G__96628_96787__$1,n__29088__auto___96784,jobs,results,process,async))
;
return ((function (__96785,switch__47085__auto__,c__47173__auto___96789,G__96628_96786,G__96628_96787__$1,n__29088__auto___96784,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____0 = (function (){
var statearr_96649 = [null,null,null,null,null,null,null];
(statearr_96649[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__);

(statearr_96649[(1)] = (1));

return statearr_96649;
});
var cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____1 = (function (state_96641){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_96641);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e96650){if((e96650 instanceof Object)){
var ex__47089__auto__ = e96650;
var statearr_96651_96796 = state_96641;
(statearr_96651_96796[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_96641);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e96650;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__96797 = state_96641;
state_96641 = G__96797;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__ = function(state_96641){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____1.call(this,state_96641);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__;
})()
;})(__96785,switch__47085__auto__,c__47173__auto___96789,G__96628_96786,G__96628_96787__$1,n__29088__auto___96784,jobs,results,process,async))
})();
var state__47175__auto__ = (function (){var statearr_96652 = f__47174__auto__.call(null);
(statearr_96652[(6)] = c__47173__auto___96789);

return statearr_96652;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(__96785,c__47173__auto___96789,G__96628_96786,G__96628_96787__$1,n__29088__auto___96784,jobs,results,process,async))
);


break;
case "async":
var c__47173__auto___96798 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__96785,c__47173__auto___96798,G__96628_96786,G__96628_96787__$1,n__29088__auto___96784,jobs,results,process,async){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (__96785,c__47173__auto___96798,G__96628_96786,G__96628_96787__$1,n__29088__auto___96784,jobs,results,process,async){
return (function (state_96665){
var state_val_96666 = (state_96665[(1)]);
if((state_val_96666 === (1))){
var state_96665__$1 = state_96665;
var statearr_96667_96799 = state_96665__$1;
(statearr_96667_96799[(2)] = null);

(statearr_96667_96799[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_96666 === (2))){
var state_96665__$1 = state_96665;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_96665__$1,(4),jobs);
} else {
if((state_val_96666 === (3))){
var inst_96663 = (state_96665[(2)]);
var state_96665__$1 = state_96665;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_96665__$1,inst_96663);
} else {
if((state_val_96666 === (4))){
var inst_96655 = (state_96665[(2)]);
var inst_96656 = async.call(null,inst_96655);
var state_96665__$1 = state_96665;
if(cljs.core.truth_(inst_96656)){
var statearr_96668_96800 = state_96665__$1;
(statearr_96668_96800[(1)] = (5));

} else {
var statearr_96669_96801 = state_96665__$1;
(statearr_96669_96801[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_96666 === (5))){
var state_96665__$1 = state_96665;
var statearr_96670_96802 = state_96665__$1;
(statearr_96670_96802[(2)] = null);

(statearr_96670_96802[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_96666 === (6))){
var state_96665__$1 = state_96665;
var statearr_96671_96803 = state_96665__$1;
(statearr_96671_96803[(2)] = null);

(statearr_96671_96803[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_96666 === (7))){
var inst_96661 = (state_96665[(2)]);
var state_96665__$1 = state_96665;
var statearr_96672_96804 = state_96665__$1;
(statearr_96672_96804[(2)] = inst_96661);

(statearr_96672_96804[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__96785,c__47173__auto___96798,G__96628_96786,G__96628_96787__$1,n__29088__auto___96784,jobs,results,process,async))
;
return ((function (__96785,switch__47085__auto__,c__47173__auto___96798,G__96628_96786,G__96628_96787__$1,n__29088__auto___96784,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____0 = (function (){
var statearr_96673 = [null,null,null,null,null,null,null];
(statearr_96673[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__);

(statearr_96673[(1)] = (1));

return statearr_96673;
});
var cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____1 = (function (state_96665){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_96665);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e96674){if((e96674 instanceof Object)){
var ex__47089__auto__ = e96674;
var statearr_96675_96805 = state_96665;
(statearr_96675_96805[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_96665);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e96674;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__96806 = state_96665;
state_96665 = G__96806;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__ = function(state_96665){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____1.call(this,state_96665);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__;
})()
;})(__96785,switch__47085__auto__,c__47173__auto___96798,G__96628_96786,G__96628_96787__$1,n__29088__auto___96784,jobs,results,process,async))
})();
var state__47175__auto__ = (function (){var statearr_96676 = f__47174__auto__.call(null);
(statearr_96676[(6)] = c__47173__auto___96798);

return statearr_96676;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(__96785,c__47173__auto___96798,G__96628_96786,G__96628_96787__$1,n__29088__auto___96784,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__96628_96787__$1)].join('')));

}

var G__96807 = (__96785 + (1));
__96785 = G__96807;
continue;
} else {
}
break;
}

var c__47173__auto___96808 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto___96808,jobs,results,process,async){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto___96808,jobs,results,process,async){
return (function (state_96698){
var state_val_96699 = (state_96698[(1)]);
if((state_val_96699 === (1))){
var state_96698__$1 = state_96698;
var statearr_96700_96809 = state_96698__$1;
(statearr_96700_96809[(2)] = null);

(statearr_96700_96809[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_96699 === (2))){
var state_96698__$1 = state_96698;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_96698__$1,(4),from);
} else {
if((state_val_96699 === (3))){
var inst_96696 = (state_96698[(2)]);
var state_96698__$1 = state_96698;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_96698__$1,inst_96696);
} else {
if((state_val_96699 === (4))){
var inst_96679 = (state_96698[(7)]);
var inst_96679__$1 = (state_96698[(2)]);
var inst_96680 = (inst_96679__$1 == null);
var state_96698__$1 = (function (){var statearr_96701 = state_96698;
(statearr_96701[(7)] = inst_96679__$1);

return statearr_96701;
})();
if(cljs.core.truth_(inst_96680)){
var statearr_96702_96812 = state_96698__$1;
(statearr_96702_96812[(1)] = (5));

} else {
var statearr_96703_96813 = state_96698__$1;
(statearr_96703_96813[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_96699 === (5))){
var inst_96682 = cljs.core.async.close_BANG_.call(null,jobs);
var state_96698__$1 = state_96698;
var statearr_96704_96814 = state_96698__$1;
(statearr_96704_96814[(2)] = inst_96682);

(statearr_96704_96814[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_96699 === (6))){
var inst_96679 = (state_96698[(7)]);
var inst_96684 = (state_96698[(8)]);
var inst_96684__$1 = cljs.core.async.chan.call(null,(1));
var inst_96685 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_96686 = [inst_96679,inst_96684__$1];
var inst_96687 = (new cljs.core.PersistentVector(null,2,(5),inst_96685,inst_96686,null));
var state_96698__$1 = (function (){var statearr_96705 = state_96698;
(statearr_96705[(8)] = inst_96684__$1);

return statearr_96705;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_96698__$1,(8),jobs,inst_96687);
} else {
if((state_val_96699 === (7))){
var inst_96694 = (state_96698[(2)]);
var state_96698__$1 = state_96698;
var statearr_96706_96817 = state_96698__$1;
(statearr_96706_96817[(2)] = inst_96694);

(statearr_96706_96817[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_96699 === (8))){
var inst_96684 = (state_96698[(8)]);
var inst_96689 = (state_96698[(2)]);
var state_96698__$1 = (function (){var statearr_96707 = state_96698;
(statearr_96707[(9)] = inst_96689);

return statearr_96707;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_96698__$1,(9),results,inst_96684);
} else {
if((state_val_96699 === (9))){
var inst_96691 = (state_96698[(2)]);
var state_96698__$1 = (function (){var statearr_96708 = state_96698;
(statearr_96708[(10)] = inst_96691);

return statearr_96708;
})();
var statearr_96709_96824 = state_96698__$1;
(statearr_96709_96824[(2)] = null);

(statearr_96709_96824[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__47173__auto___96808,jobs,results,process,async))
;
return ((function (switch__47085__auto__,c__47173__auto___96808,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____0 = (function (){
var statearr_96710 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_96710[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__);

(statearr_96710[(1)] = (1));

return statearr_96710;
});
var cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____1 = (function (state_96698){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_96698);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e96711){if((e96711 instanceof Object)){
var ex__47089__auto__ = e96711;
var statearr_96712_96832 = state_96698;
(statearr_96712_96832[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_96698);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e96711;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__96833 = state_96698;
state_96698 = G__96833;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__ = function(state_96698){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____1.call(this,state_96698);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto___96808,jobs,results,process,async))
})();
var state__47175__auto__ = (function (){var statearr_96713 = f__47174__auto__.call(null);
(statearr_96713[(6)] = c__47173__auto___96808);

return statearr_96713;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto___96808,jobs,results,process,async))
);


var c__47173__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto__,jobs,results,process,async){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto__,jobs,results,process,async){
return (function (state_96751){
var state_val_96752 = (state_96751[(1)]);
if((state_val_96752 === (7))){
var inst_96747 = (state_96751[(2)]);
var state_96751__$1 = state_96751;
var statearr_96753_96838 = state_96751__$1;
(statearr_96753_96838[(2)] = inst_96747);

(statearr_96753_96838[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_96752 === (20))){
var state_96751__$1 = state_96751;
var statearr_96754_96840 = state_96751__$1;
(statearr_96754_96840[(2)] = null);

(statearr_96754_96840[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_96752 === (1))){
var state_96751__$1 = state_96751;
var statearr_96755_96843 = state_96751__$1;
(statearr_96755_96843[(2)] = null);

(statearr_96755_96843[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_96752 === (4))){
var inst_96716 = (state_96751[(7)]);
var inst_96716__$1 = (state_96751[(2)]);
var inst_96717 = (inst_96716__$1 == null);
var state_96751__$1 = (function (){var statearr_96756 = state_96751;
(statearr_96756[(7)] = inst_96716__$1);

return statearr_96756;
})();
if(cljs.core.truth_(inst_96717)){
var statearr_96757_96844 = state_96751__$1;
(statearr_96757_96844[(1)] = (5));

} else {
var statearr_96758_96845 = state_96751__$1;
(statearr_96758_96845[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_96752 === (15))){
var inst_96729 = (state_96751[(8)]);
var state_96751__$1 = state_96751;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_96751__$1,(18),to,inst_96729);
} else {
if((state_val_96752 === (21))){
var inst_96742 = (state_96751[(2)]);
var state_96751__$1 = state_96751;
var statearr_96759_96846 = state_96751__$1;
(statearr_96759_96846[(2)] = inst_96742);

(statearr_96759_96846[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_96752 === (13))){
var inst_96744 = (state_96751[(2)]);
var state_96751__$1 = (function (){var statearr_96760 = state_96751;
(statearr_96760[(9)] = inst_96744);

return statearr_96760;
})();
var statearr_96761_96847 = state_96751__$1;
(statearr_96761_96847[(2)] = null);

(statearr_96761_96847[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_96752 === (6))){
var inst_96716 = (state_96751[(7)]);
var state_96751__$1 = state_96751;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_96751__$1,(11),inst_96716);
} else {
if((state_val_96752 === (17))){
var inst_96737 = (state_96751[(2)]);
var state_96751__$1 = state_96751;
if(cljs.core.truth_(inst_96737)){
var statearr_96762_96848 = state_96751__$1;
(statearr_96762_96848[(1)] = (19));

} else {
var statearr_96763_96849 = state_96751__$1;
(statearr_96763_96849[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_96752 === (3))){
var inst_96749 = (state_96751[(2)]);
var state_96751__$1 = state_96751;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_96751__$1,inst_96749);
} else {
if((state_val_96752 === (12))){
var inst_96726 = (state_96751[(10)]);
var state_96751__$1 = state_96751;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_96751__$1,(14),inst_96726);
} else {
if((state_val_96752 === (2))){
var state_96751__$1 = state_96751;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_96751__$1,(4),results);
} else {
if((state_val_96752 === (19))){
var state_96751__$1 = state_96751;
var statearr_96764_96850 = state_96751__$1;
(statearr_96764_96850[(2)] = null);

(statearr_96764_96850[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_96752 === (11))){
var inst_96726 = (state_96751[(2)]);
var state_96751__$1 = (function (){var statearr_96765 = state_96751;
(statearr_96765[(10)] = inst_96726);

return statearr_96765;
})();
var statearr_96766_96851 = state_96751__$1;
(statearr_96766_96851[(2)] = null);

(statearr_96766_96851[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_96752 === (9))){
var state_96751__$1 = state_96751;
var statearr_96767_96852 = state_96751__$1;
(statearr_96767_96852[(2)] = null);

(statearr_96767_96852[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_96752 === (5))){
var state_96751__$1 = state_96751;
if(cljs.core.truth_(close_QMARK_)){
var statearr_96768_96853 = state_96751__$1;
(statearr_96768_96853[(1)] = (8));

} else {
var statearr_96769_96854 = state_96751__$1;
(statearr_96769_96854[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_96752 === (14))){
var inst_96731 = (state_96751[(11)]);
var inst_96729 = (state_96751[(8)]);
var inst_96729__$1 = (state_96751[(2)]);
var inst_96730 = (inst_96729__$1 == null);
var inst_96731__$1 = cljs.core.not.call(null,inst_96730);
var state_96751__$1 = (function (){var statearr_96770 = state_96751;
(statearr_96770[(11)] = inst_96731__$1);

(statearr_96770[(8)] = inst_96729__$1);

return statearr_96770;
})();
if(inst_96731__$1){
var statearr_96771_96855 = state_96751__$1;
(statearr_96771_96855[(1)] = (15));

} else {
var statearr_96772_96856 = state_96751__$1;
(statearr_96772_96856[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_96752 === (16))){
var inst_96731 = (state_96751[(11)]);
var state_96751__$1 = state_96751;
var statearr_96773_96857 = state_96751__$1;
(statearr_96773_96857[(2)] = inst_96731);

(statearr_96773_96857[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_96752 === (10))){
var inst_96723 = (state_96751[(2)]);
var state_96751__$1 = state_96751;
var statearr_96774_96858 = state_96751__$1;
(statearr_96774_96858[(2)] = inst_96723);

(statearr_96774_96858[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_96752 === (18))){
var inst_96734 = (state_96751[(2)]);
var state_96751__$1 = state_96751;
var statearr_96775_96863 = state_96751__$1;
(statearr_96775_96863[(2)] = inst_96734);

(statearr_96775_96863[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_96752 === (8))){
var inst_96720 = cljs.core.async.close_BANG_.call(null,to);
var state_96751__$1 = state_96751;
var statearr_96776_96864 = state_96751__$1;
(statearr_96776_96864[(2)] = inst_96720);

(statearr_96776_96864[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__47173__auto__,jobs,results,process,async))
;
return ((function (switch__47085__auto__,c__47173__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____0 = (function (){
var statearr_96777 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_96777[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__);

(statearr_96777[(1)] = (1));

return statearr_96777;
});
var cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____1 = (function (state_96751){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_96751);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e96778){if((e96778 instanceof Object)){
var ex__47089__auto__ = e96778;
var statearr_96779_96870 = state_96751;
(statearr_96779_96870[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_96751);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e96778;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__96872 = state_96751;
state_96751 = G__96872;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__ = function(state_96751){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____1.call(this,state_96751);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__47086__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto__,jobs,results,process,async))
})();
var state__47175__auto__ = (function (){var statearr_96780 = f__47174__auto__.call(null);
(statearr_96780[(6)] = c__47173__auto__);

return statearr_96780;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto__,jobs,results,process,async))
);

return c__47173__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__96874 = arguments.length;
switch (G__96874) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__96879 = arguments.length;
switch (G__96879) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__96886 = arguments.length;
switch (G__96886) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__47173__auto___96941 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto___96941,tc,fc){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto___96941,tc,fc){
return (function (state_96915){
var state_val_96916 = (state_96915[(1)]);
if((state_val_96916 === (7))){
var inst_96911 = (state_96915[(2)]);
var state_96915__$1 = state_96915;
var statearr_96917_96942 = state_96915__$1;
(statearr_96917_96942[(2)] = inst_96911);

(statearr_96917_96942[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_96916 === (1))){
var state_96915__$1 = state_96915;
var statearr_96918_96943 = state_96915__$1;
(statearr_96918_96943[(2)] = null);

(statearr_96918_96943[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_96916 === (4))){
var inst_96889 = (state_96915[(7)]);
var inst_96889__$1 = (state_96915[(2)]);
var inst_96890 = (inst_96889__$1 == null);
var state_96915__$1 = (function (){var statearr_96919 = state_96915;
(statearr_96919[(7)] = inst_96889__$1);

return statearr_96919;
})();
if(cljs.core.truth_(inst_96890)){
var statearr_96920_96944 = state_96915__$1;
(statearr_96920_96944[(1)] = (5));

} else {
var statearr_96921_96945 = state_96915__$1;
(statearr_96921_96945[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_96916 === (13))){
var state_96915__$1 = state_96915;
var statearr_96922_96946 = state_96915__$1;
(statearr_96922_96946[(2)] = null);

(statearr_96922_96946[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_96916 === (6))){
var inst_96889 = (state_96915[(7)]);
var inst_96898 = p.call(null,inst_96889);
var state_96915__$1 = state_96915;
if(cljs.core.truth_(inst_96898)){
var statearr_96923_96947 = state_96915__$1;
(statearr_96923_96947[(1)] = (9));

} else {
var statearr_96924_96948 = state_96915__$1;
(statearr_96924_96948[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_96916 === (3))){
var inst_96913 = (state_96915[(2)]);
var state_96915__$1 = state_96915;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_96915__$1,inst_96913);
} else {
if((state_val_96916 === (12))){
var state_96915__$1 = state_96915;
var statearr_96925_96949 = state_96915__$1;
(statearr_96925_96949[(2)] = null);

(statearr_96925_96949[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_96916 === (2))){
var state_96915__$1 = state_96915;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_96915__$1,(4),ch);
} else {
if((state_val_96916 === (11))){
var inst_96889 = (state_96915[(7)]);
var inst_96902 = (state_96915[(2)]);
var state_96915__$1 = state_96915;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_96915__$1,(8),inst_96902,inst_96889);
} else {
if((state_val_96916 === (9))){
var state_96915__$1 = state_96915;
var statearr_96926_96953 = state_96915__$1;
(statearr_96926_96953[(2)] = tc);

(statearr_96926_96953[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_96916 === (5))){
var inst_96892 = cljs.core.async.close_BANG_.call(null,tc);
var inst_96893 = cljs.core.async.close_BANG_.call(null,fc);
var state_96915__$1 = (function (){var statearr_96927 = state_96915;
(statearr_96927[(8)] = inst_96892);

return statearr_96927;
})();
var statearr_96928_96954 = state_96915__$1;
(statearr_96928_96954[(2)] = inst_96893);

(statearr_96928_96954[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_96916 === (14))){
var inst_96909 = (state_96915[(2)]);
var state_96915__$1 = state_96915;
var statearr_96929_96955 = state_96915__$1;
(statearr_96929_96955[(2)] = inst_96909);

(statearr_96929_96955[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_96916 === (10))){
var state_96915__$1 = state_96915;
var statearr_96930_96956 = state_96915__$1;
(statearr_96930_96956[(2)] = fc);

(statearr_96930_96956[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_96916 === (8))){
var inst_96904 = (state_96915[(2)]);
var state_96915__$1 = state_96915;
if(cljs.core.truth_(inst_96904)){
var statearr_96931_96957 = state_96915__$1;
(statearr_96931_96957[(1)] = (12));

} else {
var statearr_96932_96958 = state_96915__$1;
(statearr_96932_96958[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__47173__auto___96941,tc,fc))
;
return ((function (switch__47085__auto__,c__47173__auto___96941,tc,fc){
return (function() {
var cljs$core$async$state_machine__47086__auto__ = null;
var cljs$core$async$state_machine__47086__auto____0 = (function (){
var statearr_96933 = [null,null,null,null,null,null,null,null,null];
(statearr_96933[(0)] = cljs$core$async$state_machine__47086__auto__);

(statearr_96933[(1)] = (1));

return statearr_96933;
});
var cljs$core$async$state_machine__47086__auto____1 = (function (state_96915){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_96915);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e96934){if((e96934 instanceof Object)){
var ex__47089__auto__ = e96934;
var statearr_96935_96959 = state_96915;
(statearr_96935_96959[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_96915);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e96934;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__96960 = state_96915;
state_96915 = G__96960;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
cljs$core$async$state_machine__47086__auto__ = function(state_96915){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__47086__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__47086__auto____1.call(this,state_96915);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__47086__auto____0;
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__47086__auto____1;
return cljs$core$async$state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto___96941,tc,fc))
})();
var state__47175__auto__ = (function (){var statearr_96936 = f__47174__auto__.call(null);
(statearr_96936[(6)] = c__47173__auto___96941);

return statearr_96936;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto___96941,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__47173__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto__){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto__){
return (function (state_96981){
var state_val_96982 = (state_96981[(1)]);
if((state_val_96982 === (7))){
var inst_96977 = (state_96981[(2)]);
var state_96981__$1 = state_96981;
var statearr_96983_97004 = state_96981__$1;
(statearr_96983_97004[(2)] = inst_96977);

(statearr_96983_97004[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_96982 === (1))){
var inst_96961 = init;
var state_96981__$1 = (function (){var statearr_96984 = state_96981;
(statearr_96984[(7)] = inst_96961);

return statearr_96984;
})();
var statearr_96985_97005 = state_96981__$1;
(statearr_96985_97005[(2)] = null);

(statearr_96985_97005[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_96982 === (4))){
var inst_96964 = (state_96981[(8)]);
var inst_96964__$1 = (state_96981[(2)]);
var inst_96965 = (inst_96964__$1 == null);
var state_96981__$1 = (function (){var statearr_96989 = state_96981;
(statearr_96989[(8)] = inst_96964__$1);

return statearr_96989;
})();
if(cljs.core.truth_(inst_96965)){
var statearr_96990_97006 = state_96981__$1;
(statearr_96990_97006[(1)] = (5));

} else {
var statearr_96991_97007 = state_96981__$1;
(statearr_96991_97007[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_96982 === (6))){
var inst_96961 = (state_96981[(7)]);
var inst_96964 = (state_96981[(8)]);
var inst_96968 = (state_96981[(9)]);
var inst_96968__$1 = f.call(null,inst_96961,inst_96964);
var inst_96969 = cljs.core.reduced_QMARK_.call(null,inst_96968__$1);
var state_96981__$1 = (function (){var statearr_96992 = state_96981;
(statearr_96992[(9)] = inst_96968__$1);

return statearr_96992;
})();
if(inst_96969){
var statearr_96993_97008 = state_96981__$1;
(statearr_96993_97008[(1)] = (8));

} else {
var statearr_96994_97009 = state_96981__$1;
(statearr_96994_97009[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_96982 === (3))){
var inst_96979 = (state_96981[(2)]);
var state_96981__$1 = state_96981;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_96981__$1,inst_96979);
} else {
if((state_val_96982 === (2))){
var state_96981__$1 = state_96981;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_96981__$1,(4),ch);
} else {
if((state_val_96982 === (9))){
var inst_96968 = (state_96981[(9)]);
var inst_96961 = inst_96968;
var state_96981__$1 = (function (){var statearr_96995 = state_96981;
(statearr_96995[(7)] = inst_96961);

return statearr_96995;
})();
var statearr_96996_97013 = state_96981__$1;
(statearr_96996_97013[(2)] = null);

(statearr_96996_97013[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_96982 === (5))){
var inst_96961 = (state_96981[(7)]);
var state_96981__$1 = state_96981;
var statearr_96997_97014 = state_96981__$1;
(statearr_96997_97014[(2)] = inst_96961);

(statearr_96997_97014[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_96982 === (10))){
var inst_96975 = (state_96981[(2)]);
var state_96981__$1 = state_96981;
var statearr_96998_97015 = state_96981__$1;
(statearr_96998_97015[(2)] = inst_96975);

(statearr_96998_97015[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_96982 === (8))){
var inst_96968 = (state_96981[(9)]);
var inst_96971 = cljs.core.deref.call(null,inst_96968);
var state_96981__$1 = state_96981;
var statearr_96999_97016 = state_96981__$1;
(statearr_96999_97016[(2)] = inst_96971);

(statearr_96999_97016[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__47173__auto__))
;
return ((function (switch__47085__auto__,c__47173__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__47086__auto__ = null;
var cljs$core$async$reduce_$_state_machine__47086__auto____0 = (function (){
var statearr_97000 = [null,null,null,null,null,null,null,null,null,null];
(statearr_97000[(0)] = cljs$core$async$reduce_$_state_machine__47086__auto__);

(statearr_97000[(1)] = (1));

return statearr_97000;
});
var cljs$core$async$reduce_$_state_machine__47086__auto____1 = (function (state_96981){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_96981);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e97001){if((e97001 instanceof Object)){
var ex__47089__auto__ = e97001;
var statearr_97002_97017 = state_96981;
(statearr_97002_97017[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_96981);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e97001;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__97018 = state_96981;
state_96981 = G__97018;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__47086__auto__ = function(state_96981){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__47086__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__47086__auto____1.call(this,state_96981);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$reduce_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__47086__auto____0;
cljs$core$async$reduce_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__47086__auto____1;
return cljs$core$async$reduce_$_state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto__))
})();
var state__47175__auto__ = (function (){var statearr_97003 = f__47174__auto__.call(null);
(statearr_97003[(6)] = c__47173__auto__);

return statearr_97003;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto__))
);

return c__47173__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__47173__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto__,f__$1){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto__,f__$1){
return (function (state_97024){
var state_val_97025 = (state_97024[(1)]);
if((state_val_97025 === (1))){
var inst_97019 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_97024__$1 = state_97024;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_97024__$1,(2),inst_97019);
} else {
if((state_val_97025 === (2))){
var inst_97021 = (state_97024[(2)]);
var inst_97022 = f__$1.call(null,inst_97021);
var state_97024__$1 = state_97024;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_97024__$1,inst_97022);
} else {
return null;
}
}
});})(c__47173__auto__,f__$1))
;
return ((function (switch__47085__auto__,c__47173__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__47086__auto__ = null;
var cljs$core$async$transduce_$_state_machine__47086__auto____0 = (function (){
var statearr_97026 = [null,null,null,null,null,null,null];
(statearr_97026[(0)] = cljs$core$async$transduce_$_state_machine__47086__auto__);

(statearr_97026[(1)] = (1));

return statearr_97026;
});
var cljs$core$async$transduce_$_state_machine__47086__auto____1 = (function (state_97024){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_97024);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e97030){if((e97030 instanceof Object)){
var ex__47089__auto__ = e97030;
var statearr_97031_97033 = state_97024;
(statearr_97031_97033[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_97024);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e97030;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__97034 = state_97024;
state_97024 = G__97034;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__47086__auto__ = function(state_97024){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__47086__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__47086__auto____1.call(this,state_97024);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$transduce_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__47086__auto____0;
cljs$core$async$transduce_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__47086__auto____1;
return cljs$core$async$transduce_$_state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto__,f__$1))
})();
var state__47175__auto__ = (function (){var statearr_97032 = f__47174__auto__.call(null);
(statearr_97032[(6)] = c__47173__auto__);

return statearr_97032;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto__,f__$1))
);

return c__47173__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__97036 = arguments.length;
switch (G__97036) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__47173__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto__){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto__){
return (function (state_97064){
var state_val_97065 = (state_97064[(1)]);
if((state_val_97065 === (7))){
var inst_97046 = (state_97064[(2)]);
var state_97064__$1 = state_97064;
var statearr_97066_97090 = state_97064__$1;
(statearr_97066_97090[(2)] = inst_97046);

(statearr_97066_97090[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97065 === (1))){
var inst_97040 = cljs.core.seq.call(null,coll);
var inst_97041 = inst_97040;
var state_97064__$1 = (function (){var statearr_97067 = state_97064;
(statearr_97067[(7)] = inst_97041);

return statearr_97067;
})();
var statearr_97068_97091 = state_97064__$1;
(statearr_97068_97091[(2)] = null);

(statearr_97068_97091[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97065 === (4))){
var inst_97041 = (state_97064[(7)]);
var inst_97044 = cljs.core.first.call(null,inst_97041);
var state_97064__$1 = state_97064;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_97064__$1,(7),ch,inst_97044);
} else {
if((state_val_97065 === (13))){
var inst_97058 = (state_97064[(2)]);
var state_97064__$1 = state_97064;
var statearr_97069_97092 = state_97064__$1;
(statearr_97069_97092[(2)] = inst_97058);

(statearr_97069_97092[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97065 === (6))){
var inst_97049 = (state_97064[(2)]);
var state_97064__$1 = state_97064;
if(cljs.core.truth_(inst_97049)){
var statearr_97070_97093 = state_97064__$1;
(statearr_97070_97093[(1)] = (8));

} else {
var statearr_97071_97094 = state_97064__$1;
(statearr_97071_97094[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97065 === (3))){
var inst_97062 = (state_97064[(2)]);
var state_97064__$1 = state_97064;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_97064__$1,inst_97062);
} else {
if((state_val_97065 === (12))){
var state_97064__$1 = state_97064;
var statearr_97072_97095 = state_97064__$1;
(statearr_97072_97095[(2)] = null);

(statearr_97072_97095[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97065 === (2))){
var inst_97041 = (state_97064[(7)]);
var state_97064__$1 = state_97064;
if(cljs.core.truth_(inst_97041)){
var statearr_97073_97096 = state_97064__$1;
(statearr_97073_97096[(1)] = (4));

} else {
var statearr_97074_97097 = state_97064__$1;
(statearr_97074_97097[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97065 === (11))){
var inst_97055 = cljs.core.async.close_BANG_.call(null,ch);
var state_97064__$1 = state_97064;
var statearr_97075_97098 = state_97064__$1;
(statearr_97075_97098[(2)] = inst_97055);

(statearr_97075_97098[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97065 === (9))){
var state_97064__$1 = state_97064;
if(cljs.core.truth_(close_QMARK_)){
var statearr_97076_97099 = state_97064__$1;
(statearr_97076_97099[(1)] = (11));

} else {
var statearr_97077_97100 = state_97064__$1;
(statearr_97077_97100[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97065 === (5))){
var inst_97041 = (state_97064[(7)]);
var state_97064__$1 = state_97064;
var statearr_97078_97101 = state_97064__$1;
(statearr_97078_97101[(2)] = inst_97041);

(statearr_97078_97101[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97065 === (10))){
var inst_97060 = (state_97064[(2)]);
var state_97064__$1 = state_97064;
var statearr_97079_97102 = state_97064__$1;
(statearr_97079_97102[(2)] = inst_97060);

(statearr_97079_97102[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97065 === (8))){
var inst_97041 = (state_97064[(7)]);
var inst_97051 = cljs.core.next.call(null,inst_97041);
var inst_97041__$1 = inst_97051;
var state_97064__$1 = (function (){var statearr_97080 = state_97064;
(statearr_97080[(7)] = inst_97041__$1);

return statearr_97080;
})();
var statearr_97081_97103 = state_97064__$1;
(statearr_97081_97103[(2)] = null);

(statearr_97081_97103[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__47173__auto__))
;
return ((function (switch__47085__auto__,c__47173__auto__){
return (function() {
var cljs$core$async$state_machine__47086__auto__ = null;
var cljs$core$async$state_machine__47086__auto____0 = (function (){
var statearr_97082 = [null,null,null,null,null,null,null,null];
(statearr_97082[(0)] = cljs$core$async$state_machine__47086__auto__);

(statearr_97082[(1)] = (1));

return statearr_97082;
});
var cljs$core$async$state_machine__47086__auto____1 = (function (state_97064){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_97064);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e97083){if((e97083 instanceof Object)){
var ex__47089__auto__ = e97083;
var statearr_97084_97111 = state_97064;
(statearr_97084_97111[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_97064);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e97083;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__97112 = state_97064;
state_97064 = G__97112;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
cljs$core$async$state_machine__47086__auto__ = function(state_97064){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__47086__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__47086__auto____1.call(this,state_97064);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__47086__auto____0;
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__47086__auto____1;
return cljs$core$async$state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto__))
})();
var state__47175__auto__ = (function (){var statearr_97085 = f__47174__auto__.call(null);
(statearr_97085[(6)] = c__47173__auto__);

return statearr_97085;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto__))
);

return c__47173__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__28824__auto__ = (((_ == null))?null:_);
var m__28825__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,_);
} else {
var m__28825__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__28824__auto__ = (((m == null))?null:m);
var m__28825__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__28825__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__28824__auto__ = (((m == null))?null:m);
var m__28825__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,m,ch);
} else {
var m__28825__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__28824__auto__ = (((m == null))?null:m);
var m__28825__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,m);
} else {
var m__28825__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async97120 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async97120 = (function (ch,cs,meta97121){
this.ch = ch;
this.cs = cs;
this.meta97121 = meta97121;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

cljs.core.async.t_cljs$core$async97120.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_97122,meta97121__$1){
var self__ = this;
var _97122__$1 = this;
return (new cljs.core.async.t_cljs$core$async97120(self__.ch,self__.cs,meta97121__$1));
});})(cs))
;


cljs.core.async.t_cljs$core$async97120.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_97122){
var self__ = this;
var _97122__$1 = this;
return self__.meta97121;
});})(cs))
;


cljs.core.async.t_cljs$core$async97120.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async97120.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;


cljs.core.async.t_cljs$core$async97120.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async97120.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;


cljs.core.async.t_cljs$core$async97120.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;


cljs.core.async.t_cljs$core$async97120.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async97120.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta97121","meta97121",-275499730,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async97120.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async97120.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async97120";

cljs.core.async.t_cljs$core$async97120.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"cljs.core.async/t_cljs$core$async97120");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async97120 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async97120(ch__$1,cs__$1,meta97121){
return (new cljs.core.async.t_cljs$core$async97120(ch__$1,cs__$1,meta97121));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async97120(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__47173__auto___97354 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto___97354,cs,m,dchan,dctr,done){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto___97354,cs,m,dchan,dctr,done){
return (function (state_97260){
var state_val_97261 = (state_97260[(1)]);
if((state_val_97261 === (7))){
var inst_97256 = (state_97260[(2)]);
var state_97260__$1 = state_97260;
var statearr_97262_97355 = state_97260__$1;
(statearr_97262_97355[(2)] = inst_97256);

(statearr_97262_97355[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97261 === (20))){
var inst_97156 = (state_97260[(7)]);
var inst_97168 = cljs.core.first.call(null,inst_97156);
var inst_97169 = cljs.core.nth.call(null,inst_97168,(0),null);
var inst_97170 = cljs.core.nth.call(null,inst_97168,(1),null);
var state_97260__$1 = (function (){var statearr_97263 = state_97260;
(statearr_97263[(8)] = inst_97169);

return statearr_97263;
})();
if(cljs.core.truth_(inst_97170)){
var statearr_97264_97356 = state_97260__$1;
(statearr_97264_97356[(1)] = (22));

} else {
var statearr_97265_97357 = state_97260__$1;
(statearr_97265_97357[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97261 === (27))){
var inst_97200 = (state_97260[(9)]);
var inst_97198 = (state_97260[(10)]);
var inst_97125 = (state_97260[(11)]);
var inst_97205 = (state_97260[(12)]);
var inst_97205__$1 = cljs.core._nth.call(null,inst_97198,inst_97200);
var inst_97206 = cljs.core.async.put_BANG_.call(null,inst_97205__$1,inst_97125,done);
var state_97260__$1 = (function (){var statearr_97266 = state_97260;
(statearr_97266[(12)] = inst_97205__$1);

return statearr_97266;
})();
if(cljs.core.truth_(inst_97206)){
var statearr_97267_97358 = state_97260__$1;
(statearr_97267_97358[(1)] = (30));

} else {
var statearr_97268_97359 = state_97260__$1;
(statearr_97268_97359[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97261 === (1))){
var state_97260__$1 = state_97260;
var statearr_97269_97360 = state_97260__$1;
(statearr_97269_97360[(2)] = null);

(statearr_97269_97360[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97261 === (24))){
var inst_97156 = (state_97260[(7)]);
var inst_97175 = (state_97260[(2)]);
var inst_97176 = cljs.core.next.call(null,inst_97156);
var inst_97134 = inst_97176;
var inst_97135 = null;
var inst_97136 = (0);
var inst_97137 = (0);
var state_97260__$1 = (function (){var statearr_97270 = state_97260;
(statearr_97270[(13)] = inst_97175);

(statearr_97270[(14)] = inst_97137);

(statearr_97270[(15)] = inst_97136);

(statearr_97270[(16)] = inst_97134);

(statearr_97270[(17)] = inst_97135);

return statearr_97270;
})();
var statearr_97271_97364 = state_97260__$1;
(statearr_97271_97364[(2)] = null);

(statearr_97271_97364[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97261 === (39))){
var state_97260__$1 = state_97260;
var statearr_97275_97365 = state_97260__$1;
(statearr_97275_97365[(2)] = null);

(statearr_97275_97365[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97261 === (4))){
var inst_97125 = (state_97260[(11)]);
var inst_97125__$1 = (state_97260[(2)]);
var inst_97126 = (inst_97125__$1 == null);
var state_97260__$1 = (function (){var statearr_97276 = state_97260;
(statearr_97276[(11)] = inst_97125__$1);

return statearr_97276;
})();
if(cljs.core.truth_(inst_97126)){
var statearr_97277_97366 = state_97260__$1;
(statearr_97277_97366[(1)] = (5));

} else {
var statearr_97278_97367 = state_97260__$1;
(statearr_97278_97367[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97261 === (15))){
var inst_97137 = (state_97260[(14)]);
var inst_97136 = (state_97260[(15)]);
var inst_97134 = (state_97260[(16)]);
var inst_97135 = (state_97260[(17)]);
var inst_97152 = (state_97260[(2)]);
var inst_97153 = (inst_97137 + (1));
var tmp97272 = inst_97136;
var tmp97273 = inst_97134;
var tmp97274 = inst_97135;
var inst_97134__$1 = tmp97273;
var inst_97135__$1 = tmp97274;
var inst_97136__$1 = tmp97272;
var inst_97137__$1 = inst_97153;
var state_97260__$1 = (function (){var statearr_97279 = state_97260;
(statearr_97279[(18)] = inst_97152);

(statearr_97279[(14)] = inst_97137__$1);

(statearr_97279[(15)] = inst_97136__$1);

(statearr_97279[(16)] = inst_97134__$1);

(statearr_97279[(17)] = inst_97135__$1);

return statearr_97279;
})();
var statearr_97280_97368 = state_97260__$1;
(statearr_97280_97368[(2)] = null);

(statearr_97280_97368[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97261 === (21))){
var inst_97179 = (state_97260[(2)]);
var state_97260__$1 = state_97260;
var statearr_97284_97369 = state_97260__$1;
(statearr_97284_97369[(2)] = inst_97179);

(statearr_97284_97369[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97261 === (31))){
var inst_97205 = (state_97260[(12)]);
var inst_97209 = done.call(null,null);
var inst_97210 = cljs.core.async.untap_STAR_.call(null,m,inst_97205);
var state_97260__$1 = (function (){var statearr_97285 = state_97260;
(statearr_97285[(19)] = inst_97209);

return statearr_97285;
})();
var statearr_97286_97370 = state_97260__$1;
(statearr_97286_97370[(2)] = inst_97210);

(statearr_97286_97370[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97261 === (32))){
var inst_97200 = (state_97260[(9)]);
var inst_97199 = (state_97260[(20)]);
var inst_97198 = (state_97260[(10)]);
var inst_97197 = (state_97260[(21)]);
var inst_97212 = (state_97260[(2)]);
var inst_97213 = (inst_97200 + (1));
var tmp97281 = inst_97199;
var tmp97282 = inst_97198;
var tmp97283 = inst_97197;
var inst_97197__$1 = tmp97283;
var inst_97198__$1 = tmp97282;
var inst_97199__$1 = tmp97281;
var inst_97200__$1 = inst_97213;
var state_97260__$1 = (function (){var statearr_97287 = state_97260;
(statearr_97287[(9)] = inst_97200__$1);

(statearr_97287[(22)] = inst_97212);

(statearr_97287[(20)] = inst_97199__$1);

(statearr_97287[(10)] = inst_97198__$1);

(statearr_97287[(21)] = inst_97197__$1);

return statearr_97287;
})();
var statearr_97288_97371 = state_97260__$1;
(statearr_97288_97371[(2)] = null);

(statearr_97288_97371[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97261 === (40))){
var inst_97228 = (state_97260[(23)]);
var inst_97232 = done.call(null,null);
var inst_97233 = cljs.core.async.untap_STAR_.call(null,m,inst_97228);
var state_97260__$1 = (function (){var statearr_97289 = state_97260;
(statearr_97289[(24)] = inst_97232);

return statearr_97289;
})();
var statearr_97290_97372 = state_97260__$1;
(statearr_97290_97372[(2)] = inst_97233);

(statearr_97290_97372[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97261 === (33))){
var inst_97219 = (state_97260[(25)]);
var inst_97221 = cljs.core.chunked_seq_QMARK_.call(null,inst_97219);
var state_97260__$1 = state_97260;
if(inst_97221){
var statearr_97291_97376 = state_97260__$1;
(statearr_97291_97376[(1)] = (36));

} else {
var statearr_97292_97377 = state_97260__$1;
(statearr_97292_97377[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97261 === (13))){
var inst_97146 = (state_97260[(26)]);
var inst_97149 = cljs.core.async.close_BANG_.call(null,inst_97146);
var state_97260__$1 = state_97260;
var statearr_97293_97378 = state_97260__$1;
(statearr_97293_97378[(2)] = inst_97149);

(statearr_97293_97378[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97261 === (22))){
var inst_97169 = (state_97260[(8)]);
var inst_97172 = cljs.core.async.close_BANG_.call(null,inst_97169);
var state_97260__$1 = state_97260;
var statearr_97297_97379 = state_97260__$1;
(statearr_97297_97379[(2)] = inst_97172);

(statearr_97297_97379[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97261 === (36))){
var inst_97219 = (state_97260[(25)]);
var inst_97223 = cljs.core.chunk_first.call(null,inst_97219);
var inst_97224 = cljs.core.chunk_rest.call(null,inst_97219);
var inst_97225 = cljs.core.count.call(null,inst_97223);
var inst_97197 = inst_97224;
var inst_97198 = inst_97223;
var inst_97199 = inst_97225;
var inst_97200 = (0);
var state_97260__$1 = (function (){var statearr_97298 = state_97260;
(statearr_97298[(9)] = inst_97200);

(statearr_97298[(20)] = inst_97199);

(statearr_97298[(10)] = inst_97198);

(statearr_97298[(21)] = inst_97197);

return statearr_97298;
})();
var statearr_97299_97380 = state_97260__$1;
(statearr_97299_97380[(2)] = null);

(statearr_97299_97380[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97261 === (41))){
var inst_97219 = (state_97260[(25)]);
var inst_97235 = (state_97260[(2)]);
var inst_97236 = cljs.core.next.call(null,inst_97219);
var inst_97197 = inst_97236;
var inst_97198 = null;
var inst_97199 = (0);
var inst_97200 = (0);
var state_97260__$1 = (function (){var statearr_97300 = state_97260;
(statearr_97300[(9)] = inst_97200);

(statearr_97300[(27)] = inst_97235);

(statearr_97300[(20)] = inst_97199);

(statearr_97300[(10)] = inst_97198);

(statearr_97300[(21)] = inst_97197);

return statearr_97300;
})();
var statearr_97301_97381 = state_97260__$1;
(statearr_97301_97381[(2)] = null);

(statearr_97301_97381[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97261 === (43))){
var state_97260__$1 = state_97260;
var statearr_97302_97382 = state_97260__$1;
(statearr_97302_97382[(2)] = null);

(statearr_97302_97382[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97261 === (29))){
var inst_97244 = (state_97260[(2)]);
var state_97260__$1 = state_97260;
var statearr_97303_97383 = state_97260__$1;
(statearr_97303_97383[(2)] = inst_97244);

(statearr_97303_97383[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97261 === (44))){
var inst_97253 = (state_97260[(2)]);
var state_97260__$1 = (function (){var statearr_97304 = state_97260;
(statearr_97304[(28)] = inst_97253);

return statearr_97304;
})();
var statearr_97305_97384 = state_97260__$1;
(statearr_97305_97384[(2)] = null);

(statearr_97305_97384[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97261 === (6))){
var inst_97189 = (state_97260[(29)]);
var inst_97188 = cljs.core.deref.call(null,cs);
var inst_97189__$1 = cljs.core.keys.call(null,inst_97188);
var inst_97190 = cljs.core.count.call(null,inst_97189__$1);
var inst_97191 = cljs.core.reset_BANG_.call(null,dctr,inst_97190);
var inst_97196 = cljs.core.seq.call(null,inst_97189__$1);
var inst_97197 = inst_97196;
var inst_97198 = null;
var inst_97199 = (0);
var inst_97200 = (0);
var state_97260__$1 = (function (){var statearr_97306 = state_97260;
(statearr_97306[(9)] = inst_97200);

(statearr_97306[(30)] = inst_97191);

(statearr_97306[(20)] = inst_97199);

(statearr_97306[(10)] = inst_97198);

(statearr_97306[(21)] = inst_97197);

(statearr_97306[(29)] = inst_97189__$1);

return statearr_97306;
})();
var statearr_97307_97388 = state_97260__$1;
(statearr_97307_97388[(2)] = null);

(statearr_97307_97388[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97261 === (28))){
var inst_97219 = (state_97260[(25)]);
var inst_97197 = (state_97260[(21)]);
var inst_97219__$1 = cljs.core.seq.call(null,inst_97197);
var state_97260__$1 = (function (){var statearr_97308 = state_97260;
(statearr_97308[(25)] = inst_97219__$1);

return statearr_97308;
})();
if(inst_97219__$1){
var statearr_97309_97389 = state_97260__$1;
(statearr_97309_97389[(1)] = (33));

} else {
var statearr_97310_97390 = state_97260__$1;
(statearr_97310_97390[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97261 === (25))){
var inst_97200 = (state_97260[(9)]);
var inst_97199 = (state_97260[(20)]);
var inst_97202 = (inst_97200 < inst_97199);
var inst_97203 = inst_97202;
var state_97260__$1 = state_97260;
if(cljs.core.truth_(inst_97203)){
var statearr_97311_97391 = state_97260__$1;
(statearr_97311_97391[(1)] = (27));

} else {
var statearr_97312_97392 = state_97260__$1;
(statearr_97312_97392[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97261 === (34))){
var state_97260__$1 = state_97260;
var statearr_97313_97393 = state_97260__$1;
(statearr_97313_97393[(2)] = null);

(statearr_97313_97393[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97261 === (17))){
var state_97260__$1 = state_97260;
var statearr_97314_97394 = state_97260__$1;
(statearr_97314_97394[(2)] = null);

(statearr_97314_97394[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97261 === (3))){
var inst_97258 = (state_97260[(2)]);
var state_97260__$1 = state_97260;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_97260__$1,inst_97258);
} else {
if((state_val_97261 === (12))){
var inst_97184 = (state_97260[(2)]);
var state_97260__$1 = state_97260;
var statearr_97315_97396 = state_97260__$1;
(statearr_97315_97396[(2)] = inst_97184);

(statearr_97315_97396[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97261 === (2))){
var state_97260__$1 = state_97260;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_97260__$1,(4),ch);
} else {
if((state_val_97261 === (23))){
var state_97260__$1 = state_97260;
var statearr_97316_97397 = state_97260__$1;
(statearr_97316_97397[(2)] = null);

(statearr_97316_97397[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97261 === (35))){
var inst_97242 = (state_97260[(2)]);
var state_97260__$1 = state_97260;
var statearr_97317_97398 = state_97260__$1;
(statearr_97317_97398[(2)] = inst_97242);

(statearr_97317_97398[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97261 === (19))){
var inst_97156 = (state_97260[(7)]);
var inst_97160 = cljs.core.chunk_first.call(null,inst_97156);
var inst_97161 = cljs.core.chunk_rest.call(null,inst_97156);
var inst_97162 = cljs.core.count.call(null,inst_97160);
var inst_97134 = inst_97161;
var inst_97135 = inst_97160;
var inst_97136 = inst_97162;
var inst_97137 = (0);
var state_97260__$1 = (function (){var statearr_97318 = state_97260;
(statearr_97318[(14)] = inst_97137);

(statearr_97318[(15)] = inst_97136);

(statearr_97318[(16)] = inst_97134);

(statearr_97318[(17)] = inst_97135);

return statearr_97318;
})();
var statearr_97319_97399 = state_97260__$1;
(statearr_97319_97399[(2)] = null);

(statearr_97319_97399[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97261 === (11))){
var inst_97134 = (state_97260[(16)]);
var inst_97156 = (state_97260[(7)]);
var inst_97156__$1 = cljs.core.seq.call(null,inst_97134);
var state_97260__$1 = (function (){var statearr_97320 = state_97260;
(statearr_97320[(7)] = inst_97156__$1);

return statearr_97320;
})();
if(inst_97156__$1){
var statearr_97321_97400 = state_97260__$1;
(statearr_97321_97400[(1)] = (16));

} else {
var statearr_97322_97401 = state_97260__$1;
(statearr_97322_97401[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97261 === (9))){
var inst_97186 = (state_97260[(2)]);
var state_97260__$1 = state_97260;
var statearr_97323_97402 = state_97260__$1;
(statearr_97323_97402[(2)] = inst_97186);

(statearr_97323_97402[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97261 === (5))){
var inst_97132 = cljs.core.deref.call(null,cs);
var inst_97133 = cljs.core.seq.call(null,inst_97132);
var inst_97134 = inst_97133;
var inst_97135 = null;
var inst_97136 = (0);
var inst_97137 = (0);
var state_97260__$1 = (function (){var statearr_97327 = state_97260;
(statearr_97327[(14)] = inst_97137);

(statearr_97327[(15)] = inst_97136);

(statearr_97327[(16)] = inst_97134);

(statearr_97327[(17)] = inst_97135);

return statearr_97327;
})();
var statearr_97328_97405 = state_97260__$1;
(statearr_97328_97405[(2)] = null);

(statearr_97328_97405[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97261 === (14))){
var state_97260__$1 = state_97260;
var statearr_97329_97409 = state_97260__$1;
(statearr_97329_97409[(2)] = null);

(statearr_97329_97409[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97261 === (45))){
var inst_97250 = (state_97260[(2)]);
var state_97260__$1 = state_97260;
var statearr_97330_97410 = state_97260__$1;
(statearr_97330_97410[(2)] = inst_97250);

(statearr_97330_97410[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97261 === (26))){
var inst_97189 = (state_97260[(29)]);
var inst_97246 = (state_97260[(2)]);
var inst_97247 = cljs.core.seq.call(null,inst_97189);
var state_97260__$1 = (function (){var statearr_97331 = state_97260;
(statearr_97331[(31)] = inst_97246);

return statearr_97331;
})();
if(inst_97247){
var statearr_97332_97411 = state_97260__$1;
(statearr_97332_97411[(1)] = (42));

} else {
var statearr_97333_97412 = state_97260__$1;
(statearr_97333_97412[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97261 === (16))){
var inst_97156 = (state_97260[(7)]);
var inst_97158 = cljs.core.chunked_seq_QMARK_.call(null,inst_97156);
var state_97260__$1 = state_97260;
if(inst_97158){
var statearr_97334_97413 = state_97260__$1;
(statearr_97334_97413[(1)] = (19));

} else {
var statearr_97335_97414 = state_97260__$1;
(statearr_97335_97414[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97261 === (38))){
var inst_97239 = (state_97260[(2)]);
var state_97260__$1 = state_97260;
var statearr_97336_97415 = state_97260__$1;
(statearr_97336_97415[(2)] = inst_97239);

(statearr_97336_97415[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97261 === (30))){
var state_97260__$1 = state_97260;
var statearr_97337_97416 = state_97260__$1;
(statearr_97337_97416[(2)] = null);

(statearr_97337_97416[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97261 === (10))){
var inst_97137 = (state_97260[(14)]);
var inst_97135 = (state_97260[(17)]);
var inst_97145 = cljs.core._nth.call(null,inst_97135,inst_97137);
var inst_97146 = cljs.core.nth.call(null,inst_97145,(0),null);
var inst_97147 = cljs.core.nth.call(null,inst_97145,(1),null);
var state_97260__$1 = (function (){var statearr_97338 = state_97260;
(statearr_97338[(26)] = inst_97146);

return statearr_97338;
})();
if(cljs.core.truth_(inst_97147)){
var statearr_97339_97417 = state_97260__$1;
(statearr_97339_97417[(1)] = (13));

} else {
var statearr_97340_97418 = state_97260__$1;
(statearr_97340_97418[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97261 === (18))){
var inst_97182 = (state_97260[(2)]);
var state_97260__$1 = state_97260;
var statearr_97341_97419 = state_97260__$1;
(statearr_97341_97419[(2)] = inst_97182);

(statearr_97341_97419[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97261 === (42))){
var state_97260__$1 = state_97260;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_97260__$1,(45),dchan);
} else {
if((state_val_97261 === (37))){
var inst_97219 = (state_97260[(25)]);
var inst_97228 = (state_97260[(23)]);
var inst_97125 = (state_97260[(11)]);
var inst_97228__$1 = cljs.core.first.call(null,inst_97219);
var inst_97229 = cljs.core.async.put_BANG_.call(null,inst_97228__$1,inst_97125,done);
var state_97260__$1 = (function (){var statearr_97342 = state_97260;
(statearr_97342[(23)] = inst_97228__$1);

return statearr_97342;
})();
if(cljs.core.truth_(inst_97229)){
var statearr_97343_97420 = state_97260__$1;
(statearr_97343_97420[(1)] = (39));

} else {
var statearr_97344_97421 = state_97260__$1;
(statearr_97344_97421[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97261 === (8))){
var inst_97137 = (state_97260[(14)]);
var inst_97136 = (state_97260[(15)]);
var inst_97139 = (inst_97137 < inst_97136);
var inst_97140 = inst_97139;
var state_97260__$1 = state_97260;
if(cljs.core.truth_(inst_97140)){
var statearr_97345_97425 = state_97260__$1;
(statearr_97345_97425[(1)] = (10));

} else {
var statearr_97346_97426 = state_97260__$1;
(statearr_97346_97426[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__47173__auto___97354,cs,m,dchan,dctr,done))
;
return ((function (switch__47085__auto__,c__47173__auto___97354,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__47086__auto__ = null;
var cljs$core$async$mult_$_state_machine__47086__auto____0 = (function (){
var statearr_97347 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_97347[(0)] = cljs$core$async$mult_$_state_machine__47086__auto__);

(statearr_97347[(1)] = (1));

return statearr_97347;
});
var cljs$core$async$mult_$_state_machine__47086__auto____1 = (function (state_97260){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_97260);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e97348){if((e97348 instanceof Object)){
var ex__47089__auto__ = e97348;
var statearr_97349_97427 = state_97260;
(statearr_97349_97427[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_97260);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e97348;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__97428 = state_97260;
state_97260 = G__97428;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__47086__auto__ = function(state_97260){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__47086__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__47086__auto____1.call(this,state_97260);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mult_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__47086__auto____0;
cljs$core$async$mult_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__47086__auto____1;
return cljs$core$async$mult_$_state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto___97354,cs,m,dchan,dctr,done))
})();
var state__47175__auto__ = (function (){var statearr_97350 = f__47174__auto__.call(null);
(statearr_97350[(6)] = c__47173__auto___97354);

return statearr_97350;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto___97354,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__97430 = arguments.length;
switch (G__97430) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__28824__auto__ = (((m == null))?null:m);
var m__28825__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,m,ch);
} else {
var m__28825__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__28824__auto__ = (((m == null))?null:m);
var m__28825__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,m,ch);
} else {
var m__28825__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__28824__auto__ = (((m == null))?null:m);
var m__28825__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,m);
} else {
var m__28825__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__28824__auto__ = (((m == null))?null:m);
var m__28825__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,m,state_map);
} else {
var m__28825__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__28824__auto__ = (((m == null))?null:m);
var m__28825__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,m,mode);
} else {
var m__28825__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__29319__auto__ = [];
var len__29312__auto___97451 = arguments.length;
var i__29313__auto___97452 = (0);
while(true){
if((i__29313__auto___97452 < len__29312__auto___97451)){
args__29319__auto__.push((arguments[i__29313__auto___97452]));

var G__97453 = (i__29313__auto___97452 + (1));
i__29313__auto___97452 = G__97453;
continue;
} else {
}
break;
}

var argseq__29320__auto__ = ((((3) < args__29319__auto__.length))?(new cljs.core.IndexedSeq(args__29319__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__29320__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__97442){
var map__97443 = p__97442;
var map__97443__$1 = ((((!((map__97443 == null)))?((((map__97443.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__97443.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__97443):map__97443);
var opts = map__97443__$1;
var statearr_97448_97454 = state;
(statearr_97448_97454[(1)] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts.call(null,((function (map__97443,map__97443__$1,opts){
return (function (val){
var statearr_97449_97455 = state;
(statearr_97449_97455[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__97443,map__97443__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_97450_97456 = state;
(statearr_97450_97456[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq97438){
var G__97439 = cljs.core.first.call(null,seq97438);
var seq97438__$1 = cljs.core.next.call(null,seq97438);
var G__97440 = cljs.core.first.call(null,seq97438__$1);
var seq97438__$2 = cljs.core.next.call(null,seq97438__$1);
var G__97441 = cljs.core.first.call(null,seq97438__$2);
var seq97438__$3 = cljs.core.next.call(null,seq97438__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__97439,G__97440,G__97441,seq97438__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async97462 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async97462 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta97463){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta97463 = meta97463;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

cljs.core.async.t_cljs$core$async97462.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_97464,meta97463__$1){
var self__ = this;
var _97464__$1 = this;
return (new cljs.core.async.t_cljs$core$async97462(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta97463__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async97462.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_97464){
var self__ = this;
var _97464__$1 = this;
return self__.meta97463;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async97462.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async97462.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async97462.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async97462.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async97462.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async97462.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async97462.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async97462.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async97462.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta97463","meta97463",-1376210051,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async97462.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async97462.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async97462";

cljs.core.async.t_cljs$core$async97462.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"cljs.core.async/t_cljs$core$async97462");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async97462 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async97462(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta97463){
return (new cljs.core.async.t_cljs$core$async97462(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta97463));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async97462(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__47173__auto___97646 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto___97646,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto___97646,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_97568){
var state_val_97570 = (state_97568[(1)]);
if((state_val_97570 === (7))){
var inst_97482 = (state_97568[(2)]);
var state_97568__$1 = state_97568;
var statearr_97573_97649 = state_97568__$1;
(statearr_97573_97649[(2)] = inst_97482);

(statearr_97573_97649[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97570 === (20))){
var inst_97494 = (state_97568[(7)]);
var state_97568__$1 = state_97568;
var statearr_97574_97650 = state_97568__$1;
(statearr_97574_97650[(2)] = inst_97494);

(statearr_97574_97650[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97570 === (27))){
var state_97568__$1 = state_97568;
var statearr_97578_97652 = state_97568__$1;
(statearr_97578_97652[(2)] = null);

(statearr_97578_97652[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97570 === (1))){
var inst_97469 = (state_97568[(8)]);
var inst_97469__$1 = calc_state.call(null);
var inst_97471 = (inst_97469__$1 == null);
var inst_97472 = cljs.core.not.call(null,inst_97471);
var state_97568__$1 = (function (){var statearr_97579 = state_97568;
(statearr_97579[(8)] = inst_97469__$1);

return statearr_97579;
})();
if(inst_97472){
var statearr_97580_97655 = state_97568__$1;
(statearr_97580_97655[(1)] = (2));

} else {
var statearr_97581_97656 = state_97568__$1;
(statearr_97581_97656[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97570 === (24))){
var inst_97518 = (state_97568[(9)]);
var inst_97541 = (state_97568[(10)]);
var inst_97527 = (state_97568[(11)]);
var inst_97541__$1 = inst_97518.call(null,inst_97527);
var state_97568__$1 = (function (){var statearr_97582 = state_97568;
(statearr_97582[(10)] = inst_97541__$1);

return statearr_97582;
})();
if(cljs.core.truth_(inst_97541__$1)){
var statearr_97583_97657 = state_97568__$1;
(statearr_97583_97657[(1)] = (29));

} else {
var statearr_97584_97658 = state_97568__$1;
(statearr_97584_97658[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97570 === (4))){
var inst_97485 = (state_97568[(2)]);
var state_97568__$1 = state_97568;
if(cljs.core.truth_(inst_97485)){
var statearr_97585_97659 = state_97568__$1;
(statearr_97585_97659[(1)] = (8));

} else {
var statearr_97586_97660 = state_97568__$1;
(statearr_97586_97660[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97570 === (15))){
var inst_97512 = (state_97568[(2)]);
var state_97568__$1 = state_97568;
if(cljs.core.truth_(inst_97512)){
var statearr_97587_97661 = state_97568__$1;
(statearr_97587_97661[(1)] = (19));

} else {
var statearr_97588_97662 = state_97568__$1;
(statearr_97588_97662[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97570 === (21))){
var inst_97517 = (state_97568[(12)]);
var inst_97517__$1 = (state_97568[(2)]);
var inst_97518 = cljs.core.get.call(null,inst_97517__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_97519 = cljs.core.get.call(null,inst_97517__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_97520 = cljs.core.get.call(null,inst_97517__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_97568__$1 = (function (){var statearr_97589 = state_97568;
(statearr_97589[(9)] = inst_97518);

(statearr_97589[(13)] = inst_97519);

(statearr_97589[(12)] = inst_97517__$1);

return statearr_97589;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_97568__$1,(22),inst_97520);
} else {
if((state_val_97570 === (31))){
var inst_97549 = (state_97568[(2)]);
var state_97568__$1 = state_97568;
if(cljs.core.truth_(inst_97549)){
var statearr_97590_97666 = state_97568__$1;
(statearr_97590_97666[(1)] = (32));

} else {
var statearr_97591_97667 = state_97568__$1;
(statearr_97591_97667[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97570 === (32))){
var inst_97526 = (state_97568[(14)]);
var state_97568__$1 = state_97568;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_97568__$1,(35),out,inst_97526);
} else {
if((state_val_97570 === (33))){
var inst_97517 = (state_97568[(12)]);
var inst_97494 = inst_97517;
var state_97568__$1 = (function (){var statearr_97593 = state_97568;
(statearr_97593[(7)] = inst_97494);

return statearr_97593;
})();
var statearr_97594_97668 = state_97568__$1;
(statearr_97594_97668[(2)] = null);

(statearr_97594_97668[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97570 === (13))){
var inst_97494 = (state_97568[(7)]);
var inst_97501 = inst_97494.cljs$lang$protocol_mask$partition0$;
var inst_97502 = (inst_97501 & (64));
var inst_97503 = inst_97494.cljs$core$ISeq$;
var inst_97504 = (cljs.core.PROTOCOL_SENTINEL === inst_97503);
var inst_97505 = (inst_97502) || (inst_97504);
var state_97568__$1 = state_97568;
if(cljs.core.truth_(inst_97505)){
var statearr_97595_97669 = state_97568__$1;
(statearr_97595_97669[(1)] = (16));

} else {
var statearr_97596_97670 = state_97568__$1;
(statearr_97596_97670[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97570 === (22))){
var inst_97526 = (state_97568[(14)]);
var inst_97527 = (state_97568[(11)]);
var inst_97525 = (state_97568[(2)]);
var inst_97526__$1 = cljs.core.nth.call(null,inst_97525,(0),null);
var inst_97527__$1 = cljs.core.nth.call(null,inst_97525,(1),null);
var inst_97528 = (inst_97526__$1 == null);
var inst_97529 = cljs.core._EQ_.call(null,inst_97527__$1,change);
var inst_97530 = (inst_97528) || (inst_97529);
var state_97568__$1 = (function (){var statearr_97597 = state_97568;
(statearr_97597[(14)] = inst_97526__$1);

(statearr_97597[(11)] = inst_97527__$1);

return statearr_97597;
})();
if(cljs.core.truth_(inst_97530)){
var statearr_97598_97671 = state_97568__$1;
(statearr_97598_97671[(1)] = (23));

} else {
var statearr_97599_97672 = state_97568__$1;
(statearr_97599_97672[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97570 === (36))){
var inst_97517 = (state_97568[(12)]);
var inst_97494 = inst_97517;
var state_97568__$1 = (function (){var statearr_97600 = state_97568;
(statearr_97600[(7)] = inst_97494);

return statearr_97600;
})();
var statearr_97601_97673 = state_97568__$1;
(statearr_97601_97673[(2)] = null);

(statearr_97601_97673[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97570 === (29))){
var inst_97541 = (state_97568[(10)]);
var state_97568__$1 = state_97568;
var statearr_97602_97674 = state_97568__$1;
(statearr_97602_97674[(2)] = inst_97541);

(statearr_97602_97674[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97570 === (6))){
var state_97568__$1 = state_97568;
var statearr_97603_97675 = state_97568__$1;
(statearr_97603_97675[(2)] = false);

(statearr_97603_97675[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97570 === (28))){
var inst_97537 = (state_97568[(2)]);
var inst_97538 = calc_state.call(null);
var inst_97494 = inst_97538;
var state_97568__$1 = (function (){var statearr_97604 = state_97568;
(statearr_97604[(7)] = inst_97494);

(statearr_97604[(15)] = inst_97537);

return statearr_97604;
})();
var statearr_97605_97676 = state_97568__$1;
(statearr_97605_97676[(2)] = null);

(statearr_97605_97676[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97570 === (25))){
var inst_97563 = (state_97568[(2)]);
var state_97568__$1 = state_97568;
var statearr_97606_97677 = state_97568__$1;
(statearr_97606_97677[(2)] = inst_97563);

(statearr_97606_97677[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97570 === (34))){
var inst_97561 = (state_97568[(2)]);
var state_97568__$1 = state_97568;
var statearr_97607_97681 = state_97568__$1;
(statearr_97607_97681[(2)] = inst_97561);

(statearr_97607_97681[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97570 === (17))){
var state_97568__$1 = state_97568;
var statearr_97608_97682 = state_97568__$1;
(statearr_97608_97682[(2)] = false);

(statearr_97608_97682[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97570 === (3))){
var state_97568__$1 = state_97568;
var statearr_97609_97683 = state_97568__$1;
(statearr_97609_97683[(2)] = false);

(statearr_97609_97683[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97570 === (12))){
var inst_97565 = (state_97568[(2)]);
var state_97568__$1 = state_97568;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_97568__$1,inst_97565);
} else {
if((state_val_97570 === (2))){
var inst_97469 = (state_97568[(8)]);
var inst_97474 = inst_97469.cljs$lang$protocol_mask$partition0$;
var inst_97475 = (inst_97474 & (64));
var inst_97476 = inst_97469.cljs$core$ISeq$;
var inst_97477 = (cljs.core.PROTOCOL_SENTINEL === inst_97476);
var inst_97478 = (inst_97475) || (inst_97477);
var state_97568__$1 = state_97568;
if(cljs.core.truth_(inst_97478)){
var statearr_97610_97684 = state_97568__$1;
(statearr_97610_97684[(1)] = (5));

} else {
var statearr_97611_97685 = state_97568__$1;
(statearr_97611_97685[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97570 === (23))){
var inst_97526 = (state_97568[(14)]);
var inst_97532 = (inst_97526 == null);
var state_97568__$1 = state_97568;
if(cljs.core.truth_(inst_97532)){
var statearr_97612_97686 = state_97568__$1;
(statearr_97612_97686[(1)] = (26));

} else {
var statearr_97613_97687 = state_97568__$1;
(statearr_97613_97687[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97570 === (35))){
var inst_97552 = (state_97568[(2)]);
var state_97568__$1 = state_97568;
if(cljs.core.truth_(inst_97552)){
var statearr_97614_97688 = state_97568__$1;
(statearr_97614_97688[(1)] = (36));

} else {
var statearr_97615_97689 = state_97568__$1;
(statearr_97615_97689[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97570 === (19))){
var inst_97494 = (state_97568[(7)]);
var inst_97514 = cljs.core.apply.call(null,cljs.core.hash_map,inst_97494);
var state_97568__$1 = state_97568;
var statearr_97617_97690 = state_97568__$1;
(statearr_97617_97690[(2)] = inst_97514);

(statearr_97617_97690[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97570 === (11))){
var inst_97494 = (state_97568[(7)]);
var inst_97498 = (inst_97494 == null);
var inst_97499 = cljs.core.not.call(null,inst_97498);
var state_97568__$1 = state_97568;
if(inst_97499){
var statearr_97619_97691 = state_97568__$1;
(statearr_97619_97691[(1)] = (13));

} else {
var statearr_97620_97692 = state_97568__$1;
(statearr_97620_97692[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97570 === (9))){
var inst_97469 = (state_97568[(8)]);
var state_97568__$1 = state_97568;
var statearr_97621_97693 = state_97568__$1;
(statearr_97621_97693[(2)] = inst_97469);

(statearr_97621_97693[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97570 === (5))){
var state_97568__$1 = state_97568;
var statearr_97622_97694 = state_97568__$1;
(statearr_97622_97694[(2)] = true);

(statearr_97622_97694[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97570 === (14))){
var state_97568__$1 = state_97568;
var statearr_97624_97695 = state_97568__$1;
(statearr_97624_97695[(2)] = false);

(statearr_97624_97695[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97570 === (26))){
var inst_97527 = (state_97568[(11)]);
var inst_97534 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_97527);
var state_97568__$1 = state_97568;
var statearr_97626_97696 = state_97568__$1;
(statearr_97626_97696[(2)] = inst_97534);

(statearr_97626_97696[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97570 === (16))){
var state_97568__$1 = state_97568;
var statearr_97628_97700 = state_97568__$1;
(statearr_97628_97700[(2)] = true);

(statearr_97628_97700[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97570 === (38))){
var inst_97557 = (state_97568[(2)]);
var state_97568__$1 = state_97568;
var statearr_97629_97701 = state_97568__$1;
(statearr_97629_97701[(2)] = inst_97557);

(statearr_97629_97701[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97570 === (30))){
var inst_97518 = (state_97568[(9)]);
var inst_97519 = (state_97568[(13)]);
var inst_97527 = (state_97568[(11)]);
var inst_97544 = cljs.core.empty_QMARK_.call(null,inst_97518);
var inst_97545 = inst_97519.call(null,inst_97527);
var inst_97546 = cljs.core.not.call(null,inst_97545);
var inst_97547 = (inst_97544) && (inst_97546);
var state_97568__$1 = state_97568;
var statearr_97633_97702 = state_97568__$1;
(statearr_97633_97702[(2)] = inst_97547);

(statearr_97633_97702[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97570 === (10))){
var inst_97469 = (state_97568[(8)]);
var inst_97490 = (state_97568[(2)]);
var inst_97491 = cljs.core.get.call(null,inst_97490,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_97492 = cljs.core.get.call(null,inst_97490,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_97493 = cljs.core.get.call(null,inst_97490,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_97494 = inst_97469;
var state_97568__$1 = (function (){var statearr_97634 = state_97568;
(statearr_97634[(16)] = inst_97491);

(statearr_97634[(7)] = inst_97494);

(statearr_97634[(17)] = inst_97493);

(statearr_97634[(18)] = inst_97492);

return statearr_97634;
})();
var statearr_97635_97703 = state_97568__$1;
(statearr_97635_97703[(2)] = null);

(statearr_97635_97703[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97570 === (18))){
var inst_97509 = (state_97568[(2)]);
var state_97568__$1 = state_97568;
var statearr_97636_97704 = state_97568__$1;
(statearr_97636_97704[(2)] = inst_97509);

(statearr_97636_97704[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97570 === (37))){
var state_97568__$1 = state_97568;
var statearr_97637_97705 = state_97568__$1;
(statearr_97637_97705[(2)] = null);

(statearr_97637_97705[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97570 === (8))){
var inst_97469 = (state_97568[(8)]);
var inst_97487 = cljs.core.apply.call(null,cljs.core.hash_map,inst_97469);
var state_97568__$1 = state_97568;
var statearr_97638_97706 = state_97568__$1;
(statearr_97638_97706[(2)] = inst_97487);

(statearr_97638_97706[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__47173__auto___97646,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__47085__auto__,c__47173__auto___97646,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__47086__auto__ = null;
var cljs$core$async$mix_$_state_machine__47086__auto____0 = (function (){
var statearr_97639 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_97639[(0)] = cljs$core$async$mix_$_state_machine__47086__auto__);

(statearr_97639[(1)] = (1));

return statearr_97639;
});
var cljs$core$async$mix_$_state_machine__47086__auto____1 = (function (state_97568){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_97568);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e97640){if((e97640 instanceof Object)){
var ex__47089__auto__ = e97640;
var statearr_97641_97707 = state_97568;
(statearr_97641_97707[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_97568);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e97640;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__97708 = state_97568;
state_97568 = G__97708;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__47086__auto__ = function(state_97568){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__47086__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__47086__auto____1.call(this,state_97568);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mix_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__47086__auto____0;
cljs$core$async$mix_$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__47086__auto____1;
return cljs$core$async$mix_$_state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto___97646,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__47175__auto__ = (function (){var statearr_97642 = f__47174__auto__.call(null);
(statearr_97642[(6)] = c__47173__auto___97646);

return statearr_97642;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto___97646,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__28824__auto__ = (((p == null))?null:p);
var m__28825__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__28825__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__28824__auto__ = (((p == null))?null:p);
var m__28825__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,p,v,ch);
} else {
var m__28825__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__97713 = arguments.length;
switch (G__97713) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__28824__auto__ = (((p == null))?null:p);
var m__28825__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,p);
} else {
var m__28825__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__28824__auto__ = (((p == null))?null:p);
var m__28825__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,p,v);
} else {
var m__28825__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__97721 = arguments.length;
switch (G__97721) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__28141__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__28141__auto__,mults){
return (function (p1__97719_SHARP_){
if(cljs.core.truth_(p1__97719_SHARP_.call(null,topic))){
return p1__97719_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__97719_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__28141__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async97722 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async97722 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta97723){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta97723 = meta97723;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

cljs.core.async.t_cljs$core$async97722.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_97724,meta97723__$1){
var self__ = this;
var _97724__$1 = this;
return (new cljs.core.async.t_cljs$core$async97722(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta97723__$1));
});})(mults,ensure_mult))
;


cljs.core.async.t_cljs$core$async97722.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_97724){
var self__ = this;
var _97724__$1 = this;
return self__.meta97723;
});})(mults,ensure_mult))
;


cljs.core.async.t_cljs$core$async97722.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async97722.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;


cljs.core.async.t_cljs$core$async97722.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async97722.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;


cljs.core.async.t_cljs$core$async97722.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;


cljs.core.async.t_cljs$core$async97722.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;


cljs.core.async.t_cljs$core$async97722.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async97722.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta97723","meta97723",-1818551097,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async97722.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async97722.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async97722";

cljs.core.async.t_cljs$core$async97722.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"cljs.core.async/t_cljs$core$async97722");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async97722 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async97722(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta97723){
return (new cljs.core.async.t_cljs$core$async97722(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta97723));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async97722(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__47173__auto___97864 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto___97864,mults,ensure_mult,p){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto___97864,mults,ensure_mult,p){
return (function (state_97801){
var state_val_97802 = (state_97801[(1)]);
if((state_val_97802 === (7))){
var inst_97797 = (state_97801[(2)]);
var state_97801__$1 = state_97801;
var statearr_97804_97865 = state_97801__$1;
(statearr_97804_97865[(2)] = inst_97797);

(statearr_97804_97865[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97802 === (20))){
var state_97801__$1 = state_97801;
var statearr_97805_97866 = state_97801__$1;
(statearr_97805_97866[(2)] = null);

(statearr_97805_97866[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97802 === (1))){
var state_97801__$1 = state_97801;
var statearr_97806_97867 = state_97801__$1;
(statearr_97806_97867[(2)] = null);

(statearr_97806_97867[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97802 === (24))){
var inst_97780 = (state_97801[(7)]);
var inst_97789 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_97780);
var state_97801__$1 = state_97801;
var statearr_97807_97868 = state_97801__$1;
(statearr_97807_97868[(2)] = inst_97789);

(statearr_97807_97868[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97802 === (4))){
var inst_97732 = (state_97801[(8)]);
var inst_97732__$1 = (state_97801[(2)]);
var inst_97733 = (inst_97732__$1 == null);
var state_97801__$1 = (function (){var statearr_97808 = state_97801;
(statearr_97808[(8)] = inst_97732__$1);

return statearr_97808;
})();
if(cljs.core.truth_(inst_97733)){
var statearr_97809_97874 = state_97801__$1;
(statearr_97809_97874[(1)] = (5));

} else {
var statearr_97810_97875 = state_97801__$1;
(statearr_97810_97875[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97802 === (15))){
var inst_97774 = (state_97801[(2)]);
var state_97801__$1 = state_97801;
var statearr_97811_97876 = state_97801__$1;
(statearr_97811_97876[(2)] = inst_97774);

(statearr_97811_97876[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97802 === (21))){
var inst_97794 = (state_97801[(2)]);
var state_97801__$1 = (function (){var statearr_97812 = state_97801;
(statearr_97812[(9)] = inst_97794);

return statearr_97812;
})();
var statearr_97813_97877 = state_97801__$1;
(statearr_97813_97877[(2)] = null);

(statearr_97813_97877[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97802 === (13))){
var inst_97756 = (state_97801[(10)]);
var inst_97758 = cljs.core.chunked_seq_QMARK_.call(null,inst_97756);
var state_97801__$1 = state_97801;
if(inst_97758){
var statearr_97814_97878 = state_97801__$1;
(statearr_97814_97878[(1)] = (16));

} else {
var statearr_97815_97879 = state_97801__$1;
(statearr_97815_97879[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97802 === (22))){
var inst_97786 = (state_97801[(2)]);
var state_97801__$1 = state_97801;
if(cljs.core.truth_(inst_97786)){
var statearr_97816_97883 = state_97801__$1;
(statearr_97816_97883[(1)] = (23));

} else {
var statearr_97817_97884 = state_97801__$1;
(statearr_97817_97884[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97802 === (6))){
var inst_97780 = (state_97801[(7)]);
var inst_97782 = (state_97801[(11)]);
var inst_97732 = (state_97801[(8)]);
var inst_97780__$1 = topic_fn.call(null,inst_97732);
var inst_97781 = cljs.core.deref.call(null,mults);
var inst_97782__$1 = cljs.core.get.call(null,inst_97781,inst_97780__$1);
var state_97801__$1 = (function (){var statearr_97818 = state_97801;
(statearr_97818[(7)] = inst_97780__$1);

(statearr_97818[(11)] = inst_97782__$1);

return statearr_97818;
})();
if(cljs.core.truth_(inst_97782__$1)){
var statearr_97820_97885 = state_97801__$1;
(statearr_97820_97885[(1)] = (19));

} else {
var statearr_97821_97886 = state_97801__$1;
(statearr_97821_97886[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97802 === (25))){
var inst_97791 = (state_97801[(2)]);
var state_97801__$1 = state_97801;
var statearr_97823_97887 = state_97801__$1;
(statearr_97823_97887[(2)] = inst_97791);

(statearr_97823_97887[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97802 === (17))){
var inst_97756 = (state_97801[(10)]);
var inst_97765 = cljs.core.first.call(null,inst_97756);
var inst_97766 = cljs.core.async.muxch_STAR_.call(null,inst_97765);
var inst_97767 = cljs.core.async.close_BANG_.call(null,inst_97766);
var inst_97768 = cljs.core.next.call(null,inst_97756);
var inst_97742 = inst_97768;
var inst_97743 = null;
var inst_97744 = (0);
var inst_97745 = (0);
var state_97801__$1 = (function (){var statearr_97827 = state_97801;
(statearr_97827[(12)] = inst_97745);

(statearr_97827[(13)] = inst_97767);

(statearr_97827[(14)] = inst_97742);

(statearr_97827[(15)] = inst_97743);

(statearr_97827[(16)] = inst_97744);

return statearr_97827;
})();
var statearr_97828_97889 = state_97801__$1;
(statearr_97828_97889[(2)] = null);

(statearr_97828_97889[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97802 === (3))){
var inst_97799 = (state_97801[(2)]);
var state_97801__$1 = state_97801;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_97801__$1,inst_97799);
} else {
if((state_val_97802 === (12))){
var inst_97776 = (state_97801[(2)]);
var state_97801__$1 = state_97801;
var statearr_97829_97890 = state_97801__$1;
(statearr_97829_97890[(2)] = inst_97776);

(statearr_97829_97890[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97802 === (2))){
var state_97801__$1 = state_97801;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_97801__$1,(4),ch);
} else {
if((state_val_97802 === (23))){
var state_97801__$1 = state_97801;
var statearr_97830_97891 = state_97801__$1;
(statearr_97830_97891[(2)] = null);

(statearr_97830_97891[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97802 === (19))){
var inst_97782 = (state_97801[(11)]);
var inst_97732 = (state_97801[(8)]);
var inst_97784 = cljs.core.async.muxch_STAR_.call(null,inst_97782);
var state_97801__$1 = state_97801;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_97801__$1,(22),inst_97784,inst_97732);
} else {
if((state_val_97802 === (11))){
var inst_97742 = (state_97801[(14)]);
var inst_97756 = (state_97801[(10)]);
var inst_97756__$1 = cljs.core.seq.call(null,inst_97742);
var state_97801__$1 = (function (){var statearr_97831 = state_97801;
(statearr_97831[(10)] = inst_97756__$1);

return statearr_97831;
})();
if(inst_97756__$1){
var statearr_97832_97892 = state_97801__$1;
(statearr_97832_97892[(1)] = (13));

} else {
var statearr_97833_97893 = state_97801__$1;
(statearr_97833_97893[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97802 === (9))){
var inst_97778 = (state_97801[(2)]);
var state_97801__$1 = state_97801;
var statearr_97834_97894 = state_97801__$1;
(statearr_97834_97894[(2)] = inst_97778);

(statearr_97834_97894[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97802 === (5))){
var inst_97739 = cljs.core.deref.call(null,mults);
var inst_97740 = cljs.core.vals.call(null,inst_97739);
var inst_97741 = cljs.core.seq.call(null,inst_97740);
var inst_97742 = inst_97741;
var inst_97743 = null;
var inst_97744 = (0);
var inst_97745 = (0);
var state_97801__$1 = (function (){var statearr_97835 = state_97801;
(statearr_97835[(12)] = inst_97745);

(statearr_97835[(14)] = inst_97742);

(statearr_97835[(15)] = inst_97743);

(statearr_97835[(16)] = inst_97744);

return statearr_97835;
})();
var statearr_97836_97895 = state_97801__$1;
(statearr_97836_97895[(2)] = null);

(statearr_97836_97895[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97802 === (14))){
var state_97801__$1 = state_97801;
var statearr_97840_97896 = state_97801__$1;
(statearr_97840_97896[(2)] = null);

(statearr_97840_97896[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97802 === (16))){
var inst_97756 = (state_97801[(10)]);
var inst_97760 = cljs.core.chunk_first.call(null,inst_97756);
var inst_97761 = cljs.core.chunk_rest.call(null,inst_97756);
var inst_97762 = cljs.core.count.call(null,inst_97760);
var inst_97742 = inst_97761;
var inst_97743 = inst_97760;
var inst_97744 = inst_97762;
var inst_97745 = (0);
var state_97801__$1 = (function (){var statearr_97841 = state_97801;
(statearr_97841[(12)] = inst_97745);

(statearr_97841[(14)] = inst_97742);

(statearr_97841[(15)] = inst_97743);

(statearr_97841[(16)] = inst_97744);

return statearr_97841;
})();
var statearr_97842_97897 = state_97801__$1;
(statearr_97842_97897[(2)] = null);

(statearr_97842_97897[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97802 === (10))){
var inst_97745 = (state_97801[(12)]);
var inst_97742 = (state_97801[(14)]);
var inst_97743 = (state_97801[(15)]);
var inst_97744 = (state_97801[(16)]);
var inst_97750 = cljs.core._nth.call(null,inst_97743,inst_97745);
var inst_97751 = cljs.core.async.muxch_STAR_.call(null,inst_97750);
var inst_97752 = cljs.core.async.close_BANG_.call(null,inst_97751);
var inst_97753 = (inst_97745 + (1));
var tmp97837 = inst_97742;
var tmp97838 = inst_97743;
var tmp97839 = inst_97744;
var inst_97742__$1 = tmp97837;
var inst_97743__$1 = tmp97838;
var inst_97744__$1 = tmp97839;
var inst_97745__$1 = inst_97753;
var state_97801__$1 = (function (){var statearr_97843 = state_97801;
(statearr_97843[(12)] = inst_97745__$1);

(statearr_97843[(17)] = inst_97752);

(statearr_97843[(14)] = inst_97742__$1);

(statearr_97843[(15)] = inst_97743__$1);

(statearr_97843[(16)] = inst_97744__$1);

return statearr_97843;
})();
var statearr_97844_97898 = state_97801__$1;
(statearr_97844_97898[(2)] = null);

(statearr_97844_97898[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97802 === (18))){
var inst_97771 = (state_97801[(2)]);
var state_97801__$1 = state_97801;
var statearr_97845_97899 = state_97801__$1;
(statearr_97845_97899[(2)] = inst_97771);

(statearr_97845_97899[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97802 === (8))){
var inst_97745 = (state_97801[(12)]);
var inst_97744 = (state_97801[(16)]);
var inst_97747 = (inst_97745 < inst_97744);
var inst_97748 = inst_97747;
var state_97801__$1 = state_97801;
if(cljs.core.truth_(inst_97748)){
var statearr_97846_97900 = state_97801__$1;
(statearr_97846_97900[(1)] = (10));

} else {
var statearr_97847_97901 = state_97801__$1;
(statearr_97847_97901[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__47173__auto___97864,mults,ensure_mult,p))
;
return ((function (switch__47085__auto__,c__47173__auto___97864,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__47086__auto__ = null;
var cljs$core$async$state_machine__47086__auto____0 = (function (){
var statearr_97851 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_97851[(0)] = cljs$core$async$state_machine__47086__auto__);

(statearr_97851[(1)] = (1));

return statearr_97851;
});
var cljs$core$async$state_machine__47086__auto____1 = (function (state_97801){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_97801);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e97852){if((e97852 instanceof Object)){
var ex__47089__auto__ = e97852;
var statearr_97853_97906 = state_97801;
(statearr_97853_97906[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_97801);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e97852;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__97908 = state_97801;
state_97801 = G__97908;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
cljs$core$async$state_machine__47086__auto__ = function(state_97801){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__47086__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__47086__auto____1.call(this,state_97801);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__47086__auto____0;
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__47086__auto____1;
return cljs$core$async$state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto___97864,mults,ensure_mult,p))
})();
var state__47175__auto__ = (function (){var statearr_97854 = f__47174__auto__.call(null);
(statearr_97854[(6)] = c__47173__auto___97864);

return statearr_97854;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto___97864,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__97912 = arguments.length;
switch (G__97912) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__97922 = arguments.length;
switch (G__97922) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__97926 = arguments.length;
switch (G__97926) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__47173__auto___98007 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto___98007,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto___98007,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_97965){
var state_val_97966 = (state_97965[(1)]);
if((state_val_97966 === (7))){
var state_97965__$1 = state_97965;
var statearr_97969_98008 = state_97965__$1;
(statearr_97969_98008[(2)] = null);

(statearr_97969_98008[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97966 === (1))){
var state_97965__$1 = state_97965;
var statearr_97971_98009 = state_97965__$1;
(statearr_97971_98009[(2)] = null);

(statearr_97971_98009[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97966 === (4))){
var inst_97929 = (state_97965[(7)]);
var inst_97931 = (inst_97929 < cnt);
var state_97965__$1 = state_97965;
if(cljs.core.truth_(inst_97931)){
var statearr_97972_98010 = state_97965__$1;
(statearr_97972_98010[(1)] = (6));

} else {
var statearr_97973_98011 = state_97965__$1;
(statearr_97973_98011[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97966 === (15))){
var inst_97961 = (state_97965[(2)]);
var state_97965__$1 = state_97965;
var statearr_97976_98012 = state_97965__$1;
(statearr_97976_98012[(2)] = inst_97961);

(statearr_97976_98012[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97966 === (13))){
var inst_97954 = cljs.core.async.close_BANG_.call(null,out);
var state_97965__$1 = state_97965;
var statearr_97977_98013 = state_97965__$1;
(statearr_97977_98013[(2)] = inst_97954);

(statearr_97977_98013[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97966 === (6))){
var state_97965__$1 = state_97965;
var statearr_97978_98014 = state_97965__$1;
(statearr_97978_98014[(2)] = null);

(statearr_97978_98014[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97966 === (3))){
var inst_97963 = (state_97965[(2)]);
var state_97965__$1 = state_97965;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_97965__$1,inst_97963);
} else {
if((state_val_97966 === (12))){
var inst_97951 = (state_97965[(8)]);
var inst_97951__$1 = (state_97965[(2)]);
var inst_97952 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_97951__$1);
var state_97965__$1 = (function (){var statearr_97979 = state_97965;
(statearr_97979[(8)] = inst_97951__$1);

return statearr_97979;
})();
if(cljs.core.truth_(inst_97952)){
var statearr_97981_98015 = state_97965__$1;
(statearr_97981_98015[(1)] = (13));

} else {
var statearr_97982_98016 = state_97965__$1;
(statearr_97982_98016[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97966 === (2))){
var inst_97928 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_97929 = (0);
var state_97965__$1 = (function (){var statearr_97985 = state_97965;
(statearr_97985[(9)] = inst_97928);

(statearr_97985[(7)] = inst_97929);

return statearr_97985;
})();
var statearr_97986_98020 = state_97965__$1;
(statearr_97986_98020[(2)] = null);

(statearr_97986_98020[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97966 === (11))){
var inst_97929 = (state_97965[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_97965,(10),Object,null,(9));
var inst_97938 = chs__$1.call(null,inst_97929);
var inst_97939 = done.call(null,inst_97929);
var inst_97940 = cljs.core.async.take_BANG_.call(null,inst_97938,inst_97939);
var state_97965__$1 = state_97965;
var statearr_97987_98021 = state_97965__$1;
(statearr_97987_98021[(2)] = inst_97940);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_97965__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97966 === (9))){
var inst_97929 = (state_97965[(7)]);
var inst_97942 = (state_97965[(2)]);
var inst_97943 = (inst_97929 + (1));
var inst_97929__$1 = inst_97943;
var state_97965__$1 = (function (){var statearr_97988 = state_97965;
(statearr_97988[(10)] = inst_97942);

(statearr_97988[(7)] = inst_97929__$1);

return statearr_97988;
})();
var statearr_97990_98022 = state_97965__$1;
(statearr_97990_98022[(2)] = null);

(statearr_97990_98022[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97966 === (5))){
var inst_97949 = (state_97965[(2)]);
var state_97965__$1 = (function (){var statearr_97991 = state_97965;
(statearr_97991[(11)] = inst_97949);

return statearr_97991;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_97965__$1,(12),dchan);
} else {
if((state_val_97966 === (14))){
var inst_97951 = (state_97965[(8)]);
var inst_97956 = cljs.core.apply.call(null,f,inst_97951);
var state_97965__$1 = state_97965;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_97965__$1,(16),out,inst_97956);
} else {
if((state_val_97966 === (16))){
var inst_97958 = (state_97965[(2)]);
var state_97965__$1 = (function (){var statearr_97994 = state_97965;
(statearr_97994[(12)] = inst_97958);

return statearr_97994;
})();
var statearr_97995_98023 = state_97965__$1;
(statearr_97995_98023[(2)] = null);

(statearr_97995_98023[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97966 === (10))){
var inst_97933 = (state_97965[(2)]);
var inst_97934 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_97965__$1 = (function (){var statearr_97996 = state_97965;
(statearr_97996[(13)] = inst_97933);

return statearr_97996;
})();
var statearr_97997_98024 = state_97965__$1;
(statearr_97997_98024[(2)] = inst_97934);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_97965__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_97966 === (8))){
var inst_97947 = (state_97965[(2)]);
var state_97965__$1 = state_97965;
var statearr_98001_98025 = state_97965__$1;
(statearr_98001_98025[(2)] = inst_97947);

(statearr_98001_98025[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__47173__auto___98007,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__47085__auto__,c__47173__auto___98007,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__47086__auto__ = null;
var cljs$core$async$state_machine__47086__auto____0 = (function (){
var statearr_98002 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_98002[(0)] = cljs$core$async$state_machine__47086__auto__);

(statearr_98002[(1)] = (1));

return statearr_98002;
});
var cljs$core$async$state_machine__47086__auto____1 = (function (state_97965){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_97965);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e98003){if((e98003 instanceof Object)){
var ex__47089__auto__ = e98003;
var statearr_98004_98026 = state_97965;
(statearr_98004_98026[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_97965);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e98003;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__98027 = state_97965;
state_97965 = G__98027;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
cljs$core$async$state_machine__47086__auto__ = function(state_97965){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__47086__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__47086__auto____1.call(this,state_97965);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__47086__auto____0;
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__47086__auto____1;
return cljs$core$async$state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto___98007,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__47175__auto__ = (function (){var statearr_98005 = f__47174__auto__.call(null);
(statearr_98005[(6)] = c__47173__auto___98007);

return statearr_98005;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto___98007,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__98030 = arguments.length;
switch (G__98030) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__47173__auto___98084 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto___98084,out){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto___98084,out){
return (function (state_98062){
var state_val_98063 = (state_98062[(1)]);
if((state_val_98063 === (7))){
var inst_98041 = (state_98062[(7)]);
var inst_98042 = (state_98062[(8)]);
var inst_98041__$1 = (state_98062[(2)]);
var inst_98042__$1 = cljs.core.nth.call(null,inst_98041__$1,(0),null);
var inst_98043 = cljs.core.nth.call(null,inst_98041__$1,(1),null);
var inst_98044 = (inst_98042__$1 == null);
var state_98062__$1 = (function (){var statearr_98064 = state_98062;
(statearr_98064[(9)] = inst_98043);

(statearr_98064[(7)] = inst_98041__$1);

(statearr_98064[(8)] = inst_98042__$1);

return statearr_98064;
})();
if(cljs.core.truth_(inst_98044)){
var statearr_98065_98085 = state_98062__$1;
(statearr_98065_98085[(1)] = (8));

} else {
var statearr_98066_98086 = state_98062__$1;
(statearr_98066_98086[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98063 === (1))){
var inst_98031 = cljs.core.vec.call(null,chs);
var inst_98032 = inst_98031;
var state_98062__$1 = (function (){var statearr_98067 = state_98062;
(statearr_98067[(10)] = inst_98032);

return statearr_98067;
})();
var statearr_98068_98087 = state_98062__$1;
(statearr_98068_98087[(2)] = null);

(statearr_98068_98087[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98063 === (4))){
var inst_98032 = (state_98062[(10)]);
var state_98062__$1 = state_98062;
return cljs.core.async.ioc_alts_BANG_.call(null,state_98062__$1,(7),inst_98032);
} else {
if((state_val_98063 === (6))){
var inst_98058 = (state_98062[(2)]);
var state_98062__$1 = state_98062;
var statearr_98069_98088 = state_98062__$1;
(statearr_98069_98088[(2)] = inst_98058);

(statearr_98069_98088[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98063 === (3))){
var inst_98060 = (state_98062[(2)]);
var state_98062__$1 = state_98062;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_98062__$1,inst_98060);
} else {
if((state_val_98063 === (2))){
var inst_98032 = (state_98062[(10)]);
var inst_98034 = cljs.core.count.call(null,inst_98032);
var inst_98035 = (inst_98034 > (0));
var state_98062__$1 = state_98062;
if(cljs.core.truth_(inst_98035)){
var statearr_98071_98089 = state_98062__$1;
(statearr_98071_98089[(1)] = (4));

} else {
var statearr_98072_98090 = state_98062__$1;
(statearr_98072_98090[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98063 === (11))){
var inst_98032 = (state_98062[(10)]);
var inst_98051 = (state_98062[(2)]);
var tmp98070 = inst_98032;
var inst_98032__$1 = tmp98070;
var state_98062__$1 = (function (){var statearr_98073 = state_98062;
(statearr_98073[(10)] = inst_98032__$1);

(statearr_98073[(11)] = inst_98051);

return statearr_98073;
})();
var statearr_98074_98091 = state_98062__$1;
(statearr_98074_98091[(2)] = null);

(statearr_98074_98091[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98063 === (9))){
var inst_98042 = (state_98062[(8)]);
var state_98062__$1 = state_98062;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_98062__$1,(11),out,inst_98042);
} else {
if((state_val_98063 === (5))){
var inst_98056 = cljs.core.async.close_BANG_.call(null,out);
var state_98062__$1 = state_98062;
var statearr_98075_98092 = state_98062__$1;
(statearr_98075_98092[(2)] = inst_98056);

(statearr_98075_98092[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98063 === (10))){
var inst_98054 = (state_98062[(2)]);
var state_98062__$1 = state_98062;
var statearr_98076_98093 = state_98062__$1;
(statearr_98076_98093[(2)] = inst_98054);

(statearr_98076_98093[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98063 === (8))){
var inst_98043 = (state_98062[(9)]);
var inst_98032 = (state_98062[(10)]);
var inst_98041 = (state_98062[(7)]);
var inst_98042 = (state_98062[(8)]);
var inst_98046 = (function (){var cs = inst_98032;
var vec__98037 = inst_98041;
var v = inst_98042;
var c = inst_98043;
return ((function (cs,vec__98037,v,c,inst_98043,inst_98032,inst_98041,inst_98042,state_val_98063,c__47173__auto___98084,out){
return (function (p1__98028_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__98028_SHARP_);
});
;})(cs,vec__98037,v,c,inst_98043,inst_98032,inst_98041,inst_98042,state_val_98063,c__47173__auto___98084,out))
})();
var inst_98047 = cljs.core.filterv.call(null,inst_98046,inst_98032);
var inst_98032__$1 = inst_98047;
var state_98062__$1 = (function (){var statearr_98077 = state_98062;
(statearr_98077[(10)] = inst_98032__$1);

return statearr_98077;
})();
var statearr_98078_98094 = state_98062__$1;
(statearr_98078_98094[(2)] = null);

(statearr_98078_98094[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__47173__auto___98084,out))
;
return ((function (switch__47085__auto__,c__47173__auto___98084,out){
return (function() {
var cljs$core$async$state_machine__47086__auto__ = null;
var cljs$core$async$state_machine__47086__auto____0 = (function (){
var statearr_98079 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_98079[(0)] = cljs$core$async$state_machine__47086__auto__);

(statearr_98079[(1)] = (1));

return statearr_98079;
});
var cljs$core$async$state_machine__47086__auto____1 = (function (state_98062){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_98062);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e98080){if((e98080 instanceof Object)){
var ex__47089__auto__ = e98080;
var statearr_98081_98095 = state_98062;
(statearr_98081_98095[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_98062);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e98080;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__98096 = state_98062;
state_98062 = G__98096;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
cljs$core$async$state_machine__47086__auto__ = function(state_98062){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__47086__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__47086__auto____1.call(this,state_98062);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__47086__auto____0;
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__47086__auto____1;
return cljs$core$async$state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto___98084,out))
})();
var state__47175__auto__ = (function (){var statearr_98082 = f__47174__auto__.call(null);
(statearr_98082[(6)] = c__47173__auto___98084);

return statearr_98082;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto___98084,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__98098 = arguments.length;
switch (G__98098) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__47173__auto___98143 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto___98143,out){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto___98143,out){
return (function (state_98122){
var state_val_98123 = (state_98122[(1)]);
if((state_val_98123 === (7))){
var inst_98104 = (state_98122[(7)]);
var inst_98104__$1 = (state_98122[(2)]);
var inst_98105 = (inst_98104__$1 == null);
var inst_98106 = cljs.core.not.call(null,inst_98105);
var state_98122__$1 = (function (){var statearr_98124 = state_98122;
(statearr_98124[(7)] = inst_98104__$1);

return statearr_98124;
})();
if(inst_98106){
var statearr_98125_98144 = state_98122__$1;
(statearr_98125_98144[(1)] = (8));

} else {
var statearr_98126_98145 = state_98122__$1;
(statearr_98126_98145[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98123 === (1))){
var inst_98099 = (0);
var state_98122__$1 = (function (){var statearr_98127 = state_98122;
(statearr_98127[(8)] = inst_98099);

return statearr_98127;
})();
var statearr_98128_98146 = state_98122__$1;
(statearr_98128_98146[(2)] = null);

(statearr_98128_98146[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98123 === (4))){
var state_98122__$1 = state_98122;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_98122__$1,(7),ch);
} else {
if((state_val_98123 === (6))){
var inst_98117 = (state_98122[(2)]);
var state_98122__$1 = state_98122;
var statearr_98129_98147 = state_98122__$1;
(statearr_98129_98147[(2)] = inst_98117);

(statearr_98129_98147[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98123 === (3))){
var inst_98119 = (state_98122[(2)]);
var inst_98120 = cljs.core.async.close_BANG_.call(null,out);
var state_98122__$1 = (function (){var statearr_98130 = state_98122;
(statearr_98130[(9)] = inst_98119);

return statearr_98130;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_98122__$1,inst_98120);
} else {
if((state_val_98123 === (2))){
var inst_98099 = (state_98122[(8)]);
var inst_98101 = (inst_98099 < n);
var state_98122__$1 = state_98122;
if(cljs.core.truth_(inst_98101)){
var statearr_98131_98148 = state_98122__$1;
(statearr_98131_98148[(1)] = (4));

} else {
var statearr_98132_98149 = state_98122__$1;
(statearr_98132_98149[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98123 === (11))){
var inst_98099 = (state_98122[(8)]);
var inst_98109 = (state_98122[(2)]);
var inst_98110 = (inst_98099 + (1));
var inst_98099__$1 = inst_98110;
var state_98122__$1 = (function (){var statearr_98133 = state_98122;
(statearr_98133[(8)] = inst_98099__$1);

(statearr_98133[(10)] = inst_98109);

return statearr_98133;
})();
var statearr_98134_98150 = state_98122__$1;
(statearr_98134_98150[(2)] = null);

(statearr_98134_98150[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98123 === (9))){
var state_98122__$1 = state_98122;
var statearr_98135_98151 = state_98122__$1;
(statearr_98135_98151[(2)] = null);

(statearr_98135_98151[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98123 === (5))){
var state_98122__$1 = state_98122;
var statearr_98136_98152 = state_98122__$1;
(statearr_98136_98152[(2)] = null);

(statearr_98136_98152[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98123 === (10))){
var inst_98114 = (state_98122[(2)]);
var state_98122__$1 = state_98122;
var statearr_98137_98153 = state_98122__$1;
(statearr_98137_98153[(2)] = inst_98114);

(statearr_98137_98153[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98123 === (8))){
var inst_98104 = (state_98122[(7)]);
var state_98122__$1 = state_98122;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_98122__$1,(11),out,inst_98104);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__47173__auto___98143,out))
;
return ((function (switch__47085__auto__,c__47173__auto___98143,out){
return (function() {
var cljs$core$async$state_machine__47086__auto__ = null;
var cljs$core$async$state_machine__47086__auto____0 = (function (){
var statearr_98138 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_98138[(0)] = cljs$core$async$state_machine__47086__auto__);

(statearr_98138[(1)] = (1));

return statearr_98138;
});
var cljs$core$async$state_machine__47086__auto____1 = (function (state_98122){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_98122);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e98139){if((e98139 instanceof Object)){
var ex__47089__auto__ = e98139;
var statearr_98140_98154 = state_98122;
(statearr_98140_98154[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_98122);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e98139;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__98155 = state_98122;
state_98122 = G__98155;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
cljs$core$async$state_machine__47086__auto__ = function(state_98122){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__47086__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__47086__auto____1.call(this,state_98122);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__47086__auto____0;
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__47086__auto____1;
return cljs$core$async$state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto___98143,out))
})();
var state__47175__auto__ = (function (){var statearr_98141 = f__47174__auto__.call(null);
(statearr_98141[(6)] = c__47173__auto___98143);

return statearr_98141;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto___98143,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async98157 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async98157 = (function (f,ch,meta98158){
this.f = f;
this.ch = ch;
this.meta98158 = meta98158;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

cljs.core.async.t_cljs$core$async98157.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_98159,meta98158__$1){
var self__ = this;
var _98159__$1 = this;
return (new cljs.core.async.t_cljs$core$async98157(self__.f,self__.ch,meta98158__$1));
});


cljs.core.async.t_cljs$core$async98157.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_98159){
var self__ = this;
var _98159__$1 = this;
return self__.meta98158;
});


cljs.core.async.t_cljs$core$async98157.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async98157.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});


cljs.core.async.t_cljs$core$async98157.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});


cljs.core.async.t_cljs$core$async98157.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async98157.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async98160 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async98160 = (function (f,ch,meta98158,_,fn1,meta98161){
this.f = f;
this.ch = ch;
this.meta98158 = meta98158;
this._ = _;
this.fn1 = fn1;
this.meta98161 = meta98161;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

cljs.core.async.t_cljs$core$async98160.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_98162,meta98161__$1){
var self__ = this;
var _98162__$1 = this;
return (new cljs.core.async.t_cljs$core$async98160(self__.f,self__.ch,self__.meta98158,self__._,self__.fn1,meta98161__$1));
});})(___$1))
;


cljs.core.async.t_cljs$core$async98160.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_98162){
var self__ = this;
var _98162__$1 = this;
return self__.meta98161;
});})(___$1))
;


cljs.core.async.t_cljs$core$async98160.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async98160.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;


cljs.core.async.t_cljs$core$async98160.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;


cljs.core.async.t_cljs$core$async98160.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__98156_SHARP_){
return f1.call(null,(((p1__98156_SHARP_ == null))?null:self__.f.call(null,p1__98156_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async98160.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta98158","meta98158",1127986314,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async98157","cljs.core.async/t_cljs$core$async98157",-1678571012,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta98161","meta98161",-1204192323,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async98160.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async98160.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async98160";

cljs.core.async.t_cljs$core$async98160.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"cljs.core.async/t_cljs$core$async98160");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async98160 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async98160(f__$1,ch__$1,meta98158__$1,___$2,fn1__$1,meta98161){
return (new cljs.core.async.t_cljs$core$async98160(f__$1,ch__$1,meta98158__$1,___$2,fn1__$1,meta98161));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async98160(self__.f,self__.ch,self__.meta98158,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__28129__auto__ = ret;
if(cljs.core.truth_(and__28129__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__28129__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});


cljs.core.async.t_cljs$core$async98157.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async98157.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async98157.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta98158","meta98158",1127986314,null)], null);
});

cljs.core.async.t_cljs$core$async98157.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async98157.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async98157";

cljs.core.async.t_cljs$core$async98157.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"cljs.core.async/t_cljs$core$async98157");
});

cljs.core.async.__GT_t_cljs$core$async98157 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async98157(f__$1,ch__$1,meta98158){
return (new cljs.core.async.t_cljs$core$async98157(f__$1,ch__$1,meta98158));
});

}

return (new cljs.core.async.t_cljs$core$async98157(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async98163 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async98163 = (function (f,ch,meta98164){
this.f = f;
this.ch = ch;
this.meta98164 = meta98164;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

cljs.core.async.t_cljs$core$async98163.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_98165,meta98164__$1){
var self__ = this;
var _98165__$1 = this;
return (new cljs.core.async.t_cljs$core$async98163(self__.f,self__.ch,meta98164__$1));
});


cljs.core.async.t_cljs$core$async98163.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_98165){
var self__ = this;
var _98165__$1 = this;
return self__.meta98164;
});


cljs.core.async.t_cljs$core$async98163.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async98163.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});


cljs.core.async.t_cljs$core$async98163.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async98163.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});


cljs.core.async.t_cljs$core$async98163.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async98163.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async98163.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta98164","meta98164",350159238,null)], null);
});

cljs.core.async.t_cljs$core$async98163.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async98163.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async98163";

cljs.core.async.t_cljs$core$async98163.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"cljs.core.async/t_cljs$core$async98163");
});

cljs.core.async.__GT_t_cljs$core$async98163 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async98163(f__$1,ch__$1,meta98164){
return (new cljs.core.async.t_cljs$core$async98163(f__$1,ch__$1,meta98164));
});

}

return (new cljs.core.async.t_cljs$core$async98163(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async98166 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async98166 = (function (p,ch,meta98167){
this.p = p;
this.ch = ch;
this.meta98167 = meta98167;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

cljs.core.async.t_cljs$core$async98166.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_98168,meta98167__$1){
var self__ = this;
var _98168__$1 = this;
return (new cljs.core.async.t_cljs$core$async98166(self__.p,self__.ch,meta98167__$1));
});


cljs.core.async.t_cljs$core$async98166.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_98168){
var self__ = this;
var _98168__$1 = this;
return self__.meta98167;
});


cljs.core.async.t_cljs$core$async98166.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async98166.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});


cljs.core.async.t_cljs$core$async98166.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});


cljs.core.async.t_cljs$core$async98166.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async98166.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});


cljs.core.async.t_cljs$core$async98166.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async98166.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async98166.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta98167","meta98167",-1308134054,null)], null);
});

cljs.core.async.t_cljs$core$async98166.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async98166.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async98166";

cljs.core.async.t_cljs$core$async98166.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"cljs.core.async/t_cljs$core$async98166");
});

cljs.core.async.__GT_t_cljs$core$async98166 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async98166(p__$1,ch__$1,meta98167){
return (new cljs.core.async.t_cljs$core$async98166(p__$1,ch__$1,meta98167));
});

}

return (new cljs.core.async.t_cljs$core$async98166(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__98170 = arguments.length;
switch (G__98170) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__47173__auto___98210 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto___98210,out){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto___98210,out){
return (function (state_98191){
var state_val_98192 = (state_98191[(1)]);
if((state_val_98192 === (7))){
var inst_98187 = (state_98191[(2)]);
var state_98191__$1 = state_98191;
var statearr_98193_98211 = state_98191__$1;
(statearr_98193_98211[(2)] = inst_98187);

(statearr_98193_98211[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98192 === (1))){
var state_98191__$1 = state_98191;
var statearr_98194_98212 = state_98191__$1;
(statearr_98194_98212[(2)] = null);

(statearr_98194_98212[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98192 === (4))){
var inst_98173 = (state_98191[(7)]);
var inst_98173__$1 = (state_98191[(2)]);
var inst_98174 = (inst_98173__$1 == null);
var state_98191__$1 = (function (){var statearr_98195 = state_98191;
(statearr_98195[(7)] = inst_98173__$1);

return statearr_98195;
})();
if(cljs.core.truth_(inst_98174)){
var statearr_98196_98213 = state_98191__$1;
(statearr_98196_98213[(1)] = (5));

} else {
var statearr_98197_98214 = state_98191__$1;
(statearr_98197_98214[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98192 === (6))){
var inst_98173 = (state_98191[(7)]);
var inst_98178 = p.call(null,inst_98173);
var state_98191__$1 = state_98191;
if(cljs.core.truth_(inst_98178)){
var statearr_98198_98215 = state_98191__$1;
(statearr_98198_98215[(1)] = (8));

} else {
var statearr_98199_98216 = state_98191__$1;
(statearr_98199_98216[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98192 === (3))){
var inst_98189 = (state_98191[(2)]);
var state_98191__$1 = state_98191;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_98191__$1,inst_98189);
} else {
if((state_val_98192 === (2))){
var state_98191__$1 = state_98191;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_98191__$1,(4),ch);
} else {
if((state_val_98192 === (11))){
var inst_98181 = (state_98191[(2)]);
var state_98191__$1 = state_98191;
var statearr_98200_98217 = state_98191__$1;
(statearr_98200_98217[(2)] = inst_98181);

(statearr_98200_98217[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98192 === (9))){
var state_98191__$1 = state_98191;
var statearr_98201_98218 = state_98191__$1;
(statearr_98201_98218[(2)] = null);

(statearr_98201_98218[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98192 === (5))){
var inst_98176 = cljs.core.async.close_BANG_.call(null,out);
var state_98191__$1 = state_98191;
var statearr_98202_98219 = state_98191__$1;
(statearr_98202_98219[(2)] = inst_98176);

(statearr_98202_98219[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98192 === (10))){
var inst_98184 = (state_98191[(2)]);
var state_98191__$1 = (function (){var statearr_98203 = state_98191;
(statearr_98203[(8)] = inst_98184);

return statearr_98203;
})();
var statearr_98204_98220 = state_98191__$1;
(statearr_98204_98220[(2)] = null);

(statearr_98204_98220[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98192 === (8))){
var inst_98173 = (state_98191[(7)]);
var state_98191__$1 = state_98191;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_98191__$1,(11),out,inst_98173);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__47173__auto___98210,out))
;
return ((function (switch__47085__auto__,c__47173__auto___98210,out){
return (function() {
var cljs$core$async$state_machine__47086__auto__ = null;
var cljs$core$async$state_machine__47086__auto____0 = (function (){
var statearr_98205 = [null,null,null,null,null,null,null,null,null];
(statearr_98205[(0)] = cljs$core$async$state_machine__47086__auto__);

(statearr_98205[(1)] = (1));

return statearr_98205;
});
var cljs$core$async$state_machine__47086__auto____1 = (function (state_98191){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_98191);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e98206){if((e98206 instanceof Object)){
var ex__47089__auto__ = e98206;
var statearr_98207_98221 = state_98191;
(statearr_98207_98221[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_98191);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e98206;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__98222 = state_98191;
state_98191 = G__98222;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
cljs$core$async$state_machine__47086__auto__ = function(state_98191){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__47086__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__47086__auto____1.call(this,state_98191);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__47086__auto____0;
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__47086__auto____1;
return cljs$core$async$state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto___98210,out))
})();
var state__47175__auto__ = (function (){var statearr_98208 = f__47174__auto__.call(null);
(statearr_98208[(6)] = c__47173__auto___98210);

return statearr_98208;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto___98210,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__98224 = arguments.length;
switch (G__98224) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__47173__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto__){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto__){
return (function (state_98287){
var state_val_98288 = (state_98287[(1)]);
if((state_val_98288 === (7))){
var inst_98283 = (state_98287[(2)]);
var state_98287__$1 = state_98287;
var statearr_98289_98327 = state_98287__$1;
(statearr_98289_98327[(2)] = inst_98283);

(statearr_98289_98327[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98288 === (20))){
var inst_98253 = (state_98287[(7)]);
var inst_98264 = (state_98287[(2)]);
var inst_98265 = cljs.core.next.call(null,inst_98253);
var inst_98239 = inst_98265;
var inst_98240 = null;
var inst_98241 = (0);
var inst_98242 = (0);
var state_98287__$1 = (function (){var statearr_98290 = state_98287;
(statearr_98290[(8)] = inst_98242);

(statearr_98290[(9)] = inst_98241);

(statearr_98290[(10)] = inst_98264);

(statearr_98290[(11)] = inst_98239);

(statearr_98290[(12)] = inst_98240);

return statearr_98290;
})();
var statearr_98291_98328 = state_98287__$1;
(statearr_98291_98328[(2)] = null);

(statearr_98291_98328[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98288 === (1))){
var state_98287__$1 = state_98287;
var statearr_98292_98329 = state_98287__$1;
(statearr_98292_98329[(2)] = null);

(statearr_98292_98329[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98288 === (4))){
var inst_98228 = (state_98287[(13)]);
var inst_98228__$1 = (state_98287[(2)]);
var inst_98229 = (inst_98228__$1 == null);
var state_98287__$1 = (function (){var statearr_98293 = state_98287;
(statearr_98293[(13)] = inst_98228__$1);

return statearr_98293;
})();
if(cljs.core.truth_(inst_98229)){
var statearr_98294_98330 = state_98287__$1;
(statearr_98294_98330[(1)] = (5));

} else {
var statearr_98295_98331 = state_98287__$1;
(statearr_98295_98331[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98288 === (15))){
var state_98287__$1 = state_98287;
var statearr_98299_98332 = state_98287__$1;
(statearr_98299_98332[(2)] = null);

(statearr_98299_98332[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98288 === (21))){
var state_98287__$1 = state_98287;
var statearr_98300_98333 = state_98287__$1;
(statearr_98300_98333[(2)] = null);

(statearr_98300_98333[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98288 === (13))){
var inst_98242 = (state_98287[(8)]);
var inst_98241 = (state_98287[(9)]);
var inst_98239 = (state_98287[(11)]);
var inst_98240 = (state_98287[(12)]);
var inst_98249 = (state_98287[(2)]);
var inst_98250 = (inst_98242 + (1));
var tmp98296 = inst_98241;
var tmp98297 = inst_98239;
var tmp98298 = inst_98240;
var inst_98239__$1 = tmp98297;
var inst_98240__$1 = tmp98298;
var inst_98241__$1 = tmp98296;
var inst_98242__$1 = inst_98250;
var state_98287__$1 = (function (){var statearr_98301 = state_98287;
(statearr_98301[(8)] = inst_98242__$1);

(statearr_98301[(9)] = inst_98241__$1);

(statearr_98301[(14)] = inst_98249);

(statearr_98301[(11)] = inst_98239__$1);

(statearr_98301[(12)] = inst_98240__$1);

return statearr_98301;
})();
var statearr_98302_98334 = state_98287__$1;
(statearr_98302_98334[(2)] = null);

(statearr_98302_98334[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98288 === (22))){
var state_98287__$1 = state_98287;
var statearr_98303_98335 = state_98287__$1;
(statearr_98303_98335[(2)] = null);

(statearr_98303_98335[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98288 === (6))){
var inst_98228 = (state_98287[(13)]);
var inst_98237 = f.call(null,inst_98228);
var inst_98238 = cljs.core.seq.call(null,inst_98237);
var inst_98239 = inst_98238;
var inst_98240 = null;
var inst_98241 = (0);
var inst_98242 = (0);
var state_98287__$1 = (function (){var statearr_98304 = state_98287;
(statearr_98304[(8)] = inst_98242);

(statearr_98304[(9)] = inst_98241);

(statearr_98304[(11)] = inst_98239);

(statearr_98304[(12)] = inst_98240);

return statearr_98304;
})();
var statearr_98305_98336 = state_98287__$1;
(statearr_98305_98336[(2)] = null);

(statearr_98305_98336[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98288 === (17))){
var inst_98253 = (state_98287[(7)]);
var inst_98257 = cljs.core.chunk_first.call(null,inst_98253);
var inst_98258 = cljs.core.chunk_rest.call(null,inst_98253);
var inst_98259 = cljs.core.count.call(null,inst_98257);
var inst_98239 = inst_98258;
var inst_98240 = inst_98257;
var inst_98241 = inst_98259;
var inst_98242 = (0);
var state_98287__$1 = (function (){var statearr_98306 = state_98287;
(statearr_98306[(8)] = inst_98242);

(statearr_98306[(9)] = inst_98241);

(statearr_98306[(11)] = inst_98239);

(statearr_98306[(12)] = inst_98240);

return statearr_98306;
})();
var statearr_98307_98337 = state_98287__$1;
(statearr_98307_98337[(2)] = null);

(statearr_98307_98337[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98288 === (3))){
var inst_98285 = (state_98287[(2)]);
var state_98287__$1 = state_98287;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_98287__$1,inst_98285);
} else {
if((state_val_98288 === (12))){
var inst_98273 = (state_98287[(2)]);
var state_98287__$1 = state_98287;
var statearr_98308_98338 = state_98287__$1;
(statearr_98308_98338[(2)] = inst_98273);

(statearr_98308_98338[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98288 === (2))){
var state_98287__$1 = state_98287;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_98287__$1,(4),in$);
} else {
if((state_val_98288 === (23))){
var inst_98281 = (state_98287[(2)]);
var state_98287__$1 = state_98287;
var statearr_98309_98339 = state_98287__$1;
(statearr_98309_98339[(2)] = inst_98281);

(statearr_98309_98339[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98288 === (19))){
var inst_98268 = (state_98287[(2)]);
var state_98287__$1 = state_98287;
var statearr_98310_98340 = state_98287__$1;
(statearr_98310_98340[(2)] = inst_98268);

(statearr_98310_98340[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98288 === (11))){
var inst_98253 = (state_98287[(7)]);
var inst_98239 = (state_98287[(11)]);
var inst_98253__$1 = cljs.core.seq.call(null,inst_98239);
var state_98287__$1 = (function (){var statearr_98311 = state_98287;
(statearr_98311[(7)] = inst_98253__$1);

return statearr_98311;
})();
if(inst_98253__$1){
var statearr_98312_98341 = state_98287__$1;
(statearr_98312_98341[(1)] = (14));

} else {
var statearr_98313_98342 = state_98287__$1;
(statearr_98313_98342[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98288 === (9))){
var inst_98275 = (state_98287[(2)]);
var inst_98276 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_98287__$1 = (function (){var statearr_98314 = state_98287;
(statearr_98314[(15)] = inst_98275);

return statearr_98314;
})();
if(cljs.core.truth_(inst_98276)){
var statearr_98315_98343 = state_98287__$1;
(statearr_98315_98343[(1)] = (21));

} else {
var statearr_98316_98344 = state_98287__$1;
(statearr_98316_98344[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98288 === (5))){
var inst_98231 = cljs.core.async.close_BANG_.call(null,out);
var state_98287__$1 = state_98287;
var statearr_98317_98345 = state_98287__$1;
(statearr_98317_98345[(2)] = inst_98231);

(statearr_98317_98345[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98288 === (14))){
var inst_98253 = (state_98287[(7)]);
var inst_98255 = cljs.core.chunked_seq_QMARK_.call(null,inst_98253);
var state_98287__$1 = state_98287;
if(inst_98255){
var statearr_98318_98346 = state_98287__$1;
(statearr_98318_98346[(1)] = (17));

} else {
var statearr_98319_98347 = state_98287__$1;
(statearr_98319_98347[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98288 === (16))){
var inst_98271 = (state_98287[(2)]);
var state_98287__$1 = state_98287;
var statearr_98320_98348 = state_98287__$1;
(statearr_98320_98348[(2)] = inst_98271);

(statearr_98320_98348[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98288 === (10))){
var inst_98242 = (state_98287[(8)]);
var inst_98240 = (state_98287[(12)]);
var inst_98247 = cljs.core._nth.call(null,inst_98240,inst_98242);
var state_98287__$1 = state_98287;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_98287__$1,(13),out,inst_98247);
} else {
if((state_val_98288 === (18))){
var inst_98253 = (state_98287[(7)]);
var inst_98262 = cljs.core.first.call(null,inst_98253);
var state_98287__$1 = state_98287;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_98287__$1,(20),out,inst_98262);
} else {
if((state_val_98288 === (8))){
var inst_98242 = (state_98287[(8)]);
var inst_98241 = (state_98287[(9)]);
var inst_98244 = (inst_98242 < inst_98241);
var inst_98245 = inst_98244;
var state_98287__$1 = state_98287;
if(cljs.core.truth_(inst_98245)){
var statearr_98321_98349 = state_98287__$1;
(statearr_98321_98349[(1)] = (10));

} else {
var statearr_98322_98350 = state_98287__$1;
(statearr_98322_98350[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__47173__auto__))
;
return ((function (switch__47085__auto__,c__47173__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__47086__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__47086__auto____0 = (function (){
var statearr_98323 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_98323[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__47086__auto__);

(statearr_98323[(1)] = (1));

return statearr_98323;
});
var cljs$core$async$mapcat_STAR__$_state_machine__47086__auto____1 = (function (state_98287){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_98287);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e98324){if((e98324 instanceof Object)){
var ex__47089__auto__ = e98324;
var statearr_98325_98351 = state_98287;
(statearr_98325_98351[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_98287);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e98324;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__98352 = state_98287;
state_98287 = G__98352;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__47086__auto__ = function(state_98287){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__47086__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__47086__auto____1.call(this,state_98287);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mapcat_STAR__$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__47086__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__47086__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto__))
})();
var state__47175__auto__ = (function (){var statearr_98326 = f__47174__auto__.call(null);
(statearr_98326[(6)] = c__47173__auto__);

return statearr_98326;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto__))
);

return c__47173__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__98354 = arguments.length;
switch (G__98354) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__98357 = arguments.length;
switch (G__98357) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__98360 = arguments.length;
switch (G__98360) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__47173__auto___98407 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto___98407,out){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto___98407,out){
return (function (state_98384){
var state_val_98385 = (state_98384[(1)]);
if((state_val_98385 === (7))){
var inst_98379 = (state_98384[(2)]);
var state_98384__$1 = state_98384;
var statearr_98386_98408 = state_98384__$1;
(statearr_98386_98408[(2)] = inst_98379);

(statearr_98386_98408[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98385 === (1))){
var inst_98361 = null;
var state_98384__$1 = (function (){var statearr_98387 = state_98384;
(statearr_98387[(7)] = inst_98361);

return statearr_98387;
})();
var statearr_98388_98409 = state_98384__$1;
(statearr_98388_98409[(2)] = null);

(statearr_98388_98409[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98385 === (4))){
var inst_98364 = (state_98384[(8)]);
var inst_98364__$1 = (state_98384[(2)]);
var inst_98365 = (inst_98364__$1 == null);
var inst_98366 = cljs.core.not.call(null,inst_98365);
var state_98384__$1 = (function (){var statearr_98389 = state_98384;
(statearr_98389[(8)] = inst_98364__$1);

return statearr_98389;
})();
if(inst_98366){
var statearr_98390_98410 = state_98384__$1;
(statearr_98390_98410[(1)] = (5));

} else {
var statearr_98391_98411 = state_98384__$1;
(statearr_98391_98411[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98385 === (6))){
var state_98384__$1 = state_98384;
var statearr_98392_98412 = state_98384__$1;
(statearr_98392_98412[(2)] = null);

(statearr_98392_98412[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98385 === (3))){
var inst_98381 = (state_98384[(2)]);
var inst_98382 = cljs.core.async.close_BANG_.call(null,out);
var state_98384__$1 = (function (){var statearr_98393 = state_98384;
(statearr_98393[(9)] = inst_98381);

return statearr_98393;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_98384__$1,inst_98382);
} else {
if((state_val_98385 === (2))){
var state_98384__$1 = state_98384;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_98384__$1,(4),ch);
} else {
if((state_val_98385 === (11))){
var inst_98364 = (state_98384[(8)]);
var inst_98373 = (state_98384[(2)]);
var inst_98361 = inst_98364;
var state_98384__$1 = (function (){var statearr_98394 = state_98384;
(statearr_98394[(7)] = inst_98361);

(statearr_98394[(10)] = inst_98373);

return statearr_98394;
})();
var statearr_98395_98413 = state_98384__$1;
(statearr_98395_98413[(2)] = null);

(statearr_98395_98413[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98385 === (9))){
var inst_98364 = (state_98384[(8)]);
var state_98384__$1 = state_98384;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_98384__$1,(11),out,inst_98364);
} else {
if((state_val_98385 === (5))){
var inst_98361 = (state_98384[(7)]);
var inst_98364 = (state_98384[(8)]);
var inst_98368 = cljs.core._EQ_.call(null,inst_98364,inst_98361);
var state_98384__$1 = state_98384;
if(inst_98368){
var statearr_98397_98414 = state_98384__$1;
(statearr_98397_98414[(1)] = (8));

} else {
var statearr_98398_98415 = state_98384__$1;
(statearr_98398_98415[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98385 === (10))){
var inst_98376 = (state_98384[(2)]);
var state_98384__$1 = state_98384;
var statearr_98399_98416 = state_98384__$1;
(statearr_98399_98416[(2)] = inst_98376);

(statearr_98399_98416[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98385 === (8))){
var inst_98361 = (state_98384[(7)]);
var tmp98396 = inst_98361;
var inst_98361__$1 = tmp98396;
var state_98384__$1 = (function (){var statearr_98400 = state_98384;
(statearr_98400[(7)] = inst_98361__$1);

return statearr_98400;
})();
var statearr_98401_98417 = state_98384__$1;
(statearr_98401_98417[(2)] = null);

(statearr_98401_98417[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__47173__auto___98407,out))
;
return ((function (switch__47085__auto__,c__47173__auto___98407,out){
return (function() {
var cljs$core$async$state_machine__47086__auto__ = null;
var cljs$core$async$state_machine__47086__auto____0 = (function (){
var statearr_98402 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_98402[(0)] = cljs$core$async$state_machine__47086__auto__);

(statearr_98402[(1)] = (1));

return statearr_98402;
});
var cljs$core$async$state_machine__47086__auto____1 = (function (state_98384){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_98384);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e98403){if((e98403 instanceof Object)){
var ex__47089__auto__ = e98403;
var statearr_98404_98418 = state_98384;
(statearr_98404_98418[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_98384);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e98403;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__98419 = state_98384;
state_98384 = G__98419;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
cljs$core$async$state_machine__47086__auto__ = function(state_98384){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__47086__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__47086__auto____1.call(this,state_98384);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__47086__auto____0;
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__47086__auto____1;
return cljs$core$async$state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto___98407,out))
})();
var state__47175__auto__ = (function (){var statearr_98405 = f__47174__auto__.call(null);
(statearr_98405[(6)] = c__47173__auto___98407);

return statearr_98405;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto___98407,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__98421 = arguments.length;
switch (G__98421) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__47173__auto___98487 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto___98487,out){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto___98487,out){
return (function (state_98459){
var state_val_98460 = (state_98459[(1)]);
if((state_val_98460 === (7))){
var inst_98455 = (state_98459[(2)]);
var state_98459__$1 = state_98459;
var statearr_98461_98488 = state_98459__$1;
(statearr_98461_98488[(2)] = inst_98455);

(statearr_98461_98488[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98460 === (1))){
var inst_98422 = (new Array(n));
var inst_98423 = inst_98422;
var inst_98424 = (0);
var state_98459__$1 = (function (){var statearr_98462 = state_98459;
(statearr_98462[(7)] = inst_98424);

(statearr_98462[(8)] = inst_98423);

return statearr_98462;
})();
var statearr_98463_98489 = state_98459__$1;
(statearr_98463_98489[(2)] = null);

(statearr_98463_98489[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98460 === (4))){
var inst_98427 = (state_98459[(9)]);
var inst_98427__$1 = (state_98459[(2)]);
var inst_98428 = (inst_98427__$1 == null);
var inst_98429 = cljs.core.not.call(null,inst_98428);
var state_98459__$1 = (function (){var statearr_98464 = state_98459;
(statearr_98464[(9)] = inst_98427__$1);

return statearr_98464;
})();
if(inst_98429){
var statearr_98465_98490 = state_98459__$1;
(statearr_98465_98490[(1)] = (5));

} else {
var statearr_98466_98491 = state_98459__$1;
(statearr_98466_98491[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98460 === (15))){
var inst_98449 = (state_98459[(2)]);
var state_98459__$1 = state_98459;
var statearr_98467_98492 = state_98459__$1;
(statearr_98467_98492[(2)] = inst_98449);

(statearr_98467_98492[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98460 === (13))){
var state_98459__$1 = state_98459;
var statearr_98468_98493 = state_98459__$1;
(statearr_98468_98493[(2)] = null);

(statearr_98468_98493[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98460 === (6))){
var inst_98424 = (state_98459[(7)]);
var inst_98445 = (inst_98424 > (0));
var state_98459__$1 = state_98459;
if(cljs.core.truth_(inst_98445)){
var statearr_98469_98494 = state_98459__$1;
(statearr_98469_98494[(1)] = (12));

} else {
var statearr_98470_98495 = state_98459__$1;
(statearr_98470_98495[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98460 === (3))){
var inst_98457 = (state_98459[(2)]);
var state_98459__$1 = state_98459;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_98459__$1,inst_98457);
} else {
if((state_val_98460 === (12))){
var inst_98423 = (state_98459[(8)]);
var inst_98447 = cljs.core.vec.call(null,inst_98423);
var state_98459__$1 = state_98459;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_98459__$1,(15),out,inst_98447);
} else {
if((state_val_98460 === (2))){
var state_98459__$1 = state_98459;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_98459__$1,(4),ch);
} else {
if((state_val_98460 === (11))){
var inst_98439 = (state_98459[(2)]);
var inst_98440 = (new Array(n));
var inst_98423 = inst_98440;
var inst_98424 = (0);
var state_98459__$1 = (function (){var statearr_98471 = state_98459;
(statearr_98471[(7)] = inst_98424);

(statearr_98471[(8)] = inst_98423);

(statearr_98471[(10)] = inst_98439);

return statearr_98471;
})();
var statearr_98472_98496 = state_98459__$1;
(statearr_98472_98496[(2)] = null);

(statearr_98472_98496[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98460 === (9))){
var inst_98423 = (state_98459[(8)]);
var inst_98437 = cljs.core.vec.call(null,inst_98423);
var state_98459__$1 = state_98459;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_98459__$1,(11),out,inst_98437);
} else {
if((state_val_98460 === (5))){
var inst_98424 = (state_98459[(7)]);
var inst_98423 = (state_98459[(8)]);
var inst_98427 = (state_98459[(9)]);
var inst_98432 = (state_98459[(11)]);
var inst_98431 = (inst_98423[inst_98424] = inst_98427);
var inst_98432__$1 = (inst_98424 + (1));
var inst_98433 = (inst_98432__$1 < n);
var state_98459__$1 = (function (){var statearr_98473 = state_98459;
(statearr_98473[(12)] = inst_98431);

(statearr_98473[(11)] = inst_98432__$1);

return statearr_98473;
})();
if(cljs.core.truth_(inst_98433)){
var statearr_98474_98497 = state_98459__$1;
(statearr_98474_98497[(1)] = (8));

} else {
var statearr_98475_98498 = state_98459__$1;
(statearr_98475_98498[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98460 === (14))){
var inst_98452 = (state_98459[(2)]);
var inst_98453 = cljs.core.async.close_BANG_.call(null,out);
var state_98459__$1 = (function (){var statearr_98477 = state_98459;
(statearr_98477[(13)] = inst_98452);

return statearr_98477;
})();
var statearr_98478_98499 = state_98459__$1;
(statearr_98478_98499[(2)] = inst_98453);

(statearr_98478_98499[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98460 === (10))){
var inst_98443 = (state_98459[(2)]);
var state_98459__$1 = state_98459;
var statearr_98479_98500 = state_98459__$1;
(statearr_98479_98500[(2)] = inst_98443);

(statearr_98479_98500[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98460 === (8))){
var inst_98423 = (state_98459[(8)]);
var inst_98432 = (state_98459[(11)]);
var tmp98476 = inst_98423;
var inst_98423__$1 = tmp98476;
var inst_98424 = inst_98432;
var state_98459__$1 = (function (){var statearr_98480 = state_98459;
(statearr_98480[(7)] = inst_98424);

(statearr_98480[(8)] = inst_98423__$1);

return statearr_98480;
})();
var statearr_98481_98501 = state_98459__$1;
(statearr_98481_98501[(2)] = null);

(statearr_98481_98501[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__47173__auto___98487,out))
;
return ((function (switch__47085__auto__,c__47173__auto___98487,out){
return (function() {
var cljs$core$async$state_machine__47086__auto__ = null;
var cljs$core$async$state_machine__47086__auto____0 = (function (){
var statearr_98482 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_98482[(0)] = cljs$core$async$state_machine__47086__auto__);

(statearr_98482[(1)] = (1));

return statearr_98482;
});
var cljs$core$async$state_machine__47086__auto____1 = (function (state_98459){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_98459);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e98483){if((e98483 instanceof Object)){
var ex__47089__auto__ = e98483;
var statearr_98484_98502 = state_98459;
(statearr_98484_98502[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_98459);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e98483;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__98503 = state_98459;
state_98459 = G__98503;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
cljs$core$async$state_machine__47086__auto__ = function(state_98459){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__47086__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__47086__auto____1.call(this,state_98459);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__47086__auto____0;
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__47086__auto____1;
return cljs$core$async$state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto___98487,out))
})();
var state__47175__auto__ = (function (){var statearr_98485 = f__47174__auto__.call(null);
(statearr_98485[(6)] = c__47173__auto___98487);

return statearr_98485;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto___98487,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__98505 = arguments.length;
switch (G__98505) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__47173__auto___98575 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__47173__auto___98575,out){
return (function (){
var f__47174__auto__ = (function (){var switch__47085__auto__ = ((function (c__47173__auto___98575,out){
return (function (state_98547){
var state_val_98548 = (state_98547[(1)]);
if((state_val_98548 === (7))){
var inst_98543 = (state_98547[(2)]);
var state_98547__$1 = state_98547;
var statearr_98549_98576 = state_98547__$1;
(statearr_98549_98576[(2)] = inst_98543);

(statearr_98549_98576[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98548 === (1))){
var inst_98506 = [];
var inst_98507 = inst_98506;
var inst_98508 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_98547__$1 = (function (){var statearr_98550 = state_98547;
(statearr_98550[(7)] = inst_98507);

(statearr_98550[(8)] = inst_98508);

return statearr_98550;
})();
var statearr_98551_98577 = state_98547__$1;
(statearr_98551_98577[(2)] = null);

(statearr_98551_98577[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98548 === (4))){
var inst_98511 = (state_98547[(9)]);
var inst_98511__$1 = (state_98547[(2)]);
var inst_98512 = (inst_98511__$1 == null);
var inst_98513 = cljs.core.not.call(null,inst_98512);
var state_98547__$1 = (function (){var statearr_98552 = state_98547;
(statearr_98552[(9)] = inst_98511__$1);

return statearr_98552;
})();
if(inst_98513){
var statearr_98553_98578 = state_98547__$1;
(statearr_98553_98578[(1)] = (5));

} else {
var statearr_98554_98579 = state_98547__$1;
(statearr_98554_98579[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98548 === (15))){
var inst_98537 = (state_98547[(2)]);
var state_98547__$1 = state_98547;
var statearr_98555_98580 = state_98547__$1;
(statearr_98555_98580[(2)] = inst_98537);

(statearr_98555_98580[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98548 === (13))){
var state_98547__$1 = state_98547;
var statearr_98556_98581 = state_98547__$1;
(statearr_98556_98581[(2)] = null);

(statearr_98556_98581[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98548 === (6))){
var inst_98507 = (state_98547[(7)]);
var inst_98532 = inst_98507.length;
var inst_98533 = (inst_98532 > (0));
var state_98547__$1 = state_98547;
if(cljs.core.truth_(inst_98533)){
var statearr_98557_98582 = state_98547__$1;
(statearr_98557_98582[(1)] = (12));

} else {
var statearr_98558_98583 = state_98547__$1;
(statearr_98558_98583[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98548 === (3))){
var inst_98545 = (state_98547[(2)]);
var state_98547__$1 = state_98547;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_98547__$1,inst_98545);
} else {
if((state_val_98548 === (12))){
var inst_98507 = (state_98547[(7)]);
var inst_98535 = cljs.core.vec.call(null,inst_98507);
var state_98547__$1 = state_98547;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_98547__$1,(15),out,inst_98535);
} else {
if((state_val_98548 === (2))){
var state_98547__$1 = state_98547;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_98547__$1,(4),ch);
} else {
if((state_val_98548 === (11))){
var inst_98515 = (state_98547[(10)]);
var inst_98511 = (state_98547[(9)]);
var inst_98525 = (state_98547[(2)]);
var inst_98526 = [];
var inst_98527 = inst_98526.push(inst_98511);
var inst_98507 = inst_98526;
var inst_98508 = inst_98515;
var state_98547__$1 = (function (){var statearr_98559 = state_98547;
(statearr_98559[(7)] = inst_98507);

(statearr_98559[(11)] = inst_98527);

(statearr_98559[(12)] = inst_98525);

(statearr_98559[(8)] = inst_98508);

return statearr_98559;
})();
var statearr_98560_98584 = state_98547__$1;
(statearr_98560_98584[(2)] = null);

(statearr_98560_98584[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98548 === (9))){
var inst_98507 = (state_98547[(7)]);
var inst_98523 = cljs.core.vec.call(null,inst_98507);
var state_98547__$1 = state_98547;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_98547__$1,(11),out,inst_98523);
} else {
if((state_val_98548 === (5))){
var inst_98515 = (state_98547[(10)]);
var inst_98511 = (state_98547[(9)]);
var inst_98508 = (state_98547[(8)]);
var inst_98515__$1 = f.call(null,inst_98511);
var inst_98516 = cljs.core._EQ_.call(null,inst_98515__$1,inst_98508);
var inst_98517 = cljs.core.keyword_identical_QMARK_.call(null,inst_98508,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_98518 = (inst_98516) || (inst_98517);
var state_98547__$1 = (function (){var statearr_98561 = state_98547;
(statearr_98561[(10)] = inst_98515__$1);

return statearr_98561;
})();
if(cljs.core.truth_(inst_98518)){
var statearr_98562_98585 = state_98547__$1;
(statearr_98562_98585[(1)] = (8));

} else {
var statearr_98563_98586 = state_98547__$1;
(statearr_98563_98586[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98548 === (14))){
var inst_98540 = (state_98547[(2)]);
var inst_98541 = cljs.core.async.close_BANG_.call(null,out);
var state_98547__$1 = (function (){var statearr_98565 = state_98547;
(statearr_98565[(13)] = inst_98540);

return statearr_98565;
})();
var statearr_98566_98587 = state_98547__$1;
(statearr_98566_98587[(2)] = inst_98541);

(statearr_98566_98587[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98548 === (10))){
var inst_98530 = (state_98547[(2)]);
var state_98547__$1 = state_98547;
var statearr_98567_98588 = state_98547__$1;
(statearr_98567_98588[(2)] = inst_98530);

(statearr_98567_98588[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_98548 === (8))){
var inst_98507 = (state_98547[(7)]);
var inst_98515 = (state_98547[(10)]);
var inst_98511 = (state_98547[(9)]);
var inst_98520 = inst_98507.push(inst_98511);
var tmp98564 = inst_98507;
var inst_98507__$1 = tmp98564;
var inst_98508 = inst_98515;
var state_98547__$1 = (function (){var statearr_98568 = state_98547;
(statearr_98568[(7)] = inst_98507__$1);

(statearr_98568[(8)] = inst_98508);

(statearr_98568[(14)] = inst_98520);

return statearr_98568;
})();
var statearr_98569_98589 = state_98547__$1;
(statearr_98569_98589[(2)] = null);

(statearr_98569_98589[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__47173__auto___98575,out))
;
return ((function (switch__47085__auto__,c__47173__auto___98575,out){
return (function() {
var cljs$core$async$state_machine__47086__auto__ = null;
var cljs$core$async$state_machine__47086__auto____0 = (function (){
var statearr_98570 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_98570[(0)] = cljs$core$async$state_machine__47086__auto__);

(statearr_98570[(1)] = (1));

return statearr_98570;
});
var cljs$core$async$state_machine__47086__auto____1 = (function (state_98547){
while(true){
var ret_value__47087__auto__ = (function (){try{while(true){
var result__47088__auto__ = switch__47085__auto__.call(null,state_98547);
if(cljs.core.keyword_identical_QMARK_.call(null,result__47088__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__47088__auto__;
}
break;
}
}catch (e98571){if((e98571 instanceof Object)){
var ex__47089__auto__ = e98571;
var statearr_98572_98590 = state_98547;
(statearr_98572_98590[(5)] = ex__47089__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_98547);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e98571;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__47087__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__98591 = state_98547;
state_98547 = G__98591;
continue;
} else {
return ret_value__47087__auto__;
}
break;
}
});
cljs$core$async$state_machine__47086__auto__ = function(state_98547){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__47086__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__47086__auto____1.call(this,state_98547);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__47086__auto____0;
cljs$core$async$state_machine__47086__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__47086__auto____1;
return cljs$core$async$state_machine__47086__auto__;
})()
;})(switch__47085__auto__,c__47173__auto___98575,out))
})();
var state__47175__auto__ = (function (){var statearr_98573 = f__47174__auto__.call(null);
(statearr_98573[(6)] = c__47173__auto___98575);

return statearr_98573;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__47175__auto__);
});})(c__47173__auto___98575,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map?rel=1511404582219
