// Compiled by ClojureScript 1.9.946 {}
goog.provide('fulcro_spec.renderer');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cognitect.transit');
goog.require('goog.string');
goog.require('com.stuartsierra.component');
goog.require('goog.dom');
goog.require('om.dom');
goog.require('om.next');
goog.require('pushy.core');
goog.require('fulcro.client.core');
goog.require('fulcro.client.data_fetch');
goog.require('fulcro.client.network');
goog.require('fulcro.client.mutations');
goog.require('fulcro_spec.dom.edn_renderer');
goog.require('fulcro_spec.diff');
goog.require('fulcro_spec.selectors');
goog.require('fulcro.websockets.networking');
goog.require('goog.date.DateTime');
goog.require('goog.i18n.DateTimeFormat');
cljs.core.enable_console_print_BANG_.call(null);
fulcro_spec.renderer.test_item_class = (function fulcro_spec$renderer$test_item_class(p__48872){
var map__48873 = p__48872;
var map__48873__$1 = ((((!((map__48873 == null)))?((((map__48873.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48873.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48873):map__48873);
var fail = cljs.core.get.call(null,map__48873__$1,new cljs.core.Keyword(null,"fail","fail",1706214930));
var error = cljs.core.get.call(null,map__48873__$1,new cljs.core.Keyword(null,"error","error",-978969032));
var pass = cljs.core.get.call(null,map__48873__$1,new cljs.core.Keyword(null,"pass","pass",1574159993));
var manual = cljs.core.get.call(null,map__48873__$1,new cljs.core.Keyword(null,"manual","manual",-237370608));
return ["test-",cljs.core.str.cljs$core$IFn$_invoke$arity$1((((fail > (0)))?"fail":(((error > (0)))?"error":(((pass > (0)))?"pass":(((manual > (0)))?"manual":"pending"
)))))].join('');
});
fulcro_spec.renderer.color_favicon_data_url = (function fulcro_spec$renderer$color_favicon_data_url(color){
var cvs = document.createElement("canvas");
cvs.width = (16);

cvs.height = (16);

var ctx_48875 = cvs.getContext("2d");
ctx_48875.fillStyle = color;

ctx_48875.fillRect((0),(0),(16),(16));

return cvs.toDataURL();
});
fulcro_spec.renderer.change_favicon_to_color = (function fulcro_spec$renderer$change_favicon_to_color(color){
var favicon = document.getElementById("favicon");
return favicon.href = fulcro_spec.renderer.color_favicon_data_url.call(null,color);
});
fulcro_spec.renderer.has_status_QMARK_ = (function fulcro_spec$renderer$has_status_QMARK_(p){
return (function fulcro_spec$renderer$has_status_QMARK__$_has_status_QMARK__STAR_(x){
var or__28141__auto__ = p.call(null,new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(x));
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
return (cljs.core.seq.call(null,new cljs.core.Keyword(null,"test-items","test-items",1900391985).cljs$core$IFn$_invoke$arity$1(x))) && (cljs.core.seq.call(null,cljs.core.filter.call(null,fulcro_spec$renderer$has_status_QMARK__$_has_status_QMARK__STAR_,new cljs.core.Keyword(null,"test-items","test-items",1900391985).cljs$core$IFn$_invoke$arity$1(x))));
}
});
});
fulcro_spec.renderer.filters = (function (){var report_as = (function (status){
return (function (p1__48876_SHARP_){
return cljs.core.update.call(null,p1__48876_SHARP_,new cljs.core.Keyword(null,"status","status",-1997798413),cljs.core.select_keys,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [status], null));
});
});
var no_test_results = ((function (report_as){
return (function (p1__48877_SHARP_){
return cljs.core.dissoc.call(null,p1__48877_SHARP_,new cljs.core.Keyword(null,"test-results","test-results",575566942));
});})(report_as))
;
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"all","all",892129742),cljs.core.map.call(null,cljs.core.identity),null,cljs.core.map.call(null,cljs.core.identity),new cljs.core.Keyword(null,"failing","failing",-324520682),cljs.core.filter.call(null,cljs.core.comp.call(null,((function (report_as,no_test_results){
return (function (p1__48878_SHARP_){
return cljs.core.some.call(null,cljs.core.pos_QMARK_,p1__48878_SHARP_);
});})(report_as,no_test_results))
,cljs.core.juxt.call(null,new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"error","error",-978969032)),new cljs.core.Keyword(null,"status","status",-1997798413))),new cljs.core.Keyword(null,"manual","manual",-237370608),cljs.core.comp.call(null,cljs.core.filter.call(null,fulcro_spec.renderer.has_status_QMARK_.call(null,((function (report_as,no_test_results){
return (function (p1__48879_SHARP_){
return (new cljs.core.Keyword(null,"manual","manual",-237370608).cljs$core$IFn$_invoke$arity$1(p1__48879_SHARP_) > (0));
});})(report_as,no_test_results))
)),cljs.core.map.call(null,no_test_results),cljs.core.map.call(null,report_as.call(null,new cljs.core.Keyword(null,"manual","manual",-237370608)))),new cljs.core.Keyword(null,"passing","passing",154799600),cljs.core.comp.call(null,cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.pos_QMARK_,new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"status","status",-1997798413))),cljs.core.map.call(null,report_as.call(null,new cljs.core.Keyword(null,"pass","pass",1574159993)))),new cljs.core.Keyword(null,"pending","pending",-220036727),cljs.core.comp.call(null,cljs.core.filter.call(null,fulcro_spec.renderer.has_status_QMARK_.call(null,((function (report_as,no_test_results){
return (function (p1__48880_SHARP_){
return (cljs.core.apply.call(null,cljs.core._PLUS_,cljs.core.vals.call(null,p1__48880_SHARP_)) === (0));
});})(report_as,no_test_results))
)),cljs.core.map.call(null,no_test_results),cljs.core.map.call(null,report_as.call(null,new cljs.core.Keyword(null,"pending","pending",-220036727))))], null);
})();
if(typeof fulcro_spec.renderer.Foldable !== 'undefined'){
} else {
/**
 * @constructor
 */
fulcro_spec.renderer.Foldable = (function fulcro_spec$renderer$Foldable(){
var this__35632__auto__ = this;
React.Component.apply(this__35632__auto__,arguments);

if(!((this__35632__auto__.initLocalState == null))){
this__35632__auto__.state = this__35632__auto__.initLocalState();
} else {
this__35632__auto__.state = {};
}

return this__35632__auto__;
});

fulcro_spec.renderer.Foldable.prototype = goog.object.clone(React.Component.prototype);
}

var x48883_48901 = fulcro_spec.renderer.Foldable.prototype;
x48883_48901.componentWillUpdate = ((function (x48883_48901){
return (function (next_props__35520__auto__,next_state__35521__auto__){
var this__35519__auto__ = this;
if(((!((this__35519__auto__ == null)))?(((false) || ((cljs.core.PROTOCOL_SENTINEL === this__35519__auto__.om$next$Ident$)))?true:false):false)){
var ident__35523__auto___48902 = om.next.ident.call(null,this__35519__auto__,om.next.props.call(null,this__35519__auto__));
var next_ident__35524__auto___48903 = om.next.ident.call(null,this__35519__auto__,om.next._next_props.call(null,next_props__35520__auto__,this__35519__auto__));
if(cljs.core.not_EQ_.call(null,ident__35523__auto___48902,next_ident__35524__auto___48903)){
var idxr__35525__auto___48904 = cljs.core.get_in.call(null,om.next.get_reconciler.call(null,this__35519__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
if((idxr__35525__auto___48904 == null)){
} else {
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"indexes","indexes",1496475545).cljs$core$IFn$_invoke$arity$1(idxr__35525__auto___48904),((function (idxr__35525__auto___48904,ident__35523__auto___48902,next_ident__35524__auto___48903,this__35519__auto__,x48883_48901){
return (function (indexes__35526__auto__){
return cljs.core.update_in.call(null,cljs.core.update_in.call(null,indexes__35526__auto__,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ref->components","ref->components",-303587249),ident__35523__auto___48902], null),cljs.core.disj,this__35519__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ref->components","ref->components",-303587249),next_ident__35524__auto___48903], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentHashSet.EMPTY),this__35519__auto__);
});})(idxr__35525__auto___48904,ident__35523__auto___48902,next_ident__35524__auto___48903,this__35519__auto__,x48883_48901))
);
}
} else {
}
} else {
}

om.next.merge_pending_props_BANG_.call(null,this__35519__auto__);

return om.next.merge_pending_state_BANG_.call(null,this__35519__auto__);
});})(x48883_48901))
;

x48883_48901.shouldComponentUpdate = ((function (x48883_48901){
return (function (next_props__35520__auto__,next_state__35521__auto__){
var this__35519__auto__ = this;
var next_children__35522__auto__ = next_props__35520__auto__.children;
var next_props__35520__auto____$1 = goog.object.get(next_props__35520__auto__,"omcljs$value");
var next_props__35520__auto____$2 = (function (){var G__48885 = next_props__35520__auto____$1;
if((next_props__35520__auto____$1 instanceof om.next.OmProps)){
return om.next.unwrap.call(null,G__48885);
} else {
return G__48885;
}
})();
var or__28141__auto__ = cljs.core.not_EQ_.call(null,om.next.props.call(null,this__35519__auto__),next_props__35520__auto____$2);
if(or__28141__auto__){
return or__28141__auto__;
} else {
var or__28141__auto____$1 = (function (){var and__28129__auto__ = this__35519__auto__.state;
if(cljs.core.truth_(and__28129__auto__)){
return cljs.core.not_EQ_.call(null,goog.object.get(this__35519__auto__.state,"omcljs$state"),goog.object.get(next_state__35521__auto__,"omcljs$state"));
} else {
return and__28129__auto__;
}
})();
if(cljs.core.truth_(or__28141__auto____$1)){
return or__28141__auto____$1;
} else {
return cljs.core.not_EQ_.call(null,this__35519__auto__.props.children,next_children__35522__auto__);
}
}
});})(x48883_48901))
;

x48883_48901.componentWillUnmount = ((function (x48883_48901){
return (function (){
var this__35519__auto__ = this;
var r__35530__auto__ = om.next.get_reconciler.call(null,this__35519__auto__);
var cfg__35531__auto__ = new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(r__35530__auto__);
var st__35532__auto__ = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(cfg__35531__auto__);
var indexer__35529__auto__ = new cljs.core.Keyword(null,"indexer","indexer",-1774914315).cljs$core$IFn$_invoke$arity$1(cfg__35531__auto__);
if(cljs.core.truth_((function (){var and__28129__auto__ = !((st__35532__auto__ == null));
if(and__28129__auto__){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,st__35532__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("om.next","queries","om.next/queries",-22717146),this__35519__auto__], null));
} else {
return and__28129__auto__;
}
})())){
cljs.core.swap_BANG_.call(null,st__35532__auto__,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("om.next","queries","om.next/queries",-22717146)], null),cljs.core.dissoc,this__35519__auto__);
} else {
}

if((indexer__35529__auto__ == null)){
return null;
} else {
return om.next.protocols.drop_component_BANG_.call(null,indexer__35529__auto__,this__35519__auto__);
}
});})(x48883_48901))
;

x48883_48901.componentDidUpdate = ((function (x48883_48901){
return (function (prev_props__35527__auto__,prev_state__35528__auto__){
var this__35519__auto__ = this;
return om.next.clear_prev_props_BANG_.call(null,this__35519__auto__);
});})(x48883_48901))
;

x48883_48901.isMounted = ((function (x48883_48901){
return (function (){
var this__35519__auto__ = this;
return cljs.core.boolean$.call(null,goog.object.getValueByKeys(this__35519__auto__,"_reactInternalInstance","_renderedComponent"));
});})(x48883_48901))
;

x48883_48901.componentWillMount = ((function (x48883_48901){
return (function (){
var this__35519__auto__ = this;
var indexer__35529__auto__ = cljs.core.get_in.call(null,om.next.get_reconciler.call(null,this__35519__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
if((indexer__35529__auto__ == null)){
return null;
} else {
return om.next.protocols.index_component_BANG_.call(null,indexer__35529__auto__,this__35519__auto__);
}
});})(x48883_48901))
;

x48883_48901.initLocalState = ((function (x48883_48901){
return (function (){
var this$ = this;
var ret__35497__auto__ = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"folded?","folded?",1971930715),true], null);
var obj48887 = {"omcljs$state":ret__35497__auto__};
return obj48887;
});})(x48883_48901))
;

x48883_48901.render = ((function (x48883_48901){
return (function (){
var this__35518__auto__ = this;
var this$ = this__35518__auto__;
var _STAR_reconciler_STAR_48888 = om.next._STAR_reconciler_STAR_;
var _STAR_depth_STAR_48889 = om.next._STAR_depth_STAR_;
var _STAR_shared_STAR_48890 = om.next._STAR_shared_STAR_;
var _STAR_instrument_STAR_48891 = om.next._STAR_instrument_STAR_;
var _STAR_parent_STAR_48892 = om.next._STAR_parent_STAR_;
om.next._STAR_reconciler_STAR_ = om.next.get_reconciler.call(null,this__35518__auto__);

om.next._STAR_depth_STAR_ = (om.next.depth.call(null,this__35518__auto__) + (1));

om.next._STAR_shared_STAR_ = om.next.shared.call(null,this__35518__auto__);

om.next._STAR_instrument_STAR_ = om.next.instrument.call(null,this__35518__auto__);

om.next._STAR_parent_STAR_ = this__35518__auto__;

try{var map__48893 = om.next.get_state.call(null,this$);
var map__48893__$1 = ((((!((map__48893 == null)))?((((map__48893.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48893.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48893):map__48893);
var folded_QMARK_ = cljs.core.get.call(null,map__48893__$1,new cljs.core.Keyword(null,"folded?","folded?",1971930715));
var map__48894 = om.next.props.call(null,this$);
var map__48894__$1 = ((((!((map__48894 == null)))?((((map__48894.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48894.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48894):map__48894);
var render = cljs.core.get.call(null,map__48894__$1,new cljs.core.Keyword(null,"render","render",-1408033454));
var map__48895 = render.call(null,folded_QMARK_);
var map__48895__$1 = ((((!((map__48895 == null)))?((((map__48895.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48895.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48895):map__48895);
var title = cljs.core.get.call(null,map__48895__$1,new cljs.core.Keyword(null,"title","title",636505583));
var value = cljs.core.get.call(null,map__48895__$1,new cljs.core.Keyword(null,"value","value",305978217));
var classes = cljs.core.get.call(null,map__48895__$1,new cljs.core.Keyword(null,"classes","classes",2037804510));
return om.dom.div.call(null,({"className": "foldable"}),om.dom.a.call(null,({"className": classes, "onClick": ((function (map__48893,map__48893__$1,folded_QMARK_,map__48894,map__48894__$1,render,map__48895,map__48895__$1,title,value,classes,_STAR_reconciler_STAR_48888,_STAR_depth_STAR_48889,_STAR_shared_STAR_48890,_STAR_instrument_STAR_48891,_STAR_parent_STAR_48892,this$,this__35518__auto__,x48883_48901){
return (function (){
return om.next.update_state_BANG_.call(null,this$,cljs.core.update,new cljs.core.Keyword(null,"folded?","folded?",1971930715),cljs.core.not);
});})(map__48893,map__48893__$1,folded_QMARK_,map__48894,map__48894__$1,render,map__48895,map__48895__$1,title,value,classes,_STAR_reconciler_STAR_48888,_STAR_depth_STAR_48889,_STAR_shared_STAR_48890,_STAR_instrument_STAR_48891,_STAR_parent_STAR_48892,this$,this__35518__auto__,x48883_48901))
}),(cljs.core.truth_(folded_QMARK_)?"\u25BA":"\u25BC"),(cljs.core.truth_(folded_QMARK_)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.apply.call(null,cljs.core.str,cljs.core.take.call(null,(40),title))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(((((40) < cljs.core.count.call(null,title)))?"...":null))].join(''):[cljs.core.str.cljs$core$IFn$_invoke$arity$1(title)].join(''))),om.dom.div.call(null,({"className": (cljs.core.truth_(folded_QMARK_)?"hidden":null)}),value));
}finally {om.next._STAR_parent_STAR_ = _STAR_parent_STAR_48892;

om.next._STAR_instrument_STAR_ = _STAR_instrument_STAR_48891;

om.next._STAR_shared_STAR_ = _STAR_shared_STAR_48890;

om.next._STAR_depth_STAR_ = _STAR_depth_STAR_48889;

om.next._STAR_reconciler_STAR_ = _STAR_reconciler_STAR_48888;
}});})(x48883_48901))
;


fulcro_spec.renderer.Foldable.prototype.constructor = fulcro_spec.renderer.Foldable;

fulcro_spec.renderer.Foldable.prototype.constructor.displayName = "fulcro-spec.renderer/Foldable";

fulcro_spec.renderer.Foldable.prototype.om$isComponent = true;

var x48899_48905 = fulcro_spec.renderer.Foldable;


var x48900_48906 = fulcro_spec.renderer.Foldable.prototype;


fulcro_spec.renderer.Foldable.cljs$lang$type = true;

fulcro_spec.renderer.Foldable.cljs$lang$ctorStr = "fulcro-spec.renderer/Foldable";

fulcro_spec.renderer.Foldable.cljs$lang$ctorPrWriter = (function (this__35635__auto__,writer__35636__auto__,opt__35637__auto__){
return cljs.core._write.call(null,writer__35636__auto__,"fulcro-spec.renderer/Foldable");
});
fulcro_spec.renderer.ui_foldable = om.next.factory.call(null,fulcro_spec.renderer.Foldable,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"keyfn","keyfn",780060332),(function (){
return cljs.core.gensym.call(null,"foldable");
})], null));
if(typeof fulcro_spec.renderer.ResultLine !== 'undefined'){
} else {
/**
 * @constructor
 */
fulcro_spec.renderer.ResultLine = (function fulcro_spec$renderer$ResultLine(){
var this__35632__auto__ = this;
React.Component.apply(this__35632__auto__,arguments);

if(!((this__35632__auto__.initLocalState == null))){
this__35632__auto__.state = this__35632__auto__.initLocalState();
} else {
this__35632__auto__.state = {};
}

return this__35632__auto__;
});

fulcro_spec.renderer.ResultLine.prototype = goog.object.clone(React.Component.prototype);
}

var x48909_48921 = fulcro_spec.renderer.ResultLine.prototype;
x48909_48921.componentWillUpdate = ((function (x48909_48921){
return (function (next_props__35520__auto__,next_state__35521__auto__){
var this__35519__auto__ = this;
if(((!((this__35519__auto__ == null)))?(((false) || ((cljs.core.PROTOCOL_SENTINEL === this__35519__auto__.om$next$Ident$)))?true:false):false)){
var ident__35523__auto___48922 = om.next.ident.call(null,this__35519__auto__,om.next.props.call(null,this__35519__auto__));
var next_ident__35524__auto___48923 = om.next.ident.call(null,this__35519__auto__,om.next._next_props.call(null,next_props__35520__auto__,this__35519__auto__));
if(cljs.core.not_EQ_.call(null,ident__35523__auto___48922,next_ident__35524__auto___48923)){
var idxr__35525__auto___48924 = cljs.core.get_in.call(null,om.next.get_reconciler.call(null,this__35519__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
if((idxr__35525__auto___48924 == null)){
} else {
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"indexes","indexes",1496475545).cljs$core$IFn$_invoke$arity$1(idxr__35525__auto___48924),((function (idxr__35525__auto___48924,ident__35523__auto___48922,next_ident__35524__auto___48923,this__35519__auto__,x48909_48921){
return (function (indexes__35526__auto__){
return cljs.core.update_in.call(null,cljs.core.update_in.call(null,indexes__35526__auto__,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ref->components","ref->components",-303587249),ident__35523__auto___48922], null),cljs.core.disj,this__35519__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ref->components","ref->components",-303587249),next_ident__35524__auto___48923], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentHashSet.EMPTY),this__35519__auto__);
});})(idxr__35525__auto___48924,ident__35523__auto___48922,next_ident__35524__auto___48923,this__35519__auto__,x48909_48921))
);
}
} else {
}
} else {
}

om.next.merge_pending_props_BANG_.call(null,this__35519__auto__);

return om.next.merge_pending_state_BANG_.call(null,this__35519__auto__);
});})(x48909_48921))
;

x48909_48921.shouldComponentUpdate = ((function (x48909_48921){
return (function (next_props__35520__auto__,next_state__35521__auto__){
var this__35519__auto__ = this;
var next_children__35522__auto__ = next_props__35520__auto__.children;
var next_props__35520__auto____$1 = goog.object.get(next_props__35520__auto__,"omcljs$value");
var next_props__35520__auto____$2 = (function (){var G__48911 = next_props__35520__auto____$1;
if((next_props__35520__auto____$1 instanceof om.next.OmProps)){
return om.next.unwrap.call(null,G__48911);
} else {
return G__48911;
}
})();
var or__28141__auto__ = cljs.core.not_EQ_.call(null,om.next.props.call(null,this__35519__auto__),next_props__35520__auto____$2);
if(or__28141__auto__){
return or__28141__auto__;
} else {
var or__28141__auto____$1 = (function (){var and__28129__auto__ = this__35519__auto__.state;
if(cljs.core.truth_(and__28129__auto__)){
return cljs.core.not_EQ_.call(null,goog.object.get(this__35519__auto__.state,"omcljs$state"),goog.object.get(next_state__35521__auto__,"omcljs$state"));
} else {
return and__28129__auto__;
}
})();
if(cljs.core.truth_(or__28141__auto____$1)){
return or__28141__auto____$1;
} else {
return cljs.core.not_EQ_.call(null,this__35519__auto__.props.children,next_children__35522__auto__);
}
}
});})(x48909_48921))
;

x48909_48921.componentWillUnmount = ((function (x48909_48921){
return (function (){
var this__35519__auto__ = this;
var r__35530__auto__ = om.next.get_reconciler.call(null,this__35519__auto__);
var cfg__35531__auto__ = new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(r__35530__auto__);
var st__35532__auto__ = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(cfg__35531__auto__);
var indexer__35529__auto__ = new cljs.core.Keyword(null,"indexer","indexer",-1774914315).cljs$core$IFn$_invoke$arity$1(cfg__35531__auto__);
if(cljs.core.truth_((function (){var and__28129__auto__ = !((st__35532__auto__ == null));
if(and__28129__auto__){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,st__35532__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("om.next","queries","om.next/queries",-22717146),this__35519__auto__], null));
} else {
return and__28129__auto__;
}
})())){
cljs.core.swap_BANG_.call(null,st__35532__auto__,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("om.next","queries","om.next/queries",-22717146)], null),cljs.core.dissoc,this__35519__auto__);
} else {
}

if((indexer__35529__auto__ == null)){
return null;
} else {
return om.next.protocols.drop_component_BANG_.call(null,indexer__35529__auto__,this__35519__auto__);
}
});})(x48909_48921))
;

x48909_48921.componentDidUpdate = ((function (x48909_48921){
return (function (prev_props__35527__auto__,prev_state__35528__auto__){
var this__35519__auto__ = this;
return om.next.clear_prev_props_BANG_.call(null,this__35519__auto__);
});})(x48909_48921))
;

x48909_48921.isMounted = ((function (x48909_48921){
return (function (){
var this__35519__auto__ = this;
return cljs.core.boolean$.call(null,goog.object.getValueByKeys(this__35519__auto__,"_reactInternalInstance","_renderedComponent"));
});})(x48909_48921))
;

x48909_48921.componentWillMount = ((function (x48909_48921){
return (function (){
var this__35519__auto__ = this;
var indexer__35529__auto__ = cljs.core.get_in.call(null,om.next.get_reconciler.call(null,this__35519__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
if((indexer__35529__auto__ == null)){
return null;
} else {
return om.next.protocols.index_component_BANG_.call(null,indexer__35529__auto__,this__35519__auto__);
}
});})(x48909_48921))
;

x48909_48921.render = ((function (x48909_48921){
return (function (){
var this__35518__auto__ = this;
var this$ = this__35518__auto__;
var _STAR_reconciler_STAR_48912 = om.next._STAR_reconciler_STAR_;
var _STAR_depth_STAR_48913 = om.next._STAR_depth_STAR_;
var _STAR_shared_STAR_48914 = om.next._STAR_shared_STAR_;
var _STAR_instrument_STAR_48915 = om.next._STAR_instrument_STAR_;
var _STAR_parent_STAR_48916 = om.next._STAR_parent_STAR_;
om.next._STAR_reconciler_STAR_ = om.next.get_reconciler.call(null,this__35518__auto__);

om.next._STAR_depth_STAR_ = (om.next.depth.call(null,this__35518__auto__) + (1));

om.next._STAR_shared_STAR_ = om.next.shared.call(null,this__35518__auto__);

om.next._STAR_instrument_STAR_ = om.next.instrument.call(null,this__35518__auto__);

om.next._STAR_parent_STAR_ = this__35518__auto__;

try{var map__48917 = om.next.props.call(null,this$);
var map__48917__$1 = ((((!((map__48917 == null)))?((((map__48917.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48917.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48917):map__48917);
var title = cljs.core.get.call(null,map__48917__$1,new cljs.core.Keyword(null,"title","title",636505583));
var value = cljs.core.get.call(null,map__48917__$1,new cljs.core.Keyword(null,"value","value",305978217));
var stack = cljs.core.get.call(null,map__48917__$1,new cljs.core.Keyword(null,"stack","stack",-793405930));
var type = cljs.core.get.call(null,map__48917__$1,new cljs.core.Keyword(null,"type","type",1174270348));
return om.dom.tr.call(null,null,om.dom.td.call(null,({"className": ["test-result-title ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,type))].join('')}),title),om.dom.td.call(null,({"className": "test-result"}),om.dom.code.call(null,null,fulcro_spec.renderer.ui_foldable.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"render","render",-1408033454),((function (map__48917,map__48917__$1,title,value,stack,type,_STAR_reconciler_STAR_48912,_STAR_depth_STAR_48913,_STAR_shared_STAR_48914,_STAR_instrument_STAR_48915,_STAR_parent_STAR_48916,this$,this__35518__auto__,x48909_48921){
return (function (folded_QMARK_){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"title","title",636505583),(cljs.core.truth_(stack)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(value)].join(''):(cljs.core.truth_(folded_QMARK_)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(value)].join(''):title)),new cljs.core.Keyword(null,"value","value",305978217),(cljs.core.truth_(stack)?stack:((cljs.core.not.call(null,folded_QMARK_))?fulcro_spec.dom.edn_renderer.html_edn.call(null,value):null)),new cljs.core.Keyword(null,"classes","classes",2037804510),(cljs.core.truth_(stack)?"stack":null)], null);
});})(map__48917,map__48917__$1,title,value,stack,type,_STAR_reconciler_STAR_48912,_STAR_depth_STAR_48913,_STAR_shared_STAR_48914,_STAR_instrument_STAR_48915,_STAR_parent_STAR_48916,this$,this__35518__auto__,x48909_48921))
], null)))));
}finally {om.next._STAR_parent_STAR_ = _STAR_parent_STAR_48916;

om.next._STAR_instrument_STAR_ = _STAR_instrument_STAR_48915;

om.next._STAR_shared_STAR_ = _STAR_shared_STAR_48914;

om.next._STAR_depth_STAR_ = _STAR_depth_STAR_48913;

om.next._STAR_reconciler_STAR_ = _STAR_reconciler_STAR_48912;
}});})(x48909_48921))
;


fulcro_spec.renderer.ResultLine.prototype.constructor = fulcro_spec.renderer.ResultLine;

fulcro_spec.renderer.ResultLine.prototype.constructor.displayName = "fulcro-spec.renderer/ResultLine";

fulcro_spec.renderer.ResultLine.prototype.om$isComponent = true;

var x48919_48925 = fulcro_spec.renderer.ResultLine;


var x48920_48926 = fulcro_spec.renderer.ResultLine.prototype;


fulcro_spec.renderer.ResultLine.cljs$lang$type = true;

fulcro_spec.renderer.ResultLine.cljs$lang$ctorStr = "fulcro-spec.renderer/ResultLine";

fulcro_spec.renderer.ResultLine.cljs$lang$ctorPrWriter = (function (this__35635__auto__,writer__35636__auto__,opt__35637__auto__){
return cljs.core._write.call(null,writer__35636__auto__,"fulcro-spec.renderer/ResultLine");
});
fulcro_spec.renderer.ui_result_line = om.next.factory.call(null,fulcro_spec.renderer.ResultLine,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"keyfn","keyfn",780060332),(function (){
return cljs.core.gensym.call(null,"result-line");
})], null));
if(typeof fulcro_spec.renderer.HumanDiffLines !== 'undefined'){
} else {
/**
 * @constructor
 */
fulcro_spec.renderer.HumanDiffLines = (function fulcro_spec$renderer$HumanDiffLines(){
var this__35632__auto__ = this;
React.Component.apply(this__35632__auto__,arguments);

if(!((this__35632__auto__.initLocalState == null))){
this__35632__auto__.state = this__35632__auto__.initLocalState();
} else {
this__35632__auto__.state = {};
}

return this__35632__auto__;
});

fulcro_spec.renderer.HumanDiffLines.prototype = goog.object.clone(React.Component.prototype);
}

var x48929_48941 = fulcro_spec.renderer.HumanDiffLines.prototype;
x48929_48941.componentWillUpdate = ((function (x48929_48941){
return (function (next_props__35520__auto__,next_state__35521__auto__){
var this__35519__auto__ = this;
if(((!((this__35519__auto__ == null)))?(((false) || ((cljs.core.PROTOCOL_SENTINEL === this__35519__auto__.om$next$Ident$)))?true:false):false)){
var ident__35523__auto___48942 = om.next.ident.call(null,this__35519__auto__,om.next.props.call(null,this__35519__auto__));
var next_ident__35524__auto___48943 = om.next.ident.call(null,this__35519__auto__,om.next._next_props.call(null,next_props__35520__auto__,this__35519__auto__));
if(cljs.core.not_EQ_.call(null,ident__35523__auto___48942,next_ident__35524__auto___48943)){
var idxr__35525__auto___48944 = cljs.core.get_in.call(null,om.next.get_reconciler.call(null,this__35519__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
if((idxr__35525__auto___48944 == null)){
} else {
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"indexes","indexes",1496475545).cljs$core$IFn$_invoke$arity$1(idxr__35525__auto___48944),((function (idxr__35525__auto___48944,ident__35523__auto___48942,next_ident__35524__auto___48943,this__35519__auto__,x48929_48941){
return (function (indexes__35526__auto__){
return cljs.core.update_in.call(null,cljs.core.update_in.call(null,indexes__35526__auto__,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ref->components","ref->components",-303587249),ident__35523__auto___48942], null),cljs.core.disj,this__35519__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ref->components","ref->components",-303587249),next_ident__35524__auto___48943], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentHashSet.EMPTY),this__35519__auto__);
});})(idxr__35525__auto___48944,ident__35523__auto___48942,next_ident__35524__auto___48943,this__35519__auto__,x48929_48941))
);
}
} else {
}
} else {
}

om.next.merge_pending_props_BANG_.call(null,this__35519__auto__);

return om.next.merge_pending_state_BANG_.call(null,this__35519__auto__);
});})(x48929_48941))
;

x48929_48941.shouldComponentUpdate = ((function (x48929_48941){
return (function (next_props__35520__auto__,next_state__35521__auto__){
var this__35519__auto__ = this;
var next_children__35522__auto__ = next_props__35520__auto__.children;
var next_props__35520__auto____$1 = goog.object.get(next_props__35520__auto__,"omcljs$value");
var next_props__35520__auto____$2 = (function (){var G__48931 = next_props__35520__auto____$1;
if((next_props__35520__auto____$1 instanceof om.next.OmProps)){
return om.next.unwrap.call(null,G__48931);
} else {
return G__48931;
}
})();
var or__28141__auto__ = cljs.core.not_EQ_.call(null,om.next.props.call(null,this__35519__auto__),next_props__35520__auto____$2);
if(or__28141__auto__){
return or__28141__auto__;
} else {
var or__28141__auto____$1 = (function (){var and__28129__auto__ = this__35519__auto__.state;
if(cljs.core.truth_(and__28129__auto__)){
return cljs.core.not_EQ_.call(null,goog.object.get(this__35519__auto__.state,"omcljs$state"),goog.object.get(next_state__35521__auto__,"omcljs$state"));
} else {
return and__28129__auto__;
}
})();
if(cljs.core.truth_(or__28141__auto____$1)){
return or__28141__auto____$1;
} else {
return cljs.core.not_EQ_.call(null,this__35519__auto__.props.children,next_children__35522__auto__);
}
}
});})(x48929_48941))
;

x48929_48941.componentWillUnmount = ((function (x48929_48941){
return (function (){
var this__35519__auto__ = this;
var r__35530__auto__ = om.next.get_reconciler.call(null,this__35519__auto__);
var cfg__35531__auto__ = new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(r__35530__auto__);
var st__35532__auto__ = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(cfg__35531__auto__);
var indexer__35529__auto__ = new cljs.core.Keyword(null,"indexer","indexer",-1774914315).cljs$core$IFn$_invoke$arity$1(cfg__35531__auto__);
if(cljs.core.truth_((function (){var and__28129__auto__ = !((st__35532__auto__ == null));
if(and__28129__auto__){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,st__35532__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("om.next","queries","om.next/queries",-22717146),this__35519__auto__], null));
} else {
return and__28129__auto__;
}
})())){
cljs.core.swap_BANG_.call(null,st__35532__auto__,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("om.next","queries","om.next/queries",-22717146)], null),cljs.core.dissoc,this__35519__auto__);
} else {
}

if((indexer__35529__auto__ == null)){
return null;
} else {
return om.next.protocols.drop_component_BANG_.call(null,indexer__35529__auto__,this__35519__auto__);
}
});})(x48929_48941))
;

x48929_48941.componentDidUpdate = ((function (x48929_48941){
return (function (prev_props__35527__auto__,prev_state__35528__auto__){
var this__35519__auto__ = this;
return om.next.clear_prev_props_BANG_.call(null,this__35519__auto__);
});})(x48929_48941))
;

x48929_48941.isMounted = ((function (x48929_48941){
return (function (){
var this__35519__auto__ = this;
return cljs.core.boolean$.call(null,goog.object.getValueByKeys(this__35519__auto__,"_reactInternalInstance","_renderedComponent"));
});})(x48929_48941))
;

x48929_48941.componentWillMount = ((function (x48929_48941){
return (function (){
var this__35519__auto__ = this;
var indexer__35529__auto__ = cljs.core.get_in.call(null,om.next.get_reconciler.call(null,this__35519__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
if((indexer__35529__auto__ == null)){
return null;
} else {
return om.next.protocols.index_component_BANG_.call(null,indexer__35529__auto__,this__35519__auto__);
}
});})(x48929_48941))
;

x48929_48941.render = ((function (x48929_48941){
return (function (){
var this__35518__auto__ = this;
var this$ = this__35518__auto__;
var _STAR_reconciler_STAR_48932 = om.next._STAR_reconciler_STAR_;
var _STAR_depth_STAR_48933 = om.next._STAR_depth_STAR_;
var _STAR_shared_STAR_48934 = om.next._STAR_shared_STAR_;
var _STAR_instrument_STAR_48935 = om.next._STAR_instrument_STAR_;
var _STAR_parent_STAR_48936 = om.next._STAR_parent_STAR_;
om.next._STAR_reconciler_STAR_ = om.next.get_reconciler.call(null,this__35518__auto__);

om.next._STAR_depth_STAR_ = (om.next.depth.call(null,this__35518__auto__) + (1));

om.next._STAR_shared_STAR_ = om.next.shared.call(null,this__35518__auto__);

om.next._STAR_instrument_STAR_ = om.next.instrument.call(null,this__35518__auto__);

om.next._STAR_parent_STAR_ = this__35518__auto__;

try{var d = om.next.props.call(null,this$);
var map__48937 = fulcro_spec.diff.extract.call(null,d);
var map__48937__$1 = ((((!((map__48937 == null)))?((((map__48937.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48937.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48937):map__48937);
var exp = cljs.core.get.call(null,map__48937__$1,new cljs.core.Keyword(null,"exp","exp",-261706262));
var got = cljs.core.get.call(null,map__48937__$1,new cljs.core.Keyword(null,"got","got",-1674745710));
var path = cljs.core.get.call(null,map__48937__$1,new cljs.core.Keyword(null,"path","path",-188191168));
return om.dom.table.call(null,({"className": "human-diff-lines"}),om.dom.tbody.call(null,null,((cljs.core.seq.call(null,path))?om.dom.tr.call(null,({"className": "path"}),om.dom.td.call(null,null,"at: "),om.dom.td.call(null,null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(path)].join(''))):null),om.dom.tr.call(null,({"className": "expected"}),om.dom.td.call(null,null,"exp: "),om.dom.td.call(null,null,fulcro_spec.dom.edn_renderer.html_edn.call(null,exp))),om.dom.tr.call(null,({"className": "actual"}),om.dom.td.call(null,null,"got: "),om.dom.td.call(null,null,fulcro_spec.dom.edn_renderer.html_edn.call(null,got)))));
}finally {om.next._STAR_parent_STAR_ = _STAR_parent_STAR_48936;

om.next._STAR_instrument_STAR_ = _STAR_instrument_STAR_48935;

om.next._STAR_shared_STAR_ = _STAR_shared_STAR_48934;

om.next._STAR_depth_STAR_ = _STAR_depth_STAR_48933;

om.next._STAR_reconciler_STAR_ = _STAR_reconciler_STAR_48932;
}});})(x48929_48941))
;


fulcro_spec.renderer.HumanDiffLines.prototype.constructor = fulcro_spec.renderer.HumanDiffLines;

fulcro_spec.renderer.HumanDiffLines.prototype.constructor.displayName = "fulcro-spec.renderer/HumanDiffLines";

fulcro_spec.renderer.HumanDiffLines.prototype.om$isComponent = true;

var x48939_48945 = fulcro_spec.renderer.HumanDiffLines;


var x48940_48946 = fulcro_spec.renderer.HumanDiffLines.prototype;


fulcro_spec.renderer.HumanDiffLines.cljs$lang$type = true;

fulcro_spec.renderer.HumanDiffLines.cljs$lang$ctorStr = "fulcro-spec.renderer/HumanDiffLines";

fulcro_spec.renderer.HumanDiffLines.cljs$lang$ctorPrWriter = (function (this__35635__auto__,writer__35636__auto__,opt__35637__auto__){
return cljs.core._write.call(null,writer__35636__auto__,"fulcro-spec.renderer/HumanDiffLines");
});
fulcro_spec.renderer.ui_human_diff_lines = om.next.factory.call(null,fulcro_spec.renderer.HumanDiffLines,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"keyfn","keyfn",780060332),(function (){
return cljs.core.gensym.call(null,"human-diff-lines");
})], null));
if(typeof fulcro_spec.renderer.HumanDiff !== 'undefined'){
} else {
/**
 * @constructor
 */
fulcro_spec.renderer.HumanDiff = (function fulcro_spec$renderer$HumanDiff(){
var this__35632__auto__ = this;
React.Component.apply(this__35632__auto__,arguments);

if(!((this__35632__auto__.initLocalState == null))){
this__35632__auto__.state = this__35632__auto__.initLocalState();
} else {
this__35632__auto__.state = {};
}

return this__35632__auto__;
});

fulcro_spec.renderer.HumanDiff.prototype = goog.object.clone(React.Component.prototype);
}

var x48949_48964 = fulcro_spec.renderer.HumanDiff.prototype;
x48949_48964.componentWillUpdate = ((function (x48949_48964){
return (function (next_props__35520__auto__,next_state__35521__auto__){
var this__35519__auto__ = this;
if(((!((this__35519__auto__ == null)))?(((false) || ((cljs.core.PROTOCOL_SENTINEL === this__35519__auto__.om$next$Ident$)))?true:false):false)){
var ident__35523__auto___48965 = om.next.ident.call(null,this__35519__auto__,om.next.props.call(null,this__35519__auto__));
var next_ident__35524__auto___48966 = om.next.ident.call(null,this__35519__auto__,om.next._next_props.call(null,next_props__35520__auto__,this__35519__auto__));
if(cljs.core.not_EQ_.call(null,ident__35523__auto___48965,next_ident__35524__auto___48966)){
var idxr__35525__auto___48967 = cljs.core.get_in.call(null,om.next.get_reconciler.call(null,this__35519__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
if((idxr__35525__auto___48967 == null)){
} else {
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"indexes","indexes",1496475545).cljs$core$IFn$_invoke$arity$1(idxr__35525__auto___48967),((function (idxr__35525__auto___48967,ident__35523__auto___48965,next_ident__35524__auto___48966,this__35519__auto__,x48949_48964){
return (function (indexes__35526__auto__){
return cljs.core.update_in.call(null,cljs.core.update_in.call(null,indexes__35526__auto__,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ref->components","ref->components",-303587249),ident__35523__auto___48965], null),cljs.core.disj,this__35519__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ref->components","ref->components",-303587249),next_ident__35524__auto___48966], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentHashSet.EMPTY),this__35519__auto__);
});})(idxr__35525__auto___48967,ident__35523__auto___48965,next_ident__35524__auto___48966,this__35519__auto__,x48949_48964))
);
}
} else {
}
} else {
}

om.next.merge_pending_props_BANG_.call(null,this__35519__auto__);

return om.next.merge_pending_state_BANG_.call(null,this__35519__auto__);
});})(x48949_48964))
;

x48949_48964.shouldComponentUpdate = ((function (x48949_48964){
return (function (next_props__35520__auto__,next_state__35521__auto__){
var this__35519__auto__ = this;
var next_children__35522__auto__ = next_props__35520__auto__.children;
var next_props__35520__auto____$1 = goog.object.get(next_props__35520__auto__,"omcljs$value");
var next_props__35520__auto____$2 = (function (){var G__48951 = next_props__35520__auto____$1;
if((next_props__35520__auto____$1 instanceof om.next.OmProps)){
return om.next.unwrap.call(null,G__48951);
} else {
return G__48951;
}
})();
var or__28141__auto__ = cljs.core.not_EQ_.call(null,om.next.props.call(null,this__35519__auto__),next_props__35520__auto____$2);
if(or__28141__auto__){
return or__28141__auto__;
} else {
var or__28141__auto____$1 = (function (){var and__28129__auto__ = this__35519__auto__.state;
if(cljs.core.truth_(and__28129__auto__)){
return cljs.core.not_EQ_.call(null,goog.object.get(this__35519__auto__.state,"omcljs$state"),goog.object.get(next_state__35521__auto__,"omcljs$state"));
} else {
return and__28129__auto__;
}
})();
if(cljs.core.truth_(or__28141__auto____$1)){
return or__28141__auto____$1;
} else {
return cljs.core.not_EQ_.call(null,this__35519__auto__.props.children,next_children__35522__auto__);
}
}
});})(x48949_48964))
;

x48949_48964.componentWillUnmount = ((function (x48949_48964){
return (function (){
var this__35519__auto__ = this;
var r__35530__auto__ = om.next.get_reconciler.call(null,this__35519__auto__);
var cfg__35531__auto__ = new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(r__35530__auto__);
var st__35532__auto__ = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(cfg__35531__auto__);
var indexer__35529__auto__ = new cljs.core.Keyword(null,"indexer","indexer",-1774914315).cljs$core$IFn$_invoke$arity$1(cfg__35531__auto__);
if(cljs.core.truth_((function (){var and__28129__auto__ = !((st__35532__auto__ == null));
if(and__28129__auto__){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,st__35532__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("om.next","queries","om.next/queries",-22717146),this__35519__auto__], null));
} else {
return and__28129__auto__;
}
})())){
cljs.core.swap_BANG_.call(null,st__35532__auto__,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("om.next","queries","om.next/queries",-22717146)], null),cljs.core.dissoc,this__35519__auto__);
} else {
}

if((indexer__35529__auto__ == null)){
return null;
} else {
return om.next.protocols.drop_component_BANG_.call(null,indexer__35529__auto__,this__35519__auto__);
}
});})(x48949_48964))
;

x48949_48964.componentDidUpdate = ((function (x48949_48964){
return (function (prev_props__35527__auto__,prev_state__35528__auto__){
var this__35519__auto__ = this;
return om.next.clear_prev_props_BANG_.call(null,this__35519__auto__);
});})(x48949_48964))
;

x48949_48964.isMounted = ((function (x48949_48964){
return (function (){
var this__35519__auto__ = this;
return cljs.core.boolean$.call(null,goog.object.getValueByKeys(this__35519__auto__,"_reactInternalInstance","_renderedComponent"));
});})(x48949_48964))
;

x48949_48964.componentWillMount = ((function (x48949_48964){
return (function (){
var this__35519__auto__ = this;
var indexer__35529__auto__ = cljs.core.get_in.call(null,om.next.get_reconciler.call(null,this__35519__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
if((indexer__35529__auto__ == null)){
return null;
} else {
return om.next.protocols.index_component_BANG_.call(null,indexer__35529__auto__,this__35519__auto__);
}
});})(x48949_48964))
;

x48949_48964.render = ((function (x48949_48964){
return (function (){
var this__35518__auto__ = this;
var this$ = this__35518__auto__;
var _STAR_reconciler_STAR_48952 = om.next._STAR_reconciler_STAR_;
var _STAR_depth_STAR_48953 = om.next._STAR_depth_STAR_;
var _STAR_shared_STAR_48954 = om.next._STAR_shared_STAR_;
var _STAR_instrument_STAR_48955 = om.next._STAR_instrument_STAR_;
var _STAR_parent_STAR_48956 = om.next._STAR_parent_STAR_;
om.next._STAR_reconciler_STAR_ = om.next.get_reconciler.call(null,this__35518__auto__);

om.next._STAR_depth_STAR_ = (om.next.depth.call(null,this__35518__auto__) + (1));

om.next._STAR_shared_STAR_ = om.next.shared.call(null,this__35518__auto__);

om.next._STAR_instrument_STAR_ = om.next.instrument.call(null,this__35518__auto__);

om.next._STAR_parent_STAR_ = this__35518__auto__;

try{var map__48957 = om.next.props.call(null,this$);
var map__48957__$1 = ((((!((map__48957 == null)))?((((map__48957.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48957.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48957):map__48957);
var diff = cljs.core.get.call(null,map__48957__$1,new cljs.core.Keyword(null,"diff","diff",2135942783));
var actual = cljs.core.get.call(null,map__48957__$1,new cljs.core.Keyword(null,"actual","actual",107306363));
var vec__48958 = cljs.core.split_at.call(null,(2),diff);
var fst = cljs.core.nth.call(null,vec__48958,(0),null);
var rst = cljs.core.nth.call(null,vec__48958,(1),null);
return om.dom.tr.call(null,null,om.dom.td.call(null,null,"DIFFS:"),om.dom.td.call(null,null,om.dom.div.call(null,null,cljs.core.mapv.call(null,fulcro_spec.renderer.ui_human_diff_lines,fst),((cljs.core.seq.call(null,rst))?fulcro_spec.renderer.ui_foldable.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"render","render",-1408033454),((function (map__48957,map__48957__$1,diff,actual,vec__48958,fst,rst,_STAR_reconciler_STAR_48952,_STAR_depth_STAR_48953,_STAR_shared_STAR_48954,_STAR_instrument_STAR_48955,_STAR_parent_STAR_48956,this$,this__35518__auto__,x48949_48964){
return (function (folded_QMARK_){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"title","title",636505583),"& more",new cljs.core.Keyword(null,"value","value",305978217),cljs.core.mapv.call(null,fulcro_spec.renderer.ui_human_diff_lines,rst),new cljs.core.Keyword(null,"classes","classes",2037804510),""], null);
});})(map__48957,map__48957__$1,diff,actual,vec__48958,fst,rst,_STAR_reconciler_STAR_48952,_STAR_depth_STAR_48953,_STAR_shared_STAR_48954,_STAR_instrument_STAR_48955,_STAR_parent_STAR_48956,this$,this__35518__auto__,x48949_48964))
], null)):null))));
}finally {om.next._STAR_parent_STAR_ = _STAR_parent_STAR_48956;

om.next._STAR_instrument_STAR_ = _STAR_instrument_STAR_48955;

om.next._STAR_shared_STAR_ = _STAR_shared_STAR_48954;

om.next._STAR_depth_STAR_ = _STAR_depth_STAR_48953;

om.next._STAR_reconciler_STAR_ = _STAR_reconciler_STAR_48952;
}});})(x48949_48964))
;


fulcro_spec.renderer.HumanDiff.prototype.constructor = fulcro_spec.renderer.HumanDiff;

fulcro_spec.renderer.HumanDiff.prototype.constructor.displayName = "fulcro-spec.renderer/HumanDiff";

fulcro_spec.renderer.HumanDiff.prototype.om$isComponent = true;

var x48962_48968 = fulcro_spec.renderer.HumanDiff;


var x48963_48969 = fulcro_spec.renderer.HumanDiff.prototype;


fulcro_spec.renderer.HumanDiff.cljs$lang$type = true;

fulcro_spec.renderer.HumanDiff.cljs$lang$ctorStr = "fulcro-spec.renderer/HumanDiff";

fulcro_spec.renderer.HumanDiff.cljs$lang$ctorPrWriter = (function (this__35635__auto__,writer__35636__auto__,opt__35637__auto__){
return cljs.core._write.call(null,writer__35636__auto__,"fulcro-spec.renderer/HumanDiff");
});
fulcro_spec.renderer.ui_human_diff = om.next.factory.call(null,fulcro_spec.renderer.HumanDiff,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"keyfn","keyfn",780060332),(function (){
return cljs.core.gensym.call(null,"human-diff");
})], null));
if(typeof fulcro_spec.renderer.TestResult !== 'undefined'){
} else {
/**
 * @constructor
 */
fulcro_spec.renderer.TestResult = (function fulcro_spec$renderer$TestResult(){
var this__35632__auto__ = this;
React.Component.apply(this__35632__auto__,arguments);

if(!((this__35632__auto__.initLocalState == null))){
this__35632__auto__.state = this__35632__auto__.initLocalState();
} else {
this__35632__auto__.state = {};
}

return this__35632__auto__;
});

fulcro_spec.renderer.TestResult.prototype = goog.object.clone(React.Component.prototype);
}

var x48972_48984 = fulcro_spec.renderer.TestResult.prototype;
x48972_48984.componentWillUpdate = ((function (x48972_48984){
return (function (next_props__35520__auto__,next_state__35521__auto__){
var this__35519__auto__ = this;
if(((!((this__35519__auto__ == null)))?(((false) || ((cljs.core.PROTOCOL_SENTINEL === this__35519__auto__.om$next$Ident$)))?true:false):false)){
var ident__35523__auto___48985 = om.next.ident.call(null,this__35519__auto__,om.next.props.call(null,this__35519__auto__));
var next_ident__35524__auto___48986 = om.next.ident.call(null,this__35519__auto__,om.next._next_props.call(null,next_props__35520__auto__,this__35519__auto__));
if(cljs.core.not_EQ_.call(null,ident__35523__auto___48985,next_ident__35524__auto___48986)){
var idxr__35525__auto___48987 = cljs.core.get_in.call(null,om.next.get_reconciler.call(null,this__35519__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
if((idxr__35525__auto___48987 == null)){
} else {
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"indexes","indexes",1496475545).cljs$core$IFn$_invoke$arity$1(idxr__35525__auto___48987),((function (idxr__35525__auto___48987,ident__35523__auto___48985,next_ident__35524__auto___48986,this__35519__auto__,x48972_48984){
return (function (indexes__35526__auto__){
return cljs.core.update_in.call(null,cljs.core.update_in.call(null,indexes__35526__auto__,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ref->components","ref->components",-303587249),ident__35523__auto___48985], null),cljs.core.disj,this__35519__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ref->components","ref->components",-303587249),next_ident__35524__auto___48986], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentHashSet.EMPTY),this__35519__auto__);
});})(idxr__35525__auto___48987,ident__35523__auto___48985,next_ident__35524__auto___48986,this__35519__auto__,x48972_48984))
);
}
} else {
}
} else {
}

om.next.merge_pending_props_BANG_.call(null,this__35519__auto__);

return om.next.merge_pending_state_BANG_.call(null,this__35519__auto__);
});})(x48972_48984))
;

x48972_48984.shouldComponentUpdate = ((function (x48972_48984){
return (function (next_props__35520__auto__,next_state__35521__auto__){
var this__35519__auto__ = this;
var next_children__35522__auto__ = next_props__35520__auto__.children;
var next_props__35520__auto____$1 = goog.object.get(next_props__35520__auto__,"omcljs$value");
var next_props__35520__auto____$2 = (function (){var G__48974 = next_props__35520__auto____$1;
if((next_props__35520__auto____$1 instanceof om.next.OmProps)){
return om.next.unwrap.call(null,G__48974);
} else {
return G__48974;
}
})();
var or__28141__auto__ = cljs.core.not_EQ_.call(null,om.next.props.call(null,this__35519__auto__),next_props__35520__auto____$2);
if(or__28141__auto__){
return or__28141__auto__;
} else {
var or__28141__auto____$1 = (function (){var and__28129__auto__ = this__35519__auto__.state;
if(cljs.core.truth_(and__28129__auto__)){
return cljs.core.not_EQ_.call(null,goog.object.get(this__35519__auto__.state,"omcljs$state"),goog.object.get(next_state__35521__auto__,"omcljs$state"));
} else {
return and__28129__auto__;
}
})();
if(cljs.core.truth_(or__28141__auto____$1)){
return or__28141__auto____$1;
} else {
return cljs.core.not_EQ_.call(null,this__35519__auto__.props.children,next_children__35522__auto__);
}
}
});})(x48972_48984))
;

x48972_48984.componentWillUnmount = ((function (x48972_48984){
return (function (){
var this__35519__auto__ = this;
var r__35530__auto__ = om.next.get_reconciler.call(null,this__35519__auto__);
var cfg__35531__auto__ = new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(r__35530__auto__);
var st__35532__auto__ = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(cfg__35531__auto__);
var indexer__35529__auto__ = new cljs.core.Keyword(null,"indexer","indexer",-1774914315).cljs$core$IFn$_invoke$arity$1(cfg__35531__auto__);
if(cljs.core.truth_((function (){var and__28129__auto__ = !((st__35532__auto__ == null));
if(and__28129__auto__){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,st__35532__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("om.next","queries","om.next/queries",-22717146),this__35519__auto__], null));
} else {
return and__28129__auto__;
}
})())){
cljs.core.swap_BANG_.call(null,st__35532__auto__,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("om.next","queries","om.next/queries",-22717146)], null),cljs.core.dissoc,this__35519__auto__);
} else {
}

if((indexer__35529__auto__ == null)){
return null;
} else {
return om.next.protocols.drop_component_BANG_.call(null,indexer__35529__auto__,this__35519__auto__);
}
});})(x48972_48984))
;

x48972_48984.componentDidUpdate = ((function (x48972_48984){
return (function (prev_props__35527__auto__,prev_state__35528__auto__){
var this__35519__auto__ = this;
return om.next.clear_prev_props_BANG_.call(null,this__35519__auto__);
});})(x48972_48984))
;

x48972_48984.isMounted = ((function (x48972_48984){
return (function (){
var this__35519__auto__ = this;
return cljs.core.boolean$.call(null,goog.object.getValueByKeys(this__35519__auto__,"_reactInternalInstance","_renderedComponent"));
});})(x48972_48984))
;

x48972_48984.componentWillMount = ((function (x48972_48984){
return (function (){
var this__35519__auto__ = this;
var indexer__35529__auto__ = cljs.core.get_in.call(null,om.next.get_reconciler.call(null,this__35519__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
if((indexer__35529__auto__ == null)){
return null;
} else {
return om.next.protocols.index_component_BANG_.call(null,indexer__35529__auto__,this__35519__auto__);
}
});})(x48972_48984))
;

x48972_48984.render = ((function (x48972_48984){
return (function (){
var this__35518__auto__ = this;
var this$ = this__35518__auto__;
var _STAR_reconciler_STAR_48975 = om.next._STAR_reconciler_STAR_;
var _STAR_depth_STAR_48976 = om.next._STAR_depth_STAR_;
var _STAR_shared_STAR_48977 = om.next._STAR_shared_STAR_;
var _STAR_instrument_STAR_48978 = om.next._STAR_instrument_STAR_;
var _STAR_parent_STAR_48979 = om.next._STAR_parent_STAR_;
om.next._STAR_reconciler_STAR_ = om.next.get_reconciler.call(null,this__35518__auto__);

om.next._STAR_depth_STAR_ = (om.next.depth.call(null,this__35518__auto__) + (1));

om.next._STAR_shared_STAR_ = om.next.shared.call(null,this__35518__auto__);

om.next._STAR_instrument_STAR_ = om.next.instrument.call(null,this__35518__auto__);

om.next._STAR_parent_STAR_ = this__35518__auto__;

try{var map__48980 = om.next.props.call(null,this$);
var map__48980__$1 = ((((!((map__48980 == null)))?((((map__48980.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48980.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48980):map__48980);
var where = cljs.core.get.call(null,map__48980__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
var message = cljs.core.get.call(null,map__48980__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var extra = cljs.core.get.call(null,map__48980__$1,new cljs.core.Keyword(null,"extra","extra",1612569067));
var actual = cljs.core.get.call(null,map__48980__$1,new cljs.core.Keyword(null,"actual","actual",107306363));
var expected = cljs.core.get.call(null,map__48980__$1,new cljs.core.Keyword(null,"expected","expected",1583670997));
var stack = cljs.core.get.call(null,map__48980__$1,new cljs.core.Keyword(null,"stack","stack",-793405930));
var diff = cljs.core.get.call(null,map__48980__$1,new cljs.core.Keyword(null,"diff","diff",2135942783));
return om.dom.li.call(null,null,om.dom.table.call(null,null,om.dom.tbody.call(null,null,om.dom.tr.call(null,null,om.dom.td.call(null,({"className": "test-result-title"}),"Where: "),om.dom.td.call(null,({"className": "test-result"}),clojure.string.replace.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(where)].join(''),/G__\d+/,""))),(cljs.core.truth_(message)?fulcro_spec.renderer.ui_result_line.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"normal","normal",-1519123858),new cljs.core.Keyword(null,"title","title",636505583),"ASSERTION: ",new cljs.core.Keyword(null,"value","value",305978217),message], null)):null),fulcro_spec.renderer.ui_result_line.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"normal","normal",-1519123858),new cljs.core.Keyword(null,"title","title",636505583),"Actual: ",new cljs.core.Keyword(null,"value","value",305978217),actual,new cljs.core.Keyword(null,"stack","stack",-793405930),stack], null)),fulcro_spec.renderer.ui_result_line.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"normal","normal",-1519123858),new cljs.core.Keyword(null,"title","title",636505583),"Expected: ",new cljs.core.Keyword(null,"value","value",305978217),expected], null)),(cljs.core.truth_(extra)?fulcro_spec.renderer.ui_result_line.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"normal","normal",-1519123858),new cljs.core.Keyword(null,"title","title",636505583),"Message: ",new cljs.core.Keyword(null,"value","value",305978217),extra], null)):null),(cljs.core.truth_(diff)?fulcro_spec.renderer.ui_human_diff.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"actual","actual",107306363),actual,new cljs.core.Keyword(null,"diff","diff",2135942783),diff], null)):null))));
}finally {om.next._STAR_parent_STAR_ = _STAR_parent_STAR_48979;

om.next._STAR_instrument_STAR_ = _STAR_instrument_STAR_48978;

om.next._STAR_shared_STAR_ = _STAR_shared_STAR_48977;

om.next._STAR_depth_STAR_ = _STAR_depth_STAR_48976;

om.next._STAR_reconciler_STAR_ = _STAR_reconciler_STAR_48975;
}});})(x48972_48984))
;


fulcro_spec.renderer.TestResult.prototype.constructor = fulcro_spec.renderer.TestResult;

fulcro_spec.renderer.TestResult.prototype.constructor.displayName = "fulcro-spec.renderer/TestResult";

fulcro_spec.renderer.TestResult.prototype.om$isComponent = true;

var x48982_48988 = fulcro_spec.renderer.TestResult;


var x48983_48989 = fulcro_spec.renderer.TestResult.prototype;


fulcro_spec.renderer.TestResult.cljs$lang$type = true;

fulcro_spec.renderer.TestResult.cljs$lang$ctorStr = "fulcro-spec.renderer/TestResult";

fulcro_spec.renderer.TestResult.cljs$lang$ctorPrWriter = (function (this__35635__auto__,writer__35636__auto__,opt__35637__auto__){
return cljs.core._write.call(null,writer__35636__auto__,"fulcro-spec.renderer/TestResult");
});
fulcro_spec.renderer.ui_test_result = om.next.factory.call(null,fulcro_spec.renderer.TestResult,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"keyfn","keyfn",780060332),new cljs.core.Keyword(null,"id","id",-1388402092)], null));
if(typeof fulcro_spec.renderer.TestItem !== 'undefined'){
} else {
/**
 * @constructor
 */
fulcro_spec.renderer.TestItem = (function fulcro_spec$renderer$TestItem(){
var this__35632__auto__ = this;
React.Component.apply(this__35632__auto__,arguments);

if(!((this__35632__auto__.initLocalState == null))){
this__35632__auto__.state = this__35632__auto__.initLocalState();
} else {
this__35632__auto__.state = {};
}

return this__35632__auto__;
});

fulcro_spec.renderer.TestItem.prototype = goog.object.clone(React.Component.prototype);
}

var x48993_49005 = fulcro_spec.renderer.TestItem.prototype;
x48993_49005.componentWillUpdate = ((function (x48993_49005){
return (function (next_props__35520__auto__,next_state__35521__auto__){
var this__35519__auto__ = this;
if(((!((this__35519__auto__ == null)))?(((false) || ((cljs.core.PROTOCOL_SENTINEL === this__35519__auto__.om$next$Ident$)))?true:false):false)){
var ident__35523__auto___49006 = om.next.ident.call(null,this__35519__auto__,om.next.props.call(null,this__35519__auto__));
var next_ident__35524__auto___49007 = om.next.ident.call(null,this__35519__auto__,om.next._next_props.call(null,next_props__35520__auto__,this__35519__auto__));
if(cljs.core.not_EQ_.call(null,ident__35523__auto___49006,next_ident__35524__auto___49007)){
var idxr__35525__auto___49008 = cljs.core.get_in.call(null,om.next.get_reconciler.call(null,this__35519__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
if((idxr__35525__auto___49008 == null)){
} else {
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"indexes","indexes",1496475545).cljs$core$IFn$_invoke$arity$1(idxr__35525__auto___49008),((function (idxr__35525__auto___49008,ident__35523__auto___49006,next_ident__35524__auto___49007,this__35519__auto__,x48993_49005){
return (function (indexes__35526__auto__){
return cljs.core.update_in.call(null,cljs.core.update_in.call(null,indexes__35526__auto__,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ref->components","ref->components",-303587249),ident__35523__auto___49006], null),cljs.core.disj,this__35519__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ref->components","ref->components",-303587249),next_ident__35524__auto___49007], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentHashSet.EMPTY),this__35519__auto__);
});})(idxr__35525__auto___49008,ident__35523__auto___49006,next_ident__35524__auto___49007,this__35519__auto__,x48993_49005))
);
}
} else {
}
} else {
}

om.next.merge_pending_props_BANG_.call(null,this__35519__auto__);

return om.next.merge_pending_state_BANG_.call(null,this__35519__auto__);
});})(x48993_49005))
;

x48993_49005.shouldComponentUpdate = ((function (x48993_49005){
return (function (next_props__35520__auto__,next_state__35521__auto__){
var this__35519__auto__ = this;
var next_children__35522__auto__ = next_props__35520__auto__.children;
var next_props__35520__auto____$1 = goog.object.get(next_props__35520__auto__,"omcljs$value");
var next_props__35520__auto____$2 = (function (){var G__48995 = next_props__35520__auto____$1;
if((next_props__35520__auto____$1 instanceof om.next.OmProps)){
return om.next.unwrap.call(null,G__48995);
} else {
return G__48995;
}
})();
var or__28141__auto__ = cljs.core.not_EQ_.call(null,om.next.props.call(null,this__35519__auto__),next_props__35520__auto____$2);
if(or__28141__auto__){
return or__28141__auto__;
} else {
var or__28141__auto____$1 = (function (){var and__28129__auto__ = this__35519__auto__.state;
if(cljs.core.truth_(and__28129__auto__)){
return cljs.core.not_EQ_.call(null,goog.object.get(this__35519__auto__.state,"omcljs$state"),goog.object.get(next_state__35521__auto__,"omcljs$state"));
} else {
return and__28129__auto__;
}
})();
if(cljs.core.truth_(or__28141__auto____$1)){
return or__28141__auto____$1;
} else {
return cljs.core.not_EQ_.call(null,this__35519__auto__.props.children,next_children__35522__auto__);
}
}
});})(x48993_49005))
;

x48993_49005.componentWillUnmount = ((function (x48993_49005){
return (function (){
var this__35519__auto__ = this;
var r__35530__auto__ = om.next.get_reconciler.call(null,this__35519__auto__);
var cfg__35531__auto__ = new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(r__35530__auto__);
var st__35532__auto__ = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(cfg__35531__auto__);
var indexer__35529__auto__ = new cljs.core.Keyword(null,"indexer","indexer",-1774914315).cljs$core$IFn$_invoke$arity$1(cfg__35531__auto__);
if(cljs.core.truth_((function (){var and__28129__auto__ = !((st__35532__auto__ == null));
if(and__28129__auto__){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,st__35532__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("om.next","queries","om.next/queries",-22717146),this__35519__auto__], null));
} else {
return and__28129__auto__;
}
})())){
cljs.core.swap_BANG_.call(null,st__35532__auto__,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("om.next","queries","om.next/queries",-22717146)], null),cljs.core.dissoc,this__35519__auto__);
} else {
}

if((indexer__35529__auto__ == null)){
return null;
} else {
return om.next.protocols.drop_component_BANG_.call(null,indexer__35529__auto__,this__35519__auto__);
}
});})(x48993_49005))
;

x48993_49005.componentDidUpdate = ((function (x48993_49005){
return (function (prev_props__35527__auto__,prev_state__35528__auto__){
var this__35519__auto__ = this;
return om.next.clear_prev_props_BANG_.call(null,this__35519__auto__);
});})(x48993_49005))
;

x48993_49005.isMounted = ((function (x48993_49005){
return (function (){
var this__35519__auto__ = this;
return cljs.core.boolean$.call(null,goog.object.getValueByKeys(this__35519__auto__,"_reactInternalInstance","_renderedComponent"));
});})(x48993_49005))
;

x48993_49005.componentWillMount = ((function (x48993_49005){
return (function (){
var this__35519__auto__ = this;
var indexer__35529__auto__ = cljs.core.get_in.call(null,om.next.get_reconciler.call(null,this__35519__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
if((indexer__35529__auto__ == null)){
return null;
} else {
return om.next.protocols.index_component_BANG_.call(null,indexer__35529__auto__,this__35519__auto__);
}
});})(x48993_49005))
;

x48993_49005.render = ((function (x48993_49005){
return (function (){
var this__35518__auto__ = this;
var this$ = this__35518__auto__;
var _STAR_reconciler_STAR_48996 = om.next._STAR_reconciler_STAR_;
var _STAR_depth_STAR_48997 = om.next._STAR_depth_STAR_;
var _STAR_shared_STAR_48998 = om.next._STAR_shared_STAR_;
var _STAR_instrument_STAR_48999 = om.next._STAR_instrument_STAR_;
var _STAR_parent_STAR_49000 = om.next._STAR_parent_STAR_;
om.next._STAR_reconciler_STAR_ = om.next.get_reconciler.call(null,this__35518__auto__);

om.next._STAR_depth_STAR_ = (om.next.depth.call(null,this__35518__auto__) + (1));

om.next._STAR_shared_STAR_ = om.next.shared.call(null,this__35518__auto__);

om.next._STAR_instrument_STAR_ = om.next.instrument.call(null,this__35518__auto__);

om.next._STAR_parent_STAR_ = this__35518__auto__;

try{var map__49001 = om.next.props.call(null,this$);
var map__49001__$1 = ((((!((map__49001 == null)))?((((map__49001.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__49001.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49001):map__49001);
var test_item_data = map__49001__$1;
var id = cljs.core.get.call(null,map__49001__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var current_filter = cljs.core.get.call(null,map__49001__$1,new cljs.core.Keyword(null,"current-filter","current-filter",1519815247));
return om.dom.li.call(null,({"className": "test-item"}),om.dom.div.call(null,null,om.dom.span.call(null,({"className": fulcro_spec.renderer.test_item_class.call(null,new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(test_item_data))}),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(test_item_data)),om.dom.ul.call(null,({"className": "test-list"}),cljs.core.mapv.call(null,fulcro_spec.renderer.ui_test_result,new cljs.core.Keyword(null,"test-results","test-results",575566942).cljs$core$IFn$_invoke$arity$1(test_item_data))),om.dom.ul.call(null,({"className": "test-list"}),cljs.core.sequence.call(null,cljs.core.comp.call(null,fulcro_spec.renderer.filters.call(null,current_filter),cljs.core.map.call(null,((function (map__49001,map__49001__$1,test_item_data,id,current_filter,_STAR_reconciler_STAR_48996,_STAR_depth_STAR_48997,_STAR_shared_STAR_48998,_STAR_instrument_STAR_48999,_STAR_parent_STAR_49000,this$,this__35518__auto__,x48993_49005){
return (function (p1__48990_SHARP_){
return cljs.core.assoc.call(null,p1__48990_SHARP_,new cljs.core.Keyword(null,"current-filter","current-filter",1519815247),current_filter);
});})(map__49001,map__49001__$1,test_item_data,id,current_filter,_STAR_reconciler_STAR_48996,_STAR_depth_STAR_48997,_STAR_shared_STAR_48998,_STAR_instrument_STAR_48999,_STAR_parent_STAR_49000,this$,this__35518__auto__,x48993_49005))
),cljs.core.map.call(null,fulcro_spec.renderer.ui_test_item)),new cljs.core.Keyword(null,"test-items","test-items",1900391985).cljs$core$IFn$_invoke$arity$1(test_item_data)))));
}finally {om.next._STAR_parent_STAR_ = _STAR_parent_STAR_49000;

om.next._STAR_instrument_STAR_ = _STAR_instrument_STAR_48999;

om.next._STAR_shared_STAR_ = _STAR_shared_STAR_48998;

om.next._STAR_depth_STAR_ = _STAR_depth_STAR_48997;

om.next._STAR_reconciler_STAR_ = _STAR_reconciler_STAR_48996;
}});})(x48993_49005))
;


fulcro_spec.renderer.TestItem.prototype.constructor = fulcro_spec.renderer.TestItem;

fulcro_spec.renderer.TestItem.prototype.constructor.displayName = "fulcro-spec.renderer/TestItem";

fulcro_spec.renderer.TestItem.prototype.om$isComponent = true;

var x49003_49009 = fulcro_spec.renderer.TestItem;


var x49004_49010 = fulcro_spec.renderer.TestItem.prototype;


fulcro_spec.renderer.TestItem.cljs$lang$type = true;

fulcro_spec.renderer.TestItem.cljs$lang$ctorStr = "fulcro-spec.renderer/TestItem";

fulcro_spec.renderer.TestItem.cljs$lang$ctorPrWriter = (function (this__35635__auto__,writer__35636__auto__,opt__35637__auto__){
return cljs.core._write.call(null,writer__35636__auto__,"fulcro-spec.renderer/TestItem");
});
fulcro_spec.renderer.ui_test_item = om.next.factory.call(null,fulcro_spec.renderer.TestItem,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"keyfn","keyfn",780060332),new cljs.core.Keyword(null,"id","id",-1388402092)], null));
if(typeof fulcro_spec.renderer.TestNamespace !== 'undefined'){
} else {
/**
 * @constructor
 */
fulcro_spec.renderer.TestNamespace = (function fulcro_spec$renderer$TestNamespace(){
var this__35632__auto__ = this;
React.Component.apply(this__35632__auto__,arguments);

if(!((this__35632__auto__.initLocalState == null))){
this__35632__auto__.state = this__35632__auto__.initLocalState();
} else {
this__35632__auto__.state = {};
}

return this__35632__auto__;
});

fulcro_spec.renderer.TestNamespace.prototype = goog.object.clone(React.Component.prototype);
}

var x49014_49026 = fulcro_spec.renderer.TestNamespace.prototype;
x49014_49026.componentWillUpdate = ((function (x49014_49026){
return (function (next_props__35520__auto__,next_state__35521__auto__){
var this__35519__auto__ = this;
if(((!((this__35519__auto__ == null)))?(((false) || ((cljs.core.PROTOCOL_SENTINEL === this__35519__auto__.om$next$Ident$)))?true:false):false)){
var ident__35523__auto___49027 = om.next.ident.call(null,this__35519__auto__,om.next.props.call(null,this__35519__auto__));
var next_ident__35524__auto___49028 = om.next.ident.call(null,this__35519__auto__,om.next._next_props.call(null,next_props__35520__auto__,this__35519__auto__));
if(cljs.core.not_EQ_.call(null,ident__35523__auto___49027,next_ident__35524__auto___49028)){
var idxr__35525__auto___49029 = cljs.core.get_in.call(null,om.next.get_reconciler.call(null,this__35519__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
if((idxr__35525__auto___49029 == null)){
} else {
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"indexes","indexes",1496475545).cljs$core$IFn$_invoke$arity$1(idxr__35525__auto___49029),((function (idxr__35525__auto___49029,ident__35523__auto___49027,next_ident__35524__auto___49028,this__35519__auto__,x49014_49026){
return (function (indexes__35526__auto__){
return cljs.core.update_in.call(null,cljs.core.update_in.call(null,indexes__35526__auto__,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ref->components","ref->components",-303587249),ident__35523__auto___49027], null),cljs.core.disj,this__35519__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ref->components","ref->components",-303587249),next_ident__35524__auto___49028], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentHashSet.EMPTY),this__35519__auto__);
});})(idxr__35525__auto___49029,ident__35523__auto___49027,next_ident__35524__auto___49028,this__35519__auto__,x49014_49026))
);
}
} else {
}
} else {
}

om.next.merge_pending_props_BANG_.call(null,this__35519__auto__);

return om.next.merge_pending_state_BANG_.call(null,this__35519__auto__);
});})(x49014_49026))
;

x49014_49026.shouldComponentUpdate = ((function (x49014_49026){
return (function (next_props__35520__auto__,next_state__35521__auto__){
var this__35519__auto__ = this;
var next_children__35522__auto__ = next_props__35520__auto__.children;
var next_props__35520__auto____$1 = goog.object.get(next_props__35520__auto__,"omcljs$value");
var next_props__35520__auto____$2 = (function (){var G__49016 = next_props__35520__auto____$1;
if((next_props__35520__auto____$1 instanceof om.next.OmProps)){
return om.next.unwrap.call(null,G__49016);
} else {
return G__49016;
}
})();
var or__28141__auto__ = cljs.core.not_EQ_.call(null,om.next.props.call(null,this__35519__auto__),next_props__35520__auto____$2);
if(or__28141__auto__){
return or__28141__auto__;
} else {
var or__28141__auto____$1 = (function (){var and__28129__auto__ = this__35519__auto__.state;
if(cljs.core.truth_(and__28129__auto__)){
return cljs.core.not_EQ_.call(null,goog.object.get(this__35519__auto__.state,"omcljs$state"),goog.object.get(next_state__35521__auto__,"omcljs$state"));
} else {
return and__28129__auto__;
}
})();
if(cljs.core.truth_(or__28141__auto____$1)){
return or__28141__auto____$1;
} else {
return cljs.core.not_EQ_.call(null,this__35519__auto__.props.children,next_children__35522__auto__);
}
}
});})(x49014_49026))
;

x49014_49026.componentWillUnmount = ((function (x49014_49026){
return (function (){
var this__35519__auto__ = this;
var r__35530__auto__ = om.next.get_reconciler.call(null,this__35519__auto__);
var cfg__35531__auto__ = new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(r__35530__auto__);
var st__35532__auto__ = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(cfg__35531__auto__);
var indexer__35529__auto__ = new cljs.core.Keyword(null,"indexer","indexer",-1774914315).cljs$core$IFn$_invoke$arity$1(cfg__35531__auto__);
if(cljs.core.truth_((function (){var and__28129__auto__ = !((st__35532__auto__ == null));
if(and__28129__auto__){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,st__35532__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("om.next","queries","om.next/queries",-22717146),this__35519__auto__], null));
} else {
return and__28129__auto__;
}
})())){
cljs.core.swap_BANG_.call(null,st__35532__auto__,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("om.next","queries","om.next/queries",-22717146)], null),cljs.core.dissoc,this__35519__auto__);
} else {
}

if((indexer__35529__auto__ == null)){
return null;
} else {
return om.next.protocols.drop_component_BANG_.call(null,indexer__35529__auto__,this__35519__auto__);
}
});})(x49014_49026))
;

x49014_49026.componentDidUpdate = ((function (x49014_49026){
return (function (prev_props__35527__auto__,prev_state__35528__auto__){
var this__35519__auto__ = this;
return om.next.clear_prev_props_BANG_.call(null,this__35519__auto__);
});})(x49014_49026))
;

x49014_49026.isMounted = ((function (x49014_49026){
return (function (){
var this__35519__auto__ = this;
return cljs.core.boolean$.call(null,goog.object.getValueByKeys(this__35519__auto__,"_reactInternalInstance","_renderedComponent"));
});})(x49014_49026))
;

x49014_49026.componentWillMount = ((function (x49014_49026){
return (function (){
var this__35519__auto__ = this;
var indexer__35529__auto__ = cljs.core.get_in.call(null,om.next.get_reconciler.call(null,this__35519__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
if((indexer__35529__auto__ == null)){
return null;
} else {
return om.next.protocols.index_component_BANG_.call(null,indexer__35529__auto__,this__35519__auto__);
}
});})(x49014_49026))
;

x49014_49026.render = ((function (x49014_49026){
return (function (){
var this__35518__auto__ = this;
var this$ = this__35518__auto__;
var _STAR_reconciler_STAR_49017 = om.next._STAR_reconciler_STAR_;
var _STAR_depth_STAR_49018 = om.next._STAR_depth_STAR_;
var _STAR_shared_STAR_49019 = om.next._STAR_shared_STAR_;
var _STAR_instrument_STAR_49020 = om.next._STAR_instrument_STAR_;
var _STAR_parent_STAR_49021 = om.next._STAR_parent_STAR_;
om.next._STAR_reconciler_STAR_ = om.next.get_reconciler.call(null,this__35518__auto__);

om.next._STAR_depth_STAR_ = (om.next.depth.call(null,this__35518__auto__) + (1));

om.next._STAR_shared_STAR_ = om.next.shared.call(null,this__35518__auto__);

om.next._STAR_instrument_STAR_ = om.next.instrument.call(null,this__35518__auto__);

om.next._STAR_parent_STAR_ = this__35518__auto__;

try{var map__49022 = om.next.props.call(null,this$);
var map__49022__$1 = ((((!((map__49022 == null)))?((((map__49022.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__49022.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49022):map__49022);
var tests_by_namespace = map__49022__$1;
var current_filter = cljs.core.get.call(null,map__49022__$1,new cljs.core.Keyword(null,"current-filter","current-filter",1519815247));
if(cljs.core.seq.call(null,new cljs.core.Keyword(null,"test-items","test-items",1900391985).cljs$core$IFn$_invoke$arity$1(tests_by_namespace))){
return om.dom.li.call(null,({"className": "test-item"}),om.dom.div.call(null,({"className": "test-namespace"}),om.dom.h2.call(null,({"className": fulcro_spec.renderer.test_item_class.call(null,new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(tests_by_namespace))}),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(tests_by_namespace))].join('')),om.dom.ul.call(null,({"className": "test-list"}),cljs.core.sequence.call(null,cljs.core.comp.call(null,fulcro_spec.renderer.filters.call(null,current_filter),cljs.core.map.call(null,((function (map__49022,map__49022__$1,tests_by_namespace,current_filter,_STAR_reconciler_STAR_49017,_STAR_depth_STAR_49018,_STAR_shared_STAR_49019,_STAR_instrument_STAR_49020,_STAR_parent_STAR_49021,this$,this__35518__auto__,x49014_49026){
return (function (p1__49011_SHARP_){
return cljs.core.assoc.call(null,p1__49011_SHARP_,new cljs.core.Keyword(null,"current-filter","current-filter",1519815247),current_filter);
});})(map__49022,map__49022__$1,tests_by_namespace,current_filter,_STAR_reconciler_STAR_49017,_STAR_depth_STAR_49018,_STAR_shared_STAR_49019,_STAR_instrument_STAR_49020,_STAR_parent_STAR_49021,this$,this__35518__auto__,x49014_49026))
),cljs.core.map.call(null,fulcro_spec.renderer.ui_test_item)),cljs.core.sort_by.call(null,cljs.core.comp.call(null,new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"form-meta","form-meta",-352800224)),new cljs.core.Keyword(null,"test-items","test-items",1900391985).cljs$core$IFn$_invoke$arity$1(tests_by_namespace))))));
} else {
return null;
}
}finally {om.next._STAR_parent_STAR_ = _STAR_parent_STAR_49021;

om.next._STAR_instrument_STAR_ = _STAR_instrument_STAR_49020;

om.next._STAR_shared_STAR_ = _STAR_shared_STAR_49019;

om.next._STAR_depth_STAR_ = _STAR_depth_STAR_49018;

om.next._STAR_reconciler_STAR_ = _STAR_reconciler_STAR_49017;
}});})(x49014_49026))
;


fulcro_spec.renderer.TestNamespace.prototype.constructor = fulcro_spec.renderer.TestNamespace;

fulcro_spec.renderer.TestNamespace.prototype.constructor.displayName = "fulcro-spec.renderer/TestNamespace";

fulcro_spec.renderer.TestNamespace.prototype.om$isComponent = true;

var x49024_49030 = fulcro_spec.renderer.TestNamespace;


var x49025_49031 = fulcro_spec.renderer.TestNamespace.prototype;


fulcro_spec.renderer.TestNamespace.cljs$lang$type = true;

fulcro_spec.renderer.TestNamespace.cljs$lang$ctorStr = "fulcro-spec.renderer/TestNamespace";

fulcro_spec.renderer.TestNamespace.cljs$lang$ctorPrWriter = (function (this__35635__auto__,writer__35636__auto__,opt__35637__auto__){
return cljs.core._write.call(null,writer__35636__auto__,"fulcro-spec.renderer/TestNamespace");
});
fulcro_spec.renderer.ui_test_namespace = om.next.factory.call(null,fulcro_spec.renderer.TestNamespace,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"keyfn","keyfn",780060332),new cljs.core.Keyword(null,"name","name",1843675177)], null));
fulcro_spec.renderer.material_icon_paths = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"check","check",1226308904),new cljs.core.Keyword(null,"update","update",1045576396),new cljs.core.Keyword(null,"pan_tool","pan_tool",-306611187),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"access_time","access_time",-1820282641),new cljs.core.Keyword(null,"warning","warning",-1685650671),new cljs.core.Keyword(null,"assignment","assignment",1330426519),new cljs.core.Keyword(null,"help","help",-439233446),new cljs.core.Keyword(null,"hourglass_empty","hourglass_empty",141670077),new cljs.core.Keyword(null,"menu","menu",352255198)],["M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41z","M21 10.12h-6.78l2.74-2.82c-2.73-2.7-7.15-2.8-9.88-.1-2.73 2.71-2.73 7.08 0 9.79 2.73 2.71 7.15 2.71 9.88 0C18.32 15.65 19 14.08 19 12.1h2c0 1.98-.88 4.55-2.64 6.29-3.51 3.48-9.21 3.48-12.72 0-3.5-3.47-3.53-9.11-.02-12.58 3.51-3.47 9.14-3.47 12.65 0L21 3v7.12zM12.5 8v4.25l3.5 2.08-.72 1.21L11 13V8h1.5z","M23 5.5V20c0 2.2-1.8 4-4 4h-7.3c-1.08 0-2.1-.43-2.85-1.19L1 14.83s1.26-1.23 1.3-1.25c.22-.19.49-.29.79-.29.22 0 .42.06.6.16.04.01 4.31 2.46 4.31 2.46V4c0-.83.67-1.5 1.5-1.5S11 3.17 11 4v7h1V1.5c0-.83.67-1.5 1.5-1.5S15 .67 15 1.5V11h1V2.5c0-.83.67-1.5 1.5-1.5s1.5.67 1.5 1.5V11h1V5.5c0-.83.67-1.5 1.5-1.5s1.5.67 1.5 1.5z","M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12z","M11.99 2C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2zM12 20c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8zm.5-13H11v6l5.25 3.15.75-1.23-4.5-2.67z","M1 21h22L12 2 1 21zm12-3h-2v-2h2v2zm0-4h-2v-4h2v4z","M19 3h-4.18C14.4 1.84 13.3 1 12 1c-1.3 0-2.4.84-2.82 2H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-7 0c.55 0 1 .45 1 1s-.45 1-1 1-1-.45-1-1 .45-1 1-1zm2 14H7v-2h7v2zm3-4H7v-2h10v2zm0-4H7V7h10v2z","M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 17h-2v-2h2v2zm2.07-7.75l-.9.92C13.45 12.9 13 13.5 13 15h-2v-.5c0-1.1.45-2.1 1.17-2.83l1.24-1.26c.37-.36.59-.86.59-1.41 0-1.1-.9-2-2-2s-2 .9-2 2H8c0-2.21 1.79-4 4-4s4 1.79 4 4c0 .88-.36 1.68-.93 2.25z","M6 2v6h.01L6 8.01 10 12l-4 4 .01.01H6V22h12v-5.99h-.01L18 16l-4-4 4-3.99-.01-.01H18V2H6zm10 14.5V20H8v-3.5l4-4 4 4zm-4-5l-4-4V4h8v3.5l-4 4z","M3 18h18v-2H3v2zm0-5h18v-2H3v2zm0-7v2h18V6H3z"]);
fulcro_spec.renderer.state_mods = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"is","is",369128998),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 16, [new cljs.core.Keyword(null,"open","open",-1763596448),null,new cljs.core.Keyword(null,"informative","informative",1852560673),null,new cljs.core.Keyword(null,"collapsed","collapsed",-628494523),null,new cljs.core.Keyword(null,"disabled","disabled",-1529784218),null,new cljs.core.Keyword(null,"neutral","neutral",-1941956087),null,new cljs.core.Keyword(null,"positive","positive",1112941866),null,new cljs.core.Keyword(null,"negative","negative",-1562068438),null,new cljs.core.Keyword(null,"featured","featured",1584623723),null,new cljs.core.Keyword(null,"invalid","invalid",412869516),null,new cljs.core.Keyword(null,"passive","passive",252884080),null,new cljs.core.Keyword(null,"indeterminate","indeterminate",-513040976),null,new cljs.core.Keyword(null,"alterable","alterable",1971374420),null,new cljs.core.Keyword(null,"active","active",1895962068),null,new cljs.core.Keyword(null,"optional","optional",2053951509),null,new cljs.core.Keyword(null,"error","error",-978969032),null,new cljs.core.Keyword(null,"live","live",-1610148039),null], null), null),new cljs.core.Keyword(null,"has","has",1466247447),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"descendents","descendents",-2087093947),null,new cljs.core.Keyword(null,"actions","actions",-812656882),null,new cljs.core.Keyword(null,"focus","focus",234677911),null], null), null)], null);
/**
 * `fragments` is a collection of fragmentsto concatinate.
 */
fulcro_spec.renderer.concat_class_string = (function fulcro_spec$renderer$concat_class_string(var_args){
var G__49033 = arguments.length;
switch (G__49033) {
case 1:
return fulcro_spec.renderer.concat_class_string.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fulcro_spec.renderer.concat_class_string.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fulcro_spec.renderer.concat_class_string.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fulcro_spec.renderer.concat_class_string.cljs$core$IFn$_invoke$arity$1 = (function (fragments){
return fulcro_spec.renderer.concat_class_string.call(null,"","",fragments);
});

fulcro_spec.renderer.concat_class_string.cljs$core$IFn$_invoke$arity$2 = (function (type,fragments){
return fulcro_spec.renderer.concat_class_string.call(null,"",type,fragments);
});

fulcro_spec.renderer.concat_class_string.cljs$core$IFn$_invoke$arity$3 = (function (base_str,type,fragments){
return cljs.core.reduce.call(null,(function (acc,n){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(acc)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(base_str),cljs.core.str.cljs$core$IFn$_invoke$arity$1(type),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,n))].join(''))].join('');
}),base_str,fragments);
});

fulcro_spec.renderer.concat_class_string.cljs$lang$maxFixedArity = 3;

fulcro_spec.renderer.concat_state_string = (function fulcro_spec$renderer$concat_state_string(states){
return cljs.core.reduce.call(null,(function (acc,n){
var middle = (cljs.core.truth_(cljs.core.not_empty.call(null,acc))?" ":null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"is","is",369128998).cljs$core$IFn$_invoke$arity$1(fulcro_spec.renderer.state_mods).call(null,n))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(acc),cljs.core.str.cljs$core$IFn$_invoke$arity$1(middle),cljs.core.str.cljs$core$IFn$_invoke$arity$1(["is-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,n))].join(''))].join('');
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"has","has",1466247447).cljs$core$IFn$_invoke$arity$1(fulcro_spec.renderer.state_mods).call(null,n))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(acc),cljs.core.str.cljs$core$IFn$_invoke$arity$1(middle),cljs.core.str.cljs$core$IFn$_invoke$arity$1(["has-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,n))].join(''))].join('');
} else {
return acc;

}
}
}),"",states);
});
/**
 * Capitalize every word in a string
 */
fulcro_spec.renderer.title_case = (function fulcro_spec$renderer$title_case(s){
return clojure.string.join.call(null,cljs.core.map.call(null,clojure.string.capitalize,clojure.string.split.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(s)].join(''),/\b/)));
});
fulcro_spec.renderer.icon = (function fulcro_spec$renderer$icon(var_args){
var args__29319__auto__ = [];
var len__29312__auto___49041 = arguments.length;
var i__29313__auto___49042 = (0);
while(true){
if((i__29313__auto___49042 < len__29312__auto___49041)){
args__29319__auto__.push((arguments[i__29313__auto___49042]));

var G__49043 = (i__29313__auto___49042 + (1));
i__29313__auto___49042 = G__49043;
continue;
} else {
}
break;
}

var argseq__29320__auto__ = ((((1) < args__29319__auto__.length))?(new cljs.core.IndexedSeq(args__29319__auto__.slice((1)),(0),null)):null);
return fulcro_spec.renderer.icon.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29320__auto__);
});

fulcro_spec.renderer.icon.cljs$core$IFn$_invoke$arity$variadic = (function (icon_path,p__49037){
var map__49038 = p__49037;
var map__49038__$1 = ((((!((map__49038 == null)))?((((map__49038.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__49038.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49038):map__49038);
var width = cljs.core.get.call(null,map__49038__$1,new cljs.core.Keyword(null,"width","width",-384071477));
var height = cljs.core.get.call(null,map__49038__$1,new cljs.core.Keyword(null,"height","height",1025178622));
var modifiers = cljs.core.get.call(null,map__49038__$1,new cljs.core.Keyword(null,"modifiers","modifiers",50378834));
var states = cljs.core.get.call(null,map__49038__$1,new cljs.core.Keyword(null,"states","states",1389013542));
var className = cljs.core.get.call(null,map__49038__$1,new cljs.core.Keyword(null,"className","className",-1983287057));
var onClick = cljs.core.get.call(null,map__49038__$1,new cljs.core.Keyword(null,"onClick","onClick",-1991238530));
if((icon_path instanceof cljs.core.Keyword)){
} else {
throw (new Error(["Assert failed: ","Must pass a :key","\n","(keyword? icon-path)"].join('')));
}

var add_class = ((function (map__49038,map__49038__$1,width,height,modifiers,states,className,onClick){
return (function (attrs){
return null;
});})(map__49038,map__49038__$1,width,height,modifiers,states,className,onClick))
;
var path_check = icon_path.call(null,fulcro_spec.renderer.material_icon_paths);
var icon_name = clojure.string.replace.call(null,cljs.core.name.call(null,icon_path),/_/,"-");
if(clojure.string.blank_QMARK_.call(null,path_check)){
return null;
} else {
return om.dom.svg.call(null,cljs.core.clj__GT_js.call(null,(function (){var G__49040 = new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"className","className",-1983287057),clojure.string.join.call(null," ",new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [fulcro_spec.renderer.concat_class_string.call(null,"c-icon","--",modifiers),["c-icon--",cljs.core.str.cljs$core$IFn$_invoke$arity$1(icon_name)].join(''),fulcro_spec.renderer.concat_state_string.call(null,states),fulcro_spec.renderer.concat_class_string.call(null,className)], null)),new cljs.core.Keyword(null,"version","version",425292698),"1.1",new cljs.core.Keyword(null,"xmlns","xmlns",-1862095571),"http://www.w3.org/2000/svg",new cljs.core.Keyword(null,"width","width",-384071477),"24",new cljs.core.Keyword(null,"height","height",1025178622),"24",new cljs.core.Keyword(null,"aria-labelledby","aria-labelledby",1817118667),"title",new cljs.core.Keyword(null,"role","role",-736691072),"img",new cljs.core.Keyword(null,"viewBox","viewBox",-469489477),"0 0 24 24"], null);
if(cljs.core.truth_(onClick)){
return cljs.core.assoc.call(null,G__49040,new cljs.core.Keyword(null,"onClick","onClick",-1991238530),((function (G__49040,add_class,path_check,icon_name,map__49038,map__49038__$1,width,height,modifiers,states,className,onClick){
return (function (){
return onClick.call(null);
});})(G__49040,add_class,path_check,icon_name,map__49038,map__49038__$1,width,height,modifiers,states,className,onClick))
);
} else {
return G__49040;
}
})()),om.dom.title.call(null,null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(fulcro_spec.renderer.title_case.call(null,clojure.string.replace.call(null,cljs.core.name.call(null,icon_path),/_/," ")))].join('')),om.dom.path.call(null,({"d": path_check})));
}
});

fulcro_spec.renderer.icon.cljs$lang$maxFixedArity = (1);

fulcro_spec.renderer.icon.cljs$lang$applyTo = (function (seq49035){
var G__49036 = cljs.core.first.call(null,seq49035);
var seq49035__$1 = cljs.core.next.call(null,seq49035);
return fulcro_spec.renderer.icon.cljs$core$IFn$_invoke$arity$variadic(G__49036,seq49035__$1);
});

fulcro_spec.renderer.filter_button = (function fulcro_spec$renderer$filter_button(var_args){
var G__49045 = arguments.length;
switch (G__49045) {
case 2:
return fulcro_spec.renderer.filter_button.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 5:
return fulcro_spec.renderer.filter_button.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fulcro_spec.renderer.filter_button.cljs$core$IFn$_invoke$arity$2 = (function (icon_type,data){
return fulcro_spec.renderer.filter_button.call(null,icon_type,data,cljs.core.gensym.call(null),cljs.core.gensym.call(null),cljs.core.constantly.call(null,null));
});

fulcro_spec.renderer.filter_button.cljs$core$IFn$_invoke$arity$5 = (function (icon_type,data,this_filter,current_filter,toggle_filter_cb){
var is_active_QMARK_ = cljs.core._EQ_.call(null,this_filter,current_filter);
return om.dom.button.call(null,({"className": "c-button c-button--icon", "onClick": toggle_filter_cb.call(null,this_filter)}),fulcro_spec.renderer.icon.call(null,icon_type,new cljs.core.Keyword(null,"states","states",1389013542),(function (){var G__49046 = cljs.core.PersistentVector.EMPTY;
if(is_active_QMARK_){
return cljs.core.conj.call(null,G__49046,new cljs.core.Keyword(null,"active","active",1895962068));
} else {
return G__49046;
}
})()),om.dom.span.call(null,({"className": (function (){var G__49047 = "c-message";
if(is_active_QMARK_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__49047)," c-message--primary"].join('');
} else {
return G__49047;
}
})()}),data));
});

fulcro_spec.renderer.filter_button.cljs$lang$maxFixedArity = 5;

fulcro_spec.renderer.find_tests = (function fulcro_spec$renderer$find_tests(test_filter,namespaces){
return cljs.core.remove.call(null,cljs.core.some_fn.call(null,cljs.core.nil_QMARK_,cljs.core.comp.call(null,cljs.core.seq,new cljs.core.Keyword(null,"test-items","test-items",1900391985))),cljs.core.apply.call(null,cljs.core.tree_seq,cljs.core.comp.call(null,cljs.core.seq,new cljs.core.Keyword(null,"test-items","test-items",1900391985)),cljs.core.comp.call(null,cljs.core.partial.call(null,cljs.core.sequence,fulcro_spec.renderer.filters.call(null,test_filter)),new cljs.core.Keyword(null,"test-items","test-items",1900391985)),cljs.core.sequence.call(null,fulcro_spec.renderer.filters.call(null,test_filter),namespaces)));
});
fulcro_spec.renderer.test_info = (function fulcro_spec$renderer$test_info(p__49049,current_filter,toggle_filter_cb){
var map__49050 = p__49049;
var map__49050__$1 = ((((!((map__49050 == null)))?((((map__49050.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__49050.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49050):map__49050);
var pass = cljs.core.get.call(null,map__49050__$1,new cljs.core.Keyword(null,"pass","pass",1574159993));
var fail = cljs.core.get.call(null,map__49050__$1,new cljs.core.Keyword(null,"fail","fail",1706214930));
var error = cljs.core.get.call(null,map__49050__$1,new cljs.core.Keyword(null,"error","error",-978969032));
var namespaces = cljs.core.get.call(null,map__49050__$1,new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469));
var end_time = cljs.core.get.call(null,map__49050__$1,new cljs.core.Keyword(null,"end-time","end-time",-1849817460));
var run_time = cljs.core.get.call(null,map__49050__$1,new cljs.core.Keyword(null,"run-time","run-time",-1231674133));
var total = ((pass + fail) + error);
var end_time__$1 = (new goog.i18n.DateTimeFormat("HH:mm:ss")).format((function (){var or__28141__auto__ = (function (){var and__28129__auto__ = end_time;
if(cljs.core.truth_(and__28129__auto__)){
return (new goog.date.DateTime()).setTime(end_time);
} else {
return and__28129__auto__;
}
})();
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
return (new goog.date.DateTime());
}
})());
var run_time__$1 = clojure.string.replace_first.call(null,goog.string.format("%.3fs",(run_time / (1000))),/^0/,"");
if(((fail + error) > (0))){
fulcro_spec.renderer.change_favicon_to_color.call(null,"#d00");
} else {
fulcro_spec.renderer.change_favicon_to_color.call(null,"#0d0");
}

return om.dom.span.call(null,null,fulcro_spec.renderer.filter_button.call(null,new cljs.core.Keyword(null,"assignment","assignment",1330426519),cljs.core.count.call(null,namespaces)),fulcro_spec.renderer.filter_button.call(null,new cljs.core.Keyword(null,"help","help",-439233446),total),fulcro_spec.renderer.filter_button.call(null,new cljs.core.Keyword(null,"check","check",1226308904),pass,new cljs.core.Keyword(null,"passing","passing",154799600),current_filter,toggle_filter_cb),fulcro_spec.renderer.filter_button.call(null,new cljs.core.Keyword(null,"update","update",1045576396),cljs.core.count.call(null,fulcro_spec.renderer.find_tests.call(null,new cljs.core.Keyword(null,"pending","pending",-220036727),namespaces)),new cljs.core.Keyword(null,"pending","pending",-220036727),current_filter,toggle_filter_cb),fulcro_spec.renderer.filter_button.call(null,new cljs.core.Keyword(null,"pan_tool","pan_tool",-306611187),cljs.core.count.call(null,fulcro_spec.renderer.find_tests.call(null,new cljs.core.Keyword(null,"manual","manual",-237370608),namespaces)),new cljs.core.Keyword(null,"manual","manual",-237370608),current_filter,toggle_filter_cb),fulcro_spec.renderer.filter_button.call(null,new cljs.core.Keyword(null,"close","close",1835149582),fail,new cljs.core.Keyword(null,"failing","failing",-324520682),current_filter,toggle_filter_cb),fulcro_spec.renderer.filter_button.call(null,new cljs.core.Keyword(null,"warning","warning",-1685650671),error,new cljs.core.Keyword(null,"failing","failing",-324520682),current_filter,toggle_filter_cb),fulcro_spec.renderer.filter_button.call(null,new cljs.core.Keyword(null,"access_time","access_time",-1820282641),end_time__$1),fulcro_spec.renderer.filter_button.call(null,new cljs.core.Keyword(null,"hourglass_empty","hourglass_empty",141670077),run_time__$1));
});
var render_input_49058 = (function (p__49052){
var map__49053 = p__49052;
var map__49053__$1 = ((((!((map__49053 == null)))?((((map__49053.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__49053.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49053):map__49053);
var props = map__49053__$1;
var type = cljs.core.get.call(null,map__49053__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var id = cljs.core.get.call(null,map__49053__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
return om.dom.span.call(null,null,om.dom.input.call(null,cljs.core.clj__GT_js.call(null,props)),om.dom.label.call(null,({"htmlFor": id}),"\u00A0"));
});
/**
 * Render a checkbox (not the label). Props is a normal clj(s) map with React/HTML attributes plus:
 * 
 *   `:className` - additional class stylings to apply to the top level of the checkbox
 *   `:id` string - Unique DOM ID. Required for correct rendering.
 *   `:checked` - true, false, or :partial
 */
fulcro_spec.renderer.ui_checkbox = ((function (render_input_49058){
return (function fulcro_spec$renderer$ui_checkbox(p__49055){
var map__49056 = p__49055;
var map__49056__$1 = ((((!((map__49056 == null)))?((((map__49056.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__49056.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49056):map__49056);
var props = map__49056__$1;
var id = cljs.core.get.call(null,map__49056__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var state = cljs.core.get.call(null,map__49056__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var checked = cljs.core.get.call(null,map__49056__$1,new cljs.core.Keyword(null,"checked","checked",-50955819));
var className = cljs.core.get.call(null,map__49056__$1,new cljs.core.Keyword(null,"className","className",-1983287057));
if(cljs.core.truth_(id)){
} else {
throw (new Error(["Assert failed: ","DOM ID is required on checkbox","\n","id"].join('')));
}

var classes = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(className)," c-checkbox",cljs.core.str.cljs$core$IFn$_invoke$arity$1(((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"partial","partial",241141745),checked))?" is-indeterminate":null))].join('');
var checked__$1 = cljs.core.boolean$.call(null,checked);
var attrs = cljs.core.assoc.call(null,props,new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"checked","checked",-50955819),checked__$1,new cljs.core.Keyword(null,"className","className",-1983287057),classes);
return render_input_49058.call(null,attrs);
});})(render_input_49058))
;
if(typeof fulcro_spec.renderer.SelectorControl !== 'undefined'){
} else {
/**
 * @constructor
 */
fulcro_spec.renderer.SelectorControl = (function fulcro_spec$renderer$SelectorControl(){
var this__35632__auto__ = this;
React.Component.apply(this__35632__auto__,arguments);

if(!((this__35632__auto__.initLocalState == null))){
this__35632__auto__.state = this__35632__auto__.initLocalState();
} else {
this__35632__auto__.state = {};
}

return this__35632__auto__;
});

fulcro_spec.renderer.SelectorControl.prototype = goog.object.clone(React.Component.prototype);
}

var x49061_49073 = fulcro_spec.renderer.SelectorControl.prototype;
x49061_49073.componentWillUpdate = ((function (x49061_49073){
return (function (next_props__35520__auto__,next_state__35521__auto__){
var this__35519__auto__ = this;
if(((!((this__35519__auto__ == null)))?(((false) || ((cljs.core.PROTOCOL_SENTINEL === this__35519__auto__.om$next$Ident$)))?true:false):false)){
var ident__35523__auto___49074 = om.next.ident.call(null,this__35519__auto__,om.next.props.call(null,this__35519__auto__));
var next_ident__35524__auto___49075 = om.next.ident.call(null,this__35519__auto__,om.next._next_props.call(null,next_props__35520__auto__,this__35519__auto__));
if(cljs.core.not_EQ_.call(null,ident__35523__auto___49074,next_ident__35524__auto___49075)){
var idxr__35525__auto___49076 = cljs.core.get_in.call(null,om.next.get_reconciler.call(null,this__35519__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
if((idxr__35525__auto___49076 == null)){
} else {
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"indexes","indexes",1496475545).cljs$core$IFn$_invoke$arity$1(idxr__35525__auto___49076),((function (idxr__35525__auto___49076,ident__35523__auto___49074,next_ident__35524__auto___49075,this__35519__auto__,x49061_49073){
return (function (indexes__35526__auto__){
return cljs.core.update_in.call(null,cljs.core.update_in.call(null,indexes__35526__auto__,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ref->components","ref->components",-303587249),ident__35523__auto___49074], null),cljs.core.disj,this__35519__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ref->components","ref->components",-303587249),next_ident__35524__auto___49075], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentHashSet.EMPTY),this__35519__auto__);
});})(idxr__35525__auto___49076,ident__35523__auto___49074,next_ident__35524__auto___49075,this__35519__auto__,x49061_49073))
);
}
} else {
}
} else {
}

om.next.merge_pending_props_BANG_.call(null,this__35519__auto__);

return om.next.merge_pending_state_BANG_.call(null,this__35519__auto__);
});})(x49061_49073))
;

x49061_49073.shouldComponentUpdate = ((function (x49061_49073){
return (function (next_props__35520__auto__,next_state__35521__auto__){
var this__35519__auto__ = this;
var next_children__35522__auto__ = next_props__35520__auto__.children;
var next_props__35520__auto____$1 = goog.object.get(next_props__35520__auto__,"omcljs$value");
var next_props__35520__auto____$2 = (function (){var G__49063 = next_props__35520__auto____$1;
if((next_props__35520__auto____$1 instanceof om.next.OmProps)){
return om.next.unwrap.call(null,G__49063);
} else {
return G__49063;
}
})();
var or__28141__auto__ = cljs.core.not_EQ_.call(null,om.next.props.call(null,this__35519__auto__),next_props__35520__auto____$2);
if(or__28141__auto__){
return or__28141__auto__;
} else {
var or__28141__auto____$1 = (function (){var and__28129__auto__ = this__35519__auto__.state;
if(cljs.core.truth_(and__28129__auto__)){
return cljs.core.not_EQ_.call(null,goog.object.get(this__35519__auto__.state,"omcljs$state"),goog.object.get(next_state__35521__auto__,"omcljs$state"));
} else {
return and__28129__auto__;
}
})();
if(cljs.core.truth_(or__28141__auto____$1)){
return or__28141__auto____$1;
} else {
return cljs.core.not_EQ_.call(null,this__35519__auto__.props.children,next_children__35522__auto__);
}
}
});})(x49061_49073))
;

x49061_49073.componentWillUnmount = ((function (x49061_49073){
return (function (){
var this__35519__auto__ = this;
var r__35530__auto__ = om.next.get_reconciler.call(null,this__35519__auto__);
var cfg__35531__auto__ = new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(r__35530__auto__);
var st__35532__auto__ = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(cfg__35531__auto__);
var indexer__35529__auto__ = new cljs.core.Keyword(null,"indexer","indexer",-1774914315).cljs$core$IFn$_invoke$arity$1(cfg__35531__auto__);
if(cljs.core.truth_((function (){var and__28129__auto__ = !((st__35532__auto__ == null));
if(and__28129__auto__){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,st__35532__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("om.next","queries","om.next/queries",-22717146),this__35519__auto__], null));
} else {
return and__28129__auto__;
}
})())){
cljs.core.swap_BANG_.call(null,st__35532__auto__,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("om.next","queries","om.next/queries",-22717146)], null),cljs.core.dissoc,this__35519__auto__);
} else {
}

if((indexer__35529__auto__ == null)){
return null;
} else {
return om.next.protocols.drop_component_BANG_.call(null,indexer__35529__auto__,this__35519__auto__);
}
});})(x49061_49073))
;

x49061_49073.componentDidUpdate = ((function (x49061_49073){
return (function (prev_props__35527__auto__,prev_state__35528__auto__){
var this__35519__auto__ = this;
return om.next.clear_prev_props_BANG_.call(null,this__35519__auto__);
});})(x49061_49073))
;

x49061_49073.isMounted = ((function (x49061_49073){
return (function (){
var this__35519__auto__ = this;
return cljs.core.boolean$.call(null,goog.object.getValueByKeys(this__35519__auto__,"_reactInternalInstance","_renderedComponent"));
});})(x49061_49073))
;

x49061_49073.componentWillMount = ((function (x49061_49073){
return (function (){
var this__35519__auto__ = this;
var indexer__35529__auto__ = cljs.core.get_in.call(null,om.next.get_reconciler.call(null,this__35519__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
if((indexer__35529__auto__ == null)){
return null;
} else {
return om.next.protocols.index_component_BANG_.call(null,indexer__35529__auto__,this__35519__auto__);
}
});})(x49061_49073))
;

x49061_49073.render = ((function (x49061_49073){
return (function (){
var this__35518__auto__ = this;
var this$ = this__35518__auto__;
var _STAR_reconciler_STAR_49064 = om.next._STAR_reconciler_STAR_;
var _STAR_depth_STAR_49065 = om.next._STAR_depth_STAR_;
var _STAR_shared_STAR_49066 = om.next._STAR_shared_STAR_;
var _STAR_instrument_STAR_49067 = om.next._STAR_instrument_STAR_;
var _STAR_parent_STAR_49068 = om.next._STAR_parent_STAR_;
om.next._STAR_reconciler_STAR_ = om.next.get_reconciler.call(null,this__35518__auto__);

om.next._STAR_depth_STAR_ = (om.next.depth.call(null,this__35518__auto__) + (1));

om.next._STAR_shared_STAR_ = om.next.shared.call(null,this__35518__auto__);

om.next._STAR_instrument_STAR_ = om.next.instrument.call(null,this__35518__auto__);

om.next._STAR_parent_STAR_ = this__35518__auto__;

try{var map__49069 = om.next.props.call(null,this$);
var map__49069__$1 = ((((!((map__49069 == null)))?((((map__49069.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__49069.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49069):map__49069);
var id = cljs.core.get.call(null,map__49069__$1,new cljs.core.Keyword("selector","id","selector/id",1917888117));
var active_QMARK_ = cljs.core.get.call(null,map__49069__$1,new cljs.core.Keyword("selector","active?","selector/active?",604593375));
return om.dom.div.call(null,({"className": "c-drawer__action", "key": [cljs.core.str.cljs$core$IFn$_invoke$arity$1(id)].join('')}),fulcro_spec.renderer.ui_checkbox.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"id","id",-1388402092),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(id)].join(''),new cljs.core.Keyword(null,"checked","checked",-50955819),active_QMARK_,new cljs.core.Keyword(null,"onChange","onChange",-312891301),((function (map__49069,map__49069__$1,id,active_QMARK_,_STAR_reconciler_STAR_49064,_STAR_depth_STAR_49065,_STAR_shared_STAR_49066,_STAR_instrument_STAR_49067,_STAR_parent_STAR_49068,this$,this__35518__auto__,x49061_49073){
return (function (e){
return om.next.transact_BANG_.call(null,this$,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__29003__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("fulcro-spec.selectors","set-selector","fulcro-spec.selectors/set-selector",483272861,null)),(function (){var x__29003__auto__ = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("selector","id","selector/id",1917888117),id,new cljs.core.Keyword("selector","active?","selector/active?",604593375),e.target.checked], null);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__29003__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__29003__auto__);
})())))));
});})(map__49069,map__49069__$1,id,active_QMARK_,_STAR_reconciler_STAR_49064,_STAR_depth_STAR_49065,_STAR_shared_STAR_49066,_STAR_instrument_STAR_49067,_STAR_parent_STAR_49068,this$,this__35518__auto__,x49061_49073))
], null)),om.dom.span.call(null,({}),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(id)].join('')));
}finally {om.next._STAR_parent_STAR_ = _STAR_parent_STAR_49068;

om.next._STAR_instrument_STAR_ = _STAR_instrument_STAR_49067;

om.next._STAR_shared_STAR_ = _STAR_shared_STAR_49066;

om.next._STAR_depth_STAR_ = _STAR_depth_STAR_49065;

om.next._STAR_reconciler_STAR_ = _STAR_reconciler_STAR_49064;
}});})(x49061_49073))
;


fulcro_spec.renderer.SelectorControl.prototype.constructor = fulcro_spec.renderer.SelectorControl;

fulcro_spec.renderer.SelectorControl.prototype.constructor.displayName = "fulcro-spec.renderer/SelectorControl";

fulcro_spec.renderer.SelectorControl.prototype.om$isComponent = true;

var x49071_49077 = fulcro_spec.renderer.SelectorControl;
/** @nocollapse */
x49071_49077.om$next$IQuery$ = cljs.core.PROTOCOL_SENTINEL;

/** @nocollapse */
x49071_49077.om$next$IQuery$query$arity$1 = ((function (x49071_49077){
return (function (this$){
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("selector","id","selector/id",1917888117),new cljs.core.Keyword("selector","active?","selector/active?",604593375)], null);
});})(x49071_49077))
;


var x49072_49078 = fulcro_spec.renderer.SelectorControl.prototype;

x49072_49078.om$next$IQuery$ = cljs.core.PROTOCOL_SENTINEL;


x49072_49078.om$next$IQuery$query$arity$1 = ((function (x49072_49078){
return (function (this$){
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("selector","id","selector/id",1917888117),new cljs.core.Keyword("selector","active?","selector/active?",604593375)], null);
});})(x49072_49078))
;


fulcro_spec.renderer.SelectorControl.cljs$lang$type = true;

fulcro_spec.renderer.SelectorControl.cljs$lang$ctorStr = "fulcro-spec.renderer/SelectorControl";

fulcro_spec.renderer.SelectorControl.cljs$lang$ctorPrWriter = (function (this__35635__auto__,writer__35636__auto__,opt__35637__auto__){
return cljs.core._write.call(null,writer__35636__auto__,"fulcro-spec.renderer/SelectorControl");
});
fulcro_spec.renderer.ui_selector_control = om.next.factory.call(null,fulcro_spec.renderer.SelectorControl,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"keyfn","keyfn",780060332),new cljs.core.Keyword("selector","id","selector/id",1917888117)], null));
fulcro_spec.renderer.test_selectors = (function fulcro_spec$renderer$test_selectors(selectors){
return om.dom.div.call(null,null,om.dom.h1.call(null,null,"Test Selectors:"),cljs.core.map.call(null,fulcro_spec.renderer.ui_selector_control,cljs.core.sort_by.call(null,new cljs.core.Keyword("selector","id","selector/id",1917888117),selectors)));
});
fulcro_spec.renderer.toolbar_button = (function fulcro_spec$renderer$toolbar_button(toggle_drawer){
return om.dom.div.call(null,({"className": "c-toolbar__button"}),om.dom.button.call(null,({"className": "c-button c-button--icon", "onClick": toggle_drawer}),fulcro_spec.renderer.icon.call(null,new cljs.core.Keyword(null,"menu","menu",352255198))));
});
fulcro_spec.renderer.test_header = (function fulcro_spec$renderer$test_header(test_report,current_filter,toggle_drawer,toggle_filter_cb){
return om.dom.header.call(null,({"className": "u-layout__header c-toolbar c-toolbar--raised"}),om.dom.div.call(null,({"className": "c-toolbar__row"}),om.dom.h1.call(null,null,"Fulcro Spec"),om.dom.div.call(null,({"className": "c-toolbar__spacer"})),fulcro_spec.renderer.test_info.call(null,test_report,current_filter,toggle_filter_cb)),fulcro_spec.renderer.toolbar_button.call(null,toggle_drawer));
});
/**
 * Generate a layout row. This is a div container for a row in a 12-wide grid responsive layout.
 *   Rows should contain layout columns generated with the `col` function of this namespace.
 * 
 *   The properties are normal DOM attributes as a cljs map and can include standard React DOM properties.
 * 
 *   `:distribute-extra-columns` can be :between or :around, and indicates where to put unused columns.
 *    - :between Unused column space is even distributed between columns
 *        2COL _____ 2COL _____ 2COL
 *    - :around Unused column space is even distributed around columns
 *        __ 2COL __ 2COL __ 2COL __
 * 
 *   `:halign` can be :start, :center, or :end for positioning a single child column in that position
 *   `:valign` can be :top, :middle, or :bottom and will affect the vertical positioning of nested cells that do not
 *   share a common height.
 */
fulcro_spec.renderer.row = (function fulcro_spec$renderer$row(var_args){
var args__29319__auto__ = [];
var len__29312__auto___49085 = arguments.length;
var i__29313__auto___49086 = (0);
while(true){
if((i__29313__auto___49086 < len__29312__auto___49085)){
args__29319__auto__.push((arguments[i__29313__auto___49086]));

var G__49087 = (i__29313__auto___49086 + (1));
i__29313__auto___49086 = G__49087;
continue;
} else {
}
break;
}

var argseq__29320__auto__ = ((((1) < args__29319__auto__.length))?(new cljs.core.IndexedSeq(args__29319__auto__.slice((1)),(0),null)):null);
return fulcro_spec.renderer.row.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29320__auto__);
});

fulcro_spec.renderer.row.cljs$core$IFn$_invoke$arity$variadic = (function (p__49081,children){
var map__49082 = p__49081;
var map__49082__$1 = ((((!((map__49082 == null)))?((((map__49082.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__49082.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49082):map__49082);
var props = map__49082__$1;
var distribute_extra_columns = cljs.core.get.call(null,map__49082__$1,new cljs.core.Keyword(null,"distribute-extra-columns","distribute-extra-columns",-2101013909));
var halign = cljs.core.get.call(null,map__49082__$1,new cljs.core.Keyword(null,"halign","halign",-1113968481));
var valign = cljs.core.get.call(null,map__49082__$1,new cljs.core.Keyword(null,"valign","valign",1485197511));
var density = cljs.core.get.call(null,map__49082__$1,new cljs.core.Keyword(null,"density","density",-1664155941));
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [null,null,new cljs.core.Keyword(null,"between","between",1131099276),null,new cljs.core.Keyword(null,"around","around",-265975553),null], null), null),distribute_extra_columns)){
} else {
throw (new Error("Assert failed: (contains? #{nil :between :around} distribute-extra-columns)"));
}

if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [null,null,new cljs.core.Keyword(null,"start","start",-355208981),null,new cljs.core.Keyword(null,"center","center",-748944368),null,new cljs.core.Keyword(null,"end","end",-268185958),null], null), null),halign)){
} else {
throw (new Error("Assert failed: (contains? #{nil :start :center :end} halign)"));
}

if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [null,null,new cljs.core.Keyword(null,"bottom","bottom",-1550509018),null,new cljs.core.Keyword(null,"top","top",-1856271961),null,new cljs.core.Keyword(null,"middle","middle",-701029031),null], null), null),valign)){
} else {
throw (new Error("Assert failed: (contains? #{nil :bottom :top :middle} valign)"));
}

if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [null,null,new cljs.core.Keyword(null,"break","break",126570225),null,new cljs.core.Keyword(null,"collapse","collapse",-1218136136),null,new cljs.core.Keyword(null,"wide","wide",-151772487),null], null), null),density)){
} else {
throw (new Error("Assert failed: (contains? #{nil :break :collapse :wide} density)"));
}

var className = (function (){var or__28141__auto__ = new cljs.core.Keyword(null,"className","className",-1983287057).cljs$core$IFn$_invoke$arity$1(props);
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
return "";
}
})();
var classes = (function (){var G__49084 = className;
var G__49084__$1 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__49084)," u-row"].join('')
;
var G__49084__$2 = (cljs.core.truth_(distribute_extra_columns)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__49084__$1)," u-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,distribute_extra_columns))].join(''):G__49084__$1);
var G__49084__$3 = (cljs.core.truth_(halign)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__49084__$2)," u-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,halign))].join(''):G__49084__$2);
var G__49084__$4 = (cljs.core.truth_(valign)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__49084__$3)," u-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,valign))].join(''):G__49084__$3);
if(cljs.core.truth_(density)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__49084__$4)," u-row--",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,density))].join('');
} else {
return G__49084__$4;
}
})();
var attrs = cljs.core.clj__GT_js.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,props,new cljs.core.Keyword(null,"distribute-extra-columns","distribute-extra-columns",-2101013909),new cljs.core.Keyword(null,"halign","halign",-1113968481),new cljs.core.Keyword(null,"valign","valign",1485197511),new cljs.core.Keyword(null,"density","density",-1664155941)),new cljs.core.Keyword(null,"className","className",-1983287057),classes));
return cljs.core.apply.call(null,om.dom.div,attrs,children);
});

fulcro_spec.renderer.row.cljs$lang$maxFixedArity = (1);

fulcro_spec.renderer.row.cljs$lang$applyTo = (function (seq49079){
var G__49080 = cljs.core.first.call(null,seq49079);
var seq49079__$1 = cljs.core.next.call(null,seq49079);
return fulcro_spec.renderer.row.cljs$core$IFn$_invoke$arity$variadic(G__49080,seq49079__$1);
});

/**
 * Output a div that represents a column in the 12-column responsive grid.
 * 
 *   NOTE: halign works on anything, valign on on rows
 */
fulcro_spec.renderer.col = (function fulcro_spec$renderer$col(var_args){
var args__29319__auto__ = [];
var len__29312__auto___49094 = arguments.length;
var i__29313__auto___49095 = (0);
while(true){
if((i__29313__auto___49095 < len__29312__auto___49094)){
args__29319__auto__.push((arguments[i__29313__auto___49095]));

var G__49096 = (i__29313__auto___49095 + (1));
i__29313__auto___49095 = G__49096;
continue;
} else {
}
break;
}

var argseq__29320__auto__ = ((((1) < args__29319__auto__.length))?(new cljs.core.IndexedSeq(args__29319__auto__.slice((1)),(0),null)):null);
return fulcro_spec.renderer.col.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29320__auto__);
});

fulcro_spec.renderer.col.cljs$core$IFn$_invoke$arity$variadic = (function (p__49090,children){
var map__49091 = p__49090;
var map__49091__$1 = ((((!((map__49091 == null)))?((((map__49091.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__49091.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49091):map__49091);
var props = map__49091__$1;
var md_push = cljs.core.get.call(null,map__49091__$1,new cljs.core.Keyword(null,"md-push","md-push",288470810));
var sm_push = cljs.core.get.call(null,map__49091__$1,new cljs.core.Keyword(null,"sm-push","sm-push",1835708573));
var halign = cljs.core.get.call(null,map__49091__$1,new cljs.core.Keyword(null,"halign","halign",-1113968481));
var xl_push = cljs.core.get.call(null,map__49091__$1,new cljs.core.Keyword(null,"xl-push","xl-push",-1108453728));
var sm_width = cljs.core.get.call(null,map__49091__$1,new cljs.core.Keyword(null,"sm-width","sm-width",280805410));
var push = cljs.core.get.call(null,map__49091__$1,new cljs.core.Keyword(null,"push","push",799791267));
var lg_width = cljs.core.get.call(null,map__49091__$1,new cljs.core.Keyword(null,"lg-width","lg-width",420811558));
var valign = cljs.core.get.call(null,map__49091__$1,new cljs.core.Keyword(null,"valign","valign",1485197511));
var lg_push = cljs.core.get.call(null,map__49091__$1,new cljs.core.Keyword(null,"lg-push","lg-push",606284103));
var width = cljs.core.get.call(null,map__49091__$1,new cljs.core.Keyword(null,"width","width",-384071477));
var md_width = cljs.core.get.call(null,map__49091__$1,new cljs.core.Keyword(null,"md-width","md-width",-1317567860));
var xl_width = cljs.core.get.call(null,map__49091__$1,new cljs.core.Keyword(null,"xl-width","xl-width",401581997));
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [null,null,new cljs.core.Keyword(null,"start","start",-355208981),null,new cljs.core.Keyword(null,"center","center",-748944368),null,new cljs.core.Keyword(null,"end","end",-268185958),null], null), null),halign)){
} else {
throw (new Error("Assert failed: (contains? #{nil :start :center :end} halign)"));
}

if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [null,null,new cljs.core.Keyword(null,"bottom","bottom",-1550509018),null,new cljs.core.Keyword(null,"top","top",-1856271961),null,new cljs.core.Keyword(null,"middle","middle",-701029031),null], null), null),valign)){
} else {
throw (new Error("Assert failed: (contains? #{nil :bottom :top :middle} valign)"));
}

var classes = (function (){var G__49093 = new cljs.core.Keyword(null,"className","className",-1983287057).cljs$core$IFn$_invoke$arity$1(props);
var G__49093__$1 = (cljs.core.truth_(width)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__49093)," u-column--",cljs.core.str.cljs$core$IFn$_invoke$arity$1(width)].join(''):G__49093);
var G__49093__$2 = (cljs.core.truth_(halign)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__49093__$1)," u-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,halign))].join(''):G__49093__$1);
var G__49093__$3 = (cljs.core.truth_(valign)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__49093__$2)," u-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,valign))].join(''):G__49093__$2);
var G__49093__$4 = (cljs.core.truth_(sm_width)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__49093__$3)," u-column--",cljs.core.str.cljs$core$IFn$_invoke$arity$1(sm_width),"@sm"].join(''):G__49093__$3);
var G__49093__$5 = (cljs.core.truth_(md_width)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__49093__$4)," u-column--",cljs.core.str.cljs$core$IFn$_invoke$arity$1(md_width),"@md"].join(''):G__49093__$4);
var G__49093__$6 = (cljs.core.truth_(lg_width)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__49093__$5)," u-column--",cljs.core.str.cljs$core$IFn$_invoke$arity$1(lg_width),"@lg"].join(''):G__49093__$5);
var G__49093__$7 = (cljs.core.truth_(xl_width)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__49093__$6)," u-column--",cljs.core.str.cljs$core$IFn$_invoke$arity$1(xl_width),"@xl"].join(''):G__49093__$6);
var G__49093__$8 = (cljs.core.truth_(push)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__49093__$7)," u-push--",cljs.core.str.cljs$core$IFn$_invoke$arity$1(push)].join(''):G__49093__$7);
var G__49093__$9 = (cljs.core.truth_(sm_push)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__49093__$8)," u-push--",cljs.core.str.cljs$core$IFn$_invoke$arity$1(sm_push),"@sm"].join(''):G__49093__$8);
var G__49093__$10 = (cljs.core.truth_(md_push)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__49093__$9)," u-push--",cljs.core.str.cljs$core$IFn$_invoke$arity$1(md_push),"@md"].join(''):G__49093__$9);
var G__49093__$11 = (cljs.core.truth_(lg_push)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__49093__$10)," u-push--",cljs.core.str.cljs$core$IFn$_invoke$arity$1(lg_push),"@lg"].join(''):G__49093__$10);
if(cljs.core.truth_(xl_push)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__49093__$11)," u-push--",cljs.core.str.cljs$core$IFn$_invoke$arity$1(xl_push),"@xl"].join('');
} else {
return G__49093__$11;
}
})();
var attrs = cljs.core.clj__GT_js.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,props,new cljs.core.Keyword(null,"width","width",-384071477),new cljs.core.Keyword(null,"halign","halign",-1113968481),new cljs.core.Keyword(null,"valign","valign",1485197511),new cljs.core.Keyword(null,"sm-width","sm-width",280805410),new cljs.core.Keyword(null,"md-width","md-width",-1317567860),new cljs.core.Keyword(null,"lg-width","lg-width",420811558),new cljs.core.Keyword(null,"xl-width","xl-width",401581997),new cljs.core.Keyword(null,"push","push",799791267),new cljs.core.Keyword(null,"sm-push","sm-push",1835708573),new cljs.core.Keyword(null,"md-push","md-push",288470810),new cljs.core.Keyword(null,"lg-push","lg-push",606284103),new cljs.core.Keyword(null,"xl-push","xl-push",-1108453728)),new cljs.core.Keyword(null,"className","className",-1983287057),classes));
return cljs.core.apply.call(null,om.dom.div,attrs,children);
});

fulcro_spec.renderer.col.cljs$lang$maxFixedArity = (1);

fulcro_spec.renderer.col.cljs$lang$applyTo = (function (seq49088){
var G__49089 = cljs.core.first.call(null,seq49088);
var seq49088__$1 = cljs.core.next.call(null,seq49088);
return fulcro_spec.renderer.col.cljs$core$IFn$_invoke$arity$variadic(G__49089,seq49088__$1);
});

fulcro_spec.renderer.test_main = (function fulcro_spec$renderer$test_main(p__49098,current_filter){
var map__49099 = p__49098;
var map__49099__$1 = ((((!((map__49099 == null)))?((((map__49099.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__49099.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49099):map__49099);
var namespaces = cljs.core.get.call(null,map__49099__$1,new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469));
return om.dom.main.call(null,({"className": "u-layout__content"}),om.dom.article.call(null,({"className": "o-article"}),fulcro_spec.renderer.row.call(null,cljs.core.PersistentArrayMap.EMPTY,fulcro_spec.renderer.col.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"width","width",-384071477),(12)], null),om.dom.div.call(null,({"className": "test-report"}),om.dom.ul.call(null,null,cljs.core.sequence.call(null,cljs.core.comp.call(null,fulcro_spec.renderer.filters.call(null,current_filter),cljs.core.map.call(null,((function (map__49099,map__49099__$1,namespaces){
return (function (p1__49097_SHARP_){
return cljs.core.assoc.call(null,p1__49097_SHARP_,new cljs.core.Keyword(null,"current-filter","current-filter",1519815247),current_filter);
});})(map__49099,map__49099__$1,namespaces))
),cljs.core.map.call(null,fulcro_spec.renderer.ui_test_namespace)),cljs.core.sort_by.call(null,new cljs.core.Keyword(null,"name","name",1843675177),namespaces))))))));
});
if(typeof fulcro_spec.renderer.TestReport !== 'undefined'){
} else {
/**
 * @constructor
 */
fulcro_spec.renderer.TestReport = (function fulcro_spec$renderer$TestReport(){
var this__35632__auto__ = this;
React.Component.apply(this__35632__auto__,arguments);

if(!((this__35632__auto__.initLocalState == null))){
this__35632__auto__.state = this__35632__auto__.initLocalState();
} else {
this__35632__auto__.state = {};
}

return this__35632__auto__;
});

fulcro_spec.renderer.TestReport.prototype = goog.object.clone(React.Component.prototype);
}

var x49103_49119 = fulcro_spec.renderer.TestReport.prototype;
x49103_49119.componentWillUpdate = ((function (x49103_49119){
return (function (next_props__35520__auto__,next_state__35521__auto__){
var this__35519__auto__ = this;
if(((!((this__35519__auto__ == null)))?(((false) || ((cljs.core.PROTOCOL_SENTINEL === this__35519__auto__.om$next$Ident$)))?true:false):false)){
var ident__35523__auto___49120 = om.next.ident.call(null,this__35519__auto__,om.next.props.call(null,this__35519__auto__));
var next_ident__35524__auto___49121 = om.next.ident.call(null,this__35519__auto__,om.next._next_props.call(null,next_props__35520__auto__,this__35519__auto__));
if(cljs.core.not_EQ_.call(null,ident__35523__auto___49120,next_ident__35524__auto___49121)){
var idxr__35525__auto___49122 = cljs.core.get_in.call(null,om.next.get_reconciler.call(null,this__35519__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
if((idxr__35525__auto___49122 == null)){
} else {
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"indexes","indexes",1496475545).cljs$core$IFn$_invoke$arity$1(idxr__35525__auto___49122),((function (idxr__35525__auto___49122,ident__35523__auto___49120,next_ident__35524__auto___49121,this__35519__auto__,x49103_49119){
return (function (indexes__35526__auto__){
return cljs.core.update_in.call(null,cljs.core.update_in.call(null,indexes__35526__auto__,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ref->components","ref->components",-303587249),ident__35523__auto___49120], null),cljs.core.disj,this__35519__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ref->components","ref->components",-303587249),next_ident__35524__auto___49121], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentHashSet.EMPTY),this__35519__auto__);
});})(idxr__35525__auto___49122,ident__35523__auto___49120,next_ident__35524__auto___49121,this__35519__auto__,x49103_49119))
);
}
} else {
}
} else {
}

om.next.merge_pending_props_BANG_.call(null,this__35519__auto__);

return om.next.merge_pending_state_BANG_.call(null,this__35519__auto__);
});})(x49103_49119))
;

x49103_49119.shouldComponentUpdate = ((function (x49103_49119){
return (function (next_props__35520__auto__,next_state__35521__auto__){
var this__35519__auto__ = this;
var next_children__35522__auto__ = next_props__35520__auto__.children;
var next_props__35520__auto____$1 = goog.object.get(next_props__35520__auto__,"omcljs$value");
var next_props__35520__auto____$2 = (function (){var G__49105 = next_props__35520__auto____$1;
if((next_props__35520__auto____$1 instanceof om.next.OmProps)){
return om.next.unwrap.call(null,G__49105);
} else {
return G__49105;
}
})();
var or__28141__auto__ = cljs.core.not_EQ_.call(null,om.next.props.call(null,this__35519__auto__),next_props__35520__auto____$2);
if(or__28141__auto__){
return or__28141__auto__;
} else {
var or__28141__auto____$1 = (function (){var and__28129__auto__ = this__35519__auto__.state;
if(cljs.core.truth_(and__28129__auto__)){
return cljs.core.not_EQ_.call(null,goog.object.get(this__35519__auto__.state,"omcljs$state"),goog.object.get(next_state__35521__auto__,"omcljs$state"));
} else {
return and__28129__auto__;
}
})();
if(cljs.core.truth_(or__28141__auto____$1)){
return or__28141__auto____$1;
} else {
return cljs.core.not_EQ_.call(null,this__35519__auto__.props.children,next_children__35522__auto__);
}
}
});})(x49103_49119))
;

x49103_49119.componentWillUnmount = ((function (x49103_49119){
return (function (){
var this__35519__auto__ = this;
var r__35530__auto__ = om.next.get_reconciler.call(null,this__35519__auto__);
var cfg__35531__auto__ = new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(r__35530__auto__);
var st__35532__auto__ = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(cfg__35531__auto__);
var indexer__35529__auto__ = new cljs.core.Keyword(null,"indexer","indexer",-1774914315).cljs$core$IFn$_invoke$arity$1(cfg__35531__auto__);
if(cljs.core.truth_((function (){var and__28129__auto__ = !((st__35532__auto__ == null));
if(and__28129__auto__){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,st__35532__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("om.next","queries","om.next/queries",-22717146),this__35519__auto__], null));
} else {
return and__28129__auto__;
}
})())){
cljs.core.swap_BANG_.call(null,st__35532__auto__,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("om.next","queries","om.next/queries",-22717146)], null),cljs.core.dissoc,this__35519__auto__);
} else {
}

if((indexer__35529__auto__ == null)){
return null;
} else {
return om.next.protocols.drop_component_BANG_.call(null,indexer__35529__auto__,this__35519__auto__);
}
});})(x49103_49119))
;

x49103_49119.componentDidUpdate = ((function (x49103_49119){
return (function (prev_props__35527__auto__,prev_state__35528__auto__){
var this__35519__auto__ = this;
return om.next.clear_prev_props_BANG_.call(null,this__35519__auto__);
});})(x49103_49119))
;

x49103_49119.isMounted = ((function (x49103_49119){
return (function (){
var this__35519__auto__ = this;
return cljs.core.boolean$.call(null,goog.object.getValueByKeys(this__35519__auto__,"_reactInternalInstance","_renderedComponent"));
});})(x49103_49119))
;

x49103_49119.componentWillMount = ((function (x49103_49119){
return (function (){
var this__35519__auto__ = this;
var indexer__35529__auto__ = cljs.core.get_in.call(null,om.next.get_reconciler.call(null,this__35519__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
if((indexer__35529__auto__ == null)){
return null;
} else {
return om.next.protocols.index_component_BANG_.call(null,indexer__35529__auto__,this__35519__auto__);
}
});})(x49103_49119))
;

x49103_49119.render = ((function (x49103_49119){
return (function (){
var this__35518__auto__ = this;
var this$ = this__35518__auto__;
var _STAR_reconciler_STAR_49106 = om.next._STAR_reconciler_STAR_;
var _STAR_depth_STAR_49107 = om.next._STAR_depth_STAR_;
var _STAR_shared_STAR_49108 = om.next._STAR_shared_STAR_;
var _STAR_instrument_STAR_49109 = om.next._STAR_instrument_STAR_;
var _STAR_parent_STAR_49110 = om.next._STAR_parent_STAR_;
om.next._STAR_reconciler_STAR_ = om.next.get_reconciler.call(null,this__35518__auto__);

om.next._STAR_depth_STAR_ = (om.next.depth.call(null,this__35518__auto__) + (1));

om.next._STAR_shared_STAR_ = om.next.shared.call(null,this__35518__auto__);

om.next._STAR_instrument_STAR_ = om.next.instrument.call(null,this__35518__auto__);

om.next._STAR_parent_STAR_ = this__35518__auto__;

try{var map__49111 = om.next.props.call(null,this$);
var map__49111__$1 = ((((!((map__49111 == null)))?((((map__49111.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__49111.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49111):map__49111);
var props = map__49111__$1;
var react_key = cljs.core.get.call(null,map__49111__$1,new cljs.core.Keyword("ui","react-key","ui/react-key",1337877664));
var compile_error = cljs.core.get.call(null,map__49111__$1,new cljs.core.Keyword(null,"compile-error","compile-error",-1313154526));
var test_report = cljs.core.get.call(null,map__49111__$1,new cljs.core.Keyword(null,"test-report","test-report",-769743150));
var selectors = cljs.core.get.call(null,map__49111__$1,new cljs.core.Keyword(null,"selectors","selectors",-680741768));
var current_filter = cljs.core.get.call(null,map__49111__$1,new cljs.core.Keyword("ui","current-filter","ui/current-filter",1519811523));
var map__49112 = om.next.get_state.call(null,this$);
var map__49112__$1 = ((((!((map__49112 == null)))?((((map__49112.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__49112.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49112):map__49112);
var open_drawer_QMARK_ = cljs.core.get.call(null,map__49112__$1,new cljs.core.Keyword(null,"open-drawer?","open-drawer?",1426251925));
var toggle_drawer = ((function (map__49111,map__49111__$1,props,react_key,compile_error,test_report,selectors,current_filter,map__49112,map__49112__$1,open_drawer_QMARK_,_STAR_reconciler_STAR_49106,_STAR_depth_STAR_49107,_STAR_shared_STAR_49108,_STAR_instrument_STAR_49109,_STAR_parent_STAR_49110,this$,this__35518__auto__,x49103_49119){
return (function (){
return om.next.update_state_BANG_.call(null,this$,cljs.core.update,new cljs.core.Keyword(null,"open-drawer?","open-drawer?",1426251925),cljs.core.not);
});})(map__49111,map__49111__$1,props,react_key,compile_error,test_report,selectors,current_filter,map__49112,map__49112__$1,open_drawer_QMARK_,_STAR_reconciler_STAR_49106,_STAR_depth_STAR_49107,_STAR_shared_STAR_49108,_STAR_instrument_STAR_49109,_STAR_parent_STAR_49110,this$,this__35518__auto__,x49103_49119))
;
var toggle_filter_cb = ((function (map__49111,map__49111__$1,props,react_key,compile_error,test_report,selectors,current_filter,map__49112,map__49112__$1,open_drawer_QMARK_,toggle_drawer,_STAR_reconciler_STAR_49106,_STAR_depth_STAR_49107,_STAR_shared_STAR_49108,_STAR_instrument_STAR_49109,_STAR_parent_STAR_49110,this$,this__35518__auto__,x49103_49119){
return (function (f){
return ((function (map__49111,map__49111__$1,props,react_key,compile_error,test_report,selectors,current_filter,map__49112,map__49112__$1,open_drawer_QMARK_,toggle_drawer,_STAR_reconciler_STAR_49106,_STAR_depth_STAR_49107,_STAR_shared_STAR_49108,_STAR_instrument_STAR_49109,_STAR_parent_STAR_49110,this$,this__35518__auto__,x49103_49119){
return (function (){
return om.next.transact_BANG_.call(null,this$,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__29003__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("fulcro-spec.renderer","toggle-filter","fulcro-spec.renderer/toggle-filter",1341829866,null)),(function (){var x__29003__auto__ = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"filter","filter",-948537934),f], null);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__29003__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__29003__auto__);
})())))));
});
;})(map__49111,map__49111__$1,props,react_key,compile_error,test_report,selectors,current_filter,map__49112,map__49112__$1,open_drawer_QMARK_,toggle_drawer,_STAR_reconciler_STAR_49106,_STAR_depth_STAR_49107,_STAR_shared_STAR_49108,_STAR_instrument_STAR_49109,_STAR_parent_STAR_49110,this$,this__35518__auto__,x49103_49119))
});})(map__49111,map__49111__$1,props,react_key,compile_error,test_report,selectors,current_filter,map__49112,map__49112__$1,open_drawer_QMARK_,toggle_drawer,_STAR_reconciler_STAR_49106,_STAR_depth_STAR_49107,_STAR_shared_STAR_49108,_STAR_instrument_STAR_49109,_STAR_parent_STAR_49110,this$,this__35518__auto__,x49103_49119))
;
return om.dom.div.call(null,({"key": react_key, "className": "u-layout"}),om.dom.div.call(null,({"className": "u-layout__page u-layout__page--fixed"}),fulcro_spec.renderer.test_header.call(null,test_report,current_filter,toggle_drawer,toggle_filter_cb),om.dom.div.call(null,({"className": (function (){var G__49115 = "c-drawer";
if(cljs.core.truth_(open_drawer_QMARK_)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__49115)," is-open"].join('');
} else {
return G__49115;
}
})()}),om.dom.div.call(null,({"className": "c-drawer__header"}),om.dom.img.call(null,({"src": "img/logo.png", "height": (35), "width": (35), "onClick": toggle_drawer})),om.dom.h1.call(null,null,"Fulcro Spec")),fulcro_spec.renderer.test_selectors.call(null,selectors)),om.dom.div.call(null,({"className": (function (){var G__49116 = "c-backdrop";
if(cljs.core.truth_(open_drawer_QMARK_)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__49116)," is-active"].join('');
} else {
return G__49116;
}
})(), "onClick": toggle_drawer})),(cljs.core.truth_(compile_error)?om.dom.h1.call(null,null,compile_error):fulcro_spec.renderer.test_main.call(null,test_report,current_filter))));
}finally {om.next._STAR_parent_STAR_ = _STAR_parent_STAR_49110;

om.next._STAR_instrument_STAR_ = _STAR_instrument_STAR_49109;

om.next._STAR_shared_STAR_ = _STAR_shared_STAR_49108;

om.next._STAR_depth_STAR_ = _STAR_depth_STAR_49107;

om.next._STAR_reconciler_STAR_ = _STAR_reconciler_STAR_49106;
}});})(x49103_49119))
;


fulcro_spec.renderer.TestReport.prototype.constructor = fulcro_spec.renderer.TestReport;

fulcro_spec.renderer.TestReport.prototype.constructor.displayName = "fulcro-spec.renderer/TestReport";

fulcro_spec.renderer.TestReport.prototype.om$isComponent = true;

var x49117_49123 = fulcro_spec.renderer.TestReport;
/** @nocollapse */
x49117_49123.fulcro$client$core$InitialAppState$ = cljs.core.PROTOCOL_SENTINEL;

/** @nocollapse */
x49117_49123.fulcro$client$core$InitialAppState$initial_state$arity$2 = ((function (x49117_49123){
return (function (this$,_){
var this$__$1 = this;
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword("ui","react-key","ui/react-key",1337877664),cljs.core.gensym.call(null,"UI_REACT_KEY"),new cljs.core.Keyword(null,"compile-error","compile-error",-1313154526),null,new cljs.core.Keyword("ui","current-filter","ui/current-filter",1519811523),new cljs.core.Keyword(null,"all","all",892129742)], null);
});})(x49117_49123))
;

/** @nocollapse */
x49117_49123.om$next$IQuery$ = cljs.core.PROTOCOL_SENTINEL;

/** @nocollapse */
x49117_49123.om$next$IQuery$query$arity$1 = ((function (x49117_49123){
return (function (this$){
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("ui","react-key","ui/react-key",1337877664),new cljs.core.Keyword(null,"test-report","test-report",-769743150),new cljs.core.Keyword(null,"compile-error","compile-error",-1313154526),new cljs.core.Keyword("ui","current-filter","ui/current-filter",1519811523),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"selectors","selectors",-680741768),om.next.get_query.call(null,fulcro_spec.renderer.SelectorControl)], null)], null);
});})(x49117_49123))
;


var x49118_49124 = fulcro_spec.renderer.TestReport.prototype;

x49118_49124.fulcro$client$core$InitialAppState$ = cljs.core.PROTOCOL_SENTINEL;


x49118_49124.fulcro$client$core$InitialAppState$initial_state$arity$2 = ((function (x49118_49124){
return (function (this$,_){
var this$__$1 = this;
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword("ui","react-key","ui/react-key",1337877664),cljs.core.gensym.call(null,"UI_REACT_KEY"),new cljs.core.Keyword(null,"compile-error","compile-error",-1313154526),null,new cljs.core.Keyword("ui","current-filter","ui/current-filter",1519811523),new cljs.core.Keyword(null,"all","all",892129742)], null);
});})(x49118_49124))
;


x49118_49124.om$next$IQuery$ = cljs.core.PROTOCOL_SENTINEL;


x49118_49124.om$next$IQuery$query$arity$1 = ((function (x49118_49124){
return (function (this$){
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("ui","react-key","ui/react-key",1337877664),new cljs.core.Keyword(null,"test-report","test-report",-769743150),new cljs.core.Keyword(null,"compile-error","compile-error",-1313154526),new cljs.core.Keyword("ui","current-filter","ui/current-filter",1519811523),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"selectors","selectors",-680741768),om.next.get_query.call(null,fulcro_spec.renderer.SelectorControl)], null)], null);
});})(x49118_49124))
;


fulcro_spec.renderer.TestReport.cljs$lang$type = true;

fulcro_spec.renderer.TestReport.cljs$lang$ctorStr = "fulcro-spec.renderer/TestReport";

fulcro_spec.renderer.TestReport.cljs$lang$ctorPrWriter = (function (this__35635__auto__,writer__35636__auto__,opt__35637__auto__){
return cljs.core._write.call(null,writer__35636__auto__,"fulcro-spec.renderer/TestReport");
});
cljs.core._add_method.call(null,fulcro.client.mutations.mutate,new cljs.core.Symbol("fulcro-spec.renderer","render-tests","fulcro-spec.renderer/render-tests",658035607,null),(function (env49125,_,new_report){
return cljs.core.merge.call(null,(function (){var map__49126 = env49125;
var map__49126__$1 = ((((!((map__49126 == null)))?((((map__49126.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__49126.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49126):map__49126);
var state = cljs.core.get.call(null,map__49126__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"action","action",-811238024),((function (map__49126,map__49126__$1,state){
return (function (){
return cljs.core.swap_BANG_.call(null,state,cljs.core.assoc,new cljs.core.Keyword(null,"test-report","test-report",-769743150),new_report);
});})(map__49126,map__49126__$1,state))
], null);
})(),(function (){var env = env49125;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"remote","remote",-1593576576),false], null);
})());
}));
cljs.core._add_method.call(null,fulcro.client.mutations.mutate,new cljs.core.Symbol("fulcro-spec.renderer","show-compile-error","fulcro-spec.renderer/show-compile-error",-1959581225,null),(function (env49128,_,p__49129){
var map__49130 = p__49129;
var map__49130__$1 = ((((!((map__49130 == null)))?((((map__49130.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__49130.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49130):map__49130);
var error = cljs.core.get.call(null,map__49130__$1,new cljs.core.Keyword(null,"error","error",-978969032));
return cljs.core.merge.call(null,(function (){var map__49132 = env49128;
var map__49132__$1 = ((((!((map__49132 == null)))?((((map__49132.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__49132.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49132):map__49132);
var state = cljs.core.get.call(null,map__49132__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"action","action",-811238024),((function (map__49132,map__49132__$1,state,map__49130,map__49130__$1,error){
return (function (){
return cljs.core.swap_BANG_.call(null,state,cljs.core.assoc,new cljs.core.Keyword(null,"compile-error","compile-error",-1313154526),error);
});})(map__49132,map__49132__$1,state,map__49130,map__49130__$1,error))
], null);
})(),(function (){var env = env49128;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"remote","remote",-1593576576),false], null);
})());
}));
cljs.core._add_method.call(null,fulcro.client.mutations.mutate,new cljs.core.Symbol("fulcro-spec.renderer","clear-compile-error","fulcro-spec.renderer/clear-compile-error",-616390103,null),(function (env49134,_,ignored){
return cljs.core.merge.call(null,(function (){var map__49135 = env49134;
var map__49135__$1 = ((((!((map__49135 == null)))?((((map__49135.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__49135.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49135):map__49135);
var state = cljs.core.get.call(null,map__49135__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"action","action",-811238024),((function (map__49135,map__49135__$1,state){
return (function (){
return cljs.core.swap_BANG_.call(null,state,cljs.core.assoc,new cljs.core.Keyword(null,"compile-error","compile-error",-1313154526),false);
});})(map__49135,map__49135__$1,state))
], null);
})(),(function (){var env = env49134;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"remote","remote",-1593576576),false], null);
})());
}));
cljs.core._add_method.call(null,fulcro.websockets.networking.push_received,new cljs.core.Symbol("fulcro-spec.renderer","render-tests","fulcro-spec.renderer/render-tests",658035607,null),(function (p__49137,p__49138){
var map__49139 = p__49137;
var map__49139__$1 = ((((!((map__49139 == null)))?((((map__49139.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__49139.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49139):map__49139);
var reconciler = cljs.core.get.call(null,map__49139__$1,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966));
var map__49140 = p__49138;
var map__49140__$1 = ((((!((map__49140 == null)))?((((map__49140.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__49140.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49140):map__49140);
var test_report = cljs.core.get.call(null,map__49140__$1,new cljs.core.Keyword(null,"msg","msg",-1386103444));
return om.next.transact_BANG_.call(null,om.next.app_root.call(null,reconciler),cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__29003__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("fulcro-spec.renderer","clear-compile-error","fulcro-spec.renderer/clear-compile-error",-616390103,null)),(function (){var x__29003__auto__ = cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__29003__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__29003__auto__);
})(),(function (){var x__29003__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("fulcro-spec.renderer","render-tests","fulcro-spec.renderer/render-tests",658035607,null)),(function (){var x__29003__auto__ = test_report;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__29003__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__29003__auto__);
})())))));
}));
cljs.core._add_method.call(null,fulcro.websockets.networking.push_received,new cljs.core.Symbol("fulcro-spec.renderer","show-compile-error","fulcro-spec.renderer/show-compile-error",-1959581225,null),(function (p__49143,p__49144){
var map__49145 = p__49143;
var map__49145__$1 = ((((!((map__49145 == null)))?((((map__49145.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__49145.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49145):map__49145);
var reconciler = cljs.core.get.call(null,map__49145__$1,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966));
var map__49146 = p__49144;
var map__49146__$1 = ((((!((map__49146 == null)))?((((map__49146.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__49146.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49146):map__49146);
var message = cljs.core.get.call(null,map__49146__$1,new cljs.core.Keyword(null,"msg","msg",-1386103444));
return om.next.transact_BANG_.call(null,om.next.app_root.call(null,reconciler),cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__29003__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("fulcro-spec.renderer","show-compile-error","fulcro-spec.renderer/show-compile-error",-1959581225,null)),(function (){var x__29003__auto__ = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"error","error",-978969032),message], null);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__29003__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__29003__auto__);
})())))));
}));
if(typeof fulcro_spec.renderer.networking !== 'undefined'){
} else {
fulcro_spec.renderer.networking = cljs.core.atom.call(null,null);
}

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {com.stuartsierra.component.Lifecycle}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fulcro_spec.renderer.TestRenderer = (function (root,target,with_websockets_QMARK_,runner_atom,__meta,__extmap,__hash){
this.root = root;
this.target = target;
this.with_websockets_QMARK_ = with_websockets_QMARK_;
this.runner_atom = runner_atom;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});

fulcro_spec.renderer.TestRenderer.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__28781__auto__,k__28782__auto__){
var self__ = this;
var this__28781__auto____$1 = this;
return this__28781__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__28782__auto__,null);
});


fulcro_spec.renderer.TestRenderer.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__28783__auto__,k49150,else__28784__auto__){
var self__ = this;
var this__28783__auto____$1 = this;
var G__49154 = k49150;
var G__49154__$1 = (((G__49154 instanceof cljs.core.Keyword))?G__49154.fqn:null);
switch (G__49154__$1) {
case "root":
return self__.root;

break;
case "target":
return self__.target;

break;
case "with-websockets?":
return self__.with_websockets_QMARK_;

break;
case "runner-atom":
return self__.runner_atom;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k49150,else__28784__auto__);

}
});


fulcro_spec.renderer.TestRenderer.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__28795__auto__,writer__28796__auto__,opts__28797__auto__){
var self__ = this;
var this__28795__auto____$1 = this;
var pr_pair__28798__auto__ = ((function (this__28795__auto____$1){
return (function (keyval__28799__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__28796__auto__,cljs.core.pr_writer,""," ","",opts__28797__auto__,keyval__28799__auto__);
});})(this__28795__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__28796__auto__,pr_pair__28798__auto__,"#fulcro-spec.renderer.TestRenderer{",", ","}",opts__28797__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"root","root",-448657453),self__.root],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"target","target",253001721),self__.target],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"with-websockets?","with-websockets?",-1841272103),self__.with_websockets_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"runner-atom","runner-atom",617192507),self__.runner_atom],null))], null),self__.__extmap));
});


fulcro_spec.renderer.TestRenderer.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__49149){
var self__ = this;
var G__49149__$1 = this;
return (new cljs.core.RecordIter((0),G__49149__$1,4,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"root","root",-448657453),new cljs.core.Keyword(null,"target","target",253001721),new cljs.core.Keyword(null,"with-websockets?","with-websockets?",-1841272103),new cljs.core.Keyword(null,"runner-atom","runner-atom",617192507)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});


fulcro_spec.renderer.TestRenderer.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__28779__auto__){
var self__ = this;
var this__28779__auto____$1 = this;
return self__.__meta;
});


fulcro_spec.renderer.TestRenderer.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__28776__auto__){
var self__ = this;
var this__28776__auto____$1 = this;
return (new fulcro_spec.renderer.TestRenderer(self__.root,self__.target,self__.with_websockets_QMARK_,self__.runner_atom,self__.__meta,self__.__extmap,self__.__hash));
});


fulcro_spec.renderer.TestRenderer.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__28785__auto__){
var self__ = this;
var this__28785__auto____$1 = this;
return (4 + cljs.core.count.call(null,self__.__extmap));
});


fulcro_spec.renderer.TestRenderer.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__28777__auto__){
var self__ = this;
var this__28777__auto____$1 = this;
var h__28595__auto__ = self__.__hash;
if(!((h__28595__auto__ == null))){
return h__28595__auto__;
} else {
var h__28595__auto____$1 = ((function (h__28595__auto__,this__28777__auto____$1){
return (function (coll__28778__auto__){
return (1773823653 ^ cljs.core.hash_unordered_coll.call(null,coll__28778__auto__));
});})(h__28595__auto__,this__28777__auto____$1))
.call(null,this__28777__auto____$1);
self__.__hash = h__28595__auto____$1;

return h__28595__auto____$1;
}
});


fulcro_spec.renderer.TestRenderer.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this49151,other49152){
var self__ = this;
var this49151__$1 = this;
return (!((other49152 == null))) && ((this49151__$1.constructor === other49152.constructor)) && (cljs.core._EQ_.call(null,this49151__$1.root,other49152.root)) && (cljs.core._EQ_.call(null,this49151__$1.target,other49152.target)) && (cljs.core._EQ_.call(null,this49151__$1.with_websockets_QMARK_,other49152.with_websockets_QMARK_)) && (cljs.core._EQ_.call(null,this49151__$1.runner_atom,other49152.runner_atom)) && (cljs.core._EQ_.call(null,this49151__$1.__extmap,other49152.__extmap));
});


fulcro_spec.renderer.TestRenderer.prototype.com$stuartsierra$component$Lifecycle$ = cljs.core.PROTOCOL_SENTINEL;


fulcro_spec.renderer.TestRenderer.prototype.com$stuartsierra$component$Lifecycle$start$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
try{var app = fulcro.client.core.new_fulcro_client.call(null,new cljs.core.Keyword(null,"networking","networking",586110628),(cljs.core.truth_(self__.with_websockets_QMARK_)?(function (){
cljs.core.reset_BANG_.call(null,fulcro_spec.renderer.networking,fulcro.websockets.networking.make_channel_client.call(null,"/_fulcro_spec_chsk"));

return cljs.core.deref.call(null,fulcro_spec.renderer.networking);
})()
:(function (){
if(typeof fulcro_spec.renderer.t_fulcro_spec$renderer49156 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {fulcro.client.network.FulcroNetwork}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
fulcro_spec.renderer.t_fulcro_spec$renderer49156 = (function (root,target,with_websockets_QMARK_,runner_atom,__meta,__extmap,__hash,this$,meta49157){
this.root = root;
this.target = target;
this.with_websockets_QMARK_ = with_websockets_QMARK_;
this.runner_atom = runner_atom;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.this$ = this$;
this.meta49157 = meta49157;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

fulcro_spec.renderer.t_fulcro_spec$renderer49156.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (this$__$1){
return (function (_49158,meta49157__$1){
var self__ = this;
var _49158__$1 = this;
return (new fulcro_spec.renderer.t_fulcro_spec$renderer49156(self__.root,self__.target,self__.with_websockets_QMARK_,self__.runner_atom,self__.__meta,self__.__extmap,self__.__hash,self__.this$,meta49157__$1));
});})(this$__$1))
;


fulcro_spec.renderer.t_fulcro_spec$renderer49156.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (this$__$1){
return (function (_49158){
var self__ = this;
var _49158__$1 = this;
return self__.meta49157;
});})(this$__$1))
;


fulcro_spec.renderer.t_fulcro_spec$renderer49156.prototype.fulcro$client$network$FulcroNetwork$ = cljs.core.PROTOCOL_SENTINEL;


fulcro_spec.renderer.t_fulcro_spec$renderer49156.prototype.fulcro$client$network$FulcroNetwork$start$arity$1 = ((function (this$__$1){
return (function (this$__$1){
var self__ = this;
var this$__$2 = this;
return this$__$2;
});})(this$__$1))
;


fulcro_spec.renderer.t_fulcro_spec$renderer49156.prototype.fulcro$client$network$FulcroNetwork$send$arity$4 = ((function (this$__$1){
return (function (this$__$1,edn,ok,err){
var self__ = this;
var this$__$2 = this;
return ok.call(null,om.next.parser.call(null,cljs.core.deref.call(null,self__.runner_atom)).call(null,cljs.core.deref.call(null,self__.runner_atom),edn));
});})(this$__$1))
;

fulcro_spec.renderer.t_fulcro_spec$renderer49156.getBasis = ((function (this$__$1){
return (function (){
return new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"root","root",1191874074,null),new cljs.core.Symbol(null,"target","target",1893533248,null),new cljs.core.Symbol(null,"with-websockets?","with-websockets?",-200740576,null),new cljs.core.Symbol(null,"runner-atom","runner-atom",-2037243262,null),new cljs.core.Symbol(null,"__meta","__meta",-946752628,null),new cljs.core.Symbol(null,"__extmap","__extmap",-1435580931,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"this","this",1028897902,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("fulcro-spec.renderer","TestRenderer","fulcro-spec.renderer/TestRenderer",-580758391,null)], null)),new cljs.core.Symbol(null,"meta49157","meta49157",685497320,null)], null);
});})(this$__$1))
;

fulcro_spec.renderer.t_fulcro_spec$renderer49156.cljs$lang$type = true;

fulcro_spec.renderer.t_fulcro_spec$renderer49156.cljs$lang$ctorStr = "fulcro-spec.renderer/t_fulcro_spec$renderer49156";

fulcro_spec.renderer.t_fulcro_spec$renderer49156.cljs$lang$ctorPrWriter = ((function (this$__$1){
return (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"fulcro-spec.renderer/t_fulcro_spec$renderer49156");
});})(this$__$1))
;

fulcro_spec.renderer.__GT_t_fulcro_spec$renderer49156 = ((function (this$__$1){
return (function fulcro_spec$renderer$__GT_t_fulcro_spec$renderer49156(root__$1,target__$1,with_websockets_QMARK___$1,runner_atom__$1,__meta__$1,__extmap__$1,__hash__$1,this$__$2,meta49157){
return (new fulcro_spec.renderer.t_fulcro_spec$renderer49156(root__$1,target__$1,with_websockets_QMARK___$1,runner_atom__$1,__meta__$1,__extmap__$1,__hash__$1,this$__$2,meta49157));
});})(this$__$1))
;

}

return (new fulcro_spec.renderer.t_fulcro_spec$renderer49156(self__.root,self__.target,self__.with_websockets_QMARK_,self__.runner_atom,self__.__meta,self__.__extmap,self__.__hash,this$__$1,cljs.core.PersistentArrayMap.EMPTY));
})()
),new cljs.core.Keyword(null,"started-callback","started-callback",-1798586951),((function (this$__$1){
return (function (app){
if(cljs.core.truth_((function (){var and__28129__auto__ = self__.with_websockets_QMARK_;
if(cljs.core.truth_(and__28129__auto__)){
return cljs.core.deref.call(null,fulcro_spec.renderer.networking);
} else {
return and__28129__auto__;
}
})())){
fulcro.websockets.networking.install_push_handlers.call(null,cljs.core.deref.call(null,fulcro_spec.renderer.networking),app);
} else {
}

return fulcro.client.data_fetch.load.call(null,app,new cljs.core.Keyword(null,"selectors","selectors",-680741768),fulcro_spec.renderer.SelectorControl,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"post-mutation","post-mutation",-1076606705),new cljs.core.Symbol("fulcro-spec.selectors","set-selectors","fulcro-spec.selectors/set-selectors",-193971597,null)], null));
});})(this$__$1))
);
return cljs.core.assoc.call(null,this$__$1,new cljs.core.Keyword(null,"app","app",-560961707),fulcro.client.core.mount.call(null,app,self__.root,self__.target));
}catch (e49155){if((e49155 instanceof Object)){
var e = e49155;
return console.log("Startup Failed: ",e);
} else {
throw e49155;

}
}});


fulcro_spec.renderer.TestRenderer.prototype.com$stuartsierra$component$Lifecycle$stop$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.assoc.call(null,this$__$1,new cljs.core.Keyword(null,"app","app",-560961707),null);
});


fulcro_spec.renderer.TestRenderer.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__28790__auto__,k__28791__auto__){
var self__ = this;
var this__28790__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"root","root",-448657453),null,new cljs.core.Keyword(null,"with-websockets?","with-websockets?",-1841272103),null,new cljs.core.Keyword(null,"target","target",253001721),null,new cljs.core.Keyword(null,"runner-atom","runner-atom",617192507),null], null), null),k__28791__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__28790__auto____$1),self__.__meta),k__28791__auto__);
} else {
return (new fulcro_spec.renderer.TestRenderer(self__.root,self__.target,self__.with_websockets_QMARK_,self__.runner_atom,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__28791__auto__)),null));
}
});


fulcro_spec.renderer.TestRenderer.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__28788__auto__,k__28789__auto__,G__49149){
var self__ = this;
var this__28788__auto____$1 = this;
var pred__49159 = cljs.core.keyword_identical_QMARK_;
var expr__49160 = k__28789__auto__;
if(cljs.core.truth_(pred__49159.call(null,new cljs.core.Keyword(null,"root","root",-448657453),expr__49160))){
return (new fulcro_spec.renderer.TestRenderer(G__49149,self__.target,self__.with_websockets_QMARK_,self__.runner_atom,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__49159.call(null,new cljs.core.Keyword(null,"target","target",253001721),expr__49160))){
return (new fulcro_spec.renderer.TestRenderer(self__.root,G__49149,self__.with_websockets_QMARK_,self__.runner_atom,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__49159.call(null,new cljs.core.Keyword(null,"with-websockets?","with-websockets?",-1841272103),expr__49160))){
return (new fulcro_spec.renderer.TestRenderer(self__.root,self__.target,G__49149,self__.runner_atom,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__49159.call(null,new cljs.core.Keyword(null,"runner-atom","runner-atom",617192507),expr__49160))){
return (new fulcro_spec.renderer.TestRenderer(self__.root,self__.target,self__.with_websockets_QMARK_,G__49149,self__.__meta,self__.__extmap,null));
} else {
return (new fulcro_spec.renderer.TestRenderer(self__.root,self__.target,self__.with_websockets_QMARK_,self__.runner_atom,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__28789__auto__,G__49149),null));
}
}
}
}
});


fulcro_spec.renderer.TestRenderer.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__28793__auto__){
var self__ = this;
var this__28793__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"root","root",-448657453),self__.root],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"target","target",253001721),self__.target],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"with-websockets?","with-websockets?",-1841272103),self__.with_websockets_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"runner-atom","runner-atom",617192507),self__.runner_atom],null))], null),self__.__extmap));
});


fulcro_spec.renderer.TestRenderer.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__28780__auto__,G__49149){
var self__ = this;
var this__28780__auto____$1 = this;
return (new fulcro_spec.renderer.TestRenderer(self__.root,self__.target,self__.with_websockets_QMARK_,self__.runner_atom,G__49149,self__.__extmap,self__.__hash));
});


fulcro_spec.renderer.TestRenderer.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__28786__auto__,entry__28787__auto__){
var self__ = this;
var this__28786__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__28787__auto__)){
return this__28786__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__28787__auto__,(0)),cljs.core._nth.call(null,entry__28787__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__28786__auto____$1,entry__28787__auto__);
}
});

fulcro_spec.renderer.TestRenderer.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"root","root",1191874074,null),new cljs.core.Symbol(null,"target","target",1893533248,null),new cljs.core.Symbol(null,"with-websockets?","with-websockets?",-200740576,null),new cljs.core.Symbol(null,"runner-atom","runner-atom",-2037243262,null)], null);
});

fulcro_spec.renderer.TestRenderer.cljs$lang$type = true;

fulcro_spec.renderer.TestRenderer.cljs$lang$ctorPrSeq = (function (this__28817__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"fulcro-spec.renderer/TestRenderer");
});

fulcro_spec.renderer.TestRenderer.cljs$lang$ctorPrWriter = (function (this__28817__auto__,writer__28818__auto__){
return cljs.core._write.call(null,writer__28818__auto__,"fulcro-spec.renderer/TestRenderer");
});

fulcro_spec.renderer.__GT_TestRenderer = (function fulcro_spec$renderer$__GT_TestRenderer(root,target,with_websockets_QMARK_,runner_atom){
return (new fulcro_spec.renderer.TestRenderer(root,target,with_websockets_QMARK_,runner_atom,null,null,null));
});

fulcro_spec.renderer.map__GT_TestRenderer = (function fulcro_spec$renderer$map__GT_TestRenderer(G__49153){
return (new fulcro_spec.renderer.TestRenderer(new cljs.core.Keyword(null,"root","root",-448657453).cljs$core$IFn$_invoke$arity$1(G__49153),new cljs.core.Keyword(null,"target","target",253001721).cljs$core$IFn$_invoke$arity$1(G__49153),new cljs.core.Keyword(null,"with-websockets?","with-websockets?",-1841272103).cljs$core$IFn$_invoke$arity$1(G__49153),new cljs.core.Keyword(null,"runner-atom","runner-atom",617192507).cljs$core$IFn$_invoke$arity$1(G__49153),null,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,G__49153,new cljs.core.Keyword(null,"root","root",-448657453),new cljs.core.Keyword(null,"target","target",253001721),new cljs.core.Keyword(null,"with-websockets?","with-websockets?",-1841272103),new cljs.core.Keyword(null,"runner-atom","runner-atom",617192507))),null));
});

fulcro_spec.renderer.make_test_renderer = (function fulcro_spec$renderer$make_test_renderer(p__49163){
var map__49164 = p__49163;
var map__49164__$1 = ((((!((map__49164 == null)))?((((map__49164.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__49164.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49164):map__49164);
var with_websockets_QMARK_ = cljs.core.get.call(null,map__49164__$1,new cljs.core.Keyword(null,"with-websockets?","with-websockets?",-1841272103),true);
return fulcro_spec.renderer.map__GT_TestRenderer.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"with-websockets?","with-websockets?",-1841272103),with_websockets_QMARK_,new cljs.core.Keyword(null,"runner-atom","runner-atom",617192507),cljs.core.atom.call(null,null),new cljs.core.Keyword(null,"root","root",-448657453),fulcro_spec.renderer.TestReport,new cljs.core.Keyword(null,"target","target",253001721),"fulcro-spec-report"], null));
});

//# sourceMappingURL=renderer.js.map?rel=1511229551527
