// Compiled by ClojureScript 1.9.946 {}
goog.provide('fulcro_spec.async');
goog.require('cljs.core');
goog.require('cljs.pprint');

/**
 * @interface
 */
fulcro_spec.async.IAsyncQueue = function(){};

/**
 * Returns the current time on the simulated clock, in ms
 */
fulcro_spec.async.current_time = (function fulcro_spec$async$current_time(this$){
if((!((this$ == null))) && (!((this$.fulcro_spec$async$IAsyncQueue$current_time$arity$1 == null)))){
return this$.fulcro_spec$async$IAsyncQueue$current_time$arity$1(this$);
} else {
var x__28824__auto__ = (((this$ == null))?null:this$);
var m__28825__auto__ = (fulcro_spec.async.current_time[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,this$);
} else {
var m__28825__auto____$1 = (fulcro_spec.async.current_time["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IAsyncQueue.current-time",this$);
}
}
}
});

/**
 * Returns the first event on the queue
 */
fulcro_spec.async.peek_event = (function fulcro_spec$async$peek_event(this$){
if((!((this$ == null))) && (!((this$.fulcro_spec$async$IAsyncQueue$peek_event$arity$1 == null)))){
return this$.fulcro_spec$async$IAsyncQueue$peek_event$arity$1(this$);
} else {
var x__28824__auto__ = (((this$ == null))?null:this$);
var m__28825__auto__ = (fulcro_spec.async.peek_event[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,this$);
} else {
var m__28825__auto____$1 = (fulcro_spec.async.peek_event["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IAsyncQueue.peek-event",this$);
}
}
}
});

/**
 * Move the clock forward by the specified number of ms, triggering events (even those added by interstitial triggers) in the correct order up to (and including) events that coincide with the final time.
 */
fulcro_spec.async.advance_clock = (function fulcro_spec$async$advance_clock(this$,ms){
if((!((this$ == null))) && (!((this$.fulcro_spec$async$IAsyncQueue$advance_clock$arity$2 == null)))){
return this$.fulcro_spec$async$IAsyncQueue$advance_clock$arity$2(this$,ms);
} else {
var x__28824__auto__ = (((this$ == null))?null:this$);
var m__28825__auto__ = (fulcro_spec.async.advance_clock[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,this$,ms);
} else {
var m__28825__auto____$1 = (fulcro_spec.async.advance_clock["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,this$,ms);
} else {
throw cljs.core.missing_protocol.call(null,"IAsyncQueue.advance-clock",this$);
}
}
}
});

/**
 * Schedule an event which should occur at some time in the future (offset from now).
 */
fulcro_spec.async.schedule_event = (function fulcro_spec$async$schedule_event(this$,ms_from_now,fn_to_call){
if((!((this$ == null))) && (!((this$.fulcro_spec$async$IAsyncQueue$schedule_event$arity$3 == null)))){
return this$.fulcro_spec$async$IAsyncQueue$schedule_event$arity$3(this$,ms_from_now,fn_to_call);
} else {
var x__28824__auto__ = (((this$ == null))?null:this$);
var m__28825__auto__ = (fulcro_spec.async.schedule_event[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,this$,ms_from_now,fn_to_call);
} else {
var m__28825__auto____$1 = (fulcro_spec.async.schedule_event["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,this$,ms_from_now,fn_to_call);
} else {
throw cljs.core.missing_protocol.call(null,"IAsyncQueue.schedule-event",this$);
}
}
}
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fulcro_spec.async.Event = (function (abs_time,fn_to_call,__meta,__extmap,__hash){
this.abs_time = abs_time;
this.fn_to_call = fn_to_call;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});

fulcro_spec.async.Event.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__28781__auto__,k__28782__auto__){
var self__ = this;
var this__28781__auto____$1 = this;
return this__28781__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__28782__auto__,null);
});


fulcro_spec.async.Event.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__28783__auto__,k50467,else__28784__auto__){
var self__ = this;
var this__28783__auto____$1 = this;
var G__50471 = k50467;
var G__50471__$1 = (((G__50471 instanceof cljs.core.Keyword))?G__50471.fqn:null);
switch (G__50471__$1) {
case "abs-time":
return self__.abs_time;

break;
case "fn-to-call":
return self__.fn_to_call;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k50467,else__28784__auto__);

}
});


fulcro_spec.async.Event.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__28795__auto__,writer__28796__auto__,opts__28797__auto__){
var self__ = this;
var this__28795__auto____$1 = this;
var pr_pair__28798__auto__ = ((function (this__28795__auto____$1){
return (function (keyval__28799__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__28796__auto__,cljs.core.pr_writer,""," ","",opts__28797__auto__,keyval__28799__auto__);
});})(this__28795__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__28796__auto__,pr_pair__28798__auto__,"#fulcro-spec.async.Event{",", ","}",opts__28797__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"abs-time","abs-time",59488074),self__.abs_time],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fn-to-call","fn-to-call",-596918373),self__.fn_to_call],null))], null),self__.__extmap));
});


fulcro_spec.async.Event.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__50466){
var self__ = this;
var G__50466__$1 = this;
return (new cljs.core.RecordIter((0),G__50466__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"abs-time","abs-time",59488074),new cljs.core.Keyword(null,"fn-to-call","fn-to-call",-596918373)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});


fulcro_spec.async.Event.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__28779__auto__){
var self__ = this;
var this__28779__auto____$1 = this;
return self__.__meta;
});


fulcro_spec.async.Event.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__28776__auto__){
var self__ = this;
var this__28776__auto____$1 = this;
return (new fulcro_spec.async.Event(self__.abs_time,self__.fn_to_call,self__.__meta,self__.__extmap,self__.__hash));
});


fulcro_spec.async.Event.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__28785__auto__){
var self__ = this;
var this__28785__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});


fulcro_spec.async.Event.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__28777__auto__){
var self__ = this;
var this__28777__auto____$1 = this;
var h__28595__auto__ = self__.__hash;
if(!((h__28595__auto__ == null))){
return h__28595__auto__;
} else {
var h__28595__auto____$1 = ((function (h__28595__auto__,this__28777__auto____$1){
return (function (coll__28778__auto__){
return (2079420738 ^ cljs.core.hash_unordered_coll.call(null,coll__28778__auto__));
});})(h__28595__auto__,this__28777__auto____$1))
.call(null,this__28777__auto____$1);
self__.__hash = h__28595__auto____$1;

return h__28595__auto____$1;
}
});


fulcro_spec.async.Event.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this50468,other50469){
var self__ = this;
var this50468__$1 = this;
return (!((other50469 == null))) && ((this50468__$1.constructor === other50469.constructor)) && (cljs.core._EQ_.call(null,this50468__$1.abs_time,other50469.abs_time)) && (cljs.core._EQ_.call(null,this50468__$1.fn_to_call,other50469.fn_to_call)) && (cljs.core._EQ_.call(null,this50468__$1.__extmap,other50469.__extmap));
});


fulcro_spec.async.Event.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__28790__auto__,k__28791__auto__){
var self__ = this;
var this__28790__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"abs-time","abs-time",59488074),null,new cljs.core.Keyword(null,"fn-to-call","fn-to-call",-596918373),null], null), null),k__28791__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__28790__auto____$1),self__.__meta),k__28791__auto__);
} else {
return (new fulcro_spec.async.Event(self__.abs_time,self__.fn_to_call,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__28791__auto__)),null));
}
});


fulcro_spec.async.Event.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__28788__auto__,k__28789__auto__,G__50466){
var self__ = this;
var this__28788__auto____$1 = this;
var pred__50472 = cljs.core.keyword_identical_QMARK_;
var expr__50473 = k__28789__auto__;
if(cljs.core.truth_(pred__50472.call(null,new cljs.core.Keyword(null,"abs-time","abs-time",59488074),expr__50473))){
return (new fulcro_spec.async.Event(G__50466,self__.fn_to_call,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__50472.call(null,new cljs.core.Keyword(null,"fn-to-call","fn-to-call",-596918373),expr__50473))){
return (new fulcro_spec.async.Event(self__.abs_time,G__50466,self__.__meta,self__.__extmap,null));
} else {
return (new fulcro_spec.async.Event(self__.abs_time,self__.fn_to_call,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__28789__auto__,G__50466),null));
}
}
});


fulcro_spec.async.Event.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__28793__auto__){
var self__ = this;
var this__28793__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"abs-time","abs-time",59488074),self__.abs_time],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fn-to-call","fn-to-call",-596918373),self__.fn_to_call],null))], null),self__.__extmap));
});


fulcro_spec.async.Event.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__28780__auto__,G__50466){
var self__ = this;
var this__28780__auto____$1 = this;
return (new fulcro_spec.async.Event(self__.abs_time,self__.fn_to_call,G__50466,self__.__extmap,self__.__hash));
});


fulcro_spec.async.Event.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__28786__auto__,entry__28787__auto__){
var self__ = this;
var this__28786__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__28787__auto__)){
return this__28786__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__28787__auto__,(0)),cljs.core._nth.call(null,entry__28787__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__28786__auto____$1,entry__28787__auto__);
}
});

fulcro_spec.async.Event.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"abs-time","abs-time",1700019601,null),new cljs.core.Symbol(null,"fn-to-call","fn-to-call",1043613154,null)], null);
});

fulcro_spec.async.Event.cljs$lang$type = true;

fulcro_spec.async.Event.cljs$lang$ctorPrSeq = (function (this__28817__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"fulcro-spec.async/Event");
});

fulcro_spec.async.Event.cljs$lang$ctorPrWriter = (function (this__28817__auto__,writer__28818__auto__){
return cljs.core._write.call(null,writer__28818__auto__,"fulcro-spec.async/Event");
});

fulcro_spec.async.__GT_Event = (function fulcro_spec$async$__GT_Event(abs_time,fn_to_call){
return (new fulcro_spec.async.Event(abs_time,fn_to_call,null,null,null));
});

fulcro_spec.async.map__GT_Event = (function fulcro_spec$async$map__GT_Event(G__50470){
return (new fulcro_spec.async.Event(new cljs.core.Keyword(null,"abs-time","abs-time",59488074).cljs$core$IFn$_invoke$arity$1(G__50470),new cljs.core.Keyword(null,"fn-to-call","fn-to-call",-596918373).cljs$core$IFn$_invoke$arity$1(G__50470),null,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,G__50470,new cljs.core.Keyword(null,"abs-time","abs-time",59488074),new cljs.core.Keyword(null,"fn-to-call","fn-to-call",-596918373))),null));
});

/**
 * Triggers the first event in the queue (runs it), and removes it from the queue.
 */
fulcro_spec.async.process_first_event_BANG_ = (function fulcro_spec$async$process_first_event_BANG_(queue){
var temp__4655__auto__ = fulcro_spec.async.peek_event.call(null,queue);
if(cljs.core.truth_(temp__4655__auto__)){
var evt = temp__4655__auto__;
new cljs.core.Keyword(null,"fn-to-call","fn-to-call",-596918373).cljs$core$IFn$_invoke$arity$1(evt).call(null);

return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"schedule","schedule",349275266).cljs$core$IFn$_invoke$arity$1(queue),((function (evt,temp__4655__auto__){
return (function (p1__50476_SHARP_){
return cljs.core.dissoc.call(null,p1__50476_SHARP_,new cljs.core.Keyword(null,"abs-time","abs-time",59488074).cljs$core$IFn$_invoke$arity$1(evt));
});})(evt,temp__4655__auto__))
);
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {fulcro_spec.async.IAsyncQueue}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fulcro_spec.async.AsyncQueue = (function (schedule,now,__meta,__extmap,__hash){
this.schedule = schedule;
this.now = now;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});

fulcro_spec.async.AsyncQueue.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__28781__auto__,k__28782__auto__){
var self__ = this;
var this__28781__auto____$1 = this;
return this__28781__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__28782__auto__,null);
});


fulcro_spec.async.AsyncQueue.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__28783__auto__,k50479,else__28784__auto__){
var self__ = this;
var this__28783__auto____$1 = this;
var G__50483 = k50479;
var G__50483__$1 = (((G__50483 instanceof cljs.core.Keyword))?G__50483.fqn:null);
switch (G__50483__$1) {
case "schedule":
return self__.schedule;

break;
case "now":
return self__.now;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k50479,else__28784__auto__);

}
});


fulcro_spec.async.AsyncQueue.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__28795__auto__,writer__28796__auto__,opts__28797__auto__){
var self__ = this;
var this__28795__auto____$1 = this;
var pr_pair__28798__auto__ = ((function (this__28795__auto____$1){
return (function (keyval__28799__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__28796__auto__,cljs.core.pr_writer,""," ","",opts__28797__auto__,keyval__28799__auto__);
});})(this__28795__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__28796__auto__,pr_pair__28798__auto__,"#fulcro-spec.async.AsyncQueue{",", ","}",opts__28797__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schedule","schedule",349275266),self__.schedule],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"now","now",-1650525531),self__.now],null))], null),self__.__extmap));
});


fulcro_spec.async.AsyncQueue.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__50478){
var self__ = this;
var G__50478__$1 = this;
return (new cljs.core.RecordIter((0),G__50478__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schedule","schedule",349275266),new cljs.core.Keyword(null,"now","now",-1650525531)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});


fulcro_spec.async.AsyncQueue.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__28779__auto__){
var self__ = this;
var this__28779__auto____$1 = this;
return self__.__meta;
});


fulcro_spec.async.AsyncQueue.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__28776__auto__){
var self__ = this;
var this__28776__auto____$1 = this;
return (new fulcro_spec.async.AsyncQueue(self__.schedule,self__.now,self__.__meta,self__.__extmap,self__.__hash));
});


fulcro_spec.async.AsyncQueue.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__28785__auto__){
var self__ = this;
var this__28785__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});


fulcro_spec.async.AsyncQueue.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__28777__auto__){
var self__ = this;
var this__28777__auto____$1 = this;
var h__28595__auto__ = self__.__hash;
if(!((h__28595__auto__ == null))){
return h__28595__auto__;
} else {
var h__28595__auto____$1 = ((function (h__28595__auto__,this__28777__auto____$1){
return (function (coll__28778__auto__){
return (1101961030 ^ cljs.core.hash_unordered_coll.call(null,coll__28778__auto__));
});})(h__28595__auto__,this__28777__auto____$1))
.call(null,this__28777__auto____$1);
self__.__hash = h__28595__auto____$1;

return h__28595__auto____$1;
}
});


fulcro_spec.async.AsyncQueue.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this50480,other50481){
var self__ = this;
var this50480__$1 = this;
return (!((other50481 == null))) && ((this50480__$1.constructor === other50481.constructor)) && (cljs.core._EQ_.call(null,this50480__$1.schedule,other50481.schedule)) && (cljs.core._EQ_.call(null,this50480__$1.now,other50481.now)) && (cljs.core._EQ_.call(null,this50480__$1.__extmap,other50481.__extmap));
});


fulcro_spec.async.AsyncQueue.prototype.fulcro_spec$async$IAsyncQueue$ = cljs.core.PROTOCOL_SENTINEL;


fulcro_spec.async.AsyncQueue.prototype.fulcro_spec$async$IAsyncQueue$current_time$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.deref.call(null,new cljs.core.Keyword(null,"now","now",-1650525531).cljs$core$IFn$_invoke$arity$1(this$__$1));
});


fulcro_spec.async.AsyncQueue.prototype.fulcro_spec$async$IAsyncQueue$peek_event$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.second.call(null,cljs.core.first.call(null,cljs.core.deref.call(null,new cljs.core.Keyword(null,"schedule","schedule",349275266).cljs$core$IFn$_invoke$arity$1(this$__$1))));
});


fulcro_spec.async.AsyncQueue.prototype.fulcro_spec$async$IAsyncQueue$advance_clock$arity$2 = (function (this$,ms){
var self__ = this;
var this$__$1 = this;
var stop_time = (ms + cljs.core.deref.call(null,new cljs.core.Keyword(null,"now","now",-1650525531).cljs$core$IFn$_invoke$arity$1(this$__$1)));
var evt_50488 = this$__$1.fulcro_spec$async$IAsyncQueue$peek_event$arity$1(null);
while(true){
var now_50489__$1 = (function (){var or__28141__auto__ = new cljs.core.Keyword(null,"abs-time","abs-time",59488074).cljs$core$IFn$_invoke$arity$1(evt_50488);
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
return (stop_time + (1));
}
})();
if((now_50489__$1 <= stop_time)){
cljs.core.reset_BANG_.call(null,new cljs.core.Keyword(null,"now","now",-1650525531).cljs$core$IFn$_invoke$arity$1(this$__$1),now_50489__$1);

fulcro_spec.async.process_first_event_BANG_.call(null,this$__$1);

var G__50490 = this$__$1.fulcro_spec$async$IAsyncQueue$peek_event$arity$1(null);
evt_50488 = G__50490;
continue;
} else {
}
break;
}

return cljs.core.reset_BANG_.call(null,new cljs.core.Keyword(null,"now","now",-1650525531).cljs$core$IFn$_invoke$arity$1(this$__$1),stop_time);
});


fulcro_spec.async.AsyncQueue.prototype.fulcro_spec$async$IAsyncQueue$schedule_event$arity$3 = (function (this$,ms_from_now,fn_to_call){
var self__ = this;
var this$__$1 = this;
var tm = (ms_from_now + cljs.core.deref.call(null,new cljs.core.Keyword(null,"now","now",-1650525531).cljs$core$IFn$_invoke$arity$1(this$__$1)));
var event = (new fulcro_spec.async.Event(tm,fn_to_call,null,null,null));
if(cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,new cljs.core.Keyword(null,"schedule","schedule",349275266).cljs$core$IFn$_invoke$arity$1(this$__$1)),tm)){
throw cljs.core.ex_info.call(null,["Schedule already contains an event ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ms_from_now),"ms from 'now' which would generate an indeterminant ordering for your events. Please offset your submission time a bit"].join(''),cljs.core.PersistentArrayMap.EMPTY);
} else {
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"schedule","schedule",349275266).cljs$core$IFn$_invoke$arity$1(this$__$1),((function (tm,event,this$__$1){
return (function (p1__50477_SHARP_){
return cljs.core.assoc.call(null,p1__50477_SHARP_,new cljs.core.Keyword(null,"abs-time","abs-time",59488074).cljs$core$IFn$_invoke$arity$1(event),event);
});})(tm,event,this$__$1))
);
}
});


fulcro_spec.async.AsyncQueue.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__28790__auto__,k__28791__auto__){
var self__ = this;
var this__28790__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schedule","schedule",349275266),null,new cljs.core.Keyword(null,"now","now",-1650525531),null], null), null),k__28791__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__28790__auto____$1),self__.__meta),k__28791__auto__);
} else {
return (new fulcro_spec.async.AsyncQueue(self__.schedule,self__.now,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__28791__auto__)),null));
}
});


fulcro_spec.async.AsyncQueue.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__28788__auto__,k__28789__auto__,G__50478){
var self__ = this;
var this__28788__auto____$1 = this;
var pred__50484 = cljs.core.keyword_identical_QMARK_;
var expr__50485 = k__28789__auto__;
if(cljs.core.truth_(pred__50484.call(null,new cljs.core.Keyword(null,"schedule","schedule",349275266),expr__50485))){
return (new fulcro_spec.async.AsyncQueue(G__50478,self__.now,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__50484.call(null,new cljs.core.Keyword(null,"now","now",-1650525531),expr__50485))){
return (new fulcro_spec.async.AsyncQueue(self__.schedule,G__50478,self__.__meta,self__.__extmap,null));
} else {
return (new fulcro_spec.async.AsyncQueue(self__.schedule,self__.now,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__28789__auto__,G__50478),null));
}
}
});


fulcro_spec.async.AsyncQueue.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__28793__auto__){
var self__ = this;
var this__28793__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schedule","schedule",349275266),self__.schedule],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"now","now",-1650525531),self__.now],null))], null),self__.__extmap));
});


fulcro_spec.async.AsyncQueue.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__28780__auto__,G__50478){
var self__ = this;
var this__28780__auto____$1 = this;
return (new fulcro_spec.async.AsyncQueue(self__.schedule,self__.now,G__50478,self__.__extmap,self__.__hash));
});


fulcro_spec.async.AsyncQueue.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__28786__auto__,entry__28787__auto__){
var self__ = this;
var this__28786__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__28787__auto__)){
return this__28786__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__28787__auto__,(0)),cljs.core._nth.call(null,entry__28787__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__28786__auto____$1,entry__28787__auto__);
}
});

fulcro_spec.async.AsyncQueue.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"schedule","schedule",1989806793,null),new cljs.core.Symbol(null,"now","now",-9994004,null)], null);
});

fulcro_spec.async.AsyncQueue.cljs$lang$type = true;

fulcro_spec.async.AsyncQueue.cljs$lang$ctorPrSeq = (function (this__28817__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"fulcro-spec.async/AsyncQueue");
});

fulcro_spec.async.AsyncQueue.cljs$lang$ctorPrWriter = (function (this__28817__auto__,writer__28818__auto__){
return cljs.core._write.call(null,writer__28818__auto__,"fulcro-spec.async/AsyncQueue");
});

fulcro_spec.async.__GT_AsyncQueue = (function fulcro_spec$async$__GT_AsyncQueue(schedule,now){
return (new fulcro_spec.async.AsyncQueue(schedule,now,null,null,null));
});

fulcro_spec.async.map__GT_AsyncQueue = (function fulcro_spec$async$map__GT_AsyncQueue(G__50482){
return (new fulcro_spec.async.AsyncQueue(new cljs.core.Keyword(null,"schedule","schedule",349275266).cljs$core$IFn$_invoke$arity$1(G__50482),new cljs.core.Keyword(null,"now","now",-1650525531).cljs$core$IFn$_invoke$arity$1(G__50482),null,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,G__50482,new cljs.core.Keyword(null,"schedule","schedule",349275266),new cljs.core.Keyword(null,"now","now",-1650525531))),null));
});

/**
 * Build an asynchronous event simulation queue.
 */
fulcro_spec.async.make_async_queue = (function fulcro_spec$async$make_async_queue(){
return (new fulcro_spec.async.AsyncQueue(cljs.core.atom.call(null,cljs.core.sorted_map.call(null)),cljs.core.atom.call(null,(0)),null,null,null));
});

//# sourceMappingURL=async.js.map?rel=1511229552517
