// Compiled by ClojureScript 1.9.946 {}
goog.provide('fulcro.websockets.networking');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('cognitect.transit');
goog.require('taoensso.sente');
goog.require('taoensso.sente.packers.transit');
goog.require('om.next');
goog.require('om.transit');
goog.require('fulcro.client.network');
goog.require('fulcro.client.logging');
goog.require('fulcro.websockets.transit_packer');

/**
 * @interface
 */
fulcro.websockets.networking.ChannelSocket = function(){};

/**
 * Install the push handlers. Must be called in started callback, passed the websocket network object, and the completed app
 */
fulcro.websockets.networking.install_push_handlers = (function fulcro$websockets$networking$install_push_handlers(this$,app){
if((!((this$ == null))) && (!((this$.fulcro$websockets$networking$ChannelSocket$install_push_handlers$arity$2 == null)))){
return this$.fulcro$websockets$networking$ChannelSocket$install_push_handlers$arity$2(this$,app);
} else {
var x__28824__auto__ = (((this$ == null))?null:this$);
var m__28825__auto__ = (fulcro.websockets.networking.install_push_handlers[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,this$,app);
} else {
var m__28825__auto____$1 = (fulcro.websockets.networking.install_push_handlers["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,this$,app);
} else {
throw cljs.core.missing_protocol.call(null,"ChannelSocket.install-push-handlers",this$);
}
}
}
});

/**
 * Reconnect the socket
 */
fulcro.websockets.networking.reconnect = (function fulcro$websockets$networking$reconnect(this$){
if((!((this$ == null))) && (!((this$.fulcro$websockets$networking$ChannelSocket$reconnect$arity$1 == null)))){
return this$.fulcro$websockets$networking$ChannelSocket$reconnect$arity$1(this$);
} else {
var x__28824__auto__ = (((this$ == null))?null:this$);
var m__28825__auto__ = (fulcro.websockets.networking.reconnect[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,this$);
} else {
var m__28825__auto____$1 = (fulcro.websockets.networking.reconnect["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"ChannelSocket.reconnect",this$);
}
}
}
});

if(typeof fulcro.websockets.networking.router_ !== 'undefined'){
} else {
fulcro.websockets.networking.router_ = cljs.core.atom.call(null,null);
}
fulcro.websockets.networking.stop_router_BANG_ = (function fulcro$websockets$networking$stop_router_BANG_(){
var temp__4657__auto__ = cljs.core.deref.call(null,fulcro.websockets.networking.router_);
if(cljs.core.truth_(temp__4657__auto__)){
var stop_f = temp__4657__auto__;
return stop_f.call(null);
} else {
return null;
}
});
fulcro.websockets.networking.start_router_BANG_ = (function fulcro$websockets$networking$start_router_BANG_(ch_recv,msg_handler){
fulcro.client.logging.info.call(null,"Starting websocket router.");

fulcro.websockets.networking.stop_router_BANG_.call(null);

return cljs.core.reset_BANG_.call(null,fulcro.websockets.networking.router_,taoensso.sente.start_chsk_router_BANG_.call(null,ch_recv,msg_handler));
});
if(typeof fulcro.websockets.networking.message_received !== 'undefined'){
} else {
/**
 * Multimethod to handle Sente `event-msg`s
 */
fulcro.websockets.networking.message_received = (function (){var method_table__29098__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__29099__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__29100__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__29101__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__29102__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"fulcro.websockets.networking","message-received"),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__29102__auto__,method_table__29098__auto__,prefer_table__29099__auto__,method_cache__29100__auto__,cached_hierarchy__29101__auto__));
})();
}
if(typeof fulcro.websockets.networking.push_received !== 'undefined'){
} else {
/**
 * Multimethod to handle push events
 */
fulcro.websockets.networking.push_received = (function (){var method_table__29098__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__29099__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__29100__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__29101__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__29102__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"fulcro.websockets.networking","push-received"),((function (method_table__29098__auto__,prefer_table__29099__auto__,method_cache__29100__auto__,cached_hierarchy__29101__auto__,hierarchy__29102__auto__){
return (function (app,msg){
return new cljs.core.Keyword(null,"topic","topic",-1960480691).cljs$core$IFn$_invoke$arity$1(msg);
});})(method_table__29098__auto__,prefer_table__29099__auto__,method_cache__29100__auto__,cached_hierarchy__29101__auto__,hierarchy__29102__auto__))
,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__29102__auto__,method_table__29098__auto__,prefer_table__29099__auto__,method_cache__29100__auto__,cached_hierarchy__29101__auto__));
})();
}
cljs.core._add_method.call(null,fulcro.websockets.networking.push_received,new cljs.core.Keyword(null,"default","default",-1987822328),(function (app,msg){
return fulcro.client.logging.error.call(null,["Received and unhandled message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg)].join(''));
}));

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {fulcro.client.network.FulcroNetwork}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {fulcro.websockets.networking.ChannelSocket}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fulcro.websockets.networking.ChannelClient = (function (ch_recv,url,init_chan,channel_socket,send_fn,global_error_callback,req_params,parse_queue,completed_app,__meta,__extmap,__hash){
this.ch_recv = ch_recv;
this.url = url;
this.init_chan = init_chan;
this.channel_socket = channel_socket;
this.send_fn = send_fn;
this.global_error_callback = global_error_callback;
this.req_params = req_params;
this.parse_queue = parse_queue;
this.completed_app = completed_app;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});

fulcro.websockets.networking.ChannelClient.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__28781__auto__,k__28782__auto__){
var self__ = this;
var this__28781__auto____$1 = this;
return this__28781__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__28782__auto__,null);
});


fulcro.websockets.networking.ChannelClient.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__28783__auto__,k48619,else__28784__auto__){
var self__ = this;
var this__28783__auto____$1 = this;
var G__48623 = k48619;
var G__48623__$1 = (((G__48623 instanceof cljs.core.Keyword))?G__48623.fqn:null);
switch (G__48623__$1) {
case "ch-recv":
return self__.ch_recv;

break;
case "url":
return self__.url;

break;
case "init-chan":
return self__.init_chan;

break;
case "channel-socket":
return self__.channel_socket;

break;
case "send-fn":
return self__.send_fn;

break;
case "global-error-callback":
return self__.global_error_callback;

break;
case "req-params":
return self__.req_params;

break;
case "parse-queue":
return self__.parse_queue;

break;
case "completed-app":
return self__.completed_app;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k48619,else__28784__auto__);

}
});


fulcro.websockets.networking.ChannelClient.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__28795__auto__,writer__28796__auto__,opts__28797__auto__){
var self__ = this;
var this__28795__auto____$1 = this;
var pr_pair__28798__auto__ = ((function (this__28795__auto____$1){
return (function (keyval__28799__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__28796__auto__,cljs.core.pr_writer,""," ","",opts__28797__auto__,keyval__28799__auto__);
});})(this__28795__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__28796__auto__,pr_pair__28798__auto__,"#fulcro.websockets.networking.ChannelClient{",", ","}",opts__28797__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861),self__.ch_recv],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"url","url",276297046),self__.url],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"init-chan","init-chan",2144713800),self__.init_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"channel-socket","channel-socket",416262463),self__.channel_socket],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"send-fn","send-fn",351002041),self__.send_fn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"global-error-callback","global-error-callback",901427631),self__.global_error_callback],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"req-params","req-params",2117077454),self__.req_params],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"parse-queue","parse-queue",1928611689),self__.parse_queue],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"completed-app","completed-app",-635152970),self__.completed_app],null))], null),self__.__extmap));
});


fulcro.websockets.networking.ChannelClient.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__48618){
var self__ = this;
var G__48618__$1 = this;
return (new cljs.core.RecordIter((0),G__48618__$1,9,new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861),new cljs.core.Keyword(null,"url","url",276297046),new cljs.core.Keyword(null,"init-chan","init-chan",2144713800),new cljs.core.Keyword(null,"channel-socket","channel-socket",416262463),new cljs.core.Keyword(null,"send-fn","send-fn",351002041),new cljs.core.Keyword(null,"global-error-callback","global-error-callback",901427631),new cljs.core.Keyword(null,"req-params","req-params",2117077454),new cljs.core.Keyword(null,"parse-queue","parse-queue",1928611689),new cljs.core.Keyword(null,"completed-app","completed-app",-635152970)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});


fulcro.websockets.networking.ChannelClient.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__28779__auto__){
var self__ = this;
var this__28779__auto____$1 = this;
return self__.__meta;
});


fulcro.websockets.networking.ChannelClient.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__28776__auto__){
var self__ = this;
var this__28776__auto____$1 = this;
return (new fulcro.websockets.networking.ChannelClient(self__.ch_recv,self__.url,self__.init_chan,self__.channel_socket,self__.send_fn,self__.global_error_callback,self__.req_params,self__.parse_queue,self__.completed_app,self__.__meta,self__.__extmap,self__.__hash));
});


fulcro.websockets.networking.ChannelClient.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__28785__auto__){
var self__ = this;
var this__28785__auto____$1 = this;
return (9 + cljs.core.count.call(null,self__.__extmap));
});


fulcro.websockets.networking.ChannelClient.prototype.fulcro$websockets$networking$ChannelSocket$ = cljs.core.PROTOCOL_SENTINEL;


fulcro.websockets.networking.ChannelClient.prototype.fulcro$websockets$networking$ChannelSocket$install_push_handlers$arity$2 = (function (this$,app){
var self__ = this;
var this$__$1 = this;
fulcro.websockets.networking.message_received.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"default","default",-1987822328),((function (this$__$1){
return (function (p__48624){
var map__48625 = p__48624;
var map__48625__$1 = ((((!((map__48625 == null)))?((((map__48625.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48625.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48625):map__48625);
var ch_recv__$1 = cljs.core.get.call(null,map__48625__$1,new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861));
var send_fn__$1 = cljs.core.get.call(null,map__48625__$1,new cljs.core.Keyword(null,"send-fn","send-fn",351002041));
var state = cljs.core.get.call(null,map__48625__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var event = cljs.core.get.call(null,map__48625__$1,new cljs.core.Keyword(null,"event","event",301435442));
var id = cljs.core.get.call(null,map__48625__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var _QMARK_data = cljs.core.get.call(null,map__48625__$1,new cljs.core.Keyword(null,"?data","?data",-9471433));
var command = new cljs.core.Keyword(null,"command","command",-894540724).cljs$core$IFn$_invoke$arity$1(_QMARK_data);
return fulcro.client.logging.debug.call(null,"Message Routed to default handler ",command);
});})(this$__$1))
);

fulcro.websockets.networking.message_received.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword("api","parse","api/parse",-1162064757),((function (this$__$1){
return (function (p__48627){
var map__48628 = p__48627;
var map__48628__$1 = ((((!((map__48628 == null)))?((((map__48628.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48628.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48628):map__48628);
var _QMARK_data = cljs.core.get.call(null,map__48628__$1,new cljs.core.Keyword(null,"?data","?data",-9471433));
return cljs.core.async.put_BANG_.call(null,self__.parse_queue,_QMARK_data);
});})(this$__$1))
);

fulcro.websockets.networking.message_received.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword("api","server-push","api/server-push",-1185983895),((function (this$__$1){
return (function (p__48630){
var map__48631 = p__48630;
var map__48631__$1 = ((((!((map__48631 == null)))?((((map__48631.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48631.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48631):map__48631);
var msg = map__48631__$1;
var _QMARK_data = cljs.core.get.call(null,map__48631__$1,new cljs.core.Keyword(null,"?data","?data",-9471433));
return fulcro.websockets.networking.push_received.call(null,app,_QMARK_data);
});})(this$__$1))
);

fulcro.websockets.networking.message_received.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword("chsk","handshake","chsk/handshake",64910686),((function (this$__$1){
return (function (p__48633){
var map__48634 = p__48633;
var map__48634__$1 = ((((!((map__48634 == null)))?((((map__48634.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48634.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48634):map__48634);
var message = map__48634__$1;
var ch_recv__$1 = cljs.core.get.call(null,map__48634__$1,new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861));
var send_fn__$1 = cljs.core.get.call(null,map__48634__$1,new cljs.core.Keyword(null,"send-fn","send-fn",351002041));
var state = cljs.core.get.call(null,map__48634__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var event = cljs.core.get.call(null,map__48634__$1,new cljs.core.Keyword(null,"event","event",301435442));
var id = cljs.core.get.call(null,map__48634__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var _QMARK_data = cljs.core.get.call(null,map__48634__$1,new cljs.core.Keyword(null,"?data","?data",-9471433));
return fulcro.client.logging.debug.call(null,"Message Routed to handshake handler ",state);
});})(this$__$1))
);

return fulcro.websockets.networking.message_received.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword("chsk","state","chsk/state",-1991397620),((function (this$__$1){
return (function (p__48636){
var map__48637 = p__48636;
var map__48637__$1 = ((((!((map__48637 == null)))?((((map__48637.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48637.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48637):map__48637);
var message = map__48637__$1;
var ch_recv__$1 = cljs.core.get.call(null,map__48637__$1,new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861));
var send_fn__$1 = cljs.core.get.call(null,map__48637__$1,new cljs.core.Keyword(null,"send-fn","send-fn",351002041));
var state = cljs.core.get.call(null,map__48637__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var event = cljs.core.get.call(null,map__48637__$1,new cljs.core.Keyword(null,"event","event",301435442));
var id = cljs.core.get.call(null,map__48637__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var _QMARK_data = cljs.core.get.call(null,map__48637__$1,new cljs.core.Keyword(null,"?data","?data",-9471433));
fulcro.client.logging.debug.call(null,"Message Routed to state handler",cljs.core.keys.call(null,message));

fulcro.client.logging.debug.call(null,"Event",event);

fulcro.client.logging.debug.call(null,"State",state);

if(cljs.core.truth_(new cljs.core.Keyword(null,"ever-opened?","ever-opened?",1128459732).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,state)))){
return cljs.core.async.put_BANG_.call(null,self__.init_chan,true);
} else {
return null;
}
});})(this$__$1))
);
});


fulcro.websockets.networking.ChannelClient.prototype.fulcro$websockets$networking$ChannelSocket$reconnect$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return taoensso.sente.chsk_reconnect_BANG_.call(null,self__.channel_socket);
});


fulcro.websockets.networking.ChannelClient.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__28777__auto__){
var self__ = this;
var this__28777__auto____$1 = this;
var h__28595__auto__ = self__.__hash;
if(!((h__28595__auto__ == null))){
return h__28595__auto__;
} else {
var h__28595__auto____$1 = ((function (h__28595__auto__,this__28777__auto____$1){
return (function (coll__28778__auto__){
return (954161770 ^ cljs.core.hash_unordered_coll.call(null,coll__28778__auto__));
});})(h__28595__auto__,this__28777__auto____$1))
.call(null,this__28777__auto____$1);
self__.__hash = h__28595__auto____$1;

return h__28595__auto____$1;
}
});


fulcro.websockets.networking.ChannelClient.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this48620,other48621){
var self__ = this;
var this48620__$1 = this;
return (!((other48621 == null))) && ((this48620__$1.constructor === other48621.constructor)) && (cljs.core._EQ_.call(null,this48620__$1.ch_recv,other48621.ch_recv)) && (cljs.core._EQ_.call(null,this48620__$1.url,other48621.url)) && (cljs.core._EQ_.call(null,this48620__$1.init_chan,other48621.init_chan)) && (cljs.core._EQ_.call(null,this48620__$1.channel_socket,other48621.channel_socket)) && (cljs.core._EQ_.call(null,this48620__$1.send_fn,other48621.send_fn)) && (cljs.core._EQ_.call(null,this48620__$1.global_error_callback,other48621.global_error_callback)) && (cljs.core._EQ_.call(null,this48620__$1.req_params,other48621.req_params)) && (cljs.core._EQ_.call(null,this48620__$1.parse_queue,other48621.parse_queue)) && (cljs.core._EQ_.call(null,this48620__$1.completed_app,other48621.completed_app)) && (cljs.core._EQ_.call(null,this48620__$1.__extmap,other48621.__extmap));
});


fulcro.websockets.networking.ChannelClient.prototype.fulcro$client$network$FulcroNetwork$ = cljs.core.PROTOCOL_SENTINEL;


fulcro.websockets.networking.ChannelClient.prototype.fulcro$client$network$FulcroNetwork$send$arity$4 = (function (this$,edn,ok,err){
var self__ = this;
var this$__$1 = this;
var c__42036__auto___48739 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42036__auto___48739,this$__$1){
return (function (){
var f__42037__auto__ = (function (){var switch__42015__auto__ = ((function (c__42036__auto___48739,this$__$1){
return (function (state_48681){
var state_val_48682 = (state_48681[(1)]);
if((state_val_48682 === (7))){
var state_48681__$1 = state_48681;
var statearr_48683_48740 = state_48681__$1;
(statearr_48683_48740[(2)] = false);

(statearr_48683_48740[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48682 === (1))){
var state_48681__$1 = state_48681;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_48681__$1,(2),self__.parse_queue);
} else {
if((state_val_48682 === (4))){
var state_48681__$1 = state_48681;
var statearr_48684_48741 = state_48681__$1;
(statearr_48684_48741[(2)] = false);

(statearr_48684_48741[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48682 === (15))){
var inst_48664 = (state_48681[(7)]);
var inst_48663 = (state_48681[(8)]);
var inst_48673 = self__.global_error_callback.call(null,inst_48663,inst_48664);
var state_48681__$1 = state_48681;
var statearr_48685_48742 = state_48681__$1;
(statearr_48685_48742[(2)] = inst_48673);

(statearr_48685_48742[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48682 === (13))){
var inst_48663 = (state_48681[(8)]);
var inst_48670 = ["SERVER ERROR CODE: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_48663)].join('');
var inst_48671 = fulcro.client.logging.debug.call(null,inst_48670);
var state_48681__$1 = (function (){var statearr_48686 = state_48681;
(statearr_48686[(9)] = inst_48671);

return statearr_48686;
})();
if(cljs.core.truth_(self__.global_error_callback)){
var statearr_48687_48743 = state_48681__$1;
(statearr_48687_48743[(1)] = (15));

} else {
var statearr_48688_48744 = state_48681__$1;
(statearr_48688_48744[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48682 === (6))){
var state_48681__$1 = state_48681;
var statearr_48689_48745 = state_48681__$1;
(statearr_48689_48745[(2)] = true);

(statearr_48689_48745[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48682 === (17))){
var inst_48664 = (state_48681[(7)]);
var inst_48676 = (state_48681[(2)]);
var inst_48677 = err.call(null,inst_48664);
var state_48681__$1 = (function (){var statearr_48690 = state_48681;
(statearr_48690[(10)] = inst_48676);

return statearr_48690;
})();
var statearr_48691_48746 = state_48681__$1;
(statearr_48691_48746[(2)] = inst_48677);

(statearr_48691_48746[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48682 === (3))){
var inst_48641 = (state_48681[(11)]);
var inst_48646 = inst_48641.cljs$lang$protocol_mask$partition0$;
var inst_48647 = (inst_48646 & (64));
var inst_48648 = inst_48641.cljs$core$ISeq$;
var inst_48649 = (cljs.core.PROTOCOL_SENTINEL === inst_48648);
var inst_48650 = (inst_48647) || (inst_48649);
var state_48681__$1 = state_48681;
if(cljs.core.truth_(inst_48650)){
var statearr_48692_48747 = state_48681__$1;
(statearr_48692_48747[(1)] = (6));

} else {
var statearr_48693_48748 = state_48681__$1;
(statearr_48693_48748[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48682 === (12))){
var inst_48664 = (state_48681[(7)]);
var inst_48668 = ok.call(null,inst_48664);
var state_48681__$1 = state_48681;
var statearr_48694_48749 = state_48681__$1;
(statearr_48694_48749[(2)] = inst_48668);

(statearr_48694_48749[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48682 === (2))){
var inst_48641 = (state_48681[(11)]);
var inst_48641__$1 = (state_48681[(2)]);
var inst_48643 = (inst_48641__$1 == null);
var inst_48644 = cljs.core.not.call(null,inst_48643);
var state_48681__$1 = (function (){var statearr_48695 = state_48681;
(statearr_48695[(11)] = inst_48641__$1);

return statearr_48695;
})();
if(inst_48644){
var statearr_48696_48750 = state_48681__$1;
(statearr_48696_48750[(1)] = (3));

} else {
var statearr_48697_48751 = state_48681__$1;
(statearr_48697_48751[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48682 === (11))){
var inst_48664 = (state_48681[(7)]);
var inst_48663 = (state_48681[(8)]);
var inst_48662 = (state_48681[(2)]);
var inst_48663__$1 = cljs.core.get.call(null,inst_48662,new cljs.core.Keyword(null,"status","status",-1997798413));
var inst_48664__$1 = cljs.core.get.call(null,inst_48662,new cljs.core.Keyword(null,"body","body",-2049205669));
var inst_48665 = fulcro.client.logging.debug.call(null,"Receiving ",inst_48664__$1);
var inst_48666 = cljs.core._EQ_.call(null,inst_48663__$1,(200));
var state_48681__$1 = (function (){var statearr_48698 = state_48681;
(statearr_48698[(7)] = inst_48664__$1);

(statearr_48698[(8)] = inst_48663__$1);

(statearr_48698[(12)] = inst_48665);

return statearr_48698;
})();
if(inst_48666){
var statearr_48699_48752 = state_48681__$1;
(statearr_48699_48752[(1)] = (12));

} else {
var statearr_48700_48753 = state_48681__$1;
(statearr_48700_48753[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48682 === (9))){
var inst_48641 = (state_48681[(11)]);
var inst_48659 = cljs.core.apply.call(null,cljs.core.hash_map,inst_48641);
var state_48681__$1 = state_48681;
var statearr_48701_48754 = state_48681__$1;
(statearr_48701_48754[(2)] = inst_48659);

(statearr_48701_48754[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48682 === (5))){
var inst_48657 = (state_48681[(2)]);
var state_48681__$1 = state_48681;
if(cljs.core.truth_(inst_48657)){
var statearr_48702_48755 = state_48681__$1;
(statearr_48702_48755[(1)] = (9));

} else {
var statearr_48703_48756 = state_48681__$1;
(statearr_48703_48756[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48682 === (14))){
var inst_48679 = (state_48681[(2)]);
var state_48681__$1 = (function (){var statearr_48704 = state_48681;
(statearr_48704[(13)] = inst_48679);

return statearr_48704;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_48681__$1,self__.parse_queue);
} else {
if((state_val_48682 === (16))){
var state_48681__$1 = state_48681;
var statearr_48705_48757 = state_48681__$1;
(statearr_48705_48757[(2)] = null);

(statearr_48705_48757[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48682 === (10))){
var inst_48641 = (state_48681[(11)]);
var state_48681__$1 = state_48681;
var statearr_48706_48758 = state_48681__$1;
(statearr_48706_48758[(2)] = inst_48641);

(statearr_48706_48758[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48682 === (8))){
var inst_48654 = (state_48681[(2)]);
var state_48681__$1 = state_48681;
var statearr_48707_48759 = state_48681__$1;
(statearr_48707_48759[(2)] = inst_48654);

(statearr_48707_48759[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__42036__auto___48739,this$__$1))
;
return ((function (switch__42015__auto__,c__42036__auto___48739,this$__$1){
return (function() {
var fulcro$websockets$networking$state_machine__42016__auto__ = null;
var fulcro$websockets$networking$state_machine__42016__auto____0 = (function (){
var statearr_48708 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48708[(0)] = fulcro$websockets$networking$state_machine__42016__auto__);

(statearr_48708[(1)] = (1));

return statearr_48708;
});
var fulcro$websockets$networking$state_machine__42016__auto____1 = (function (state_48681){
while(true){
var ret_value__42017__auto__ = (function (){try{while(true){
var result__42018__auto__ = switch__42015__auto__.call(null,state_48681);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42018__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42018__auto__;
}
break;
}
}catch (e48709){if((e48709 instanceof Object)){
var ex__42019__auto__ = e48709;
var statearr_48710_48760 = state_48681;
(statearr_48710_48760[(5)] = ex__42019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_48681);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e48709;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48761 = state_48681;
state_48681 = G__48761;
continue;
} else {
return ret_value__42017__auto__;
}
break;
}
});
fulcro$websockets$networking$state_machine__42016__auto__ = function(state_48681){
switch(arguments.length){
case 0:
return fulcro$websockets$networking$state_machine__42016__auto____0.call(this);
case 1:
return fulcro$websockets$networking$state_machine__42016__auto____1.call(this,state_48681);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
fulcro$websockets$networking$state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$0 = fulcro$websockets$networking$state_machine__42016__auto____0;
fulcro$websockets$networking$state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$1 = fulcro$websockets$networking$state_machine__42016__auto____1;
return fulcro$websockets$networking$state_machine__42016__auto__;
})()
;})(switch__42015__auto__,c__42036__auto___48739,this$__$1))
})();
var state__42038__auto__ = (function (){var statearr_48711 = f__42037__auto__.call(null);
(statearr_48711[(6)] = c__42036__auto___48739);

return statearr_48711;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42038__auto__);
});})(c__42036__auto___48739,this$__$1))
);


var c__42036__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42036__auto__,this$__$1){
return (function (){
var f__42037__auto__ = (function (){var switch__42015__auto__ = ((function (c__42036__auto__,this$__$1){
return (function (state_48728){
var state_val_48729 = (state_48728[(1)]);
if((state_val_48729 === (1))){
var state_48728__$1 = state_48728;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_48728__$1,(2),self__.init_chan);
} else {
if((state_val_48729 === (2))){
var inst_48713 = (state_48728[(2)]);
var inst_48714 = fulcro.client.logging.debug.call(null,"Sending ",edn);
var inst_48715 = cljs.core.List.EMPTY;
var inst_48716 = cljs.core._conj.call(null,inst_48715,new cljs.core.Keyword("api","parse","api/parse",-1162064757));
var inst_48717 = [new cljs.core.Keyword(null,"action","action",-811238024),new cljs.core.Keyword(null,"command","command",-894540724),new cljs.core.Keyword(null,"content","content",15833224)];
var inst_48718 = [new cljs.core.Keyword(null,"send-message","send-message",185030731),new cljs.core.Keyword(null,"send-om-request","send-om-request",-1867228457),edn];
var inst_48719 = cljs.core.PersistentHashMap.fromArrays(inst_48717,inst_48718);
var inst_48720 = cljs.core.List.EMPTY;
var inst_48721 = cljs.core._conj.call(null,inst_48720,inst_48719);
var inst_48722 = cljs.core.concat.call(null,inst_48716,inst_48721);
var inst_48723 = cljs.core.seq.call(null,inst_48722);
var inst_48724 = cljs.core.sequence.call(null,inst_48723);
var inst_48725 = cljs.core.vec.call(null,inst_48724);
var inst_48726 = self__.send_fn.call(null,inst_48725);
var state_48728__$1 = (function (){var statearr_48730 = state_48728;
(statearr_48730[(7)] = inst_48714);

(statearr_48730[(8)] = inst_48713);

return statearr_48730;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_48728__$1,inst_48726);
} else {
return null;
}
}
});})(c__42036__auto__,this$__$1))
;
return ((function (switch__42015__auto__,c__42036__auto__,this$__$1){
return (function() {
var fulcro$websockets$networking$state_machine__42016__auto__ = null;
var fulcro$websockets$networking$state_machine__42016__auto____0 = (function (){
var statearr_48731 = [null,null,null,null,null,null,null,null,null];
(statearr_48731[(0)] = fulcro$websockets$networking$state_machine__42016__auto__);

(statearr_48731[(1)] = (1));

return statearr_48731;
});
var fulcro$websockets$networking$state_machine__42016__auto____1 = (function (state_48728){
while(true){
var ret_value__42017__auto__ = (function (){try{while(true){
var result__42018__auto__ = switch__42015__auto__.call(null,state_48728);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42018__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42018__auto__;
}
break;
}
}catch (e48732){if((e48732 instanceof Object)){
var ex__42019__auto__ = e48732;
var statearr_48733_48762 = state_48728;
(statearr_48733_48762[(5)] = ex__42019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_48728);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e48732;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48763 = state_48728;
state_48728 = G__48763;
continue;
} else {
return ret_value__42017__auto__;
}
break;
}
});
fulcro$websockets$networking$state_machine__42016__auto__ = function(state_48728){
switch(arguments.length){
case 0:
return fulcro$websockets$networking$state_machine__42016__auto____0.call(this);
case 1:
return fulcro$websockets$networking$state_machine__42016__auto____1.call(this,state_48728);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
fulcro$websockets$networking$state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$0 = fulcro$websockets$networking$state_machine__42016__auto____0;
fulcro$websockets$networking$state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$1 = fulcro$websockets$networking$state_machine__42016__auto____1;
return fulcro$websockets$networking$state_machine__42016__auto__;
})()
;})(switch__42015__auto__,c__42036__auto__,this$__$1))
})();
var state__42038__auto__ = (function (){var statearr_48734 = f__42037__auto__.call(null);
(statearr_48734[(6)] = c__42036__auto__);

return statearr_48734;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42038__auto__);
});})(c__42036__auto__,this$__$1))
);

return c__42036__auto__;
});


fulcro.websockets.networking.ChannelClient.prototype.fulcro$client$network$FulcroNetwork$start$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
fulcro.client.logging.debug.call(null,"Remember to install the push handlers.");

fulcro.websockets.networking.start_router_BANG_.call(null,self__.ch_recv,fulcro.websockets.networking.message_received);

return this$__$1;
});


fulcro.websockets.networking.ChannelClient.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__28790__auto__,k__28791__auto__){
var self__ = this;
var this__28790__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, [new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861),null,new cljs.core.Keyword(null,"init-chan","init-chan",2144713800),null,new cljs.core.Keyword(null,"parse-queue","parse-queue",1928611689),null,new cljs.core.Keyword(null,"req-params","req-params",2117077454),null,new cljs.core.Keyword(null,"global-error-callback","global-error-callback",901427631),null,new cljs.core.Keyword(null,"url","url",276297046),null,new cljs.core.Keyword(null,"completed-app","completed-app",-635152970),null,new cljs.core.Keyword(null,"send-fn","send-fn",351002041),null,new cljs.core.Keyword(null,"channel-socket","channel-socket",416262463),null], null), null),k__28791__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__28790__auto____$1),self__.__meta),k__28791__auto__);
} else {
return (new fulcro.websockets.networking.ChannelClient(self__.ch_recv,self__.url,self__.init_chan,self__.channel_socket,self__.send_fn,self__.global_error_callback,self__.req_params,self__.parse_queue,self__.completed_app,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__28791__auto__)),null));
}
});


fulcro.websockets.networking.ChannelClient.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__28788__auto__,k__28789__auto__,G__48618){
var self__ = this;
var this__28788__auto____$1 = this;
var pred__48735 = cljs.core.keyword_identical_QMARK_;
var expr__48736 = k__28789__auto__;
if(cljs.core.truth_(pred__48735.call(null,new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861),expr__48736))){
return (new fulcro.websockets.networking.ChannelClient(G__48618,self__.url,self__.init_chan,self__.channel_socket,self__.send_fn,self__.global_error_callback,self__.req_params,self__.parse_queue,self__.completed_app,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__48735.call(null,new cljs.core.Keyword(null,"url","url",276297046),expr__48736))){
return (new fulcro.websockets.networking.ChannelClient(self__.ch_recv,G__48618,self__.init_chan,self__.channel_socket,self__.send_fn,self__.global_error_callback,self__.req_params,self__.parse_queue,self__.completed_app,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__48735.call(null,new cljs.core.Keyword(null,"init-chan","init-chan",2144713800),expr__48736))){
return (new fulcro.websockets.networking.ChannelClient(self__.ch_recv,self__.url,G__48618,self__.channel_socket,self__.send_fn,self__.global_error_callback,self__.req_params,self__.parse_queue,self__.completed_app,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__48735.call(null,new cljs.core.Keyword(null,"channel-socket","channel-socket",416262463),expr__48736))){
return (new fulcro.websockets.networking.ChannelClient(self__.ch_recv,self__.url,self__.init_chan,G__48618,self__.send_fn,self__.global_error_callback,self__.req_params,self__.parse_queue,self__.completed_app,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__48735.call(null,new cljs.core.Keyword(null,"send-fn","send-fn",351002041),expr__48736))){
return (new fulcro.websockets.networking.ChannelClient(self__.ch_recv,self__.url,self__.init_chan,self__.channel_socket,G__48618,self__.global_error_callback,self__.req_params,self__.parse_queue,self__.completed_app,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__48735.call(null,new cljs.core.Keyword(null,"global-error-callback","global-error-callback",901427631),expr__48736))){
return (new fulcro.websockets.networking.ChannelClient(self__.ch_recv,self__.url,self__.init_chan,self__.channel_socket,self__.send_fn,G__48618,self__.req_params,self__.parse_queue,self__.completed_app,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__48735.call(null,new cljs.core.Keyword(null,"req-params","req-params",2117077454),expr__48736))){
return (new fulcro.websockets.networking.ChannelClient(self__.ch_recv,self__.url,self__.init_chan,self__.channel_socket,self__.send_fn,self__.global_error_callback,G__48618,self__.parse_queue,self__.completed_app,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__48735.call(null,new cljs.core.Keyword(null,"parse-queue","parse-queue",1928611689),expr__48736))){
return (new fulcro.websockets.networking.ChannelClient(self__.ch_recv,self__.url,self__.init_chan,self__.channel_socket,self__.send_fn,self__.global_error_callback,self__.req_params,G__48618,self__.completed_app,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__48735.call(null,new cljs.core.Keyword(null,"completed-app","completed-app",-635152970),expr__48736))){
return (new fulcro.websockets.networking.ChannelClient(self__.ch_recv,self__.url,self__.init_chan,self__.channel_socket,self__.send_fn,self__.global_error_callback,self__.req_params,self__.parse_queue,G__48618,self__.__meta,self__.__extmap,null));
} else {
return (new fulcro.websockets.networking.ChannelClient(self__.ch_recv,self__.url,self__.init_chan,self__.channel_socket,self__.send_fn,self__.global_error_callback,self__.req_params,self__.parse_queue,self__.completed_app,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__28789__auto__,G__48618),null));
}
}
}
}
}
}
}
}
}
});


fulcro.websockets.networking.ChannelClient.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__28793__auto__){
var self__ = this;
var this__28793__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861),self__.ch_recv],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"url","url",276297046),self__.url],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"init-chan","init-chan",2144713800),self__.init_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"channel-socket","channel-socket",416262463),self__.channel_socket],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"send-fn","send-fn",351002041),self__.send_fn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"global-error-callback","global-error-callback",901427631),self__.global_error_callback],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"req-params","req-params",2117077454),self__.req_params],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"parse-queue","parse-queue",1928611689),self__.parse_queue],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"completed-app","completed-app",-635152970),self__.completed_app],null))], null),self__.__extmap));
});


fulcro.websockets.networking.ChannelClient.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__28780__auto__,G__48618){
var self__ = this;
var this__28780__auto____$1 = this;
return (new fulcro.websockets.networking.ChannelClient(self__.ch_recv,self__.url,self__.init_chan,self__.channel_socket,self__.send_fn,self__.global_error_callback,self__.req_params,self__.parse_queue,self__.completed_app,G__48618,self__.__extmap,self__.__hash));
});


fulcro.websockets.networking.ChannelClient.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__28786__auto__,entry__28787__auto__){
var self__ = this;
var this__28786__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__28787__auto__)){
return this__28786__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__28787__auto__,(0)),cljs.core._nth.call(null,entry__28787__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__28786__auto____$1,entry__28787__auto__);
}
});

fulcro.websockets.networking.ChannelClient.getBasis = (function (){
return new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch-recv","ch-recv",649614666,null),new cljs.core.Symbol(null,"url","url",1916828573,null),new cljs.core.Symbol(null,"init-chan","init-chan",-509721969,null),new cljs.core.Symbol(null,"channel-socket","channel-socket",2056793990,null),new cljs.core.Symbol(null,"send-fn","send-fn",1991533568,null),new cljs.core.Symbol(null,"global-error-callback","global-error-callback",-1753008138,null),new cljs.core.Symbol(null,"req-params","req-params",-537358315,null),new cljs.core.Symbol(null,"parse-queue","parse-queue",-725824080,null),new cljs.core.Symbol(null,"completed-app","completed-app",1005378557,null)], null);
});

fulcro.websockets.networking.ChannelClient.cljs$lang$type = true;

fulcro.websockets.networking.ChannelClient.cljs$lang$ctorPrSeq = (function (this__28817__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"fulcro.websockets.networking/ChannelClient");
});

fulcro.websockets.networking.ChannelClient.cljs$lang$ctorPrWriter = (function (this__28817__auto__,writer__28818__auto__){
return cljs.core._write.call(null,writer__28818__auto__,"fulcro.websockets.networking/ChannelClient");
});

fulcro.websockets.networking.__GT_ChannelClient = (function fulcro$websockets$networking$__GT_ChannelClient(ch_recv,url,init_chan,channel_socket,send_fn,global_error_callback,req_params,parse_queue,completed_app){
return (new fulcro.websockets.networking.ChannelClient(ch_recv,url,init_chan,channel_socket,send_fn,global_error_callback,req_params,parse_queue,completed_app,null,null,null));
});

fulcro.websockets.networking.map__GT_ChannelClient = (function fulcro$websockets$networking$map__GT_ChannelClient(G__48622){
return (new fulcro.websockets.networking.ChannelClient(new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861).cljs$core$IFn$_invoke$arity$1(G__48622),new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(G__48622),new cljs.core.Keyword(null,"init-chan","init-chan",2144713800).cljs$core$IFn$_invoke$arity$1(G__48622),new cljs.core.Keyword(null,"channel-socket","channel-socket",416262463).cljs$core$IFn$_invoke$arity$1(G__48622),new cljs.core.Keyword(null,"send-fn","send-fn",351002041).cljs$core$IFn$_invoke$arity$1(G__48622),new cljs.core.Keyword(null,"global-error-callback","global-error-callback",901427631).cljs$core$IFn$_invoke$arity$1(G__48622),new cljs.core.Keyword(null,"req-params","req-params",2117077454).cljs$core$IFn$_invoke$arity$1(G__48622),new cljs.core.Keyword(null,"parse-queue","parse-queue",1928611689).cljs$core$IFn$_invoke$arity$1(G__48622),new cljs.core.Keyword(null,"completed-app","completed-app",-635152970).cljs$core$IFn$_invoke$arity$1(G__48622),null,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,G__48622,new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861),new cljs.core.Keyword(null,"url","url",276297046),new cljs.core.Keyword(null,"init-chan","init-chan",2144713800),new cljs.core.Keyword(null,"channel-socket","channel-socket",416262463),new cljs.core.Keyword(null,"send-fn","send-fn",351002041),new cljs.core.Keyword(null,"global-error-callback","global-error-callback",901427631),new cljs.core.Keyword(null,"req-params","req-params",2117077454),new cljs.core.Keyword(null,"parse-queue","parse-queue",1928611689),new cljs.core.Keyword(null,"completed-app","completed-app",-635152970))),null));
});

/**
 * Creates a client side networking component for use in place of the default fulcro networking component.
 * 
 *   Params:
 *   - `url` - The url to handle websocket traffic on. (ex. "\chsk")
 *   - `host` (Optional) - server that is hosting the websocket server
 *   - `global-error-callback` (Optional) - Analagous to the global error callback in fulcro client.
 *   - `req-params` (Optional) - Params to be attached to the initial request.
 *   - `state-callback` (Optional) - Callback that runs when the websocket state of the websocket changes.
 *    The function takes an old state parameter and a new state parameter (arity 2 function).
 *    `state-callback` can be either a function, or an atom containing a function.
 *   - `transit-handlers` (Optional) - Expects a map with `:read` and/or `:write` key containing a map of transit handlers,
 *   
 */
fulcro.websockets.networking.make_channel_client = (function fulcro$websockets$networking$make_channel_client(var_args){
var args__29319__auto__ = [];
var len__29312__auto___48771 = arguments.length;
var i__29313__auto___48772 = (0);
while(true){
if((i__29313__auto___48772 < len__29312__auto___48771)){
args__29319__auto__.push((arguments[i__29313__auto___48772]));

var G__48773 = (i__29313__auto___48772 + (1));
i__29313__auto___48772 = G__48773;
continue;
} else {
}
break;
}

var argseq__29320__auto__ = ((((1) < args__29319__auto__.length))?(new cljs.core.IndexedSeq(args__29319__auto__.slice((1)),(0),null)):null);
return fulcro.websockets.networking.make_channel_client.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29320__auto__);
});

fulcro.websockets.networking.make_channel_client.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__48766){
var map__48767 = p__48766;
var map__48767__$1 = ((((!((map__48767 == null)))?((((map__48767.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48767.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48767):map__48767);
var global_error_callback = cljs.core.get.call(null,map__48767__$1,new cljs.core.Keyword(null,"global-error-callback","global-error-callback",901427631));
var host = cljs.core.get.call(null,map__48767__$1,new cljs.core.Keyword(null,"host","host",-1558485167));
var req_params = cljs.core.get.call(null,map__48767__$1,new cljs.core.Keyword(null,"req-params","req-params",2117077454));
var state_callback = cljs.core.get.call(null,map__48767__$1,new cljs.core.Keyword(null,"state-callback","state-callback",-1311788585));
var transit_handlers = cljs.core.get.call(null,map__48767__$1,new cljs.core.Keyword(null,"transit-handlers","transit-handlers",-1206080791));
var parse_queue = cljs.core.async.chan.call(null);
var map__48769 = taoensso.sente.make_channel_socket_BANG_.call(null,url,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"packer","packer",66077544),fulcro.websockets.transit_packer.make_packer.call(null,transit_handlers),new cljs.core.Keyword(null,"host","host",-1558485167),host,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"params","params",710516235),req_params,new cljs.core.Keyword(null,"wrap-recv-evs?","wrap-recv-evs?",-1996694153),false], null));
var map__48769__$1 = ((((!((map__48769 == null)))?((((map__48769.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48769.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48769):map__48769);
var chsk = cljs.core.get.call(null,map__48769__$1,new cljs.core.Keyword(null,"chsk","chsk",-863703081));
var ch_recv = cljs.core.get.call(null,map__48769__$1,new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861));
var send_fn = cljs.core.get.call(null,map__48769__$1,new cljs.core.Keyword(null,"send-fn","send-fn",351002041));
var state = cljs.core.get.call(null,map__48769__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var channel_client = fulcro.websockets.networking.map__GT_ChannelClient.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861),ch_recv,new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"init-chan","init-chan",2144713800),cljs.core.async.promise_chan.call(null),new cljs.core.Keyword(null,"channel-socket","channel-socket",416262463),chsk,new cljs.core.Keyword(null,"send-fn","send-fn",351002041),send_fn,new cljs.core.Keyword(null,"global-error-callback","global-error-callback",901427631),global_error_callback,new cljs.core.Keyword(null,"req-params","req-params",2117077454),req_params,new cljs.core.Keyword(null,"parse-queue","parse-queue",1928611689),parse_queue], null));
if(cljs.core.fn_QMARK_.call(null,state_callback)){
cljs.core.add_watch.call(null,state,new cljs.core.Keyword("fulcro.websockets.networking","state-callback","fulcro.websockets.networking/state-callback",-1576821266),((function (parse_queue,map__48769,map__48769__$1,chsk,ch_recv,send_fn,state,channel_client,map__48767,map__48767__$1,global_error_callback,host,req_params,state_callback,transit_handlers){
return (function (a,k,o,n){
return state_callback.call(null,o,n);
});})(parse_queue,map__48769,map__48769__$1,chsk,ch_recv,send_fn,state,channel_client,map__48767,map__48767__$1,global_error_callback,host,req_params,state_callback,transit_handlers))
);
} else {
if((state_callback instanceof cljs.core.Atom)){
cljs.core.add_watch.call(null,state,new cljs.core.Keyword("fulcro.websockets.networking","state-callback","fulcro.websockets.networking/state-callback",-1576821266),((function (parse_queue,map__48769,map__48769__$1,chsk,ch_recv,send_fn,state,channel_client,map__48767,map__48767__$1,global_error_callback,host,req_params,state_callback,transit_handlers){
return (function (a,k,o,n){
return cljs.core.deref.call(null,state_callback).call(null,o,n);
});})(parse_queue,map__48769,map__48769__$1,chsk,ch_recv,send_fn,state,channel_client,map__48767,map__48767__$1,global_error_callback,host,req_params,state_callback,transit_handlers))
);
} else {
}
}

return channel_client;
});

fulcro.websockets.networking.make_channel_client.cljs$lang$maxFixedArity = (1);

fulcro.websockets.networking.make_channel_client.cljs$lang$applyTo = (function (seq48764){
var G__48765 = cljs.core.first.call(null,seq48764);
var seq48764__$1 = cljs.core.next.call(null,seq48764);
return fulcro.websockets.networking.make_channel_client.cljs$core$IFn$_invoke$arity$variadic(G__48765,seq48764__$1);
});


//# sourceMappingURL=networking.js.map?rel=1511229550763
