// Compiled by ClojureScript 1.9.946 {}
goog.provide('fulcro.client.mutations');
goog.require('cljs.core');
goog.require('cljs.spec.alpha');
goog.require('om.next');
goog.require('fulcro.client.util');
goog.require('fulcro.client.logging');
goog.require('fulcro.i18n');
goog.require('cljs.loader');
if(typeof fulcro.client.mutations.mutate !== 'undefined'){
} else {
fulcro.client.mutations.mutate = (function (){var method_table__29098__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__29099__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__29100__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__29101__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__29102__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"fulcro.client.mutations","mutate"),om.next.dispatch,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__29102__auto__,method_table__29098__auto__,prefer_table__29099__auto__,method_cache__29100__auto__,cached_hierarchy__29101__auto__));
})();
}
if(typeof fulcro.client.mutations.post_mutate !== 'undefined'){
} else {
fulcro.client.mutations.post_mutate = (function (){var method_table__29098__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__29099__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__29100__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__29101__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__29102__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"fulcro.client.mutations","post-mutate"),om.next.dispatch,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__29102__auto__,method_table__29098__auto__,prefer_table__29099__auto__,method_cache__29100__auto__,cached_hierarchy__29101__auto__));
})();
}
cljs.core._add_method.call(null,fulcro.client.mutations.post_mutate,new cljs.core.Keyword(null,"default","default",-1987822328),(function (env,k,p){
return null;
}));
fulcro.client.mutations.default_locale_QMARK_ = (function fulcro$client$mutations$default_locale_QMARK_(locale_string){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["en",null,"en-US",null], null), null).call(null,locale_string);
});
fulcro.client.mutations.locale_present_QMARK_ = (function fulcro$client$mutations$locale_present_QMARK_(locale_string){
var or__28141__auto__ = fulcro.client.mutations.default_locale_QMARK_.call(null,locale_string);
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
return cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,fulcro.i18n._STAR_loaded_translations_STAR_),locale_string);
}
});
/**
 * Returns true if the given locale is in a loadable module. Always returns false on the server-side.
 */
fulcro.client.mutations.locale_loadable_QMARK_ = (function fulcro$client$mutations$locale_loadable_QMARK_(locale_key){
return cljs.core.contains_QMARK_.call(null,cljs.loader.module_infos,locale_key);
});
/**
 * Given a state map and locale, returns a new state map with the locale properly changed. Also potentially triggers a module load.
 *   There is also the mutation `change-locale` that can be used from transact.
 */
fulcro.client.mutations.change_locale_impl = (function fulcro$client$mutations$change_locale_impl(state_map,lang){
var lang__$1 = cljs.core.name.call(null,lang);
var locale_key = cljs.core.keyword.call(null,lang__$1);
var present_QMARK_ = fulcro.client.mutations.locale_present_QMARK_.call(null,lang__$1);
var valid_locale_QMARK_ = (function (){var or__28141__auto__ = present_QMARK_;
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
return fulcro.client.mutations.locale_loadable_QMARK_.call(null,locale_key);
}
})();
if(cljs.core.truth_(valid_locale_QMARK_)){
if(cljs.core.truth_((function (){var and__28129__auto__ = cljs.core.not.call(null,present_QMARK_);
if(and__28129__auto__){
return fulcro.client.mutations.locale_loadable_QMARK_.call(null,locale_key);
} else {
return and__28129__auto__;
}
})())){
cljs.loader.load.call(null,locale_key,((function (lang__$1,locale_key,present_QMARK_,valid_locale_QMARK_){
return (function (){
return fulcro.client.logging.debug.call(null,"Finished loading locale ",lang__$1);
});})(lang__$1,locale_key,present_QMARK_,valid_locale_QMARK_))
);
} else {
}

cljs.core.reset_BANG_.call(null,fulcro.i18n._STAR_current_locale_STAR_,lang__$1);

return cljs.core.assoc.call(null,cljs.core.assoc.call(null,state_map,new cljs.core.Keyword("ui","locale","ui/locale",-2115717461),lang__$1),new cljs.core.Keyword("ui","react-key","ui/react-key",1337877664),lang__$1);
} else {
fulcro.client.logging.error.call(null,["Attempt to change locale to ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(lang__$1)," but there was no such locale required or available as a loadable module."].join(''));

return state_map;
}
});
cljs.core._add_method.call(null,fulcro.client.mutations.mutate,new cljs.core.Symbol("fulcro.client.mutations","change-locale","fulcro.client.mutations/change-locale",386431844,null),(function (env57798,_,p__57799){
var map__57800 = p__57799;
var map__57800__$1 = ((((!((map__57800 == null)))?((((map__57800.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57800.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57800):map__57800);
var lang = cljs.core.get.call(null,map__57800__$1,new cljs.core.Keyword(null,"lang","lang",-1819677104));
return cljs.core.merge.call(null,(function (){var map__57802 = env57798;
var map__57802__$1 = ((((!((map__57802 == null)))?((((map__57802.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57802.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57802):map__57802);
var state = cljs.core.get.call(null,map__57802__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"action","action",-811238024),((function (map__57802,map__57802__$1,state,map__57800,map__57800__$1,lang){
return (function (){
return cljs.core.swap_BANG_.call(null,state,fulcro.client.mutations.change_locale_impl,lang);
});})(map__57802,map__57802__$1,state,map__57800,map__57800__$1,lang))
], null);
})(),(function (){var env = env57798;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"remote","remote",-1593576576),false], null);
})());
}));
cljs.core._add_method.call(null,fulcro.client.mutations.mutate,new cljs.core.Symbol("fulcro.client.mutations","set-props","fulcro.client.mutations/set-props",-1739323709,null),(function (env57804,_,params){
return cljs.core.merge.call(null,(function (){var map__57805 = env57804;
var map__57805__$1 = ((((!((map__57805 == null)))?((((map__57805.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57805.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57805):map__57805);
var state = cljs.core.get.call(null,map__57805__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var ref = cljs.core.get.call(null,map__57805__$1,new cljs.core.Keyword(null,"ref","ref",1289896967));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"action","action",-811238024),((function (map__57805,map__57805__$1,state,ref){
return (function (){
if((ref == null)){
fulcro.client.logging.error.call(null,"ui/set-props requires component to have an ident.");
} else {
}

return cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,ref,((function (map__57805,map__57805__$1,state,ref){
return (function (st){
return cljs.core.merge.call(null,st,params);
});})(map__57805,map__57805__$1,state,ref))
);
});})(map__57805,map__57805__$1,state,ref))
], null);
})(),(function (){var env = env57804;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"remote","remote",-1593576576),false], null);
})());
}));
cljs.core._add_method.call(null,fulcro.client.mutations.mutate,new cljs.core.Symbol("fulcro.client.mutations","toggle","fulcro.client.mutations/toggle",-1176623641,null),(function (env57807,_,p__57808){
var map__57809 = p__57808;
var map__57809__$1 = ((((!((map__57809 == null)))?((((map__57809.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57809.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57809):map__57809);
var field = cljs.core.get.call(null,map__57809__$1,new cljs.core.Keyword(null,"field","field",-1302436500));
return cljs.core.merge.call(null,(function (){var map__57811 = env57807;
var map__57811__$1 = ((((!((map__57811 == null)))?((((map__57811.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57811.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57811):map__57811);
var state = cljs.core.get.call(null,map__57811__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var ref = cljs.core.get.call(null,map__57811__$1,new cljs.core.Keyword(null,"ref","ref",1289896967));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"action","action",-811238024),((function (map__57811,map__57811__$1,state,ref,map__57809,map__57809__$1,field){
return (function (){
if((ref == null)){
fulcro.client.logging.error.call(null,"ui/toggle requires component to have an ident.");
} else {
}

return cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,cljs.core.conj.call(null,ref,field),cljs.core.not);
});})(map__57811,map__57811__$1,state,ref,map__57809,map__57809__$1,field))
], null);
})(),(function (){var env = env57807;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"remote","remote",-1593576576),false], null);
})());
}));
cljs.core._add_method.call(null,fulcro.client.mutations.mutate,new cljs.core.Keyword(null,"default","default",-1987822328),(function (p__57813,k,_){
var map__57814 = p__57813;
var map__57814__$1 = ((((!((map__57814 == null)))?((((map__57814.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57814.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57814):map__57814);
var target = cljs.core.get.call(null,map__57814__$1,new cljs.core.Keyword(null,"target","target",253001721));
if((target == null)){
return fulcro.client.logging.error.call(null,fulcro.client.logging.value_message.call(null,"Unknown app state mutation. Have you required the file with your mutations?",k));
} else {
return null;
}
}));
/**
 * Toggle the given boolean `field` on the specified component. It is recommended you use this function only on
 *   UI-related data (e.g. form checkbox checked status) and write clear top-level transactions for anything more complicated.
 */
fulcro.client.mutations.toggle_BANG_ = (function fulcro$client$mutations$toggle_BANG_(comp,field){
return om.next.transact_BANG_.call(null,comp,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__29003__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("fulcro.client.mutations","toggle","fulcro.client.mutations/toggle",-1176623641,null)),(function (){var x__29003__auto__ = cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"field","field",-1302436500)),(function (){var x__29003__auto__ = field;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__29003__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__29003__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__29003__auto__);
})())))));
});
/**
 * Set a raw value on the given `field` of a `component`. It is recommended you use this function only on
 *   UI-related data (e.g. form inputs that are used by the UI, and not persisted data).
 */
fulcro.client.mutations.set_value_BANG_ = (function fulcro$client$mutations$set_value_BANG_(component,field,value){
return om.next.transact_BANG_.call(null,component,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__29003__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("fulcro.client.mutations","set-props","fulcro.client.mutations/set-props",-1739323709,null)),(function (){var x__29003__auto__ = cljs.core.PersistentArrayMap.createAsIfByAssoc([field,value]);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__29003__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__29003__auto__);
})())))));
});
/**
 * Helper for set-integer!, use that instead. It is recommended you use this function only on UI-related
 *   data (e.g. data that is used for display purposes) and write clear top-level transactions for anything else.
 */
fulcro.client.mutations.ensure_integer = (function fulcro$client$mutations$ensure_integer(v){
var rv = parseInt(v);
if(cljs.core.truth_(isNaN(v))){
return (0);
} else {
return rv;
}
});
fulcro.client.mutations.target_value = (function fulcro$client$mutations$target_value(evt){
return evt.target.value;
});
/**
 * Set the given integer on the given `field` of a `component`. Allows same parameters as `set-string!`.
 * 
 * It is recommended you use this function only on UI-related data (e.g. data that is used for display purposes)
 * and write clear top-level transactions for anything else.
 */
fulcro.client.mutations.set_integer_BANG_ = (function fulcro$client$mutations$set_integer_BANG_(var_args){
var args__29319__auto__ = [];
var len__29312__auto___57822 = arguments.length;
var i__29313__auto___57823 = (0);
while(true){
if((i__29313__auto___57823 < len__29312__auto___57822)){
args__29319__auto__.push((arguments[i__29313__auto___57823]));

var G__57824 = (i__29313__auto___57823 + (1));
i__29313__auto___57823 = G__57824;
continue;
} else {
}
break;
}

var argseq__29320__auto__ = ((((2) < args__29319__auto__.length))?(new cljs.core.IndexedSeq(args__29319__auto__.slice((2)),(0),null)):null);
return fulcro.client.mutations.set_integer_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__29320__auto__);
});

fulcro.client.mutations.set_integer_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (component,field,p__57819){
var map__57820 = p__57819;
var map__57820__$1 = ((((!((map__57820 == null)))?((((map__57820.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57820.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57820):map__57820);
var event = cljs.core.get.call(null,map__57820__$1,new cljs.core.Keyword(null,"event","event",301435442));
var value = cljs.core.get.call(null,map__57820__$1,new cljs.core.Keyword(null,"value","value",305978217));
if(cljs.core.truth_((function (){var and__28129__auto__ = (function (){var or__28141__auto__ = event;
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
return value;
}
})();
if(cljs.core.truth_(and__28129__auto__)){
return cljs.core.not.call(null,(function (){var and__28129__auto____$1 = event;
if(cljs.core.truth_(and__28129__auto____$1)){
return value;
} else {
return and__28129__auto____$1;
}
})());
} else {
return and__28129__auto__;
}
})())){
} else {
throw (new Error(["Assert failed: ","Supply either :event or :value","\n","(and (or event value) (not (and event value)))"].join('')));
}

var value__$1 = fulcro.client.mutations.ensure_integer.call(null,(cljs.core.truth_(event)?fulcro.client.mutations.target_value.call(null,event):value));
return fulcro.client.mutations.set_value_BANG_.call(null,component,field,value__$1);
});

fulcro.client.mutations.set_integer_BANG_.cljs$lang$maxFixedArity = (2);

fulcro.client.mutations.set_integer_BANG_.cljs$lang$applyTo = (function (seq57816){
var G__57817 = cljs.core.first.call(null,seq57816);
var seq57816__$1 = cljs.core.next.call(null,seq57816);
var G__57818 = cljs.core.first.call(null,seq57816__$1);
var seq57816__$2 = cljs.core.next.call(null,seq57816__$1);
return fulcro.client.mutations.set_integer_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__57817,G__57818,seq57816__$2);
});

/**
 * Set a string on the given `field` of a `component`. The string can be literal via named parameter `:value` or
 *   can be auto-extracted from a UI event using the named parameter `:event`
 * 
 *   Examples
 * 
 *   ```
 *   (set-string! this :ui/name :value "Hello") ; set from literal (or var)
 *   (set-string! this :ui/name :event evt) ; extract from UI event target value
 *   ```
 * 
 *   It is recommended you use this function only on UI-related
 *   data (e.g. data that is used for display purposes) and write clear top-level transactions for anything else.
 */
fulcro.client.mutations.set_string_BANG_ = (function fulcro$client$mutations$set_string_BANG_(var_args){
var args__29319__auto__ = [];
var len__29312__auto___57831 = arguments.length;
var i__29313__auto___57832 = (0);
while(true){
if((i__29313__auto___57832 < len__29312__auto___57831)){
args__29319__auto__.push((arguments[i__29313__auto___57832]));

var G__57833 = (i__29313__auto___57832 + (1));
i__29313__auto___57832 = G__57833;
continue;
} else {
}
break;
}

var argseq__29320__auto__ = ((((2) < args__29319__auto__.length))?(new cljs.core.IndexedSeq(args__29319__auto__.slice((2)),(0),null)):null);
return fulcro.client.mutations.set_string_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__29320__auto__);
});

fulcro.client.mutations.set_string_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (component,field,p__57828){
var map__57829 = p__57828;
var map__57829__$1 = ((((!((map__57829 == null)))?((((map__57829.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57829.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57829):map__57829);
var event = cljs.core.get.call(null,map__57829__$1,new cljs.core.Keyword(null,"event","event",301435442));
var value = cljs.core.get.call(null,map__57829__$1,new cljs.core.Keyword(null,"value","value",305978217));
if(cljs.core.truth_((function (){var and__28129__auto__ = (function (){var or__28141__auto__ = event;
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
return value;
}
})();
if(cljs.core.truth_(and__28129__auto__)){
return cljs.core.not.call(null,(function (){var and__28129__auto____$1 = event;
if(cljs.core.truth_(and__28129__auto____$1)){
return value;
} else {
return and__28129__auto____$1;
}
})());
} else {
return and__28129__auto__;
}
})())){
} else {
throw (new Error(["Assert failed: ","Supply either :event or :value","\n","(and (or event value) (not (and event value)))"].join('')));
}

var value__$1 = (cljs.core.truth_(event)?fulcro.client.mutations.target_value.call(null,event):value);
return fulcro.client.mutations.set_value_BANG_.call(null,component,field,value__$1);
});

fulcro.client.mutations.set_string_BANG_.cljs$lang$maxFixedArity = (2);

fulcro.client.mutations.set_string_BANG_.cljs$lang$applyTo = (function (seq57825){
var G__57826 = cljs.core.first.call(null,seq57825);
var seq57825__$1 = cljs.core.next.call(null,seq57825);
var G__57827 = cljs.core.first.call(null,seq57825__$1);
var seq57825__$2 = cljs.core.next.call(null,seq57825__$1);
return fulcro.client.mutations.set_string_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__57826,G__57827,seq57825__$2);
});


//# sourceMappingURL=mutations.js.map?rel=1511229560871
