// Compiled by ClojureScript 1.9.946 {}
goog.provide('fulcro.client.impl.data_fetch');
goog.require('cljs.core');
goog.require('om.next.impl.parser');
goog.require('om.next');
goog.require('om.next.protocols');
goog.require('om.util');
goog.require('clojure.walk');
goog.require('clojure.set');
goog.require('fulcro.client.logging');
goog.require('fulcro.client.util');
goog.require('fulcro.client.mutations');
goog.require('fulcro.client.impl.om_plumbing');











/**
 * Test if the given bit of state is a data fetch state-tracking marker
 */
fulcro.client.impl.data_fetch.data_state_QMARK_ = (function fulcro$client$impl$data_fetch$data_state_QMARK_(state){
return cljs.core.contains_QMARK_.call(null,state,new cljs.core.Keyword("fulcro.client.impl.data-fetch","type","fulcro.client.impl.data-fetch/type",296514265));
});
var is_kind_QMARK_ = (function fulcro$client$impl$data_fetch$is_kind_QMARK_(state,type){
if(cljs.core.truth_(fulcro.client.impl.data_fetch.data_state_QMARK_.call(null,state))){
return cljs.core._EQ_.call(null,type,new cljs.core.Keyword("fulcro.client.impl.data-fetch","type","fulcro.client.impl.data-fetch/type",296514265).cljs$core$IFn$_invoke$arity$1(state));
} else {
return false;
}
});
/**
 * Test if the given item is a data state marker that is in the ready state
 */
fulcro.client.impl.data_fetch.ready_QMARK_ = (function fulcro$client$impl$data_fetch$ready_QMARK_(state){
return is_kind_QMARK_.call(null,state,new cljs.core.Keyword(null,"ready","ready",1086465795));
});

/**
 * Test if the given item is a data state marker in the loading state
 */
fulcro.client.impl.data_fetch.loading_QMARK_ = (function fulcro$client$impl$data_fetch$loading_QMARK_(state){
return is_kind_QMARK_.call(null,state,new cljs.core.Keyword(null,"loading","loading",-737050189));
});

/**
 * Test if the given item is a data state marker in the failed state
 */
fulcro.client.impl.data_fetch.failed_QMARK_ = (function fulcro$client$impl$data_fetch$failed_QMARK_(state){
return is_kind_QMARK_.call(null,state,new cljs.core.Keyword(null,"failed","failed",-1397425762));
});
fulcro.client.impl.data_fetch.is_direct_table_load_QMARK_ = (function fulcro$client$impl$data_fetch$is_direct_table_load_QMARK_(load_marker){
return (cljs.core.not.call(null,fulcro.client.impl.data_fetch.data_field.call(null,load_marker))) && (om.util.ident_QMARK_.call(null,fulcro.client.impl.data_fetch.data_query_key.call(null,load_marker)));
});
fulcro.client.impl.data_fetch.place_load_marker = (function fulcro$client$impl$data_fetch$place_load_marker(state_map,marker){
return cljs.core.update_in.call(null,state_map,fulcro.client.impl.data_fetch.data_path.call(null,marker),(function (current_val){
if(cljs.core.truth_(fulcro.client.impl.data_fetch.is_direct_table_load_QMARK_.call(null,marker))){
if(cljs.core.map_QMARK_.call(null,current_val)){
return cljs.core.assoc.call(null,current_val,new cljs.core.Keyword("ui","fetch-state","ui/fetch-state",1030289927),marker);
} else {
return null;
}
} else {
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("ui","fetch-state","ui/fetch-state",1030289927),marker], null);
}
}));
});
/**
 * Place load markers in the app state at their data paths so that UI rendering can see them.
 */
fulcro.client.impl.data_fetch.place_load_markers = (function fulcro$client$impl$data_fetch$place_load_markers(state_atom,items_to_load){
return cljs.core.swap_BANG_.call(null,state_atom,(function (state_map){
return cljs.core.reduce.call(null,(function (s,item){
var i = fulcro.client.impl.data_fetch.set_loading_BANG_.call(null,item);
var G__57888 = cljs.core.update.call(null,s,new cljs.core.Keyword("fulcro","loads-in-progress","fulcro/loads-in-progress",-1196090224),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentHashSet.EMPTY),fulcro.client.impl.data_fetch.data_uuid.call(null,i));
if(cljs.core.truth_(fulcro.client.impl.data_fetch.data_marker_QMARK_.call(null,i))){
return fulcro.client.impl.data_fetch.place_load_marker.call(null,G__57888,i);
} else {
return G__57888;
}
}),state_map,items_to_load);
}));
});
/**
 * Marks all of the items in the ready-to-load state as loading, places the loading markers in the appropriate locations
 *   in the app state, and return maps with the keys:
 * 
 *   `query` : The full query to send to the server.
 *   `on-load` : The function to call to merge a response. Detects missing data and sets failure markers for those.
 *   `on-error` : The function to call to set network/server error(s) in place of loading markers.
 *   `load-descriptors` : Args to pass back to on-load and on-error. These are separated
 *  so that `rewrite-tempids-in-request-queue` can rewrite tempids for merge and
 *  error callbacks
 * 
 *   response-channel will have the response posted to it when the request is done.
 *   .
 */
fulcro.client.impl.data_fetch.mark_parallel_loading = (function fulcro$client$impl$data_fetch$mark_parallel_loading(remote_name,reconciler){
var state = om.next.app_state.call(null,reconciler);
var queued_items = cljs.core.get.call(null,cljs.core.deref.call(null,state),new cljs.core.Keyword("fulcro","ready-to-load","fulcro/ready-to-load",127104696));
var is_eligible_QMARK_ = ((function (state,queued_items){
return (function (item){
var and__28129__auto__ = new cljs.core.Keyword("fulcro.client.impl.data-fetch","parallel","fulcro.client.impl.data-fetch/parallel",1010707051).cljs$core$IFn$_invoke$arity$1(item);
if(cljs.core.truth_(and__28129__auto__)){
return cljs.core._EQ_.call(null,remote_name,fulcro.client.impl.data_fetch.data_remote.call(null,item));
} else {
return and__28129__auto__;
}
});})(state,queued_items))
;
var other_items_loading_QMARK_ = cljs.core.boolean$.call(null,cljs.core.seq.call(null,cljs.core.get.call(null,cljs.core.deref.call(null,state),new cljs.core.Keyword("fulcro","loads-in-progress","fulcro/loads-in-progress",-1196090224))));
var items_to_load = cljs.core.filter.call(null,is_eligible_QMARK_,queued_items);
var remaining_items = cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,is_eligible_QMARK_),queued_items);
var loading_QMARK_ = (cljs.core.seq.call(null,items_to_load)) || (other_items_loading_QMARK_);
if(cljs.core.empty_QMARK_.call(null,items_to_load)){
return null;
} else {
fulcro.client.impl.data_fetch.place_load_markers.call(null,state,items_to_load);

cljs.core.swap_BANG_.call(null,state,cljs.core.assoc,new cljs.core.Keyword("ui","loading-data","ui/loading-data",-1566515143),loading_QMARK_,new cljs.core.Keyword("fulcro","ready-to-load","fulcro/ready-to-load",127104696),remaining_items);

var iter__28949__auto__ = ((function (state,queued_items,is_eligible_QMARK_,other_items_loading_QMARK_,items_to_load,remaining_items,loading_QMARK_){
return (function fulcro$client$impl$data_fetch$mark_parallel_loading_$_iter__57889(s__57890){
return (new cljs.core.LazySeq(null,((function (state,queued_items,is_eligible_QMARK_,other_items_loading_QMARK_,items_to_load,remaining_items,loading_QMARK_){
return (function (){
var s__57890__$1 = s__57890;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__57890__$1);
if(temp__4657__auto__){
var s__57890__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__57890__$2)){
var c__28947__auto__ = cljs.core.chunk_first.call(null,s__57890__$2);
var size__28948__auto__ = cljs.core.count.call(null,c__28947__auto__);
var b__57892 = cljs.core.chunk_buffer.call(null,size__28948__auto__);
if((function (){var i__57891 = (0);
while(true){
if((i__57891 < size__28948__auto__)){
var item = cljs.core._nth.call(null,c__28947__auto__,i__57891);
cljs.core.chunk_append.call(null,b__57892,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"query","query",-1288509510),fulcro.client.impl.data_fetch.full_query.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [item], null)),new cljs.core.Keyword(null,"on-load","on-load",1415151594),fulcro.client.impl.data_fetch.loaded_callback.call(null,reconciler),new cljs.core.Keyword(null,"on-error","on-error",1728533530),fulcro.client.impl.data_fetch.error_callback.call(null,reconciler),new cljs.core.Keyword(null,"load-descriptors","load-descriptors",391720681),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [item], null)], null));

var G__57893 = (i__57891 + (1));
i__57891 = G__57893;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__57892),fulcro$client$impl$data_fetch$mark_parallel_loading_$_iter__57889.call(null,cljs.core.chunk_rest.call(null,s__57890__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__57892),null);
}
} else {
var item = cljs.core.first.call(null,s__57890__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"query","query",-1288509510),fulcro.client.impl.data_fetch.full_query.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [item], null)),new cljs.core.Keyword(null,"on-load","on-load",1415151594),fulcro.client.impl.data_fetch.loaded_callback.call(null,reconciler),new cljs.core.Keyword(null,"on-error","on-error",1728533530),fulcro.client.impl.data_fetch.error_callback.call(null,reconciler),new cljs.core.Keyword(null,"load-descriptors","load-descriptors",391720681),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [item], null)], null),fulcro$client$impl$data_fetch$mark_parallel_loading_$_iter__57889.call(null,cljs.core.rest.call(null,s__57890__$2)));
}
} else {
return null;
}
break;
}
});})(state,queued_items,is_eligible_QMARK_,other_items_loading_QMARK_,items_to_load,remaining_items,loading_QMARK_))
,null,null));
});})(state,queued_items,is_eligible_QMARK_,other_items_loading_QMARK_,items_to_load,remaining_items,loading_QMARK_))
;
return iter__28949__auto__.call(null,items_to_load);
}
});
/**
 * Returns a lazy sequence of the elements of coll with dupes removed.
 * An element is a duplicate IFF (keys-fn element) has key collision with any prior element
 * to come before it. E.g. (dedupe-by identity [[:a] [:b] [:a] [:a :c]]) => [[:a] [:b]]
 * Returns a stateful transducer when no collection is provided.
 */
fulcro.client.impl.data_fetch.dedupe_by = (function fulcro$client$impl$data_fetch$dedupe_by(var_args){
var G__57895 = arguments.length;
switch (G__57895) {
case 1:
return fulcro.client.impl.data_fetch.dedupe_by.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fulcro.client.impl.data_fetch.dedupe_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fulcro.client.impl.data_fetch.dedupe_by.cljs$core$IFn$_invoke$arity$1 = (function (keys_fn){
return (function (rf){
var keys_seen = cljs.core.volatile_BANG_.call(null,cljs.core.PersistentHashSet.EMPTY);
return ((function (keys_seen){
return (function() {
var G__57897 = null;
var G__57897__0 = (function (){
return rf.call(null);
});
var G__57897__1 = (function (result){
return rf.call(null,result);
});
var G__57897__2 = (function (result,input){
var input_keys = cljs.core.set.call(null,keys_fn.call(null,input));
if(cljs.core.empty_QMARK_.call(null,clojure.set.intersection.call(null,cljs.core.deref.call(null,keys_seen),input_keys))){
cljs.core._vreset_BANG_.call(null,keys_seen,clojure.set.union.call(null,cljs.core._deref.call(null,keys_seen),input_keys));

return rf.call(null,result,input);
} else {
return result;
}
});
G__57897 = function(result,input){
switch(arguments.length){
case 0:
return G__57897__0.call(this);
case 1:
return G__57897__1.call(this,result);
case 2:
return G__57897__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__57897.cljs$core$IFn$_invoke$arity$0 = G__57897__0;
G__57897.cljs$core$IFn$_invoke$arity$1 = G__57897__1;
G__57897.cljs$core$IFn$_invoke$arity$2 = G__57897__2;
return G__57897;
})()
;})(keys_seen))
});
});

fulcro.client.impl.data_fetch.dedupe_by.cljs$core$IFn$_invoke$arity$2 = (function (keys_fn,coll){
return cljs.core.sequence.call(null,fulcro.client.impl.data_fetch.dedupe_by.call(null,keys_fn),coll);
});

fulcro.client.impl.data_fetch.dedupe_by.cljs$lang$maxFixedArity = 2;

fulcro.client.impl.data_fetch.join_key_or_nil = (function fulcro$client$impl$data_fetch$join_key_or_nil(expr){
if(cljs.core.truth_(om.util.join_QMARK_.call(null,expr))){
var join_key_or_ident = om.util.join_key.call(null,expr);
if(om.util.ident_QMARK_.call(null,join_key_or_ident)){
return cljs.core.first.call(null,join_key_or_ident);
} else {
return join_key_or_ident;
}
} else {
return null;
}
});
/**
 * This function is used to split accidental colliding queries into separate network
 *   requests. The most general description of this issue is
 *   from two unrelated `load` calls when black-box composing functions. The two
 *   separate queries: One issues `[{:entitlements [:foo]}]`, and the other
 *   asks for `[{:entitlements [:bar]}]`. Fulcro merges these into a single query
 *   [{:entitlements [:foo]} {:entitlements [:bar]}]. However, the response to a query
 *   is a map, and such a query would result in the backend parser being called twice (once per key in the subquery)
 *   but one would stomp on the other. Thus, this function ensures such accidental collisions are
 *   not combined into a single network request.
 */
fulcro.client.impl.data_fetch.split_items_ready_to_load = (function fulcro$client$impl$data_fetch$split_items_ready_to_load(items_ready_to_load){
var items_to_load_now = cljs.core.vec.call(null,fulcro.client.impl.data_fetch.dedupe_by.call(null,(function (item){
return cljs.core.map.call(null,fulcro.client.impl.data_fetch.join_key_or_nil,fulcro.client.impl.data_fetch.data_query.call(null,item));
}),items_ready_to_load));
var is_loading_now_QMARK_ = cljs.core.set.call(null,items_to_load_now);
var items_to_defer = cljs.core.vec.call(null,cljs.core.remove.call(null,is_loading_now_QMARK_,items_ready_to_load));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [items_to_load_now,items_to_defer], null);
});
/**
 * Marks all of the items in the ready-to-load state as loading, places the loading markers in the appropriate locations
 *   in the app state, and returns a map with the keys:
 * 
 *   `query` : The full query to send to the server.
 *   `on-load` : The function to call to merge a response. Detects missing data and sets failure markers for those.
 *   `on-error` : The function to call to set network/server error(s) in place of loading markers.
 *   `load-descriptors` : Args to pass back to on-load and on-error. These are separated
 *  so that `rewrite-tempids-in-request-queue` can rewrite tempids for merge and
 *  error callbacks
 * 
 *   response-channel will have the response posted to it when the request is done.
 *   .
 */
fulcro.client.impl.data_fetch.mark_loading = (function fulcro$client$impl$data_fetch$mark_loading(remote,reconciler){
var state = om.next.app_state.call(null,reconciler);
var is_eligible_QMARK_ = ((function (state){
return (function (item){
return cljs.core._EQ_.call(null,remote,fulcro.client.impl.data_fetch.data_remote.call(null,item));
});})(state))
;
var all_items = cljs.core.get.call(null,cljs.core.deref.call(null,state),new cljs.core.Keyword("fulcro","ready-to-load","fulcro/ready-to-load",127104696));
var items_ready_to_load = cljs.core.filter.call(null,is_eligible_QMARK_,all_items);
var items_for_other_remotes = cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,is_eligible_QMARK_),all_items);
var other_items_loading_QMARK_ = cljs.core.boolean$.call(null,cljs.core.seq.call(null,cljs.core.get.call(null,cljs.core.deref.call(null,state),new cljs.core.Keyword("fulcro","loads-in-progress","fulcro/loads-in-progress",-1196090224))));
var vec__57898 = fulcro.client.impl.data_fetch.split_items_ready_to_load.call(null,items_ready_to_load);
var items_to_load_now = cljs.core.nth.call(null,vec__57898,(0),null);
var items_to_defer = cljs.core.nth.call(null,vec__57898,(1),null);
var remaining_items = cljs.core.concat.call(null,items_for_other_remotes,items_to_defer);
var loading_QMARK_ = (cljs.core.seq.call(null,items_to_load_now)) || (other_items_loading_QMARK_);
if(cljs.core.empty_QMARK_.call(null,items_to_load_now)){
return null;
} else {
fulcro.client.impl.data_fetch.place_load_markers.call(null,state,items_to_load_now);

cljs.core.swap_BANG_.call(null,state,cljs.core.assoc,new cljs.core.Keyword("ui","loading-data","ui/loading-data",-1566515143),loading_QMARK_,new cljs.core.Keyword("fulcro","ready-to-load","fulcro/ready-to-load",127104696),remaining_items);

return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"query","query",-1288509510),fulcro.client.impl.data_fetch.full_query.call(null,items_to_load_now),new cljs.core.Keyword(null,"on-load","on-load",1415151594),fulcro.client.impl.data_fetch.loaded_callback.call(null,reconciler),new cljs.core.Keyword(null,"on-error","on-error",1728533530),fulcro.client.impl.data_fetch.error_callback.call(null,reconciler),new cljs.core.Keyword(null,"load-descriptors","load-descriptors",391720681),items_to_load_now], null);
}
});
fulcro.client.impl.data_fetch.valid_types = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"ready","ready",1086465795),null,new cljs.core.Keyword(null,"loading","loading",-737050189),null,new cljs.core.Keyword(null,"failed","failed",-1397425762),null], null), null);
/**
 * This is just a testing function -- using ready-state as public interface and call the
 *   `set-{type}!` functions to change it as needed.
 */
fulcro.client.impl.data_fetch.make_data_state = (function fulcro$client$impl$data_fetch$make_data_state(var_args){
var G__57902 = arguments.length;
switch (G__57902) {
case 1:
return fulcro.client.impl.data_fetch.make_data_state.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fulcro.client.impl.data_fetch.make_data_state.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fulcro.client.impl.data_fetch.make_data_state.cljs$core$IFn$_invoke$arity$1 = (function (type){
return fulcro.client.impl.data_fetch.make_data_state.call(null,type,cljs.core.PersistentArrayMap.EMPTY);
});

fulcro.client.impl.data_fetch.make_data_state.cljs$core$IFn$_invoke$arity$2 = (function (type,params){
if(cljs.core.truth_(cljs.core.get.call(null,fulcro.client.impl.data_fetch.valid_types,type))){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("fulcro.client.impl.data-fetch","type","fulcro.client.impl.data-fetch/type",296514265),type,new cljs.core.Keyword("fulcro.client.impl.data-fetch","params","fulcro.client.impl.data-fetch/params",1865690070),params], null);
} else {
throw cljs.core.ex_info.call(null,["INVALID DATA STATE TYPE: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}
});

fulcro.client.impl.data_fetch.make_data_state.cljs$lang$maxFixedArity = 2;

/**
 * Remove items from a query (AST) that have a key listed in the elision-set
 */
fulcro.client.impl.data_fetch.elide_ast_nodes = (function fulcro$client$impl$data_fetch$elide_ast_nodes(p__57905,elision_set){
var map__57906 = p__57905;
var map__57906__$1 = ((((!((map__57906 == null)))?((((map__57906.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57906.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57906):map__57906);
var ast = map__57906__$1;
var key = cljs.core.get.call(null,map__57906__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var union_key = cljs.core.get.call(null,map__57906__$1,new cljs.core.Keyword(null,"union-key","union-key",1529707234));
var children = cljs.core.get.call(null,map__57906__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var union_elision_QMARK_ = cljs.core.contains_QMARK_.call(null,elision_set,union_key);
if((union_elision_QMARK_) || (cljs.core.contains_QMARK_.call(null,elision_set,key))){
return null;
} else {
if((union_elision_QMARK_) && ((cljs.core.count.call(null,children) <= (2)))){
fulcro.client.logging.warn.call(null,"Om unions are not designed to be used with fewer than two children. Check your calls to Fulcro\n        load functions where the :without set contains ",cljs.core.pr_str.call(null,union_key));
} else {
}

return cljs.core.update.call(null,ast,new cljs.core.Keyword(null,"children","children",-940561982),((function (union_elision_QMARK_,map__57906,map__57906__$1,ast,key,union_key,children){
return (function (c){
return cljs.core.vec.call(null,cljs.core.keep.call(null,((function (union_elision_QMARK_,map__57906,map__57906__$1,ast,key,union_key,children){
return (function (p1__57904_SHARP_){
return fulcro.client.impl.data_fetch.elide_ast_nodes.call(null,p1__57904_SHARP_,elision_set);
});})(union_elision_QMARK_,map__57906,map__57906__$1,ast,key,union_key,children))
,c));
});})(union_elision_QMARK_,map__57906,map__57906__$1,ast,key,union_key,children))
);
}
});
/**
 * Inject parameters into elements of the top-level query.
 * 
 *   `params` is a map from keyword (on the query in the AST) to parameter maps. So, given the AST for this query:
 * 
 *   ```
 *   [:a :b :c]
 *   ```
 * 
 *   and a `params` of `{:a {:x 1} :c {:y 2}}` you'll get an AST representing:
 * 
 *   ```
 *   [(:a {:x 1}) :b (:c {:y 2})]
 *   ```
 *   
 */
fulcro.client.impl.data_fetch.inject_query_params = (function fulcro$client$impl$data_fetch$inject_query_params(ast,params){
var top_level_keys = cljs.core.set.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"dispatch-key","dispatch-key",733619510),new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(ast)));
var param_keys = cljs.core.set.call(null,cljs.core.keys.call(null,params));
var unknown_keys = clojure.set.difference.call(null,param_keys,top_level_keys);
if(!(cljs.core.empty_QMARK_.call(null,unknown_keys))){
fulcro.client.logging.error.call(null,["Error: You attempted to add parameters for ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,unknown_keys))," to top-level key(s) of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,om.next.ast__GT_query.call(null,ast)))].join(''));
} else {
}

return cljs.core.update_in.call(null,ast,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"children","children",-940561982)], null),((function (top_level_keys,param_keys,unknown_keys){
return (function (p1__57908_SHARP_){
return cljs.core.map.call(null,((function (top_level_keys,param_keys,unknown_keys){
return (function (c){
var temp__4655__auto__ = cljs.core.get.call(null,params,new cljs.core.Keyword(null,"dispatch-key","dispatch-key",733619510).cljs$core$IFn$_invoke$arity$1(c));
if(cljs.core.truth_(temp__4655__auto__)){
var new_params = temp__4655__auto__;
return cljs.core.update.call(null,c,new cljs.core.Keyword(null,"params","params",710516235),cljs.core.merge,new_params);
} else {
return c;
}
});})(top_level_keys,param_keys,unknown_keys))
,p1__57908_SHARP_);
});})(top_level_keys,param_keys,unknown_keys))
);
});
/**
 * Generate a ready-to-load state with all of the necessary details to do
 *   remoting and merging.
 */
fulcro.client.impl.data_fetch.ready_state = (function fulcro$client$impl$data_fetch$ready_state(p__57909){
var map__57910 = p__57909;
var map__57910__$1 = ((((!((map__57910 == null)))?((((map__57910.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57910.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57910):map__57910);
var target = cljs.core.get.call(null,map__57910__$1,new cljs.core.Keyword(null,"target","target",253001721));
var query = cljs.core.get.call(null,map__57910__$1,new cljs.core.Keyword(null,"query","query",-1288509510));
var remote = cljs.core.get.call(null,map__57910__$1,new cljs.core.Keyword(null,"remote","remote",-1593576576),new cljs.core.Keyword(null,"remote","remote",-1593576576));
var refresh = cljs.core.get.call(null,map__57910__$1,new cljs.core.Keyword(null,"refresh","refresh",1947415525),cljs.core.PersistentVector.EMPTY);
var parallel = cljs.core.get.call(null,map__57910__$1,new cljs.core.Keyword(null,"parallel","parallel",-1863607128));
var fallback = cljs.core.get.call(null,map__57910__$1,new cljs.core.Keyword(null,"fallback","fallback",761637929));
var marker = cljs.core.get.call(null,map__57910__$1,new cljs.core.Keyword(null,"marker","marker",865118313),true);
var params = cljs.core.get.call(null,map__57910__$1,new cljs.core.Keyword(null,"params","params",710516235));
var field = cljs.core.get.call(null,map__57910__$1,new cljs.core.Keyword(null,"field","field",-1302436500));
var env = cljs.core.get.call(null,map__57910__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var post_mutation = cljs.core.get.call(null,map__57910__$1,new cljs.core.Keyword(null,"post-mutation","post-mutation",-1076606705));
var without = cljs.core.get.call(null,map__57910__$1,new cljs.core.Keyword(null,"without","without",1107036688),cljs.core.PersistentHashSet.EMPTY);
var ident = cljs.core.get.call(null,map__57910__$1,new cljs.core.Keyword(null,"ident","ident",-742346));
var post_mutation_params = cljs.core.get.call(null,map__57910__$1,new cljs.core.Keyword(null,"post-mutation-params","post-mutation-params",-849425897));
if(cljs.core.truth_((function (){var or__28141__auto__ = field;
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
return query;
}
})())){
} else {
throw (new Error(["Assert failed: ","You must supply a query or a field/ident pair","\n","(or field query)"].join('')));
}

if(cljs.core.truth_((function (){var or__28141__auto__ = cljs.core.not.call(null,field);
if(or__28141__auto__){
return or__28141__auto__;
} else {
var and__28129__auto__ = field;
if(cljs.core.truth_(and__28129__auto__)){
return om.util.ident_QMARK_.call(null,ident);
} else {
return and__28129__auto__;
}
}
})())){
} else {
throw (new Error(["Assert failed: ","Field requires ident","\n","(or (not field) (and field (util/ident? ident)))"].join('')));
}

var old_ast = om.next.query__GT_ast.call(null,query);
var ast = (function (){var G__57912 = old_ast;
var G__57912__$1 = (cljs.core.truth_(cljs.core.not_empty.call(null,without))?fulcro.client.impl.data_fetch.elide_ast_nodes.call(null,G__57912,without):G__57912);
if(cljs.core.truth_(params)){
return fulcro.client.impl.data_fetch.inject_query_params.call(null,G__57912__$1,params);
} else {
return G__57912__$1;
}
})();
var query_field = cljs.core.first.call(null,query);
var key = (cljs.core.truth_(om.util.join_QMARK_.call(null,query_field))?om.util.join_key.call(null,query_field):query_field);
var query_SINGLEQUOTE_ = om.next.ast__GT_query.call(null,ast);
if((cljs.core.not.call(null,field)) || (cljs.core._EQ_.call(null,field,key))){
} else {
throw (new Error(["Assert failed: ","Component fetch query does not match supplied field.","\n","(or (not field) (= field key))"].join('')));
}

return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword("fulcro.client.impl.data-fetch","uuid","fulcro.client.impl.data-fetch/uuid",1534451240),new cljs.core.Keyword("fulcro.client.impl.data-fetch","parallel","fulcro.client.impl.data-fetch/parallel",1010707051),new cljs.core.Keyword("fulcro.client.impl.data-fetch","target","fulcro.client.impl.data-fetch/target",1805324748),new cljs.core.Keyword("fulcro.client.impl.data-fetch","original-env","fulcro.client.impl.data-fetch/original-env",1405563884),new cljs.core.Keyword("fulcro.client.impl.data-fetch","remote","fulcro.client.impl.data-fetch/remote",340944109),new cljs.core.Keyword("fulcro.client.impl.data-fetch","query","fulcro.client.impl.data-fetch/query",-555583859),new cljs.core.Keyword("fulcro.client.impl.data-fetch","refresh","fulcro.client.impl.data-fetch/refresh",-12271976),new cljs.core.Keyword("fulcro.client.impl.data-fetch","ident","fulcro.client.impl.data-fetch/ident",1787247225),new cljs.core.Keyword("fulcro.client.impl.data-fetch","type","fulcro.client.impl.data-fetch/type",296514265),new cljs.core.Keyword("fulcro.client.impl.data-fetch","post-mutation-params","fulcro.client.impl.data-fetch/post-mutation-params",430524764),new cljs.core.Keyword("fulcro.client.impl.data-fetch","fallback","fulcro.client.impl.data-fetch/fallback",-644539810),new cljs.core.Keyword("fulcro.client.impl.data-fetch","marker","fulcro.client.impl.data-fetch/marker",392378046),new cljs.core.Keyword("fulcro.client.impl.data-fetch","post-mutation","fulcro.client.impl.data-fetch/post-mutation",-75376962),new cljs.core.Keyword("fulcro.client.impl.data-fetch","field","fulcro.client.impl.data-fetch/field",-439885921)],[[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.random_uuid.call(null))].join(''),parallel,target,cljs.core.with_meta.call(null,cljs.core.PersistentArrayMap.EMPTY,env),remote,query_SINGLEQUOTE_,refresh,ident,new cljs.core.Keyword(null,"ready","ready",1086465795),post_mutation_params,fallback,marker,post_mutation,field]);
});
/**
 * Place a ready-to-load marker into the application state. This should be done from
 *   a mutate function that is abstractly loading something. This is intended for internal use.
 * 
 *   See the `load` and `load-field` functions in `fulcro.client.data-fetch` for the public API.
 */
fulcro.client.impl.data_fetch.mark_ready = (function fulcro$client$impl$data_fetch$mark_ready(p__57913){
var map__57914 = p__57913;
var map__57914__$1 = ((((!((map__57914 == null)))?((((map__57914.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57914.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57914):map__57914);
var config = map__57914__$1;
var env = cljs.core.get.call(null,map__57914__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var state = cljs.core.get.call(null,env,new cljs.core.Keyword(null,"state","state",-1988618099));
var marker_QMARK_ = !((false === new cljs.core.Keyword(null,"marker","marker",865118313).cljs$core$IFn$_invoke$arity$1(config)));
var load_request = fulcro.client.impl.data_fetch.ready_state.call(null,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"marker","marker",865118313),true,new cljs.core.Keyword(null,"refresh","refresh",1947415525),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"without","without",1107036688),cljs.core.PersistentHashSet.EMPTY,new cljs.core.Keyword(null,"env","env",-1815813235),env], null),config));
return cljs.core.swap_BANG_.call(null,state,((function (state,marker_QMARK_,load_request,map__57914,map__57914__$1,config,env){
return (function (s){
var G__57916 = cljs.core.update.call(null,s,new cljs.core.Keyword("fulcro","ready-to-load","fulcro/ready-to-load",127104696),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),load_request);
if(marker_QMARK_){
return fulcro.client.impl.data_fetch.place_load_marker.call(null,G__57916,load_request);
} else {
return G__57916;
}
});})(state,marker_QMARK_,load_request,map__57914,map__57914__$1,config,env))
);
});
/**
 * Return the ident (if any) of the component related to the query in the data state marker. An ident is required
 *   to be present if the marker is targeting a field.
 */
fulcro.client.impl.data_fetch.data_target = (function fulcro$client$impl$data_fetch$data_target(state){
return new cljs.core.Keyword("fulcro.client.impl.data-fetch","target","fulcro.client.impl.data-fetch/target",1805324748).cljs$core$IFn$_invoke$arity$1(state);
});
/**
 * Return the ident (if any) of the component related to the query in the data state marker. An ident is required
 *   to be present if the marker is targeting a field.
 */
fulcro.client.impl.data_fetch.data_ident = (function fulcro$client$impl$data_fetch$data_ident(state){
return new cljs.core.Keyword("fulcro.client.impl.data-fetch","ident","fulcro.client.impl.data-fetch/ident",1787247225).cljs$core$IFn$_invoke$arity$1(state);
});
/**
 * Get the query that will be sent to the server as a result of the given data state marker
 */
fulcro.client.impl.data_fetch.data_query = (function fulcro$client$impl$data_fetch$data_query(state){
if(cljs.core.truth_(fulcro.client.impl.data_fetch.data_ident.call(null,state))){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentArrayMap.createAsIfByAssoc([fulcro.client.impl.data_fetch.data_ident.call(null,state),new cljs.core.Keyword("fulcro.client.impl.data-fetch","query","fulcro.client.impl.data-fetch/query",-555583859).cljs$core$IFn$_invoke$arity$1(state)])], null);
} else {
return new cljs.core.Keyword("fulcro.client.impl.data-fetch","query","fulcro.client.impl.data-fetch/query",-555583859).cljs$core$IFn$_invoke$arity$1(state);
}
});
/**
 * Get the target field (if any) from the data state marker
 */
fulcro.client.impl.data_fetch.data_field = (function fulcro$client$impl$data_fetch$data_field(state){
return new cljs.core.Keyword("fulcro.client.impl.data-fetch","field","fulcro.client.impl.data-fetch/field",-439885921).cljs$core$IFn$_invoke$arity$1(state);
});
/**
 * Get the UUID of the data fetch
 */
fulcro.client.impl.data_fetch.data_uuid = (function fulcro$client$impl$data_fetch$data_uuid(state){
return new cljs.core.Keyword("fulcro.client.impl.data-fetch","uuid","fulcro.client.impl.data-fetch/uuid",1534451240).cljs$core$IFn$_invoke$arity$1(state);
});
/**
 * Test if the user desires a copy of the state marker to appear in the app state at the data path of the target data.
 */
fulcro.client.impl.data_fetch.data_marker_QMARK_ = (function fulcro$client$impl$data_fetch$data_marker_QMARK_(state){
return new cljs.core.Keyword("fulcro.client.impl.data-fetch","marker","fulcro.client.impl.data-fetch/marker",392378046).cljs$core$IFn$_invoke$arity$1(state);
});
/**
 * Get the list of query keywords that should be refreshed (re-rendered) when this load completes.
 */
fulcro.client.impl.data_fetch.data_refresh = (function fulcro$client$impl$data_fetch$data_refresh(state){
return new cljs.core.Keyword("fulcro.client.impl.data-fetch","refresh","fulcro.client.impl.data-fetch/refresh",-12271976).cljs$core$IFn$_invoke$arity$1(state);
});
/**
 * Get the remote that this marker is meant to talk to
 */
fulcro.client.impl.data_fetch.data_remote = (function fulcro$client$impl$data_fetch$data_remote(state){
return new cljs.core.Keyword("fulcro.client.impl.data-fetch","remote","fulcro.client.impl.data-fetch/remote",340944109).cljs$core$IFn$_invoke$arity$1(state);
});
/**
 * Get the 'primary' query key of the data fetch. This is defined as the first keyword of the overall query (which might
 *   be a simple prop or join key for example)
 */
fulcro.client.impl.data_fetch.data_query_key = (function fulcro$client$impl$data_fetch$data_query_key(state){
var ast = om.next.query__GT_ast.call(null,new cljs.core.Keyword("fulcro.client.impl.data-fetch","query","fulcro.client.impl.data-fetch/query",-555583859).cljs$core$IFn$_invoke$arity$1(state));
var node = cljs.core.first.call(null,new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(ast));
return new cljs.core.Keyword(null,"key","key",-1516042587).cljs$core$IFn$_invoke$arity$1(node);
});
/**
 * Get the app-state database path of the target of the load that the given data state marker is trying to load.
 */
fulcro.client.impl.data_fetch.data_path = (function fulcro$client$impl$data_fetch$data_path(state){
var target = fulcro.client.impl.data_fetch.data_target.call(null,state);
if(cljs.core.truth_((function (){var and__28129__auto__ = (fulcro.client.impl.data_fetch.data_field.call(null,state) == null);
if(and__28129__auto__){
var and__28129__auto____$1 = cljs.core.vector_QMARK_.call(null,target);
if(and__28129__auto____$1){
return cljs.core.not_empty.call(null,target);
} else {
return and__28129__auto____$1;
}
} else {
return and__28129__auto__;
}
})())){
return target;
} else {
if((cljs.core.vector_QMARK_.call(null,fulcro.client.impl.data_fetch.data_ident.call(null,state))) && ((fulcro.client.impl.data_fetch.data_field.call(null,state) instanceof cljs.core.Keyword))){
return cljs.core.conj.call(null,fulcro.client.impl.data_fetch.data_ident.call(null,state),fulcro.client.impl.data_fetch.data_field.call(null,state));
} else {
if(om.util.ident_QMARK_.call(null,fulcro.client.impl.data_fetch.data_query_key.call(null,state))){
return fulcro.client.impl.data_fetch.data_query_key.call(null,state);
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fulcro.client.impl.data_fetch.data_query_key.call(null,state)], null);

}
}
}
});
/**
 * Get the parameters that the user wants to add to the first join/keyword of the data fetch query.
 */
fulcro.client.impl.data_fetch.data_params = (function fulcro$client$impl$data_fetch$data_params(state){
return new cljs.core.Keyword("fulcro.client.impl.data-fetch","params","fulcro.client.impl.data-fetch/params",1865690070).cljs$core$IFn$_invoke$arity$1(state);
});
/**
 * Get the keywords that should be (recursively) removed from the query that will be sent to the server.
 */
fulcro.client.impl.data_fetch.data_exclusions = (function fulcro$client$impl$data_fetch$data_exclusions(state){
return new cljs.core.Keyword("fulcro.client.impl.data-fetch","without","fulcro.client.impl.data-fetch/without",357489619).cljs$core$IFn$_invoke$arity$1(state);
});
var set_type = (function fulcro$client$impl$data_fetch$set_type(state,type,params){
return cljs.core.merge.call(null,state,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("fulcro.client.impl.data-fetch","type","fulcro.client.impl.data-fetch/type",296514265),type,new cljs.core.Keyword("fulcro.client.impl.data-fetch","params","fulcro.client.impl.data-fetch/params",1865690070),params], null));
});
/**
 * Returns a state (based on the input state) that is in the 'ready' to load state.
 */
fulcro.client.impl.data_fetch.set_ready_BANG_ = (function fulcro$client$impl$data_fetch$set_ready_BANG_(var_args){
var G__57918 = arguments.length;
switch (G__57918) {
case 1:
return fulcro.client.impl.data_fetch.set_ready_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fulcro.client.impl.data_fetch.set_ready_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fulcro.client.impl.data_fetch.set_ready_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (state){
return fulcro.client.impl.data_fetch.set_ready_BANG_.call(null,state,null);
});

fulcro.client.impl.data_fetch.set_ready_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (state,params){
return set_type.call(null,state,new cljs.core.Keyword(null,"ready","ready",1086465795),params);
});

fulcro.client.impl.data_fetch.set_ready_BANG_.cljs$lang$maxFixedArity = 2;


/**
 * Returns a marker (based on the input state) that is in the loading state (and ensures that it has a UUID)
 */
fulcro.client.impl.data_fetch.set_loading_BANG_ = (function fulcro$client$impl$data_fetch$set_loading_BANG_(var_args){
var G__57920 = arguments.length;
switch (G__57920) {
case 1:
return fulcro.client.impl.data_fetch.set_loading_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fulcro.client.impl.data_fetch.set_loading_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fulcro.client.impl.data_fetch.set_loading_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (state){
return fulcro.client.impl.data_fetch.set_loading_BANG_.call(null,state,null);
});

fulcro.client.impl.data_fetch.set_loading_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (state,params){
var rv = set_type.call(null,state,new cljs.core.Keyword(null,"loading","loading",-737050189),params);
return cljs.core.with_meta.call(null,rv,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"state","state",-1988618099),rv], null));
});

fulcro.client.impl.data_fetch.set_loading_BANG_.cljs$lang$maxFixedArity = 2;


/**
 * Returns a marker (based on the input state) that is in the error state
 */
fulcro.client.impl.data_fetch.set_failed_BANG_ = (function fulcro$client$impl$data_fetch$set_failed_BANG_(var_args){
var G__57922 = arguments.length;
switch (G__57922) {
case 1:
return fulcro.client.impl.data_fetch.set_failed_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fulcro.client.impl.data_fetch.set_failed_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fulcro.client.impl.data_fetch.set_failed_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (state){
return fulcro.client.impl.data_fetch.set_failed_BANG_.call(null,state,null);
});

fulcro.client.impl.data_fetch.set_failed_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (state,params){
return set_type.call(null,state,new cljs.core.Keyword(null,"failed","failed",-1397425762),params);
});

fulcro.client.impl.data_fetch.set_failed_BANG_.cljs$lang$maxFixedArity = 2;

/**
 * Composes together the queries of a sequence of data states into a single query.
 */
fulcro.client.impl.data_fetch.full_query = (function fulcro$client$impl$data_fetch$full_query(items){
return cljs.core.vec.call(null,cljs.core.mapcat.call(null,(function (item){
return fulcro.client.impl.data_fetch.data_query.call(null,item);
}),items));
});
fulcro.client.impl.data_fetch.set_global_loading = (function fulcro$client$impl$data_fetch$set_global_loading(reconciler){

var state_atom = om.next.app_state.call(null,reconciler);
var loading_QMARK_ = cljs.core.boolean$.call(null,cljs.core.seq.call(null,cljs.core.get.call(null,cljs.core.deref.call(null,state_atom),new cljs.core.Keyword("fulcro","loads-in-progress","fulcro/loads-in-progress",-1196090224))));
return cljs.core.swap_BANG_.call(null,state_atom,cljs.core.assoc,new cljs.core.Keyword("ui","loading-data","ui/loading-data",-1566515143),loading_QMARK_);
});
/**
 * For items that are manually targeted, move them in app state from their result location to their target location.
 */
fulcro.client.impl.data_fetch.relocate_targeted_results = (function fulcro$client$impl$data_fetch$relocate_targeted_results(state_atom,items){
return cljs.core.swap_BANG_.call(null,state_atom,(function (state_map){
return cljs.core.reduce.call(null,(function (state,item){
var default_target = fulcro.client.impl.data_fetch.data_query_key.call(null,item);
var explicit_target = (function (){var or__28141__auto__ = fulcro.client.impl.data_fetch.data_target.call(null,item);
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})();
var relocate_QMARK_ = (function (){var and__28129__auto__ = (fulcro.client.impl.data_fetch.data_field.call(null,item) == null);
if(and__28129__auto__){
var and__28129__auto____$1 = (fulcro.client.impl.data_fetch.data_query_key.call(null,item) instanceof cljs.core.Keyword);
if(and__28129__auto____$1){
return cljs.core.not_empty.call(null,explicit_target);
} else {
return and__28129__auto____$1;
}
} else {
return and__28129__auto__;
}
})();
if(cljs.core.truth_(relocate_QMARK_)){
var value = cljs.core.get.call(null,state,default_target);
return cljs.core.assoc_in.call(null,cljs.core.dissoc.call(null,state,fulcro.client.impl.data_fetch.data_query_key.call(null,item)),explicit_target,value);
} else {
return state;
}
}),state_map,items);
}));
});
/**
 * Returns app-state without the load marker for the given item.
 */
fulcro.client.impl.data_fetch.remove_marker = (function fulcro$client$impl$data_fetch$remove_marker(app_state,item){
var path = fulcro.client.impl.data_fetch.data_path.call(null,item);
var data = cljs.core.get_in.call(null,app_state,path);
if((cljs.core.map_QMARK_.call(null,data)) && (cljs.core._EQ_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("ui","fetch-state","ui/fetch-state",1030289927),null], null), null),cljs.core.set.call(null,cljs.core.keys.call(null,data))))){
return cljs.core.assoc_in.call(null,app_state,path,null);
} else {
if((cljs.core.map_QMARK_.call(null,data)) && (cljs.core.contains_QMARK_.call(null,data,new cljs.core.Keyword("ui","fetch-state","ui/fetch-state",1030289927)))){
return cljs.core.update_in.call(null,app_state,path,cljs.core.dissoc,new cljs.core.Keyword("ui","fetch-state","ui/fetch-state",1030289927));
} else {
return cljs.core.assoc_in.call(null,app_state,path,null);

}
}
});
/**
 * Build a callback env for post mutations and fallbacks
 */
fulcro.client.impl.data_fetch.callback_env = (function fulcro$client$impl$data_fetch$callback_env(reconciler,load_request,original_env){
var state = om.next.app_state.call(null,reconciler);
var map__57926 = load_request;
var map__57926__$1 = ((((!((map__57926 == null)))?((((map__57926.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57926.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57926):map__57926);
var parallel = cljs.core.get.call(null,map__57926__$1,new cljs.core.Keyword("fulcro.client.impl.data-fetch","parallel","fulcro.client.impl.data-fetch/parallel",1010707051));
var target = cljs.core.get.call(null,map__57926__$1,new cljs.core.Keyword("fulcro.client.impl.data-fetch","target","fulcro.client.impl.data-fetch/target",1805324748));
var remote = cljs.core.get.call(null,map__57926__$1,new cljs.core.Keyword("fulcro.client.impl.data-fetch","remote","fulcro.client.impl.data-fetch/remote",340944109));
var query = cljs.core.get.call(null,map__57926__$1,new cljs.core.Keyword("fulcro.client.impl.data-fetch","query","fulcro.client.impl.data-fetch/query",-555583859));
var refresh = cljs.core.get.call(null,map__57926__$1,new cljs.core.Keyword("fulcro.client.impl.data-fetch","refresh","fulcro.client.impl.data-fetch/refresh",-12271976));
var ident = cljs.core.get.call(null,map__57926__$1,new cljs.core.Keyword("fulcro.client.impl.data-fetch","ident","fulcro.client.impl.data-fetch/ident",1787247225));
var post_mutation_params = cljs.core.get.call(null,map__57926__$1,new cljs.core.Keyword("fulcro.client.impl.data-fetch","post-mutation-params","fulcro.client.impl.data-fetch/post-mutation-params",430524764));
var fallback = cljs.core.get.call(null,map__57926__$1,new cljs.core.Keyword("fulcro.client.impl.data-fetch","fallback","fulcro.client.impl.data-fetch/fallback",-644539810));
var marker = cljs.core.get.call(null,map__57926__$1,new cljs.core.Keyword("fulcro.client.impl.data-fetch","marker","fulcro.client.impl.data-fetch/marker",392378046));
var post_mutation = cljs.core.get.call(null,map__57926__$1,new cljs.core.Keyword("fulcro.client.impl.data-fetch","post-mutation","fulcro.client.impl.data-fetch/post-mutation",-75376962));
var field = cljs.core.get.call(null,map__57926__$1,new cljs.core.Keyword("fulcro.client.impl.data-fetch","field","fulcro.client.impl.data-fetch/field",-439885921));
return cljs.core.merge.call(null,original_env,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"state","state",-1988618099),state,new cljs.core.Keyword(null,"load-request","load-request",693664659),(function (){var G__57928 = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"target","target",253001721),target,new cljs.core.Keyword(null,"remote","remote",-1593576576),remote,new cljs.core.Keyword(null,"marker","marker",865118313),marker,new cljs.core.Keyword(null,"server-query","server-query",-191976706),query,new cljs.core.Keyword(null,"parallel","parallel",-1863607128),cljs.core.boolean$.call(null,parallel)], null);
var G__57928__$1 = (cljs.core.truth_(post_mutation)?cljs.core.assoc.call(null,G__57928,new cljs.core.Keyword(null,"post-mutation","post-mutation",-1076606705),post_mutation):G__57928);
var G__57928__$2 = (cljs.core.truth_(post_mutation_params)?cljs.core.assoc.call(null,G__57928__$1,new cljs.core.Keyword(null,"post-mutation-params","post-mutation-params",-849425897),post_mutation_params):G__57928__$1);
var G__57928__$3 = (cljs.core.truth_(refresh)?cljs.core.assoc.call(null,G__57928__$2,new cljs.core.Keyword(null,"refresh","refresh",1947415525),refresh):G__57928__$2);
if(cljs.core.truth_(fallback)){
return cljs.core.assoc.call(null,G__57928__$3,new cljs.core.Keyword(null,"fallback","fallback",761637929),fallback);
} else {
return G__57928__$3;
}
})()], null));
});
/**
 * Generates a callback that processes all of the post-processing steps once a remote load has completed. This includes:
 * 
 *   - Marking the items that were queries for but not returned as 'missing' (see documentation on mark and sweep of db)
 *   - Refreshing elements of the UI that were included in the data fetch :refresh option
 *   - Removing loading markers related to the executed loads that were not overwritten by incoming data
 *   - Merging the incoming data into the normalized database
 *   - Running post-mutations for any fetches that completed
 *   - Updating the global loading marker
 *   - Triggering re-render for all data item refresh lists
 *   
 */
fulcro.client.impl.data_fetch.loaded_callback = (function fulcro$client$impl$data_fetch$loaded_callback(reconciler){
return (function (response,items){
var query = fulcro.client.impl.data_fetch.full_query.call(null,items);
var loading_items = cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.map.call(null,fulcro.client.impl.data_fetch.set_loading_BANG_,items));
var refresh_set = cljs.core.into.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("ui","loading-data","ui/loading-data",-1566515143),null], null), null),cljs.core.mapcat.call(null,fulcro.client.impl.data_fetch.data_refresh,items));
var to_refresh = cljs.core.vec.call(null,refresh_set);
var marked_response = fulcro.client.impl.om_plumbing.mark_missing.call(null,response,query);
var app_state = om.next.app_state.call(null,reconciler);
var ran_mutations = cljs.core.atom.call(null,false);
var remove_markers = ((function (query,loading_items,refresh_set,to_refresh,marked_response,app_state,ran_mutations){
return (function (){
var seq__57929 = cljs.core.seq.call(null,loading_items);
var chunk__57930 = null;
var count__57931 = (0);
var i__57932 = (0);
while(true){
if((i__57932 < count__57931)){
var item = cljs.core._nth.call(null,chunk__57930,i__57932);
cljs.core.swap_BANG_.call(null,app_state,((function (seq__57929,chunk__57930,count__57931,i__57932,item,query,loading_items,refresh_set,to_refresh,marked_response,app_state,ran_mutations){
return (function (s){
var G__57933 = s;
var G__57933__$1 = cljs.core.update.call(null,G__57933,new cljs.core.Keyword("fulcro","loads-in-progress","fulcro/loads-in-progress",-1196090224),cljs.core.disj,fulcro.client.impl.data_fetch.data_uuid.call(null,item))
;
if(cljs.core.truth_(fulcro.client.impl.data_fetch.data_marker_QMARK_.call(null,item))){
return fulcro.client.impl.data_fetch.remove_marker.call(null,G__57933__$1,item);
} else {
return G__57933__$1;
}
});})(seq__57929,chunk__57930,count__57931,i__57932,item,query,loading_items,refresh_set,to_refresh,marked_response,app_state,ran_mutations))
);

var G__57941 = seq__57929;
var G__57942 = chunk__57930;
var G__57943 = count__57931;
var G__57944 = (i__57932 + (1));
seq__57929 = G__57941;
chunk__57930 = G__57942;
count__57931 = G__57943;
i__57932 = G__57944;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__57929);
if(temp__4657__auto__){
var seq__57929__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__57929__$1)){
var c__28980__auto__ = cljs.core.chunk_first.call(null,seq__57929__$1);
var G__57945 = cljs.core.chunk_rest.call(null,seq__57929__$1);
var G__57946 = c__28980__auto__;
var G__57947 = cljs.core.count.call(null,c__28980__auto__);
var G__57948 = (0);
seq__57929 = G__57945;
chunk__57930 = G__57946;
count__57931 = G__57947;
i__57932 = G__57948;
continue;
} else {
var item = cljs.core.first.call(null,seq__57929__$1);
cljs.core.swap_BANG_.call(null,app_state,((function (seq__57929,chunk__57930,count__57931,i__57932,item,seq__57929__$1,temp__4657__auto__,query,loading_items,refresh_set,to_refresh,marked_response,app_state,ran_mutations){
return (function (s){
var G__57934 = s;
var G__57934__$1 = cljs.core.update.call(null,G__57934,new cljs.core.Keyword("fulcro","loads-in-progress","fulcro/loads-in-progress",-1196090224),cljs.core.disj,fulcro.client.impl.data_fetch.data_uuid.call(null,item))
;
if(cljs.core.truth_(fulcro.client.impl.data_fetch.data_marker_QMARK_.call(null,item))){
return fulcro.client.impl.data_fetch.remove_marker.call(null,G__57934__$1,item);
} else {
return G__57934__$1;
}
});})(seq__57929,chunk__57930,count__57931,i__57932,item,seq__57929__$1,temp__4657__auto__,query,loading_items,refresh_set,to_refresh,marked_response,app_state,ran_mutations))
);

var G__57949 = cljs.core.next.call(null,seq__57929__$1);
var G__57950 = null;
var G__57951 = (0);
var G__57952 = (0);
seq__57929 = G__57949;
chunk__57930 = G__57950;
count__57931 = G__57951;
i__57932 = G__57952;
continue;
}
} else {
return null;
}
}
break;
}
});})(query,loading_items,refresh_set,to_refresh,marked_response,app_state,ran_mutations))
;
var run_post_mutations = ((function (query,loading_items,refresh_set,to_refresh,marked_response,app_state,ran_mutations,remove_markers){
return (function (){
var seq__57935 = cljs.core.seq.call(null,loading_items);
var chunk__57936 = null;
var count__57937 = (0);
var i__57938 = (0);
while(true){
if((i__57938 < count__57937)){
var item = cljs.core._nth.call(null,chunk__57936,i__57938);
var temp__4657__auto___57953 = new cljs.core.Keyword("fulcro.client.impl.data-fetch","post-mutation","fulcro.client.impl.data-fetch/post-mutation",-75376962).cljs$core$IFn$_invoke$arity$1(item);
if(cljs.core.truth_(temp__4657__auto___57953)){
var mutation_symbol_57954 = temp__4657__auto___57953;
cljs.core.reset_BANG_.call(null,ran_mutations,true);

var params_57955 = (function (){var or__28141__auto__ = new cljs.core.Keyword("fulcro.client.impl.data-fetch","post-mutation-params","fulcro.client.impl.data-fetch/post-mutation-params",430524764).cljs$core$IFn$_invoke$arity$1(item);
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
var original_env_57956 = cljs.core.meta.call(null,new cljs.core.Keyword("fulcro.client.impl.data-fetch","original-env","fulcro.client.impl.data-fetch/original-env",1405563884).cljs$core$IFn$_invoke$arity$1(item));
var G__57939_57957 = fulcro.client.mutations.mutate.call(null,fulcro.client.impl.data_fetch.callback_env.call(null,reconciler,item,original_env_57956),mutation_symbol_57954,params_57955);
var G__57939_57958__$1 = (((G__57939_57957 == null))?null:new cljs.core.Keyword(null,"action","action",-811238024).cljs$core$IFn$_invoke$arity$1(G__57939_57957));
if((G__57939_57958__$1 == null)){
} else {
cljs.core.apply.call(null,G__57939_57958__$1,cljs.core.PersistentVector.EMPTY);
}
} else {
}

var G__57959 = seq__57935;
var G__57960 = chunk__57936;
var G__57961 = count__57937;
var G__57962 = (i__57938 + (1));
seq__57935 = G__57959;
chunk__57936 = G__57960;
count__57937 = G__57961;
i__57938 = G__57962;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__57935);
if(temp__4657__auto__){
var seq__57935__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__57935__$1)){
var c__28980__auto__ = cljs.core.chunk_first.call(null,seq__57935__$1);
var G__57963 = cljs.core.chunk_rest.call(null,seq__57935__$1);
var G__57964 = c__28980__auto__;
var G__57965 = cljs.core.count.call(null,c__28980__auto__);
var G__57966 = (0);
seq__57935 = G__57963;
chunk__57936 = G__57964;
count__57937 = G__57965;
i__57938 = G__57966;
continue;
} else {
var item = cljs.core.first.call(null,seq__57935__$1);
var temp__4657__auto___57967__$1 = new cljs.core.Keyword("fulcro.client.impl.data-fetch","post-mutation","fulcro.client.impl.data-fetch/post-mutation",-75376962).cljs$core$IFn$_invoke$arity$1(item);
if(cljs.core.truth_(temp__4657__auto___57967__$1)){
var mutation_symbol_57968 = temp__4657__auto___57967__$1;
cljs.core.reset_BANG_.call(null,ran_mutations,true);

var params_57969 = (function (){var or__28141__auto__ = new cljs.core.Keyword("fulcro.client.impl.data-fetch","post-mutation-params","fulcro.client.impl.data-fetch/post-mutation-params",430524764).cljs$core$IFn$_invoke$arity$1(item);
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
var original_env_57970 = cljs.core.meta.call(null,new cljs.core.Keyword("fulcro.client.impl.data-fetch","original-env","fulcro.client.impl.data-fetch/original-env",1405563884).cljs$core$IFn$_invoke$arity$1(item));
var G__57940_57971 = fulcro.client.mutations.mutate.call(null,fulcro.client.impl.data_fetch.callback_env.call(null,reconciler,item,original_env_57970),mutation_symbol_57968,params_57969);
var G__57940_57972__$1 = (((G__57940_57971 == null))?null:new cljs.core.Keyword(null,"action","action",-811238024).cljs$core$IFn$_invoke$arity$1(G__57940_57971));
if((G__57940_57972__$1 == null)){
} else {
cljs.core.apply.call(null,G__57940_57972__$1,cljs.core.PersistentVector.EMPTY);
}
} else {
}

var G__57973 = cljs.core.next.call(null,seq__57935__$1);
var G__57974 = null;
var G__57975 = (0);
var G__57976 = (0);
seq__57935 = G__57973;
chunk__57936 = G__57974;
count__57937 = G__57975;
i__57938 = G__57976;
continue;
}
} else {
return null;
}
}
break;
}
});})(query,loading_items,refresh_set,to_refresh,marked_response,app_state,ran_mutations,remove_markers))
;
remove_markers.call(null);

om.next.merge_BANG_.call(null,reconciler,marked_response,query);

fulcro.client.impl.data_fetch.relocate_targeted_results.call(null,app_state,loading_items);

run_post_mutations.call(null);

fulcro.client.impl.data_fetch.set_global_loading.call(null,reconciler);

if(cljs.core.contains_QMARK_.call(null,refresh_set,new cljs.core.Keyword("fulcro","force-root","fulcro/force-root",1965847682))){
return om.next.force_root_render_BANG_.call(null,reconciler);
} else {
return fulcro.client.util.force_render.call(null,reconciler,to_refresh);
}
});
});
/**
 * Generates a callback that is used whenever a hard server error occurs (status code 400+ or network error).
 * 
 *   The generated callback:
 * 
 *   - Replaces affected loading markers with error markers (if :marker is true on the load item)
 *   - Runs fallbacks associated with the loads
 *   - Sets the global error marker (:fulcro/server-error)
 *   - Refreshes UI (from root if there were fallbacks)
 *   
 */
fulcro.client.impl.data_fetch.error_callback = (function fulcro$client$impl$data_fetch$error_callback(reconciler){
return (function (error,items){
var loading_items = cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.map.call(null,fulcro.client.impl.data_fetch.set_loading_BANG_,items));
var app_state = om.next.app_state.call(null,reconciler);
var refresh_set = cljs.core.into.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("ui","loading-data","ui/loading-data",-1566515143),null], null), null),cljs.core.mapcat.call(null,fulcro.client.impl.data_fetch.data_refresh,items));
var to_refresh = cljs.core.vec.call(null,refresh_set);
var ran_fallbacks = cljs.core.atom.call(null,false);
var mark_errors = ((function (loading_items,app_state,refresh_set,to_refresh,ran_fallbacks){
return (function (){
cljs.core.swap_BANG_.call(null,app_state,cljs.core.assoc,new cljs.core.Keyword("fulcro","server-error","fulcro/server-error",-1254037316),error);

var seq__57977 = cljs.core.seq.call(null,loading_items);
var chunk__57978 = null;
var count__57979 = (0);
var i__57980 = (0);
while(true){
if((i__57980 < count__57979)){
var item = cljs.core._nth.call(null,chunk__57978,i__57980);
cljs.core.swap_BANG_.call(null,app_state,((function (seq__57977,chunk__57978,count__57979,i__57980,item,loading_items,app_state,refresh_set,to_refresh,ran_fallbacks){
return (function (s){
var G__57981 = s;
var G__57981__$1 = (cljs.core.truth_(fulcro.client.impl.data_fetch.data_marker_QMARK_.call(null,item))?cljs.core.update_in.call(null,G__57981,cljs.core.conj.call(null,fulcro.client.impl.data_fetch.data_path.call(null,item),new cljs.core.Keyword("ui","fetch-state","ui/fetch-state",1030289927)),fulcro.client.impl.data_fetch.set_failed_BANG_,error):G__57981);
return cljs.core.update.call(null,G__57981__$1,new cljs.core.Keyword("fulcro","loads-in-progress","fulcro/loads-in-progress",-1196090224),cljs.core.disj,fulcro.client.impl.data_fetch.data_uuid.call(null,item));

});})(seq__57977,chunk__57978,count__57979,i__57980,item,loading_items,app_state,refresh_set,to_refresh,ran_fallbacks))
);

var G__57989 = seq__57977;
var G__57990 = chunk__57978;
var G__57991 = count__57979;
var G__57992 = (i__57980 + (1));
seq__57977 = G__57989;
chunk__57978 = G__57990;
count__57979 = G__57991;
i__57980 = G__57992;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__57977);
if(temp__4657__auto__){
var seq__57977__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__57977__$1)){
var c__28980__auto__ = cljs.core.chunk_first.call(null,seq__57977__$1);
var G__57993 = cljs.core.chunk_rest.call(null,seq__57977__$1);
var G__57994 = c__28980__auto__;
var G__57995 = cljs.core.count.call(null,c__28980__auto__);
var G__57996 = (0);
seq__57977 = G__57993;
chunk__57978 = G__57994;
count__57979 = G__57995;
i__57980 = G__57996;
continue;
} else {
var item = cljs.core.first.call(null,seq__57977__$1);
cljs.core.swap_BANG_.call(null,app_state,((function (seq__57977,chunk__57978,count__57979,i__57980,item,seq__57977__$1,temp__4657__auto__,loading_items,app_state,refresh_set,to_refresh,ran_fallbacks){
return (function (s){
var G__57982 = s;
var G__57982__$1 = (cljs.core.truth_(fulcro.client.impl.data_fetch.data_marker_QMARK_.call(null,item))?cljs.core.update_in.call(null,G__57982,cljs.core.conj.call(null,fulcro.client.impl.data_fetch.data_path.call(null,item),new cljs.core.Keyword("ui","fetch-state","ui/fetch-state",1030289927)),fulcro.client.impl.data_fetch.set_failed_BANG_,error):G__57982);
return cljs.core.update.call(null,G__57982__$1,new cljs.core.Keyword("fulcro","loads-in-progress","fulcro/loads-in-progress",-1196090224),cljs.core.disj,fulcro.client.impl.data_fetch.data_uuid.call(null,item));

});})(seq__57977,chunk__57978,count__57979,i__57980,item,seq__57977__$1,temp__4657__auto__,loading_items,app_state,refresh_set,to_refresh,ran_fallbacks))
);

var G__57997 = cljs.core.next.call(null,seq__57977__$1);
var G__57998 = null;
var G__57999 = (0);
var G__58000 = (0);
seq__57977 = G__57997;
chunk__57978 = G__57998;
count__57979 = G__57999;
i__57980 = G__58000;
continue;
}
} else {
return null;
}
}
break;
}
});})(loading_items,app_state,refresh_set,to_refresh,ran_fallbacks))
;
var run_fallbacks = ((function (loading_items,app_state,refresh_set,to_refresh,ran_fallbacks,mark_errors){
return (function (){
var seq__57983 = cljs.core.seq.call(null,loading_items);
var chunk__57984 = null;
var count__57985 = (0);
var i__57986 = (0);
while(true){
if((i__57986 < count__57985)){
var item = cljs.core._nth.call(null,chunk__57984,i__57986);
var temp__4657__auto___58001 = new cljs.core.Keyword("fulcro.client.impl.data-fetch","fallback","fulcro.client.impl.data-fetch/fallback",-644539810).cljs$core$IFn$_invoke$arity$1(item);
if(cljs.core.truth_(temp__4657__auto___58001)){
var fallback_symbol_58002 = temp__4657__auto___58001;
var original_env_58003 = cljs.core.meta.call(null,new cljs.core.Keyword("fulcro.client.impl.data-fetch","original-env","fulcro.client.impl.data-fetch/original-env",1405563884).cljs$core$IFn$_invoke$arity$1(item));
var env_58004 = fulcro.client.impl.data_fetch.callback_env.call(null,reconciler,item,original_env_58003);
cljs.core.reset_BANG_.call(null,ran_fallbacks,true);

var G__57987_58005 = fulcro.client.mutations.mutate.call(null,env_58004,fallback_symbol_58002,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"error","error",-978969032),error], null));
var G__57987_58006__$1 = (((G__57987_58005 == null))?null:new cljs.core.Keyword(null,"action","action",-811238024).cljs$core$IFn$_invoke$arity$1(G__57987_58005));
if((G__57987_58006__$1 == null)){
} else {
cljs.core.apply.call(null,G__57987_58006__$1,cljs.core.PersistentVector.EMPTY);
}
} else {
}

var G__58007 = seq__57983;
var G__58008 = chunk__57984;
var G__58009 = count__57985;
var G__58010 = (i__57986 + (1));
seq__57983 = G__58007;
chunk__57984 = G__58008;
count__57985 = G__58009;
i__57986 = G__58010;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__57983);
if(temp__4657__auto__){
var seq__57983__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__57983__$1)){
var c__28980__auto__ = cljs.core.chunk_first.call(null,seq__57983__$1);
var G__58011 = cljs.core.chunk_rest.call(null,seq__57983__$1);
var G__58012 = c__28980__auto__;
var G__58013 = cljs.core.count.call(null,c__28980__auto__);
var G__58014 = (0);
seq__57983 = G__58011;
chunk__57984 = G__58012;
count__57985 = G__58013;
i__57986 = G__58014;
continue;
} else {
var item = cljs.core.first.call(null,seq__57983__$1);
var temp__4657__auto___58015__$1 = new cljs.core.Keyword("fulcro.client.impl.data-fetch","fallback","fulcro.client.impl.data-fetch/fallback",-644539810).cljs$core$IFn$_invoke$arity$1(item);
if(cljs.core.truth_(temp__4657__auto___58015__$1)){
var fallback_symbol_58016 = temp__4657__auto___58015__$1;
var original_env_58017 = cljs.core.meta.call(null,new cljs.core.Keyword("fulcro.client.impl.data-fetch","original-env","fulcro.client.impl.data-fetch/original-env",1405563884).cljs$core$IFn$_invoke$arity$1(item));
var env_58018 = fulcro.client.impl.data_fetch.callback_env.call(null,reconciler,item,original_env_58017);
cljs.core.reset_BANG_.call(null,ran_fallbacks,true);

var G__57988_58019 = fulcro.client.mutations.mutate.call(null,env_58018,fallback_symbol_58016,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"error","error",-978969032),error], null));
var G__57988_58020__$1 = (((G__57988_58019 == null))?null:new cljs.core.Keyword(null,"action","action",-811238024).cljs$core$IFn$_invoke$arity$1(G__57988_58019));
if((G__57988_58020__$1 == null)){
} else {
cljs.core.apply.call(null,G__57988_58020__$1,cljs.core.PersistentVector.EMPTY);
}
} else {
}

var G__58021 = cljs.core.next.call(null,seq__57983__$1);
var G__58022 = null;
var G__58023 = (0);
var G__58024 = (0);
seq__57983 = G__58021;
chunk__57984 = G__58022;
count__57985 = G__58023;
i__57986 = G__58024;
continue;
}
} else {
return null;
}
}
break;
}
});})(loading_items,app_state,refresh_set,to_refresh,ran_fallbacks,mark_errors))
;
mark_errors.call(null);

run_fallbacks.call(null);

fulcro.client.impl.data_fetch.set_global_loading.call(null,reconciler);

return om.next.force_root_render_BANG_.call(null,reconciler);
});
});

//# sourceMappingURL=data_fetch.js.map?rel=1511229561167
