// Compiled by ClojureScript 1.9.946 {}
goog.provide('fulcro.client.impl.application');
goog.require('cljs.core');
goog.require('fulcro.client.logging');
goog.require('om.next');
goog.require('om.util');
goog.require('fulcro.i18n');
goog.require('fulcro.client.impl.data_fetch');
goog.require('fulcro.client.util');
goog.require('cljs.core.async');
goog.require('fulcro.client.network');
goog.require('fulcro.client.impl.om_plumbing');
/**
 * This internal function is responsible for generating and returning a function that can accomplish calling the fallbacks that
 *   appear in an incoming Om transaction, which is in turn used by the error-handling logic of the plumbing.
 */
fulcro.client.impl.application.fallback_handler = (function fulcro$client$impl$application$fallback_handler(p__58064,query){
var map__58065 = p__58064;
var map__58065__$1 = ((((!((map__58065 == null)))?((((map__58065.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__58065.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__58065):map__58065);
var reconciler = cljs.core.get.call(null,map__58065__$1,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966));
return ((function (map__58065,map__58065__$1,reconciler){
return (function (error){
cljs.core.swap_BANG_.call(null,om.next.app_state.call(null,reconciler),cljs.core.assoc,new cljs.core.Keyword("fulcro","server-error","fulcro/server-error",-1254037316),error);

var temp__4655__auto__ = fulcro.client.impl.om_plumbing.fallback_query.call(null,query,error);
if(cljs.core.truth_(temp__4655__auto__)){
var q = temp__4655__auto__;
fulcro.client.logging.warn.call(null,fulcro.client.logging.value_message.call(null,"Transaction failed. Running fallback.",q));

return om.next.transact_BANG_.call(null,reconciler,q);
} else {
return fulcro.client.logging.warn.call(null,"Fallback triggered, but no fallbacks were defined.");
}
});
;})(map__58065,map__58065__$1,reconciler))
});
/**
 * Enqueue a send to the network queue. This is a standalone function because we cannot mock core async functions.
 */
fulcro.client.impl.application.enqueue = (function fulcro$client$impl$application$enqueue(q,v){
var c__42036__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42036__auto__){
return (function (){
var f__42037__auto__ = (function (){var switch__42015__auto__ = ((function (c__42036__auto__){
return (function (state_58070){
var state_val_58071 = (state_58070[(1)]);
if((state_val_58071 === (1))){
var state_58070__$1 = state_58070;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_58070__$1,(2),q,v);
} else {
if((state_val_58071 === (2))){
var inst_58068 = (state_58070[(2)]);
var state_58070__$1 = state_58070;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_58070__$1,inst_58068);
} else {
return null;
}
}
});})(c__42036__auto__))
;
return ((function (switch__42015__auto__,c__42036__auto__){
return (function() {
var fulcro$client$impl$application$enqueue_$_state_machine__42016__auto__ = null;
var fulcro$client$impl$application$enqueue_$_state_machine__42016__auto____0 = (function (){
var statearr_58072 = [null,null,null,null,null,null,null];
(statearr_58072[(0)] = fulcro$client$impl$application$enqueue_$_state_machine__42016__auto__);

(statearr_58072[(1)] = (1));

return statearr_58072;
});
var fulcro$client$impl$application$enqueue_$_state_machine__42016__auto____1 = (function (state_58070){
while(true){
var ret_value__42017__auto__ = (function (){try{while(true){
var result__42018__auto__ = switch__42015__auto__.call(null,state_58070);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42018__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42018__auto__;
}
break;
}
}catch (e58073){if((e58073 instanceof Object)){
var ex__42019__auto__ = e58073;
var statearr_58074_58076 = state_58070;
(statearr_58074_58076[(5)] = ex__42019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_58070);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e58073;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58077 = state_58070;
state_58070 = G__58077;
continue;
} else {
return ret_value__42017__auto__;
}
break;
}
});
fulcro$client$impl$application$enqueue_$_state_machine__42016__auto__ = function(state_58070){
switch(arguments.length){
case 0:
return fulcro$client$impl$application$enqueue_$_state_machine__42016__auto____0.call(this);
case 1:
return fulcro$client$impl$application$enqueue_$_state_machine__42016__auto____1.call(this,state_58070);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
fulcro$client$impl$application$enqueue_$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$0 = fulcro$client$impl$application$enqueue_$_state_machine__42016__auto____0;
fulcro$client$impl$application$enqueue_$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$1 = fulcro$client$impl$application$enqueue_$_state_machine__42016__auto____1;
return fulcro$client$impl$application$enqueue_$_state_machine__42016__auto__;
})()
;})(switch__42015__auto__,c__42036__auto__))
})();
var state__42038__auto__ = (function (){var statearr_58075 = f__42037__auto__.call(null);
(statearr_58075[(6)] = c__42036__auto__);

return statearr_58075;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42038__auto__);
});})(c__42036__auto__))
);

return c__42036__auto__;
});
/**
 * Do a properly-plumbed network send. This function recursively strips ui attributes from the tx and pushes the tx over
 *   the network. It installs the given on-load and on-error handlers to deal with the network response.
 */
fulcro.client.impl.application.real_send = (function fulcro$client$impl$application$real_send(net,tx,on_done,on_error,on_load){
if(((!((net == null)))?(((false) || ((cljs.core.PROTOCOL_SENTINEL === net.fulcro$client$network$ProgressiveTransfer$)))?true:false):false)){
return fulcro.client.network.updating_send.call(null,net,fulcro.client.impl.om_plumbing.strip_ui.call(null,tx),on_done,on_error,on_load);
} else {
return fulcro.client.network.send.call(null,net,fulcro.client.impl.om_plumbing.strip_ui.call(null,tx),on_done,on_error);
}
});
/**
 * Split a tx that contains mutations. Returns a vector that contains at least one tx (the original).
 * 
 * Examples:
 * [(f) (g)] => [[(f) (g)]]
 * [(f) (g) (f) (k)] => [[(f) (g)] [(f) (k)]]
 * [(f) (g) (f) (k) (g)] => [[(f) (g)] [(f) (k) (g)]]
 * 
 */
fulcro.client.impl.application.split_mutations = (function fulcro$client$impl$application$split_mutations(tx){
if(!((cljs.core.vector_QMARK_.call(null,tx)) && (cljs.core.every_QMARK_.call(null,(function (t){
return (cljs.core.list_QMARK_.call(null,t)) && ((cljs.core.first.call(null,t) instanceof cljs.core.Symbol));
}),tx)))){
fulcro.client.logging.error.call(null,"INTERNAL ERROR: split-mutations was asked to split a tx that contained things other than mutations.",tx);

return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [tx], null);
} else {
if(cljs.core.empty_QMARK_.call(null,tx)){
return cljs.core.PersistentVector.EMPTY;
} else {
var mutation_name = (function (m){
return cljs.core.first.call(null,m);
});
var map__58079 = cljs.core.reduce.call(null,((function (mutation_name){
return (function (p__58080,mutation){
var map__58081 = p__58080;
var map__58081__$1 = ((((!((map__58081 == null)))?((((map__58081.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__58081.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__58081):map__58081);
var seen = cljs.core.get.call(null,map__58081__$1,new cljs.core.Keyword(null,"seen","seen",-518999789));
var accumulator = cljs.core.get.call(null,map__58081__$1,new cljs.core.Keyword(null,"accumulator","accumulator",1546185501));
var current_tx = cljs.core.get.call(null,map__58081__$1,new cljs.core.Keyword(null,"current-tx","current-tx",1600727374));
if(cljs.core.contains_QMARK_.call(null,seen,mutation_name.call(null,mutation))){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"seen","seen",-518999789),cljs.core.PersistentHashSet.EMPTY,new cljs.core.Keyword(null,"accumulator","accumulator",1546185501),cljs.core.conj.call(null,accumulator,current_tx),new cljs.core.Keyword(null,"current-tx","current-tx",1600727374),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [mutation], null)], null);
} else {
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"seen","seen",-518999789),cljs.core.conj.call(null,seen,mutation_name.call(null,mutation)),new cljs.core.Keyword(null,"accumulator","accumulator",1546185501),accumulator,new cljs.core.Keyword(null,"current-tx","current-tx",1600727374),cljs.core.conj.call(null,current_tx,mutation)], null);
}
});})(mutation_name))
,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"seen","seen",-518999789),cljs.core.PersistentHashSet.EMPTY,new cljs.core.Keyword(null,"accumulator","accumulator",1546185501),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"current-tx","current-tx",1600727374),cljs.core.PersistentVector.EMPTY], null),tx);
var map__58079__$1 = ((((!((map__58079 == null)))?((((map__58079.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__58079.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__58079):map__58079);
var accumulator = cljs.core.get.call(null,map__58079__$1,new cljs.core.Keyword(null,"accumulator","accumulator",1546185501));
var current_tx = cljs.core.get.call(null,map__58079__$1,new cljs.core.Keyword(null,"current-tx","current-tx",1600727374));
return cljs.core.conj.call(null,accumulator,current_tx);
}
}
});
/**
 * Splits out the (remote) mutations and fallbacks in a transaction, creates an error handler that can
 * trigger fallbacks, and enqueues the remote mutations on the network queue. If duplicate mutation names
 * appear, then they will be separated into separate network requests.
 * 
 * NOTE: If the mutation in the tx has duplicates, then the same fallback will be used for the
 * resulting split tx. See `split-mutations` (which is used by this function to split dupes out of txes).
 */
fulcro.client.impl.application.enqueue_mutations = (function fulcro$client$impl$application$enqueue_mutations(p__58085,remote_tx_map,cb){
var map__58086 = p__58085;
var map__58086__$1 = ((((!((map__58086 == null)))?((((map__58086.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__58086.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__58086):map__58086);
var app = map__58086__$1;
var send_queues = cljs.core.get.call(null,map__58086__$1,new cljs.core.Keyword(null,"send-queues","send-queues",-212336330));
var seq__58088 = cljs.core.seq.call(null,cljs.core.keys.call(null,remote_tx_map));
var chunk__58089 = null;
var count__58090 = (0);
var i__58091 = (0);
while(true){
if((i__58091 < count__58090)){
var remote = cljs.core._nth.call(null,chunk__58089,i__58091);
var queue_58100 = cljs.core.get.call(null,send_queues,remote);
var full_remote_transaction_58101 = cljs.core.get.call(null,remote_tx_map,remote);
var fallback_58102 = fulcro.client.impl.application.fallback_handler.call(null,app,full_remote_transaction_58101);
var desired_remote_mutations_58103 = fulcro.client.impl.om_plumbing.remove_loads_and_fallbacks.call(null,full_remote_transaction_58101);
var tx_list_58104 = fulcro.client.impl.application.split_mutations.call(null,desired_remote_mutations_58103);
var has_mutations_QMARK__58105 = ((function (seq__58088,chunk__58089,count__58090,i__58091,queue_58100,full_remote_transaction_58101,fallback_58102,desired_remote_mutations_58103,tx_list_58104,remote,map__58086,map__58086__$1,app,send_queues){
return (function (tx){
return (cljs.core.count.call(null,tx) > (0));
});})(seq__58088,chunk__58089,count__58090,i__58091,queue_58100,full_remote_transaction_58101,fallback_58102,desired_remote_mutations_58103,tx_list_58104,remote,map__58086,map__58086__$1,app,send_queues))
;
var payload_58106 = ((function (seq__58088,chunk__58089,count__58090,i__58091,queue_58100,full_remote_transaction_58101,fallback_58102,desired_remote_mutations_58103,tx_list_58104,has_mutations_QMARK__58105,remote,map__58086,map__58086__$1,app,send_queues){
return (function (tx){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"query","query",-1288509510),tx,new cljs.core.Keyword(null,"on-load","on-load",1415151594),cb,new cljs.core.Keyword(null,"on-error","on-error",1728533530),((function (seq__58088,chunk__58089,count__58090,i__58091,queue_58100,full_remote_transaction_58101,fallback_58102,desired_remote_mutations_58103,tx_list_58104,has_mutations_QMARK__58105,remote,map__58086,map__58086__$1,app,send_queues){
return (function (p1__58084_SHARP_){
return fallback_58102.call(null,p1__58084_SHARP_);
});})(seq__58088,chunk__58089,count__58090,i__58091,queue_58100,full_remote_transaction_58101,fallback_58102,desired_remote_mutations_58103,tx_list_58104,has_mutations_QMARK__58105,remote,map__58086,map__58086__$1,app,send_queues))
], null);
});})(seq__58088,chunk__58089,count__58090,i__58091,queue_58100,full_remote_transaction_58101,fallback_58102,desired_remote_mutations_58103,tx_list_58104,has_mutations_QMARK__58105,remote,map__58086,map__58086__$1,app,send_queues))
;
var seq__58092_58107 = cljs.core.seq.call(null,tx_list_58104);
var chunk__58093_58108 = null;
var count__58094_58109 = (0);
var i__58095_58110 = (0);
while(true){
if((i__58095_58110 < count__58094_58109)){
var tx_58111 = cljs.core._nth.call(null,chunk__58093_58108,i__58095_58110);
if(cljs.core.truth_(has_mutations_QMARK__58105.call(null,tx_58111))){
fulcro.client.impl.application.enqueue.call(null,queue_58100,payload_58106.call(null,tx_58111));
} else {
}

var G__58112 = seq__58092_58107;
var G__58113 = chunk__58093_58108;
var G__58114 = count__58094_58109;
var G__58115 = (i__58095_58110 + (1));
seq__58092_58107 = G__58112;
chunk__58093_58108 = G__58113;
count__58094_58109 = G__58114;
i__58095_58110 = G__58115;
continue;
} else {
var temp__4657__auto___58116 = cljs.core.seq.call(null,seq__58092_58107);
if(temp__4657__auto___58116){
var seq__58092_58117__$1 = temp__4657__auto___58116;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__58092_58117__$1)){
var c__28980__auto___58118 = cljs.core.chunk_first.call(null,seq__58092_58117__$1);
var G__58119 = cljs.core.chunk_rest.call(null,seq__58092_58117__$1);
var G__58120 = c__28980__auto___58118;
var G__58121 = cljs.core.count.call(null,c__28980__auto___58118);
var G__58122 = (0);
seq__58092_58107 = G__58119;
chunk__58093_58108 = G__58120;
count__58094_58109 = G__58121;
i__58095_58110 = G__58122;
continue;
} else {
var tx_58123 = cljs.core.first.call(null,seq__58092_58117__$1);
if(cljs.core.truth_(has_mutations_QMARK__58105.call(null,tx_58123))){
fulcro.client.impl.application.enqueue.call(null,queue_58100,payload_58106.call(null,tx_58123));
} else {
}

var G__58124 = cljs.core.next.call(null,seq__58092_58117__$1);
var G__58125 = null;
var G__58126 = (0);
var G__58127 = (0);
seq__58092_58107 = G__58124;
chunk__58093_58108 = G__58125;
count__58094_58109 = G__58126;
i__58095_58110 = G__58127;
continue;
}
} else {
}
}
break;
}

var G__58128 = seq__58088;
var G__58129 = chunk__58089;
var G__58130 = count__58090;
var G__58131 = (i__58091 + (1));
seq__58088 = G__58128;
chunk__58089 = G__58129;
count__58090 = G__58130;
i__58091 = G__58131;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__58088);
if(temp__4657__auto__){
var seq__58088__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__58088__$1)){
var c__28980__auto__ = cljs.core.chunk_first.call(null,seq__58088__$1);
var G__58132 = cljs.core.chunk_rest.call(null,seq__58088__$1);
var G__58133 = c__28980__auto__;
var G__58134 = cljs.core.count.call(null,c__28980__auto__);
var G__58135 = (0);
seq__58088 = G__58132;
chunk__58089 = G__58133;
count__58090 = G__58134;
i__58091 = G__58135;
continue;
} else {
var remote = cljs.core.first.call(null,seq__58088__$1);
var queue_58136 = cljs.core.get.call(null,send_queues,remote);
var full_remote_transaction_58137 = cljs.core.get.call(null,remote_tx_map,remote);
var fallback_58138 = fulcro.client.impl.application.fallback_handler.call(null,app,full_remote_transaction_58137);
var desired_remote_mutations_58139 = fulcro.client.impl.om_plumbing.remove_loads_and_fallbacks.call(null,full_remote_transaction_58137);
var tx_list_58140 = fulcro.client.impl.application.split_mutations.call(null,desired_remote_mutations_58139);
var has_mutations_QMARK__58141 = ((function (seq__58088,chunk__58089,count__58090,i__58091,queue_58136,full_remote_transaction_58137,fallback_58138,desired_remote_mutations_58139,tx_list_58140,remote,seq__58088__$1,temp__4657__auto__,map__58086,map__58086__$1,app,send_queues){
return (function (tx){
return (cljs.core.count.call(null,tx) > (0));
});})(seq__58088,chunk__58089,count__58090,i__58091,queue_58136,full_remote_transaction_58137,fallback_58138,desired_remote_mutations_58139,tx_list_58140,remote,seq__58088__$1,temp__4657__auto__,map__58086,map__58086__$1,app,send_queues))
;
var payload_58142 = ((function (seq__58088,chunk__58089,count__58090,i__58091,queue_58136,full_remote_transaction_58137,fallback_58138,desired_remote_mutations_58139,tx_list_58140,has_mutations_QMARK__58141,remote,seq__58088__$1,temp__4657__auto__,map__58086,map__58086__$1,app,send_queues){
return (function (tx){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"query","query",-1288509510),tx,new cljs.core.Keyword(null,"on-load","on-load",1415151594),cb,new cljs.core.Keyword(null,"on-error","on-error",1728533530),((function (seq__58088,chunk__58089,count__58090,i__58091,queue_58136,full_remote_transaction_58137,fallback_58138,desired_remote_mutations_58139,tx_list_58140,has_mutations_QMARK__58141,remote,seq__58088__$1,temp__4657__auto__,map__58086,map__58086__$1,app,send_queues){
return (function (p1__58084_SHARP_){
return fallback_58138.call(null,p1__58084_SHARP_);
});})(seq__58088,chunk__58089,count__58090,i__58091,queue_58136,full_remote_transaction_58137,fallback_58138,desired_remote_mutations_58139,tx_list_58140,has_mutations_QMARK__58141,remote,seq__58088__$1,temp__4657__auto__,map__58086,map__58086__$1,app,send_queues))
], null);
});})(seq__58088,chunk__58089,count__58090,i__58091,queue_58136,full_remote_transaction_58137,fallback_58138,desired_remote_mutations_58139,tx_list_58140,has_mutations_QMARK__58141,remote,seq__58088__$1,temp__4657__auto__,map__58086,map__58086__$1,app,send_queues))
;
var seq__58096_58143 = cljs.core.seq.call(null,tx_list_58140);
var chunk__58097_58144 = null;
var count__58098_58145 = (0);
var i__58099_58146 = (0);
while(true){
if((i__58099_58146 < count__58098_58145)){
var tx_58147 = cljs.core._nth.call(null,chunk__58097_58144,i__58099_58146);
if(cljs.core.truth_(has_mutations_QMARK__58141.call(null,tx_58147))){
fulcro.client.impl.application.enqueue.call(null,queue_58136,payload_58142.call(null,tx_58147));
} else {
}

var G__58148 = seq__58096_58143;
var G__58149 = chunk__58097_58144;
var G__58150 = count__58098_58145;
var G__58151 = (i__58099_58146 + (1));
seq__58096_58143 = G__58148;
chunk__58097_58144 = G__58149;
count__58098_58145 = G__58150;
i__58099_58146 = G__58151;
continue;
} else {
var temp__4657__auto___58152__$1 = cljs.core.seq.call(null,seq__58096_58143);
if(temp__4657__auto___58152__$1){
var seq__58096_58153__$1 = temp__4657__auto___58152__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__58096_58153__$1)){
var c__28980__auto___58154 = cljs.core.chunk_first.call(null,seq__58096_58153__$1);
var G__58155 = cljs.core.chunk_rest.call(null,seq__58096_58153__$1);
var G__58156 = c__28980__auto___58154;
var G__58157 = cljs.core.count.call(null,c__28980__auto___58154);
var G__58158 = (0);
seq__58096_58143 = G__58155;
chunk__58097_58144 = G__58156;
count__58098_58145 = G__58157;
i__58099_58146 = G__58158;
continue;
} else {
var tx_58159 = cljs.core.first.call(null,seq__58096_58153__$1);
if(cljs.core.truth_(has_mutations_QMARK__58141.call(null,tx_58159))){
fulcro.client.impl.application.enqueue.call(null,queue_58136,payload_58142.call(null,tx_58159));
} else {
}

var G__58160 = cljs.core.next.call(null,seq__58096_58153__$1);
var G__58161 = null;
var G__58162 = (0);
var G__58163 = (0);
seq__58096_58143 = G__58160;
chunk__58097_58144 = G__58161;
count__58098_58145 = G__58162;
i__58099_58146 = G__58163;
continue;
}
} else {
}
}
break;
}

var G__58164 = cljs.core.next.call(null,seq__58088__$1);
var G__58165 = null;
var G__58166 = (0);
var G__58167 = (0);
seq__58088 = G__58164;
chunk__58089 = G__58165;
count__58090 = G__58166;
i__58091 = G__58167;
continue;
}
} else {
return null;
}
}
break;
}
});
/**
 * Finds any loads marked `parallel` and triggers real network requests immediately. Remaining loads
 *   are pulled into a single fetch payload (combined into one query) and enqueued behind any prior mutations/reads that
 *   were already requested in a prior UI/event cycle. Thus non-parallel reads are processed in clusters grouped due to UI
 *   events (a single event might trigger many reads which will all go to the server as a single combined request).
 *   Further UI events that trigger remote interaction will end up waiting until prior network request(s) are complete.
 * 
 *   This ensures that default reasoning is simple and sequential in the face of optimistic UI updates (real network
 *   traffic characteristics could cause out of order processing, and you would not want
 *   a 'create list' to be processed on the server *after* an 'add an item to the list'). 
 */
fulcro.client.impl.application.enqueue_reads = (function fulcro$client$impl$application$enqueue_reads(p__58170){
var map__58171 = p__58170;
var map__58171__$1 = ((((!((map__58171 == null)))?((((map__58171.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__58171.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__58171):map__58171);
var send_queues = cljs.core.get.call(null,map__58171__$1,new cljs.core.Keyword(null,"send-queues","send-queues",-212336330));
var reconciler = cljs.core.get.call(null,map__58171__$1,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966));
var networking = cljs.core.get.call(null,map__58171__$1,new cljs.core.Keyword(null,"networking","networking",586110628));
var seq__58173 = cljs.core.seq.call(null,cljs.core.keys.call(null,send_queues));
var chunk__58174 = null;
var count__58175 = (0);
var i__58176 = (0);
while(true){
if((i__58176 < count__58175)){
var remote = cljs.core._nth.call(null,chunk__58174,i__58176);
var queue_58193 = cljs.core.get.call(null,send_queues,remote);
var network_58194 = cljs.core.get.call(null,networking,remote);
var parallel_payload_58195 = fulcro.client.impl.data_fetch.mark_parallel_loading.call(null,remote,reconciler);
var seq__58177_58196 = cljs.core.seq.call(null,parallel_payload_58195);
var chunk__58178_58197 = null;
var count__58179_58198 = (0);
var i__58180_58199 = (0);
while(true){
if((i__58180_58199 < count__58179_58198)){
var map__58181_58200 = cljs.core._nth.call(null,chunk__58178_58197,i__58180_58199);
var map__58181_58201__$1 = ((((!((map__58181_58200 == null)))?((((map__58181_58200.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__58181_58200.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__58181_58200):map__58181_58200);
var query_58202 = cljs.core.get.call(null,map__58181_58201__$1,new cljs.core.Keyword(null,"query","query",-1288509510));
var on_load_58203 = cljs.core.get.call(null,map__58181_58201__$1,new cljs.core.Keyword(null,"on-load","on-load",1415151594));
var on_error_58204 = cljs.core.get.call(null,map__58181_58201__$1,new cljs.core.Keyword(null,"on-error","on-error",1728533530));
var load_descriptors_58205 = cljs.core.get.call(null,map__58181_58201__$1,new cljs.core.Keyword(null,"load-descriptors","load-descriptors",391720681));
var on_load_SINGLEQUOTE__58206 = ((function (seq__58177_58196,chunk__58178_58197,count__58179_58198,i__58180_58199,seq__58173,chunk__58174,count__58175,i__58176,map__58181_58200,map__58181_58201__$1,query_58202,on_load_58203,on_error_58204,load_descriptors_58205,queue_58193,network_58194,parallel_payload_58195,remote,map__58171,map__58171__$1,send_queues,reconciler,networking){
return (function (p1__58168_SHARP_){
return on_load_58203.call(null,p1__58168_SHARP_,load_descriptors_58205);
});})(seq__58177_58196,chunk__58178_58197,count__58179_58198,i__58180_58199,seq__58173,chunk__58174,count__58175,i__58176,map__58181_58200,map__58181_58201__$1,query_58202,on_load_58203,on_error_58204,load_descriptors_58205,queue_58193,network_58194,parallel_payload_58195,remote,map__58171,map__58171__$1,send_queues,reconciler,networking))
;
var on_error_SINGLEQUOTE__58207 = ((function (seq__58177_58196,chunk__58178_58197,count__58179_58198,i__58180_58199,seq__58173,chunk__58174,count__58175,i__58176,on_load_SINGLEQUOTE__58206,map__58181_58200,map__58181_58201__$1,query_58202,on_load_58203,on_error_58204,load_descriptors_58205,queue_58193,network_58194,parallel_payload_58195,remote,map__58171,map__58171__$1,send_queues,reconciler,networking){
return (function (p1__58169_SHARP_){
return on_error_58204.call(null,p1__58169_SHARP_,load_descriptors_58205);
});})(seq__58177_58196,chunk__58178_58197,count__58179_58198,i__58180_58199,seq__58173,chunk__58174,count__58175,i__58176,on_load_SINGLEQUOTE__58206,map__58181_58200,map__58181_58201__$1,query_58202,on_load_58203,on_error_58204,load_descriptors_58205,queue_58193,network_58194,parallel_payload_58195,remote,map__58171,map__58171__$1,send_queues,reconciler,networking))
;
fulcro.client.impl.application.real_send.call(null,network_58194,query_58202,on_load_SINGLEQUOTE__58206,on_error_SINGLEQUOTE__58207,null);

var G__58208 = seq__58177_58196;
var G__58209 = chunk__58178_58197;
var G__58210 = count__58179_58198;
var G__58211 = (i__58180_58199 + (1));
seq__58177_58196 = G__58208;
chunk__58178_58197 = G__58209;
count__58179_58198 = G__58210;
i__58180_58199 = G__58211;
continue;
} else {
var temp__4657__auto___58212 = cljs.core.seq.call(null,seq__58177_58196);
if(temp__4657__auto___58212){
var seq__58177_58213__$1 = temp__4657__auto___58212;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__58177_58213__$1)){
var c__28980__auto___58214 = cljs.core.chunk_first.call(null,seq__58177_58213__$1);
var G__58215 = cljs.core.chunk_rest.call(null,seq__58177_58213__$1);
var G__58216 = c__28980__auto___58214;
var G__58217 = cljs.core.count.call(null,c__28980__auto___58214);
var G__58218 = (0);
seq__58177_58196 = G__58215;
chunk__58178_58197 = G__58216;
count__58179_58198 = G__58217;
i__58180_58199 = G__58218;
continue;
} else {
var map__58183_58219 = cljs.core.first.call(null,seq__58177_58213__$1);
var map__58183_58220__$1 = ((((!((map__58183_58219 == null)))?((((map__58183_58219.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__58183_58219.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__58183_58219):map__58183_58219);
var query_58221 = cljs.core.get.call(null,map__58183_58220__$1,new cljs.core.Keyword(null,"query","query",-1288509510));
var on_load_58222 = cljs.core.get.call(null,map__58183_58220__$1,new cljs.core.Keyword(null,"on-load","on-load",1415151594));
var on_error_58223 = cljs.core.get.call(null,map__58183_58220__$1,new cljs.core.Keyword(null,"on-error","on-error",1728533530));
var load_descriptors_58224 = cljs.core.get.call(null,map__58183_58220__$1,new cljs.core.Keyword(null,"load-descriptors","load-descriptors",391720681));
var on_load_SINGLEQUOTE__58225 = ((function (seq__58177_58196,chunk__58178_58197,count__58179_58198,i__58180_58199,seq__58173,chunk__58174,count__58175,i__58176,map__58183_58219,map__58183_58220__$1,query_58221,on_load_58222,on_error_58223,load_descriptors_58224,seq__58177_58213__$1,temp__4657__auto___58212,queue_58193,network_58194,parallel_payload_58195,remote,map__58171,map__58171__$1,send_queues,reconciler,networking){
return (function (p1__58168_SHARP_){
return on_load_58222.call(null,p1__58168_SHARP_,load_descriptors_58224);
});})(seq__58177_58196,chunk__58178_58197,count__58179_58198,i__58180_58199,seq__58173,chunk__58174,count__58175,i__58176,map__58183_58219,map__58183_58220__$1,query_58221,on_load_58222,on_error_58223,load_descriptors_58224,seq__58177_58213__$1,temp__4657__auto___58212,queue_58193,network_58194,parallel_payload_58195,remote,map__58171,map__58171__$1,send_queues,reconciler,networking))
;
var on_error_SINGLEQUOTE__58226 = ((function (seq__58177_58196,chunk__58178_58197,count__58179_58198,i__58180_58199,seq__58173,chunk__58174,count__58175,i__58176,on_load_SINGLEQUOTE__58225,map__58183_58219,map__58183_58220__$1,query_58221,on_load_58222,on_error_58223,load_descriptors_58224,seq__58177_58213__$1,temp__4657__auto___58212,queue_58193,network_58194,parallel_payload_58195,remote,map__58171,map__58171__$1,send_queues,reconciler,networking){
return (function (p1__58169_SHARP_){
return on_error_58223.call(null,p1__58169_SHARP_,load_descriptors_58224);
});})(seq__58177_58196,chunk__58178_58197,count__58179_58198,i__58180_58199,seq__58173,chunk__58174,count__58175,i__58176,on_load_SINGLEQUOTE__58225,map__58183_58219,map__58183_58220__$1,query_58221,on_load_58222,on_error_58223,load_descriptors_58224,seq__58177_58213__$1,temp__4657__auto___58212,queue_58193,network_58194,parallel_payload_58195,remote,map__58171,map__58171__$1,send_queues,reconciler,networking))
;
fulcro.client.impl.application.real_send.call(null,network_58194,query_58221,on_load_SINGLEQUOTE__58225,on_error_SINGLEQUOTE__58226,null);

var G__58227 = cljs.core.next.call(null,seq__58177_58213__$1);
var G__58228 = null;
var G__58229 = (0);
var G__58230 = (0);
seq__58177_58196 = G__58227;
chunk__58178_58197 = G__58228;
count__58179_58198 = G__58229;
i__58180_58199 = G__58230;
continue;
}
} else {
}
}
break;
}

var fetch_payload_58231 = fulcro.client.impl.data_fetch.mark_loading.call(null,remote,reconciler);
while(true){
if(cljs.core.truth_(fetch_payload_58231)){
fulcro.client.impl.application.enqueue.call(null,queue_58193,cljs.core.assoc.call(null,fetch_payload_58231,new cljs.core.Keyword(null,"networking","networking",586110628),network_58194));

var G__58232 = fulcro.client.impl.data_fetch.mark_loading.call(null,remote,reconciler);
fetch_payload_58231 = G__58232;
continue;
} else {
}
break;
}

var G__58233 = seq__58173;
var G__58234 = chunk__58174;
var G__58235 = count__58175;
var G__58236 = (i__58176 + (1));
seq__58173 = G__58233;
chunk__58174 = G__58234;
count__58175 = G__58235;
i__58176 = G__58236;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__58173);
if(temp__4657__auto__){
var seq__58173__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__58173__$1)){
var c__28980__auto__ = cljs.core.chunk_first.call(null,seq__58173__$1);
var G__58237 = cljs.core.chunk_rest.call(null,seq__58173__$1);
var G__58238 = c__28980__auto__;
var G__58239 = cljs.core.count.call(null,c__28980__auto__);
var G__58240 = (0);
seq__58173 = G__58237;
chunk__58174 = G__58238;
count__58175 = G__58239;
i__58176 = G__58240;
continue;
} else {
var remote = cljs.core.first.call(null,seq__58173__$1);
var queue_58241 = cljs.core.get.call(null,send_queues,remote);
var network_58242 = cljs.core.get.call(null,networking,remote);
var parallel_payload_58243 = fulcro.client.impl.data_fetch.mark_parallel_loading.call(null,remote,reconciler);
var seq__58185_58244 = cljs.core.seq.call(null,parallel_payload_58243);
var chunk__58186_58245 = null;
var count__58187_58246 = (0);
var i__58188_58247 = (0);
while(true){
if((i__58188_58247 < count__58187_58246)){
var map__58189_58248 = cljs.core._nth.call(null,chunk__58186_58245,i__58188_58247);
var map__58189_58249__$1 = ((((!((map__58189_58248 == null)))?((((map__58189_58248.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__58189_58248.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__58189_58248):map__58189_58248);
var query_58250 = cljs.core.get.call(null,map__58189_58249__$1,new cljs.core.Keyword(null,"query","query",-1288509510));
var on_load_58251 = cljs.core.get.call(null,map__58189_58249__$1,new cljs.core.Keyword(null,"on-load","on-load",1415151594));
var on_error_58252 = cljs.core.get.call(null,map__58189_58249__$1,new cljs.core.Keyword(null,"on-error","on-error",1728533530));
var load_descriptors_58253 = cljs.core.get.call(null,map__58189_58249__$1,new cljs.core.Keyword(null,"load-descriptors","load-descriptors",391720681));
var on_load_SINGLEQUOTE__58254 = ((function (seq__58185_58244,chunk__58186_58245,count__58187_58246,i__58188_58247,seq__58173,chunk__58174,count__58175,i__58176,map__58189_58248,map__58189_58249__$1,query_58250,on_load_58251,on_error_58252,load_descriptors_58253,queue_58241,network_58242,parallel_payload_58243,remote,seq__58173__$1,temp__4657__auto__,map__58171,map__58171__$1,send_queues,reconciler,networking){
return (function (p1__58168_SHARP_){
return on_load_58251.call(null,p1__58168_SHARP_,load_descriptors_58253);
});})(seq__58185_58244,chunk__58186_58245,count__58187_58246,i__58188_58247,seq__58173,chunk__58174,count__58175,i__58176,map__58189_58248,map__58189_58249__$1,query_58250,on_load_58251,on_error_58252,load_descriptors_58253,queue_58241,network_58242,parallel_payload_58243,remote,seq__58173__$1,temp__4657__auto__,map__58171,map__58171__$1,send_queues,reconciler,networking))
;
var on_error_SINGLEQUOTE__58255 = ((function (seq__58185_58244,chunk__58186_58245,count__58187_58246,i__58188_58247,seq__58173,chunk__58174,count__58175,i__58176,on_load_SINGLEQUOTE__58254,map__58189_58248,map__58189_58249__$1,query_58250,on_load_58251,on_error_58252,load_descriptors_58253,queue_58241,network_58242,parallel_payload_58243,remote,seq__58173__$1,temp__4657__auto__,map__58171,map__58171__$1,send_queues,reconciler,networking){
return (function (p1__58169_SHARP_){
return on_error_58252.call(null,p1__58169_SHARP_,load_descriptors_58253);
});})(seq__58185_58244,chunk__58186_58245,count__58187_58246,i__58188_58247,seq__58173,chunk__58174,count__58175,i__58176,on_load_SINGLEQUOTE__58254,map__58189_58248,map__58189_58249__$1,query_58250,on_load_58251,on_error_58252,load_descriptors_58253,queue_58241,network_58242,parallel_payload_58243,remote,seq__58173__$1,temp__4657__auto__,map__58171,map__58171__$1,send_queues,reconciler,networking))
;
fulcro.client.impl.application.real_send.call(null,network_58242,query_58250,on_load_SINGLEQUOTE__58254,on_error_SINGLEQUOTE__58255,null);

var G__58256 = seq__58185_58244;
var G__58257 = chunk__58186_58245;
var G__58258 = count__58187_58246;
var G__58259 = (i__58188_58247 + (1));
seq__58185_58244 = G__58256;
chunk__58186_58245 = G__58257;
count__58187_58246 = G__58258;
i__58188_58247 = G__58259;
continue;
} else {
var temp__4657__auto___58260__$1 = cljs.core.seq.call(null,seq__58185_58244);
if(temp__4657__auto___58260__$1){
var seq__58185_58261__$1 = temp__4657__auto___58260__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__58185_58261__$1)){
var c__28980__auto___58262 = cljs.core.chunk_first.call(null,seq__58185_58261__$1);
var G__58263 = cljs.core.chunk_rest.call(null,seq__58185_58261__$1);
var G__58264 = c__28980__auto___58262;
var G__58265 = cljs.core.count.call(null,c__28980__auto___58262);
var G__58266 = (0);
seq__58185_58244 = G__58263;
chunk__58186_58245 = G__58264;
count__58187_58246 = G__58265;
i__58188_58247 = G__58266;
continue;
} else {
var map__58191_58267 = cljs.core.first.call(null,seq__58185_58261__$1);
var map__58191_58268__$1 = ((((!((map__58191_58267 == null)))?((((map__58191_58267.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__58191_58267.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__58191_58267):map__58191_58267);
var query_58269 = cljs.core.get.call(null,map__58191_58268__$1,new cljs.core.Keyword(null,"query","query",-1288509510));
var on_load_58270 = cljs.core.get.call(null,map__58191_58268__$1,new cljs.core.Keyword(null,"on-load","on-load",1415151594));
var on_error_58271 = cljs.core.get.call(null,map__58191_58268__$1,new cljs.core.Keyword(null,"on-error","on-error",1728533530));
var load_descriptors_58272 = cljs.core.get.call(null,map__58191_58268__$1,new cljs.core.Keyword(null,"load-descriptors","load-descriptors",391720681));
var on_load_SINGLEQUOTE__58273 = ((function (seq__58185_58244,chunk__58186_58245,count__58187_58246,i__58188_58247,seq__58173,chunk__58174,count__58175,i__58176,map__58191_58267,map__58191_58268__$1,query_58269,on_load_58270,on_error_58271,load_descriptors_58272,seq__58185_58261__$1,temp__4657__auto___58260__$1,queue_58241,network_58242,parallel_payload_58243,remote,seq__58173__$1,temp__4657__auto__,map__58171,map__58171__$1,send_queues,reconciler,networking){
return (function (p1__58168_SHARP_){
return on_load_58270.call(null,p1__58168_SHARP_,load_descriptors_58272);
});})(seq__58185_58244,chunk__58186_58245,count__58187_58246,i__58188_58247,seq__58173,chunk__58174,count__58175,i__58176,map__58191_58267,map__58191_58268__$1,query_58269,on_load_58270,on_error_58271,load_descriptors_58272,seq__58185_58261__$1,temp__4657__auto___58260__$1,queue_58241,network_58242,parallel_payload_58243,remote,seq__58173__$1,temp__4657__auto__,map__58171,map__58171__$1,send_queues,reconciler,networking))
;
var on_error_SINGLEQUOTE__58274 = ((function (seq__58185_58244,chunk__58186_58245,count__58187_58246,i__58188_58247,seq__58173,chunk__58174,count__58175,i__58176,on_load_SINGLEQUOTE__58273,map__58191_58267,map__58191_58268__$1,query_58269,on_load_58270,on_error_58271,load_descriptors_58272,seq__58185_58261__$1,temp__4657__auto___58260__$1,queue_58241,network_58242,parallel_payload_58243,remote,seq__58173__$1,temp__4657__auto__,map__58171,map__58171__$1,send_queues,reconciler,networking){
return (function (p1__58169_SHARP_){
return on_error_58271.call(null,p1__58169_SHARP_,load_descriptors_58272);
});})(seq__58185_58244,chunk__58186_58245,count__58187_58246,i__58188_58247,seq__58173,chunk__58174,count__58175,i__58176,on_load_SINGLEQUOTE__58273,map__58191_58267,map__58191_58268__$1,query_58269,on_load_58270,on_error_58271,load_descriptors_58272,seq__58185_58261__$1,temp__4657__auto___58260__$1,queue_58241,network_58242,parallel_payload_58243,remote,seq__58173__$1,temp__4657__auto__,map__58171,map__58171__$1,send_queues,reconciler,networking))
;
fulcro.client.impl.application.real_send.call(null,network_58242,query_58269,on_load_SINGLEQUOTE__58273,on_error_SINGLEQUOTE__58274,null);

var G__58275 = cljs.core.next.call(null,seq__58185_58261__$1);
var G__58276 = null;
var G__58277 = (0);
var G__58278 = (0);
seq__58185_58244 = G__58275;
chunk__58186_58245 = G__58276;
count__58187_58246 = G__58277;
i__58188_58247 = G__58278;
continue;
}
} else {
}
}
break;
}

var fetch_payload_58279 = fulcro.client.impl.data_fetch.mark_loading.call(null,remote,reconciler);
while(true){
if(cljs.core.truth_(fetch_payload_58279)){
fulcro.client.impl.application.enqueue.call(null,queue_58241,cljs.core.assoc.call(null,fetch_payload_58279,new cljs.core.Keyword(null,"networking","networking",586110628),network_58242));

var G__58280 = fulcro.client.impl.data_fetch.mark_loading.call(null,remote,reconciler);
fetch_payload_58279 = G__58280;
continue;
} else {
}
break;
}

var G__58281 = cljs.core.next.call(null,seq__58173__$1);
var G__58282 = null;
var G__58283 = (0);
var G__58284 = (0);
seq__58173 = G__58281;
chunk__58174 = G__58282;
count__58175 = G__58283;
i__58176 = G__58284;
continue;
}
} else {
return null;
}
}
break;
}
});
fulcro.client.impl.application.detect_errant_remotes = (function fulcro$client$impl$application$detect_errant_remotes(p__58285){
var map__58286 = p__58285;
var map__58286__$1 = ((((!((map__58286 == null)))?((((map__58286.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__58286.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__58286):map__58286);
var app = map__58286__$1;
var reconciler = cljs.core.get.call(null,map__58286__$1,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966));
var send_queues = cljs.core.get.call(null,map__58286__$1,new cljs.core.Keyword(null,"send-queues","send-queues",-212336330));
var state = om.next.app_state.call(null,reconciler);
var all_items = cljs.core.get.call(null,cljs.core.deref.call(null,state),new cljs.core.Keyword("fulcro","ready-to-load","fulcro/ready-to-load",127104696));
var item_remotes = cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.map.call(null,fulcro.client.impl.data_fetch.data_remote,all_items));
var all_remotes = cljs.core.set.call(null,cljs.core.keys.call(null,send_queues));
var invalid_remotes = clojure.set.difference.call(null,item_remotes,all_remotes);
if(cljs.core.truth_(cljs.core.not_empty.call(null,invalid_remotes))){
return fulcro.client.logging.error.call(null,["Use of invalid remote(s) detected! ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(invalid_remotes)].join(''));
} else {
return null;
}
});
/**
 * Puts queries/mutations (and their corresponding callbacks) onto the send queue. The networking code will pull these
 *   off one at a time and send them through the real networking layer. Reads are guaranteed to *follow* writes.
 */
fulcro.client.impl.application.server_send = (function fulcro$client$impl$application$server_send(app,remote_tx_map,cb){
fulcro.client.impl.application.detect_errant_remotes.call(null,app);

fulcro.client.impl.application.enqueue_mutations.call(null,app,remote_tx_map,cb);

return fulcro.client.impl.application.enqueue_reads.call(null,app);
});
/**
 * Sends a network payload. There are two kinds of payloads in Fulcro. The first is
 *   for reads, which are tracked by load descriptors in the app state. These load descriptors
 *   tell the plumbing how to handle the response, and expect to only be merged in once. Mutations
 *   do not have a payload, and can technically received progress updates from the network. The built-in
 *   networking does not (currently) give progress events, but plugin networking can. It is currently not
 *   supported to give an update on a load, so this function is careful to detect that a payload is a send
 *   and turns all but the last update into a no-op. The send-complete function comes from the
 *   network sequential processing loop, and when called unblocks the network processing to allow the
 *   next request to go. Be very careful with this code, as bugs will cause applications to stop responding
 *   to remote requests.
 */
fulcro.client.impl.application.send_payload = (function fulcro$client$impl$application$send_payload(network,payload,send_complete){
var map__58290 = payload;
var map__58290__$1 = ((((!((map__58290 == null)))?((((map__58290.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__58290.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__58290):map__58290);
var query = cljs.core.get.call(null,map__58290__$1,new cljs.core.Keyword(null,"query","query",-1288509510));
var on_load = cljs.core.get.call(null,map__58290__$1,new cljs.core.Keyword(null,"on-load","on-load",1415151594));
var on_error = cljs.core.get.call(null,map__58290__$1,new cljs.core.Keyword(null,"on-error","on-error",1728533530));
var load_descriptors = cljs.core.get.call(null,map__58290__$1,new cljs.core.Keyword(null,"load-descriptors","load-descriptors",391720681));
var merge_data = (cljs.core.truth_(load_descriptors)?((function (map__58290,map__58290__$1,query,on_load,on_error,load_descriptors){
return (function (p1__58288_SHARP_){
return on_load.call(null,p1__58288_SHARP_,load_descriptors);
});})(map__58290,map__58290__$1,query,on_load,on_error,load_descriptors))
:on_load);
var on_update = (cljs.core.truth_(load_descriptors)?cljs.core.identity:merge_data);
var on_error__$1 = (cljs.core.truth_(load_descriptors)?((function (map__58290,map__58290__$1,query,on_load,on_error,load_descriptors,merge_data,on_update){
return (function (p1__58289_SHARP_){
return on_error.call(null,p1__58289_SHARP_,load_descriptors);
});})(map__58290,map__58290__$1,query,on_load,on_error,load_descriptors,merge_data,on_update))
:on_error);
var on_error__$2 = cljs.core.comp.call(null,send_complete,on_error__$1);
var on_done = cljs.core.comp.call(null,send_complete,merge_data);
return fulcro.client.impl.application.real_send.call(null,network,query,on_done,on_error__$2,on_update);
});
fulcro.client.impl.application.is_sequential_QMARK_ = (function fulcro$client$impl$application$is_sequential_QMARK_(network){
if(((!((network == null)))?(((false) || ((cljs.core.PROTOCOL_SENTINEL === network.fulcro$client$network$NetworkBehavior$)))?true:false):false)){
return fulcro.client.network.serialize_requests_QMARK_.call(null,network);
} else {
return true;
}
});
/**
 * Starts a async go loop that sends network requests on a networking object's request queue. Must be called once and only
 *   once for each active networking object on the UI. Each iteration of the loop pulls off a
 *   single request, sends it, waits for the response, and then repeats. Gives the appearance of a separate networking
 *   'thread' using core async.
 */
fulcro.client.impl.application.start_network_sequential_processing = (function fulcro$client$impl$application$start_network_sequential_processing(p__58293){
var map__58294 = p__58293;
var map__58294__$1 = ((((!((map__58294 == null)))?((((map__58294.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__58294.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__58294):map__58294);
var networking = cljs.core.get.call(null,map__58294__$1,new cljs.core.Keyword(null,"networking","networking",586110628));
var send_queues = cljs.core.get.call(null,map__58294__$1,new cljs.core.Keyword(null,"send-queues","send-queues",-212336330));
var response_channels = cljs.core.get.call(null,map__58294__$1,new cljs.core.Keyword(null,"response-channels","response-channels",-1871059128));
var seq__58296 = cljs.core.seq.call(null,cljs.core.keys.call(null,send_queues));
var chunk__58297 = null;
var count__58298 = (0);
var i__58299 = (0);
while(true){
if((i__58299 < count__58298)){
var remote = cljs.core._nth.call(null,chunk__58297,i__58299);
var queue_58384 = cljs.core.get.call(null,send_queues,remote);
var network_58385 = cljs.core.get.call(null,networking,remote);
var sequential_QMARK__58386 = fulcro.client.impl.application.is_sequential_QMARK_.call(null,network_58385);
var response_channel_58387 = cljs.core.get.call(null,response_channels,remote);
var send_complete_58388 = (cljs.core.truth_(sequential_QMARK__58386)?((function (seq__58296,chunk__58297,count__58298,i__58299,queue_58384,network_58385,sequential_QMARK__58386,response_channel_58387,remote,map__58294,map__58294__$1,networking,send_queues,response_channels){
return (function (){
var c__42036__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (seq__58296,chunk__58297,count__58298,i__58299,c__42036__auto__,queue_58384,network_58385,sequential_QMARK__58386,response_channel_58387,remote,map__58294,map__58294__$1,networking,send_queues,response_channels){
return (function (){
var f__42037__auto__ = (function (){var switch__42015__auto__ = ((function (seq__58296,chunk__58297,count__58298,i__58299,c__42036__auto__,queue_58384,network_58385,sequential_QMARK__58386,response_channel_58387,remote,map__58294,map__58294__$1,networking,send_queues,response_channels){
return (function (state_58303){
var state_val_58304 = (state_58303[(1)]);
if((state_val_58304 === (1))){
var state_58303__$1 = state_58303;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_58303__$1,(2),response_channel_58387,new cljs.core.Keyword(null,"complete","complete",-500388775));
} else {
if((state_val_58304 === (2))){
var inst_58301 = (state_58303[(2)]);
var state_58303__$1 = state_58303;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_58303__$1,inst_58301);
} else {
return null;
}
}
});})(seq__58296,chunk__58297,count__58298,i__58299,c__42036__auto__,queue_58384,network_58385,sequential_QMARK__58386,response_channel_58387,remote,map__58294,map__58294__$1,networking,send_queues,response_channels))
;
return ((function (seq__58296,chunk__58297,count__58298,i__58299,switch__42015__auto__,c__42036__auto__,queue_58384,network_58385,sequential_QMARK__58386,response_channel_58387,remote,map__58294,map__58294__$1,networking,send_queues,response_channels){
return (function() {
var fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto__ = null;
var fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto____0 = (function (){
var statearr_58305 = [null,null,null,null,null,null,null];
(statearr_58305[(0)] = fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto__);

(statearr_58305[(1)] = (1));

return statearr_58305;
});
var fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto____1 = (function (state_58303){
while(true){
var ret_value__42017__auto__ = (function (){try{while(true){
var result__42018__auto__ = switch__42015__auto__.call(null,state_58303);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42018__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42018__auto__;
}
break;
}
}catch (e58306){if((e58306 instanceof Object)){
var ex__42019__auto__ = e58306;
var statearr_58307_58389 = state_58303;
(statearr_58307_58389[(5)] = ex__42019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_58303);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e58306;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58390 = state_58303;
state_58303 = G__58390;
continue;
} else {
return ret_value__42017__auto__;
}
break;
}
});
fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto__ = function(state_58303){
switch(arguments.length){
case 0:
return fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto____0.call(this);
case 1:
return fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto____1.call(this,state_58303);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$0 = fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto____0;
fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$1 = fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto____1;
return fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto__;
})()
;})(seq__58296,chunk__58297,count__58298,i__58299,switch__42015__auto__,c__42036__auto__,queue_58384,network_58385,sequential_QMARK__58386,response_channel_58387,remote,map__58294,map__58294__$1,networking,send_queues,response_channels))
})();
var state__42038__auto__ = (function (){var statearr_58308 = f__42037__auto__.call(null);
(statearr_58308[(6)] = c__42036__auto__);

return statearr_58308;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42038__auto__);
});})(seq__58296,chunk__58297,count__58298,i__58299,c__42036__auto__,queue_58384,network_58385,sequential_QMARK__58386,response_channel_58387,remote,map__58294,map__58294__$1,networking,send_queues,response_channels))
);

return c__42036__auto__;
});})(seq__58296,chunk__58297,count__58298,i__58299,queue_58384,network_58385,sequential_QMARK__58386,response_channel_58387,remote,map__58294,map__58294__$1,networking,send_queues,response_channels))
:cljs.core.identity);
var c__42036__auto___58391 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (seq__58296,chunk__58297,count__58298,i__58299,c__42036__auto___58391,queue_58384,network_58385,sequential_QMARK__58386,response_channel_58387,send_complete_58388,remote,map__58294,map__58294__$1,networking,send_queues,response_channels){
return (function (){
var f__42037__auto__ = (function (){var switch__42015__auto__ = ((function (seq__58296,chunk__58297,count__58298,i__58299,c__42036__auto___58391,queue_58384,network_58385,sequential_QMARK__58386,response_channel_58387,send_complete_58388,remote,map__58294,map__58294__$1,networking,send_queues,response_channels){
return (function (state_58326){
var state_val_58327 = (state_58326[(1)]);
if((state_val_58327 === (1))){
var state_58326__$1 = state_58326;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58326__$1,(2),queue_58384);
} else {
if((state_val_58327 === (2))){
var inst_58310 = (state_58326[(2)]);
var inst_58311 = inst_58310;
var state_58326__$1 = (function (){var statearr_58328 = state_58326;
(statearr_58328[(7)] = inst_58311);

return statearr_58328;
})();
var statearr_58329_58392 = state_58326__$1;
(statearr_58329_58392[(2)] = null);

(statearr_58329_58392[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58327 === (3))){
var inst_58311 = (state_58326[(7)]);
var inst_58313 = fulcro.client.impl.application.send_payload.call(null,network_58385,inst_58311,send_complete_58388);
var state_58326__$1 = (function (){var statearr_58330 = state_58326;
(statearr_58330[(8)] = inst_58313);

return statearr_58330;
})();
if(cljs.core.truth_(sequential_QMARK__58386)){
var statearr_58331_58393 = state_58326__$1;
(statearr_58331_58393[(1)] = (5));

} else {
var statearr_58332_58394 = state_58326__$1;
(statearr_58332_58394[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58327 === (4))){
var inst_58324 = (state_58326[(2)]);
var state_58326__$1 = state_58326;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_58326__$1,inst_58324);
} else {
if((state_val_58327 === (5))){
var state_58326__$1 = state_58326;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58326__$1,(8),response_channel_58387);
} else {
if((state_val_58327 === (6))){
var state_58326__$1 = state_58326;
var statearr_58333_58395 = state_58326__$1;
(statearr_58333_58395[(2)] = null);

(statearr_58333_58395[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58327 === (7))){
var inst_58319 = (state_58326[(2)]);
var state_58326__$1 = (function (){var statearr_58334 = state_58326;
(statearr_58334[(9)] = inst_58319);

return statearr_58334;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58326__$1,(9),queue_58384);
} else {
if((state_val_58327 === (8))){
var inst_58316 = (state_58326[(2)]);
var state_58326__$1 = state_58326;
var statearr_58335_58396 = state_58326__$1;
(statearr_58335_58396[(2)] = inst_58316);

(statearr_58335_58396[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58327 === (9))){
var inst_58321 = (state_58326[(2)]);
var inst_58311 = inst_58321;
var state_58326__$1 = (function (){var statearr_58336 = state_58326;
(statearr_58336[(7)] = inst_58311);

return statearr_58336;
})();
var statearr_58337_58397 = state_58326__$1;
(statearr_58337_58397[(2)] = null);

(statearr_58337_58397[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(seq__58296,chunk__58297,count__58298,i__58299,c__42036__auto___58391,queue_58384,network_58385,sequential_QMARK__58386,response_channel_58387,send_complete_58388,remote,map__58294,map__58294__$1,networking,send_queues,response_channels))
;
return ((function (seq__58296,chunk__58297,count__58298,i__58299,switch__42015__auto__,c__42036__auto___58391,queue_58384,network_58385,sequential_QMARK__58386,response_channel_58387,send_complete_58388,remote,map__58294,map__58294__$1,networking,send_queues,response_channels){
return (function() {
var fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto__ = null;
var fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto____0 = (function (){
var statearr_58338 = [null,null,null,null,null,null,null,null,null,null];
(statearr_58338[(0)] = fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto__);

(statearr_58338[(1)] = (1));

return statearr_58338;
});
var fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto____1 = (function (state_58326){
while(true){
var ret_value__42017__auto__ = (function (){try{while(true){
var result__42018__auto__ = switch__42015__auto__.call(null,state_58326);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42018__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42018__auto__;
}
break;
}
}catch (e58339){if((e58339 instanceof Object)){
var ex__42019__auto__ = e58339;
var statearr_58340_58398 = state_58326;
(statearr_58340_58398[(5)] = ex__42019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_58326);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e58339;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58399 = state_58326;
state_58326 = G__58399;
continue;
} else {
return ret_value__42017__auto__;
}
break;
}
});
fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto__ = function(state_58326){
switch(arguments.length){
case 0:
return fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto____0.call(this);
case 1:
return fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto____1.call(this,state_58326);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$0 = fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto____0;
fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$1 = fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto____1;
return fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto__;
})()
;})(seq__58296,chunk__58297,count__58298,i__58299,switch__42015__auto__,c__42036__auto___58391,queue_58384,network_58385,sequential_QMARK__58386,response_channel_58387,send_complete_58388,remote,map__58294,map__58294__$1,networking,send_queues,response_channels))
})();
var state__42038__auto__ = (function (){var statearr_58341 = f__42037__auto__.call(null);
(statearr_58341[(6)] = c__42036__auto___58391);

return statearr_58341;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42038__auto__);
});})(seq__58296,chunk__58297,count__58298,i__58299,c__42036__auto___58391,queue_58384,network_58385,sequential_QMARK__58386,response_channel_58387,send_complete_58388,remote,map__58294,map__58294__$1,networking,send_queues,response_channels))
);


var G__58400 = seq__58296;
var G__58401 = chunk__58297;
var G__58402 = count__58298;
var G__58403 = (i__58299 + (1));
seq__58296 = G__58400;
chunk__58297 = G__58401;
count__58298 = G__58402;
i__58299 = G__58403;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__58296);
if(temp__4657__auto__){
var seq__58296__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__58296__$1)){
var c__28980__auto__ = cljs.core.chunk_first.call(null,seq__58296__$1);
var G__58404 = cljs.core.chunk_rest.call(null,seq__58296__$1);
var G__58405 = c__28980__auto__;
var G__58406 = cljs.core.count.call(null,c__28980__auto__);
var G__58407 = (0);
seq__58296 = G__58404;
chunk__58297 = G__58405;
count__58298 = G__58406;
i__58299 = G__58407;
continue;
} else {
var remote = cljs.core.first.call(null,seq__58296__$1);
var queue_58408 = cljs.core.get.call(null,send_queues,remote);
var network_58409 = cljs.core.get.call(null,networking,remote);
var sequential_QMARK__58410 = fulcro.client.impl.application.is_sequential_QMARK_.call(null,network_58409);
var response_channel_58411 = cljs.core.get.call(null,response_channels,remote);
var send_complete_58412 = (cljs.core.truth_(sequential_QMARK__58410)?((function (seq__58296,chunk__58297,count__58298,i__58299,queue_58408,network_58409,sequential_QMARK__58410,response_channel_58411,remote,seq__58296__$1,temp__4657__auto__,map__58294,map__58294__$1,networking,send_queues,response_channels){
return (function (){
var c__42036__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (seq__58296,chunk__58297,count__58298,i__58299,c__42036__auto__,queue_58408,network_58409,sequential_QMARK__58410,response_channel_58411,remote,seq__58296__$1,temp__4657__auto__,map__58294,map__58294__$1,networking,send_queues,response_channels){
return (function (){
var f__42037__auto__ = (function (){var switch__42015__auto__ = ((function (seq__58296,chunk__58297,count__58298,i__58299,c__42036__auto__,queue_58408,network_58409,sequential_QMARK__58410,response_channel_58411,remote,seq__58296__$1,temp__4657__auto__,map__58294,map__58294__$1,networking,send_queues,response_channels){
return (function (state_58345){
var state_val_58346 = (state_58345[(1)]);
if((state_val_58346 === (1))){
var state_58345__$1 = state_58345;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_58345__$1,(2),response_channel_58411,new cljs.core.Keyword(null,"complete","complete",-500388775));
} else {
if((state_val_58346 === (2))){
var inst_58343 = (state_58345[(2)]);
var state_58345__$1 = state_58345;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_58345__$1,inst_58343);
} else {
return null;
}
}
});})(seq__58296,chunk__58297,count__58298,i__58299,c__42036__auto__,queue_58408,network_58409,sequential_QMARK__58410,response_channel_58411,remote,seq__58296__$1,temp__4657__auto__,map__58294,map__58294__$1,networking,send_queues,response_channels))
;
return ((function (seq__58296,chunk__58297,count__58298,i__58299,switch__42015__auto__,c__42036__auto__,queue_58408,network_58409,sequential_QMARK__58410,response_channel_58411,remote,seq__58296__$1,temp__4657__auto__,map__58294,map__58294__$1,networking,send_queues,response_channels){
return (function() {
var fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto__ = null;
var fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto____0 = (function (){
var statearr_58347 = [null,null,null,null,null,null,null];
(statearr_58347[(0)] = fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto__);

(statearr_58347[(1)] = (1));

return statearr_58347;
});
var fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto____1 = (function (state_58345){
while(true){
var ret_value__42017__auto__ = (function (){try{while(true){
var result__42018__auto__ = switch__42015__auto__.call(null,state_58345);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42018__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42018__auto__;
}
break;
}
}catch (e58348){if((e58348 instanceof Object)){
var ex__42019__auto__ = e58348;
var statearr_58349_58413 = state_58345;
(statearr_58349_58413[(5)] = ex__42019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_58345);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e58348;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58414 = state_58345;
state_58345 = G__58414;
continue;
} else {
return ret_value__42017__auto__;
}
break;
}
});
fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto__ = function(state_58345){
switch(arguments.length){
case 0:
return fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto____0.call(this);
case 1:
return fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto____1.call(this,state_58345);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$0 = fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto____0;
fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$1 = fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto____1;
return fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto__;
})()
;})(seq__58296,chunk__58297,count__58298,i__58299,switch__42015__auto__,c__42036__auto__,queue_58408,network_58409,sequential_QMARK__58410,response_channel_58411,remote,seq__58296__$1,temp__4657__auto__,map__58294,map__58294__$1,networking,send_queues,response_channels))
})();
var state__42038__auto__ = (function (){var statearr_58350 = f__42037__auto__.call(null);
(statearr_58350[(6)] = c__42036__auto__);

return statearr_58350;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42038__auto__);
});})(seq__58296,chunk__58297,count__58298,i__58299,c__42036__auto__,queue_58408,network_58409,sequential_QMARK__58410,response_channel_58411,remote,seq__58296__$1,temp__4657__auto__,map__58294,map__58294__$1,networking,send_queues,response_channels))
);

return c__42036__auto__;
});})(seq__58296,chunk__58297,count__58298,i__58299,queue_58408,network_58409,sequential_QMARK__58410,response_channel_58411,remote,seq__58296__$1,temp__4657__auto__,map__58294,map__58294__$1,networking,send_queues,response_channels))
:cljs.core.identity);
var c__42036__auto___58415 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (seq__58296,chunk__58297,count__58298,i__58299,c__42036__auto___58415,queue_58408,network_58409,sequential_QMARK__58410,response_channel_58411,send_complete_58412,remote,seq__58296__$1,temp__4657__auto__,map__58294,map__58294__$1,networking,send_queues,response_channels){
return (function (){
var f__42037__auto__ = (function (){var switch__42015__auto__ = ((function (seq__58296,chunk__58297,count__58298,i__58299,c__42036__auto___58415,queue_58408,network_58409,sequential_QMARK__58410,response_channel_58411,send_complete_58412,remote,seq__58296__$1,temp__4657__auto__,map__58294,map__58294__$1,networking,send_queues,response_channels){
return (function (state_58368){
var state_val_58369 = (state_58368[(1)]);
if((state_val_58369 === (1))){
var state_58368__$1 = state_58368;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58368__$1,(2),queue_58408);
} else {
if((state_val_58369 === (2))){
var inst_58352 = (state_58368[(2)]);
var inst_58353 = inst_58352;
var state_58368__$1 = (function (){var statearr_58370 = state_58368;
(statearr_58370[(7)] = inst_58353);

return statearr_58370;
})();
var statearr_58371_58416 = state_58368__$1;
(statearr_58371_58416[(2)] = null);

(statearr_58371_58416[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58369 === (3))){
var inst_58353 = (state_58368[(7)]);
var inst_58355 = fulcro.client.impl.application.send_payload.call(null,network_58409,inst_58353,send_complete_58412);
var state_58368__$1 = (function (){var statearr_58372 = state_58368;
(statearr_58372[(8)] = inst_58355);

return statearr_58372;
})();
if(cljs.core.truth_(sequential_QMARK__58410)){
var statearr_58373_58417 = state_58368__$1;
(statearr_58373_58417[(1)] = (5));

} else {
var statearr_58374_58418 = state_58368__$1;
(statearr_58374_58418[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58369 === (4))){
var inst_58366 = (state_58368[(2)]);
var state_58368__$1 = state_58368;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_58368__$1,inst_58366);
} else {
if((state_val_58369 === (5))){
var state_58368__$1 = state_58368;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58368__$1,(8),response_channel_58411);
} else {
if((state_val_58369 === (6))){
var state_58368__$1 = state_58368;
var statearr_58375_58419 = state_58368__$1;
(statearr_58375_58419[(2)] = null);

(statearr_58375_58419[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58369 === (7))){
var inst_58361 = (state_58368[(2)]);
var state_58368__$1 = (function (){var statearr_58376 = state_58368;
(statearr_58376[(9)] = inst_58361);

return statearr_58376;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58368__$1,(9),queue_58408);
} else {
if((state_val_58369 === (8))){
var inst_58358 = (state_58368[(2)]);
var state_58368__$1 = state_58368;
var statearr_58377_58420 = state_58368__$1;
(statearr_58377_58420[(2)] = inst_58358);

(statearr_58377_58420[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58369 === (9))){
var inst_58363 = (state_58368[(2)]);
var inst_58353 = inst_58363;
var state_58368__$1 = (function (){var statearr_58378 = state_58368;
(statearr_58378[(7)] = inst_58353);

return statearr_58378;
})();
var statearr_58379_58421 = state_58368__$1;
(statearr_58379_58421[(2)] = null);

(statearr_58379_58421[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(seq__58296,chunk__58297,count__58298,i__58299,c__42036__auto___58415,queue_58408,network_58409,sequential_QMARK__58410,response_channel_58411,send_complete_58412,remote,seq__58296__$1,temp__4657__auto__,map__58294,map__58294__$1,networking,send_queues,response_channels))
;
return ((function (seq__58296,chunk__58297,count__58298,i__58299,switch__42015__auto__,c__42036__auto___58415,queue_58408,network_58409,sequential_QMARK__58410,response_channel_58411,send_complete_58412,remote,seq__58296__$1,temp__4657__auto__,map__58294,map__58294__$1,networking,send_queues,response_channels){
return (function() {
var fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto__ = null;
var fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto____0 = (function (){
var statearr_58380 = [null,null,null,null,null,null,null,null,null,null];
(statearr_58380[(0)] = fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto__);

(statearr_58380[(1)] = (1));

return statearr_58380;
});
var fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto____1 = (function (state_58368){
while(true){
var ret_value__42017__auto__ = (function (){try{while(true){
var result__42018__auto__ = switch__42015__auto__.call(null,state_58368);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42018__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42018__auto__;
}
break;
}
}catch (e58381){if((e58381 instanceof Object)){
var ex__42019__auto__ = e58381;
var statearr_58382_58422 = state_58368;
(statearr_58382_58422[(5)] = ex__42019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_58368);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e58381;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58423 = state_58368;
state_58368 = G__58423;
continue;
} else {
return ret_value__42017__auto__;
}
break;
}
});
fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto__ = function(state_58368){
switch(arguments.length){
case 0:
return fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto____0.call(this);
case 1:
return fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto____1.call(this,state_58368);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$0 = fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto____0;
fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$1 = fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto____1;
return fulcro$client$impl$application$start_network_sequential_processing_$_state_machine__42016__auto__;
})()
;})(seq__58296,chunk__58297,count__58298,i__58299,switch__42015__auto__,c__42036__auto___58415,queue_58408,network_58409,sequential_QMARK__58410,response_channel_58411,send_complete_58412,remote,seq__58296__$1,temp__4657__auto__,map__58294,map__58294__$1,networking,send_queues,response_channels))
})();
var state__42038__auto__ = (function (){var statearr_58383 = f__42037__auto__.call(null);
(statearr_58383[(6)] = c__42036__auto___58415);

return statearr_58383;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42038__auto__);
});})(seq__58296,chunk__58297,count__58298,i__58299,c__42036__auto___58415,queue_58408,network_58409,sequential_QMARK__58410,response_channel_58411,send_complete_58412,remote,seq__58296__$1,temp__4657__auto__,map__58294,map__58294__$1,networking,send_queues,response_channels))
);


var G__58424 = cljs.core.next.call(null,seq__58296__$1);
var G__58425 = null;
var G__58426 = (0);
var G__58427 = (0);
seq__58296 = G__58424;
chunk__58297 = G__58425;
count__58298 = G__58426;
i__58299 = G__58427;
continue;
}
} else {
return null;
}
}
break;
}
});
/**
 * Configure a re-render when the locale changes and also when the translations arrive from a module load.
 * During startup this function will be called once for each reconciler that is running on a page.
 */
fulcro.client.impl.application.initialize_internationalization = (function fulcro$client$impl$application$initialize_internationalization(reconciler){
var re_render = (function fulcro$client$impl$application$initialize_internationalization_$_re_render(k,r,o,n){
if(om.next.mounted_QMARK_.call(null,om.next.app_root.call(null,reconciler))){
fulcro.client.logging.debug.call(null,"Forcing a UI refresh on locale change.");

return fulcro.client.util.force_render.call(null,reconciler);
} else {
return null;
}
});
cljs.core.remove_watch.call(null,fulcro.i18n._STAR_current_locale_STAR_,new cljs.core.Keyword(null,"locale","locale",-2115712697));

cljs.core.add_watch.call(null,fulcro.i18n._STAR_loaded_translations_STAR_,new cljs.core.Keyword(null,"locale","locale",-2115712697),re_render);

return cljs.core.add_watch.call(null,fulcro.i18n._STAR_current_locale_STAR_,new cljs.core.Keyword(null,"locale","locale",-2115712697),re_render);
});
/**
 * Remove not-found keys from m (non-recursive)
 */
fulcro.client.impl.application.sweep_one = (function fulcro$client$impl$application$sweep_one(m){
if(cljs.core.map_QMARK_.call(null,m)){
return cljs.core.reduce.call(null,(function (acc,p__58428){
var vec__58429 = p__58428;
var k = cljs.core.nth.call(null,vec__58429,(0),null);
var v = cljs.core.nth.call(null,vec__58429,(1),null);
if((cljs.core._EQ_.call(null,new cljs.core.Keyword("fulcro.client.impl.om-plumbing","not-found","fulcro.client.impl.om-plumbing/not-found",-315197951),k)) || (cljs.core._EQ_.call(null,new cljs.core.Keyword("fulcro.client.impl.om-plumbing","not-found","fulcro.client.impl.om-plumbing/not-found",-315197951),v))){
return acc;
} else {
return cljs.core.assoc.call(null,acc,k,v);
}
}),cljs.core.with_meta.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.meta.call(null,m)),m);
} else {
if(cljs.core.vector_QMARK_.call(null,m)){
return cljs.core.with_meta.call(null,cljs.core.mapv.call(null,fulcro.client.impl.application.sweep_one,m),cljs.core.meta.call(null,m));
} else {
return m;

}
}
});
/**
 * Remove all of the not-found keys (recursively) from v, stopping at marked leaves (if present)
 */
fulcro.client.impl.application.sweep = (function fulcro$client$impl$application$sweep(m){
if(cljs.core.truth_(fulcro.client.impl.om_plumbing.leaf_QMARK_.call(null,m))){
return fulcro.client.impl.application.sweep_one.call(null,m);
} else {
if(cljs.core.map_QMARK_.call(null,m)){
return cljs.core.reduce.call(null,(function (acc,p__58432){
var vec__58433 = p__58432;
var k = cljs.core.nth.call(null,vec__58433,(0),null);
var v = cljs.core.nth.call(null,vec__58433,(1),null);
if((cljs.core._EQ_.call(null,new cljs.core.Keyword("fulcro.client.impl.om-plumbing","not-found","fulcro.client.impl.om-plumbing/not-found",-315197951),k)) || (cljs.core._EQ_.call(null,new cljs.core.Keyword("fulcro.client.impl.om-plumbing","not-found","fulcro.client.impl.om-plumbing/not-found",-315197951),v))){
return acc;
} else {
if((om.util.ident_QMARK_.call(null,v)) && (cljs.core._EQ_.call(null,new cljs.core.Keyword("fulcro.client.impl.om-plumbing","not-found","fulcro.client.impl.om-plumbing/not-found",-315197951),cljs.core.second.call(null,v)))){
return acc;
} else {
return cljs.core.assoc.call(null,acc,k,fulcro.client.impl.application.sweep.call(null,v));

}
}
}),cljs.core.with_meta.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.meta.call(null,m)),m);
} else {
if(cljs.core.vector_QMARK_.call(null,m)){
return cljs.core.with_meta.call(null,cljs.core.mapv.call(null,fulcro.client.impl.application.sweep,m),cljs.core.meta.call(null,m));
} else {
return m;

}
}
}
});
/**
 * Do a recursive merge of source into target, but remove any target data that is marked as missing in the response. The
 *   missing marker is generated in the source when something has been asked for in the query, but had no value in the
 *   response. This allows us to correctly remove 'empty' data from the database without accidentally removing something
 *   that may still exist on the server (in truth we don't know its status, since it wasn't asked for, but we leave
 *   it as our 'best guess')
 */
fulcro.client.impl.application.sweep_merge = (function fulcro$client$impl$application$sweep_merge(target,source){
return cljs.core.reduce.call(null,(function (acc,p__58436){
var vec__58437 = p__58436;
var key = cljs.core.nth.call(null,vec__58437,(0),null);
var new_value = cljs.core.nth.call(null,vec__58437,(1),null);
var existing_value = cljs.core.get.call(null,acc,key);
if(cljs.core._EQ_.call(null,key,new cljs.core.Keyword("fulcro.client.impl.om-plumbing","not-found","fulcro.client.impl.om-plumbing/not-found",-315197951))){
return acc;
} else {
if(cljs.core._EQ_.call(null,new_value,new cljs.core.Keyword("fulcro.client.impl.om-plumbing","not-found","fulcro.client.impl.om-plumbing/not-found",-315197951))){
return cljs.core.dissoc.call(null,acc,key);
} else {
if((om.util.ident_QMARK_.call(null,new_value)) && (cljs.core._EQ_.call(null,new cljs.core.Keyword("fulcro.client.impl.om-plumbing","not-found","fulcro.client.impl.om-plumbing/not-found",-315197951),cljs.core.second.call(null,new_value)))){
return acc;
} else {
if(cljs.core.truth_(fulcro.client.impl.om_plumbing.leaf_QMARK_.call(null,new_value))){
return cljs.core.assoc.call(null,acc,key,fulcro.client.impl.application.sweep_one.call(null,new_value));
} else {
if((cljs.core.map_QMARK_.call(null,existing_value)) && (cljs.core.map_QMARK_.call(null,new_value))){
return cljs.core.update.call(null,acc,key,fulcro.client.impl.application.sweep_merge,new_value);
} else {
return cljs.core.assoc.call(null,acc,key,fulcro.client.impl.application.sweep.call(null,new_value));

}
}
}
}
}
}),target,source);
});
fulcro.client.impl.application.merge_handler = (function fulcro$client$impl$application$merge_handler(mutation_merge,target,source){
var source_to_merge = cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.filter.call(null,(function (p__58440){
var vec__58441 = p__58440;
var k = cljs.core.nth.call(null,vec__58441,(0),null);
var _ = cljs.core.nth.call(null,vec__58441,(1),null);
return !((k instanceof cljs.core.Symbol));
}),source));
var merged_state = fulcro.client.impl.application.sweep_merge.call(null,target,source_to_merge);
return cljs.core.reduce.call(null,((function (source_to_merge,merged_state){
return (function (acc,p__58444){
var vec__58445 = p__58444;
var k = cljs.core.nth.call(null,vec__58445,(0),null);
var v = cljs.core.nth.call(null,vec__58445,(1),null);
if(cljs.core.truth_((function (){var and__28129__auto__ = mutation_merge;
if(cljs.core.truth_(and__28129__auto__)){
return (k instanceof cljs.core.Symbol);
} else {
return and__28129__auto__;
}
})())){
var temp__4655__auto__ = mutation_merge.call(null,acc,k,cljs.core.dissoc.call(null,v,new cljs.core.Keyword(null,"tempids","tempids",1767509089)));
if(cljs.core.truth_(temp__4655__auto__)){
var updated_state = temp__4655__auto__;
return updated_state;
} else {
fulcro.client.logging.info.call(null,"Return value handler for",k,"returned nil. Ignored.");

return acc;
}
} else {
return acc;
}
});})(source_to_merge,merged_state))
,merged_state,source);
});
/**
 * The reconciler's send method calls FulcroApplication/server-send, which itself requires a reconciler with a
 *   send method already defined. This creates a catch-22 / circular dependency on the reconciler and :send field within
 *   the reconciler.
 * 
 *   To resolve the issue, we def an atom pointing to the reconciler that the send method will deref each time it is
 *   called. This allows us to define the reconciler with a send method that, at the time of initialization, has an app
 *   that points to a nil reconciler. By the end of this function, the app's reconciler reference has been properly set.
 */
fulcro.client.impl.application.generate_reconciler = (function fulcro$client$impl$application$generate_reconciler(p__58448,initial_state,parser,p__58449){
var map__58450 = p__58448;
var map__58450__$1 = ((((!((map__58450 == null)))?((((map__58450.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__58450.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__58450):map__58450);
var app = map__58450__$1;
var send_queues = cljs.core.get.call(null,map__58450__$1,new cljs.core.Keyword(null,"send-queues","send-queues",-212336330));
var mutation_merge = cljs.core.get.call(null,map__58450__$1,new cljs.core.Keyword(null,"mutation-merge","mutation-merge",-2131743322));
var map__58451 = p__58449;
var map__58451__$1 = ((((!((map__58451 == null)))?((((map__58451.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__58451.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__58451):map__58451);
var reconciler_options = map__58451__$1;
var migrate = cljs.core.get.call(null,map__58451__$1,new cljs.core.Keyword(null,"migrate","migrate",-207110743));
var rec_atom = cljs.core.atom.call(null,null);
var remotes = cljs.core.keys.call(null,send_queues);
var tempid_migrate = ((function (rec_atom,remotes,map__58450,map__58450__$1,app,send_queues,mutation_merge,map__58451,map__58451__$1,reconciler_options,migrate){
return (function (pure,_,tempids,___$1){
var seq__58454_58458 = cljs.core.seq.call(null,cljs.core.vals.call(null,send_queues));
var chunk__58455_58459 = null;
var count__58456_58460 = (0);
var i__58457_58461 = (0);
while(true){
if((i__58457_58461 < count__58456_58460)){
var queue_58462 = cljs.core._nth.call(null,chunk__58455_58459,i__58457_58461);
fulcro.client.impl.om_plumbing.rewrite_tempids_in_request_queue.call(null,queue_58462,tempids);

var G__58463 = seq__58454_58458;
var G__58464 = chunk__58455_58459;
var G__58465 = count__58456_58460;
var G__58466 = (i__58457_58461 + (1));
seq__58454_58458 = G__58463;
chunk__58455_58459 = G__58464;
count__58456_58460 = G__58465;
i__58457_58461 = G__58466;
continue;
} else {
var temp__4657__auto___58467 = cljs.core.seq.call(null,seq__58454_58458);
if(temp__4657__auto___58467){
var seq__58454_58468__$1 = temp__4657__auto___58467;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__58454_58468__$1)){
var c__28980__auto___58469 = cljs.core.chunk_first.call(null,seq__58454_58468__$1);
var G__58470 = cljs.core.chunk_rest.call(null,seq__58454_58468__$1);
var G__58471 = c__28980__auto___58469;
var G__58472 = cljs.core.count.call(null,c__28980__auto___58469);
var G__58473 = (0);
seq__58454_58458 = G__58470;
chunk__58455_58459 = G__58471;
count__58456_58460 = G__58472;
i__58457_58461 = G__58473;
continue;
} else {
var queue_58474 = cljs.core.first.call(null,seq__58454_58468__$1);
fulcro.client.impl.om_plumbing.rewrite_tempids_in_request_queue.call(null,queue_58474,tempids);

var G__58475 = cljs.core.next.call(null,seq__58454_58468__$1);
var G__58476 = null;
var G__58477 = (0);
var G__58478 = (0);
seq__58454_58458 = G__58475;
chunk__58455_58459 = G__58476;
count__58456_58460 = G__58477;
i__58457_58461 = G__58478;
continue;
}
} else {
}
}
break;
}

var state_migrate = (function (){var or__28141__auto__ = migrate;
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
return fulcro.client.impl.om_plumbing.resolve_tempids;
}
})();
return state_migrate.call(null,pure,tempids);
});})(rec_atom,remotes,map__58450,map__58450__$1,app,send_queues,mutation_merge,map__58451,map__58451__$1,reconciler_options,migrate))
;
var initial_state_with_locale = (function (){var set_default_locale = ((function (rec_atom,remotes,tempid_migrate,map__58450,map__58450__$1,app,send_queues,mutation_merge,map__58451,map__58451__$1,reconciler_options,migrate){
return (function (s){
return cljs.core.update.call(null,s,new cljs.core.Keyword("ui","locale","ui/locale",-2115717461),cljs.core.fnil.call(null,cljs.core.identity,new cljs.core.Keyword(null,"en","en",88457073)));
});})(rec_atom,remotes,tempid_migrate,map__58450,map__58450__$1,app,send_queues,mutation_merge,map__58451,map__58451__$1,reconciler_options,migrate))
;
var is_atom_QMARK_ = fulcro.client.util.atom_QMARK_.call(null,initial_state);
var incoming_locale = cljs.core.get.call(null,(cljs.core.truth_(is_atom_QMARK_)?cljs.core.deref.call(null,initial_state):initial_state),new cljs.core.Keyword("ui","locale","ui/locale",-2115717461));
if(cljs.core.truth_(incoming_locale)){
cljs.core.reset_BANG_.call(null,fulcro.i18n._STAR_current_locale_STAR_,incoming_locale);
} else {
}

if(cljs.core.truth_(is_atom_QMARK_)){
cljs.core.swap_BANG_.call(null,initial_state,set_default_locale);

return initial_state;
} else {
return set_default_locale.call(null,initial_state);
}
})();
var config = cljs.core.merge.call(null,cljs.core.PersistentArrayMap.EMPTY,reconciler_options,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"migrate","migrate",-207110743),tempid_migrate,new cljs.core.Keyword(null,"state","state",-1988618099),initial_state_with_locale,new cljs.core.Keyword(null,"send","send",-652151114),((function (rec_atom,remotes,tempid_migrate,initial_state_with_locale,map__58450,map__58450__$1,app,send_queues,mutation_merge,map__58451,map__58451__$1,reconciler_options,migrate){
return (function (tx,cb){
return fulcro.client.impl.application.server_send.call(null,cljs.core.assoc.call(null,app,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966),cljs.core.deref.call(null,rec_atom)),tx,cb);
});})(rec_atom,remotes,tempid_migrate,initial_state_with_locale,map__58450,map__58450__$1,app,send_queues,mutation_merge,map__58451,map__58451__$1,reconciler_options,migrate))
,new cljs.core.Keyword(null,"normalize","normalize",-1904390051),true,new cljs.core.Keyword(null,"remotes","remotes",1132366312),remotes,new cljs.core.Keyword(null,"merge-ident","merge-ident",1040841862),((function (rec_atom,remotes,tempid_migrate,initial_state_with_locale,map__58450,map__58450__$1,app,send_queues,mutation_merge,map__58451,map__58451__$1,reconciler_options,migrate){
return (function (reconciler,app_state,ident,props){
return cljs.core.update_in.call(null,app_state,ident,cljs.core.comp.call(null,fulcro.client.impl.application.sweep_one,cljs.core.merge),props);
});})(rec_atom,remotes,tempid_migrate,initial_state_with_locale,map__58450,map__58450__$1,app,send_queues,mutation_merge,map__58451,map__58451__$1,reconciler_options,migrate))
,new cljs.core.Keyword(null,"merge-tree","merge-tree",-127861161),((function (rec_atom,remotes,tempid_migrate,initial_state_with_locale,map__58450,map__58450__$1,app,send_queues,mutation_merge,map__58451,map__58451__$1,reconciler_options,migrate){
return (function (target,source){
return fulcro.client.impl.application.merge_handler.call(null,mutation_merge,target,source);
});})(rec_atom,remotes,tempid_migrate,initial_state_with_locale,map__58450,map__58450__$1,app,send_queues,mutation_merge,map__58451,map__58451__$1,reconciler_options,migrate))
,new cljs.core.Keyword(null,"parser","parser",-1543495310),parser], null));
var rec = om.next.reconciler.call(null,config);
cljs.core.reset_BANG_.call(null,rec_atom,rec);

return rec;
});
fulcro.client.impl.application.initialize_global_error_callbacks = (function fulcro$client$impl$application$initialize_global_error_callbacks(app){
var seq__58480 = cljs.core.seq.call(null,cljs.core.keys.call(null,new cljs.core.Keyword(null,"networking","networking",586110628).cljs$core$IFn$_invoke$arity$1(app)));
var chunk__58481 = null;
var count__58482 = (0);
var i__58483 = (0);
while(true){
if((i__58483 < count__58482)){
var remote = cljs.core._nth.call(null,chunk__58481,i__58483);
var cb_atom_58484 = cljs.core.get_in.call(null,app,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"networking","networking",586110628),remote,new cljs.core.Keyword(null,"global-error-callback","global-error-callback",901427631)], null));
if(cljs.core.truth_(fulcro.client.util.atom_QMARK_.call(null,cb_atom_58484))){
cljs.core.swap_BANG_.call(null,cb_atom_58484,((function (seq__58480,chunk__58481,count__58482,i__58483,cb_atom_58484,remote){
return (function (p1__58479_SHARP_){
if(cljs.core.fn_QMARK_.call(null,p1__58479_SHARP_)){
return cljs.core.partial.call(null,p1__58479_SHARP_,om.next.app_state.call(null,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966).cljs$core$IFn$_invoke$arity$1(app)));
} else {
throw cljs.core.ex_info.call(null,"Networking error callback must be a function.",cljs.core.PersistentArrayMap.EMPTY);
}
});})(seq__58480,chunk__58481,count__58482,i__58483,cb_atom_58484,remote))
);
} else {
}

var G__58485 = seq__58480;
var G__58486 = chunk__58481;
var G__58487 = count__58482;
var G__58488 = (i__58483 + (1));
seq__58480 = G__58485;
chunk__58481 = G__58486;
count__58482 = G__58487;
i__58483 = G__58488;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__58480);
if(temp__4657__auto__){
var seq__58480__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__58480__$1)){
var c__28980__auto__ = cljs.core.chunk_first.call(null,seq__58480__$1);
var G__58489 = cljs.core.chunk_rest.call(null,seq__58480__$1);
var G__58490 = c__28980__auto__;
var G__58491 = cljs.core.count.call(null,c__28980__auto__);
var G__58492 = (0);
seq__58480 = G__58489;
chunk__58481 = G__58490;
count__58482 = G__58491;
i__58483 = G__58492;
continue;
} else {
var remote = cljs.core.first.call(null,seq__58480__$1);
var cb_atom_58493 = cljs.core.get_in.call(null,app,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"networking","networking",586110628),remote,new cljs.core.Keyword(null,"global-error-callback","global-error-callback",901427631)], null));
if(cljs.core.truth_(fulcro.client.util.atom_QMARK_.call(null,cb_atom_58493))){
cljs.core.swap_BANG_.call(null,cb_atom_58493,((function (seq__58480,chunk__58481,count__58482,i__58483,cb_atom_58493,remote,seq__58480__$1,temp__4657__auto__){
return (function (p1__58479_SHARP_){
if(cljs.core.fn_QMARK_.call(null,p1__58479_SHARP_)){
return cljs.core.partial.call(null,p1__58479_SHARP_,om.next.app_state.call(null,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966).cljs$core$IFn$_invoke$arity$1(app)));
} else {
throw cljs.core.ex_info.call(null,"Networking error callback must be a function.",cljs.core.PersistentArrayMap.EMPTY);
}
});})(seq__58480,chunk__58481,count__58482,i__58483,cb_atom_58493,remote,seq__58480__$1,temp__4657__auto__))
);
} else {
}

var G__58494 = cljs.core.next.call(null,seq__58480__$1);
var G__58495 = null;
var G__58496 = (0);
var G__58497 = (0);
seq__58480 = G__58494;
chunk__58481 = G__58495;
count__58482 = G__58496;
i__58483 = G__58497;
continue;
}
} else {
return null;
}
}
break;
}
});

//# sourceMappingURL=application.js.map?rel=1511229561722
