// Compiled by ClojureScript 1.9.946 {}
goog.provide('com.rpl.specter');
goog.require('cljs.core');
goog.require('com.rpl.specter.protocols');
goog.require('com.rpl.specter.impl');
goog.require('com.rpl.specter.navs');
goog.require('clojure.set');
com.rpl.specter.static_path_QMARK_ = (function com$rpl$specter$static_path_QMARK_(path){
if(cljs.core.sequential_QMARK_.call(null,path)){
return cljs.core.every_QMARK_.call(null,com.rpl.specter.static_path_QMARK_,path);
} else {
return cljs.core.not.call(null,com.rpl.specter.impl.dynamic_param_QMARK_.call(null,path));
}
});
com.rpl.specter.wrap_dynamic_nav = (function com$rpl$specter$wrap_dynamic_nav(f){
return (function() { 
var G__57519__delegate = function (args){
var ret = cljs.core.apply.call(null,f,args);
if(cljs.core.truth_((function (){var and__28129__auto__ = cljs.core.sequential_QMARK_.call(null,ret);
if(and__28129__auto__){
return com.rpl.specter.static_path_QMARK_.call(null,ret);
} else {
return and__28129__auto__;
}
})())){
return com.rpl.specter.impl.comp_paths_STAR_.call(null,ret);
} else {
if((cljs.core.sequential_QMARK_.call(null,ret)) && (cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,ret)))){
return cljs.core.first.call(null,ret);
} else {
return ret;

}
}
};
var G__57519 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__57520__i = 0, G__57520__a = new Array(arguments.length -  0);
while (G__57520__i < G__57520__a.length) {G__57520__a[G__57520__i] = arguments[G__57520__i + 0]; ++G__57520__i;}
  args = new cljs.core.IndexedSeq(G__57520__a,0,null);
} 
return G__57519__delegate.call(this,args);};
G__57519.cljs$lang$maxFixedArity = 0;
G__57519.cljs$lang$applyTo = (function (arglist__57521){
var args = cljs.core.seq(arglist__57521);
return G__57519__delegate(args);
});
G__57519.cljs$core$IFn$_invoke$arity$variadic = G__57519__delegate;
return G__57519;
})()
;
});
/**
 * Returns a compiled version of the given path for use with
 * compiled-{select/transform/setval/etc.} functions.
 */
com.rpl.specter.comp_paths = (function com$rpl$specter$comp_paths(var_args){
var args__29319__auto__ = [];
var len__29312__auto___57538 = arguments.length;
var i__29313__auto___57539 = (0);
while(true){
if((i__29313__auto___57539 < len__29312__auto___57538)){
args__29319__auto__.push((arguments[i__29313__auto___57539]));

var G__57540 = (i__29313__auto___57539 + (1));
i__29313__auto___57539 = G__57540;
continue;
} else {
}
break;
}

var argseq__29320__auto__ = ((((0) < args__29319__auto__.length))?(new cljs.core.IndexedSeq(args__29319__auto__.slice((0)),(0),null)):null);
return com.rpl.specter.comp_paths.cljs$core$IFn$_invoke$arity$variadic(argseq__29320__auto__);
});

com.rpl.specter.comp_paths.cljs$core$IFn$_invoke$arity$variadic = (function (apath){
return com.rpl.specter.impl.comp_paths_STAR_.call(null,cljs.core.vec.call(null,apath));
});

com.rpl.specter.comp_paths.cljs$lang$maxFixedArity = (0);

com.rpl.specter.comp_paths.cljs$lang$applyTo = (function (seq57537){
return com.rpl.specter.comp_paths.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq57537));
});

/**
 * Version of select that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select = com.rpl.specter.impl.compiled_select_STAR_;
/**
 * Navigates to and returns a sequence of all the elements specified by the path.
 */
com.rpl.specter.select_STAR_ = (function com$rpl$specter$select_STAR_(path,structure){
return com.rpl.specter.compiled_select.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),structure);
});
/**
 * Version of select-one that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_one = com.rpl.specter.impl.compiled_select_one_STAR_;
/**
 * Like select, but returns either one element or nil. Throws exception if multiple elements found
 */
com.rpl.specter.select_one_STAR_ = (function com$rpl$specter$select_one_STAR_(path,structure){
return com.rpl.specter.compiled_select_one.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),structure);
});
/**
 * Version of select-one! that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_one_BANG_ = com.rpl.specter.impl.compiled_select_one_BANG__STAR_;
/**
 * Returns exactly one element, throws exception if zero or multiple elements found
 */
com.rpl.specter.select_one_BANG__STAR_ = (function com$rpl$specter$select_one_BANG__STAR_(path,structure){
return com.rpl.specter.compiled_select_one_BANG_.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),structure);
});
/**
 * Version of select-first that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_first = com.rpl.specter.impl.compiled_select_first_STAR_;
/**
 * Returns first element found.
 */
com.rpl.specter.select_first_STAR_ = (function com$rpl$specter$select_first_STAR_(path,structure){
return com.rpl.specter.compiled_select_first.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),structure);
});
/**
 * Version of select-any that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_any = com.rpl.specter.impl.compiled_select_any_STAR_;
/**
 * Global value used to indicate no elements selected during
 *           [[select-any]].
 */
com.rpl.specter.NONE = com.rpl.specter.impl.NONE;
/**
 * Returns any element found or [[NONE]] if nothing selected. This is the most
 * efficient of the various selection operations.
 */
com.rpl.specter.select_any_STAR_ = (function com$rpl$specter$select_any_STAR_(path,structure){
return com.rpl.specter.compiled_select_any.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),structure);
});
/**
 * Version of selected-any? that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_selected_any_QMARK_ = com.rpl.specter.impl.compiled_selected_any_QMARK__STAR_;
/**
 * Returns true if any element was selected, false otherwise.
 */
com.rpl.specter.selected_any_QMARK__STAR_ = (function com$rpl$specter$selected_any_QMARK__STAR_(path,structure){
return com.rpl.specter.compiled_selected_any_QMARK_.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),structure);
});
/**
 * Version of traverse that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_traverse = com.rpl.specter.impl.do_compiled_traverse;
/**
 * Return a reducible object that traverses over `structure` to every element
 * specified by the path
 */
com.rpl.specter.traverse_STAR_ = (function com$rpl$specter$traverse_STAR_(apath,structure){
return com.rpl.specter.compiled_traverse.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,apath),structure);
});
/**
 * Version of traverse-all that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_traverse_all = com.rpl.specter.impl.compiled_traverse_all_STAR_;
/**
 * Returns a transducer that traverses over each element with the given path.
 */
com.rpl.specter.traverse_all_STAR_ = (function com$rpl$specter$traverse_all_STAR_(apath){
return com.rpl.specter.compiled_traverse_all.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,apath));
});
/**
 * Version of transform that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_transform = com.rpl.specter.impl.compiled_transform_STAR_;
/**
 * Navigates to each value specified by the path and replaces it by the result of running
 *   the transform-fn on it
 */
com.rpl.specter.transform_STAR_ = (function com$rpl$specter$transform_STAR_(path,transform_fn,structure){
return com.rpl.specter.compiled_transform.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),transform_fn,structure);
});
/**
 * Version of `multi-transform` that takes in a path precompiled with `comp-paths`
 */
com.rpl.specter.compiled_multi_transform = com.rpl.specter.impl.compiled_multi_transform_STAR_;
/**
 * Just like `transform` but expects transform functions to be specified
 * inline in the path using `terminal`. Error is thrown if navigation finishes
 * at a non-`terminal` navigator. `terminal-val` is a wrapper around `terminal` and is
 * the `multi-transform` equivalent of `setval`.
 */
com.rpl.specter.multi_transform_STAR_ = (function com$rpl$specter$multi_transform_STAR_(path,structure){
return com.rpl.specter.compiled_multi_transform.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),structure);
});
/**
 * Version of setval that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_setval = com.rpl.specter.impl.compiled_setval_STAR_;
/**
 * Navigates to each value specified by the path and replaces it by val
 */
com.rpl.specter.setval_STAR_ = (function com$rpl$specter$setval_STAR_(path,val,structure){
return com.rpl.specter.compiled_setval.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),val,structure);
});
/**
 * Version of replace-in that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_replace_in = com.rpl.specter.impl.compiled_replace_in_STAR_;
/**
 * Similar to transform, except returns a pair of [transformed-structure sequence-of-user-ret].
 * The transform-fn in this case is expected to return [ret user-ret]. ret is
 * what's used to transform the data structure, while user-ret will be added to the user-ret sequence
 * in the final return. replace-in is useful for situations where you need to know the specific values
 * of what was transformed in the data structure.
 */
com.rpl.specter.replace_in_STAR_ = (function com$rpl$specter$replace_in_STAR_(var_args){
var args__29319__auto__ = [];
var len__29312__auto___57548 = arguments.length;
var i__29313__auto___57549 = (0);
while(true){
if((i__29313__auto___57549 < len__29312__auto___57548)){
args__29319__auto__.push((arguments[i__29313__auto___57549]));

var G__57550 = (i__29313__auto___57549 + (1));
i__29313__auto___57549 = G__57550;
continue;
} else {
}
break;
}

var argseq__29320__auto__ = ((((3) < args__29319__auto__.length))?(new cljs.core.IndexedSeq(args__29319__auto__.slice((3)),(0),null)):null);
return com.rpl.specter.replace_in_STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__29320__auto__);
});

com.rpl.specter.replace_in_STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (path,transform_fn,structure,p__57545){
var map__57546 = p__57545;
var map__57546__$1 = ((((!((map__57546 == null)))?((((map__57546.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57546.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57546):map__57546);
var merge_fn = cljs.core.get.call(null,map__57546__$1,new cljs.core.Keyword(null,"merge-fn","merge-fn",588067341),cljs.core.concat);
return com.rpl.specter.compiled_replace_in.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),transform_fn,structure,new cljs.core.Keyword(null,"merge-fn","merge-fn",588067341),merge_fn);
});

com.rpl.specter.replace_in_STAR_.cljs$lang$maxFixedArity = (3);

com.rpl.specter.replace_in_STAR_.cljs$lang$applyTo = (function (seq57541){
var G__57542 = cljs.core.first.call(null,seq57541);
var seq57541__$1 = cljs.core.next.call(null,seq57541);
var G__57543 = cljs.core.first.call(null,seq57541__$1);
var seq57541__$2 = cljs.core.next.call(null,seq57541__$1);
var G__57544 = cljs.core.first.call(null,seq57541__$2);
var seq57541__$3 = cljs.core.next.call(null,seq57541__$2);
return com.rpl.specter.replace_in_STAR_.cljs$core$IFn$_invoke$arity$variadic(G__57542,G__57543,G__57544,seq57541__$3);
});

com.rpl.specter.late_path = com.rpl.specter.impl.late_path;
com.rpl.specter.dynamic_param_QMARK_ = com.rpl.specter.impl.dynamic_param_QMARK_;
com.rpl.specter.late_resolved_fn = com.rpl.specter.impl.late_resolved_fn;
/**
 * Turns a navigator that takes one argument into a navigator that takes
 *        many arguments and uses the same navigator with each argument. There
 *        is no performance cost to using this. See implementation of `keypath`
 */
com.rpl.specter.eachnav = cljs.core.vary_meta.call(null,com.rpl.specter.wrap_dynamic_nav.call(null,(function (navfn){
var latenavfn = com.rpl.specter.late_resolved_fn.call(null,navfn);
return cljs.core.vary_meta.call(null,com.rpl.specter.wrap_dynamic_nav.call(null,((function (latenavfn){
return (function() { 
var G__57551__delegate = function (args){
return cljs.core.map.call(null,latenavfn,args);
};
var G__57551 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__57552__i = 0, G__57552__a = new Array(arguments.length -  0);
while (G__57552__i < G__57552__a.length) {G__57552__a[G__57552__i] = arguments[G__57552__i + 0]; ++G__57552__i;}
  args = new cljs.core.IndexedSeq(G__57552__a,0,null);
} 
return G__57551__delegate.call(this,args);};
G__57551.cljs$lang$maxFixedArity = 0;
G__57551.cljs$lang$applyTo = (function (arglist__57553){
var args = cljs.core.seq(arglist__57553);
return G__57551__delegate(args);
});
G__57551.cljs$core$IFn$_invoke$arity$variadic = G__57551__delegate;
return G__57551;
})()
;})(latenavfn))
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
})),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
com.rpl.specter.local_declarepath = com.rpl.specter.impl.local_declarepath;


com.rpl.specter.STOP_select_STAR_ = (function com$rpl$specter$STOP_select_STAR_(structure,next_fn){
return com.rpl.specter.NONE;
});

com.rpl.specter.STOP_transform_STAR_ = (function com$rpl$specter$STOP_transform_STAR_(structure,next_fn){
return structure;
});

/**
 * Stops navigation at this point. For selection returns nothing and for
 *        transformation returns the structure unchanged
 */
com.rpl.specter.STOP = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter57554 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter57554 = (function (meta57555){
this.meta57555 = meta57555;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter57554.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_57556,meta57555__$1){
var self__ = this;
var _57556__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter57554(meta57555__$1));
});


com.rpl.specter.t_com$rpl$specter57554.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_57556){
var self__ = this;
var _57556__$1 = this;
return self__.meta57555;
});


com.rpl.specter.t_com$rpl$specter57554.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter57554.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return com.rpl.specter.NONE;
});


com.rpl.specter.t_com$rpl$specter57554.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return structure;
});

com.rpl.specter.t_com$rpl$specter57554.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta57555","meta57555",1810153248,null)], null);
});

com.rpl.specter.t_com$rpl$specter57554.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter57554.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter57554";

com.rpl.specter.t_com$rpl$specter57554.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter57554");
});

com.rpl.specter.__GT_t_com$rpl$specter57554 = (function com$rpl$specter$__GT_t_com$rpl$specter57554(meta57555){
return (new com.rpl.specter.t_com$rpl$specter57554(meta57555));
});

}

return (new com.rpl.specter.t_com$rpl$specter57554(null));
})()
;
/**
 * Stays navigated at the current point. Essentially a no-op navigator.
 */
com.rpl.specter.STAY = com.rpl.specter.impl.STAY_STAR_;
/**
 * For usage with `multi-transform`, defines an endpoint in the navigation
 *        that will have the parameterized transform function run. The transform
 *        function works just like it does in `transform`, with collected values
 *        given as the first arguments
 */
com.rpl.specter.terminal = com.rpl.specter.impl.direct_nav_obj.call(null,(function (afn){
if(typeof com.rpl.specter.t_com$rpl$specter57557 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter57557 = (function (afn,meta57558){
this.afn = afn;
this.meta57558 = meta57558;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter57557.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_57559,meta57558__$1){
var self__ = this;
var _57559__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter57557(self__.afn,meta57558__$1));
});


com.rpl.specter.t_com$rpl$specter57557.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_57559){
var self__ = this;
var _57559__$1 = this;
return self__.meta57558;
});


com.rpl.specter.t_com$rpl$specter57557.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter57557.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
throw (new java.lang.IllegalArgumentException(com.rpl.specter.impl.smart_str.call(null,"'terminal' should only be used in multi-transform")));
});


com.rpl.specter.t_com$rpl$specter57557.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.terminal_STAR_.call(null,self__.afn,vals,structure);
});

com.rpl.specter.t_com$rpl$specter57557.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"meta57558","meta57558",562692206,null)], null);
});

com.rpl.specter.t_com$rpl$specter57557.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter57557.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter57557";

com.rpl.specter.t_com$rpl$specter57557.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter57557");
});

com.rpl.specter.__GT_t_com$rpl$specter57557 = (function com$rpl$specter$__GT_t_com$rpl$specter57557(afn__$1,meta57558){
return (new com.rpl.specter.t_com$rpl$specter57557(afn__$1,meta57558));
});

}

return (new com.rpl.specter.t_com$rpl$specter57557(afn,null));
}));
/**
 * Like `terminal` but specifies a val to set at the location regardless of
 * the collected values or the value at the location.
 */
com.rpl.specter.terminal_val = (function com$rpl$specter$terminal_val(v){
return com.rpl.specter.terminal.call(null,com.rpl.specter.impl.fast_constantly.call(null,v));
});


com.rpl.specter.ALL_select_STAR_ = (function com$rpl$specter$ALL_select_STAR_(structure,next_fn){
return com.rpl.specter.navs.all_select.call(null,structure,next_fn);
});

com.rpl.specter.ALL_transform_STAR_ = (function com$rpl$specter$ALL_transform_STAR_(structure,next_fn){
return com.rpl.specter.navs.all_transform.call(null,structure,next_fn);
});

/**
 * Navigate to every element of the collection. For maps navigates to
 *        a vector of `[key value]`.
 */
com.rpl.specter.ALL = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter57560 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter57560 = (function (meta57561){
this.meta57561 = meta57561;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter57560.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_57562,meta57561__$1){
var self__ = this;
var _57562__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter57560(meta57561__$1));
});


com.rpl.specter.t_com$rpl$specter57560.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_57562){
var self__ = this;
var _57562__$1 = this;
return self__.meta57561;
});


com.rpl.specter.t_com$rpl$specter57560.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter57560.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return com.rpl.specter.navs.all_select.call(null,structure,next_fn);
});


com.rpl.specter.t_com$rpl$specter57560.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return com.rpl.specter.navs.all_transform.call(null,structure,next_fn);
});

com.rpl.specter.t_com$rpl$specter57560.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta57561","meta57561",-1069032195,null)], null);
});

com.rpl.specter.t_com$rpl$specter57560.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter57560.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter57560";

com.rpl.specter.t_com$rpl$specter57560.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter57560");
});

com.rpl.specter.__GT_t_com$rpl$specter57560 = (function com$rpl$specter$__GT_t_com$rpl$specter57560(meta57561){
return (new com.rpl.specter.t_com$rpl$specter57560(meta57561));
});

}

return (new com.rpl.specter.t_com$rpl$specter57560(null));
})()
;


com.rpl.specter.ALL_WITH_META_select_STAR_ = (function com$rpl$specter$ALL_WITH_META_select_STAR_(structure,next_fn){
return com.rpl.specter.navs.all_select.call(null,structure,next_fn);
});

com.rpl.specter.ALL_WITH_META_transform_STAR_ = (function com$rpl$specter$ALL_WITH_META_transform_STAR_(structure,next_fn){
var m = cljs.core.meta.call(null,structure);
var res = com.rpl.specter.navs.all_transform.call(null,structure,next_fn);
if(!((res == null))){
return cljs.core.with_meta.call(null,res,m);
} else {
return null;
}
});

/**
 * Same as ALL, except maintains metadata on the structure.
 */
com.rpl.specter.ALL_WITH_META = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter57563 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter57563 = (function (meta57564){
this.meta57564 = meta57564;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter57563.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_57565,meta57564__$1){
var self__ = this;
var _57565__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter57563(meta57564__$1));
});


com.rpl.specter.t_com$rpl$specter57563.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_57565){
var self__ = this;
var _57565__$1 = this;
return self__.meta57564;
});


com.rpl.specter.t_com$rpl$specter57563.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter57563.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return com.rpl.specter.navs.all_select.call(null,structure,next_fn);
});


com.rpl.specter.t_com$rpl$specter57563.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
var m = cljs.core.meta.call(null,structure);
var res = com.rpl.specter.navs.all_transform.call(null,structure,next_fn);
if(!((res == null))){
return cljs.core.with_meta.call(null,res,m);
} else {
return null;
}
});

com.rpl.specter.t_com$rpl$specter57563.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta57564","meta57564",1483207685,null)], null);
});

com.rpl.specter.t_com$rpl$specter57563.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter57563.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter57563";

com.rpl.specter.t_com$rpl$specter57563.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter57563");
});

com.rpl.specter.__GT_t_com$rpl$specter57563 = (function com$rpl$specter$__GT_t_com$rpl$specter57563(meta57564){
return (new com.rpl.specter.t_com$rpl$specter57563(meta57564));
});

}

return (new com.rpl.specter.t_com$rpl$specter57563(null));
})()
;


com.rpl.specter.MAP_VALS_select_STAR_ = (function com$rpl$specter$MAP_VALS_select_STAR_(structure,next_fn){
return cljs.core.reduce.call(null,(function (curr__30794__auto__,v){
var ret__30795__auto__ = next_fn.call(null,v);
if((ret__30795__auto__ === com.rpl.specter.NONE)){
return curr__30794__auto__;
} else {
if(cljs.core.reduced_QMARK_.call(null,ret__30795__auto__)){
return cljs.core.reduced.call(null,ret__30795__auto__);
} else {
return ret__30795__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.vals.call(null,structure));
});

com.rpl.specter.MAP_VALS_transform_STAR_ = (function com$rpl$specter$MAP_VALS_transform_STAR_(structure,next_fn){
return com.rpl.specter.navs.map_vals_transform.call(null,structure,next_fn);
});

/**
 * Navigate to each value of the map. This is more efficient than
 *        navigating via [ALL LAST]
 */
com.rpl.specter.MAP_VALS = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter57566 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter57566 = (function (meta57567){
this.meta57567 = meta57567;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter57566.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_57568,meta57567__$1){
var self__ = this;
var _57568__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter57566(meta57567__$1));
});


com.rpl.specter.t_com$rpl$specter57566.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_57568){
var self__ = this;
var _57568__$1 = this;
return self__.meta57567;
});


com.rpl.specter.t_com$rpl$specter57566.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter57566.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return cljs.core.reduce.call(null,((function (next_fn,this__32582__auto____$1){
return (function (curr__30794__auto__,v){
var ret__30795__auto__ = next_fn.call(null,v);
if((ret__30795__auto__ === com.rpl.specter.NONE)){
return curr__30794__auto__;
} else {
if(cljs.core.reduced_QMARK_.call(null,ret__30795__auto__)){
return cljs.core.reduced.call(null,ret__30795__auto__);
} else {
return ret__30795__auto__;
}
}
});})(next_fn,this__32582__auto____$1))
,com.rpl.specter.NONE,cljs.core.vals.call(null,structure));
});


com.rpl.specter.t_com$rpl$specter57566.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return com.rpl.specter.navs.map_vals_transform.call(null,structure,next_fn);
});

com.rpl.specter.t_com$rpl$specter57566.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta57567","meta57567",-1077395150,null)], null);
});

com.rpl.specter.t_com$rpl$specter57566.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter57566.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter57566";

com.rpl.specter.t_com$rpl$specter57566.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter57566");
});

com.rpl.specter.__GT_t_com$rpl$specter57566 = (function com$rpl$specter$__GT_t_com$rpl$specter57566(meta57567){
return (new com.rpl.specter.t_com$rpl$specter57566(meta57567));
});

}

return (new com.rpl.specter.t_com$rpl$specter57566(null));
})()
;


com.rpl.specter.MAP_KEYS_select_STAR_ = (function com$rpl$specter$MAP_KEYS_select_STAR_(structure,next_fn){
return cljs.core.reduce.call(null,(function (curr__30794__auto__,k){
var ret__30795__auto__ = next_fn.call(null,k);
if((ret__30795__auto__ === com.rpl.specter.NONE)){
return curr__30794__auto__;
} else {
if(cljs.core.reduced_QMARK_.call(null,ret__30795__auto__)){
return cljs.core.reduced.call(null,ret__30795__auto__);
} else {
return ret__30795__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.keys.call(null,structure));
});

com.rpl.specter.MAP_KEYS_transform_STAR_ = (function com$rpl$specter$MAP_KEYS_transform_STAR_(structure,next_fn){
return com.rpl.specter.navs.map_keys_transform.call(null,structure,next_fn);
});

/**
 * Navigate to each key of the map. This is more efficient than
 *        navigating via [ALL FIRST]
 */
com.rpl.specter.MAP_KEYS = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter57569 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter57569 = (function (meta57570){
this.meta57570 = meta57570;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter57569.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_57571,meta57570__$1){
var self__ = this;
var _57571__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter57569(meta57570__$1));
});


com.rpl.specter.t_com$rpl$specter57569.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_57571){
var self__ = this;
var _57571__$1 = this;
return self__.meta57570;
});


com.rpl.specter.t_com$rpl$specter57569.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter57569.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return cljs.core.reduce.call(null,((function (next_fn,this__32582__auto____$1){
return (function (curr__30794__auto__,k){
var ret__30795__auto__ = next_fn.call(null,k);
if((ret__30795__auto__ === com.rpl.specter.NONE)){
return curr__30794__auto__;
} else {
if(cljs.core.reduced_QMARK_.call(null,ret__30795__auto__)){
return cljs.core.reduced.call(null,ret__30795__auto__);
} else {
return ret__30795__auto__;
}
}
});})(next_fn,this__32582__auto____$1))
,com.rpl.specter.NONE,cljs.core.keys.call(null,structure));
});


com.rpl.specter.t_com$rpl$specter57569.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return com.rpl.specter.navs.map_keys_transform.call(null,structure,next_fn);
});

com.rpl.specter.t_com$rpl$specter57569.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta57570","meta57570",-1684396577,null)], null);
});

com.rpl.specter.t_com$rpl$specter57569.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter57569.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter57569";

com.rpl.specter.t_com$rpl$specter57569.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter57569");
});

com.rpl.specter.__GT_t_com$rpl$specter57569 = (function com$rpl$specter$__GT_t_com$rpl$specter57569(meta57570){
return (new com.rpl.specter.t_com$rpl$specter57569(meta57570));
});

}

return (new com.rpl.specter.t_com$rpl$specter57569(null));
})()
;
com.rpl.specter.VAL = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter57572 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter57572 = (function (meta57573){
this.meta57573 = meta57573;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter57572.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_57574,meta57573__$1){
var self__ = this;
var _57574__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter57572(meta57573__$1));
});


com.rpl.specter.t_com$rpl$specter57572.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_57574){
var self__ = this;
var _57574__$1 = this;
return self__.meta57573;
});


com.rpl.specter.t_com$rpl$specter57572.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter57572.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__33343__auto__,vals__33344__auto__,structure,next_fn__33345__auto__){
var self__ = this;
var this__33343__auto____$1 = this;
return next_fn__33345__auto__.call(null,cljs.core.conj.call(null,vals__33344__auto__,structure),structure);
});


com.rpl.specter.t_com$rpl$specter57572.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__33343__auto__,vals__33344__auto__,structure,next_fn__33345__auto__){
var self__ = this;
var this__33343__auto____$1 = this;
return next_fn__33345__auto__.call(null,cljs.core.conj.call(null,vals__33344__auto__,structure),structure);
});

com.rpl.specter.t_com$rpl$specter57572.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta57573","meta57573",-371721313,null)], null);
});

com.rpl.specter.t_com$rpl$specter57572.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter57572.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter57572";

com.rpl.specter.t_com$rpl$specter57572.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter57572");
});

com.rpl.specter.__GT_t_com$rpl$specter57572 = (function com$rpl$specter$__GT_t_com$rpl$specter57572(meta57573){
return (new com.rpl.specter.t_com$rpl$specter57572(meta57573));
});

}

return (new com.rpl.specter.t_com$rpl$specter57572(null));
})()
;
/**
 * Navigate to the last element of the collection. If the collection is
 *        empty navigation is stopped at this point.
 */
com.rpl.specter.LAST = com.rpl.specter.navs.PosNavigator.call(null,com.rpl.specter.navs.get_last,com.rpl.specter.navs.update_last);
/**
 * Navigate to the first element of the collection. If the collection is
 *        empty navigation is stopped at this point.
 */
com.rpl.specter.FIRST = com.rpl.specter.navs.PosNavigator.call(null,com.rpl.specter.navs.get_first,com.rpl.specter.navs.update_first);


com.rpl.specter.srange_dynamic_select_STAR_ = (function com$rpl$specter$srange_dynamic_select_STAR_(start_index_fn,end_index_fn,structure,next_fn){
var s = start_index_fn.call(null,structure);
return com.rpl.specter.navs.srange_select.call(null,structure,s,com.rpl.specter.navs.invoke_end_fn.call(null,end_index_fn,structure,s),next_fn);
});

com.rpl.specter.srange_dynamic_transform_STAR_ = (function com$rpl$specter$srange_dynamic_transform_STAR_(start_index_fn,end_index_fn,structure,next_fn){
var s = start_index_fn.call(null,structure);
return com.rpl.specter.navs.srange_transform.call(null,structure,s,com.rpl.specter.navs.invoke_end_fn.call(null,end_index_fn,structure,s),next_fn);
});

/**
 * Uses start-index-fn and end-index-fn to determine the bounds of the subsequence
 *        to select when navigating. `start-index-fn` takes in the structure as input. `end-index-fn`
 *        can be one of two forms. If a regular function (e.g. defined with `fn`), it takes in only the structure as input. If a function defined using special `end-fn` macro, it takes in the structure and the result of `start-index-fn`.
 */
com.rpl.specter.srange_dynamic = com.rpl.specter.impl.direct_nav_obj.call(null,(function (start_index_fn,end_index_fn){
if(typeof com.rpl.specter.t_com$rpl$specter57575 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter57575 = (function (start_index_fn,end_index_fn,meta57576){
this.start_index_fn = start_index_fn;
this.end_index_fn = end_index_fn;
this.meta57576 = meta57576;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter57575.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_57577,meta57576__$1){
var self__ = this;
var _57577__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter57575(self__.start_index_fn,self__.end_index_fn,meta57576__$1));
});


com.rpl.specter.t_com$rpl$specter57575.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_57577){
var self__ = this;
var _57577__$1 = this;
return self__.meta57576;
});


com.rpl.specter.t_com$rpl$specter57575.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter57575.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
var s = self__.start_index_fn.call(null,structure);
return com.rpl.specter.navs.srange_select.call(null,structure,s,com.rpl.specter.navs.invoke_end_fn.call(null,self__.end_index_fn,structure,s),next_fn);
});


com.rpl.specter.t_com$rpl$specter57575.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
var s = self__.start_index_fn.call(null,structure);
return com.rpl.specter.navs.srange_transform.call(null,structure,s,com.rpl.specter.navs.invoke_end_fn.call(null,self__.end_index_fn,structure,s),next_fn);
});

com.rpl.specter.t_com$rpl$specter57575.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"start-index-fn","start-index-fn",-344842645,null),new cljs.core.Symbol(null,"end-index-fn","end-index-fn",1237092062,null),new cljs.core.Symbol(null,"meta57576","meta57576",1423036516,null)], null);
});

com.rpl.specter.t_com$rpl$specter57575.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter57575.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter57575";

com.rpl.specter.t_com$rpl$specter57575.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter57575");
});

com.rpl.specter.__GT_t_com$rpl$specter57575 = (function com$rpl$specter$__GT_t_com$rpl$specter57575(start_index_fn__$1,end_index_fn__$1,meta57576){
return (new com.rpl.specter.t_com$rpl$specter57575(start_index_fn__$1,end_index_fn__$1,meta57576));
});

}

return (new com.rpl.specter.t_com$rpl$specter57575(start_index_fn,end_index_fn,null));
}));


com.rpl.specter.srange_select_STAR_ = (function com$rpl$specter$srange_select_STAR_(start,end,structure,next_fn){
return com.rpl.specter.navs.srange_select.call(null,structure,start,end,next_fn);
});

com.rpl.specter.srange_transform_STAR_ = (function com$rpl$specter$srange_transform_STAR_(start,end,structure,next_fn){
return com.rpl.specter.navs.srange_transform.call(null,structure,start,end,next_fn);
});

/**
 * Navigates to the subsequence bound by the indexes start (inclusive)
 *        and end (exclusive)
 */
com.rpl.specter.srange = com.rpl.specter.impl.direct_nav_obj.call(null,(function (start,end){
if(typeof com.rpl.specter.t_com$rpl$specter57578 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter57578 = (function (start,end,meta57579){
this.start = start;
this.end = end;
this.meta57579 = meta57579;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter57578.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_57580,meta57579__$1){
var self__ = this;
var _57580__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter57578(self__.start,self__.end,meta57579__$1));
});


com.rpl.specter.t_com$rpl$specter57578.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_57580){
var self__ = this;
var _57580__$1 = this;
return self__.meta57579;
});


com.rpl.specter.t_com$rpl$specter57578.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter57578.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return com.rpl.specter.navs.srange_select.call(null,structure,self__.start,self__.end,next_fn);
});


com.rpl.specter.t_com$rpl$specter57578.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return com.rpl.specter.navs.srange_transform.call(null,structure,self__.start,self__.end,next_fn);
});

com.rpl.specter.t_com$rpl$specter57578.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.Symbol(null,"meta57579","meta57579",703740191,null)], null);
});

com.rpl.specter.t_com$rpl$specter57578.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter57578.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter57578";

com.rpl.specter.t_com$rpl$specter57578.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter57578");
});

com.rpl.specter.__GT_t_com$rpl$specter57578 = (function com$rpl$specter$__GT_t_com$rpl$specter57578(start__$1,end__$1,meta57579){
return (new com.rpl.specter.t_com$rpl$specter57578(start__$1,end__$1,meta57579));
});

}

return (new com.rpl.specter.t_com$rpl$specter57578(start,end,null));
}));


com.rpl.specter.continuous_subseqs_select_STAR_ = (function com$rpl$specter$continuous_subseqs_select_STAR_(pred,structure,next_fn){
return cljs.core.reduce.call(null,(function (curr__30794__auto__,p__57581){
var vec__57582 = p__57581;
var s = cljs.core.nth.call(null,vec__57582,(0),null);
var e = cljs.core.nth.call(null,vec__57582,(1),null);
var ret__30795__auto__ = com.rpl.specter.navs.srange_select.call(null,structure,s,e,next_fn);
if((ret__30795__auto__ === com.rpl.specter.NONE)){
return curr__30794__auto__;
} else {
if(cljs.core.reduced_QMARK_.call(null,ret__30795__auto__)){
return cljs.core.reduced.call(null,ret__30795__auto__);
} else {
return ret__30795__auto__;
}
}
}),com.rpl.specter.NONE,com.rpl.specter.impl.matching_ranges.call(null,structure,pred));
});

com.rpl.specter.continuous_subseqs_transform_STAR_ = (function com$rpl$specter$continuous_subseqs_transform_STAR_(pred,structure,next_fn){
return com.rpl.specter.impl.continuous_subseqs_transform_STAR_.call(null,pred,structure,next_fn);
});

/**
 * Navigates to every continuous subsequence of elements matching `pred`
 */
com.rpl.specter.continuous_subseqs = com.rpl.specter.impl.direct_nav_obj.call(null,(function (pred){
if(typeof com.rpl.specter.t_com$rpl$specter57585 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter57585 = (function (pred,meta57586){
this.pred = pred;
this.meta57586 = meta57586;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter57585.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_57587,meta57586__$1){
var self__ = this;
var _57587__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter57585(self__.pred,meta57586__$1));
});


com.rpl.specter.t_com$rpl$specter57585.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_57587){
var self__ = this;
var _57587__$1 = this;
return self__.meta57586;
});


com.rpl.specter.t_com$rpl$specter57585.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter57585.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return cljs.core.reduce.call(null,((function (next_fn,this__32582__auto____$1){
return (function (curr__30794__auto__,p__57588){
var vec__57589 = p__57588;
var s = cljs.core.nth.call(null,vec__57589,(0),null);
var e = cljs.core.nth.call(null,vec__57589,(1),null);
var ret__30795__auto__ = com.rpl.specter.navs.srange_select.call(null,structure,s,e,next_fn);
if((ret__30795__auto__ === com.rpl.specter.NONE)){
return curr__30794__auto__;
} else {
if(cljs.core.reduced_QMARK_.call(null,ret__30795__auto__)){
return cljs.core.reduced.call(null,ret__30795__auto__);
} else {
return ret__30795__auto__;
}
}
});})(next_fn,this__32582__auto____$1))
,com.rpl.specter.NONE,com.rpl.specter.impl.matching_ranges.call(null,structure,self__.pred));
});


com.rpl.specter.t_com$rpl$specter57585.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return com.rpl.specter.impl.continuous_subseqs_transform_STAR_.call(null,self__.pred,structure,next_fn);
});

com.rpl.specter.t_com$rpl$specter57585.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"meta57586","meta57586",-84191174,null)], null);
});

com.rpl.specter.t_com$rpl$specter57585.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter57585.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter57585";

com.rpl.specter.t_com$rpl$specter57585.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter57585");
});

com.rpl.specter.__GT_t_com$rpl$specter57585 = (function com$rpl$specter$__GT_t_com$rpl$specter57585(pred__$1,meta57586){
return (new com.rpl.specter.t_com$rpl$specter57585(pred__$1,meta57586));
});

}

return (new com.rpl.specter.t_com$rpl$specter57585(pred,null));
}));


com.rpl.specter.BEGINNING_select_STAR_ = (function com$rpl$specter$BEGINNING_select_STAR_(structure,next_fn){
return next_fn.call(null,((typeof structure === 'string')?"":cljs.core.PersistentVector.EMPTY));
});

com.rpl.specter.BEGINNING_transform_STAR_ = (function com$rpl$specter$BEGINNING_transform_STAR_(structure,next_fn){
if(typeof structure === 'string'){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(next_fn.call(null,"")),cljs.core.str.cljs$core$IFn$_invoke$arity$1(structure)].join('');
} else {
var to_prepend = next_fn.call(null,cljs.core.PersistentVector.EMPTY);
return com.rpl.specter.navs.prepend_all.call(null,structure,to_prepend);
}
});

/**
 * Navigate to the empty subsequence before the first element of the collection.
 */
com.rpl.specter.BEGINNING = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter57592 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter57592 = (function (meta57593){
this.meta57593 = meta57593;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter57592.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_57594,meta57593__$1){
var self__ = this;
var _57594__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter57592(meta57593__$1));
});


com.rpl.specter.t_com$rpl$specter57592.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_57594){
var self__ = this;
var _57594__$1 = this;
return self__.meta57593;
});


com.rpl.specter.t_com$rpl$specter57592.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter57592.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return next_fn.call(null,((typeof structure === 'string')?"":cljs.core.PersistentVector.EMPTY));
});


com.rpl.specter.t_com$rpl$specter57592.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
if(typeof structure === 'string'){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(next_fn.call(null,"")),cljs.core.str.cljs$core$IFn$_invoke$arity$1(structure)].join('');
} else {
var to_prepend = next_fn.call(null,cljs.core.PersistentVector.EMPTY);
return com.rpl.specter.navs.prepend_all.call(null,structure,to_prepend);
}
});

com.rpl.specter.t_com$rpl$specter57592.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta57593","meta57593",1951232540,null)], null);
});

com.rpl.specter.t_com$rpl$specter57592.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter57592.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter57592";

com.rpl.specter.t_com$rpl$specter57592.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter57592");
});

com.rpl.specter.__GT_t_com$rpl$specter57592 = (function com$rpl$specter$__GT_t_com$rpl$specter57592(meta57593){
return (new com.rpl.specter.t_com$rpl$specter57592(meta57593));
});

}

return (new com.rpl.specter.t_com$rpl$specter57592(null));
})()
;


com.rpl.specter.END_select_STAR_ = (function com$rpl$specter$END_select_STAR_(structure,next_fn){
return next_fn.call(null,((typeof structure === 'string')?"":cljs.core.PersistentVector.EMPTY));
});

com.rpl.specter.END_transform_STAR_ = (function com$rpl$specter$END_transform_STAR_(structure,next_fn){
if(typeof structure === 'string'){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(structure),cljs.core.str.cljs$core$IFn$_invoke$arity$1(next_fn.call(null,""))].join('');
} else {
var to_append = next_fn.call(null,cljs.core.PersistentVector.EMPTY);
return com.rpl.specter.navs.append_all.call(null,structure,to_append);
}
});

/**
 * Navigate to the empty subsequence after the last element of the collection.
 */
com.rpl.specter.END = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter57595 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter57595 = (function (meta57596){
this.meta57596 = meta57596;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter57595.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_57597,meta57596__$1){
var self__ = this;
var _57597__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter57595(meta57596__$1));
});


com.rpl.specter.t_com$rpl$specter57595.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_57597){
var self__ = this;
var _57597__$1 = this;
return self__.meta57596;
});


com.rpl.specter.t_com$rpl$specter57595.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter57595.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return next_fn.call(null,((typeof structure === 'string')?"":cljs.core.PersistentVector.EMPTY));
});


com.rpl.specter.t_com$rpl$specter57595.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
if(typeof structure === 'string'){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(structure),cljs.core.str.cljs$core$IFn$_invoke$arity$1(next_fn.call(null,""))].join('');
} else {
var to_append = next_fn.call(null,cljs.core.PersistentVector.EMPTY);
return com.rpl.specter.navs.append_all.call(null,structure,to_append);
}
});

com.rpl.specter.t_com$rpl$specter57595.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta57596","meta57596",-1102755517,null)], null);
});

com.rpl.specter.t_com$rpl$specter57595.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter57595.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter57595";

com.rpl.specter.t_com$rpl$specter57595.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter57595");
});

com.rpl.specter.__GT_t_com$rpl$specter57595 = (function com$rpl$specter$__GT_t_com$rpl$specter57595(meta57596){
return (new com.rpl.specter.t_com$rpl$specter57595(meta57596));
});

}

return (new com.rpl.specter.t_com$rpl$specter57595(null));
})()
;


com.rpl.specter.NONE_ELEM_select_STAR_ = (function com$rpl$specter$NONE_ELEM_select_STAR_(structure,next_fn){
return next_fn.call(null,com.rpl.specter.NONE);
});

com.rpl.specter.NONE_ELEM_transform_STAR_ = (function com$rpl$specter$NONE_ELEM_transform_STAR_(structure,next_fn){
var newe = next_fn.call(null,com.rpl.specter.NONE);
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
if((structure == null)){
return cljs.core.PersistentHashSet.createAsIfByAssoc([newe]);
} else {
return cljs.core.conj.call(null,structure,newe);
}
}
});

/**
 * Navigate to 'void' elem in the set.
 *        For transformations - if result is not `NONE`,
 *        then add that value to the set.
 */
com.rpl.specter.NONE_ELEM = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter57598 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter57598 = (function (meta57599){
this.meta57599 = meta57599;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter57598.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_57600,meta57599__$1){
var self__ = this;
var _57600__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter57598(meta57599__$1));
});


com.rpl.specter.t_com$rpl$specter57598.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_57600){
var self__ = this;
var _57600__$1 = this;
return self__.meta57599;
});


com.rpl.specter.t_com$rpl$specter57598.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter57598.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return next_fn.call(null,com.rpl.specter.NONE);
});


com.rpl.specter.t_com$rpl$specter57598.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
var newe = next_fn.call(null,com.rpl.specter.NONE);
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
if((structure == null)){
return cljs.core.PersistentHashSet.createAsIfByAssoc([newe]);
} else {
return cljs.core.conj.call(null,structure,newe);
}
}
});

com.rpl.specter.t_com$rpl$specter57598.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta57599","meta57599",-781533021,null)], null);
});

com.rpl.specter.t_com$rpl$specter57598.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter57598.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter57598";

com.rpl.specter.t_com$rpl$specter57598.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter57598");
});

com.rpl.specter.__GT_t_com$rpl$specter57598 = (function com$rpl$specter$__GT_t_com$rpl$specter57598(meta57599){
return (new com.rpl.specter.t_com$rpl$specter57598(meta57599));
});

}

return (new com.rpl.specter.t_com$rpl$specter57598(null));
})()
;


com.rpl.specter.BEFORE_ELEM_select_STAR_ = (function com$rpl$specter$BEFORE_ELEM_select_STAR_(structure,next_fn){
return next_fn.call(null,com.rpl.specter.NONE);
});

com.rpl.specter.BEFORE_ELEM_transform_STAR_ = (function com$rpl$specter$BEFORE_ELEM_transform_STAR_(structure,next_fn){
var newe = next_fn.call(null,com.rpl.specter.NONE);
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
return com.rpl.specter.navs.prepend_one.call(null,structure,newe);
}
});

/**
 * Navigate to 'void' element before the sequence.
 *        For transformations – if result is not `NONE`,
 *        then prepend that value.
 */
com.rpl.specter.BEFORE_ELEM = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter57601 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter57601 = (function (meta57602){
this.meta57602 = meta57602;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter57601.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_57603,meta57602__$1){
var self__ = this;
var _57603__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter57601(meta57602__$1));
});


com.rpl.specter.t_com$rpl$specter57601.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_57603){
var self__ = this;
var _57603__$1 = this;
return self__.meta57602;
});


com.rpl.specter.t_com$rpl$specter57601.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter57601.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return next_fn.call(null,com.rpl.specter.NONE);
});


com.rpl.specter.t_com$rpl$specter57601.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
var newe = next_fn.call(null,com.rpl.specter.NONE);
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
return com.rpl.specter.navs.prepend_one.call(null,structure,newe);
}
});

com.rpl.specter.t_com$rpl$specter57601.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta57602","meta57602",-2006706453,null)], null);
});

com.rpl.specter.t_com$rpl$specter57601.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter57601.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter57601";

com.rpl.specter.t_com$rpl$specter57601.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter57601");
});

com.rpl.specter.__GT_t_com$rpl$specter57601 = (function com$rpl$specter$__GT_t_com$rpl$specter57601(meta57602){
return (new com.rpl.specter.t_com$rpl$specter57601(meta57602));
});

}

return (new com.rpl.specter.t_com$rpl$specter57601(null));
})()
;


com.rpl.specter.AFTER_ELEM_select_STAR_ = (function com$rpl$specter$AFTER_ELEM_select_STAR_(structure,next_fn){
return next_fn.call(null,com.rpl.specter.NONE);
});

com.rpl.specter.AFTER_ELEM_transform_STAR_ = (function com$rpl$specter$AFTER_ELEM_transform_STAR_(structure,next_fn){
var newe = next_fn.call(null,com.rpl.specter.NONE);
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
return com.rpl.specter.navs.append_one.call(null,structure,newe);
}
});

/**
 * Navigate to 'void' element after the sequence.
 *        For transformations – if result is not `NONE`,
 *        then append that value.
 */
com.rpl.specter.AFTER_ELEM = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter57604 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter57604 = (function (meta57605){
this.meta57605 = meta57605;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter57604.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_57606,meta57605__$1){
var self__ = this;
var _57606__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter57604(meta57605__$1));
});


com.rpl.specter.t_com$rpl$specter57604.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_57606){
var self__ = this;
var _57606__$1 = this;
return self__.meta57605;
});


com.rpl.specter.t_com$rpl$specter57604.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter57604.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return next_fn.call(null,com.rpl.specter.NONE);
});


com.rpl.specter.t_com$rpl$specter57604.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
var newe = next_fn.call(null,com.rpl.specter.NONE);
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
return com.rpl.specter.navs.append_one.call(null,structure,newe);
}
});

com.rpl.specter.t_com$rpl$specter57604.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta57605","meta57605",-473045665,null)], null);
});

com.rpl.specter.t_com$rpl$specter57604.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter57604.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter57604";

com.rpl.specter.t_com$rpl$specter57604.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter57604");
});

com.rpl.specter.__GT_t_com$rpl$specter57604 = (function com$rpl$specter$__GT_t_com$rpl$specter57604(meta57605){
return (new com.rpl.specter.t_com$rpl$specter57604(meta57605));
});

}

return (new com.rpl.specter.t_com$rpl$specter57604(null));
})()
;


com.rpl.specter.subset_select_STAR_ = (function com$rpl$specter$subset_select_STAR_(aset,structure,next_fn){
return next_fn.call(null,clojure.set.intersection.call(null,structure,aset));
});

com.rpl.specter.subset_transform_STAR_ = (function com$rpl$specter$subset_transform_STAR_(aset,structure,next_fn){
var subset = clojure.set.intersection.call(null,structure,aset);
var newset = next_fn.call(null,subset);
return clojure.set.union.call(null,clojure.set.difference.call(null,structure,subset),newset);
});

/**
 * Navigates to the specified subset (by taking an intersection).
 *        In a transform, that subset in the original set is changed to the
 *        new value of the subset.
 */
com.rpl.specter.subset = com.rpl.specter.impl.direct_nav_obj.call(null,(function (aset){
if(typeof com.rpl.specter.t_com$rpl$specter57607 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter57607 = (function (aset,meta57608){
this.aset = aset;
this.meta57608 = meta57608;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter57607.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_57609,meta57608__$1){
var self__ = this;
var _57609__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter57607(self__.aset,meta57608__$1));
});


com.rpl.specter.t_com$rpl$specter57607.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_57609){
var self__ = this;
var _57609__$1 = this;
return self__.meta57608;
});


com.rpl.specter.t_com$rpl$specter57607.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter57607.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return next_fn.call(null,clojure.set.intersection.call(null,structure,self__.aset));
});


com.rpl.specter.t_com$rpl$specter57607.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
var subset = clojure.set.intersection.call(null,structure,self__.aset);
var newset = next_fn.call(null,subset);
return clojure.set.union.call(null,clojure.set.difference.call(null,structure,subset),newset);
});

com.rpl.specter.t_com$rpl$specter57607.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"aset","aset",900773178,null),new cljs.core.Symbol(null,"meta57608","meta57608",1862200995,null)], null);
});

com.rpl.specter.t_com$rpl$specter57607.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter57607.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter57607";

com.rpl.specter.t_com$rpl$specter57607.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter57607");
});

com.rpl.specter.__GT_t_com$rpl$specter57607 = (function com$rpl$specter$__GT_t_com$rpl$specter57607(aset__$1,meta57608){
return (new com.rpl.specter.t_com$rpl$specter57607(aset__$1,meta57608));
});

}

return (new com.rpl.specter.t_com$rpl$specter57607(aset,null));
}));


com.rpl.specter.submap_select_STAR_ = (function com$rpl$specter$submap_select_STAR_(m_keys,structure,next_fn){
return next_fn.call(null,cljs.core.select_keys.call(null,structure,m_keys));
});

com.rpl.specter.submap_transform_STAR_ = (function com$rpl$specter$submap_transform_STAR_(m_keys,structure,next_fn){
var submap = cljs.core.select_keys.call(null,structure,m_keys);
var newmap = next_fn.call(null,submap);
return cljs.core.merge.call(null,cljs.core.reduce.call(null,cljs.core.dissoc,structure,m_keys),newmap);
});

/**
 * Navigates to the specified submap (using select-keys).
 *        In a transform, that submap in the original map is changed to the new
 *        value of the submap.
 */
com.rpl.specter.submap = com.rpl.specter.impl.direct_nav_obj.call(null,(function (m_keys){
if(typeof com.rpl.specter.t_com$rpl$specter57610 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter57610 = (function (m_keys,meta57611){
this.m_keys = m_keys;
this.meta57611 = meta57611;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter57610.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_57612,meta57611__$1){
var self__ = this;
var _57612__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter57610(self__.m_keys,meta57611__$1));
});


com.rpl.specter.t_com$rpl$specter57610.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_57612){
var self__ = this;
var _57612__$1 = this;
return self__.meta57611;
});


com.rpl.specter.t_com$rpl$specter57610.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter57610.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return next_fn.call(null,cljs.core.select_keys.call(null,structure,self__.m_keys));
});


com.rpl.specter.t_com$rpl$specter57610.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
var submap = cljs.core.select_keys.call(null,structure,self__.m_keys);
var newmap = next_fn.call(null,submap);
return cljs.core.merge.call(null,cljs.core.reduce.call(null,cljs.core.dissoc,structure,self__.m_keys),newmap);
});

com.rpl.specter.t_com$rpl$specter57610.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"m-keys","m-keys",-197459035,null),new cljs.core.Symbol(null,"meta57611","meta57611",-1404973788,null)], null);
});

com.rpl.specter.t_com$rpl$specter57610.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter57610.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter57610";

com.rpl.specter.t_com$rpl$specter57610.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter57610");
});

com.rpl.specter.__GT_t_com$rpl$specter57610 = (function com$rpl$specter$__GT_t_com$rpl$specter57610(m_keys__$1,meta57611){
return (new com.rpl.specter.t_com$rpl$specter57610(m_keys__$1,meta57611));
});

}

return (new com.rpl.specter.t_com$rpl$specter57610(m_keys,null));
}));
/**
 * Navigates to a sequence that contains the results of (select ...),
 *   but is a view to the original structure that can be transformed.
 * 
 *   Requires that the input navigators will walk the structure's
 *   children in the same order when executed on "select" and then
 *   "transform".
 * 
 *   If transformed sequence is smaller than input sequence, missing entries
 *   will be filled in with NONE, triggering removal if supported by that navigator.
 */
com.rpl.specter.subselect = cljs.core.vary_meta.call(null,com.rpl.specter.wrap_dynamic_nav.call(null,(function() { 
var G__57616__delegate = function (path){
var builder__33346__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,(function (late){
if(typeof com.rpl.specter.t_com$rpl$specter57613 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter57613 = (function (path,late,meta57614){
this.path = path;
this.late = late;
this.meta57614 = meta57614;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter57613.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_57615,meta57614__$1){
var self__ = this;
var _57615__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter57613(self__.path,self__.late,meta57614__$1));
});


com.rpl.specter.t_com$rpl$specter57613.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_57615){
var self__ = this;
var _57615__$1 = this;
return self__.meta57614;
});


com.rpl.specter.t_com$rpl$specter57613.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter57613.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return next_fn.call(null,com.rpl.specter.compiled_select.call(null,self__.late,structure));
});


com.rpl.specter.t_com$rpl$specter57613.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
var select_result = com.rpl.specter.compiled_select.call(null,self__.late,structure);
var transformed = next_fn.call(null,select_result);
var values_to_insert = com.rpl.specter.impl.mutable_cell.call(null,transformed);
return com.rpl.specter.compiled_transform.call(null,self__.late,((function (select_result,transformed,values_to_insert,next_fn,this__32582__auto____$1){
return (function (_){
var vs = com.rpl.specter.impl.get_cell.call(null,values_to_insert);
if(cljs.core.truth_(vs)){
com.rpl.specter.impl.update_cell_BANG_.call(null,values_to_insert,cljs.core.next);

return cljs.core.first.call(null,vs);
} else {
return com.rpl.specter.NONE;
}
});})(select_result,transformed,values_to_insert,next_fn,this__32582__auto____$1))
,structure);
});

com.rpl.specter.t_com$rpl$specter57613.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta57614","meta57614",1139737558,null)], null);
});

com.rpl.specter.t_com$rpl$specter57613.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter57613.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter57613";

com.rpl.specter.t_com$rpl$specter57613.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter57613");
});

com.rpl.specter.__GT_t_com$rpl$specter57613 = (function com$rpl$specter$__GT_t_com$rpl$specter57613(path__$1,late__$1,meta57614){
return (new com.rpl.specter.t_com$rpl$specter57613(path__$1,late__$1,meta57614));
});

}

return (new com.rpl.specter.t_com$rpl$specter57613(path,late,null));
}));
var curr_params__33347__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,path)], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__33347__auto__)){
return cljs.core.apply.call(null,builder__33346__auto__,curr_params__33347__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__33346__auto__,curr_params__33347__auto__,null);
}
};
var G__57616 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__57617__i = 0, G__57617__a = new Array(arguments.length -  0);
while (G__57617__i < G__57617__a.length) {G__57617__a[G__57617__i] = arguments[G__57617__i + 0]; ++G__57617__i;}
  path = new cljs.core.IndexedSeq(G__57617__a,0,null);
} 
return G__57616__delegate.call(this,path);};
G__57616.cljs$lang$maxFixedArity = 0;
G__57616.cljs$lang$applyTo = (function (arglist__57618){
var path = cljs.core.seq(arglist__57618);
return G__57616__delegate(path);
});
G__57616.cljs$core$IFn$_invoke$arity$variadic = G__57616__delegate;
return G__57616;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to the given key in the map (not to the value). Navigates only if the
 *        key currently exists in the map. Can transform to NONE to remove the key/value
 *        pair from the map.
 */
com.rpl.specter.map_key = com.rpl.specter.impl.direct_nav_obj.call(null,(function (key){
if(typeof com.rpl.specter.t_com$rpl$specter57619 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter57619 = (function (key,meta57620){
this.key = key;
this.meta57620 = meta57620;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter57619.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_57621,meta57620__$1){
var self__ = this;
var _57621__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter57619(self__.key,meta57620__$1));
});


com.rpl.specter.t_com$rpl$specter57619.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_57621){
var self__ = this;
var _57621__$1 = this;
return self__.meta57620;
});


com.rpl.specter.t_com$rpl$specter57619.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter57619.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if(cljs.core.contains_QMARK_.call(null,structure,self__.key)){
return next_fn.call(null,vals,self__.key);
} else {
return com.rpl.specter.NONE;
}
});


com.rpl.specter.t_com$rpl$specter57619.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if(cljs.core.contains_QMARK_.call(null,structure,self__.key)){
var newkey = next_fn.call(null,vals,self__.key);
var dissoced = cljs.core.dissoc.call(null,structure,self__.key);
if((com.rpl.specter.NONE === newkey)){
return dissoced;
} else {
return cljs.core.assoc.call(null,dissoced,newkey,cljs.core.get.call(null,structure,self__.key));
}
} else {
return structure;
}
});

com.rpl.specter.t_com$rpl$specter57619.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"key","key",124488940,null),new cljs.core.Symbol(null,"meta57620","meta57620",1215865269,null)], null);
});

com.rpl.specter.t_com$rpl$specter57619.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter57619.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter57619";

com.rpl.specter.t_com$rpl$specter57619.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter57619");
});

com.rpl.specter.__GT_t_com$rpl$specter57619 = (function com$rpl$specter$__GT_t_com$rpl$specter57619(key__$1,meta57620){
return (new com.rpl.specter.t_com$rpl$specter57619(key__$1,meta57620));
});

}

return (new com.rpl.specter.t_com$rpl$specter57619(key,null));
}));
/**
 * Navigates to the given element in the set only if it exists in the set.
 *        Can transform to NONE to remove the element from the set.
 */
com.rpl.specter.set_elem = com.rpl.specter.impl.direct_nav_obj.call(null,(function (elem){
if(typeof com.rpl.specter.t_com$rpl$specter57622 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter57622 = (function (elem,meta57623){
this.elem = elem;
this.meta57623 = meta57623;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter57622.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_57624,meta57623__$1){
var self__ = this;
var _57624__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter57622(self__.elem,meta57623__$1));
});


com.rpl.specter.t_com$rpl$specter57622.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_57624){
var self__ = this;
var _57624__$1 = this;
return self__.meta57623;
});


com.rpl.specter.t_com$rpl$specter57622.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter57622.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if(cljs.core.contains_QMARK_.call(null,structure,self__.elem)){
return next_fn.call(null,vals,self__.elem);
} else {
return com.rpl.specter.NONE;
}
});


com.rpl.specter.t_com$rpl$specter57622.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if(cljs.core.contains_QMARK_.call(null,structure,self__.elem)){
var newelem = next_fn.call(null,vals,self__.elem);
var removed = cljs.core.disj.call(null,structure,self__.elem);
if((com.rpl.specter.NONE === newelem)){
return removed;
} else {
return cljs.core.conj.call(null,removed,newelem);
}
} else {
return structure;
}
});

com.rpl.specter.t_com$rpl$specter57622.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"elem","elem",-2035804713,null),new cljs.core.Symbol(null,"meta57623","meta57623",629734002,null)], null);
});

com.rpl.specter.t_com$rpl$specter57622.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter57622.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter57622";

com.rpl.specter.t_com$rpl$specter57622.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter57622");
});

com.rpl.specter.__GT_t_com$rpl$specter57622 = (function com$rpl$specter$__GT_t_com$rpl$specter57622(elem__$1,meta57623){
return (new com.rpl.specter.t_com$rpl$specter57622(elem__$1,meta57623));
});

}

return (new com.rpl.specter.t_com$rpl$specter57622(elem,null));
}));
/**
 * Navigate to the specified keys one after another. If navigate to NONE,
 *           that element is removed from the map or vector.
 */
com.rpl.specter.keypath = com.rpl.specter.eachnav.call(null,com.rpl.specter.navs.keypath_STAR_);
/**
 * Navigate to the specified keys one after another, only if they exist
 *           in the data structure. If navigate to NONE, that element is removed
 *           from the map or vector.
 */
com.rpl.specter.must = com.rpl.specter.eachnav.call(null,com.rpl.specter.navs.must_STAR_);
/**
 * Navigate to the specified indices one after another.If navigate to
 *          NONE, that element is removed from the sequence.
 */
com.rpl.specter.nthpath = com.rpl.specter.eachnav.call(null,com.rpl.specter.navs.nthpath_STAR_);
/**
 * Navigates to result of running `afn` on the currently navigated value.
 */
com.rpl.specter.view = com.rpl.specter.impl.direct_nav_obj.call(null,(function (afn){
if(typeof com.rpl.specter.t_com$rpl$specter57625 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter57625 = (function (afn,meta57626){
this.afn = afn;
this.meta57626 = meta57626;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter57625.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_57627,meta57626__$1){
var self__ = this;
var _57627__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter57625(self__.afn,meta57626__$1));
});


com.rpl.specter.t_com$rpl$specter57625.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_57627){
var self__ = this;
var _57627__$1 = this;
return self__.meta57626;
});


com.rpl.specter.t_com$rpl$specter57625.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter57625.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return next_fn.call(null,vals,self__.afn.call(null,structure));
});


com.rpl.specter.t_com$rpl$specter57625.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return next_fn.call(null,vals,self__.afn.call(null,structure));
});

com.rpl.specter.t_com$rpl$specter57625.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"meta57626","meta57626",131679438,null)], null);
});

com.rpl.specter.t_com$rpl$specter57625.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter57625.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter57625";

com.rpl.specter.t_com$rpl$specter57625.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter57625");
});

com.rpl.specter.__GT_t_com$rpl$specter57625 = (function com$rpl$specter$__GT_t_com$rpl$specter57625(afn__$1,meta57626){
return (new com.rpl.specter.t_com$rpl$specter57625(afn__$1,meta57626));
});

}

return (new com.rpl.specter.t_com$rpl$specter57625(afn,null));
}));


com.rpl.specter.parser_select_STAR_ = (function com$rpl$specter$parser_select_STAR_(parse_fn,unparse_fn,structure,next_fn){
return next_fn.call(null,parse_fn.call(null,structure));
});

com.rpl.specter.parser_transform_STAR_ = (function com$rpl$specter$parser_transform_STAR_(parse_fn,unparse_fn,structure,next_fn){
return unparse_fn.call(null,next_fn.call(null,parse_fn.call(null,structure)));
});

/**
 * Navigate to the result of running `parse-fn` on the value. For
 *        transforms, the transformed value then has `unparse-fn` run on
 *        it to get the final value at this point.
 */
com.rpl.specter.parser = com.rpl.specter.impl.direct_nav_obj.call(null,(function (parse_fn,unparse_fn){
if(typeof com.rpl.specter.t_com$rpl$specter57628 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter57628 = (function (parse_fn,unparse_fn,meta57629){
this.parse_fn = parse_fn;
this.unparse_fn = unparse_fn;
this.meta57629 = meta57629;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter57628.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_57630,meta57629__$1){
var self__ = this;
var _57630__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter57628(self__.parse_fn,self__.unparse_fn,meta57629__$1));
});


com.rpl.specter.t_com$rpl$specter57628.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_57630){
var self__ = this;
var _57630__$1 = this;
return self__.meta57629;
});


com.rpl.specter.t_com$rpl$specter57628.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter57628.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return next_fn.call(null,self__.parse_fn.call(null,structure));
});


com.rpl.specter.t_com$rpl$specter57628.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return self__.unparse_fn.call(null,next_fn.call(null,self__.parse_fn.call(null,structure)));
});

com.rpl.specter.t_com$rpl$specter57628.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"parse-fn","parse-fn",-836029424,null),new cljs.core.Symbol(null,"unparse-fn","unparse-fn",407187734,null),new cljs.core.Symbol(null,"meta57629","meta57629",698213697,null)], null);
});

com.rpl.specter.t_com$rpl$specter57628.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter57628.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter57628";

com.rpl.specter.t_com$rpl$specter57628.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter57628");
});

com.rpl.specter.__GT_t_com$rpl$specter57628 = (function com$rpl$specter$__GT_t_com$rpl$specter57628(parse_fn__$1,unparse_fn__$1,meta57629){
return (new com.rpl.specter.t_com$rpl$specter57628(parse_fn__$1,unparse_fn__$1,meta57629));
});

}

return (new com.rpl.specter.t_com$rpl$specter57628(parse_fn,unparse_fn,null));
}));


com.rpl.specter.ATOM_select_STAR_ = (function com$rpl$specter$ATOM_select_STAR_(structure,next_fn){
return next_fn.call(null,cljs.core.deref.call(null,structure));
});

com.rpl.specter.ATOM_transform_STAR_ = (function com$rpl$specter$ATOM_transform_STAR_(structure,next_fn){
cljs.core.swap_BANG_.call(null,structure,next_fn);

return structure;
});

/**
 * Navigates to atom value.
 */
com.rpl.specter.ATOM = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter57631 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter57631 = (function (meta57632){
this.meta57632 = meta57632;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter57631.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_57633,meta57632__$1){
var self__ = this;
var _57633__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter57631(meta57632__$1));
});


com.rpl.specter.t_com$rpl$specter57631.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_57633){
var self__ = this;
var _57633__$1 = this;
return self__.meta57632;
});


com.rpl.specter.t_com$rpl$specter57631.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter57631.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return next_fn.call(null,cljs.core.deref.call(null,structure));
});


com.rpl.specter.t_com$rpl$specter57631.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
cljs.core.swap_BANG_.call(null,structure,next_fn);

return structure;
});

com.rpl.specter.t_com$rpl$specter57631.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta57632","meta57632",226427607,null)], null);
});

com.rpl.specter.t_com$rpl$specter57631.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter57631.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter57631";

com.rpl.specter.t_com$rpl$specter57631.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter57631");
});

com.rpl.specter.__GT_t_com$rpl$specter57631 = (function com$rpl$specter$__GT_t_com$rpl$specter57631(meta57632){
return (new com.rpl.specter.t_com$rpl$specter57631(meta57632));
});

}

return (new com.rpl.specter.t_com$rpl$specter57631(null));
})()
;
/**
 * Filters the current value based on whether a path finds anything.
 *   e.g. (selected? :vals ALL even?) keeps the current element only if an
 *   even number exists for the :vals key.
 */
com.rpl.specter.selected_QMARK_ = cljs.core.vary_meta.call(null,com.rpl.specter.wrap_dynamic_nav.call(null,(function() { 
var G__57639__delegate = function (path){
var temp__4655__auto__ = com.rpl.specter.navs.extract_basic_filter_fn.call(null,path);
if(cljs.core.truth_(temp__4655__auto__)){
var afn = temp__4655__auto__;
return afn;
} else {
var builder__33346__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,((function (temp__4655__auto__){
return (function (late){
if(typeof com.rpl.specter.t_com$rpl$specter57636 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter57636 = (function (path,temp__4655__auto__,late,meta57637){
this.path = path;
this.temp__4655__auto__ = temp__4655__auto__;
this.late = late;
this.meta57637 = meta57637;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter57636.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (temp__4655__auto__){
return (function (_57638,meta57637__$1){
var self__ = this;
var _57638__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter57636(self__.path,self__.temp__4655__auto__,self__.late,meta57637__$1));
});})(temp__4655__auto__))
;


com.rpl.specter.t_com$rpl$specter57636.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (temp__4655__auto__){
return (function (_57638){
var self__ = this;
var _57638__$1 = this;
return self__.meta57637;
});})(temp__4655__auto__))
;


com.rpl.specter.t_com$rpl$specter57636.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter57636.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = ((function (temp__4655__auto__){
return (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.filter_select.call(null,((function (this$__$1,temp__4655__auto__){
return (function (p1__57634_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_.call(null,self__.late,vals,p1__57634_SHARP_);
});})(this$__$1,temp__4655__auto__))
,vals,structure,next_fn);
});})(temp__4655__auto__))
;


com.rpl.specter.t_com$rpl$specter57636.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = ((function (temp__4655__auto__){
return (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.filter_transform.call(null,((function (this$__$1,temp__4655__auto__){
return (function (p1__57635_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_.call(null,self__.late,vals,p1__57635_SHARP_);
});})(this$__$1,temp__4655__auto__))
,vals,structure,next_fn);
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter57636.getBasis = ((function (temp__4655__auto__){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"temp__4655__auto__","temp__4655__auto__",-1826162292,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta57637","meta57637",1450668123,null)], null);
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter57636.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter57636.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter57636";

com.rpl.specter.t_com$rpl$specter57636.cljs$lang$ctorPrWriter = ((function (temp__4655__auto__){
return (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter57636");
});})(temp__4655__auto__))
;

com.rpl.specter.__GT_t_com$rpl$specter57636 = ((function (temp__4655__auto__){
return (function com$rpl$specter$__GT_t_com$rpl$specter57636(path__$1,temp__4655__auto____$1,late__$1,meta57637){
return (new com.rpl.specter.t_com$rpl$specter57636(path__$1,temp__4655__auto____$1,late__$1,meta57637));
});})(temp__4655__auto__))
;

}

return (new com.rpl.specter.t_com$rpl$specter57636(path,temp__4655__auto__,late,null));
});})(temp__4655__auto__))
);
var curr_params__33347__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,path)], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__33347__auto__)){
return cljs.core.apply.call(null,builder__33346__auto__,curr_params__33347__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__33346__auto__,curr_params__33347__auto__,null);
}
}
};
var G__57639 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__57640__i = 0, G__57640__a = new Array(arguments.length -  0);
while (G__57640__i < G__57640__a.length) {G__57640__a[G__57640__i] = arguments[G__57640__i + 0]; ++G__57640__i;}
  path = new cljs.core.IndexedSeq(G__57640__a,0,null);
} 
return G__57639__delegate.call(this,path);};
G__57639.cljs$lang$maxFixedArity = 0;
G__57639.cljs$lang$applyTo = (function (arglist__57641){
var path = cljs.core.seq(arglist__57641);
return G__57639__delegate(path);
});
G__57639.cljs$core$IFn$_invoke$arity$variadic = G__57639__delegate;
return G__57639;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
com.rpl.specter.not_selected_QMARK_ = cljs.core.vary_meta.call(null,com.rpl.specter.wrap_dynamic_nav.call(null,(function() { 
var G__57647__delegate = function (path){
var temp__4655__auto__ = com.rpl.specter.navs.extract_basic_filter_fn.call(null,path);
if(cljs.core.truth_(temp__4655__auto__)){
var afn = temp__4655__auto__;
return ((function (afn,temp__4655__auto__){
return (function (s){
return cljs.core.not.call(null,afn.call(null,s));
});
;})(afn,temp__4655__auto__))
} else {
var builder__33346__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,((function (temp__4655__auto__){
return (function (late){
if(typeof com.rpl.specter.t_com$rpl$specter57644 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter57644 = (function (path,temp__4655__auto__,late,meta57645){
this.path = path;
this.temp__4655__auto__ = temp__4655__auto__;
this.late = late;
this.meta57645 = meta57645;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter57644.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (temp__4655__auto__){
return (function (_57646,meta57645__$1){
var self__ = this;
var _57646__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter57644(self__.path,self__.temp__4655__auto__,self__.late,meta57645__$1));
});})(temp__4655__auto__))
;


com.rpl.specter.t_com$rpl$specter57644.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (temp__4655__auto__){
return (function (_57646){
var self__ = this;
var _57646__$1 = this;
return self__.meta57645;
});})(temp__4655__auto__))
;


com.rpl.specter.t_com$rpl$specter57644.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter57644.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = ((function (temp__4655__auto__){
return (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.filter_select.call(null,((function (this$__$1,temp__4655__auto__){
return (function (p1__57642_SHARP_){
return com.rpl.specter.navs.not_selected_QMARK__STAR_.call(null,self__.late,vals,p1__57642_SHARP_);
});})(this$__$1,temp__4655__auto__))
,vals,structure,next_fn);
});})(temp__4655__auto__))
;


com.rpl.specter.t_com$rpl$specter57644.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = ((function (temp__4655__auto__){
return (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.filter_transform.call(null,((function (this$__$1,temp__4655__auto__){
return (function (p1__57643_SHARP_){
return com.rpl.specter.navs.not_selected_QMARK__STAR_.call(null,self__.late,vals,p1__57643_SHARP_);
});})(this$__$1,temp__4655__auto__))
,vals,structure,next_fn);
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter57644.getBasis = ((function (temp__4655__auto__){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"temp__4655__auto__","temp__4655__auto__",-1826162292,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta57645","meta57645",1768456565,null)], null);
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter57644.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter57644.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter57644";

com.rpl.specter.t_com$rpl$specter57644.cljs$lang$ctorPrWriter = ((function (temp__4655__auto__){
return (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter57644");
});})(temp__4655__auto__))
;

com.rpl.specter.__GT_t_com$rpl$specter57644 = ((function (temp__4655__auto__){
return (function com$rpl$specter$__GT_t_com$rpl$specter57644(path__$1,temp__4655__auto____$1,late__$1,meta57645){
return (new com.rpl.specter.t_com$rpl$specter57644(path__$1,temp__4655__auto____$1,late__$1,meta57645));
});})(temp__4655__auto__))
;

}

return (new com.rpl.specter.t_com$rpl$specter57644(path,temp__4655__auto__,late,null));
});})(temp__4655__auto__))
);
var curr_params__33347__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,path)], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__33347__auto__)){
return cljs.core.apply.call(null,builder__33346__auto__,curr_params__33347__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__33346__auto__,curr_params__33347__auto__,null);
}
}
};
var G__57647 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__57648__i = 0, G__57648__a = new Array(arguments.length -  0);
while (G__57648__i < G__57648__a.length) {G__57648__a[G__57648__i] = arguments[G__57648__i + 0]; ++G__57648__i;}
  path = new cljs.core.IndexedSeq(G__57648__a,0,null);
} 
return G__57647__delegate.call(this,path);};
G__57647.cljs$lang$maxFixedArity = 0;
G__57647.cljs$lang$applyTo = (function (arglist__57649){
var path = cljs.core.seq(arglist__57649);
return G__57647__delegate(path);
});
G__57647.cljs$core$IFn$_invoke$arity$variadic = G__57647__delegate;
return G__57647;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to a view of the current sequence that only contains elements that
 *   match the given path. An element matches the selector path if calling select
 *   on that element with the path yields anything other than an empty sequence.
 * 
 *   For transformation: `NONE` entries in the result sequence cause corresponding entries in
 *   input to be removed. A result sequence smaller than the input sequence is equivalent to
 *   padding the result sequence with `NONE` at the end until the same size as the input.
 */
com.rpl.specter.filterer = cljs.core.vary_meta.call(null,com.rpl.specter.wrap_dynamic_nav.call(null,(function() { 
var G__57650__delegate = function (path){
return com.rpl.specter.subselect.call(null,com.rpl.specter.ALL,com.rpl.specter.selected_QMARK_.call(null,path));
};
var G__57650 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__57651__i = 0, G__57651__a = new Array(arguments.length -  0);
while (G__57651__i < G__57651__a.length) {G__57651__a[G__57651__i] = arguments[G__57651__i + 0]; ++G__57651__i;}
  path = new cljs.core.IndexedSeq(G__57651__a,0,null);
} 
return G__57650__delegate.call(this,path);};
G__57650.cljs$lang$maxFixedArity = 0;
G__57650.cljs$lang$applyTo = (function (arglist__57652){
var path = cljs.core.seq(arglist__57652);
return G__57650__delegate(path);
});
G__57650.cljs$core$IFn$_invoke$arity$variadic = G__57650__delegate;
return G__57650;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to a view of the current value by transforming it with the
 * specified path and update-fn.
 */
com.rpl.specter.transformed = cljs.core.vary_meta.call(null,com.rpl.specter.wrap_dynamic_nav.call(null,(function (path,update_fn){
var builder__33346__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,(function (late,late_fn){
if(typeof com.rpl.specter.t_com$rpl$specter57653 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter57653 = (function (path,update_fn,late,late_fn,meta57654){
this.path = path;
this.update_fn = update_fn;
this.late = late;
this.late_fn = late_fn;
this.meta57654 = meta57654;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter57653.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_57655,meta57654__$1){
var self__ = this;
var _57655__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter57653(self__.path,self__.update_fn,self__.late,self__.late_fn,meta57654__$1));
});


com.rpl.specter.t_com$rpl$specter57653.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_57655){
var self__ = this;
var _57655__$1 = this;
return self__.meta57654;
});


com.rpl.specter.t_com$rpl$specter57653.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter57653.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return next_fn.call(null,com.rpl.specter.compiled_transform.call(null,self__.late,self__.late_fn,structure));
});


com.rpl.specter.t_com$rpl$specter57653.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return next_fn.call(null,com.rpl.specter.compiled_transform.call(null,self__.late,self__.late_fn,structure));
});

com.rpl.specter.t_com$rpl$specter57653.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"update-fn","update-fn",-1943348456,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"late-fn","late-fn",268309430,null),new cljs.core.Symbol(null,"meta57654","meta57654",-1652251197,null)], null);
});

com.rpl.specter.t_com$rpl$specter57653.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter57653.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter57653";

com.rpl.specter.t_com$rpl$specter57653.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter57653");
});

com.rpl.specter.__GT_t_com$rpl$specter57653 = (function com$rpl$specter$__GT_t_com$rpl$specter57653(path__$1,update_fn__$1,late__$1,late_fn__$1,meta57654){
return (new com.rpl.specter.t_com$rpl$specter57653(path__$1,update_fn__$1,late__$1,late_fn__$1,meta57654));
});

}

return (new com.rpl.specter.t_com$rpl$specter57653(path,update_fn,late,late_fn,null));
}));
var curr_params__33347__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,path),update_fn], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__33347__auto__)){
return cljs.core.apply.call(null,builder__33346__auto__,curr_params__33347__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__33346__auto__,curr_params__33347__auto__,null);
}
})),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to a view of the current value by transforming with a reduction over
 * the specified traversal.
 */
com.rpl.specter.traversed = cljs.core.vary_meta.call(null,com.rpl.specter.wrap_dynamic_nav.call(null,(function (path,reduce_fn){
var builder__33346__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,(function (late,late_fn){
if(typeof com.rpl.specter.t_com$rpl$specter57656 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter57656 = (function (path,reduce_fn,late,late_fn,meta57657){
this.path = path;
this.reduce_fn = reduce_fn;
this.late = late;
this.late_fn = late_fn;
this.meta57657 = meta57657;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter57656.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_57658,meta57657__$1){
var self__ = this;
var _57658__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter57656(self__.path,self__.reduce_fn,self__.late,self__.late_fn,meta57657__$1));
});


com.rpl.specter.t_com$rpl$specter57656.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_57658){
var self__ = this;
var _57658__$1 = this;
return self__.meta57657;
});


com.rpl.specter.t_com$rpl$specter57656.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter57656.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return next_fn.call(null,cljs.core.reduce.call(null,self__.late_fn,com.rpl.specter.compiled_traverse.call(null,self__.late,structure)));
});


com.rpl.specter.t_com$rpl$specter57656.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return next_fn.call(null,cljs.core.reduce.call(null,self__.late_fn,com.rpl.specter.compiled_traverse.call(null,self__.late,structure)));
});

com.rpl.specter.t_com$rpl$specter57656.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"reduce-fn","reduce-fn",-1484020844,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"late-fn","late-fn",268309430,null),new cljs.core.Symbol(null,"meta57657","meta57657",1399423189,null)], null);
});

com.rpl.specter.t_com$rpl$specter57656.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter57656.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter57656";

com.rpl.specter.t_com$rpl$specter57656.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter57656");
});

com.rpl.specter.__GT_t_com$rpl$specter57656 = (function com$rpl$specter$__GT_t_com$rpl$specter57656(path__$1,reduce_fn__$1,late__$1,late_fn__$1,meta57657){
return (new com.rpl.specter.t_com$rpl$specter57656(path__$1,reduce_fn__$1,late__$1,late_fn__$1,meta57657));
});

}

return (new com.rpl.specter.t_com$rpl$specter57656(path,reduce_fn,late,late_fn,null));
}));
var curr_params__33347__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,path),reduce_fn], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__33347__auto__)){
return cljs.core.apply.call(null,builder__33346__auto__,curr_params__33347__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__33346__auto__,curr_params__33347__auto__,null);
}
})),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Keeps the element only if it matches the supplied predicate. This is the
 *        late-bound parameterized version of using a function directly in a path.
 */
com.rpl.specter.pred = com.rpl.specter.impl.pred_STAR_;
com.rpl.specter.pred_EQ_ = (function com$rpl$specter$pred_EQ_(v){
return com.rpl.specter.pred.call(null,(function (p1__57659_SHARP_){
return cljs.core._EQ_.call(null,p1__57659_SHARP_,v);
}));
});
com.rpl.specter.pred_LT_ = (function com$rpl$specter$pred_LT_(v){
return com.rpl.specter.pred.call(null,(function (p1__57660_SHARP_){
return (p1__57660_SHARP_ < v);
}));
});
com.rpl.specter.pred_GT_ = (function com$rpl$specter$pred_GT_(v){
return com.rpl.specter.pred.call(null,(function (p1__57661_SHARP_){
return (p1__57661_SHARP_ > v);
}));
});
com.rpl.specter.pred_LT__EQ_ = (function com$rpl$specter$pred_LT__EQ_(v){
return com.rpl.specter.pred.call(null,(function (p1__57662_SHARP_){
return (p1__57662_SHARP_ <= v);
}));
});
com.rpl.specter.pred_GT__EQ_ = (function com$rpl$specter$pred_GT__EQ_(v){
return com.rpl.specter.pred.call(null,(function (p1__57663_SHARP_){
return (p1__57663_SHARP_ >= v);
}));
});
goog.object.set(com.rpl.specter.protocols.ImplicitNav,"null",true);

goog.object.set(com.rpl.specter.protocols.implicit_nav,"null",(function (this$){
return com.rpl.specter.STAY;
}));

cljs.core.Keyword.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.Keyword.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return com.rpl.specter.navs.keypath_STAR_.call(null,this$__$1);
});
goog.object.set(com.rpl.specter.protocols.ImplicitNav,"function",true);

goog.object.set(com.rpl.specter.protocols.implicit_nav,"function",(function (this$){
return com.rpl.specter.pred.call(null,this$);
}));

cljs.core.PersistentHashSet.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.PersistentHashSet.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return com.rpl.specter.pred.call(null,this$__$1);
});


com.rpl.specter.nil__GT_val_select_STAR_ = (function com$rpl$specter$nil__GT_val_select_STAR_(v,structure,next_fn){
return next_fn.call(null,(((structure == null))?v:structure));
});

com.rpl.specter.nil__GT_val_transform_STAR_ = (function com$rpl$specter$nil__GT_val_transform_STAR_(v,structure,next_fn){
return next_fn.call(null,(((structure == null))?v:structure));
});

/**
 * Navigates to the provided val if the structure is nil. Otherwise it stays
 *        navigated at the structure.
 */
com.rpl.specter.nil__GT_val = com.rpl.specter.impl.direct_nav_obj.call(null,(function (v){
if(typeof com.rpl.specter.t_com$rpl$specter57664 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter57664 = (function (v,meta57665){
this.v = v;
this.meta57665 = meta57665;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter57664.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_57666,meta57665__$1){
var self__ = this;
var _57666__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter57664(self__.v,meta57665__$1));
});


com.rpl.specter.t_com$rpl$specter57664.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_57666){
var self__ = this;
var _57666__$1 = this;
return self__.meta57665;
});


com.rpl.specter.t_com$rpl$specter57664.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter57664.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return next_fn.call(null,(((structure == null))?self__.v:structure));
});


com.rpl.specter.t_com$rpl$specter57664.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return next_fn.call(null,(((structure == null))?self__.v:structure));
});

com.rpl.specter.t_com$rpl$specter57664.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null),new cljs.core.Symbol(null,"meta57665","meta57665",1315743094,null)], null);
});

com.rpl.specter.t_com$rpl$specter57664.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter57664.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter57664";

com.rpl.specter.t_com$rpl$specter57664.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter57664");
});

com.rpl.specter.__GT_t_com$rpl$specter57664 = (function com$rpl$specter$__GT_t_com$rpl$specter57664(v__$1,meta57665){
return (new com.rpl.specter.t_com$rpl$specter57664(v__$1,meta57665));
});

}

return (new com.rpl.specter.t_com$rpl$specter57664(v,null));
}));
/**
 * Navigates to #{} if the value is nil. Otherwise it stays
 *        navigated at the current value.
 */
com.rpl.specter.NIL__GT_SET = com.rpl.specter.nil__GT_val.call(null,cljs.core.PersistentHashSet.EMPTY);
/**
 * Navigates to '() if the value is nil. Otherwise it stays
 *        navigated at the current value.
 */
com.rpl.specter.NIL__GT_LIST = com.rpl.specter.nil__GT_val.call(null,cljs.core.List.EMPTY);
/**
 * Navigates to [] if the value is nil. Otherwise it stays
 *        navigated at the current value.
 */
com.rpl.specter.NIL__GT_VECTOR = com.rpl.specter.nil__GT_val.call(null,cljs.core.PersistentVector.EMPTY);


com.rpl.specter.META_select_STAR_ = (function com$rpl$specter$META_select_STAR_(structure,next_fn){
return next_fn.call(null,cljs.core.meta.call(null,structure));
});

com.rpl.specter.META_transform_STAR_ = (function com$rpl$specter$META_transform_STAR_(structure,next_fn){
return cljs.core.with_meta.call(null,structure,next_fn.call(null,cljs.core.meta.call(null,structure)));
});

/**
 * Navigates to the metadata of the structure, or nil if
 *   the structure has no metadata or may not contain metadata.
 */
com.rpl.specter.META = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter57667 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter57667 = (function (meta57668){
this.meta57668 = meta57668;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter57667.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_57669,meta57668__$1){
var self__ = this;
var _57669__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter57667(meta57668__$1));
});


com.rpl.specter.t_com$rpl$specter57667.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_57669){
var self__ = this;
var _57669__$1 = this;
return self__.meta57668;
});


com.rpl.specter.t_com$rpl$specter57667.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter57667.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return next_fn.call(null,cljs.core.meta.call(null,structure));
});


com.rpl.specter.t_com$rpl$specter57667.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return cljs.core.with_meta.call(null,structure,next_fn.call(null,cljs.core.meta.call(null,structure)));
});

com.rpl.specter.t_com$rpl$specter57667.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta57668","meta57668",1199126002,null)], null);
});

com.rpl.specter.t_com$rpl$specter57667.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter57667.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter57667";

com.rpl.specter.t_com$rpl$specter57667.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter57667");
});

com.rpl.specter.__GT_t_com$rpl$specter57667 = (function com$rpl$specter$__GT_t_com$rpl$specter57667(meta57668){
return (new com.rpl.specter.t_com$rpl$specter57667(meta57668));
});

}

return (new com.rpl.specter.t_com$rpl$specter57667(null));
})()
;


com.rpl.specter.NAME_select_STAR_ = (function com$rpl$specter$NAME_select_STAR_(structure,next_fn){
return next_fn.call(null,cljs.core.name.call(null,structure));
});

com.rpl.specter.NAME_transform_STAR_ = (function com$rpl$specter$NAME_transform_STAR_(structure,next_fn){
var new_name = next_fn.call(null,cljs.core.name.call(null,structure));
var ns = cljs.core.namespace.call(null,structure);
if((structure instanceof cljs.core.Keyword)){
return cljs.core.keyword.call(null,ns,new_name);
} else {
if((structure instanceof cljs.core.Symbol)){
return cljs.core.symbol.call(null,ns,new_name);
} else {
throw (new java.lang.IllegalArgumentException(com.rpl.specter.impl.smart_str.call(null,"NAME can only be used on symbols or keywords - ",structure)));

}
}
});

/**
 * Navigates to the name portion of the keyword or symbol
 */
com.rpl.specter.NAME = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter57670 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter57670 = (function (meta57671){
this.meta57671 = meta57671;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter57670.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_57672,meta57671__$1){
var self__ = this;
var _57672__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter57670(meta57671__$1));
});


com.rpl.specter.t_com$rpl$specter57670.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_57672){
var self__ = this;
var _57672__$1 = this;
return self__.meta57671;
});


com.rpl.specter.t_com$rpl$specter57670.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter57670.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return next_fn.call(null,cljs.core.name.call(null,structure));
});


com.rpl.specter.t_com$rpl$specter57670.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
var new_name = next_fn.call(null,cljs.core.name.call(null,structure));
var ns = cljs.core.namespace.call(null,structure);
if((structure instanceof cljs.core.Keyword)){
return cljs.core.keyword.call(null,ns,new_name);
} else {
if((structure instanceof cljs.core.Symbol)){
return cljs.core.symbol.call(null,ns,new_name);
} else {
throw (new java.lang.IllegalArgumentException(com.rpl.specter.impl.smart_str.call(null,"NAME can only be used on symbols or keywords - ",structure)));

}
}
});

com.rpl.specter.t_com$rpl$specter57670.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta57671","meta57671",-1141685230,null)], null);
});

com.rpl.specter.t_com$rpl$specter57670.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter57670.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter57670";

com.rpl.specter.t_com$rpl$specter57670.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter57670");
});

com.rpl.specter.__GT_t_com$rpl$specter57670 = (function com$rpl$specter$__GT_t_com$rpl$specter57670(meta57671){
return (new com.rpl.specter.t_com$rpl$specter57670(meta57671));
});

}

return (new com.rpl.specter.t_com$rpl$specter57670(null));
})()
;


com.rpl.specter.NAMESPACE_select_STAR_ = (function com$rpl$specter$NAMESPACE_select_STAR_(structure,next_fn){
return next_fn.call(null,cljs.core.namespace.call(null,structure));
});

com.rpl.specter.NAMESPACE_transform_STAR_ = (function com$rpl$specter$NAMESPACE_transform_STAR_(structure,next_fn){
var name = cljs.core.name.call(null,structure);
var new_ns = next_fn.call(null,cljs.core.namespace.call(null,structure));
if((structure instanceof cljs.core.Keyword)){
return cljs.core.keyword.call(null,new_ns,name);
} else {
if((structure instanceof cljs.core.Symbol)){
return cljs.core.symbol.call(null,new_ns,name);
} else {
throw (new java.lang.IllegalArgumentException(com.rpl.specter.impl.smart_str.call(null,"NAMESPACE can only be used on symbols or keywords - ",structure)));

}
}
});

/**
 * Navigates to the namespace portion of the keyword or symbol
 */
com.rpl.specter.NAMESPACE = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter57673 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter57673 = (function (meta57674){
this.meta57674 = meta57674;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter57673.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_57675,meta57674__$1){
var self__ = this;
var _57675__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter57673(meta57674__$1));
});


com.rpl.specter.t_com$rpl$specter57673.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_57675){
var self__ = this;
var _57675__$1 = this;
return self__.meta57674;
});


com.rpl.specter.t_com$rpl$specter57673.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter57673.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return next_fn.call(null,cljs.core.namespace.call(null,structure));
});


com.rpl.specter.t_com$rpl$specter57673.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
var name = cljs.core.name.call(null,structure);
var new_ns = next_fn.call(null,cljs.core.namespace.call(null,structure));
if((structure instanceof cljs.core.Keyword)){
return cljs.core.keyword.call(null,new_ns,name);
} else {
if((structure instanceof cljs.core.Symbol)){
return cljs.core.symbol.call(null,new_ns,name);
} else {
throw (new java.lang.IllegalArgumentException(com.rpl.specter.impl.smart_str.call(null,"NAMESPACE can only be used on symbols or keywords - ",structure)));

}
}
});

com.rpl.specter.t_com$rpl$specter57673.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta57674","meta57674",1562965919,null)], null);
});

com.rpl.specter.t_com$rpl$specter57673.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter57673.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter57673";

com.rpl.specter.t_com$rpl$specter57673.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter57673");
});

com.rpl.specter.__GT_t_com$rpl$specter57673 = (function com$rpl$specter$__GT_t_com$rpl$specter57673(meta57674){
return (new com.rpl.specter.t_com$rpl$specter57673(meta57674));
});

}

return (new com.rpl.specter.t_com$rpl$specter57673(null));
})()
;
/**
 * Adds the result of running select with the given path on the
 *        current value to the collected vals.
 */
com.rpl.specter.collect = cljs.core.vary_meta.call(null,com.rpl.specter.wrap_dynamic_nav.call(null,(function() { 
var G__57679__delegate = function (path){
var builder__33346__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,(function (late){
if(typeof com.rpl.specter.t_com$rpl$specter57676 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter57676 = (function (path,late,meta57677){
this.path = path;
this.late = late;
this.meta57677 = meta57677;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter57676.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_57678,meta57677__$1){
var self__ = this;
var _57678__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter57676(self__.path,self__.late,meta57677__$1));
});


com.rpl.specter.t_com$rpl$specter57676.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_57678){
var self__ = this;
var _57678__$1 = this;
return self__.meta57677;
});


com.rpl.specter.t_com$rpl$specter57676.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter57676.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__33343__auto__,vals__33344__auto__,structure,next_fn__33345__auto__){
var self__ = this;
var this__33343__auto____$1 = this;
return next_fn__33345__auto__.call(null,cljs.core.conj.call(null,vals__33344__auto__,com.rpl.specter.compiled_select.call(null,self__.late,structure)),structure);
});


com.rpl.specter.t_com$rpl$specter57676.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__33343__auto__,vals__33344__auto__,structure,next_fn__33345__auto__){
var self__ = this;
var this__33343__auto____$1 = this;
return next_fn__33345__auto__.call(null,cljs.core.conj.call(null,vals__33344__auto__,com.rpl.specter.compiled_select.call(null,self__.late,structure)),structure);
});

com.rpl.specter.t_com$rpl$specter57676.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta57677","meta57677",-1519698683,null)], null);
});

com.rpl.specter.t_com$rpl$specter57676.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter57676.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter57676";

com.rpl.specter.t_com$rpl$specter57676.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter57676");
});

com.rpl.specter.__GT_t_com$rpl$specter57676 = (function com$rpl$specter$__GT_t_com$rpl$specter57676(path__$1,late__$1,meta57677){
return (new com.rpl.specter.t_com$rpl$specter57676(path__$1,late__$1,meta57677));
});

}

return (new com.rpl.specter.t_com$rpl$specter57676(path,late,null));
}));
var curr_params__33347__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,path)], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__33347__auto__)){
return cljs.core.apply.call(null,builder__33346__auto__,curr_params__33347__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__33346__auto__,curr_params__33347__auto__,null);
}
};
var G__57679 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__57680__i = 0, G__57680__a = new Array(arguments.length -  0);
while (G__57680__i < G__57680__a.length) {G__57680__a[G__57680__i] = arguments[G__57680__i + 0]; ++G__57680__i;}
  path = new cljs.core.IndexedSeq(G__57680__a,0,null);
} 
return G__57679__delegate.call(this,path);};
G__57679.cljs$lang$maxFixedArity = 0;
G__57679.cljs$lang$applyTo = (function (arglist__57681){
var path = cljs.core.seq(arglist__57681);
return G__57679__delegate(path);
});
G__57679.cljs$core$IFn$_invoke$arity$variadic = G__57679__delegate;
return G__57679;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Adds the result of running select-one with the given path on the
 *        current value to the collected vals.
 */
com.rpl.specter.collect_one = cljs.core.vary_meta.call(null,com.rpl.specter.wrap_dynamic_nav.call(null,(function() { 
var G__57685__delegate = function (path){
var builder__33346__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,(function (late){
if(typeof com.rpl.specter.t_com$rpl$specter57682 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter57682 = (function (path,late,meta57683){
this.path = path;
this.late = late;
this.meta57683 = meta57683;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter57682.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_57684,meta57683__$1){
var self__ = this;
var _57684__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter57682(self__.path,self__.late,meta57683__$1));
});


com.rpl.specter.t_com$rpl$specter57682.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_57684){
var self__ = this;
var _57684__$1 = this;
return self__.meta57683;
});


com.rpl.specter.t_com$rpl$specter57682.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter57682.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__33343__auto__,vals__33344__auto__,structure,next_fn__33345__auto__){
var self__ = this;
var this__33343__auto____$1 = this;
return next_fn__33345__auto__.call(null,cljs.core.conj.call(null,vals__33344__auto__,com.rpl.specter.compiled_select_one.call(null,self__.late,structure)),structure);
});


com.rpl.specter.t_com$rpl$specter57682.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__33343__auto__,vals__33344__auto__,structure,next_fn__33345__auto__){
var self__ = this;
var this__33343__auto____$1 = this;
return next_fn__33345__auto__.call(null,cljs.core.conj.call(null,vals__33344__auto__,com.rpl.specter.compiled_select_one.call(null,self__.late,structure)),structure);
});

com.rpl.specter.t_com$rpl$specter57682.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta57683","meta57683",-823624751,null)], null);
});

com.rpl.specter.t_com$rpl$specter57682.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter57682.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter57682";

com.rpl.specter.t_com$rpl$specter57682.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter57682");
});

com.rpl.specter.__GT_t_com$rpl$specter57682 = (function com$rpl$specter$__GT_t_com$rpl$specter57682(path__$1,late__$1,meta57683){
return (new com.rpl.specter.t_com$rpl$specter57682(path__$1,late__$1,meta57683));
});

}

return (new com.rpl.specter.t_com$rpl$specter57682(path,late,null));
}));
var curr_params__33347__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,path)], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__33347__auto__)){
return cljs.core.apply.call(null,builder__33346__auto__,curr_params__33347__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__33346__auto__,curr_params__33347__auto__,null);
}
};
var G__57685 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__57686__i = 0, G__57686__a = new Array(arguments.length -  0);
while (G__57686__i < G__57686__a.length) {G__57686__a[G__57686__i] = arguments[G__57686__i + 0]; ++G__57686__i;}
  path = new cljs.core.IndexedSeq(G__57686__a,0,null);
} 
return G__57685__delegate.call(this,path);};
G__57685.cljs$lang$maxFixedArity = 0;
G__57685.cljs$lang$applyTo = (function (arglist__57687){
var path = cljs.core.seq(arglist__57687);
return G__57685__delegate(path);
});
G__57685.cljs$core$IFn$_invoke$arity$variadic = G__57685__delegate;
return G__57685;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Adds an external value to the collected vals. Useful when additional arguments
 *   are required to the transform function that would otherwise require partial
 *   application or a wrapper function.
 * 
 *   e.g., incrementing val at path [:a :b] by 3:
 *   (transform [:a :b (putval 3)] + some-map)
 */
com.rpl.specter.putval = com.rpl.specter.impl.direct_nav_obj.call(null,(function (val){
if(typeof com.rpl.specter.t_com$rpl$specter57688 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter57688 = (function (val,meta57689){
this.val = val;
this.meta57689 = meta57689;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter57688.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_57690,meta57689__$1){
var self__ = this;
var _57690__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter57688(self__.val,meta57689__$1));
});


com.rpl.specter.t_com$rpl$specter57688.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_57690){
var self__ = this;
var _57690__$1 = this;
return self__.meta57689;
});


com.rpl.specter.t_com$rpl$specter57688.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter57688.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__33343__auto__,vals__33344__auto__,structure,next_fn__33345__auto__){
var self__ = this;
var this__33343__auto____$1 = this;
return next_fn__33345__auto__.call(null,cljs.core.conj.call(null,vals__33344__auto__,self__.val),structure);
});


com.rpl.specter.t_com$rpl$specter57688.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__33343__auto__,vals__33344__auto__,structure,next_fn__33345__auto__){
var self__ = this;
var this__33343__auto____$1 = this;
return next_fn__33345__auto__.call(null,cljs.core.conj.call(null,vals__33344__auto__,self__.val),structure);
});

com.rpl.specter.t_com$rpl$specter57688.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.Symbol(null,"meta57689","meta57689",-1076481349,null)], null);
});

com.rpl.specter.t_com$rpl$specter57688.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter57688.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter57688";

com.rpl.specter.t_com$rpl$specter57688.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter57688");
});

com.rpl.specter.__GT_t_com$rpl$specter57688 = (function com$rpl$specter$__GT_t_com$rpl$specter57688(val__$1,meta57689){
return (new com.rpl.specter.t_com$rpl$specter57688(val__$1,meta57689));
});

}

return (new com.rpl.specter.t_com$rpl$specter57688(val,null));
}));
/**
 * Continues navigating on the given path with the collected vals reset to []. Once
 *   navigation leaves the scope of with-fresh-collected, the collected vals revert
 *   to what they were before.
 */
com.rpl.specter.with_fresh_collected = cljs.core.vary_meta.call(null,com.rpl.specter.wrap_dynamic_nav.call(null,(function() { 
var G__57696__delegate = function (path){
var builder__33346__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,(function (late){
if(typeof com.rpl.specter.t_com$rpl$specter57691 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter57691 = (function (path,late,meta57692){
this.path = path;
this.late = late;
this.meta57692 = meta57692;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter57691.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_57693,meta57692__$1){
var self__ = this;
var _57693__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter57691(self__.path,self__.late,meta57692__$1));
});


com.rpl.specter.t_com$rpl$specter57691.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_57693){
var self__ = this;
var _57693__$1 = this;
return self__.meta57692;
});


com.rpl.specter.t_com$rpl$specter57691.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter57691.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.protocols.select_STAR_.call(null,self__.late,cljs.core.PersistentVector.EMPTY,structure,((function (this$__$1){
return (function (_,structure__$1){
return next_fn.call(null,vals,structure__$1);
});})(this$__$1))
);
});


com.rpl.specter.t_com$rpl$specter57691.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.protocols.transform_STAR_.call(null,self__.late,cljs.core.PersistentVector.EMPTY,structure,((function (this$__$1){
return (function (_,structure__$1){
return next_fn.call(null,vals,structure__$1);
});})(this$__$1))
);
});

com.rpl.specter.t_com$rpl$specter57691.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta57692","meta57692",159442338,null)], null);
});

com.rpl.specter.t_com$rpl$specter57691.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter57691.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter57691";

com.rpl.specter.t_com$rpl$specter57691.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter57691");
});

com.rpl.specter.__GT_t_com$rpl$specter57691 = (function com$rpl$specter$__GT_t_com$rpl$specter57691(path__$1,late__$1,meta57692){
return (new com.rpl.specter.t_com$rpl$specter57691(path__$1,late__$1,meta57692));
});

}

return (new com.rpl.specter.t_com$rpl$specter57691(path,late,null));
}));
var curr_params__33347__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,path)], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__33347__auto__)){
return cljs.core.apply.call(null,builder__33346__auto__,curr_params__33347__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__33346__auto__,curr_params__33347__auto__,null);
}
};
var G__57696 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__57697__i = 0, G__57697__a = new Array(arguments.length -  0);
while (G__57697__i < G__57697__a.length) {G__57697__a[G__57697__i] = arguments[G__57697__i + 0]; ++G__57697__i;}
  path = new cljs.core.IndexedSeq(G__57697__a,0,null);
} 
return G__57696__delegate.call(this,path);};
G__57696.cljs$lang$maxFixedArity = 0;
G__57696.cljs$lang$applyTo = (function (arglist__57698){
var path = cljs.core.seq(arglist__57698);
return G__57696__delegate(path);
});
G__57696.cljs$core$IFn$_invoke$arity$variadic = G__57696__delegate;
return G__57696;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Drops all collected values for subsequent navigation.
 */
com.rpl.specter.DISPENSE = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter57699 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter57699 = (function (meta57700){
this.meta57700 = meta57700;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter57699.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_57701,meta57700__$1){
var self__ = this;
var _57701__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter57699(meta57700__$1));
});


com.rpl.specter.t_com$rpl$specter57699.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_57701){
var self__ = this;
var _57701__$1 = this;
return self__.meta57700;
});


com.rpl.specter.t_com$rpl$specter57699.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter57699.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return next_fn.call(null,cljs.core.PersistentVector.EMPTY,structure);
});


com.rpl.specter.t_com$rpl$specter57699.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return next_fn.call(null,cljs.core.PersistentVector.EMPTY,structure);
});

com.rpl.specter.t_com$rpl$specter57699.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta57700","meta57700",-1746261001,null)], null);
});

com.rpl.specter.t_com$rpl$specter57699.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter57699.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter57699";

com.rpl.specter.t_com$rpl$specter57699.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter57699");
});

com.rpl.specter.__GT_t_com$rpl$specter57699 = (function com$rpl$specter$__GT_t_com$rpl$specter57699(meta57700){
return (new com.rpl.specter.t_com$rpl$specter57699(meta57700));
});

}

return (new com.rpl.specter.t_com$rpl$specter57699(null));
})()
;
/**
 * Like cond-path, but with if semantics.
 */
com.rpl.specter.if_path = cljs.core.vary_meta.call(null,com.rpl.specter.wrap_dynamic_nav.call(null,(function() {
var G__57710 = null;
var G__57710__2 = (function (cond_p,then_path){
return com.rpl.specter.if_path.call(null,cond_p,then_path,com.rpl.specter.STOP);
});
var G__57710__3 = (function (cond_p,then_path,else_path){
var temp__4655__auto__ = com.rpl.specter.navs.extract_basic_filter_fn.call(null,cond_p);
if(cljs.core.truth_(temp__4655__auto__)){
var afn = temp__4655__auto__;
var builder__33346__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,((function (afn,temp__4655__auto__){
return (function (late_then,late_else){
if(typeof com.rpl.specter.t_com$rpl$specter57704 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter57704 = (function (cond_p,then_path,else_path,temp__4655__auto__,afn,late_then,late_else,meta57705){
this.cond_p = cond_p;
this.then_path = then_path;
this.else_path = else_path;
this.temp__4655__auto__ = temp__4655__auto__;
this.afn = afn;
this.late_then = late_then;
this.late_else = late_else;
this.meta57705 = meta57705;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter57704.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (afn,temp__4655__auto__){
return (function (_57706,meta57705__$1){
var self__ = this;
var _57706__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter57704(self__.cond_p,self__.then_path,self__.else_path,self__.temp__4655__auto__,self__.afn,self__.late_then,self__.late_else,meta57705__$1));
});})(afn,temp__4655__auto__))
;


com.rpl.specter.t_com$rpl$specter57704.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (afn,temp__4655__auto__){
return (function (_57706){
var self__ = this;
var _57706__$1 = this;
return self__.meta57705;
});})(afn,temp__4655__auto__))
;


com.rpl.specter.t_com$rpl$specter57704.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter57704.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = ((function (afn,temp__4655__auto__){
return (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_select.call(null,vals,structure,next_fn,self__.afn,self__.late_then,self__.late_else);
});})(afn,temp__4655__auto__))
;


com.rpl.specter.t_com$rpl$specter57704.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = ((function (afn,temp__4655__auto__){
return (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_transform.call(null,vals,structure,next_fn,self__.afn,self__.late_then,self__.late_else);
});})(afn,temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter57704.getBasis = ((function (afn,temp__4655__auto__){
return (function (){
return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cond-p","cond-p",695068009,null),new cljs.core.Symbol(null,"then-path","then-path",1949536092,null),new cljs.core.Symbol(null,"else-path","else-path",-2100209576,null),new cljs.core.Symbol(null,"temp__4655__auto__","temp__4655__auto__",-1826162292,null),new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"late-then","late-then",1623904294,null),new cljs.core.Symbol(null,"late-else","late-else",1462724600,null),new cljs.core.Symbol(null,"meta57705","meta57705",247506079,null)], null);
});})(afn,temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter57704.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter57704.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter57704";

com.rpl.specter.t_com$rpl$specter57704.cljs$lang$ctorPrWriter = ((function (afn,temp__4655__auto__){
return (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter57704");
});})(afn,temp__4655__auto__))
;

com.rpl.specter.__GT_t_com$rpl$specter57704 = ((function (afn,temp__4655__auto__){
return (function com$rpl$specter$__GT_t_com$rpl$specter57704(cond_p__$1,then_path__$1,else_path__$1,temp__4655__auto____$1,afn__$1,late_then__$1,late_else__$1,meta57705){
return (new com.rpl.specter.t_com$rpl$specter57704(cond_p__$1,then_path__$1,else_path__$1,temp__4655__auto____$1,afn__$1,late_then__$1,late_else__$1,meta57705));
});})(afn,temp__4655__auto__))
;

}

return (new com.rpl.specter.t_com$rpl$specter57704(cond_p,then_path,else_path,temp__4655__auto__,afn,late_then,late_else,null));
});})(afn,temp__4655__auto__))
);
var curr_params__33347__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,then_path),com.rpl.specter.late_path.call(null,else_path)], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__33347__auto__)){
return cljs.core.apply.call(null,builder__33346__auto__,curr_params__33347__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__33346__auto__,curr_params__33347__auto__,null);
}
} else {
var builder__33346__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,((function (temp__4655__auto__){
return (function (late_cond,late_then,late_else){
if(typeof com.rpl.specter.t_com$rpl$specter57707 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter57707 = (function (cond_p,then_path,else_path,temp__4655__auto__,late_cond,late_then,late_else,meta57708){
this.cond_p = cond_p;
this.then_path = then_path;
this.else_path = else_path;
this.temp__4655__auto__ = temp__4655__auto__;
this.late_cond = late_cond;
this.late_then = late_then;
this.late_else = late_else;
this.meta57708 = meta57708;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter57707.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (temp__4655__auto__){
return (function (_57709,meta57708__$1){
var self__ = this;
var _57709__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter57707(self__.cond_p,self__.then_path,self__.else_path,self__.temp__4655__auto__,self__.late_cond,self__.late_then,self__.late_else,meta57708__$1));
});})(temp__4655__auto__))
;


com.rpl.specter.t_com$rpl$specter57707.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (temp__4655__auto__){
return (function (_57709){
var self__ = this;
var _57709__$1 = this;
return self__.meta57708;
});})(temp__4655__auto__))
;


com.rpl.specter.t_com$rpl$specter57707.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter57707.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = ((function (temp__4655__auto__){
return (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_select.call(null,vals,structure,next_fn,((function (this$__$1,temp__4655__auto__){
return (function (p1__57702_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_.call(null,self__.late_cond,vals,p1__57702_SHARP_);
});})(this$__$1,temp__4655__auto__))
,self__.late_then,self__.late_else);
});})(temp__4655__auto__))
;


com.rpl.specter.t_com$rpl$specter57707.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = ((function (temp__4655__auto__){
return (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_transform.call(null,vals,structure,next_fn,((function (this$__$1,temp__4655__auto__){
return (function (p1__57703_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_.call(null,self__.late_cond,vals,p1__57703_SHARP_);
});})(this$__$1,temp__4655__auto__))
,self__.late_then,self__.late_else);
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter57707.getBasis = ((function (temp__4655__auto__){
return (function (){
return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cond-p","cond-p",695068009,null),new cljs.core.Symbol(null,"then-path","then-path",1949536092,null),new cljs.core.Symbol(null,"else-path","else-path",-2100209576,null),new cljs.core.Symbol(null,"temp__4655__auto__","temp__4655__auto__",-1826162292,null),new cljs.core.Symbol(null,"late-cond","late-cond",1031862828,null),new cljs.core.Symbol(null,"late-then","late-then",1623904294,null),new cljs.core.Symbol(null,"late-else","late-else",1462724600,null),new cljs.core.Symbol(null,"meta57708","meta57708",-1130412060,null)], null);
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter57707.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter57707.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter57707";

com.rpl.specter.t_com$rpl$specter57707.cljs$lang$ctorPrWriter = ((function (temp__4655__auto__){
return (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter57707");
});})(temp__4655__auto__))
;

com.rpl.specter.__GT_t_com$rpl$specter57707 = ((function (temp__4655__auto__){
return (function com$rpl$specter$__GT_t_com$rpl$specter57707(cond_p__$1,then_path__$1,else_path__$1,temp__4655__auto____$1,late_cond__$1,late_then__$1,late_else__$1,meta57708){
return (new com.rpl.specter.t_com$rpl$specter57707(cond_p__$1,then_path__$1,else_path__$1,temp__4655__auto____$1,late_cond__$1,late_then__$1,late_else__$1,meta57708));
});})(temp__4655__auto__))
;

}

return (new com.rpl.specter.t_com$rpl$specter57707(cond_p,then_path,else_path,temp__4655__auto__,late_cond,late_then,late_else,null));
});})(temp__4655__auto__))
);
var curr_params__33347__auto__ = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,cond_p),com.rpl.specter.late_path.call(null,then_path),com.rpl.specter.late_path.call(null,else_path)], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__33347__auto__)){
return cljs.core.apply.call(null,builder__33346__auto__,curr_params__33347__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__33346__auto__,curr_params__33347__auto__,null);
}
}
});
G__57710 = function(cond_p,then_path,else_path){
switch(arguments.length){
case 2:
return G__57710__2.call(this,cond_p,then_path);
case 3:
return G__57710__3.call(this,cond_p,then_path,else_path);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__57710.cljs$core$IFn$_invoke$arity$2 = G__57710__2;
G__57710.cljs$core$IFn$_invoke$arity$3 = G__57710__3;
return G__57710;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Takes in alternating cond-path path cond-path path...
 * Tests the structure if selecting with cond-path returns anything.
 * If so, it uses the following path for this portion of the navigation.
 * Otherwise, it tries the next cond-path. If nothing matches, then the structure
 * is not selected.
 * 
 * The input paths may be parameterized, in which case the result of cond-path
 * will be parameterized in the order of which the parameterized navigators
 * were declared.
 */
com.rpl.specter.cond_path = cljs.core.vary_meta.call(null,com.rpl.specter.wrap_dynamic_nav.call(null,(function() { 
var G__57715__delegate = function (conds){
var pairs = cljs.core.reverse.call(null,cljs.core.partition.call(null,(2),conds));
return cljs.core.reduce.call(null,((function (pairs){
return (function (p,p__57711){
var vec__57712 = p__57711;
var tester = cljs.core.nth.call(null,vec__57712,(0),null);
var apath = cljs.core.nth.call(null,vec__57712,(1),null);
return com.rpl.specter.if_path.call(null,tester,apath,p);
});})(pairs))
,com.rpl.specter.STOP,pairs);
};
var G__57715 = function (var_args){
var conds = null;
if (arguments.length > 0) {
var G__57716__i = 0, G__57716__a = new Array(arguments.length -  0);
while (G__57716__i < G__57716__a.length) {G__57716__a[G__57716__i] = arguments[G__57716__i + 0]; ++G__57716__i;}
  conds = new cljs.core.IndexedSeq(G__57716__a,0,null);
} 
return G__57715__delegate.call(this,conds);};
G__57715.cljs$lang$maxFixedArity = 0;
G__57715.cljs$lang$applyTo = (function (arglist__57717){
var conds = cljs.core.seq(arglist__57717);
return G__57715__delegate(conds);
});
G__57715.cljs$core$IFn$_invoke$arity$variadic = G__57715__delegate;
return G__57715;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * A path that branches on multiple paths. For updates,
 * applies updates to the paths in order.
 */
com.rpl.specter.multi_path = cljs.core.vary_meta.call(null,com.rpl.specter.wrap_dynamic_nav.call(null,(function() {
var G__57725 = null;
var G__57725__0 = (function (){
return com.rpl.specter.STAY;
});
var G__57725__1 = (function (path){
return path;
});
var G__57725__2 = (function (path1,path2){
var builder__33346__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,(function (late1,late2){
if(typeof com.rpl.specter.t_com$rpl$specter57718 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter57718 = (function (path1,path2,late1,late2,meta57719){
this.path1 = path1;
this.path2 = path2;
this.late1 = late1;
this.late2 = late2;
this.meta57719 = meta57719;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter57718.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_57720,meta57719__$1){
var self__ = this;
var _57720__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter57718(self__.path1,self__.path2,self__.late1,self__.late2,meta57719__$1));
});


com.rpl.specter.t_com$rpl$specter57718.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_57720){
var self__ = this;
var _57720__$1 = this;
return self__.meta57719;
});


com.rpl.specter.t_com$rpl$specter57718.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter57718.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var res1 = com.rpl.specter.protocols.select_STAR_.call(null,self__.late1,vals,structure,next_fn);
if(cljs.core.reduced_QMARK_.call(null,res1)){
return res1;
} else {
var res2 = com.rpl.specter.protocols.select_STAR_.call(null,self__.late2,vals,structure,next_fn);
if((com.rpl.specter.NONE === res1)){
return res2;
} else {
return res1;
}
}
});


com.rpl.specter.t_com$rpl$specter57718.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var s1 = com.rpl.specter.protocols.transform_STAR_.call(null,self__.late1,vals,structure,next_fn);
return com.rpl.specter.protocols.transform_STAR_.call(null,self__.late2,vals,s1,next_fn);
});

com.rpl.specter.t_com$rpl$specter57718.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path1","path1",-2002517142,null),new cljs.core.Symbol(null,"path2","path2",-1937913521,null),new cljs.core.Symbol(null,"late1","late1",-1413016621,null),new cljs.core.Symbol(null,"late2","late2",-681717994,null),new cljs.core.Symbol(null,"meta57719","meta57719",-307326907,null)], null);
});

com.rpl.specter.t_com$rpl$specter57718.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter57718.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter57718";

com.rpl.specter.t_com$rpl$specter57718.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter57718");
});

com.rpl.specter.__GT_t_com$rpl$specter57718 = (function com$rpl$specter$__GT_t_com$rpl$specter57718(path1__$1,path2__$1,late1__$1,late2__$1,meta57719){
return (new com.rpl.specter.t_com$rpl$specter57718(path1__$1,path2__$1,late1__$1,late2__$1,meta57719));
});

}

return (new com.rpl.specter.t_com$rpl$specter57718(path1,path2,late1,late2,null));
}));
var curr_params__33347__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,path1),com.rpl.specter.late_path.call(null,path2)], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__33347__auto__)){
return cljs.core.apply.call(null,builder__33346__auto__,curr_params__33347__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__33346__auto__,curr_params__33347__auto__,null);
}
});
var G__57725__3 = (function() { 
var G__57726__delegate = function (path1,path2,paths){
return cljs.core.reduce.call(null,com.rpl.specter.multi_path,com.rpl.specter.multi_path.call(null,path1,path2),paths);
};
var G__57726 = function (path1,path2,var_args){
var paths = null;
if (arguments.length > 2) {
var G__57727__i = 0, G__57727__a = new Array(arguments.length -  2);
while (G__57727__i < G__57727__a.length) {G__57727__a[G__57727__i] = arguments[G__57727__i + 2]; ++G__57727__i;}
  paths = new cljs.core.IndexedSeq(G__57727__a,0,null);
} 
return G__57726__delegate.call(this,path1,path2,paths);};
G__57726.cljs$lang$maxFixedArity = 2;
G__57726.cljs$lang$applyTo = (function (arglist__57728){
var path1 = cljs.core.first(arglist__57728);
arglist__57728 = cljs.core.next(arglist__57728);
var path2 = cljs.core.first(arglist__57728);
var paths = cljs.core.rest(arglist__57728);
return G__57726__delegate(path1,path2,paths);
});
G__57726.cljs$core$IFn$_invoke$arity$variadic = G__57726__delegate;
return G__57726;
})()
;
G__57725 = function(path1,path2,var_args){
var paths = var_args;
switch(arguments.length){
case 0:
return G__57725__0.call(this);
case 1:
return G__57725__1.call(this,path1);
case 2:
return G__57725__2.call(this,path1,path2);
default:
var G__57729 = null;
if (arguments.length > 2) {
var G__57730__i = 0, G__57730__a = new Array(arguments.length -  2);
while (G__57730__i < G__57730__a.length) {G__57730__a[G__57730__i] = arguments[G__57730__i + 2]; ++G__57730__i;}
G__57729 = new cljs.core.IndexedSeq(G__57730__a,0,null);
}
return G__57725__3.cljs$core$IFn$_invoke$arity$variadic(path1,path2, G__57729);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__57725.cljs$lang$maxFixedArity = 2;
G__57725.cljs$lang$applyTo = G__57725__3.cljs$lang$applyTo;
G__57725.cljs$core$IFn$_invoke$arity$0 = G__57725__0;
G__57725.cljs$core$IFn$_invoke$arity$1 = G__57725__1;
G__57725.cljs$core$IFn$_invoke$arity$2 = G__57725__2;
G__57725.cljs$core$IFn$_invoke$arity$variadic = G__57725__3.cljs$core$IFn$_invoke$arity$variadic;
return G__57725;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to the current element and then navigates via the provided path.
 * This can be used to implement pre-order traversal.
 */
com.rpl.specter.stay_then_continue = cljs.core.vary_meta.call(null,com.rpl.specter.wrap_dynamic_nav.call(null,(function() { 
var G__57731__delegate = function (path){
return com.rpl.specter.multi_path.call(null,com.rpl.specter.STAY,path);
};
var G__57731 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__57732__i = 0, G__57732__a = new Array(arguments.length -  0);
while (G__57732__i < G__57732__a.length) {G__57732__a[G__57732__i] = arguments[G__57732__i + 0]; ++G__57732__i;}
  path = new cljs.core.IndexedSeq(G__57732__a,0,null);
} 
return G__57731__delegate.call(this,path);};
G__57731.cljs$lang$maxFixedArity = 0;
G__57731.cljs$lang$applyTo = (function (arglist__57733){
var path = cljs.core.seq(arglist__57733);
return G__57731__delegate(path);
});
G__57731.cljs$core$IFn$_invoke$arity$variadic = G__57731__delegate;
return G__57731;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to the provided path and then to the current element. This can be used
 * to implement post-order traversal.
 */
com.rpl.specter.continue_then_stay = cljs.core.vary_meta.call(null,com.rpl.specter.wrap_dynamic_nav.call(null,(function() { 
var G__57734__delegate = function (path){
return com.rpl.specter.multi_path.call(null,path,com.rpl.specter.STAY);
};
var G__57734 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__57735__i = 0, G__57735__a = new Array(arguments.length -  0);
while (G__57735__i < G__57735__a.length) {G__57735__a[G__57735__i] = arguments[G__57735__i + 0]; ++G__57735__i;}
  path = new cljs.core.IndexedSeq(G__57735__a,0,null);
} 
return G__57734__delegate.call(this,path);};
G__57734.cljs$lang$maxFixedArity = 0;
G__57734.cljs$lang$applyTo = (function (arglist__57736){
var path = cljs.core.seq(arglist__57736);
return G__57734__delegate(path);
});
G__57734.cljs$core$IFn$_invoke$arity$variadic = G__57734__delegate;
return G__57734;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigate the data structure until reaching
 *        a value for which `afn` returns truthy. Has
 *        same semantics as clojure.walk.
 */
com.rpl.specter.walker = com.rpl.specter.impl.direct_nav_obj.call(null,(function (afn){
var p = com.rpl.specter.impl.local_declarepath.call(null);
com.rpl.specter.impl.providepath_STAR_.call(null,p,(function (){var info__33353__auto__ = com.rpl.specter.pathcache57737;
var info__33353__auto____$1 = (((info__33353__auto__ == null))?(function (){var info57738 = com.rpl.specter.impl.magic_precompilation.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation.call(null,com.rpl.specter.impl.__GT_VarUse.call(null,com.rpl.specter.cond_path,new cljs.core.Var(function(){return com.rpl.specter.cond_path;},new cljs.core.Symbol("com.rpl.specter","cond-path","com.rpl.specter/cond-path",97137882,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),"resources/public/js/compiled/test/out/com/rpl/specter.cljc",25,1,1237,1237,cljs.core.List.EMPTY,"Takes in alternating cond-path path cond-path path...\n   Tests the structure if selecting with cond-path returns anything.\n   If so, it uses the following path for this portion of the navigation.\n   Otherwise, it tries the next cond-path. If nothing matches, then the structure\n   is not selected.\n\n   The input paths may be parameterized, in which case the result of cond-path\n   will be parameterized in the order of which the parameterized navigators\n   were declared.",(cljs.core.truth_(com.rpl.specter.cond_path)?com.rpl.specter.cond_path.cljs$lang$test:null)])),new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null)),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation.call(null,com.rpl.specter.impl.__GT_VarUse.call(null,com.rpl.specter.pred,new cljs.core.Var(function(){return com.rpl.specter.pred;},new cljs.core.Symbol("com.rpl.specter","pred","com.rpl.specter/pred",1192968523,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"direct-nav","direct-nav",-2100776046),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null),"resources/public/js/compiled/test/out/com/rpl/specter.cljc",7,1,true,1042,1046,cljs.core.List.EMPTY,"Keeps the element only if it matches the supplied predicate. This is the\n          late-bound parameterized version of using a function directly in a path.",(cljs.core.truth_(com.rpl.specter.pred)?com.rpl.specter.pred.cljs$lang$test:null)])),new cljs.core.Symbol(null,"pred","pred",-727012372,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym.call(null,afn,new cljs.core.Symbol(null,"afn","afn",216963467,null))], null),cljs.core.list(new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null))),com.rpl.specter.impl.__GT_VarUse.call(null,com.rpl.specter.STAY,new cljs.core.Var(function(){return com.rpl.specter.STAY;},new cljs.core.Symbol("com.rpl.specter","STAY","com.rpl.specter/STAY",-176499375,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),"resources/public/js/compiled/test/out/com/rpl/specter.cljc",7,1,626,628,cljs.core.List.EMPTY,"Stays navigated at the current point. Essentially a no-op navigator.",(cljs.core.truth_(com.rpl.specter.STAY)?com.rpl.specter.STAY.cljs$lang$test:null)])),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null)),com.rpl.specter.impl.__GT_VarUse.call(null,cljs.core.coll_QMARK_,new cljs.core.Var(function(){return cljs.core.coll_QMARK_;},new cljs.core.Symbol("cljs.core","coll?","cljs.core/coll?",1208130522,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),"cljs/core.cljs",(21),(1),(2086),(2086),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),"Returns true if x satisfies ICollection",((cljs.core.coll_QMARK_)?cljs.core.coll_QMARK_.cljs$lang$test:null)])),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_VarUse.call(null,com.rpl.specter.ALL,new cljs.core.Var(function(){return com.rpl.specter.ALL;},new cljs.core.Symbol("com.rpl.specter","ALL","com.rpl.specter/ALL",-1409005960,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),"resources/public/js/compiled/test/out/com/rpl/specter.cljc",6,1,650,653,cljs.core.List.EMPTY,"Navigate to every element of the collection. For maps navigates to\n          a vector of `[key value]`.",(cljs.core.truth_(com.rpl.specter.ALL)?com.rpl.specter.ALL.cljs$lang$test:null)])),new cljs.core.Symbol(null,"ALL","ALL",866837407,null)),com.rpl.specter.impl.__GT_LocalSym.call(null,p,new cljs.core.Symbol(null,"p","p",1791580836,null))], null)], null),cljs.core.list(new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),cljs.core.list(new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null)),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL","ALL",866837407,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null),new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL","ALL",866837407,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null));
com.rpl.specter.pathcache57737 = info57738;

return info57738;
})():info__33353__auto__);
var precompiled57739 = com.rpl.specter.impl.cached_path_info_precompiled.call(null,info__33353__auto____$1);
var dynamic_QMARK___33354__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_.call(null,info__33353__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___33354__auto__)){
return precompiled57739.call(null,new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.cond_path,com.rpl.specter.pred,afn,com.rpl.specter.STAY,cljs.core.coll_QMARK_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.ALL,p], null),com.rpl.specter.ALL,p], null));
} else {
return precompiled57739;
}
})());

return p;
}));
/**
 * Like `walker` but maintains metadata of any forms traversed.
 */
com.rpl.specter.codewalker = com.rpl.specter.impl.direct_nav_obj.call(null,(function (afn){
var p = com.rpl.specter.impl.local_declarepath.call(null);
com.rpl.specter.impl.providepath_STAR_.call(null,p,(function (){var info__33353__auto__ = com.rpl.specter.pathcache57740;
var info__33353__auto____$1 = (((info__33353__auto__ == null))?(function (){var info57741 = com.rpl.specter.impl.magic_precompilation.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation.call(null,com.rpl.specter.impl.__GT_VarUse.call(null,com.rpl.specter.cond_path,new cljs.core.Var(function(){return com.rpl.specter.cond_path;},new cljs.core.Symbol("com.rpl.specter","cond-path","com.rpl.specter/cond-path",97137882,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),"resources/public/js/compiled/test/out/com/rpl/specter.cljc",25,1,1237,1237,cljs.core.List.EMPTY,"Takes in alternating cond-path path cond-path path...\n   Tests the structure if selecting with cond-path returns anything.\n   If so, it uses the following path for this portion of the navigation.\n   Otherwise, it tries the next cond-path. If nothing matches, then the structure\n   is not selected.\n\n   The input paths may be parameterized, in which case the result of cond-path\n   will be parameterized in the order of which the parameterized navigators\n   were declared.",(cljs.core.truth_(com.rpl.specter.cond_path)?com.rpl.specter.cond_path.cljs$lang$test:null)])),new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null)),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation.call(null,com.rpl.specter.impl.__GT_VarUse.call(null,com.rpl.specter.pred,new cljs.core.Var(function(){return com.rpl.specter.pred;},new cljs.core.Symbol("com.rpl.specter","pred","com.rpl.specter/pred",1192968523,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"direct-nav","direct-nav",-2100776046),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null),"resources/public/js/compiled/test/out/com/rpl/specter.cljc",7,1,true,1042,1046,cljs.core.List.EMPTY,"Keeps the element only if it matches the supplied predicate. This is the\n          late-bound parameterized version of using a function directly in a path.",(cljs.core.truth_(com.rpl.specter.pred)?com.rpl.specter.pred.cljs$lang$test:null)])),new cljs.core.Symbol(null,"pred","pred",-727012372,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym.call(null,afn,new cljs.core.Symbol(null,"afn","afn",216963467,null))], null),cljs.core.list(new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null))),com.rpl.specter.impl.__GT_VarUse.call(null,com.rpl.specter.STAY,new cljs.core.Var(function(){return com.rpl.specter.STAY;},new cljs.core.Symbol("com.rpl.specter","STAY","com.rpl.specter/STAY",-176499375,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),"resources/public/js/compiled/test/out/com/rpl/specter.cljc",7,1,626,628,cljs.core.List.EMPTY,"Stays navigated at the current point. Essentially a no-op navigator.",(cljs.core.truth_(com.rpl.specter.STAY)?com.rpl.specter.STAY.cljs$lang$test:null)])),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null)),com.rpl.specter.impl.__GT_VarUse.call(null,cljs.core.coll_QMARK_,new cljs.core.Var(function(){return cljs.core.coll_QMARK_;},new cljs.core.Symbol("cljs.core","coll?","cljs.core/coll?",1208130522,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),"cljs/core.cljs",(21),(1),(2086),(2086),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),"Returns true if x satisfies ICollection",((cljs.core.coll_QMARK_)?cljs.core.coll_QMARK_.cljs$lang$test:null)])),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_VarUse.call(null,com.rpl.specter.ALL_WITH_META,new cljs.core.Var(function(){return com.rpl.specter.ALL_WITH_META;},new cljs.core.Symbol("com.rpl.specter","ALL-WITH-META","com.rpl.specter/ALL-WITH-META",-1161868995,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null),"resources/public/js/compiled/test/out/com/rpl/specter.cljc",16,1,660,662,cljs.core.List.EMPTY,"Same as ALL, except maintains metadata on the structure.",(cljs.core.truth_(com.rpl.specter.ALL_WITH_META)?com.rpl.specter.ALL_WITH_META.cljs$lang$test:null)])),new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null)),com.rpl.specter.impl.__GT_LocalSym.call(null,p,new cljs.core.Symbol(null,"p","p",1791580836,null))], null)], null),cljs.core.list(new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),cljs.core.list(new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null)),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null),new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null),new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null));
com.rpl.specter.pathcache57740 = info57741;

return info57741;
})():info__33353__auto__);
var precompiled57742 = com.rpl.specter.impl.cached_path_info_precompiled.call(null,info__33353__auto____$1);
var dynamic_QMARK___33354__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_.call(null,info__33353__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___33354__auto__)){
return precompiled57742.call(null,new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.cond_path,com.rpl.specter.pred,afn,com.rpl.specter.STAY,cljs.core.coll_QMARK_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.ALL_WITH_META,p], null),com.rpl.specter.ALL_WITH_META,p], null));
} else {
return precompiled57742;
}
})());

return p;
}));

//# sourceMappingURL=specter.js.map?rel=1511229560512
