// Compiled by ClojureScript 1.9.946 {}
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('goog.string');
goog.require('sablono.normalize');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('goog.dom');
goog.require('cljsjs.react');
goog.require('cljsjs.react.dom');
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__69126__delegate = function (args){
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,args))){
var vec__69122 = cljs.core.apply.call(null,func,cljs.core.rest.call(null,args));
var seq__69123 = cljs.core.seq.call(null,vec__69122);
var first__69124 = cljs.core.first.call(null,seq__69123);
var seq__69123__$1 = cljs.core.next.call(null,seq__69123);
var tag = first__69124;
var body = seq__69123__$1;
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,body))){
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.merge.call(null,cljs.core.first.call(null,body),cljs.core.first.call(null,args)),cljs.core.rest.call(null,body));
} else {
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.first.call(null,args),body);
}
} else {
return cljs.core.apply.call(null,func,args);
}
};
var G__69126 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__69129__i = 0, G__69129__a = new Array(arguments.length -  0);
while (G__69129__i < G__69129__a.length) {G__69129__a[G__69129__i] = arguments[G__69129__i + 0]; ++G__69129__i;}
  args = new cljs.core.IndexedSeq(G__69129__a,0,null);
} 
return G__69126__delegate.call(this,args);};
G__69126.cljs$lang$maxFixedArity = 0;
G__69126.cljs$lang$applyTo = (function (arglist__69131){
var args = cljs.core.seq(arglist__69131);
return G__69126__delegate(args);
});
G__69126.cljs$core$IFn$_invoke$arity$variadic = G__69126__delegate;
return G__69126;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__28949__auto__ = (function sablono$core$update_arglists_$_iter__69132(s__69133){
return (new cljs.core.LazySeq(null,(function (){
var s__69133__$1 = s__69133;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__69133__$1);
if(temp__4657__auto__){
var s__69133__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__69133__$2)){
var c__28947__auto__ = cljs.core.chunk_first.call(null,s__69133__$2);
var size__28948__auto__ = cljs.core.count.call(null,c__28947__auto__);
var b__69135 = cljs.core.chunk_buffer.call(null,size__28948__auto__);
if((function (){var i__69134 = (0);
while(true){
if((i__69134 < size__28948__auto__)){
var args = cljs.core._nth.call(null,c__28947__auto__,i__69134);
cljs.core.chunk_append.call(null,b__69135,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)));

var G__69137 = (i__69134 + (1));
i__69134 = G__69137;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__69135),sablono$core$update_arglists_$_iter__69132.call(null,cljs.core.chunk_rest.call(null,s__69133__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__69135),null);
}
} else {
var args = cljs.core.first.call(null,s__69133__$2);
return cljs.core.cons.call(null,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)),sablono$core$update_arglists_$_iter__69132.call(null,cljs.core.rest.call(null,s__69133__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__28949__auto__.call(null,arglists);
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__29319__auto__ = [];
var len__29312__auto___69157 = arguments.length;
var i__29313__auto___69158 = (0);
while(true){
if((i__29313__auto___69158 < len__29312__auto___69157)){
args__29319__auto__.push((arguments[i__29313__auto___69158]));

var G__69159 = (i__29313__auto___69158 + (1));
i__29313__auto___69158 = G__69159;
continue;
} else {
}
break;
}

var argseq__29320__auto__ = ((((0) < args__29319__auto__.length))?(new cljs.core.IndexedSeq(args__29319__auto__.slice((0)),(0),null)):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__29320__auto__);
});

sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__28949__auto__ = (function sablono$core$iter__69146(s__69147){
return (new cljs.core.LazySeq(null,(function (){
var s__69147__$1 = s__69147;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__69147__$1);
if(temp__4657__auto__){
var s__69147__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__69147__$2)){
var c__28947__auto__ = cljs.core.chunk_first.call(null,s__69147__$2);
var size__28948__auto__ = cljs.core.count.call(null,c__28947__auto__);
var b__69149 = cljs.core.chunk_buffer.call(null,size__28948__auto__);
if((function (){var i__69148 = (0);
while(true){
if((i__69148 < size__28948__auto__)){
var style = cljs.core._nth.call(null,c__28947__auto__,i__69148);
cljs.core.chunk_append.call(null,b__69149,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null));

var G__69161 = (i__69148 + (1));
i__69148 = G__69161;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__69149),sablono$core$iter__69146.call(null,cljs.core.chunk_rest.call(null,s__69147__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__69149),null);
}
} else {
var style = cljs.core.first.call(null,s__69147__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null),sablono$core$iter__69146.call(null,cljs.core.rest.call(null,s__69147__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__28949__auto__.call(null,styles);
});

sablono.core.include_css.cljs$lang$maxFixedArity = (0);

sablono.core.include_css.cljs$lang$applyTo = (function (seq69142){
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq69142));
});

/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
return goog.dom.appendChild(goog.dom.getDocument().body,goog.dom.createDom("script",({"src": src})));
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js.call(null,"http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to69167 = (function sablono$core$link_to69167(var_args){
var args__29319__auto__ = [];
var len__29312__auto___69173 = arguments.length;
var i__29313__auto___69174 = (0);
while(true){
if((i__29313__auto___69174 < len__29312__auto___69173)){
args__29319__auto__.push((arguments[i__29313__auto___69174]));

var G__69175 = (i__29313__auto___69174 + (1));
i__29313__auto___69174 = G__69175;
continue;
} else {
}
break;
}

var argseq__29320__auto__ = ((((1) < args__29319__auto__.length))?(new cljs.core.IndexedSeq(args__29319__auto__.slice((1)),(0),null)):null);
return sablono.core.link_to69167.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29320__auto__);
});

sablono.core.link_to69167.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,url)], null),content], null);
});

sablono.core.link_to69167.cljs$lang$maxFixedArity = (1);

sablono.core.link_to69167.cljs$lang$applyTo = (function (seq69168){
var G__69169 = cljs.core.first.call(null,seq69168);
var seq69168__$1 = cljs.core.next.call(null,seq69168);
return sablono.core.link_to69167.cljs$core$IFn$_invoke$arity$variadic(G__69169,seq69168__$1);
});


sablono.core.link_to = sablono.core.wrap_attrs.call(null,sablono.core.link_to69167);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to69176 = (function sablono$core$mail_to69176(var_args){
var args__29319__auto__ = [];
var len__29312__auto___69183 = arguments.length;
var i__29313__auto___69184 = (0);
while(true){
if((i__29313__auto___69184 < len__29312__auto___69183)){
args__29319__auto__.push((arguments[i__29313__auto___69184]));

var G__69185 = (i__29313__auto___69184 + (1));
i__29313__auto___69184 = G__69185;
continue;
} else {
}
break;
}

var argseq__29320__auto__ = ((((1) < args__29319__auto__.length))?(new cljs.core.IndexedSeq(args__29319__auto__.slice((1)),(0),null)):null);
return sablono.core.mail_to69176.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29320__auto__);
});

sablono.core.mail_to69176.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__69179){
var vec__69180 = p__69179;
var content = cljs.core.nth.call(null,vec__69180,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),["mailto:",cljs.core.str.cljs$core$IFn$_invoke$arity$1(e_mail)].join('')], null),(function (){var or__28141__auto__ = content;
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
return e_mail;
}
})()], null);
});

sablono.core.mail_to69176.cljs$lang$maxFixedArity = (1);

sablono.core.mail_to69176.cljs$lang$applyTo = (function (seq69177){
var G__69178 = cljs.core.first.call(null,seq69177);
var seq69177__$1 = cljs.core.next.call(null,seq69177);
return sablono.core.mail_to69176.cljs$core$IFn$_invoke$arity$variadic(G__69178,seq69177__$1);
});


sablono.core.mail_to = sablono.core.wrap_attrs.call(null,sablono.core.mail_to69176);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list69189 = (function sablono$core$unordered_list69189(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),(function (){var iter__28949__auto__ = (function sablono$core$unordered_list69189_$_iter__69190(s__69191){
return (new cljs.core.LazySeq(null,(function (){
var s__69191__$1 = s__69191;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__69191__$1);
if(temp__4657__auto__){
var s__69191__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__69191__$2)){
var c__28947__auto__ = cljs.core.chunk_first.call(null,s__69191__$2);
var size__28948__auto__ = cljs.core.count.call(null,c__28947__auto__);
var b__69193 = cljs.core.chunk_buffer.call(null,size__28948__auto__);
if((function (){var i__69192 = (0);
while(true){
if((i__69192 < size__28948__auto__)){
var x = cljs.core._nth.call(null,c__28947__auto__,i__69192);
cljs.core.chunk_append.call(null,b__69193,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__69195 = (i__69192 + (1));
i__69192 = G__69195;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__69193),sablono$core$unordered_list69189_$_iter__69190.call(null,cljs.core.chunk_rest.call(null,s__69191__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__69193),null);
}
} else {
var x = cljs.core.first.call(null,s__69191__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$unordered_list69189_$_iter__69190.call(null,cljs.core.rest.call(null,s__69191__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__28949__auto__.call(null,coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs.call(null,sablono.core.unordered_list69189);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list69197 = (function sablono$core$ordered_list69197(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ol","ol",932524051),(function (){var iter__28949__auto__ = (function sablono$core$ordered_list69197_$_iter__69198(s__69199){
return (new cljs.core.LazySeq(null,(function (){
var s__69199__$1 = s__69199;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__69199__$1);
if(temp__4657__auto__){
var s__69199__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__69199__$2)){
var c__28947__auto__ = cljs.core.chunk_first.call(null,s__69199__$2);
var size__28948__auto__ = cljs.core.count.call(null,c__28947__auto__);
var b__69201 = cljs.core.chunk_buffer.call(null,size__28948__auto__);
if((function (){var i__69200 = (0);
while(true){
if((i__69200 < size__28948__auto__)){
var x = cljs.core._nth.call(null,c__28947__auto__,i__69200);
cljs.core.chunk_append.call(null,b__69201,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__69208 = (i__69200 + (1));
i__69200 = G__69208;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__69201),sablono$core$ordered_list69197_$_iter__69198.call(null,cljs.core.chunk_rest.call(null,s__69199__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__69201),null);
}
} else {
var x = cljs.core.first.call(null,s__69199__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$ordered_list69197_$_iter__69198.call(null,cljs.core.rest.call(null,s__69199__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__28949__auto__.call(null,coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs.call(null,sablono.core.ordered_list69197);
/**
 * Create an image element.
 */
sablono.core.image69209 = (function sablono$core$image69209(var_args){
var G__69211 = arguments.length;
switch (G__69211) {
case 1:
return sablono.core.image69209.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image69209.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.image69209.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src)], null)], null);
});

sablono.core.image69209.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src),new cljs.core.Keyword(null,"alt","alt",-3214426),alt], null)], null);
});

sablono.core.image69209.cljs$lang$maxFixedArity = 2;


sablono.core.image = sablono.core.wrap_attrs.call(null,sablono.core.image69209);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.call(null,(function (p1__69216_SHARP_,p2__69217_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__69216_SHARP_),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p2__69217_SHARP_),"]"].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.call(null,(function (p1__69223_SHARP_,p2__69224_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__69223_SHARP_),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p2__69224_SHARP_)].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__28141__auto__ = value;
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
return undefined;
}
})()], null)], null);
});
/**
 * Creates a color input field.
 */
sablono.core.color_field69231 = (function sablono$core$color_field69231(var_args){
var G__69234 = arguments.length;
switch (G__69234) {
case 1:
return sablono.core.color_field69231.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field69231.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.color_field69231.cljs$core$IFn$_invoke$arity$1 = (function (name__69102__auto__){
return sablono.core.color_field69231.call(null,name__69102__auto__,null);
});

sablono.core.color_field69231.cljs$core$IFn$_invoke$arity$2 = (function (name__69102__auto__,value__69103__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"color","color",-1642760596,null))].join(''),name__69102__auto__,value__69103__auto__);
});

sablono.core.color_field69231.cljs$lang$maxFixedArity = 2;


sablono.core.color_field = sablono.core.wrap_attrs.call(null,sablono.core.color_field69231);

/**
 * Creates a date input field.
 */
sablono.core.date_field69241 = (function sablono$core$date_field69241(var_args){
var G__69243 = arguments.length;
switch (G__69243) {
case 1:
return sablono.core.date_field69241.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field69241.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.date_field69241.cljs$core$IFn$_invoke$arity$1 = (function (name__69102__auto__){
return sablono.core.date_field69241.call(null,name__69102__auto__,null);
});

sablono.core.date_field69241.cljs$core$IFn$_invoke$arity$2 = (function (name__69102__auto__,value__69103__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"date","date",177097065,null))].join(''),name__69102__auto__,value__69103__auto__);
});

sablono.core.date_field69241.cljs$lang$maxFixedArity = 2;


sablono.core.date_field = sablono.core.wrap_attrs.call(null,sablono.core.date_field69241);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field69246 = (function sablono$core$datetime_field69246(var_args){
var G__69249 = arguments.length;
switch (G__69249) {
case 1:
return sablono.core.datetime_field69246.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field69246.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.datetime_field69246.cljs$core$IFn$_invoke$arity$1 = (function (name__69102__auto__){
return sablono.core.datetime_field69246.call(null,name__69102__auto__,null);
});

sablono.core.datetime_field69246.cljs$core$IFn$_invoke$arity$2 = (function (name__69102__auto__,value__69103__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null))].join(''),name__69102__auto__,value__69103__auto__);
});

sablono.core.datetime_field69246.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_field69246);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field69257 = (function sablono$core$datetime_local_field69257(var_args){
var G__69259 = arguments.length;
switch (G__69259) {
case 1:
return sablono.core.datetime_local_field69257.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field69257.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.datetime_local_field69257.cljs$core$IFn$_invoke$arity$1 = (function (name__69102__auto__){
return sablono.core.datetime_local_field69257.call(null,name__69102__auto__,null);
});

sablono.core.datetime_local_field69257.cljs$core$IFn$_invoke$arity$2 = (function (name__69102__auto__,value__69103__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null))].join(''),name__69102__auto__,value__69103__auto__);
});

sablono.core.datetime_local_field69257.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_local_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_local_field69257);

/**
 * Creates a email input field.
 */
sablono.core.email_field69261 = (function sablono$core$email_field69261(var_args){
var G__69264 = arguments.length;
switch (G__69264) {
case 1:
return sablono.core.email_field69261.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field69261.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.email_field69261.cljs$core$IFn$_invoke$arity$1 = (function (name__69102__auto__){
return sablono.core.email_field69261.call(null,name__69102__auto__,null);
});

sablono.core.email_field69261.cljs$core$IFn$_invoke$arity$2 = (function (name__69102__auto__,value__69103__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"email","email",-1238619063,null))].join(''),name__69102__auto__,value__69103__auto__);
});

sablono.core.email_field69261.cljs$lang$maxFixedArity = 2;


sablono.core.email_field = sablono.core.wrap_attrs.call(null,sablono.core.email_field69261);

/**
 * Creates a file input field.
 */
sablono.core.file_field69268 = (function sablono$core$file_field69268(var_args){
var G__69270 = arguments.length;
switch (G__69270) {
case 1:
return sablono.core.file_field69268.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field69268.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.file_field69268.cljs$core$IFn$_invoke$arity$1 = (function (name__69102__auto__){
return sablono.core.file_field69268.call(null,name__69102__auto__,null);
});

sablono.core.file_field69268.cljs$core$IFn$_invoke$arity$2 = (function (name__69102__auto__,value__69103__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"file","file",370885649,null))].join(''),name__69102__auto__,value__69103__auto__);
});

sablono.core.file_field69268.cljs$lang$maxFixedArity = 2;


sablono.core.file_field = sablono.core.wrap_attrs.call(null,sablono.core.file_field69268);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field69271 = (function sablono$core$hidden_field69271(var_args){
var G__69273 = arguments.length;
switch (G__69273) {
case 1:
return sablono.core.hidden_field69271.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field69271.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.hidden_field69271.cljs$core$IFn$_invoke$arity$1 = (function (name__69102__auto__){
return sablono.core.hidden_field69271.call(null,name__69102__auto__,null);
});

sablono.core.hidden_field69271.cljs$core$IFn$_invoke$arity$2 = (function (name__69102__auto__,value__69103__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null))].join(''),name__69102__auto__,value__69103__auto__);
});

sablono.core.hidden_field69271.cljs$lang$maxFixedArity = 2;


sablono.core.hidden_field = sablono.core.wrap_attrs.call(null,sablono.core.hidden_field69271);

/**
 * Creates a month input field.
 */
sablono.core.month_field69281 = (function sablono$core$month_field69281(var_args){
var G__69283 = arguments.length;
switch (G__69283) {
case 1:
return sablono.core.month_field69281.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field69281.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.month_field69281.cljs$core$IFn$_invoke$arity$1 = (function (name__69102__auto__){
return sablono.core.month_field69281.call(null,name__69102__auto__,null);
});

sablono.core.month_field69281.cljs$core$IFn$_invoke$arity$2 = (function (name__69102__auto__,value__69103__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"month","month",-319717006,null))].join(''),name__69102__auto__,value__69103__auto__);
});

sablono.core.month_field69281.cljs$lang$maxFixedArity = 2;


sablono.core.month_field = sablono.core.wrap_attrs.call(null,sablono.core.month_field69281);

/**
 * Creates a number input field.
 */
sablono.core.number_field69285 = (function sablono$core$number_field69285(var_args){
var G__69287 = arguments.length;
switch (G__69287) {
case 1:
return sablono.core.number_field69285.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field69285.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.number_field69285.cljs$core$IFn$_invoke$arity$1 = (function (name__69102__auto__){
return sablono.core.number_field69285.call(null,name__69102__auto__,null);
});

sablono.core.number_field69285.cljs$core$IFn$_invoke$arity$2 = (function (name__69102__auto__,value__69103__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"number","number",-1084057331,null))].join(''),name__69102__auto__,value__69103__auto__);
});

sablono.core.number_field69285.cljs$lang$maxFixedArity = 2;


sablono.core.number_field = sablono.core.wrap_attrs.call(null,sablono.core.number_field69285);

/**
 * Creates a password input field.
 */
sablono.core.password_field69288 = (function sablono$core$password_field69288(var_args){
var G__69290 = arguments.length;
switch (G__69290) {
case 1:
return sablono.core.password_field69288.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field69288.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.password_field69288.cljs$core$IFn$_invoke$arity$1 = (function (name__69102__auto__){
return sablono.core.password_field69288.call(null,name__69102__auto__,null);
});

sablono.core.password_field69288.cljs$core$IFn$_invoke$arity$2 = (function (name__69102__auto__,value__69103__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"password","password",2057553998,null))].join(''),name__69102__auto__,value__69103__auto__);
});

sablono.core.password_field69288.cljs$lang$maxFixedArity = 2;


sablono.core.password_field = sablono.core.wrap_attrs.call(null,sablono.core.password_field69288);

/**
 * Creates a range input field.
 */
sablono.core.range_field69291 = (function sablono$core$range_field69291(var_args){
var G__69293 = arguments.length;
switch (G__69293) {
case 1:
return sablono.core.range_field69291.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field69291.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.range_field69291.cljs$core$IFn$_invoke$arity$1 = (function (name__69102__auto__){
return sablono.core.range_field69291.call(null,name__69102__auto__,null);
});

sablono.core.range_field69291.cljs$core$IFn$_invoke$arity$2 = (function (name__69102__auto__,value__69103__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"range","range",-1014743483,null))].join(''),name__69102__auto__,value__69103__auto__);
});

sablono.core.range_field69291.cljs$lang$maxFixedArity = 2;


sablono.core.range_field = sablono.core.wrap_attrs.call(null,sablono.core.range_field69291);

/**
 * Creates a search input field.
 */
sablono.core.search_field69294 = (function sablono$core$search_field69294(var_args){
var G__69296 = arguments.length;
switch (G__69296) {
case 1:
return sablono.core.search_field69294.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field69294.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.search_field69294.cljs$core$IFn$_invoke$arity$1 = (function (name__69102__auto__){
return sablono.core.search_field69294.call(null,name__69102__auto__,null);
});

sablono.core.search_field69294.cljs$core$IFn$_invoke$arity$2 = (function (name__69102__auto__,value__69103__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"search","search",-1089495947,null))].join(''),name__69102__auto__,value__69103__auto__);
});

sablono.core.search_field69294.cljs$lang$maxFixedArity = 2;


sablono.core.search_field = sablono.core.wrap_attrs.call(null,sablono.core.search_field69294);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field69297 = (function sablono$core$tel_field69297(var_args){
var G__69299 = arguments.length;
switch (G__69299) {
case 1:
return sablono.core.tel_field69297.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field69297.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.tel_field69297.cljs$core$IFn$_invoke$arity$1 = (function (name__69102__auto__){
return sablono.core.tel_field69297.call(null,name__69102__auto__,null);
});

sablono.core.tel_field69297.cljs$core$IFn$_invoke$arity$2 = (function (name__69102__auto__,value__69103__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"tel","tel",1864669686,null))].join(''),name__69102__auto__,value__69103__auto__);
});

sablono.core.tel_field69297.cljs$lang$maxFixedArity = 2;


sablono.core.tel_field = sablono.core.wrap_attrs.call(null,sablono.core.tel_field69297);

/**
 * Creates a text input field.
 */
sablono.core.text_field69305 = (function sablono$core$text_field69305(var_args){
var G__69307 = arguments.length;
switch (G__69307) {
case 1:
return sablono.core.text_field69305.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field69305.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.text_field69305.cljs$core$IFn$_invoke$arity$1 = (function (name__69102__auto__){
return sablono.core.text_field69305.call(null,name__69102__auto__,null);
});

sablono.core.text_field69305.cljs$core$IFn$_invoke$arity$2 = (function (name__69102__auto__,value__69103__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"text","text",-150030170,null))].join(''),name__69102__auto__,value__69103__auto__);
});

sablono.core.text_field69305.cljs$lang$maxFixedArity = 2;


sablono.core.text_field = sablono.core.wrap_attrs.call(null,sablono.core.text_field69305);

/**
 * Creates a time input field.
 */
sablono.core.time_field69308 = (function sablono$core$time_field69308(var_args){
var G__69311 = arguments.length;
switch (G__69311) {
case 1:
return sablono.core.time_field69308.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field69308.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.time_field69308.cljs$core$IFn$_invoke$arity$1 = (function (name__69102__auto__){
return sablono.core.time_field69308.call(null,name__69102__auto__,null);
});

sablono.core.time_field69308.cljs$core$IFn$_invoke$arity$2 = (function (name__69102__auto__,value__69103__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"time","time",-1268547887,null))].join(''),name__69102__auto__,value__69103__auto__);
});

sablono.core.time_field69308.cljs$lang$maxFixedArity = 2;


sablono.core.time_field = sablono.core.wrap_attrs.call(null,sablono.core.time_field69308);

/**
 * Creates a url input field.
 */
sablono.core.url_field69313 = (function sablono$core$url_field69313(var_args){
var G__69317 = arguments.length;
switch (G__69317) {
case 1:
return sablono.core.url_field69313.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field69313.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.url_field69313.cljs$core$IFn$_invoke$arity$1 = (function (name__69102__auto__){
return sablono.core.url_field69313.call(null,name__69102__auto__,null);
});

sablono.core.url_field69313.cljs$core$IFn$_invoke$arity$2 = (function (name__69102__auto__,value__69103__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"url","url",1916828573,null))].join(''),name__69102__auto__,value__69103__auto__);
});

sablono.core.url_field69313.cljs$lang$maxFixedArity = 2;


sablono.core.url_field = sablono.core.wrap_attrs.call(null,sablono.core.url_field69313);

/**
 * Creates a week input field.
 */
sablono.core.week_field69320 = (function sablono$core$week_field69320(var_args){
var G__69325 = arguments.length;
switch (G__69325) {
case 1:
return sablono.core.week_field69320.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field69320.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.week_field69320.cljs$core$IFn$_invoke$arity$1 = (function (name__69102__auto__){
return sablono.core.week_field69320.call(null,name__69102__auto__,null);
});

sablono.core.week_field69320.cljs$core$IFn$_invoke$arity$2 = (function (name__69102__auto__,value__69103__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"week","week",314058249,null))].join(''),name__69102__auto__,value__69103__auto__);
});

sablono.core.week_field69320.cljs$lang$maxFixedArity = 2;


sablono.core.week_field = sablono.core.wrap_attrs.call(null,sablono.core.week_field69320);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box69378 = (function sablono$core$check_box69378(var_args){
var G__69380 = arguments.length;
switch (G__69380) {
case 1:
return sablono.core.check_box69378.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box69378.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box69378.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.check_box69378.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.check_box69378.call(null,name,null);
});

sablono.core.check_box69378.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return sablono.core.check_box69378.call(null,name,checked_QMARK_,"true");
});

sablono.core.check_box69378.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__28141__auto__ = value;
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
return undefined;
}
})(),new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.check_box69378.cljs$lang$maxFixedArity = 3;


sablono.core.check_box = sablono.core.wrap_attrs.call(null,sablono.core.check_box69378);
/**
 * Creates a radio button.
 */
sablono.core.radio_button69390 = (function sablono$core$radio_button69390(var_args){
var G__69392 = arguments.length;
switch (G__69392) {
case 1:
return sablono.core.radio_button69390.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button69390.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button69390.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.radio_button69390.cljs$core$IFn$_invoke$arity$1 = (function (group){
return sablono.core.radio_button69390.call(null,group,null);
});

sablono.core.radio_button69390.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return sablono.core.radio_button69390.call(null,group,checked_QMARK_,"true");
});

sablono.core.radio_button69390.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(sablono.util.as_str.call(null,group)),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(sablono.util.as_str.call(null,value))].join('')),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__28141__auto__ = value;
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
return undefined;
}
})(),new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.radio_button69390.cljs$lang$maxFixedArity = 3;


sablono.core.radio_button = sablono.core.wrap_attrs.call(null,sablono.core.radio_button69390);
sablono.core.hash_key = (function sablono$core$hash_key(x){
return goog.string.hashCode(cljs.core.pr_str.call(null,x));
});
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options69419 = (function sablono$core$select_options69419(coll){
var iter__28949__auto__ = (function sablono$core$select_options69419_$_iter__69420(s__69421){
return (new cljs.core.LazySeq(null,(function (){
var s__69421__$1 = s__69421;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__69421__$1);
if(temp__4657__auto__){
var s__69421__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__69421__$2)){
var c__28947__auto__ = cljs.core.chunk_first.call(null,s__69421__$2);
var size__28948__auto__ = cljs.core.count.call(null,c__28947__auto__);
var b__69423 = cljs.core.chunk_buffer.call(null,size__28948__auto__);
if((function (){var i__69422 = (0);
while(true){
if((i__69422 < size__28948__auto__)){
var x = cljs.core._nth.call(null,c__28947__auto__,i__69422);
cljs.core.chunk_append.call(null,b__69423,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__69430 = x;
var text = cljs.core.nth.call(null,vec__69430,(0),null);
var val = cljs.core.nth.call(null,vec__69430,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__69430,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono.core.select_options69419.call(null,val)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)));

var G__69450 = (i__69422 + (1));
i__69422 = G__69450;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__69423),sablono$core$select_options69419_$_iter__69420.call(null,cljs.core.chunk_rest.call(null,s__69421__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__69423),null);
}
} else {
var x = cljs.core.first.call(null,s__69421__$2);
return cljs.core.cons.call(null,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__69435 = x;
var text = cljs.core.nth.call(null,vec__69435,(0),null);
var val = cljs.core.nth.call(null,vec__69435,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__69435,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono.core.select_options69419.call(null,val)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)),sablono$core$select_options69419_$_iter__69420.call(null,cljs.core.rest.call(null,s__69421__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__28949__auto__.call(null,coll);
});

sablono.core.select_options = sablono.core.wrap_attrs.call(null,sablono.core.select_options69419);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down69452 = (function sablono$core$drop_down69452(var_args){
var G__69454 = arguments.length;
switch (G__69454) {
case 2:
return sablono.core.drop_down69452.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down69452.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.drop_down69452.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down69452.call(null,name,options,null);
});

sablono.core.drop_down69452.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name)], null),sablono.core.select_options.call(null,options,selected)], null);
});

sablono.core.drop_down69452.cljs$lang$maxFixedArity = 3;


sablono.core.drop_down = sablono.core.wrap_attrs.call(null,sablono.core.drop_down69452);
/**
 * Creates a text area element.
 */
sablono.core.text_area69465 = (function sablono$core$text_area69465(var_args){
var G__69467 = arguments.length;
switch (G__69467) {
case 1:
return sablono.core.text_area69465.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area69465.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.text_area69465.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.text_area69465.call(null,name,null);
});

sablono.core.text_area69465.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__28141__auto__ = value;
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
return undefined;
}
})()], null)], null);
});

sablono.core.text_area69465.cljs$lang$maxFixedArity = 2;


sablono.core.text_area = sablono.core.wrap_attrs.call(null,sablono.core.text_area69465);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label69481 = (function sablono$core$label69481(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"htmlFor","htmlFor",-1050291720),sablono.core.make_id.call(null,name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs.call(null,sablono.core.label69481);
/**
 * Creates a submit button.
 */
sablono.core.submit_button69482 = (function sablono$core$submit_button69482(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"submit",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs.call(null,sablono.core.submit_button69482);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button69487 = (function sablono$core$reset_button69487(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"reset",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs.call(null,sablono.core.reset_button69487);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to69490 = (function sablono$core$form_to69490(var_args){
var args__29319__auto__ = [];
var len__29312__auto___69513 = arguments.length;
var i__29313__auto___69515 = (0);
while(true){
if((i__29313__auto___69515 < len__29312__auto___69513)){
args__29319__auto__.push((arguments[i__29313__auto___69515]));

var G__69518 = (i__29313__auto___69515 + (1));
i__29313__auto___69515 = G__69518;
continue;
} else {
}
break;
}

var argseq__29320__auto__ = ((((1) < args__29319__auto__.length))?(new cljs.core.IndexedSeq(args__29319__auto__.slice((1)),(0),null)):null);
return sablono.core.form_to69490.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29320__auto__);
});

sablono.core.form_to69490.cljs$core$IFn$_invoke$arity$variadic = (function (p__69499,body){
var vec__69500 = p__69499;
var method = cljs.core.nth.call(null,vec__69500,(0),null);
var action = cljs.core.nth.call(null,vec__69500,(1),null);
var method_str = clojure.string.upper_case.call(null,cljs.core.name.call(null,method));
var action_uri = sablono.util.to_uri.call(null,action);
return cljs.core.vec.call(null,cljs.core.concat.call(null,((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"get","get",1683182755),null,new cljs.core.Keyword(null,"post","post",269697687),null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),method_str,new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),"POST",new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null),sablono.core.hidden_field.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),(3735928559)], null),"_method",method_str)], null)),body));
});

sablono.core.form_to69490.cljs$lang$maxFixedArity = (1);

sablono.core.form_to69490.cljs$lang$applyTo = (function (seq69491){
var G__69492 = cljs.core.first.call(null,seq69491);
var seq69491__$1 = cljs.core.next.call(null,seq69491);
return sablono.core.form_to69490.cljs$core$IFn$_invoke$arity$variadic(G__69492,seq69491__$1);
});


sablono.core.form_to = sablono.core.wrap_attrs.call(null,sablono.core.form_to69490);

//# sourceMappingURL=core.js.map?rel=1511229581106
