// Compiled by ClojureScript 1.9.946 {}
goog.provide('fulcro_css.css');
goog.require('cljs.core');
goog.require('cljs.tagged_literals');
goog.require('clojure.string');
goog.require('com.rpl.specter');
goog.require('om.next');
goog.require('garden.core');
goog.require('garden.selectors');
goog.require('cljs.core');
goog.require('fulcro_css.core');

/**
 * @interface
 */
fulcro_css.css.CSS = function(){};

/**
 * Specifies the component's local CSS rules
 */
fulcro_css.css.local_rules = (function fulcro_css$css$local_rules(this$){
if((!((this$ == null))) && (!((this$.fulcro_css$css$CSS$local_rules$arity$1 == null)))){
return this$.fulcro_css$css$CSS$local_rules$arity$1(this$);
} else {
var x__28824__auto__ = (((this$ == null))?null:this$);
var m__28825__auto__ = (fulcro_css.css.local_rules[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,this$);
} else {
var m__28825__auto____$1 = (fulcro_css.css.local_rules["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"CSS.local-rules",this$);
}
}
}
});

/**
 * Specifies the components (typically direct children) whose CSS should be included.
 */
fulcro_css.css.include_children = (function fulcro_css$css$include_children(this$){
if((!((this$ == null))) && (!((this$.fulcro_css$css$CSS$include_children$arity$1 == null)))){
return this$.fulcro_css$css$CSS$include_children$arity$1(this$);
} else {
var x__28824__auto__ = (((this$ == null))?null:this$);
var m__28825__auto__ = (fulcro_css.css.include_children[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,this$);
} else {
var m__28825__auto____$1 = (fulcro_css.css.include_children["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"CSS.include-children",this$);
}
}
}
});


/**
 * @interface
 */
fulcro_css.css.Global = function(){};

/**
 * Specifies the component's global CSS rules
 */
fulcro_css.css.global_rules = (function fulcro_css$css$global_rules(this$){
if((!((this$ == null))) && (!((this$.fulcro_css$css$Global$global_rules$arity$1 == null)))){
return this$.fulcro_css$css$Global$global_rules$arity$1(this$);
} else {
var x__28824__auto__ = (((this$ == null))?null:this$);
var m__28825__auto__ = (fulcro_css.css.global_rules[goog.typeOf(x__28824__auto__)]);
if(!((m__28825__auto__ == null))){
return m__28825__auto__.call(null,this$);
} else {
var m__28825__auto____$1 = (fulcro_css.css.global_rules["_"]);
if(!((m__28825__auto____$1 == null))){
return m__28825__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"Global.global-rules",this$);
}
}
}
});

/**
 * Returns true if the given component has css
 */
fulcro_css.css.CSS_QMARK_ = (function fulcro_css$css$CSS_QMARK_(x){
if(!((x == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === x.fulcro_css$css$CSS$))){
return true;
} else {
return false;
}
} else {
return false;
}
});
/**
 * Returns true if the component has global rules
 */
fulcro_css.css.Global_QMARK_ = (function fulcro_css$css$Global_QMARK_(x){
if(!((x == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === x.fulcro_css$css$Global$))){
return true;
} else {
return false;
}
} else {
return false;
}
});
/**
 * Get the *raw* value from the global-rules of a component.
 */
fulcro_css.css.get_global_rules = (function fulcro_css$css$get_global_rules(component){
if(cljs.core.truth_(fulcro_css.css.Global_QMARK_.call(null,component))){
return fulcro_css.css.global_rules.call(null,component);
} else {
return cljs.core.PersistentVector.EMPTY;
}
});
/**
 * Get the *raw* value from the local-rules of a component.
 */
fulcro_css.css.get_local_rules = (function fulcro_css$css$get_local_rules(component){
if(cljs.core.truth_(fulcro_css.css.CSS_QMARK_.call(null,component))){
return fulcro_css.css.local_rules.call(null,component);
} else {
return cljs.core.PersistentVector.EMPTY;
}
});
/**
 * Returns true if the given string starts with one of [. $ &$ &.]
 */
fulcro_css.css.prefixed_name_QMARK_ = (function fulcro_css$css$prefixed_name_QMARK_(nm){
return !((cljs.core.re_matches.call(null,/(\.|\$|&\.|&\$).*/,nm) == null));
});
/**
 * Returns the prefix of a string. [. $ &$ &.]
 */
fulcro_css.css.get_prefix = (function fulcro_css$css$get_prefix(nm){
var vec__83986 = cljs.core.re_matches.call(null,/(\.|\$|&\.|&\$).*/,nm);
var _ = cljs.core.nth.call(null,vec__83986,(0),null);
var prefix = cljs.core.nth.call(null,vec__83986,(1),null);
return prefix;
});
/**
 * Returns true if the given keyword starts with one of [. $ &$ &.]
 */
fulcro_css.css.prefixed_keyword_QMARK_ = (function fulcro_css$css$prefixed_keyword_QMARK_(kw){
var and__28129__auto__ = (kw instanceof cljs.core.Keyword);
if(and__28129__auto__){
return fulcro_css.css.prefixed_name_QMARK_.call(null,cljs.core.name.call(null,kw));
} else {
return and__28129__auto__;
}
});
/**
 * Removes the prefix of a string.
 */
fulcro_css.css.remove_prefix = (function fulcro_css$css$remove_prefix(nm){
return cljs.core.subs.call(null,nm,cljs.core.count.call(null,fulcro_css.css.get_prefix.call(null,nm)));
});
/**
 * Removes the prefix of a keyword.
 */
fulcro_css.css.remove_prefix_kw = (function fulcro_css$css$remove_prefix_kw(kw){
return cljs.core.keyword.call(null,fulcro_css.css.remove_prefix.call(null,cljs.core.name.call(null,kw)));
});
/**
 * Returns the list of components from the include-children method of a component
 */
fulcro_css.css.get_includes = (function fulcro_css$css$get_includes(component){
if(cljs.core.truth_(fulcro_css.css.CSS_QMARK_.call(null,component))){
return fulcro_css.css.include_children.call(null,component);
} else {
return cljs.core.PersistentVector.EMPTY;
}
});
/**
 * Recursively finds all includes starting at the given component.
 */
fulcro_css.css.get_nested_includes = (function fulcro_css$css$get_nested_includes(component){
var direct_children = fulcro_css.css.get_includes.call(null,component);
if(cljs.core.empty_QMARK_.call(null,direct_children)){
return cljs.core.PersistentVector.EMPTY;
} else {
return cljs.core.concat.call(null,direct_children,cljs.core.reduce.call(null,((function (direct_children){
return (function (p1__84000_SHARP_,p2__84001_SHARP_){
return cljs.core.concat.call(null,p1__84000_SHARP_,fulcro_css.css.get_nested_includes.call(null,p2__84001_SHARP_));
});})(direct_children))
,cljs.core.PersistentVector.EMPTY,direct_children));
}
});
fulcro_css.css.localize_name = (function fulcro_css$css$localize_name(nm,comp){
var no_prefix = fulcro_css.css.remove_prefix.call(null,nm);
var prefix = fulcro_css.css.get_prefix.call(null,nm);
var G__84002 = prefix;
switch (G__84002) {
case ".":
case "&.":
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefix),cljs.core.str.cljs$core$IFn$_invoke$arity$1(fulcro_css.core.local_class.call(null,comp,cljs.core.keyword.call(null,no_prefix)))].join('');

break;
case "$":
return [".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(no_prefix)].join('');

break;
case "&$":
return ["&.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(no_prefix)].join('');

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__84002)].join('')));

}
});
fulcro_css.css.localize_kw = (function fulcro_css$css$localize_kw(kw,comp){
return cljs.core.keyword.call(null,fulcro_css.css.localize_name.call(null,cljs.core.name.call(null,kw),comp));
});
/**
 * Gives the localized classname for the given keyword.
 */
fulcro_css.css.local_class = (function fulcro_css$css$local_class(comp,kw){
var nm = cljs.core.name.call(null,kw);
var prefix = fulcro_css.css.get_prefix.call(null,nm);
var no_prefix = cljs.core.subs.call(null,nm,cljs.core.count.call(null,prefix));
var G__84010 = prefix;
switch (G__84010) {
case "$":
case "&$":
return no_prefix;

break;
case ".":
case "&.":
return fulcro_css.core.local_class.call(null,comp,no_prefix);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__84010)].join('')));

}
});
fulcro_css.css.selector_QMARK_ = (function fulcro_css$css$selector_QMARK_(x){
return cljs.core._EQ_.call(null,garden.selectors.CSSSelector,cljs.core.type.call(null,x));
});
fulcro_css.css.localize_selector = (function fulcro_css$css$localize_selector(selector,comp){
var val = new cljs.core.Keyword(null,"selector","selector",762528866).cljs$core$IFn$_invoke$arity$1(selector);
var split_cns_selectors = clojure.string.split.call(null,val,/ /);
return garden.selectors.selector.call(null,clojure.string.join.call(null," ",cljs.core.map.call(null,((function (val,split_cns_selectors){
return (function (p1__84013_SHARP_){
if(cljs.core.truth_(fulcro_css.css.prefixed_name_QMARK_.call(null,p1__84013_SHARP_))){
return fulcro_css.css.localize_name.call(null,p1__84013_SHARP_,comp);
} else {
return p1__84013_SHARP_;
}
});})(val,split_cns_selectors))
,split_cns_selectors)));
});
/**
 * Converts prefixed keywords into localized keywords and localizes the values of garden selectors
 */
fulcro_css.css.localize_css = (function fulcro_css$css$localize_css(component){
return com.rpl.specter.impl.compiled_transform_STAR_.call(null,(function (){var info__33353__auto__ = fulcro_css.css.pathcache84024;
var info__33353__auto____$1 = (((info__33353__auto__ == null))?(function (){var info84025 = com.rpl.specter.impl.magic_precompilation.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation.call(null,com.rpl.specter.impl.__GT_VarUse.call(null,com.rpl.specter.walker,new cljs.core.Var(function(){return com.rpl.specter.walker;},new cljs.core.Symbol("com.rpl.specter","walker","com.rpl.specter/walker",188203798,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"walker","walker",-1621010049,null),"resources/public/js/compiled/devcards_out/com/rpl/specter.cljc",9,1,1292,1296,cljs.core.List.EMPTY,"Navigate the data structure until reaching\n          a value for which `afn` returns truthy. Has\n          same semantics as clojure.walk.",(cljs.core.truth_(com.rpl.specter.walker)?com.rpl.specter.walker.cljs$lang$test:null)])),new cljs.core.Symbol("sp","walker","sp/walker",-1621005358,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_SpecialFormUse.call(null,((function (info__33353__auto__){
return (function (p1__84021_SHARP_){
var or__28141__auto__ = fulcro_css.css.prefixed_keyword_QMARK_.call(null,p1__84021_SHARP_);
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
return fulcro_css.css.selector_QMARK_.call(null,p1__84021_SHARP_);
}
});})(info__33353__auto__))
,cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__84021#","p1__84021#",1927044762,null)], null),cljs.core.list(new cljs.core.Symbol(null,"or","or",1876275696,null),cljs.core.list(new cljs.core.Symbol(null,"prefixed-keyword?","prefixed-keyword?",-408652323,null),new cljs.core.Symbol(null,"p1__84021#","p1__84021#",1927044762,null)),cljs.core.list(new cljs.core.Symbol(null,"selector?","selector?",-1157354552,null),new cljs.core.Symbol(null,"p1__84021#","p1__84021#",1927044762,null)))))], null),cljs.core.list(new cljs.core.Symbol("sp","walker","sp/walker",-1621005358,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__84021#","p1__84021#",1927044762,null)], null),cljs.core.list(new cljs.core.Symbol(null,"or","or",1876275696,null),cljs.core.list(new cljs.core.Symbol(null,"prefixed-keyword?","prefixed-keyword?",-408652323,null),new cljs.core.Symbol(null,"p1__84021#","p1__84021#",1927044762,null)),cljs.core.list(new cljs.core.Symbol(null,"selector?","selector?",-1157354552,null),new cljs.core.Symbol(null,"p1__84021#","p1__84021#",1927044762,null))))))], null),"fulcro-css.css",cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("sp","walker","sp/walker",-1621005358,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__84021#","p1__84021#",1927044762,null)], null),cljs.core.list(new cljs.core.Symbol(null,"or","or",1876275696,null),cljs.core.list(new cljs.core.Symbol(null,"prefixed-keyword?","prefixed-keyword?",-408652323,null),new cljs.core.Symbol(null,"p1__84021#","p1__84021#",1927044762,null)),cljs.core.list(new cljs.core.Symbol(null,"selector?","selector?",-1157354552,null),new cljs.core.Symbol(null,"p1__84021#","p1__84021#",1927044762,null))))], null));
fulcro_css.css.pathcache84024 = info84025;

return info84025;
})():info__33353__auto__);
var precompiled84026 = com.rpl.specter.impl.cached_path_info_precompiled.call(null,info__33353__auto____$1);
var dynamic_QMARK___33354__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_.call(null,info__33353__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___33354__auto__)){
return precompiled84026.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.walker,((function (info__33353__auto__,info__33353__auto____$1,precompiled84026,dynamic_QMARK___33354__auto__){
return (function (p1__84021_SHARP_){
var or__28141__auto__ = fulcro_css.css.prefixed_keyword_QMARK_.call(null,p1__84021_SHARP_);
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
return fulcro_css.css.selector_QMARK_.call(null,p1__84021_SHARP_);
}
});})(info__33353__auto__,info__33353__auto____$1,precompiled84026,dynamic_QMARK___33354__auto__))
], null));
} else {
return precompiled84026;
}
})(),(function (p1__84022_SHARP_){
if(cljs.core.truth_(fulcro_css.css.prefixed_keyword_QMARK_.call(null,p1__84022_SHARP_))){
return fulcro_css.css.localize_kw.call(null,p1__84022_SHARP_,component);
} else {
return fulcro_css.css.localize_selector.call(null,p1__84022_SHARP_,component);
}
}),fulcro_css.css.get_local_rules.call(null,component));
});
/**
 * Gets the local and global rules from the given component.
 */
fulcro_css.css.get_css_rules = (function fulcro_css$css$get_css_rules(component){
return cljs.core.concat.call(null,fulcro_css.css.localize_css.call(null,component),fulcro_css.css.get_global_rules.call(null,component));
});
/**
 * Recursively gets all global and localized rules (in garden notation) starting at the given component.
 */
fulcro_css.css.get_css = (function fulcro_css$css$get_css(component){
var own_rules = fulcro_css.css.get_css_rules.call(null,component);
var nested_children = cljs.core.distinct.call(null,fulcro_css.css.get_nested_includes.call(null,component));
var nested_children_rules = cljs.core.reduce.call(null,((function (own_rules,nested_children){
return (function (p1__84049_SHARP_,p2__84050_SHARP_){
return cljs.core.into.call(null,p1__84049_SHARP_,fulcro_css.css.get_css_rules.call(null,p2__84050_SHARP_));
});})(own_rules,nested_children))
,cljs.core.PersistentVector.EMPTY,nested_children);
return cljs.core.concat.call(null,own_rules,nested_children_rules);
});
/**
 * Gets all the keywords that are present in a selector
 */
fulcro_css.css.get_selector_keywords = (function fulcro_css$css$get_selector_keywords(selector){
var val = new cljs.core.Keyword(null,"selector","selector",762528866).cljs$core$IFn$_invoke$arity$1(selector);
var classnames = cljs.core.filter.call(null,((function (val){
return (function (p1__84057_SHARP_){
return cljs.core.re_matches.call(null,/[.$].*/,p1__84057_SHARP_);
});})(val))
,clojure.string.split.call(null,val,/ /));
return cljs.core.map.call(null,cljs.core.keyword,classnames);
});
/**
 * Gets all used classnames in from the given rules as keywords
 */
fulcro_css.css.get_class_keys = (function fulcro_css$css$get_class_keys(rules){
var flattened_rules = cljs.core.flatten.call(null,rules);
var selectors = cljs.core.filter.call(null,fulcro_css.css.selector_QMARK_,flattened_rules);
var prefixed_kws = cljs.core.filter.call(null,fulcro_css.css.prefixed_keyword_QMARK_,flattened_rules);
return cljs.core.distinct.call(null,cljs.core.concat.call(null,cljs.core.flatten.call(null,cljs.core.map.call(null,fulcro_css.css.get_selector_keywords,selectors)),prefixed_kws));
});
/**
 * Returns a map from user-given CSS rule names to fulcro-css localized names of the given component.
 */
fulcro_css.css.get_classnames = (function fulcro_css$css$get_classnames(comp){
var local_class_keys = fulcro_css.css.get_class_keys.call(null,fulcro_css.css.get_local_rules.call(null,comp));
var global_class_keys = cljs.core.map.call(null,fulcro_css.css.remove_prefix_kw,fulcro_css.css.get_class_keys.call(null,fulcro_css.css.get_global_rules.call(null,comp)));
var local_classnames = cljs.core.zipmap.call(null,cljs.core.map.call(null,fulcro_css.css.remove_prefix_kw,local_class_keys),cljs.core.map.call(null,((function (local_class_keys,global_class_keys){
return (function (p1__84062_SHARP_){
return fulcro_css.css.local_class.call(null,comp,p1__84062_SHARP_);
});})(local_class_keys,global_class_keys))
,local_class_keys));
var global_classnames = cljs.core.zipmap.call(null,global_class_keys,cljs.core.map.call(null,cljs.core.name,global_class_keys));
return cljs.core.merge.call(null,local_classnames,global_classnames);
});
/**
 * (Re)place the STYLE element with the provided ID on the document's DOM  with the co-located CSS of the specified component.
 */
fulcro_css.css.upsert_css = (function fulcro_css$css$upsert_css(id,root_component){
fulcro_css.core.remove_from_dom.call(null,id);

var style_ele = document.createElement("style");
style_ele.innerHTML = garden.core.css.call(null,fulcro_css.css.get_css.call(null,root_component));

style_ele.setAttribute("id",id);

return document.body.appendChild(style_ele);
});

//# sourceMappingURL=css.js.map?rel=1511229599863
