// Compiled by ClojureScript 1.9.946 {}
goog.provide('fulcro.inspect.helpers');
goog.require('cljs.core');
goog.require('fulcro.client.core');
goog.require('om.next');
/**
 * Integrate an ident into any number of places in the app state. This function is safe to use within mutation
 *   implementations as a general helper function.
 * 
 *   The named parameters can be specified any number of times. They are:
 * 
 *   - set: A vector (path) to a list in your app state where this new object's ident should be set.
 *   - append:  A vector (path) to a list in your app state where this new object's ident should be appended. Will not append
 *   the ident if that ident is already in the list.
 *   - prepend: A vector (path) to a list in your app state where this new object's ident should be prepended. Will not append
 *   the ident if that ident is already in the list.
 *   - replace: A vector (path) to a specific location in app-state where this object's ident should be placed. Can target a to-one or to-many.
 * If the target is a vector element then that element must already exist in the vector.
 */
fulcro.inspect.helpers.integrate_ident = (function fulcro$inspect$helpers$integrate_ident(var_args){
var args__29319__auto__ = [];
var len__29312__auto___307468 = arguments.length;
var i__29313__auto___307469 = (0);
while(true){
if((i__29313__auto___307469 < len__29312__auto___307468)){
args__29319__auto__.push((arguments[i__29313__auto___307469]));

var G__307470 = (i__29313__auto___307469 + (1));
i__29313__auto___307469 = G__307470;
continue;
} else {
}
break;
}

var argseq__29320__auto__ = ((((2) < args__29319__auto__.length))?(new cljs.core.IndexedSeq(args__29319__auto__.slice((2)),(0),null)):null);
return fulcro.inspect.helpers.integrate_ident.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__29320__auto__);
});

fulcro.inspect.helpers.integrate_ident.cljs$core$IFn$_invoke$arity$variadic = (function (state,ident,named_parameters){
if(cljs.core.map_QMARK_.call(null,state)){
} else {
throw (new Error("Assert failed: (map? state)"));
}

var actions = cljs.core.partition.call(null,(2),named_parameters);
return cljs.core.reduce.call(null,((function (actions){
return (function (state__$1,p__307463){
var vec__307464 = p__307463;
var command = cljs.core.nth.call(null,vec__307464,(0),null);
var data_path = cljs.core.nth.call(null,vec__307464,(1),null);
var already_has_ident_at_path_QMARK_ = ((function (vec__307464,command,data_path,actions){
return (function (data_path__$1){
return cljs.core.some.call(null,((function (vec__307464,command,data_path,actions){
return (function (p1__307458_SHARP_){
return cljs.core._EQ_.call(null,p1__307458_SHARP_,ident);
});})(vec__307464,command,data_path,actions))
,cljs.core.get_in.call(null,state__$1,data_path__$1));
});})(vec__307464,command,data_path,actions))
;
var G__307467 = command;
var G__307467__$1 = (((G__307467 instanceof cljs.core.Keyword))?G__307467.fqn:null);
switch (G__307467__$1) {
case "set":
return cljs.core.assoc_in.call(null,state__$1,data_path,ident);

break;
case "prepend":
if(cljs.core.truth_(already_has_ident_at_path_QMARK_.call(null,data_path))){
return state__$1;
} else {
if(cljs.core.vector_QMARK_.call(null,cljs.core.get_in.call(null,state__$1,data_path))){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["Path ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(data_path)," for prepend must target an app-state vector."].join('')),"\n","(vector? (get-in state data-path))"].join('')));
}

return cljs.core.update_in.call(null,state__$1,data_path,((function (G__307467,G__307467__$1,already_has_ident_at_path_QMARK_,vec__307464,command,data_path,actions){
return (function (p1__307459_SHARP_){
return cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ident], null),p1__307459_SHARP_);
});})(G__307467,G__307467__$1,already_has_ident_at_path_QMARK_,vec__307464,command,data_path,actions))
);
}

break;
case "append":
if(cljs.core.truth_(already_has_ident_at_path_QMARK_.call(null,data_path))){
return state__$1;
} else {
if(cljs.core.vector_QMARK_.call(null,cljs.core.get_in.call(null,state__$1,data_path))){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["Path ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(data_path)," for append must target an app-state vector."].join('')),"\n","(vector? (get-in state data-path))"].join('')));
}

return cljs.core.update_in.call(null,state__$1,data_path,cljs.core.conj,ident);
}

break;
case "replace":
var path_to_vector = cljs.core.butlast.call(null,data_path);
var to_many_QMARK_ = (cljs.core.seq.call(null,path_to_vector)) && (cljs.core.vector_QMARK_.call(null,cljs.core.get_in.call(null,state__$1,path_to_vector)));
var index = cljs.core.last.call(null,data_path);
var vector = cljs.core.get_in.call(null,state__$1,path_to_vector);
if(cljs.core.vector_QMARK_.call(null,data_path)){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["Replacement path must be a vector. You passed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(data_path)].join('')),"\n","(vector? data-path)"].join('')));
}

if(to_many_QMARK_){
if(cljs.core.vector_QMARK_.call(null,vector)){
} else {
throw (new Error(["Assert failed: ","Path for replacement must be a vector","\n","(vector? vector)"].join('')));
}

if(typeof index === 'number'){
} else {
throw (new Error(["Assert failed: ","Path for replacement must end in a vector index","\n","(number? index)"].join('')));
}

if(cljs.core.contains_QMARK_.call(null,vector,index)){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["Target vector for replacement does not have an item at index ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(index)].join('')),"\n","(contains? vector index)"].join('')));
}
} else {
}

return cljs.core.assoc_in.call(null,state__$1,data_path,ident);

break;
default:
throw cljs.core.ex_info.call(null,"Unknown post-op to merge-state!: ",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"command","command",-894540724),command,new cljs.core.Keyword(null,"arg","arg",-1747261837),data_path], null));

}
});})(actions))
,state,actions);
});

fulcro.inspect.helpers.integrate_ident.cljs$lang$maxFixedArity = (2);

fulcro.inspect.helpers.integrate_ident.cljs$lang$applyTo = (function (seq307460){
var G__307461 = cljs.core.first.call(null,seq307460);
var seq307460__$1 = cljs.core.next.call(null,seq307460);
var G__307462 = cljs.core.first.call(null,seq307460__$1);
var seq307460__$2 = cljs.core.next.call(null,seq307460__$1);
return fulcro.inspect.helpers.integrate_ident.cljs$core$IFn$_invoke$arity$variadic(G__307461,G__307462,seq307460__$2);
});

fulcro.inspect.helpers.merge_entity = (function fulcro$inspect$helpers$merge_entity(var_args){
var args__29319__auto__ = [];
var len__29312__auto___307481 = arguments.length;
var i__29313__auto___307482 = (0);
while(true){
if((i__29313__auto___307482 < len__29312__auto___307481)){
args__29319__auto__.push((arguments[i__29313__auto___307482]));

var G__307483 = (i__29313__auto___307482 + (1));
i__29313__auto___307482 = G__307483;
continue;
} else {
}
break;
}

var argseq__29320__auto__ = ((((3) < args__29319__auto__.length))?(new cljs.core.IndexedSeq(args__29319__auto__.slice((3)),(0),null)):null);
return fulcro.inspect.helpers.merge_entity.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__29320__auto__);
});

fulcro.inspect.helpers.merge_entity.cljs$core$IFn$_invoke$arity$variadic = (function (state,x,data,named_parameters){

var map__307476 = om.next.tree__GT_db.call(null,(function (){
if(typeof fulcro.inspect.helpers.t_fulcro$inspect$helpers307477 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {om.next.IQuery}
 * @implements {cljs.core.IWithMeta}
*/
fulcro.inspect.helpers.t_fulcro$inspect$helpers307477 = (function (state,x,data,named_parameters,meta307478){
this.state = state;
this.x = x;
this.data = data;
this.named_parameters = named_parameters;
this.meta307478 = meta307478;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

fulcro.inspect.helpers.t_fulcro$inspect$helpers307477.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_307479,meta307478__$1){
var self__ = this;
var _307479__$1 = this;
return (new fulcro.inspect.helpers.t_fulcro$inspect$helpers307477(self__.state,self__.x,self__.data,self__.named_parameters,meta307478__$1));
});


fulcro.inspect.helpers.t_fulcro$inspect$helpers307477.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_307479){
var self__ = this;
var _307479__$1 = this;
return self__.meta307478;
});


fulcro.inspect.helpers.t_fulcro$inspect$helpers307477.prototype.om$next$IQuery$ = cljs.core.PROTOCOL_SENTINEL;


fulcro.inspect.helpers.t_fulcro$inspect$helpers307477.prototype.om$next$IQuery$query$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("fulcro.inspect.helpers","root","fulcro.inspect.helpers/root",-1338874925),om.next.get_query.call(null,self__.x)], null)], null);
});

fulcro.inspect.helpers.t_fulcro$inspect$helpers307477.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"data","data",1407862150,null),new cljs.core.Symbol(null,"named-parameters","named-parameters",2053922585,null),new cljs.core.Symbol(null,"meta307478","meta307478",-2086702416,null)], null);
});

fulcro.inspect.helpers.t_fulcro$inspect$helpers307477.cljs$lang$type = true;

fulcro.inspect.helpers.t_fulcro$inspect$helpers307477.cljs$lang$ctorStr = "fulcro.inspect.helpers/t_fulcro$inspect$helpers307477";

fulcro.inspect.helpers.t_fulcro$inspect$helpers307477.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"fulcro.inspect.helpers/t_fulcro$inspect$helpers307477");
});

fulcro.inspect.helpers.__GT_t_fulcro$inspect$helpers307477 = (function fulcro$inspect$helpers$__GT_t_fulcro$inspect$helpers307477(state__$1,x__$1,data__$1,named_parameters__$1,meta307478){
return (new fulcro.inspect.helpers.t_fulcro$inspect$helpers307477(state__$1,x__$1,data__$1,named_parameters__$1,meta307478));
});

}

return (new fulcro.inspect.helpers.t_fulcro$inspect$helpers307477(state,x,data,named_parameters,cljs.core.PersistentArrayMap.EMPTY));
})()
,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("fulcro.inspect.helpers","root","fulcro.inspect.helpers/root",-1338874925),data], null),true);
var map__307476__$1 = ((((!((map__307476 == null)))?((((map__307476.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__307476.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__307476):map__307476);
var idents = map__307476__$1;
var root = cljs.core.get.call(null,map__307476__$1,new cljs.core.Keyword("fulcro.inspect.helpers","root","fulcro.inspect.helpers/root",-1338874925));
var root_ident = om.next.ident.call(null,x,data);
var idents__$1 = cljs.core.dissoc.call(null,idents,new cljs.core.Keyword("fulcro.inspect.helpers","root","fulcro.inspect.helpers/root",-1338874925),new cljs.core.Keyword("om.next","tables","om.next/tables",1677536335));
var state__$1 = cljs.core.merge_with.call(null,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state,idents__$1);
if(cljs.core.seq.call(null,named_parameters)){
return cljs.core.apply.call(null,fulcro.inspect.helpers.integrate_ident,state__$1,root_ident,named_parameters);
} else {
return state__$1;
}
});

fulcro.inspect.helpers.merge_entity.cljs$lang$maxFixedArity = (3);

fulcro.inspect.helpers.merge_entity.cljs$lang$applyTo = (function (seq307472){
var G__307473 = cljs.core.first.call(null,seq307472);
var seq307472__$1 = cljs.core.next.call(null,seq307472);
var G__307474 = cljs.core.first.call(null,seq307472__$1);
var seq307472__$2 = cljs.core.next.call(null,seq307472__$1);
var G__307475 = cljs.core.first.call(null,seq307472__$2);
var seq307472__$3 = cljs.core.next.call(null,seq307472__$2);
return fulcro.inspect.helpers.merge_entity.cljs$core$IFn$_invoke$arity$variadic(G__307473,G__307474,G__307475,seq307472__$3);
});

fulcro.inspect.helpers.create_entity_BANG_ = (function fulcro$inspect$helpers$create_entity_BANG_(var_args){
var args__29319__auto__ = [];
var len__29312__auto___307495 = arguments.length;
var i__29313__auto___307496 = (0);
while(true){
if((i__29313__auto___307496 < len__29312__auto___307495)){
args__29319__auto__.push((arguments[i__29313__auto___307496]));

var G__307497 = (i__29313__auto___307496 + (1));
i__29313__auto___307496 = G__307497;
continue;
} else {
}
break;
}

var argseq__29320__auto__ = ((((3) < args__29319__auto__.length))?(new cljs.core.IndexedSeq(args__29319__auto__.slice((3)),(0),null)):null);
return fulcro.inspect.helpers.create_entity_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__29320__auto__);
});

fulcro.inspect.helpers.create_entity_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (p__307488,x,data,named_parameters){
var map__307489 = p__307488;
var map__307489__$1 = ((((!((map__307489 == null)))?((((map__307489.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__307489.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__307489):map__307489);
var state = cljs.core.get.call(null,map__307489__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var ref = cljs.core.get.call(null,map__307489__$1,new cljs.core.Keyword(null,"ref","ref",1289896967));
var named_parameters__$1 = cljs.core.apply.call(null,cljs.core.concat,cljs.core.map.call(null,((function (map__307489,map__307489__$1,state,ref){
return (function (p__307491){
var vec__307492 = p__307491;
var op = cljs.core.nth.call(null,vec__307492,(0),null);
var path = cljs.core.nth.call(null,vec__307492,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [op,cljs.core.conj.call(null,ref,path)], null);
});})(map__307489,map__307489__$1,state,ref))
,cljs.core.partition.call(null,(2),named_parameters)));
return cljs.core.apply.call(null,cljs.core.swap_BANG_,state,fulcro.inspect.helpers.merge_entity,x,fulcro.client.core.get_initial_state.call(null,x,data),named_parameters__$1);
});

fulcro.inspect.helpers.create_entity_BANG_.cljs$lang$maxFixedArity = (3);

fulcro.inspect.helpers.create_entity_BANG_.cljs$lang$applyTo = (function (seq307484){
var G__307485 = cljs.core.first.call(null,seq307484);
var seq307484__$1 = cljs.core.next.call(null,seq307484);
var G__307486 = cljs.core.first.call(null,seq307484__$1);
var seq307484__$2 = cljs.core.next.call(null,seq307484__$1);
var G__307487 = cljs.core.first.call(null,seq307484__$2);
var seq307484__$3 = cljs.core.next.call(null,seq307484__$2);
return fulcro.inspect.helpers.create_entity_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__307485,G__307486,G__307487,seq307484__$3);
});

fulcro.inspect.helpers.dissoc_in = (function fulcro$inspect$helpers$dissoc_in(m,path){
var G__307498 = m;
if(cljs.core.truth_(cljs.core.get_in.call(null,m,cljs.core.butlast.call(null,path)))){
return cljs.core.update_in.call(null,G__307498,cljs.core.butlast.call(null,path),cljs.core.dissoc,cljs.core.last.call(null,path));
} else {
return G__307498;
}
});
fulcro.inspect.helpers.om_ident_QMARK_ = (function fulcro$inspect$helpers$om_ident_QMARK_(x){
return (cljs.core.vector_QMARK_.call(null,x)) && (cljs.core._EQ_.call(null,(2),cljs.core.count.call(null,x))) && ((cljs.core.first.call(null,x) instanceof cljs.core.Keyword));
});
fulcro.inspect.helpers.deep_remove_ref = (function fulcro$inspect$helpers$deep_remove_ref(state,ref){

var item = cljs.core.get_in.call(null,state,ref);
var idents = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.comp.call(null,cljs.core.keep.call(null,((function (item){
return (function (v){
if(cljs.core.truth_(fulcro.inspect.helpers.om_ident_QMARK_.call(null,v))){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v], null);
} else {
if((cljs.core.vector_QMARK_.call(null,v)) && (cljs.core.every_QMARK_.call(null,fulcro.inspect.helpers.om_ident_QMARK_,v))){
return v;
} else {
return null;
}
}
});})(item))
),cljs.core.cat),cljs.core.vals.call(null,item));
return cljs.core.reduce.call(null,((function (item,idents){
return (function (s,i){
return fulcro.inspect.helpers.deep_remove_ref.call(null,s,i);
});})(item,idents))
,fulcro.inspect.helpers.dissoc_in.call(null,state,ref),idents);
});
fulcro.inspect.helpers.vec_remove_index = (function fulcro$inspect$helpers$vec_remove_index(i,v){

return cljs.core.vec.call(null,cljs.core.concat.call(null,cljs.core.subvec.call(null,v,(0),i),cljs.core.subvec.call(null,v,(i + (1)),cljs.core.count.call(null,v))));
});

//# sourceMappingURL=helpers.js.map?rel=1511304485115
