// Compiled by ClojureScript 1.9.946 {}
goog.provide('fulcro.client.util');
goog.require('cljs.core');
goog.require('cljs.pprint');
goog.require('cljs.spec.alpha');
goog.require('clojure.walk');
goog.require('om.next');
goog.require('om.dom');
goog.require('om.next.protocols');
goog.require('om.transit');
goog.require('cognitect.transit');
goog.require('om.next.impl.parser');
/**
 * Get the ident of an Om class with props. Works on client/server
 */
fulcro.client.util.get_ident = (function fulcro$client$util$get_ident(class$,props){
if(((!((class$ == null)))?(((false) || ((cljs.core.PROTOCOL_SENTINEL === class$.om$next$Ident$)))?true:false):false)){
return om.next.ident.call(null,class$,props);
} else {
return null;
}
});
/**
 * Get a unique string-based key. Never returns the same value.
 */
fulcro.client.util.unique_key = (function fulcro$client$util$unique_key(){
var s = cljs.core.random_uuid.call(null);
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s)].join('');
});
/**
 * Re-render components. If only a reconciler is supplied then it forces a full DOM re-render by updating the :ui/react-key
 *   in app state and forcing Om to re-render the entire DOM, which only works properly if you query
 *   for :ui/react-key in your Root render component and add that as the react :key to your top-level element.
 * 
 *   If you supply an additional vector of keywords and idents then it will ask Om to rerender only those components that mention
 *   those things in their queries.
 */
fulcro.client.util.force_render = (function fulcro$client$util$force_render(var_args){
var G__82807 = arguments.length;
switch (G__82807) {
case 2:
return fulcro.client.util.force_render.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return fulcro.client.util.force_render.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fulcro.client.util.force_render.cljs$core$IFn$_invoke$arity$2 = (function (reconciler,keywords){
om.next.protocols.queue_BANG_.call(null,reconciler,keywords);

return om.next.protocols.schedule_render_BANG_.call(null,reconciler);
});

fulcro.client.util.force_render.cljs$core$IFn$_invoke$arity$1 = (function (reconciler){
var app_state = om.next.app_state.call(null,reconciler);
cljs.core.swap_BANG_.call(null,app_state,cljs.core.assoc,new cljs.core.Keyword("ui","react-key","ui/react-key",1337877664),fulcro.client.util.unique_key.call(null));

return om.next.force_root_render_BANG_.call(null,reconciler);
});

fulcro.client.util.force_render.cljs$lang$maxFixedArity = 2;

fulcro.client.util.atom_QMARK_ = (function fulcro$client$util$atom_QMARK_(a){
return (a instanceof cljs.core.Atom);
});
/**
 * Removes parameters from the query, e.g. for PCI compliant logging.
 */
fulcro.client.util.strip_parameters = (function fulcro$client$util$strip_parameters(query){
return om.next.impl.parser.ast__GT_expr.call(null,clojure.walk.prewalk.call(null,(function (p1__82814_SHARP_){
if(cljs.core.map_QMARK_.call(null,p1__82814_SHARP_)){
return cljs.core.dissoc.call(null,p1__82814_SHARP_,new cljs.core.Keyword(null,"params","params",710516235));
} else {
return p1__82814_SHARP_;
}
}),om.next.impl.parser.query__GT_ast.call(null,query)),true);
});
fulcro.client.util.deep_merge = (function fulcro$client$util$deep_merge(var_args){
var args__29319__auto__ = [];
var len__29312__auto___82817 = arguments.length;
var i__29313__auto___82819 = (0);
while(true){
if((i__29313__auto___82819 < len__29312__auto___82817)){
args__29319__auto__.push((arguments[i__29313__auto___82819]));

var G__82821 = (i__29313__auto___82819 + (1));
i__29313__auto___82819 = G__82821;
continue;
} else {
}
break;
}

var argseq__29320__auto__ = ((((0) < args__29319__auto__.length))?(new cljs.core.IndexedSeq(args__29319__auto__.slice((0)),(0),null)):null);
return fulcro.client.util.deep_merge.cljs$core$IFn$_invoke$arity$variadic(argseq__29320__auto__);
});

fulcro.client.util.deep_merge.cljs$core$IFn$_invoke$arity$variadic = (function (xs){

if(cljs.core.every_QMARK_.call(null,cljs.core.map_QMARK_,xs)){
return cljs.core.apply.call(null,cljs.core.merge_with,fulcro.client.util.deep_merge,xs);
} else {
return cljs.core.last.call(null,xs);
}
});

fulcro.client.util.deep_merge.cljs$lang$maxFixedArity = (0);

fulcro.client.util.deep_merge.cljs$lang$applyTo = (function (seq82815){
return fulcro.client.util.deep_merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq82815));
});

/**
 * Helper for logging the app-state. Pass in a Fulcro application atom and either top-level keys, data-paths
 *    (like get-in), or both.
 */
fulcro.client.util.log_app_state = (function fulcro$client$util$log_app_state(var_args){
var args__29319__auto__ = [];
var len__29312__auto___82833 = arguments.length;
var i__29313__auto___82834 = (0);
while(true){
if((i__29313__auto___82834 < len__29312__auto___82833)){
args__29319__auto__.push((arguments[i__29313__auto___82834]));

var G__82835 = (i__29313__auto___82834 + (1));
i__29313__auto___82834 = G__82835;
continue;
} else {
}
break;
}

var argseq__29320__auto__ = ((((1) < args__29319__auto__.length))?(new cljs.core.IndexedSeq(args__29319__auto__.slice((1)),(0),null)):null);
return fulcro.client.util.log_app_state.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29320__auto__);
});

fulcro.client.util.log_app_state.cljs$core$IFn$_invoke$arity$variadic = (function (app_atom,keys_and_paths){
try{var app_state = om.next.app_state.call(null,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,app_atom)));
return cljs.pprint.pprint.call(null,(function (){var make_path = ((function (app_state){
return (function fulcro$client$util$make_path(location){
if(cljs.core.sequential_QMARK_.call(null,location)){
return location;
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [location], null);
}
});})(app_state))
;
var process_location = ((function (app_state){
return (function fulcro$client$util$process_location(acc,location){
var path = make_path.call(null,location);
return cljs.core.assoc_in.call(null,acc,path,cljs.core.get_in.call(null,cljs.core.deref.call(null,app_state),path));
});})(app_state))
;
var pred__82830 = cljs.core._EQ_;
var expr__82831 = cljs.core.count.call(null,keys_and_paths);
if(cljs.core.truth_(pred__82830.call(null,(0),expr__82831))){
return cljs.core.deref.call(null,app_state);
} else {
if(cljs.core.truth_(pred__82830.call(null,(1),expr__82831))){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,app_state),make_path.call(null,cljs.core.first.call(null,keys_and_paths)));
} else {
return cljs.core.reduce.call(null,process_location,cljs.core.PersistentArrayMap.EMPTY,keys_and_paths);
}
}
})());
}catch (e82826){if((e82826 instanceof Error)){
var e = e82826;
throw cljs.core.ex_info.call(null,"fulcro.client.impl.util/log-app-state expects an atom with a Fulcro client",cljs.core.PersistentArrayMap.EMPTY);
} else {
throw e82826;

}
}});

fulcro.client.util.log_app_state.cljs$lang$maxFixedArity = (1);

fulcro.client.util.log_app_state.cljs$lang$applyTo = (function (seq82824){
var G__82825 = cljs.core.first.call(null,seq82824);
var seq82824__$1 = cljs.core.next.call(null,seq82824);
return fulcro.client.util.log_app_state.cljs$core$IFn$_invoke$arity$variadic(G__82825,seq82824__$1);
});

fulcro.client.util.conform_BANG_ = (function fulcro$client$util$conform_BANG_(spec,x){
var rt = cljs.spec.alpha.conform.call(null,spec,x);
if(cljs.core.truth_(cljs.spec.alpha.invalid_QMARK_.call(null,rt))){
throw cljs.core.ex_info.call(null,cljs.spec.alpha.explain_str.call(null,spec,x),cljs.spec.alpha.explain_data.call(null,spec,x));
} else {
}

return rt;
});
/**
 * Returns the react-instance (which is logically true) iff the given react instance is an instance of the given react class.
 *   Otherwise returns nil.
 */
fulcro.client.util.react_instance_QMARK_ = (function fulcro$client$util$react_instance_QMARK_(react_class,react_instance){
if(cljs.core.truth_(react_class)){
} else {
throw (new Error("Assert failed: react-class"));
}

if(cljs.core.truth_(react_instance)){
} else {
throw (new Error("Assert failed: react-instance"));
}

if(cljs.core._EQ_.call(null,om.next.react_type.call(null,react_instance),react_class)){
return react_instance;
} else {
return null;
}
});
/**
 * Finds (and returns) the first instance of the given React class (or nil if not found) in a sequence of instances. Useful
 *   for finding a child of the correct type when nesting react components.
 */
fulcro.client.util.first_node = (function fulcro$client$util$first_node(react_class,sequence_of_react_instances){
return cljs.core.some.call(null,(function (p1__82836_SHARP_){
return fulcro.client.util.react_instance_QMARK_.call(null,react_class,p1__82836_SHARP_);
}),sequence_of_react_instances);
});
/**
 * Use transit to encode clj data as a string. Useful for encoding initial app state from server-side rendering.
 */
fulcro.client.util.transit_clj__GT_str = (function fulcro$client$util$transit_clj__GT_str(coll){
return cognitect.transit.write.call(null,om.transit.writer.call(null),coll);
});
/**
 * Use transit to decode a string into a clj data structure. Useful for decoding initial app state when starting from a server-side rendering.
 */
fulcro.client.util.transit_str__GT_clj = (function fulcro$client$util$transit_str__GT_clj(str){
return cognitect.transit.read.call(null,om.next.reader.call(null),str);
});

//# sourceMappingURL=util.js.map?rel=1511229599018
