// Compiled by ClojureScript 1.9.946 {}
goog.provide('fulcro.client.impl.data_fetch');
goog.require('cljs.core');
goog.require('om.next.impl.parser');
goog.require('om.next');
goog.require('om.next.protocols');
goog.require('om.util');
goog.require('clojure.walk');
goog.require('clojure.set');
goog.require('fulcro.client.logging');
goog.require('fulcro.client.util');
goog.require('fulcro.client.mutations');
goog.require('fulcro.client.impl.om_plumbing');











/**
 * Test if the given bit of state is a data fetch state-tracking marker
 */
fulcro.client.impl.data_fetch.data_state_QMARK_ = (function fulcro$client$impl$data_fetch$data_state_QMARK_(state){
return cljs.core.contains_QMARK_.call(null,state,new cljs.core.Keyword("fulcro.client.impl.data-fetch","type","fulcro.client.impl.data-fetch/type",296514265));
});
var is_kind_QMARK_ = (function fulcro$client$impl$data_fetch$is_kind_QMARK_(state,type){
if(cljs.core.truth_(fulcro.client.impl.data_fetch.data_state_QMARK_.call(null,state))){
return cljs.core._EQ_.call(null,type,new cljs.core.Keyword("fulcro.client.impl.data-fetch","type","fulcro.client.impl.data-fetch/type",296514265).cljs$core$IFn$_invoke$arity$1(state));
} else {
return false;
}
});
/**
 * Test if the given item is a data state marker that is in the ready state
 */
fulcro.client.impl.data_fetch.ready_QMARK_ = (function fulcro$client$impl$data_fetch$ready_QMARK_(state){
return is_kind_QMARK_.call(null,state,new cljs.core.Keyword(null,"ready","ready",1086465795));
});

/**
 * Test if the given item is a data state marker in the loading state
 */
fulcro.client.impl.data_fetch.loading_QMARK_ = (function fulcro$client$impl$data_fetch$loading_QMARK_(state){
return is_kind_QMARK_.call(null,state,new cljs.core.Keyword(null,"loading","loading",-737050189));
});

/**
 * Test if the given item is a data state marker in the failed state
 */
fulcro.client.impl.data_fetch.failed_QMARK_ = (function fulcro$client$impl$data_fetch$failed_QMARK_(state){
return is_kind_QMARK_.call(null,state,new cljs.core.Keyword(null,"failed","failed",-1397425762));
});
fulcro.client.impl.data_fetch.is_direct_table_load_QMARK_ = (function fulcro$client$impl$data_fetch$is_direct_table_load_QMARK_(load_marker){
return (cljs.core.not.call(null,fulcro.client.impl.data_fetch.data_field.call(null,load_marker))) && (om.util.ident_QMARK_.call(null,fulcro.client.impl.data_fetch.data_query_key.call(null,load_marker)));
});
fulcro.client.impl.data_fetch.place_load_marker = (function fulcro$client$impl$data_fetch$place_load_marker(state_map,marker){
return cljs.core.update_in.call(null,state_map,fulcro.client.impl.data_fetch.data_path.call(null,marker),(function (current_val){
if(cljs.core.truth_(fulcro.client.impl.data_fetch.is_direct_table_load_QMARK_.call(null,marker))){
if(cljs.core.map_QMARK_.call(null,current_val)){
return cljs.core.assoc.call(null,current_val,new cljs.core.Keyword("ui","fetch-state","ui/fetch-state",1030289927),marker);
} else {
return null;
}
} else {
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("ui","fetch-state","ui/fetch-state",1030289927),marker], null);
}
}));
});
/**
 * Place load markers in the app state at their data paths so that UI rendering can see them.
 */
fulcro.client.impl.data_fetch.place_load_markers = (function fulcro$client$impl$data_fetch$place_load_markers(state_atom,items_to_load){
return cljs.core.swap_BANG_.call(null,state_atom,(function (state_map){
return cljs.core.reduce.call(null,(function (s,item){
var i = fulcro.client.impl.data_fetch.set_loading_BANG_.call(null,item);
var G__83133 = cljs.core.update.call(null,s,new cljs.core.Keyword("fulcro","loads-in-progress","fulcro/loads-in-progress",-1196090224),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentHashSet.EMPTY),fulcro.client.impl.data_fetch.data_uuid.call(null,i));
if(cljs.core.truth_(fulcro.client.impl.data_fetch.data_marker_QMARK_.call(null,i))){
return fulcro.client.impl.data_fetch.place_load_marker.call(null,G__83133,i);
} else {
return G__83133;
}
}),state_map,items_to_load);
}));
});
/**
 * Marks all of the items in the ready-to-load state as loading, places the loading markers in the appropriate locations
 *   in the app state, and return maps with the keys:
 * 
 *   `query` : The full query to send to the server.
 *   `on-load` : The function to call to merge a response. Detects missing data and sets failure markers for those.
 *   `on-error` : The function to call to set network/server error(s) in place of loading markers.
 *   `load-descriptors` : Args to pass back to on-load and on-error. These are separated
 *  so that `rewrite-tempids-in-request-queue` can rewrite tempids for merge and
 *  error callbacks
 * 
 *   response-channel will have the response posted to it when the request is done.
 *   .
 */
fulcro.client.impl.data_fetch.mark_parallel_loading = (function fulcro$client$impl$data_fetch$mark_parallel_loading(remote_name,reconciler){
var state = om.next.app_state.call(null,reconciler);
var queued_items = cljs.core.get.call(null,cljs.core.deref.call(null,state),new cljs.core.Keyword("fulcro","ready-to-load","fulcro/ready-to-load",127104696));
var is_eligible_QMARK_ = ((function (state,queued_items){
return (function (item){
var and__28129__auto__ = new cljs.core.Keyword("fulcro.client.impl.data-fetch","parallel","fulcro.client.impl.data-fetch/parallel",1010707051).cljs$core$IFn$_invoke$arity$1(item);
if(cljs.core.truth_(and__28129__auto__)){
return cljs.core._EQ_.call(null,remote_name,fulcro.client.impl.data_fetch.data_remote.call(null,item));
} else {
return and__28129__auto__;
}
});})(state,queued_items))
;
var other_items_loading_QMARK_ = cljs.core.boolean$.call(null,cljs.core.seq.call(null,cljs.core.get.call(null,cljs.core.deref.call(null,state),new cljs.core.Keyword("fulcro","loads-in-progress","fulcro/loads-in-progress",-1196090224))));
var items_to_load = cljs.core.filter.call(null,is_eligible_QMARK_,queued_items);
var remaining_items = cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,is_eligible_QMARK_),queued_items);
var loading_QMARK_ = (cljs.core.seq.call(null,items_to_load)) || (other_items_loading_QMARK_);
if(cljs.core.empty_QMARK_.call(null,items_to_load)){
return null;
} else {
fulcro.client.impl.data_fetch.place_load_markers.call(null,state,items_to_load);

cljs.core.swap_BANG_.call(null,state,cljs.core.assoc,new cljs.core.Keyword("ui","loading-data","ui/loading-data",-1566515143),loading_QMARK_,new cljs.core.Keyword("fulcro","ready-to-load","fulcro/ready-to-load",127104696),remaining_items);

var iter__28949__auto__ = ((function (state,queued_items,is_eligible_QMARK_,other_items_loading_QMARK_,items_to_load,remaining_items,loading_QMARK_){
return (function fulcro$client$impl$data_fetch$mark_parallel_loading_$_iter__83134(s__83135){
return (new cljs.core.LazySeq(null,((function (state,queued_items,is_eligible_QMARK_,other_items_loading_QMARK_,items_to_load,remaining_items,loading_QMARK_){
return (function (){
var s__83135__$1 = s__83135;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__83135__$1);
if(temp__4657__auto__){
var s__83135__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__83135__$2)){
var c__28947__auto__ = cljs.core.chunk_first.call(null,s__83135__$2);
var size__28948__auto__ = cljs.core.count.call(null,c__28947__auto__);
var b__83137 = cljs.core.chunk_buffer.call(null,size__28948__auto__);
if((function (){var i__83136 = (0);
while(true){
if((i__83136 < size__28948__auto__)){
var item = cljs.core._nth.call(null,c__28947__auto__,i__83136);
cljs.core.chunk_append.call(null,b__83137,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"query","query",-1288509510),fulcro.client.impl.data_fetch.full_query.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [item], null)),new cljs.core.Keyword(null,"on-load","on-load",1415151594),fulcro.client.impl.data_fetch.loaded_callback.call(null,reconciler),new cljs.core.Keyword(null,"on-error","on-error",1728533530),fulcro.client.impl.data_fetch.error_callback.call(null,reconciler),new cljs.core.Keyword(null,"load-descriptors","load-descriptors",391720681),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [item], null)], null));

var G__83140 = (i__83136 + (1));
i__83136 = G__83140;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__83137),fulcro$client$impl$data_fetch$mark_parallel_loading_$_iter__83134.call(null,cljs.core.chunk_rest.call(null,s__83135__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__83137),null);
}
} else {
var item = cljs.core.first.call(null,s__83135__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"query","query",-1288509510),fulcro.client.impl.data_fetch.full_query.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [item], null)),new cljs.core.Keyword(null,"on-load","on-load",1415151594),fulcro.client.impl.data_fetch.loaded_callback.call(null,reconciler),new cljs.core.Keyword(null,"on-error","on-error",1728533530),fulcro.client.impl.data_fetch.error_callback.call(null,reconciler),new cljs.core.Keyword(null,"load-descriptors","load-descriptors",391720681),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [item], null)], null),fulcro$client$impl$data_fetch$mark_parallel_loading_$_iter__83134.call(null,cljs.core.rest.call(null,s__83135__$2)));
}
} else {
return null;
}
break;
}
});})(state,queued_items,is_eligible_QMARK_,other_items_loading_QMARK_,items_to_load,remaining_items,loading_QMARK_))
,null,null));
});})(state,queued_items,is_eligible_QMARK_,other_items_loading_QMARK_,items_to_load,remaining_items,loading_QMARK_))
;
return iter__28949__auto__.call(null,items_to_load);
}
});
/**
 * Returns a lazy sequence of the elements of coll with dupes removed.
 * An element is a duplicate IFF (keys-fn element) has key collision with any prior element
 * to come before it. E.g. (dedupe-by identity [[:a] [:b] [:a] [:a :c]]) => [[:a] [:b]]
 * Returns a stateful transducer when no collection is provided.
 */
fulcro.client.impl.data_fetch.dedupe_by = (function fulcro$client$impl$data_fetch$dedupe_by(var_args){
var G__83144 = arguments.length;
switch (G__83144) {
case 1:
return fulcro.client.impl.data_fetch.dedupe_by.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fulcro.client.impl.data_fetch.dedupe_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fulcro.client.impl.data_fetch.dedupe_by.cljs$core$IFn$_invoke$arity$1 = (function (keys_fn){
return (function (rf){
var keys_seen = cljs.core.volatile_BANG_.call(null,cljs.core.PersistentHashSet.EMPTY);
return ((function (keys_seen){
return (function() {
var G__83148 = null;
var G__83148__0 = (function (){
return rf.call(null);
});
var G__83148__1 = (function (result){
return rf.call(null,result);
});
var G__83148__2 = (function (result,input){
var input_keys = cljs.core.set.call(null,keys_fn.call(null,input));
if(cljs.core.empty_QMARK_.call(null,clojure.set.intersection.call(null,cljs.core.deref.call(null,keys_seen),input_keys))){
cljs.core._vreset_BANG_.call(null,keys_seen,clojure.set.union.call(null,cljs.core._deref.call(null,keys_seen),input_keys));

return rf.call(null,result,input);
} else {
return result;
}
});
G__83148 = function(result,input){
switch(arguments.length){
case 0:
return G__83148__0.call(this);
case 1:
return G__83148__1.call(this,result);
case 2:
return G__83148__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__83148.cljs$core$IFn$_invoke$arity$0 = G__83148__0;
G__83148.cljs$core$IFn$_invoke$arity$1 = G__83148__1;
G__83148.cljs$core$IFn$_invoke$arity$2 = G__83148__2;
return G__83148;
})()
;})(keys_seen))
});
});

fulcro.client.impl.data_fetch.dedupe_by.cljs$core$IFn$_invoke$arity$2 = (function (keys_fn,coll){
return cljs.core.sequence.call(null,fulcro.client.impl.data_fetch.dedupe_by.call(null,keys_fn),coll);
});

fulcro.client.impl.data_fetch.dedupe_by.cljs$lang$maxFixedArity = 2;

fulcro.client.impl.data_fetch.join_key_or_nil = (function fulcro$client$impl$data_fetch$join_key_or_nil(expr){
if(cljs.core.truth_(om.util.join_QMARK_.call(null,expr))){
var join_key_or_ident = om.util.join_key.call(null,expr);
if(om.util.ident_QMARK_.call(null,join_key_or_ident)){
return cljs.core.first.call(null,join_key_or_ident);
} else {
return join_key_or_ident;
}
} else {
return null;
}
});
/**
 * This function is used to split accidental colliding queries into separate network
 *   requests. The most general description of this issue is
 *   from two unrelated `load` calls when black-box composing functions. The two
 *   separate queries: One issues `[{:entitlements [:foo]}]`, and the other
 *   asks for `[{:entitlements [:bar]}]`. Fulcro merges these into a single query
 *   [{:entitlements [:foo]} {:entitlements [:bar]}]. However, the response to a query
 *   is a map, and such a query would result in the backend parser being called twice (once per key in the subquery)
 *   but one would stomp on the other. Thus, this function ensures such accidental collisions are
 *   not combined into a single network request.
 */
fulcro.client.impl.data_fetch.split_items_ready_to_load = (function fulcro$client$impl$data_fetch$split_items_ready_to_load(items_ready_to_load){
var items_to_load_now = cljs.core.vec.call(null,fulcro.client.impl.data_fetch.dedupe_by.call(null,(function (item){
return cljs.core.map.call(null,fulcro.client.impl.data_fetch.join_key_or_nil,fulcro.client.impl.data_fetch.data_query.call(null,item));
}),items_ready_to_load));
var is_loading_now_QMARK_ = cljs.core.set.call(null,items_to_load_now);
var items_to_defer = cljs.core.vec.call(null,cljs.core.remove.call(null,is_loading_now_QMARK_,items_ready_to_load));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [items_to_load_now,items_to_defer], null);
});
/**
 * Marks all of the items in the ready-to-load state as loading, places the loading markers in the appropriate locations
 *   in the app state, and returns a map with the keys:
 * 
 *   `query` : The full query to send to the server.
 *   `on-load` : The function to call to merge a response. Detects missing data and sets failure markers for those.
 *   `on-error` : The function to call to set network/server error(s) in place of loading markers.
 *   `load-descriptors` : Args to pass back to on-load and on-error. These are separated
 *  so that `rewrite-tempids-in-request-queue` can rewrite tempids for merge and
 *  error callbacks
 * 
 *   response-channel will have the response posted to it when the request is done.
 *   .
 */
fulcro.client.impl.data_fetch.mark_loading = (function fulcro$client$impl$data_fetch$mark_loading(remote,reconciler){
var state = om.next.app_state.call(null,reconciler);
var is_eligible_QMARK_ = ((function (state){
return (function (item){
return cljs.core._EQ_.call(null,remote,fulcro.client.impl.data_fetch.data_remote.call(null,item));
});})(state))
;
var all_items = cljs.core.get.call(null,cljs.core.deref.call(null,state),new cljs.core.Keyword("fulcro","ready-to-load","fulcro/ready-to-load",127104696));
var items_ready_to_load = cljs.core.filter.call(null,is_eligible_QMARK_,all_items);
var items_for_other_remotes = cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,is_eligible_QMARK_),all_items);
var other_items_loading_QMARK_ = cljs.core.boolean$.call(null,cljs.core.seq.call(null,cljs.core.get.call(null,cljs.core.deref.call(null,state),new cljs.core.Keyword("fulcro","loads-in-progress","fulcro/loads-in-progress",-1196090224))));
var vec__83151 = fulcro.client.impl.data_fetch.split_items_ready_to_load.call(null,items_ready_to_load);
var items_to_load_now = cljs.core.nth.call(null,vec__83151,(0),null);
var items_to_defer = cljs.core.nth.call(null,vec__83151,(1),null);
var remaining_items = cljs.core.concat.call(null,items_for_other_remotes,items_to_defer);
var loading_QMARK_ = (cljs.core.seq.call(null,items_to_load_now)) || (other_items_loading_QMARK_);
if(cljs.core.empty_QMARK_.call(null,items_to_load_now)){
return null;
} else {
fulcro.client.impl.data_fetch.place_load_markers.call(null,state,items_to_load_now);

cljs.core.swap_BANG_.call(null,state,cljs.core.assoc,new cljs.core.Keyword("ui","loading-data","ui/loading-data",-1566515143),loading_QMARK_,new cljs.core.Keyword("fulcro","ready-to-load","fulcro/ready-to-load",127104696),remaining_items);

return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"query","query",-1288509510),fulcro.client.impl.data_fetch.full_query.call(null,items_to_load_now),new cljs.core.Keyword(null,"on-load","on-load",1415151594),fulcro.client.impl.data_fetch.loaded_callback.call(null,reconciler),new cljs.core.Keyword(null,"on-error","on-error",1728533530),fulcro.client.impl.data_fetch.error_callback.call(null,reconciler),new cljs.core.Keyword(null,"load-descriptors","load-descriptors",391720681),items_to_load_now], null);
}
});
fulcro.client.impl.data_fetch.valid_types = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"ready","ready",1086465795),null,new cljs.core.Keyword(null,"loading","loading",-737050189),null,new cljs.core.Keyword(null,"failed","failed",-1397425762),null], null), null);
/**
 * This is just a testing function -- using ready-state as public interface and call the
 *   `set-{type}!` functions to change it as needed.
 */
fulcro.client.impl.data_fetch.make_data_state = (function fulcro$client$impl$data_fetch$make_data_state(var_args){
var G__83161 = arguments.length;
switch (G__83161) {
case 1:
return fulcro.client.impl.data_fetch.make_data_state.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fulcro.client.impl.data_fetch.make_data_state.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fulcro.client.impl.data_fetch.make_data_state.cljs$core$IFn$_invoke$arity$1 = (function (type){
return fulcro.client.impl.data_fetch.make_data_state.call(null,type,cljs.core.PersistentArrayMap.EMPTY);
});

fulcro.client.impl.data_fetch.make_data_state.cljs$core$IFn$_invoke$arity$2 = (function (type,params){
if(cljs.core.truth_(cljs.core.get.call(null,fulcro.client.impl.data_fetch.valid_types,type))){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("fulcro.client.impl.data-fetch","type","fulcro.client.impl.data-fetch/type",296514265),type,new cljs.core.Keyword("fulcro.client.impl.data-fetch","params","fulcro.client.impl.data-fetch/params",1865690070),params], null);
} else {
throw cljs.core.ex_info.call(null,["INVALID DATA STATE TYPE: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}
});

fulcro.client.impl.data_fetch.make_data_state.cljs$lang$maxFixedArity = 2;

/**
 * Remove items from a query (AST) that have a key listed in the elision-set
 */
fulcro.client.impl.data_fetch.elide_ast_nodes = (function fulcro$client$impl$data_fetch$elide_ast_nodes(p__83167,elision_set){
var map__83168 = p__83167;
var map__83168__$1 = ((((!((map__83168 == null)))?((((map__83168.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__83168.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__83168):map__83168);
var ast = map__83168__$1;
var key = cljs.core.get.call(null,map__83168__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var union_key = cljs.core.get.call(null,map__83168__$1,new cljs.core.Keyword(null,"union-key","union-key",1529707234));
var children = cljs.core.get.call(null,map__83168__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var union_elision_QMARK_ = cljs.core.contains_QMARK_.call(null,elision_set,union_key);
if((union_elision_QMARK_) || (cljs.core.contains_QMARK_.call(null,elision_set,key))){
return null;
} else {
if((union_elision_QMARK_) && ((cljs.core.count.call(null,children) <= (2)))){
fulcro.client.logging.warn.call(null,"Om unions are not designed to be used with fewer than two children. Check your calls to Fulcro\n        load functions where the :without set contains ",cljs.core.pr_str.call(null,union_key));
} else {
}

return cljs.core.update.call(null,ast,new cljs.core.Keyword(null,"children","children",-940561982),((function (union_elision_QMARK_,map__83168,map__83168__$1,ast,key,union_key,children){
return (function (c){
return cljs.core.vec.call(null,cljs.core.keep.call(null,((function (union_elision_QMARK_,map__83168,map__83168__$1,ast,key,union_key,children){
return (function (p1__83166_SHARP_){
return fulcro.client.impl.data_fetch.elide_ast_nodes.call(null,p1__83166_SHARP_,elision_set);
});})(union_elision_QMARK_,map__83168,map__83168__$1,ast,key,union_key,children))
,c));
});})(union_elision_QMARK_,map__83168,map__83168__$1,ast,key,union_key,children))
);
}
});
/**
 * Inject parameters into elements of the top-level query.
 * 
 *   `params` is a map from keyword (on the query in the AST) to parameter maps. So, given the AST for this query:
 * 
 *   ```
 *   [:a :b :c]
 *   ```
 * 
 *   and a `params` of `{:a {:x 1} :c {:y 2}}` you'll get an AST representing:
 * 
 *   ```
 *   [(:a {:x 1}) :b (:c {:y 2})]
 *   ```
 *   
 */
fulcro.client.impl.data_fetch.inject_query_params = (function fulcro$client$impl$data_fetch$inject_query_params(ast,params){
var top_level_keys = cljs.core.set.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"dispatch-key","dispatch-key",733619510),new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(ast)));
var param_keys = cljs.core.set.call(null,cljs.core.keys.call(null,params));
var unknown_keys = clojure.set.difference.call(null,param_keys,top_level_keys);
if(!(cljs.core.empty_QMARK_.call(null,unknown_keys))){
fulcro.client.logging.error.call(null,["Error: You attempted to add parameters for ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,unknown_keys))," to top-level key(s) of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,om.next.ast__GT_query.call(null,ast)))].join(''));
} else {
}

return cljs.core.update_in.call(null,ast,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"children","children",-940561982)], null),((function (top_level_keys,param_keys,unknown_keys){
return (function (p1__83171_SHARP_){
return cljs.core.map.call(null,((function (top_level_keys,param_keys,unknown_keys){
return (function (c){
var temp__4655__auto__ = cljs.core.get.call(null,params,new cljs.core.Keyword(null,"dispatch-key","dispatch-key",733619510).cljs$core$IFn$_invoke$arity$1(c));
if(cljs.core.truth_(temp__4655__auto__)){
var new_params = temp__4655__auto__;
return cljs.core.update.call(null,c,new cljs.core.Keyword(null,"params","params",710516235),cljs.core.merge,new_params);
} else {
return c;
}
});})(top_level_keys,param_keys,unknown_keys))
,p1__83171_SHARP_);
});})(top_level_keys,param_keys,unknown_keys))
);
});
/**
 * Generate a ready-to-load state with all of the necessary details to do
 *   remoting and merging.
 */
fulcro.client.impl.data_fetch.ready_state = (function fulcro$client$impl$data_fetch$ready_state(p__83180){
var map__83181 = p__83180;
var map__83181__$1 = ((((!((map__83181 == null)))?((((map__83181.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__83181.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__83181):map__83181);
var target = cljs.core.get.call(null,map__83181__$1,new cljs.core.Keyword(null,"target","target",253001721));
var query = cljs.core.get.call(null,map__83181__$1,new cljs.core.Keyword(null,"query","query",-1288509510));
var remote = cljs.core.get.call(null,map__83181__$1,new cljs.core.Keyword(null,"remote","remote",-1593576576),new cljs.core.Keyword(null,"remote","remote",-1593576576));
var refresh = cljs.core.get.call(null,map__83181__$1,new cljs.core.Keyword(null,"refresh","refresh",1947415525),cljs.core.PersistentVector.EMPTY);
var parallel = cljs.core.get.call(null,map__83181__$1,new cljs.core.Keyword(null,"parallel","parallel",-1863607128));
var fallback = cljs.core.get.call(null,map__83181__$1,new cljs.core.Keyword(null,"fallback","fallback",761637929));
var marker = cljs.core.get.call(null,map__83181__$1,new cljs.core.Keyword(null,"marker","marker",865118313),true);
var params = cljs.core.get.call(null,map__83181__$1,new cljs.core.Keyword(null,"params","params",710516235));
var field = cljs.core.get.call(null,map__83181__$1,new cljs.core.Keyword(null,"field","field",-1302436500));
var env = cljs.core.get.call(null,map__83181__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var post_mutation = cljs.core.get.call(null,map__83181__$1,new cljs.core.Keyword(null,"post-mutation","post-mutation",-1076606705));
var without = cljs.core.get.call(null,map__83181__$1,new cljs.core.Keyword(null,"without","without",1107036688),cljs.core.PersistentHashSet.EMPTY);
var ident = cljs.core.get.call(null,map__83181__$1,new cljs.core.Keyword(null,"ident","ident",-742346));
var post_mutation_params = cljs.core.get.call(null,map__83181__$1,new cljs.core.Keyword(null,"post-mutation-params","post-mutation-params",-849425897));
if(cljs.core.truth_((function (){var or__28141__auto__ = field;
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
return query;
}
})())){
} else {
throw (new Error(["Assert failed: ","You must supply a query or a field/ident pair","\n","(or field query)"].join('')));
}

if(cljs.core.truth_((function (){var or__28141__auto__ = cljs.core.not.call(null,field);
if(or__28141__auto__){
return or__28141__auto__;
} else {
var and__28129__auto__ = field;
if(cljs.core.truth_(and__28129__auto__)){
return om.util.ident_QMARK_.call(null,ident);
} else {
return and__28129__auto__;
}
}
})())){
} else {
throw (new Error(["Assert failed: ","Field requires ident","\n","(or (not field) (and field (util/ident? ident)))"].join('')));
}

var old_ast = om.next.query__GT_ast.call(null,query);
var ast = (function (){var G__83183 = old_ast;
var G__83183__$1 = (cljs.core.truth_(cljs.core.not_empty.call(null,without))?fulcro.client.impl.data_fetch.elide_ast_nodes.call(null,G__83183,without):G__83183);
if(cljs.core.truth_(params)){
return fulcro.client.impl.data_fetch.inject_query_params.call(null,G__83183__$1,params);
} else {
return G__83183__$1;
}
})();
var query_field = cljs.core.first.call(null,query);
var key = (cljs.core.truth_(om.util.join_QMARK_.call(null,query_field))?om.util.join_key.call(null,query_field):query_field);
var query_SINGLEQUOTE_ = om.next.ast__GT_query.call(null,ast);
if((cljs.core.not.call(null,field)) || (cljs.core._EQ_.call(null,field,key))){
} else {
throw (new Error(["Assert failed: ","Component fetch query does not match supplied field.","\n","(or (not field) (= field key))"].join('')));
}

return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword("fulcro.client.impl.data-fetch","uuid","fulcro.client.impl.data-fetch/uuid",1534451240),new cljs.core.Keyword("fulcro.client.impl.data-fetch","parallel","fulcro.client.impl.data-fetch/parallel",1010707051),new cljs.core.Keyword("fulcro.client.impl.data-fetch","target","fulcro.client.impl.data-fetch/target",1805324748),new cljs.core.Keyword("fulcro.client.impl.data-fetch","original-env","fulcro.client.impl.data-fetch/original-env",1405563884),new cljs.core.Keyword("fulcro.client.impl.data-fetch","remote","fulcro.client.impl.data-fetch/remote",340944109),new cljs.core.Keyword("fulcro.client.impl.data-fetch","query","fulcro.client.impl.data-fetch/query",-555583859),new cljs.core.Keyword("fulcro.client.impl.data-fetch","refresh","fulcro.client.impl.data-fetch/refresh",-12271976),new cljs.core.Keyword("fulcro.client.impl.data-fetch","ident","fulcro.client.impl.data-fetch/ident",1787247225),new cljs.core.Keyword("fulcro.client.impl.data-fetch","type","fulcro.client.impl.data-fetch/type",296514265),new cljs.core.Keyword("fulcro.client.impl.data-fetch","post-mutation-params","fulcro.client.impl.data-fetch/post-mutation-params",430524764),new cljs.core.Keyword("fulcro.client.impl.data-fetch","fallback","fulcro.client.impl.data-fetch/fallback",-644539810),new cljs.core.Keyword("fulcro.client.impl.data-fetch","marker","fulcro.client.impl.data-fetch/marker",392378046),new cljs.core.Keyword("fulcro.client.impl.data-fetch","post-mutation","fulcro.client.impl.data-fetch/post-mutation",-75376962),new cljs.core.Keyword("fulcro.client.impl.data-fetch","field","fulcro.client.impl.data-fetch/field",-439885921)],[[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.random_uuid.call(null))].join(''),parallel,target,cljs.core.with_meta.call(null,cljs.core.PersistentArrayMap.EMPTY,env),remote,query_SINGLEQUOTE_,refresh,ident,new cljs.core.Keyword(null,"ready","ready",1086465795),post_mutation_params,fallback,marker,post_mutation,field]);
});
/**
 * Place a ready-to-load marker into the application state. This should be done from
 *   a mutate function that is abstractly loading something. This is intended for internal use.
 * 
 *   See the `load` and `load-field` functions in `fulcro.client.data-fetch` for the public API.
 */
fulcro.client.impl.data_fetch.mark_ready = (function fulcro$client$impl$data_fetch$mark_ready(p__83197){
var map__83198 = p__83197;
var map__83198__$1 = ((((!((map__83198 == null)))?((((map__83198.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__83198.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__83198):map__83198);
var config = map__83198__$1;
var env = cljs.core.get.call(null,map__83198__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var state = cljs.core.get.call(null,env,new cljs.core.Keyword(null,"state","state",-1988618099));
var marker_QMARK_ = !((false === new cljs.core.Keyword(null,"marker","marker",865118313).cljs$core$IFn$_invoke$arity$1(config)));
var load_request = fulcro.client.impl.data_fetch.ready_state.call(null,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"marker","marker",865118313),true,new cljs.core.Keyword(null,"refresh","refresh",1947415525),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"without","without",1107036688),cljs.core.PersistentHashSet.EMPTY,new cljs.core.Keyword(null,"env","env",-1815813235),env], null),config));
return cljs.core.swap_BANG_.call(null,state,((function (state,marker_QMARK_,load_request,map__83198,map__83198__$1,config,env){
return (function (s){
var G__83200 = cljs.core.update.call(null,s,new cljs.core.Keyword("fulcro","ready-to-load","fulcro/ready-to-load",127104696),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),load_request);
if(marker_QMARK_){
return fulcro.client.impl.data_fetch.place_load_marker.call(null,G__83200,load_request);
} else {
return G__83200;
}
});})(state,marker_QMARK_,load_request,map__83198,map__83198__$1,config,env))
);
});
/**
 * Return the ident (if any) of the component related to the query in the data state marker. An ident is required
 *   to be present if the marker is targeting a field.
 */
fulcro.client.impl.data_fetch.data_target = (function fulcro$client$impl$data_fetch$data_target(state){
return new cljs.core.Keyword("fulcro.client.impl.data-fetch","target","fulcro.client.impl.data-fetch/target",1805324748).cljs$core$IFn$_invoke$arity$1(state);
});
/**
 * Return the ident (if any) of the component related to the query in the data state marker. An ident is required
 *   to be present if the marker is targeting a field.
 */
fulcro.client.impl.data_fetch.data_ident = (function fulcro$client$impl$data_fetch$data_ident(state){
return new cljs.core.Keyword("fulcro.client.impl.data-fetch","ident","fulcro.client.impl.data-fetch/ident",1787247225).cljs$core$IFn$_invoke$arity$1(state);
});
/**
 * Get the query that will be sent to the server as a result of the given data state marker
 */
fulcro.client.impl.data_fetch.data_query = (function fulcro$client$impl$data_fetch$data_query(state){
if(cljs.core.truth_(fulcro.client.impl.data_fetch.data_ident.call(null,state))){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentArrayMap.createAsIfByAssoc([fulcro.client.impl.data_fetch.data_ident.call(null,state),new cljs.core.Keyword("fulcro.client.impl.data-fetch","query","fulcro.client.impl.data-fetch/query",-555583859).cljs$core$IFn$_invoke$arity$1(state)])], null);
} else {
return new cljs.core.Keyword("fulcro.client.impl.data-fetch","query","fulcro.client.impl.data-fetch/query",-555583859).cljs$core$IFn$_invoke$arity$1(state);
}
});
/**
 * Get the target field (if any) from the data state marker
 */
fulcro.client.impl.data_fetch.data_field = (function fulcro$client$impl$data_fetch$data_field(state){
return new cljs.core.Keyword("fulcro.client.impl.data-fetch","field","fulcro.client.impl.data-fetch/field",-439885921).cljs$core$IFn$_invoke$arity$1(state);
});
/**
 * Get the UUID of the data fetch
 */
fulcro.client.impl.data_fetch.data_uuid = (function fulcro$client$impl$data_fetch$data_uuid(state){
return new cljs.core.Keyword("fulcro.client.impl.data-fetch","uuid","fulcro.client.impl.data-fetch/uuid",1534451240).cljs$core$IFn$_invoke$arity$1(state);
});
/**
 * Test if the user desires a copy of the state marker to appear in the app state at the data path of the target data.
 */
fulcro.client.impl.data_fetch.data_marker_QMARK_ = (function fulcro$client$impl$data_fetch$data_marker_QMARK_(state){
return new cljs.core.Keyword("fulcro.client.impl.data-fetch","marker","fulcro.client.impl.data-fetch/marker",392378046).cljs$core$IFn$_invoke$arity$1(state);
});
/**
 * Get the list of query keywords that should be refreshed (re-rendered) when this load completes.
 */
fulcro.client.impl.data_fetch.data_refresh = (function fulcro$client$impl$data_fetch$data_refresh(state){
return new cljs.core.Keyword("fulcro.client.impl.data-fetch","refresh","fulcro.client.impl.data-fetch/refresh",-12271976).cljs$core$IFn$_invoke$arity$1(state);
});
/**
 * Get the remote that this marker is meant to talk to
 */
fulcro.client.impl.data_fetch.data_remote = (function fulcro$client$impl$data_fetch$data_remote(state){
return new cljs.core.Keyword("fulcro.client.impl.data-fetch","remote","fulcro.client.impl.data-fetch/remote",340944109).cljs$core$IFn$_invoke$arity$1(state);
});
/**
 * Get the 'primary' query key of the data fetch. This is defined as the first keyword of the overall query (which might
 *   be a simple prop or join key for example)
 */
fulcro.client.impl.data_fetch.data_query_key = (function fulcro$client$impl$data_fetch$data_query_key(state){
var ast = om.next.query__GT_ast.call(null,new cljs.core.Keyword("fulcro.client.impl.data-fetch","query","fulcro.client.impl.data-fetch/query",-555583859).cljs$core$IFn$_invoke$arity$1(state));
var node = cljs.core.first.call(null,new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(ast));
return new cljs.core.Keyword(null,"key","key",-1516042587).cljs$core$IFn$_invoke$arity$1(node);
});
/**
 * Get the app-state database path of the target of the load that the given data state marker is trying to load.
 */
fulcro.client.impl.data_fetch.data_path = (function fulcro$client$impl$data_fetch$data_path(state){
var target = fulcro.client.impl.data_fetch.data_target.call(null,state);
if(cljs.core.truth_((function (){var and__28129__auto__ = (fulcro.client.impl.data_fetch.data_field.call(null,state) == null);
if(and__28129__auto__){
var and__28129__auto____$1 = cljs.core.vector_QMARK_.call(null,target);
if(and__28129__auto____$1){
return cljs.core.not_empty.call(null,target);
} else {
return and__28129__auto____$1;
}
} else {
return and__28129__auto__;
}
})())){
return target;
} else {
if((cljs.core.vector_QMARK_.call(null,fulcro.client.impl.data_fetch.data_ident.call(null,state))) && ((fulcro.client.impl.data_fetch.data_field.call(null,state) instanceof cljs.core.Keyword))){
return cljs.core.conj.call(null,fulcro.client.impl.data_fetch.data_ident.call(null,state),fulcro.client.impl.data_fetch.data_field.call(null,state));
} else {
if(om.util.ident_QMARK_.call(null,fulcro.client.impl.data_fetch.data_query_key.call(null,state))){
return fulcro.client.impl.data_fetch.data_query_key.call(null,state);
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fulcro.client.impl.data_fetch.data_query_key.call(null,state)], null);

}
}
}
});
/**
 * Get the parameters that the user wants to add to the first join/keyword of the data fetch query.
 */
fulcro.client.impl.data_fetch.data_params = (function fulcro$client$impl$data_fetch$data_params(state){
return new cljs.core.Keyword("fulcro.client.impl.data-fetch","params","fulcro.client.impl.data-fetch/params",1865690070).cljs$core$IFn$_invoke$arity$1(state);
});
/**
 * Get the keywords that should be (recursively) removed from the query that will be sent to the server.
 */
fulcro.client.impl.data_fetch.data_exclusions = (function fulcro$client$impl$data_fetch$data_exclusions(state){
return new cljs.core.Keyword("fulcro.client.impl.data-fetch","without","fulcro.client.impl.data-fetch/without",357489619).cljs$core$IFn$_invoke$arity$1(state);
});
var set_type = (function fulcro$client$impl$data_fetch$set_type(state,type,params){
return cljs.core.merge.call(null,state,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("fulcro.client.impl.data-fetch","type","fulcro.client.impl.data-fetch/type",296514265),type,new cljs.core.Keyword("fulcro.client.impl.data-fetch","params","fulcro.client.impl.data-fetch/params",1865690070),params], null));
});
/**
 * Returns a state (based on the input state) that is in the 'ready' to load state.
 */
fulcro.client.impl.data_fetch.set_ready_BANG_ = (function fulcro$client$impl$data_fetch$set_ready_BANG_(var_args){
var G__83217 = arguments.length;
switch (G__83217) {
case 1:
return fulcro.client.impl.data_fetch.set_ready_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fulcro.client.impl.data_fetch.set_ready_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fulcro.client.impl.data_fetch.set_ready_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (state){
return fulcro.client.impl.data_fetch.set_ready_BANG_.call(null,state,null);
});

fulcro.client.impl.data_fetch.set_ready_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (state,params){
return set_type.call(null,state,new cljs.core.Keyword(null,"ready","ready",1086465795),params);
});

fulcro.client.impl.data_fetch.set_ready_BANG_.cljs$lang$maxFixedArity = 2;


/**
 * Returns a marker (based on the input state) that is in the loading state (and ensures that it has a UUID)
 */
fulcro.client.impl.data_fetch.set_loading_BANG_ = (function fulcro$client$impl$data_fetch$set_loading_BANG_(var_args){
var G__83219 = arguments.length;
switch (G__83219) {
case 1:
return fulcro.client.impl.data_fetch.set_loading_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fulcro.client.impl.data_fetch.set_loading_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fulcro.client.impl.data_fetch.set_loading_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (state){
return fulcro.client.impl.data_fetch.set_loading_BANG_.call(null,state,null);
});

fulcro.client.impl.data_fetch.set_loading_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (state,params){
var rv = set_type.call(null,state,new cljs.core.Keyword(null,"loading","loading",-737050189),params);
return cljs.core.with_meta.call(null,rv,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"state","state",-1988618099),rv], null));
});

fulcro.client.impl.data_fetch.set_loading_BANG_.cljs$lang$maxFixedArity = 2;


/**
 * Returns a marker (based on the input state) that is in the error state
 */
fulcro.client.impl.data_fetch.set_failed_BANG_ = (function fulcro$client$impl$data_fetch$set_failed_BANG_(var_args){
var G__83221 = arguments.length;
switch (G__83221) {
case 1:
return fulcro.client.impl.data_fetch.set_failed_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fulcro.client.impl.data_fetch.set_failed_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fulcro.client.impl.data_fetch.set_failed_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (state){
return fulcro.client.impl.data_fetch.set_failed_BANG_.call(null,state,null);
});

fulcro.client.impl.data_fetch.set_failed_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (state,params){
return set_type.call(null,state,new cljs.core.Keyword(null,"failed","failed",-1397425762),params);
});

fulcro.client.impl.data_fetch.set_failed_BANG_.cljs$lang$maxFixedArity = 2;

/**
 * Composes together the queries of a sequence of data states into a single query.
 */
fulcro.client.impl.data_fetch.full_query = (function fulcro$client$impl$data_fetch$full_query(items){
return cljs.core.vec.call(null,cljs.core.mapcat.call(null,(function (item){
return fulcro.client.impl.data_fetch.data_query.call(null,item);
}),items));
});
fulcro.client.impl.data_fetch.set_global_loading = (function fulcro$client$impl$data_fetch$set_global_loading(reconciler){

var state_atom = om.next.app_state.call(null,reconciler);
var loading_QMARK_ = cljs.core.boolean$.call(null,cljs.core.seq.call(null,cljs.core.get.call(null,cljs.core.deref.call(null,state_atom),new cljs.core.Keyword("fulcro","loads-in-progress","fulcro/loads-in-progress",-1196090224))));
return cljs.core.swap_BANG_.call(null,state_atom,cljs.core.assoc,new cljs.core.Keyword("ui","loading-data","ui/loading-data",-1566515143),loading_QMARK_);
});
/**
 * For items that are manually targeted, move them in app state from their result location to their target location.
 */
fulcro.client.impl.data_fetch.relocate_targeted_results = (function fulcro$client$impl$data_fetch$relocate_targeted_results(state_atom,items){
return cljs.core.swap_BANG_.call(null,state_atom,(function (state_map){
return cljs.core.reduce.call(null,(function (state,item){
var default_target = fulcro.client.impl.data_fetch.data_query_key.call(null,item);
var explicit_target = (function (){var or__28141__auto__ = fulcro.client.impl.data_fetch.data_target.call(null,item);
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})();
var relocate_QMARK_ = (function (){var and__28129__auto__ = (fulcro.client.impl.data_fetch.data_field.call(null,item) == null);
if(and__28129__auto__){
var and__28129__auto____$1 = (fulcro.client.impl.data_fetch.data_query_key.call(null,item) instanceof cljs.core.Keyword);
if(and__28129__auto____$1){
return cljs.core.not_empty.call(null,explicit_target);
} else {
return and__28129__auto____$1;
}
} else {
return and__28129__auto__;
}
})();
if(cljs.core.truth_(relocate_QMARK_)){
var value = cljs.core.get.call(null,state,default_target);
return cljs.core.assoc_in.call(null,cljs.core.dissoc.call(null,state,fulcro.client.impl.data_fetch.data_query_key.call(null,item)),explicit_target,value);
} else {
return state;
}
}),state_map,items);
}));
});
/**
 * Returns app-state without the load marker for the given item.
 */
fulcro.client.impl.data_fetch.remove_marker = (function fulcro$client$impl$data_fetch$remove_marker(app_state,item){
var path = fulcro.client.impl.data_fetch.data_path.call(null,item);
var data = cljs.core.get_in.call(null,app_state,path);
if((cljs.core.map_QMARK_.call(null,data)) && (cljs.core._EQ_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("ui","fetch-state","ui/fetch-state",1030289927),null], null), null),cljs.core.set.call(null,cljs.core.keys.call(null,data))))){
return cljs.core.assoc_in.call(null,app_state,path,null);
} else {
if((cljs.core.map_QMARK_.call(null,data)) && (cljs.core.contains_QMARK_.call(null,data,new cljs.core.Keyword("ui","fetch-state","ui/fetch-state",1030289927)))){
return cljs.core.update_in.call(null,app_state,path,cljs.core.dissoc,new cljs.core.Keyword("ui","fetch-state","ui/fetch-state",1030289927));
} else {
return cljs.core.assoc_in.call(null,app_state,path,null);

}
}
});
/**
 * Build a callback env for post mutations and fallbacks
 */
fulcro.client.impl.data_fetch.callback_env = (function fulcro$client$impl$data_fetch$callback_env(reconciler,load_request,original_env){
var state = om.next.app_state.call(null,reconciler);
var map__83225 = load_request;
var map__83225__$1 = ((((!((map__83225 == null)))?((((map__83225.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__83225.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__83225):map__83225);
var parallel = cljs.core.get.call(null,map__83225__$1,new cljs.core.Keyword("fulcro.client.impl.data-fetch","parallel","fulcro.client.impl.data-fetch/parallel",1010707051));
var target = cljs.core.get.call(null,map__83225__$1,new cljs.core.Keyword("fulcro.client.impl.data-fetch","target","fulcro.client.impl.data-fetch/target",1805324748));
var remote = cljs.core.get.call(null,map__83225__$1,new cljs.core.Keyword("fulcro.client.impl.data-fetch","remote","fulcro.client.impl.data-fetch/remote",340944109));
var query = cljs.core.get.call(null,map__83225__$1,new cljs.core.Keyword("fulcro.client.impl.data-fetch","query","fulcro.client.impl.data-fetch/query",-555583859));
var refresh = cljs.core.get.call(null,map__83225__$1,new cljs.core.Keyword("fulcro.client.impl.data-fetch","refresh","fulcro.client.impl.data-fetch/refresh",-12271976));
var ident = cljs.core.get.call(null,map__83225__$1,new cljs.core.Keyword("fulcro.client.impl.data-fetch","ident","fulcro.client.impl.data-fetch/ident",1787247225));
var post_mutation_params = cljs.core.get.call(null,map__83225__$1,new cljs.core.Keyword("fulcro.client.impl.data-fetch","post-mutation-params","fulcro.client.impl.data-fetch/post-mutation-params",430524764));
var fallback = cljs.core.get.call(null,map__83225__$1,new cljs.core.Keyword("fulcro.client.impl.data-fetch","fallback","fulcro.client.impl.data-fetch/fallback",-644539810));
var marker = cljs.core.get.call(null,map__83225__$1,new cljs.core.Keyword("fulcro.client.impl.data-fetch","marker","fulcro.client.impl.data-fetch/marker",392378046));
var post_mutation = cljs.core.get.call(null,map__83225__$1,new cljs.core.Keyword("fulcro.client.impl.data-fetch","post-mutation","fulcro.client.impl.data-fetch/post-mutation",-75376962));
var field = cljs.core.get.call(null,map__83225__$1,new cljs.core.Keyword("fulcro.client.impl.data-fetch","field","fulcro.client.impl.data-fetch/field",-439885921));
return cljs.core.merge.call(null,original_env,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"state","state",-1988618099),state,new cljs.core.Keyword(null,"load-request","load-request",693664659),(function (){var G__83227 = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"target","target",253001721),target,new cljs.core.Keyword(null,"remote","remote",-1593576576),remote,new cljs.core.Keyword(null,"marker","marker",865118313),marker,new cljs.core.Keyword(null,"server-query","server-query",-191976706),query,new cljs.core.Keyword(null,"parallel","parallel",-1863607128),cljs.core.boolean$.call(null,parallel)], null);
var G__83227__$1 = (cljs.core.truth_(post_mutation)?cljs.core.assoc.call(null,G__83227,new cljs.core.Keyword(null,"post-mutation","post-mutation",-1076606705),post_mutation):G__83227);
var G__83227__$2 = (cljs.core.truth_(post_mutation_params)?cljs.core.assoc.call(null,G__83227__$1,new cljs.core.Keyword(null,"post-mutation-params","post-mutation-params",-849425897),post_mutation_params):G__83227__$1);
var G__83227__$3 = (cljs.core.truth_(refresh)?cljs.core.assoc.call(null,G__83227__$2,new cljs.core.Keyword(null,"refresh","refresh",1947415525),refresh):G__83227__$2);
if(cljs.core.truth_(fallback)){
return cljs.core.assoc.call(null,G__83227__$3,new cljs.core.Keyword(null,"fallback","fallback",761637929),fallback);
} else {
return G__83227__$3;
}
})()], null));
});
/**
 * Generates a callback that processes all of the post-processing steps once a remote load has completed. This includes:
 * 
 *   - Marking the items that were queries for but not returned as 'missing' (see documentation on mark and sweep of db)
 *   - Refreshing elements of the UI that were included in the data fetch :refresh option
 *   - Removing loading markers related to the executed loads that were not overwritten by incoming data
 *   - Merging the incoming data into the normalized database
 *   - Running post-mutations for any fetches that completed
 *   - Updating the global loading marker
 *   - Triggering re-render for all data item refresh lists
 *   
 */
fulcro.client.impl.data_fetch.loaded_callback = (function fulcro$client$impl$data_fetch$loaded_callback(reconciler){
return (function (response,items){
var query = fulcro.client.impl.data_fetch.full_query.call(null,items);
var loading_items = cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.map.call(null,fulcro.client.impl.data_fetch.set_loading_BANG_,items));
var refresh_set = cljs.core.into.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("ui","loading-data","ui/loading-data",-1566515143),null], null), null),cljs.core.mapcat.call(null,fulcro.client.impl.data_fetch.data_refresh,items));
var to_refresh = cljs.core.vec.call(null,refresh_set);
var marked_response = fulcro.client.impl.om_plumbing.mark_missing.call(null,response,query);
var app_state = om.next.app_state.call(null,reconciler);
var ran_mutations = cljs.core.atom.call(null,false);
var remove_markers = ((function (query,loading_items,refresh_set,to_refresh,marked_response,app_state,ran_mutations){
return (function (){
var seq__83228 = cljs.core.seq.call(null,loading_items);
var chunk__83229 = null;
var count__83230 = (0);
var i__83231 = (0);
while(true){
if((i__83231 < count__83230)){
var item = cljs.core._nth.call(null,chunk__83229,i__83231);
cljs.core.swap_BANG_.call(null,app_state,((function (seq__83228,chunk__83229,count__83230,i__83231,item,query,loading_items,refresh_set,to_refresh,marked_response,app_state,ran_mutations){
return (function (s){
var G__83232 = s;
var G__83232__$1 = cljs.core.update.call(null,G__83232,new cljs.core.Keyword("fulcro","loads-in-progress","fulcro/loads-in-progress",-1196090224),cljs.core.disj,fulcro.client.impl.data_fetch.data_uuid.call(null,item))
;
if(cljs.core.truth_(fulcro.client.impl.data_fetch.data_marker_QMARK_.call(null,item))){
return fulcro.client.impl.data_fetch.remove_marker.call(null,G__83232__$1,item);
} else {
return G__83232__$1;
}
});})(seq__83228,chunk__83229,count__83230,i__83231,item,query,loading_items,refresh_set,to_refresh,marked_response,app_state,ran_mutations))
);

var G__83240 = seq__83228;
var G__83241 = chunk__83229;
var G__83242 = count__83230;
var G__83243 = (i__83231 + (1));
seq__83228 = G__83240;
chunk__83229 = G__83241;
count__83230 = G__83242;
i__83231 = G__83243;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__83228);
if(temp__4657__auto__){
var seq__83228__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__83228__$1)){
var c__28980__auto__ = cljs.core.chunk_first.call(null,seq__83228__$1);
var G__83244 = cljs.core.chunk_rest.call(null,seq__83228__$1);
var G__83245 = c__28980__auto__;
var G__83246 = cljs.core.count.call(null,c__28980__auto__);
var G__83247 = (0);
seq__83228 = G__83244;
chunk__83229 = G__83245;
count__83230 = G__83246;
i__83231 = G__83247;
continue;
} else {
var item = cljs.core.first.call(null,seq__83228__$1);
cljs.core.swap_BANG_.call(null,app_state,((function (seq__83228,chunk__83229,count__83230,i__83231,item,seq__83228__$1,temp__4657__auto__,query,loading_items,refresh_set,to_refresh,marked_response,app_state,ran_mutations){
return (function (s){
var G__83233 = s;
var G__83233__$1 = cljs.core.update.call(null,G__83233,new cljs.core.Keyword("fulcro","loads-in-progress","fulcro/loads-in-progress",-1196090224),cljs.core.disj,fulcro.client.impl.data_fetch.data_uuid.call(null,item))
;
if(cljs.core.truth_(fulcro.client.impl.data_fetch.data_marker_QMARK_.call(null,item))){
return fulcro.client.impl.data_fetch.remove_marker.call(null,G__83233__$1,item);
} else {
return G__83233__$1;
}
});})(seq__83228,chunk__83229,count__83230,i__83231,item,seq__83228__$1,temp__4657__auto__,query,loading_items,refresh_set,to_refresh,marked_response,app_state,ran_mutations))
);

var G__83248 = cljs.core.next.call(null,seq__83228__$1);
var G__83249 = null;
var G__83250 = (0);
var G__83251 = (0);
seq__83228 = G__83248;
chunk__83229 = G__83249;
count__83230 = G__83250;
i__83231 = G__83251;
continue;
}
} else {
return null;
}
}
break;
}
});})(query,loading_items,refresh_set,to_refresh,marked_response,app_state,ran_mutations))
;
var run_post_mutations = ((function (query,loading_items,refresh_set,to_refresh,marked_response,app_state,ran_mutations,remove_markers){
return (function (){
var seq__83234 = cljs.core.seq.call(null,loading_items);
var chunk__83235 = null;
var count__83236 = (0);
var i__83237 = (0);
while(true){
if((i__83237 < count__83236)){
var item = cljs.core._nth.call(null,chunk__83235,i__83237);
var temp__4657__auto___83252 = new cljs.core.Keyword("fulcro.client.impl.data-fetch","post-mutation","fulcro.client.impl.data-fetch/post-mutation",-75376962).cljs$core$IFn$_invoke$arity$1(item);
if(cljs.core.truth_(temp__4657__auto___83252)){
var mutation_symbol_83253 = temp__4657__auto___83252;
cljs.core.reset_BANG_.call(null,ran_mutations,true);

var params_83254 = (function (){var or__28141__auto__ = new cljs.core.Keyword("fulcro.client.impl.data-fetch","post-mutation-params","fulcro.client.impl.data-fetch/post-mutation-params",430524764).cljs$core$IFn$_invoke$arity$1(item);
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
var original_env_83255 = cljs.core.meta.call(null,new cljs.core.Keyword("fulcro.client.impl.data-fetch","original-env","fulcro.client.impl.data-fetch/original-env",1405563884).cljs$core$IFn$_invoke$arity$1(item));
var G__83238_83256 = fulcro.client.mutations.mutate.call(null,fulcro.client.impl.data_fetch.callback_env.call(null,reconciler,item,original_env_83255),mutation_symbol_83253,params_83254);
var G__83238_83257__$1 = (((G__83238_83256 == null))?null:new cljs.core.Keyword(null,"action","action",-811238024).cljs$core$IFn$_invoke$arity$1(G__83238_83256));
if((G__83238_83257__$1 == null)){
} else {
cljs.core.apply.call(null,G__83238_83257__$1,cljs.core.PersistentVector.EMPTY);
}
} else {
}

var G__83258 = seq__83234;
var G__83259 = chunk__83235;
var G__83260 = count__83236;
var G__83261 = (i__83237 + (1));
seq__83234 = G__83258;
chunk__83235 = G__83259;
count__83236 = G__83260;
i__83237 = G__83261;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__83234);
if(temp__4657__auto__){
var seq__83234__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__83234__$1)){
var c__28980__auto__ = cljs.core.chunk_first.call(null,seq__83234__$1);
var G__83262 = cljs.core.chunk_rest.call(null,seq__83234__$1);
var G__83263 = c__28980__auto__;
var G__83264 = cljs.core.count.call(null,c__28980__auto__);
var G__83265 = (0);
seq__83234 = G__83262;
chunk__83235 = G__83263;
count__83236 = G__83264;
i__83237 = G__83265;
continue;
} else {
var item = cljs.core.first.call(null,seq__83234__$1);
var temp__4657__auto___83266__$1 = new cljs.core.Keyword("fulcro.client.impl.data-fetch","post-mutation","fulcro.client.impl.data-fetch/post-mutation",-75376962).cljs$core$IFn$_invoke$arity$1(item);
if(cljs.core.truth_(temp__4657__auto___83266__$1)){
var mutation_symbol_83267 = temp__4657__auto___83266__$1;
cljs.core.reset_BANG_.call(null,ran_mutations,true);

var params_83268 = (function (){var or__28141__auto__ = new cljs.core.Keyword("fulcro.client.impl.data-fetch","post-mutation-params","fulcro.client.impl.data-fetch/post-mutation-params",430524764).cljs$core$IFn$_invoke$arity$1(item);
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
var original_env_83269 = cljs.core.meta.call(null,new cljs.core.Keyword("fulcro.client.impl.data-fetch","original-env","fulcro.client.impl.data-fetch/original-env",1405563884).cljs$core$IFn$_invoke$arity$1(item));
var G__83239_83270 = fulcro.client.mutations.mutate.call(null,fulcro.client.impl.data_fetch.callback_env.call(null,reconciler,item,original_env_83269),mutation_symbol_83267,params_83268);
var G__83239_83271__$1 = (((G__83239_83270 == null))?null:new cljs.core.Keyword(null,"action","action",-811238024).cljs$core$IFn$_invoke$arity$1(G__83239_83270));
if((G__83239_83271__$1 == null)){
} else {
cljs.core.apply.call(null,G__83239_83271__$1,cljs.core.PersistentVector.EMPTY);
}
} else {
}

var G__83272 = cljs.core.next.call(null,seq__83234__$1);
var G__83273 = null;
var G__83274 = (0);
var G__83275 = (0);
seq__83234 = G__83272;
chunk__83235 = G__83273;
count__83236 = G__83274;
i__83237 = G__83275;
continue;
}
} else {
return null;
}
}
break;
}
});})(query,loading_items,refresh_set,to_refresh,marked_response,app_state,ran_mutations,remove_markers))
;
remove_markers.call(null);

om.next.merge_BANG_.call(null,reconciler,marked_response,query);

fulcro.client.impl.data_fetch.relocate_targeted_results.call(null,app_state,loading_items);

run_post_mutations.call(null);

fulcro.client.impl.data_fetch.set_global_loading.call(null,reconciler);

if(cljs.core.contains_QMARK_.call(null,refresh_set,new cljs.core.Keyword("fulcro","force-root","fulcro/force-root",1965847682))){
return om.next.force_root_render_BANG_.call(null,reconciler);
} else {
return fulcro.client.util.force_render.call(null,reconciler,to_refresh);
}
});
});
/**
 * Generates a callback that is used whenever a hard server error occurs (status code 400+ or network error).
 * 
 *   The generated callback:
 * 
 *   - Replaces affected loading markers with error markers (if :marker is true on the load item)
 *   - Runs fallbacks associated with the loads
 *   - Sets the global error marker (:fulcro/server-error)
 *   - Refreshes UI (from root if there were fallbacks)
 *   
 */
fulcro.client.impl.data_fetch.error_callback = (function fulcro$client$impl$data_fetch$error_callback(reconciler){
return (function (error,items){
var loading_items = cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.map.call(null,fulcro.client.impl.data_fetch.set_loading_BANG_,items));
var app_state = om.next.app_state.call(null,reconciler);
var refresh_set = cljs.core.into.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("ui","loading-data","ui/loading-data",-1566515143),null], null), null),cljs.core.mapcat.call(null,fulcro.client.impl.data_fetch.data_refresh,items));
var to_refresh = cljs.core.vec.call(null,refresh_set);
var ran_fallbacks = cljs.core.atom.call(null,false);
var mark_errors = ((function (loading_items,app_state,refresh_set,to_refresh,ran_fallbacks){
return (function (){
cljs.core.swap_BANG_.call(null,app_state,cljs.core.assoc,new cljs.core.Keyword("fulcro","server-error","fulcro/server-error",-1254037316),error);

var seq__83276 = cljs.core.seq.call(null,loading_items);
var chunk__83277 = null;
var count__83278 = (0);
var i__83279 = (0);
while(true){
if((i__83279 < count__83278)){
var item = cljs.core._nth.call(null,chunk__83277,i__83279);
cljs.core.swap_BANG_.call(null,app_state,((function (seq__83276,chunk__83277,count__83278,i__83279,item,loading_items,app_state,refresh_set,to_refresh,ran_fallbacks){
return (function (s){
var G__83280 = s;
var G__83280__$1 = (cljs.core.truth_(fulcro.client.impl.data_fetch.data_marker_QMARK_.call(null,item))?cljs.core.update_in.call(null,G__83280,cljs.core.conj.call(null,fulcro.client.impl.data_fetch.data_path.call(null,item),new cljs.core.Keyword("ui","fetch-state","ui/fetch-state",1030289927)),fulcro.client.impl.data_fetch.set_failed_BANG_,error):G__83280);
return cljs.core.update.call(null,G__83280__$1,new cljs.core.Keyword("fulcro","loads-in-progress","fulcro/loads-in-progress",-1196090224),cljs.core.disj,fulcro.client.impl.data_fetch.data_uuid.call(null,item));

});})(seq__83276,chunk__83277,count__83278,i__83279,item,loading_items,app_state,refresh_set,to_refresh,ran_fallbacks))
);

var G__83288 = seq__83276;
var G__83289 = chunk__83277;
var G__83290 = count__83278;
var G__83291 = (i__83279 + (1));
seq__83276 = G__83288;
chunk__83277 = G__83289;
count__83278 = G__83290;
i__83279 = G__83291;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__83276);
if(temp__4657__auto__){
var seq__83276__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__83276__$1)){
var c__28980__auto__ = cljs.core.chunk_first.call(null,seq__83276__$1);
var G__83292 = cljs.core.chunk_rest.call(null,seq__83276__$1);
var G__83293 = c__28980__auto__;
var G__83294 = cljs.core.count.call(null,c__28980__auto__);
var G__83295 = (0);
seq__83276 = G__83292;
chunk__83277 = G__83293;
count__83278 = G__83294;
i__83279 = G__83295;
continue;
} else {
var item = cljs.core.first.call(null,seq__83276__$1);
cljs.core.swap_BANG_.call(null,app_state,((function (seq__83276,chunk__83277,count__83278,i__83279,item,seq__83276__$1,temp__4657__auto__,loading_items,app_state,refresh_set,to_refresh,ran_fallbacks){
return (function (s){
var G__83281 = s;
var G__83281__$1 = (cljs.core.truth_(fulcro.client.impl.data_fetch.data_marker_QMARK_.call(null,item))?cljs.core.update_in.call(null,G__83281,cljs.core.conj.call(null,fulcro.client.impl.data_fetch.data_path.call(null,item),new cljs.core.Keyword("ui","fetch-state","ui/fetch-state",1030289927)),fulcro.client.impl.data_fetch.set_failed_BANG_,error):G__83281);
return cljs.core.update.call(null,G__83281__$1,new cljs.core.Keyword("fulcro","loads-in-progress","fulcro/loads-in-progress",-1196090224),cljs.core.disj,fulcro.client.impl.data_fetch.data_uuid.call(null,item));

});})(seq__83276,chunk__83277,count__83278,i__83279,item,seq__83276__$1,temp__4657__auto__,loading_items,app_state,refresh_set,to_refresh,ran_fallbacks))
);

var G__83298 = cljs.core.next.call(null,seq__83276__$1);
var G__83299 = null;
var G__83300 = (0);
var G__83301 = (0);
seq__83276 = G__83298;
chunk__83277 = G__83299;
count__83278 = G__83300;
i__83279 = G__83301;
continue;
}
} else {
return null;
}
}
break;
}
});})(loading_items,app_state,refresh_set,to_refresh,ran_fallbacks))
;
var run_fallbacks = ((function (loading_items,app_state,refresh_set,to_refresh,ran_fallbacks,mark_errors){
return (function (){
var seq__83282 = cljs.core.seq.call(null,loading_items);
var chunk__83283 = null;
var count__83284 = (0);
var i__83285 = (0);
while(true){
if((i__83285 < count__83284)){
var item = cljs.core._nth.call(null,chunk__83283,i__83285);
var temp__4657__auto___83302 = new cljs.core.Keyword("fulcro.client.impl.data-fetch","fallback","fulcro.client.impl.data-fetch/fallback",-644539810).cljs$core$IFn$_invoke$arity$1(item);
if(cljs.core.truth_(temp__4657__auto___83302)){
var fallback_symbol_83307 = temp__4657__auto___83302;
var original_env_83308 = cljs.core.meta.call(null,new cljs.core.Keyword("fulcro.client.impl.data-fetch","original-env","fulcro.client.impl.data-fetch/original-env",1405563884).cljs$core$IFn$_invoke$arity$1(item));
var env_83309 = fulcro.client.impl.data_fetch.callback_env.call(null,reconciler,item,original_env_83308);
cljs.core.reset_BANG_.call(null,ran_fallbacks,true);

var G__83286_83310 = fulcro.client.mutations.mutate.call(null,env_83309,fallback_symbol_83307,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"error","error",-978969032),error], null));
var G__83286_83311__$1 = (((G__83286_83310 == null))?null:new cljs.core.Keyword(null,"action","action",-811238024).cljs$core$IFn$_invoke$arity$1(G__83286_83310));
if((G__83286_83311__$1 == null)){
} else {
cljs.core.apply.call(null,G__83286_83311__$1,cljs.core.PersistentVector.EMPTY);
}
} else {
}

var G__83312 = seq__83282;
var G__83313 = chunk__83283;
var G__83314 = count__83284;
var G__83315 = (i__83285 + (1));
seq__83282 = G__83312;
chunk__83283 = G__83313;
count__83284 = G__83314;
i__83285 = G__83315;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__83282);
if(temp__4657__auto__){
var seq__83282__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__83282__$1)){
var c__28980__auto__ = cljs.core.chunk_first.call(null,seq__83282__$1);
var G__83317 = cljs.core.chunk_rest.call(null,seq__83282__$1);
var G__83318 = c__28980__auto__;
var G__83319 = cljs.core.count.call(null,c__28980__auto__);
var G__83320 = (0);
seq__83282 = G__83317;
chunk__83283 = G__83318;
count__83284 = G__83319;
i__83285 = G__83320;
continue;
} else {
var item = cljs.core.first.call(null,seq__83282__$1);
var temp__4657__auto___83324__$1 = new cljs.core.Keyword("fulcro.client.impl.data-fetch","fallback","fulcro.client.impl.data-fetch/fallback",-644539810).cljs$core$IFn$_invoke$arity$1(item);
if(cljs.core.truth_(temp__4657__auto___83324__$1)){
var fallback_symbol_83325 = temp__4657__auto___83324__$1;
var original_env_83326 = cljs.core.meta.call(null,new cljs.core.Keyword("fulcro.client.impl.data-fetch","original-env","fulcro.client.impl.data-fetch/original-env",1405563884).cljs$core$IFn$_invoke$arity$1(item));
var env_83327 = fulcro.client.impl.data_fetch.callback_env.call(null,reconciler,item,original_env_83326);
cljs.core.reset_BANG_.call(null,ran_fallbacks,true);

var G__83287_83328 = fulcro.client.mutations.mutate.call(null,env_83327,fallback_symbol_83325,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"error","error",-978969032),error], null));
var G__83287_83329__$1 = (((G__83287_83328 == null))?null:new cljs.core.Keyword(null,"action","action",-811238024).cljs$core$IFn$_invoke$arity$1(G__83287_83328));
if((G__83287_83329__$1 == null)){
} else {
cljs.core.apply.call(null,G__83287_83329__$1,cljs.core.PersistentVector.EMPTY);
}
} else {
}

var G__83330 = cljs.core.next.call(null,seq__83282__$1);
var G__83331 = null;
var G__83332 = (0);
var G__83333 = (0);
seq__83282 = G__83330;
chunk__83283 = G__83331;
count__83284 = G__83332;
i__83285 = G__83333;
continue;
}
} else {
return null;
}
}
break;
}
});})(loading_items,app_state,refresh_set,to_refresh,ran_fallbacks,mark_errors))
;
mark_errors.call(null);

run_fallbacks.call(null);

fulcro.client.impl.data_fetch.set_global_loading.call(null,reconciler);

return om.next.force_root_render_BANG_.call(null,reconciler);
});
});

//# sourceMappingURL=data_fetch.js.map?rel=1511229599431
