// Compiled by ClojureScript 1.9.946 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('figwheel.client.utils');
goog.require('goog.Uri');
goog.require('goog.string');
goog.require('goog.object');
goog.require('goog.net.jsloader');
goog.require('goog.html.legacyconversions');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.core.async');
goog.require('goog.async.Deferred');
if(typeof figwheel.client.file_reloading.figwheel_meta_pragmas !== 'undefined'){
} else {
figwheel.client.file_reloading.figwheel_meta_pragmas = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.on_cssload_custom_event = (function figwheel$client$file_reloading$on_cssload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.css-reload",files);
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__28141__auto__ = (cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && (((new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) == null)) || (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string')) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372)));
if(or__28141__auto__){
return or__28141__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.name__GT_path = (function figwheel$client$file_reloading$name__GT_path(ns){

return goog.object.get(goog.dependencies_.nameToPath,ns);
});
figwheel.client.file_reloading.provided_QMARK_ = (function figwheel$client$file_reloading$provided_QMARK_(ns){
return goog.object.get(goog.dependencies_.written,figwheel.client.file_reloading.name__GT_path.call(null,ns));
});
figwheel.client.file_reloading.immutable_ns_QMARK_ = (function figwheel$client$file_reloading$immutable_ns_QMARK_(name){
var or__28141__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, ["cljs.nodejs",null,"goog",null,"cljs.core",null], null), null).call(null,name);
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
var or__28141__auto____$1 = goog.string.startsWith("clojure.",name);
if(cljs.core.truth_(or__28141__auto____$1)){
return or__28141__auto____$1;
} else {
return goog.string.startsWith("goog.",name);
}
}
});
figwheel.client.file_reloading.get_requires = (function figwheel$client$file_reloading$get_requires(ns){
return cljs.core.set.call(null,cljs.core.filter.call(null,(function (p1__71537_SHARP_){
return cljs.core.not.call(null,figwheel.client.file_reloading.immutable_ns_QMARK_.call(null,p1__71537_SHARP_));
}),goog.object.getKeys(goog.object.get(goog.dependencies_.requires,figwheel.client.file_reloading.name__GT_path.call(null,ns)))));
});
if(typeof figwheel.client.file_reloading.dependency_data !== 'undefined'){
} else {
figwheel.client.file_reloading.dependency_data = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"dependents","dependents",136812837),cljs.core.PersistentArrayMap.EMPTY], null));
}
figwheel.client.file_reloading.path_to_name_BANG_ = (function figwheel$client$file_reloading$path_to_name_BANG_(path,name){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([name]));
});
/**
 * Setup a path to name dependencies map.
 * That goes from path -> #{ ns-names }
 */
figwheel.client.file_reloading.setup_path__GT_name_BANG_ = (function figwheel$client$file_reloading$setup_path__GT_name_BANG_(){
var nameToPath = goog.object.filter(goog.dependencies_.nameToPath,(function (v,k,o){
return goog.string.startsWith(v,"../");
}));
return goog.object.forEach(nameToPath,((function (nameToPath){
return (function (v,k,o){
return figwheel.client.file_reloading.path_to_name_BANG_.call(null,v,k);
});})(nameToPath))
);
});
/**
 * returns a set of namespaces defined by a path
 */
figwheel.client.file_reloading.path__GT_name = (function figwheel$client$file_reloading$path__GT_name(path){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null));
});
figwheel.client.file_reloading.name_to_parent_BANG_ = (function figwheel$client$file_reloading$name_to_parent_BANG_(ns,parent_ns){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([parent_ns]));
});
/**
 * This reverses the goog.dependencies_.requires for looking up ns-dependents.
 */
figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_ = (function figwheel$client$file_reloading$setup_ns__GT_dependents_BANG_(){
var requires = goog.object.filter(goog.dependencies_.requires,(function (v,k,o){
return goog.string.startsWith(k,"../");
}));
return goog.object.forEach(requires,((function (requires){
return (function (v,k,_){
return goog.object.forEach(v,((function (requires){
return (function (v_SINGLEQUOTE_,k_SINGLEQUOTE_,___$1){
var seq__71597 = cljs.core.seq.call(null,figwheel.client.file_reloading.path__GT_name.call(null,k));
var chunk__71598 = null;
var count__71599 = (0);
var i__71600 = (0);
while(true){
if((i__71600 < count__71599)){
var n = cljs.core._nth.call(null,chunk__71598,i__71600);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__71618 = seq__71597;
var G__71619 = chunk__71598;
var G__71620 = count__71599;
var G__71621 = (i__71600 + (1));
seq__71597 = G__71618;
chunk__71598 = G__71619;
count__71599 = G__71620;
i__71600 = G__71621;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__71597);
if(temp__4657__auto__){
var seq__71597__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__71597__$1)){
var c__28980__auto__ = cljs.core.chunk_first.call(null,seq__71597__$1);
var G__71622 = cljs.core.chunk_rest.call(null,seq__71597__$1);
var G__71623 = c__28980__auto__;
var G__71624 = cljs.core.count.call(null,c__28980__auto__);
var G__71625 = (0);
seq__71597 = G__71622;
chunk__71598 = G__71623;
count__71599 = G__71624;
i__71600 = G__71625;
continue;
} else {
var n = cljs.core.first.call(null,seq__71597__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__71626 = cljs.core.next.call(null,seq__71597__$1);
var G__71627 = null;
var G__71628 = (0);
var G__71629 = (0);
seq__71597 = G__71626;
chunk__71598 = G__71627;
count__71599 = G__71628;
i__71600 = G__71629;
continue;
}
} else {
return null;
}
}
break;
}
});})(requires))
);
});})(requires))
);
});
figwheel.client.file_reloading.ns__GT_dependents = (function figwheel$client$file_reloading$ns__GT_dependents(ns){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null));
});
figwheel.client.file_reloading.build_topo_sort = (function figwheel$client$file_reloading$build_topo_sort(get_deps){
var get_deps__$1 = cljs.core.memoize.call(null,get_deps);
var topo_sort_helper_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_topo_sort_helper_STAR_(x,depth,state){
var deps = get_deps__$1.call(null,x);
if(cljs.core.empty_QMARK_.call(null,deps)){
return null;
} else {
return topo_sort_STAR_.call(null,deps,depth,state);
}
});})(get_deps__$1))
;
var topo_sort_STAR_ = ((function (get_deps__$1){
return (function() {
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = null;
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1 = (function (deps){
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.call(null,deps,(0),cljs.core.atom.call(null,cljs.core.sorted_map.call(null)));
});
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3 = (function (deps,depth,state){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [depth], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),deps);

var seq__71640_71652 = cljs.core.seq.call(null,deps);
var chunk__71641_71653 = null;
var count__71642_71654 = (0);
var i__71643_71655 = (0);
while(true){
if((i__71643_71655 < count__71642_71654)){
var dep_71657 = cljs.core._nth.call(null,chunk__71641_71653,i__71643_71655);
topo_sort_helper_STAR_.call(null,dep_71657,(depth + (1)),state);

var G__71662 = seq__71640_71652;
var G__71663 = chunk__71641_71653;
var G__71664 = count__71642_71654;
var G__71665 = (i__71643_71655 + (1));
seq__71640_71652 = G__71662;
chunk__71641_71653 = G__71663;
count__71642_71654 = G__71664;
i__71643_71655 = G__71665;
continue;
} else {
var temp__4657__auto___71666 = cljs.core.seq.call(null,seq__71640_71652);
if(temp__4657__auto___71666){
var seq__71640_71667__$1 = temp__4657__auto___71666;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__71640_71667__$1)){
var c__28980__auto___71671 = cljs.core.chunk_first.call(null,seq__71640_71667__$1);
var G__71674 = cljs.core.chunk_rest.call(null,seq__71640_71667__$1);
var G__71675 = c__28980__auto___71671;
var G__71676 = cljs.core.count.call(null,c__28980__auto___71671);
var G__71677 = (0);
seq__71640_71652 = G__71674;
chunk__71641_71653 = G__71675;
count__71642_71654 = G__71676;
i__71643_71655 = G__71677;
continue;
} else {
var dep_71689 = cljs.core.first.call(null,seq__71640_71667__$1);
topo_sort_helper_STAR_.call(null,dep_71689,(depth + (1)),state);

var G__71706 = cljs.core.next.call(null,seq__71640_71667__$1);
var G__71707 = null;
var G__71708 = (0);
var G__71709 = (0);
seq__71640_71652 = G__71706;
chunk__71641_71653 = G__71707;
count__71642_71654 = G__71708;
i__71643_71655 = G__71709;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,depth,(0))){
return elim_dups_STAR_.call(null,cljs.core.reverse.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,state))));
} else {
return null;
}
});
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = function(deps,depth,state){
switch(arguments.length){
case 1:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1.call(this,deps);
case 3:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3.call(this,deps,depth,state);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1;
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$3 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3;
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_;
})()
;})(get_deps__$1))
;
var elim_dups_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_(p__71644){
var vec__71645 = p__71644;
var seq__71646 = cljs.core.seq.call(null,vec__71645);
var first__71647 = cljs.core.first.call(null,seq__71646);
var seq__71646__$1 = cljs.core.next.call(null,seq__71646);
var x = first__71647;
var xs = seq__71646__$1;
if((x == null)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.cons.call(null,x,figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_.call(null,cljs.core.map.call(null,((function (vec__71645,seq__71646,first__71647,seq__71646__$1,x,xs,get_deps__$1){
return (function (p1__71630_SHARP_){
return clojure.set.difference.call(null,p1__71630_SHARP_,x);
});})(vec__71645,seq__71646,first__71647,seq__71646__$1,x,xs,get_deps__$1))
,xs)));
}
});})(get_deps__$1))
;
return topo_sort_STAR_;
});
figwheel.client.file_reloading.get_all_dependencies = (function figwheel$client$file_reloading$get_all_dependencies(ns){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.get_requires);
return cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns], null))));
});
figwheel.client.file_reloading.get_all_dependents = (function figwheel$client$file_reloading$get_all_dependents(nss){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.ns__GT_dependents);
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,figwheel.client.file_reloading.immutable_ns_QMARK_),cljs.core.reverse.call(null,cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,nss)))));
});
figwheel.client.file_reloading.unprovide_BANG_ = (function figwheel$client$file_reloading$unprovide_BANG_(ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.dependencies_.visited,path);

goog.object.remove(goog.dependencies_.written,path);

return goog.object.remove(goog.dependencies_.written,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(path)].join(''));
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_reloading.name__GT_path.call(null,ns))].join('');
});
figwheel.client.file_reloading.addDependency = (function figwheel$client$file_reloading$addDependency(path,provides,requires){
var seq__71824 = cljs.core.seq.call(null,provides);
var chunk__71825 = null;
var count__71826 = (0);
var i__71827 = (0);
while(true){
if((i__71827 < count__71826)){
var prov = cljs.core._nth.call(null,chunk__71825,i__71827);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__71830_71853 = cljs.core.seq.call(null,requires);
var chunk__71831_71854 = null;
var count__71832_71855 = (0);
var i__71833_71856 = (0);
while(true){
if((i__71833_71856 < count__71832_71855)){
var req_71860 = cljs.core._nth.call(null,chunk__71831_71854,i__71833_71856);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_71860,prov);

var G__71863 = seq__71830_71853;
var G__71864 = chunk__71831_71854;
var G__71865 = count__71832_71855;
var G__71866 = (i__71833_71856 + (1));
seq__71830_71853 = G__71863;
chunk__71831_71854 = G__71864;
count__71832_71855 = G__71865;
i__71833_71856 = G__71866;
continue;
} else {
var temp__4657__auto___71869 = cljs.core.seq.call(null,seq__71830_71853);
if(temp__4657__auto___71869){
var seq__71830_71871__$1 = temp__4657__auto___71869;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__71830_71871__$1)){
var c__28980__auto___71873 = cljs.core.chunk_first.call(null,seq__71830_71871__$1);
var G__71874 = cljs.core.chunk_rest.call(null,seq__71830_71871__$1);
var G__71875 = c__28980__auto___71873;
var G__71876 = cljs.core.count.call(null,c__28980__auto___71873);
var G__71877 = (0);
seq__71830_71853 = G__71874;
chunk__71831_71854 = G__71875;
count__71832_71855 = G__71876;
i__71833_71856 = G__71877;
continue;
} else {
var req_71879 = cljs.core.first.call(null,seq__71830_71871__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_71879,prov);

var G__71882 = cljs.core.next.call(null,seq__71830_71871__$1);
var G__71883 = null;
var G__71884 = (0);
var G__71885 = (0);
seq__71830_71853 = G__71882;
chunk__71831_71854 = G__71883;
count__71832_71855 = G__71884;
i__71833_71856 = G__71885;
continue;
}
} else {
}
}
break;
}

var G__71889 = seq__71824;
var G__71890 = chunk__71825;
var G__71891 = count__71826;
var G__71892 = (i__71827 + (1));
seq__71824 = G__71889;
chunk__71825 = G__71890;
count__71826 = G__71891;
i__71827 = G__71892;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__71824);
if(temp__4657__auto__){
var seq__71824__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__71824__$1)){
var c__28980__auto__ = cljs.core.chunk_first.call(null,seq__71824__$1);
var G__71894 = cljs.core.chunk_rest.call(null,seq__71824__$1);
var G__71895 = c__28980__auto__;
var G__71896 = cljs.core.count.call(null,c__28980__auto__);
var G__71897 = (0);
seq__71824 = G__71894;
chunk__71825 = G__71895;
count__71826 = G__71896;
i__71827 = G__71897;
continue;
} else {
var prov = cljs.core.first.call(null,seq__71824__$1);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__71842_71901 = cljs.core.seq.call(null,requires);
var chunk__71843_71902 = null;
var count__71844_71903 = (0);
var i__71845_71904 = (0);
while(true){
if((i__71845_71904 < count__71844_71903)){
var req_71905 = cljs.core._nth.call(null,chunk__71843_71902,i__71845_71904);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_71905,prov);

var G__71908 = seq__71842_71901;
var G__71909 = chunk__71843_71902;
var G__71910 = count__71844_71903;
var G__71911 = (i__71845_71904 + (1));
seq__71842_71901 = G__71908;
chunk__71843_71902 = G__71909;
count__71844_71903 = G__71910;
i__71845_71904 = G__71911;
continue;
} else {
var temp__4657__auto___71912__$1 = cljs.core.seq.call(null,seq__71842_71901);
if(temp__4657__auto___71912__$1){
var seq__71842_71913__$1 = temp__4657__auto___71912__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__71842_71913__$1)){
var c__28980__auto___71914 = cljs.core.chunk_first.call(null,seq__71842_71913__$1);
var G__71916 = cljs.core.chunk_rest.call(null,seq__71842_71913__$1);
var G__71917 = c__28980__auto___71914;
var G__71918 = cljs.core.count.call(null,c__28980__auto___71914);
var G__71919 = (0);
seq__71842_71901 = G__71916;
chunk__71843_71902 = G__71917;
count__71844_71903 = G__71918;
i__71845_71904 = G__71919;
continue;
} else {
var req_71920 = cljs.core.first.call(null,seq__71842_71913__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_71920,prov);

var G__71921 = cljs.core.next.call(null,seq__71842_71913__$1);
var G__71922 = null;
var G__71923 = (0);
var G__71924 = (0);
seq__71842_71901 = G__71921;
chunk__71843_71902 = G__71922;
count__71844_71903 = G__71923;
i__71845_71904 = G__71924;
continue;
}
} else {
}
}
break;
}

var G__71926 = cljs.core.next.call(null,seq__71824__$1);
var G__71927 = null;
var G__71928 = (0);
var G__71929 = (0);
seq__71824 = G__71926;
chunk__71825 = G__71927;
count__71826 = G__71928;
i__71827 = G__71929;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.file_reloading.figwheel_require = (function figwheel$client$file_reloading$figwheel_require(src,reload){
goog.require = figwheel.client.file_reloading.figwheel_require;

if(cljs.core._EQ_.call(null,reload,"reload-all")){
var seq__71935_71940 = cljs.core.seq.call(null,figwheel.client.file_reloading.get_all_dependencies.call(null,src));
var chunk__71936_71941 = null;
var count__71937_71942 = (0);
var i__71938_71943 = (0);
while(true){
if((i__71938_71943 < count__71937_71942)){
var ns_71944 = cljs.core._nth.call(null,chunk__71936_71941,i__71938_71943);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_71944);

var G__71947 = seq__71935_71940;
var G__71948 = chunk__71936_71941;
var G__71949 = count__71937_71942;
var G__71950 = (i__71938_71943 + (1));
seq__71935_71940 = G__71947;
chunk__71936_71941 = G__71948;
count__71937_71942 = G__71949;
i__71938_71943 = G__71950;
continue;
} else {
var temp__4657__auto___71951 = cljs.core.seq.call(null,seq__71935_71940);
if(temp__4657__auto___71951){
var seq__71935_71952__$1 = temp__4657__auto___71951;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__71935_71952__$1)){
var c__28980__auto___71953 = cljs.core.chunk_first.call(null,seq__71935_71952__$1);
var G__71954 = cljs.core.chunk_rest.call(null,seq__71935_71952__$1);
var G__71955 = c__28980__auto___71953;
var G__71956 = cljs.core.count.call(null,c__28980__auto___71953);
var G__71957 = (0);
seq__71935_71940 = G__71954;
chunk__71936_71941 = G__71955;
count__71937_71942 = G__71956;
i__71938_71943 = G__71957;
continue;
} else {
var ns_71959 = cljs.core.first.call(null,seq__71935_71952__$1);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_71959);

var G__71960 = cljs.core.next.call(null,seq__71935_71952__$1);
var G__71961 = null;
var G__71962 = (0);
var G__71963 = (0);
seq__71935_71940 = G__71960;
chunk__71936_71941 = G__71961;
count__71937_71942 = G__71962;
i__71938_71943 = G__71963;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(reload)){
figwheel.client.file_reloading.unprovide_BANG_.call(null,src);
} else {
}

return goog.require_figwheel_backup_(src);
});
/**
 * Reusable browser REPL bootstrapping. Patches the essential functions
 *   in goog.base to support re-loading of namespaces after page load.
 */
figwheel.client.file_reloading.bootstrap_goog_base = (function figwheel$client$file_reloading$bootstrap_goog_base(){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
goog.require_figwheel_backup_ = (function (){var or__28141__auto__ = goog.require__;
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
return goog.require;
}
})();

goog.isProvided_ = (function (name){
return false;
});

figwheel.client.file_reloading.setup_path__GT_name_BANG_.call(null);

figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_.call(null);

goog.addDependency_figwheel_backup_ = goog.addDependency;

goog.addDependency = (function() { 
var G__71974__delegate = function (args){
cljs.core.apply.call(null,figwheel.client.file_reloading.addDependency,args);

return cljs.core.apply.call(null,goog.addDependency_figwheel_backup_,args);
};
var G__71974 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__71976__i = 0, G__71976__a = new Array(arguments.length -  0);
while (G__71976__i < G__71976__a.length) {G__71976__a[G__71976__i] = arguments[G__71976__i + 0]; ++G__71976__i;}
  args = new cljs.core.IndexedSeq(G__71976__a,0,null);
} 
return G__71974__delegate.call(this,args);};
G__71974.cljs$lang$maxFixedArity = 0;
G__71974.cljs$lang$applyTo = (function (arglist__71977){
var args = cljs.core.seq(arglist__71977);
return G__71974__delegate(args);
});
G__71974.cljs$core$IFn$_invoke$arity$variadic = G__71974__delegate;
return G__71974;
})()
;

goog.constructNamespace_("cljs.user");

goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.queued_file_reload;

return goog.require = figwheel.client.file_reloading.figwheel_require;
}
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
if(typeof figwheel.client.file_reloading.bootstrapped_cljs !== 'undefined'){
return null;
} else {
return (
figwheel.client.file_reloading.bootstrapped_cljs = (function (){
figwheel.client.file_reloading.bootstrap_goog_base.call(null);

return true;
})()
)
;
}
});
figwheel.client.file_reloading.gloader = ((typeof goog.net.jsloader.safeLoad !== 'undefined')?(function (p1__71980_SHARP_,p2__71981_SHARP_){
return goog.net.jsloader.safeLoad(goog.html.legacyconversions.trustedResourceUrlFromString([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__71980_SHARP_)].join('')),p2__71981_SHARP_);
}):((typeof goog.net.jsloader.load !== 'undefined')?(function (p1__71982_SHARP_,p2__71983_SHARP_){
return goog.net.jsloader.load([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__71982_SHARP_)].join(''),p2__71983_SHARP_);
}):(function(){throw cljs.core.ex_info.call(null,"No remote script loading function found.",cljs.core.PersistentArrayMap.EMPTY)})()
));
figwheel.client.file_reloading.reload_file_in_html_env = (function figwheel$client$file_reloading$reload_file_in_html_env(request_url,callback){

var G__71988 = figwheel.client.file_reloading.gloader.call(null,figwheel.client.file_reloading.add_cache_buster.call(null,request_url),({"cleanupWhenDone": true}));
G__71988.addCallback(((function (G__71988){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(G__71988))
);

G__71988.addErrback(((function (G__71988){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(G__71988))
);

return G__71988;
});
figwheel.client.file_reloading.reload_file_STAR_ = (function (){var pred__71995 = cljs.core._EQ_;
var expr__71996 = figwheel.client.utils.host_env_QMARK_.call(null);
if(cljs.core.truth_(pred__71995.call(null,new cljs.core.Keyword(null,"node","node",581201198),expr__71996))){
var node_path_lib = require("path");
var util_pattern = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_path_lib.sep),cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_path_lib.join("goog","bootstrap","nodejs.js"))].join('');
var util_path = goog.object.findKey(require.cache,((function (node_path_lib,util_pattern,pred__71995,expr__71996){
return (function (v,k,o){
return goog.string.endsWith(k,util_pattern);
});})(node_path_lib,util_pattern,pred__71995,expr__71996))
);
var parts = cljs.core.pop.call(null,cljs.core.pop.call(null,clojure.string.split.call(null,util_path,/[\/\\]/)));
var root_path = clojure.string.join.call(null,node_path_lib.sep,parts);
return ((function (node_path_lib,util_pattern,util_path,parts,root_path,pred__71995,expr__71996){
return (function (request_url,callback){

var cache_path = node_path_lib.resolve(root_path,request_url);
goog.object.remove(require.cache,cache_path);

return callback.call(null,(function (){try{return require(cache_path);
}catch (e71999){if((e71999 instanceof Error)){
var e = e71999;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cache_path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e71999;

}
}})());
});
;})(node_path_lib,util_pattern,util_path,parts,root_path,pred__71995,expr__71996))
} else {
if(cljs.core.truth_(pred__71995.call(null,new cljs.core.Keyword(null,"html","html",-998796897),expr__71996))){
return figwheel.client.file_reloading.reload_file_in_html_env;
} else {
if(cljs.core.truth_(pred__71995.call(null,new cljs.core.Keyword(null,"react-native","react-native",-1543085138),expr__71996))){
return figwheel.client.file_reloading.reload_file_in_html_env;
} else {
if(cljs.core.truth_(pred__71995.call(null,new cljs.core.Keyword(null,"worker","worker",938239996),expr__71996))){
return ((function (pred__71995,expr__71996){
return (function (request_url,callback){

return callback.call(null,(function (){try{self.importScripts(figwheel.client.file_reloading.add_cache_buster.call(null,request_url));

return true;
}catch (e72003){if((e72003 instanceof Error)){
var e = e72003;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e72003;

}
}})());
});
;})(pred__71995,expr__71996))
} else {
return ((function (pred__71995,expr__71996){
return (function (a,b){
throw "Reload not defined for this platform";
});
;})(pred__71995,expr__71996))
}
}
}
}
})();
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__72023,callback){
var map__72025 = p__72023;
var map__72025__$1 = ((((!((map__72025 == null)))?((((map__72025.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__72025.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__72025):map__72025);
var file_msg = map__72025__$1;
var request_url = cljs.core.get.call(null,map__72025__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,["FigWheel: Attempting to load ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return figwheel.client.file_reloading.reload_file_STAR_.call(null,request_url,((function (map__72025,map__72025__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,["FigWheel: Successfully loaded ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__72025,map__72025__$1,file_msg,request_url))
);
});
if(typeof figwheel.client.file_reloading.reload_chan !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_chan = cljs.core.async.chan.call(null);
}
if(typeof figwheel.client.file_reloading.on_load_callbacks !== 'undefined'){
} else {
figwheel.client.file_reloading.on_load_callbacks = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if(typeof figwheel.client.file_reloading.dependencies_loaded !== 'undefined'){
} else {
figwheel.client.file_reloading.dependencies_loaded = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
figwheel.client.file_reloading.blocking_load = (function figwheel$client$file_reloading$blocking_load(url){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.reload_file.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-url","request-url",2100346596),url], null),((function (out){
return (function (file_msg){
cljs.core.async.put_BANG_.call(null,out,file_msg);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
if(typeof figwheel.client.file_reloading.reloader_loop !== 'undefined'){
} else {
figwheel.client.file_reloading.reloader_loop = (function (){var c__42036__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42036__auto__){
return (function (){
var f__42037__auto__ = (function (){var switch__42015__auto__ = ((function (c__42036__auto__){
return (function (state_72068){
var state_val_72069 = (state_72068[(1)]);
if((state_val_72069 === (7))){
var inst_72064 = (state_72068[(2)]);
var state_72068__$1 = state_72068;
var statearr_72071_72121 = state_72068__$1;
(statearr_72071_72121[(2)] = inst_72064);

(statearr_72071_72121[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72069 === (1))){
var state_72068__$1 = state_72068;
var statearr_72075_72123 = state_72068__$1;
(statearr_72075_72123[(2)] = null);

(statearr_72075_72123[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72069 === (4))){
var inst_72047 = (state_72068[(7)]);
var inst_72047__$1 = (state_72068[(2)]);
var state_72068__$1 = (function (){var statearr_72076 = state_72068;
(statearr_72076[(7)] = inst_72047__$1);

return statearr_72076;
})();
if(cljs.core.truth_(inst_72047__$1)){
var statearr_72077_72133 = state_72068__$1;
(statearr_72077_72133[(1)] = (5));

} else {
var statearr_72078_72134 = state_72068__$1;
(statearr_72078_72134[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72069 === (6))){
var state_72068__$1 = state_72068;
var statearr_72079_72137 = state_72068__$1;
(statearr_72079_72137[(2)] = null);

(statearr_72079_72137[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72069 === (3))){
var inst_72066 = (state_72068[(2)]);
var state_72068__$1 = state_72068;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72068__$1,inst_72066);
} else {
if((state_val_72069 === (2))){
var state_72068__$1 = state_72068;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72068__$1,(4),figwheel.client.file_reloading.reload_chan);
} else {
if((state_val_72069 === (11))){
var inst_72060 = (state_72068[(2)]);
var state_72068__$1 = (function (){var statearr_72080 = state_72068;
(statearr_72080[(8)] = inst_72060);

return statearr_72080;
})();
var statearr_72081_72140 = state_72068__$1;
(statearr_72081_72140[(2)] = null);

(statearr_72081_72140[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72069 === (9))){
var inst_72051 = (state_72068[(9)]);
var inst_72053 = (state_72068[(10)]);
var inst_72055 = inst_72053.call(null,inst_72051);
var state_72068__$1 = state_72068;
var statearr_72084_72145 = state_72068__$1;
(statearr_72084_72145[(2)] = inst_72055);

(statearr_72084_72145[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72069 === (5))){
var inst_72047 = (state_72068[(7)]);
var inst_72049 = figwheel.client.file_reloading.blocking_load.call(null,inst_72047);
var state_72068__$1 = state_72068;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72068__$1,(8),inst_72049);
} else {
if((state_val_72069 === (10))){
var inst_72051 = (state_72068[(9)]);
var inst_72057 = cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,cljs.core.conj,inst_72051);
var state_72068__$1 = state_72068;
var statearr_72088_72152 = state_72068__$1;
(statearr_72088_72152[(2)] = inst_72057);

(statearr_72088_72152[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72069 === (8))){
var inst_72047 = (state_72068[(7)]);
var inst_72053 = (state_72068[(10)]);
var inst_72051 = (state_72068[(2)]);
var inst_72052 = cljs.core.deref.call(null,figwheel.client.file_reloading.on_load_callbacks);
var inst_72053__$1 = cljs.core.get.call(null,inst_72052,inst_72047);
var state_72068__$1 = (function (){var statearr_72095 = state_72068;
(statearr_72095[(9)] = inst_72051);

(statearr_72095[(10)] = inst_72053__$1);

return statearr_72095;
})();
if(cljs.core.truth_(inst_72053__$1)){
var statearr_72096_72154 = state_72068__$1;
(statearr_72096_72154[(1)] = (9));

} else {
var statearr_72097_72155 = state_72068__$1;
(statearr_72097_72155[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__42036__auto__))
;
return ((function (switch__42015__auto__,c__42036__auto__){
return (function() {
var figwheel$client$file_reloading$state_machine__42016__auto__ = null;
var figwheel$client$file_reloading$state_machine__42016__auto____0 = (function (){
var statearr_72100 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_72100[(0)] = figwheel$client$file_reloading$state_machine__42016__auto__);

(statearr_72100[(1)] = (1));

return statearr_72100;
});
var figwheel$client$file_reloading$state_machine__42016__auto____1 = (function (state_72068){
while(true){
var ret_value__42017__auto__ = (function (){try{while(true){
var result__42018__auto__ = switch__42015__auto__.call(null,state_72068);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42018__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42018__auto__;
}
break;
}
}catch (e72106){if((e72106 instanceof Object)){
var ex__42019__auto__ = e72106;
var statearr_72107_72166 = state_72068;
(statearr_72107_72166[(5)] = ex__42019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_72068);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e72106;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72173 = state_72068;
state_72068 = G__72173;
continue;
} else {
return ret_value__42017__auto__;
}
break;
}
});
figwheel$client$file_reloading$state_machine__42016__auto__ = function(state_72068){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$state_machine__42016__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$state_machine__42016__auto____1.call(this,state_72068);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$state_machine__42016__auto____0;
figwheel$client$file_reloading$state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$state_machine__42016__auto____1;
return figwheel$client$file_reloading$state_machine__42016__auto__;
})()
;})(switch__42015__auto__,c__42036__auto__))
})();
var state__42038__auto__ = (function (){var statearr_72111 = f__42037__auto__.call(null);
(statearr_72111[(6)] = c__42036__auto__);

return statearr_72111;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42038__auto__);
});})(c__42036__auto__))
);

return c__42036__auto__;
})();
}
figwheel.client.file_reloading.queued_file_reload = (function figwheel$client$file_reloading$queued_file_reload(url){
return cljs.core.async.put_BANG_.call(null,figwheel.client.file_reloading.reload_chan,url);
});
figwheel.client.file_reloading.require_with_callback = (function figwheel$client$file_reloading$require_with_callback(p__72178,callback){
var map__72180 = p__72178;
var map__72180__$1 = ((((!((map__72180 == null)))?((((map__72180.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__72180.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__72180):map__72180);
var file_msg = map__72180__$1;
var namespace = cljs.core.get.call(null,map__72180__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var request_url = figwheel.client.file_reloading.resolve_ns.call(null,namespace);
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.assoc,request_url,((function (request_url,map__72180,map__72180__$1,file_msg,namespace){
return (function (file_msg_SINGLEQUOTE_){
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.dissoc,request_url);

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,file_msg,cljs.core.select_keys.call(null,file_msg_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375)], null)))], null));
});})(request_url,map__72180,map__72180__$1,file_msg,namespace))
);

return figwheel.client.file_reloading.figwheel_require.call(null,cljs.core.name.call(null,namespace),true);
});
figwheel.client.file_reloading.figwheel_no_load_QMARK_ = (function figwheel$client$file_reloading$figwheel_no_load_QMARK_(p__72191){
var map__72192 = p__72191;
var map__72192__$1 = ((((!((map__72192 == null)))?((((map__72192.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__72192.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__72192):map__72192);
var file_msg = map__72192__$1;
var namespace = cljs.core.get.call(null,map__72192__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__72222){
var map__72223 = p__72222;
var map__72223__$1 = ((((!((map__72223 == null)))?((((map__72223.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__72223.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__72223):map__72223);
var file_msg = map__72223__$1;
var namespace = cljs.core.get.call(null,map__72223__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
var and__28129__auto__ = cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,file_msg));
if(and__28129__auto__){
var or__28141__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__28141__auto__)){
return or__28141__auto__;
} else {
var or__28141__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__28141__auto____$1)){
return or__28141__auto____$1;
} else {
return figwheel.client.file_reloading.provided_QMARK_.call(null,cljs.core.name.call(null,namespace));
}
}
} else {
return and__28129__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__72257,callback){
var map__72258 = p__72257;
var map__72258__$1 = ((((!((map__72258 == null)))?((((map__72258.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__72258.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__72258):map__72258);
var file_msg = map__72258__$1;
var request_url = cljs.core.get.call(null,map__72258__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__72258__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.require_with_callback.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,["Figwheel: Not trying to load file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__42036__auto___72346 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42036__auto___72346,out){
return (function (){
var f__42037__auto__ = (function (){var switch__42015__auto__ = ((function (c__42036__auto___72346,out){
return (function (state_72316){
var state_val_72317 = (state_72316[(1)]);
if((state_val_72317 === (1))){
var inst_72282 = cljs.core.seq.call(null,files);
var inst_72285 = cljs.core.first.call(null,inst_72282);
var inst_72288 = cljs.core.next.call(null,inst_72282);
var inst_72290 = files;
var state_72316__$1 = (function (){var statearr_72321 = state_72316;
(statearr_72321[(7)] = inst_72285);

(statearr_72321[(8)] = inst_72288);

(statearr_72321[(9)] = inst_72290);

return statearr_72321;
})();
var statearr_72324_72350 = state_72316__$1;
(statearr_72324_72350[(2)] = null);

(statearr_72324_72350[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72317 === (2))){
var inst_72298 = (state_72316[(10)]);
var inst_72290 = (state_72316[(9)]);
var inst_72297 = cljs.core.seq.call(null,inst_72290);
var inst_72298__$1 = cljs.core.first.call(null,inst_72297);
var inst_72299 = cljs.core.next.call(null,inst_72297);
var inst_72300 = (inst_72298__$1 == null);
var inst_72301 = cljs.core.not.call(null,inst_72300);
var state_72316__$1 = (function (){var statearr_72329 = state_72316;
(statearr_72329[(11)] = inst_72299);

(statearr_72329[(10)] = inst_72298__$1);

return statearr_72329;
})();
if(inst_72301){
var statearr_72330_72351 = state_72316__$1;
(statearr_72330_72351[(1)] = (4));

} else {
var statearr_72331_72352 = state_72316__$1;
(statearr_72331_72352[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72317 === (3))){
var inst_72313 = (state_72316[(2)]);
var state_72316__$1 = state_72316;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72316__$1,inst_72313);
} else {
if((state_val_72317 === (4))){
var inst_72298 = (state_72316[(10)]);
var inst_72303 = figwheel.client.file_reloading.reload_js_file.call(null,inst_72298);
var state_72316__$1 = state_72316;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72316__$1,(7),inst_72303);
} else {
if((state_val_72317 === (5))){
var inst_72309 = cljs.core.async.close_BANG_.call(null,out);
var state_72316__$1 = state_72316;
var statearr_72334_72353 = state_72316__$1;
(statearr_72334_72353[(2)] = inst_72309);

(statearr_72334_72353[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72317 === (6))){
var inst_72311 = (state_72316[(2)]);
var state_72316__$1 = state_72316;
var statearr_72335_72354 = state_72316__$1;
(statearr_72335_72354[(2)] = inst_72311);

(statearr_72335_72354[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72317 === (7))){
var inst_72299 = (state_72316[(11)]);
var inst_72305 = (state_72316[(2)]);
var inst_72306 = cljs.core.async.put_BANG_.call(null,out,inst_72305);
var inst_72290 = inst_72299;
var state_72316__$1 = (function (){var statearr_72336 = state_72316;
(statearr_72336[(12)] = inst_72306);

(statearr_72336[(9)] = inst_72290);

return statearr_72336;
})();
var statearr_72337_72355 = state_72316__$1;
(statearr_72337_72355[(2)] = null);

(statearr_72337_72355[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__42036__auto___72346,out))
;
return ((function (switch__42015__auto__,c__42036__auto___72346,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__42016__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__42016__auto____0 = (function (){
var statearr_72338 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72338[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__42016__auto__);

(statearr_72338[(1)] = (1));

return statearr_72338;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__42016__auto____1 = (function (state_72316){
while(true){
var ret_value__42017__auto__ = (function (){try{while(true){
var result__42018__auto__ = switch__42015__auto__.call(null,state_72316);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42018__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42018__auto__;
}
break;
}
}catch (e72340){if((e72340 instanceof Object)){
var ex__42019__auto__ = e72340;
var statearr_72341_72360 = state_72316;
(statearr_72341_72360[(5)] = ex__42019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_72316);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e72340;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72362 = state_72316;
state_72316 = G__72362;
continue;
} else {
return ret_value__42017__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__42016__auto__ = function(state_72316){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__42016__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__42016__auto____1.call(this,state_72316);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__42016__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__42016__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__42016__auto__;
})()
;})(switch__42015__auto__,c__42036__auto___72346,out))
})();
var state__42038__auto__ = (function (){var statearr_72344 = f__42037__auto__.call(null);
(statearr_72344[(6)] = c__42036__auto___72346);

return statearr_72344;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42038__auto__);
});})(c__42036__auto___72346,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__72365,opts){
var map__72366 = p__72365;
var map__72366__$1 = ((((!((map__72366 == null)))?((((map__72366.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__72366.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__72366):map__72366);
var eval_body = cljs.core.get.call(null,map__72366__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__72366__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__28129__auto__ = eval_body;
if(cljs.core.truth_(and__28129__auto__)){
return typeof eval_body === 'string';
} else {
return and__28129__auto__;
}
})())){
var code = eval_body;
try{figwheel.client.utils.debug_prn.call(null,["Evaling file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e72369){var e = e72369;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Unable to evaluate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.expand_files = (function figwheel$client$file_reloading$expand_files(files){
var deps = figwheel.client.file_reloading.get_all_dependents.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,cljs.core.partial.call(null,cljs.core.re_matches,/figwheel\.connect.*/),new cljs.core.Keyword(null,"namespace","namespace",-377510372)),cljs.core.map.call(null,((function (deps){
return (function (n){
var temp__4655__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,((function (deps){
return (function (p1__72371_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__72371_SHARP_),n);
});})(deps))
,files));
if(cljs.core.truth_(temp__4655__auto__)){
var file_msg = temp__4655__auto__;
return file_msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372),new cljs.core.Keyword(null,"namespace","namespace",-377510372),n], null);
}
});})(deps))
,deps));
});
figwheel.client.file_reloading.sort_files = (function figwheel$client$file_reloading$sort_files(files){
if((cljs.core.count.call(null,files) <= (1))){
return files;
} else {
var keep_files = cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,keep_files,new cljs.core.Keyword(null,"namespace","namespace",-377510372)),figwheel.client.file_reloading.expand_files.call(null,files));
}
});
figwheel.client.file_reloading.get_figwheel_always = (function figwheel$client$file_reloading$get_figwheel_always(){
return cljs.core.map.call(null,(function (p__72384){
var vec__72385 = p__72384;
var k = cljs.core.nth.call(null,vec__72385,(0),null);
var v = cljs.core.nth.call(null,vec__72385,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),k,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372)], null);
}),cljs.core.filter.call(null,(function (p__72388){
var vec__72389 = p__72388;
var k = cljs.core.nth.call(null,vec__72389,(0),null);
var v = cljs.core.nth.call(null,vec__72389,(1),null);
return new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(v);
}),cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas)));
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__72396,p__72397){
var map__72399 = p__72396;
var map__72399__$1 = ((((!((map__72399 == null)))?((((map__72399.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__72399.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__72399):map__72399);
var opts = map__72399__$1;
var before_jsload = cljs.core.get.call(null,map__72399__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__72399__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var reload_dependents = cljs.core.get.call(null,map__72399__$1,new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430));
var map__72400 = p__72397;
var map__72400__$1 = ((((!((map__72400 == null)))?((((map__72400.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__72400.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__72400):map__72400);
var msg = map__72400__$1;
var files = cljs.core.get.call(null,map__72400__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var figwheel_meta = cljs.core.get.call(null,map__72400__$1,new cljs.core.Keyword(null,"figwheel-meta","figwheel-meta",-225970237));
var recompile_dependents = cljs.core.get.call(null,map__72400__$1,new cljs.core.Keyword(null,"recompile-dependents","recompile-dependents",523804171));
if(cljs.core.empty_QMARK_.call(null,figwheel_meta)){
} else {
cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas,figwheel_meta);
}

var c__42036__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42036__auto__,map__72399,map__72399__$1,opts,before_jsload,on_jsload,reload_dependents,map__72400,map__72400__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
var f__42037__auto__ = (function (){var switch__42015__auto__ = ((function (c__42036__auto__,map__72399,map__72399__$1,opts,before_jsload,on_jsload,reload_dependents,map__72400,map__72400__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (state_72570){
var state_val_72571 = (state_72570[(1)]);
if((state_val_72571 === (7))){
var inst_72419 = (state_72570[(7)]);
var inst_72420 = (state_72570[(8)]);
var inst_72421 = (state_72570[(9)]);
var inst_72422 = (state_72570[(10)]);
var inst_72430 = cljs.core._nth.call(null,inst_72420,inst_72422);
var inst_72431 = figwheel.client.file_reloading.eval_body.call(null,inst_72430,opts);
var inst_72433 = (inst_72422 + (1));
var tmp72572 = inst_72419;
var tmp72573 = inst_72420;
var tmp72574 = inst_72421;
var inst_72419__$1 = tmp72572;
var inst_72420__$1 = tmp72573;
var inst_72421__$1 = tmp72574;
var inst_72422__$1 = inst_72433;
var state_72570__$1 = (function (){var statearr_72576 = state_72570;
(statearr_72576[(7)] = inst_72419__$1);

(statearr_72576[(8)] = inst_72420__$1);

(statearr_72576[(9)] = inst_72421__$1);

(statearr_72576[(10)] = inst_72422__$1);

(statearr_72576[(11)] = inst_72431);

return statearr_72576;
})();
var statearr_72577_72695 = state_72570__$1;
(statearr_72577_72695[(2)] = null);

(statearr_72577_72695[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72571 === (20))){
var inst_72466 = (state_72570[(12)]);
var inst_72474 = figwheel.client.file_reloading.sort_files.call(null,inst_72466);
var state_72570__$1 = state_72570;
var statearr_72578_72699 = state_72570__$1;
(statearr_72578_72699[(2)] = inst_72474);

(statearr_72578_72699[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72571 === (27))){
var state_72570__$1 = state_72570;
var statearr_72579_72702 = state_72570__$1;
(statearr_72579_72702[(2)] = null);

(statearr_72579_72702[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72571 === (1))){
var inst_72410 = (state_72570[(13)]);
var inst_72407 = before_jsload.call(null,files);
var inst_72408 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_72409 = (function (){return ((function (inst_72410,inst_72407,inst_72408,state_val_72571,c__42036__auto__,map__72399,map__72399__$1,opts,before_jsload,on_jsload,reload_dependents,map__72400,map__72400__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__72393_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__72393_SHARP_);
});
;})(inst_72410,inst_72407,inst_72408,state_val_72571,c__42036__auto__,map__72399,map__72399__$1,opts,before_jsload,on_jsload,reload_dependents,map__72400,map__72400__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_72410__$1 = cljs.core.filter.call(null,inst_72409,files);
var inst_72412 = cljs.core.not_empty.call(null,inst_72410__$1);
var state_72570__$1 = (function (){var statearr_72580 = state_72570;
(statearr_72580[(14)] = inst_72407);

(statearr_72580[(13)] = inst_72410__$1);

(statearr_72580[(15)] = inst_72408);

return statearr_72580;
})();
if(cljs.core.truth_(inst_72412)){
var statearr_72581_72708 = state_72570__$1;
(statearr_72581_72708[(1)] = (2));

} else {
var statearr_72582_72709 = state_72570__$1;
(statearr_72582_72709[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72571 === (24))){
var state_72570__$1 = state_72570;
var statearr_72584_72713 = state_72570__$1;
(statearr_72584_72713[(2)] = null);

(statearr_72584_72713[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72571 === (39))){
var inst_72516 = (state_72570[(16)]);
var state_72570__$1 = state_72570;
var statearr_72585_72715 = state_72570__$1;
(statearr_72585_72715[(2)] = inst_72516);

(statearr_72585_72715[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72571 === (46))){
var inst_72563 = (state_72570[(2)]);
var state_72570__$1 = state_72570;
var statearr_72586_72720 = state_72570__$1;
(statearr_72586_72720[(2)] = inst_72563);

(statearr_72586_72720[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72571 === (4))){
var inst_72460 = (state_72570[(2)]);
var inst_72461 = cljs.core.List.EMPTY;
var inst_72462 = cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,inst_72461);
var inst_72463 = (function (){return ((function (inst_72460,inst_72461,inst_72462,state_val_72571,c__42036__auto__,map__72399,map__72399__$1,opts,before_jsload,on_jsload,reload_dependents,map__72400,map__72400__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__72394_SHARP_){
var and__28129__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__72394_SHARP_);
if(cljs.core.truth_(and__28129__auto__)){
return (cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__72394_SHARP_))) && (cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,p1__72394_SHARP_)));
} else {
return and__28129__auto__;
}
});
;})(inst_72460,inst_72461,inst_72462,state_val_72571,c__42036__auto__,map__72399,map__72399__$1,opts,before_jsload,on_jsload,reload_dependents,map__72400,map__72400__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_72464 = cljs.core.filter.call(null,inst_72463,files);
var inst_72465 = figwheel.client.file_reloading.get_figwheel_always.call(null);
var inst_72466 = cljs.core.concat.call(null,inst_72464,inst_72465);
var state_72570__$1 = (function (){var statearr_72589 = state_72570;
(statearr_72589[(17)] = inst_72460);

(statearr_72589[(18)] = inst_72462);

(statearr_72589[(12)] = inst_72466);

return statearr_72589;
})();
if(cljs.core.truth_(reload_dependents)){
var statearr_72590_72725 = state_72570__$1;
(statearr_72590_72725[(1)] = (16));

} else {
var statearr_72591_72726 = state_72570__$1;
(statearr_72591_72726[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72571 === (15))){
var inst_72450 = (state_72570[(2)]);
var state_72570__$1 = state_72570;
var statearr_72592_72727 = state_72570__$1;
(statearr_72592_72727[(2)] = inst_72450);

(statearr_72592_72727[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72571 === (21))){
var inst_72476 = (state_72570[(19)]);
var inst_72476__$1 = (state_72570[(2)]);
var inst_72477 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_72476__$1);
var state_72570__$1 = (function (){var statearr_72593 = state_72570;
(statearr_72593[(19)] = inst_72476__$1);

return statearr_72593;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72570__$1,(22),inst_72477);
} else {
if((state_val_72571 === (31))){
var inst_72566 = (state_72570[(2)]);
var state_72570__$1 = state_72570;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72570__$1,inst_72566);
} else {
if((state_val_72571 === (32))){
var inst_72516 = (state_72570[(16)]);
var inst_72521 = inst_72516.cljs$lang$protocol_mask$partition0$;
var inst_72522 = (inst_72521 & (64));
var inst_72523 = inst_72516.cljs$core$ISeq$;
var inst_72524 = (cljs.core.PROTOCOL_SENTINEL === inst_72523);
var inst_72525 = (inst_72522) || (inst_72524);
var state_72570__$1 = state_72570;
if(cljs.core.truth_(inst_72525)){
var statearr_72597_72734 = state_72570__$1;
(statearr_72597_72734[(1)] = (35));

} else {
var statearr_72598_72736 = state_72570__$1;
(statearr_72598_72736[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72571 === (40))){
var inst_72538 = (state_72570[(20)]);
var inst_72537 = (state_72570[(2)]);
var inst_72538__$1 = cljs.core.get.call(null,inst_72537,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_72539 = cljs.core.get.call(null,inst_72537,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_72540 = cljs.core.not_empty.call(null,inst_72538__$1);
var state_72570__$1 = (function (){var statearr_72601 = state_72570;
(statearr_72601[(21)] = inst_72539);

(statearr_72601[(20)] = inst_72538__$1);

return statearr_72601;
})();
if(cljs.core.truth_(inst_72540)){
var statearr_72603_72742 = state_72570__$1;
(statearr_72603_72742[(1)] = (41));

} else {
var statearr_72604_72743 = state_72570__$1;
(statearr_72604_72743[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72571 === (33))){
var state_72570__$1 = state_72570;
var statearr_72605_72744 = state_72570__$1;
(statearr_72605_72744[(2)] = false);

(statearr_72605_72744[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72571 === (13))){
var inst_72436 = (state_72570[(22)]);
var inst_72440 = cljs.core.chunk_first.call(null,inst_72436);
var inst_72441 = cljs.core.chunk_rest.call(null,inst_72436);
var inst_72442 = cljs.core.count.call(null,inst_72440);
var inst_72419 = inst_72441;
var inst_72420 = inst_72440;
var inst_72421 = inst_72442;
var inst_72422 = (0);
var state_72570__$1 = (function (){var statearr_72606 = state_72570;
(statearr_72606[(7)] = inst_72419);

(statearr_72606[(8)] = inst_72420);

(statearr_72606[(9)] = inst_72421);

(statearr_72606[(10)] = inst_72422);

return statearr_72606;
})();
var statearr_72607_72749 = state_72570__$1;
(statearr_72607_72749[(2)] = null);

(statearr_72607_72749[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72571 === (22))){
var inst_72479 = (state_72570[(23)]);
var inst_72480 = (state_72570[(24)]);
var inst_72484 = (state_72570[(25)]);
var inst_72476 = (state_72570[(19)]);
var inst_72479__$1 = (state_72570[(2)]);
var inst_72480__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_72479__$1);
var inst_72481 = (function (){var all_files = inst_72476;
var res_SINGLEQUOTE_ = inst_72479__$1;
var res = inst_72480__$1;
return ((function (all_files,res_SINGLEQUOTE_,res,inst_72479,inst_72480,inst_72484,inst_72476,inst_72479__$1,inst_72480__$1,state_val_72571,c__42036__auto__,map__72399,map__72399__$1,opts,before_jsload,on_jsload,reload_dependents,map__72400,map__72400__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__72395_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__72395_SHARP_));
});
;})(all_files,res_SINGLEQUOTE_,res,inst_72479,inst_72480,inst_72484,inst_72476,inst_72479__$1,inst_72480__$1,state_val_72571,c__42036__auto__,map__72399,map__72399__$1,opts,before_jsload,on_jsload,reload_dependents,map__72400,map__72400__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_72482 = cljs.core.filter.call(null,inst_72481,inst_72479__$1);
var inst_72483 = cljs.core.deref.call(null,figwheel.client.file_reloading.dependencies_loaded);
var inst_72484__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_72483);
var inst_72485 = cljs.core.not_empty.call(null,inst_72484__$1);
var state_72570__$1 = (function (){var statearr_72608 = state_72570;
(statearr_72608[(23)] = inst_72479__$1);

(statearr_72608[(24)] = inst_72480__$1);

(statearr_72608[(25)] = inst_72484__$1);

(statearr_72608[(26)] = inst_72482);

return statearr_72608;
})();
if(cljs.core.truth_(inst_72485)){
var statearr_72609_72756 = state_72570__$1;
(statearr_72609_72756[(1)] = (23));

} else {
var statearr_72610_72757 = state_72570__$1;
(statearr_72610_72757[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72571 === (36))){
var state_72570__$1 = state_72570;
var statearr_72611_72760 = state_72570__$1;
(statearr_72611_72760[(2)] = false);

(statearr_72611_72760[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72571 === (41))){
var inst_72538 = (state_72570[(20)]);
var inst_72542 = cljs.core.comp.call(null,figwheel.client.file_reloading.name__GT_path,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var inst_72543 = cljs.core.map.call(null,inst_72542,inst_72538);
var inst_72544 = cljs.core.pr_str.call(null,inst_72543);
var inst_72545 = ["figwheel-no-load meta-data: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_72544)].join('');
var inst_72546 = figwheel.client.utils.log.call(null,inst_72545);
var state_72570__$1 = state_72570;
var statearr_72612_72764 = state_72570__$1;
(statearr_72612_72764[(2)] = inst_72546);

(statearr_72612_72764[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72571 === (43))){
var inst_72539 = (state_72570[(21)]);
var inst_72549 = (state_72570[(2)]);
var inst_72550 = cljs.core.not_empty.call(null,inst_72539);
var state_72570__$1 = (function (){var statearr_72613 = state_72570;
(statearr_72613[(27)] = inst_72549);

return statearr_72613;
})();
if(cljs.core.truth_(inst_72550)){
var statearr_72614_72768 = state_72570__$1;
(statearr_72614_72768[(1)] = (44));

} else {
var statearr_72615_72770 = state_72570__$1;
(statearr_72615_72770[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72571 === (29))){
var inst_72479 = (state_72570[(23)]);
var inst_72516 = (state_72570[(16)]);
var inst_72480 = (state_72570[(24)]);
var inst_72484 = (state_72570[(25)]);
var inst_72482 = (state_72570[(26)]);
var inst_72476 = (state_72570[(19)]);
var inst_72512 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_72515 = (function (){var all_files = inst_72476;
var res_SINGLEQUOTE_ = inst_72479;
var res = inst_72480;
var files_not_loaded = inst_72482;
var dependencies_that_loaded = inst_72484;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_72479,inst_72516,inst_72480,inst_72484,inst_72482,inst_72476,inst_72512,state_val_72571,c__42036__auto__,map__72399,map__72399__$1,opts,before_jsload,on_jsload,reload_dependents,map__72400,map__72400__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__72514){
var map__72616 = p__72514;
var map__72616__$1 = ((((!((map__72616 == null)))?((((map__72616.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__72616.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__72616):map__72616);
var namespace = cljs.core.get.call(null,map__72616__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.truth_(meta_data.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179)))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_72479,inst_72516,inst_72480,inst_72484,inst_72482,inst_72476,inst_72512,state_val_72571,c__42036__auto__,map__72399,map__72399__$1,opts,before_jsload,on_jsload,reload_dependents,map__72400,map__72400__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_72516__$1 = cljs.core.group_by.call(null,inst_72515,inst_72482);
var inst_72518 = (inst_72516__$1 == null);
var inst_72519 = cljs.core.not.call(null,inst_72518);
var state_72570__$1 = (function (){var statearr_72618 = state_72570;
(statearr_72618[(16)] = inst_72516__$1);

(statearr_72618[(28)] = inst_72512);

return statearr_72618;
})();
if(inst_72519){
var statearr_72619_72778 = state_72570__$1;
(statearr_72619_72778[(1)] = (32));

} else {
var statearr_72620_72779 = state_72570__$1;
(statearr_72620_72779[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72571 === (44))){
var inst_72539 = (state_72570[(21)]);
var inst_72552 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_72539);
var inst_72553 = cljs.core.pr_str.call(null,inst_72552);
var inst_72554 = ["not required: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_72553)].join('');
var inst_72560 = figwheel.client.utils.log.call(null,inst_72554);
var state_72570__$1 = state_72570;
var statearr_72621_72783 = state_72570__$1;
(statearr_72621_72783[(2)] = inst_72560);

(statearr_72621_72783[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72571 === (6))){
var inst_72457 = (state_72570[(2)]);
var state_72570__$1 = state_72570;
var statearr_72622_72785 = state_72570__$1;
(statearr_72622_72785[(2)] = inst_72457);

(statearr_72622_72785[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72571 === (28))){
var inst_72482 = (state_72570[(26)]);
var inst_72509 = (state_72570[(2)]);
var inst_72510 = cljs.core.not_empty.call(null,inst_72482);
var state_72570__$1 = (function (){var statearr_72624 = state_72570;
(statearr_72624[(29)] = inst_72509);

return statearr_72624;
})();
if(cljs.core.truth_(inst_72510)){
var statearr_72625_72788 = state_72570__$1;
(statearr_72625_72788[(1)] = (29));

} else {
var statearr_72626_72789 = state_72570__$1;
(statearr_72626_72789[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72571 === (25))){
var inst_72480 = (state_72570[(24)]);
var inst_72496 = (state_72570[(2)]);
var inst_72497 = cljs.core.not_empty.call(null,inst_72480);
var state_72570__$1 = (function (){var statearr_72627 = state_72570;
(statearr_72627[(30)] = inst_72496);

return statearr_72627;
})();
if(cljs.core.truth_(inst_72497)){
var statearr_72628_72791 = state_72570__$1;
(statearr_72628_72791[(1)] = (26));

} else {
var statearr_72629_72792 = state_72570__$1;
(statearr_72629_72792[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72571 === (34))){
var inst_72532 = (state_72570[(2)]);
var state_72570__$1 = state_72570;
if(cljs.core.truth_(inst_72532)){
var statearr_72630_72795 = state_72570__$1;
(statearr_72630_72795[(1)] = (38));

} else {
var statearr_72631_72798 = state_72570__$1;
(statearr_72631_72798[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72571 === (17))){
var state_72570__$1 = state_72570;
var statearr_72632_72799 = state_72570__$1;
(statearr_72632_72799[(2)] = recompile_dependents);

(statearr_72632_72799[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72571 === (3))){
var state_72570__$1 = state_72570;
var statearr_72633_72801 = state_72570__$1;
(statearr_72633_72801[(2)] = null);

(statearr_72633_72801[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72571 === (12))){
var inst_72453 = (state_72570[(2)]);
var state_72570__$1 = state_72570;
var statearr_72635_72803 = state_72570__$1;
(statearr_72635_72803[(2)] = inst_72453);

(statearr_72635_72803[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72571 === (2))){
var inst_72410 = (state_72570[(13)]);
var inst_72418 = cljs.core.seq.call(null,inst_72410);
var inst_72419 = inst_72418;
var inst_72420 = null;
var inst_72421 = (0);
var inst_72422 = (0);
var state_72570__$1 = (function (){var statearr_72637 = state_72570;
(statearr_72637[(7)] = inst_72419);

(statearr_72637[(8)] = inst_72420);

(statearr_72637[(9)] = inst_72421);

(statearr_72637[(10)] = inst_72422);

return statearr_72637;
})();
var statearr_72638_72808 = state_72570__$1;
(statearr_72638_72808[(2)] = null);

(statearr_72638_72808[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72571 === (23))){
var inst_72479 = (state_72570[(23)]);
var inst_72480 = (state_72570[(24)]);
var inst_72484 = (state_72570[(25)]);
var inst_72482 = (state_72570[(26)]);
var inst_72476 = (state_72570[(19)]);
var inst_72487 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these dependencies");
var inst_72489 = (function (){var all_files = inst_72476;
var res_SINGLEQUOTE_ = inst_72479;
var res = inst_72480;
var files_not_loaded = inst_72482;
var dependencies_that_loaded = inst_72484;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_72479,inst_72480,inst_72484,inst_72482,inst_72476,inst_72487,state_val_72571,c__42036__auto__,map__72399,map__72399__$1,opts,before_jsload,on_jsload,reload_dependents,map__72400,map__72400__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__72488){
var map__72639 = p__72488;
var map__72639__$1 = ((((!((map__72639 == null)))?((((map__72639.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__72639.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__72639):map__72639);
var request_url = cljs.core.get.call(null,map__72639__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
return clojure.string.replace.call(null,request_url,goog.basePath,"");
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_72479,inst_72480,inst_72484,inst_72482,inst_72476,inst_72487,state_val_72571,c__42036__auto__,map__72399,map__72399__$1,opts,before_jsload,on_jsload,reload_dependents,map__72400,map__72400__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_72490 = cljs.core.reverse.call(null,inst_72484);
var inst_72491 = cljs.core.map.call(null,inst_72489,inst_72490);
var inst_72492 = cljs.core.pr_str.call(null,inst_72491);
var inst_72493 = figwheel.client.utils.log.call(null,inst_72492);
var state_72570__$1 = (function (){var statearr_72642 = state_72570;
(statearr_72642[(31)] = inst_72487);

return statearr_72642;
})();
var statearr_72643_72818 = state_72570__$1;
(statearr_72643_72818[(2)] = inst_72493);

(statearr_72643_72818[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72571 === (35))){
var state_72570__$1 = state_72570;
var statearr_72644_72820 = state_72570__$1;
(statearr_72644_72820[(2)] = true);

(statearr_72644_72820[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72571 === (19))){
var inst_72466 = (state_72570[(12)]);
var inst_72472 = figwheel.client.file_reloading.expand_files.call(null,inst_72466);
var state_72570__$1 = state_72570;
var statearr_72645_72823 = state_72570__$1;
(statearr_72645_72823[(2)] = inst_72472);

(statearr_72645_72823[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72571 === (11))){
var state_72570__$1 = state_72570;
var statearr_72646_72826 = state_72570__$1;
(statearr_72646_72826[(2)] = null);

(statearr_72646_72826[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72571 === (9))){
var inst_72455 = (state_72570[(2)]);
var state_72570__$1 = state_72570;
var statearr_72651_72828 = state_72570__$1;
(statearr_72651_72828[(2)] = inst_72455);

(statearr_72651_72828[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72571 === (5))){
var inst_72421 = (state_72570[(9)]);
var inst_72422 = (state_72570[(10)]);
var inst_72427 = (inst_72422 < inst_72421);
var inst_72428 = inst_72427;
var state_72570__$1 = state_72570;
if(cljs.core.truth_(inst_72428)){
var statearr_72652_72831 = state_72570__$1;
(statearr_72652_72831[(1)] = (7));

} else {
var statearr_72653_72832 = state_72570__$1;
(statearr_72653_72832[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72571 === (14))){
var inst_72436 = (state_72570[(22)]);
var inst_72445 = cljs.core.first.call(null,inst_72436);
var inst_72446 = figwheel.client.file_reloading.eval_body.call(null,inst_72445,opts);
var inst_72447 = cljs.core.next.call(null,inst_72436);
var inst_72419 = inst_72447;
var inst_72420 = null;
var inst_72421 = (0);
var inst_72422 = (0);
var state_72570__$1 = (function (){var statearr_72654 = state_72570;
(statearr_72654[(32)] = inst_72446);

(statearr_72654[(7)] = inst_72419);

(statearr_72654[(8)] = inst_72420);

(statearr_72654[(9)] = inst_72421);

(statearr_72654[(10)] = inst_72422);

return statearr_72654;
})();
var statearr_72655_72836 = state_72570__$1;
(statearr_72655_72836[(2)] = null);

(statearr_72655_72836[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72571 === (45))){
var state_72570__$1 = state_72570;
var statearr_72657_72839 = state_72570__$1;
(statearr_72657_72839[(2)] = null);

(statearr_72657_72839[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72571 === (26))){
var inst_72479 = (state_72570[(23)]);
var inst_72480 = (state_72570[(24)]);
var inst_72484 = (state_72570[(25)]);
var inst_72482 = (state_72570[(26)]);
var inst_72476 = (state_72570[(19)]);
var inst_72499 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_72501 = (function (){var all_files = inst_72476;
var res_SINGLEQUOTE_ = inst_72479;
var res = inst_72480;
var files_not_loaded = inst_72482;
var dependencies_that_loaded = inst_72484;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_72479,inst_72480,inst_72484,inst_72482,inst_72476,inst_72499,state_val_72571,c__42036__auto__,map__72399,map__72399__$1,opts,before_jsload,on_jsload,reload_dependents,map__72400,map__72400__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__72500){
var map__72660 = p__72500;
var map__72660__$1 = ((((!((map__72660 == null)))?((((map__72660.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__72660.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__72660):map__72660);
var namespace = cljs.core.get.call(null,map__72660__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__72660__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.name__GT_path.call(null,cljs.core.name.call(null,namespace));
} else {
return file;
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_72479,inst_72480,inst_72484,inst_72482,inst_72476,inst_72499,state_val_72571,c__42036__auto__,map__72399,map__72399__$1,opts,before_jsload,on_jsload,reload_dependents,map__72400,map__72400__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_72502 = cljs.core.map.call(null,inst_72501,inst_72480);
var inst_72503 = cljs.core.pr_str.call(null,inst_72502);
var inst_72504 = figwheel.client.utils.log.call(null,inst_72503);
var inst_72505 = (function (){var all_files = inst_72476;
var res_SINGLEQUOTE_ = inst_72479;
var res = inst_72480;
var files_not_loaded = inst_72482;
var dependencies_that_loaded = inst_72484;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_72479,inst_72480,inst_72484,inst_72482,inst_72476,inst_72499,inst_72501,inst_72502,inst_72503,inst_72504,state_val_72571,c__42036__auto__,map__72399,map__72399__$1,opts,before_jsload,on_jsload,reload_dependents,map__72400,map__72400__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_72479,inst_72480,inst_72484,inst_72482,inst_72476,inst_72499,inst_72501,inst_72502,inst_72503,inst_72504,state_val_72571,c__42036__auto__,map__72399,map__72399__$1,opts,before_jsload,on_jsload,reload_dependents,map__72400,map__72400__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_72506 = setTimeout(inst_72505,(10));
var state_72570__$1 = (function (){var statearr_72663 = state_72570;
(statearr_72663[(33)] = inst_72499);

(statearr_72663[(34)] = inst_72504);

return statearr_72663;
})();
var statearr_72664_72857 = state_72570__$1;
(statearr_72664_72857[(2)] = inst_72506);

(statearr_72664_72857[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72571 === (16))){
var state_72570__$1 = state_72570;
var statearr_72665_72860 = state_72570__$1;
(statearr_72665_72860[(2)] = reload_dependents);

(statearr_72665_72860[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72571 === (38))){
var inst_72516 = (state_72570[(16)]);
var inst_72534 = cljs.core.apply.call(null,cljs.core.hash_map,inst_72516);
var state_72570__$1 = state_72570;
var statearr_72668_72866 = state_72570__$1;
(statearr_72668_72866[(2)] = inst_72534);

(statearr_72668_72866[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72571 === (30))){
var state_72570__$1 = state_72570;
var statearr_72671_72868 = state_72570__$1;
(statearr_72671_72868[(2)] = null);

(statearr_72671_72868[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72571 === (10))){
var inst_72436 = (state_72570[(22)]);
var inst_72438 = cljs.core.chunked_seq_QMARK_.call(null,inst_72436);
var state_72570__$1 = state_72570;
if(inst_72438){
var statearr_72672_72869 = state_72570__$1;
(statearr_72672_72869[(1)] = (13));

} else {
var statearr_72674_72871 = state_72570__$1;
(statearr_72674_72871[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72571 === (18))){
var inst_72470 = (state_72570[(2)]);
var state_72570__$1 = state_72570;
if(cljs.core.truth_(inst_72470)){
var statearr_72675_72874 = state_72570__$1;
(statearr_72675_72874[(1)] = (19));

} else {
var statearr_72676_72876 = state_72570__$1;
(statearr_72676_72876[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72571 === (42))){
var state_72570__$1 = state_72570;
var statearr_72677_72877 = state_72570__$1;
(statearr_72677_72877[(2)] = null);

(statearr_72677_72877[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72571 === (37))){
var inst_72529 = (state_72570[(2)]);
var state_72570__$1 = state_72570;
var statearr_72678_72880 = state_72570__$1;
(statearr_72678_72880[(2)] = inst_72529);

(statearr_72678_72880[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72571 === (8))){
var inst_72419 = (state_72570[(7)]);
var inst_72436 = (state_72570[(22)]);
var inst_72436__$1 = cljs.core.seq.call(null,inst_72419);
var state_72570__$1 = (function (){var statearr_72679 = state_72570;
(statearr_72679[(22)] = inst_72436__$1);

return statearr_72679;
})();
if(inst_72436__$1){
var statearr_72680_72881 = state_72570__$1;
(statearr_72680_72881[(1)] = (10));

} else {
var statearr_72681_72882 = state_72570__$1;
(statearr_72681_72882[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__42036__auto__,map__72399,map__72399__$1,opts,before_jsload,on_jsload,reload_dependents,map__72400,map__72400__$1,msg,files,figwheel_meta,recompile_dependents))
;
return ((function (switch__42015__auto__,c__42036__auto__,map__72399,map__72399__$1,opts,before_jsload,on_jsload,reload_dependents,map__72400,map__72400__$1,msg,files,figwheel_meta,recompile_dependents){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__42016__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__42016__auto____0 = (function (){
var statearr_72682 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72682[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__42016__auto__);

(statearr_72682[(1)] = (1));

return statearr_72682;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__42016__auto____1 = (function (state_72570){
while(true){
var ret_value__42017__auto__ = (function (){try{while(true){
var result__42018__auto__ = switch__42015__auto__.call(null,state_72570);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42018__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42018__auto__;
}
break;
}
}catch (e72684){if((e72684 instanceof Object)){
var ex__42019__auto__ = e72684;
var statearr_72685_72890 = state_72570;
(statearr_72685_72890[(5)] = ex__42019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_72570);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e72684;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72891 = state_72570;
state_72570 = G__72891;
continue;
} else {
return ret_value__42017__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__42016__auto__ = function(state_72570){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__42016__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__42016__auto____1.call(this,state_72570);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__42016__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__42016__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__42016__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__42016__auto__;
})()
;})(switch__42015__auto__,c__42036__auto__,map__72399,map__72399__$1,opts,before_jsload,on_jsload,reload_dependents,map__72400,map__72400__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var state__42038__auto__ = (function (){var statearr_72688 = f__42037__auto__.call(null);
(statearr_72688[(6)] = c__42036__auto__);

return statearr_72688;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42038__auto__);
});})(c__42036__auto__,map__72399,map__72399__$1,opts,before_jsload,on_jsload,reload_dependents,map__72400,map__72400__$1,msg,files,figwheel_meta,recompile_dependents))
);

return c__42036__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(location.protocol),"//"].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__72902,link){
var map__72903 = p__72902;
var map__72903__$1 = ((((!((map__72903 == null)))?((((map__72903.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__72903.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__72903):map__72903);
var file = cljs.core.get.call(null,map__72903__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__4657__auto__ = link.href;
if(cljs.core.truth_(temp__4657__auto__)){
var link_href = temp__4657__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__4657__auto__,map__72903,map__72903__$1,file){
return (function (p1__72900_SHARP_,p2__72901_SHARP_){
if(cljs.core._EQ_.call(null,p1__72900_SHARP_,p2__72901_SHARP_)){
return p1__72900_SHARP_;
} else {
return false;
}
});})(link_href,temp__4657__auto__,map__72903,map__72903__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__4657__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__72921){
var map__72922 = p__72921;
var map__72922__$1 = ((((!((map__72922 == null)))?((((map__72922.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__72922.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__72922):map__72922);
var match_length = cljs.core.get.call(null,map__72922__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__72922__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__72920_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__72920_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__4657__auto__)){
var res = temp__4657__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.distinctify = (function figwheel$client$file_reloading$distinctify(key,seqq){
return cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (p1__72939_SHARP_,p2__72940_SHARP_){
return cljs.core.assoc.call(null,p1__72939_SHARP_,cljs.core.get.call(null,p2__72940_SHARP_,key),p2__72940_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,seqq));
});
figwheel.client.file_reloading.add_link_to_document = (function figwheel$client$file_reloading$add_link_to_document(orig_link,klone,finished_fn){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
parent.removeChild(orig_link);

return finished_fn.call(null);
});})(parent))
,(300));
});
if(typeof figwheel.client.file_reloading.reload_css_deferred_chain !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_css_deferred_chain = cljs.core.atom.call(null,goog.async.Deferred.succeed());
}
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(f_data,fin){
var temp__4655__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__4655__auto__)){
var link = temp__4655__auto__;
return figwheel.client.file_reloading.add_link_to_document.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href),((function (link,temp__4655__auto__){
return (function (){
return fin.call(null,cljs.core.assoc.call(null,f_data,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),true));
});})(link,temp__4655__auto__))
);
} else {
return fin.call(null,f_data);
}
});
figwheel.client.file_reloading.reload_css_files_STAR_ = (function figwheel$client$file_reloading$reload_css_files_STAR_(deferred,f_datas,on_cssload){
return figwheel.client.utils.liftContD.call(null,figwheel.client.utils.mapConcatD.call(null,deferred,figwheel.client.file_reloading.reload_css_file,f_datas),(function (f_datas_SINGLEQUOTE_,fin){
var loaded_f_datas_72959 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),f_datas_SINGLEQUOTE_);
figwheel.client.file_reloading.on_cssload_custom_event.call(null,loaded_f_datas_72959);

if(cljs.core.fn_QMARK_.call(null,on_cssload)){
on_cssload.call(null,loaded_f_datas_72959);
} else {
}

return fin.call(null);
}));
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__72962,p__72963){
var map__72964 = p__72962;
var map__72964__$1 = ((((!((map__72964 == null)))?((((map__72964.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__72964.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__72964):map__72964);
var on_cssload = cljs.core.get.call(null,map__72964__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
var map__72965 = p__72963;
var map__72965__$1 = ((((!((map__72965 == null)))?((((map__72965.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__72965.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__72965):map__72965);
var files_msg = map__72965__$1;
var files = cljs.core.get.call(null,map__72965__$1,new cljs.core.Keyword(null,"files","files",-472457450));
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
var temp__4657__auto__ = cljs.core.not_empty.call(null,figwheel.client.file_reloading.distinctify.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files));
if(cljs.core.truth_(temp__4657__auto__)){
var f_datas = temp__4657__auto__;
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.reload_css_deferred_chain,figwheel.client.file_reloading.reload_css_files_STAR_,f_datas,on_cssload);
} else {
return null;
}
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map?rel=1511229582474
