// Compiled by ClojureScript 1.9.946 {}
goog.provide('com.rpl.specter');
goog.require('cljs.core');
goog.require('com.rpl.specter.protocols');
goog.require('com.rpl.specter.impl');
goog.require('com.rpl.specter.navs');
goog.require('clojure.set');
com.rpl.specter.static_path_QMARK_ = (function com$rpl$specter$static_path_QMARK_(path){
if(cljs.core.sequential_QMARK_.call(null,path)){
return cljs.core.every_QMARK_.call(null,com.rpl.specter.static_path_QMARK_,path);
} else {
return cljs.core.not.call(null,com.rpl.specter.impl.dynamic_param_QMARK_.call(null,path));
}
});
com.rpl.specter.wrap_dynamic_nav = (function com$rpl$specter$wrap_dynamic_nav(f){
return (function() { 
var G__80194__delegate = function (args){
var ret = cljs.core.apply.call(null,f,args);
if(cljs.core.truth_((function (){var and__28129__auto__ = cljs.core.sequential_QMARK_.call(null,ret);
if(and__28129__auto__){
return com.rpl.specter.static_path_QMARK_.call(null,ret);
} else {
return and__28129__auto__;
}
})())){
return com.rpl.specter.impl.comp_paths_STAR_.call(null,ret);
} else {
if((cljs.core.sequential_QMARK_.call(null,ret)) && (cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,ret)))){
return cljs.core.first.call(null,ret);
} else {
return ret;

}
}
};
var G__80194 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__80197__i = 0, G__80197__a = new Array(arguments.length -  0);
while (G__80197__i < G__80197__a.length) {G__80197__a[G__80197__i] = arguments[G__80197__i + 0]; ++G__80197__i;}
  args = new cljs.core.IndexedSeq(G__80197__a,0,null);
} 
return G__80194__delegate.call(this,args);};
G__80194.cljs$lang$maxFixedArity = 0;
G__80194.cljs$lang$applyTo = (function (arglist__80199){
var args = cljs.core.seq(arglist__80199);
return G__80194__delegate(args);
});
G__80194.cljs$core$IFn$_invoke$arity$variadic = G__80194__delegate;
return G__80194;
})()
;
});
/**
 * Returns a compiled version of the given path for use with
 * compiled-{select/transform/setval/etc.} functions.
 */
com.rpl.specter.comp_paths = (function com$rpl$specter$comp_paths(var_args){
var args__29319__auto__ = [];
var len__29312__auto___80224 = arguments.length;
var i__29313__auto___80226 = (0);
while(true){
if((i__29313__auto___80226 < len__29312__auto___80224)){
args__29319__auto__.push((arguments[i__29313__auto___80226]));

var G__80227 = (i__29313__auto___80226 + (1));
i__29313__auto___80226 = G__80227;
continue;
} else {
}
break;
}

var argseq__29320__auto__ = ((((0) < args__29319__auto__.length))?(new cljs.core.IndexedSeq(args__29319__auto__.slice((0)),(0),null)):null);
return com.rpl.specter.comp_paths.cljs$core$IFn$_invoke$arity$variadic(argseq__29320__auto__);
});

com.rpl.specter.comp_paths.cljs$core$IFn$_invoke$arity$variadic = (function (apath){
return com.rpl.specter.impl.comp_paths_STAR_.call(null,cljs.core.vec.call(null,apath));
});

com.rpl.specter.comp_paths.cljs$lang$maxFixedArity = (0);

com.rpl.specter.comp_paths.cljs$lang$applyTo = (function (seq80221){
return com.rpl.specter.comp_paths.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq80221));
});

/**
 * Version of select that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select = com.rpl.specter.impl.compiled_select_STAR_;
/**
 * Navigates to and returns a sequence of all the elements specified by the path.
 */
com.rpl.specter.select_STAR_ = (function com$rpl$specter$select_STAR_(path,structure){
return com.rpl.specter.compiled_select.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),structure);
});
/**
 * Version of select-one that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_one = com.rpl.specter.impl.compiled_select_one_STAR_;
/**
 * Like select, but returns either one element or nil. Throws exception if multiple elements found
 */
com.rpl.specter.select_one_STAR_ = (function com$rpl$specter$select_one_STAR_(path,structure){
return com.rpl.specter.compiled_select_one.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),structure);
});
/**
 * Version of select-one! that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_one_BANG_ = com.rpl.specter.impl.compiled_select_one_BANG__STAR_;
/**
 * Returns exactly one element, throws exception if zero or multiple elements found
 */
com.rpl.specter.select_one_BANG__STAR_ = (function com$rpl$specter$select_one_BANG__STAR_(path,structure){
return com.rpl.specter.compiled_select_one_BANG_.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),structure);
});
/**
 * Version of select-first that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_first = com.rpl.specter.impl.compiled_select_first_STAR_;
/**
 * Returns first element found.
 */
com.rpl.specter.select_first_STAR_ = (function com$rpl$specter$select_first_STAR_(path,structure){
return com.rpl.specter.compiled_select_first.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),structure);
});
/**
 * Version of select-any that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_any = com.rpl.specter.impl.compiled_select_any_STAR_;
/**
 * Global value used to indicate no elements selected during
 *           [[select-any]].
 */
com.rpl.specter.NONE = com.rpl.specter.impl.NONE;
/**
 * Returns any element found or [[NONE]] if nothing selected. This is the most
 * efficient of the various selection operations.
 */
com.rpl.specter.select_any_STAR_ = (function com$rpl$specter$select_any_STAR_(path,structure){
return com.rpl.specter.compiled_select_any.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),structure);
});
/**
 * Version of selected-any? that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_selected_any_QMARK_ = com.rpl.specter.impl.compiled_selected_any_QMARK__STAR_;
/**
 * Returns true if any element was selected, false otherwise.
 */
com.rpl.specter.selected_any_QMARK__STAR_ = (function com$rpl$specter$selected_any_QMARK__STAR_(path,structure){
return com.rpl.specter.compiled_selected_any_QMARK_.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),structure);
});
/**
 * Version of traverse that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_traverse = com.rpl.specter.impl.do_compiled_traverse;
/**
 * Return a reducible object that traverses over `structure` to every element
 * specified by the path
 */
com.rpl.specter.traverse_STAR_ = (function com$rpl$specter$traverse_STAR_(apath,structure){
return com.rpl.specter.compiled_traverse.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,apath),structure);
});
/**
 * Version of traverse-all that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_traverse_all = com.rpl.specter.impl.compiled_traverse_all_STAR_;
/**
 * Returns a transducer that traverses over each element with the given path.
 */
com.rpl.specter.traverse_all_STAR_ = (function com$rpl$specter$traverse_all_STAR_(apath){
return com.rpl.specter.compiled_traverse_all.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,apath));
});
/**
 * Version of transform that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_transform = com.rpl.specter.impl.compiled_transform_STAR_;
/**
 * Navigates to each value specified by the path and replaces it by the result of running
 *   the transform-fn on it
 */
com.rpl.specter.transform_STAR_ = (function com$rpl$specter$transform_STAR_(path,transform_fn,structure){
return com.rpl.specter.compiled_transform.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),transform_fn,structure);
});
/**
 * Version of `multi-transform` that takes in a path precompiled with `comp-paths`
 */
com.rpl.specter.compiled_multi_transform = com.rpl.specter.impl.compiled_multi_transform_STAR_;
/**
 * Just like `transform` but expects transform functions to be specified
 * inline in the path using `terminal`. Error is thrown if navigation finishes
 * at a non-`terminal` navigator. `terminal-val` is a wrapper around `terminal` and is
 * the `multi-transform` equivalent of `setval`.
 */
com.rpl.specter.multi_transform_STAR_ = (function com$rpl$specter$multi_transform_STAR_(path,structure){
return com.rpl.specter.compiled_multi_transform.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),structure);
});
/**
 * Version of setval that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_setval = com.rpl.specter.impl.compiled_setval_STAR_;
/**
 * Navigates to each value specified by the path and replaces it by val
 */
com.rpl.specter.setval_STAR_ = (function com$rpl$specter$setval_STAR_(path,val,structure){
return com.rpl.specter.compiled_setval.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),val,structure);
});
/**
 * Version of replace-in that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_replace_in = com.rpl.specter.impl.compiled_replace_in_STAR_;
/**
 * Similar to transform, except returns a pair of [transformed-structure sequence-of-user-ret].
 * The transform-fn in this case is expected to return [ret user-ret]. ret is
 * what's used to transform the data structure, while user-ret will be added to the user-ret sequence
 * in the final return. replace-in is useful for situations where you need to know the specific values
 * of what was transformed in the data structure.
 */
com.rpl.specter.replace_in_STAR_ = (function com$rpl$specter$replace_in_STAR_(var_args){
var args__29319__auto__ = [];
var len__29312__auto___80249 = arguments.length;
var i__29313__auto___80250 = (0);
while(true){
if((i__29313__auto___80250 < len__29312__auto___80249)){
args__29319__auto__.push((arguments[i__29313__auto___80250]));

var G__80251 = (i__29313__auto___80250 + (1));
i__29313__auto___80250 = G__80251;
continue;
} else {
}
break;
}

var argseq__29320__auto__ = ((((3) < args__29319__auto__.length))?(new cljs.core.IndexedSeq(args__29319__auto__.slice((3)),(0),null)):null);
return com.rpl.specter.replace_in_STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__29320__auto__);
});

com.rpl.specter.replace_in_STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (path,transform_fn,structure,p__80245){
var map__80246 = p__80245;
var map__80246__$1 = ((((!((map__80246 == null)))?((((map__80246.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__80246.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__80246):map__80246);
var merge_fn = cljs.core.get.call(null,map__80246__$1,new cljs.core.Keyword(null,"merge-fn","merge-fn",588067341),cljs.core.concat);
return com.rpl.specter.compiled_replace_in.call(null,com.rpl.specter.impl.comp_paths_STAR_.call(null,path),transform_fn,structure,new cljs.core.Keyword(null,"merge-fn","merge-fn",588067341),merge_fn);
});

com.rpl.specter.replace_in_STAR_.cljs$lang$maxFixedArity = (3);

com.rpl.specter.replace_in_STAR_.cljs$lang$applyTo = (function (seq80240){
var G__80241 = cljs.core.first.call(null,seq80240);
var seq80240__$1 = cljs.core.next.call(null,seq80240);
var G__80242 = cljs.core.first.call(null,seq80240__$1);
var seq80240__$2 = cljs.core.next.call(null,seq80240__$1);
var G__80243 = cljs.core.first.call(null,seq80240__$2);
var seq80240__$3 = cljs.core.next.call(null,seq80240__$2);
return com.rpl.specter.replace_in_STAR_.cljs$core$IFn$_invoke$arity$variadic(G__80241,G__80242,G__80243,seq80240__$3);
});

com.rpl.specter.late_path = com.rpl.specter.impl.late_path;
com.rpl.specter.dynamic_param_QMARK_ = com.rpl.specter.impl.dynamic_param_QMARK_;
com.rpl.specter.late_resolved_fn = com.rpl.specter.impl.late_resolved_fn;
/**
 * Turns a navigator that takes one argument into a navigator that takes
 *        many arguments and uses the same navigator with each argument. There
 *        is no performance cost to using this. See implementation of `keypath`
 */
com.rpl.specter.eachnav = cljs.core.vary_meta.call(null,com.rpl.specter.wrap_dynamic_nav.call(null,(function (navfn){
var latenavfn = com.rpl.specter.late_resolved_fn.call(null,navfn);
return cljs.core.vary_meta.call(null,com.rpl.specter.wrap_dynamic_nav.call(null,((function (latenavfn){
return (function() { 
var G__80259__delegate = function (args){
return cljs.core.map.call(null,latenavfn,args);
};
var G__80259 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__80262__i = 0, G__80262__a = new Array(arguments.length -  0);
while (G__80262__i < G__80262__a.length) {G__80262__a[G__80262__i] = arguments[G__80262__i + 0]; ++G__80262__i;}
  args = new cljs.core.IndexedSeq(G__80262__a,0,null);
} 
return G__80259__delegate.call(this,args);};
G__80259.cljs$lang$maxFixedArity = 0;
G__80259.cljs$lang$applyTo = (function (arglist__80263){
var args = cljs.core.seq(arglist__80263);
return G__80259__delegate(args);
});
G__80259.cljs$core$IFn$_invoke$arity$variadic = G__80259__delegate;
return G__80259;
})()
;})(latenavfn))
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
})),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
com.rpl.specter.local_declarepath = com.rpl.specter.impl.local_declarepath;


com.rpl.specter.STOP_select_STAR_ = (function com$rpl$specter$STOP_select_STAR_(structure,next_fn){
return com.rpl.specter.NONE;
});

com.rpl.specter.STOP_transform_STAR_ = (function com$rpl$specter$STOP_transform_STAR_(structure,next_fn){
return structure;
});

/**
 * Stops navigation at this point. For selection returns nothing and for
 *        transformation returns the structure unchanged
 */
com.rpl.specter.STOP = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter80265 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter80265 = (function (meta80266){
this.meta80266 = meta80266;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter80265.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_80267,meta80266__$1){
var self__ = this;
var _80267__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter80265(meta80266__$1));
});


com.rpl.specter.t_com$rpl$specter80265.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_80267){
var self__ = this;
var _80267__$1 = this;
return self__.meta80266;
});


com.rpl.specter.t_com$rpl$specter80265.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter80265.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return com.rpl.specter.NONE;
});


com.rpl.specter.t_com$rpl$specter80265.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return structure;
});

com.rpl.specter.t_com$rpl$specter80265.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta80266","meta80266",167321717,null)], null);
});

com.rpl.specter.t_com$rpl$specter80265.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter80265.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter80265";

com.rpl.specter.t_com$rpl$specter80265.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter80265");
});

com.rpl.specter.__GT_t_com$rpl$specter80265 = (function com$rpl$specter$__GT_t_com$rpl$specter80265(meta80266){
return (new com.rpl.specter.t_com$rpl$specter80265(meta80266));
});

}

return (new com.rpl.specter.t_com$rpl$specter80265(null));
})()
;
/**
 * Stays navigated at the current point. Essentially a no-op navigator.
 */
com.rpl.specter.STAY = com.rpl.specter.impl.STAY_STAR_;
/**
 * For usage with `multi-transform`, defines an endpoint in the navigation
 *        that will have the parameterized transform function run. The transform
 *        function works just like it does in `transform`, with collected values
 *        given as the first arguments
 */
com.rpl.specter.terminal = com.rpl.specter.impl.direct_nav_obj.call(null,(function (afn){
if(typeof com.rpl.specter.t_com$rpl$specter80278 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter80278 = (function (afn,meta80279){
this.afn = afn;
this.meta80279 = meta80279;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter80278.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_80280,meta80279__$1){
var self__ = this;
var _80280__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter80278(self__.afn,meta80279__$1));
});


com.rpl.specter.t_com$rpl$specter80278.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_80280){
var self__ = this;
var _80280__$1 = this;
return self__.meta80279;
});


com.rpl.specter.t_com$rpl$specter80278.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter80278.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
throw (new java.lang.IllegalArgumentException(com.rpl.specter.impl.smart_str.call(null,"'terminal' should only be used in multi-transform")));
});


com.rpl.specter.t_com$rpl$specter80278.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.terminal_STAR_.call(null,self__.afn,vals,structure);
});

com.rpl.specter.t_com$rpl$specter80278.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"meta80279","meta80279",-2103991098,null)], null);
});

com.rpl.specter.t_com$rpl$specter80278.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter80278.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter80278";

com.rpl.specter.t_com$rpl$specter80278.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter80278");
});

com.rpl.specter.__GT_t_com$rpl$specter80278 = (function com$rpl$specter$__GT_t_com$rpl$specter80278(afn__$1,meta80279){
return (new com.rpl.specter.t_com$rpl$specter80278(afn__$1,meta80279));
});

}

return (new com.rpl.specter.t_com$rpl$specter80278(afn,null));
}));
/**
 * Like `terminal` but specifies a val to set at the location regardless of
 * the collected values or the value at the location.
 */
com.rpl.specter.terminal_val = (function com$rpl$specter$terminal_val(v){
return com.rpl.specter.terminal.call(null,com.rpl.specter.impl.fast_constantly.call(null,v));
});


com.rpl.specter.ALL_select_STAR_ = (function com$rpl$specter$ALL_select_STAR_(structure,next_fn){
return com.rpl.specter.navs.all_select.call(null,structure,next_fn);
});

com.rpl.specter.ALL_transform_STAR_ = (function com$rpl$specter$ALL_transform_STAR_(structure,next_fn){
return com.rpl.specter.navs.all_transform.call(null,structure,next_fn);
});

/**
 * Navigate to every element of the collection. For maps navigates to
 *        a vector of `[key value]`.
 */
com.rpl.specter.ALL = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter80288 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter80288 = (function (meta80289){
this.meta80289 = meta80289;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter80288.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_80290,meta80289__$1){
var self__ = this;
var _80290__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter80288(meta80289__$1));
});


com.rpl.specter.t_com$rpl$specter80288.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_80290){
var self__ = this;
var _80290__$1 = this;
return self__.meta80289;
});


com.rpl.specter.t_com$rpl$specter80288.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter80288.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return com.rpl.specter.navs.all_select.call(null,structure,next_fn);
});


com.rpl.specter.t_com$rpl$specter80288.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return com.rpl.specter.navs.all_transform.call(null,structure,next_fn);
});

com.rpl.specter.t_com$rpl$specter80288.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta80289","meta80289",-887732422,null)], null);
});

com.rpl.specter.t_com$rpl$specter80288.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter80288.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter80288";

com.rpl.specter.t_com$rpl$specter80288.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter80288");
});

com.rpl.specter.__GT_t_com$rpl$specter80288 = (function com$rpl$specter$__GT_t_com$rpl$specter80288(meta80289){
return (new com.rpl.specter.t_com$rpl$specter80288(meta80289));
});

}

return (new com.rpl.specter.t_com$rpl$specter80288(null));
})()
;


com.rpl.specter.ALL_WITH_META_select_STAR_ = (function com$rpl$specter$ALL_WITH_META_select_STAR_(structure,next_fn){
return com.rpl.specter.navs.all_select.call(null,structure,next_fn);
});

com.rpl.specter.ALL_WITH_META_transform_STAR_ = (function com$rpl$specter$ALL_WITH_META_transform_STAR_(structure,next_fn){
var m = cljs.core.meta.call(null,structure);
var res = com.rpl.specter.navs.all_transform.call(null,structure,next_fn);
if(!((res == null))){
return cljs.core.with_meta.call(null,res,m);
} else {
return null;
}
});

/**
 * Same as ALL, except maintains metadata on the structure.
 */
com.rpl.specter.ALL_WITH_META = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter80330 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter80330 = (function (meta80331){
this.meta80331 = meta80331;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter80330.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_80332,meta80331__$1){
var self__ = this;
var _80332__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter80330(meta80331__$1));
});


com.rpl.specter.t_com$rpl$specter80330.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_80332){
var self__ = this;
var _80332__$1 = this;
return self__.meta80331;
});


com.rpl.specter.t_com$rpl$specter80330.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter80330.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return com.rpl.specter.navs.all_select.call(null,structure,next_fn);
});


com.rpl.specter.t_com$rpl$specter80330.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
var m = cljs.core.meta.call(null,structure);
var res = com.rpl.specter.navs.all_transform.call(null,structure,next_fn);
if(!((res == null))){
return cljs.core.with_meta.call(null,res,m);
} else {
return null;
}
});

com.rpl.specter.t_com$rpl$specter80330.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta80331","meta80331",-447078703,null)], null);
});

com.rpl.specter.t_com$rpl$specter80330.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter80330.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter80330";

com.rpl.specter.t_com$rpl$specter80330.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter80330");
});

com.rpl.specter.__GT_t_com$rpl$specter80330 = (function com$rpl$specter$__GT_t_com$rpl$specter80330(meta80331){
return (new com.rpl.specter.t_com$rpl$specter80330(meta80331));
});

}

return (new com.rpl.specter.t_com$rpl$specter80330(null));
})()
;


com.rpl.specter.MAP_VALS_select_STAR_ = (function com$rpl$specter$MAP_VALS_select_STAR_(structure,next_fn){
return cljs.core.reduce.call(null,(function (curr__30794__auto__,v){
var ret__30795__auto__ = next_fn.call(null,v);
if((ret__30795__auto__ === com.rpl.specter.NONE)){
return curr__30794__auto__;
} else {
if(cljs.core.reduced_QMARK_.call(null,ret__30795__auto__)){
return cljs.core.reduced.call(null,ret__30795__auto__);
} else {
return ret__30795__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.vals.call(null,structure));
});

com.rpl.specter.MAP_VALS_transform_STAR_ = (function com$rpl$specter$MAP_VALS_transform_STAR_(structure,next_fn){
return com.rpl.specter.navs.map_vals_transform.call(null,structure,next_fn);
});

/**
 * Navigate to each value of the map. This is more efficient than
 *        navigating via [ALL LAST]
 */
com.rpl.specter.MAP_VALS = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter80351 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter80351 = (function (meta80352){
this.meta80352 = meta80352;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter80351.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_80353,meta80352__$1){
var self__ = this;
var _80353__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter80351(meta80352__$1));
});


com.rpl.specter.t_com$rpl$specter80351.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_80353){
var self__ = this;
var _80353__$1 = this;
return self__.meta80352;
});


com.rpl.specter.t_com$rpl$specter80351.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter80351.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return cljs.core.reduce.call(null,((function (next_fn,this__32582__auto____$1){
return (function (curr__30794__auto__,v){
var ret__30795__auto__ = next_fn.call(null,v);
if((ret__30795__auto__ === com.rpl.specter.NONE)){
return curr__30794__auto__;
} else {
if(cljs.core.reduced_QMARK_.call(null,ret__30795__auto__)){
return cljs.core.reduced.call(null,ret__30795__auto__);
} else {
return ret__30795__auto__;
}
}
});})(next_fn,this__32582__auto____$1))
,com.rpl.specter.NONE,cljs.core.vals.call(null,structure));
});


com.rpl.specter.t_com$rpl$specter80351.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return com.rpl.specter.navs.map_vals_transform.call(null,structure,next_fn);
});

com.rpl.specter.t_com$rpl$specter80351.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta80352","meta80352",-242341406,null)], null);
});

com.rpl.specter.t_com$rpl$specter80351.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter80351.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter80351";

com.rpl.specter.t_com$rpl$specter80351.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter80351");
});

com.rpl.specter.__GT_t_com$rpl$specter80351 = (function com$rpl$specter$__GT_t_com$rpl$specter80351(meta80352){
return (new com.rpl.specter.t_com$rpl$specter80351(meta80352));
});

}

return (new com.rpl.specter.t_com$rpl$specter80351(null));
})()
;


com.rpl.specter.MAP_KEYS_select_STAR_ = (function com$rpl$specter$MAP_KEYS_select_STAR_(structure,next_fn){
return cljs.core.reduce.call(null,(function (curr__30794__auto__,k){
var ret__30795__auto__ = next_fn.call(null,k);
if((ret__30795__auto__ === com.rpl.specter.NONE)){
return curr__30794__auto__;
} else {
if(cljs.core.reduced_QMARK_.call(null,ret__30795__auto__)){
return cljs.core.reduced.call(null,ret__30795__auto__);
} else {
return ret__30795__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.keys.call(null,structure));
});

com.rpl.specter.MAP_KEYS_transform_STAR_ = (function com$rpl$specter$MAP_KEYS_transform_STAR_(structure,next_fn){
return com.rpl.specter.navs.map_keys_transform.call(null,structure,next_fn);
});

/**
 * Navigate to each key of the map. This is more efficient than
 *        navigating via [ALL FIRST]
 */
com.rpl.specter.MAP_KEYS = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter80387 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter80387 = (function (meta80388){
this.meta80388 = meta80388;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter80387.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_80389,meta80388__$1){
var self__ = this;
var _80389__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter80387(meta80388__$1));
});


com.rpl.specter.t_com$rpl$specter80387.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_80389){
var self__ = this;
var _80389__$1 = this;
return self__.meta80388;
});


com.rpl.specter.t_com$rpl$specter80387.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter80387.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return cljs.core.reduce.call(null,((function (next_fn,this__32582__auto____$1){
return (function (curr__30794__auto__,k){
var ret__30795__auto__ = next_fn.call(null,k);
if((ret__30795__auto__ === com.rpl.specter.NONE)){
return curr__30794__auto__;
} else {
if(cljs.core.reduced_QMARK_.call(null,ret__30795__auto__)){
return cljs.core.reduced.call(null,ret__30795__auto__);
} else {
return ret__30795__auto__;
}
}
});})(next_fn,this__32582__auto____$1))
,com.rpl.specter.NONE,cljs.core.keys.call(null,structure));
});


com.rpl.specter.t_com$rpl$specter80387.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return com.rpl.specter.navs.map_keys_transform.call(null,structure,next_fn);
});

com.rpl.specter.t_com$rpl$specter80387.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta80388","meta80388",-452750646,null)], null);
});

com.rpl.specter.t_com$rpl$specter80387.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter80387.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter80387";

com.rpl.specter.t_com$rpl$specter80387.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter80387");
});

com.rpl.specter.__GT_t_com$rpl$specter80387 = (function com$rpl$specter$__GT_t_com$rpl$specter80387(meta80388){
return (new com.rpl.specter.t_com$rpl$specter80387(meta80388));
});

}

return (new com.rpl.specter.t_com$rpl$specter80387(null));
})()
;
com.rpl.specter.VAL = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter80413 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter80413 = (function (meta80414){
this.meta80414 = meta80414;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter80413.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_80415,meta80414__$1){
var self__ = this;
var _80415__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter80413(meta80414__$1));
});


com.rpl.specter.t_com$rpl$specter80413.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_80415){
var self__ = this;
var _80415__$1 = this;
return self__.meta80414;
});


com.rpl.specter.t_com$rpl$specter80413.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter80413.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__33343__auto__,vals__33344__auto__,structure,next_fn__33345__auto__){
var self__ = this;
var this__33343__auto____$1 = this;
return next_fn__33345__auto__.call(null,cljs.core.conj.call(null,vals__33344__auto__,structure),structure);
});


com.rpl.specter.t_com$rpl$specter80413.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__33343__auto__,vals__33344__auto__,structure,next_fn__33345__auto__){
var self__ = this;
var this__33343__auto____$1 = this;
return next_fn__33345__auto__.call(null,cljs.core.conj.call(null,vals__33344__auto__,structure),structure);
});

com.rpl.specter.t_com$rpl$specter80413.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta80414","meta80414",1703239816,null)], null);
});

com.rpl.specter.t_com$rpl$specter80413.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter80413.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter80413";

com.rpl.specter.t_com$rpl$specter80413.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter80413");
});

com.rpl.specter.__GT_t_com$rpl$specter80413 = (function com$rpl$specter$__GT_t_com$rpl$specter80413(meta80414){
return (new com.rpl.specter.t_com$rpl$specter80413(meta80414));
});

}

return (new com.rpl.specter.t_com$rpl$specter80413(null));
})()
;
/**
 * Navigate to the last element of the collection. If the collection is
 *        empty navigation is stopped at this point.
 */
com.rpl.specter.LAST = com.rpl.specter.navs.PosNavigator.call(null,com.rpl.specter.navs.get_last,com.rpl.specter.navs.update_last);
/**
 * Navigate to the first element of the collection. If the collection is
 *        empty navigation is stopped at this point.
 */
com.rpl.specter.FIRST = com.rpl.specter.navs.PosNavigator.call(null,com.rpl.specter.navs.get_first,com.rpl.specter.navs.update_first);


com.rpl.specter.srange_dynamic_select_STAR_ = (function com$rpl$specter$srange_dynamic_select_STAR_(start_index_fn,end_index_fn,structure,next_fn){
var s = start_index_fn.call(null,structure);
return com.rpl.specter.navs.srange_select.call(null,structure,s,com.rpl.specter.navs.invoke_end_fn.call(null,end_index_fn,structure,s),next_fn);
});

com.rpl.specter.srange_dynamic_transform_STAR_ = (function com$rpl$specter$srange_dynamic_transform_STAR_(start_index_fn,end_index_fn,structure,next_fn){
var s = start_index_fn.call(null,structure);
return com.rpl.specter.navs.srange_transform.call(null,structure,s,com.rpl.specter.navs.invoke_end_fn.call(null,end_index_fn,structure,s),next_fn);
});

/**
 * Uses start-index-fn and end-index-fn to determine the bounds of the subsequence
 *        to select when navigating. `start-index-fn` takes in the structure as input. `end-index-fn`
 *        can be one of two forms. If a regular function (e.g. defined with `fn`), it takes in only the structure as input. If a function defined using special `end-fn` macro, it takes in the structure and the result of `start-index-fn`.
 */
com.rpl.specter.srange_dynamic = com.rpl.specter.impl.direct_nav_obj.call(null,(function (start_index_fn,end_index_fn){
if(typeof com.rpl.specter.t_com$rpl$specter80430 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter80430 = (function (start_index_fn,end_index_fn,meta80431){
this.start_index_fn = start_index_fn;
this.end_index_fn = end_index_fn;
this.meta80431 = meta80431;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter80430.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_80432,meta80431__$1){
var self__ = this;
var _80432__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter80430(self__.start_index_fn,self__.end_index_fn,meta80431__$1));
});


com.rpl.specter.t_com$rpl$specter80430.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_80432){
var self__ = this;
var _80432__$1 = this;
return self__.meta80431;
});


com.rpl.specter.t_com$rpl$specter80430.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter80430.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
var s = self__.start_index_fn.call(null,structure);
return com.rpl.specter.navs.srange_select.call(null,structure,s,com.rpl.specter.navs.invoke_end_fn.call(null,self__.end_index_fn,structure,s),next_fn);
});


com.rpl.specter.t_com$rpl$specter80430.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
var s = self__.start_index_fn.call(null,structure);
return com.rpl.specter.navs.srange_transform.call(null,structure,s,com.rpl.specter.navs.invoke_end_fn.call(null,self__.end_index_fn,structure,s),next_fn);
});

com.rpl.specter.t_com$rpl$specter80430.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"start-index-fn","start-index-fn",-344842645,null),new cljs.core.Symbol(null,"end-index-fn","end-index-fn",1237092062,null),new cljs.core.Symbol(null,"meta80431","meta80431",1496074106,null)], null);
});

com.rpl.specter.t_com$rpl$specter80430.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter80430.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter80430";

com.rpl.specter.t_com$rpl$specter80430.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter80430");
});

com.rpl.specter.__GT_t_com$rpl$specter80430 = (function com$rpl$specter$__GT_t_com$rpl$specter80430(start_index_fn__$1,end_index_fn__$1,meta80431){
return (new com.rpl.specter.t_com$rpl$specter80430(start_index_fn__$1,end_index_fn__$1,meta80431));
});

}

return (new com.rpl.specter.t_com$rpl$specter80430(start_index_fn,end_index_fn,null));
}));


com.rpl.specter.srange_select_STAR_ = (function com$rpl$specter$srange_select_STAR_(start,end,structure,next_fn){
return com.rpl.specter.navs.srange_select.call(null,structure,start,end,next_fn);
});

com.rpl.specter.srange_transform_STAR_ = (function com$rpl$specter$srange_transform_STAR_(start,end,structure,next_fn){
return com.rpl.specter.navs.srange_transform.call(null,structure,start,end,next_fn);
});

/**
 * Navigates to the subsequence bound by the indexes start (inclusive)
 *        and end (exclusive)
 */
com.rpl.specter.srange = com.rpl.specter.impl.direct_nav_obj.call(null,(function (start,end){
if(typeof com.rpl.specter.t_com$rpl$specter80471 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter80471 = (function (start,end,meta80472){
this.start = start;
this.end = end;
this.meta80472 = meta80472;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter80471.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_80473,meta80472__$1){
var self__ = this;
var _80473__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter80471(self__.start,self__.end,meta80472__$1));
});


com.rpl.specter.t_com$rpl$specter80471.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_80473){
var self__ = this;
var _80473__$1 = this;
return self__.meta80472;
});


com.rpl.specter.t_com$rpl$specter80471.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter80471.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return com.rpl.specter.navs.srange_select.call(null,structure,self__.start,self__.end,next_fn);
});


com.rpl.specter.t_com$rpl$specter80471.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return com.rpl.specter.navs.srange_transform.call(null,structure,self__.start,self__.end,next_fn);
});

com.rpl.specter.t_com$rpl$specter80471.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.Symbol(null,"meta80472","meta80472",413711502,null)], null);
});

com.rpl.specter.t_com$rpl$specter80471.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter80471.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter80471";

com.rpl.specter.t_com$rpl$specter80471.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter80471");
});

com.rpl.specter.__GT_t_com$rpl$specter80471 = (function com$rpl$specter$__GT_t_com$rpl$specter80471(start__$1,end__$1,meta80472){
return (new com.rpl.specter.t_com$rpl$specter80471(start__$1,end__$1,meta80472));
});

}

return (new com.rpl.specter.t_com$rpl$specter80471(start,end,null));
}));


com.rpl.specter.continuous_subseqs_select_STAR_ = (function com$rpl$specter$continuous_subseqs_select_STAR_(pred,structure,next_fn){
return cljs.core.reduce.call(null,(function (curr__30794__auto__,p__80494){
var vec__80495 = p__80494;
var s = cljs.core.nth.call(null,vec__80495,(0),null);
var e = cljs.core.nth.call(null,vec__80495,(1),null);
var ret__30795__auto__ = com.rpl.specter.navs.srange_select.call(null,structure,s,e,next_fn);
if((ret__30795__auto__ === com.rpl.specter.NONE)){
return curr__30794__auto__;
} else {
if(cljs.core.reduced_QMARK_.call(null,ret__30795__auto__)){
return cljs.core.reduced.call(null,ret__30795__auto__);
} else {
return ret__30795__auto__;
}
}
}),com.rpl.specter.NONE,com.rpl.specter.impl.matching_ranges.call(null,structure,pred));
});

com.rpl.specter.continuous_subseqs_transform_STAR_ = (function com$rpl$specter$continuous_subseqs_transform_STAR_(pred,structure,next_fn){
return com.rpl.specter.impl.continuous_subseqs_transform_STAR_.call(null,pred,structure,next_fn);
});

/**
 * Navigates to every continuous subsequence of elements matching `pred`
 */
com.rpl.specter.continuous_subseqs = com.rpl.specter.impl.direct_nav_obj.call(null,(function (pred){
if(typeof com.rpl.specter.t_com$rpl$specter80500 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter80500 = (function (pred,meta80501){
this.pred = pred;
this.meta80501 = meta80501;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter80500.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_80502,meta80501__$1){
var self__ = this;
var _80502__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter80500(self__.pred,meta80501__$1));
});


com.rpl.specter.t_com$rpl$specter80500.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_80502){
var self__ = this;
var _80502__$1 = this;
return self__.meta80501;
});


com.rpl.specter.t_com$rpl$specter80500.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter80500.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return cljs.core.reduce.call(null,((function (next_fn,this__32582__auto____$1){
return (function (curr__30794__auto__,p__80506){
var vec__80507 = p__80506;
var s = cljs.core.nth.call(null,vec__80507,(0),null);
var e = cljs.core.nth.call(null,vec__80507,(1),null);
var ret__30795__auto__ = com.rpl.specter.navs.srange_select.call(null,structure,s,e,next_fn);
if((ret__30795__auto__ === com.rpl.specter.NONE)){
return curr__30794__auto__;
} else {
if(cljs.core.reduced_QMARK_.call(null,ret__30795__auto__)){
return cljs.core.reduced.call(null,ret__30795__auto__);
} else {
return ret__30795__auto__;
}
}
});})(next_fn,this__32582__auto____$1))
,com.rpl.specter.NONE,com.rpl.specter.impl.matching_ranges.call(null,structure,self__.pred));
});


com.rpl.specter.t_com$rpl$specter80500.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return com.rpl.specter.impl.continuous_subseqs_transform_STAR_.call(null,self__.pred,structure,next_fn);
});

com.rpl.specter.t_com$rpl$specter80500.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"meta80501","meta80501",683125430,null)], null);
});

com.rpl.specter.t_com$rpl$specter80500.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter80500.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter80500";

com.rpl.specter.t_com$rpl$specter80500.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter80500");
});

com.rpl.specter.__GT_t_com$rpl$specter80500 = (function com$rpl$specter$__GT_t_com$rpl$specter80500(pred__$1,meta80501){
return (new com.rpl.specter.t_com$rpl$specter80500(pred__$1,meta80501));
});

}

return (new com.rpl.specter.t_com$rpl$specter80500(pred,null));
}));


com.rpl.specter.BEGINNING_select_STAR_ = (function com$rpl$specter$BEGINNING_select_STAR_(structure,next_fn){
return next_fn.call(null,((typeof structure === 'string')?"":cljs.core.PersistentVector.EMPTY));
});

com.rpl.specter.BEGINNING_transform_STAR_ = (function com$rpl$specter$BEGINNING_transform_STAR_(structure,next_fn){
if(typeof structure === 'string'){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(next_fn.call(null,"")),cljs.core.str.cljs$core$IFn$_invoke$arity$1(structure)].join('');
} else {
var to_prepend = next_fn.call(null,cljs.core.PersistentVector.EMPTY);
return com.rpl.specter.navs.prepend_all.call(null,structure,to_prepend);
}
});

/**
 * Navigate to the empty subsequence before the first element of the collection.
 */
com.rpl.specter.BEGINNING = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter80518 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter80518 = (function (meta80519){
this.meta80519 = meta80519;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter80518.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_80520,meta80519__$1){
var self__ = this;
var _80520__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter80518(meta80519__$1));
});


com.rpl.specter.t_com$rpl$specter80518.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_80520){
var self__ = this;
var _80520__$1 = this;
return self__.meta80519;
});


com.rpl.specter.t_com$rpl$specter80518.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter80518.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return next_fn.call(null,((typeof structure === 'string')?"":cljs.core.PersistentVector.EMPTY));
});


com.rpl.specter.t_com$rpl$specter80518.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
if(typeof structure === 'string'){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(next_fn.call(null,"")),cljs.core.str.cljs$core$IFn$_invoke$arity$1(structure)].join('');
} else {
var to_prepend = next_fn.call(null,cljs.core.PersistentVector.EMPTY);
return com.rpl.specter.navs.prepend_all.call(null,structure,to_prepend);
}
});

com.rpl.specter.t_com$rpl$specter80518.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta80519","meta80519",-2131109333,null)], null);
});

com.rpl.specter.t_com$rpl$specter80518.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter80518.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter80518";

com.rpl.specter.t_com$rpl$specter80518.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter80518");
});

com.rpl.specter.__GT_t_com$rpl$specter80518 = (function com$rpl$specter$__GT_t_com$rpl$specter80518(meta80519){
return (new com.rpl.specter.t_com$rpl$specter80518(meta80519));
});

}

return (new com.rpl.specter.t_com$rpl$specter80518(null));
})()
;


com.rpl.specter.END_select_STAR_ = (function com$rpl$specter$END_select_STAR_(structure,next_fn){
return next_fn.call(null,((typeof structure === 'string')?"":cljs.core.PersistentVector.EMPTY));
});

com.rpl.specter.END_transform_STAR_ = (function com$rpl$specter$END_transform_STAR_(structure,next_fn){
if(typeof structure === 'string'){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(structure),cljs.core.str.cljs$core$IFn$_invoke$arity$1(next_fn.call(null,""))].join('');
} else {
var to_append = next_fn.call(null,cljs.core.PersistentVector.EMPTY);
return com.rpl.specter.navs.append_all.call(null,structure,to_append);
}
});

/**
 * Navigate to the empty subsequence after the last element of the collection.
 */
com.rpl.specter.END = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter80524 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter80524 = (function (meta80525){
this.meta80525 = meta80525;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter80524.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_80526,meta80525__$1){
var self__ = this;
var _80526__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter80524(meta80525__$1));
});


com.rpl.specter.t_com$rpl$specter80524.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_80526){
var self__ = this;
var _80526__$1 = this;
return self__.meta80525;
});


com.rpl.specter.t_com$rpl$specter80524.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter80524.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return next_fn.call(null,((typeof structure === 'string')?"":cljs.core.PersistentVector.EMPTY));
});


com.rpl.specter.t_com$rpl$specter80524.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
if(typeof structure === 'string'){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(structure),cljs.core.str.cljs$core$IFn$_invoke$arity$1(next_fn.call(null,""))].join('');
} else {
var to_append = next_fn.call(null,cljs.core.PersistentVector.EMPTY);
return com.rpl.specter.navs.append_all.call(null,structure,to_append);
}
});

com.rpl.specter.t_com$rpl$specter80524.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta80525","meta80525",-1891547283,null)], null);
});

com.rpl.specter.t_com$rpl$specter80524.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter80524.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter80524";

com.rpl.specter.t_com$rpl$specter80524.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter80524");
});

com.rpl.specter.__GT_t_com$rpl$specter80524 = (function com$rpl$specter$__GT_t_com$rpl$specter80524(meta80525){
return (new com.rpl.specter.t_com$rpl$specter80524(meta80525));
});

}

return (new com.rpl.specter.t_com$rpl$specter80524(null));
})()
;


com.rpl.specter.NONE_ELEM_select_STAR_ = (function com$rpl$specter$NONE_ELEM_select_STAR_(structure,next_fn){
return next_fn.call(null,com.rpl.specter.NONE);
});

com.rpl.specter.NONE_ELEM_transform_STAR_ = (function com$rpl$specter$NONE_ELEM_transform_STAR_(structure,next_fn){
var newe = next_fn.call(null,com.rpl.specter.NONE);
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
if((structure == null)){
return cljs.core.PersistentHashSet.createAsIfByAssoc([newe]);
} else {
return cljs.core.conj.call(null,structure,newe);
}
}
});

/**
 * Navigate to 'void' elem in the set.
 *        For transformations - if result is not `NONE`,
 *        then add that value to the set.
 */
com.rpl.specter.NONE_ELEM = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter80669 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter80669 = (function (meta80671){
this.meta80671 = meta80671;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter80669.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_80672,meta80671__$1){
var self__ = this;
var _80672__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter80669(meta80671__$1));
});


com.rpl.specter.t_com$rpl$specter80669.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_80672){
var self__ = this;
var _80672__$1 = this;
return self__.meta80671;
});


com.rpl.specter.t_com$rpl$specter80669.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter80669.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return next_fn.call(null,com.rpl.specter.NONE);
});


com.rpl.specter.t_com$rpl$specter80669.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
var newe = next_fn.call(null,com.rpl.specter.NONE);
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
if((structure == null)){
return cljs.core.PersistentHashSet.createAsIfByAssoc([newe]);
} else {
return cljs.core.conj.call(null,structure,newe);
}
}
});

com.rpl.specter.t_com$rpl$specter80669.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta80671","meta80671",533551487,null)], null);
});

com.rpl.specter.t_com$rpl$specter80669.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter80669.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter80669";

com.rpl.specter.t_com$rpl$specter80669.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter80669");
});

com.rpl.specter.__GT_t_com$rpl$specter80669 = (function com$rpl$specter$__GT_t_com$rpl$specter80669(meta80671){
return (new com.rpl.specter.t_com$rpl$specter80669(meta80671));
});

}

return (new com.rpl.specter.t_com$rpl$specter80669(null));
})()
;


com.rpl.specter.BEFORE_ELEM_select_STAR_ = (function com$rpl$specter$BEFORE_ELEM_select_STAR_(structure,next_fn){
return next_fn.call(null,com.rpl.specter.NONE);
});

com.rpl.specter.BEFORE_ELEM_transform_STAR_ = (function com$rpl$specter$BEFORE_ELEM_transform_STAR_(structure,next_fn){
var newe = next_fn.call(null,com.rpl.specter.NONE);
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
return com.rpl.specter.navs.prepend_one.call(null,structure,newe);
}
});

/**
 * Navigate to 'void' element before the sequence.
 *        For transformations – if result is not `NONE`,
 *        then prepend that value.
 */
com.rpl.specter.BEFORE_ELEM = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter80723 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter80723 = (function (meta80724){
this.meta80724 = meta80724;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter80723.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_80725,meta80724__$1){
var self__ = this;
var _80725__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter80723(meta80724__$1));
});


com.rpl.specter.t_com$rpl$specter80723.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_80725){
var self__ = this;
var _80725__$1 = this;
return self__.meta80724;
});


com.rpl.specter.t_com$rpl$specter80723.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter80723.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return next_fn.call(null,com.rpl.specter.NONE);
});


com.rpl.specter.t_com$rpl$specter80723.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
var newe = next_fn.call(null,com.rpl.specter.NONE);
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
return com.rpl.specter.navs.prepend_one.call(null,structure,newe);
}
});

com.rpl.specter.t_com$rpl$specter80723.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta80724","meta80724",417996301,null)], null);
});

com.rpl.specter.t_com$rpl$specter80723.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter80723.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter80723";

com.rpl.specter.t_com$rpl$specter80723.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter80723");
});

com.rpl.specter.__GT_t_com$rpl$specter80723 = (function com$rpl$specter$__GT_t_com$rpl$specter80723(meta80724){
return (new com.rpl.specter.t_com$rpl$specter80723(meta80724));
});

}

return (new com.rpl.specter.t_com$rpl$specter80723(null));
})()
;


com.rpl.specter.AFTER_ELEM_select_STAR_ = (function com$rpl$specter$AFTER_ELEM_select_STAR_(structure,next_fn){
return next_fn.call(null,com.rpl.specter.NONE);
});

com.rpl.specter.AFTER_ELEM_transform_STAR_ = (function com$rpl$specter$AFTER_ELEM_transform_STAR_(structure,next_fn){
var newe = next_fn.call(null,com.rpl.specter.NONE);
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
return com.rpl.specter.navs.append_one.call(null,structure,newe);
}
});

/**
 * Navigate to 'void' element after the sequence.
 *        For transformations – if result is not `NONE`,
 *        then append that value.
 */
com.rpl.specter.AFTER_ELEM = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter80752 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter80752 = (function (meta80753){
this.meta80753 = meta80753;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter80752.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_80754,meta80753__$1){
var self__ = this;
var _80754__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter80752(meta80753__$1));
});


com.rpl.specter.t_com$rpl$specter80752.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_80754){
var self__ = this;
var _80754__$1 = this;
return self__.meta80753;
});


com.rpl.specter.t_com$rpl$specter80752.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter80752.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return next_fn.call(null,com.rpl.specter.NONE);
});


com.rpl.specter.t_com$rpl$specter80752.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
var newe = next_fn.call(null,com.rpl.specter.NONE);
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
return com.rpl.specter.navs.append_one.call(null,structure,newe);
}
});

com.rpl.specter.t_com$rpl$specter80752.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta80753","meta80753",1493429908,null)], null);
});

com.rpl.specter.t_com$rpl$specter80752.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter80752.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter80752";

com.rpl.specter.t_com$rpl$specter80752.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter80752");
});

com.rpl.specter.__GT_t_com$rpl$specter80752 = (function com$rpl$specter$__GT_t_com$rpl$specter80752(meta80753){
return (new com.rpl.specter.t_com$rpl$specter80752(meta80753));
});

}

return (new com.rpl.specter.t_com$rpl$specter80752(null));
})()
;


com.rpl.specter.subset_select_STAR_ = (function com$rpl$specter$subset_select_STAR_(aset,structure,next_fn){
return next_fn.call(null,clojure.set.intersection.call(null,structure,aset));
});

com.rpl.specter.subset_transform_STAR_ = (function com$rpl$specter$subset_transform_STAR_(aset,structure,next_fn){
var subset = clojure.set.intersection.call(null,structure,aset);
var newset = next_fn.call(null,subset);
return clojure.set.union.call(null,clojure.set.difference.call(null,structure,subset),newset);
});

/**
 * Navigates to the specified subset (by taking an intersection).
 *        In a transform, that subset in the original set is changed to the
 *        new value of the subset.
 */
com.rpl.specter.subset = com.rpl.specter.impl.direct_nav_obj.call(null,(function (aset){
if(typeof com.rpl.specter.t_com$rpl$specter80759 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter80759 = (function (aset,meta80760){
this.aset = aset;
this.meta80760 = meta80760;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter80759.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_80761,meta80760__$1){
var self__ = this;
var _80761__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter80759(self__.aset,meta80760__$1));
});


com.rpl.specter.t_com$rpl$specter80759.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_80761){
var self__ = this;
var _80761__$1 = this;
return self__.meta80760;
});


com.rpl.specter.t_com$rpl$specter80759.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter80759.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return next_fn.call(null,clojure.set.intersection.call(null,structure,self__.aset));
});


com.rpl.specter.t_com$rpl$specter80759.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
var subset = clojure.set.intersection.call(null,structure,self__.aset);
var newset = next_fn.call(null,subset);
return clojure.set.union.call(null,clojure.set.difference.call(null,structure,subset),newset);
});

com.rpl.specter.t_com$rpl$specter80759.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"aset","aset",900773178,null),new cljs.core.Symbol(null,"meta80760","meta80760",-959380496,null)], null);
});

com.rpl.specter.t_com$rpl$specter80759.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter80759.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter80759";

com.rpl.specter.t_com$rpl$specter80759.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter80759");
});

com.rpl.specter.__GT_t_com$rpl$specter80759 = (function com$rpl$specter$__GT_t_com$rpl$specter80759(aset__$1,meta80760){
return (new com.rpl.specter.t_com$rpl$specter80759(aset__$1,meta80760));
});

}

return (new com.rpl.specter.t_com$rpl$specter80759(aset,null));
}));


com.rpl.specter.submap_select_STAR_ = (function com$rpl$specter$submap_select_STAR_(m_keys,structure,next_fn){
return next_fn.call(null,cljs.core.select_keys.call(null,structure,m_keys));
});

com.rpl.specter.submap_transform_STAR_ = (function com$rpl$specter$submap_transform_STAR_(m_keys,structure,next_fn){
var submap = cljs.core.select_keys.call(null,structure,m_keys);
var newmap = next_fn.call(null,submap);
return cljs.core.merge.call(null,cljs.core.reduce.call(null,cljs.core.dissoc,structure,m_keys),newmap);
});

/**
 * Navigates to the specified submap (using select-keys).
 *        In a transform, that submap in the original map is changed to the new
 *        value of the submap.
 */
com.rpl.specter.submap = com.rpl.specter.impl.direct_nav_obj.call(null,(function (m_keys){
if(typeof com.rpl.specter.t_com$rpl$specter80772 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter80772 = (function (m_keys,meta80773){
this.m_keys = m_keys;
this.meta80773 = meta80773;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter80772.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_80774,meta80773__$1){
var self__ = this;
var _80774__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter80772(self__.m_keys,meta80773__$1));
});


com.rpl.specter.t_com$rpl$specter80772.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_80774){
var self__ = this;
var _80774__$1 = this;
return self__.meta80773;
});


com.rpl.specter.t_com$rpl$specter80772.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter80772.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return next_fn.call(null,cljs.core.select_keys.call(null,structure,self__.m_keys));
});


com.rpl.specter.t_com$rpl$specter80772.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
var submap = cljs.core.select_keys.call(null,structure,self__.m_keys);
var newmap = next_fn.call(null,submap);
return cljs.core.merge.call(null,cljs.core.reduce.call(null,cljs.core.dissoc,structure,self__.m_keys),newmap);
});

com.rpl.specter.t_com$rpl$specter80772.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"m-keys","m-keys",-197459035,null),new cljs.core.Symbol(null,"meta80773","meta80773",-1454321481,null)], null);
});

com.rpl.specter.t_com$rpl$specter80772.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter80772.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter80772";

com.rpl.specter.t_com$rpl$specter80772.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter80772");
});

com.rpl.specter.__GT_t_com$rpl$specter80772 = (function com$rpl$specter$__GT_t_com$rpl$specter80772(m_keys__$1,meta80773){
return (new com.rpl.specter.t_com$rpl$specter80772(m_keys__$1,meta80773));
});

}

return (new com.rpl.specter.t_com$rpl$specter80772(m_keys,null));
}));
/**
 * Navigates to a sequence that contains the results of (select ...),
 *   but is a view to the original structure that can be transformed.
 * 
 *   Requires that the input navigators will walk the structure's
 *   children in the same order when executed on "select" and then
 *   "transform".
 * 
 *   If transformed sequence is smaller than input sequence, missing entries
 *   will be filled in with NONE, triggering removal if supported by that navigator.
 */
com.rpl.specter.subselect = cljs.core.vary_meta.call(null,com.rpl.specter.wrap_dynamic_nav.call(null,(function() { 
var G__80792__delegate = function (path){
var builder__33346__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,(function (late){
if(typeof com.rpl.specter.t_com$rpl$specter80785 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter80785 = (function (path,late,meta80786){
this.path = path;
this.late = late;
this.meta80786 = meta80786;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter80785.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_80787,meta80786__$1){
var self__ = this;
var _80787__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter80785(self__.path,self__.late,meta80786__$1));
});


com.rpl.specter.t_com$rpl$specter80785.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_80787){
var self__ = this;
var _80787__$1 = this;
return self__.meta80786;
});


com.rpl.specter.t_com$rpl$specter80785.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter80785.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return next_fn.call(null,com.rpl.specter.compiled_select.call(null,self__.late,structure));
});


com.rpl.specter.t_com$rpl$specter80785.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
var select_result = com.rpl.specter.compiled_select.call(null,self__.late,structure);
var transformed = next_fn.call(null,select_result);
var values_to_insert = com.rpl.specter.impl.mutable_cell.call(null,transformed);
return com.rpl.specter.compiled_transform.call(null,self__.late,((function (select_result,transformed,values_to_insert,next_fn,this__32582__auto____$1){
return (function (_){
var vs = com.rpl.specter.impl.get_cell.call(null,values_to_insert);
if(cljs.core.truth_(vs)){
com.rpl.specter.impl.update_cell_BANG_.call(null,values_to_insert,cljs.core.next);

return cljs.core.first.call(null,vs);
} else {
return com.rpl.specter.NONE;
}
});})(select_result,transformed,values_to_insert,next_fn,this__32582__auto____$1))
,structure);
});

com.rpl.specter.t_com$rpl$specter80785.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta80786","meta80786",-706527287,null)], null);
});

com.rpl.specter.t_com$rpl$specter80785.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter80785.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter80785";

com.rpl.specter.t_com$rpl$specter80785.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter80785");
});

com.rpl.specter.__GT_t_com$rpl$specter80785 = (function com$rpl$specter$__GT_t_com$rpl$specter80785(path__$1,late__$1,meta80786){
return (new com.rpl.specter.t_com$rpl$specter80785(path__$1,late__$1,meta80786));
});

}

return (new com.rpl.specter.t_com$rpl$specter80785(path,late,null));
}));
var curr_params__33347__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,path)], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__33347__auto__)){
return cljs.core.apply.call(null,builder__33346__auto__,curr_params__33347__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__33346__auto__,curr_params__33347__auto__,null);
}
};
var G__80792 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__80801__i = 0, G__80801__a = new Array(arguments.length -  0);
while (G__80801__i < G__80801__a.length) {G__80801__a[G__80801__i] = arguments[G__80801__i + 0]; ++G__80801__i;}
  path = new cljs.core.IndexedSeq(G__80801__a,0,null);
} 
return G__80792__delegate.call(this,path);};
G__80792.cljs$lang$maxFixedArity = 0;
G__80792.cljs$lang$applyTo = (function (arglist__80802){
var path = cljs.core.seq(arglist__80802);
return G__80792__delegate(path);
});
G__80792.cljs$core$IFn$_invoke$arity$variadic = G__80792__delegate;
return G__80792;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to the given key in the map (not to the value). Navigates only if the
 *        key currently exists in the map. Can transform to NONE to remove the key/value
 *        pair from the map.
 */
com.rpl.specter.map_key = com.rpl.specter.impl.direct_nav_obj.call(null,(function (key){
if(typeof com.rpl.specter.t_com$rpl$specter80804 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter80804 = (function (key,meta80805){
this.key = key;
this.meta80805 = meta80805;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter80804.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_80806,meta80805__$1){
var self__ = this;
var _80806__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter80804(self__.key,meta80805__$1));
});


com.rpl.specter.t_com$rpl$specter80804.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_80806){
var self__ = this;
var _80806__$1 = this;
return self__.meta80805;
});


com.rpl.specter.t_com$rpl$specter80804.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter80804.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if(cljs.core.contains_QMARK_.call(null,structure,self__.key)){
return next_fn.call(null,vals,self__.key);
} else {
return com.rpl.specter.NONE;
}
});


com.rpl.specter.t_com$rpl$specter80804.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if(cljs.core.contains_QMARK_.call(null,structure,self__.key)){
var newkey = next_fn.call(null,vals,self__.key);
var dissoced = cljs.core.dissoc.call(null,structure,self__.key);
if((com.rpl.specter.NONE === newkey)){
return dissoced;
} else {
return cljs.core.assoc.call(null,dissoced,newkey,cljs.core.get.call(null,structure,self__.key));
}
} else {
return structure;
}
});

com.rpl.specter.t_com$rpl$specter80804.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"key","key",124488940,null),new cljs.core.Symbol(null,"meta80805","meta80805",-1061035294,null)], null);
});

com.rpl.specter.t_com$rpl$specter80804.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter80804.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter80804";

com.rpl.specter.t_com$rpl$specter80804.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter80804");
});

com.rpl.specter.__GT_t_com$rpl$specter80804 = (function com$rpl$specter$__GT_t_com$rpl$specter80804(key__$1,meta80805){
return (new com.rpl.specter.t_com$rpl$specter80804(key__$1,meta80805));
});

}

return (new com.rpl.specter.t_com$rpl$specter80804(key,null));
}));
/**
 * Navigates to the given element in the set only if it exists in the set.
 *        Can transform to NONE to remove the element from the set.
 */
com.rpl.specter.set_elem = com.rpl.specter.impl.direct_nav_obj.call(null,(function (elem){
if(typeof com.rpl.specter.t_com$rpl$specter80818 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter80818 = (function (elem,meta80819){
this.elem = elem;
this.meta80819 = meta80819;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter80818.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_80820,meta80819__$1){
var self__ = this;
var _80820__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter80818(self__.elem,meta80819__$1));
});


com.rpl.specter.t_com$rpl$specter80818.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_80820){
var self__ = this;
var _80820__$1 = this;
return self__.meta80819;
});


com.rpl.specter.t_com$rpl$specter80818.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter80818.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if(cljs.core.contains_QMARK_.call(null,structure,self__.elem)){
return next_fn.call(null,vals,self__.elem);
} else {
return com.rpl.specter.NONE;
}
});


com.rpl.specter.t_com$rpl$specter80818.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if(cljs.core.contains_QMARK_.call(null,structure,self__.elem)){
var newelem = next_fn.call(null,vals,self__.elem);
var removed = cljs.core.disj.call(null,structure,self__.elem);
if((com.rpl.specter.NONE === newelem)){
return removed;
} else {
return cljs.core.conj.call(null,removed,newelem);
}
} else {
return structure;
}
});

com.rpl.specter.t_com$rpl$specter80818.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"elem","elem",-2035804713,null),new cljs.core.Symbol(null,"meta80819","meta80819",1347773903,null)], null);
});

com.rpl.specter.t_com$rpl$specter80818.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter80818.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter80818";

com.rpl.specter.t_com$rpl$specter80818.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter80818");
});

com.rpl.specter.__GT_t_com$rpl$specter80818 = (function com$rpl$specter$__GT_t_com$rpl$specter80818(elem__$1,meta80819){
return (new com.rpl.specter.t_com$rpl$specter80818(elem__$1,meta80819));
});

}

return (new com.rpl.specter.t_com$rpl$specter80818(elem,null));
}));
/**
 * Navigate to the specified keys one after another. If navigate to NONE,
 *           that element is removed from the map or vector.
 */
com.rpl.specter.keypath = com.rpl.specter.eachnav.call(null,com.rpl.specter.navs.keypath_STAR_);
/**
 * Navigate to the specified keys one after another, only if they exist
 *           in the data structure. If navigate to NONE, that element is removed
 *           from the map or vector.
 */
com.rpl.specter.must = com.rpl.specter.eachnav.call(null,com.rpl.specter.navs.must_STAR_);
/**
 * Navigate to the specified indices one after another.If navigate to
 *          NONE, that element is removed from the sequence.
 */
com.rpl.specter.nthpath = com.rpl.specter.eachnav.call(null,com.rpl.specter.navs.nthpath_STAR_);
/**
 * Navigates to result of running `afn` on the currently navigated value.
 */
com.rpl.specter.view = com.rpl.specter.impl.direct_nav_obj.call(null,(function (afn){
if(typeof com.rpl.specter.t_com$rpl$specter80830 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter80830 = (function (afn,meta80831){
this.afn = afn;
this.meta80831 = meta80831;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter80830.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_80832,meta80831__$1){
var self__ = this;
var _80832__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter80830(self__.afn,meta80831__$1));
});


com.rpl.specter.t_com$rpl$specter80830.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_80832){
var self__ = this;
var _80832__$1 = this;
return self__.meta80831;
});


com.rpl.specter.t_com$rpl$specter80830.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter80830.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return next_fn.call(null,vals,self__.afn.call(null,structure));
});


com.rpl.specter.t_com$rpl$specter80830.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return next_fn.call(null,vals,self__.afn.call(null,structure));
});

com.rpl.specter.t_com$rpl$specter80830.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"meta80831","meta80831",-878201773,null)], null);
});

com.rpl.specter.t_com$rpl$specter80830.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter80830.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter80830";

com.rpl.specter.t_com$rpl$specter80830.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter80830");
});

com.rpl.specter.__GT_t_com$rpl$specter80830 = (function com$rpl$specter$__GT_t_com$rpl$specter80830(afn__$1,meta80831){
return (new com.rpl.specter.t_com$rpl$specter80830(afn__$1,meta80831));
});

}

return (new com.rpl.specter.t_com$rpl$specter80830(afn,null));
}));


com.rpl.specter.parser_select_STAR_ = (function com$rpl$specter$parser_select_STAR_(parse_fn,unparse_fn,structure,next_fn){
return next_fn.call(null,parse_fn.call(null,structure));
});

com.rpl.specter.parser_transform_STAR_ = (function com$rpl$specter$parser_transform_STAR_(parse_fn,unparse_fn,structure,next_fn){
return unparse_fn.call(null,next_fn.call(null,parse_fn.call(null,structure)));
});

/**
 * Navigate to the result of running `parse-fn` on the value. For
 *        transforms, the transformed value then has `unparse-fn` run on
 *        it to get the final value at this point.
 */
com.rpl.specter.parser = com.rpl.specter.impl.direct_nav_obj.call(null,(function (parse_fn,unparse_fn){
if(typeof com.rpl.specter.t_com$rpl$specter80836 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter80836 = (function (parse_fn,unparse_fn,meta80837){
this.parse_fn = parse_fn;
this.unparse_fn = unparse_fn;
this.meta80837 = meta80837;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter80836.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_80838,meta80837__$1){
var self__ = this;
var _80838__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter80836(self__.parse_fn,self__.unparse_fn,meta80837__$1));
});


com.rpl.specter.t_com$rpl$specter80836.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_80838){
var self__ = this;
var _80838__$1 = this;
return self__.meta80837;
});


com.rpl.specter.t_com$rpl$specter80836.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter80836.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return next_fn.call(null,self__.parse_fn.call(null,structure));
});


com.rpl.specter.t_com$rpl$specter80836.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return self__.unparse_fn.call(null,next_fn.call(null,self__.parse_fn.call(null,structure)));
});

com.rpl.specter.t_com$rpl$specter80836.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"parse-fn","parse-fn",-836029424,null),new cljs.core.Symbol(null,"unparse-fn","unparse-fn",407187734,null),new cljs.core.Symbol(null,"meta80837","meta80837",-590936545,null)], null);
});

com.rpl.specter.t_com$rpl$specter80836.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter80836.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter80836";

com.rpl.specter.t_com$rpl$specter80836.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter80836");
});

com.rpl.specter.__GT_t_com$rpl$specter80836 = (function com$rpl$specter$__GT_t_com$rpl$specter80836(parse_fn__$1,unparse_fn__$1,meta80837){
return (new com.rpl.specter.t_com$rpl$specter80836(parse_fn__$1,unparse_fn__$1,meta80837));
});

}

return (new com.rpl.specter.t_com$rpl$specter80836(parse_fn,unparse_fn,null));
}));


com.rpl.specter.ATOM_select_STAR_ = (function com$rpl$specter$ATOM_select_STAR_(structure,next_fn){
return next_fn.call(null,cljs.core.deref.call(null,structure));
});

com.rpl.specter.ATOM_transform_STAR_ = (function com$rpl$specter$ATOM_transform_STAR_(structure,next_fn){
cljs.core.swap_BANG_.call(null,structure,next_fn);

return structure;
});

/**
 * Navigates to atom value.
 */
com.rpl.specter.ATOM = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter80839 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter80839 = (function (meta80840){
this.meta80840 = meta80840;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter80839.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_80841,meta80840__$1){
var self__ = this;
var _80841__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter80839(meta80840__$1));
});


com.rpl.specter.t_com$rpl$specter80839.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_80841){
var self__ = this;
var _80841__$1 = this;
return self__.meta80840;
});


com.rpl.specter.t_com$rpl$specter80839.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter80839.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return next_fn.call(null,cljs.core.deref.call(null,structure));
});


com.rpl.specter.t_com$rpl$specter80839.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
cljs.core.swap_BANG_.call(null,structure,next_fn);

return structure;
});

com.rpl.specter.t_com$rpl$specter80839.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta80840","meta80840",577253200,null)], null);
});

com.rpl.specter.t_com$rpl$specter80839.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter80839.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter80839";

com.rpl.specter.t_com$rpl$specter80839.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter80839");
});

com.rpl.specter.__GT_t_com$rpl$specter80839 = (function com$rpl$specter$__GT_t_com$rpl$specter80839(meta80840){
return (new com.rpl.specter.t_com$rpl$specter80839(meta80840));
});

}

return (new com.rpl.specter.t_com$rpl$specter80839(null));
})()
;
/**
 * Filters the current value based on whether a path finds anything.
 *   e.g. (selected? :vals ALL even?) keeps the current element only if an
 *   even number exists for the :vals key.
 */
com.rpl.specter.selected_QMARK_ = cljs.core.vary_meta.call(null,com.rpl.specter.wrap_dynamic_nav.call(null,(function() { 
var G__80863__delegate = function (path){
var temp__4655__auto__ = com.rpl.specter.navs.extract_basic_filter_fn.call(null,path);
if(cljs.core.truth_(temp__4655__auto__)){
var afn = temp__4655__auto__;
return afn;
} else {
var builder__33346__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,((function (temp__4655__auto__){
return (function (late){
if(typeof com.rpl.specter.t_com$rpl$specter80857 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter80857 = (function (path,temp__4655__auto__,late,meta80858){
this.path = path;
this.temp__4655__auto__ = temp__4655__auto__;
this.late = late;
this.meta80858 = meta80858;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter80857.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (temp__4655__auto__){
return (function (_80859,meta80858__$1){
var self__ = this;
var _80859__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter80857(self__.path,self__.temp__4655__auto__,self__.late,meta80858__$1));
});})(temp__4655__auto__))
;


com.rpl.specter.t_com$rpl$specter80857.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (temp__4655__auto__){
return (function (_80859){
var self__ = this;
var _80859__$1 = this;
return self__.meta80858;
});})(temp__4655__auto__))
;


com.rpl.specter.t_com$rpl$specter80857.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter80857.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = ((function (temp__4655__auto__){
return (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.filter_select.call(null,((function (this$__$1,temp__4655__auto__){
return (function (p1__80855_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_.call(null,self__.late,vals,p1__80855_SHARP_);
});})(this$__$1,temp__4655__auto__))
,vals,structure,next_fn);
});})(temp__4655__auto__))
;


com.rpl.specter.t_com$rpl$specter80857.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = ((function (temp__4655__auto__){
return (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.filter_transform.call(null,((function (this$__$1,temp__4655__auto__){
return (function (p1__80856_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_.call(null,self__.late,vals,p1__80856_SHARP_);
});})(this$__$1,temp__4655__auto__))
,vals,structure,next_fn);
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter80857.getBasis = ((function (temp__4655__auto__){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"temp__4655__auto__","temp__4655__auto__",-1826162292,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta80858","meta80858",1377205128,null)], null);
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter80857.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter80857.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter80857";

com.rpl.specter.t_com$rpl$specter80857.cljs$lang$ctorPrWriter = ((function (temp__4655__auto__){
return (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter80857");
});})(temp__4655__auto__))
;

com.rpl.specter.__GT_t_com$rpl$specter80857 = ((function (temp__4655__auto__){
return (function com$rpl$specter$__GT_t_com$rpl$specter80857(path__$1,temp__4655__auto____$1,late__$1,meta80858){
return (new com.rpl.specter.t_com$rpl$specter80857(path__$1,temp__4655__auto____$1,late__$1,meta80858));
});})(temp__4655__auto__))
;

}

return (new com.rpl.specter.t_com$rpl$specter80857(path,temp__4655__auto__,late,null));
});})(temp__4655__auto__))
);
var curr_params__33347__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,path)], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__33347__auto__)){
return cljs.core.apply.call(null,builder__33346__auto__,curr_params__33347__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__33346__auto__,curr_params__33347__auto__,null);
}
}
};
var G__80863 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__80895__i = 0, G__80895__a = new Array(arguments.length -  0);
while (G__80895__i < G__80895__a.length) {G__80895__a[G__80895__i] = arguments[G__80895__i + 0]; ++G__80895__i;}
  path = new cljs.core.IndexedSeq(G__80895__a,0,null);
} 
return G__80863__delegate.call(this,path);};
G__80863.cljs$lang$maxFixedArity = 0;
G__80863.cljs$lang$applyTo = (function (arglist__80899){
var path = cljs.core.seq(arglist__80899);
return G__80863__delegate(path);
});
G__80863.cljs$core$IFn$_invoke$arity$variadic = G__80863__delegate;
return G__80863;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
com.rpl.specter.not_selected_QMARK_ = cljs.core.vary_meta.call(null,com.rpl.specter.wrap_dynamic_nav.call(null,(function() { 
var G__80981__delegate = function (path){
var temp__4655__auto__ = com.rpl.specter.navs.extract_basic_filter_fn.call(null,path);
if(cljs.core.truth_(temp__4655__auto__)){
var afn = temp__4655__auto__;
return ((function (afn,temp__4655__auto__){
return (function (s){
return cljs.core.not.call(null,afn.call(null,s));
});
;})(afn,temp__4655__auto__))
} else {
var builder__33346__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,((function (temp__4655__auto__){
return (function (late){
if(typeof com.rpl.specter.t_com$rpl$specter80933 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter80933 = (function (path,temp__4655__auto__,late,meta80934){
this.path = path;
this.temp__4655__auto__ = temp__4655__auto__;
this.late = late;
this.meta80934 = meta80934;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter80933.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (temp__4655__auto__){
return (function (_80935,meta80934__$1){
var self__ = this;
var _80935__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter80933(self__.path,self__.temp__4655__auto__,self__.late,meta80934__$1));
});})(temp__4655__auto__))
;


com.rpl.specter.t_com$rpl$specter80933.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (temp__4655__auto__){
return (function (_80935){
var self__ = this;
var _80935__$1 = this;
return self__.meta80934;
});})(temp__4655__auto__))
;


com.rpl.specter.t_com$rpl$specter80933.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter80933.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = ((function (temp__4655__auto__){
return (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.filter_select.call(null,((function (this$__$1,temp__4655__auto__){
return (function (p1__80917_SHARP_){
return com.rpl.specter.navs.not_selected_QMARK__STAR_.call(null,self__.late,vals,p1__80917_SHARP_);
});})(this$__$1,temp__4655__auto__))
,vals,structure,next_fn);
});})(temp__4655__auto__))
;


com.rpl.specter.t_com$rpl$specter80933.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = ((function (temp__4655__auto__){
return (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.filter_transform.call(null,((function (this$__$1,temp__4655__auto__){
return (function (p1__80922_SHARP_){
return com.rpl.specter.navs.not_selected_QMARK__STAR_.call(null,self__.late,vals,p1__80922_SHARP_);
});})(this$__$1,temp__4655__auto__))
,vals,structure,next_fn);
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter80933.getBasis = ((function (temp__4655__auto__){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"temp__4655__auto__","temp__4655__auto__",-1826162292,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta80934","meta80934",2116708482,null)], null);
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter80933.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter80933.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter80933";

com.rpl.specter.t_com$rpl$specter80933.cljs$lang$ctorPrWriter = ((function (temp__4655__auto__){
return (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter80933");
});})(temp__4655__auto__))
;

com.rpl.specter.__GT_t_com$rpl$specter80933 = ((function (temp__4655__auto__){
return (function com$rpl$specter$__GT_t_com$rpl$specter80933(path__$1,temp__4655__auto____$1,late__$1,meta80934){
return (new com.rpl.specter.t_com$rpl$specter80933(path__$1,temp__4655__auto____$1,late__$1,meta80934));
});})(temp__4655__auto__))
;

}

return (new com.rpl.specter.t_com$rpl$specter80933(path,temp__4655__auto__,late,null));
});})(temp__4655__auto__))
);
var curr_params__33347__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,path)], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__33347__auto__)){
return cljs.core.apply.call(null,builder__33346__auto__,curr_params__33347__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__33346__auto__,curr_params__33347__auto__,null);
}
}
};
var G__80981 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__81004__i = 0, G__81004__a = new Array(arguments.length -  0);
while (G__81004__i < G__81004__a.length) {G__81004__a[G__81004__i] = arguments[G__81004__i + 0]; ++G__81004__i;}
  path = new cljs.core.IndexedSeq(G__81004__a,0,null);
} 
return G__80981__delegate.call(this,path);};
G__80981.cljs$lang$maxFixedArity = 0;
G__80981.cljs$lang$applyTo = (function (arglist__81006){
var path = cljs.core.seq(arglist__81006);
return G__80981__delegate(path);
});
G__80981.cljs$core$IFn$_invoke$arity$variadic = G__80981__delegate;
return G__80981;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to a view of the current sequence that only contains elements that
 *   match the given path. An element matches the selector path if calling select
 *   on that element with the path yields anything other than an empty sequence.
 * 
 *   For transformation: `NONE` entries in the result sequence cause corresponding entries in
 *   input to be removed. A result sequence smaller than the input sequence is equivalent to
 *   padding the result sequence with `NONE` at the end until the same size as the input.
 */
com.rpl.specter.filterer = cljs.core.vary_meta.call(null,com.rpl.specter.wrap_dynamic_nav.call(null,(function() { 
var G__81011__delegate = function (path){
return com.rpl.specter.subselect.call(null,com.rpl.specter.ALL,com.rpl.specter.selected_QMARK_.call(null,path));
};
var G__81011 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__81013__i = 0, G__81013__a = new Array(arguments.length -  0);
while (G__81013__i < G__81013__a.length) {G__81013__a[G__81013__i] = arguments[G__81013__i + 0]; ++G__81013__i;}
  path = new cljs.core.IndexedSeq(G__81013__a,0,null);
} 
return G__81011__delegate.call(this,path);};
G__81011.cljs$lang$maxFixedArity = 0;
G__81011.cljs$lang$applyTo = (function (arglist__81015){
var path = cljs.core.seq(arglist__81015);
return G__81011__delegate(path);
});
G__81011.cljs$core$IFn$_invoke$arity$variadic = G__81011__delegate;
return G__81011;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to a view of the current value by transforming it with the
 * specified path and update-fn.
 */
com.rpl.specter.transformed = cljs.core.vary_meta.call(null,com.rpl.specter.wrap_dynamic_nav.call(null,(function (path,update_fn){
var builder__33346__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,(function (late,late_fn){
if(typeof com.rpl.specter.t_com$rpl$specter81018 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter81018 = (function (path,update_fn,late,late_fn,meta81019){
this.path = path;
this.update_fn = update_fn;
this.late = late;
this.late_fn = late_fn;
this.meta81019 = meta81019;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter81018.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_81020,meta81019__$1){
var self__ = this;
var _81020__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter81018(self__.path,self__.update_fn,self__.late,self__.late_fn,meta81019__$1));
});


com.rpl.specter.t_com$rpl$specter81018.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_81020){
var self__ = this;
var _81020__$1 = this;
return self__.meta81019;
});


com.rpl.specter.t_com$rpl$specter81018.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter81018.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return next_fn.call(null,com.rpl.specter.compiled_transform.call(null,self__.late,self__.late_fn,structure));
});


com.rpl.specter.t_com$rpl$specter81018.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return next_fn.call(null,com.rpl.specter.compiled_transform.call(null,self__.late,self__.late_fn,structure));
});

com.rpl.specter.t_com$rpl$specter81018.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"update-fn","update-fn",-1943348456,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"late-fn","late-fn",268309430,null),new cljs.core.Symbol(null,"meta81019","meta81019",1004581167,null)], null);
});

com.rpl.specter.t_com$rpl$specter81018.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter81018.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter81018";

com.rpl.specter.t_com$rpl$specter81018.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter81018");
});

com.rpl.specter.__GT_t_com$rpl$specter81018 = (function com$rpl$specter$__GT_t_com$rpl$specter81018(path__$1,update_fn__$1,late__$1,late_fn__$1,meta81019){
return (new com.rpl.specter.t_com$rpl$specter81018(path__$1,update_fn__$1,late__$1,late_fn__$1,meta81019));
});

}

return (new com.rpl.specter.t_com$rpl$specter81018(path,update_fn,late,late_fn,null));
}));
var curr_params__33347__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,path),update_fn], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__33347__auto__)){
return cljs.core.apply.call(null,builder__33346__auto__,curr_params__33347__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__33346__auto__,curr_params__33347__auto__,null);
}
})),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to a view of the current value by transforming with a reduction over
 * the specified traversal.
 */
com.rpl.specter.traversed = cljs.core.vary_meta.call(null,com.rpl.specter.wrap_dynamic_nav.call(null,(function (path,reduce_fn){
var builder__33346__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,(function (late,late_fn){
if(typeof com.rpl.specter.t_com$rpl$specter81044 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter81044 = (function (path,reduce_fn,late,late_fn,meta81045){
this.path = path;
this.reduce_fn = reduce_fn;
this.late = late;
this.late_fn = late_fn;
this.meta81045 = meta81045;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter81044.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_81046,meta81045__$1){
var self__ = this;
var _81046__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter81044(self__.path,self__.reduce_fn,self__.late,self__.late_fn,meta81045__$1));
});


com.rpl.specter.t_com$rpl$specter81044.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_81046){
var self__ = this;
var _81046__$1 = this;
return self__.meta81045;
});


com.rpl.specter.t_com$rpl$specter81044.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter81044.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return next_fn.call(null,cljs.core.reduce.call(null,self__.late_fn,com.rpl.specter.compiled_traverse.call(null,self__.late,structure)));
});


com.rpl.specter.t_com$rpl$specter81044.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return next_fn.call(null,cljs.core.reduce.call(null,self__.late_fn,com.rpl.specter.compiled_traverse.call(null,self__.late,structure)));
});

com.rpl.specter.t_com$rpl$specter81044.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"reduce-fn","reduce-fn",-1484020844,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"late-fn","late-fn",268309430,null),new cljs.core.Symbol(null,"meta81045","meta81045",-668623421,null)], null);
});

com.rpl.specter.t_com$rpl$specter81044.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter81044.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter81044";

com.rpl.specter.t_com$rpl$specter81044.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter81044");
});

com.rpl.specter.__GT_t_com$rpl$specter81044 = (function com$rpl$specter$__GT_t_com$rpl$specter81044(path__$1,reduce_fn__$1,late__$1,late_fn__$1,meta81045){
return (new com.rpl.specter.t_com$rpl$specter81044(path__$1,reduce_fn__$1,late__$1,late_fn__$1,meta81045));
});

}

return (new com.rpl.specter.t_com$rpl$specter81044(path,reduce_fn,late,late_fn,null));
}));
var curr_params__33347__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,path),reduce_fn], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__33347__auto__)){
return cljs.core.apply.call(null,builder__33346__auto__,curr_params__33347__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__33346__auto__,curr_params__33347__auto__,null);
}
})),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Keeps the element only if it matches the supplied predicate. This is the
 *        late-bound parameterized version of using a function directly in a path.
 */
com.rpl.specter.pred = com.rpl.specter.impl.pred_STAR_;
com.rpl.specter.pred_EQ_ = (function com$rpl$specter$pred_EQ_(v){
return com.rpl.specter.pred.call(null,(function (p1__81047_SHARP_){
return cljs.core._EQ_.call(null,p1__81047_SHARP_,v);
}));
});
com.rpl.specter.pred_LT_ = (function com$rpl$specter$pred_LT_(v){
return com.rpl.specter.pred.call(null,(function (p1__81048_SHARP_){
return (p1__81048_SHARP_ < v);
}));
});
com.rpl.specter.pred_GT_ = (function com$rpl$specter$pred_GT_(v){
return com.rpl.specter.pred.call(null,(function (p1__81049_SHARP_){
return (p1__81049_SHARP_ > v);
}));
});
com.rpl.specter.pred_LT__EQ_ = (function com$rpl$specter$pred_LT__EQ_(v){
return com.rpl.specter.pred.call(null,(function (p1__81050_SHARP_){
return (p1__81050_SHARP_ <= v);
}));
});
com.rpl.specter.pred_GT__EQ_ = (function com$rpl$specter$pred_GT__EQ_(v){
return com.rpl.specter.pred.call(null,(function (p1__81051_SHARP_){
return (p1__81051_SHARP_ >= v);
}));
});
goog.object.set(com.rpl.specter.protocols.ImplicitNav,"null",true);

goog.object.set(com.rpl.specter.protocols.implicit_nav,"null",(function (this$){
return com.rpl.specter.STAY;
}));

cljs.core.Keyword.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.Keyword.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return com.rpl.specter.navs.keypath_STAR_.call(null,this$__$1);
});
goog.object.set(com.rpl.specter.protocols.ImplicitNav,"function",true);

goog.object.set(com.rpl.specter.protocols.implicit_nav,"function",(function (this$){
return com.rpl.specter.pred.call(null,this$);
}));

cljs.core.PersistentHashSet.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.PersistentHashSet.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return com.rpl.specter.pred.call(null,this$__$1);
});


com.rpl.specter.nil__GT_val_select_STAR_ = (function com$rpl$specter$nil__GT_val_select_STAR_(v,structure,next_fn){
return next_fn.call(null,(((structure == null))?v:structure));
});

com.rpl.specter.nil__GT_val_transform_STAR_ = (function com$rpl$specter$nil__GT_val_transform_STAR_(v,structure,next_fn){
return next_fn.call(null,(((structure == null))?v:structure));
});

/**
 * Navigates to the provided val if the structure is nil. Otherwise it stays
 *        navigated at the structure.
 */
com.rpl.specter.nil__GT_val = com.rpl.specter.impl.direct_nav_obj.call(null,(function (v){
if(typeof com.rpl.specter.t_com$rpl$specter81053 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter81053 = (function (v,meta81054){
this.v = v;
this.meta81054 = meta81054;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter81053.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_81055,meta81054__$1){
var self__ = this;
var _81055__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter81053(self__.v,meta81054__$1));
});


com.rpl.specter.t_com$rpl$specter81053.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_81055){
var self__ = this;
var _81055__$1 = this;
return self__.meta81054;
});


com.rpl.specter.t_com$rpl$specter81053.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter81053.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return next_fn.call(null,(((structure == null))?self__.v:structure));
});


com.rpl.specter.t_com$rpl$specter81053.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return next_fn.call(null,(((structure == null))?self__.v:structure));
});

com.rpl.specter.t_com$rpl$specter81053.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null),new cljs.core.Symbol(null,"meta81054","meta81054",-537015307,null)], null);
});

com.rpl.specter.t_com$rpl$specter81053.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter81053.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter81053";

com.rpl.specter.t_com$rpl$specter81053.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter81053");
});

com.rpl.specter.__GT_t_com$rpl$specter81053 = (function com$rpl$specter$__GT_t_com$rpl$specter81053(v__$1,meta81054){
return (new com.rpl.specter.t_com$rpl$specter81053(v__$1,meta81054));
});

}

return (new com.rpl.specter.t_com$rpl$specter81053(v,null));
}));
/**
 * Navigates to #{} if the value is nil. Otherwise it stays
 *        navigated at the current value.
 */
com.rpl.specter.NIL__GT_SET = com.rpl.specter.nil__GT_val.call(null,cljs.core.PersistentHashSet.EMPTY);
/**
 * Navigates to '() if the value is nil. Otherwise it stays
 *        navigated at the current value.
 */
com.rpl.specter.NIL__GT_LIST = com.rpl.specter.nil__GT_val.call(null,cljs.core.List.EMPTY);
/**
 * Navigates to [] if the value is nil. Otherwise it stays
 *        navigated at the current value.
 */
com.rpl.specter.NIL__GT_VECTOR = com.rpl.specter.nil__GT_val.call(null,cljs.core.PersistentVector.EMPTY);


com.rpl.specter.META_select_STAR_ = (function com$rpl$specter$META_select_STAR_(structure,next_fn){
return next_fn.call(null,cljs.core.meta.call(null,structure));
});

com.rpl.specter.META_transform_STAR_ = (function com$rpl$specter$META_transform_STAR_(structure,next_fn){
return cljs.core.with_meta.call(null,structure,next_fn.call(null,cljs.core.meta.call(null,structure)));
});

/**
 * Navigates to the metadata of the structure, or nil if
 *   the structure has no metadata or may not contain metadata.
 */
com.rpl.specter.META = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter81070 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter81070 = (function (meta81071){
this.meta81071 = meta81071;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter81070.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_81072,meta81071__$1){
var self__ = this;
var _81072__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter81070(meta81071__$1));
});


com.rpl.specter.t_com$rpl$specter81070.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_81072){
var self__ = this;
var _81072__$1 = this;
return self__.meta81071;
});


com.rpl.specter.t_com$rpl$specter81070.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter81070.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return next_fn.call(null,cljs.core.meta.call(null,structure));
});


com.rpl.specter.t_com$rpl$specter81070.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return cljs.core.with_meta.call(null,structure,next_fn.call(null,cljs.core.meta.call(null,structure)));
});

com.rpl.specter.t_com$rpl$specter81070.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta81071","meta81071",-2144284891,null)], null);
});

com.rpl.specter.t_com$rpl$specter81070.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter81070.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter81070";

com.rpl.specter.t_com$rpl$specter81070.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter81070");
});

com.rpl.specter.__GT_t_com$rpl$specter81070 = (function com$rpl$specter$__GT_t_com$rpl$specter81070(meta81071){
return (new com.rpl.specter.t_com$rpl$specter81070(meta81071));
});

}

return (new com.rpl.specter.t_com$rpl$specter81070(null));
})()
;


com.rpl.specter.NAME_select_STAR_ = (function com$rpl$specter$NAME_select_STAR_(structure,next_fn){
return next_fn.call(null,cljs.core.name.call(null,structure));
});

com.rpl.specter.NAME_transform_STAR_ = (function com$rpl$specter$NAME_transform_STAR_(structure,next_fn){
var new_name = next_fn.call(null,cljs.core.name.call(null,structure));
var ns = cljs.core.namespace.call(null,structure);
if((structure instanceof cljs.core.Keyword)){
return cljs.core.keyword.call(null,ns,new_name);
} else {
if((structure instanceof cljs.core.Symbol)){
return cljs.core.symbol.call(null,ns,new_name);
} else {
throw (new java.lang.IllegalArgumentException(com.rpl.specter.impl.smart_str.call(null,"NAME can only be used on symbols or keywords - ",structure)));

}
}
});

/**
 * Navigates to the name portion of the keyword or symbol
 */
com.rpl.specter.NAME = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter81085 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter81085 = (function (meta81086){
this.meta81086 = meta81086;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter81085.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_81087,meta81086__$1){
var self__ = this;
var _81087__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter81085(meta81086__$1));
});


com.rpl.specter.t_com$rpl$specter81085.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_81087){
var self__ = this;
var _81087__$1 = this;
return self__.meta81086;
});


com.rpl.specter.t_com$rpl$specter81085.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter81085.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return next_fn.call(null,cljs.core.name.call(null,structure));
});


com.rpl.specter.t_com$rpl$specter81085.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
var new_name = next_fn.call(null,cljs.core.name.call(null,structure));
var ns = cljs.core.namespace.call(null,structure);
if((structure instanceof cljs.core.Keyword)){
return cljs.core.keyword.call(null,ns,new_name);
} else {
if((structure instanceof cljs.core.Symbol)){
return cljs.core.symbol.call(null,ns,new_name);
} else {
throw (new java.lang.IllegalArgumentException(com.rpl.specter.impl.smart_str.call(null,"NAME can only be used on symbols or keywords - ",structure)));

}
}
});

com.rpl.specter.t_com$rpl$specter81085.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta81086","meta81086",-1602705501,null)], null);
});

com.rpl.specter.t_com$rpl$specter81085.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter81085.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter81085";

com.rpl.specter.t_com$rpl$specter81085.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter81085");
});

com.rpl.specter.__GT_t_com$rpl$specter81085 = (function com$rpl$specter$__GT_t_com$rpl$specter81085(meta81086){
return (new com.rpl.specter.t_com$rpl$specter81085(meta81086));
});

}

return (new com.rpl.specter.t_com$rpl$specter81085(null));
})()
;


com.rpl.specter.NAMESPACE_select_STAR_ = (function com$rpl$specter$NAMESPACE_select_STAR_(structure,next_fn){
return next_fn.call(null,cljs.core.namespace.call(null,structure));
});

com.rpl.specter.NAMESPACE_transform_STAR_ = (function com$rpl$specter$NAMESPACE_transform_STAR_(structure,next_fn){
var name = cljs.core.name.call(null,structure);
var new_ns = next_fn.call(null,cljs.core.namespace.call(null,structure));
if((structure instanceof cljs.core.Keyword)){
return cljs.core.keyword.call(null,new_ns,name);
} else {
if((structure instanceof cljs.core.Symbol)){
return cljs.core.symbol.call(null,new_ns,name);
} else {
throw (new java.lang.IllegalArgumentException(com.rpl.specter.impl.smart_str.call(null,"NAMESPACE can only be used on symbols or keywords - ",structure)));

}
}
});

/**
 * Navigates to the namespace portion of the keyword or symbol
 */
com.rpl.specter.NAMESPACE = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter81104 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter81104 = (function (meta81105){
this.meta81105 = meta81105;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter81104.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_81106,meta81105__$1){
var self__ = this;
var _81106__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter81104(meta81105__$1));
});


com.rpl.specter.t_com$rpl$specter81104.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_81106){
var self__ = this;
var _81106__$1 = this;
return self__.meta81105;
});


com.rpl.specter.t_com$rpl$specter81104.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter81104.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
return next_fn.call(null,cljs.core.namespace.call(null,structure));
});


com.rpl.specter.t_com$rpl$specter81104.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__32582__auto__,vals__32583__auto__,structure,next_fn__32584__auto__){
var self__ = this;
var this__32582__auto____$1 = this;
var next_fn = ((function (this__32582__auto____$1){
return (function (s__32585__auto__){
return next_fn__32584__auto__.call(null,vals__32583__auto__,s__32585__auto__);
});})(this__32582__auto____$1))
;
var name = cljs.core.name.call(null,structure);
var new_ns = next_fn.call(null,cljs.core.namespace.call(null,structure));
if((structure instanceof cljs.core.Keyword)){
return cljs.core.keyword.call(null,new_ns,name);
} else {
if((structure instanceof cljs.core.Symbol)){
return cljs.core.symbol.call(null,new_ns,name);
} else {
throw (new java.lang.IllegalArgumentException(com.rpl.specter.impl.smart_str.call(null,"NAMESPACE can only be used on symbols or keywords - ",structure)));

}
}
});

com.rpl.specter.t_com$rpl$specter81104.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta81105","meta81105",-970013519,null)], null);
});

com.rpl.specter.t_com$rpl$specter81104.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter81104.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter81104";

com.rpl.specter.t_com$rpl$specter81104.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter81104");
});

com.rpl.specter.__GT_t_com$rpl$specter81104 = (function com$rpl$specter$__GT_t_com$rpl$specter81104(meta81105){
return (new com.rpl.specter.t_com$rpl$specter81104(meta81105));
});

}

return (new com.rpl.specter.t_com$rpl$specter81104(null));
})()
;
/**
 * Adds the result of running select with the given path on the
 *        current value to the collected vals.
 */
com.rpl.specter.collect = cljs.core.vary_meta.call(null,com.rpl.specter.wrap_dynamic_nav.call(null,(function() { 
var G__81116__delegate = function (path){
var builder__33346__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,(function (late){
if(typeof com.rpl.specter.t_com$rpl$specter81113 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter81113 = (function (path,late,meta81114){
this.path = path;
this.late = late;
this.meta81114 = meta81114;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter81113.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_81115,meta81114__$1){
var self__ = this;
var _81115__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter81113(self__.path,self__.late,meta81114__$1));
});


com.rpl.specter.t_com$rpl$specter81113.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_81115){
var self__ = this;
var _81115__$1 = this;
return self__.meta81114;
});


com.rpl.specter.t_com$rpl$specter81113.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter81113.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__33343__auto__,vals__33344__auto__,structure,next_fn__33345__auto__){
var self__ = this;
var this__33343__auto____$1 = this;
return next_fn__33345__auto__.call(null,cljs.core.conj.call(null,vals__33344__auto__,com.rpl.specter.compiled_select.call(null,self__.late,structure)),structure);
});


com.rpl.specter.t_com$rpl$specter81113.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__33343__auto__,vals__33344__auto__,structure,next_fn__33345__auto__){
var self__ = this;
var this__33343__auto____$1 = this;
return next_fn__33345__auto__.call(null,cljs.core.conj.call(null,vals__33344__auto__,com.rpl.specter.compiled_select.call(null,self__.late,structure)),structure);
});

com.rpl.specter.t_com$rpl$specter81113.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta81114","meta81114",-345248837,null)], null);
});

com.rpl.specter.t_com$rpl$specter81113.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter81113.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter81113";

com.rpl.specter.t_com$rpl$specter81113.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter81113");
});

com.rpl.specter.__GT_t_com$rpl$specter81113 = (function com$rpl$specter$__GT_t_com$rpl$specter81113(path__$1,late__$1,meta81114){
return (new com.rpl.specter.t_com$rpl$specter81113(path__$1,late__$1,meta81114));
});

}

return (new com.rpl.specter.t_com$rpl$specter81113(path,late,null));
}));
var curr_params__33347__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,path)], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__33347__auto__)){
return cljs.core.apply.call(null,builder__33346__auto__,curr_params__33347__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__33346__auto__,curr_params__33347__auto__,null);
}
};
var G__81116 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__81119__i = 0, G__81119__a = new Array(arguments.length -  0);
while (G__81119__i < G__81119__a.length) {G__81119__a[G__81119__i] = arguments[G__81119__i + 0]; ++G__81119__i;}
  path = new cljs.core.IndexedSeq(G__81119__a,0,null);
} 
return G__81116__delegate.call(this,path);};
G__81116.cljs$lang$maxFixedArity = 0;
G__81116.cljs$lang$applyTo = (function (arglist__81120){
var path = cljs.core.seq(arglist__81120);
return G__81116__delegate(path);
});
G__81116.cljs$core$IFn$_invoke$arity$variadic = G__81116__delegate;
return G__81116;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Adds the result of running select-one with the given path on the
 *        current value to the collected vals.
 */
com.rpl.specter.collect_one = cljs.core.vary_meta.call(null,com.rpl.specter.wrap_dynamic_nav.call(null,(function() { 
var G__81124__delegate = function (path){
var builder__33346__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,(function (late){
if(typeof com.rpl.specter.t_com$rpl$specter81121 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter81121 = (function (path,late,meta81122){
this.path = path;
this.late = late;
this.meta81122 = meta81122;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter81121.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_81123,meta81122__$1){
var self__ = this;
var _81123__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter81121(self__.path,self__.late,meta81122__$1));
});


com.rpl.specter.t_com$rpl$specter81121.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_81123){
var self__ = this;
var _81123__$1 = this;
return self__.meta81122;
});


com.rpl.specter.t_com$rpl$specter81121.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter81121.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__33343__auto__,vals__33344__auto__,structure,next_fn__33345__auto__){
var self__ = this;
var this__33343__auto____$1 = this;
return next_fn__33345__auto__.call(null,cljs.core.conj.call(null,vals__33344__auto__,com.rpl.specter.compiled_select_one.call(null,self__.late,structure)),structure);
});


com.rpl.specter.t_com$rpl$specter81121.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__33343__auto__,vals__33344__auto__,structure,next_fn__33345__auto__){
var self__ = this;
var this__33343__auto____$1 = this;
return next_fn__33345__auto__.call(null,cljs.core.conj.call(null,vals__33344__auto__,com.rpl.specter.compiled_select_one.call(null,self__.late,structure)),structure);
});

com.rpl.specter.t_com$rpl$specter81121.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta81122","meta81122",-2057363008,null)], null);
});

com.rpl.specter.t_com$rpl$specter81121.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter81121.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter81121";

com.rpl.specter.t_com$rpl$specter81121.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter81121");
});

com.rpl.specter.__GT_t_com$rpl$specter81121 = (function com$rpl$specter$__GT_t_com$rpl$specter81121(path__$1,late__$1,meta81122){
return (new com.rpl.specter.t_com$rpl$specter81121(path__$1,late__$1,meta81122));
});

}

return (new com.rpl.specter.t_com$rpl$specter81121(path,late,null));
}));
var curr_params__33347__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,path)], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__33347__auto__)){
return cljs.core.apply.call(null,builder__33346__auto__,curr_params__33347__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__33346__auto__,curr_params__33347__auto__,null);
}
};
var G__81124 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__81126__i = 0, G__81126__a = new Array(arguments.length -  0);
while (G__81126__i < G__81126__a.length) {G__81126__a[G__81126__i] = arguments[G__81126__i + 0]; ++G__81126__i;}
  path = new cljs.core.IndexedSeq(G__81126__a,0,null);
} 
return G__81124__delegate.call(this,path);};
G__81124.cljs$lang$maxFixedArity = 0;
G__81124.cljs$lang$applyTo = (function (arglist__81127){
var path = cljs.core.seq(arglist__81127);
return G__81124__delegate(path);
});
G__81124.cljs$core$IFn$_invoke$arity$variadic = G__81124__delegate;
return G__81124;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Adds an external value to the collected vals. Useful when additional arguments
 *   are required to the transform function that would otherwise require partial
 *   application or a wrapper function.
 * 
 *   e.g., incrementing val at path [:a :b] by 3:
 *   (transform [:a :b (putval 3)] + some-map)
 */
com.rpl.specter.putval = com.rpl.specter.impl.direct_nav_obj.call(null,(function (val){
if(typeof com.rpl.specter.t_com$rpl$specter81129 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter81129 = (function (val,meta81130){
this.val = val;
this.meta81130 = meta81130;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter81129.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_81131,meta81130__$1){
var self__ = this;
var _81131__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter81129(self__.val,meta81130__$1));
});


com.rpl.specter.t_com$rpl$specter81129.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_81131){
var self__ = this;
var _81131__$1 = this;
return self__.meta81130;
});


com.rpl.specter.t_com$rpl$specter81129.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter81129.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__33343__auto__,vals__33344__auto__,structure,next_fn__33345__auto__){
var self__ = this;
var this__33343__auto____$1 = this;
return next_fn__33345__auto__.call(null,cljs.core.conj.call(null,vals__33344__auto__,self__.val),structure);
});


com.rpl.specter.t_com$rpl$specter81129.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__33343__auto__,vals__33344__auto__,structure,next_fn__33345__auto__){
var self__ = this;
var this__33343__auto____$1 = this;
return next_fn__33345__auto__.call(null,cljs.core.conj.call(null,vals__33344__auto__,self__.val),structure);
});

com.rpl.specter.t_com$rpl$specter81129.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.Symbol(null,"meta81130","meta81130",-2062599746,null)], null);
});

com.rpl.specter.t_com$rpl$specter81129.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter81129.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter81129";

com.rpl.specter.t_com$rpl$specter81129.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter81129");
});

com.rpl.specter.__GT_t_com$rpl$specter81129 = (function com$rpl$specter$__GT_t_com$rpl$specter81129(val__$1,meta81130){
return (new com.rpl.specter.t_com$rpl$specter81129(val__$1,meta81130));
});

}

return (new com.rpl.specter.t_com$rpl$specter81129(val,null));
}));
/**
 * Continues navigating on the given path with the collected vals reset to []. Once
 *   navigation leaves the scope of with-fresh-collected, the collected vals revert
 *   to what they were before.
 */
com.rpl.specter.with_fresh_collected = cljs.core.vary_meta.call(null,com.rpl.specter.wrap_dynamic_nav.call(null,(function() { 
var G__81218__delegate = function (path){
var builder__33346__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,(function (late){
if(typeof com.rpl.specter.t_com$rpl$specter81149 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter81149 = (function (path,late,meta81150){
this.path = path;
this.late = late;
this.meta81150 = meta81150;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter81149.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_81151,meta81150__$1){
var self__ = this;
var _81151__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter81149(self__.path,self__.late,meta81150__$1));
});


com.rpl.specter.t_com$rpl$specter81149.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_81151){
var self__ = this;
var _81151__$1 = this;
return self__.meta81150;
});


com.rpl.specter.t_com$rpl$specter81149.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter81149.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.protocols.select_STAR_.call(null,self__.late,cljs.core.PersistentVector.EMPTY,structure,((function (this$__$1){
return (function (_,structure__$1){
return next_fn.call(null,vals,structure__$1);
});})(this$__$1))
);
});


com.rpl.specter.t_com$rpl$specter81149.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.protocols.transform_STAR_.call(null,self__.late,cljs.core.PersistentVector.EMPTY,structure,((function (this$__$1){
return (function (_,structure__$1){
return next_fn.call(null,vals,structure__$1);
});})(this$__$1))
);
});

com.rpl.specter.t_com$rpl$specter81149.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta81150","meta81150",1081091698,null)], null);
});

com.rpl.specter.t_com$rpl$specter81149.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter81149.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter81149";

com.rpl.specter.t_com$rpl$specter81149.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter81149");
});

com.rpl.specter.__GT_t_com$rpl$specter81149 = (function com$rpl$specter$__GT_t_com$rpl$specter81149(path__$1,late__$1,meta81150){
return (new com.rpl.specter.t_com$rpl$specter81149(path__$1,late__$1,meta81150));
});

}

return (new com.rpl.specter.t_com$rpl$specter81149(path,late,null));
}));
var curr_params__33347__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,path)], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__33347__auto__)){
return cljs.core.apply.call(null,builder__33346__auto__,curr_params__33347__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__33346__auto__,curr_params__33347__auto__,null);
}
};
var G__81218 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__81239__i = 0, G__81239__a = new Array(arguments.length -  0);
while (G__81239__i < G__81239__a.length) {G__81239__a[G__81239__i] = arguments[G__81239__i + 0]; ++G__81239__i;}
  path = new cljs.core.IndexedSeq(G__81239__a,0,null);
} 
return G__81218__delegate.call(this,path);};
G__81218.cljs$lang$maxFixedArity = 0;
G__81218.cljs$lang$applyTo = (function (arglist__81242){
var path = cljs.core.seq(arglist__81242);
return G__81218__delegate(path);
});
G__81218.cljs$core$IFn$_invoke$arity$variadic = G__81218__delegate;
return G__81218;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Drops all collected values for subsequent navigation.
 */
com.rpl.specter.DISPENSE = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter81244 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter81244 = (function (meta81245){
this.meta81245 = meta81245;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter81244.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_81246,meta81245__$1){
var self__ = this;
var _81246__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter81244(meta81245__$1));
});


com.rpl.specter.t_com$rpl$specter81244.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_81246){
var self__ = this;
var _81246__$1 = this;
return self__.meta81245;
});


com.rpl.specter.t_com$rpl$specter81244.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter81244.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return next_fn.call(null,cljs.core.PersistentVector.EMPTY,structure);
});


com.rpl.specter.t_com$rpl$specter81244.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return next_fn.call(null,cljs.core.PersistentVector.EMPTY,structure);
});

com.rpl.specter.t_com$rpl$specter81244.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta81245","meta81245",1869947599,null)], null);
});

com.rpl.specter.t_com$rpl$specter81244.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter81244.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter81244";

com.rpl.specter.t_com$rpl$specter81244.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter81244");
});

com.rpl.specter.__GT_t_com$rpl$specter81244 = (function com$rpl$specter$__GT_t_com$rpl$specter81244(meta81245){
return (new com.rpl.specter.t_com$rpl$specter81244(meta81245));
});

}

return (new com.rpl.specter.t_com$rpl$specter81244(null));
})()
;
/**
 * Like cond-path, but with if semantics.
 */
com.rpl.specter.if_path = cljs.core.vary_meta.call(null,com.rpl.specter.wrap_dynamic_nav.call(null,(function() {
var G__81273 = null;
var G__81273__2 = (function (cond_p,then_path){
return com.rpl.specter.if_path.call(null,cond_p,then_path,com.rpl.specter.STOP);
});
var G__81273__3 = (function (cond_p,then_path,else_path){
var temp__4655__auto__ = com.rpl.specter.navs.extract_basic_filter_fn.call(null,cond_p);
if(cljs.core.truth_(temp__4655__auto__)){
var afn = temp__4655__auto__;
var builder__33346__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,((function (afn,temp__4655__auto__){
return (function (late_then,late_else){
if(typeof com.rpl.specter.t_com$rpl$specter81267 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter81267 = (function (cond_p,then_path,else_path,temp__4655__auto__,afn,late_then,late_else,meta81268){
this.cond_p = cond_p;
this.then_path = then_path;
this.else_path = else_path;
this.temp__4655__auto__ = temp__4655__auto__;
this.afn = afn;
this.late_then = late_then;
this.late_else = late_else;
this.meta81268 = meta81268;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter81267.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (afn,temp__4655__auto__){
return (function (_81269,meta81268__$1){
var self__ = this;
var _81269__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter81267(self__.cond_p,self__.then_path,self__.else_path,self__.temp__4655__auto__,self__.afn,self__.late_then,self__.late_else,meta81268__$1));
});})(afn,temp__4655__auto__))
;


com.rpl.specter.t_com$rpl$specter81267.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (afn,temp__4655__auto__){
return (function (_81269){
var self__ = this;
var _81269__$1 = this;
return self__.meta81268;
});})(afn,temp__4655__auto__))
;


com.rpl.specter.t_com$rpl$specter81267.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter81267.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = ((function (afn,temp__4655__auto__){
return (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_select.call(null,vals,structure,next_fn,self__.afn,self__.late_then,self__.late_else);
});})(afn,temp__4655__auto__))
;


com.rpl.specter.t_com$rpl$specter81267.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = ((function (afn,temp__4655__auto__){
return (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_transform.call(null,vals,structure,next_fn,self__.afn,self__.late_then,self__.late_else);
});})(afn,temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter81267.getBasis = ((function (afn,temp__4655__auto__){
return (function (){
return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cond-p","cond-p",695068009,null),new cljs.core.Symbol(null,"then-path","then-path",1949536092,null),new cljs.core.Symbol(null,"else-path","else-path",-2100209576,null),new cljs.core.Symbol(null,"temp__4655__auto__","temp__4655__auto__",-1826162292,null),new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"late-then","late-then",1623904294,null),new cljs.core.Symbol(null,"late-else","late-else",1462724600,null),new cljs.core.Symbol(null,"meta81268","meta81268",-1203605968,null)], null);
});})(afn,temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter81267.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter81267.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter81267";

com.rpl.specter.t_com$rpl$specter81267.cljs$lang$ctorPrWriter = ((function (afn,temp__4655__auto__){
return (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter81267");
});})(afn,temp__4655__auto__))
;

com.rpl.specter.__GT_t_com$rpl$specter81267 = ((function (afn,temp__4655__auto__){
return (function com$rpl$specter$__GT_t_com$rpl$specter81267(cond_p__$1,then_path__$1,else_path__$1,temp__4655__auto____$1,afn__$1,late_then__$1,late_else__$1,meta81268){
return (new com.rpl.specter.t_com$rpl$specter81267(cond_p__$1,then_path__$1,else_path__$1,temp__4655__auto____$1,afn__$1,late_then__$1,late_else__$1,meta81268));
});})(afn,temp__4655__auto__))
;

}

return (new com.rpl.specter.t_com$rpl$specter81267(cond_p,then_path,else_path,temp__4655__auto__,afn,late_then,late_else,null));
});})(afn,temp__4655__auto__))
);
var curr_params__33347__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,then_path),com.rpl.specter.late_path.call(null,else_path)], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__33347__auto__)){
return cljs.core.apply.call(null,builder__33346__auto__,curr_params__33347__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__33346__auto__,curr_params__33347__auto__,null);
}
} else {
var builder__33346__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,((function (temp__4655__auto__){
return (function (late_cond,late_then,late_else){
if(typeof com.rpl.specter.t_com$rpl$specter81270 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter81270 = (function (cond_p,then_path,else_path,temp__4655__auto__,late_cond,late_then,late_else,meta81271){
this.cond_p = cond_p;
this.then_path = then_path;
this.else_path = else_path;
this.temp__4655__auto__ = temp__4655__auto__;
this.late_cond = late_cond;
this.late_then = late_then;
this.late_else = late_else;
this.meta81271 = meta81271;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter81270.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (temp__4655__auto__){
return (function (_81272,meta81271__$1){
var self__ = this;
var _81272__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter81270(self__.cond_p,self__.then_path,self__.else_path,self__.temp__4655__auto__,self__.late_cond,self__.late_then,self__.late_else,meta81271__$1));
});})(temp__4655__auto__))
;


com.rpl.specter.t_com$rpl$specter81270.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (temp__4655__auto__){
return (function (_81272){
var self__ = this;
var _81272__$1 = this;
return self__.meta81271;
});})(temp__4655__auto__))
;


com.rpl.specter.t_com$rpl$specter81270.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter81270.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = ((function (temp__4655__auto__){
return (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_select.call(null,vals,structure,next_fn,((function (this$__$1,temp__4655__auto__){
return (function (p1__81265_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_.call(null,self__.late_cond,vals,p1__81265_SHARP_);
});})(this$__$1,temp__4655__auto__))
,self__.late_then,self__.late_else);
});})(temp__4655__auto__))
;


com.rpl.specter.t_com$rpl$specter81270.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = ((function (temp__4655__auto__){
return (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_transform.call(null,vals,structure,next_fn,((function (this$__$1,temp__4655__auto__){
return (function (p1__81266_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_.call(null,self__.late_cond,vals,p1__81266_SHARP_);
});})(this$__$1,temp__4655__auto__))
,self__.late_then,self__.late_else);
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter81270.getBasis = ((function (temp__4655__auto__){
return (function (){
return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cond-p","cond-p",695068009,null),new cljs.core.Symbol(null,"then-path","then-path",1949536092,null),new cljs.core.Symbol(null,"else-path","else-path",-2100209576,null),new cljs.core.Symbol(null,"temp__4655__auto__","temp__4655__auto__",-1826162292,null),new cljs.core.Symbol(null,"late-cond","late-cond",1031862828,null),new cljs.core.Symbol(null,"late-then","late-then",1623904294,null),new cljs.core.Symbol(null,"late-else","late-else",1462724600,null),new cljs.core.Symbol(null,"meta81271","meta81271",1715243814,null)], null);
});})(temp__4655__auto__))
;

com.rpl.specter.t_com$rpl$specter81270.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter81270.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter81270";

com.rpl.specter.t_com$rpl$specter81270.cljs$lang$ctorPrWriter = ((function (temp__4655__auto__){
return (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter81270");
});})(temp__4655__auto__))
;

com.rpl.specter.__GT_t_com$rpl$specter81270 = ((function (temp__4655__auto__){
return (function com$rpl$specter$__GT_t_com$rpl$specter81270(cond_p__$1,then_path__$1,else_path__$1,temp__4655__auto____$1,late_cond__$1,late_then__$1,late_else__$1,meta81271){
return (new com.rpl.specter.t_com$rpl$specter81270(cond_p__$1,then_path__$1,else_path__$1,temp__4655__auto____$1,late_cond__$1,late_then__$1,late_else__$1,meta81271));
});})(temp__4655__auto__))
;

}

return (new com.rpl.specter.t_com$rpl$specter81270(cond_p,then_path,else_path,temp__4655__auto__,late_cond,late_then,late_else,null));
});})(temp__4655__auto__))
);
var curr_params__33347__auto__ = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,cond_p),com.rpl.specter.late_path.call(null,then_path),com.rpl.specter.late_path.call(null,else_path)], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__33347__auto__)){
return cljs.core.apply.call(null,builder__33346__auto__,curr_params__33347__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__33346__auto__,curr_params__33347__auto__,null);
}
}
});
G__81273 = function(cond_p,then_path,else_path){
switch(arguments.length){
case 2:
return G__81273__2.call(this,cond_p,then_path);
case 3:
return G__81273__3.call(this,cond_p,then_path,else_path);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__81273.cljs$core$IFn$_invoke$arity$2 = G__81273__2;
G__81273.cljs$core$IFn$_invoke$arity$3 = G__81273__3;
return G__81273;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Takes in alternating cond-path path cond-path path...
 * Tests the structure if selecting with cond-path returns anything.
 * If so, it uses the following path for this portion of the navigation.
 * Otherwise, it tries the next cond-path. If nothing matches, then the structure
 * is not selected.
 * 
 * The input paths may be parameterized, in which case the result of cond-path
 * will be parameterized in the order of which the parameterized navigators
 * were declared.
 */
com.rpl.specter.cond_path = cljs.core.vary_meta.call(null,com.rpl.specter.wrap_dynamic_nav.call(null,(function() { 
var G__81297__delegate = function (conds){
var pairs = cljs.core.reverse.call(null,cljs.core.partition.call(null,(2),conds));
return cljs.core.reduce.call(null,((function (pairs){
return (function (p,p__81292){
var vec__81294 = p__81292;
var tester = cljs.core.nth.call(null,vec__81294,(0),null);
var apath = cljs.core.nth.call(null,vec__81294,(1),null);
return com.rpl.specter.if_path.call(null,tester,apath,p);
});})(pairs))
,com.rpl.specter.STOP,pairs);
};
var G__81297 = function (var_args){
var conds = null;
if (arguments.length > 0) {
var G__81299__i = 0, G__81299__a = new Array(arguments.length -  0);
while (G__81299__i < G__81299__a.length) {G__81299__a[G__81299__i] = arguments[G__81299__i + 0]; ++G__81299__i;}
  conds = new cljs.core.IndexedSeq(G__81299__a,0,null);
} 
return G__81297__delegate.call(this,conds);};
G__81297.cljs$lang$maxFixedArity = 0;
G__81297.cljs$lang$applyTo = (function (arglist__81301){
var conds = cljs.core.seq(arglist__81301);
return G__81297__delegate(conds);
});
G__81297.cljs$core$IFn$_invoke$arity$variadic = G__81297__delegate;
return G__81297;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * A path that branches on multiple paths. For updates,
 * applies updates to the paths in order.
 */
com.rpl.specter.multi_path = cljs.core.vary_meta.call(null,com.rpl.specter.wrap_dynamic_nav.call(null,(function() {
var G__81313 = null;
var G__81313__0 = (function (){
return com.rpl.specter.STAY;
});
var G__81313__1 = (function (path){
return path;
});
var G__81313__2 = (function (path1,path2){
var builder__33346__auto__ = com.rpl.specter.impl.direct_nav_obj.call(null,(function (late1,late2){
if(typeof com.rpl.specter.t_com$rpl$specter81303 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter81303 = (function (path1,path2,late1,late2,meta81304){
this.path1 = path1;
this.path2 = path2;
this.late1 = late1;
this.late2 = late2;
this.meta81304 = meta81304;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});

com.rpl.specter.t_com$rpl$specter81303.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_81305,meta81304__$1){
var self__ = this;
var _81305__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter81303(self__.path1,self__.path2,self__.late1,self__.late2,meta81304__$1));
});


com.rpl.specter.t_com$rpl$specter81303.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_81305){
var self__ = this;
var _81305__$1 = this;
return self__.meta81304;
});


com.rpl.specter.t_com$rpl$specter81303.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;


com.rpl.specter.t_com$rpl$specter81303.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var res1 = com.rpl.specter.protocols.select_STAR_.call(null,self__.late1,vals,structure,next_fn);
if(cljs.core.reduced_QMARK_.call(null,res1)){
return res1;
} else {
var res2 = com.rpl.specter.protocols.select_STAR_.call(null,self__.late2,vals,structure,next_fn);
if((com.rpl.specter.NONE === res1)){
return res2;
} else {
return res1;
}
}
});


com.rpl.specter.t_com$rpl$specter81303.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var s1 = com.rpl.specter.protocols.transform_STAR_.call(null,self__.late1,vals,structure,next_fn);
return com.rpl.specter.protocols.transform_STAR_.call(null,self__.late2,vals,s1,next_fn);
});

com.rpl.specter.t_com$rpl$specter81303.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path1","path1",-2002517142,null),new cljs.core.Symbol(null,"path2","path2",-1937913521,null),new cljs.core.Symbol(null,"late1","late1",-1413016621,null),new cljs.core.Symbol(null,"late2","late2",-681717994,null),new cljs.core.Symbol(null,"meta81304","meta81304",-2104427098,null)], null);
});

com.rpl.specter.t_com$rpl$specter81303.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter81303.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter81303";

com.rpl.specter.t_com$rpl$specter81303.cljs$lang$ctorPrWriter = (function (this__28766__auto__,writer__28767__auto__,opt__28768__auto__){
return cljs.core._write.call(null,writer__28767__auto__,"com.rpl.specter/t_com$rpl$specter81303");
});

com.rpl.specter.__GT_t_com$rpl$specter81303 = (function com$rpl$specter$__GT_t_com$rpl$specter81303(path1__$1,path2__$1,late1__$1,late2__$1,meta81304){
return (new com.rpl.specter.t_com$rpl$specter81303(path1__$1,path2__$1,late1__$1,late2__$1,meta81304));
});

}

return (new com.rpl.specter.t_com$rpl$specter81303(path1,path2,late1,late2,null));
}));
var curr_params__33347__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.late_path.call(null,path1),com.rpl.specter.late_path.call(null,path2)], null);
if(cljs.core.every_QMARK_.call(null,cljs.core.complement.call(null,com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__33347__auto__)){
return cljs.core.apply.call(null,builder__33346__auto__,curr_params__33347__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction.call(null,builder__33346__auto__,curr_params__33347__auto__,null);
}
});
var G__81313__3 = (function() { 
var G__81320__delegate = function (path1,path2,paths){
return cljs.core.reduce.call(null,com.rpl.specter.multi_path,com.rpl.specter.multi_path.call(null,path1,path2),paths);
};
var G__81320 = function (path1,path2,var_args){
var paths = null;
if (arguments.length > 2) {
var G__81321__i = 0, G__81321__a = new Array(arguments.length -  2);
while (G__81321__i < G__81321__a.length) {G__81321__a[G__81321__i] = arguments[G__81321__i + 2]; ++G__81321__i;}
  paths = new cljs.core.IndexedSeq(G__81321__a,0,null);
} 
return G__81320__delegate.call(this,path1,path2,paths);};
G__81320.cljs$lang$maxFixedArity = 2;
G__81320.cljs$lang$applyTo = (function (arglist__81322){
var path1 = cljs.core.first(arglist__81322);
arglist__81322 = cljs.core.next(arglist__81322);
var path2 = cljs.core.first(arglist__81322);
var paths = cljs.core.rest(arglist__81322);
return G__81320__delegate(path1,path2,paths);
});
G__81320.cljs$core$IFn$_invoke$arity$variadic = G__81320__delegate;
return G__81320;
})()
;
G__81313 = function(path1,path2,var_args){
var paths = var_args;
switch(arguments.length){
case 0:
return G__81313__0.call(this);
case 1:
return G__81313__1.call(this,path1);
case 2:
return G__81313__2.call(this,path1,path2);
default:
var G__81323 = null;
if (arguments.length > 2) {
var G__81324__i = 0, G__81324__a = new Array(arguments.length -  2);
while (G__81324__i < G__81324__a.length) {G__81324__a[G__81324__i] = arguments[G__81324__i + 2]; ++G__81324__i;}
G__81323 = new cljs.core.IndexedSeq(G__81324__a,0,null);
}
return G__81313__3.cljs$core$IFn$_invoke$arity$variadic(path1,path2, G__81323);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__81313.cljs$lang$maxFixedArity = 2;
G__81313.cljs$lang$applyTo = G__81313__3.cljs$lang$applyTo;
G__81313.cljs$core$IFn$_invoke$arity$0 = G__81313__0;
G__81313.cljs$core$IFn$_invoke$arity$1 = G__81313__1;
G__81313.cljs$core$IFn$_invoke$arity$2 = G__81313__2;
G__81313.cljs$core$IFn$_invoke$arity$variadic = G__81313__3.cljs$core$IFn$_invoke$arity$variadic;
return G__81313;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to the current element and then navigates via the provided path.
 * This can be used to implement pre-order traversal.
 */
com.rpl.specter.stay_then_continue = cljs.core.vary_meta.call(null,com.rpl.specter.wrap_dynamic_nav.call(null,(function() { 
var G__81327__delegate = function (path){
return com.rpl.specter.multi_path.call(null,com.rpl.specter.STAY,path);
};
var G__81327 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__81328__i = 0, G__81328__a = new Array(arguments.length -  0);
while (G__81328__i < G__81328__a.length) {G__81328__a[G__81328__i] = arguments[G__81328__i + 0]; ++G__81328__i;}
  path = new cljs.core.IndexedSeq(G__81328__a,0,null);
} 
return G__81327__delegate.call(this,path);};
G__81327.cljs$lang$maxFixedArity = 0;
G__81327.cljs$lang$applyTo = (function (arglist__81329){
var path = cljs.core.seq(arglist__81329);
return G__81327__delegate(path);
});
G__81327.cljs$core$IFn$_invoke$arity$variadic = G__81327__delegate;
return G__81327;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to the provided path and then to the current element. This can be used
 * to implement post-order traversal.
 */
com.rpl.specter.continue_then_stay = cljs.core.vary_meta.call(null,com.rpl.specter.wrap_dynamic_nav.call(null,(function() { 
var G__81331__delegate = function (path){
return com.rpl.specter.multi_path.call(null,path,com.rpl.specter.STAY);
};
var G__81331 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__81332__i = 0, G__81332__a = new Array(arguments.length -  0);
while (G__81332__i < G__81332__a.length) {G__81332__a[G__81332__i] = arguments[G__81332__i + 0]; ++G__81332__i;}
  path = new cljs.core.IndexedSeq(G__81332__a,0,null);
} 
return G__81331__delegate.call(this,path);};
G__81331.cljs$lang$maxFixedArity = 0;
G__81331.cljs$lang$applyTo = (function (arglist__81333){
var path = cljs.core.seq(arglist__81333);
return G__81331__delegate(path);
});
G__81331.cljs$core$IFn$_invoke$arity$variadic = G__81331__delegate;
return G__81331;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigate the data structure until reaching
 *        a value for which `afn` returns truthy. Has
 *        same semantics as clojure.walk.
 */
com.rpl.specter.walker = com.rpl.specter.impl.direct_nav_obj.call(null,(function (afn){
var p = com.rpl.specter.impl.local_declarepath.call(null);
com.rpl.specter.impl.providepath_STAR_.call(null,p,(function (){var info__33353__auto__ = com.rpl.specter.pathcache81334;
var info__33353__auto____$1 = (((info__33353__auto__ == null))?(function (){var info81335 = com.rpl.specter.impl.magic_precompilation.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation.call(null,com.rpl.specter.impl.__GT_VarUse.call(null,com.rpl.specter.cond_path,new cljs.core.Var(function(){return com.rpl.specter.cond_path;},new cljs.core.Symbol("com.rpl.specter","cond-path","com.rpl.specter/cond-path",97137882,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),"resources/public/js/compiled/devcards_out/com/rpl/specter.cljc",25,1,1237,1237,cljs.core.List.EMPTY,"Takes in alternating cond-path path cond-path path...\n   Tests the structure if selecting with cond-path returns anything.\n   If so, it uses the following path for this portion of the navigation.\n   Otherwise, it tries the next cond-path. If nothing matches, then the structure\n   is not selected.\n\n   The input paths may be parameterized, in which case the result of cond-path\n   will be parameterized in the order of which the parameterized navigators\n   were declared.",(cljs.core.truth_(com.rpl.specter.cond_path)?com.rpl.specter.cond_path.cljs$lang$test:null)])),new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null)),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation.call(null,com.rpl.specter.impl.__GT_VarUse.call(null,com.rpl.specter.pred,new cljs.core.Var(function(){return com.rpl.specter.pred;},new cljs.core.Symbol("com.rpl.specter","pred","com.rpl.specter/pred",1192968523,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"direct-nav","direct-nav",-2100776046),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null),"resources/public/js/compiled/devcards_out/com/rpl/specter.cljc",7,1,true,1042,1046,cljs.core.List.EMPTY,"Keeps the element only if it matches the supplied predicate. This is the\n          late-bound parameterized version of using a function directly in a path.",(cljs.core.truth_(com.rpl.specter.pred)?com.rpl.specter.pred.cljs$lang$test:null)])),new cljs.core.Symbol(null,"pred","pred",-727012372,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym.call(null,afn,new cljs.core.Symbol(null,"afn","afn",216963467,null))], null),cljs.core.list(new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null))),com.rpl.specter.impl.__GT_VarUse.call(null,com.rpl.specter.STAY,new cljs.core.Var(function(){return com.rpl.specter.STAY;},new cljs.core.Symbol("com.rpl.specter","STAY","com.rpl.specter/STAY",-176499375,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),"resources/public/js/compiled/devcards_out/com/rpl/specter.cljc",7,1,626,628,cljs.core.List.EMPTY,"Stays navigated at the current point. Essentially a no-op navigator.",(cljs.core.truth_(com.rpl.specter.STAY)?com.rpl.specter.STAY.cljs$lang$test:null)])),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null)),com.rpl.specter.impl.__GT_VarUse.call(null,cljs.core.coll_QMARK_,new cljs.core.Var(function(){return cljs.core.coll_QMARK_;},new cljs.core.Symbol("cljs.core","coll?","cljs.core/coll?",1208130522,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),"cljs/core.cljs",21,1,2086,2086,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),"Returns true if x satisfies ICollection",((cljs.core.coll_QMARK_)?cljs.core.coll_QMARK_.cljs$lang$test:null)])),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_VarUse.call(null,com.rpl.specter.ALL,new cljs.core.Var(function(){return com.rpl.specter.ALL;},new cljs.core.Symbol("com.rpl.specter","ALL","com.rpl.specter/ALL",-1409005960,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),"resources/public/js/compiled/devcards_out/com/rpl/specter.cljc",6,1,650,653,cljs.core.List.EMPTY,"Navigate to every element of the collection. For maps navigates to\n          a vector of `[key value]`.",(cljs.core.truth_(com.rpl.specter.ALL)?com.rpl.specter.ALL.cljs$lang$test:null)])),new cljs.core.Symbol(null,"ALL","ALL",866837407,null)),com.rpl.specter.impl.__GT_LocalSym.call(null,p,new cljs.core.Symbol(null,"p","p",1791580836,null))], null)], null),cljs.core.list(new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),cljs.core.list(new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null)),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL","ALL",866837407,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null),new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL","ALL",866837407,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null));
com.rpl.specter.pathcache81334 = info81335;

return info81335;
})():info__33353__auto__);
var precompiled81336 = com.rpl.specter.impl.cached_path_info_precompiled.call(null,info__33353__auto____$1);
var dynamic_QMARK___33354__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_.call(null,info__33353__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___33354__auto__)){
return precompiled81336.call(null,new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.cond_path,com.rpl.specter.pred,afn,com.rpl.specter.STAY,cljs.core.coll_QMARK_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.ALL,p], null),com.rpl.specter.ALL,p], null));
} else {
return precompiled81336;
}
})());

return p;
}));
/**
 * Like `walker` but maintains metadata of any forms traversed.
 */
com.rpl.specter.codewalker = com.rpl.specter.impl.direct_nav_obj.call(null,(function (afn){
var p = com.rpl.specter.impl.local_declarepath.call(null);
com.rpl.specter.impl.providepath_STAR_.call(null,p,(function (){var info__33353__auto__ = com.rpl.specter.pathcache81398;
var info__33353__auto____$1 = (((info__33353__auto__ == null))?(function (){var info81399 = com.rpl.specter.impl.magic_precompilation.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation.call(null,com.rpl.specter.impl.__GT_VarUse.call(null,com.rpl.specter.cond_path,new cljs.core.Var(function(){return com.rpl.specter.cond_path;},new cljs.core.Symbol("com.rpl.specter","cond-path","com.rpl.specter/cond-path",97137882,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),"resources/public/js/compiled/devcards_out/com/rpl/specter.cljc",25,1,1237,1237,cljs.core.List.EMPTY,"Takes in alternating cond-path path cond-path path...\n   Tests the structure if selecting with cond-path returns anything.\n   If so, it uses the following path for this portion of the navigation.\n   Otherwise, it tries the next cond-path. If nothing matches, then the structure\n   is not selected.\n\n   The input paths may be parameterized, in which case the result of cond-path\n   will be parameterized in the order of which the parameterized navigators\n   were declared.",(cljs.core.truth_(com.rpl.specter.cond_path)?com.rpl.specter.cond_path.cljs$lang$test:null)])),new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null)),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation.call(null,com.rpl.specter.impl.__GT_VarUse.call(null,com.rpl.specter.pred,new cljs.core.Var(function(){return com.rpl.specter.pred;},new cljs.core.Symbol("com.rpl.specter","pred","com.rpl.specter/pred",1192968523,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"direct-nav","direct-nav",-2100776046),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null),"resources/public/js/compiled/devcards_out/com/rpl/specter.cljc",7,1,true,1042,1046,cljs.core.List.EMPTY,"Keeps the element only if it matches the supplied predicate. This is the\n          late-bound parameterized version of using a function directly in a path.",(cljs.core.truth_(com.rpl.specter.pred)?com.rpl.specter.pred.cljs$lang$test:null)])),new cljs.core.Symbol(null,"pred","pred",-727012372,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym.call(null,afn,new cljs.core.Symbol(null,"afn","afn",216963467,null))], null),cljs.core.list(new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null))),com.rpl.specter.impl.__GT_VarUse.call(null,com.rpl.specter.STAY,new cljs.core.Var(function(){return com.rpl.specter.STAY;},new cljs.core.Symbol("com.rpl.specter","STAY","com.rpl.specter/STAY",-176499375,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),"resources/public/js/compiled/devcards_out/com/rpl/specter.cljc",7,1,626,628,cljs.core.List.EMPTY,"Stays navigated at the current point. Essentially a no-op navigator.",(cljs.core.truth_(com.rpl.specter.STAY)?com.rpl.specter.STAY.cljs$lang$test:null)])),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null)),com.rpl.specter.impl.__GT_VarUse.call(null,cljs.core.coll_QMARK_,new cljs.core.Var(function(){return cljs.core.coll_QMARK_;},new cljs.core.Symbol("cljs.core","coll?","cljs.core/coll?",1208130522,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),"cljs/core.cljs",21,1,2086,2086,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),"Returns true if x satisfies ICollection",((cljs.core.coll_QMARK_)?cljs.core.coll_QMARK_.cljs$lang$test:null)])),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_VarUse.call(null,com.rpl.specter.ALL_WITH_META,new cljs.core.Var(function(){return com.rpl.specter.ALL_WITH_META;},new cljs.core.Symbol("com.rpl.specter","ALL-WITH-META","com.rpl.specter/ALL-WITH-META",-1161868995,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null),"resources/public/js/compiled/devcards_out/com/rpl/specter.cljc",16,1,660,662,cljs.core.List.EMPTY,"Same as ALL, except maintains metadata on the structure.",(cljs.core.truth_(com.rpl.specter.ALL_WITH_META)?com.rpl.specter.ALL_WITH_META.cljs$lang$test:null)])),new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null)),com.rpl.specter.impl.__GT_LocalSym.call(null,p,new cljs.core.Symbol(null,"p","p",1791580836,null))], null)], null),cljs.core.list(new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),cljs.core.list(new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null)),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null),new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null),new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null));
com.rpl.specter.pathcache81398 = info81399;

return info81399;
})():info__33353__auto__);
var precompiled81400 = com.rpl.specter.impl.cached_path_info_precompiled.call(null,info__33353__auto____$1);
var dynamic_QMARK___33354__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_.call(null,info__33353__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___33354__auto__)){
return precompiled81400.call(null,new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.cond_path,com.rpl.specter.pred,afn,com.rpl.specter.STAY,cljs.core.coll_QMARK_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.ALL_WITH_META,p], null),com.rpl.specter.ALL_WITH_META,p], null));
} else {
return precompiled81400;
}
})());

return p;
}));

//# sourceMappingURL=specter.js.map?rel=1511229588316
