(defproject fulcrologic/fulcro-auxillary "1.0.0-SNAPSHOT"
  :description "A library of conveniences for Fulcro"
  :license {:name "MIT" :url "https://opensource.org/licenses/MIT"}
  :min-lein-version "2.7.0"

  :dependencies [[org.clojure/clojure "1.9.0"]
                 [org.clojure/clojurescript "1.9.946"]
                 [fulcrologic/fulcro "2.5.0-SNAPSHOT" :scope "provided"]
                 [http-kit "2.2.0"]
                 [ring/ring-core "1.6.3" :exclusions [commons-codec]]
                 [bk/ring-gzip "0.2.1"]
                 [com.stuartsierra/component "0.3.2"]
                 [bidi "2.1.3"]
                 [com.taoensso/sente "1.12.0"]
                 [fulcrologic/fulcro-spec "2.1.0-SNAPSHOT" :scope "test" :exclusions [fulcrologic/fulcro]]]

  :source-paths ["src/main"]
  :test-paths ["src/test"]

  :test-refresh {:report       fulcro-spec.reporters.terminal/fulcro-report
                 :with-repl    true
                 :changes-only true}

  :profiles {:cljs {:source-paths ["src/main" "src/test" "src/cards"]
                    :dependencies [[binaryage/devtools "0.9.9"]
                                   [thheller/shadow-cljs "2.2.14"]
                                   [fulcrologic/fulcro-inspect "2.0.0" :exclusions [fulcrologic/fulcro-css]]
                                   [devcards "0.2.4" :exclusions [cljsjs/react cljsjs/react-dom]]]}
             :dev  {:source-paths ["src/dev" "src/main" "src/cards"]
                    :jvm-opts     ["-XX:-OmitStackTraceInFastThrow" "-client" "-XX:+TieredCompilation" "-XX:TieredStopAtLevel=1"
                                   "-Xmx1g" "-XX:+UseConcMarkSweepGC" "-XX:+CMSClassUnloadingEnabled" "-Xverify:none"]

                    :plugins      [[com.jakemccrary/lein-test-refresh "0.21.1"]]

                    :dependencies [[org.clojure/tools.namespace "0.3.0-alpha4"]
                                   [org.clojure/tools.nrepl "0.2.13"]
                                   [com.cemerick/piggieback "0.2.2"]]
                    :repl-options {:init-ns          user
                                   :nrepl-middleware [cemerick.piggieback/wrap-cljs-repl]}}})
