(ns app.parser
  (:require [om.next :as om]))

(defmulti read om/dispatch)
(defmulti mutate om/dispatch)

(def app-state
  {:app/route    '[:app/home _]
   :app/home     {:page/title   "Home page"
                  :page/content "This is the homepage. There isn't a lot to see here."}
   :app/artworks {:page/title   "Artworks page"
                  :page/content "This is the artwork page. There isn't a lot to see here."}
   :app/artists  {:page/title   "Artists page"
                  :page/content "This is the artists page, the place where one might write things about their own self."}})

(defonce reconciler (om/reconciler {:state  app-state
                                    :parser (om/parser {:read read :mutate mutate})}))
