(ns app.parser
  (:require [om.next :as om]))

(defmulti read om/dispatch)
(defmulti mutate om/dispatch)

(def app-state
  {:app/route '[:app/home _]
   :app/home  {:home/title   "Home page"
               :home/content "This is the homepage. There isn't a lot to see here."}
   :app/about {:about/title   "About page"
               :about/content "This is the about page, the place where one might write things about their own self."}})

(defonce reconciler (om/reconciler {:state  app-state
                                    :parser (om/parser {:read read :mutate mutate})}))
