(ns app.core
  (:require [goog.dom :as gdom]
            [goog.events :as events]
            [om.next :as om]
            [app.parser :as p]
            [app.routes :as routes])
  (:import goog.History
           goog.history.EventType))

(defn init []
  (let [h (History.)]
    (events/listen h EventType.NAVIGATE
                   #(if-let [token (not-empty (.-token %))]
                     (let [response (routes/service {:uri token})]
                       (routes/change-route! response))
                     (set! js/window.location.hash "/")))
    (doto h (.setEnabled true)))
  (om/add-root! p/reconciler routes/Root (gdom/getElement "app")))