(ns app.core
  (:require [om.core :as om :include-macros true]
            [cljsjs.react.dom]
            [sablono.core :as sab]))

(enable-console-print!)

(defonce app-state (atom {:text "Hello"}))

(defn widget [cursor owner]
  (reify
    om/IRender
    (render [_]
      (sab/html
       [:div
        [:h1 (:text cursor)]]))))

(defn reload []
  (om/refresh! widget))

(defn init []
  (when-let [node (.getElementById js/document "container")]
    (om/root widget app-state {:target node})))
