(defproject forthold/neocons "1.0.1-SNAPSHOT"
  :dev-dependencies [[lein-clojars "0.6.0"]]
  :description "Neocons is an experimental idiomatic Clojure client for the Neo4J REST API"
  :license { :name "Eclipse Public License" }
  :repositories {
                 "clojure-releases" "http://build.clojure.org/releases"
                 "sonatype" {:url "http://oss.sonatype.org/content/repositories/releases"
                             :snapshots false
                             :releases {:checksum :fail :update :always}
                             }
                 }
  :dependencies [[org.clojure/clojure   "1.3.0"]
                 [org.clojure/data.json "0.1.2"]
                 [clj-http              "0.3.2"]]
  :multi-deps {
               "1.4" [[org.clojure/clojure "1.4.0-beta1"]]
               :all [[org.clojure/data.json "0.1.2"]
                     [clj-http              "0.3.1"]]
               }
  :source-path        "src/clojure"
  :java-source-path   "src/java"
  :dev-resources-path "test/resources"
  :warn-on-reflection true
  :test-selectors   {:default        (fn [v] (not (:time-consuming v)))
                     :time-consuming (fn [v] (:time-consuming v))
                     :focus          (fn [v] (:focus v))
                     :indexing       (fn [v] (:indexing v))
                     :all            (fn [_] true)})
