/*
 * Decompiled with CFR 0.152.
 */
package org.jblas.benchmark;

import java.io.PrintStream;
import org.jblas.benchmark.ATLASDoubleMultiplicationBenchmark;
import org.jblas.benchmark.ATLASFloatMultiplicationBenchmark;
import org.jblas.benchmark.Benchmark;
import org.jblas.benchmark.BenchmarkResult;
import org.jblas.benchmark.JavaDoubleMultiplicationBenchmark;
import org.jblas.benchmark.JavaFloatMultiplicationBenchmark;
import org.jblas.util.ArchFlavor;
import org.jblas.util.Logger;
import org.jblas.util.SanityChecks;

public class Main {
    static Benchmark[] multiplicationBenchmarks = new Benchmark[]{new JavaDoubleMultiplicationBenchmark(), new JavaFloatMultiplicationBenchmark(), new ATLASDoubleMultiplicationBenchmark(), new ATLASFloatMultiplicationBenchmark()};

    public static void printHelp() {
        System.out.printf("Usage: benchmark [opts]%n%nwith options:%n%n  --arch-flavor=value     overriding arch flavor (e.g. --arch-flavor=sse2)%n  --skip-java             don't run java benchmarks%n  --help                  show this help%n  --debug                 set config levels to debug%n", new Object[0]);
    }

    public static void main(String[] args) {
        int[] multiplicationSizes = new int[]{10, 100, 1000};
        PrintStream out = System.out;
        boolean skipJava = false;
        boolean unrecognizedOptions = false;
        for (String arg : args) {
            if (!arg.startsWith("--")) continue;
            int i = arg.indexOf(61);
            String value = null;
            if (i != -1) {
                value = arg.substring(i + 1);
                arg = arg.substring(0, i);
            }
            if (arg.equals("--arch-flavor")) {
                Logger.getLogger().info("Setting arch flavor to " + value);
                ArchFlavor.overrideArchFlavor(value);
                continue;
            }
            if (arg.equals("--skip-java")) {
                skipJava = true;
                continue;
            }
            if (arg.equals("--help")) {
                Main.printHelp();
                return;
            }
            if (arg.equals("--debug")) {
                Logger.getLogger().setLevel(1);
                continue;
            }
            Logger.getLogger().warning("Unrecognized option \"" + arg + "\"");
            unrecognizedOptions = true;
        }
        if (unrecognizedOptions) {
            return;
        }
        out.println("Simple benchmark for jblas");
        out.println();
        out.println("Running sanity benchmarks.");
        out.println();
        SanityChecks.main(args);
        out.println();
        out.println("Each benchmark will take about 5 seconds...");
        for (Benchmark b : multiplicationBenchmarks) {
            if (skipJava && b.getName().contains("Java")) continue;
            out.println();
            out.println("Running benchmark \"" + b.getName() + "\".");
            for (int n : multiplicationSizes) {
                out.printf("n = %-5d: ", n);
                out.flush();
                BenchmarkResult result = b.run(n, 5.0);
                result.printResult();
            }
        }
    }
}

