/*
 * Decompiled with CFR 0.152.
 */
package org.jblas;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jblas.ConvertsToDoubleMatrix;
import org.jblas.FloatMatrix;
import org.jblas.JavaBlas;
import org.jblas.MatrixFunctions;
import org.jblas.NativeBlas;
import org.jblas.SimpleBlas;
import org.jblas.exceptions.SizeException;
import org.jblas.ranges.Range;
import org.jblas.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleMatrix
implements Serializable {
    public int rows;
    public int columns;
    public int length;
    public double[] data = null;
    public static final DoubleMatrix EMPTY = new DoubleMatrix();
    static final long serialVersionUID = -1249281332731183060L;

    public DoubleMatrix(int newRows, int newColumns, double ... newData) {
        this.rows = newRows;
        this.columns = newColumns;
        this.length = this.rows * this.columns;
        if (newData != null && newData.length != newRows * newColumns) {
            throw new IllegalArgumentException("Passed data must match matrix dimensions.");
        }
        this.data = newData;
    }

    public DoubleMatrix(int newRows, int newColumns) {
        this(newRows, newColumns, new double[newRows * newColumns]);
    }

    public DoubleMatrix() {
        this(0, 0, (double[])null);
    }

    public DoubleMatrix(int len) {
        this(len, 1, new double[len]);
    }

    public DoubleMatrix(double[] newData) {
        this(newData.length);
        this.data = newData;
    }

    public DoubleMatrix(String filename) throws IOException {
        this.load(filename);
    }

    public DoubleMatrix(double[][] data) {
        this(data.length, data[0].length);
        int r;
        for (r = 0; r < this.rows; ++r) {
            assert (data[r].length == this.columns);
        }
        for (r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.columns; ++c) {
                this.put(r, c, data[r][c]);
            }
        }
    }

    public DoubleMatrix(List<Double> data) {
        this(data.size());
        int c = 0;
        for (Double d : data) {
            this.put(c++, (double)d);
        }
    }

    public static DoubleMatrix valueOf(String text) {
        String[] rowValues = text.split(";");
        String[] columnValues = rowValues[0].trim().split("\\s+");
        DoubleMatrix result = null;
        for (int r = 0; r < rowValues.length; ++r) {
            columnValues = rowValues[r].trim().split("\\s+");
            if (r == 0) {
                result = new DoubleMatrix(rowValues.length, columnValues.length);
            }
            for (int c = 0; c < columnValues.length; ++c) {
                result.put(r, c, (double)Double.valueOf(columnValues[c]));
            }
        }
        return result;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }

    public static DoubleMatrix rand(int rows, int columns) {
        DoubleMatrix m = new DoubleMatrix(rows, columns);
        for (int i = 0; i < rows * columns; ++i) {
            m.data[i] = Random.nextDouble();
        }
        return m;
    }

    public static DoubleMatrix rand(int len) {
        return DoubleMatrix.rand(len, 1);
    }

    public static DoubleMatrix randn(int rows, int columns) {
        DoubleMatrix m = new DoubleMatrix(rows, columns);
        for (int i = 0; i < rows * columns; ++i) {
            m.data[i] = Random.nextGaussian();
        }
        return m;
    }

    public static DoubleMatrix randn(int len) {
        return DoubleMatrix.randn(len, 1);
    }

    public static DoubleMatrix zeros(int rows, int columns) {
        return new DoubleMatrix(rows, columns);
    }

    public static DoubleMatrix zeros(int length) {
        return DoubleMatrix.zeros(length, 1);
    }

    public static DoubleMatrix ones(int rows, int columns) {
        DoubleMatrix m = new DoubleMatrix(rows, columns);
        for (int i = 0; i < rows * columns; ++i) {
            m.put(i, 1.0);
        }
        return m;
    }

    public static DoubleMatrix ones(int length) {
        return DoubleMatrix.ones(length, 1);
    }

    public static DoubleMatrix eye(int n) {
        DoubleMatrix m = new DoubleMatrix(n, n);
        for (int i = 0; i < n; ++i) {
            m.put(i, i, 1.0);
        }
        return m;
    }

    public static DoubleMatrix diag(DoubleMatrix x) {
        DoubleMatrix m = new DoubleMatrix(x.length, x.length);
        for (int i = 0; i < x.length; ++i) {
            m.put(i, i, x.get(i));
        }
        return m;
    }

    public static DoubleMatrix scalar(double s) {
        DoubleMatrix m = new DoubleMatrix(1, 1);
        m.put(0, 0, s);
        return m;
    }

    public boolean isScalar() {
        return this.length == 1;
    }

    public double scalar() {
        return this.get(0);
    }

    public static DoubleMatrix logspace(double lower, double upper, int size) {
        DoubleMatrix result = new DoubleMatrix(size);
        for (int i = 0; i < size; ++i) {
            double t = (double)i / (double)(size - 1);
            double e = lower * (1.0 - t) + t * upper;
            result.put(i, Math.pow(10.0, e));
        }
        return result;
    }

    public static DoubleMatrix linspace(int lower, int upper, int size) {
        DoubleMatrix result = new DoubleMatrix(size);
        for (int i = 0; i < size; ++i) {
            double t = (double)i / (double)(size - 1);
            result.put(i, (double)lower * (1.0 - t) + t * (double)upper);
        }
        return result;
    }

    public static DoubleMatrix concatHorizontally(DoubleMatrix A, DoubleMatrix B) {
        if (A.rows != B.rows) {
            throw new SizeException("Matrices don't have same number of rows.");
        }
        DoubleMatrix result = new DoubleMatrix(A.rows, A.columns + B.columns);
        SimpleBlas.copy(A, result);
        JavaBlas.rcopy(B.length, B.data, 0, 1, result.data, A.length, 1);
        return result;
    }

    public static DoubleMatrix concatVertically(DoubleMatrix A, DoubleMatrix B) {
        if (A.columns != B.columns) {
            throw new SizeException("Matrices don't have same number of columns (" + A.columns + " != " + B.columns + ".");
        }
        DoubleMatrix result = new DoubleMatrix(A.rows + B.rows, A.columns);
        for (int i = 0; i < A.columns; ++i) {
            JavaBlas.rcopy(A.rows, A.data, A.index(0, i), 1, result.data, result.index(0, i), 1);
            JavaBlas.rcopy(B.rows, B.data, B.index(0, i), 1, result.data, result.index(A.rows, i), 1);
        }
        return result;
    }

    public DoubleMatrix get(int[] indices) {
        DoubleMatrix result = new DoubleMatrix(indices.length);
        for (int i = 0; i < indices.length; ++i) {
            result.put(i, this.get(indices[i]));
        }
        return result;
    }

    public DoubleMatrix get(int r, int[] indices) {
        DoubleMatrix result = new DoubleMatrix(1, indices.length);
        for (int i = 0; i < indices.length; ++i) {
            result.put(i, this.get(r, indices[i]));
        }
        return result;
    }

    public DoubleMatrix get(int[] indices, int c) {
        DoubleMatrix result = new DoubleMatrix(indices.length, c);
        for (int i = 0; i < indices.length; ++i) {
            result.put(i, this.get(indices[i], c));
        }
        return result;
    }

    public DoubleMatrix get(int[] rindices, int[] cindices) {
        DoubleMatrix result = new DoubleMatrix(rindices.length, cindices.length);
        for (int i = 0; i < rindices.length; ++i) {
            for (int j = 0; j < cindices.length; ++j) {
                result.put(i, j, this.get(rindices[i], cindices[j]));
            }
        }
        return result;
    }

    public DoubleMatrix get(Range rs, Range cs) {
        rs.init(0, this.rows);
        cs.init(0, this.columns);
        DoubleMatrix result = new DoubleMatrix(rs.length(), cs.length());
        while (rs.hasMore()) {
            while (cs.hasMore()) {
                result.put(rs.index(), cs.index(), this.get(rs.value(), cs.value()));
                cs.next();
            }
            rs.next();
        }
        return result;
    }

    public DoubleMatrix get(Range rs, int c) {
        rs.init(0, this.rows);
        DoubleMatrix result = new DoubleMatrix(rs.length(), 1);
        while (rs.hasMore()) {
            result.put(rs.index(), 0, this.get(rs.value(), c));
            rs.next();
        }
        return result;
    }

    public DoubleMatrix get(int r, Range cs) {
        cs.init(0, this.columns);
        DoubleMatrix result = new DoubleMatrix(1, cs.length());
        while (cs.hasMore()) {
            result.put(0, cs.index(), this.get(r, cs.value()));
            cs.next();
        }
        return result;
    }

    public DoubleMatrix get(DoubleMatrix indices) {
        return this.get(indices.findIndices());
    }

    public DoubleMatrix get(int r, DoubleMatrix indices) {
        return this.get(r, indices.findIndices());
    }

    public DoubleMatrix get(DoubleMatrix indices, int c) {
        return this.get(indices.findIndices(), c);
    }

    public DoubleMatrix get(DoubleMatrix rindices, DoubleMatrix cindices) {
        return this.get(rindices.findIndices(), cindices.findIndices());
    }

    public DoubleMatrix getRange(int a, int b) {
        DoubleMatrix result = new DoubleMatrix(b - a);
        for (int k = 0; k < b - a; ++k) {
            result.put(k, this.get(a + k));
        }
        return result;
    }

    public DoubleMatrix getColumnRange(int r, int a, int b) {
        DoubleMatrix result = new DoubleMatrix(1, b - a);
        for (int k = 0; k < b - a; ++k) {
            result.put(k, this.get(r, a + k));
        }
        return result;
    }

    public DoubleMatrix getRowRange(int a, int b, int c) {
        DoubleMatrix result = new DoubleMatrix(b - a);
        for (int k = 0; k < b - a; ++k) {
            result.put(k, this.get(a + k, c));
        }
        return result;
    }

    public DoubleMatrix getRange(int ra, int rb, int ca, int cb) {
        DoubleMatrix result = new DoubleMatrix(rb - ra, cb - ca);
        for (int i = 0; i < rb - ra; ++i) {
            for (int j = 0; j < cb - ca; ++j) {
                result.put(i, j, this.get(ra + i, ca + j));
            }
        }
        return result;
    }

    public DoubleMatrix getRows(int[] rindices) {
        DoubleMatrix result = new DoubleMatrix(rindices.length, this.columns);
        for (int i = 0; i < rindices.length; ++i) {
            JavaBlas.rcopy(this.columns, this.data, this.index(rindices[i], 0), this.rows, result.data, result.index(i, 0), result.rows);
        }
        return result;
    }

    public DoubleMatrix getRows(DoubleMatrix rindices) {
        return this.getRows(rindices.findIndices());
    }

    public DoubleMatrix getRows(Range indices, DoubleMatrix result) {
        indices.init(0, this.rows);
        if (result.rows < indices.length()) {
            throw new SizeException("Result matrix does not have enough rows (" + result.rows + " < " + indices.length() + ")");
        }
        result.checkColumns(this.columns);
        for (int c = 0; c < this.columns; ++c) {
            indices.init(0, this.rows);
            int r = 0;
            while (indices.hasMore()) {
                result.put(r, c, this.get(indices.index(), c));
                indices.next();
                ++r;
            }
        }
        return result;
    }

    public DoubleMatrix getRows(Range indices) {
        indices.init(0, this.rows);
        DoubleMatrix result = new DoubleMatrix(indices.length(), this.columns);
        return this.getRows(indices, result);
    }

    public DoubleMatrix getColumns(int[] cindices) {
        DoubleMatrix result = new DoubleMatrix(this.rows, cindices.length);
        for (int i = 0; i < cindices.length; ++i) {
            JavaBlas.rcopy(this.rows, this.data, this.index(0, cindices[i]), 1, result.data, result.index(0, i), 1);
        }
        return result;
    }

    public DoubleMatrix getColumns(DoubleMatrix cindices) {
        return this.getColumns(cindices.findIndices());
    }

    public void checkLength(int l) {
        if (this.length != l) {
            throw new SizeException("Matrix does not have the necessary length (" + this.length + " != " + l + ").");
        }
    }

    public void checkRows(int r) {
        if (this.rows != r) {
            throw new SizeException("Matrix does not have the necessary number of rows (" + this.rows + " != " + r + ").");
        }
    }

    public void checkColumns(int c) {
        if (this.columns != c) {
            throw new SizeException("Matrix does not have the necessary number of columns (" + this.columns + " != " + c + ").");
        }
    }

    public DoubleMatrix put(int[] indices, DoubleMatrix x) {
        if (x.isScalar()) {
            return this.put(indices, x.scalar());
        }
        x.checkLength(indices.length);
        for (int i = 0; i < indices.length; ++i) {
            this.put(indices[i], x.get(i));
        }
        return this;
    }

    public DoubleMatrix put(int r, int[] indices, DoubleMatrix x) {
        if (x.isScalar()) {
            return this.put(r, indices, x.scalar());
        }
        x.checkColumns(indices.length);
        for (int i = 0; i < indices.length; ++i) {
            this.put(r, indices[i], x.get(i));
        }
        return this;
    }

    public DoubleMatrix put(int[] indices, int c, DoubleMatrix x) {
        if (x.isScalar()) {
            return this.put(indices, c, x.scalar());
        }
        x.checkRows(indices.length);
        for (int i = 0; i < indices.length; ++i) {
            this.put(indices[i], c, x.get(i));
        }
        return this;
    }

    public DoubleMatrix put(int[] rindices, int[] cindices, DoubleMatrix x) {
        if (x.isScalar()) {
            return this.put(rindices, cindices, x.scalar());
        }
        x.checkRows(rindices.length);
        x.checkColumns(cindices.length);
        for (int i = 0; i < rindices.length; ++i) {
            for (int j = 0; j < cindices.length; ++j) {
                this.put(rindices[i], cindices[j], x.get(i, j));
            }
        }
        return this;
    }

    public DoubleMatrix put(Range rs, Range cs, DoubleMatrix x) {
        rs.init(0, this.rows);
        cs.init(0, this.columns);
        x.checkRows(rs.length());
        x.checkColumns(cs.length());
        while (rs.hasMore()) {
            cs.init(0, this.columns);
            while (cs.hasMore()) {
                this.put(rs.value(), cs.value(), x.get(rs.index(), cs.index()));
                cs.next();
            }
            rs.next();
        }
        return this;
    }

    public DoubleMatrix put(int[] indices, double v) {
        for (int i = 0; i < indices.length; ++i) {
            this.put(indices[i], v);
        }
        return this;
    }

    public DoubleMatrix put(int r, int[] indices, double v) {
        for (int i = 0; i < indices.length; ++i) {
            this.put(r, indices[i], v);
        }
        return this;
    }

    public DoubleMatrix put(int[] indices, int c, double v) {
        for (int i = 0; i < indices.length; ++i) {
            this.put(indices[i], c, v);
        }
        return this;
    }

    public DoubleMatrix put(int[] rindices, int[] cindices, double v) {
        for (int i = 0; i < rindices.length; ++i) {
            for (int j = 0; j < cindices.length; ++j) {
                this.put(rindices[i], cindices[j], v);
            }
        }
        return this;
    }

    public DoubleMatrix put(DoubleMatrix indices, DoubleMatrix v) {
        return this.put(indices.findIndices(), v);
    }

    public DoubleMatrix put(int r, DoubleMatrix indices, DoubleMatrix v) {
        return this.put(r, indices.findIndices(), v);
    }

    public DoubleMatrix put(DoubleMatrix indices, int c, DoubleMatrix v) {
        return this.put(indices.findIndices(), c, v);
    }

    public DoubleMatrix put(DoubleMatrix rindices, DoubleMatrix cindices, DoubleMatrix v) {
        return this.put(rindices.findIndices(), cindices.findIndices(), v);
    }

    public DoubleMatrix put(DoubleMatrix indices, double v) {
        return this.put(indices.findIndices(), v);
    }

    public DoubleMatrix put(int r, DoubleMatrix indices, double v) {
        return this.put(r, indices.findIndices(), v);
    }

    public DoubleMatrix put(DoubleMatrix indices, int c, double v) {
        return this.put(indices.findIndices(), c, v);
    }

    public DoubleMatrix put(DoubleMatrix rindices, DoubleMatrix cindices, double v) {
        return this.put(rindices.findIndices(), cindices.findIndices(), v);
    }

    public int[] findIndices() {
        int len = 0;
        for (int i = 0; i < this.length; ++i) {
            if (this.get(i) == 0.0) continue;
            ++len;
        }
        int[] indices = new int[len];
        int c = 0;
        for (int i = 0; i < this.length; ++i) {
            if (this.get(i) == 0.0) continue;
            indices[c++] = i;
        }
        return indices;
    }

    public DoubleMatrix transpose() {
        DoubleMatrix result = new DoubleMatrix(this.columns, this.rows);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                result.put(j, i, this.get(i, j));
            }
        }
        return result;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DoubleMatrix)) {
            return false;
        }
        DoubleMatrix other = (DoubleMatrix)o;
        if (!this.sameSize(other)) {
            return false;
        }
        DoubleMatrix diff = MatrixFunctions.absi(this.sub(other));
        return diff.max() / (double)(this.rows * this.columns) < 1.0E-6;
    }

    public int hashCode() {
        int hash = 7;
        hash = 83 * hash + this.rows;
        hash = 83 * hash + this.columns;
        hash = 83 * hash + Arrays.hashCode(this.data);
        return hash;
    }

    public void resize(int newRows, int newColumns) {
        this.rows = newRows;
        this.columns = newColumns;
        this.length = newRows * newColumns;
        this.data = new double[this.rows * this.columns];
    }

    public DoubleMatrix reshape(int newRows, int newColumns) {
        if (this.length != newRows * newColumns) {
            throw new IllegalArgumentException("Number of elements must not change.");
        }
        this.rows = newRows;
        this.columns = newColumns;
        return this;
    }

    public DoubleMatrix repmat(int rowMult, int columnMult) {
        DoubleMatrix result = new DoubleMatrix(this.rows * rowMult, this.columns * columnMult);
        for (int c = 0; c < columnMult; ++c) {
            for (int r = 0; r < rowMult; ++r) {
                for (int i = 0; i < this.rows; ++i) {
                    for (int j = 0; j < this.columns; ++j) {
                        result.put(r * this.rows + i, c * this.columns + j, this.get(i, j));
                    }
                }
            }
        }
        return result;
    }

    public boolean sameSize(DoubleMatrix a) {
        return this.rows == a.rows && this.columns == a.columns;
    }

    public void assertSameSize(DoubleMatrix a) {
        if (!this.sameSize(a)) {
            throw new SizeException("Matrices must have the same size.");
        }
    }

    public boolean multipliesWith(DoubleMatrix a) {
        return this.columns == a.rows;
    }

    public void assertMultipliesWith(DoubleMatrix a) {
        if (!this.multipliesWith(a)) {
            throw new SizeException("Number of columns of left matrix must be equal to number of rows of right matrix.");
        }
    }

    public boolean sameLength(DoubleMatrix a) {
        return this.length == a.length;
    }

    public void assertSameLength(DoubleMatrix a) {
        if (!this.sameLength(a)) {
            throw new SizeException("Matrices must have same length (is: " + this.length + " and " + a.length + ")");
        }
    }

    public DoubleMatrix copy(DoubleMatrix a) {
        if (!this.sameSize(a)) {
            this.resize(a.rows, a.columns);
        }
        System.arraycopy(a.data, 0, this.data, 0, this.length);
        return a;
    }

    public DoubleMatrix dup() {
        DoubleMatrix out = new DoubleMatrix(this.rows, this.columns);
        JavaBlas.rcopy(this.length, this.data, 0, 1, out.data, 0, 1);
        return out;
    }

    public DoubleMatrix swapColumns(int i, int j) {
        NativeBlas.dswap(this.rows, this.data, this.index(0, i), 1, this.data, this.index(0, j), 1);
        return this;
    }

    public DoubleMatrix swapRows(int i, int j) {
        NativeBlas.dswap(this.columns, this.data, this.index(i, 0), this.rows, this.data, this.index(j, 0), this.rows);
        return this;
    }

    public DoubleMatrix put(int rowIndex, int columnIndex, double value) {
        this.data[this.index((int)rowIndex, (int)columnIndex)] = value;
        return this;
    }

    public double get(int rowIndex, int columnIndex) {
        return this.data[this.index(rowIndex, columnIndex)];
    }

    public int index(int rowIndex, int columnIndex) {
        return rowIndex + this.rows * columnIndex;
    }

    public int indexRows(int i) {
        return i / this.rows;
    }

    public int indexColumns(int i) {
        return i - this.indexRows(i) * this.rows;
    }

    public double get(int i) {
        return this.data[i];
    }

    public DoubleMatrix put(int i, double v) {
        this.data[i] = v;
        return this;
    }

    public DoubleMatrix fill(double value) {
        for (int i = 0; i < this.length; ++i) {
            this.put(i, value);
        }
        return this;
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.columns;
    }

    public int getLength() {
        return this.length;
    }

    public boolean isEmpty() {
        return this.columns == 0 || this.rows == 0;
    }

    public boolean isSquare() {
        return this.columns == this.rows;
    }

    public void assertSquare() {
        if (!this.isSquare()) {
            throw new SizeException("Matrix must be square!");
        }
    }

    public boolean isVector() {
        return this.columns == 1 || this.rows == 1;
    }

    public boolean isRowVector() {
        return this.rows == 1;
    }

    public boolean isColumnVector() {
        return this.columns == 1;
    }

    public DoubleMatrix diag() {
        this.assertSquare();
        DoubleMatrix d = new DoubleMatrix(this.rows);
        JavaBlas.rcopy(this.rows, this.data, 0, this.rows + 1, d.data, 0, 1);
        return d;
    }

    public void print() {
        System.out.println(this.toString());
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("[");
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                s.append(this.get(i, j));
                if (j >= this.columns - 1) continue;
                s.append(", ");
            }
            if (i >= this.rows - 1) continue;
            s.append("; ");
        }
        s.append("]");
        return s.toString();
    }

    public String toString(String fmt) {
        StringWriter s = new StringWriter();
        PrintWriter p = new PrintWriter(s);
        p.print("[");
        for (int r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.columns; ++c) {
                p.printf(fmt, this.get(r, c));
                if (c >= this.columns - 1) continue;
                p.print(", ");
            }
            if (r >= this.rows - 1) continue;
            p.print("; ");
        }
        p.print("]");
        return s.toString();
    }

    public double[] toArray() {
        double[] array = new double[this.length];
        System.arraycopy(this.data, 0, array, 0, this.length);
        return array;
    }

    public double[][] toArray2() {
        double[][] array = new double[this.rows][this.columns];
        for (int r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.columns; ++c) {
                array[r][c] = this.get(r, c);
            }
        }
        return array;
    }

    public int[] toIntArray() {
        int[] array = new int[this.length];
        for (int i = 0; i < this.length; ++i) {
            array[i] = (int)Math.rint(this.get(i));
        }
        return array;
    }

    public int[][] toIntArray2() {
        int[][] array = new int[this.rows][this.columns];
        for (int r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.columns; ++c) {
                array[r][c] = (int)Math.rint(this.get(r, c));
            }
        }
        return array;
    }

    public boolean[] toBooleanArray() {
        boolean[] array = new boolean[this.length];
        for (int i = 0; i < this.length; ++i) {
            array[i] = this.get(i) != 0.0;
        }
        return array;
    }

    public boolean[][] toBooleanArray2() {
        boolean[][] array = new boolean[this.rows][this.columns];
        for (int r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.columns; ++c) {
                array[r][c] = this.get(r, c) != 0.0;
            }
        }
        return array;
    }

    public FloatMatrix toFloat() {
        FloatMatrix result = new FloatMatrix(this.rows, this.columns);
        for (int i = 0; i < this.length; ++i) {
            result.put(i, (float)this.get(i));
        }
        return result;
    }

    public List<Double> elementsAsList() {
        return new ElementsAsListView(this);
    }

    public List<DoubleMatrix> rowsAsList() {
        return new RowsAsListView(this);
    }

    public List<DoubleMatrix> columnsAsList() {
        return new ColumnsAsListView(this);
    }

    private void ensureResultLength(DoubleMatrix other, DoubleMatrix result) {
        if (!this.sameLength(result)) {
            if (result == this || result == other) {
                throw new SizeException("Cannot resize result matrix because it is used in-place.");
            }
            result.resize(this.rows, this.columns);
        }
    }

    public DoubleMatrix addi(DoubleMatrix other, DoubleMatrix result) {
        if (other.isScalar()) {
            return this.addi(other.scalar(), result);
        }
        if (this.isScalar()) {
            return other.addi(this.scalar(), result);
        }
        this.assertSameLength(other);
        this.ensureResultLength(other, result);
        if (result == this) {
            SimpleBlas.axpy(1.0, other, result);
        } else if (result == other) {
            SimpleBlas.axpy(1.0, this, result);
        } else {
            JavaBlas.rzgxpy(this.length, result.data, this.data, other.data);
        }
        return result;
    }

    public DoubleMatrix addi(double v, DoubleMatrix result) {
        this.ensureResultLength(null, result);
        for (int i = 0; i < this.length; ++i) {
            result.put(i, this.get(i) + v);
        }
        return result;
    }

    public DoubleMatrix subi(DoubleMatrix other, DoubleMatrix result) {
        if (other.isScalar()) {
            return this.subi(other.scalar(), result);
        }
        if (this.isScalar()) {
            return other.rsubi(this.scalar(), result);
        }
        this.assertSameLength(other);
        this.ensureResultLength(other, result);
        if (result == this) {
            SimpleBlas.axpy(-1.0, other, result);
        } else if (result == other) {
            SimpleBlas.scal(-1.0, result);
            SimpleBlas.axpy(1.0, this, result);
        } else {
            SimpleBlas.copy(this, result);
            SimpleBlas.axpy(-1.0, other, result);
        }
        return result;
    }

    public DoubleMatrix subi(double v, DoubleMatrix result) {
        this.ensureResultLength(null, result);
        for (int i = 0; i < this.length; ++i) {
            result.put(i, this.get(i) - v);
        }
        return result;
    }

    public DoubleMatrix rsubi(DoubleMatrix other, DoubleMatrix result) {
        return other.subi(this, result);
    }

    public DoubleMatrix rsubi(double a, DoubleMatrix result) {
        this.ensureResultLength(null, result);
        for (int i = 0; i < this.length; ++i) {
            result.put(i, a - this.get(i));
        }
        return result;
    }

    public DoubleMatrix muli(DoubleMatrix other, DoubleMatrix result) {
        if (other.isScalar()) {
            return this.muli(other.scalar(), result);
        }
        if (this.isScalar()) {
            return other.muli(this.scalar(), result);
        }
        this.assertSameLength(other);
        this.ensureResultLength(other, result);
        for (int i = 0; i < this.length; ++i) {
            result.put(i, this.get(i) * other.get(i));
        }
        return result;
    }

    public DoubleMatrix muli(double v, DoubleMatrix result) {
        this.ensureResultLength(null, result);
        for (int i = 0; i < this.length; ++i) {
            result.put(i, this.get(i) * v);
        }
        return result;
    }

    public DoubleMatrix mmuli(DoubleMatrix other, DoubleMatrix result) {
        if (other.isScalar()) {
            return this.muli(other.scalar(), result);
        }
        if (this.isScalar()) {
            return other.muli(this.scalar(), result);
        }
        this.assertMultipliesWith(other);
        if (result.rows != this.rows || result.columns != other.columns) {
            if (result != this && result != other) {
                result.resize(this.rows, other.columns);
            } else {
                throw new SizeException("Cannot resize result matrix because it is used in-place.");
            }
        }
        if (result == this || result == other) {
            DoubleMatrix temp = new DoubleMatrix(result.rows, result.columns);
            if (other.columns == 1) {
                SimpleBlas.gemv(1.0, this, other, 0.0, temp);
            } else {
                SimpleBlas.gemm(1.0, this, other, 0.0, temp);
            }
            SimpleBlas.copy(temp, result);
        } else if (other.columns == 1) {
            SimpleBlas.gemv(1.0, this, other, 0.0, result);
        } else {
            SimpleBlas.gemm(1.0, this, other, 0.0, result);
        }
        return result;
    }

    public DoubleMatrix mmuli(double v, DoubleMatrix result) {
        return this.muli(v, result);
    }

    public DoubleMatrix divi(DoubleMatrix other, DoubleMatrix result) {
        if (other.isScalar()) {
            return this.divi(other.scalar(), result);
        }
        if (this.isScalar()) {
            return other.rdivi(this.scalar(), result);
        }
        this.assertSameLength(other);
        this.ensureResultLength(other, result);
        for (int i = 0; i < this.length; ++i) {
            result.put(i, this.get(i) / other.get(i));
        }
        return result;
    }

    public DoubleMatrix divi(double a, DoubleMatrix result) {
        this.ensureResultLength(null, result);
        for (int i = 0; i < this.length; ++i) {
            result.put(i, this.get(i) / a);
        }
        return result;
    }

    public DoubleMatrix rdivi(DoubleMatrix other, DoubleMatrix result) {
        return other.divi(this, result);
    }

    public DoubleMatrix rdivi(double a, DoubleMatrix result) {
        this.ensureResultLength(null, result);
        for (int i = 0; i < this.length; ++i) {
            result.put(i, a / this.get(i));
        }
        return result;
    }

    public DoubleMatrix negi() {
        for (int i = 0; i < this.length; ++i) {
            this.put(i, -this.get(i));
        }
        return this;
    }

    public DoubleMatrix neg() {
        return this.dup().negi();
    }

    public DoubleMatrix noti() {
        for (int i = 0; i < this.length; ++i) {
            this.put(i, this.get(i) == 0.0 ? 1.0 : 0.0);
        }
        return this;
    }

    public DoubleMatrix not() {
        return this.dup().noti();
    }

    public DoubleMatrix truthi() {
        for (int i = 0; i < this.length; ++i) {
            this.put(i, this.get(i) == 0.0 ? 0.0 : 1.0);
        }
        return this;
    }

    public DoubleMatrix truth() {
        return this.dup().truthi();
    }

    public DoubleMatrix isNaNi() {
        for (int i = 0; i < this.length; ++i) {
            this.put(i, Double.isNaN(this.get(i)) ? 1.0 : 0.0);
        }
        return this;
    }

    public DoubleMatrix isNaN() {
        return this.dup().isNaNi();
    }

    public DoubleMatrix isInfinitei() {
        for (int i = 0; i < this.length; ++i) {
            this.put(i, Double.isInfinite(this.get(i)) ? 1.0 : 0.0);
        }
        return this;
    }

    public DoubleMatrix isInfinite() {
        return this.dup().isInfinitei();
    }

    public DoubleMatrix selecti(DoubleMatrix where) {
        this.checkLength(where.length);
        for (int i = 0; i < this.length; ++i) {
            if (where.get(i) != 0.0) continue;
            this.put(i, 0.0);
        }
        return this;
    }

    public DoubleMatrix select(DoubleMatrix where) {
        return this.dup().selecti(where);
    }

    public DoubleMatrix rankOneUpdate(double alpha, DoubleMatrix x, DoubleMatrix y) {
        if (this.rows != x.length) {
            throw new SizeException("Vector x has wrong length (" + x.length + " != " + this.rows + ").");
        }
        if (this.columns != y.length) {
            throw new SizeException("Vector y has wrong length (" + x.length + " != " + this.columns + ").");
        }
        SimpleBlas.ger(alpha, x, y, this);
        return this;
    }

    public DoubleMatrix rankOneUpdate(double alpha, DoubleMatrix x) {
        return this.rankOneUpdate(alpha, x, x);
    }

    public DoubleMatrix rankOneUpdate(DoubleMatrix x) {
        return this.rankOneUpdate(1.0, x, x);
    }

    public DoubleMatrix rankOneUpdate(DoubleMatrix x, DoubleMatrix y) {
        return this.rankOneUpdate(1.0, x, y);
    }

    public double min() {
        if (this.isEmpty()) {
            return Double.POSITIVE_INFINITY;
        }
        double v = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.length; ++i) {
            if (Double.isNaN(this.get(i)) || !(this.get(i) < v)) continue;
            v = this.get(i);
        }
        return v;
    }

    public int argmin() {
        if (this.isEmpty()) {
            return -1;
        }
        double v = Double.POSITIVE_INFINITY;
        int a = -1;
        for (int i = 0; i < this.length; ++i) {
            if (Double.isNaN(this.get(i)) || !(this.get(i) < v)) continue;
            v = this.get(i);
            a = i;
        }
        return a;
    }

    public DoubleMatrix mini(DoubleMatrix other, DoubleMatrix result) {
        if (result == this) {
            for (int i = 0; i < this.length; ++i) {
                if (!(this.get(i) > other.get(i))) continue;
                this.put(i, other.get(i));
            }
        } else {
            for (int i = 0; i < this.length; ++i) {
                if (this.get(i) > other.get(i)) {
                    result.put(i, other.get(i));
                    continue;
                }
                result.put(i, this.get(i));
            }
        }
        return this;
    }

    public DoubleMatrix mini(DoubleMatrix other) {
        return this.mini(other, this);
    }

    public DoubleMatrix min(DoubleMatrix other) {
        return this.mini(other, new DoubleMatrix(this.rows, this.columns));
    }

    public DoubleMatrix mini(double v, DoubleMatrix result) {
        if (result == this) {
            for (int i = 0; i < this.length; ++i) {
                if (!(this.get(i) > v)) continue;
                result.put(i, v);
            }
        } else {
            for (int i = 0; i < this.length; ++i) {
                if (this.get(i) > v) {
                    result.put(i, v);
                    continue;
                }
                result.put(i, this.get(i));
            }
        }
        return this;
    }

    public DoubleMatrix mini(double v) {
        return this.mini(v, this);
    }

    public DoubleMatrix min(double v) {
        return this.mini(v, new DoubleMatrix(this.rows, this.columns));
    }

    public double max() {
        if (this.isEmpty()) {
            return Double.NEGATIVE_INFINITY;
        }
        double v = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.length; ++i) {
            if (Double.isNaN(this.get(i)) || !(this.get(i) > v)) continue;
            v = this.get(i);
        }
        return v;
    }

    public int argmax() {
        if (this.isEmpty()) {
            return -1;
        }
        double v = Double.NEGATIVE_INFINITY;
        int a = -1;
        for (int i = 0; i < this.length; ++i) {
            if (Double.isNaN(this.get(i)) || !(this.get(i) > v)) continue;
            v = this.get(i);
            a = i;
        }
        return a;
    }

    public DoubleMatrix maxi(DoubleMatrix other, DoubleMatrix result) {
        if (result == this) {
            for (int i = 0; i < this.length; ++i) {
                if (!(this.get(i) < other.get(i))) continue;
                this.put(i, other.get(i));
            }
        } else {
            for (int i = 0; i < this.length; ++i) {
                if (this.get(i) < other.get(i)) {
                    result.put(i, other.get(i));
                    continue;
                }
                result.put(i, this.get(i));
            }
        }
        return this;
    }

    public DoubleMatrix maxi(DoubleMatrix other) {
        return this.maxi(other, this);
    }

    public DoubleMatrix max(DoubleMatrix other) {
        return this.maxi(other, new DoubleMatrix(this.rows, this.columns));
    }

    public DoubleMatrix maxi(double v, DoubleMatrix result) {
        if (result == this) {
            for (int i = 0; i < this.length; ++i) {
                if (!(this.get(i) < v)) continue;
                result.put(i, v);
            }
        } else {
            for (int i = 0; i < this.length; ++i) {
                if (this.get(i) < v) {
                    result.put(i, v);
                    continue;
                }
                result.put(i, this.get(i));
            }
        }
        return this;
    }

    public DoubleMatrix maxi(double v) {
        return this.maxi(v, this);
    }

    public DoubleMatrix max(double v) {
        return this.maxi(v, new DoubleMatrix(this.rows, this.columns));
    }

    public double sum() {
        double s = 0.0;
        for (int i = 0; i < this.length; ++i) {
            s += this.get(i);
        }
        return s;
    }

    public double prod() {
        double p = 1.0;
        for (int i = 0; i < this.length; ++i) {
            p *= this.get(i);
        }
        return p;
    }

    public double mean() {
        return this.sum() / (double)this.length;
    }

    public DoubleMatrix cumulativeSumi() {
        double s = 0.0;
        for (int i = 0; i < this.length; ++i) {
            this.put(i, s += this.get(i));
        }
        return this;
    }

    public DoubleMatrix cumulativeSum() {
        return this.dup().cumulativeSumi();
    }

    public double dot(DoubleMatrix other) {
        return SimpleBlas.dot(this, other);
    }

    public double project(DoubleMatrix other) {
        other.checkLength(this.length);
        double norm = 0.0;
        double dot = 0.0;
        for (int i = 0; i < this.length; ++i) {
            double x = this.get(i);
            norm += x * x;
            dot += x * other.get(i);
        }
        return dot / norm;
    }

    public double norm2() {
        double norm = 0.0;
        for (int i = 0; i < this.length; ++i) {
            norm += this.get(i) * this.get(i);
        }
        return Math.sqrt(norm);
    }

    public double normmax() {
        double max = 0.0;
        for (int i = 0; i < this.length; ++i) {
            double a = Math.abs(this.get(i));
            if (!(a > max)) continue;
            max = a;
        }
        return max;
    }

    public double norm1() {
        double norm = 0.0;
        for (int i = 0; i < this.length; ++i) {
            norm += Math.abs(this.get(i));
        }
        return norm;
    }

    public double squaredDistance(DoubleMatrix other) {
        other.checkLength(this.length);
        double sd = 0.0;
        for (int i = 0; i < this.length; ++i) {
            double d = this.get(i) - other.get(i);
            sd += d * d;
        }
        return sd;
    }

    public double distance2(DoubleMatrix other) {
        return Math.sqrt(this.squaredDistance(other));
    }

    public double distance1(DoubleMatrix other) {
        other.checkLength(this.length);
        double d = 0.0;
        for (int i = 0; i < this.length; ++i) {
            d += Math.abs(this.get(i) - other.get(i));
        }
        return d;
    }

    public DoubleMatrix sort() {
        double[] array = this.toArray();
        Arrays.sort(array);
        return new DoubleMatrix(this.rows, this.columns, array);
    }

    public DoubleMatrix sorti() {
        Arrays.sort(this.data);
        return this;
    }

    public int[] sortingPermutation() {
        Integer[] indices = new Integer[this.length];
        for (int i = 0; i < this.length; ++i) {
            indices[i] = i;
        }
        final double[] array = this.data;
        Arrays.sort(indices, new Comparator(){

            public int compare(Object o1, Object o2) {
                int j;
                int i = (Integer)o1;
                if (array[i] < array[j = ((Integer)o2).intValue()]) {
                    return -1;
                }
                if (array[i] == array[j]) {
                    return 0;
                }
                return 1;
            }
        });
        int[] result = new int[this.length];
        for (int i = 0; i < this.length; ++i) {
            result[i] = indices[i];
        }
        return result;
    }

    public DoubleMatrix sortColumnsi() {
        for (int i = 0; i < this.length; i += this.rows) {
            Arrays.sort(this.data, i, i + this.rows);
        }
        return this;
    }

    public DoubleMatrix sortColumns() {
        return this.dup().sortColumnsi();
    }

    public int[][] columnSortingPermutations() {
        int[][] result = new int[this.columns][];
        DoubleMatrix temp = new DoubleMatrix(this.rows);
        for (int c = 0; c < this.columns; ++c) {
            result[c] = this.getColumn(c, temp).sortingPermutation();
        }
        return result;
    }

    public DoubleMatrix sortRowsi() {
        DoubleMatrix temp = new DoubleMatrix(this.columns);
        for (int r = 0; r < this.rows; ++r) {
            this.putRow(r, this.getRow(r, temp).sorti());
        }
        return this;
    }

    public DoubleMatrix sortRows() {
        return this.dup().sortRowsi();
    }

    public int[][] rowSortingPermutations() {
        int[][] result = new int[this.rows][];
        DoubleMatrix temp = new DoubleMatrix(this.columns);
        for (int r = 0; r < this.rows; ++r) {
            result[r] = this.getRow(r, temp).sortingPermutation();
        }
        return result;
    }

    public DoubleMatrix columnSums() {
        if (this.rows == 1) {
            return this.dup();
        }
        DoubleMatrix v = new DoubleMatrix(1, this.columns);
        for (int c = 0; c < this.columns; ++c) {
            for (int r = 0; r < this.rows; ++r) {
                v.put(c, v.get(c) + this.get(r, c));
            }
        }
        return v;
    }

    public DoubleMatrix columnMeans() {
        return this.columnSums().divi(this.rows);
    }

    public DoubleMatrix rowSums() {
        if (this.columns == 1) {
            return this.dup();
        }
        DoubleMatrix v = new DoubleMatrix(this.rows);
        for (int c = 0; c < this.columns; ++c) {
            for (int r = 0; r < this.rows; ++r) {
                v.put(r, v.get(r) + this.get(r, c));
            }
        }
        return v;
    }

    public DoubleMatrix rowMeans() {
        return this.rowSums().divi(this.columns);
    }

    public DoubleMatrix getColumn(int c) {
        return this.getColumn(c, new DoubleMatrix(this.rows, 1));
    }

    public DoubleMatrix getColumn(int c, DoubleMatrix result) {
        result.checkLength(this.rows);
        JavaBlas.rcopy(this.rows, this.data, this.index(0, c), 1, result.data, 0, 1);
        return result;
    }

    public void putColumn(int c, DoubleMatrix v) {
        JavaBlas.rcopy(this.rows, v.data, 0, 1, this.data, this.index(0, c), 1);
    }

    public DoubleMatrix getRow(int r) {
        return this.getRow(r, new DoubleMatrix(1, this.columns));
    }

    public DoubleMatrix getRow(int r, DoubleMatrix result) {
        result.checkLength(this.columns);
        JavaBlas.rcopy(this.columns, this.data, this.index(r, 0), this.rows, result.data, 0, 1);
        return result;
    }

    public void putRow(int r, DoubleMatrix v) {
        JavaBlas.rcopy(this.columns, v.data, 0, 1, this.data, this.index(r, 0), this.rows);
    }

    public DoubleMatrix columnMins() {
        DoubleMatrix mins = new DoubleMatrix(1, this.columns);
        for (int c = 0; c < this.columns; ++c) {
            mins.put(c, this.getColumn(c).min());
        }
        return mins;
    }

    public int[] columnArgmins() {
        int[] argmins = new int[this.columns];
        for (int c = 0; c < this.columns; ++c) {
            argmins[c] = this.getColumn(c).argmin();
        }
        return argmins;
    }

    public DoubleMatrix columnMaxs() {
        DoubleMatrix maxs = new DoubleMatrix(1, this.columns);
        for (int c = 0; c < this.columns; ++c) {
            maxs.put(c, this.getColumn(c).max());
        }
        return maxs;
    }

    public int[] columnArgmaxs() {
        int[] argmaxs = new int[this.columns];
        for (int c = 0; c < this.columns; ++c) {
            argmaxs[c] = this.getColumn(c).argmax();
        }
        return argmaxs;
    }

    public DoubleMatrix rowMins() {
        DoubleMatrix mins = new DoubleMatrix(this.rows);
        for (int c = 0; c < this.rows; ++c) {
            mins.put(c, this.getRow(c).min());
        }
        return mins;
    }

    public int[] rowArgmins() {
        int[] argmins = new int[this.rows];
        for (int c = 0; c < this.rows; ++c) {
            argmins[c] = this.getRow(c).argmin();
        }
        return argmins;
    }

    public DoubleMatrix rowMaxs() {
        DoubleMatrix maxs = new DoubleMatrix(this.rows);
        for (int c = 0; c < this.rows; ++c) {
            maxs.put(c, this.getRow(c).max());
        }
        return maxs;
    }

    public int[] rowArgmaxs() {
        int[] argmaxs = new int[this.rows];
        for (int c = 0; c < this.rows; ++c) {
            argmaxs[c] = this.getRow(c).argmax();
        }
        return argmaxs;
    }

    public DoubleMatrix addiRowVector(DoubleMatrix x) {
        x.checkLength(this.columns);
        for (int c = 0; c < this.columns; ++c) {
            for (int r = 0; r < this.rows; ++r) {
                this.put(r, c, this.get(r, c) + x.get(c));
            }
        }
        return this;
    }

    public DoubleMatrix addRowVector(DoubleMatrix x) {
        return this.dup().addiRowVector(x);
    }

    public DoubleMatrix addiColumnVector(DoubleMatrix x) {
        x.checkLength(this.rows);
        for (int c = 0; c < this.columns; ++c) {
            for (int r = 0; r < this.rows; ++r) {
                this.put(r, c, this.get(r, c) + x.get(r));
            }
        }
        return this;
    }

    public DoubleMatrix addColumnVector(DoubleMatrix x) {
        return this.dup().addiColumnVector(x);
    }

    public DoubleMatrix subiRowVector(DoubleMatrix x) {
        x.checkLength(this.columns);
        for (int c = 0; c < this.columns; ++c) {
            for (int r = 0; r < this.rows; ++r) {
                this.put(r, c, this.get(r, c) - x.get(c));
            }
        }
        return this;
    }

    public DoubleMatrix subRowVector(DoubleMatrix x) {
        return this.dup().subiRowVector(x);
    }

    public DoubleMatrix subiColumnVector(DoubleMatrix x) {
        x.checkLength(this.rows);
        for (int c = 0; c < this.columns; ++c) {
            for (int r = 0; r < this.rows; ++r) {
                this.put(r, c, this.get(r, c) - x.get(r));
            }
        }
        return this;
    }

    public DoubleMatrix subColumnVector(DoubleMatrix x) {
        return this.dup().subiColumnVector(x);
    }

    public DoubleMatrix mulRow(int r, double scale) {
        NativeBlas.dscal(this.columns, scale, this.data, this.index(r, 0), this.rows);
        return this;
    }

    public DoubleMatrix mulColumn(int c, double scale) {
        NativeBlas.dscal(this.rows, scale, this.data, this.index(0, c), 1);
        return this;
    }

    public DoubleMatrix muliColumnVector(DoubleMatrix x) {
        x.checkLength(this.rows);
        for (int c = 0; c < this.columns; ++c) {
            for (int r = 0; r < this.rows; ++r) {
                this.put(r, c, this.get(r, c) * x.get(r));
            }
        }
        return this;
    }

    public DoubleMatrix mulColumnVector(DoubleMatrix x) {
        return this.dup().muliColumnVector(x);
    }

    public DoubleMatrix muliRowVector(DoubleMatrix x) {
        x.checkLength(this.columns);
        for (int c = 0; c < this.columns; ++c) {
            for (int r = 0; r < this.rows; ++r) {
                this.put(r, c, this.get(r, c) * x.get(c));
            }
        }
        return this;
    }

    public DoubleMatrix mulRowVector(DoubleMatrix x) {
        return this.dup().muliRowVector(x);
    }

    public DoubleMatrix diviRowVector(DoubleMatrix x) {
        x.checkLength(this.columns);
        for (int c = 0; c < this.columns; ++c) {
            for (int r = 0; r < this.rows; ++r) {
                this.put(r, c, this.get(r, c) / x.get(c));
            }
        }
        return this;
    }

    public DoubleMatrix divRowVector(DoubleMatrix x) {
        return this.dup().diviRowVector(x);
    }

    public DoubleMatrix diviColumnVector(DoubleMatrix x) {
        x.checkLength(this.rows);
        for (int c = 0; c < this.columns; ++c) {
            for (int r = 0; r < this.rows; ++r) {
                this.put(r, c, this.get(r, c) / x.get(r));
            }
        }
        return this;
    }

    public DoubleMatrix divColumnVector(DoubleMatrix x) {
        return this.dup().diviColumnVector(x);
    }

    public void out(DataOutputStream dos) throws IOException {
        dos.writeUTF("double");
        dos.writeInt(this.columns);
        dos.writeInt(this.rows);
        dos.writeInt(this.data.length);
        for (int i = 0; i < this.data.length; ++i) {
            dos.writeDouble(this.data[i]);
        }
    }

    public void in(DataInputStream dis) throws IOException {
        if (!dis.readUTF().equals("double")) {
            throw new IllegalStateException("The matrix in the specified file is not of the correct type!");
        }
        this.columns = dis.readInt();
        this.rows = dis.readInt();
        int MAX = dis.readInt();
        this.data = new double[MAX];
        for (int i = 0; i < MAX; ++i) {
            this.data[i] = dis.readDouble();
        }
    }

    public void save(String filename) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FileOutputStream(filename, false));
        this.out(dos);
    }

    public void load(String filename) throws IOException {
        DataInputStream dis = new DataInputStream(new FileInputStream(filename));
        this.in(dis);
    }

    public static DoubleMatrix loadAsciiFile(String filename) throws IOException {
        String line;
        BufferedReader is = new BufferedReader(new InputStreamReader(new FileInputStream(filename)));
        int rows = 0;
        int columns = -1;
        while ((line = is.readLine()) != null) {
            String[] elements = line.split("\\s+");
            int numElements = elements.length;
            if (elements[0].length() == 0) {
                --numElements;
            }
            if (elements[elements.length - 1].length() == 0) {
                --numElements;
            }
            if (columns == -1) {
                columns = numElements;
            } else if (columns != numElements) {
                throw new IOException("Number of elements changes in line " + line + ".");
            }
            ++rows;
        }
        is.close();
        is = new BufferedReader(new InputStreamReader(new FileInputStream(filename)));
        DoubleMatrix result = new DoubleMatrix(rows, columns);
        int r = 0;
        while ((line = is.readLine()) != null) {
            String[] elements = line.split("\\s+");
            int firstElement = elements[0].length() == 0 ? 1 : 0;
            int c = 0;
            int cc = firstElement;
            while (c < columns) {
                result.put(r, c, (double)Double.valueOf(elements[cc]));
                ++c;
                ++cc;
            }
            ++r;
        }
        return result;
    }

    public static DoubleMatrix loadCSVFile(String filename) throws IOException {
        String line;
        BufferedReader is = new BufferedReader(new InputStreamReader(new FileInputStream(filename)));
        LinkedList<DoubleMatrix> rows = new LinkedList<DoubleMatrix>();
        int columns = -1;
        while ((line = is.readLine()) != null) {
            String[] elements = line.split(",");
            int numElements = elements.length;
            if (elements[0].length() == 0) {
                --numElements;
            }
            if (elements[elements.length - 1].length() == 0) {
                --numElements;
            }
            if (columns == -1) {
                columns = numElements;
            } else if (columns != numElements) {
                throw new IOException("Number of elements changes in line " + line + ".");
            }
            DoubleMatrix row = new DoubleMatrix(columns);
            for (int c = 0; c < columns; ++c) {
                row.put(c, (double)Double.valueOf(elements[c]));
            }
            rows.add(row);
        }
        is.close();
        System.out.println("Done reading file");
        DoubleMatrix result = new DoubleMatrix(rows.size(), columns);
        int r = 0;
        Iterator ri = rows.iterator();
        while (ri.hasNext()) {
            result.putRow(r, (DoubleMatrix)ri.next());
            ++r;
        }
        return result;
    }

    public DoubleMatrix addi(DoubleMatrix other) {
        return this.addi(other, this);
    }

    public DoubleMatrix add(DoubleMatrix other) {
        return this.addi(other, new DoubleMatrix(this.rows, this.columns));
    }

    public DoubleMatrix addi(double v) {
        return this.addi(v, this);
    }

    public DoubleMatrix add(double v) {
        return this.addi(v, new DoubleMatrix(this.rows, this.columns));
    }

    public DoubleMatrix subi(DoubleMatrix other) {
        return this.subi(other, this);
    }

    public DoubleMatrix sub(DoubleMatrix other) {
        return this.subi(other, new DoubleMatrix(this.rows, this.columns));
    }

    public DoubleMatrix subi(double v) {
        return this.subi(v, this);
    }

    public DoubleMatrix sub(double v) {
        return this.subi(v, new DoubleMatrix(this.rows, this.columns));
    }

    public DoubleMatrix rsubi(DoubleMatrix other) {
        return this.rsubi(other, this);
    }

    public DoubleMatrix rsub(DoubleMatrix other) {
        return this.rsubi(other, new DoubleMatrix(this.rows, this.columns));
    }

    public DoubleMatrix rsubi(double v) {
        return this.rsubi(v, this);
    }

    public DoubleMatrix rsub(double v) {
        return this.rsubi(v, new DoubleMatrix(this.rows, this.columns));
    }

    public DoubleMatrix divi(DoubleMatrix other) {
        return this.divi(other, this);
    }

    public DoubleMatrix div(DoubleMatrix other) {
        return this.divi(other, new DoubleMatrix(this.rows, this.columns));
    }

    public DoubleMatrix divi(double v) {
        return this.divi(v, this);
    }

    public DoubleMatrix div(double v) {
        return this.divi(v, new DoubleMatrix(this.rows, this.columns));
    }

    public DoubleMatrix rdivi(DoubleMatrix other) {
        return this.rdivi(other, this);
    }

    public DoubleMatrix rdiv(DoubleMatrix other) {
        return this.rdivi(other, new DoubleMatrix(this.rows, this.columns));
    }

    public DoubleMatrix rdivi(double v) {
        return this.rdivi(v, this);
    }

    public DoubleMatrix rdiv(double v) {
        return this.rdivi(v, new DoubleMatrix(this.rows, this.columns));
    }

    public DoubleMatrix muli(DoubleMatrix other) {
        return this.muli(other, this);
    }

    public DoubleMatrix mul(DoubleMatrix other) {
        return this.muli(other, new DoubleMatrix(this.rows, this.columns));
    }

    public DoubleMatrix muli(double v) {
        return this.muli(v, this);
    }

    public DoubleMatrix mul(double v) {
        return this.muli(v, new DoubleMatrix(this.rows, this.columns));
    }

    public DoubleMatrix mmuli(DoubleMatrix other) {
        return this.mmuli(other, this);
    }

    public DoubleMatrix mmul(DoubleMatrix other) {
        return this.mmuli(other, new DoubleMatrix(this.rows, other.columns));
    }

    public DoubleMatrix mmuli(double v) {
        return this.mmuli(v, this);
    }

    public DoubleMatrix mmul(double v) {
        return this.mmuli(v, new DoubleMatrix(this.rows, this.columns));
    }

    public DoubleMatrix lti(DoubleMatrix other, DoubleMatrix result) {
        if (other.isScalar()) {
            return this.lti(other.scalar(), result);
        }
        this.assertSameLength(other);
        this.ensureResultLength(other, result);
        for (int i = 0; i < this.length; ++i) {
            result.put(i, this.get(i) < other.get(i) ? 1.0 : 0.0);
        }
        return result;
    }

    public DoubleMatrix lti(DoubleMatrix other) {
        return this.lti(other, this);
    }

    public DoubleMatrix lt(DoubleMatrix other) {
        return this.lti(other, new DoubleMatrix(this.rows, this.columns));
    }

    public DoubleMatrix lti(double value, DoubleMatrix result) {
        this.ensureResultLength(null, result);
        for (int i = 0; i < this.length; ++i) {
            result.put(i, this.get(i) < value ? 1.0 : 0.0);
        }
        return result;
    }

    public DoubleMatrix lti(double value) {
        return this.lti(value, this);
    }

    public DoubleMatrix lt(double value) {
        return this.lti(value, new DoubleMatrix(this.rows, this.columns));
    }

    public DoubleMatrix gti(DoubleMatrix other, DoubleMatrix result) {
        if (other.isScalar()) {
            return this.gti(other.scalar(), result);
        }
        this.assertSameLength(other);
        this.ensureResultLength(other, result);
        for (int i = 0; i < this.length; ++i) {
            result.put(i, this.get(i) > other.get(i) ? 1.0 : 0.0);
        }
        return result;
    }

    public DoubleMatrix gti(DoubleMatrix other) {
        return this.gti(other, this);
    }

    public DoubleMatrix gt(DoubleMatrix other) {
        return this.gti(other, new DoubleMatrix(this.rows, this.columns));
    }

    public DoubleMatrix gti(double value, DoubleMatrix result) {
        this.ensureResultLength(null, result);
        for (int i = 0; i < this.length; ++i) {
            result.put(i, this.get(i) > value ? 1.0 : 0.0);
        }
        return result;
    }

    public DoubleMatrix gti(double value) {
        return this.gti(value, this);
    }

    public DoubleMatrix gt(double value) {
        return this.gti(value, new DoubleMatrix(this.rows, this.columns));
    }

    public DoubleMatrix lei(DoubleMatrix other, DoubleMatrix result) {
        if (other.isScalar()) {
            return this.lei(other.scalar(), result);
        }
        this.assertSameLength(other);
        this.ensureResultLength(other, result);
        for (int i = 0; i < this.length; ++i) {
            result.put(i, this.get(i) <= other.get(i) ? 1.0 : 0.0);
        }
        return result;
    }

    public DoubleMatrix lei(DoubleMatrix other) {
        return this.lei(other, this);
    }

    public DoubleMatrix le(DoubleMatrix other) {
        return this.lei(other, new DoubleMatrix(this.rows, this.columns));
    }

    public DoubleMatrix lei(double value, DoubleMatrix result) {
        this.ensureResultLength(null, result);
        for (int i = 0; i < this.length; ++i) {
            result.put(i, this.get(i) <= value ? 1.0 : 0.0);
        }
        return result;
    }

    public DoubleMatrix lei(double value) {
        return this.lei(value, this);
    }

    public DoubleMatrix le(double value) {
        return this.lei(value, new DoubleMatrix(this.rows, this.columns));
    }

    public DoubleMatrix gei(DoubleMatrix other, DoubleMatrix result) {
        if (other.isScalar()) {
            return this.gei(other.scalar(), result);
        }
        this.assertSameLength(other);
        this.ensureResultLength(other, result);
        for (int i = 0; i < this.length; ++i) {
            result.put(i, this.get(i) >= other.get(i) ? 1.0 : 0.0);
        }
        return result;
    }

    public DoubleMatrix gei(DoubleMatrix other) {
        return this.gei(other, this);
    }

    public DoubleMatrix ge(DoubleMatrix other) {
        return this.gei(other, new DoubleMatrix(this.rows, this.columns));
    }

    public DoubleMatrix gei(double value, DoubleMatrix result) {
        this.ensureResultLength(null, result);
        for (int i = 0; i < this.length; ++i) {
            result.put(i, this.get(i) >= value ? 1.0 : 0.0);
        }
        return result;
    }

    public DoubleMatrix gei(double value) {
        return this.gei(value, this);
    }

    public DoubleMatrix ge(double value) {
        return this.gei(value, new DoubleMatrix(this.rows, this.columns));
    }

    public DoubleMatrix eqi(DoubleMatrix other, DoubleMatrix result) {
        if (other.isScalar()) {
            return this.eqi(other.scalar(), result);
        }
        this.assertSameLength(other);
        this.ensureResultLength(other, result);
        for (int i = 0; i < this.length; ++i) {
            result.put(i, this.get(i) == other.get(i) ? 1.0 : 0.0);
        }
        return result;
    }

    public DoubleMatrix eqi(DoubleMatrix other) {
        return this.eqi(other, this);
    }

    public DoubleMatrix eq(DoubleMatrix other) {
        return this.eqi(other, new DoubleMatrix(this.rows, this.columns));
    }

    public DoubleMatrix eqi(double value, DoubleMatrix result) {
        this.ensureResultLength(null, result);
        for (int i = 0; i < this.length; ++i) {
            result.put(i, this.get(i) == value ? 1.0 : 0.0);
        }
        return result;
    }

    public DoubleMatrix eqi(double value) {
        return this.eqi(value, this);
    }

    public DoubleMatrix eq(double value) {
        return this.eqi(value, new DoubleMatrix(this.rows, this.columns));
    }

    public DoubleMatrix nei(DoubleMatrix other, DoubleMatrix result) {
        if (other.isScalar()) {
            return this.nei(other.scalar(), result);
        }
        this.assertSameLength(other);
        this.ensureResultLength(other, result);
        for (int i = 0; i < this.length; ++i) {
            result.put(i, this.get(i) != other.get(i) ? 1.0 : 0.0);
        }
        return result;
    }

    public DoubleMatrix nei(DoubleMatrix other) {
        return this.nei(other, this);
    }

    public DoubleMatrix ne(DoubleMatrix other) {
        return this.nei(other, new DoubleMatrix(this.rows, this.columns));
    }

    public DoubleMatrix nei(double value, DoubleMatrix result) {
        this.ensureResultLength(null, result);
        for (int i = 0; i < this.length; ++i) {
            result.put(i, this.get(i) != value ? 1.0 : 0.0);
        }
        return result;
    }

    public DoubleMatrix nei(double value) {
        return this.nei(value, this);
    }

    public DoubleMatrix ne(double value) {
        return this.nei(value, new DoubleMatrix(this.rows, this.columns));
    }

    public DoubleMatrix andi(DoubleMatrix other, DoubleMatrix result) {
        this.assertSameLength(other);
        this.ensureResultLength(other, result);
        for (int i = 0; i < this.length; ++i) {
            result.put(i, this.get(i) != 0.0 & other.get(i) != 0.0 ? 1.0 : 0.0);
        }
        return result;
    }

    public DoubleMatrix andi(DoubleMatrix other) {
        return this.andi(other, this);
    }

    public DoubleMatrix and(DoubleMatrix other) {
        return this.andi(other, new DoubleMatrix(this.rows, this.columns));
    }

    public DoubleMatrix andi(double value, DoubleMatrix result) {
        this.ensureResultLength(null, result);
        boolean val = value != 0.0;
        for (int i = 0; i < this.length; ++i) {
            result.put(i, this.get(i) != 0.0 & val ? 1.0 : 0.0);
        }
        return result;
    }

    public DoubleMatrix andi(double value) {
        return this.andi(value, this);
    }

    public DoubleMatrix and(double value) {
        return this.andi(value, new DoubleMatrix(this.rows, this.columns));
    }

    public DoubleMatrix ori(DoubleMatrix other, DoubleMatrix result) {
        this.assertSameLength(other);
        this.ensureResultLength(other, result);
        for (int i = 0; i < this.length; ++i) {
            result.put(i, this.get(i) != 0.0 | other.get(i) != 0.0 ? 1.0 : 0.0);
        }
        return result;
    }

    public DoubleMatrix ori(DoubleMatrix other) {
        return this.ori(other, this);
    }

    public DoubleMatrix or(DoubleMatrix other) {
        return this.ori(other, new DoubleMatrix(this.rows, this.columns));
    }

    public DoubleMatrix ori(double value, DoubleMatrix result) {
        this.ensureResultLength(null, result);
        boolean val = value != 0.0;
        for (int i = 0; i < this.length; ++i) {
            result.put(i, this.get(i) != 0.0 | val ? 1.0 : 0.0);
        }
        return result;
    }

    public DoubleMatrix ori(double value) {
        return this.ori(value, this);
    }

    public DoubleMatrix or(double value) {
        return this.ori(value, new DoubleMatrix(this.rows, this.columns));
    }

    public DoubleMatrix xori(DoubleMatrix other, DoubleMatrix result) {
        this.assertSameLength(other);
        this.ensureResultLength(other, result);
        for (int i = 0; i < this.length; ++i) {
            result.put(i, this.get(i) != 0.0 ^ other.get(i) != 0.0 ? 1.0 : 0.0);
        }
        return result;
    }

    public DoubleMatrix xori(DoubleMatrix other) {
        return this.xori(other, this);
    }

    public DoubleMatrix xor(DoubleMatrix other) {
        return this.xori(other, new DoubleMatrix(this.rows, this.columns));
    }

    public DoubleMatrix xori(double value, DoubleMatrix result) {
        this.ensureResultLength(null, result);
        boolean val = value != 0.0;
        for (int i = 0; i < this.length; ++i) {
            result.put(i, this.get(i) != 0.0 ^ val ? 1.0 : 0.0);
        }
        return result;
    }

    public DoubleMatrix xori(double value) {
        return this.xori(value, this);
    }

    public DoubleMatrix xor(double value) {
        return this.xori(value, new DoubleMatrix(this.rows, this.columns));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ColumnsAsListView
    extends AbstractList<DoubleMatrix>
    implements ConvertsToDoubleMatrix {
        private DoubleMatrix me;

        public ColumnsAsListView(DoubleMatrix me) {
            this.me = me;
        }

        @Override
        public DoubleMatrix get(int index) {
            return DoubleMatrix.this.getColumn(index);
        }

        @Override
        public int size() {
            return DoubleMatrix.this.columns;
        }

        @Override
        public DoubleMatrix convertToDoubleMatrix() {
            return this.me;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class RowsAsListView
    extends AbstractList<DoubleMatrix>
    implements ConvertsToDoubleMatrix {
        private DoubleMatrix me;

        public RowsAsListView(DoubleMatrix me) {
            this.me = me;
        }

        @Override
        public DoubleMatrix get(int index) {
            return DoubleMatrix.this.getRow(index);
        }

        @Override
        public int size() {
            return DoubleMatrix.this.rows;
        }

        @Override
        public DoubleMatrix convertToDoubleMatrix() {
            return this.me;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ElementsAsListView
    extends AbstractList<Double>
    implements ConvertsToDoubleMatrix {
        private DoubleMatrix me;

        public ElementsAsListView(DoubleMatrix me) {
            this.me = me;
        }

        @Override
        public Double get(int index) {
            return this.me.get(index);
        }

        @Override
        public int size() {
            return this.me.length;
        }

        @Override
        public DoubleMatrix convertToDoubleMatrix() {
            return this.me;
        }
    }
}

