(ns fogus.tupling
  (:require [clojure.core.protocols :as clojure])
  (:import  [clojure.lang Util IMapEntry MapEntry]
            [java.util List Map$Entry Iterator Collection]))

(defn ^:private -lookup-field [t alias nope-fun]
  (if (keyword? alias)
    (case alias
      :id     (.id t)
      :attr   (.attr t)
      :val    (.val t)
      :domain (.domain t)
      :t      (.t t)
      (nope-fun))
    (case alias
      0  (.id t)
      1  (.attr t)
      2  (.val t)
      3  (.domain t)
      4  (.t t)
      (nope-fun))))

(deftype T [domain id attr val t metadata]
  clojure.lang.IObj
  (meta [_] metadata)
  (withMeta [_ m] (T. domain id attr val t m))
  
  clojure.lang.ILookup
  (valAt [this field] (-lookup-field this field (constantly nil)))
  (valAt [this field nope] (-lookup-field this field (constantly nope)))

  clojure.lang.IEditableCollection
  (asTransient [_]
   (-> []
    transient
    (conj! domain)
    (conj! id)
    (conj! attr)
    (conj! val)
    (conj! t)))

  clojure.lang.Associative
  (containsKey [this key]
    (cond
     (number? key)  (<= 0 key 4)
     (keyword? key) (boolean (-lookup-field this key (constantly nil)))
     :else          false))

  (entryAt [this key]
    (when (.containsKey this key)
      (clojure.lang.MapEntry. key (-lookup-field this key (constantly nil)))))

  (assoc [this key |v|]
    (cond
     (or (= 0 key) (= :domain key)) (T. |v| id attr val t metadata)
     (or (= 1 key) (= :id key))     (T. domain |v| attr val t metadata)
     (or (= 2 key) (= :attr key))   (T. domain id |v| val t metadata)
     (or (= 3 key) (= :val key))    (T. domain id attr |v| t metadata)
     (or (= 4 key) (= :t key))      (T. domain id attr val |v| metadata)
     :else
     (throw (IndexOutOfBoundsException. (str key)))))

  clojure.lang.IPersistentVector
  (length [_] 5)
  
  (assocN [this k |v|]
    (case k 
      0 (T. |v| id attr val t metadata)
      1 (T. domain |v| attr val t metadata)
      2 (T. domain id |v| val t metadata)
      3 (T. domain id attr |v| t metadata)
      4 (T. domain id attr val |v| metadata)
      (throw
       (IndexOutOfBoundsException.))))
  
  clojure.lang.Counted
  (count [_] 5)

  java.util.Collection
  (isEmpty [_] false)
  (iterator [_] (.iterator [domain id attr val t]))
  (toArray [_] (to-array [domain id attr val t]))
  (size [_] 5)
  (equals [this other] (= this other))

  clojure.lang.ISeq
  (first [_] domain)
  (next [_] (list id attr val t))
  (more [this] (next this))
  (cons [e _] [e id attr val t])
  
  clojure.lang.IPersistentCollection
  (equiv [this other]
   (if (instance? T other)
     (and (Util/equiv domain (.domain other))
          (Util/equiv id     (.id other))
          (Util/equiv attr   (.attr other))
          (Util/equiv val    (.val other))
          (Util/equiv t      (.t other)))
     false))
  
  clojure.lang.Indexed
  (nth [this index not-found] (-lookup-field this index (constantly not-found)))
  (nth [this index] (-lookup-field this index (constantly nil)))

  clojure.lang.Sequential
  clojure.lang.Seqable
  (seq [this] this)
  
  java.util.List
  (empty [_] (T. nil nil nil nil nil nil))
  (get [this index] (-lookup-field this index #(throw (IndexOutOfBoundsException. (str "T[" index "]")))))
  
  clojure.lang.Reversible
  (rseq [_] (T. t val attr id domain metadata))

  
)


(comment
  ;; [domain id attr val t metadata]

  
)

:done