(ns trout.util
  (:require [clojure.java.io :as io]
            [clojure.string :as string])
  (:import [java.util.regex Pattern]))

;; TODO: Move most of these into Thneed or replace with new contrib

(defn slurp-resource
  "Stolen from marginalia from leiningen"
  [resource-name]
  (try
    (-> (.getContextClassLoader (Thread/currentThread))
        (.getResourceAsStream resource-name)
        (java.io.InputStreamReader.)
        (slurp))
    (catch java.lang.NullPointerException npe
      (println (str "Could not locate resources at " resource-name))
      (println "    ... attempting to fix.")
      (let [resource-name (str "vendor/" resource-name)]
        (try
          (-> (.getContextClassLoader (Thread/currentThread))
              (.getResourceAsStream resource-name)
              (java.io.InputStreamReader.)
              (slurp))
          (catch java.lang.NullPointerException npe
            (println (str "    STILL could not locate resources at " resource-name ". Giving up!"))))))))

(defn path 
  [& elems]
  (string/join (System/getProperty "file.separator") elems))

(defn indexed
  "Returns a lazy sequence of [index, item] pairs, where items come
  from 's' and indexes count up from zero.

  (indexed '(a b c d))  =>  ([0 a] [1 b] [2 c] [3 d])"
  [s]
  (map vector (iterate inc 0) s))

(defn str-part
  "Splits the string into a lazy sequence of substrings, alternating
  between substrings that match the patthern and the substrings
  between the matches.  The sequence always starts with the substring
  before the first match, or an empty string if the beginning of the
  string matches.

  For example: (str-part #\"[a-z]+\" \"abc123def\")
  returns: (\"\" \"abc\" \"123\" \"def\")"
  [^Pattern re ^String s]
  (let [m (re-matcher re s)]
    ((fn step [prevend]
       (lazy-seq
        (if (.find m)
          (cons (.subSequence s prevend (.start m))
                (cons (re-groups m)
                      (step (+ (.start m) (count (.group m))))))
          (when (< prevend (.length s))
            (list (.subSequence s prevend (.length s)))))))
     0)))

(defn split
  "Splits string on a regular expression.  Optional argument limit is
  the maximum number of splits."
  ([^Pattern re ^String s] (seq (.split re s)))
  ([^Pattern re limit ^String s] (seq (.split re s limit))))

(defn replace-re
  "Replaces all matches of re with replacement in s."
  [re replacement ^String s]
  (.replaceAll (re-matcher re s) replacement))

(defn replace-by
  "Replaces all matches of re in s with the result of
  (f (re-groups the-match))."
  [re f ^String s]
  (let [m (re-matcher re s)]
    (let [buffer (StringBuffer. (.length s))]
      (loop []
        (if (.find m)
          (do (.appendReplacement m buffer (f (re-groups m)))
              (recur))
          (do (.appendTail m buffer)
              (.toString buffer)))))))
